/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.animation.Animator;
import android.animation.ObjectAnimator;
import android.content.Context;
import android.content.res.TypedArray;
import android.database.DataSetObserver;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.os.Handler;
import android.os.SystemClock;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.IntProperty;
import android.util.Log;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.animation.AccelerateDecelerateInterpolator;
import android.widget.AbsListView;
import android.widget.Adapter;
import android.widget.AdapterView;
import android.widget.LinearLayout;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.PopupWindow;
import android.widget.TextView;
import com.android.internal.R;
import com.android.internal.widget.AutoScrollHelper;
import java.util.Locale;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class ListPopupWindow
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "ListPopupWindow";
    private static boolean DEBUG = false;
    private static int EXPAND_LIST_TIMEOUT = 250;
    private Context mContext;
    private PopupWindow mPopup;
    private ListAdapter mAdapter;
    private DropDownListView mDropDownList;
    private int mDropDownHeight;
    private int mDropDownWidth;
    private int mDropDownHorizontalOffset;
    private int mDropDownVerticalOffset;
    private boolean mDropDownVerticalOffsetSet;
    private int mDropDownGravity;
    private boolean mDropDownAlwaysVisible;
    private boolean mForceIgnoreOutsideTouch;
    int mListItemExpandMaximum;
    private View mPromptView;
    private int mPromptPosition;
    private DataSetObserver mObserver;
    private View mDropDownAnchorView;
    private Drawable mDropDownListHighlight;
    private AdapterView.OnItemClickListener mItemClickListener;
    private AdapterView.OnItemSelectedListener mItemSelectedListener;
    private ResizePopupRunnable mResizePopupRunnable;
    private PopupTouchInterceptor mTouchInterceptor;
    private PopupScrollListener mScrollListener;
    private ListSelectorHider mHideSelector;
    private Runnable mShowDropDownRunnable;
    private Handler mHandler;
    private Rect mTempRect;
    private boolean mModal;
    private int mLayoutDirection;
    public static int POSITION_PROMPT_ABOVE = 0;
    public static int POSITION_PROMPT_BELOW = 1;
    public static int MATCH_PARENT = -1;
    public static int WRAP_CONTENT = -2;
    public static int INPUT_METHOD_FROM_FOCUSABLE = 0;
    public static int INPUT_METHOD_NEEDED = 1;
    public static int INPUT_METHOD_NOT_NEEDED = 2;

    private void $$robo$$android_widget_ListPopupWindow$__constructor__(Context context) {
    }

    private void $$robo$$android_widget_ListPopupWindow$__constructor__(Context context, AttributeSet attrs) {
    }

    private void $$robo$$android_widget_ListPopupWindow$__constructor__(Context context, AttributeSet attrs, int defStyleAttr) {
    }

    private void $$robo$$android_widget_ListPopupWindow$__constructor__(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        this.mDropDownHeight = -2;
        this.mDropDownWidth = -2;
        this.mDropDownGravity = 0;
        this.mDropDownAlwaysVisible = false;
        this.mForceIgnoreOutsideTouch = false;
        this.mListItemExpandMaximum = Integer.MAX_VALUE;
        this.mPromptPosition = 0;
        this.mResizePopupRunnable = new ResizePopupRunnable(this);
        this.mTouchInterceptor = new PopupTouchInterceptor(this);
        this.mScrollListener = new PopupScrollListener(this);
        this.mHideSelector = new ListSelectorHider(this);
        this.mHandler = new Handler();
        this.mTempRect = new Rect();
        this.mContext = context;
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.ListPopupWindow, defStyleAttr, defStyleRes);
        this.mDropDownHorizontalOffset = a.getDimensionPixelOffset(0, 0);
        this.mDropDownVerticalOffset = a.getDimensionPixelOffset(1, 0);
        if (this.mDropDownVerticalOffset != 0) {
            this.mDropDownVerticalOffsetSet = true;
        }
        a.recycle();
        this.mPopup = new PopupWindow(context, attrs, defStyleAttr, defStyleRes);
        this.mPopup.setInputMethodMode(1);
        Locale locale = this.mContext.getResources().getConfiguration().locale;
        this.mLayoutDirection = TextUtils.getLayoutDirectionFromLocale(locale);
    }

    private final void $$robo$$android_widget_ListPopupWindow$setAdapter(ListAdapter adapter) {
        if (this.mObserver == null) {
            this.mObserver = new PopupDataSetObserver(this);
        } else if (this.mAdapter != null) {
            this.mAdapter.unregisterDataSetObserver(this.mObserver);
        }
        this.mAdapter = adapter;
        if (this.mAdapter != null) {
            adapter.registerDataSetObserver(this.mObserver);
        }
        if (this.mDropDownList != null) {
            this.mDropDownList.setAdapter(this.mAdapter);
        }
    }

    private final void $$robo$$android_widget_ListPopupWindow$setPromptPosition(int position) {
        this.mPromptPosition = position;
    }

    private final int $$robo$$android_widget_ListPopupWindow$getPromptPosition() {
        return this.mPromptPosition;
    }

    private final void $$robo$$android_widget_ListPopupWindow$setModal(boolean modal) {
        this.mModal = modal;
        this.mPopup.setFocusable(modal);
    }

    private final boolean $$robo$$android_widget_ListPopupWindow$isModal() {
        return this.mModal;
    }

    private final void $$robo$$android_widget_ListPopupWindow$setForceIgnoreOutsideTouch(boolean forceIgnoreOutsideTouch) {
        this.mForceIgnoreOutsideTouch = forceIgnoreOutsideTouch;
    }

    private final void $$robo$$android_widget_ListPopupWindow$setDropDownAlwaysVisible(boolean dropDownAlwaysVisible) {
        this.mDropDownAlwaysVisible = dropDownAlwaysVisible;
    }

    private final boolean $$robo$$android_widget_ListPopupWindow$isDropDownAlwaysVisible() {
        return this.mDropDownAlwaysVisible;
    }

    private final void $$robo$$android_widget_ListPopupWindow$setSoftInputMode(int mode) {
        this.mPopup.setSoftInputMode(mode);
    }

    private final int $$robo$$android_widget_ListPopupWindow$getSoftInputMode() {
        return this.mPopup.getSoftInputMode();
    }

    private final void $$robo$$android_widget_ListPopupWindow$setListSelector(Drawable selector) {
        this.mDropDownListHighlight = selector;
    }

    private final Drawable $$robo$$android_widget_ListPopupWindow$getBackground() {
        return this.mPopup.getBackground();
    }

    private final void $$robo$$android_widget_ListPopupWindow$setBackgroundDrawable(Drawable d) {
        this.mPopup.setBackgroundDrawable(d);
    }

    private final void $$robo$$android_widget_ListPopupWindow$setAnimationStyle(int animationStyle) {
        this.mPopup.setAnimationStyle(animationStyle);
    }

    private final int $$robo$$android_widget_ListPopupWindow$getAnimationStyle() {
        return this.mPopup.getAnimationStyle();
    }

    private final View $$robo$$android_widget_ListPopupWindow$getAnchorView() {
        return this.mDropDownAnchorView;
    }

    private final void $$robo$$android_widget_ListPopupWindow$setAnchorView(View anchor) {
        this.mDropDownAnchorView = anchor;
    }

    private final int $$robo$$android_widget_ListPopupWindow$getHorizontalOffset() {
        return this.mDropDownHorizontalOffset;
    }

    private final void $$robo$$android_widget_ListPopupWindow$setHorizontalOffset(int offset) {
        this.mDropDownHorizontalOffset = offset;
    }

    private final int $$robo$$android_widget_ListPopupWindow$getVerticalOffset() {
        if (!this.mDropDownVerticalOffsetSet) {
            return 0;
        }
        return this.mDropDownVerticalOffset;
    }

    private final void $$robo$$android_widget_ListPopupWindow$setVerticalOffset(int offset) {
        this.mDropDownVerticalOffset = offset;
        this.mDropDownVerticalOffsetSet = true;
    }

    private final void $$robo$$android_widget_ListPopupWindow$setDropDownGravity(int gravity) {
        this.mDropDownGravity = gravity;
    }

    private final int $$robo$$android_widget_ListPopupWindow$getWidth() {
        return this.mDropDownWidth;
    }

    private final void $$robo$$android_widget_ListPopupWindow$setWidth(int width) {
        this.mDropDownWidth = width;
    }

    private final void $$robo$$android_widget_ListPopupWindow$setContentWidth(int width) {
        Drawable popupBackground = this.mPopup.getBackground();
        if (popupBackground != null) {
            popupBackground.getPadding(this.mTempRect);
            this.mDropDownWidth = this.mTempRect.left + this.mTempRect.right + width;
        } else {
            this.setWidth(width);
        }
    }

    private final int $$robo$$android_widget_ListPopupWindow$getHeight() {
        return this.mDropDownHeight;
    }

    private final void $$robo$$android_widget_ListPopupWindow$setHeight(int height) {
        this.mDropDownHeight = height;
    }

    private final void $$robo$$android_widget_ListPopupWindow$setOnItemClickListener(AdapterView.OnItemClickListener clickListener) {
        this.mItemClickListener = clickListener;
    }

    private final void $$robo$$android_widget_ListPopupWindow$setOnItemSelectedListener(AdapterView.OnItemSelectedListener selectedListener) {
        this.mItemSelectedListener = selectedListener;
    }

    private final void $$robo$$android_widget_ListPopupWindow$setPromptView(View prompt) {
        boolean showing = this.isShowing();
        if (showing) {
            this.removePromptView();
        }
        this.mPromptView = prompt;
        if (showing) {
            this.show();
        }
    }

    private final void $$robo$$android_widget_ListPopupWindow$postShow() {
        this.mHandler.post(this.mShowDropDownRunnable);
    }

    private final void $$robo$$android_widget_ListPopupWindow$show() {
        int height = this.buildDropDown();
        int widthSpec = 0;
        int heightSpec = 0;
        boolean noInputMethod = this.isInputMethodNotNeeded();
        this.mPopup.setAllowScrollingAnchorParent(!noInputMethod);
        if (this.mPopup.isShowing()) {
            widthSpec = this.mDropDownWidth == -1 ? -1 : (this.mDropDownWidth == -2 ? this.getAnchorView().getWidth() : this.mDropDownWidth);
            if (this.mDropDownHeight == -1) {
                int n = heightSpec = noInputMethod ? height : -1;
                if (noInputMethod) {
                    this.mPopup.setWindowLayoutMode(this.mDropDownWidth == -1 ? -1 : 0, 0);
                } else {
                    this.mPopup.setWindowLayoutMode(this.mDropDownWidth == -1 ? -1 : 0, -1);
                }
            } else {
                heightSpec = this.mDropDownHeight == -2 ? height : this.mDropDownHeight;
            }
            this.mPopup.setOutsideTouchable(!this.mForceIgnoreOutsideTouch && !this.mDropDownAlwaysVisible);
            this.mPopup.update(this.getAnchorView(), this.mDropDownHorizontalOffset, this.mDropDownVerticalOffset, widthSpec, heightSpec);
        } else {
            if (this.mDropDownWidth == -1) {
                widthSpec = -1;
            } else if (this.mDropDownWidth == -2) {
                this.mPopup.setWidth(this.getAnchorView().getWidth());
            } else {
                this.mPopup.setWidth(this.mDropDownWidth);
            }
            if (this.mDropDownHeight == -1) {
                heightSpec = -1;
            } else if (this.mDropDownHeight == -2) {
                this.mPopup.setHeight(height);
            } else {
                this.mPopup.setHeight(this.mDropDownHeight);
            }
            this.mPopup.setWindowLayoutMode(widthSpec, heightSpec);
            this.mPopup.setClipToScreenEnabled(true);
            this.mPopup.setOutsideTouchable(!this.mForceIgnoreOutsideTouch && !this.mDropDownAlwaysVisible);
            this.mPopup.setTouchInterceptor(this.mTouchInterceptor);
            this.mPopup.showAsDropDown(this.getAnchorView(), this.mDropDownHorizontalOffset, this.mDropDownVerticalOffset, this.mDropDownGravity);
            this.mDropDownList.setSelection(-1);
            if (!this.mModal || this.mDropDownList.isInTouchMode()) {
                this.clearListSelection();
            }
            if (!this.mModal) {
                this.mHandler.post(this.mHideSelector);
            }
        }
    }

    private final void $$robo$$android_widget_ListPopupWindow$dismiss() {
        this.mPopup.dismiss();
        this.removePromptView();
        this.mPopup.setContentView(null);
        this.mDropDownList = null;
        this.mHandler.removeCallbacks(this.mResizePopupRunnable);
    }

    private final void $$robo$$android_widget_ListPopupWindow$setOnDismissListener(PopupWindow.OnDismissListener listener) {
        this.mPopup.setOnDismissListener(listener);
    }

    private final void $$robo$$android_widget_ListPopupWindow$removePromptView() {
        ViewParent parent;
        if (this.mPromptView != null && (parent = this.mPromptView.getParent()) instanceof ViewGroup) {
            ViewGroup group = (ViewGroup)parent;
            group.removeView(this.mPromptView);
        }
    }

    private final void $$robo$$android_widget_ListPopupWindow$setInputMethodMode(int mode) {
        this.mPopup.setInputMethodMode(mode);
    }

    private final int $$robo$$android_widget_ListPopupWindow$getInputMethodMode() {
        return this.mPopup.getInputMethodMode();
    }

    private final void $$robo$$android_widget_ListPopupWindow$setSelection(int position) {
        DropDownListView list = this.mDropDownList;
        if (this.isShowing() && list != null) {
            list.mListSelectionHidden = false;
            list.setSelection(position);
            if (list.getChoiceMode() != 0) {
                list.setItemChecked(position, true);
            }
        }
    }

    private final void $$robo$$android_widget_ListPopupWindow$clearListSelection() {
        DropDownListView list = this.mDropDownList;
        if (list != null) {
            list.mListSelectionHidden = true;
            list.hideSelector();
            list.requestLayout();
        }
    }

    private final boolean $$robo$$android_widget_ListPopupWindow$isShowing() {
        return this.mPopup.isShowing();
    }

    private final boolean $$robo$$android_widget_ListPopupWindow$isInputMethodNotNeeded() {
        return this.mPopup.getInputMethodMode() == 2;
    }

    private final boolean $$robo$$android_widget_ListPopupWindow$performItemClick(int position) {
        if (this.isShowing()) {
            if (this.mItemClickListener != null) {
                DropDownListView list = this.mDropDownList;
                View child = list.getChildAt(position - list.getFirstVisiblePosition());
                Adapter adapter = list.getAdapter();
                this.mItemClickListener.onItemClick(list, child, position, adapter.getItemId(position));
            }
            return true;
        }
        return false;
    }

    private final Object $$robo$$android_widget_ListPopupWindow$getSelectedItem() {
        if (!this.isShowing()) {
            return null;
        }
        return this.mDropDownList.getSelectedItem();
    }

    private final int $$robo$$android_widget_ListPopupWindow$getSelectedItemPosition() {
        if (!this.isShowing()) {
            return -1;
        }
        return this.mDropDownList.getSelectedItemPosition();
    }

    private final long $$robo$$android_widget_ListPopupWindow$getSelectedItemId() {
        if (!this.isShowing()) {
            return Long.MIN_VALUE;
        }
        return this.mDropDownList.getSelectedItemId();
    }

    private final View $$robo$$android_widget_ListPopupWindow$getSelectedView() {
        if (!this.isShowing()) {
            return null;
        }
        return this.mDropDownList.getSelectedView();
    }

    private final ListView $$robo$$android_widget_ListPopupWindow$getListView() {
        return this.mDropDownList;
    }

    private final void $$robo$$android_widget_ListPopupWindow$setListItemExpandMax(int max) {
        this.mListItemExpandMaximum = max;
    }

    private final boolean $$robo$$android_widget_ListPopupWindow$onKeyDown(int keyCode, KeyEvent event) {
        if (this.isShowing() && keyCode != 62 && (this.mDropDownList.getSelectedItemPosition() >= 0 || !KeyEvent.isConfirmKey(keyCode))) {
            int curIndex = this.mDropDownList.getSelectedItemPosition();
            boolean below = !this.mPopup.isAboveAnchor();
            ListAdapter adapter = this.mAdapter;
            int firstItem = Integer.MAX_VALUE;
            int lastItem = Integer.MIN_VALUE;
            if (adapter != null) {
                boolean allEnabled = adapter.areAllItemsEnabled();
                firstItem = allEnabled ? 0 : this.mDropDownList.lookForSelectablePosition(0, true);
                int n = lastItem = allEnabled ? adapter.getCount() - 1 : this.mDropDownList.lookForSelectablePosition(adapter.getCount() - 1, false);
            }
            if (below && keyCode == 19 && curIndex <= firstItem || !below && keyCode == 20 && curIndex >= lastItem) {
                this.clearListSelection();
                this.mPopup.setInputMethodMode(1);
                this.show();
                return true;
            }
            this.mDropDownList.mListSelectionHidden = false;
            boolean consumed = this.mDropDownList.onKeyDown(keyCode, event);
            if (consumed) {
                this.mPopup.setInputMethodMode(2);
                this.mDropDownList.requestFocusFromTouch();
                this.show();
                switch (keyCode) {
                    case 19: 
                    case 20: 
                    case 23: 
                    case 66: {
                        return true;
                    }
                }
            } else if (below && keyCode == 20 ? curIndex == lastItem : !below && keyCode == 19 && curIndex == firstItem) {
                return true;
            }
        }
        return false;
    }

    private final boolean $$robo$$android_widget_ListPopupWindow$onKeyUp(int keyCode, KeyEvent event) {
        if (this.isShowing() && this.mDropDownList.getSelectedItemPosition() >= 0) {
            boolean consumed = this.mDropDownList.onKeyUp(keyCode, event);
            if (consumed && KeyEvent.isConfirmKey(keyCode)) {
                this.dismiss();
            }
            return consumed;
        }
        return false;
    }

    private final boolean $$robo$$android_widget_ListPopupWindow$onKeyPreIme(int keyCode, KeyEvent event) {
        if (keyCode == 4 && this.isShowing()) {
            View anchorView = this.mDropDownAnchorView;
            if (event.getAction() == 0 && event.getRepeatCount() == 0) {
                KeyEvent.DispatcherState state = anchorView.getKeyDispatcherState();
                if (state != null) {
                    state.startTracking(event, this);
                }
                return true;
            }
            if (event.getAction() == 1) {
                KeyEvent.DispatcherState state = anchorView.getKeyDispatcherState();
                if (state != null) {
                    state.handleUpEvent(event);
                }
                if (event.isTracking() && !event.isCanceled()) {
                    this.dismiss();
                    return true;
                }
            }
        }
        return false;
    }

    private final View.OnTouchListener $$robo$$android_widget_ListPopupWindow$createDragToOpenListener(View src) {
        return new ShadowedObject(this, src){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ ListPopupWindow this$0;

            private void $$robo$$android_widget_ListPopupWindow_1$__constructor__(ListPopupWindow listPopupWindow, View x0) {
            }

            private final ListPopupWindow $$robo$$android_widget_ListPopupWindow_1$getPopup() {
                return this.this$0;
            }

            private void __constructor__(ListPopupWindow listPopupWindow, View view) {
                this.$$robo$$android_widget_ListPopupWindow_1$__constructor__(listPopupWindow, view);
            }
            {
                this.this$0 = listPopupWindow;
                super(view);
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_ListPopupWindow_1$__constructor__(android.widget.ListPopupWindow android.view.View ), 0, this, listPopupWindow, view);
            }

            @Override
            public ListPopupWindow getPopup() {
                return InvokeDynamicSupport.bootstrap("getPopup", $$robo$$android_widget_ListPopupWindow_1$getPopup(), 0, this);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
    }

    private final int $$robo$$android_widget_ListPopupWindow$buildDropDown() {
        int childWidthSpec;
        int otherHeights = 0;
        if (this.mDropDownList == null) {
            Context context = this.mContext;
            this.mShowDropDownRunnable = new Runnable(this){
                public transient /* synthetic */ Object __robo_data__;
                /* synthetic */ ListPopupWindow this$0;

                private void $$robo$$android_widget_ListPopupWindow_2$__constructor__(ListPopupWindow listPopupWindow) {
                }

                private final void $$robo$$android_widget_ListPopupWindow_2$run() {
                    View view = this.this$0.getAnchorView();
                    if (view != null && view.getWindowToken() != null) {
                        this.this$0.show();
                    }
                }

                private void __constructor__(ListPopupWindow listPopupWindow) {
                    this.$$robo$$android_widget_ListPopupWindow_2$__constructor__(listPopupWindow);
                }
                {
                    this.this$0 = listPopupWindow;
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_ListPopupWindow_2$__constructor__(android.widget.ListPopupWindow ), 0, this, listPopupWindow);
                }

                @Override
                public void run() {
                    InvokeDynamicSupport.bootstrap("run", $$robo$$android_widget_ListPopupWindow_2$run(), 0, this);
                }
                {
                    this.$$robo$init();
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            };
            this.mDropDownList = new DropDownListView(context, !this.mModal);
            if (this.mDropDownListHighlight != null) {
                this.mDropDownList.setSelector(this.mDropDownListHighlight);
            }
            this.mDropDownList.setAdapter(this.mAdapter);
            this.mDropDownList.setOnItemClickListener(this.mItemClickListener);
            this.mDropDownList.setFocusable(true);
            this.mDropDownList.setFocusableInTouchMode(true);
            this.mDropDownList.setOnItemSelectedListener(new AdapterView.OnItemSelectedListener(this){
                public transient /* synthetic */ Object __robo_data__;
                /* synthetic */ ListPopupWindow this$0;

                private void $$robo$$android_widget_ListPopupWindow_3$__constructor__(ListPopupWindow listPopupWindow) {
                }

                private final void $$robo$$android_widget_ListPopupWindow_3$onItemSelected(AdapterView<?> parent, View view, int position, long id2) {
                    DropDownListView dropDownList;
                    if (position != -1 && (dropDownList = this.this$0.mDropDownList) != null) {
                        dropDownList.mListSelectionHidden = false;
                    }
                }

                private final void $$robo$$android_widget_ListPopupWindow_3$onNothingSelected(AdapterView<?> parent) {
                }

                private void __constructor__(ListPopupWindow listPopupWindow) {
                    this.$$robo$$android_widget_ListPopupWindow_3$__constructor__(listPopupWindow);
                }
                {
                    this.this$0 = listPopupWindow;
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_ListPopupWindow_3$__constructor__(android.widget.ListPopupWindow ), 0, this, listPopupWindow);
                }

                @Override
                public void onItemSelected(AdapterView<?> adapterView, View view, int n, long l) {
                    InvokeDynamicSupport.bootstrap("onItemSelected", $$robo$$android_widget_ListPopupWindow_3$onItemSelected(android.widget.AdapterView<?> android.view.View int long ), 0, this, adapterView, view, n, l);
                }

                @Override
                public void onNothingSelected(AdapterView<?> adapterView) {
                    InvokeDynamicSupport.bootstrap("onNothingSelected", $$robo$$android_widget_ListPopupWindow_3$onNothingSelected(android.widget.AdapterView<?> ), 0, this, adapterView);
                }
                {
                    this.$$robo$init();
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            });
            this.mDropDownList.setOnScrollListener(this.mScrollListener);
            if (this.mItemSelectedListener != null) {
                this.mDropDownList.setOnItemSelectedListener(this.mItemSelectedListener);
            }
            ViewGroup dropDownView = this.mDropDownList;
            View hintView = this.mPromptView;
            if (hintView != null) {
                LinearLayout hintContainer = new LinearLayout(context);
                hintContainer.setOrientation(1);
                LinearLayout.LayoutParams hintParams = new LinearLayout.LayoutParams(-1, 0, 1.0f);
                switch (this.mPromptPosition) {
                    case 1: {
                        hintContainer.addView((View)dropDownView, hintParams);
                        hintContainer.addView(hintView);
                        break;
                    }
                    case 0: {
                        hintContainer.addView(hintView);
                        hintContainer.addView((View)dropDownView, hintParams);
                        break;
                    }
                    default: {
                        Log.e("ListPopupWindow", "Invalid hint position " + this.mPromptPosition);
                    }
                }
                int widthSpec = View.MeasureSpec.makeMeasureSpec(this.mDropDownWidth, Integer.MIN_VALUE);
                int heightSpec = 0;
                hintView.measure(widthSpec, heightSpec);
                hintParams = (LinearLayout.LayoutParams)hintView.getLayoutParams();
                otherHeights = hintView.getMeasuredHeight() + hintParams.topMargin + hintParams.bottomMargin;
                dropDownView = hintContainer;
            }
            this.mPopup.setContentView(dropDownView);
        } else {
            ViewGroup dropDownView = (ViewGroup)this.mPopup.getContentView();
            View view = this.mPromptView;
            if (view != null) {
                LinearLayout.LayoutParams hintParams = (LinearLayout.LayoutParams)view.getLayoutParams();
                otherHeights = view.getMeasuredHeight() + hintParams.topMargin + hintParams.bottomMargin;
            }
        }
        int padding = 0;
        Drawable background = this.mPopup.getBackground();
        if (background != null) {
            background.getPadding(this.mTempRect);
            padding = this.mTempRect.top + this.mTempRect.bottom;
            if (!this.mDropDownVerticalOffsetSet) {
                this.mDropDownVerticalOffset = -this.mTempRect.top;
            }
        } else {
            this.mTempRect.setEmpty();
        }
        boolean ignoreBottomDecorations = this.mPopup.getInputMethodMode() == 2;
        int maxHeight = this.mPopup.getMaxAvailableHeight(this.getAnchorView(), this.mDropDownVerticalOffset, ignoreBottomDecorations);
        if (this.mDropDownAlwaysVisible || this.mDropDownHeight == -1) {
            return maxHeight + padding;
        }
        switch (this.mDropDownWidth) {
            case -2: {
                childWidthSpec = View.MeasureSpec.makeMeasureSpec(this.mContext.getResources().getDisplayMetrics().widthPixels - (this.mTempRect.left + this.mTempRect.right), Integer.MIN_VALUE);
                break;
            }
            case -1: {
                childWidthSpec = View.MeasureSpec.makeMeasureSpec(this.mContext.getResources().getDisplayMetrics().widthPixels - (this.mTempRect.left + this.mTempRect.right), 0x40000000);
                break;
            }
            default: {
                childWidthSpec = View.MeasureSpec.makeMeasureSpec(this.mDropDownWidth, 0x40000000);
            }
        }
        int listContent = this.mDropDownList.measureHeightOfChildren(childWidthSpec, 0, -1, maxHeight - otherHeights, -1);
        if (listContent > 0) {
            otherHeights += padding;
        }
        return listContent + otherHeights;
    }

    private void __constructor__(Context context) {
        this.$$robo$$android_widget_ListPopupWindow$__constructor__(context);
    }

    public ListPopupWindow(Context context) {
        this(context, null, 16843519, 0);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_ListPopupWindow$__constructor__(android.content.Context ), 0, this, context);
    }

    private void __constructor__(Context context, AttributeSet attributeSet) {
        this.$$robo$$android_widget_ListPopupWindow$__constructor__(context, attributeSet);
    }

    public ListPopupWindow(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 16843519, 0);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_ListPopupWindow$__constructor__(android.content.Context android.util.AttributeSet ), 0, this, context, attributeSet);
    }

    private void __constructor__(Context context, AttributeSet attributeSet, int n) {
        this.$$robo$$android_widget_ListPopupWindow$__constructor__(context, attributeSet, n);
    }

    public ListPopupWindow(Context context, AttributeSet attributeSet, int n) {
        this(context, attributeSet, n, 0);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_ListPopupWindow$__constructor__(android.content.Context android.util.AttributeSet int ), 0, this, context, attributeSet, n);
    }

    private void __constructor__(Context context, AttributeSet attributeSet, int n, int n2) {
        this.$$robo$$android_widget_ListPopupWindow$__constructor__(context, attributeSet, n, n2);
    }

    public ListPopupWindow(Context context, AttributeSet attributeSet, int n, int n2) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_ListPopupWindow$__constructor__(android.content.Context android.util.AttributeSet int int ), 0, this, context, attributeSet, n, n2);
    }

    public void setAdapter(ListAdapter listAdapter) {
        InvokeDynamicSupport.bootstrap("setAdapter", $$robo$$android_widget_ListPopupWindow$setAdapter(android.widget.ListAdapter ), 0, this, listAdapter);
    }

    public void setPromptPosition(int n) {
        InvokeDynamicSupport.bootstrap("setPromptPosition", $$robo$$android_widget_ListPopupWindow$setPromptPosition(int ), 0, this, n);
    }

    public int getPromptPosition() {
        return (int)InvokeDynamicSupport.bootstrap("getPromptPosition", $$robo$$android_widget_ListPopupWindow$getPromptPosition(), 0, this);
    }

    public void setModal(boolean bl) {
        InvokeDynamicSupport.bootstrap("setModal", $$robo$$android_widget_ListPopupWindow$setModal(boolean ), 0, this, bl);
    }

    public boolean isModal() {
        return (boolean)InvokeDynamicSupport.bootstrap("isModal", $$robo$$android_widget_ListPopupWindow$isModal(), 0, this);
    }

    public void setForceIgnoreOutsideTouch(boolean bl) {
        InvokeDynamicSupport.bootstrap("setForceIgnoreOutsideTouch", $$robo$$android_widget_ListPopupWindow$setForceIgnoreOutsideTouch(boolean ), 0, this, bl);
    }

    public void setDropDownAlwaysVisible(boolean bl) {
        InvokeDynamicSupport.bootstrap("setDropDownAlwaysVisible", $$robo$$android_widget_ListPopupWindow$setDropDownAlwaysVisible(boolean ), 0, this, bl);
    }

    public boolean isDropDownAlwaysVisible() {
        return (boolean)InvokeDynamicSupport.bootstrap("isDropDownAlwaysVisible", $$robo$$android_widget_ListPopupWindow$isDropDownAlwaysVisible(), 0, this);
    }

    public void setSoftInputMode(int n) {
        InvokeDynamicSupport.bootstrap("setSoftInputMode", $$robo$$android_widget_ListPopupWindow$setSoftInputMode(int ), 0, this, n);
    }

    public int getSoftInputMode() {
        return (int)InvokeDynamicSupport.bootstrap("getSoftInputMode", $$robo$$android_widget_ListPopupWindow$getSoftInputMode(), 0, this);
    }

    public void setListSelector(Drawable drawable2) {
        InvokeDynamicSupport.bootstrap("setListSelector", $$robo$$android_widget_ListPopupWindow$setListSelector(android.graphics.drawable.Drawable ), 0, this, drawable2);
    }

    public Drawable getBackground() {
        return InvokeDynamicSupport.bootstrap("getBackground", $$robo$$android_widget_ListPopupWindow$getBackground(), 0, this);
    }

    public void setBackgroundDrawable(Drawable drawable2) {
        InvokeDynamicSupport.bootstrap("setBackgroundDrawable", $$robo$$android_widget_ListPopupWindow$setBackgroundDrawable(android.graphics.drawable.Drawable ), 0, this, drawable2);
    }

    public void setAnimationStyle(int n) {
        InvokeDynamicSupport.bootstrap("setAnimationStyle", $$robo$$android_widget_ListPopupWindow$setAnimationStyle(int ), 0, this, n);
    }

    public int getAnimationStyle() {
        return (int)InvokeDynamicSupport.bootstrap("getAnimationStyle", $$robo$$android_widget_ListPopupWindow$getAnimationStyle(), 0, this);
    }

    public View getAnchorView() {
        return InvokeDynamicSupport.bootstrap("getAnchorView", $$robo$$android_widget_ListPopupWindow$getAnchorView(), 0, this);
    }

    public void setAnchorView(View view) {
        InvokeDynamicSupport.bootstrap("setAnchorView", $$robo$$android_widget_ListPopupWindow$setAnchorView(android.view.View ), 0, this, view);
    }

    public int getHorizontalOffset() {
        return (int)InvokeDynamicSupport.bootstrap("getHorizontalOffset", $$robo$$android_widget_ListPopupWindow$getHorizontalOffset(), 0, this);
    }

    public void setHorizontalOffset(int n) {
        InvokeDynamicSupport.bootstrap("setHorizontalOffset", $$robo$$android_widget_ListPopupWindow$setHorizontalOffset(int ), 0, this, n);
    }

    public int getVerticalOffset() {
        return (int)InvokeDynamicSupport.bootstrap("getVerticalOffset", $$robo$$android_widget_ListPopupWindow$getVerticalOffset(), 0, this);
    }

    public void setVerticalOffset(int n) {
        InvokeDynamicSupport.bootstrap("setVerticalOffset", $$robo$$android_widget_ListPopupWindow$setVerticalOffset(int ), 0, this, n);
    }

    public void setDropDownGravity(int n) {
        InvokeDynamicSupport.bootstrap("setDropDownGravity", $$robo$$android_widget_ListPopupWindow$setDropDownGravity(int ), 0, this, n);
    }

    public int getWidth() {
        return (int)InvokeDynamicSupport.bootstrap("getWidth", $$robo$$android_widget_ListPopupWindow$getWidth(), 0, this);
    }

    public void setWidth(int n) {
        InvokeDynamicSupport.bootstrap("setWidth", $$robo$$android_widget_ListPopupWindow$setWidth(int ), 0, this, n);
    }

    public void setContentWidth(int n) {
        InvokeDynamicSupport.bootstrap("setContentWidth", $$robo$$android_widget_ListPopupWindow$setContentWidth(int ), 0, this, n);
    }

    public int getHeight() {
        return (int)InvokeDynamicSupport.bootstrap("getHeight", $$robo$$android_widget_ListPopupWindow$getHeight(), 0, this);
    }

    public void setHeight(int n) {
        InvokeDynamicSupport.bootstrap("setHeight", $$robo$$android_widget_ListPopupWindow$setHeight(int ), 0, this, n);
    }

    public void setOnItemClickListener(AdapterView.OnItemClickListener onItemClickListener) {
        InvokeDynamicSupport.bootstrap("setOnItemClickListener", $$robo$$android_widget_ListPopupWindow$setOnItemClickListener(android.widget.AdapterView$OnItemClickListener ), 0, this, onItemClickListener);
    }

    public void setOnItemSelectedListener(AdapterView.OnItemSelectedListener onItemSelectedListener) {
        InvokeDynamicSupport.bootstrap("setOnItemSelectedListener", $$robo$$android_widget_ListPopupWindow$setOnItemSelectedListener(android.widget.AdapterView$OnItemSelectedListener ), 0, this, onItemSelectedListener);
    }

    public void setPromptView(View view) {
        InvokeDynamicSupport.bootstrap("setPromptView", $$robo$$android_widget_ListPopupWindow$setPromptView(android.view.View ), 0, this, view);
    }

    public void postShow() {
        InvokeDynamicSupport.bootstrap("postShow", $$robo$$android_widget_ListPopupWindow$postShow(), 0, this);
    }

    public void show() {
        InvokeDynamicSupport.bootstrap("show", $$robo$$android_widget_ListPopupWindow$show(), 0, this);
    }

    public void dismiss() {
        InvokeDynamicSupport.bootstrap("dismiss", $$robo$$android_widget_ListPopupWindow$dismiss(), 0, this);
    }

    public void setOnDismissListener(PopupWindow.OnDismissListener onDismissListener) {
        InvokeDynamicSupport.bootstrap("setOnDismissListener", $$robo$$android_widget_ListPopupWindow$setOnDismissListener(android.widget.PopupWindow$OnDismissListener ), 0, this, onDismissListener);
    }

    private void removePromptView() {
        InvokeDynamicSupport.bootstrap("removePromptView", $$robo$$android_widget_ListPopupWindow$removePromptView(), 0, this);
    }

    public void setInputMethodMode(int n) {
        InvokeDynamicSupport.bootstrap("setInputMethodMode", $$robo$$android_widget_ListPopupWindow$setInputMethodMode(int ), 0, this, n);
    }

    public int getInputMethodMode() {
        return (int)InvokeDynamicSupport.bootstrap("getInputMethodMode", $$robo$$android_widget_ListPopupWindow$getInputMethodMode(), 0, this);
    }

    public void setSelection(int n) {
        InvokeDynamicSupport.bootstrap("setSelection", $$robo$$android_widget_ListPopupWindow$setSelection(int ), 0, this, n);
    }

    public void clearListSelection() {
        InvokeDynamicSupport.bootstrap("clearListSelection", $$robo$$android_widget_ListPopupWindow$clearListSelection(), 0, this);
    }

    public boolean isShowing() {
        return (boolean)InvokeDynamicSupport.bootstrap("isShowing", $$robo$$android_widget_ListPopupWindow$isShowing(), 0, this);
    }

    public boolean isInputMethodNotNeeded() {
        return (boolean)InvokeDynamicSupport.bootstrap("isInputMethodNotNeeded", $$robo$$android_widget_ListPopupWindow$isInputMethodNotNeeded(), 0, this);
    }

    public boolean performItemClick(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("performItemClick", $$robo$$android_widget_ListPopupWindow$performItemClick(int ), 0, this, n);
    }

    public Object getSelectedItem() {
        return InvokeDynamicSupport.bootstrap("getSelectedItem", $$robo$$android_widget_ListPopupWindow$getSelectedItem(), 0, this);
    }

    public int getSelectedItemPosition() {
        return (int)InvokeDynamicSupport.bootstrap("getSelectedItemPosition", $$robo$$android_widget_ListPopupWindow$getSelectedItemPosition(), 0, this);
    }

    public long getSelectedItemId() {
        return (long)InvokeDynamicSupport.bootstrap("getSelectedItemId", $$robo$$android_widget_ListPopupWindow$getSelectedItemId(), 0, this);
    }

    public View getSelectedView() {
        return InvokeDynamicSupport.bootstrap("getSelectedView", $$robo$$android_widget_ListPopupWindow$getSelectedView(), 0, this);
    }

    public ListView getListView() {
        return InvokeDynamicSupport.bootstrap("getListView", $$robo$$android_widget_ListPopupWindow$getListView(), 0, this);
    }

    void setListItemExpandMax(int n) {
        InvokeDynamicSupport.bootstrap("setListItemExpandMax", $$robo$$android_widget_ListPopupWindow$setListItemExpandMax(int ), 0, this, n);
    }

    public boolean onKeyDown(int n, KeyEvent keyEvent) {
        return (boolean)InvokeDynamicSupport.bootstrap("onKeyDown", $$robo$$android_widget_ListPopupWindow$onKeyDown(int android.view.KeyEvent ), 0, this, n, keyEvent);
    }

    public boolean onKeyUp(int n, KeyEvent keyEvent) {
        return (boolean)InvokeDynamicSupport.bootstrap("onKeyUp", $$robo$$android_widget_ListPopupWindow$onKeyUp(int android.view.KeyEvent ), 0, this, n, keyEvent);
    }

    public boolean onKeyPreIme(int n, KeyEvent keyEvent) {
        return (boolean)InvokeDynamicSupport.bootstrap("onKeyPreIme", $$robo$$android_widget_ListPopupWindow$onKeyPreIme(int android.view.KeyEvent ), 0, this, n, keyEvent);
    }

    public View.OnTouchListener createDragToOpenListener(View view) {
        return InvokeDynamicSupport.bootstrap("createDragToOpenListener", $$robo$$android_widget_ListPopupWindow$createDragToOpenListener(android.view.View ), 0, this, view);
    }

    private int buildDropDown() {
        return (int)InvokeDynamicSupport.bootstrap("buildDropDown", $$robo$$android_widget_ListPopupWindow$buildDropDown(), 0, this);
    }

    public /* synthetic */ ListPopupWindow() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ListPopupWindow)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    private class PopupScrollListener
    implements AbsListView.OnScrollListener,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        /* synthetic */ ListPopupWindow this$0;

        private void $$robo$$android_widget_ListPopupWindow_PopupScrollListener$__constructor__(ListPopupWindow listPopupWindow) {
        }

        private final void $$robo$$android_widget_ListPopupWindow_PopupScrollListener$onScroll(AbsListView view, int firstVisibleItem, int visibleItemCount, int totalItemCount) {
        }

        private final void $$robo$$android_widget_ListPopupWindow_PopupScrollListener$onScrollStateChanged(AbsListView view, int scrollState) {
            if (scrollState == 1 && !this.this$0.isInputMethodNotNeeded() && this.this$0.mPopup.getContentView() != null) {
                this.this$0.mHandler.removeCallbacks(this.this$0.mResizePopupRunnable);
                this.this$0.mResizePopupRunnable.run();
            }
        }

        private /* synthetic */ void $$robo$$android_widget_ListPopupWindow_PopupScrollListener$__constructor__(ListPopupWindow x0, 1 x1) {
        }

        private void __constructor__(ListPopupWindow listPopupWindow) {
            this.$$robo$$android_widget_ListPopupWindow_PopupScrollListener$__constructor__(listPopupWindow);
        }

        private PopupScrollListener(ListPopupWindow listPopupWindow) {
            this.this$0 = listPopupWindow;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_ListPopupWindow_PopupScrollListener$__constructor__(android.widget.ListPopupWindow ), 0, this, listPopupWindow);
        }

        @Override
        public void onScroll(AbsListView absListView, int n, int n2, int n3) {
            InvokeDynamicSupport.bootstrap("onScroll", $$robo$$android_widget_ListPopupWindow_PopupScrollListener$onScroll(android.widget.AbsListView int int int ), 0, this, absListView, n, n2, n3);
        }

        @Override
        public void onScrollStateChanged(AbsListView absListView, int n) {
            InvokeDynamicSupport.bootstrap("onScrollStateChanged", $$robo$$android_widget_ListPopupWindow_PopupScrollListener$onScrollStateChanged(android.widget.AbsListView int ), 0, this, absListView, n);
        }

        private /* synthetic */ void __constructor__(ListPopupWindow listPopupWindow, 1 var2_2) {
            this.$$robo$$android_widget_ListPopupWindow_PopupScrollListener$__constructor__(listPopupWindow, var2_2);
        }

        public /* synthetic */ PopupScrollListener() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (PopupScrollListener)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private class PopupTouchInterceptor
    implements View.OnTouchListener,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        /* synthetic */ ListPopupWindow this$0;

        private void $$robo$$android_widget_ListPopupWindow_PopupTouchInterceptor$__constructor__(ListPopupWindow listPopupWindow) {
        }

        private final boolean $$robo$$android_widget_ListPopupWindow_PopupTouchInterceptor$onTouch(View v, MotionEvent event) {
            int action = event.getAction();
            int x = (int)event.getX();
            int y = (int)event.getY();
            if (action == 0 && this.this$0.mPopup != null && this.this$0.mPopup.isShowing() && x >= 0 && x < this.this$0.mPopup.getWidth() && y >= 0 && y < this.this$0.mPopup.getHeight()) {
                this.this$0.mHandler.postDelayed(this.this$0.mResizePopupRunnable, 250L);
            } else if (action == 1) {
                this.this$0.mHandler.removeCallbacks(this.this$0.mResizePopupRunnable);
            }
            return false;
        }

        private /* synthetic */ void $$robo$$android_widget_ListPopupWindow_PopupTouchInterceptor$__constructor__(ListPopupWindow x0, 1 x1) {
        }

        private void __constructor__(ListPopupWindow listPopupWindow) {
            this.$$robo$$android_widget_ListPopupWindow_PopupTouchInterceptor$__constructor__(listPopupWindow);
        }

        private PopupTouchInterceptor(ListPopupWindow listPopupWindow) {
            this.this$0 = listPopupWindow;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_ListPopupWindow_PopupTouchInterceptor$__constructor__(android.widget.ListPopupWindow ), 0, this, listPopupWindow);
        }

        @Override
        public boolean onTouch(View view, MotionEvent motionEvent) {
            return (boolean)InvokeDynamicSupport.bootstrap("onTouch", $$robo$$android_widget_ListPopupWindow_PopupTouchInterceptor$onTouch(android.view.View android.view.MotionEvent ), 0, this, view, motionEvent);
        }

        private /* synthetic */ void __constructor__(ListPopupWindow listPopupWindow, 1 var2_2) {
            this.$$robo$$android_widget_ListPopupWindow_PopupTouchInterceptor$__constructor__(listPopupWindow, var2_2);
        }

        public /* synthetic */ PopupTouchInterceptor() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (PopupTouchInterceptor)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private class ResizePopupRunnable
    implements Runnable,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        /* synthetic */ ListPopupWindow this$0;

        private void $$robo$$android_widget_ListPopupWindow_ResizePopupRunnable$__constructor__(ListPopupWindow listPopupWindow) {
        }

        private final void $$robo$$android_widget_ListPopupWindow_ResizePopupRunnable$run() {
            if (this.this$0.mDropDownList != null && this.this$0.mDropDownList.getCount() > this.this$0.mDropDownList.getChildCount() && this.this$0.mDropDownList.getChildCount() <= this.this$0.mListItemExpandMaximum) {
                this.this$0.mPopup.setInputMethodMode(2);
                this.this$0.show();
            }
        }

        private /* synthetic */ void $$robo$$android_widget_ListPopupWindow_ResizePopupRunnable$__constructor__(ListPopupWindow x0, 1 x1) {
        }

        private void __constructor__(ListPopupWindow listPopupWindow) {
            this.$$robo$$android_widget_ListPopupWindow_ResizePopupRunnable$__constructor__(listPopupWindow);
        }

        private ResizePopupRunnable(ListPopupWindow listPopupWindow) {
            this.this$0 = listPopupWindow;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_ListPopupWindow_ResizePopupRunnable$__constructor__(android.widget.ListPopupWindow ), 0, this, listPopupWindow);
        }

        @Override
        public void run() {
            InvokeDynamicSupport.bootstrap("run", $$robo$$android_widget_ListPopupWindow_ResizePopupRunnable$run(), 0, this);
        }

        private /* synthetic */ void __constructor__(ListPopupWindow listPopupWindow, 1 var2_2) {
            this.$$robo$$android_widget_ListPopupWindow_ResizePopupRunnable$__constructor__(listPopupWindow, var2_2);
        }

        public /* synthetic */ ResizePopupRunnable() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ResizePopupRunnable)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private class ListSelectorHider
    implements Runnable,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        /* synthetic */ ListPopupWindow this$0;

        private void $$robo$$android_widget_ListPopupWindow_ListSelectorHider$__constructor__(ListPopupWindow listPopupWindow) {
        }

        private final void $$robo$$android_widget_ListPopupWindow_ListSelectorHider$run() {
            this.this$0.clearListSelection();
        }

        private /* synthetic */ void $$robo$$android_widget_ListPopupWindow_ListSelectorHider$__constructor__(ListPopupWindow x0, 1 x1) {
        }

        private void __constructor__(ListPopupWindow listPopupWindow) {
            this.$$robo$$android_widget_ListPopupWindow_ListSelectorHider$__constructor__(listPopupWindow);
        }

        private ListSelectorHider(ListPopupWindow listPopupWindow) {
            this.this$0 = listPopupWindow;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_ListPopupWindow_ListSelectorHider$__constructor__(android.widget.ListPopupWindow ), 0, this, listPopupWindow);
        }

        @Override
        public void run() {
            InvokeDynamicSupport.bootstrap("run", $$robo$$android_widget_ListPopupWindow_ListSelectorHider$run(), 0, this);
        }

        private /* synthetic */ void __constructor__(ListPopupWindow listPopupWindow, 1 var2_2) {
            this.$$robo$$android_widget_ListPopupWindow_ListSelectorHider$__constructor__(listPopupWindow, var2_2);
        }

        public /* synthetic */ ListSelectorHider() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ListSelectorHider)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private class PopupDataSetObserver
    extends DataSetObserver
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        /* synthetic */ ListPopupWindow this$0;

        private void $$robo$$android_widget_ListPopupWindow_PopupDataSetObserver$__constructor__(ListPopupWindow listPopupWindow) {
        }

        private final void $$robo$$android_widget_ListPopupWindow_PopupDataSetObserver$onChanged() {
            if (this.this$0.isShowing()) {
                this.this$0.show();
            }
        }

        private final void $$robo$$android_widget_ListPopupWindow_PopupDataSetObserver$onInvalidated() {
            this.this$0.dismiss();
        }

        private /* synthetic */ void $$robo$$android_widget_ListPopupWindow_PopupDataSetObserver$__constructor__(ListPopupWindow x0, 1 x1) {
        }

        private void __constructor__(ListPopupWindow listPopupWindow) {
            this.$$robo$$android_widget_ListPopupWindow_PopupDataSetObserver$__constructor__(listPopupWindow);
        }

        private PopupDataSetObserver(ListPopupWindow listPopupWindow) {
            this.this$0 = listPopupWindow;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_ListPopupWindow_PopupDataSetObserver$__constructor__(android.widget.ListPopupWindow ), 0, this, listPopupWindow);
        }

        @Override
        public void onChanged() {
            InvokeDynamicSupport.bootstrap("onChanged", $$robo$$android_widget_ListPopupWindow_PopupDataSetObserver$onChanged(), 0, this);
        }

        @Override
        public void onInvalidated() {
            InvokeDynamicSupport.bootstrap("onInvalidated", $$robo$$android_widget_ListPopupWindow_PopupDataSetObserver$onInvalidated(), 0, this);
        }

        private /* synthetic */ void __constructor__(ListPopupWindow listPopupWindow, 1 var2_2) {
            this.$$robo$$android_widget_ListPopupWindow_PopupDataSetObserver$__constructor__(listPopupWindow, var2_2);
        }

        public /* synthetic */ PopupDataSetObserver() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (PopupDataSetObserver)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private static class DropDownListView
    extends ListView
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private static long CLICK_ANIM_DURATION = 150L;
        private static int CLICK_ANIM_ALPHA = 128;
        private static IntProperty<Drawable> DRAWABLE_ALPHA;
        private boolean mListSelectionHidden;
        private boolean mHijackFocus;
        private boolean mDrawsInPressedState;
        private Animator mClickAnimation;
        private AutoScrollHelper.AbsListViewAutoScroller mScrollHelper;

        private void $$robo$$android_widget_ListPopupWindow_DropDownListView$__constructor__(Context context, boolean hijackFocus) {
            this.mHijackFocus = hijackFocus;
            this.setCacheColorHint(0);
        }

        private final boolean $$robo$$android_widget_ListPopupWindow_DropDownListView$onForwardedEvent(MotionEvent event, int activePointerId) {
            boolean handledEvent = true;
            boolean clearPressedItem = false;
            int actionMasked = event.getActionMasked();
            switch (actionMasked) {
                case 3: {
                    handledEvent = false;
                    break;
                }
                case 1: {
                    handledEvent = false;
                }
                case 2: {
                    int y;
                    int activeIndex = event.findPointerIndex(activePointerId);
                    if (activeIndex < 0) {
                        handledEvent = false;
                        break;
                    }
                    int x = (int)event.getX(activeIndex);
                    int position = this.pointToPosition(x, y = (int)event.getY(activeIndex));
                    if (position == -1) {
                        clearPressedItem = true;
                        break;
                    }
                    View child = this.getChildAt(position - this.getFirstVisiblePosition());
                    this.setPressedItem(child, position, x, y);
                    handledEvent = true;
                    if (actionMasked != 1) break;
                    this.clickPressedItem(child, position);
                }
            }
            if (!handledEvent || clearPressedItem) {
                this.clearPressedItem();
            }
            if (handledEvent) {
                if (this.mScrollHelper == null) {
                    this.mScrollHelper = new AutoScrollHelper.AbsListViewAutoScroller(this);
                }
                this.mScrollHelper.setEnabled(true);
                this.mScrollHelper.onTouch(this, event);
            } else if (this.mScrollHelper != null) {
                this.mScrollHelper.setEnabled(false);
            }
            return handledEvent;
        }

        private final void $$robo$$android_widget_ListPopupWindow_DropDownListView$clickPressedItem(View child, int position) {
            long id2 = this.getItemIdAtPosition(position);
            ObjectAnimator anim2 = ObjectAnimator.ofInt(this.mSelector, DRAWABLE_ALPHA, 255, 128, 255);
            ((Animator)anim2).setDuration(150L);
            ((Animator)anim2).setInterpolator(new AccelerateDecelerateInterpolator());
            anim2.addListener((Animator.AnimatorListener)new ShadowedObject(this, child, position, id2){
                public transient /* synthetic */ Object __robo_data__;
                /* synthetic */ View val$child;
                /* synthetic */ int val$position;
                /* synthetic */ long val$id;
                /* synthetic */ DropDownListView this$0;

                private void $$robo$$android_widget_ListPopupWindow_DropDownListView_2$__constructor__(DropDownListView dropDownListView, View view, int n, long l) {
                }

                private final void $$robo$$android_widget_ListPopupWindow_DropDownListView_2$onAnimationEnd(Animator animation) {
                    this.this$0.performItemClick(this.val$child, this.val$position, this.val$id);
                }

                private void __constructor__(DropDownListView dropDownListView, View view, int n, long l) {
                    this.$$robo$$android_widget_ListPopupWindow_DropDownListView_2$__constructor__(dropDownListView, view, n, l);
                }
                {
                    this.this$0 = dropDownListView;
                    this.val$child = view;
                    this.val$position = n;
                    this.val$id = l;
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_ListPopupWindow_DropDownListView_2$__constructor__(android.widget.ListPopupWindow$DropDownListView android.view.View int long ), 0, this, dropDownListView, view, n, l);
                }

                @Override
                public void onAnimationEnd(Animator animator2) {
                    InvokeDynamicSupport.bootstrap("onAnimationEnd", $$robo$$android_widget_ListPopupWindow_DropDownListView_2$onAnimationEnd(android.animation.Animator ), 0, this, animator2);
                }
                {
                    this.$$robo$init();
                }

                @Override
                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                @Override
                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            });
            ((Animator)anim2).start();
            if (this.mClickAnimation != null) {
                this.mClickAnimation.cancel();
            }
            this.mClickAnimation = anim2;
        }

        private final void $$robo$$android_widget_ListPopupWindow_DropDownListView$clearPressedItem() {
            this.mDrawsInPressedState = false;
            this.setPressed(false);
            this.updateSelectorState();
            if (this.mClickAnimation != null) {
                this.mClickAnimation.cancel();
                this.mClickAnimation = null;
            }
        }

        private final void $$robo$$android_widget_ListPopupWindow_DropDownListView$setPressedItem(View child, int position, float x, float y) {
            this.mDrawsInPressedState = true;
            this.setPressed(true);
            this.layoutChildren();
            this.setSelectedPositionInt(position);
            this.positionSelectorLikeTouch(position, child, x, y);
            this.refreshDrawableState();
            if (this.mClickAnimation != null) {
                this.mClickAnimation.cancel();
                this.mClickAnimation = null;
            }
        }

        private final boolean $$robo$$android_widget_ListPopupWindow_DropDownListView$touchModeDrawsInPressedState() {
            return this.mDrawsInPressedState || super.touchModeDrawsInPressedState();
        }

        private final View $$robo$$android_widget_ListPopupWindow_DropDownListView$obtainView(int position, boolean[] isScrap) {
            View view = super.obtainView(position, isScrap);
            if (view instanceof TextView) {
                ((TextView)view).setHorizontallyScrolling(true);
            }
            return view;
        }

        private final boolean $$robo$$android_widget_ListPopupWindow_DropDownListView$isInTouchMode() {
            return this.mHijackFocus && this.mListSelectionHidden || super.isInTouchMode();
        }

        private final boolean $$robo$$android_widget_ListPopupWindow_DropDownListView$hasWindowFocus() {
            return this.mHijackFocus || super.hasWindowFocus();
        }

        private final boolean $$robo$$android_widget_ListPopupWindow_DropDownListView$isFocused() {
            return this.mHijackFocus || super.isFocused();
        }

        private final boolean $$robo$$android_widget_ListPopupWindow_DropDownListView$hasFocus() {
            return this.mHijackFocus || super.hasFocus();
        }

        static void __staticInitializer__() {
            DRAWABLE_ALPHA = new IntProperty<Drawable>("alpha"){
                public transient /* synthetic */ Object __robo_data__;

                private void $$robo$$android_widget_ListPopupWindow_DropDownListView_1$__constructor__(String x0) {
                }

                private final void $$robo$$android_widget_ListPopupWindow_DropDownListView_1$setValue(Drawable object, int value) {
                    object.setAlpha(value);
                }

                private final Integer $$robo$$android_widget_ListPopupWindow_DropDownListView_1$get(Drawable object) {
                    return object.getAlpha();
                }

                private void __constructor__(String string2) {
                    this.$$robo$$android_widget_ListPopupWindow_DropDownListView_1$__constructor__(string2);
                }
                {
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_ListPopupWindow_DropDownListView_1$__constructor__(java.lang.String ), 0, this, string2);
                }

                @Override
                public void setValue(Drawable drawable2, int n) {
                    InvokeDynamicSupport.bootstrap("setValue", $$robo$$android_widget_ListPopupWindow_DropDownListView_1$setValue(android.graphics.drawable.Drawable int ), 0, this, drawable2, n);
                }

                @Override
                public Integer get(Drawable drawable2) {
                    return InvokeDynamicSupport.bootstrap("get", $$robo$$android_widget_ListPopupWindow_DropDownListView_1$get(android.graphics.drawable.Drawable ), 0, this, drawable2);
                }
                {
                    this.$$robo$init();
                }

                @Override
                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                @Override
                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            };
        }

        private void __constructor__(Context context, boolean bl) {
            this.$$robo$$android_widget_ListPopupWindow_DropDownListView$__constructor__(context, bl);
        }

        public DropDownListView(Context context, boolean bl) {
            super(context, null, 16842861);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_ListPopupWindow_DropDownListView$__constructor__(android.content.Context boolean ), 0, this, context, bl);
        }

        public boolean onForwardedEvent(MotionEvent motionEvent, int n) {
            return (boolean)InvokeDynamicSupport.bootstrap("onForwardedEvent", $$robo$$android_widget_ListPopupWindow_DropDownListView$onForwardedEvent(android.view.MotionEvent int ), 0, this, motionEvent, n);
        }

        private void clickPressedItem(View view, int n) {
            InvokeDynamicSupport.bootstrap("clickPressedItem", $$robo$$android_widget_ListPopupWindow_DropDownListView$clickPressedItem(android.view.View int ), 0, this, view, n);
        }

        private void clearPressedItem() {
            InvokeDynamicSupport.bootstrap("clearPressedItem", $$robo$$android_widget_ListPopupWindow_DropDownListView$clearPressedItem(), 0, this);
        }

        private void setPressedItem(View view, int n, float f, float f2) {
            InvokeDynamicSupport.bootstrap("setPressedItem", $$robo$$android_widget_ListPopupWindow_DropDownListView$setPressedItem(android.view.View int float float ), 0, this, view, n, f, f2);
        }

        @Override
        boolean touchModeDrawsInPressedState() {
            return (boolean)InvokeDynamicSupport.bootstrap("touchModeDrawsInPressedState", $$robo$$android_widget_ListPopupWindow_DropDownListView$touchModeDrawsInPressedState(), 0, this);
        }

        @Override
        View obtainView(int n, boolean[] blArray) {
            return InvokeDynamicSupport.bootstrap("obtainView", $$robo$$android_widget_ListPopupWindow_DropDownListView$obtainView(int boolean[] ), 0, this, n, blArray);
        }

        @Override
        public boolean isInTouchMode() {
            return (boolean)InvokeDynamicSupport.bootstrap("isInTouchMode", $$robo$$android_widget_ListPopupWindow_DropDownListView$isInTouchMode(), 0, this);
        }

        @Override
        public boolean hasWindowFocus() {
            return (boolean)InvokeDynamicSupport.bootstrap("hasWindowFocus", $$robo$$android_widget_ListPopupWindow_DropDownListView$hasWindowFocus(), 0, this);
        }

        @Override
        public boolean isFocused() {
            return (boolean)InvokeDynamicSupport.bootstrap("isFocused", $$robo$$android_widget_ListPopupWindow_DropDownListView$isFocused(), 0, this);
        }

        @Override
        public boolean hasFocus() {
            return (boolean)InvokeDynamicSupport.bootstrap("hasFocus", $$robo$$android_widget_ListPopupWindow_DropDownListView$hasFocus(), 0, this);
        }

        static {
            RobolectricInternals.classInitializing(DropDownListView.class);
        }

        public /* synthetic */ DropDownListView() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (DropDownListView)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static abstract class ForwardingListener
    implements View.OnTouchListener,
    View.OnAttachStateChangeListener,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private float mScaledTouchSlop;
        private int mTapTimeout;
        private int mLongPressTimeout;
        private View mSrc;
        private Runnable mDisallowIntercept;
        private Runnable mTriggerLongPress;
        private boolean mForwarding;
        private boolean mWasLongPress;
        private int mActivePointerId;

        private void $$robo$$android_widget_ListPopupWindow_ForwardingListener$__constructor__(View src) {
            this.mSrc = src;
            this.mScaledTouchSlop = ViewConfiguration.get(src.getContext()).getScaledTouchSlop();
            this.mTapTimeout = ViewConfiguration.getTapTimeout();
            this.mLongPressTimeout = (this.mTapTimeout + ViewConfiguration.getLongPressTimeout()) / 2;
            src.addOnAttachStateChangeListener(this);
        }

        public abstract ListPopupWindow getPopup();

        private final boolean $$robo$$android_widget_ListPopupWindow_ForwardingListener$onTouch(View v, MotionEvent event) {
            boolean forwarding;
            boolean wasForwarding = this.mForwarding;
            if (wasForwarding) {
                forwarding = this.mWasLongPress ? this.onTouchForwarded(event) : this.onTouchForwarded(event) || !this.onForwardingStopped();
            } else {
                boolean bl = forwarding = this.onTouchObserved(event) && this.onForwardingStarted();
                if (forwarding) {
                    long now = SystemClock.uptimeMillis();
                    MotionEvent e = MotionEvent.obtain(now, now, 3, 0.0f, 0.0f, 0);
                    this.mSrc.onTouchEvent(e);
                    e.recycle();
                }
            }
            this.mForwarding = forwarding;
            return forwarding || wasForwarding;
        }

        private final void $$robo$$android_widget_ListPopupWindow_ForwardingListener$onViewAttachedToWindow(View v) {
        }

        private final void $$robo$$android_widget_ListPopupWindow_ForwardingListener$onViewDetachedFromWindow(View v) {
            this.mForwarding = false;
            this.mActivePointerId = -1;
            if (this.mDisallowIntercept != null) {
                this.mSrc.removeCallbacks(this.mDisallowIntercept);
            }
        }

        private final boolean $$robo$$android_widget_ListPopupWindow_ForwardingListener$onForwardingStarted() {
            ListPopupWindow popup = this.getPopup();
            if (popup != null && !popup.isShowing()) {
                popup.show();
            }
            return true;
        }

        private final boolean $$robo$$android_widget_ListPopupWindow_ForwardingListener$onForwardingStopped() {
            ListPopupWindow popup = this.getPopup();
            if (popup != null && popup.isShowing()) {
                popup.dismiss();
            }
            return true;
        }

        private final boolean $$robo$$android_widget_ListPopupWindow_ForwardingListener$onTouchObserved(MotionEvent srcEvent) {
            View src = this.mSrc;
            if (!src.isEnabled()) {
                return false;
            }
            int actionMasked = srcEvent.getActionMasked();
            switch (actionMasked) {
                case 0: {
                    this.mActivePointerId = srcEvent.getPointerId(0);
                    this.mWasLongPress = false;
                    if (this.mDisallowIntercept == null) {
                        this.mDisallowIntercept = new DisallowIntercept(this);
                    }
                    src.postDelayed(this.mDisallowIntercept, this.mTapTimeout);
                    if (this.mTriggerLongPress == null) {
                        this.mTriggerLongPress = new TriggerLongPress(this);
                    }
                    src.postDelayed(this.mTriggerLongPress, this.mLongPressTimeout);
                    break;
                }
                case 2: {
                    float y;
                    float x;
                    int activePointerIndex = srcEvent.findPointerIndex(this.mActivePointerId);
                    if (activePointerIndex < 0 || src.pointInView(x = srcEvent.getX(activePointerIndex), y = srcEvent.getY(activePointerIndex), this.mScaledTouchSlop)) break;
                    this.clearCallbacks();
                    src.getParent().requestDisallowInterceptTouchEvent(true);
                    return true;
                }
                case 1: 
                case 3: {
                    this.clearCallbacks();
                }
            }
            return false;
        }

        private final void $$robo$$android_widget_ListPopupWindow_ForwardingListener$clearCallbacks() {
            if (this.mTriggerLongPress != null) {
                this.mSrc.removeCallbacks(this.mTriggerLongPress);
            }
            if (this.mDisallowIntercept != null) {
                this.mSrc.removeCallbacks(this.mDisallowIntercept);
            }
        }

        private final void $$robo$$android_widget_ListPopupWindow_ForwardingListener$onLongPress() {
            this.clearCallbacks();
            View src = this.mSrc;
            if (!src.isEnabled()) {
                return;
            }
            if (!this.onForwardingStarted()) {
                return;
            }
            this.mSrc.getParent().requestDisallowInterceptTouchEvent(true);
            long now = SystemClock.uptimeMillis();
            MotionEvent e = MotionEvent.obtain(now, now, 3, 0.0f, 0.0f, 0);
            this.mSrc.onTouchEvent(e);
            e.recycle();
            this.mForwarding = true;
            this.mWasLongPress = true;
        }

        private final boolean $$robo$$android_widget_ListPopupWindow_ForwardingListener$onTouchForwarded(MotionEvent srcEvent) {
            View src = this.mSrc;
            ListPopupWindow popup = this.getPopup();
            if (popup == null || !popup.isShowing()) {
                return false;
            }
            DropDownListView dst = popup.mDropDownList;
            if (dst == null || !dst.isShown()) {
                return false;
            }
            MotionEvent dstEvent = MotionEvent.obtainNoHistory(srcEvent);
            src.toGlobalMotionEvent(dstEvent);
            dst.toLocalMotionEvent(dstEvent);
            boolean handled = dst.onForwardedEvent(dstEvent, this.mActivePointerId);
            dstEvent.recycle();
            int action = srcEvent.getActionMasked();
            boolean keepForwarding = action != 1 && action != 3;
            return handled && keepForwarding;
        }

        private void __constructor__(View view) {
            this.$$robo$$android_widget_ListPopupWindow_ForwardingListener$__constructor__(view);
        }

        public ForwardingListener(View view) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_ListPopupWindow_ForwardingListener$__constructor__(android.view.View ), 0, this, view);
        }

        @Override
        public boolean onTouch(View view, MotionEvent motionEvent) {
            return (boolean)InvokeDynamicSupport.bootstrap("onTouch", $$robo$$android_widget_ListPopupWindow_ForwardingListener$onTouch(android.view.View android.view.MotionEvent ), 0, this, view, motionEvent);
        }

        @Override
        public void onViewAttachedToWindow(View view) {
            InvokeDynamicSupport.bootstrap("onViewAttachedToWindow", $$robo$$android_widget_ListPopupWindow_ForwardingListener$onViewAttachedToWindow(android.view.View ), 0, this, view);
        }

        @Override
        public void onViewDetachedFromWindow(View view) {
            InvokeDynamicSupport.bootstrap("onViewDetachedFromWindow", $$robo$$android_widget_ListPopupWindow_ForwardingListener$onViewDetachedFromWindow(android.view.View ), 0, this, view);
        }

        protected boolean onForwardingStarted() {
            return (boolean)InvokeDynamicSupport.bootstrap("onForwardingStarted", $$robo$$android_widget_ListPopupWindow_ForwardingListener$onForwardingStarted(), 0, this);
        }

        protected boolean onForwardingStopped() {
            return (boolean)InvokeDynamicSupport.bootstrap("onForwardingStopped", $$robo$$android_widget_ListPopupWindow_ForwardingListener$onForwardingStopped(), 0, this);
        }

        private boolean onTouchObserved(MotionEvent motionEvent) {
            return (boolean)InvokeDynamicSupport.bootstrap("onTouchObserved", $$robo$$android_widget_ListPopupWindow_ForwardingListener$onTouchObserved(android.view.MotionEvent ), 0, this, motionEvent);
        }

        private void clearCallbacks() {
            InvokeDynamicSupport.bootstrap("clearCallbacks", $$robo$$android_widget_ListPopupWindow_ForwardingListener$clearCallbacks(), 0, this);
        }

        private void onLongPress() {
            InvokeDynamicSupport.bootstrap("onLongPress", $$robo$$android_widget_ListPopupWindow_ForwardingListener$onLongPress(), 0, this);
        }

        private boolean onTouchForwarded(MotionEvent motionEvent) {
            return (boolean)InvokeDynamicSupport.bootstrap("onTouchForwarded", $$robo$$android_widget_ListPopupWindow_ForwardingListener$onTouchForwarded(android.view.MotionEvent ), 0, this, motionEvent);
        }

        public /* synthetic */ ForwardingListener() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ForwardingListener)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }

        private class TriggerLongPress
        implements Runnable,
        ShadowedObject {
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ ForwardingListener this$0;

            private void $$robo$$android_widget_ListPopupWindow_ForwardingListener_TriggerLongPress$__constructor__(ForwardingListener forwardingListener) {
            }

            private final void $$robo$$android_widget_ListPopupWindow_ForwardingListener_TriggerLongPress$run() {
                this.this$0.onLongPress();
            }

            private /* synthetic */ void $$robo$$android_widget_ListPopupWindow_ForwardingListener_TriggerLongPress$__constructor__(ForwardingListener x0, 1 x1) {
            }

            private void __constructor__(ForwardingListener forwardingListener) {
                this.$$robo$$android_widget_ListPopupWindow_ForwardingListener_TriggerLongPress$__constructor__(forwardingListener);
            }

            private TriggerLongPress(ForwardingListener forwardingListener) {
                this.this$0 = forwardingListener;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_ListPopupWindow_ForwardingListener_TriggerLongPress$__constructor__(android.widget.ListPopupWindow$ForwardingListener ), 0, this, forwardingListener);
            }

            @Override
            public void run() {
                InvokeDynamicSupport.bootstrap("run", $$robo$$android_widget_ListPopupWindow_ForwardingListener_TriggerLongPress$run(), 0, this);
            }

            private /* synthetic */ void __constructor__(ForwardingListener forwardingListener, 1 var2_2) {
                this.$$robo$$android_widget_ListPopupWindow_ForwardingListener_TriggerLongPress$__constructor__(forwardingListener, var2_2);
            }

            public /* synthetic */ TriggerLongPress() {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (TriggerLongPress)this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        }

        private class DisallowIntercept
        implements Runnable,
        ShadowedObject {
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ ForwardingListener this$0;

            private void $$robo$$android_widget_ListPopupWindow_ForwardingListener_DisallowIntercept$__constructor__(ForwardingListener forwardingListener) {
            }

            private final void $$robo$$android_widget_ListPopupWindow_ForwardingListener_DisallowIntercept$run() {
                ViewParent parent = this.this$0.mSrc.getParent();
                parent.requestDisallowInterceptTouchEvent(true);
            }

            private /* synthetic */ void $$robo$$android_widget_ListPopupWindow_ForwardingListener_DisallowIntercept$__constructor__(ForwardingListener x0, 1 x1) {
            }

            private void __constructor__(ForwardingListener forwardingListener) {
                this.$$robo$$android_widget_ListPopupWindow_ForwardingListener_DisallowIntercept$__constructor__(forwardingListener);
            }

            private DisallowIntercept(ForwardingListener forwardingListener) {
                this.this$0 = forwardingListener;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_ListPopupWindow_ForwardingListener_DisallowIntercept$__constructor__(android.widget.ListPopupWindow$ForwardingListener ), 0, this, forwardingListener);
            }

            @Override
            public void run() {
                InvokeDynamicSupport.bootstrap("run", $$robo$$android_widget_ListPopupWindow_ForwardingListener_DisallowIntercept$run(), 0, this);
            }

            private /* synthetic */ void __constructor__(ForwardingListener forwardingListener, 1 var2_2) {
                this.$$robo$$android_widget_ListPopupWindow_ForwardingListener_DisallowIntercept$__constructor__(forwardingListener, var2_2);
            }

            public /* synthetic */ DisallowIntercept() {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (DisallowIntercept)this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        }
    }
}

