/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.StateListDrawable;
import android.os.IBinder;
import android.util.AttributeSet;
import android.view.Gravity;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.view.WindowManager;
import android.widget.FrameLayout;
import com.android.internal.R;
import java.lang.ref.WeakReference;
import org.robolectric.internal.bytecode.InstrumentedInterface;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class PopupWindow
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    public static int INPUT_METHOD_FROM_FOCUSABLE = 0;
    public static int INPUT_METHOD_NEEDED = 1;
    public static int INPUT_METHOD_NOT_NEEDED = 2;
    private static int DEFAULT_ANCHORED_GRAVITY = 0x800033;
    private Context mContext;
    private WindowManager mWindowManager;
    private boolean mIsShowing;
    private boolean mIsDropdown;
    private View mContentView;
    private View mPopupView;
    private boolean mFocusable;
    private int mInputMethodMode;
    private int mSoftInputMode;
    private boolean mTouchable;
    private boolean mOutsideTouchable;
    private boolean mClippingEnabled;
    private int mSplitTouchEnabled;
    private boolean mLayoutInScreen;
    private boolean mClipToScreen;
    private boolean mAllowScrollingAnchorParent;
    private boolean mLayoutInsetDecor;
    private boolean mNotTouchModal;
    private View.OnTouchListener mTouchInterceptor;
    private int mWidthMode;
    private int mWidth;
    private int mLastWidth;
    private int mHeightMode;
    private int mHeight;
    private int mLastHeight;
    private int mPopupWidth;
    private int mPopupHeight;
    private float mElevation;
    private int[] mDrawingLocation;
    private int[] mScreenLocation;
    private Rect mTempRect;
    private Drawable mBackground;
    private Drawable mAboveAnchorBackgroundDrawable;
    private Drawable mBelowAnchorBackgroundDrawable;
    private int mAnchorRelativeX;
    private int mAnchorRelativeY;
    private boolean mAboveAnchor;
    private int mWindowLayoutType;
    private OnDismissListener mOnDismissListener;
    private boolean mIgnoreCheekPress;
    private int mAnimationStyle;
    private static int[] ABOVE_ANCHOR_STATE_SET;
    private WeakReference<View> mAnchor;
    private ViewTreeObserver.OnScrollChangedListener mOnScrollChangedListener;
    private int mAnchorXoff;
    private int mAnchorYoff;
    private int mAnchoredGravity;
    private boolean mOverlapAnchor;
    private boolean mPopupViewInitialLayoutDirectionInherited;

    private void $$robo$$android_widget_PopupWindow$__constructor__(Context context) {
    }

    private void $$robo$$android_widget_PopupWindow$__constructor__(Context context, AttributeSet attrs) {
    }

    private void $$robo$$android_widget_PopupWindow$__constructor__(Context context, AttributeSet attrs, int defStyleAttr) {
    }

    private void $$robo$$android_widget_PopupWindow$__constructor__(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        this.mInputMethodMode = 0;
        this.mSoftInputMode = 1;
        this.mTouchable = true;
        this.mOutsideTouchable = false;
        this.mClippingEnabled = true;
        this.mSplitTouchEnabled = -1;
        this.mAllowScrollingAnchorParent = true;
        this.mLayoutInsetDecor = false;
        this.mDrawingLocation = new int[2];
        this.mScreenLocation = new int[2];
        this.mTempRect = new Rect();
        this.mWindowLayoutType = 1000;
        this.mIgnoreCheekPress = false;
        this.mAnimationStyle = -1;
        this.mOnScrollChangedListener = new ViewTreeObserver.OnScrollChangedListener(this){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ PopupWindow this$0;

            private void $$robo$$android_widget_PopupWindow_1$__constructor__(PopupWindow popupWindow) {
            }

            private final void $$robo$$android_widget_PopupWindow_1$onScrollChanged() {
                View anchor;
                View view = anchor = this.this$0.mAnchor != null ? (View)this.this$0.mAnchor.get() : null;
                if (anchor != null && this.this$0.mPopupView != null) {
                    WindowManager.LayoutParams p = (WindowManager.LayoutParams)this.this$0.mPopupView.getLayoutParams();
                    this.this$0.updateAboveAnchor(this.this$0.findDropDownPosition(anchor, p, this.this$0.mAnchorXoff, this.this$0.mAnchorYoff, this.this$0.mAnchoredGravity));
                    this.this$0.update(p.x, p.y, -1, -1, true);
                }
            }

            private void __constructor__(PopupWindow popupWindow) {
                this.$$robo$$android_widget_PopupWindow_1$__constructor__(popupWindow);
            }
            {
                this.this$0 = popupWindow;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_PopupWindow_1$__constructor__(android.widget.PopupWindow ), 0, this, popupWindow);
            }

            @Override
            public void onScrollChanged() {
                InvokeDynamicSupport.bootstrap("onScrollChanged", $$robo$$android_widget_PopupWindow_1$onScrollChanged(), 0, this);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.mContext = context;
        this.mWindowManager = (WindowManager)context.getSystemService("window");
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.PopupWindow, defStyleAttr, defStyleRes);
        this.mBackground = a.getDrawable(0);
        this.mElevation = a.getDimension(3, 0.0f);
        this.mOverlapAnchor = a.getBoolean(2, false);
        int animStyle = a.getResourceId(1, -1);
        int n = this.mAnimationStyle = animStyle == 16974564 ? -1 : animStyle;
        if (this.mBackground instanceof StateListDrawable) {
            StateListDrawable background = (StateListDrawable)this.mBackground;
            int aboveAnchorStateIndex = background.getStateDrawableIndex(ABOVE_ANCHOR_STATE_SET);
            int count = background.getStateCount();
            int belowAnchorStateIndex = -1;
            for (int i = 0; i < count; ++i) {
                if (i == aboveAnchorStateIndex) continue;
                belowAnchorStateIndex = i;
                break;
            }
            if (aboveAnchorStateIndex != -1 && belowAnchorStateIndex != -1) {
                this.mAboveAnchorBackgroundDrawable = background.getStateDrawable(aboveAnchorStateIndex);
                this.mBelowAnchorBackgroundDrawable = background.getStateDrawable(belowAnchorStateIndex);
            } else {
                this.mBelowAnchorBackgroundDrawable = null;
                this.mAboveAnchorBackgroundDrawable = null;
            }
        }
        a.recycle();
    }

    private void $$robo$$android_widget_PopupWindow$__constructor__() {
    }

    private void $$robo$$android_widget_PopupWindow$__constructor__(View contentView) {
    }

    private void $$robo$$android_widget_PopupWindow$__constructor__(int width, int height) {
    }

    private void $$robo$$android_widget_PopupWindow$__constructor__(View contentView, int width, int height) {
    }

    private void $$robo$$android_widget_PopupWindow$__constructor__(View contentView, int width, int height, boolean focusable) {
        this.mInputMethodMode = 0;
        this.mSoftInputMode = 1;
        this.mTouchable = true;
        this.mOutsideTouchable = false;
        this.mClippingEnabled = true;
        this.mSplitTouchEnabled = -1;
        this.mAllowScrollingAnchorParent = true;
        this.mLayoutInsetDecor = false;
        this.mDrawingLocation = new int[2];
        this.mScreenLocation = new int[2];
        this.mTempRect = new Rect();
        this.mWindowLayoutType = 1000;
        this.mIgnoreCheekPress = false;
        this.mAnimationStyle = -1;
        this.mOnScrollChangedListener = new /* invalid duplicate definition of identical inner class */;
        if (contentView != null) {
            this.mContext = contentView.getContext();
            this.mWindowManager = (WindowManager)this.mContext.getSystemService("window");
        }
        this.setContentView(contentView);
        this.setWidth(width);
        this.setHeight(height);
        this.setFocusable(focusable);
    }

    private final Drawable $$robo$$android_widget_PopupWindow$getBackground() {
        return this.mBackground;
    }

    private final void $$robo$$android_widget_PopupWindow$setBackgroundDrawable(Drawable background) {
        this.mBackground = background;
    }

    private final float $$robo$$android_widget_PopupWindow$getElevation() {
        return this.mElevation;
    }

    private final void $$robo$$android_widget_PopupWindow$setElevation(float elevation) {
        this.mElevation = elevation;
    }

    private final int $$robo$$android_widget_PopupWindow$getAnimationStyle() {
        return this.mAnimationStyle;
    }

    private final void $$robo$$android_widget_PopupWindow$setIgnoreCheekPress() {
        this.mIgnoreCheekPress = true;
    }

    private final void $$robo$$android_widget_PopupWindow$setAnimationStyle(int animationStyle) {
        this.mAnimationStyle = animationStyle;
    }

    private final View $$robo$$android_widget_PopupWindow$getContentView() {
        return this.mContentView;
    }

    private final void $$robo$$android_widget_PopupWindow$setContentView(View contentView) {
        if (this.isShowing()) {
            return;
        }
        this.mContentView = contentView;
        if (this.mContext == null && this.mContentView != null) {
            this.mContext = this.mContentView.getContext();
        }
        if (this.mWindowManager == null && this.mContentView != null) {
            this.mWindowManager = (WindowManager)this.mContext.getSystemService("window");
        }
    }

    private final void $$robo$$android_widget_PopupWindow$setTouchInterceptor(View.OnTouchListener l) {
        this.mTouchInterceptor = l;
    }

    private final boolean $$robo$$android_widget_PopupWindow$isFocusable() {
        return this.mFocusable;
    }

    private final void $$robo$$android_widget_PopupWindow$setFocusable(boolean focusable) {
        this.mFocusable = focusable;
    }

    private final int $$robo$$android_widget_PopupWindow$getInputMethodMode() {
        return this.mInputMethodMode;
    }

    private final void $$robo$$android_widget_PopupWindow$setInputMethodMode(int mode) {
        this.mInputMethodMode = mode;
    }

    private final void $$robo$$android_widget_PopupWindow$setSoftInputMode(int mode) {
        this.mSoftInputMode = mode;
    }

    private final int $$robo$$android_widget_PopupWindow$getSoftInputMode() {
        return this.mSoftInputMode;
    }

    private final boolean $$robo$$android_widget_PopupWindow$isTouchable() {
        return this.mTouchable;
    }

    private final void $$robo$$android_widget_PopupWindow$setTouchable(boolean touchable) {
        this.mTouchable = touchable;
    }

    private final boolean $$robo$$android_widget_PopupWindow$isOutsideTouchable() {
        return this.mOutsideTouchable;
    }

    private final void $$robo$$android_widget_PopupWindow$setOutsideTouchable(boolean touchable) {
        this.mOutsideTouchable = touchable;
    }

    private final boolean $$robo$$android_widget_PopupWindow$isClippingEnabled() {
        return this.mClippingEnabled;
    }

    private final void $$robo$$android_widget_PopupWindow$setClippingEnabled(boolean enabled) {
        this.mClippingEnabled = enabled;
    }

    private final void $$robo$$android_widget_PopupWindow$setClipToScreenEnabled(boolean enabled) {
        this.mClipToScreen = enabled;
        this.setClippingEnabled(!enabled);
    }

    private final void $$robo$$android_widget_PopupWindow$setAllowScrollingAnchorParent(boolean enabled) {
        this.mAllowScrollingAnchorParent = enabled;
    }

    private final boolean $$robo$$android_widget_PopupWindow$isSplitTouchEnabled() {
        if (this.mSplitTouchEnabled < 0 && this.mContext != null) {
            return this.mContext.getApplicationInfo().targetSdkVersion >= 11;
        }
        return this.mSplitTouchEnabled == 1;
    }

    private final void $$robo$$android_widget_PopupWindow$setSplitTouchEnabled(boolean enabled) {
        this.mSplitTouchEnabled = enabled ? 1 : 0;
    }

    private final boolean $$robo$$android_widget_PopupWindow$isLayoutInScreenEnabled() {
        return this.mLayoutInScreen;
    }

    private final void $$robo$$android_widget_PopupWindow$setLayoutInScreenEnabled(boolean enabled) {
        this.mLayoutInScreen = enabled;
    }

    private final void $$robo$$android_widget_PopupWindow$setLayoutInsetDecor(boolean enabled) {
        this.mLayoutInsetDecor = enabled;
    }

    private final void $$robo$$android_widget_PopupWindow$setWindowLayoutType(int layoutType) {
        this.mWindowLayoutType = layoutType;
    }

    private final int $$robo$$android_widget_PopupWindow$getWindowLayoutType() {
        return this.mWindowLayoutType;
    }

    private final void $$robo$$android_widget_PopupWindow$setTouchModal(boolean touchModal) {
        this.mNotTouchModal = !touchModal;
    }

    private final void $$robo$$android_widget_PopupWindow$setWindowLayoutMode(int widthSpec, int heightSpec) {
        this.mWidthMode = widthSpec;
        this.mHeightMode = heightSpec;
    }

    private final int $$robo$$android_widget_PopupWindow$getHeight() {
        return this.mHeight;
    }

    private final void $$robo$$android_widget_PopupWindow$setHeight(int height) {
        this.mHeight = height;
    }

    private final int $$robo$$android_widget_PopupWindow$getWidth() {
        return this.mWidth;
    }

    private final void $$robo$$android_widget_PopupWindow$setWidth(int width) {
        this.mWidth = width;
    }

    private final boolean $$robo$$android_widget_PopupWindow$isShowing() {
        return this.mIsShowing;
    }

    private final void $$robo$$android_widget_PopupWindow$showAtLocation(View parent, int gravity, int x, int y) {
        this.showAtLocation(parent.getWindowToken(), gravity, x, y);
    }

    private final void $$robo$$android_widget_PopupWindow$showAtLocation(IBinder token, int gravity, int x, int y) {
        if (this.isShowing() || this.mContentView == null) {
            return;
        }
        this.unregisterForScrollChanged();
        this.mIsShowing = true;
        this.mIsDropdown = false;
        WindowManager.LayoutParams p = this.createPopupLayout(token);
        p.windowAnimations = this.computeAnimationResource();
        this.preparePopup(p);
        if (gravity == 0) {
            gravity = 0x800033;
        }
        p.gravity = gravity;
        p.x = x;
        p.y = y;
        if (this.mHeightMode < 0) {
            p.height = this.mLastHeight = this.mHeightMode;
        }
        if (this.mWidthMode < 0) {
            p.width = this.mLastWidth = this.mWidthMode;
        }
        this.invokePopup(p);
    }

    private final void $$robo$$android_widget_PopupWindow$showAsDropDown(View anchor) {
        this.showAsDropDown(anchor, 0, 0);
    }

    private final void $$robo$$android_widget_PopupWindow$showAsDropDown(View anchor, int xoff, int yoff) {
        this.showAsDropDown(anchor, xoff, yoff, 0x800033);
    }

    private final void $$robo$$android_widget_PopupWindow$showAsDropDown(View anchor, int xoff, int yoff, int gravity) {
        if (this.isShowing() || this.mContentView == null) {
            return;
        }
        this.registerForScrollChanged(anchor, xoff, yoff, gravity);
        this.mIsShowing = true;
        this.mIsDropdown = true;
        WindowManager.LayoutParams p = this.createPopupLayout(anchor.getWindowToken());
        this.preparePopup(p);
        this.updateAboveAnchor(this.findDropDownPosition(anchor, p, xoff, yoff, gravity));
        if (this.mHeightMode < 0) {
            p.height = this.mLastHeight = this.mHeightMode;
        }
        if (this.mWidthMode < 0) {
            p.width = this.mLastWidth = this.mWidthMode;
        }
        p.windowAnimations = this.computeAnimationResource();
        this.invokePopup(p);
    }

    private final void $$robo$$android_widget_PopupWindow$updateAboveAnchor(boolean aboveAnchor) {
        if (aboveAnchor != this.mAboveAnchor) {
            this.mAboveAnchor = aboveAnchor;
            if (this.mBackground != null) {
                if (this.mAboveAnchorBackgroundDrawable != null) {
                    if (this.mAboveAnchor) {
                        this.mPopupView.setBackground(this.mAboveAnchorBackgroundDrawable);
                    } else {
                        this.mPopupView.setBackground(this.mBelowAnchorBackgroundDrawable);
                    }
                } else {
                    this.mPopupView.refreshDrawableState();
                }
            }
        }
    }

    private final boolean $$robo$$android_widget_PopupWindow$isAboveAnchor() {
        return this.mAboveAnchor;
    }

    private final void $$robo$$android_widget_PopupWindow$preparePopup(WindowManager.LayoutParams p) {
        if (this.mContentView == null || this.mContext == null || this.mWindowManager == null) {
            throw new IllegalStateException("You must specify a valid content view by calling setContentView() before attempting to show the popup.");
        }
        if (this.mBackground != null) {
            ViewGroup.LayoutParams layoutParams = this.mContentView.getLayoutParams();
            int height = -1;
            if (layoutParams != null && layoutParams.height == -2) {
                height = -2;
            }
            PopupViewContainer popupViewContainer = new PopupViewContainer(this, this.mContext);
            FrameLayout.LayoutParams listParams = new FrameLayout.LayoutParams(-1, height);
            popupViewContainer.setBackground(this.mBackground);
            popupViewContainer.addView(this.mContentView, listParams);
            this.mPopupView = popupViewContainer;
        } else {
            this.mPopupView = this.mContentView;
        }
        this.mPopupView.setElevation(this.mElevation);
        this.mPopupViewInitialLayoutDirectionInherited = this.mPopupView.getRawLayoutDirection() == 2;
        this.mPopupWidth = p.width;
        this.mPopupHeight = p.height;
    }

    private final void $$robo$$android_widget_PopupWindow$invokePopup(WindowManager.LayoutParams p) {
        if (this.mContext != null) {
            p.packageName = this.mContext.getPackageName();
        }
        this.mPopupView.setFitsSystemWindows(this.mLayoutInsetDecor);
        this.setLayoutDirectionFromAnchor();
        this.mWindowManager.addView(this.mPopupView, p);
    }

    private final void $$robo$$android_widget_PopupWindow$setLayoutDirectionFromAnchor() {
        View anchor;
        if (this.mAnchor != null && (anchor = (View)this.mAnchor.get()) != null && this.mPopupViewInitialLayoutDirectionInherited) {
            this.mPopupView.setLayoutDirection(anchor.getLayoutDirection());
        }
    }

    private final WindowManager.LayoutParams $$robo$$android_widget_PopupWindow$createPopupLayout(IBinder token) {
        WindowManager.LayoutParams p = new WindowManager.LayoutParams();
        p.gravity = 0x800033;
        p.width = this.mLastWidth = this.mWidth;
        p.height = this.mLastHeight = this.mHeight;
        p.format = this.mBackground != null ? this.mBackground.getOpacity() : -3;
        p.flags = this.computeFlags(p.flags);
        p.type = this.mWindowLayoutType;
        p.token = token;
        p.softInputMode = this.mSoftInputMode;
        p.setTitle("PopupWindow:" + Integer.toHexString(this.hashCode()));
        return p;
    }

    private final int $$robo$$android_widget_PopupWindow$computeFlags(int curFlags) {
        curFlags &= 0xFF797DE7;
        if (this.mIgnoreCheekPress) {
            curFlags |= 0x8000;
        }
        if (!this.mFocusable) {
            curFlags |= 8;
            if (this.mInputMethodMode == 1) {
                curFlags |= 0x20000;
            }
        } else if (this.mInputMethodMode == 2) {
            curFlags |= 0x20000;
        }
        if (!this.mTouchable) {
            curFlags |= 0x10;
        }
        if (this.mOutsideTouchable) {
            curFlags |= 0x40000;
        }
        if (!this.mClippingEnabled) {
            curFlags |= 0x200;
        }
        if (this.isSplitTouchEnabled()) {
            curFlags |= 0x800000;
        }
        if (this.mLayoutInScreen) {
            curFlags |= 0x100;
        }
        if (this.mLayoutInsetDecor) {
            curFlags |= 0x10000;
        }
        if (this.mNotTouchModal) {
            curFlags |= 0x20;
        }
        return curFlags;
    }

    private final int $$robo$$android_widget_PopupWindow$computeAnimationResource() {
        if (this.mAnimationStyle == -1) {
            if (this.mIsDropdown) {
                return this.mAboveAnchor ? 16974556 : 16974555;
            }
            return 0;
        }
        return this.mAnimationStyle;
    }

    private final boolean $$robo$$android_widget_PopupWindow$findDropDownPosition(View anchor, WindowManager.LayoutParams p, int xoff, int yoff, int gravity) {
        int anchorHeight = anchor.getHeight();
        int anchorWidth = anchor.getWidth();
        if (this.mOverlapAnchor) {
            yoff -= anchorHeight;
        }
        anchor.getLocationInWindow(this.mDrawingLocation);
        p.x = this.mDrawingLocation[0] + xoff;
        p.y = this.mDrawingLocation[1] + anchorHeight + yoff;
        int hgrav = Gravity.getAbsoluteGravity(gravity, anchor.getLayoutDirection()) & 7;
        if (hgrav == 5) {
            p.x -= this.mPopupWidth - anchorWidth;
        }
        boolean onTop = false;
        p.gravity = 51;
        anchor.getLocationOnScreen(this.mScreenLocation);
        Rect displayFrame = new Rect();
        anchor.getWindowVisibleDisplayFrame(displayFrame);
        int screenY = this.mScreenLocation[1] + anchorHeight + yoff;
        View root = anchor.getRootView();
        if (screenY + this.mPopupHeight > displayFrame.bottom || p.x + this.mPopupWidth - root.getWidth() > 0) {
            if (this.mAllowScrollingAnchorParent) {
                int scrollX = anchor.getScrollX();
                int scrollY = anchor.getScrollY();
                Rect r = new Rect(scrollX, scrollY, scrollX + this.mPopupWidth + xoff, scrollY + this.mPopupHeight + anchorHeight + yoff);
                anchor.requestRectangleOnScreen(r, true);
            }
            anchor.getLocationInWindow(this.mDrawingLocation);
            p.x = this.mDrawingLocation[0] + xoff;
            p.y = this.mDrawingLocation[1] + anchorHeight + yoff;
            if (hgrav == 5) {
                p.x -= this.mPopupWidth - anchorWidth;
            }
            anchor.getLocationOnScreen(this.mScreenLocation);
            boolean bl = onTop = displayFrame.bottom - this.mScreenLocation[1] - anchorHeight - yoff < this.mScreenLocation[1] - yoff - displayFrame.top;
            if (onTop) {
                p.gravity = 83;
                p.y = root.getHeight() - this.mDrawingLocation[1] + yoff;
            } else {
                p.y = this.mDrawingLocation[1] + anchorHeight + yoff;
            }
        }
        if (this.mClipToScreen) {
            int right = p.x + p.width;
            int displayFrameWidth = displayFrame.right - displayFrame.left;
            if (right > displayFrameWidth) {
                p.x -= right - displayFrameWidth;
            }
            if (p.x < displayFrame.left) {
                p.x = displayFrame.left;
                p.width = Math.min(p.width, displayFrameWidth);
            }
            if (onTop) {
                int popupTop = this.mScreenLocation[1] + yoff - this.mPopupHeight;
                if (popupTop < 0) {
                    p.y += popupTop;
                }
            } else {
                p.y = Math.max(p.y, displayFrame.top);
            }
        }
        p.gravity |= 0x10000000;
        this.mAnchorRelativeX = this.mDrawingLocation[0] - p.x + anchorHeight / 2;
        this.mAnchorRelativeY = this.mDrawingLocation[1] - p.y + anchorWidth / 2;
        return onTop;
    }

    private final int $$robo$$android_widget_PopupWindow$getMaxAvailableHeight(View anchor) {
        return this.getMaxAvailableHeight(anchor, 0);
    }

    private final int $$robo$$android_widget_PopupWindow$getMaxAvailableHeight(View anchor, int yOffset) {
        return this.getMaxAvailableHeight(anchor, yOffset, false);
    }

    private final int $$robo$$android_widget_PopupWindow$getMaxAvailableHeight(View anchor, int yOffset, boolean ignoreBottomDecorations) {
        Rect displayFrame = new Rect();
        anchor.getWindowVisibleDisplayFrame(displayFrame);
        int[] anchorPos = this.mDrawingLocation;
        anchor.getLocationOnScreen(anchorPos);
        int bottomEdge = displayFrame.bottom;
        if (ignoreBottomDecorations) {
            Resources res = anchor.getContext().getResources();
            bottomEdge = res.getDisplayMetrics().heightPixels;
        }
        int distanceToBottom = bottomEdge - (anchorPos[1] + anchor.getHeight()) - yOffset;
        int distanceToTop = anchorPos[1] - displayFrame.top + yOffset;
        int returnedHeight = Math.max(distanceToBottom, distanceToTop);
        if (this.mBackground != null) {
            this.mBackground.getPadding(this.mTempRect);
            returnedHeight -= this.mTempRect.top + this.mTempRect.bottom;
        }
        return returnedHeight;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_widget_PopupWindow$dismiss() {
        if (this.isShowing() && this.mPopupView != null) {
            this.mIsShowing = false;
            this.unregisterForScrollChanged();
            try {
                this.mWindowManager.removeViewImmediate(this.mPopupView);
            }
            finally {
                if (this.mPopupView != this.mContentView && this.mPopupView instanceof ViewGroup) {
                    ((ViewGroup)this.mPopupView).removeView(this.mContentView);
                }
                this.mPopupView = null;
                if (this.mOnDismissListener != null) {
                    this.mOnDismissListener.onDismiss();
                }
            }
        }
    }

    private final void $$robo$$android_widget_PopupWindow$setOnDismissListener(OnDismissListener onDismissListener) {
        this.mOnDismissListener = onDismissListener;
    }

    private final void $$robo$$android_widget_PopupWindow$update() {
        int newFlags;
        if (!this.isShowing() || this.mContentView == null) {
            return;
        }
        WindowManager.LayoutParams p = (WindowManager.LayoutParams)this.mPopupView.getLayoutParams();
        boolean update = false;
        int newAnim = this.computeAnimationResource();
        if (newAnim != p.windowAnimations) {
            p.windowAnimations = newAnim;
            update = true;
        }
        if ((newFlags = this.computeFlags(p.flags)) != p.flags) {
            p.flags = newFlags;
            update = true;
        }
        if (update) {
            this.setLayoutDirectionFromAnchor();
            this.mWindowManager.updateViewLayout(this.mPopupView, p);
        }
    }

    private final void $$robo$$android_widget_PopupWindow$update(int width, int height) {
        WindowManager.LayoutParams p = (WindowManager.LayoutParams)this.mPopupView.getLayoutParams();
        this.update(p.x, p.y, width, height, false);
    }

    private final void $$robo$$android_widget_PopupWindow$update(int x, int y, int width, int height) {
        this.update(x, y, width, height, false);
    }

    private final void $$robo$$android_widget_PopupWindow$update(int x, int y, int width, int height, boolean force) {
        int newFlags;
        int newAnim;
        int finalHeight;
        int finalWidth;
        if (width != -1) {
            this.mLastWidth = width;
            this.setWidth(width);
        }
        if (height != -1) {
            this.mLastHeight = height;
            this.setHeight(height);
        }
        if (!this.isShowing() || this.mContentView == null) {
            return;
        }
        WindowManager.LayoutParams p = (WindowManager.LayoutParams)this.mPopupView.getLayoutParams();
        boolean update = force;
        int n = finalWidth = this.mWidthMode < 0 ? this.mWidthMode : this.mLastWidth;
        if (width != -1 && p.width != finalWidth) {
            p.width = this.mLastWidth = finalWidth;
            update = true;
        }
        int n2 = finalHeight = this.mHeightMode < 0 ? this.mHeightMode : this.mLastHeight;
        if (height != -1 && p.height != finalHeight) {
            p.height = this.mLastHeight = finalHeight;
            update = true;
        }
        if (p.x != x) {
            p.x = x;
            update = true;
        }
        if (p.y != y) {
            p.y = y;
            update = true;
        }
        if ((newAnim = this.computeAnimationResource()) != p.windowAnimations) {
            p.windowAnimations = newAnim;
            update = true;
        }
        if ((newFlags = this.computeFlags(p.flags)) != p.flags) {
            p.flags = newFlags;
            update = true;
        }
        if (update) {
            this.setLayoutDirectionFromAnchor();
            this.mWindowManager.updateViewLayout(this.mPopupView, p);
        }
    }

    private final void $$robo$$android_widget_PopupWindow$update(View anchor, int width, int height) {
        this.update(anchor, false, 0, 0, true, width, height, this.mAnchoredGravity);
    }

    private final void $$robo$$android_widget_PopupWindow$update(View anchor, int xoff, int yoff, int width, int height) {
        this.update(anchor, true, xoff, yoff, true, width, height, this.mAnchoredGravity);
    }

    private final void $$robo$$android_widget_PopupWindow$update(View anchor, boolean updateLocation, int xoff, int yoff, boolean updateDimension, int width, int height, int gravity) {
        boolean needsUpdate;
        if (!this.isShowing() || this.mContentView == null) {
            return;
        }
        WeakReference<View> oldAnchor = this.mAnchor;
        boolean bl = needsUpdate = updateLocation && (this.mAnchorXoff != xoff || this.mAnchorYoff != yoff);
        if (oldAnchor == null || oldAnchor.get() != anchor || needsUpdate && !this.mIsDropdown) {
            this.registerForScrollChanged(anchor, xoff, yoff, gravity);
        } else if (needsUpdate) {
            this.mAnchorXoff = xoff;
            this.mAnchorYoff = yoff;
            this.mAnchoredGravity = gravity;
        }
        WindowManager.LayoutParams p = (WindowManager.LayoutParams)this.mPopupView.getLayoutParams();
        if (updateDimension) {
            if (width == -1) {
                width = this.mPopupWidth;
            } else {
                this.mPopupWidth = width;
            }
            if (height == -1) {
                height = this.mPopupHeight;
            } else {
                this.mPopupHeight = height;
            }
        }
        int x = p.x;
        int y = p.y;
        if (updateLocation) {
            this.updateAboveAnchor(this.findDropDownPosition(anchor, p, xoff, yoff, gravity));
        } else {
            this.updateAboveAnchor(this.findDropDownPosition(anchor, p, this.mAnchorXoff, this.mAnchorYoff, this.mAnchoredGravity));
        }
        this.update(p.x, p.y, width, height, x != p.x || y != p.y);
    }

    private final void $$robo$$android_widget_PopupWindow$unregisterForScrollChanged() {
        WeakReference<View> anchorRef = this.mAnchor;
        View anchor = null;
        if (anchorRef != null) {
            anchor = (View)anchorRef.get();
        }
        if (anchor != null) {
            ViewTreeObserver vto = anchor.getViewTreeObserver();
            vto.removeOnScrollChangedListener(this.mOnScrollChangedListener);
        }
        this.mAnchor = null;
    }

    private final void $$robo$$android_widget_PopupWindow$registerForScrollChanged(View anchor, int xoff, int yoff, int gravity) {
        this.unregisterForScrollChanged();
        this.mAnchor = new WeakReference<View>(anchor);
        ViewTreeObserver vto = anchor.getViewTreeObserver();
        if (vto != null) {
            vto.addOnScrollChangedListener(this.mOnScrollChangedListener);
        }
        this.mAnchorXoff = xoff;
        this.mAnchorYoff = yoff;
        this.mAnchoredGravity = gravity;
    }

    static void __staticInitializer__() {
        ABOVE_ANCHOR_STATE_SET = new int[]{0x10100AA};
    }

    private void __constructor__(Context context) {
        this.$$robo$$android_widget_PopupWindow$__constructor__(context);
    }

    public PopupWindow(Context context) {
        this(context, null);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_PopupWindow$__constructor__(android.content.Context ), 0, this, context);
    }

    private void __constructor__(Context context, AttributeSet attributeSet) {
        this.$$robo$$android_widget_PopupWindow$__constructor__(context, attributeSet);
    }

    public PopupWindow(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 16842870);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_PopupWindow$__constructor__(android.content.Context android.util.AttributeSet ), 0, this, context, attributeSet);
    }

    private void __constructor__(Context context, AttributeSet attributeSet, int n) {
        this.$$robo$$android_widget_PopupWindow$__constructor__(context, attributeSet, n);
    }

    public PopupWindow(Context context, AttributeSet attributeSet, int n) {
        this(context, attributeSet, n, 0);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_PopupWindow$__constructor__(android.content.Context android.util.AttributeSet int ), 0, this, context, attributeSet, n);
    }

    private void __constructor__(Context context, AttributeSet attributeSet, int n, int n2) {
        this.$$robo$$android_widget_PopupWindow$__constructor__(context, attributeSet, n, n2);
    }

    public PopupWindow(Context context, AttributeSet attributeSet, int n, int n2) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_PopupWindow$__constructor__(android.content.Context android.util.AttributeSet int int ), 0, this, context, attributeSet, n, n2);
    }

    private void __constructor__() {
        this.$$robo$$android_widget_PopupWindow$__constructor__();
    }

    public PopupWindow() {
        this(null, 0, 0);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_PopupWindow$__constructor__(), 0, this);
    }

    private void __constructor__(View view) {
        this.$$robo$$android_widget_PopupWindow$__constructor__(view);
    }

    public PopupWindow(View view) {
        this(view, 0, 0);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_PopupWindow$__constructor__(android.view.View ), 0, this, view);
    }

    private void __constructor__(int n, int n2) {
        this.$$robo$$android_widget_PopupWindow$__constructor__(n, n2);
    }

    public PopupWindow(int n, int n2) {
        this(null, n, n2);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_PopupWindow$__constructor__(int int ), 0, this, n, n2);
    }

    private void __constructor__(View view, int n, int n2) {
        this.$$robo$$android_widget_PopupWindow$__constructor__(view, n, n2);
    }

    public PopupWindow(View view, int n, int n2) {
        this(view, n, n2, false);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_PopupWindow$__constructor__(android.view.View int int ), 0, this, view, n, n2);
    }

    private void __constructor__(View view, int n, int n2, boolean bl) {
        this.$$robo$$android_widget_PopupWindow$__constructor__(view, n, n2, bl);
    }

    public PopupWindow(View view, int n, int n2, boolean bl) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_PopupWindow$__constructor__(android.view.View int int boolean ), 0, this, view, n, n2, bl);
    }

    public Drawable getBackground() {
        return InvokeDynamicSupport.bootstrap("getBackground", $$robo$$android_widget_PopupWindow$getBackground(), 0, this);
    }

    public void setBackgroundDrawable(Drawable drawable2) {
        InvokeDynamicSupport.bootstrap("setBackgroundDrawable", $$robo$$android_widget_PopupWindow$setBackgroundDrawable(android.graphics.drawable.Drawable ), 0, this, drawable2);
    }

    public float getElevation() {
        return (float)InvokeDynamicSupport.bootstrap("getElevation", $$robo$$android_widget_PopupWindow$getElevation(), 0, this);
    }

    public void setElevation(float f) {
        InvokeDynamicSupport.bootstrap("setElevation", $$robo$$android_widget_PopupWindow$setElevation(float ), 0, this, f);
    }

    public int getAnimationStyle() {
        return (int)InvokeDynamicSupport.bootstrap("getAnimationStyle", $$robo$$android_widget_PopupWindow$getAnimationStyle(), 0, this);
    }

    public void setIgnoreCheekPress() {
        InvokeDynamicSupport.bootstrap("setIgnoreCheekPress", $$robo$$android_widget_PopupWindow$setIgnoreCheekPress(), 0, this);
    }

    public void setAnimationStyle(int n) {
        InvokeDynamicSupport.bootstrap("setAnimationStyle", $$robo$$android_widget_PopupWindow$setAnimationStyle(int ), 0, this, n);
    }

    public View getContentView() {
        return InvokeDynamicSupport.bootstrap("getContentView", $$robo$$android_widget_PopupWindow$getContentView(), 0, this);
    }

    public void setContentView(View view) {
        InvokeDynamicSupport.bootstrap("setContentView", $$robo$$android_widget_PopupWindow$setContentView(android.view.View ), 0, this, view);
    }

    public void setTouchInterceptor(View.OnTouchListener onTouchListener) {
        InvokeDynamicSupport.bootstrap("setTouchInterceptor", $$robo$$android_widget_PopupWindow$setTouchInterceptor(android.view.View$OnTouchListener ), 0, this, onTouchListener);
    }

    public boolean isFocusable() {
        return (boolean)InvokeDynamicSupport.bootstrap("isFocusable", $$robo$$android_widget_PopupWindow$isFocusable(), 0, this);
    }

    public void setFocusable(boolean bl) {
        InvokeDynamicSupport.bootstrap("setFocusable", $$robo$$android_widget_PopupWindow$setFocusable(boolean ), 0, this, bl);
    }

    public int getInputMethodMode() {
        return (int)InvokeDynamicSupport.bootstrap("getInputMethodMode", $$robo$$android_widget_PopupWindow$getInputMethodMode(), 0, this);
    }

    public void setInputMethodMode(int n) {
        InvokeDynamicSupport.bootstrap("setInputMethodMode", $$robo$$android_widget_PopupWindow$setInputMethodMode(int ), 0, this, n);
    }

    public void setSoftInputMode(int n) {
        InvokeDynamicSupport.bootstrap("setSoftInputMode", $$robo$$android_widget_PopupWindow$setSoftInputMode(int ), 0, this, n);
    }

    public int getSoftInputMode() {
        return (int)InvokeDynamicSupport.bootstrap("getSoftInputMode", $$robo$$android_widget_PopupWindow$getSoftInputMode(), 0, this);
    }

    public boolean isTouchable() {
        return (boolean)InvokeDynamicSupport.bootstrap("isTouchable", $$robo$$android_widget_PopupWindow$isTouchable(), 0, this);
    }

    public void setTouchable(boolean bl) {
        InvokeDynamicSupport.bootstrap("setTouchable", $$robo$$android_widget_PopupWindow$setTouchable(boolean ), 0, this, bl);
    }

    public boolean isOutsideTouchable() {
        return (boolean)InvokeDynamicSupport.bootstrap("isOutsideTouchable", $$robo$$android_widget_PopupWindow$isOutsideTouchable(), 0, this);
    }

    public void setOutsideTouchable(boolean bl) {
        InvokeDynamicSupport.bootstrap("setOutsideTouchable", $$robo$$android_widget_PopupWindow$setOutsideTouchable(boolean ), 0, this, bl);
    }

    public boolean isClippingEnabled() {
        return (boolean)InvokeDynamicSupport.bootstrap("isClippingEnabled", $$robo$$android_widget_PopupWindow$isClippingEnabled(), 0, this);
    }

    public void setClippingEnabled(boolean bl) {
        InvokeDynamicSupport.bootstrap("setClippingEnabled", $$robo$$android_widget_PopupWindow$setClippingEnabled(boolean ), 0, this, bl);
    }

    public void setClipToScreenEnabled(boolean bl) {
        InvokeDynamicSupport.bootstrap("setClipToScreenEnabled", $$robo$$android_widget_PopupWindow$setClipToScreenEnabled(boolean ), 0, this, bl);
    }

    void setAllowScrollingAnchorParent(boolean bl) {
        InvokeDynamicSupport.bootstrap("setAllowScrollingAnchorParent", $$robo$$android_widget_PopupWindow$setAllowScrollingAnchorParent(boolean ), 0, this, bl);
    }

    public boolean isSplitTouchEnabled() {
        return (boolean)InvokeDynamicSupport.bootstrap("isSplitTouchEnabled", $$robo$$android_widget_PopupWindow$isSplitTouchEnabled(), 0, this);
    }

    public void setSplitTouchEnabled(boolean bl) {
        InvokeDynamicSupport.bootstrap("setSplitTouchEnabled", $$robo$$android_widget_PopupWindow$setSplitTouchEnabled(boolean ), 0, this, bl);
    }

    public boolean isLayoutInScreenEnabled() {
        return (boolean)InvokeDynamicSupport.bootstrap("isLayoutInScreenEnabled", $$robo$$android_widget_PopupWindow$isLayoutInScreenEnabled(), 0, this);
    }

    public void setLayoutInScreenEnabled(boolean bl) {
        InvokeDynamicSupport.bootstrap("setLayoutInScreenEnabled", $$robo$$android_widget_PopupWindow$setLayoutInScreenEnabled(boolean ), 0, this, bl);
    }

    public void setLayoutInsetDecor(boolean bl) {
        InvokeDynamicSupport.bootstrap("setLayoutInsetDecor", $$robo$$android_widget_PopupWindow$setLayoutInsetDecor(boolean ), 0, this, bl);
    }

    public void setWindowLayoutType(int n) {
        InvokeDynamicSupport.bootstrap("setWindowLayoutType", $$robo$$android_widget_PopupWindow$setWindowLayoutType(int ), 0, this, n);
    }

    public int getWindowLayoutType() {
        return (int)InvokeDynamicSupport.bootstrap("getWindowLayoutType", $$robo$$android_widget_PopupWindow$getWindowLayoutType(), 0, this);
    }

    public void setTouchModal(boolean bl) {
        InvokeDynamicSupport.bootstrap("setTouchModal", $$robo$$android_widget_PopupWindow$setTouchModal(boolean ), 0, this, bl);
    }

    public void setWindowLayoutMode(int n, int n2) {
        InvokeDynamicSupport.bootstrap("setWindowLayoutMode", $$robo$$android_widget_PopupWindow$setWindowLayoutMode(int int ), 0, this, n, n2);
    }

    public int getHeight() {
        return (int)InvokeDynamicSupport.bootstrap("getHeight", $$robo$$android_widget_PopupWindow$getHeight(), 0, this);
    }

    public void setHeight(int n) {
        InvokeDynamicSupport.bootstrap("setHeight", $$robo$$android_widget_PopupWindow$setHeight(int ), 0, this, n);
    }

    public int getWidth() {
        return (int)InvokeDynamicSupport.bootstrap("getWidth", $$robo$$android_widget_PopupWindow$getWidth(), 0, this);
    }

    public void setWidth(int n) {
        InvokeDynamicSupport.bootstrap("setWidth", $$robo$$android_widget_PopupWindow$setWidth(int ), 0, this, n);
    }

    public boolean isShowing() {
        return (boolean)InvokeDynamicSupport.bootstrap("isShowing", $$robo$$android_widget_PopupWindow$isShowing(), 0, this);
    }

    public void showAtLocation(View view, int n, int n2, int n3) {
        InvokeDynamicSupport.bootstrap("showAtLocation", $$robo$$android_widget_PopupWindow$showAtLocation(android.view.View int int int ), 0, this, view, n, n2, n3);
    }

    public void showAtLocation(IBinder iBinder, int n, int n2, int n3) {
        InvokeDynamicSupport.bootstrap("showAtLocation", $$robo$$android_widget_PopupWindow$showAtLocation(android.os.IBinder int int int ), 0, this, iBinder, n, n2, n3);
    }

    public void showAsDropDown(View view) {
        InvokeDynamicSupport.bootstrap("showAsDropDown", $$robo$$android_widget_PopupWindow$showAsDropDown(android.view.View ), 0, this, view);
    }

    public void showAsDropDown(View view, int n, int n2) {
        InvokeDynamicSupport.bootstrap("showAsDropDown", $$robo$$android_widget_PopupWindow$showAsDropDown(android.view.View int int ), 0, this, view, n, n2);
    }

    public void showAsDropDown(View view, int n, int n2, int n3) {
        InvokeDynamicSupport.bootstrap("showAsDropDown", $$robo$$android_widget_PopupWindow$showAsDropDown(android.view.View int int int ), 0, this, view, n, n2, n3);
    }

    private void updateAboveAnchor(boolean bl) {
        InvokeDynamicSupport.bootstrap("updateAboveAnchor", $$robo$$android_widget_PopupWindow$updateAboveAnchor(boolean ), 0, this, bl);
    }

    public boolean isAboveAnchor() {
        return (boolean)InvokeDynamicSupport.bootstrap("isAboveAnchor", $$robo$$android_widget_PopupWindow$isAboveAnchor(), 0, this);
    }

    private void preparePopup(WindowManager.LayoutParams layoutParams) {
        InvokeDynamicSupport.bootstrap("preparePopup", $$robo$$android_widget_PopupWindow$preparePopup(android.view.WindowManager$LayoutParams ), 0, this, layoutParams);
    }

    private void invokePopup(WindowManager.LayoutParams layoutParams) {
        InvokeDynamicSupport.bootstrap("invokePopup", $$robo$$android_widget_PopupWindow$invokePopup(android.view.WindowManager$LayoutParams ), 0, this, layoutParams);
    }

    private void setLayoutDirectionFromAnchor() {
        InvokeDynamicSupport.bootstrap("setLayoutDirectionFromAnchor", $$robo$$android_widget_PopupWindow$setLayoutDirectionFromAnchor(), 0, this);
    }

    private WindowManager.LayoutParams createPopupLayout(IBinder iBinder) {
        return InvokeDynamicSupport.bootstrap("createPopupLayout", $$robo$$android_widget_PopupWindow$createPopupLayout(android.os.IBinder ), 0, this, iBinder);
    }

    private int computeFlags(int n) {
        return (int)InvokeDynamicSupport.bootstrap("computeFlags", $$robo$$android_widget_PopupWindow$computeFlags(int ), 0, this, n);
    }

    private int computeAnimationResource() {
        return (int)InvokeDynamicSupport.bootstrap("computeAnimationResource", $$robo$$android_widget_PopupWindow$computeAnimationResource(), 0, this);
    }

    private boolean findDropDownPosition(View view, WindowManager.LayoutParams layoutParams, int n, int n2, int n3) {
        return (boolean)InvokeDynamicSupport.bootstrap("findDropDownPosition", $$robo$$android_widget_PopupWindow$findDropDownPosition(android.view.View android.view.WindowManager$LayoutParams int int int ), 0, this, view, layoutParams, n, n2, n3);
    }

    public int getMaxAvailableHeight(View view) {
        return (int)InvokeDynamicSupport.bootstrap("getMaxAvailableHeight", $$robo$$android_widget_PopupWindow$getMaxAvailableHeight(android.view.View ), 0, this, view);
    }

    public int getMaxAvailableHeight(View view, int n) {
        return (int)InvokeDynamicSupport.bootstrap("getMaxAvailableHeight", $$robo$$android_widget_PopupWindow$getMaxAvailableHeight(android.view.View int ), 0, this, view, n);
    }

    public int getMaxAvailableHeight(View view, int n, boolean bl) {
        return (int)InvokeDynamicSupport.bootstrap("getMaxAvailableHeight", $$robo$$android_widget_PopupWindow$getMaxAvailableHeight(android.view.View int boolean ), 0, this, view, n, bl);
    }

    public void dismiss() {
        InvokeDynamicSupport.bootstrap("dismiss", $$robo$$android_widget_PopupWindow$dismiss(), 0, this);
    }

    public void setOnDismissListener(OnDismissListener onDismissListener) {
        InvokeDynamicSupport.bootstrap("setOnDismissListener", $$robo$$android_widget_PopupWindow$setOnDismissListener(android.widget.PopupWindow$OnDismissListener ), 0, this, onDismissListener);
    }

    public void update() {
        InvokeDynamicSupport.bootstrap("update", $$robo$$android_widget_PopupWindow$update(), 0, this);
    }

    public void update(int n, int n2) {
        InvokeDynamicSupport.bootstrap("update", $$robo$$android_widget_PopupWindow$update(int int ), 0, this, n, n2);
    }

    public void update(int n, int n2, int n3, int n4) {
        InvokeDynamicSupport.bootstrap("update", $$robo$$android_widget_PopupWindow$update(int int int int ), 0, this, n, n2, n3, n4);
    }

    public void update(int n, int n2, int n3, int n4, boolean bl) {
        InvokeDynamicSupport.bootstrap("update", $$robo$$android_widget_PopupWindow$update(int int int int boolean ), 0, this, n, n2, n3, n4, bl);
    }

    public void update(View view, int n, int n2) {
        InvokeDynamicSupport.bootstrap("update", $$robo$$android_widget_PopupWindow$update(android.view.View int int ), 0, this, view, n, n2);
    }

    public void update(View view, int n, int n2, int n3, int n4) {
        InvokeDynamicSupport.bootstrap("update", $$robo$$android_widget_PopupWindow$update(android.view.View int int int int ), 0, this, view, n, n2, n3, n4);
    }

    private void update(View view, boolean bl, int n, int n2, boolean bl2, int n3, int n4, int n5) {
        InvokeDynamicSupport.bootstrap("update", $$robo$$android_widget_PopupWindow$update(android.view.View boolean int int boolean int int int ), 0, this, view, bl, n, n2, bl2, n3, n4, n5);
    }

    private void unregisterForScrollChanged() {
        InvokeDynamicSupport.bootstrap("unregisterForScrollChanged", $$robo$$android_widget_PopupWindow$unregisterForScrollChanged(), 0, this);
    }

    private void registerForScrollChanged(View view, int n, int n2, int n3) {
        InvokeDynamicSupport.bootstrap("registerForScrollChanged", $$robo$$android_widget_PopupWindow$registerForScrollChanged(android.view.View int int int ), 0, this, view, n, n2, n3);
    }

    static {
        RobolectricInternals.classInitializing(PopupWindow.class);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (PopupWindow)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    private class PopupViewContainer
    extends FrameLayout
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private static String TAG = "PopupWindow.PopupViewContainer";
        /* synthetic */ PopupWindow this$0;

        private void $$robo$$android_widget_PopupWindow_PopupViewContainer$__constructor__(PopupWindow popupWindow, Context context) {
        }

        private final int[] $$robo$$android_widget_PopupWindow_PopupViewContainer$onCreateDrawableState(int extraSpace) {
            if (this.this$0.mAboveAnchor) {
                int[] drawableState = super.onCreateDrawableState(extraSpace + 1);
                View.mergeDrawableStates(drawableState, ABOVE_ANCHOR_STATE_SET);
                return drawableState;
            }
            return super.onCreateDrawableState(extraSpace);
        }

        private final boolean $$robo$$android_widget_PopupWindow_PopupViewContainer$dispatchKeyEvent(KeyEvent event) {
            if (event.getKeyCode() == 4) {
                KeyEvent.DispatcherState state;
                if (this.getKeyDispatcherState() == null) {
                    return super.dispatchKeyEvent(event);
                }
                if (event.getAction() == 0 && event.getRepeatCount() == 0) {
                    KeyEvent.DispatcherState state2 = this.getKeyDispatcherState();
                    if (state2 != null) {
                        state2.startTracking(event, this);
                    }
                    return true;
                }
                if (event.getAction() == 1 && (state = this.getKeyDispatcherState()) != null && state.isTracking(event) && !event.isCanceled()) {
                    this.this$0.dismiss();
                    return true;
                }
                return super.dispatchKeyEvent(event);
            }
            return super.dispatchKeyEvent(event);
        }

        private final boolean $$robo$$android_widget_PopupWindow_PopupViewContainer$dispatchTouchEvent(MotionEvent ev) {
            if (this.this$0.mTouchInterceptor != null && this.this$0.mTouchInterceptor.onTouch(this, ev)) {
                return true;
            }
            return super.dispatchTouchEvent(ev);
        }

        private final boolean $$robo$$android_widget_PopupWindow_PopupViewContainer$onTouchEvent(MotionEvent event) {
            int x = (int)event.getX();
            int y = (int)event.getY();
            if (event.getAction() == 0 && (x < 0 || x >= this.getWidth() || y < 0 || y >= this.getHeight())) {
                this.this$0.dismiss();
                return true;
            }
            if (event.getAction() == 4) {
                this.this$0.dismiss();
                return true;
            }
            return super.onTouchEvent(event);
        }

        private final void $$robo$$android_widget_PopupWindow_PopupViewContainer$sendAccessibilityEvent(int eventType) {
            if (this.this$0.mContentView != null) {
                this.this$0.mContentView.sendAccessibilityEvent(eventType);
            } else {
                super.sendAccessibilityEvent(eventType);
            }
        }

        private void __constructor__(PopupWindow popupWindow, Context context) {
            this.$$robo$$android_widget_PopupWindow_PopupViewContainer$__constructor__(popupWindow, context);
        }

        public PopupViewContainer(PopupWindow popupWindow, Context context) {
            this.this$0 = popupWindow;
            super(context);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_PopupWindow_PopupViewContainer$__constructor__(android.widget.PopupWindow android.content.Context ), 0, this, popupWindow, context);
        }

        @Override
        protected int[] onCreateDrawableState(int n) {
            return InvokeDynamicSupport.bootstrap("onCreateDrawableState", $$robo$$android_widget_PopupWindow_PopupViewContainer$onCreateDrawableState(int ), 0, this, n);
        }

        @Override
        public boolean dispatchKeyEvent(KeyEvent keyEvent) {
            return (boolean)InvokeDynamicSupport.bootstrap("dispatchKeyEvent", $$robo$$android_widget_PopupWindow_PopupViewContainer$dispatchKeyEvent(android.view.KeyEvent ), 0, this, keyEvent);
        }

        @Override
        public boolean dispatchTouchEvent(MotionEvent motionEvent) {
            return (boolean)InvokeDynamicSupport.bootstrap("dispatchTouchEvent", $$robo$$android_widget_PopupWindow_PopupViewContainer$dispatchTouchEvent(android.view.MotionEvent ), 0, this, motionEvent);
        }

        @Override
        public boolean onTouchEvent(MotionEvent motionEvent) {
            return (boolean)InvokeDynamicSupport.bootstrap("onTouchEvent", $$robo$$android_widget_PopupWindow_PopupViewContainer$onTouchEvent(android.view.MotionEvent ), 0, this, motionEvent);
        }

        @Override
        public void sendAccessibilityEvent(int n) {
            InvokeDynamicSupport.bootstrap("sendAccessibilityEvent", $$robo$$android_widget_PopupWindow_PopupViewContainer$sendAccessibilityEvent(int ), 0, this, n);
        }

        public /* synthetic */ PopupViewContainer() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (PopupViewContainer)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static interface OnDismissListener
    extends InstrumentedInterface {
        public void onDismiss();
    }
}

