/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.animation.Animator;
import android.animation.AnimatorSet;
import android.animation.Keyframe;
import android.animation.ObjectAnimator;
import android.animation.PropertyValuesHolder;
import android.animation.ValueAnimator;
import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.RectF;
import android.graphics.Typeface;
import android.os.Bundle;
import android.text.TextPaint;
import android.text.format.DateUtils;
import android.text.format.Time;
import android.util.AttributeSet;
import android.util.Log;
import android.util.TypedValue;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityNodeInfo;
import android.widget.TextView;
import android.widget.TimePickerClockDelegate;
import com.android.internal.R;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Locale;
import org.robolectric.internal.bytecode.InstrumentedInterface;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class RadialTimePickerView
extends View
implements View.OnTouchListener,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "ClockView";
    private static boolean DEBUG = false;
    private static int DEBUG_COLOR = 0x20FF0000;
    private static int DEBUG_TEXT_COLOR = 0x60FF0000;
    private static int DEBUG_STROKE_WIDTH = 2;
    private static int HOURS = 0;
    private static int MINUTES = 1;
    private static int HOURS_INNER = 2;
    private static int AMPM = 3;
    private static int SELECTOR_CIRCLE = 0;
    private static int SELECTOR_DOT = 1;
    private static int SELECTOR_LINE = 2;
    private static int AM = 0;
    private static int PM = 1;
    private static int ALPHA_OPAQUE = 255;
    private static int ALPHA_TRANSPARENT = 0;
    private static int ALPHA_SELECTOR = 60;
    private static int ALPHA_AMPM_SELECTED = 60;
    private static int ALPHA_AMPM_PRESSED = 255;
    private static float COSINE_30_DEGREES;
    private static float SINE_30_DEGREES = 0.5f;
    private static int DEGREES_FOR_ONE_HOUR = 30;
    private static int DEGREES_FOR_ONE_MINUTE = 6;
    private static int[] HOURS_NUMBERS;
    private static int[] HOURS_NUMBERS_24;
    private static int[] MINUTES_NUMBERS;
    private static int CENTER_RADIUS = 2;
    private static int[] STATE_SET_SELECTED;
    private static int[] sSnapPrefer30sMap;
    private String[] mHours12Texts;
    private String[] mOuterHours24Texts;
    private String[] mInnerHours24Texts;
    private String[] mMinutesTexts;
    private String[] mAmPmText;
    private Paint[] mPaint;
    private int[] mColor;
    private IntHolder[] mAlpha;
    private Paint mPaintCenter;
    private Paint[][] mPaintSelector;
    private int[][] mColorSelector;
    private IntHolder[][] mAlphaSelector;
    private Paint mPaintAmPmText;
    private Paint[] mPaintAmPmCircle;
    private Paint mPaintBackground;
    private Paint mPaintDisabled;
    private Paint mPaintDebug;
    private Typeface mTypeface;
    private boolean mIs24HourMode;
    private boolean mShowHours;
    private boolean mIsOnInnerCircle;
    private int mXCenter;
    private int mYCenter;
    private float[] mCircleRadius;
    private int mMinHypotenuseForInnerNumber;
    private int mMaxHypotenuseForOuterNumber;
    private int mHalfwayHypotenusePoint;
    private float[] mTextSize;
    private float mInnerTextSize;
    private float[][] mTextGridHeights;
    private float[][] mTextGridWidths;
    private float[] mInnerTextGridHeights;
    private float[] mInnerTextGridWidths;
    private String[] mOuterTextHours;
    private String[] mInnerTextHours;
    private String[] mOuterTextMinutes;
    private float[] mCircleRadiusMultiplier;
    private float[] mNumbersRadiusMultiplier;
    private float[] mTextSizeMultiplier;
    private float[] mAnimationRadiusMultiplier;
    private float mTransitionMidRadiusMultiplier;
    private float mTransitionEndRadiusMultiplier;
    private AnimatorSet mTransition;
    private InvalidateUpdateListener mInvalidateUpdateListener;
    private int[] mLineLength;
    private int[] mSelectionRadius;
    private float mSelectionRadiusMultiplier;
    private int[] mSelectionDegrees;
    private int mAmPmCircleRadius;
    private float mAmPmYCenter;
    private float mAmPmCircleRadiusMultiplier;
    private int mAmPmTextColor;
    private float mLeftIndicatorXCenter;
    private float mRightIndicatorXCenter;
    private int mAmPmUnselectedColor;
    private int mAmPmSelectedColor;
    private int mAmOrPm;
    private int mAmOrPmPressed;
    private int mDisabledAlpha;
    private RectF mRectF;
    private boolean mInputEnabled;
    private OnValueSelectedListener mListener;
    private ArrayList<Animator> mHoursToMinutesAnims;
    private ArrayList<Animator> mMinuteToHoursAnims;

    private static final void $$robo$$android_widget_RadialTimePickerView$preparePrefer30sMap() {
        int snappedOutputDegrees = 0;
        int count = 1;
        int expectedCount = 8;
        for (int degrees = 0; degrees < 361; ++degrees) {
            RadialTimePickerView.sSnapPrefer30sMap[degrees] = snappedOutputDegrees;
            if (count == expectedCount) {
                expectedCount = (snappedOutputDegrees += 6) == 360 ? 7 : (snappedOutputDegrees % 30 == 0 ? 14 : 4);
                count = 1;
                continue;
            }
            ++count;
        }
    }

    private static final int $$robo$$android_widget_RadialTimePickerView$snapPrefer30s(int degrees) {
        if (sSnapPrefer30sMap == null) {
            return -1;
        }
        return sSnapPrefer30sMap[degrees];
    }

    private static final int $$robo$$android_widget_RadialTimePickerView$snapOnly30s(int degrees, int forceHigherOrLower) {
        int stepSize = 30;
        int floor = degrees / 30 * 30;
        int ceiling = floor + 30;
        if (forceHigherOrLower == 1) {
            degrees = ceiling;
        } else if (forceHigherOrLower == -1) {
            if (degrees == floor) {
                floor -= 30;
            }
            degrees = floor;
        } else {
            degrees = degrees - floor < ceiling - degrees ? floor : ceiling;
        }
        return degrees;
    }

    private void $$robo$$android_widget_RadialTimePickerView$__constructor__(Context context, AttributeSet attrs) {
    }

    private void $$robo$$android_widget_RadialTimePickerView$__constructor__(Context context, AttributeSet attrs, int defStyle) {
        int i;
        this.mHours12Texts = new String[12];
        this.mOuterHours24Texts = new String[12];
        this.mInnerHours24Texts = new String[12];
        this.mMinutesTexts = new String[12];
        this.mAmPmText = new String[2];
        this.mPaint = new Paint[2];
        this.mColor = new int[2];
        this.mAlpha = new IntHolder[2];
        this.mPaintCenter = new Paint();
        this.mPaintSelector = new Paint[2][3];
        this.mColorSelector = new int[2][3];
        this.mAlphaSelector = new IntHolder[2][3];
        this.mPaintAmPmText = new Paint();
        this.mPaintAmPmCircle = new Paint[2];
        this.mPaintBackground = new Paint();
        this.mPaintDisabled = new Paint();
        this.mPaintDebug = new Paint();
        this.mCircleRadius = new float[3];
        this.mTextSize = new float[2];
        this.mTextGridHeights = new float[2][7];
        this.mTextGridWidths = new float[2][7];
        this.mInnerTextGridHeights = new float[7];
        this.mInnerTextGridWidths = new float[7];
        this.mCircleRadiusMultiplier = new float[2];
        this.mNumbersRadiusMultiplier = new float[3];
        this.mTextSizeMultiplier = new float[3];
        this.mAnimationRadiusMultiplier = new float[3];
        this.mInvalidateUpdateListener = new InvalidateUpdateListener(this);
        this.mLineLength = new int[3];
        this.mSelectionRadius = new int[3];
        this.mSelectionDegrees = new int[3];
        this.mRectF = new RectF();
        this.mInputEnabled = true;
        this.mHoursToMinutesAnims = new ArrayList();
        this.mMinuteToHoursAnims = new ArrayList();
        TypedValue outValue = new TypedValue();
        context.getTheme().resolveAttribute(0x1010033, outValue, true);
        this.mDisabledAlpha = (int)(outValue.getFloat() * 255.0f + 0.5f);
        Resources res = this.getResources();
        TypedArray a = this.mContext.obtainStyledAttributes(attrs, R.styleable.TimePicker, defStyle, 0);
        ColorStateList amPmBackgroundColor = a.getColorStateList(7);
        if (amPmBackgroundColor == null) {
            amPmBackgroundColor = res.getColorStateList(17170668);
        }
        int amPmSelectedColor = a.getColor(12, res.getColor(17170667));
        amPmBackgroundColor = ColorStateList.addFirstIfMissing(amPmBackgroundColor, 0x10100A1, amPmSelectedColor);
        this.mAmPmSelectedColor = amPmBackgroundColor.getColorForState(STATE_SET_SELECTED, amPmSelectedColor);
        this.mAmPmUnselectedColor = amPmBackgroundColor.getDefaultColor();
        this.mAmPmTextColor = a.getColor(6, res.getColor(17170666));
        this.mTypeface = Typeface.create("sans-serif", 0);
        for (i = 0; i < this.mAlpha.length; ++i) {
            this.mAlpha[i] = new IntHolder(255);
        }
        for (i = 0; i < this.mAlphaSelector.length; ++i) {
            for (int j = 0; j < this.mAlphaSelector[i].length; ++j) {
                this.mAlphaSelector[i][j] = new IntHolder(255);
            }
        }
        int numbersTextColor = a.getColor(3, res.getColor(17170666));
        this.mPaint[0] = new Paint();
        this.mPaint[0].setAntiAlias(true);
        this.mPaint[0].setTextAlign(Paint.Align.CENTER);
        this.mColor[0] = numbersTextColor;
        this.mPaint[1] = new Paint();
        this.mPaint[1].setAntiAlias(true);
        this.mPaint[1].setTextAlign(Paint.Align.CENTER);
        this.mColor[1] = numbersTextColor;
        this.mPaintCenter.setColor(numbersTextColor);
        this.mPaintCenter.setAntiAlias(true);
        this.mPaintCenter.setTextAlign(Paint.Align.CENTER);
        this.mPaintSelector[0][0] = new Paint();
        this.mPaintSelector[0][0].setAntiAlias(true);
        this.mColorSelector[0][0] = a.getColor(5, 17170669);
        this.mPaintSelector[0][1] = new Paint();
        this.mPaintSelector[0][1].setAntiAlias(true);
        this.mColorSelector[0][1] = a.getColor(5, 17170669);
        this.mPaintSelector[0][2] = new Paint();
        this.mPaintSelector[0][2].setAntiAlias(true);
        this.mPaintSelector[0][2].setStrokeWidth(2.0f);
        this.mColorSelector[0][2] = a.getColor(5, 17170669);
        this.mPaintSelector[1][0] = new Paint();
        this.mPaintSelector[1][0].setAntiAlias(true);
        this.mColorSelector[1][0] = a.getColor(5, 17170669);
        this.mPaintSelector[1][1] = new Paint();
        this.mPaintSelector[1][1].setAntiAlias(true);
        this.mColorSelector[1][1] = a.getColor(5, 17170669);
        this.mPaintSelector[1][2] = new Paint();
        this.mPaintSelector[1][2].setAntiAlias(true);
        this.mPaintSelector[1][2].setStrokeWidth(2.0f);
        this.mColorSelector[1][2] = a.getColor(5, 17170669);
        this.mPaintAmPmText.setColor(this.mAmPmTextColor);
        this.mPaintAmPmText.setTypeface(this.mTypeface);
        this.mPaintAmPmText.setAntiAlias(true);
        this.mPaintAmPmText.setTextAlign(Paint.Align.CENTER);
        this.mPaintAmPmCircle[0] = new Paint();
        this.mPaintAmPmCircle[0].setAntiAlias(true);
        this.mPaintAmPmCircle[1] = new Paint();
        this.mPaintAmPmCircle[1].setAntiAlias(true);
        this.mPaintBackground.setColor(a.getColor(4, res.getColor(17170670)));
        this.mPaintBackground.setAntiAlias(true);
        this.mShowHours = true;
        this.mIs24HourMode = false;
        this.mAmOrPm = 0;
        this.mAmOrPmPressed = -1;
        this.initHoursAndMinutesText();
        this.initData();
        this.mTransitionMidRadiusMultiplier = Float.parseFloat(res.getString(17039441));
        this.mTransitionEndRadiusMultiplier = Float.parseFloat(res.getString(17039442));
        this.mTextGridHeights[0] = new float[7];
        this.mTextGridHeights[1] = new float[7];
        this.mSelectionRadiusMultiplier = Float.parseFloat(res.getString(17039433));
        a.recycle();
        this.setOnTouchListener(this);
        this.setClickable(true);
        Calendar calendar = Calendar.getInstance(Locale.getDefault());
        int currentHour = calendar.get(11);
        int currentMinute = calendar.get(12);
        this.setCurrentHour(currentHour);
        this.setCurrentMinute(currentMinute);
        this.setHapticFeedbackEnabled(true);
    }

    private final void $$robo$$android_widget_RadialTimePickerView$onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int measuredWidth = View.MeasureSpec.getSize(widthMeasureSpec);
        int widthMode = View.MeasureSpec.getMode(widthMeasureSpec);
        int measuredHeight = View.MeasureSpec.getSize(heightMeasureSpec);
        int heightMode = View.MeasureSpec.getMode(heightMeasureSpec);
        int minDimension = Math.min(measuredWidth, measuredHeight);
        super.onMeasure(View.MeasureSpec.makeMeasureSpec(minDimension, widthMode), View.MeasureSpec.makeMeasureSpec(minDimension, heightMode));
    }

    private final void $$robo$$android_widget_RadialTimePickerView$initialize(int hour, int minute, boolean is24HourMode) {
        this.mIs24HourMode = is24HourMode;
        this.setCurrentHour(hour);
        this.setCurrentMinute(minute);
    }

    private final void $$robo$$android_widget_RadialTimePickerView$setCurrentItemShowing(int item, boolean animate) {
        switch (item) {
            case 0: {
                this.showHours(animate);
                break;
            }
            case 1: {
                this.showMinutes(animate);
                break;
            }
            default: {
                Log.e("ClockView", "ClockView does not support showing item " + item);
            }
        }
    }

    private final int $$robo$$android_widget_RadialTimePickerView$getCurrentItemShowing() {
        return this.mShowHours ? 0 : 1;
    }

    private final void $$robo$$android_widget_RadialTimePickerView$setOnValueSelectedListener(OnValueSelectedListener listener) {
        this.mListener = listener;
    }

    private final void $$robo$$android_widget_RadialTimePickerView$setCurrentHour(int hour) {
        int degrees;
        this.mSelectionDegrees[0] = degrees = hour % 12 * 30;
        this.mSelectionDegrees[2] = degrees;
        int n = this.mAmOrPm = hour == 0 || hour % 24 < 12 ? 0 : 1;
        this.mIsOnInnerCircle = this.mIs24HourMode ? hour >= 1 && hour <= 12 : false;
        this.initData();
        this.updateLayoutData();
        this.invalidate();
    }

    private final int $$robo$$android_widget_RadialTimePickerView$getCurrentHour() {
        int hour = this.mSelectionDegrees[this.mIsOnInnerCircle ? 2 : 0] / 30 % 12;
        if (this.mIs24HourMode) {
            if (this.mIsOnInnerCircle && hour == 0) {
                hour = 12;
            } else if (!this.mIsOnInnerCircle && hour != 0) {
                hour += 12;
            }
        } else if (this.mAmOrPm == 1) {
            hour += 12;
        }
        return hour;
    }

    private final void $$robo$$android_widget_RadialTimePickerView$setCurrentMinute(int minute) {
        this.mSelectionDegrees[1] = minute % 60 * 6;
        this.invalidate();
    }

    private final int $$robo$$android_widget_RadialTimePickerView$getCurrentMinute() {
        return this.mSelectionDegrees[1] / 6;
    }

    private final void $$robo$$android_widget_RadialTimePickerView$setAmOrPm(int val) {
        this.mAmOrPm = val % 2;
        this.invalidate();
    }

    private final int $$robo$$android_widget_RadialTimePickerView$getAmOrPm() {
        return this.mAmOrPm;
    }

    private final void $$robo$$android_widget_RadialTimePickerView$swapAmPm() {
        this.mAmOrPm = this.mAmOrPm == 0 ? 1 : 0;
        this.invalidate();
    }

    private final void $$robo$$android_widget_RadialTimePickerView$showHours(boolean animate) {
        if (this.mShowHours) {
            return;
        }
        this.mShowHours = true;
        if (animate) {
            this.startMinutesToHoursAnimation();
        }
        this.initData();
        this.updateLayoutData();
        this.invalidate();
    }

    private final void $$robo$$android_widget_RadialTimePickerView$showMinutes(boolean animate) {
        if (!this.mShowHours) {
            return;
        }
        this.mShowHours = false;
        if (animate) {
            this.startHoursToMinutesAnimation();
        }
        this.initData();
        this.updateLayoutData();
        this.invalidate();
    }

    private final void $$robo$$android_widget_RadialTimePickerView$initHoursAndMinutesText() {
        for (int i = 0; i < 12; ++i) {
            this.mHours12Texts[i] = String.format("%d", HOURS_NUMBERS[i]);
            this.mOuterHours24Texts[i] = String.format("%02d", HOURS_NUMBERS_24[i]);
            this.mInnerHours24Texts[i] = String.format("%d", HOURS_NUMBERS[i]);
            this.mMinutesTexts[i] = String.format("%02d", MINUTES_NUMBERS[i]);
        }
        String[] amPmStrings = TimePickerClockDelegate.getAmPmStrings(this.mContext);
        this.mAmPmText[0] = amPmStrings[0];
        this.mAmPmText[1] = amPmStrings[1];
    }

    private final void $$robo$$android_widget_RadialTimePickerView$initData() {
        if (this.mIs24HourMode) {
            this.mOuterTextHours = this.mOuterHours24Texts;
            this.mInnerTextHours = this.mInnerHours24Texts;
        } else {
            this.mOuterTextHours = this.mHours12Texts;
            this.mInnerTextHours = null;
        }
        this.mOuterTextMinutes = this.mMinutesTexts;
        Resources res = this.getResources();
        if (this.mShowHours) {
            if (this.mIs24HourMode) {
                this.mCircleRadiusMultiplier[0] = Float.parseFloat(res.getString(17039432));
                this.mNumbersRadiusMultiplier[0] = Float.parseFloat(res.getString(17039437));
                this.mTextSizeMultiplier[0] = Float.parseFloat(res.getString(17039440));
                this.mNumbersRadiusMultiplier[2] = Float.parseFloat(res.getString(17039436));
                this.mTextSizeMultiplier[2] = Float.parseFloat(res.getString(17039439));
            } else {
                this.mCircleRadiusMultiplier[0] = Float.parseFloat(res.getString(17039431));
                this.mNumbersRadiusMultiplier[0] = Float.parseFloat(res.getString(17039435));
                this.mTextSizeMultiplier[0] = Float.parseFloat(res.getString(17039438));
            }
        } else {
            this.mCircleRadiusMultiplier[1] = Float.parseFloat(res.getString(17039431));
            this.mNumbersRadiusMultiplier[1] = Float.parseFloat(res.getString(17039435));
            this.mTextSizeMultiplier[1] = Float.parseFloat(res.getString(17039438));
        }
        this.mAnimationRadiusMultiplier[0] = 1.0f;
        this.mAnimationRadiusMultiplier[2] = 1.0f;
        this.mAnimationRadiusMultiplier[1] = 1.0f;
        this.mAmPmCircleRadiusMultiplier = Float.parseFloat(res.getString(17039434));
        this.mAlpha[0].setValue(this.mShowHours ? 255 : 0);
        this.mAlpha[1].setValue(this.mShowHours ? 0 : 255);
        this.mAlphaSelector[0][0].setValue(this.mShowHours ? 60 : 0);
        this.mAlphaSelector[0][1].setValue(this.mShowHours ? 255 : 0);
        this.mAlphaSelector[0][2].setValue(this.mShowHours ? 60 : 0);
        this.mAlphaSelector[1][0].setValue(this.mShowHours ? 0 : 60);
        this.mAlphaSelector[1][1].setValue(this.mShowHours ? 0 : 255);
        this.mAlphaSelector[1][2].setValue(this.mShowHours ? 0 : 60);
    }

    private final void $$robo$$android_widget_RadialTimePickerView$onLayout(boolean changed, int left, int top, int right, int bottom) {
        this.updateLayoutData();
    }

    private final void $$robo$$android_widget_RadialTimePickerView$updateLayoutData() {
        this.mXCenter = this.getWidth() / 2;
        this.mYCenter = this.getHeight() / 2;
        int min = Math.min(this.mXCenter, this.mYCenter);
        this.mCircleRadius[0] = (float)min * this.mCircleRadiusMultiplier[0];
        this.mCircleRadius[2] = (float)min * this.mCircleRadiusMultiplier[0];
        this.mCircleRadius[1] = (float)min * this.mCircleRadiusMultiplier[1];
        if (!this.mIs24HourMode) {
            int amPmCircleRadius = (int)(this.mCircleRadius[0] * this.mAmPmCircleRadiusMultiplier);
            this.mYCenter -= amPmCircleRadius / 2;
        }
        this.mMinHypotenuseForInnerNumber = (int)(this.mCircleRadius[0] * this.mNumbersRadiusMultiplier[2]) - this.mSelectionRadius[0];
        this.mMaxHypotenuseForOuterNumber = (int)(this.mCircleRadius[0] * this.mNumbersRadiusMultiplier[0]) + this.mSelectionRadius[0];
        this.mHalfwayHypotenusePoint = (int)(this.mCircleRadius[0] * ((this.mNumbersRadiusMultiplier[0] + this.mNumbersRadiusMultiplier[2]) / 2.0f));
        this.mTextSize[0] = this.mCircleRadius[0] * this.mTextSizeMultiplier[0];
        this.mTextSize[1] = this.mCircleRadius[1] * this.mTextSizeMultiplier[1];
        if (this.mIs24HourMode) {
            this.mInnerTextSize = this.mCircleRadius[0] * this.mTextSizeMultiplier[2];
        }
        this.calculateGridSizesHours();
        this.calculateGridSizesMinutes();
        this.mSelectionRadius[0] = (int)(this.mCircleRadius[0] * this.mSelectionRadiusMultiplier);
        this.mSelectionRadius[2] = this.mSelectionRadius[0];
        this.mSelectionRadius[1] = (int)(this.mCircleRadius[1] * this.mSelectionRadiusMultiplier);
        this.mAmPmCircleRadius = (int)(this.mCircleRadius[0] * this.mAmPmCircleRadiusMultiplier);
        this.mPaintAmPmText.setTextSize(this.mAmPmCircleRadius * 3 / 4);
        this.mAmPmYCenter = (float)this.mYCenter + this.mCircleRadius[0];
        this.mLeftIndicatorXCenter = (float)this.mXCenter - this.mCircleRadius[0] + (float)this.mAmPmCircleRadius;
        this.mRightIndicatorXCenter = (float)this.mXCenter + this.mCircleRadius[0] - (float)this.mAmPmCircleRadius;
    }

    private final void $$robo$$android_widget_RadialTimePickerView$onDraw(Canvas canvas) {
        if (!this.mInputEnabled) {
            canvas.saveLayerAlpha(0.0f, 0.0f, this.getWidth(), this.getHeight(), this.mDisabledAlpha);
        } else {
            canvas.save();
        }
        this.calculateGridSizesHours();
        this.calculateGridSizesMinutes();
        this.drawCircleBackground(canvas);
        this.drawSelector(canvas);
        this.drawTextElements(canvas, this.mTextSize[0], this.mTypeface, this.mOuterTextHours, this.mTextGridWidths[0], this.mTextGridHeights[0], this.mPaint[0], this.mColor[0], this.mAlpha[0].getValue());
        if (this.mIs24HourMode && this.mInnerTextHours != null) {
            this.drawTextElements(canvas, this.mInnerTextSize, this.mTypeface, this.mInnerTextHours, this.mInnerTextGridWidths, this.mInnerTextGridHeights, this.mPaint[0], this.mColor[0], this.mAlpha[0].getValue());
        }
        this.drawTextElements(canvas, this.mTextSize[1], this.mTypeface, this.mOuterTextMinutes, this.mTextGridWidths[1], this.mTextGridHeights[1], this.mPaint[1], this.mColor[1], this.mAlpha[1].getValue());
        this.drawCenter(canvas);
        if (!this.mIs24HourMode) {
            this.drawAmPm(canvas);
        }
        canvas.restore();
    }

    private final void $$robo$$android_widget_RadialTimePickerView$drawCircleBackground(Canvas canvas) {
        canvas.drawCircle(this.mXCenter, this.mYCenter, this.mCircleRadius[0], this.mPaintBackground);
    }

    private final void $$robo$$android_widget_RadialTimePickerView$drawCenter(Canvas canvas) {
        canvas.drawCircle(this.mXCenter, this.mYCenter, 2.0f, this.mPaintCenter);
    }

    private final void $$robo$$android_widget_RadialTimePickerView$drawSelector(Canvas canvas) {
        this.drawSelector(canvas, this.mIsOnInnerCircle ? 2 : 0);
        this.drawSelector(canvas, 1);
    }

    private final void $$robo$$android_widget_RadialTimePickerView$drawAmPm(Canvas canvas) {
        boolean isLayoutRtl = this.isLayoutRtl();
        int amColor = this.mAmPmUnselectedColor;
        int amAlpha = 255;
        int pmColor = this.mAmPmUnselectedColor;
        int pmAlpha = 255;
        if (this.mAmOrPm == 0) {
            amColor = this.mAmPmSelectedColor;
            amAlpha = 60;
        } else if (this.mAmOrPm == 1) {
            pmColor = this.mAmPmSelectedColor;
            pmAlpha = 60;
        }
        if (this.mAmOrPmPressed == 0) {
            amColor = this.mAmPmSelectedColor;
            amAlpha = 255;
        } else if (this.mAmOrPmPressed == 1) {
            pmColor = this.mAmPmSelectedColor;
            pmAlpha = 255;
        }
        this.mPaintAmPmCircle[0].setColor(amColor);
        this.mPaintAmPmCircle[0].setAlpha(this.getMultipliedAlpha(amColor, amAlpha));
        canvas.drawCircle(isLayoutRtl ? this.mRightIndicatorXCenter : this.mLeftIndicatorXCenter, this.mAmPmYCenter, this.mAmPmCircleRadius, this.mPaintAmPmCircle[0]);
        this.mPaintAmPmCircle[1].setColor(pmColor);
        this.mPaintAmPmCircle[1].setAlpha(this.getMultipliedAlpha(pmColor, pmAlpha));
        canvas.drawCircle(isLayoutRtl ? this.mLeftIndicatorXCenter : this.mRightIndicatorXCenter, this.mAmPmYCenter, this.mAmPmCircleRadius, this.mPaintAmPmCircle[1]);
        this.mPaintAmPmText.setColor(this.mAmPmTextColor);
        float textYCenter = this.mAmPmYCenter - (float)((int)(this.mPaintAmPmText.descent() + this.mPaintAmPmText.ascent()) / 2);
        canvas.drawText(isLayoutRtl ? this.mAmPmText[1] : this.mAmPmText[0], this.mLeftIndicatorXCenter, textYCenter, this.mPaintAmPmText);
        canvas.drawText(isLayoutRtl ? this.mAmPmText[0] : this.mAmPmText[1], this.mRightIndicatorXCenter, textYCenter, this.mPaintAmPmText);
    }

    private final int $$robo$$android_widget_RadialTimePickerView$getMultipliedAlpha(int argb, int alpha) {
        return (int)((double)Color.alpha(argb) * ((double)alpha / 255.0) + 0.5);
    }

    private final void $$robo$$android_widget_RadialTimePickerView$drawSelector(Canvas canvas, int index) {
        this.mLineLength[index] = (int)(this.mCircleRadius[index] * this.mNumbersRadiusMultiplier[index] * this.mAnimationRadiusMultiplier[index]);
        double selectionRadians = Math.toRadians(this.mSelectionDegrees[index]);
        int pointX = this.mXCenter + (int)((double)this.mLineLength[index] * Math.sin(selectionRadians));
        int pointY = this.mYCenter - (int)((double)this.mLineLength[index] * Math.cos(selectionRadians));
        int color2 = this.mColorSelector[index % 2][0];
        int alpha = this.mAlphaSelector[index % 2][0].getValue();
        Paint paint = this.mPaintSelector[index % 2][0];
        paint.setColor(color2);
        paint.setAlpha(this.getMultipliedAlpha(color2, alpha));
        canvas.drawCircle(pointX, pointY, this.mSelectionRadius[index], paint);
        if (this.mSelectionDegrees[index] % 30 != 0) {
            color2 = this.mColorSelector[index % 2][1];
            alpha = this.mAlphaSelector[index % 2][1].getValue();
            paint = this.mPaintSelector[index % 2][1];
            paint.setColor(color2);
            paint.setAlpha(this.getMultipliedAlpha(color2, alpha));
            canvas.drawCircle(pointX, pointY, this.mSelectionRadius[index] * 2 / 7, paint);
        } else {
            int lineLength = this.mLineLength[index] - this.mSelectionRadius[index];
            pointX = this.mXCenter + (int)((double)lineLength * Math.sin(selectionRadians));
            pointY = this.mYCenter - (int)((double)lineLength * Math.cos(selectionRadians));
        }
        color2 = this.mColorSelector[index % 2][2];
        alpha = this.mAlphaSelector[index % 2][2].getValue();
        paint = this.mPaintSelector[index % 2][2];
        paint.setColor(color2);
        paint.setAlpha(this.getMultipliedAlpha(color2, alpha));
        canvas.drawLine(this.mXCenter, this.mYCenter, pointX, pointY, paint);
    }

    private final void $$robo$$android_widget_RadialTimePickerView$drawDebug(Canvas canvas) {
        float outerRadius = this.mCircleRadius[0] * this.mNumbersRadiusMultiplier[0];
        canvas.drawCircle(this.mXCenter, this.mYCenter, outerRadius, this.mPaintDebug);
        float innerRadius = this.mCircleRadius[0] * this.mNumbersRadiusMultiplier[2];
        canvas.drawCircle(this.mXCenter, this.mYCenter, innerRadius, this.mPaintDebug);
        canvas.drawCircle(this.mXCenter, this.mYCenter, this.mCircleRadius[0], this.mPaintDebug);
        float left = (float)this.mXCenter - outerRadius;
        float top = (float)this.mYCenter - outerRadius;
        float right = (float)this.mXCenter + outerRadius;
        float bottom = (float)this.mYCenter + outerRadius;
        this.mRectF = new RectF(left, top, right, bottom);
        canvas.drawRect(this.mRectF, this.mPaintDebug);
        left = (float)this.mXCenter - this.mCircleRadius[0];
        top = (float)this.mYCenter - this.mCircleRadius[0];
        right = (float)this.mXCenter + this.mCircleRadius[0];
        bottom = (float)this.mYCenter + this.mCircleRadius[0];
        this.mRectF.set(left, top, right, bottom);
        canvas.drawRect(this.mRectF, this.mPaintDebug);
        this.mRectF.set(0.0f, 0.0f, this.getWidth(), this.getHeight());
        canvas.drawRect(this.mRectF, this.mPaintDebug);
        String selected = String.format("%02d:%02d", this.getCurrentHour(), this.getCurrentMinute());
        ViewGroup.LayoutParams lp = new ViewGroup.LayoutParams(-2, -2);
        TextView tv = new TextView(this.getContext());
        tv.setLayoutParams(lp);
        tv.setText(selected);
        tv.measure(0, 0);
        TextPaint paint = tv.getPaint();
        paint.setColor(0x60FF0000);
        int width = tv.getMeasuredWidth();
        float height = paint.descent() - paint.ascent();
        float x = this.mXCenter - width / 2;
        float y = (float)this.mYCenter + 1.5f * height;
        canvas.drawText(selected.toString(), x, y, paint);
    }

    private final void $$robo$$android_widget_RadialTimePickerView$calculateGridSizesHours() {
        float numbersRadius = this.mCircleRadius[0] * this.mNumbersRadiusMultiplier[0] * this.mAnimationRadiusMultiplier[0];
        RadialTimePickerView.calculateGridSizes(this.mPaint[0], numbersRadius, this.mXCenter, this.mYCenter, this.mTextSize[0], this.mTextGridHeights[0], this.mTextGridWidths[0]);
        if (this.mIs24HourMode) {
            float innerNumbersRadius = this.mCircleRadius[2] * this.mNumbersRadiusMultiplier[2] * this.mAnimationRadiusMultiplier[2];
            RadialTimePickerView.calculateGridSizes(this.mPaint[0], innerNumbersRadius, this.mXCenter, this.mYCenter, this.mInnerTextSize, this.mInnerTextGridHeights, this.mInnerTextGridWidths);
        }
    }

    private final void $$robo$$android_widget_RadialTimePickerView$calculateGridSizesMinutes() {
        float numbersRadius = this.mCircleRadius[1] * this.mNumbersRadiusMultiplier[1] * this.mAnimationRadiusMultiplier[1];
        RadialTimePickerView.calculateGridSizes(this.mPaint[1], numbersRadius, this.mXCenter, this.mYCenter, this.mTextSize[1], this.mTextGridHeights[1], this.mTextGridWidths[1]);
    }

    private static final void $$robo$$android_widget_RadialTimePickerView$calculateGridSizes(Paint paint, float numbersRadius, float xCenter, float yCenter, float textSize, float[] textGridHeights, float[] textGridWidths) {
        float offset1 = numbersRadius;
        float offset2 = numbersRadius * COSINE_30_DEGREES;
        float offset3 = numbersRadius * 0.5f;
        paint.setTextSize(textSize);
        textGridHeights[0] = (yCenter -= (paint.descent() + paint.ascent()) / 2.0f) - offset1;
        textGridWidths[0] = xCenter - offset1;
        textGridHeights[1] = yCenter - offset2;
        textGridWidths[1] = xCenter - offset2;
        textGridHeights[2] = yCenter - offset3;
        textGridWidths[2] = xCenter - offset3;
        textGridHeights[3] = yCenter;
        textGridWidths[3] = xCenter;
        textGridHeights[4] = yCenter + offset3;
        textGridWidths[4] = xCenter + offset3;
        textGridHeights[5] = yCenter + offset2;
        textGridWidths[5] = xCenter + offset2;
        textGridHeights[6] = yCenter + offset1;
        textGridWidths[6] = xCenter + offset1;
    }

    private final void $$robo$$android_widget_RadialTimePickerView$drawTextElements(Canvas canvas, float textSize, Typeface typeface, String[] texts, float[] textGridWidths, float[] textGridHeights, Paint paint, int color2, int alpha) {
        paint.setTextSize(textSize);
        paint.setTypeface(typeface);
        paint.setColor(color2);
        paint.setAlpha(this.getMultipliedAlpha(color2, alpha));
        canvas.drawText(texts[0], textGridWidths[3], textGridHeights[0], paint);
        canvas.drawText(texts[1], textGridWidths[4], textGridHeights[1], paint);
        canvas.drawText(texts[2], textGridWidths[5], textGridHeights[2], paint);
        canvas.drawText(texts[3], textGridWidths[6], textGridHeights[3], paint);
        canvas.drawText(texts[4], textGridWidths[5], textGridHeights[4], paint);
        canvas.drawText(texts[5], textGridWidths[4], textGridHeights[5], paint);
        canvas.drawText(texts[6], textGridWidths[3], textGridHeights[6], paint);
        canvas.drawText(texts[7], textGridWidths[2], textGridHeights[5], paint);
        canvas.drawText(texts[8], textGridWidths[1], textGridHeights[4], paint);
        canvas.drawText(texts[9], textGridWidths[0], textGridHeights[3], paint);
        canvas.drawText(texts[10], textGridWidths[1], textGridHeights[2], paint);
        canvas.drawText(texts[11], textGridWidths[2], textGridHeights[1], paint);
    }

    private final void $$robo$$android_widget_RadialTimePickerView$setAnimationRadiusMultiplierHours(float animationRadiusMultiplier) {
        this.mAnimationRadiusMultiplier[0] = animationRadiusMultiplier;
        this.mAnimationRadiusMultiplier[2] = animationRadiusMultiplier;
    }

    private final void $$robo$$android_widget_RadialTimePickerView$setAnimationRadiusMultiplierMinutes(float animationRadiusMultiplier) {
        this.mAnimationRadiusMultiplier[1] = animationRadiusMultiplier;
    }

    private static final ObjectAnimator $$robo$$android_widget_RadialTimePickerView$getRadiusDisappearAnimator(Object target, String radiusPropertyName, InvalidateUpdateListener updateListener, float midRadiusMultiplier, float endRadiusMultiplier) {
        float midwayPoint = 0.2f;
        int duration = 500;
        Keyframe kf0 = Keyframe.ofFloat(0.0f, 1.0f);
        Keyframe kf1 = Keyframe.ofFloat(midwayPoint, midRadiusMultiplier);
        Keyframe kf2 = Keyframe.ofFloat(1.0f, endRadiusMultiplier);
        PropertyValuesHolder radiusDisappear = PropertyValuesHolder.ofKeyframe(radiusPropertyName, kf0, kf1, kf2);
        ValueAnimator animator2 = ObjectAnimator.ofPropertyValuesHolder(target, radiusDisappear).setDuration(duration);
        animator2.addUpdateListener(updateListener);
        return animator2;
    }

    private static final ObjectAnimator $$robo$$android_widget_RadialTimePickerView$getRadiusReappearAnimator(Object target, String radiusPropertyName, InvalidateUpdateListener updateListener, float midRadiusMultiplier, float endRadiusMultiplier) {
        float midwayPoint = 0.2f;
        int duration = 500;
        float delayMultiplier = 0.25f;
        float transitionDurationMultiplier = 1.0f;
        float totalDurationMultiplier = transitionDurationMultiplier + delayMultiplier;
        int totalDuration = (int)((float)duration * totalDurationMultiplier);
        float delayPoint = delayMultiplier * (float)duration / (float)totalDuration;
        midwayPoint = 1.0f - midwayPoint * (1.0f - delayPoint);
        Keyframe kf0 = Keyframe.ofFloat(0.0f, endRadiusMultiplier);
        Keyframe kf1 = Keyframe.ofFloat(delayPoint, endRadiusMultiplier);
        Keyframe kf2 = Keyframe.ofFloat(midwayPoint, midRadiusMultiplier);
        Keyframe kf3 = Keyframe.ofFloat(1.0f, 1.0f);
        PropertyValuesHolder radiusReappear = PropertyValuesHolder.ofKeyframe(radiusPropertyName, kf0, kf1, kf2, kf3);
        ValueAnimator animator2 = ObjectAnimator.ofPropertyValuesHolder(target, radiusReappear).setDuration(totalDuration);
        animator2.addUpdateListener(updateListener);
        return animator2;
    }

    private static final ObjectAnimator $$robo$$android_widget_RadialTimePickerView$getFadeOutAnimator(IntHolder target, int startAlpha, int endAlpha, InvalidateUpdateListener updateListener) {
        int duration = 500;
        ObjectAnimator animator2 = ObjectAnimator.ofInt((Object)target, "value", startAlpha, endAlpha);
        animator2.setDuration(duration);
        animator2.addUpdateListener(updateListener);
        return animator2;
    }

    private static final ObjectAnimator $$robo$$android_widget_RadialTimePickerView$getFadeInAnimator(IntHolder target, int startAlpha, int endAlpha, InvalidateUpdateListener updateListener) {
        int duration = 500;
        float delayMultiplier = 0.25f;
        float transitionDurationMultiplier = 1.0f;
        float totalDurationMultiplier = transitionDurationMultiplier + delayMultiplier;
        int totalDuration = (int)((float)duration * totalDurationMultiplier);
        float delayPoint = delayMultiplier * (float)duration / (float)totalDuration;
        Keyframe kf0 = Keyframe.ofInt(0.0f, startAlpha);
        Keyframe kf1 = Keyframe.ofInt(delayPoint, startAlpha);
        Keyframe kf2 = Keyframe.ofInt(1.0f, endAlpha);
        PropertyValuesHolder fadeIn = PropertyValuesHolder.ofKeyframe("value", kf0, kf1, kf2);
        ValueAnimator animator2 = ObjectAnimator.ofPropertyValuesHolder(target, fadeIn).setDuration(totalDuration);
        animator2.addUpdateListener(updateListener);
        return animator2;
    }

    private final void $$robo$$android_widget_RadialTimePickerView$startHoursToMinutesAnimation() {
        if (this.mHoursToMinutesAnims.size() == 0) {
            this.mHoursToMinutesAnims.add(RadialTimePickerView.getRadiusDisappearAnimator(this, "animationRadiusMultiplierHours", this.mInvalidateUpdateListener, this.mTransitionMidRadiusMultiplier, this.mTransitionEndRadiusMultiplier));
            this.mHoursToMinutesAnims.add(RadialTimePickerView.getFadeOutAnimator(this.mAlpha[0], 255, 0, this.mInvalidateUpdateListener));
            this.mHoursToMinutesAnims.add(RadialTimePickerView.getFadeOutAnimator(this.mAlphaSelector[0][0], 60, 0, this.mInvalidateUpdateListener));
            this.mHoursToMinutesAnims.add(RadialTimePickerView.getFadeOutAnimator(this.mAlphaSelector[0][1], 255, 0, this.mInvalidateUpdateListener));
            this.mHoursToMinutesAnims.add(RadialTimePickerView.getFadeOutAnimator(this.mAlphaSelector[0][2], 60, 0, this.mInvalidateUpdateListener));
            this.mHoursToMinutesAnims.add(RadialTimePickerView.getRadiusReappearAnimator(this, "animationRadiusMultiplierMinutes", this.mInvalidateUpdateListener, this.mTransitionMidRadiusMultiplier, this.mTransitionEndRadiusMultiplier));
            this.mHoursToMinutesAnims.add(RadialTimePickerView.getFadeInAnimator(this.mAlpha[1], 0, 255, this.mInvalidateUpdateListener));
            this.mHoursToMinutesAnims.add(RadialTimePickerView.getFadeInAnimator(this.mAlphaSelector[1][0], 0, 60, this.mInvalidateUpdateListener));
            this.mHoursToMinutesAnims.add(RadialTimePickerView.getFadeInAnimator(this.mAlphaSelector[1][1], 0, 255, this.mInvalidateUpdateListener));
            this.mHoursToMinutesAnims.add(RadialTimePickerView.getFadeInAnimator(this.mAlphaSelector[1][2], 0, 60, this.mInvalidateUpdateListener));
        }
        if (this.mTransition != null && this.mTransition.isRunning()) {
            this.mTransition.end();
        }
        this.mTransition = new AnimatorSet();
        this.mTransition.playTogether(this.mHoursToMinutesAnims);
        this.mTransition.start();
    }

    private final void $$robo$$android_widget_RadialTimePickerView$startMinutesToHoursAnimation() {
        if (this.mMinuteToHoursAnims.size() == 0) {
            this.mMinuteToHoursAnims.add(RadialTimePickerView.getRadiusDisappearAnimator(this, "animationRadiusMultiplierMinutes", this.mInvalidateUpdateListener, this.mTransitionMidRadiusMultiplier, this.mTransitionEndRadiusMultiplier));
            this.mMinuteToHoursAnims.add(RadialTimePickerView.getFadeOutAnimator(this.mAlpha[1], 255, 0, this.mInvalidateUpdateListener));
            this.mMinuteToHoursAnims.add(RadialTimePickerView.getFadeOutAnimator(this.mAlphaSelector[1][0], 60, 0, this.mInvalidateUpdateListener));
            this.mMinuteToHoursAnims.add(RadialTimePickerView.getFadeOutAnimator(this.mAlphaSelector[1][1], 255, 0, this.mInvalidateUpdateListener));
            this.mMinuteToHoursAnims.add(RadialTimePickerView.getFadeOutAnimator(this.mAlphaSelector[1][2], 60, 0, this.mInvalidateUpdateListener));
            this.mMinuteToHoursAnims.add(RadialTimePickerView.getRadiusReappearAnimator(this, "animationRadiusMultiplierHours", this.mInvalidateUpdateListener, this.mTransitionMidRadiusMultiplier, this.mTransitionEndRadiusMultiplier));
            this.mMinuteToHoursAnims.add(RadialTimePickerView.getFadeInAnimator(this.mAlpha[0], 0, 255, this.mInvalidateUpdateListener));
            this.mMinuteToHoursAnims.add(RadialTimePickerView.getFadeInAnimator(this.mAlphaSelector[0][0], 0, 60, this.mInvalidateUpdateListener));
            this.mMinuteToHoursAnims.add(RadialTimePickerView.getFadeInAnimator(this.mAlphaSelector[0][1], 0, 255, this.mInvalidateUpdateListener));
            this.mMinuteToHoursAnims.add(RadialTimePickerView.getFadeInAnimator(this.mAlphaSelector[0][2], 0, 60, this.mInvalidateUpdateListener));
        }
        if (this.mTransition != null && this.mTransition.isRunning()) {
            this.mTransition.end();
        }
        this.mTransition = new AnimatorSet();
        this.mTransition.playTogether(this.mMinuteToHoursAnims);
        this.mTransition.start();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final int $$robo$$android_widget_RadialTimePickerView$getDegreesFromXY(float x, float y) {
        boolean topSide;
        double hypotenuse = Math.sqrt((y - (float)this.mYCenter) * (y - (float)this.mYCenter) + (x - (float)this.mXCenter) * (x - (float)this.mXCenter));
        if (hypotenuse > (double)this.mCircleRadius[0]) {
            return -1;
        }
        if (this.mIs24HourMode && this.mShowHours) {
            if (hypotenuse >= (double)this.mMinHypotenuseForInnerNumber && hypotenuse <= (double)this.mHalfwayHypotenusePoint) {
                this.mIsOnInnerCircle = true;
            } else {
                if (!(hypotenuse <= (double)this.mMaxHypotenuseForOuterNumber) || !(hypotenuse >= (double)this.mHalfwayHypotenusePoint)) return -1;
                this.mIsOnInnerCircle = false;
            }
        } else {
            int maxAllowedDistance;
            int index = this.mShowHours ? 0 : 1;
            float length = this.mCircleRadius[index] * this.mNumbersRadiusMultiplier[index];
            int distanceToNumber = (int)Math.abs(hypotenuse - (double)length);
            if (distanceToNumber > (maxAllowedDistance = (int)(this.mCircleRadius[index] * (1.0f - this.mNumbersRadiusMultiplier[index])))) {
                return -1;
            }
        }
        float opposite = Math.abs(y - (float)this.mYCenter);
        double degrees = Math.toDegrees(Math.asin((double)opposite / hypotenuse));
        boolean rightSide = x > (float)this.mXCenter;
        boolean bl = topSide = y < (float)this.mYCenter;
        if (rightSide && topSide) {
            degrees = 90.0 - degrees;
            return (int)degrees;
        } else if (rightSide && !topSide) {
            degrees = 90.0 + degrees;
            return (int)degrees;
        } else if (!rightSide && !topSide) {
            degrees = 270.0 - degrees;
            return (int)degrees;
        } else {
            if (rightSide || !topSide) return (int)degrees;
            degrees = 270.0 + degrees;
        }
        return (int)degrees;
    }

    private final int $$robo$$android_widget_RadialTimePickerView$getIsTouchingAmOrPm(float x, float y) {
        boolean isLayoutRtl = this.isLayoutRtl();
        int squaredYDistance = (int)((y - this.mAmPmYCenter) * (y - this.mAmPmYCenter));
        int distanceToAmCenter = (int)Math.sqrt((x - this.mLeftIndicatorXCenter) * (x - this.mLeftIndicatorXCenter) + (float)squaredYDistance);
        if (distanceToAmCenter <= this.mAmPmCircleRadius) {
            return isLayoutRtl ? 1 : 0;
        }
        int distanceToPmCenter = (int)Math.sqrt((x - this.mRightIndicatorXCenter) * (x - this.mRightIndicatorXCenter) + (float)squaredYDistance);
        if (distanceToPmCenter <= this.mAmPmCircleRadius) {
            return isLayoutRtl ? 0 : 1;
        }
        return -1;
    }

    private final boolean $$robo$$android_widget_RadialTimePickerView$onTouch(View v, MotionEvent event) {
        if (!this.mInputEnabled) {
            return true;
        }
        float eventX = event.getX();
        float eventY = event.getY();
        boolean result = false;
        switch (event.getAction()) {
            case 0: 
            case 2: {
                this.mAmOrPmPressed = this.getIsTouchingAmOrPm(eventX, eventY);
                if (this.mAmOrPmPressed != -1) {
                    result = true;
                } else {
                    int degrees = this.getDegreesFromXY(eventX, eventY);
                    if (degrees != -1) {
                        int snapDegrees = (this.mShowHours ? RadialTimePickerView.snapOnly30s(degrees, 0) : RadialTimePickerView.snapPrefer30s(degrees)) % 360;
                        if (this.mShowHours) {
                            this.mSelectionDegrees[0] = snapDegrees;
                            this.mSelectionDegrees[2] = snapDegrees;
                        } else {
                            this.mSelectionDegrees[1] = snapDegrees;
                        }
                        this.performHapticFeedback(4);
                        if (this.mListener != null) {
                            if (this.mShowHours) {
                                this.mListener.onValueSelected(0, this.getCurrentHour(), false);
                            } else {
                                this.mListener.onValueSelected(1, this.getCurrentMinute(), false);
                            }
                        }
                        result = true;
                    }
                }
                this.invalidate();
                return result;
            }
            case 1: {
                this.mAmOrPmPressed = this.getIsTouchingAmOrPm(eventX, eventY);
                if (this.mAmOrPmPressed != -1) {
                    if (this.mAmOrPm != this.mAmOrPmPressed) {
                        this.swapAmPm();
                    }
                    this.mAmOrPmPressed = -1;
                    if (this.mListener != null) {
                        this.mListener.onValueSelected(3, this.getCurrentHour(), true);
                    }
                    result = true;
                } else {
                    int degrees = this.getDegreesFromXY(eventX, eventY);
                    if (degrees != -1) {
                        int snapDegrees = (this.mShowHours ? RadialTimePickerView.snapOnly30s(degrees, 0) : RadialTimePickerView.snapPrefer30s(degrees)) % 360;
                        if (this.mShowHours) {
                            this.mSelectionDegrees[0] = snapDegrees;
                            this.mSelectionDegrees[2] = snapDegrees;
                        } else {
                            this.mSelectionDegrees[1] = snapDegrees;
                        }
                        if (this.mListener != null) {
                            if (this.mShowHours) {
                                this.mListener.onValueSelected(0, this.getCurrentHour(), true);
                            } else {
                                this.mListener.onValueSelected(1, this.getCurrentMinute(), true);
                            }
                        }
                        result = true;
                    }
                }
                if (result) {
                    this.invalidate();
                }
                return result;
            }
        }
        return false;
    }

    private final void $$robo$$android_widget_RadialTimePickerView$onInitializeAccessibilityNodeInfo(AccessibilityNodeInfo info) {
        super.onInitializeAccessibilityNodeInfo(info);
        info.addAction(4096);
        info.addAction(8192);
    }

    private final boolean $$robo$$android_widget_RadialTimePickerView$dispatchPopulateAccessibilityEvent(AccessibilityEvent event) {
        if (event.getEventType() == 32) {
            event.getText().clear();
            Time time = new Time();
            time.hour = this.getCurrentHour();
            time.minute = this.getCurrentMinute();
            long millis = time.normalize(true);
            int flags = 1;
            if (this.mIs24HourMode) {
                flags |= 0x80;
            }
            String timeString = DateUtils.formatDateTime(this.getContext(), millis, flags);
            event.getText().add(timeString);
            return true;
        }
        return super.dispatchPopulateAccessibilityEvent(event);
    }

    @SuppressLint(value={"NewApi"})
    private final boolean $$robo$$android_widget_RadialTimePickerView$performAccessibilityAction(int action, Bundle arguments) {
        if (super.performAccessibilityAction(action, arguments)) {
            return true;
        }
        int changeMultiplier = 0;
        if (action == 4096) {
            changeMultiplier = 1;
        } else if (action == 8192) {
            changeMultiplier = -1;
        }
        if (changeMultiplier != 0) {
            int value = 0;
            int stepSize = 0;
            if (this.mShowHours) {
                stepSize = 30;
                value = this.getCurrentHour() % 12;
            } else {
                stepSize = 6;
                value = this.getCurrentMinute();
            }
            int degrees = value * stepSize;
            degrees = RadialTimePickerView.snapOnly30s(degrees, changeMultiplier);
            value = degrees / stepSize;
            int maxValue = 0;
            int minValue = 0;
            if (this.mShowHours) {
                if (this.mIs24HourMode) {
                    maxValue = 23;
                } else {
                    maxValue = 12;
                    minValue = 1;
                }
            } else {
                maxValue = 55;
            }
            if (value > maxValue) {
                value = minValue;
            } else if (value < minValue) {
                value = maxValue;
            }
            if (this.mShowHours) {
                this.setCurrentHour(value);
                if (this.mListener != null) {
                    this.mListener.onValueSelected(0, value, false);
                }
            } else {
                this.setCurrentMinute(value);
                if (this.mListener != null) {
                    this.mListener.onValueSelected(1, value, false);
                }
            }
            return true;
        }
        return false;
    }

    private final void $$robo$$android_widget_RadialTimePickerView$setInputEnabled(boolean inputEnabled) {
        this.mInputEnabled = inputEnabled;
        this.invalidate();
    }

    static void __staticInitializer__() {
        COSINE_30_DEGREES = (float)Math.sqrt(3.0) * 0.5f;
        HOURS_NUMBERS = new int[]{12, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11};
        HOURS_NUMBERS_24 = new int[]{0, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23};
        MINUTES_NUMBERS = new int[]{0, 5, 10, 15, 20, 25, 30, 35, 40, 45, 50, 55};
        STATE_SET_SELECTED = new int[]{0x10100A1};
        sSnapPrefer30sMap = new int[361];
        RadialTimePickerView.preparePrefer30sMap();
    }

    private static void preparePrefer30sMap() {
        InvokeDynamicSupport.bootstrapStatic("preparePrefer30sMap", $$robo$$android_widget_RadialTimePickerView$preparePrefer30sMap(), 0);
    }

    private static int snapPrefer30s(int n) {
        return (int)InvokeDynamicSupport.bootstrapStatic("snapPrefer30s", $$robo$$android_widget_RadialTimePickerView$snapPrefer30s(int ), 0, (int)n);
    }

    private static int snapOnly30s(int n, int n2) {
        return (int)InvokeDynamicSupport.bootstrapStatic("snapOnly30s", $$robo$$android_widget_RadialTimePickerView$snapOnly30s(int int ), 0, (int)n, (int)n2);
    }

    private void __constructor__(Context context, AttributeSet attributeSet) {
        this.$$robo$$android_widget_RadialTimePickerView$__constructor__(context, attributeSet);
    }

    public RadialTimePickerView(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 16843933);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_RadialTimePickerView$__constructor__(android.content.Context android.util.AttributeSet ), 0, this, context, attributeSet);
    }

    private void __constructor__(Context context, AttributeSet attributeSet, int n) {
        this.$$robo$$android_widget_RadialTimePickerView$__constructor__(context, attributeSet, n);
    }

    public RadialTimePickerView(Context context, AttributeSet attributeSet, int n) {
        super(context, attributeSet);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_RadialTimePickerView$__constructor__(android.content.Context android.util.AttributeSet int ), 0, this, context, attributeSet, n);
    }

    @Override
    public void onMeasure(int n, int n2) {
        InvokeDynamicSupport.bootstrap("onMeasure", $$robo$$android_widget_RadialTimePickerView$onMeasure(int int ), 0, this, n, n2);
    }

    public void initialize(int n, int n2, boolean bl) {
        InvokeDynamicSupport.bootstrap("initialize", $$robo$$android_widget_RadialTimePickerView$initialize(int int boolean ), 0, this, n, n2, bl);
    }

    public void setCurrentItemShowing(int n, boolean bl) {
        InvokeDynamicSupport.bootstrap("setCurrentItemShowing", $$robo$$android_widget_RadialTimePickerView$setCurrentItemShowing(int boolean ), 0, this, n, bl);
    }

    public int getCurrentItemShowing() {
        return (int)InvokeDynamicSupport.bootstrap("getCurrentItemShowing", $$robo$$android_widget_RadialTimePickerView$getCurrentItemShowing(), 0, this);
    }

    public void setOnValueSelectedListener(OnValueSelectedListener onValueSelectedListener) {
        InvokeDynamicSupport.bootstrap("setOnValueSelectedListener", $$robo$$android_widget_RadialTimePickerView$setOnValueSelectedListener(android.widget.RadialTimePickerView$OnValueSelectedListener ), 0, this, onValueSelectedListener);
    }

    public void setCurrentHour(int n) {
        InvokeDynamicSupport.bootstrap("setCurrentHour", $$robo$$android_widget_RadialTimePickerView$setCurrentHour(int ), 0, this, n);
    }

    public int getCurrentHour() {
        return (int)InvokeDynamicSupport.bootstrap("getCurrentHour", $$robo$$android_widget_RadialTimePickerView$getCurrentHour(), 0, this);
    }

    public void setCurrentMinute(int n) {
        InvokeDynamicSupport.bootstrap("setCurrentMinute", $$robo$$android_widget_RadialTimePickerView$setCurrentMinute(int ), 0, this, n);
    }

    public int getCurrentMinute() {
        return (int)InvokeDynamicSupport.bootstrap("getCurrentMinute", $$robo$$android_widget_RadialTimePickerView$getCurrentMinute(), 0, this);
    }

    public void setAmOrPm(int n) {
        InvokeDynamicSupport.bootstrap("setAmOrPm", $$robo$$android_widget_RadialTimePickerView$setAmOrPm(int ), 0, this, n);
    }

    public int getAmOrPm() {
        return (int)InvokeDynamicSupport.bootstrap("getAmOrPm", $$robo$$android_widget_RadialTimePickerView$getAmOrPm(), 0, this);
    }

    public void swapAmPm() {
        InvokeDynamicSupport.bootstrap("swapAmPm", $$robo$$android_widget_RadialTimePickerView$swapAmPm(), 0, this);
    }

    public void showHours(boolean bl) {
        InvokeDynamicSupport.bootstrap("showHours", $$robo$$android_widget_RadialTimePickerView$showHours(boolean ), 0, this, bl);
    }

    public void showMinutes(boolean bl) {
        InvokeDynamicSupport.bootstrap("showMinutes", $$robo$$android_widget_RadialTimePickerView$showMinutes(boolean ), 0, this, bl);
    }

    private void initHoursAndMinutesText() {
        InvokeDynamicSupport.bootstrap("initHoursAndMinutesText", $$robo$$android_widget_RadialTimePickerView$initHoursAndMinutesText(), 0, this);
    }

    private void initData() {
        InvokeDynamicSupport.bootstrap("initData", $$robo$$android_widget_RadialTimePickerView$initData(), 0, this);
    }

    @Override
    protected void onLayout(boolean bl, int n, int n2, int n3, int n4) {
        InvokeDynamicSupport.bootstrap("onLayout", $$robo$$android_widget_RadialTimePickerView$onLayout(boolean int int int int ), 0, this, bl, n, n2, n3, n4);
    }

    private void updateLayoutData() {
        InvokeDynamicSupport.bootstrap("updateLayoutData", $$robo$$android_widget_RadialTimePickerView$updateLayoutData(), 0, this);
    }

    @Override
    public void onDraw(Canvas canvas) {
        InvokeDynamicSupport.bootstrap("onDraw", $$robo$$android_widget_RadialTimePickerView$onDraw(android.graphics.Canvas ), 0, this, canvas);
    }

    private void drawCircleBackground(Canvas canvas) {
        InvokeDynamicSupport.bootstrap("drawCircleBackground", $$robo$$android_widget_RadialTimePickerView$drawCircleBackground(android.graphics.Canvas ), 0, this, canvas);
    }

    private void drawCenter(Canvas canvas) {
        InvokeDynamicSupport.bootstrap("drawCenter", $$robo$$android_widget_RadialTimePickerView$drawCenter(android.graphics.Canvas ), 0, this, canvas);
    }

    private void drawSelector(Canvas canvas) {
        InvokeDynamicSupport.bootstrap("drawSelector", $$robo$$android_widget_RadialTimePickerView$drawSelector(android.graphics.Canvas ), 0, this, canvas);
    }

    private void drawAmPm(Canvas canvas) {
        InvokeDynamicSupport.bootstrap("drawAmPm", $$robo$$android_widget_RadialTimePickerView$drawAmPm(android.graphics.Canvas ), 0, this, canvas);
    }

    private int getMultipliedAlpha(int n, int n2) {
        return (int)InvokeDynamicSupport.bootstrap("getMultipliedAlpha", $$robo$$android_widget_RadialTimePickerView$getMultipliedAlpha(int int ), 0, this, n, n2);
    }

    private void drawSelector(Canvas canvas, int n) {
        InvokeDynamicSupport.bootstrap("drawSelector", $$robo$$android_widget_RadialTimePickerView$drawSelector(android.graphics.Canvas int ), 0, this, canvas, n);
    }

    private void drawDebug(Canvas canvas) {
        InvokeDynamicSupport.bootstrap("drawDebug", $$robo$$android_widget_RadialTimePickerView$drawDebug(android.graphics.Canvas ), 0, this, canvas);
    }

    private void calculateGridSizesHours() {
        InvokeDynamicSupport.bootstrap("calculateGridSizesHours", $$robo$$android_widget_RadialTimePickerView$calculateGridSizesHours(), 0, this);
    }

    private void calculateGridSizesMinutes() {
        InvokeDynamicSupport.bootstrap("calculateGridSizesMinutes", $$robo$$android_widget_RadialTimePickerView$calculateGridSizesMinutes(), 0, this);
    }

    private static void calculateGridSizes(Paint paint, float f, float f2, float f3, float f4, float[] fArray, float[] fArray2) {
        InvokeDynamicSupport.bootstrapStatic("calculateGridSizes", $$robo$$android_widget_RadialTimePickerView$calculateGridSizes(android.graphics.Paint float float float float float[] float[] ), 0, (Paint)paint, (float)f, (float)f2, (float)f3, (float)f4, (float[])fArray, (float[])fArray2);
    }

    private void drawTextElements(Canvas canvas, float f, Typeface typeface, String[] stringArray, float[] fArray, float[] fArray2, Paint paint, int n, int n2) {
        InvokeDynamicSupport.bootstrap("drawTextElements", $$robo$$android_widget_RadialTimePickerView$drawTextElements(android.graphics.Canvas float android.graphics.Typeface java.lang.String[] float[] float[] android.graphics.Paint int int ), 0, this, canvas, f, typeface, stringArray, fArray, fArray2, paint, n, n2);
    }

    private void setAnimationRadiusMultiplierHours(float f) {
        InvokeDynamicSupport.bootstrap("setAnimationRadiusMultiplierHours", $$robo$$android_widget_RadialTimePickerView$setAnimationRadiusMultiplierHours(float ), 0, this, f);
    }

    private void setAnimationRadiusMultiplierMinutes(float f) {
        InvokeDynamicSupport.bootstrap("setAnimationRadiusMultiplierMinutes", $$robo$$android_widget_RadialTimePickerView$setAnimationRadiusMultiplierMinutes(float ), 0, this, f);
    }

    private static ObjectAnimator getRadiusDisappearAnimator(Object object, String string2, InvalidateUpdateListener invalidateUpdateListener, float f, float f2) {
        return InvokeDynamicSupport.bootstrapStatic("getRadiusDisappearAnimator", $$robo$$android_widget_RadialTimePickerView$getRadiusDisappearAnimator(java.lang.Object java.lang.String android.widget.RadialTimePickerView$InvalidateUpdateListener float float ), 0, (Object)object, (String)string2, (InvalidateUpdateListener)invalidateUpdateListener, (float)f, (float)f2);
    }

    private static ObjectAnimator getRadiusReappearAnimator(Object object, String string2, InvalidateUpdateListener invalidateUpdateListener, float f, float f2) {
        return InvokeDynamicSupport.bootstrapStatic("getRadiusReappearAnimator", $$robo$$android_widget_RadialTimePickerView$getRadiusReappearAnimator(java.lang.Object java.lang.String android.widget.RadialTimePickerView$InvalidateUpdateListener float float ), 0, (Object)object, (String)string2, (InvalidateUpdateListener)invalidateUpdateListener, (float)f, (float)f2);
    }

    private static ObjectAnimator getFadeOutAnimator(IntHolder intHolder, int n, int n2, InvalidateUpdateListener invalidateUpdateListener) {
        return InvokeDynamicSupport.bootstrapStatic("getFadeOutAnimator", $$robo$$android_widget_RadialTimePickerView$getFadeOutAnimator(android.widget.RadialTimePickerView$IntHolder int int android.widget.RadialTimePickerView$InvalidateUpdateListener ), 0, (IntHolder)intHolder, (int)n, (int)n2, (InvalidateUpdateListener)invalidateUpdateListener);
    }

    private static ObjectAnimator getFadeInAnimator(IntHolder intHolder, int n, int n2, InvalidateUpdateListener invalidateUpdateListener) {
        return InvokeDynamicSupport.bootstrapStatic("getFadeInAnimator", $$robo$$android_widget_RadialTimePickerView$getFadeInAnimator(android.widget.RadialTimePickerView$IntHolder int int android.widget.RadialTimePickerView$InvalidateUpdateListener ), 0, (IntHolder)intHolder, (int)n, (int)n2, (InvalidateUpdateListener)invalidateUpdateListener);
    }

    private void startHoursToMinutesAnimation() {
        InvokeDynamicSupport.bootstrap("startHoursToMinutesAnimation", $$robo$$android_widget_RadialTimePickerView$startHoursToMinutesAnimation(), 0, this);
    }

    private void startMinutesToHoursAnimation() {
        InvokeDynamicSupport.bootstrap("startMinutesToHoursAnimation", $$robo$$android_widget_RadialTimePickerView$startMinutesToHoursAnimation(), 0, this);
    }

    private int getDegreesFromXY(float f, float f2) {
        return (int)InvokeDynamicSupport.bootstrap("getDegreesFromXY", $$robo$$android_widget_RadialTimePickerView$getDegreesFromXY(float float ), 0, this, f, f2);
    }

    private int getIsTouchingAmOrPm(float f, float f2) {
        return (int)InvokeDynamicSupport.bootstrap("getIsTouchingAmOrPm", $$robo$$android_widget_RadialTimePickerView$getIsTouchingAmOrPm(float float ), 0, this, f, f2);
    }

    @Override
    public boolean onTouch(View view, MotionEvent motionEvent) {
        return (boolean)InvokeDynamicSupport.bootstrap("onTouch", $$robo$$android_widget_RadialTimePickerView$onTouch(android.view.View android.view.MotionEvent ), 0, this, view, motionEvent);
    }

    @Override
    public void onInitializeAccessibilityNodeInfo(AccessibilityNodeInfo accessibilityNodeInfo) {
        InvokeDynamicSupport.bootstrap("onInitializeAccessibilityNodeInfo", $$robo$$android_widget_RadialTimePickerView$onInitializeAccessibilityNodeInfo(android.view.accessibility.AccessibilityNodeInfo ), 0, this, accessibilityNodeInfo);
    }

    @Override
    public boolean dispatchPopulateAccessibilityEvent(AccessibilityEvent accessibilityEvent) {
        return (boolean)InvokeDynamicSupport.bootstrap("dispatchPopulateAccessibilityEvent", $$robo$$android_widget_RadialTimePickerView$dispatchPopulateAccessibilityEvent(android.view.accessibility.AccessibilityEvent ), 0, this, accessibilityEvent);
    }

    @Override
    public boolean performAccessibilityAction(int n, Bundle bundle) {
        return (boolean)InvokeDynamicSupport.bootstrap("performAccessibilityAction", $$robo$$android_widget_RadialTimePickerView$performAccessibilityAction(int android.os.Bundle ), 0, this, n, bundle);
    }

    public void setInputEnabled(boolean bl) {
        InvokeDynamicSupport.bootstrap("setInputEnabled", $$robo$$android_widget_RadialTimePickerView$setInputEnabled(boolean ), 0, this, bl);
    }

    static {
        RobolectricInternals.classInitializing(RadialTimePickerView.class);
    }

    public /* synthetic */ RadialTimePickerView() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (RadialTimePickerView)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    private static class IntHolder
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private int mValue;

        private void $$robo$$android_widget_RadialTimePickerView_IntHolder$__constructor__(int value) {
            this.mValue = value;
        }

        private final void $$robo$$android_widget_RadialTimePickerView_IntHolder$setValue(int value) {
            this.mValue = value;
        }

        private final int $$robo$$android_widget_RadialTimePickerView_IntHolder$getValue() {
            return this.mValue;
        }

        private void __constructor__(int n) {
            this.$$robo$$android_widget_RadialTimePickerView_IntHolder$__constructor__(n);
        }

        public IntHolder(int n) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_RadialTimePickerView_IntHolder$__constructor__(int ), 0, this, n);
        }

        public void setValue(int n) {
            InvokeDynamicSupport.bootstrap("setValue", $$robo$$android_widget_RadialTimePickerView_IntHolder$setValue(int ), 0, this, n);
        }

        public int getValue() {
            return (int)InvokeDynamicSupport.bootstrap("getValue", $$robo$$android_widget_RadialTimePickerView_IntHolder$getValue(), 0, this);
        }

        public /* synthetic */ IntHolder() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (IntHolder)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private class InvalidateUpdateListener
    implements ValueAnimator.AnimatorUpdateListener,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        /* synthetic */ RadialTimePickerView this$0;

        private void $$robo$$android_widget_RadialTimePickerView_InvalidateUpdateListener$__constructor__(RadialTimePickerView radialTimePickerView) {
        }

        private final void $$robo$$android_widget_RadialTimePickerView_InvalidateUpdateListener$onAnimationUpdate(ValueAnimator animation) {
            this.this$0.invalidate();
        }

        private /* synthetic */ void $$robo$$android_widget_RadialTimePickerView_InvalidateUpdateListener$__constructor__(RadialTimePickerView x0, 1 x1) {
        }

        private void __constructor__(RadialTimePickerView radialTimePickerView) {
            this.$$robo$$android_widget_RadialTimePickerView_InvalidateUpdateListener$__constructor__(radialTimePickerView);
        }

        private InvalidateUpdateListener(RadialTimePickerView radialTimePickerView) {
            this.this$0 = radialTimePickerView;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_RadialTimePickerView_InvalidateUpdateListener$__constructor__(android.widget.RadialTimePickerView ), 0, this, radialTimePickerView);
        }

        @Override
        public void onAnimationUpdate(ValueAnimator valueAnimator) {
            InvokeDynamicSupport.bootstrap("onAnimationUpdate", $$robo$$android_widget_RadialTimePickerView_InvalidateUpdateListener$onAnimationUpdate(android.animation.ValueAnimator ), 0, this, valueAnimator);
        }

        private /* synthetic */ void __constructor__(RadialTimePickerView radialTimePickerView, 1 var2_2) {
            this.$$robo$$android_widget_RadialTimePickerView_InvalidateUpdateListener$__constructor__(radialTimePickerView, var2_2);
        }

        public /* synthetic */ InvalidateUpdateListener() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (InvalidateUpdateListener)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static interface OnValueSelectedListener
    extends InstrumentedInterface {
        public void onValueSelected(int var1, int var2, boolean var3);
    }
}

