/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.app.ActivityOptions;
import android.app.ActivityThread;
import android.app.Application;
import android.app.PendingIntent;
import android.appwidget.AppWidgetHostView;
import android.content.Context;
import android.content.Intent;
import android.content.IntentSender;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.PorterDuff;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.StrictMode;
import android.os.UserHandle;
import android.text.TextUtils;
import android.util.ArrayMap;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.RemotableViewMethod;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AbsListView;
import android.widget.Adapter;
import android.widget.AdapterView;
import android.widget.AdapterViewAnimator;
import android.widget.ImageView;
import android.widget.RemoteViewsListAdapter;
import android.widget.TextView;
import com.google.errorprone.annotations.DoNotMock;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import libcore.util.Objects;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class RemoteViews
implements Parcelable,
LayoutInflater.Filter,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String LOG_TAG = "RemoteViews";
    static String EXTRA_REMOTEADAPTER_APPWIDGET_ID = "remoteAdapterAppWidgetId";
    private ApplicationInfo mApplication;
    private int mLayoutId;
    private ArrayList<Action> mActions;
    private MemoryUsageCounter mMemoryUsageCounter;
    private BitmapCache mBitmapCache;
    private boolean mIsRoot;
    private static int MODE_NORMAL = 0;
    private static int MODE_HAS_LANDSCAPE_AND_PORTRAIT = 1;
    private RemoteViews mLandscape;
    private RemoteViews mPortrait;
    private boolean mIsWidgetCollectionChild;
    private static OnClickHandler DEFAULT_ON_CLICK_HANDLER;
    private static Object[] sMethodsLock;
    private static ArrayMap<Class<? extends View>, ArrayMap<MutablePair<String, Class<?>>, Method>> sMethods;
    private static ThreadLocal<Object[]> sInvokeArgsTls;
    private MutablePair<String, Class<?>> mPair;
    public static Parcelable.Creator<RemoteViews> CREATOR;

    private final void $$robo$$android_widget_RemoteViews$mergeRemoteViews(RemoteViews newRv) {
        if (newRv == null) {
            return;
        }
        Object copy = newRv.clone();
        HashMap<String, Action> map = new HashMap<String, Action>();
        if (this.mActions == null) {
            this.mActions = new ArrayList();
        }
        int count = this.mActions.size();
        for (int i = 0; i < count; ++i) {
            Action a = this.mActions.get(i);
            map.put(a.getUniqueKey(), a);
        }
        ArrayList<Action> newActions = ((RemoteViews)copy).mActions;
        if (newActions == null) {
            return;
        }
        count = newActions.size();
        for (int i = 0; i < count; ++i) {
            Action a = newActions.get(i);
            String key = newActions.get(i).getUniqueKey();
            int mergeBehavior = newActions.get(i).mergeBehavior();
            if (map.containsKey(key) && mergeBehavior == 0) {
                this.mActions.remove(map.get(key));
                map.remove(key);
            }
            if (mergeBehavior != 0 && mergeBehavior != 1) continue;
            this.mActions.add(a);
        }
        this.mBitmapCache = new BitmapCache();
        this.setBitmapCache(this.mBitmapCache);
    }

    private static final Rect $$robo$$android_widget_RemoteViews$getSourceBounds(View v) {
        float appScale = v.getContext().getResources().getCompatibilityInfo().applicationScale;
        int[] pos = new int[2];
        v.getLocationOnScreen(pos);
        Rect rect = new Rect();
        rect.left = (int)((float)pos[0] * appScale + 0.5f);
        rect.top = (int)((float)pos[1] * appScale + 0.5f);
        rect.right = (int)((float)(pos[0] + v.getWidth()) * appScale + 0.5f);
        rect.bottom = (int)((float)(pos[1] + v.getHeight()) * appScale + 0.5f);
        return rect;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Method $$robo$$android_widget_RemoteViews$getMethod(View view, String methodName, Class<?> paramType) {
        Class<?> klass = view.getClass();
        Object[] objectArray = sMethodsLock;
        synchronized (sMethodsLock) {
            ArrayMap<MutablePair<String, Class<Object>>, Method> methods = sMethods.get(klass);
            if (methods == null) {
                methods = new ArrayMap();
                sMethods.put(klass, methods);
            }
            this.mPair.first = methodName;
            this.mPair.second = paramType;
            Method method = methods.get(this.mPair);
            if (method == null) {
                try {
                    method = paramType == null ? klass.getMethod(methodName, new Class[0]) : klass.getMethod(methodName, paramType);
                }
                catch (NoSuchMethodException ex) {
                    throw new ActionException("view: " + klass.getName() + " doesn't have method: " + methodName + RemoteViews.getParameters(paramType));
                }
                if (!method.isAnnotationPresent(RemotableViewMethod.class)) {
                    throw new ActionException("view: " + klass.getName() + " can't use method with RemoteViews: " + methodName + RemoteViews.getParameters(paramType));
                }
                methods.put(new MutablePair(methodName, paramType), method);
            }
            // ** MonitorExit[var6_5] (shouldn't be in output)
            return method;
        }
    }

    private static final String $$robo$$android_widget_RemoteViews$getParameters(Class<?> paramType) {
        if (paramType == null) {
            return "()";
        }
        return "(" + paramType + ")";
    }

    private static final Object[] $$robo$$android_widget_RemoteViews$wrapArg(Object value) {
        Object[] args = sInvokeArgsTls.get();
        args[0] = value;
        return args;
    }

    private final void $$robo$$android_widget_RemoteViews$configureRemoteViewsAsChild(RemoteViews rv) {
        this.mBitmapCache.assimilate(rv.mBitmapCache);
        rv.setBitmapCache(this.mBitmapCache);
        rv.setNotRoot();
    }

    private final void $$robo$$android_widget_RemoteViews$setNotRoot() {
        this.mIsRoot = false;
    }

    private void $$robo$$android_widget_RemoteViews$__constructor__(String packageName, int layoutId) {
    }

    private void $$robo$$android_widget_RemoteViews$__constructor__(String packageName, int userId, int layoutId) {
    }

    private void $$robo$$android_widget_RemoteViews$__constructor__(ApplicationInfo application, int layoutId) {
        this.mIsRoot = true;
        this.mLandscape = null;
        this.mPortrait = null;
        this.mIsWidgetCollectionChild = false;
        this.mPair = new MutablePair<Object, Object>(null, null);
        this.mApplication = application;
        this.mLayoutId = layoutId;
        this.mBitmapCache = new BitmapCache();
        this.mMemoryUsageCounter = new MemoryUsageCounter(this);
        this.recalculateMemoryUsage();
    }

    private final boolean $$robo$$android_widget_RemoteViews$hasLandscapeAndPortraitLayouts() {
        return this.mLandscape != null && this.mPortrait != null;
    }

    private void $$robo$$android_widget_RemoteViews$__constructor__(RemoteViews landscape, RemoteViews portrait) {
        this.mIsRoot = true;
        this.mLandscape = null;
        this.mPortrait = null;
        this.mIsWidgetCollectionChild = false;
        this.mPair = new MutablePair<Object, Object>(null, null);
        if (landscape == null || portrait == null) {
            throw new RuntimeException("Both RemoteViews must be non-null");
        }
        if (landscape.mApplication.uid != portrait.mApplication.uid || !landscape.mApplication.packageName.equals(portrait.mApplication.packageName)) {
            throw new RuntimeException("Both RemoteViews must share the same package and user");
        }
        this.mApplication = portrait.mApplication;
        this.mLayoutId = portrait.getLayoutId();
        this.mLandscape = landscape;
        this.mPortrait = portrait;
        this.mMemoryUsageCounter = new MemoryUsageCounter(this);
        this.mBitmapCache = new BitmapCache();
        this.configureRemoteViewsAsChild(landscape);
        this.configureRemoteViewsAsChild(portrait);
        this.recalculateMemoryUsage();
    }

    private void $$robo$$android_widget_RemoteViews$__constructor__(Parcel parcel) {
    }

    private void $$robo$$android_widget_RemoteViews$__constructor__(Parcel parcel, BitmapCache bitmapCache) {
        this.mIsRoot = true;
        this.mLandscape = null;
        this.mPortrait = null;
        this.mIsWidgetCollectionChild = false;
        this.mPair = new MutablePair<Object, Object>(null, null);
        int mode = parcel.readInt();
        if (bitmapCache == null) {
            this.mBitmapCache = new BitmapCache(parcel);
        } else {
            this.setBitmapCache(bitmapCache);
            this.setNotRoot();
        }
        if (mode == 0) {
            this.mApplication = (ApplicationInfo)parcel.readParcelable(null);
            this.mLayoutId = parcel.readInt();
            this.mIsWidgetCollectionChild = parcel.readInt() == 1;
            int count = parcel.readInt();
            if (count > 0) {
                this.mActions = new ArrayList(count);
                block17: for (int i = 0; i < count; ++i) {
                    int tag = parcel.readInt();
                    switch (tag) {
                        case 1: {
                            this.mActions.add(new SetOnClickPendingIntent(this, parcel));
                            continue block17;
                        }
                        case 3: {
                            this.mActions.add(new SetDrawableParameters(this, parcel));
                            continue block17;
                        }
                        case 2: {
                            this.mActions.add(new ReflectionAction(this, parcel));
                            continue block17;
                        }
                        case 4: {
                            this.mActions.add(new ViewGroupAction(this, parcel, this.mBitmapCache));
                            continue block17;
                        }
                        case 5: {
                            this.mActions.add(new ReflectionActionWithoutParams(this, parcel));
                            continue block17;
                        }
                        case 6: {
                            this.mActions.add(new SetEmptyView(this, parcel));
                            continue block17;
                        }
                        case 8: {
                            this.mActions.add(new SetPendingIntentTemplate(this, parcel));
                            continue block17;
                        }
                        case 9: {
                            this.mActions.add(new SetOnClickFillInIntent(this, parcel));
                            continue block17;
                        }
                        case 10: {
                            this.mActions.add(new SetRemoteViewsAdapterIntent(this, parcel));
                            continue block17;
                        }
                        case 11: {
                            this.mActions.add(new TextViewDrawableAction(this, parcel));
                            continue block17;
                        }
                        case 13: {
                            this.mActions.add(new TextViewSizeAction(this, parcel));
                            continue block17;
                        }
                        case 14: {
                            this.mActions.add(new ViewPaddingAction(this, parcel));
                            continue block17;
                        }
                        case 12: {
                            this.mActions.add(new BitmapReflectionAction(this, parcel));
                            continue block17;
                        }
                        case 15: {
                            this.mActions.add(new SetRemoteViewsAdapterList(this, parcel));
                            continue block17;
                        }
                        case 17: {
                            this.mActions.add(new TextViewDrawableColorFilterAction(this, parcel));
                            continue block17;
                        }
                        default: {
                            throw new ActionException("Tag " + tag + " not found");
                        }
                    }
                }
            }
        } else {
            this.mLandscape = new RemoteViews(parcel, this.mBitmapCache);
            this.mPortrait = new RemoteViews(parcel, this.mBitmapCache);
            this.mApplication = this.mPortrait.mApplication;
            this.mLayoutId = this.mPortrait.getLayoutId();
        }
        this.mMemoryUsageCounter = new MemoryUsageCounter(this);
        this.recalculateMemoryUsage();
    }

    private final RemoteViews $$robo$$android_widget_RemoteViews$clone() {
        Parcel p = Parcel.obtain();
        this.writeToParcel(p, 0);
        p.setDataPosition(0);
        RemoteViews rv = new RemoteViews(p);
        p.recycle();
        return rv;
    }

    private final String $$robo$$android_widget_RemoteViews$getPackage() {
        return this.mApplication != null ? this.mApplication.packageName : null;
    }

    private final int $$robo$$android_widget_RemoteViews$getLayoutId() {
        return this.mLayoutId;
    }

    private final void $$robo$$android_widget_RemoteViews$setIsWidgetCollectionChild(boolean isWidgetCollectionChild) {
        this.mIsWidgetCollectionChild = isWidgetCollectionChild;
    }

    private final void $$robo$$android_widget_RemoteViews$recalculateMemoryUsage() {
        this.mMemoryUsageCounter.clear();
        if (!this.hasLandscapeAndPortraitLayouts()) {
            if (this.mActions != null) {
                int count = this.mActions.size();
                for (int i = 0; i < count; ++i) {
                    this.mActions.get(i).updateMemoryUsageEstimate(this.mMemoryUsageCounter);
                }
            }
            if (this.mIsRoot) {
                this.mBitmapCache.addBitmapMemory(this.mMemoryUsageCounter);
            }
        } else {
            this.mMemoryUsageCounter.increment(this.mLandscape.estimateMemoryUsage());
            this.mMemoryUsageCounter.increment(this.mPortrait.estimateMemoryUsage());
            this.mBitmapCache.addBitmapMemory(this.mMemoryUsageCounter);
        }
    }

    private final void $$robo$$android_widget_RemoteViews$setBitmapCache(BitmapCache bitmapCache) {
        this.mBitmapCache = bitmapCache;
        if (!this.hasLandscapeAndPortraitLayouts()) {
            if (this.mActions != null) {
                int count = this.mActions.size();
                for (int i = 0; i < count; ++i) {
                    this.mActions.get(i).setBitmapCache(bitmapCache);
                }
            }
        } else {
            this.mLandscape.setBitmapCache(bitmapCache);
            this.mPortrait.setBitmapCache(bitmapCache);
        }
    }

    private final int $$robo$$android_widget_RemoteViews$estimateMemoryUsage() {
        return this.mMemoryUsageCounter.getMemoryUsage();
    }

    private final void $$robo$$android_widget_RemoteViews$addAction(Action a) {
        if (this.hasLandscapeAndPortraitLayouts()) {
            throw new RuntimeException("RemoteViews specifying separate landscape and portrait layouts cannot be modified. Instead, fully configure the landscape and portrait layouts individually before constructing the combined layout.");
        }
        if (this.mActions == null) {
            this.mActions = new ArrayList();
        }
        this.mActions.add(a);
        a.updateMemoryUsageEstimate(this.mMemoryUsageCounter);
    }

    private final void $$robo$$android_widget_RemoteViews$addView(int viewId, RemoteViews nestedView) {
        this.addAction(new ViewGroupAction(this, viewId, nestedView));
    }

    private final void $$robo$$android_widget_RemoteViews$removeAllViews(int viewId) {
        this.addAction(new ViewGroupAction(this, viewId, null));
    }

    private final void $$robo$$android_widget_RemoteViews$showNext(int viewId) {
        this.addAction(new ReflectionActionWithoutParams(this, viewId, "showNext"));
    }

    private final void $$robo$$android_widget_RemoteViews$showPrevious(int viewId) {
        this.addAction(new ReflectionActionWithoutParams(this, viewId, "showPrevious"));
    }

    private final void $$robo$$android_widget_RemoteViews$setDisplayedChild(int viewId, int childIndex) {
        this.setInt(viewId, "setDisplayedChild", childIndex);
    }

    private final void $$robo$$android_widget_RemoteViews$setViewVisibility(int viewId, int visibility) {
        this.setInt(viewId, "setVisibility", visibility);
    }

    private final void $$robo$$android_widget_RemoteViews$setTextViewText(int viewId, CharSequence text) {
        this.setCharSequence(viewId, "setText", text);
    }

    private final void $$robo$$android_widget_RemoteViews$setTextViewTextSize(int viewId, int units, float size) {
        this.addAction(new TextViewSizeAction(this, viewId, units, size));
    }

    private final void $$robo$$android_widget_RemoteViews$setTextViewCompoundDrawables(int viewId, int left, int top, int right, int bottom) {
        this.addAction(new TextViewDrawableAction(this, viewId, false, left, top, right, bottom));
    }

    private final void $$robo$$android_widget_RemoteViews$setTextViewCompoundDrawablesRelative(int viewId, int start, int top, int end, int bottom) {
        this.addAction(new TextViewDrawableAction(this, viewId, true, start, top, end, bottom));
    }

    private final void $$robo$$android_widget_RemoteViews$setTextViewCompoundDrawablesRelativeColorFilter(int viewId, int index, int color2, PorterDuff.Mode mode) {
        if (index < 0 || index >= 4) {
            throw new IllegalArgumentException("index must be in range [0, 3].");
        }
        this.addAction(new TextViewDrawableColorFilterAction(this, viewId, true, index, color2, mode));
    }

    private final void $$robo$$android_widget_RemoteViews$setImageViewResource(int viewId, int srcId) {
        this.setInt(viewId, "setImageResource", srcId);
    }

    private final void $$robo$$android_widget_RemoteViews$setImageViewUri(int viewId, Uri uri) {
        this.setUri(viewId, "setImageURI", uri);
    }

    private final void $$robo$$android_widget_RemoteViews$setImageViewBitmap(int viewId, Bitmap bitmap) {
        this.setBitmap(viewId, "setImageBitmap", bitmap);
    }

    private final void $$robo$$android_widget_RemoteViews$setEmptyView(int viewId, int emptyViewId) {
        this.addAction(new SetEmptyView(this, viewId, emptyViewId));
    }

    private final void $$robo$$android_widget_RemoteViews$setChronometer(int viewId, long base, String format, boolean started) {
        this.setLong(viewId, "setBase", base);
        this.setString(viewId, "setFormat", format);
        this.setBoolean(viewId, "setStarted", started);
    }

    private final void $$robo$$android_widget_RemoteViews$setProgressBar(int viewId, int max, int progress, boolean indeterminate) {
        this.setBoolean(viewId, "setIndeterminate", indeterminate);
        if (!indeterminate) {
            this.setInt(viewId, "setMax", max);
            this.setInt(viewId, "setProgress", progress);
        }
    }

    private final void $$robo$$android_widget_RemoteViews$setOnClickPendingIntent(int viewId, PendingIntent pendingIntent) {
        this.addAction(new SetOnClickPendingIntent(this, viewId, pendingIntent));
    }

    private final void $$robo$$android_widget_RemoteViews$setPendingIntentTemplate(int viewId, PendingIntent pendingIntentTemplate) {
        this.addAction(new SetPendingIntentTemplate(this, viewId, pendingIntentTemplate));
    }

    private final void $$robo$$android_widget_RemoteViews$setOnClickFillInIntent(int viewId, Intent fillInIntent) {
        this.addAction(new SetOnClickFillInIntent(this, viewId, fillInIntent));
    }

    private final void $$robo$$android_widget_RemoteViews$setDrawableParameters(int viewId, boolean targetBackground, int alpha, int colorFilter, PorterDuff.Mode mode, int level) {
        this.addAction(new SetDrawableParameters(this, viewId, targetBackground, alpha, colorFilter, mode, level));
    }

    private final void $$robo$$android_widget_RemoteViews$setTextColor(int viewId, int color2) {
        this.setInt(viewId, "setTextColor", color2);
    }

    @Deprecated
    private final void $$robo$$android_widget_RemoteViews$setRemoteAdapter(int appWidgetId, int viewId, Intent intent) {
        this.setRemoteAdapter(viewId, intent);
    }

    private final void $$robo$$android_widget_RemoteViews$setRemoteAdapter(int viewId, Intent intent) {
        this.addAction(new SetRemoteViewsAdapterIntent(this, viewId, intent));
    }

    private final void $$robo$$android_widget_RemoteViews$setRemoteAdapter(int viewId, ArrayList<RemoteViews> list, int viewTypeCount) {
        this.addAction(new SetRemoteViewsAdapterList(this, viewId, list, viewTypeCount));
    }

    private final void $$robo$$android_widget_RemoteViews$setScrollPosition(int viewId, int position) {
        this.setInt(viewId, "smoothScrollToPosition", position);
    }

    private final void $$robo$$android_widget_RemoteViews$setRelativeScrollPosition(int viewId, int offset) {
        this.setInt(viewId, "smoothScrollByOffset", offset);
    }

    private final void $$robo$$android_widget_RemoteViews$setViewPadding(int viewId, int left, int top, int right, int bottom) {
        this.addAction(new ViewPaddingAction(this, viewId, left, top, right, bottom));
    }

    private final void $$robo$$android_widget_RemoteViews$setBoolean(int viewId, String methodName, boolean value) {
        this.addAction(new ReflectionAction(this, viewId, methodName, 1, value));
    }

    private final void $$robo$$android_widget_RemoteViews$setByte(int viewId, String methodName, byte value) {
        this.addAction(new ReflectionAction(this, viewId, methodName, 2, value));
    }

    private final void $$robo$$android_widget_RemoteViews$setShort(int viewId, String methodName, short value) {
        this.addAction(new ReflectionAction(this, viewId, methodName, 3, value));
    }

    private final void $$robo$$android_widget_RemoteViews$setInt(int viewId, String methodName, int value) {
        this.addAction(new ReflectionAction(this, viewId, methodName, 4, value));
    }

    private final void $$robo$$android_widget_RemoteViews$setLong(int viewId, String methodName, long value) {
        this.addAction(new ReflectionAction(this, viewId, methodName, 5, value));
    }

    private final void $$robo$$android_widget_RemoteViews$setFloat(int viewId, String methodName, float value) {
        this.addAction(new ReflectionAction(this, viewId, methodName, 6, Float.valueOf(value)));
    }

    private final void $$robo$$android_widget_RemoteViews$setDouble(int viewId, String methodName, double value) {
        this.addAction(new ReflectionAction(this, viewId, methodName, 7, value));
    }

    private final void $$robo$$android_widget_RemoteViews$setChar(int viewId, String methodName, char value) {
        this.addAction(new ReflectionAction(this, viewId, methodName, 8, Character.valueOf(value)));
    }

    private final void $$robo$$android_widget_RemoteViews$setString(int viewId, String methodName, String value) {
        this.addAction(new ReflectionAction(this, viewId, methodName, 9, value));
    }

    private final void $$robo$$android_widget_RemoteViews$setCharSequence(int viewId, String methodName, CharSequence value) {
        this.addAction(new ReflectionAction(this, viewId, methodName, 10, value));
    }

    private final void $$robo$$android_widget_RemoteViews$setUri(int viewId, String methodName, Uri value) {
        if (value != null) {
            value = value.getCanonicalUri();
            if (StrictMode.vmFileUriExposureEnabled()) {
                value.checkFileUriExposed("RemoteViews.setUri()");
            }
        }
        this.addAction(new ReflectionAction(this, viewId, methodName, 11, value));
    }

    private final void $$robo$$android_widget_RemoteViews$setBitmap(int viewId, String methodName, Bitmap value) {
        this.addAction(new BitmapReflectionAction(this, viewId, methodName, value));
    }

    private final void $$robo$$android_widget_RemoteViews$setBundle(int viewId, String methodName, Bundle value) {
        this.addAction(new ReflectionAction(this, viewId, methodName, 13, value));
    }

    private final void $$robo$$android_widget_RemoteViews$setIntent(int viewId, String methodName, Intent value) {
        this.addAction(new ReflectionAction(this, viewId, methodName, 14, value));
    }

    private final void $$robo$$android_widget_RemoteViews$setContentDescription(int viewId, CharSequence contentDescription) {
        this.setCharSequence(viewId, "setContentDescription", contentDescription);
    }

    private final void $$robo$$android_widget_RemoteViews$setLabelFor(int viewId, int labeledId) {
        this.setInt(viewId, "setLabelFor", labeledId);
    }

    private final RemoteViews $$robo$$android_widget_RemoteViews$getRemoteViewsToApply(Context context) {
        if (this.hasLandscapeAndPortraitLayouts()) {
            int orientation = context.getResources().getConfiguration().orientation;
            if (orientation == 2) {
                return this.mLandscape;
            }
            return this.mPortrait;
        }
        return this;
    }

    private final View $$robo$$android_widget_RemoteViews$apply(Context context, ViewGroup parent) {
        return this.apply(context, parent, null);
    }

    private final View $$robo$$android_widget_RemoteViews$apply(Context context, ViewGroup parent, OnClickHandler handler) {
        RemoteViews rvToApply = this.getRemoteViewsToApply(context);
        Context contextForResources = this.getContextForResources(context);
        ShadowedObject inflationContext = new ShadowedObject(this, context, contextForResources){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ Context val$contextForResources;
            /* synthetic */ RemoteViews this$0;

            private void $$robo$$android_widget_RemoteViews_2$__constructor__(RemoteViews remoteViews, Context x0, Context context) {
            }

            private final Resources $$robo$$android_widget_RemoteViews_2$getResources() {
                return this.val$contextForResources.getResources();
            }

            private final Resources.Theme $$robo$$android_widget_RemoteViews_2$getTheme() {
                return this.val$contextForResources.getTheme();
            }

            private void __constructor__(RemoteViews remoteViews, Context context, Context context2) {
                this.$$robo$$android_widget_RemoteViews_2$__constructor__(remoteViews, context, context2);
            }
            {
                this.this$0 = remoteViews;
                this.val$contextForResources = context2;
                super(context);
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_RemoteViews_2$__constructor__(android.widget.RemoteViews android.content.Context android.content.Context ), 0, this, remoteViews, context, context2);
            }

            @Override
            public Resources getResources() {
                return InvokeDynamicSupport.bootstrap("getResources", $$robo$$android_widget_RemoteViews_2$getResources(), 0, this);
            }

            @Override
            public Resources.Theme getTheme() {
                return InvokeDynamicSupport.bootstrap("getTheme", $$robo$$android_widget_RemoteViews_2$getTheme(), 0, this);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        LayoutInflater inflater = (LayoutInflater)context.getSystemService("layout_inflater");
        inflater = inflater.cloneInContext((Context)inflationContext);
        inflater.setFilter(this);
        View result = inflater.inflate(rvToApply.getLayoutId(), parent, false);
        rvToApply.performApply(result, parent, handler);
        return result;
    }

    private final void $$robo$$android_widget_RemoteViews$reapply(Context context, View v) {
        this.reapply(context, v, null);
    }

    private final void $$robo$$android_widget_RemoteViews$reapply(Context context, View v, OnClickHandler handler) {
        RemoteViews rvToApply = this.getRemoteViewsToApply(context);
        if (this.hasLandscapeAndPortraitLayouts() && v.getId() != rvToApply.getLayoutId()) {
            throw new RuntimeException("Attempting to re-apply RemoteViews to a view that that does not share the same root layout id.");
        }
        rvToApply.performApply(v, (ViewGroup)v.getParent(), handler);
    }

    private final void $$robo$$android_widget_RemoteViews$performApply(View v, ViewGroup parent, OnClickHandler handler) {
        if (this.mActions != null) {
            handler = handler == null ? DEFAULT_ON_CLICK_HANDLER : handler;
            int count = this.mActions.size();
            for (int i = 0; i < count; ++i) {
                Action a = this.mActions.get(i);
                a.apply(v, parent, handler);
            }
        }
    }

    private final Context $$robo$$android_widget_RemoteViews$getContextForResources(Context context) {
        if (this.mApplication != null) {
            if (context.getUserId() == UserHandle.getUserId(this.mApplication.uid) && context.getPackageName().equals(this.mApplication.packageName)) {
                return context;
            }
            try {
                return context.createApplicationContext(this.mApplication, 4);
            }
            catch (PackageManager.NameNotFoundException e) {
                Log.e("RemoteViews", "Package name " + this.mApplication.packageName + " not found");
            }
        }
        return context;
    }

    private final int $$robo$$android_widget_RemoteViews$getSequenceNumber() {
        return this.mActions == null ? 0 : this.mActions.size();
    }

    private final boolean $$robo$$android_widget_RemoteViews$onLoadClass(Class clazz) {
        return clazz.isAnnotationPresent(RemoteView.class);
    }

    private final int $$robo$$android_widget_RemoteViews$describeContents() {
        return 0;
    }

    private final void $$robo$$android_widget_RemoteViews$writeToParcel(Parcel dest, int flags) {
        if (!this.hasLandscapeAndPortraitLayouts()) {
            dest.writeInt(0);
            if (this.mIsRoot) {
                this.mBitmapCache.writeBitmapsToParcel(dest, flags);
            }
            dest.writeParcelable(this.mApplication, flags);
            dest.writeInt(this.mLayoutId);
            dest.writeInt(this.mIsWidgetCollectionChild ? 1 : 0);
            int count = this.mActions != null ? this.mActions.size() : 0;
            dest.writeInt(count);
            for (int i = 0; i < count; ++i) {
                Action a = this.mActions.get(i);
                a.writeToParcel(dest, 0);
            }
        } else {
            dest.writeInt(1);
            if (this.mIsRoot) {
                this.mBitmapCache.writeBitmapsToParcel(dest, flags);
            }
            this.mLandscape.writeToParcel(dest, flags);
            this.mPortrait.writeToParcel(dest, flags);
        }
    }

    private static final ApplicationInfo $$robo$$android_widget_RemoteViews$getApplicationInfo(String packageName, int userId) {
        if (packageName == null) {
            return null;
        }
        Application application = ActivityThread.currentApplication();
        if (application == null) {
            throw new IllegalStateException("Cannot create remote views out of an aplication.");
        }
        ApplicationInfo applicationInfo = application.getApplicationInfo();
        if (UserHandle.getUserId(applicationInfo.uid) != userId || !applicationInfo.packageName.equals(packageName)) {
            try {
                Context context = application.getBaseContext().createPackageContextAsUser(packageName, 0, new UserHandle(userId));
                applicationInfo = context.getApplicationInfo();
            }
            catch (PackageManager.NameNotFoundException nnfe) {
                throw new IllegalArgumentException("No such package " + packageName);
            }
        }
        return applicationInfo;
    }

    private /* synthetic */ void $$robo$$android_widget_RemoteViews$__constructor__(Parcel x0, BitmapCache x1, 1 x2) {
    }

    static void __staticInitializer__() {
        DEFAULT_ON_CLICK_HANDLER = new OnClickHandler();
        sMethodsLock = new Object[0];
        sMethods = new ArrayMap();
        sInvokeArgsTls = new ThreadLocal<Object[]>(){
            public transient /* synthetic */ Object __robo_data__;

            private void $$robo$$android_widget_RemoteViews_1$__constructor__() {
            }

            private final Object[] $$robo$$android_widget_RemoteViews_1$initialValue() {
                return new Object[1];
            }

            private void __constructor__() {
                this.$$robo$$android_widget_RemoteViews_1$__constructor__();
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_RemoteViews_1$__constructor__(), 0, this);
            }

            @Override
            protected Object[] initialValue() {
                return InvokeDynamicSupport.bootstrap("initialValue", $$robo$$android_widget_RemoteViews_1$initialValue(), 0, this);
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        CREATOR = new Parcelable.Creator<RemoteViews>(){
            public transient /* synthetic */ Object __robo_data__;

            private void $$robo$$android_widget_RemoteViews_3$__constructor__() {
            }

            private final RemoteViews $$robo$$android_widget_RemoteViews_3$createFromParcel(Parcel parcel) {
                return new RemoteViews(parcel);
            }

            private final RemoteViews[] $$robo$$android_widget_RemoteViews_3$newArray(int size) {
                return new RemoteViews[size];
            }

            private void __constructor__() {
                this.$$robo$$android_widget_RemoteViews_3$__constructor__();
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_RemoteViews_3$__constructor__(), 0, this);
            }

            @Override
            public RemoteViews createFromParcel(Parcel parcel) {
                return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_widget_RemoteViews_3$createFromParcel(android.os.Parcel ), 0, this, parcel);
            }

            public RemoteViews[] newArray(int n) {
                return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_widget_RemoteViews_3$newArray(int ), 0, this, n);
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
    }

    public void mergeRemoteViews(RemoteViews remoteViews) {
        InvokeDynamicSupport.bootstrap("mergeRemoteViews", $$robo$$android_widget_RemoteViews$mergeRemoteViews(android.widget.RemoteViews ), 0, this, remoteViews);
    }

    private static Rect getSourceBounds(View view) {
        return InvokeDynamicSupport.bootstrapStatic("getSourceBounds", $$robo$$android_widget_RemoteViews$getSourceBounds(android.view.View ), 0, (View)view);
    }

    private Method getMethod(View view, String string2, Class<?> clazz) {
        return InvokeDynamicSupport.bootstrap("getMethod", $$robo$$android_widget_RemoteViews$getMethod(android.view.View java.lang.String java.lang.Class<?> ), 0, this, view, string2, clazz);
    }

    private static String getParameters(Class<?> clazz) {
        return InvokeDynamicSupport.bootstrapStatic("getParameters", $$robo$$android_widget_RemoteViews$getParameters(java.lang.Class<?> ), 0, clazz);
    }

    private static Object[] wrapArg(Object object) {
        return InvokeDynamicSupport.bootstrapStatic("wrapArg", $$robo$$android_widget_RemoteViews$wrapArg(java.lang.Object ), 0, (Object)object);
    }

    private void configureRemoteViewsAsChild(RemoteViews remoteViews) {
        InvokeDynamicSupport.bootstrap("configureRemoteViewsAsChild", $$robo$$android_widget_RemoteViews$configureRemoteViewsAsChild(android.widget.RemoteViews ), 0, this, remoteViews);
    }

    void setNotRoot() {
        InvokeDynamicSupport.bootstrap("setNotRoot", $$robo$$android_widget_RemoteViews$setNotRoot(), 0, this);
    }

    private void __constructor__(String string2, int n) {
        this.$$robo$$android_widget_RemoteViews$__constructor__(string2, n);
    }

    public RemoteViews(String string2, int n) {
        this(RemoteViews.getApplicationInfo(string2, UserHandle.myUserId()), n);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_RemoteViews$__constructor__(java.lang.String int ), 0, this, string2, n);
    }

    private void __constructor__(String string2, int n, int n2) {
        this.$$robo$$android_widget_RemoteViews$__constructor__(string2, n, n2);
    }

    public RemoteViews(String string2, int n, int n2) {
        this(RemoteViews.getApplicationInfo(string2, n), n2);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_RemoteViews$__constructor__(java.lang.String int int ), 0, this, string2, n, n2);
    }

    private void __constructor__(ApplicationInfo applicationInfo, int n) {
        this.$$robo$$android_widget_RemoteViews$__constructor__(applicationInfo, n);
    }

    protected RemoteViews(ApplicationInfo applicationInfo, int n) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_RemoteViews$__constructor__(android.content.pm.ApplicationInfo int ), 0, this, applicationInfo, n);
    }

    private boolean hasLandscapeAndPortraitLayouts() {
        return (boolean)InvokeDynamicSupport.bootstrap("hasLandscapeAndPortraitLayouts", $$robo$$android_widget_RemoteViews$hasLandscapeAndPortraitLayouts(), 0, this);
    }

    private void __constructor__(RemoteViews remoteViews, RemoteViews remoteViews2) {
        this.$$robo$$android_widget_RemoteViews$__constructor__(remoteViews, remoteViews2);
    }

    public RemoteViews(RemoteViews remoteViews, RemoteViews remoteViews2) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_RemoteViews$__constructor__(android.widget.RemoteViews android.widget.RemoteViews ), 0, this, remoteViews, remoteViews2);
    }

    private void __constructor__(Parcel parcel) {
        this.$$robo$$android_widget_RemoteViews$__constructor__(parcel);
    }

    public RemoteViews(Parcel parcel) {
        this(parcel, null);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_RemoteViews$__constructor__(android.os.Parcel ), 0, this, parcel);
    }

    private void __constructor__(Parcel parcel, BitmapCache bitmapCache) {
        this.$$robo$$android_widget_RemoteViews$__constructor__(parcel, bitmapCache);
    }

    private RemoteViews(Parcel parcel, BitmapCache bitmapCache) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_RemoteViews$__constructor__(android.os.Parcel android.widget.RemoteViews$BitmapCache ), 0, this, parcel, bitmapCache);
    }

    public RemoteViews clone() {
        return InvokeDynamicSupport.bootstrap("clone", $$robo$$android_widget_RemoteViews$clone(), 0, this);
    }

    public String getPackage() {
        return InvokeDynamicSupport.bootstrap("getPackage", $$robo$$android_widget_RemoteViews$getPackage(), 0, this);
    }

    public int getLayoutId() {
        return (int)InvokeDynamicSupport.bootstrap("getLayoutId", $$robo$$android_widget_RemoteViews$getLayoutId(), 0, this);
    }

    void setIsWidgetCollectionChild(boolean bl) {
        InvokeDynamicSupport.bootstrap("setIsWidgetCollectionChild", $$robo$$android_widget_RemoteViews$setIsWidgetCollectionChild(boolean ), 0, this, bl);
    }

    private void recalculateMemoryUsage() {
        InvokeDynamicSupport.bootstrap("recalculateMemoryUsage", $$robo$$android_widget_RemoteViews$recalculateMemoryUsage(), 0, this);
    }

    private void setBitmapCache(BitmapCache bitmapCache) {
        InvokeDynamicSupport.bootstrap("setBitmapCache", $$robo$$android_widget_RemoteViews$setBitmapCache(android.widget.RemoteViews$BitmapCache ), 0, this, bitmapCache);
    }

    public int estimateMemoryUsage() {
        return (int)InvokeDynamicSupport.bootstrap("estimateMemoryUsage", $$robo$$android_widget_RemoteViews$estimateMemoryUsage(), 0, this);
    }

    private void addAction(Action action) {
        InvokeDynamicSupport.bootstrap("addAction", $$robo$$android_widget_RemoteViews$addAction(android.widget.RemoteViews$Action ), 0, this, action);
    }

    public void addView(int n, RemoteViews remoteViews) {
        InvokeDynamicSupport.bootstrap("addView", $$robo$$android_widget_RemoteViews$addView(int android.widget.RemoteViews ), 0, this, n, remoteViews);
    }

    public void removeAllViews(int n) {
        InvokeDynamicSupport.bootstrap("removeAllViews", $$robo$$android_widget_RemoteViews$removeAllViews(int ), 0, this, n);
    }

    public void showNext(int n) {
        InvokeDynamicSupport.bootstrap("showNext", $$robo$$android_widget_RemoteViews$showNext(int ), 0, this, n);
    }

    public void showPrevious(int n) {
        InvokeDynamicSupport.bootstrap("showPrevious", $$robo$$android_widget_RemoteViews$showPrevious(int ), 0, this, n);
    }

    public void setDisplayedChild(int n, int n2) {
        InvokeDynamicSupport.bootstrap("setDisplayedChild", $$robo$$android_widget_RemoteViews$setDisplayedChild(int int ), 0, this, n, n2);
    }

    public void setViewVisibility(int n, int n2) {
        InvokeDynamicSupport.bootstrap("setViewVisibility", $$robo$$android_widget_RemoteViews$setViewVisibility(int int ), 0, this, n, n2);
    }

    public void setTextViewText(int n, CharSequence charSequence) {
        InvokeDynamicSupport.bootstrap("setTextViewText", $$robo$$android_widget_RemoteViews$setTextViewText(int java.lang.CharSequence ), 0, this, n, charSequence);
    }

    public void setTextViewTextSize(int n, int n2, float f) {
        InvokeDynamicSupport.bootstrap("setTextViewTextSize", $$robo$$android_widget_RemoteViews$setTextViewTextSize(int int float ), 0, this, n, n2, f);
    }

    public void setTextViewCompoundDrawables(int n, int n2, int n3, int n4, int n5) {
        InvokeDynamicSupport.bootstrap("setTextViewCompoundDrawables", $$robo$$android_widget_RemoteViews$setTextViewCompoundDrawables(int int int int int ), 0, this, n, n2, n3, n4, n5);
    }

    public void setTextViewCompoundDrawablesRelative(int n, int n2, int n3, int n4, int n5) {
        InvokeDynamicSupport.bootstrap("setTextViewCompoundDrawablesRelative", $$robo$$android_widget_RemoteViews$setTextViewCompoundDrawablesRelative(int int int int int ), 0, this, n, n2, n3, n4, n5);
    }

    public void setTextViewCompoundDrawablesRelativeColorFilter(int n, int n2, int n3, PorterDuff.Mode mode) {
        InvokeDynamicSupport.bootstrap("setTextViewCompoundDrawablesRelativeColorFilter", $$robo$$android_widget_RemoteViews$setTextViewCompoundDrawablesRelativeColorFilter(int int int android.graphics.PorterDuff$Mode ), 0, this, n, n2, n3, mode);
    }

    public void setImageViewResource(int n, int n2) {
        InvokeDynamicSupport.bootstrap("setImageViewResource", $$robo$$android_widget_RemoteViews$setImageViewResource(int int ), 0, this, n, n2);
    }

    public void setImageViewUri(int n, Uri uri) {
        InvokeDynamicSupport.bootstrap("setImageViewUri", $$robo$$android_widget_RemoteViews$setImageViewUri(int android.net.Uri ), 0, this, n, uri);
    }

    public void setImageViewBitmap(int n, Bitmap bitmap) {
        InvokeDynamicSupport.bootstrap("setImageViewBitmap", $$robo$$android_widget_RemoteViews$setImageViewBitmap(int android.graphics.Bitmap ), 0, this, n, bitmap);
    }

    public void setEmptyView(int n, int n2) {
        InvokeDynamicSupport.bootstrap("setEmptyView", $$robo$$android_widget_RemoteViews$setEmptyView(int int ), 0, this, n, n2);
    }

    public void setChronometer(int n, long l, String string2, boolean bl) {
        InvokeDynamicSupport.bootstrap("setChronometer", $$robo$$android_widget_RemoteViews$setChronometer(int long java.lang.String boolean ), 0, this, n, l, string2, bl);
    }

    public void setProgressBar(int n, int n2, int n3, boolean bl) {
        InvokeDynamicSupport.bootstrap("setProgressBar", $$robo$$android_widget_RemoteViews$setProgressBar(int int int boolean ), 0, this, n, n2, n3, bl);
    }

    public void setOnClickPendingIntent(int n, PendingIntent pendingIntent) {
        InvokeDynamicSupport.bootstrap("setOnClickPendingIntent", $$robo$$android_widget_RemoteViews$setOnClickPendingIntent(int android.app.PendingIntent ), 0, this, n, pendingIntent);
    }

    public void setPendingIntentTemplate(int n, PendingIntent pendingIntent) {
        InvokeDynamicSupport.bootstrap("setPendingIntentTemplate", $$robo$$android_widget_RemoteViews$setPendingIntentTemplate(int android.app.PendingIntent ), 0, this, n, pendingIntent);
    }

    public void setOnClickFillInIntent(int n, Intent intent) {
        InvokeDynamicSupport.bootstrap("setOnClickFillInIntent", $$robo$$android_widget_RemoteViews$setOnClickFillInIntent(int android.content.Intent ), 0, this, n, intent);
    }

    public void setDrawableParameters(int n, boolean bl, int n2, int n3, PorterDuff.Mode mode, int n4) {
        InvokeDynamicSupport.bootstrap("setDrawableParameters", $$robo$$android_widget_RemoteViews$setDrawableParameters(int boolean int int android.graphics.PorterDuff$Mode int ), 0, this, n, bl, n2, n3, mode, n4);
    }

    public void setTextColor(int n, int n2) {
        InvokeDynamicSupport.bootstrap("setTextColor", $$robo$$android_widget_RemoteViews$setTextColor(int int ), 0, this, n, n2);
    }

    @Deprecated
    public void setRemoteAdapter(int n, int n2, Intent intent) {
        InvokeDynamicSupport.bootstrap("setRemoteAdapter", $$robo$$android_widget_RemoteViews$setRemoteAdapter(int int android.content.Intent ), 0, this, n, n2, intent);
    }

    public void setRemoteAdapter(int n, Intent intent) {
        InvokeDynamicSupport.bootstrap("setRemoteAdapter", $$robo$$android_widget_RemoteViews$setRemoteAdapter(int android.content.Intent ), 0, this, n, intent);
    }

    public void setRemoteAdapter(int n, ArrayList<RemoteViews> arrayList, int n2) {
        InvokeDynamicSupport.bootstrap("setRemoteAdapter", $$robo$$android_widget_RemoteViews$setRemoteAdapter(int java.util.ArrayList<android.widget.RemoteViews> int ), 0, this, n, arrayList, n2);
    }

    public void setScrollPosition(int n, int n2) {
        InvokeDynamicSupport.bootstrap("setScrollPosition", $$robo$$android_widget_RemoteViews$setScrollPosition(int int ), 0, this, n, n2);
    }

    public void setRelativeScrollPosition(int n, int n2) {
        InvokeDynamicSupport.bootstrap("setRelativeScrollPosition", $$robo$$android_widget_RemoteViews$setRelativeScrollPosition(int int ), 0, this, n, n2);
    }

    public void setViewPadding(int n, int n2, int n3, int n4, int n5) {
        InvokeDynamicSupport.bootstrap("setViewPadding", $$robo$$android_widget_RemoteViews$setViewPadding(int int int int int ), 0, this, n, n2, n3, n4, n5);
    }

    public void setBoolean(int n, String string2, boolean bl) {
        InvokeDynamicSupport.bootstrap("setBoolean", $$robo$$android_widget_RemoteViews$setBoolean(int java.lang.String boolean ), 0, this, n, string2, bl);
    }

    public void setByte(int n, String string2, byte by) {
        InvokeDynamicSupport.bootstrap("setByte", $$robo$$android_widget_RemoteViews$setByte(int java.lang.String byte ), 0, this, n, string2, by);
    }

    public void setShort(int n, String string2, short s) {
        InvokeDynamicSupport.bootstrap("setShort", $$robo$$android_widget_RemoteViews$setShort(int java.lang.String short ), 0, this, n, string2, s);
    }

    public void setInt(int n, String string2, int n2) {
        InvokeDynamicSupport.bootstrap("setInt", $$robo$$android_widget_RemoteViews$setInt(int java.lang.String int ), 0, this, n, string2, n2);
    }

    public void setLong(int n, String string2, long l) {
        InvokeDynamicSupport.bootstrap("setLong", $$robo$$android_widget_RemoteViews$setLong(int java.lang.String long ), 0, this, n, string2, l);
    }

    public void setFloat(int n, String string2, float f) {
        InvokeDynamicSupport.bootstrap("setFloat", $$robo$$android_widget_RemoteViews$setFloat(int java.lang.String float ), 0, this, n, string2, f);
    }

    public void setDouble(int n, String string2, double d) {
        InvokeDynamicSupport.bootstrap("setDouble", $$robo$$android_widget_RemoteViews$setDouble(int java.lang.String double ), 0, this, n, string2, d);
    }

    public void setChar(int n, String string2, char c) {
        InvokeDynamicSupport.bootstrap("setChar", $$robo$$android_widget_RemoteViews$setChar(int java.lang.String char ), 0, this, n, string2, c);
    }

    public void setString(int n, String string2, String string3) {
        InvokeDynamicSupport.bootstrap("setString", $$robo$$android_widget_RemoteViews$setString(int java.lang.String java.lang.String ), 0, this, n, string2, string3);
    }

    public void setCharSequence(int n, String string2, CharSequence charSequence) {
        InvokeDynamicSupport.bootstrap("setCharSequence", $$robo$$android_widget_RemoteViews$setCharSequence(int java.lang.String java.lang.CharSequence ), 0, this, n, string2, charSequence);
    }

    public void setUri(int n, String string2, Uri uri) {
        InvokeDynamicSupport.bootstrap("setUri", $$robo$$android_widget_RemoteViews$setUri(int java.lang.String android.net.Uri ), 0, this, n, string2, uri);
    }

    public void setBitmap(int n, String string2, Bitmap bitmap) {
        InvokeDynamicSupport.bootstrap("setBitmap", $$robo$$android_widget_RemoteViews$setBitmap(int java.lang.String android.graphics.Bitmap ), 0, this, n, string2, bitmap);
    }

    public void setBundle(int n, String string2, Bundle bundle) {
        InvokeDynamicSupport.bootstrap("setBundle", $$robo$$android_widget_RemoteViews$setBundle(int java.lang.String android.os.Bundle ), 0, this, n, string2, bundle);
    }

    public void setIntent(int n, String string2, Intent intent) {
        InvokeDynamicSupport.bootstrap("setIntent", $$robo$$android_widget_RemoteViews$setIntent(int java.lang.String android.content.Intent ), 0, this, n, string2, intent);
    }

    public void setContentDescription(int n, CharSequence charSequence) {
        InvokeDynamicSupport.bootstrap("setContentDescription", $$robo$$android_widget_RemoteViews$setContentDescription(int java.lang.CharSequence ), 0, this, n, charSequence);
    }

    public void setLabelFor(int n, int n2) {
        InvokeDynamicSupport.bootstrap("setLabelFor", $$robo$$android_widget_RemoteViews$setLabelFor(int int ), 0, this, n, n2);
    }

    private RemoteViews getRemoteViewsToApply(Context context) {
        return InvokeDynamicSupport.bootstrap("getRemoteViewsToApply", $$robo$$android_widget_RemoteViews$getRemoteViewsToApply(android.content.Context ), 0, this, context);
    }

    public View apply(Context context, ViewGroup viewGroup) {
        return InvokeDynamicSupport.bootstrap("apply", $$robo$$android_widget_RemoteViews$apply(android.content.Context android.view.ViewGroup ), 0, this, context, viewGroup);
    }

    public View apply(Context context, ViewGroup viewGroup, OnClickHandler onClickHandler) {
        return InvokeDynamicSupport.bootstrap("apply", $$robo$$android_widget_RemoteViews$apply(android.content.Context android.view.ViewGroup android.widget.RemoteViews$OnClickHandler ), 0, this, context, viewGroup, onClickHandler);
    }

    public void reapply(Context context, View view) {
        InvokeDynamicSupport.bootstrap("reapply", $$robo$$android_widget_RemoteViews$reapply(android.content.Context android.view.View ), 0, this, context, view);
    }

    public void reapply(Context context, View view, OnClickHandler onClickHandler) {
        InvokeDynamicSupport.bootstrap("reapply", $$robo$$android_widget_RemoteViews$reapply(android.content.Context android.view.View android.widget.RemoteViews$OnClickHandler ), 0, this, context, view, onClickHandler);
    }

    private void performApply(View view, ViewGroup viewGroup, OnClickHandler onClickHandler) {
        InvokeDynamicSupport.bootstrap("performApply", $$robo$$android_widget_RemoteViews$performApply(android.view.View android.view.ViewGroup android.widget.RemoteViews$OnClickHandler ), 0, this, view, viewGroup, onClickHandler);
    }

    private Context getContextForResources(Context context) {
        return InvokeDynamicSupport.bootstrap("getContextForResources", $$robo$$android_widget_RemoteViews$getContextForResources(android.content.Context ), 0, this, context);
    }

    public int getSequenceNumber() {
        return (int)InvokeDynamicSupport.bootstrap("getSequenceNumber", $$robo$$android_widget_RemoteViews$getSequenceNumber(), 0, this);
    }

    @Override
    public boolean onLoadClass(Class clazz) {
        return (boolean)InvokeDynamicSupport.bootstrap("onLoadClass", $$robo$$android_widget_RemoteViews$onLoadClass(java.lang.Class ), 0, this, clazz);
    }

    @Override
    public int describeContents() {
        return (int)InvokeDynamicSupport.bootstrap("describeContents", $$robo$$android_widget_RemoteViews$describeContents(), 0, this);
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_widget_RemoteViews$writeToParcel(android.os.Parcel int ), 0, this, parcel, n);
    }

    private static ApplicationInfo getApplicationInfo(String string2, int n) {
        return InvokeDynamicSupport.bootstrapStatic("getApplicationInfo", $$robo$$android_widget_RemoteViews$getApplicationInfo(java.lang.String int ), 0, (String)string2, (int)n);
    }

    private /* synthetic */ void __constructor__(Parcel parcel, BitmapCache bitmapCache, 1 var3_3) {
        this.$$robo$$android_widget_RemoteViews$__constructor__(parcel, bitmapCache, var3_3);
    }

    static {
        RobolectricInternals.classInitializing(RemoteViews.class);
    }

    public /* synthetic */ RemoteViews() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (RemoteViews)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static class 4
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        static /* synthetic */ int[] $SwitchMap$android$graphics$Bitmap$Config;

        static void __staticInitializer__() {
            $SwitchMap$android$graphics$Bitmap$Config = new int[Bitmap.Config.values().length];
            try {
                4.$SwitchMap$android$graphics$Bitmap$Config[Bitmap.Config.ALPHA_8.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                4.$SwitchMap$android$graphics$Bitmap$Config[Bitmap.Config.RGB_565.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                4.$SwitchMap$android$graphics$Bitmap$Config[Bitmap.Config.ARGB_4444.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                4.$SwitchMap$android$graphics$Bitmap$Config[Bitmap.Config.ARGB_8888.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
        }

        static {
            RobolectricInternals.classInitializing(4.class);
        }

        public /* synthetic */ 4() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (4)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private class MemoryUsageCounter
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        int mMemoryUsage;
        /* synthetic */ RemoteViews this$0;

        private void $$robo$$android_widget_RemoteViews_MemoryUsageCounter$__constructor__(RemoteViews remoteViews) {
        }

        private final void $$robo$$android_widget_RemoteViews_MemoryUsageCounter$clear() {
            this.mMemoryUsage = 0;
        }

        private final void $$robo$$android_widget_RemoteViews_MemoryUsageCounter$increment(int numBytes) {
            this.mMemoryUsage += numBytes;
        }

        private final int $$robo$$android_widget_RemoteViews_MemoryUsageCounter$getMemoryUsage() {
            return this.mMemoryUsage;
        }

        private final void $$robo$$android_widget_RemoteViews_MemoryUsageCounter$addBitmapMemory(Bitmap b) {
            Bitmap.Config c = b.getConfig();
            int bpp = 4;
            if (c != null) {
                switch (4.$SwitchMap$android$graphics$Bitmap$Config[c.ordinal()]) {
                    case 1: {
                        bpp = 1;
                        break;
                    }
                    case 2: 
                    case 3: {
                        bpp = 2;
                        break;
                    }
                    case 4: {
                        bpp = 4;
                    }
                }
            }
            this.increment(b.getWidth() * b.getHeight() * bpp);
        }

        private /* synthetic */ void $$robo$$android_widget_RemoteViews_MemoryUsageCounter$__constructor__(RemoteViews x0, 1 x1) {
        }

        private void __constructor__(RemoteViews remoteViews) {
            this.$$robo$$android_widget_RemoteViews_MemoryUsageCounter$__constructor__(remoteViews);
        }

        private MemoryUsageCounter(RemoteViews remoteViews) {
            this.this$0 = remoteViews;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_RemoteViews_MemoryUsageCounter$__constructor__(android.widget.RemoteViews ), 0, this, remoteViews);
        }

        public void clear() {
            InvokeDynamicSupport.bootstrap("clear", $$robo$$android_widget_RemoteViews_MemoryUsageCounter$clear(), 0, this);
        }

        public void increment(int n) {
            InvokeDynamicSupport.bootstrap("increment", $$robo$$android_widget_RemoteViews_MemoryUsageCounter$increment(int ), 0, this, n);
        }

        public int getMemoryUsage() {
            return (int)InvokeDynamicSupport.bootstrap("getMemoryUsage", $$robo$$android_widget_RemoteViews_MemoryUsageCounter$getMemoryUsage(), 0, this);
        }

        public void addBitmapMemory(Bitmap bitmap) {
            InvokeDynamicSupport.bootstrap("addBitmapMemory", $$robo$$android_widget_RemoteViews_MemoryUsageCounter$addBitmapMemory(android.graphics.Bitmap ), 0, this, bitmap);
        }

        private /* synthetic */ void __constructor__(RemoteViews remoteViews, 1 var2_2) {
            this.$$robo$$android_widget_RemoteViews_MemoryUsageCounter$__constructor__(remoteViews, var2_2);
        }

        public /* synthetic */ MemoryUsageCounter() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (MemoryUsageCounter)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private class TextViewDrawableColorFilterAction
    extends Action
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        boolean isRelative;
        int index;
        int color;
        PorterDuff.Mode mode;
        public static int TAG = 17;
        /* synthetic */ RemoteViews this$0;

        private void $$robo$$android_widget_RemoteViews_TextViewDrawableColorFilterAction$__constructor__(RemoteViews remoteViews, int viewId, boolean isRelative, int index, int color2, PorterDuff.Mode mode) {
            this.viewId = viewId;
            this.isRelative = isRelative;
            this.index = index;
            this.color = color2;
            this.mode = mode;
        }

        private void $$robo$$android_widget_RemoteViews_TextViewDrawableColorFilterAction$__constructor__(RemoteViews remoteViews, Parcel parcel) {
            this.viewId = parcel.readInt();
            this.isRelative = parcel.readInt() != 0;
            this.index = parcel.readInt();
            this.color = parcel.readInt();
            this.mode = this.readPorterDuffMode(parcel);
        }

        private final PorterDuff.Mode $$robo$$android_widget_RemoteViews_TextViewDrawableColorFilterAction$readPorterDuffMode(Parcel parcel) {
            int mode = parcel.readInt();
            if (mode >= 0 && mode < PorterDuff.Mode.values().length) {
                return PorterDuff.Mode.values()[mode];
            }
            return PorterDuff.Mode.CLEAR;
        }

        private final void $$robo$$android_widget_RemoteViews_TextViewDrawableColorFilterAction$writeToParcel(Parcel dest, int flags) {
            dest.writeInt(17);
            dest.writeInt(this.viewId);
            dest.writeInt(this.isRelative ? 1 : 0);
            dest.writeInt(this.index);
            dest.writeInt(this.color);
            dest.writeInt(this.mode.ordinal());
        }

        private final void $$robo$$android_widget_RemoteViews_TextViewDrawableColorFilterAction$apply(View root, ViewGroup rootParent, OnClickHandler handler) {
            Drawable[] drawables;
            TextView target = (TextView)root.findViewById(this.viewId);
            if (target == null) {
                return;
            }
            Drawable[] drawableArray = drawables = this.isRelative ? target.getCompoundDrawablesRelative() : target.getCompoundDrawables();
            if (this.index < 0 || this.index >= 4) {
                throw new IllegalStateException("index must be in range [0, 3].");
            }
            Drawable d = drawables[this.index];
            if (d != null) {
                d.mutate();
                d.setColorFilter(this.color, this.mode);
            }
        }

        private final String $$robo$$android_widget_RemoteViews_TextViewDrawableColorFilterAction$getActionName() {
            return "TextViewDrawableColorFilterAction";
        }

        private void __constructor__(RemoteViews remoteViews, int n, boolean bl, int n2, int n3, PorterDuff.Mode mode) {
            this.$$robo$$android_widget_RemoteViews_TextViewDrawableColorFilterAction$__constructor__(remoteViews, n, bl, n2, n3, mode);
        }

        public TextViewDrawableColorFilterAction(RemoteViews remoteViews, int n, boolean bl, int n2, int n3, PorterDuff.Mode mode) {
            this.this$0 = remoteViews;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_RemoteViews_TextViewDrawableColorFilterAction$__constructor__(android.widget.RemoteViews int boolean int int android.graphics.PorterDuff$Mode ), 0, this, remoteViews, n, bl, n2, n3, mode);
        }

        private void __constructor__(RemoteViews remoteViews, Parcel parcel) {
            this.$$robo$$android_widget_RemoteViews_TextViewDrawableColorFilterAction$__constructor__(remoteViews, parcel);
        }

        public TextViewDrawableColorFilterAction(RemoteViews remoteViews, Parcel parcel) {
            this.this$0 = remoteViews;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_RemoteViews_TextViewDrawableColorFilterAction$__constructor__(android.widget.RemoteViews android.os.Parcel ), 0, this, remoteViews, parcel);
        }

        private PorterDuff.Mode readPorterDuffMode(Parcel parcel) {
            return InvokeDynamicSupport.bootstrap("readPorterDuffMode", $$robo$$android_widget_RemoteViews_TextViewDrawableColorFilterAction$readPorterDuffMode(android.os.Parcel ), 0, this, parcel);
        }

        @Override
        public void writeToParcel(Parcel parcel, int n) {
            InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_widget_RemoteViews_TextViewDrawableColorFilterAction$writeToParcel(android.os.Parcel int ), 0, this, parcel, n);
        }

        @Override
        public void apply(View view, ViewGroup viewGroup, OnClickHandler onClickHandler) {
            InvokeDynamicSupport.bootstrap("apply", $$robo$$android_widget_RemoteViews_TextViewDrawableColorFilterAction$apply(android.view.View android.view.ViewGroup android.widget.RemoteViews$OnClickHandler ), 0, this, view, viewGroup, onClickHandler);
        }

        @Override
        public String getActionName() {
            return InvokeDynamicSupport.bootstrap("getActionName", $$robo$$android_widget_RemoteViews_TextViewDrawableColorFilterAction$getActionName(), 0, this);
        }

        public /* synthetic */ TextViewDrawableColorFilterAction() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (TextViewDrawableColorFilterAction)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private class ViewPaddingAction
    extends Action
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        int left;
        int top;
        int right;
        int bottom;
        public static int TAG = 14;
        /* synthetic */ RemoteViews this$0;

        private void $$robo$$android_widget_RemoteViews_ViewPaddingAction$__constructor__(RemoteViews remoteViews, int viewId, int left, int top, int right, int bottom) {
            this.viewId = viewId;
            this.left = left;
            this.top = top;
            this.right = right;
            this.bottom = bottom;
        }

        private void $$robo$$android_widget_RemoteViews_ViewPaddingAction$__constructor__(RemoteViews remoteViews, Parcel parcel) {
            this.viewId = parcel.readInt();
            this.left = parcel.readInt();
            this.top = parcel.readInt();
            this.right = parcel.readInt();
            this.bottom = parcel.readInt();
        }

        private final void $$robo$$android_widget_RemoteViews_ViewPaddingAction$writeToParcel(Parcel dest, int flags) {
            dest.writeInt(14);
            dest.writeInt(this.viewId);
            dest.writeInt(this.left);
            dest.writeInt(this.top);
            dest.writeInt(this.right);
            dest.writeInt(this.bottom);
        }

        private final void $$robo$$android_widget_RemoteViews_ViewPaddingAction$apply(View root, ViewGroup rootParent, OnClickHandler handler) {
            View target = root.findViewById(this.viewId);
            if (target == null) {
                return;
            }
            target.setPadding(this.left, this.top, this.right, this.bottom);
        }

        private final String $$robo$$android_widget_RemoteViews_ViewPaddingAction$getActionName() {
            return "ViewPaddingAction";
        }

        private void __constructor__(RemoteViews remoteViews, int n, int n2, int n3, int n4, int n5) {
            this.$$robo$$android_widget_RemoteViews_ViewPaddingAction$__constructor__(remoteViews, n, n2, n3, n4, n5);
        }

        public ViewPaddingAction(RemoteViews remoteViews, int n, int n2, int n3, int n4, int n5) {
            this.this$0 = remoteViews;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_RemoteViews_ViewPaddingAction$__constructor__(android.widget.RemoteViews int int int int int ), 0, this, remoteViews, n, n2, n3, n4, n5);
        }

        private void __constructor__(RemoteViews remoteViews, Parcel parcel) {
            this.$$robo$$android_widget_RemoteViews_ViewPaddingAction$__constructor__(remoteViews, parcel);
        }

        public ViewPaddingAction(RemoteViews remoteViews, Parcel parcel) {
            this.this$0 = remoteViews;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_RemoteViews_ViewPaddingAction$__constructor__(android.widget.RemoteViews android.os.Parcel ), 0, this, remoteViews, parcel);
        }

        @Override
        public void writeToParcel(Parcel parcel, int n) {
            InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_widget_RemoteViews_ViewPaddingAction$writeToParcel(android.os.Parcel int ), 0, this, parcel, n);
        }

        @Override
        public void apply(View view, ViewGroup viewGroup, OnClickHandler onClickHandler) {
            InvokeDynamicSupport.bootstrap("apply", $$robo$$android_widget_RemoteViews_ViewPaddingAction$apply(android.view.View android.view.ViewGroup android.widget.RemoteViews$OnClickHandler ), 0, this, view, viewGroup, onClickHandler);
        }

        @Override
        public String getActionName() {
            return InvokeDynamicSupport.bootstrap("getActionName", $$robo$$android_widget_RemoteViews_ViewPaddingAction$getActionName(), 0, this);
        }

        public /* synthetic */ ViewPaddingAction() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ViewPaddingAction)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private class TextViewSizeAction
    extends Action
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        int units;
        float size;
        public static int TAG = 13;
        /* synthetic */ RemoteViews this$0;

        private void $$robo$$android_widget_RemoteViews_TextViewSizeAction$__constructor__(RemoteViews remoteViews, int viewId, int units, float size) {
            this.viewId = viewId;
            this.units = units;
            this.size = size;
        }

        private void $$robo$$android_widget_RemoteViews_TextViewSizeAction$__constructor__(RemoteViews remoteViews, Parcel parcel) {
            this.viewId = parcel.readInt();
            this.units = parcel.readInt();
            this.size = parcel.readFloat();
        }

        private final void $$robo$$android_widget_RemoteViews_TextViewSizeAction$writeToParcel(Parcel dest, int flags) {
            dest.writeInt(13);
            dest.writeInt(this.viewId);
            dest.writeInt(this.units);
            dest.writeFloat(this.size);
        }

        private final void $$robo$$android_widget_RemoteViews_TextViewSizeAction$apply(View root, ViewGroup rootParent, OnClickHandler handler) {
            TextView target = (TextView)root.findViewById(this.viewId);
            if (target == null) {
                return;
            }
            target.setTextSize(this.units, this.size);
        }

        private final String $$robo$$android_widget_RemoteViews_TextViewSizeAction$getActionName() {
            return "TextViewSizeAction";
        }

        private void __constructor__(RemoteViews remoteViews, int n, int n2, float f) {
            this.$$robo$$android_widget_RemoteViews_TextViewSizeAction$__constructor__(remoteViews, n, n2, f);
        }

        public TextViewSizeAction(RemoteViews remoteViews, int n, int n2, float f) {
            this.this$0 = remoteViews;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_RemoteViews_TextViewSizeAction$__constructor__(android.widget.RemoteViews int int float ), 0, this, remoteViews, n, n2, f);
        }

        private void __constructor__(RemoteViews remoteViews, Parcel parcel) {
            this.$$robo$$android_widget_RemoteViews_TextViewSizeAction$__constructor__(remoteViews, parcel);
        }

        public TextViewSizeAction(RemoteViews remoteViews, Parcel parcel) {
            this.this$0 = remoteViews;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_RemoteViews_TextViewSizeAction$__constructor__(android.widget.RemoteViews android.os.Parcel ), 0, this, remoteViews, parcel);
        }

        @Override
        public void writeToParcel(Parcel parcel, int n) {
            InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_widget_RemoteViews_TextViewSizeAction$writeToParcel(android.os.Parcel int ), 0, this, parcel, n);
        }

        @Override
        public void apply(View view, ViewGroup viewGroup, OnClickHandler onClickHandler) {
            InvokeDynamicSupport.bootstrap("apply", $$robo$$android_widget_RemoteViews_TextViewSizeAction$apply(android.view.View android.view.ViewGroup android.widget.RemoteViews$OnClickHandler ), 0, this, view, viewGroup, onClickHandler);
        }

        @Override
        public String getActionName() {
            return InvokeDynamicSupport.bootstrap("getActionName", $$robo$$android_widget_RemoteViews_TextViewSizeAction$getActionName(), 0, this);
        }

        public /* synthetic */ TextViewSizeAction() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (TextViewSizeAction)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private class TextViewDrawableAction
    extends Action
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        boolean isRelative;
        int d1;
        int d2;
        int d3;
        int d4;
        public static int TAG = 11;
        /* synthetic */ RemoteViews this$0;

        private void $$robo$$android_widget_RemoteViews_TextViewDrawableAction$__constructor__(RemoteViews remoteViews, int viewId, boolean isRelative, int d1, int d2, int d3, int d4) {
            this.isRelative = false;
            this.viewId = viewId;
            this.isRelative = isRelative;
            this.d1 = d1;
            this.d2 = d2;
            this.d3 = d3;
            this.d4 = d4;
        }

        private void $$robo$$android_widget_RemoteViews_TextViewDrawableAction$__constructor__(RemoteViews remoteViews, Parcel parcel) {
            this.isRelative = false;
            this.viewId = parcel.readInt();
            this.isRelative = parcel.readInt() != 0;
            this.d1 = parcel.readInt();
            this.d2 = parcel.readInt();
            this.d3 = parcel.readInt();
            this.d4 = parcel.readInt();
        }

        private final void $$robo$$android_widget_RemoteViews_TextViewDrawableAction$writeToParcel(Parcel dest, int flags) {
            dest.writeInt(11);
            dest.writeInt(this.viewId);
            dest.writeInt(this.isRelative ? 1 : 0);
            dest.writeInt(this.d1);
            dest.writeInt(this.d2);
            dest.writeInt(this.d3);
            dest.writeInt(this.d4);
        }

        private final void $$robo$$android_widget_RemoteViews_TextViewDrawableAction$apply(View root, ViewGroup rootParent, OnClickHandler handler) {
            TextView target = (TextView)root.findViewById(this.viewId);
            if (target == null) {
                return;
            }
            if (this.isRelative) {
                target.setCompoundDrawablesRelativeWithIntrinsicBounds(this.d1, this.d2, this.d3, this.d4);
            } else {
                target.setCompoundDrawablesWithIntrinsicBounds(this.d1, this.d2, this.d3, this.d4);
            }
        }

        private final String $$robo$$android_widget_RemoteViews_TextViewDrawableAction$getActionName() {
            return "TextViewDrawableAction";
        }

        private void __constructor__(RemoteViews remoteViews, int n, boolean bl, int n2, int n3, int n4, int n5) {
            this.$$robo$$android_widget_RemoteViews_TextViewDrawableAction$__constructor__(remoteViews, n, bl, n2, n3, n4, n5);
        }

        public TextViewDrawableAction(RemoteViews remoteViews, int n, boolean bl, int n2, int n3, int n4, int n5) {
            this.this$0 = remoteViews;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_RemoteViews_TextViewDrawableAction$__constructor__(android.widget.RemoteViews int boolean int int int int ), 0, this, remoteViews, n, bl, n2, n3, n4, n5);
        }

        private void __constructor__(RemoteViews remoteViews, Parcel parcel) {
            this.$$robo$$android_widget_RemoteViews_TextViewDrawableAction$__constructor__(remoteViews, parcel);
        }

        public TextViewDrawableAction(RemoteViews remoteViews, Parcel parcel) {
            this.this$0 = remoteViews;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_RemoteViews_TextViewDrawableAction$__constructor__(android.widget.RemoteViews android.os.Parcel ), 0, this, remoteViews, parcel);
        }

        @Override
        public void writeToParcel(Parcel parcel, int n) {
            InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_widget_RemoteViews_TextViewDrawableAction$writeToParcel(android.os.Parcel int ), 0, this, parcel, n);
        }

        @Override
        public void apply(View view, ViewGroup viewGroup, OnClickHandler onClickHandler) {
            InvokeDynamicSupport.bootstrap("apply", $$robo$$android_widget_RemoteViews_TextViewDrawableAction$apply(android.view.View android.view.ViewGroup android.widget.RemoteViews$OnClickHandler ), 0, this, view, viewGroup, onClickHandler);
        }

        @Override
        public String getActionName() {
            return InvokeDynamicSupport.bootstrap("getActionName", $$robo$$android_widget_RemoteViews_TextViewDrawableAction$getActionName(), 0, this);
        }

        public /* synthetic */ TextViewDrawableAction() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (TextViewDrawableAction)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private class ViewGroupAction
    extends Action
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        RemoteViews nestedViews;
        public static int TAG = 4;
        /* synthetic */ RemoteViews this$0;

        private void $$robo$$android_widget_RemoteViews_ViewGroupAction$__constructor__(RemoteViews remoteViews, int viewId, RemoteViews nestedViews) {
            this.viewId = viewId;
            this.nestedViews = nestedViews;
            if (nestedViews != null) {
                remoteViews.configureRemoteViewsAsChild(nestedViews);
            }
        }

        private void $$robo$$android_widget_RemoteViews_ViewGroupAction$__constructor__(RemoteViews remoteViews, Parcel parcel, BitmapCache bitmapCache) {
            this.viewId = parcel.readInt();
            boolean nestedViewsNull = parcel.readInt() == 0;
            this.nestedViews = !nestedViewsNull ? new RemoteViews(parcel, bitmapCache) : null;
        }

        private final void $$robo$$android_widget_RemoteViews_ViewGroupAction$writeToParcel(Parcel dest, int flags) {
            dest.writeInt(4);
            dest.writeInt(this.viewId);
            if (this.nestedViews != null) {
                dest.writeInt(1);
                this.nestedViews.writeToParcel(dest, flags);
            } else {
                dest.writeInt(0);
            }
        }

        private final void $$robo$$android_widget_RemoteViews_ViewGroupAction$apply(View root, ViewGroup rootParent, OnClickHandler handler) {
            Context context = root.getContext();
            ViewGroup target = (ViewGroup)root.findViewById(this.viewId);
            if (target == null) {
                return;
            }
            if (this.nestedViews != null) {
                target.addView(this.nestedViews.apply(context, target, handler));
            } else {
                target.removeAllViews();
            }
        }

        private final void $$robo$$android_widget_RemoteViews_ViewGroupAction$updateMemoryUsageEstimate(MemoryUsageCounter counter) {
            if (this.nestedViews != null) {
                counter.increment(this.nestedViews.estimateMemoryUsage());
            }
        }

        private final void $$robo$$android_widget_RemoteViews_ViewGroupAction$setBitmapCache(BitmapCache bitmapCache) {
            if (this.nestedViews != null) {
                this.nestedViews.setBitmapCache(bitmapCache);
            }
        }

        private final String $$robo$$android_widget_RemoteViews_ViewGroupAction$getActionName() {
            return "ViewGroupAction" + (this.nestedViews == null ? "Remove" : "Add");
        }

        private final int $$robo$$android_widget_RemoteViews_ViewGroupAction$mergeBehavior() {
            return 1;
        }

        private void __constructor__(RemoteViews remoteViews, int n, RemoteViews remoteViews2) {
            this.$$robo$$android_widget_RemoteViews_ViewGroupAction$__constructor__(remoteViews, n, remoteViews2);
        }

        public ViewGroupAction(RemoteViews remoteViews, int n, RemoteViews remoteViews2) {
            this.this$0 = remoteViews;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_RemoteViews_ViewGroupAction$__constructor__(android.widget.RemoteViews int android.widget.RemoteViews ), 0, this, remoteViews, n, remoteViews2);
        }

        private void __constructor__(RemoteViews remoteViews, Parcel parcel, BitmapCache bitmapCache) {
            this.$$robo$$android_widget_RemoteViews_ViewGroupAction$__constructor__(remoteViews, parcel, bitmapCache);
        }

        public ViewGroupAction(RemoteViews remoteViews, Parcel parcel, BitmapCache bitmapCache) {
            this.this$0 = remoteViews;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_RemoteViews_ViewGroupAction$__constructor__(android.widget.RemoteViews android.os.Parcel android.widget.RemoteViews$BitmapCache ), 0, this, remoteViews, parcel, bitmapCache);
        }

        @Override
        public void writeToParcel(Parcel parcel, int n) {
            InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_widget_RemoteViews_ViewGroupAction$writeToParcel(android.os.Parcel int ), 0, this, parcel, n);
        }

        @Override
        public void apply(View view, ViewGroup viewGroup, OnClickHandler onClickHandler) {
            InvokeDynamicSupport.bootstrap("apply", $$robo$$android_widget_RemoteViews_ViewGroupAction$apply(android.view.View android.view.ViewGroup android.widget.RemoteViews$OnClickHandler ), 0, this, view, viewGroup, onClickHandler);
        }

        @Override
        public void updateMemoryUsageEstimate(MemoryUsageCounter memoryUsageCounter) {
            InvokeDynamicSupport.bootstrap("updateMemoryUsageEstimate", $$robo$$android_widget_RemoteViews_ViewGroupAction$updateMemoryUsageEstimate(android.widget.RemoteViews$MemoryUsageCounter ), 0, this, memoryUsageCounter);
        }

        @Override
        public void setBitmapCache(BitmapCache bitmapCache) {
            InvokeDynamicSupport.bootstrap("setBitmapCache", $$robo$$android_widget_RemoteViews_ViewGroupAction$setBitmapCache(android.widget.RemoteViews$BitmapCache ), 0, this, bitmapCache);
        }

        @Override
        public String getActionName() {
            return InvokeDynamicSupport.bootstrap("getActionName", $$robo$$android_widget_RemoteViews_ViewGroupAction$getActionName(), 0, this);
        }

        @Override
        public int mergeBehavior() {
            return (int)InvokeDynamicSupport.bootstrap("mergeBehavior", $$robo$$android_widget_RemoteViews_ViewGroupAction$mergeBehavior(), 0, this);
        }

        public /* synthetic */ ViewGroupAction() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ViewGroupAction)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    private final class ReflectionAction
    extends Action
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        static int TAG = 2;
        static int BOOLEAN = 1;
        static int BYTE = 2;
        static int SHORT = 3;
        static int INT = 4;
        static int LONG = 5;
        static int FLOAT = 6;
        static int DOUBLE = 7;
        static int CHAR = 8;
        static int STRING = 9;
        static int CHAR_SEQUENCE = 10;
        static int URI = 11;
        static int BITMAP = 12;
        static int BUNDLE = 13;
        static int INTENT = 14;
        String methodName;
        int type;
        Object value;
        /* synthetic */ RemoteViews this$0;

        private void $$robo$$android_widget_RemoteViews_ReflectionAction$__constructor__(RemoteViews remoteViews, int viewId, String methodName, int type, Object value) {
            this.viewId = viewId;
            this.methodName = methodName;
            this.type = type;
            this.value = value;
        }

        private void $$robo$$android_widget_RemoteViews_ReflectionAction$__constructor__(RemoteViews remoteViews, Parcel in) {
            this.viewId = in.readInt();
            this.methodName = in.readString();
            this.type = in.readInt();
            switch (this.type) {
                case 1: {
                    this.value = in.readInt() != 0;
                    break;
                }
                case 2: {
                    this.value = in.readByte();
                    break;
                }
                case 3: {
                    this.value = (short)in.readInt();
                    break;
                }
                case 4: {
                    this.value = in.readInt();
                    break;
                }
                case 5: {
                    this.value = in.readLong();
                    break;
                }
                case 6: {
                    this.value = Float.valueOf(in.readFloat());
                    break;
                }
                case 7: {
                    this.value = in.readDouble();
                    break;
                }
                case 8: {
                    this.value = Character.valueOf((char)in.readInt());
                    break;
                }
                case 9: {
                    this.value = in.readString();
                    break;
                }
                case 10: {
                    this.value = TextUtils.CHAR_SEQUENCE_CREATOR.createFromParcel(in);
                    break;
                }
                case 11: {
                    if (in.readInt() == 0) break;
                    this.value = Uri.CREATOR.createFromParcel(in);
                    break;
                }
                case 12: {
                    if (in.readInt() == 0) break;
                    this.value = Bitmap.CREATOR.createFromParcel(in);
                    break;
                }
                case 13: {
                    this.value = in.readBundle();
                    break;
                }
                case 14: {
                    if (in.readInt() == 0) break;
                    this.value = Intent.CREATOR.createFromParcel(in);
                    break;
                }
            }
        }

        private final void $$robo$$android_widget_RemoteViews_ReflectionAction$writeToParcel(Parcel out, int flags) {
            out.writeInt(2);
            out.writeInt(this.viewId);
            out.writeString(this.methodName);
            out.writeInt(this.type);
            switch (this.type) {
                case 1: {
                    out.writeInt((Boolean)this.value != false ? 1 : 0);
                    break;
                }
                case 2: {
                    out.writeByte((Byte)this.value);
                    break;
                }
                case 3: {
                    out.writeInt(((Short)this.value).shortValue());
                    break;
                }
                case 4: {
                    out.writeInt((Integer)this.value);
                    break;
                }
                case 5: {
                    out.writeLong((Long)this.value);
                    break;
                }
                case 6: {
                    out.writeFloat(((Float)this.value).floatValue());
                    break;
                }
                case 7: {
                    out.writeDouble((Double)this.value);
                    break;
                }
                case 8: {
                    out.writeInt(((Character)this.value).charValue());
                    break;
                }
                case 9: {
                    out.writeString((String)this.value);
                    break;
                }
                case 10: {
                    TextUtils.writeToParcel((CharSequence)this.value, out, flags);
                    break;
                }
                case 11: {
                    out.writeInt(this.value != null ? 1 : 0);
                    if (this.value == null) break;
                    ((Uri)this.value).writeToParcel(out, flags);
                    break;
                }
                case 12: {
                    out.writeInt(this.value != null ? 1 : 0);
                    if (this.value == null) break;
                    ((Bitmap)this.value).writeToParcel(out, flags);
                    break;
                }
                case 13: {
                    out.writeBundle((Bundle)this.value);
                    break;
                }
                case 14: {
                    out.writeInt(this.value != null ? 1 : 0);
                    if (this.value == null) break;
                    ((Intent)this.value).writeToParcel(out, flags);
                    break;
                }
            }
        }

        private final Class<?> $$robo$$android_widget_RemoteViews_ReflectionAction$getParameterType() {
            switch (this.type) {
                case 1: {
                    return Boolean.TYPE;
                }
                case 2: {
                    return Byte.TYPE;
                }
                case 3: {
                    return Short.TYPE;
                }
                case 4: {
                    return Integer.TYPE;
                }
                case 5: {
                    return Long.TYPE;
                }
                case 6: {
                    return Float.TYPE;
                }
                case 7: {
                    return Double.TYPE;
                }
                case 8: {
                    return Character.TYPE;
                }
                case 9: {
                    return String.class;
                }
                case 10: {
                    return CharSequence.class;
                }
                case 11: {
                    return Uri.class;
                }
                case 12: {
                    return Bitmap.class;
                }
                case 13: {
                    return Bundle.class;
                }
                case 14: {
                    return Intent.class;
                }
            }
            return null;
        }

        private final void $$robo$$android_widget_RemoteViews_ReflectionAction$apply(View root, ViewGroup rootParent, OnClickHandler handler) {
            View view = root.findViewById(this.viewId);
            if (view == null) {
                return;
            }
            Class<?> param = this.getParameterType();
            if (param == null) {
                throw new ActionException("bad type: " + this.type);
            }
            try {
                this.this$0.getMethod(view, this.methodName, param).invoke((Object)view, RemoteViews.wrapArg(this.value));
            }
            catch (ActionException e) {
                throw e;
            }
            catch (Exception ex) {
                throw new ActionException(ex);
            }
        }

        private final int $$robo$$android_widget_RemoteViews_ReflectionAction$mergeBehavior() {
            if (this.methodName.equals("smoothScrollBy")) {
                return 1;
            }
            return 0;
        }

        private final String $$robo$$android_widget_RemoteViews_ReflectionAction$getActionName() {
            return "ReflectionAction" + this.methodName + this.type;
        }

        private void __constructor__(RemoteViews remoteViews, int n, String string2, int n2, Object object) {
            this.$$robo$$android_widget_RemoteViews_ReflectionAction$__constructor__(remoteViews, n, string2, n2, object);
        }

        ReflectionAction(RemoteViews remoteViews, int n, String string2, int n2, Object object) {
            this.this$0 = remoteViews;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_RemoteViews_ReflectionAction$__constructor__(android.widget.RemoteViews int java.lang.String int java.lang.Object ), 0, this, remoteViews, n, string2, n2, object);
        }

        private void __constructor__(RemoteViews remoteViews, Parcel parcel) {
            this.$$robo$$android_widget_RemoteViews_ReflectionAction$__constructor__(remoteViews, parcel);
        }

        ReflectionAction(RemoteViews remoteViews, Parcel parcel) {
            this.this$0 = remoteViews;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_RemoteViews_ReflectionAction$__constructor__(android.widget.RemoteViews android.os.Parcel ), 0, this, remoteViews, parcel);
        }

        @Override
        public void writeToParcel(Parcel parcel, int n) {
            InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_widget_RemoteViews_ReflectionAction$writeToParcel(android.os.Parcel int ), 0, this, parcel, n);
        }

        private Class<?> getParameterType() {
            return InvokeDynamicSupport.bootstrap("getParameterType", $$robo$$android_widget_RemoteViews_ReflectionAction$getParameterType(), 0, this);
        }

        @Override
        public void apply(View view, ViewGroup viewGroup, OnClickHandler onClickHandler) {
            InvokeDynamicSupport.bootstrap("apply", $$robo$$android_widget_RemoteViews_ReflectionAction$apply(android.view.View android.view.ViewGroup android.widget.RemoteViews$OnClickHandler ), 0, this, view, viewGroup, onClickHandler);
        }

        @Override
        public int mergeBehavior() {
            return (int)InvokeDynamicSupport.bootstrap("mergeBehavior", $$robo$$android_widget_RemoteViews_ReflectionAction$mergeBehavior(), 0, this);
        }

        @Override
        public String getActionName() {
            return InvokeDynamicSupport.bootstrap("getActionName", $$robo$$android_widget_RemoteViews_ReflectionAction$getActionName(), 0, this);
        }

        public /* synthetic */ ReflectionAction() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ReflectionAction)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private class BitmapReflectionAction
    extends Action
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        int bitmapId;
        Bitmap bitmap;
        String methodName;
        public static int TAG = 12;
        /* synthetic */ RemoteViews this$0;

        private void $$robo$$android_widget_RemoteViews_BitmapReflectionAction$__constructor__(RemoteViews remoteViews, int viewId, String methodName, Bitmap bitmap) {
            this.bitmap = bitmap;
            this.viewId = viewId;
            this.methodName = methodName;
            this.bitmapId = remoteViews.mBitmapCache.getBitmapId(bitmap);
        }

        private void $$robo$$android_widget_RemoteViews_BitmapReflectionAction$__constructor__(RemoteViews remoteViews, Parcel in) {
            this.viewId = in.readInt();
            this.methodName = in.readString();
            this.bitmapId = in.readInt();
            this.bitmap = remoteViews.mBitmapCache.getBitmapForId(this.bitmapId);
        }

        private final void $$robo$$android_widget_RemoteViews_BitmapReflectionAction$writeToParcel(Parcel dest, int flags) {
            dest.writeInt(12);
            dest.writeInt(this.viewId);
            dest.writeString(this.methodName);
            dest.writeInt(this.bitmapId);
        }

        private final void $$robo$$android_widget_RemoteViews_BitmapReflectionAction$apply(View root, ViewGroup rootParent, OnClickHandler handler) throws ActionException {
            ReflectionAction ra = new ReflectionAction(this.this$0, this.viewId, this.methodName, 12, this.bitmap);
            ra.apply(root, rootParent, handler);
        }

        private final void $$robo$$android_widget_RemoteViews_BitmapReflectionAction$setBitmapCache(BitmapCache bitmapCache) {
            this.bitmapId = bitmapCache.getBitmapId(this.bitmap);
        }

        private final String $$robo$$android_widget_RemoteViews_BitmapReflectionAction$getActionName() {
            return "BitmapReflectionAction";
        }

        private void __constructor__(RemoteViews remoteViews, int n, String string2, Bitmap bitmap) {
            this.$$robo$$android_widget_RemoteViews_BitmapReflectionAction$__constructor__(remoteViews, n, string2, bitmap);
        }

        BitmapReflectionAction(RemoteViews remoteViews, int n, String string2, Bitmap bitmap) {
            this.this$0 = remoteViews;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_RemoteViews_BitmapReflectionAction$__constructor__(android.widget.RemoteViews int java.lang.String android.graphics.Bitmap ), 0, this, remoteViews, n, string2, bitmap);
        }

        private void __constructor__(RemoteViews remoteViews, Parcel parcel) {
            this.$$robo$$android_widget_RemoteViews_BitmapReflectionAction$__constructor__(remoteViews, parcel);
        }

        BitmapReflectionAction(RemoteViews remoteViews, Parcel parcel) {
            this.this$0 = remoteViews;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_RemoteViews_BitmapReflectionAction$__constructor__(android.widget.RemoteViews android.os.Parcel ), 0, this, remoteViews, parcel);
        }

        @Override
        public void writeToParcel(Parcel parcel, int n) {
            InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_widget_RemoteViews_BitmapReflectionAction$writeToParcel(android.os.Parcel int ), 0, this, parcel, n);
        }

        @Override
        public void apply(View view, ViewGroup viewGroup, OnClickHandler onClickHandler) throws ActionException {
            InvokeDynamicSupport.bootstrap("apply", $$robo$$android_widget_RemoteViews_BitmapReflectionAction$apply(android.view.View android.view.ViewGroup android.widget.RemoteViews$OnClickHandler ), 0, this, view, viewGroup, onClickHandler);
        }

        @Override
        public void setBitmapCache(BitmapCache bitmapCache) {
            InvokeDynamicSupport.bootstrap("setBitmapCache", $$robo$$android_widget_RemoteViews_BitmapReflectionAction$setBitmapCache(android.widget.RemoteViews$BitmapCache ), 0, this, bitmapCache);
        }

        @Override
        public String getActionName() {
            return InvokeDynamicSupport.bootstrap("getActionName", $$robo$$android_widget_RemoteViews_BitmapReflectionAction$getActionName(), 0, this);
        }

        public /* synthetic */ BitmapReflectionAction() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (BitmapReflectionAction)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private static class BitmapCache
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        ArrayList<Bitmap> mBitmaps;

        private void $$robo$$android_widget_RemoteViews_BitmapCache$__constructor__() {
            this.mBitmaps = new ArrayList();
        }

        private void $$robo$$android_widget_RemoteViews_BitmapCache$__constructor__(Parcel source) {
            int count = source.readInt();
            this.mBitmaps = new ArrayList();
            for (int i = 0; i < count; ++i) {
                Bitmap b = Bitmap.CREATOR.createFromParcel(source);
                this.mBitmaps.add(b);
            }
        }

        private final int $$robo$$android_widget_RemoteViews_BitmapCache$getBitmapId(Bitmap b) {
            if (b == null) {
                return -1;
            }
            if (this.mBitmaps.contains(b)) {
                return this.mBitmaps.indexOf(b);
            }
            this.mBitmaps.add(b);
            return this.mBitmaps.size() - 1;
        }

        private final Bitmap $$robo$$android_widget_RemoteViews_BitmapCache$getBitmapForId(int id2) {
            if (id2 == -1 || id2 >= this.mBitmaps.size()) {
                return null;
            }
            return this.mBitmaps.get(id2);
        }

        private final void $$robo$$android_widget_RemoteViews_BitmapCache$writeBitmapsToParcel(Parcel dest, int flags) {
            int count = this.mBitmaps.size();
            dest.writeInt(count);
            for (int i = 0; i < count; ++i) {
                this.mBitmaps.get(i).writeToParcel(dest, flags);
            }
        }

        private final void $$robo$$android_widget_RemoteViews_BitmapCache$assimilate(BitmapCache bitmapCache) {
            ArrayList<Bitmap> bitmapsToBeAdded = bitmapCache.mBitmaps;
            int count = bitmapsToBeAdded.size();
            for (int i = 0; i < count; ++i) {
                Bitmap b = bitmapsToBeAdded.get(i);
                if (this.mBitmaps.contains(b)) continue;
                this.mBitmaps.add(b);
            }
        }

        private final void $$robo$$android_widget_RemoteViews_BitmapCache$addBitmapMemory(MemoryUsageCounter memoryCounter) {
            for (int i = 0; i < this.mBitmaps.size(); ++i) {
                memoryCounter.addBitmapMemory(this.mBitmaps.get(i));
            }
        }

        private void __constructor__() {
            this.$$robo$$android_widget_RemoteViews_BitmapCache$__constructor__();
        }

        public BitmapCache() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_RemoteViews_BitmapCache$__constructor__(), 0, this);
        }

        private void __constructor__(Parcel parcel) {
            this.$$robo$$android_widget_RemoteViews_BitmapCache$__constructor__(parcel);
        }

        public BitmapCache(Parcel parcel) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_RemoteViews_BitmapCache$__constructor__(android.os.Parcel ), 0, this, parcel);
        }

        public int getBitmapId(Bitmap bitmap) {
            return (int)InvokeDynamicSupport.bootstrap("getBitmapId", $$robo$$android_widget_RemoteViews_BitmapCache$getBitmapId(android.graphics.Bitmap ), 0, this, bitmap);
        }

        public Bitmap getBitmapForId(int n) {
            return InvokeDynamicSupport.bootstrap("getBitmapForId", $$robo$$android_widget_RemoteViews_BitmapCache$getBitmapForId(int ), 0, this, n);
        }

        public void writeBitmapsToParcel(Parcel parcel, int n) {
            InvokeDynamicSupport.bootstrap("writeBitmapsToParcel", $$robo$$android_widget_RemoteViews_BitmapCache$writeBitmapsToParcel(android.os.Parcel int ), 0, this, parcel, n);
        }

        public void assimilate(BitmapCache bitmapCache) {
            InvokeDynamicSupport.bootstrap("assimilate", $$robo$$android_widget_RemoteViews_BitmapCache$assimilate(android.widget.RemoteViews$BitmapCache ), 0, this, bitmapCache);
        }

        public void addBitmapMemory(MemoryUsageCounter memoryUsageCounter) {
            InvokeDynamicSupport.bootstrap("addBitmapMemory", $$robo$$android_widget_RemoteViews_BitmapCache$addBitmapMemory(android.widget.RemoteViews$MemoryUsageCounter ), 0, this, memoryUsageCounter);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (BitmapCache)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    private final class ReflectionActionWithoutParams
    extends Action
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        String methodName;
        public static int TAG = 5;
        /* synthetic */ RemoteViews this$0;

        private void $$robo$$android_widget_RemoteViews_ReflectionActionWithoutParams$__constructor__(RemoteViews remoteViews, int viewId, String methodName) {
            this.viewId = viewId;
            this.methodName = methodName;
        }

        private void $$robo$$android_widget_RemoteViews_ReflectionActionWithoutParams$__constructor__(RemoteViews remoteViews, Parcel in) {
            this.viewId = in.readInt();
            this.methodName = in.readString();
        }

        private final void $$robo$$android_widget_RemoteViews_ReflectionActionWithoutParams$writeToParcel(Parcel out, int flags) {
            out.writeInt(5);
            out.writeInt(this.viewId);
            out.writeString(this.methodName);
        }

        private final void $$robo$$android_widget_RemoteViews_ReflectionActionWithoutParams$apply(View root, ViewGroup rootParent, OnClickHandler handler) {
            View view = root.findViewById(this.viewId);
            if (view == null) {
                return;
            }
            try {
                this.this$0.getMethod(view, this.methodName, null).invoke((Object)view, new Object[0]);
            }
            catch (ActionException e) {
                throw e;
            }
            catch (Exception ex) {
                throw new ActionException(ex);
            }
        }

        private final int $$robo$$android_widget_RemoteViews_ReflectionActionWithoutParams$mergeBehavior() {
            if (this.methodName.equals("showNext") || this.methodName.equals("showPrevious")) {
                return 2;
            }
            return 0;
        }

        private final String $$robo$$android_widget_RemoteViews_ReflectionActionWithoutParams$getActionName() {
            return "ReflectionActionWithoutParams";
        }

        private void __constructor__(RemoteViews remoteViews, int n, String string2) {
            this.$$robo$$android_widget_RemoteViews_ReflectionActionWithoutParams$__constructor__(remoteViews, n, string2);
        }

        ReflectionActionWithoutParams(RemoteViews remoteViews, int n, String string2) {
            this.this$0 = remoteViews;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_RemoteViews_ReflectionActionWithoutParams$__constructor__(android.widget.RemoteViews int java.lang.String ), 0, this, remoteViews, n, string2);
        }

        private void __constructor__(RemoteViews remoteViews, Parcel parcel) {
            this.$$robo$$android_widget_RemoteViews_ReflectionActionWithoutParams$__constructor__(remoteViews, parcel);
        }

        ReflectionActionWithoutParams(RemoteViews remoteViews, Parcel parcel) {
            this.this$0 = remoteViews;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_RemoteViews_ReflectionActionWithoutParams$__constructor__(android.widget.RemoteViews android.os.Parcel ), 0, this, remoteViews, parcel);
        }

        @Override
        public void writeToParcel(Parcel parcel, int n) {
            InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_widget_RemoteViews_ReflectionActionWithoutParams$writeToParcel(android.os.Parcel int ), 0, this, parcel, n);
        }

        @Override
        public void apply(View view, ViewGroup viewGroup, OnClickHandler onClickHandler) {
            InvokeDynamicSupport.bootstrap("apply", $$robo$$android_widget_RemoteViews_ReflectionActionWithoutParams$apply(android.view.View android.view.ViewGroup android.widget.RemoteViews$OnClickHandler ), 0, this, view, viewGroup, onClickHandler);
        }

        @Override
        public int mergeBehavior() {
            return (int)InvokeDynamicSupport.bootstrap("mergeBehavior", $$robo$$android_widget_RemoteViews_ReflectionActionWithoutParams$mergeBehavior(), 0, this);
        }

        @Override
        public String getActionName() {
            return InvokeDynamicSupport.bootstrap("getActionName", $$robo$$android_widget_RemoteViews_ReflectionActionWithoutParams$getActionName(), 0, this);
        }

        public /* synthetic */ ReflectionActionWithoutParams() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ReflectionActionWithoutParams)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private class SetDrawableParameters
    extends Action
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        boolean targetBackground;
        int alpha;
        int colorFilter;
        PorterDuff.Mode filterMode;
        int level;
        public static int TAG = 3;
        /* synthetic */ RemoteViews this$0;

        private void $$robo$$android_widget_RemoteViews_SetDrawableParameters$__constructor__(RemoteViews remoteViews, int id2, boolean targetBackground, int alpha, int colorFilter, PorterDuff.Mode mode, int level) {
            this.viewId = id2;
            this.targetBackground = targetBackground;
            this.alpha = alpha;
            this.colorFilter = colorFilter;
            this.filterMode = mode;
            this.level = level;
        }

        private void $$robo$$android_widget_RemoteViews_SetDrawableParameters$__constructor__(RemoteViews remoteViews, Parcel parcel) {
            this.viewId = parcel.readInt();
            this.targetBackground = parcel.readInt() != 0;
            this.alpha = parcel.readInt();
            this.colorFilter = parcel.readInt();
            boolean hasMode = parcel.readInt() != 0;
            this.filterMode = hasMode ? PorterDuff.Mode.valueOf(parcel.readString()) : null;
            this.level = parcel.readInt();
        }

        private final void $$robo$$android_widget_RemoteViews_SetDrawableParameters$writeToParcel(Parcel dest, int flags) {
            dest.writeInt(3);
            dest.writeInt(this.viewId);
            dest.writeInt(this.targetBackground ? 1 : 0);
            dest.writeInt(this.alpha);
            dest.writeInt(this.colorFilter);
            if (this.filterMode != null) {
                dest.writeInt(1);
                dest.writeString(this.filterMode.toString());
            } else {
                dest.writeInt(0);
            }
            dest.writeInt(this.level);
        }

        private final void $$robo$$android_widget_RemoteViews_SetDrawableParameters$apply(View root, ViewGroup rootParent, OnClickHandler handler) {
            View target = root.findViewById(this.viewId);
            if (target == null) {
                return;
            }
            Drawable targetDrawable = null;
            if (this.targetBackground) {
                targetDrawable = target.getBackground();
            } else if (target instanceof ImageView) {
                ImageView imageView = (ImageView)target;
                targetDrawable = imageView.getDrawable();
            }
            if (targetDrawable != null) {
                if (this.alpha != -1) {
                    targetDrawable.setAlpha(this.alpha);
                }
                if (this.filterMode != null) {
                    targetDrawable.setColorFilter(this.colorFilter, this.filterMode);
                }
                if (this.level != -1) {
                    targetDrawable.setLevel(this.level);
                }
            }
        }

        private final String $$robo$$android_widget_RemoteViews_SetDrawableParameters$getActionName() {
            return "SetDrawableParameters";
        }

        private void __constructor__(RemoteViews remoteViews, int n, boolean bl, int n2, int n3, PorterDuff.Mode mode, int n4) {
            this.$$robo$$android_widget_RemoteViews_SetDrawableParameters$__constructor__(remoteViews, n, bl, n2, n3, mode, n4);
        }

        public SetDrawableParameters(RemoteViews remoteViews, int n, boolean bl, int n2, int n3, PorterDuff.Mode mode, int n4) {
            this.this$0 = remoteViews;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_RemoteViews_SetDrawableParameters$__constructor__(android.widget.RemoteViews int boolean int int android.graphics.PorterDuff$Mode int ), 0, this, remoteViews, n, bl, n2, n3, mode, n4);
        }

        private void __constructor__(RemoteViews remoteViews, Parcel parcel) {
            this.$$robo$$android_widget_RemoteViews_SetDrawableParameters$__constructor__(remoteViews, parcel);
        }

        public SetDrawableParameters(RemoteViews remoteViews, Parcel parcel) {
            this.this$0 = remoteViews;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_RemoteViews_SetDrawableParameters$__constructor__(android.widget.RemoteViews android.os.Parcel ), 0, this, remoteViews, parcel);
        }

        @Override
        public void writeToParcel(Parcel parcel, int n) {
            InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_widget_RemoteViews_SetDrawableParameters$writeToParcel(android.os.Parcel int ), 0, this, parcel, n);
        }

        @Override
        public void apply(View view, ViewGroup viewGroup, OnClickHandler onClickHandler) {
            InvokeDynamicSupport.bootstrap("apply", $$robo$$android_widget_RemoteViews_SetDrawableParameters$apply(android.view.View android.view.ViewGroup android.widget.RemoteViews$OnClickHandler ), 0, this, view, viewGroup, onClickHandler);
        }

        @Override
        public String getActionName() {
            return InvokeDynamicSupport.bootstrap("getActionName", $$robo$$android_widget_RemoteViews_SetDrawableParameters$getActionName(), 0, this);
        }

        public /* synthetic */ SetDrawableParameters() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SetDrawableParameters)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private class SetOnClickPendingIntent
    extends Action
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        PendingIntent pendingIntent;
        public static int TAG = 1;
        /* synthetic */ RemoteViews this$0;

        private void $$robo$$android_widget_RemoteViews_SetOnClickPendingIntent$__constructor__(RemoteViews remoteViews, int id2, PendingIntent pendingIntent) {
            this.viewId = id2;
            this.pendingIntent = pendingIntent;
        }

        private void $$robo$$android_widget_RemoteViews_SetOnClickPendingIntent$__constructor__(RemoteViews remoteViews, Parcel parcel) {
            this.viewId = parcel.readInt();
            if (parcel.readInt() != 0) {
                this.pendingIntent = PendingIntent.readPendingIntentOrNullFromParcel(parcel);
            }
        }

        private final void $$robo$$android_widget_RemoteViews_SetOnClickPendingIntent$writeToParcel(Parcel dest, int flags) {
            dest.writeInt(1);
            dest.writeInt(this.viewId);
            dest.writeInt(this.pendingIntent != null ? 1 : 0);
            if (this.pendingIntent != null) {
                this.pendingIntent.writeToParcel(dest, 0);
            }
        }

        private final void $$robo$$android_widget_RemoteViews_SetOnClickPendingIntent$apply(View root, ViewGroup rootParent, OnClickHandler handler) {
            View target = root.findViewById(this.viewId);
            if (target == null) {
                return;
            }
            if (this.this$0.mIsWidgetCollectionChild) {
                Log.w("RemoteViews", "Cannot setOnClickPendingIntent for collection item (id: " + this.viewId + ")");
                ApplicationInfo appInfo = root.getContext().getApplicationInfo();
                if (appInfo != null && appInfo.targetSdkVersion >= 16) {
                    return;
                }
            }
            View.OnClickListener listener = null;
            if (this.pendingIntent != null) {
                listener = new View.OnClickListener(this, handler){
                    public transient /* synthetic */ Object __robo_data__;
                    /* synthetic */ OnClickHandler val$handler;
                    /* synthetic */ SetOnClickPendingIntent this$1;

                    private void $$robo$$android_widget_RemoteViews_SetOnClickPendingIntent_1$__constructor__(SetOnClickPendingIntent setOnClickPendingIntent, OnClickHandler onClickHandler) {
                    }

                    private final void $$robo$$android_widget_RemoteViews_SetOnClickPendingIntent_1$onClick(View v) {
                        Rect rect = RemoteViews.getSourceBounds(v);
                        Intent intent = new Intent();
                        intent.setSourceBounds(rect);
                        this.val$handler.onClickHandler(v, this.this$1.pendingIntent, intent);
                    }

                    private void __constructor__(SetOnClickPendingIntent setOnClickPendingIntent, OnClickHandler onClickHandler) {
                        this.$$robo$$android_widget_RemoteViews_SetOnClickPendingIntent_1$__constructor__(setOnClickPendingIntent, onClickHandler);
                    }
                    {
                        this.this$1 = setOnClickPendingIntent;
                        this.val$handler = onClickHandler;
                        this.$$robo$init();
                        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_RemoteViews_SetOnClickPendingIntent_1$__constructor__(android.widget.RemoteViews$SetOnClickPendingIntent android.widget.RemoteViews$OnClickHandler ), 0, this, setOnClickPendingIntent, onClickHandler);
                    }

                    @Override
                    public void onClick(View view) {
                        InvokeDynamicSupport.bootstrap("onClick", $$robo$$android_widget_RemoteViews_SetOnClickPendingIntent_1$onClick(android.view.View ), 0, this, view);
                    }
                    {
                        this.$$robo$init();
                    }

                    protected /* synthetic */ void $$robo$init() {
                        if (this.__robo_data__ == null) {
                            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                        }
                    }

                    public /* synthetic */ Object $$robo$getData() {
                        return this.__robo_data__;
                    }
                };
            }
            target.setOnClickListener(listener);
        }

        private final String $$robo$$android_widget_RemoteViews_SetOnClickPendingIntent$getActionName() {
            return "SetOnClickPendingIntent";
        }

        private void __constructor__(RemoteViews remoteViews, int n, PendingIntent pendingIntent) {
            this.$$robo$$android_widget_RemoteViews_SetOnClickPendingIntent$__constructor__(remoteViews, n, pendingIntent);
        }

        public SetOnClickPendingIntent(RemoteViews remoteViews, int n, PendingIntent pendingIntent) {
            this.this$0 = remoteViews;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_RemoteViews_SetOnClickPendingIntent$__constructor__(android.widget.RemoteViews int android.app.PendingIntent ), 0, this, remoteViews, n, pendingIntent);
        }

        private void __constructor__(RemoteViews remoteViews, Parcel parcel) {
            this.$$robo$$android_widget_RemoteViews_SetOnClickPendingIntent$__constructor__(remoteViews, parcel);
        }

        public SetOnClickPendingIntent(RemoteViews remoteViews, Parcel parcel) {
            this.this$0 = remoteViews;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_RemoteViews_SetOnClickPendingIntent$__constructor__(android.widget.RemoteViews android.os.Parcel ), 0, this, remoteViews, parcel);
        }

        @Override
        public void writeToParcel(Parcel parcel, int n) {
            InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_widget_RemoteViews_SetOnClickPendingIntent$writeToParcel(android.os.Parcel int ), 0, this, parcel, n);
        }

        @Override
        public void apply(View view, ViewGroup viewGroup, OnClickHandler onClickHandler) {
            InvokeDynamicSupport.bootstrap("apply", $$robo$$android_widget_RemoteViews_SetOnClickPendingIntent$apply(android.view.View android.view.ViewGroup android.widget.RemoteViews$OnClickHandler ), 0, this, view, viewGroup, onClickHandler);
        }

        @Override
        public String getActionName() {
            return InvokeDynamicSupport.bootstrap("getActionName", $$robo$$android_widget_RemoteViews_SetOnClickPendingIntent$getActionName(), 0, this);
        }

        public /* synthetic */ SetOnClickPendingIntent() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SetOnClickPendingIntent)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private class SetRemoteViewsAdapterIntent
    extends Action
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        Intent intent;
        public static int TAG = 10;
        /* synthetic */ RemoteViews this$0;

        private void $$robo$$android_widget_RemoteViews_SetRemoteViewsAdapterIntent$__constructor__(RemoteViews remoteViews, int id2, Intent intent) {
            this.viewId = id2;
            this.intent = intent;
        }

        private void $$robo$$android_widget_RemoteViews_SetRemoteViewsAdapterIntent$__constructor__(RemoteViews remoteViews, Parcel parcel) {
            this.viewId = parcel.readInt();
            this.intent = Intent.CREATOR.createFromParcel(parcel);
        }

        private final void $$robo$$android_widget_RemoteViews_SetRemoteViewsAdapterIntent$writeToParcel(Parcel dest, int flags) {
            dest.writeInt(10);
            dest.writeInt(this.viewId);
            this.intent.writeToParcel(dest, flags);
        }

        private final void $$robo$$android_widget_RemoteViews_SetRemoteViewsAdapterIntent$apply(View root, ViewGroup rootParent, OnClickHandler handler) {
            View target = root.findViewById(this.viewId);
            if (target == null) {
                return;
            }
            if (!(rootParent instanceof AppWidgetHostView)) {
                Log.e("RemoteViews", "SetRemoteViewsAdapterIntent action can only be used for AppWidgets (root id: " + this.viewId + ")");
                return;
            }
            if (!(target instanceof AbsListView) && !(target instanceof AdapterViewAnimator)) {
                Log.e("RemoteViews", "Cannot setRemoteViewsAdapter on a view which is not an AbsListView or AdapterViewAnimator (id: " + this.viewId + ")");
                return;
            }
            AppWidgetHostView host = (AppWidgetHostView)rootParent;
            this.intent.putExtra("remoteAdapterAppWidgetId", host.getAppWidgetId());
            if (target instanceof AbsListView) {
                AbsListView v = (AbsListView)target;
                v.setRemoteViewsAdapter(this.intent);
                v.setRemoteViewsOnClickHandler(handler);
            } else if (target instanceof AdapterViewAnimator) {
                AdapterViewAnimator v = (AdapterViewAnimator)target;
                v.setRemoteViewsAdapter(this.intent);
                v.setRemoteViewsOnClickHandler(handler);
            }
        }

        private final String $$robo$$android_widget_RemoteViews_SetRemoteViewsAdapterIntent$getActionName() {
            return "SetRemoteViewsAdapterIntent";
        }

        private void __constructor__(RemoteViews remoteViews, int n, Intent intent) {
            this.$$robo$$android_widget_RemoteViews_SetRemoteViewsAdapterIntent$__constructor__(remoteViews, n, intent);
        }

        public SetRemoteViewsAdapterIntent(RemoteViews remoteViews, int n, Intent intent) {
            this.this$0 = remoteViews;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_RemoteViews_SetRemoteViewsAdapterIntent$__constructor__(android.widget.RemoteViews int android.content.Intent ), 0, this, remoteViews, n, intent);
        }

        private void __constructor__(RemoteViews remoteViews, Parcel parcel) {
            this.$$robo$$android_widget_RemoteViews_SetRemoteViewsAdapterIntent$__constructor__(remoteViews, parcel);
        }

        public SetRemoteViewsAdapterIntent(RemoteViews remoteViews, Parcel parcel) {
            this.this$0 = remoteViews;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_RemoteViews_SetRemoteViewsAdapterIntent$__constructor__(android.widget.RemoteViews android.os.Parcel ), 0, this, remoteViews, parcel);
        }

        @Override
        public void writeToParcel(Parcel parcel, int n) {
            InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_widget_RemoteViews_SetRemoteViewsAdapterIntent$writeToParcel(android.os.Parcel int ), 0, this, parcel, n);
        }

        @Override
        public void apply(View view, ViewGroup viewGroup, OnClickHandler onClickHandler) {
            InvokeDynamicSupport.bootstrap("apply", $$robo$$android_widget_RemoteViews_SetRemoteViewsAdapterIntent$apply(android.view.View android.view.ViewGroup android.widget.RemoteViews$OnClickHandler ), 0, this, view, viewGroup, onClickHandler);
        }

        @Override
        public String getActionName() {
            return InvokeDynamicSupport.bootstrap("getActionName", $$robo$$android_widget_RemoteViews_SetRemoteViewsAdapterIntent$getActionName(), 0, this);
        }

        public /* synthetic */ SetRemoteViewsAdapterIntent() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SetRemoteViewsAdapterIntent)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private class SetRemoteViewsAdapterList
    extends Action
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        int viewTypeCount;
        ArrayList<RemoteViews> list;
        public static int TAG = 15;
        /* synthetic */ RemoteViews this$0;

        private void $$robo$$android_widget_RemoteViews_SetRemoteViewsAdapterList$__constructor__(RemoteViews remoteViews, int id2, ArrayList<RemoteViews> list, int viewTypeCount) {
            this.viewId = id2;
            this.list = list;
            this.viewTypeCount = viewTypeCount;
        }

        private void $$robo$$android_widget_RemoteViews_SetRemoteViewsAdapterList$__constructor__(RemoteViews remoteViews, Parcel parcel) {
            this.viewId = parcel.readInt();
            this.viewTypeCount = parcel.readInt();
            int count = parcel.readInt();
            this.list = new ArrayList();
            for (int i = 0; i < count; ++i) {
                RemoteViews rv = CREATOR.createFromParcel(parcel);
                this.list.add(rv);
            }
        }

        private final void $$robo$$android_widget_RemoteViews_SetRemoteViewsAdapterList$writeToParcel(Parcel dest, int flags) {
            dest.writeInt(15);
            dest.writeInt(this.viewId);
            dest.writeInt(this.viewTypeCount);
            if (this.list == null || this.list.size() == 0) {
                dest.writeInt(0);
            } else {
                int count = this.list.size();
                dest.writeInt(count);
                for (int i = 0; i < count; ++i) {
                    RemoteViews rv = this.list.get(i);
                    rv.writeToParcel(dest, flags);
                }
            }
        }

        private final void $$robo$$android_widget_RemoteViews_SetRemoteViewsAdapterList$apply(View root, ViewGroup rootParent, OnClickHandler handler) {
            View target = root.findViewById(this.viewId);
            if (target == null) {
                return;
            }
            if (!(rootParent instanceof AppWidgetHostView)) {
                Log.e("RemoteViews", "SetRemoteViewsAdapterIntent action can only be used for AppWidgets (root id: " + this.viewId + ")");
                return;
            }
            if (!(target instanceof AbsListView) && !(target instanceof AdapterViewAnimator)) {
                Log.e("RemoteViews", "Cannot setRemoteViewsAdapter on a view which is not an AbsListView or AdapterViewAnimator (id: " + this.viewId + ")");
                return;
            }
            if (target instanceof AbsListView) {
                AbsListView v = (AbsListView)target;
                Object a = v.getAdapter();
                if (a instanceof RemoteViewsListAdapter && this.viewTypeCount <= a.getViewTypeCount()) {
                    ((RemoteViewsListAdapter)a).setViewsList(this.list);
                } else {
                    v.setAdapter(new RemoteViewsListAdapter(v.getContext(), this.list, this.viewTypeCount));
                }
            } else if (target instanceof AdapterViewAnimator) {
                AdapterViewAnimator v = (AdapterViewAnimator)target;
                Adapter a = v.getAdapter();
                if (a instanceof RemoteViewsListAdapter && this.viewTypeCount <= a.getViewTypeCount()) {
                    ((RemoteViewsListAdapter)a).setViewsList(this.list);
                } else {
                    v.setAdapter(new RemoteViewsListAdapter(v.getContext(), this.list, this.viewTypeCount));
                }
            }
        }

        private final String $$robo$$android_widget_RemoteViews_SetRemoteViewsAdapterList$getActionName() {
            return "SetRemoteViewsAdapterList";
        }

        private void __constructor__(RemoteViews remoteViews, int n, ArrayList<RemoteViews> arrayList, int n2) {
            this.$$robo$$android_widget_RemoteViews_SetRemoteViewsAdapterList$__constructor__(remoteViews, n, arrayList, n2);
        }

        public SetRemoteViewsAdapterList(RemoteViews remoteViews, int n, ArrayList<RemoteViews> arrayList, int n2) {
            this.this$0 = remoteViews;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_RemoteViews_SetRemoteViewsAdapterList$__constructor__(android.widget.RemoteViews int java.util.ArrayList<android.widget.RemoteViews> int ), 0, this, remoteViews, n, arrayList, n2);
        }

        private void __constructor__(RemoteViews remoteViews, Parcel parcel) {
            this.$$robo$$android_widget_RemoteViews_SetRemoteViewsAdapterList$__constructor__(remoteViews, parcel);
        }

        public SetRemoteViewsAdapterList(RemoteViews remoteViews, Parcel parcel) {
            this.this$0 = remoteViews;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_RemoteViews_SetRemoteViewsAdapterList$__constructor__(android.widget.RemoteViews android.os.Parcel ), 0, this, remoteViews, parcel);
        }

        @Override
        public void writeToParcel(Parcel parcel, int n) {
            InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_widget_RemoteViews_SetRemoteViewsAdapterList$writeToParcel(android.os.Parcel int ), 0, this, parcel, n);
        }

        @Override
        public void apply(View view, ViewGroup viewGroup, OnClickHandler onClickHandler) {
            InvokeDynamicSupport.bootstrap("apply", $$robo$$android_widget_RemoteViews_SetRemoteViewsAdapterList$apply(android.view.View android.view.ViewGroup android.widget.RemoteViews$OnClickHandler ), 0, this, view, viewGroup, onClickHandler);
        }

        @Override
        public String getActionName() {
            return InvokeDynamicSupport.bootstrap("getActionName", $$robo$$android_widget_RemoteViews_SetRemoteViewsAdapterList$getActionName(), 0, this);
        }

        public /* synthetic */ SetRemoteViewsAdapterList() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SetRemoteViewsAdapterList)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private class SetPendingIntentTemplate
    extends Action
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        PendingIntent pendingIntentTemplate;
        public static int TAG = 8;
        /* synthetic */ RemoteViews this$0;

        private void $$robo$$android_widget_RemoteViews_SetPendingIntentTemplate$__constructor__(RemoteViews remoteViews, int id2, PendingIntent pendingIntentTemplate) {
            this.viewId = id2;
            this.pendingIntentTemplate = pendingIntentTemplate;
        }

        private void $$robo$$android_widget_RemoteViews_SetPendingIntentTemplate$__constructor__(RemoteViews remoteViews, Parcel parcel) {
            this.viewId = parcel.readInt();
            this.pendingIntentTemplate = PendingIntent.readPendingIntentOrNullFromParcel(parcel);
        }

        private final void $$robo$$android_widget_RemoteViews_SetPendingIntentTemplate$writeToParcel(Parcel dest, int flags) {
            dest.writeInt(8);
            dest.writeInt(this.viewId);
            this.pendingIntentTemplate.writeToParcel(dest, 0);
        }

        private final void $$robo$$android_widget_RemoteViews_SetPendingIntentTemplate$apply(View root, ViewGroup rootParent, OnClickHandler handler) {
            View target = root.findViewById(this.viewId);
            if (target == null) {
                return;
            }
            if (!(target instanceof AdapterView)) {
                Log.e("RemoteViews", "Cannot setPendingIntentTemplate on a view which is notan AdapterView (id: " + this.viewId + ")");
                return;
            }
            AdapterView av = (AdapterView)target;
            AdapterView.OnItemClickListener listener = new AdapterView.OnItemClickListener(this, handler){
                public transient /* synthetic */ Object __robo_data__;
                /* synthetic */ OnClickHandler val$handler;
                /* synthetic */ SetPendingIntentTemplate this$1;

                private void $$robo$$android_widget_RemoteViews_SetPendingIntentTemplate_1$__constructor__(SetPendingIntentTemplate setPendingIntentTemplate, OnClickHandler onClickHandler) {
                }

                private final void $$robo$$android_widget_RemoteViews_SetPendingIntentTemplate_1$onItemClick(AdapterView<?> parent, View view, int position, long id2) {
                    if (view instanceof ViewGroup) {
                        ViewGroup vg = (ViewGroup)view;
                        if (parent instanceof AdapterViewAnimator) {
                            vg = (ViewGroup)vg.getChildAt(0);
                        }
                        if (vg == null) {
                            return;
                        }
                        Intent fillInIntent = null;
                        int childCount = vg.getChildCount();
                        for (int i = 0; i < childCount; ++i) {
                            Object tag = vg.getChildAt(i).getTag(16908345);
                            if (!(tag instanceof Intent)) continue;
                            fillInIntent = (Intent)tag;
                            break;
                        }
                        if (fillInIntent == null) {
                            return;
                        }
                        Rect rect = RemoteViews.getSourceBounds(view);
                        Intent intent = new Intent();
                        intent.setSourceBounds(rect);
                        this.val$handler.onClickHandler(view, this.this$1.pendingIntentTemplate, fillInIntent);
                    }
                }

                private void __constructor__(SetPendingIntentTemplate setPendingIntentTemplate, OnClickHandler onClickHandler) {
                    this.$$robo$$android_widget_RemoteViews_SetPendingIntentTemplate_1$__constructor__(setPendingIntentTemplate, onClickHandler);
                }
                {
                    this.this$1 = setPendingIntentTemplate;
                    this.val$handler = onClickHandler;
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_RemoteViews_SetPendingIntentTemplate_1$__constructor__(android.widget.RemoteViews$SetPendingIntentTemplate android.widget.RemoteViews$OnClickHandler ), 0, this, setPendingIntentTemplate, onClickHandler);
                }

                @Override
                public void onItemClick(AdapterView<?> adapterView, View view, int n, long l) {
                    InvokeDynamicSupport.bootstrap("onItemClick", $$robo$$android_widget_RemoteViews_SetPendingIntentTemplate_1$onItemClick(android.widget.AdapterView<?> android.view.View int long ), 0, this, adapterView, view, n, l);
                }
                {
                    this.$$robo$init();
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            };
            av.setOnItemClickListener(listener);
            av.setTag(this.pendingIntentTemplate);
        }

        private final String $$robo$$android_widget_RemoteViews_SetPendingIntentTemplate$getActionName() {
            return "SetPendingIntentTemplate";
        }

        private void __constructor__(RemoteViews remoteViews, int n, PendingIntent pendingIntent) {
            this.$$robo$$android_widget_RemoteViews_SetPendingIntentTemplate$__constructor__(remoteViews, n, pendingIntent);
        }

        public SetPendingIntentTemplate(RemoteViews remoteViews, int n, PendingIntent pendingIntent) {
            this.this$0 = remoteViews;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_RemoteViews_SetPendingIntentTemplate$__constructor__(android.widget.RemoteViews int android.app.PendingIntent ), 0, this, remoteViews, n, pendingIntent);
        }

        private void __constructor__(RemoteViews remoteViews, Parcel parcel) {
            this.$$robo$$android_widget_RemoteViews_SetPendingIntentTemplate$__constructor__(remoteViews, parcel);
        }

        public SetPendingIntentTemplate(RemoteViews remoteViews, Parcel parcel) {
            this.this$0 = remoteViews;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_RemoteViews_SetPendingIntentTemplate$__constructor__(android.widget.RemoteViews android.os.Parcel ), 0, this, remoteViews, parcel);
        }

        @Override
        public void writeToParcel(Parcel parcel, int n) {
            InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_widget_RemoteViews_SetPendingIntentTemplate$writeToParcel(android.os.Parcel int ), 0, this, parcel, n);
        }

        @Override
        public void apply(View view, ViewGroup viewGroup, OnClickHandler onClickHandler) {
            InvokeDynamicSupport.bootstrap("apply", $$robo$$android_widget_RemoteViews_SetPendingIntentTemplate$apply(android.view.View android.view.ViewGroup android.widget.RemoteViews$OnClickHandler ), 0, this, view, viewGroup, onClickHandler);
        }

        @Override
        public String getActionName() {
            return InvokeDynamicSupport.bootstrap("getActionName", $$robo$$android_widget_RemoteViews_SetPendingIntentTemplate$getActionName(), 0, this);
        }

        public /* synthetic */ SetPendingIntentTemplate() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SetPendingIntentTemplate)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private class SetOnClickFillInIntent
    extends Action
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        Intent fillInIntent;
        public static int TAG = 9;
        /* synthetic */ RemoteViews this$0;

        private void $$robo$$android_widget_RemoteViews_SetOnClickFillInIntent$__constructor__(RemoteViews remoteViews, int id2, Intent fillInIntent) {
            this.viewId = id2;
            this.fillInIntent = fillInIntent;
        }

        private void $$robo$$android_widget_RemoteViews_SetOnClickFillInIntent$__constructor__(RemoteViews remoteViews, Parcel parcel) {
            this.viewId = parcel.readInt();
            this.fillInIntent = Intent.CREATOR.createFromParcel(parcel);
        }

        private final void $$robo$$android_widget_RemoteViews_SetOnClickFillInIntent$writeToParcel(Parcel dest, int flags) {
            dest.writeInt(9);
            dest.writeInt(this.viewId);
            this.fillInIntent.writeToParcel(dest, 0);
        }

        private final void $$robo$$android_widget_RemoteViews_SetOnClickFillInIntent$apply(View root, ViewGroup rootParent, OnClickHandler handler) {
            View target = root.findViewById(this.viewId);
            if (target == null) {
                return;
            }
            if (!this.this$0.mIsWidgetCollectionChild) {
                Log.e("RemoteViews", "The method setOnClickFillInIntent is available only from RemoteViewsFactory (ie. on collection items).");
                return;
            }
            if (target == root) {
                target.setTagInternal(16908345, this.fillInIntent);
            } else if (this.fillInIntent != null) {
                View.OnClickListener listener = new View.OnClickListener(this, handler){
                    public transient /* synthetic */ Object __robo_data__;
                    /* synthetic */ OnClickHandler val$handler;
                    /* synthetic */ SetOnClickFillInIntent this$1;

                    private void $$robo$$android_widget_RemoteViews_SetOnClickFillInIntent_1$__constructor__(SetOnClickFillInIntent setOnClickFillInIntent, OnClickHandler onClickHandler) {
                    }

                    private final void $$robo$$android_widget_RemoteViews_SetOnClickFillInIntent_1$onClick(View v) {
                        View parent;
                        for (parent = (View)((Object)v.getParent()); parent != null && !(parent instanceof AdapterView) && !(parent instanceof AppWidgetHostView); parent = (View)((Object)parent.getParent())) {
                        }
                        if (parent instanceof AppWidgetHostView || parent == null) {
                            Log.e("RemoteViews", "Collection item doesn't have AdapterView parent");
                            return;
                        }
                        if (!(parent.getTag() instanceof PendingIntent)) {
                            Log.e("RemoteViews", "Attempting setOnClickFillInIntent without calling setPendingIntentTemplate on parent.");
                            return;
                        }
                        PendingIntent pendingIntent = (PendingIntent)parent.getTag();
                        Rect rect = RemoteViews.getSourceBounds(v);
                        this.this$1.fillInIntent.setSourceBounds(rect);
                        this.val$handler.onClickHandler(v, pendingIntent, this.this$1.fillInIntent);
                    }

                    private void __constructor__(SetOnClickFillInIntent setOnClickFillInIntent, OnClickHandler onClickHandler) {
                        this.$$robo$$android_widget_RemoteViews_SetOnClickFillInIntent_1$__constructor__(setOnClickFillInIntent, onClickHandler);
                    }
                    {
                        this.this$1 = setOnClickFillInIntent;
                        this.val$handler = onClickHandler;
                        this.$$robo$init();
                        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_RemoteViews_SetOnClickFillInIntent_1$__constructor__(android.widget.RemoteViews$SetOnClickFillInIntent android.widget.RemoteViews$OnClickHandler ), 0, this, setOnClickFillInIntent, onClickHandler);
                    }

                    @Override
                    public void onClick(View view) {
                        InvokeDynamicSupport.bootstrap("onClick", $$robo$$android_widget_RemoteViews_SetOnClickFillInIntent_1$onClick(android.view.View ), 0, this, view);
                    }
                    {
                        this.$$robo$init();
                    }

                    protected /* synthetic */ void $$robo$init() {
                        if (this.__robo_data__ == null) {
                            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                        }
                    }

                    public /* synthetic */ Object $$robo$getData() {
                        return this.__robo_data__;
                    }
                };
                target.setOnClickListener(listener);
            }
        }

        private final String $$robo$$android_widget_RemoteViews_SetOnClickFillInIntent$getActionName() {
            return "SetOnClickFillInIntent";
        }

        private void __constructor__(RemoteViews remoteViews, int n, Intent intent) {
            this.$$robo$$android_widget_RemoteViews_SetOnClickFillInIntent$__constructor__(remoteViews, n, intent);
        }

        public SetOnClickFillInIntent(RemoteViews remoteViews, int n, Intent intent) {
            this.this$0 = remoteViews;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_RemoteViews_SetOnClickFillInIntent$__constructor__(android.widget.RemoteViews int android.content.Intent ), 0, this, remoteViews, n, intent);
        }

        private void __constructor__(RemoteViews remoteViews, Parcel parcel) {
            this.$$robo$$android_widget_RemoteViews_SetOnClickFillInIntent$__constructor__(remoteViews, parcel);
        }

        public SetOnClickFillInIntent(RemoteViews remoteViews, Parcel parcel) {
            this.this$0 = remoteViews;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_RemoteViews_SetOnClickFillInIntent$__constructor__(android.widget.RemoteViews android.os.Parcel ), 0, this, remoteViews, parcel);
        }

        @Override
        public void writeToParcel(Parcel parcel, int n) {
            InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_widget_RemoteViews_SetOnClickFillInIntent$writeToParcel(android.os.Parcel int ), 0, this, parcel, n);
        }

        @Override
        public void apply(View view, ViewGroup viewGroup, OnClickHandler onClickHandler) {
            InvokeDynamicSupport.bootstrap("apply", $$robo$$android_widget_RemoteViews_SetOnClickFillInIntent$apply(android.view.View android.view.ViewGroup android.widget.RemoteViews$OnClickHandler ), 0, this, view, viewGroup, onClickHandler);
        }

        @Override
        public String getActionName() {
            return InvokeDynamicSupport.bootstrap("getActionName", $$robo$$android_widget_RemoteViews_SetOnClickFillInIntent$getActionName(), 0, this);
        }

        public /* synthetic */ SetOnClickFillInIntent() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SetOnClickFillInIntent)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private class SetEmptyView
    extends Action
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        int viewId;
        int emptyViewId;
        public static int TAG = 6;
        /* synthetic */ RemoteViews this$0;

        private void $$robo$$android_widget_RemoteViews_SetEmptyView$__constructor__(RemoteViews remoteViews, int viewId, int emptyViewId) {
            this.viewId = viewId;
            this.emptyViewId = emptyViewId;
        }

        private void $$robo$$android_widget_RemoteViews_SetEmptyView$__constructor__(RemoteViews remoteViews, Parcel in) {
            this.viewId = in.readInt();
            this.emptyViewId = in.readInt();
        }

        private final void $$robo$$android_widget_RemoteViews_SetEmptyView$writeToParcel(Parcel out, int flags) {
            out.writeInt(6);
            out.writeInt(this.viewId);
            out.writeInt(this.emptyViewId);
        }

        private final void $$robo$$android_widget_RemoteViews_SetEmptyView$apply(View root, ViewGroup rootParent, OnClickHandler handler) {
            View view = root.findViewById(this.viewId);
            if (!(view instanceof AdapterView)) {
                return;
            }
            AdapterView adapterView = (AdapterView)view;
            View emptyView = root.findViewById(this.emptyViewId);
            if (emptyView == null) {
                return;
            }
            adapterView.setEmptyView(emptyView);
        }

        private final String $$robo$$android_widget_RemoteViews_SetEmptyView$getActionName() {
            return "SetEmptyView";
        }

        private void __constructor__(RemoteViews remoteViews, int n, int n2) {
            this.$$robo$$android_widget_RemoteViews_SetEmptyView$__constructor__(remoteViews, n, n2);
        }

        SetEmptyView(RemoteViews remoteViews, int n, int n2) {
            this.this$0 = remoteViews;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_RemoteViews_SetEmptyView$__constructor__(android.widget.RemoteViews int int ), 0, this, remoteViews, n, n2);
        }

        private void __constructor__(RemoteViews remoteViews, Parcel parcel) {
            this.$$robo$$android_widget_RemoteViews_SetEmptyView$__constructor__(remoteViews, parcel);
        }

        SetEmptyView(RemoteViews remoteViews, Parcel parcel) {
            this.this$0 = remoteViews;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_RemoteViews_SetEmptyView$__constructor__(android.widget.RemoteViews android.os.Parcel ), 0, this, remoteViews, parcel);
        }

        @Override
        public void writeToParcel(Parcel parcel, int n) {
            InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_widget_RemoteViews_SetEmptyView$writeToParcel(android.os.Parcel int ), 0, this, parcel, n);
        }

        @Override
        public void apply(View view, ViewGroup viewGroup, OnClickHandler onClickHandler) {
            InvokeDynamicSupport.bootstrap("apply", $$robo$$android_widget_RemoteViews_SetEmptyView$apply(android.view.View android.view.ViewGroup android.widget.RemoteViews$OnClickHandler ), 0, this, view, viewGroup, onClickHandler);
        }

        @Override
        public String getActionName() {
            return InvokeDynamicSupport.bootstrap("getActionName", $$robo$$android_widget_RemoteViews_SetEmptyView$getActionName(), 0, this);
        }

        public /* synthetic */ SetEmptyView() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SetEmptyView)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private static abstract class Action
    implements Parcelable,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public static int MERGE_REPLACE = 0;
        public static int MERGE_APPEND = 1;
        public static int MERGE_IGNORE = 2;
        int viewId;

        private void $$robo$$android_widget_RemoteViews_Action$__constructor__() {
        }

        public abstract void apply(View var1, ViewGroup var2, OnClickHandler var3) throws ActionException;

        private final int $$robo$$android_widget_RemoteViews_Action$describeContents() {
            return 0;
        }

        private final void $$robo$$android_widget_RemoteViews_Action$updateMemoryUsageEstimate(MemoryUsageCounter counter) {
        }

        private final void $$robo$$android_widget_RemoteViews_Action$setBitmapCache(BitmapCache bitmapCache) {
        }

        private final int $$robo$$android_widget_RemoteViews_Action$mergeBehavior() {
            return 0;
        }

        public abstract String getActionName();

        private final String $$robo$$android_widget_RemoteViews_Action$getUniqueKey() {
            return this.getActionName() + this.viewId;
        }

        private /* synthetic */ void $$robo$$android_widget_RemoteViews_Action$__constructor__(1 x0) {
        }

        private void __constructor__() {
            this.$$robo$$android_widget_RemoteViews_Action$__constructor__();
        }

        private Action() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_RemoteViews_Action$__constructor__(), 0, this);
        }

        @Override
        public int describeContents() {
            return (int)InvokeDynamicSupport.bootstrap("describeContents", $$robo$$android_widget_RemoteViews_Action$describeContents(), 0, this);
        }

        public void updateMemoryUsageEstimate(MemoryUsageCounter memoryUsageCounter) {
            InvokeDynamicSupport.bootstrap("updateMemoryUsageEstimate", $$robo$$android_widget_RemoteViews_Action$updateMemoryUsageEstimate(android.widget.RemoteViews$MemoryUsageCounter ), 0, this, memoryUsageCounter);
        }

        public void setBitmapCache(BitmapCache bitmapCache) {
            InvokeDynamicSupport.bootstrap("setBitmapCache", $$robo$$android_widget_RemoteViews_Action$setBitmapCache(android.widget.RemoteViews$BitmapCache ), 0, this, bitmapCache);
        }

        public int mergeBehavior() {
            return (int)InvokeDynamicSupport.bootstrap("mergeBehavior", $$robo$$android_widget_RemoteViews_Action$mergeBehavior(), 0, this);
        }

        public String getUniqueKey() {
            return InvokeDynamicSupport.bootstrap("getUniqueKey", $$robo$$android_widget_RemoteViews_Action$getUniqueKey(), 0, this);
        }

        private /* synthetic */ void __constructor__(1 var1_1) {
            this.$$robo$$android_widget_RemoteViews_Action$__constructor__(var1_1);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Action)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class OnClickHandler
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;

        private void $$robo$$android_widget_RemoteViews_OnClickHandler$__constructor__() {
        }

        private final boolean $$robo$$android_widget_RemoteViews_OnClickHandler$onClickHandler(View view, PendingIntent pendingIntent, Intent fillInIntent) {
            try {
                Context context = view.getContext();
                ActivityOptions opts = ActivityOptions.makeScaleUpAnimation(view, 0, 0, view.getMeasuredWidth(), view.getMeasuredHeight());
                context.startIntentSender(pendingIntent.getIntentSender(), fillInIntent, 0x10000000, 0x10000000, 0, opts.toBundle());
            }
            catch (IntentSender.SendIntentException e) {
                Log.e("RemoteViews", "Cannot send pending intent: ", e);
                return false;
            }
            catch (Exception e) {
                Log.e("RemoteViews", "Cannot send pending intent due to unknown exception: ", e);
                return false;
            }
            return true;
        }

        private void __constructor__() {
            this.$$robo$$android_widget_RemoteViews_OnClickHandler$__constructor__();
        }

        public OnClickHandler() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_RemoteViews_OnClickHandler$__constructor__(), 0, this);
        }

        public boolean onClickHandler(View view, PendingIntent pendingIntent, Intent intent) {
            return (boolean)InvokeDynamicSupport.bootstrap("onClickHandler", $$robo$$android_widget_RemoteViews_OnClickHandler$onClickHandler(android.view.View android.app.PendingIntent android.content.Intent ), 0, this, view, pendingIntent, intent);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (OnClickHandler)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class ActionException
    extends RuntimeException
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;

        private void $$robo$$android_widget_RemoteViews_ActionException$__constructor__(Exception ex) {
        }

        private void $$robo$$android_widget_RemoteViews_ActionException$__constructor__(String message) {
        }

        private void __constructor__(Exception exception) {
            this.$$robo$$android_widget_RemoteViews_ActionException$__constructor__(exception);
        }

        public ActionException(Exception exception) {
            super(exception);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_RemoteViews_ActionException$__constructor__(java.lang.Exception ), 0, this, exception);
        }

        private void __constructor__(String string2) {
            this.$$robo$$android_widget_RemoteViews_ActionException$__constructor__(string2);
        }

        public ActionException(String string2) {
            super(string2);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_RemoteViews_ActionException$__constructor__(java.lang.String ), 0, this, string2);
        }

        public /* synthetic */ ActionException() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ActionException)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @Target(value={ElementType.TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface RemoteView {
    }

    public static class MutablePair<F, S> {
        public transient /* synthetic */ Object __robo_data__;
        F first;
        S second;

        private void $$robo$$android_widget_RemoteViews_MutablePair$__constructor__(F first, S second) {
            this.first = first;
            this.second = second;
        }

        private final boolean $$robo$$android_widget_RemoteViews_MutablePair$equals(Object o) {
            if (!(o instanceof MutablePair)) {
                return false;
            }
            MutablePair p = (MutablePair)o;
            return Objects.equal(p.first, this.first) && Objects.equal(p.second, this.second);
        }

        private final int $$robo$$android_widget_RemoteViews_MutablePair$hashCode() {
            return (this.first == null ? 0 : this.first.hashCode()) ^ (this.second == null ? 0 : this.second.hashCode());
        }

        private void __constructor__(F f, S s) {
            this.$$robo$$android_widget_RemoteViews_MutablePair$__constructor__(f, s);
        }

        MutablePair(F f, S s) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_RemoteViews_MutablePair$__constructor__(F S ), 0, this, f, s);
        }

        public boolean equals(Object object) {
            return (boolean)InvokeDynamicSupport.bootstrap("equals", $$robo$$android_widget_RemoteViews_MutablePair$equals(java.lang.Object ), 0, this, object);
        }

        public int hashCode() {
            return (int)InvokeDynamicSupport.bootstrap("hashCode", $$robo$$android_widget_RemoteViews_MutablePair$hashCode(), 0, this);
        }

        public /* synthetic */ MutablePair() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (MutablePair)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

