/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.content.Context;
import android.util.FloatMath;
import android.view.ViewConfiguration;
import android.view.animation.AnimationUtils;
import android.view.animation.Interpolator;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class Scroller
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private Interpolator mInterpolator;
    private int mMode;
    private int mStartX;
    private int mStartY;
    private int mFinalX;
    private int mFinalY;
    private int mMinX;
    private int mMaxX;
    private int mMinY;
    private int mMaxY;
    private int mCurrX;
    private int mCurrY;
    private long mStartTime;
    private int mDuration;
    private float mDurationReciprocal;
    private float mDeltaX;
    private float mDeltaY;
    private boolean mFinished;
    private boolean mFlywheel;
    private float mVelocity;
    private float mCurrVelocity;
    private int mDistance;
    private float mFlingFriction;
    private static int DEFAULT_DURATION = 250;
    private static int SCROLL_MODE = 0;
    private static int FLING_MODE = 1;
    private static float DECELERATION_RATE;
    private static float INFLEXION = 0.35f;
    private static float START_TENSION = 0.5f;
    private static float END_TENSION = 1.0f;
    private static float P1 = 0.175f;
    private static float P2 = 0.35000002f;
    private static int NB_SAMPLES = 100;
    private static float[] SPLINE_POSITION;
    private static float[] SPLINE_TIME;
    private float mDeceleration;
    private float mPpi;
    private float mPhysicalCoeff;

    private void $$robo$$android_widget_Scroller$__constructor__(Context context) {
    }

    private void $$robo$$android_widget_Scroller$__constructor__(Context context, Interpolator interpolator2) {
    }

    private void $$robo$$android_widget_Scroller$__constructor__(Context context, Interpolator interpolator2, boolean flywheel) {
        this.mFlingFriction = ViewConfiguration.getScrollFriction();
        this.mFinished = true;
        this.mInterpolator = interpolator2 == null ? new ViscousFluidInterpolator() : interpolator2;
        this.mPpi = context.getResources().getDisplayMetrics().density * 160.0f;
        this.mDeceleration = this.computeDeceleration(ViewConfiguration.getScrollFriction());
        this.mFlywheel = flywheel;
        this.mPhysicalCoeff = this.computeDeceleration(0.84f);
    }

    private final void $$robo$$android_widget_Scroller$setFriction(float friction) {
        this.mDeceleration = this.computeDeceleration(friction);
        this.mFlingFriction = friction;
    }

    private final float $$robo$$android_widget_Scroller$computeDeceleration(float friction) {
        return 386.0878f * this.mPpi * friction;
    }

    private final boolean $$robo$$android_widget_Scroller$isFinished() {
        return this.mFinished;
    }

    private final void $$robo$$android_widget_Scroller$forceFinished(boolean finished) {
        this.mFinished = finished;
    }

    private final int $$robo$$android_widget_Scroller$getDuration() {
        return this.mDuration;
    }

    private final int $$robo$$android_widget_Scroller$getCurrX() {
        return this.mCurrX;
    }

    private final int $$robo$$android_widget_Scroller$getCurrY() {
        return this.mCurrY;
    }

    private final float $$robo$$android_widget_Scroller$getCurrVelocity() {
        return this.mMode == 1 ? this.mCurrVelocity : this.mVelocity - this.mDeceleration * (float)this.timePassed() / 2000.0f;
    }

    private final int $$robo$$android_widget_Scroller$getStartX() {
        return this.mStartX;
    }

    private final int $$robo$$android_widget_Scroller$getStartY() {
        return this.mStartY;
    }

    private final int $$robo$$android_widget_Scroller$getFinalX() {
        return this.mFinalX;
    }

    private final int $$robo$$android_widget_Scroller$getFinalY() {
        return this.mFinalY;
    }

    private final boolean $$robo$$android_widget_Scroller$computeScrollOffset() {
        if (this.mFinished) {
            return false;
        }
        int timePassed = (int)(AnimationUtils.currentAnimationTimeMillis() - this.mStartTime);
        if (timePassed < this.mDuration) {
            switch (this.mMode) {
                case 0: {
                    float x = this.mInterpolator.getInterpolation((float)timePassed * this.mDurationReciprocal);
                    this.mCurrX = this.mStartX + Math.round(x * this.mDeltaX);
                    this.mCurrY = this.mStartY + Math.round(x * this.mDeltaY);
                    break;
                }
                case 1: {
                    float t = (float)timePassed / (float)this.mDuration;
                    int index = (int)(100.0f * t);
                    float distanceCoef = 1.0f;
                    float velocityCoef = 0.0f;
                    if (index < 100) {
                        float t_inf = (float)index / 100.0f;
                        float t_sup = (float)(index + 1) / 100.0f;
                        float d_inf = SPLINE_POSITION[index];
                        float d_sup = SPLINE_POSITION[index + 1];
                        velocityCoef = (d_sup - d_inf) / (t_sup - t_inf);
                        distanceCoef = d_inf + (t - t_inf) * velocityCoef;
                    }
                    this.mCurrVelocity = velocityCoef * (float)this.mDistance / (float)this.mDuration * 1000.0f;
                    this.mCurrX = this.mStartX + Math.round(distanceCoef * (float)(this.mFinalX - this.mStartX));
                    this.mCurrX = Math.min(this.mCurrX, this.mMaxX);
                    this.mCurrX = Math.max(this.mCurrX, this.mMinX);
                    this.mCurrY = this.mStartY + Math.round(distanceCoef * (float)(this.mFinalY - this.mStartY));
                    this.mCurrY = Math.min(this.mCurrY, this.mMaxY);
                    this.mCurrY = Math.max(this.mCurrY, this.mMinY);
                    if (this.mCurrX != this.mFinalX || this.mCurrY != this.mFinalY) break;
                    this.mFinished = true;
                }
            }
        } else {
            this.mCurrX = this.mFinalX;
            this.mCurrY = this.mFinalY;
            this.mFinished = true;
        }
        return true;
    }

    private final void $$robo$$android_widget_Scroller$startScroll(int startX, int startY, int dx, int dy) {
        this.startScroll(startX, startY, dx, dy, 250);
    }

    private final void $$robo$$android_widget_Scroller$startScroll(int startX, int startY, int dx, int dy, int duration) {
        this.mMode = 0;
        this.mFinished = false;
        this.mDuration = duration;
        this.mStartTime = AnimationUtils.currentAnimationTimeMillis();
        this.mStartX = startX;
        this.mStartY = startY;
        this.mFinalX = startX + dx;
        this.mFinalY = startY + dy;
        this.mDeltaX = dx;
        this.mDeltaY = dy;
        this.mDurationReciprocal = 1.0f / (float)this.mDuration;
    }

    private final void $$robo$$android_widget_Scroller$fling(int startX, int startY, int velocityX, int velocityY, int minX, int maxX, int minY, int maxY) {
        float velocity;
        if (this.mFlywheel && !this.mFinished) {
            float oldVel = this.getCurrVelocity();
            float dx = this.mFinalX - this.mStartX;
            float dy = this.mFinalY - this.mStartY;
            float hyp = FloatMath.sqrt(dx * dx + dy * dy);
            float ndx = dx / hyp;
            float ndy = dy / hyp;
            float oldVelocityX = ndx * oldVel;
            float oldVelocityY = ndy * oldVel;
            if (Math.signum(velocityX) == Math.signum(oldVelocityX) && Math.signum(velocityY) == Math.signum(oldVelocityY)) {
                velocityX = (int)((float)velocityX + oldVelocityX);
                velocityY = (int)((float)velocityY + oldVelocityY);
            }
        }
        this.mMode = 1;
        this.mFinished = false;
        this.mVelocity = velocity = FloatMath.sqrt(velocityX * velocityX + velocityY * velocityY);
        this.mDuration = this.getSplineFlingDuration(velocity);
        this.mStartTime = AnimationUtils.currentAnimationTimeMillis();
        this.mStartX = startX;
        this.mStartY = startY;
        float coeffX = velocity == 0.0f ? 1.0f : (float)velocityX / velocity;
        float coeffY = velocity == 0.0f ? 1.0f : (float)velocityY / velocity;
        double totalDistance = this.getSplineFlingDistance(velocity);
        this.mDistance = (int)(totalDistance * (double)Math.signum(velocity));
        this.mMinX = minX;
        this.mMaxX = maxX;
        this.mMinY = minY;
        this.mMaxY = maxY;
        this.mFinalX = startX + (int)Math.round(totalDistance * (double)coeffX);
        this.mFinalX = Math.min(this.mFinalX, this.mMaxX);
        this.mFinalX = Math.max(this.mFinalX, this.mMinX);
        this.mFinalY = startY + (int)Math.round(totalDistance * (double)coeffY);
        this.mFinalY = Math.min(this.mFinalY, this.mMaxY);
        this.mFinalY = Math.max(this.mFinalY, this.mMinY);
    }

    private final double $$robo$$android_widget_Scroller$getSplineDeceleration(float velocity) {
        return Math.log(0.35f * Math.abs(velocity) / (this.mFlingFriction * this.mPhysicalCoeff));
    }

    private final int $$robo$$android_widget_Scroller$getSplineFlingDuration(float velocity) {
        double l = this.getSplineDeceleration(velocity);
        double decelMinusOne = (double)DECELERATION_RATE - 1.0;
        return (int)(1000.0 * Math.exp(l / decelMinusOne));
    }

    private final double $$robo$$android_widget_Scroller$getSplineFlingDistance(float velocity) {
        double l = this.getSplineDeceleration(velocity);
        double decelMinusOne = (double)DECELERATION_RATE - 1.0;
        return (double)(this.mFlingFriction * this.mPhysicalCoeff) * Math.exp((double)DECELERATION_RATE / decelMinusOne * l);
    }

    private final void $$robo$$android_widget_Scroller$abortAnimation() {
        this.mCurrX = this.mFinalX;
        this.mCurrY = this.mFinalY;
        this.mFinished = true;
    }

    private final void $$robo$$android_widget_Scroller$extendDuration(int extend) {
        int passed = this.timePassed();
        this.mDuration = passed + extend;
        this.mDurationReciprocal = 1.0f / (float)this.mDuration;
        this.mFinished = false;
    }

    private final int $$robo$$android_widget_Scroller$timePassed() {
        return (int)(AnimationUtils.currentAnimationTimeMillis() - this.mStartTime);
    }

    private final void $$robo$$android_widget_Scroller$setFinalX(int newX) {
        this.mFinalX = newX;
        this.mDeltaX = this.mFinalX - this.mStartX;
        this.mFinished = false;
    }

    private final void $$robo$$android_widget_Scroller$setFinalY(int newY) {
        this.mFinalY = newY;
        this.mDeltaY = this.mFinalY - this.mStartY;
        this.mFinished = false;
    }

    private final boolean $$robo$$android_widget_Scroller$isScrollingInDirection(float xvel, float yvel) {
        return !this.mFinished && Math.signum(xvel) == Math.signum(this.mFinalX - this.mStartX) && Math.signum(yvel) == Math.signum(this.mFinalY - this.mStartY);
    }

    static void __staticInitializer__() {
        DECELERATION_RATE = (float)(Math.log(0.78) / Math.log(0.9));
        SPLINE_POSITION = new float[101];
        SPLINE_TIME = new float[101];
        float x_min = 0.0f;
        float y_min = 0.0f;
        for (int i = 0; i < 100; ++i) {
            float y;
            float dy;
            float x;
            float coef;
            float tx;
            float alpha = (float)i / 100.0f;
            float x_max = 1.0f;
            while (!((double)Math.abs((tx = (coef = 3.0f * (x = x_min + (x_max - x_min) / 2.0f) * (1.0f - x)) * ((1.0f - x) * 0.175f + x * 0.35000002f) + x * x * x) - alpha) < 1.0E-5)) {
                if (tx > alpha) {
                    x_max = x;
                    continue;
                }
                x_min = x;
            }
            Scroller.SPLINE_POSITION[i] = coef * ((1.0f - x) * 0.5f + x) + x * x * x;
            float y_max = 1.0f;
            while (!((double)Math.abs((dy = (coef = 3.0f * (y = y_min + (y_max - y_min) / 2.0f) * (1.0f - y)) * ((1.0f - y) * 0.5f + y) + y * y * y) - alpha) < 1.0E-5)) {
                if (dy > alpha) {
                    y_max = y;
                    continue;
                }
                y_min = y;
            }
            Scroller.SPLINE_TIME[i] = coef * ((1.0f - y) * 0.175f + y * 0.35000002f) + y * y * y;
        }
        Scroller.SPLINE_TIME[100] = 1.0f;
        Scroller.SPLINE_POSITION[100] = 1.0f;
    }

    private void __constructor__(Context context) {
        this.$$robo$$android_widget_Scroller$__constructor__(context);
    }

    public Scroller(Context context) {
        this(context, null);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_Scroller$__constructor__(android.content.Context ), 0, this, context);
    }

    private void __constructor__(Context context, Interpolator interpolator2) {
        this.$$robo$$android_widget_Scroller$__constructor__(context, interpolator2);
    }

    public Scroller(Context context, Interpolator interpolator2) {
        this(context, interpolator2, context.getApplicationInfo().targetSdkVersion >= 11);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_Scroller$__constructor__(android.content.Context android.view.animation.Interpolator ), 0, this, context, interpolator2);
    }

    private void __constructor__(Context context, Interpolator interpolator2, boolean bl) {
        this.$$robo$$android_widget_Scroller$__constructor__(context, interpolator2, bl);
    }

    public Scroller(Context context, Interpolator interpolator2, boolean bl) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_Scroller$__constructor__(android.content.Context android.view.animation.Interpolator boolean ), 0, this, context, interpolator2, bl);
    }

    public void setFriction(float f) {
        InvokeDynamicSupport.bootstrap("setFriction", $$robo$$android_widget_Scroller$setFriction(float ), 0, this, f);
    }

    private float computeDeceleration(float f) {
        return (float)InvokeDynamicSupport.bootstrap("computeDeceleration", $$robo$$android_widget_Scroller$computeDeceleration(float ), 0, this, f);
    }

    public boolean isFinished() {
        return (boolean)InvokeDynamicSupport.bootstrap("isFinished", $$robo$$android_widget_Scroller$isFinished(), 0, this);
    }

    public void forceFinished(boolean bl) {
        InvokeDynamicSupport.bootstrap("forceFinished", $$robo$$android_widget_Scroller$forceFinished(boolean ), 0, this, bl);
    }

    public int getDuration() {
        return (int)InvokeDynamicSupport.bootstrap("getDuration", $$robo$$android_widget_Scroller$getDuration(), 0, this);
    }

    public int getCurrX() {
        return (int)InvokeDynamicSupport.bootstrap("getCurrX", $$robo$$android_widget_Scroller$getCurrX(), 0, this);
    }

    public int getCurrY() {
        return (int)InvokeDynamicSupport.bootstrap("getCurrY", $$robo$$android_widget_Scroller$getCurrY(), 0, this);
    }

    public float getCurrVelocity() {
        return (float)InvokeDynamicSupport.bootstrap("getCurrVelocity", $$robo$$android_widget_Scroller$getCurrVelocity(), 0, this);
    }

    public int getStartX() {
        return (int)InvokeDynamicSupport.bootstrap("getStartX", $$robo$$android_widget_Scroller$getStartX(), 0, this);
    }

    public int getStartY() {
        return (int)InvokeDynamicSupport.bootstrap("getStartY", $$robo$$android_widget_Scroller$getStartY(), 0, this);
    }

    public int getFinalX() {
        return (int)InvokeDynamicSupport.bootstrap("getFinalX", $$robo$$android_widget_Scroller$getFinalX(), 0, this);
    }

    public int getFinalY() {
        return (int)InvokeDynamicSupport.bootstrap("getFinalY", $$robo$$android_widget_Scroller$getFinalY(), 0, this);
    }

    public boolean computeScrollOffset() {
        return (boolean)InvokeDynamicSupport.bootstrap("computeScrollOffset", $$robo$$android_widget_Scroller$computeScrollOffset(), 0, this);
    }

    public void startScroll(int n, int n2, int n3, int n4) {
        InvokeDynamicSupport.bootstrap("startScroll", $$robo$$android_widget_Scroller$startScroll(int int int int ), 0, this, n, n2, n3, n4);
    }

    public void startScroll(int n, int n2, int n3, int n4, int n5) {
        InvokeDynamicSupport.bootstrap("startScroll", $$robo$$android_widget_Scroller$startScroll(int int int int int ), 0, this, n, n2, n3, n4, n5);
    }

    public void fling(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        InvokeDynamicSupport.bootstrap("fling", $$robo$$android_widget_Scroller$fling(int int int int int int int int ), 0, this, n, n2, n3, n4, n5, n6, n7, n8);
    }

    private double getSplineDeceleration(float f) {
        return (double)InvokeDynamicSupport.bootstrap("getSplineDeceleration", $$robo$$android_widget_Scroller$getSplineDeceleration(float ), 0, this, f);
    }

    private int getSplineFlingDuration(float f) {
        return (int)InvokeDynamicSupport.bootstrap("getSplineFlingDuration", $$robo$$android_widget_Scroller$getSplineFlingDuration(float ), 0, this, f);
    }

    private double getSplineFlingDistance(float f) {
        return (double)InvokeDynamicSupport.bootstrap("getSplineFlingDistance", $$robo$$android_widget_Scroller$getSplineFlingDistance(float ), 0, this, f);
    }

    public void abortAnimation() {
        InvokeDynamicSupport.bootstrap("abortAnimation", $$robo$$android_widget_Scroller$abortAnimation(), 0, this);
    }

    public void extendDuration(int n) {
        InvokeDynamicSupport.bootstrap("extendDuration", $$robo$$android_widget_Scroller$extendDuration(int ), 0, this, n);
    }

    public int timePassed() {
        return (int)InvokeDynamicSupport.bootstrap("timePassed", $$robo$$android_widget_Scroller$timePassed(), 0, this);
    }

    public void setFinalX(int n) {
        InvokeDynamicSupport.bootstrap("setFinalX", $$robo$$android_widget_Scroller$setFinalX(int ), 0, this, n);
    }

    public void setFinalY(int n) {
        InvokeDynamicSupport.bootstrap("setFinalY", $$robo$$android_widget_Scroller$setFinalY(int ), 0, this, n);
    }

    public boolean isScrollingInDirection(float f, float f2) {
        return (boolean)InvokeDynamicSupport.bootstrap("isScrollingInDirection", $$robo$$android_widget_Scroller$isScrollingInDirection(float float ), 0, this, f, f2);
    }

    static {
        RobolectricInternals.classInitializing(Scroller.class);
    }

    public /* synthetic */ Scroller() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Scroller)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static class ViscousFluidInterpolator
    implements Interpolator,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private static float VISCOUS_FLUID_SCALE = 8.0f;
        private static float VISCOUS_FLUID_NORMALIZE;
        private static float VISCOUS_FLUID_OFFSET;

        private void $$robo$$android_widget_Scroller_ViscousFluidInterpolator$__constructor__() {
        }

        private static final float $$robo$$android_widget_Scroller_ViscousFluidInterpolator$viscousFluid(float x) {
            if ((x *= 8.0f) < 1.0f) {
                x -= 1.0f - (float)Math.exp(-x);
            } else {
                float start = 0.36787945f;
                x = 1.0f - (float)Math.exp(1.0f - x);
                x = start + x * (1.0f - start);
            }
            return x;
        }

        private final float $$robo$$android_widget_Scroller_ViscousFluidInterpolator$getInterpolation(float input) {
            float interpolated = VISCOUS_FLUID_NORMALIZE * ViscousFluidInterpolator.viscousFluid(input);
            if (interpolated > 0.0f) {
                return interpolated + VISCOUS_FLUID_OFFSET;
            }
            return interpolated;
        }

        static void __staticInitializer__() {
            VISCOUS_FLUID_NORMALIZE = 1.0f / ViscousFluidInterpolator.viscousFluid(1.0f);
            VISCOUS_FLUID_OFFSET = 1.0f - VISCOUS_FLUID_NORMALIZE * ViscousFluidInterpolator.viscousFluid(1.0f);
        }

        private void __constructor__() {
            this.$$robo$$android_widget_Scroller_ViscousFluidInterpolator$__constructor__();
        }

        ViscousFluidInterpolator() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_Scroller_ViscousFluidInterpolator$__constructor__(), 0, this);
        }

        private static float viscousFluid(float f) {
            return (float)InvokeDynamicSupport.bootstrapStatic("viscousFluid", $$robo$$android_widget_Scroller_ViscousFluidInterpolator$viscousFluid(float ), 0, (float)f);
        }

        @Override
        public float getInterpolation(float f) {
            return (float)InvokeDynamicSupport.bootstrap("getInterpolation", $$robo$$android_widget_Scroller_ViscousFluidInterpolator$getInterpolation(float ), 0, this, f);
        }

        static {
            RobolectricInternals.classInitializing(ViscousFluidInterpolator.class);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ViscousFluidInterpolator)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

