/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.content.Context;
import android.content.res.ColorStateList;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AbsListView;
import android.widget.BaseAdapter;
import android.widget.DatePickerController;
import android.widget.SimpleMonthView;
import java.util.Calendar;
import java.util.HashMap;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class SimpleMonthAdapter
extends BaseAdapter
implements SimpleMonthView.OnDayClickListener,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "SimpleMonthAdapter";
    private Context mContext;
    private DatePickerController mController;
    private Calendar mSelectedDay;
    private ColorStateList mCalendarTextColors;

    private void $$robo$$android_widget_SimpleMonthAdapter$__constructor__(Context context, DatePickerController controller) {
        this.mContext = context;
        this.mController = controller;
        this.init();
        this.setSelectedDay(this.mController.getSelectedDay());
    }

    private final void $$robo$$android_widget_SimpleMonthAdapter$setSelectedDay(Calendar day) {
        if (this.mSelectedDay != day) {
            this.mSelectedDay = day;
            this.notifyDataSetChanged();
        }
    }

    private final void $$robo$$android_widget_SimpleMonthAdapter$setCalendarTextColor(ColorStateList colors) {
        this.mCalendarTextColors = colors;
    }

    private final void $$robo$$android_widget_SimpleMonthAdapter$init() {
        this.mSelectedDay = Calendar.getInstance();
    }

    private final int $$robo$$android_widget_SimpleMonthAdapter$getCount() {
        int diffYear = this.mController.getMaxYear() - this.mController.getMinYear();
        int diffMonth = 1 + this.mController.getMaxMonth() - this.mController.getMinMonth() + 12 * diffYear;
        return diffMonth;
    }

    private final Object $$robo$$android_widget_SimpleMonthAdapter$getItem(int position) {
        return null;
    }

    private final long $$robo$$android_widget_SimpleMonthAdapter$getItemId(int position) {
        return position;
    }

    private final boolean $$robo$$android_widget_SimpleMonthAdapter$hasStableIds() {
        return true;
    }

    private final View $$robo$$android_widget_SimpleMonthAdapter$getView(int position, View convertView, ViewGroup parent) {
        SimpleMonthView v;
        HashMap drawingParams = null;
        if (convertView != null) {
            v = (SimpleMonthView)convertView;
            drawingParams = (HashMap)v.getTag();
        } else {
            v = new SimpleMonthView(this.mContext);
            AbsListView.LayoutParams params = new AbsListView.LayoutParams(-1, -1);
            v.setLayoutParams(params);
            v.setClickable(true);
            v.setOnDayClickListener(this);
            if (this.mCalendarTextColors != null) {
                v.setTextColor(this.mCalendarTextColors);
            }
        }
        if (drawingParams == null) {
            drawingParams = new HashMap();
        } else {
            drawingParams.clear();
        }
        int currentMonth = position + this.mController.getMinMonth();
        int month = currentMonth % 12;
        int year = currentMonth / 12 + this.mController.getMinYear();
        int selectedDay = -1;
        if (this.isSelectedDayInMonth(year, month)) {
            selectedDay = this.mSelectedDay.get(5);
        }
        v.reuse();
        int enabledDayRangeStart = this.mController.getMinMonth() == month && this.mController.getMinYear() == year ? this.mController.getMinDay() : 1;
        int enabledDayRangeEnd = this.mController.getMaxMonth() == month && this.mController.getMaxYear() == year ? this.mController.getMaxDay() : 31;
        v.setMonthParams(selectedDay, month, year, this.mController.getFirstDayOfWeek(), enabledDayRangeStart, enabledDayRangeEnd);
        v.invalidate();
        return v;
    }

    private final boolean $$robo$$android_widget_SimpleMonthAdapter$isSelectedDayInMonth(int year, int month) {
        return this.mSelectedDay.get(1) == year && this.mSelectedDay.get(2) == month;
    }

    private final void $$robo$$android_widget_SimpleMonthAdapter$onDayClick(SimpleMonthView view, Calendar day) {
        if (day != null) {
            this.onDayTapped(day);
        }
    }

    private final void $$robo$$android_widget_SimpleMonthAdapter$onDayTapped(Calendar day) {
        this.mController.tryVibrate();
        this.mController.onDayOfMonthSelected(day.get(1), day.get(2), day.get(5));
        this.setSelectedDay(day);
    }

    private void __constructor__(Context context, DatePickerController datePickerController) {
        this.$$robo$$android_widget_SimpleMonthAdapter$__constructor__(context, datePickerController);
    }

    public SimpleMonthAdapter(Context context, DatePickerController datePickerController) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_SimpleMonthAdapter$__constructor__(android.content.Context android.widget.DatePickerController ), 0, this, context, datePickerController);
    }

    public void setSelectedDay(Calendar calendar) {
        InvokeDynamicSupport.bootstrap("setSelectedDay", $$robo$$android_widget_SimpleMonthAdapter$setSelectedDay(java.util.Calendar ), 0, this, calendar);
    }

    void setCalendarTextColor(ColorStateList colorStateList) {
        InvokeDynamicSupport.bootstrap("setCalendarTextColor", $$robo$$android_widget_SimpleMonthAdapter$setCalendarTextColor(android.content.res.ColorStateList ), 0, this, colorStateList);
    }

    protected void init() {
        InvokeDynamicSupport.bootstrap("init", $$robo$$android_widget_SimpleMonthAdapter$init(), 0, this);
    }

    @Override
    public int getCount() {
        return (int)InvokeDynamicSupport.bootstrap("getCount", $$robo$$android_widget_SimpleMonthAdapter$getCount(), 0, this);
    }

    @Override
    public Object getItem(int n) {
        return InvokeDynamicSupport.bootstrap("getItem", $$robo$$android_widget_SimpleMonthAdapter$getItem(int ), 0, this, n);
    }

    @Override
    public long getItemId(int n) {
        return (long)InvokeDynamicSupport.bootstrap("getItemId", $$robo$$android_widget_SimpleMonthAdapter$getItemId(int ), 0, this, n);
    }

    @Override
    public boolean hasStableIds() {
        return (boolean)InvokeDynamicSupport.bootstrap("hasStableIds", $$robo$$android_widget_SimpleMonthAdapter$hasStableIds(), 0, this);
    }

    @Override
    public View getView(int n, View view, ViewGroup viewGroup) {
        return InvokeDynamicSupport.bootstrap("getView", $$robo$$android_widget_SimpleMonthAdapter$getView(int android.view.View android.view.ViewGroup ), 0, this, n, view, viewGroup);
    }

    private boolean isSelectedDayInMonth(int n, int n2) {
        return (boolean)InvokeDynamicSupport.bootstrap("isSelectedDayInMonth", $$robo$$android_widget_SimpleMonthAdapter$isSelectedDayInMonth(int int ), 0, this, n, n2);
    }

    @Override
    public void onDayClick(SimpleMonthView simpleMonthView, Calendar calendar) {
        InvokeDynamicSupport.bootstrap("onDayClick", $$robo$$android_widget_SimpleMonthAdapter$onDayClick(android.widget.SimpleMonthView java.util.Calendar ), 0, this, simpleMonthView, calendar);
    }

    protected void onDayTapped(Calendar calendar) {
        InvokeDynamicSupport.bootstrap("onDayTapped", $$robo$$android_widget_SimpleMonthAdapter$onDayTapped(java.util.Calendar ), 0, this, calendar);
    }

    public /* synthetic */ SimpleMonthAdapter() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SimpleMonthAdapter)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

