/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.Typeface;
import android.os.Bundle;
import android.text.format.DateFormat;
import android.text.format.DateUtils;
import android.text.format.Time;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityNodeInfo;
import com.android.internal.widget.ExploreByTouchHelper;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Formatter;
import java.util.List;
import java.util.Locale;
import org.robolectric.internal.bytecode.InstrumentedInterface;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class SimpleMonthView
extends View
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "SimpleMonthView";
    private static int DEFAULT_HEIGHT = 32;
    private static int MIN_HEIGHT = 10;
    private static int DEFAULT_SELECTED_DAY = -1;
    private static int DEFAULT_WEEK_START = 1;
    private static int DEFAULT_NUM_DAYS = 7;
    private static int DEFAULT_NUM_ROWS = 6;
    private static int MAX_NUM_ROWS = 6;
    private static int SELECTED_CIRCLE_ALPHA = 60;
    private static int DAY_SEPARATOR_WIDTH = 1;
    private int mMiniDayNumberTextSize;
    private int mMonthLabelTextSize;
    private int mMonthDayLabelTextSize;
    private int mMonthHeaderSize;
    private int mDaySelectedCircleSize;
    private static float mScale;
    private SimpleDateFormat mDayFormatter;
    private int mPadding;
    private String mDayOfWeekTypeface;
    private String mMonthTitleTypeface;
    private Paint mDayNumberPaint;
    private Paint mDayNumberDisabledPaint;
    private Paint mDayNumberSelectedPaint;
    private Paint mMonthTitlePaint;
    private Paint mMonthDayLabelPaint;
    private Formatter mFormatter;
    private StringBuilder mStringBuilder;
    private int mMonth;
    private int mYear;
    private int mWidth;
    private int mRowHeight;
    private boolean mHasToday;
    private int mSelectedDay;
    private int mToday;
    private int mWeekStart;
    private int mNumDays;
    private int mNumCells;
    private int mDayOfWeekStart;
    private int mEnabledDayStart;
    private int mEnabledDayEnd;
    private Calendar mCalendar;
    private Calendar mDayLabelCalendar;
    private MonthViewTouchHelper mTouchHelper;
    private int mNumRows;
    private OnDayClickListener mOnDayClickListener;
    private boolean mLockAccessibilityDelegate;
    private int mNormalTextColor;
    private int mDisabledTextColor;
    private int mSelectedDayColor;

    private void $$robo$$android_widget_SimpleMonthView$__constructor__(Context context) {
    }

    private void $$robo$$android_widget_SimpleMonthView$__constructor__(Context context, AttributeSet attrs) {
    }

    private void $$robo$$android_widget_SimpleMonthView$__constructor__(Context context, AttributeSet attrs, int defStyle) {
        this.mDayFormatter = new SimpleDateFormat("EEEEE", Locale.getDefault());
        this.mPadding = 0;
        this.mRowHeight = 32;
        this.mHasToday = false;
        this.mSelectedDay = -1;
        this.mToday = -1;
        this.mWeekStart = 1;
        this.mNumCells = this.mNumDays = 7;
        this.mDayOfWeekStart = 0;
        this.mEnabledDayStart = 1;
        this.mEnabledDayEnd = 31;
        this.mCalendar = Calendar.getInstance();
        this.mDayLabelCalendar = Calendar.getInstance();
        this.mNumRows = 6;
        Resources res = context.getResources();
        this.mDayOfWeekTypeface = res.getString(17041009);
        this.mMonthTitleTypeface = res.getString(17041008);
        this.mStringBuilder = new StringBuilder(50);
        this.mFormatter = new Formatter(this.mStringBuilder, Locale.getDefault());
        this.mMiniDayNumberTextSize = res.getDimensionPixelSize(17105031);
        this.mMonthLabelTextSize = res.getDimensionPixelSize(17105032);
        this.mMonthDayLabelTextSize = res.getDimensionPixelSize(17105033);
        this.mMonthHeaderSize = res.getDimensionPixelOffset(17105034);
        this.mDaySelectedCircleSize = res.getDimensionPixelSize(17105035);
        this.mRowHeight = (res.getDimensionPixelOffset(17105036) - this.mMonthHeaderSize) / 6;
        this.mTouchHelper = new MonthViewTouchHelper(this, this);
        this.setAccessibilityDelegate(this.mTouchHelper);
        this.setImportantForAccessibility(1);
        this.mLockAccessibilityDelegate = true;
        this.initView();
    }

    private final void $$robo$$android_widget_SimpleMonthView$onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        this.mDayFormatter = new SimpleDateFormat("EEEEE", newConfig.locale);
    }

    private final void $$robo$$android_widget_SimpleMonthView$setTextColor(ColorStateList colors) {
        Resources res = this.getContext().getResources();
        this.mNormalTextColor = colors.getColorForState(ENABLED_STATE_SET, res.getColor(17170586));
        this.mMonthTitlePaint.setColor(this.mNormalTextColor);
        this.mMonthDayLabelPaint.setColor(this.mNormalTextColor);
        this.mDisabledTextColor = colors.getColorForState(EMPTY_STATE_SET, res.getColor(17170588));
        this.mDayNumberDisabledPaint.setColor(this.mDisabledTextColor);
        this.mSelectedDayColor = colors.getColorForState(ENABLED_SELECTED_STATE_SET, res.getColor(17170450));
        this.mDayNumberSelectedPaint.setColor(this.mSelectedDayColor);
        this.mDayNumberSelectedPaint.setAlpha(60);
    }

    private final void $$robo$$android_widget_SimpleMonthView$setAccessibilityDelegate(View.AccessibilityDelegate delegate) {
        if (!this.mLockAccessibilityDelegate) {
            super.setAccessibilityDelegate(delegate);
        }
    }

    private final void $$robo$$android_widget_SimpleMonthView$setOnDayClickListener(OnDayClickListener listener) {
        this.mOnDayClickListener = listener;
    }

    private final boolean $$robo$$android_widget_SimpleMonthView$dispatchHoverEvent(MotionEvent event) {
        if (this.mTouchHelper.dispatchHoverEvent(event)) {
            return true;
        }
        return super.dispatchHoverEvent(event);
    }

    private final boolean $$robo$$android_widget_SimpleMonthView$onTouchEvent(MotionEvent event) {
        switch (event.getAction()) {
            case 1: {
                int day = this.getDayFromLocation(event.getX(), event.getY());
                if (day < 0) break;
                this.onDayClick(day);
            }
        }
        return true;
    }

    private final void $$robo$$android_widget_SimpleMonthView$initView() {
        this.mMonthTitlePaint = new Paint();
        this.mMonthTitlePaint.setAntiAlias(true);
        this.mMonthTitlePaint.setColor(this.mNormalTextColor);
        this.mMonthTitlePaint.setTextSize(this.mMonthLabelTextSize);
        this.mMonthTitlePaint.setTypeface(Typeface.create(this.mMonthTitleTypeface, 1));
        this.mMonthTitlePaint.setTextAlign(Paint.Align.CENTER);
        this.mMonthTitlePaint.setStyle(Paint.Style.FILL);
        this.mMonthTitlePaint.setFakeBoldText(true);
        this.mMonthDayLabelPaint = new Paint();
        this.mMonthDayLabelPaint.setAntiAlias(true);
        this.mMonthDayLabelPaint.setColor(this.mNormalTextColor);
        this.mMonthDayLabelPaint.setTextSize(this.mMonthDayLabelTextSize);
        this.mMonthDayLabelPaint.setTypeface(Typeface.create(this.mDayOfWeekTypeface, 0));
        this.mMonthDayLabelPaint.setTextAlign(Paint.Align.CENTER);
        this.mMonthDayLabelPaint.setStyle(Paint.Style.FILL);
        this.mMonthDayLabelPaint.setFakeBoldText(true);
        this.mDayNumberSelectedPaint = new Paint();
        this.mDayNumberSelectedPaint.setAntiAlias(true);
        this.mDayNumberSelectedPaint.setColor(this.mSelectedDayColor);
        this.mDayNumberSelectedPaint.setAlpha(60);
        this.mDayNumberSelectedPaint.setTextAlign(Paint.Align.CENTER);
        this.mDayNumberSelectedPaint.setStyle(Paint.Style.FILL);
        this.mDayNumberSelectedPaint.setFakeBoldText(true);
        this.mDayNumberPaint = new Paint();
        this.mDayNumberPaint.setAntiAlias(true);
        this.mDayNumberPaint.setTextSize(this.mMiniDayNumberTextSize);
        this.mDayNumberPaint.setTextAlign(Paint.Align.CENTER);
        this.mDayNumberPaint.setStyle(Paint.Style.FILL);
        this.mDayNumberPaint.setFakeBoldText(false);
        this.mDayNumberDisabledPaint = new Paint();
        this.mDayNumberDisabledPaint.setAntiAlias(true);
        this.mDayNumberDisabledPaint.setColor(this.mDisabledTextColor);
        this.mDayNumberDisabledPaint.setTextSize(this.mMiniDayNumberTextSize);
        this.mDayNumberDisabledPaint.setTextAlign(Paint.Align.CENTER);
        this.mDayNumberDisabledPaint.setStyle(Paint.Style.FILL);
        this.mDayNumberDisabledPaint.setFakeBoldText(false);
    }

    private final void $$robo$$android_widget_SimpleMonthView$onDraw(Canvas canvas) {
        this.drawMonthTitle(canvas);
        this.drawWeekDayLabels(canvas);
        this.drawDays(canvas);
    }

    private static final boolean $$robo$$android_widget_SimpleMonthView$isValidDayOfWeek(int day) {
        return day >= 1 && day <= 7;
    }

    private static final boolean $$robo$$android_widget_SimpleMonthView$isValidMonth(int month) {
        return month >= 0 && month <= 11;
    }

    private final void $$robo$$android_widget_SimpleMonthView$setMonthParams(int selectedDay, int month, int year, int weekStart, int enabledDayStart, int enabledDayEnd) {
        if (this.mRowHeight < 10) {
            this.mRowHeight = 10;
        }
        this.mSelectedDay = selectedDay;
        if (SimpleMonthView.isValidMonth(month)) {
            this.mMonth = month;
        }
        this.mYear = year;
        Time today = new Time(Time.getCurrentTimezone());
        today.setToNow();
        this.mHasToday = false;
        this.mToday = -1;
        this.mCalendar.set(2, this.mMonth);
        this.mCalendar.set(1, this.mYear);
        this.mCalendar.set(5, 1);
        this.mDayOfWeekStart = this.mCalendar.get(7);
        this.mWeekStart = SimpleMonthView.isValidDayOfWeek(weekStart) ? weekStart : this.mCalendar.getFirstDayOfWeek();
        if (enabledDayStart > 0 && enabledDayEnd < 32) {
            this.mEnabledDayStart = enabledDayStart;
        }
        if (enabledDayEnd > 0 && enabledDayEnd < 32 && enabledDayEnd >= enabledDayStart) {
            this.mEnabledDayEnd = enabledDayEnd;
        }
        this.mNumCells = SimpleMonthView.getDaysInMonth(this.mMonth, this.mYear);
        for (int i = 0; i < this.mNumCells; ++i) {
            int day = i + 1;
            if (!this.sameDay(day, today)) continue;
            this.mHasToday = true;
            this.mToday = day;
        }
        this.mNumRows = this.calculateNumRows();
        this.mTouchHelper.invalidateRoot();
    }

    private static final int $$robo$$android_widget_SimpleMonthView$getDaysInMonth(int month, int year) {
        switch (month) {
            case 0: 
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 9: 
            case 11: {
                return 31;
            }
            case 3: 
            case 5: 
            case 8: 
            case 10: {
                return 30;
            }
            case 1: {
                return year % 4 == 0 ? 29 : 28;
            }
        }
        throw new IllegalArgumentException("Invalid Month");
    }

    private final void $$robo$$android_widget_SimpleMonthView$reuse() {
        this.mNumRows = 6;
        this.requestLayout();
    }

    private final int $$robo$$android_widget_SimpleMonthView$calculateNumRows() {
        int offset = this.findDayOffset();
        int dividend = (offset + this.mNumCells) / this.mNumDays;
        int remainder = (offset + this.mNumCells) % this.mNumDays;
        return dividend + (remainder > 0 ? 1 : 0);
    }

    private final boolean $$robo$$android_widget_SimpleMonthView$sameDay(int day, Time today) {
        return this.mYear == today.year && this.mMonth == today.month && day == today.monthDay;
    }

    private final void $$robo$$android_widget_SimpleMonthView$onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        this.setMeasuredDimension(View.MeasureSpec.getSize(widthMeasureSpec), this.mRowHeight * this.mNumRows + this.mMonthHeaderSize);
    }

    private final void $$robo$$android_widget_SimpleMonthView$onSizeChanged(int w, int h, int oldw, int oldh) {
        this.mWidth = w;
        this.mTouchHelper.invalidateRoot();
    }

    private final String $$robo$$android_widget_SimpleMonthView$getMonthAndYearString() {
        int flags = 52;
        this.mStringBuilder.setLength(0);
        long millis = this.mCalendar.getTimeInMillis();
        return DateUtils.formatDateRange(this.getContext(), this.mFormatter, millis, millis, flags, Time.getCurrentTimezone()).toString();
    }

    private final void $$robo$$android_widget_SimpleMonthView$drawMonthTitle(Canvas canvas) {
        float x = (float)(this.mWidth + 2 * this.mPadding) / 2.0f;
        float y = (float)(this.mMonthHeaderSize - this.mMonthDayLabelTextSize) / 2.0f;
        canvas.drawText(this.getMonthAndYearString(), x, y, this.mMonthTitlePaint);
    }

    private final void $$robo$$android_widget_SimpleMonthView$drawWeekDayLabels(Canvas canvas) {
        int y = this.mMonthHeaderSize - this.mMonthDayLabelTextSize / 2;
        int dayWidthHalf = (this.mWidth - this.mPadding * 2) / (this.mNumDays * 2);
        for (int i = 0; i < this.mNumDays; ++i) {
            int calendarDay = (i + this.mWeekStart) % this.mNumDays;
            this.mDayLabelCalendar.set(7, calendarDay);
            String dayLabel = this.mDayFormatter.format(this.mDayLabelCalendar.getTime());
            int x = (2 * i + 1) * dayWidthHalf + this.mPadding;
            canvas.drawText(dayLabel, x, y, this.mMonthDayLabelPaint);
        }
    }

    private final void $$robo$$android_widget_SimpleMonthView$drawDays(Canvas canvas) {
        int y = (this.mRowHeight + this.mMiniDayNumberTextSize) / 2 - 1 + this.mMonthHeaderSize;
        int dayWidthHalf = (this.mWidth - this.mPadding * 2) / (this.mNumDays * 2);
        int j = this.findDayOffset();
        for (int day = 1; day <= this.mNumCells; ++day) {
            int x = (2 * j + 1) * dayWidthHalf + this.mPadding;
            if (this.mSelectedDay == day) {
                canvas.drawCircle(x, y - this.mMiniDayNumberTextSize / 3, this.mDaySelectedCircleSize, this.mDayNumberSelectedPaint);
            }
            if (this.mHasToday && this.mToday == day) {
                this.mDayNumberPaint.setColor(this.mSelectedDayColor);
            } else {
                this.mDayNumberPaint.setColor(this.mNormalTextColor);
            }
            Paint paint = day < this.mEnabledDayStart || day > this.mEnabledDayEnd ? this.mDayNumberDisabledPaint : this.mDayNumberPaint;
            canvas.drawText(String.format("%d", day), x, y, paint);
            if (++j != this.mNumDays) continue;
            j = 0;
            y += this.mRowHeight;
        }
    }

    private final int $$robo$$android_widget_SimpleMonthView$findDayOffset() {
        return (this.mDayOfWeekStart < this.mWeekStart ? this.mDayOfWeekStart + this.mNumDays : this.mDayOfWeekStart) - this.mWeekStart;
    }

    private final int $$robo$$android_widget_SimpleMonthView$getDayFromLocation(float x, float y) {
        int dayStart = this.mPadding;
        if (x < (float)dayStart || x > (float)(this.mWidth - this.mPadding)) {
            return -1;
        }
        int row = (int)(y - (float)this.mMonthHeaderSize) / this.mRowHeight;
        int column = (int)((x - (float)dayStart) * (float)this.mNumDays / (float)(this.mWidth - dayStart - this.mPadding));
        int day = column - this.findDayOffset() + 1;
        if ((day += row * this.mNumDays) < 1 || day > this.mNumCells) {
            return -1;
        }
        return day;
    }

    private final void $$robo$$android_widget_SimpleMonthView$onDayClick(int day) {
        if (this.mOnDayClickListener != null) {
            Calendar date = Calendar.getInstance();
            date.set(this.mYear, this.mMonth, day);
            this.mOnDayClickListener.onDayClick(this, date);
        }
        this.mTouchHelper.sendEventForVirtualView(day, 1);
    }

    private final Calendar $$robo$$android_widget_SimpleMonthView$getAccessibilityFocus() {
        int day = this.mTouchHelper.getFocusedVirtualView();
        Calendar date = null;
        if (day >= 0) {
            date = Calendar.getInstance();
            date.set(this.mYear, this.mMonth, day);
        }
        return date;
    }

    private final void $$robo$$android_widget_SimpleMonthView$clearAccessibilityFocus() {
        this.mTouchHelper.clearFocusedVirtualView();
    }

    private final boolean $$robo$$android_widget_SimpleMonthView$restoreAccessibilityFocus(Calendar day) {
        if (day.get(1) != this.mYear || day.get(2) != this.mMonth || day.get(5) > this.mNumCells) {
            return false;
        }
        this.mTouchHelper.setFocusedVirtualView(day.get(5));
        return true;
    }

    static void __staticInitializer__() {
        mScale = 0.0f;
    }

    private void __constructor__(Context context) {
        this.$$robo$$android_widget_SimpleMonthView$__constructor__(context);
    }

    public SimpleMonthView(Context context) {
        this(context, null);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_SimpleMonthView$__constructor__(android.content.Context ), 0, this, context);
    }

    private void __constructor__(Context context, AttributeSet attributeSet) {
        this.$$robo$$android_widget_SimpleMonthView$__constructor__(context, attributeSet);
    }

    public SimpleMonthView(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 16843612);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_SimpleMonthView$__constructor__(android.content.Context android.util.AttributeSet ), 0, this, context, attributeSet);
    }

    private void __constructor__(Context context, AttributeSet attributeSet, int n) {
        this.$$robo$$android_widget_SimpleMonthView$__constructor__(context, attributeSet, n);
    }

    public SimpleMonthView(Context context, AttributeSet attributeSet, int n) {
        super(context, attributeSet);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_SimpleMonthView$__constructor__(android.content.Context android.util.AttributeSet int ), 0, this, context, attributeSet, n);
    }

    @Override
    protected void onConfigurationChanged(Configuration configuration) {
        InvokeDynamicSupport.bootstrap("onConfigurationChanged", $$robo$$android_widget_SimpleMonthView$onConfigurationChanged(android.content.res.Configuration ), 0, this, configuration);
    }

    void setTextColor(ColorStateList colorStateList) {
        InvokeDynamicSupport.bootstrap("setTextColor", $$robo$$android_widget_SimpleMonthView$setTextColor(android.content.res.ColorStateList ), 0, this, colorStateList);
    }

    @Override
    public void setAccessibilityDelegate(View.AccessibilityDelegate accessibilityDelegate) {
        InvokeDynamicSupport.bootstrap("setAccessibilityDelegate", $$robo$$android_widget_SimpleMonthView$setAccessibilityDelegate(android.view.View$AccessibilityDelegate ), 0, this, accessibilityDelegate);
    }

    public void setOnDayClickListener(OnDayClickListener onDayClickListener) {
        InvokeDynamicSupport.bootstrap("setOnDayClickListener", $$robo$$android_widget_SimpleMonthView$setOnDayClickListener(android.widget.SimpleMonthView$OnDayClickListener ), 0, this, onDayClickListener);
    }

    @Override
    public boolean dispatchHoverEvent(MotionEvent motionEvent) {
        return (boolean)InvokeDynamicSupport.bootstrap("dispatchHoverEvent", $$robo$$android_widget_SimpleMonthView$dispatchHoverEvent(android.view.MotionEvent ), 0, this, motionEvent);
    }

    @Override
    public boolean onTouchEvent(MotionEvent motionEvent) {
        return (boolean)InvokeDynamicSupport.bootstrap("onTouchEvent", $$robo$$android_widget_SimpleMonthView$onTouchEvent(android.view.MotionEvent ), 0, this, motionEvent);
    }

    private void initView() {
        InvokeDynamicSupport.bootstrap("initView", $$robo$$android_widget_SimpleMonthView$initView(), 0, this);
    }

    @Override
    protected void onDraw(Canvas canvas) {
        InvokeDynamicSupport.bootstrap("onDraw", $$robo$$android_widget_SimpleMonthView$onDraw(android.graphics.Canvas ), 0, this, canvas);
    }

    private static boolean isValidDayOfWeek(int n) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isValidDayOfWeek", $$robo$$android_widget_SimpleMonthView$isValidDayOfWeek(int ), 0, (int)n);
    }

    private static boolean isValidMonth(int n) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isValidMonth", $$robo$$android_widget_SimpleMonthView$isValidMonth(int ), 0, (int)n);
    }

    void setMonthParams(int n, int n2, int n3, int n4, int n5, int n6) {
        InvokeDynamicSupport.bootstrap("setMonthParams", $$robo$$android_widget_SimpleMonthView$setMonthParams(int int int int int int ), 0, this, n, n2, n3, n4, n5, n6);
    }

    private static int getDaysInMonth(int n, int n2) {
        return (int)InvokeDynamicSupport.bootstrapStatic("getDaysInMonth", $$robo$$android_widget_SimpleMonthView$getDaysInMonth(int int ), 0, (int)n, (int)n2);
    }

    public void reuse() {
        InvokeDynamicSupport.bootstrap("reuse", $$robo$$android_widget_SimpleMonthView$reuse(), 0, this);
    }

    private int calculateNumRows() {
        return (int)InvokeDynamicSupport.bootstrap("calculateNumRows", $$robo$$android_widget_SimpleMonthView$calculateNumRows(), 0, this);
    }

    private boolean sameDay(int n, Time time) {
        return (boolean)InvokeDynamicSupport.bootstrap("sameDay", $$robo$$android_widget_SimpleMonthView$sameDay(int android.text.format.Time ), 0, this, n, time);
    }

    @Override
    protected void onMeasure(int n, int n2) {
        InvokeDynamicSupport.bootstrap("onMeasure", $$robo$$android_widget_SimpleMonthView$onMeasure(int int ), 0, this, n, n2);
    }

    @Override
    protected void onSizeChanged(int n, int n2, int n3, int n4) {
        InvokeDynamicSupport.bootstrap("onSizeChanged", $$robo$$android_widget_SimpleMonthView$onSizeChanged(int int int int ), 0, this, n, n2, n3, n4);
    }

    private String getMonthAndYearString() {
        return InvokeDynamicSupport.bootstrap("getMonthAndYearString", $$robo$$android_widget_SimpleMonthView$getMonthAndYearString(), 0, this);
    }

    private void drawMonthTitle(Canvas canvas) {
        InvokeDynamicSupport.bootstrap("drawMonthTitle", $$robo$$android_widget_SimpleMonthView$drawMonthTitle(android.graphics.Canvas ), 0, this, canvas);
    }

    private void drawWeekDayLabels(Canvas canvas) {
        InvokeDynamicSupport.bootstrap("drawWeekDayLabels", $$robo$$android_widget_SimpleMonthView$drawWeekDayLabels(android.graphics.Canvas ), 0, this, canvas);
    }

    private void drawDays(Canvas canvas) {
        InvokeDynamicSupport.bootstrap("drawDays", $$robo$$android_widget_SimpleMonthView$drawDays(android.graphics.Canvas ), 0, this, canvas);
    }

    private int findDayOffset() {
        return (int)InvokeDynamicSupport.bootstrap("findDayOffset", $$robo$$android_widget_SimpleMonthView$findDayOffset(), 0, this);
    }

    private int getDayFromLocation(float f, float f2) {
        return (int)InvokeDynamicSupport.bootstrap("getDayFromLocation", $$robo$$android_widget_SimpleMonthView$getDayFromLocation(float float ), 0, this, f, f2);
    }

    private void onDayClick(int n) {
        InvokeDynamicSupport.bootstrap("onDayClick", $$robo$$android_widget_SimpleMonthView$onDayClick(int ), 0, this, n);
    }

    Calendar getAccessibilityFocus() {
        return InvokeDynamicSupport.bootstrap("getAccessibilityFocus", $$robo$$android_widget_SimpleMonthView$getAccessibilityFocus(), 0, this);
    }

    @Override
    public void clearAccessibilityFocus() {
        InvokeDynamicSupport.bootstrap("clearAccessibilityFocus", $$robo$$android_widget_SimpleMonthView$clearAccessibilityFocus(), 0, this);
    }

    boolean restoreAccessibilityFocus(Calendar calendar) {
        return (boolean)InvokeDynamicSupport.bootstrap("restoreAccessibilityFocus", $$robo$$android_widget_SimpleMonthView$restoreAccessibilityFocus(java.util.Calendar ), 0, this, calendar);
    }

    static {
        RobolectricInternals.classInitializing(SimpleMonthView.class);
    }

    public /* synthetic */ SimpleMonthView() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SimpleMonthView)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static interface OnDayClickListener
    extends InstrumentedInterface {
        public void onDayClick(SimpleMonthView var1, Calendar var2);
    }

    private class MonthViewTouchHelper
    extends ExploreByTouchHelper
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private static String DATE_FORMAT = "dd MMMM yyyy";
        private Rect mTempRect;
        private Calendar mTempCalendar;
        /* synthetic */ SimpleMonthView this$0;

        private void $$robo$$android_widget_SimpleMonthView_MonthViewTouchHelper$__constructor__(SimpleMonthView simpleMonthView, View host) {
            this.mTempRect = new Rect();
            this.mTempCalendar = Calendar.getInstance();
        }

        private final void $$robo$$android_widget_SimpleMonthView_MonthViewTouchHelper$setFocusedVirtualView(int virtualViewId) {
            this.getAccessibilityNodeProvider(this.this$0).performAction(virtualViewId, 64, null);
        }

        private final void $$robo$$android_widget_SimpleMonthView_MonthViewTouchHelper$clearFocusedVirtualView() {
            int focusedVirtualView = this.getFocusedVirtualView();
            if (focusedVirtualView != Integer.MIN_VALUE) {
                this.getAccessibilityNodeProvider(this.this$0).performAction(focusedVirtualView, 128, null);
            }
        }

        private final int $$robo$$android_widget_SimpleMonthView_MonthViewTouchHelper$getVirtualViewAt(float x, float y) {
            int day = this.this$0.getDayFromLocation(x, y);
            if (day >= 0) {
                return day;
            }
            return Integer.MIN_VALUE;
        }

        private final void $$robo$$android_widget_SimpleMonthView_MonthViewTouchHelper$getVisibleVirtualViews(List<Integer> virtualViewIds) {
            for (int day = 1; day <= this.this$0.mNumCells; ++day) {
                virtualViewIds.add(day);
            }
        }

        private final void $$robo$$android_widget_SimpleMonthView_MonthViewTouchHelper$onPopulateEventForVirtualView(int virtualViewId, AccessibilityEvent event) {
            event.setContentDescription(this.getItemDescription(virtualViewId));
        }

        private final void $$robo$$android_widget_SimpleMonthView_MonthViewTouchHelper$onPopulateNodeForVirtualView(int virtualViewId, AccessibilityNodeInfo node) {
            this.getItemBounds(virtualViewId, this.mTempRect);
            node.setContentDescription(this.getItemDescription(virtualViewId));
            node.setBoundsInParent(this.mTempRect);
            node.addAction(16);
            if (virtualViewId == this.this$0.mSelectedDay) {
                node.setSelected(true);
            }
        }

        private final boolean $$robo$$android_widget_SimpleMonthView_MonthViewTouchHelper$onPerformActionForVirtualView(int virtualViewId, int action, Bundle arguments) {
            switch (action) {
                case 16: {
                    this.this$0.onDayClick(virtualViewId);
                    return true;
                }
            }
            return false;
        }

        private final void $$robo$$android_widget_SimpleMonthView_MonthViewTouchHelper$getItemBounds(int day, Rect rect) {
            int offsetX = this.this$0.mPadding;
            int offsetY = this.this$0.mMonthHeaderSize;
            int cellHeight = this.this$0.mRowHeight;
            int cellWidth = (this.this$0.mWidth - 2 * this.this$0.mPadding) / this.this$0.mNumDays;
            int index = day - 1 + this.this$0.findDayOffset();
            int row = index / this.this$0.mNumDays;
            int column = index % this.this$0.mNumDays;
            int x = offsetX + column * cellWidth;
            int y = offsetY + row * cellHeight;
            rect.set(x, y, x + cellWidth, y + cellHeight);
        }

        private final CharSequence $$robo$$android_widget_SimpleMonthView_MonthViewTouchHelper$getItemDescription(int day) {
            this.mTempCalendar.set(this.this$0.mYear, this.this$0.mMonth, day);
            CharSequence date = DateFormat.format((CharSequence)"dd MMMM yyyy", this.mTempCalendar.getTimeInMillis());
            if (day == this.this$0.mSelectedDay) {
                return this.this$0.getContext().getString(17041003, date);
            }
            return date;
        }

        private void __constructor__(SimpleMonthView simpleMonthView, View view) {
            this.$$robo$$android_widget_SimpleMonthView_MonthViewTouchHelper$__constructor__(simpleMonthView, view);
        }

        public MonthViewTouchHelper(SimpleMonthView simpleMonthView, View view) {
            this.this$0 = simpleMonthView;
            super(view);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_SimpleMonthView_MonthViewTouchHelper$__constructor__(android.widget.SimpleMonthView android.view.View ), 0, this, simpleMonthView, view);
        }

        public void setFocusedVirtualView(int n) {
            InvokeDynamicSupport.bootstrap("setFocusedVirtualView", $$robo$$android_widget_SimpleMonthView_MonthViewTouchHelper$setFocusedVirtualView(int ), 0, this, n);
        }

        public void clearFocusedVirtualView() {
            InvokeDynamicSupport.bootstrap("clearFocusedVirtualView", $$robo$$android_widget_SimpleMonthView_MonthViewTouchHelper$clearFocusedVirtualView(), 0, this);
        }

        @Override
        protected int getVirtualViewAt(float f, float f2) {
            return (int)InvokeDynamicSupport.bootstrap("getVirtualViewAt", $$robo$$android_widget_SimpleMonthView_MonthViewTouchHelper$getVirtualViewAt(float float ), 0, this, f, f2);
        }

        @Override
        protected void getVisibleVirtualViews(List<Integer> list) {
            InvokeDynamicSupport.bootstrap("getVisibleVirtualViews", $$robo$$android_widget_SimpleMonthView_MonthViewTouchHelper$getVisibleVirtualViews(java.util.List<java.lang.Integer> ), 0, this, list);
        }

        @Override
        protected void onPopulateEventForVirtualView(int n, AccessibilityEvent accessibilityEvent) {
            InvokeDynamicSupport.bootstrap("onPopulateEventForVirtualView", $$robo$$android_widget_SimpleMonthView_MonthViewTouchHelper$onPopulateEventForVirtualView(int android.view.accessibility.AccessibilityEvent ), 0, this, n, accessibilityEvent);
        }

        @Override
        protected void onPopulateNodeForVirtualView(int n, AccessibilityNodeInfo accessibilityNodeInfo) {
            InvokeDynamicSupport.bootstrap("onPopulateNodeForVirtualView", $$robo$$android_widget_SimpleMonthView_MonthViewTouchHelper$onPopulateNodeForVirtualView(int android.view.accessibility.AccessibilityNodeInfo ), 0, this, n, accessibilityNodeInfo);
        }

        @Override
        protected boolean onPerformActionForVirtualView(int n, int n2, Bundle bundle) {
            return (boolean)InvokeDynamicSupport.bootstrap("onPerformActionForVirtualView", $$robo$$android_widget_SimpleMonthView_MonthViewTouchHelper$onPerformActionForVirtualView(int int android.os.Bundle ), 0, this, n, n2, bundle);
        }

        private void getItemBounds(int n, Rect rect) {
            InvokeDynamicSupport.bootstrap("getItemBounds", $$robo$$android_widget_SimpleMonthView_MonthViewTouchHelper$getItemBounds(int android.graphics.Rect ), 0, this, n, rect);
        }

        private CharSequence getItemDescription(int n) {
            return InvokeDynamicSupport.bootstrap("getItemDescription", $$robo$$android_widget_SimpleMonthView_MonthViewTouchHelper$getItemDescription(int ), 0, this, n);
        }

        public /* synthetic */ MonthViewTouchHelper() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (MonthViewTouchHelper)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

