/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.res.TypedArray;
import android.database.DataSetObserver;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.util.Log;
import android.view.Gravity;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityNodeInfo;
import android.widget.AbsSpinner;
import android.widget.AdapterView;
import android.widget.ListAdapter;
import android.widget.ListPopupWindow;
import android.widget.ListView;
import android.widget.PopupWindow;
import android.widget.SpinnerAdapter;
import com.android.internal.R;
import org.robolectric.internal.bytecode.InstrumentedInterface;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class Spinner
extends AbsSpinner
implements DialogInterface.OnClickListener,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "Spinner";
    private static int MAX_ITEMS_MEASURED = 15;
    public static int MODE_DIALOG = 0;
    public static int MODE_DROPDOWN = 1;
    private static int MODE_THEME = -1;
    private ListPopupWindow.ForwardingListener mForwardingListener;
    private SpinnerPopup mPopup;
    private DropDownAdapter mTempAdapter;
    int mDropDownWidth;
    private int mGravity;
    private boolean mDisableChildrenWhenDisabled;
    private Rect mTempRect;

    private void $$robo$$android_widget_Spinner$__constructor__(Context context) {
    }

    private void $$robo$$android_widget_Spinner$__constructor__(Context context, int mode) {
    }

    private void $$robo$$android_widget_Spinner$__constructor__(Context context, AttributeSet attrs) {
    }

    private void $$robo$$android_widget_Spinner$__constructor__(Context context, AttributeSet attrs, int defStyleAttr) {
    }

    private void $$robo$$android_widget_Spinner$__constructor__(Context context, AttributeSet attrs, int defStyleAttr, int mode) {
    }

    private void $$robo$$android_widget_Spinner$__constructor__(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes, int mode) {
        this.mTempRect = new Rect();
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.Spinner, defStyleAttr, defStyleRes);
        if (mode == -1) {
            mode = a.getInt(5, 0);
        }
        switch (mode) {
            case 0: {
                this.mPopup = new DialogPopup(this);
                break;
            }
            case 1: {
                DropdownPopup popup = new DropdownPopup(this, context, attrs, defStyleAttr, defStyleRes);
                this.mDropDownWidth = a.getLayoutDimension(4, -2);
                popup.setBackgroundDrawable(a.getDrawable(2));
                this.mPopup = popup;
                this.mForwardingListener = new ShadowedObject(this, this, popup){
                    public transient /* synthetic */ Object __robo_data__;
                    /* synthetic */ DropdownPopup val$popup;
                    /* synthetic */ Spinner this$0;

                    private void $$robo$$android_widget_Spinner_1$__constructor__(Spinner spinner, View x0, DropdownPopup dropdownPopup) {
                    }

                    private final ListPopupWindow $$robo$$android_widget_Spinner_1$getPopup() {
                        return this.val$popup;
                    }

                    private final boolean $$robo$$android_widget_Spinner_1$onForwardingStarted() {
                        if (!this.this$0.mPopup.isShowing()) {
                            this.this$0.mPopup.show(this.this$0.getTextDirection(), this.this$0.getTextAlignment());
                        }
                        return true;
                    }

                    private void __constructor__(Spinner spinner, View view, DropdownPopup dropdownPopup) {
                        this.$$robo$$android_widget_Spinner_1$__constructor__(spinner, view, dropdownPopup);
                    }
                    {
                        this.this$0 = spinner;
                        this.val$popup = dropdownPopup;
                        super(view);
                        this.$$robo$init();
                        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_Spinner_1$__constructor__(android.widget.Spinner android.view.View android.widget.Spinner$DropdownPopup ), 0, this, spinner, view, dropdownPopup);
                    }

                    @Override
                    public ListPopupWindow getPopup() {
                        return InvokeDynamicSupport.bootstrap("getPopup", $$robo$$android_widget_Spinner_1$getPopup(), 0, this);
                    }

                    @Override
                    public boolean onForwardingStarted() {
                        return (boolean)InvokeDynamicSupport.bootstrap("onForwardingStarted", $$robo$$android_widget_Spinner_1$onForwardingStarted(), 0, this);
                    }
                    {
                        this.$$robo$init();
                    }

                    @Override
                    protected /* synthetic */ void $$robo$init() {
                        if (this.__robo_data__ == null) {
                            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                        }
                    }

                    @Override
                    public /* synthetic */ Object $$robo$getData() {
                        return this.__robo_data__;
                    }
                };
                break;
            }
        }
        this.mGravity = a.getInt(0, 17);
        this.mPopup.setPromptText(a.getString(3));
        this.mDisableChildrenWhenDisabled = a.getBoolean(8, false);
        a.recycle();
        if (this.mTempAdapter != null) {
            this.mPopup.setAdapter(this.mTempAdapter);
            this.mTempAdapter = null;
        }
    }

    private final void $$robo$$android_widget_Spinner$setPopupBackgroundDrawable(Drawable background) {
        if (!(this.mPopup instanceof DropdownPopup)) {
            Log.e("Spinner", "setPopupBackgroundDrawable: incompatible spinner mode; ignoring...");
            return;
        }
        ((DropdownPopup)this.mPopup).setBackgroundDrawable(background);
    }

    private final void $$robo$$android_widget_Spinner$setPopupBackgroundResource(int resId) {
        this.setPopupBackgroundDrawable(this.getContext().getDrawable(resId));
    }

    private final Drawable $$robo$$android_widget_Spinner$getPopupBackground() {
        return this.mPopup.getBackground();
    }

    private final void $$robo$$android_widget_Spinner$setDropDownVerticalOffset(int pixels) {
        this.mPopup.setVerticalOffset(pixels);
    }

    private final int $$robo$$android_widget_Spinner$getDropDownVerticalOffset() {
        return this.mPopup.getVerticalOffset();
    }

    private final void $$robo$$android_widget_Spinner$setDropDownHorizontalOffset(int pixels) {
        this.mPopup.setHorizontalOffset(pixels);
    }

    private final int $$robo$$android_widget_Spinner$getDropDownHorizontalOffset() {
        return this.mPopup.getHorizontalOffset();
    }

    private final void $$robo$$android_widget_Spinner$setDropDownWidth(int pixels) {
        if (!(this.mPopup instanceof DropdownPopup)) {
            Log.e("Spinner", "Cannot set dropdown width for MODE_DIALOG, ignoring");
            return;
        }
        this.mDropDownWidth = pixels;
    }

    private final int $$robo$$android_widget_Spinner$getDropDownWidth() {
        return this.mDropDownWidth;
    }

    private final void $$robo$$android_widget_Spinner$setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (this.mDisableChildrenWhenDisabled) {
            int count = this.getChildCount();
            for (int i = 0; i < count; ++i) {
                this.getChildAt(i).setEnabled(enabled);
            }
        }
    }

    private final void $$robo$$android_widget_Spinner$setGravity(int gravity) {
        if (this.mGravity != gravity) {
            if ((gravity & 7) == 0) {
                gravity |= 0x800003;
            }
            this.mGravity = gravity;
            this.requestLayout();
        }
    }

    private final int $$robo$$android_widget_Spinner$getGravity() {
        return this.mGravity;
    }

    private final void $$robo$$android_widget_Spinner$setAdapter(SpinnerAdapter adapter) {
        super.setAdapter(adapter);
        this.mRecycler.clear();
        int targetSdkVersion = this.mContext.getApplicationInfo().targetSdkVersion;
        if (targetSdkVersion >= 21 && adapter != null && adapter.getViewTypeCount() != 1) {
            throw new IllegalArgumentException("Spinner adapter view type count must be 1");
        }
        if (this.mPopup != null) {
            this.mPopup.setAdapter(new DropDownAdapter(adapter));
        } else {
            this.mTempAdapter = new DropDownAdapter(adapter);
        }
    }

    private final int $$robo$$android_widget_Spinner$getBaseline() {
        View child = null;
        if (this.getChildCount() > 0) {
            child = this.getChildAt(0);
        } else if (this.mAdapter != null && this.mAdapter.getCount() > 0) {
            child = this.makeView(0, false);
            this.mRecycler.put(0, child);
        }
        if (child != null) {
            int childBaseline = child.getBaseline();
            return childBaseline >= 0 ? child.getTop() + childBaseline : -1;
        }
        return -1;
    }

    private final void $$robo$$android_widget_Spinner$onDetachedFromWindow() {
        super.onDetachedFromWindow();
        if (this.mPopup != null && this.mPopup.isShowing()) {
            this.mPopup.dismiss();
        }
    }

    private final void $$robo$$android_widget_Spinner$setOnItemClickListener(AdapterView.OnItemClickListener l) {
        throw new RuntimeException("setOnItemClickListener cannot be used with a spinner.");
    }

    private final void $$robo$$android_widget_Spinner$setOnItemClickListenerInt(AdapterView.OnItemClickListener l) {
        super.setOnItemClickListener(l);
    }

    private final boolean $$robo$$android_widget_Spinner$onTouchEvent(MotionEvent event) {
        if (this.mForwardingListener != null && this.mForwardingListener.onTouch(this, event)) {
            return true;
        }
        return super.onTouchEvent(event);
    }

    private final void $$robo$$android_widget_Spinner$onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        if (this.mPopup != null && View.MeasureSpec.getMode(widthMeasureSpec) == Integer.MIN_VALUE) {
            int measuredWidth = this.getMeasuredWidth();
            this.setMeasuredDimension(Math.min(Math.max(measuredWidth, this.measureContentWidth((SpinnerAdapter)this.getAdapter(), this.getBackground())), View.MeasureSpec.getSize(widthMeasureSpec)), this.getMeasuredHeight());
        }
    }

    private final void $$robo$$android_widget_Spinner$onLayout(boolean changed, int l, int t, int r, int b) {
        super.onLayout(changed, l, t, r, b);
        this.mInLayout = true;
        this.layout(0, false);
        this.mInLayout = false;
    }

    private final void $$robo$$android_widget_Spinner$layout(int delta, boolean animate) {
        int childrenLeft = this.mSpinnerPadding.left;
        int childrenWidth = this.mRight - this.mLeft - this.mSpinnerPadding.left - this.mSpinnerPadding.right;
        if (this.mDataChanged) {
            this.handleDataChanged();
        }
        if (this.mItemCount == 0) {
            this.resetList();
            return;
        }
        if (this.mNextSelectedPosition >= 0) {
            this.setSelectedPositionInt(this.mNextSelectedPosition);
        }
        this.recycleAllViews();
        this.removeAllViewsInLayout();
        this.mFirstPosition = this.mSelectedPosition;
        if (this.mAdapter != null) {
            View sel = this.makeView(this.mSelectedPosition, true);
            int width = sel.getMeasuredWidth();
            int selectedOffset = childrenLeft;
            int layoutDirection = this.getLayoutDirection();
            int absoluteGravity = Gravity.getAbsoluteGravity(this.mGravity, layoutDirection);
            switch (absoluteGravity & 7) {
                case 1: {
                    selectedOffset = childrenLeft + childrenWidth / 2 - width / 2;
                    break;
                }
                case 5: {
                    selectedOffset = childrenLeft + childrenWidth - width;
                }
            }
            sel.offsetLeftAndRight(selectedOffset);
        }
        this.mRecycler.clear();
        this.invalidate();
        this.checkSelectionChanged();
        this.mDataChanged = false;
        this.mNeedSync = false;
        this.setNextSelectedPositionInt(this.mSelectedPosition);
    }

    private final View $$robo$$android_widget_Spinner$makeView(int position, boolean addChild) {
        View child;
        if (!this.mDataChanged && (child = this.mRecycler.get(position)) != null) {
            this.setUpChild(child, addChild);
            return child;
        }
        child = this.mAdapter.getView(position, null, this);
        this.setUpChild(child, addChild);
        return child;
    }

    private final void $$robo$$android_widget_Spinner$setUpChild(View child, boolean addChild) {
        ViewGroup.LayoutParams lp = child.getLayoutParams();
        if (lp == null) {
            lp = this.generateDefaultLayoutParams();
        }
        if (addChild) {
            this.addViewInLayout(child, 0, lp);
        }
        child.setSelected(this.hasFocus());
        if (this.mDisableChildrenWhenDisabled) {
            child.setEnabled(this.isEnabled());
        }
        int childHeightSpec = ViewGroup.getChildMeasureSpec(this.mHeightMeasureSpec, this.mSpinnerPadding.top + this.mSpinnerPadding.bottom, lp.height);
        int childWidthSpec = ViewGroup.getChildMeasureSpec(this.mWidthMeasureSpec, this.mSpinnerPadding.left + this.mSpinnerPadding.right, lp.width);
        child.measure(childWidthSpec, childHeightSpec);
        int childTop = this.mSpinnerPadding.top + (this.getMeasuredHeight() - this.mSpinnerPadding.bottom - this.mSpinnerPadding.top - child.getMeasuredHeight()) / 2;
        int childBottom = childTop + child.getMeasuredHeight();
        int width = child.getMeasuredWidth();
        int childLeft = 0;
        int childRight = childLeft + width;
        child.layout(childLeft, childTop, childRight, childBottom);
    }

    private final boolean $$robo$$android_widget_Spinner$performClick() {
        boolean handled = super.performClick();
        if (!handled) {
            handled = true;
            if (!this.mPopup.isShowing()) {
                this.mPopup.show(this.getTextDirection(), this.getTextAlignment());
            }
        }
        return handled;
    }

    private final void $$robo$$android_widget_Spinner$onClick(DialogInterface dialog, int which) {
        this.setSelection(which);
        dialog.dismiss();
    }

    private final void $$robo$$android_widget_Spinner$onInitializeAccessibilityEvent(AccessibilityEvent event) {
        super.onInitializeAccessibilityEvent(event);
        event.setClassName(Spinner.class.getName());
    }

    private final void $$robo$$android_widget_Spinner$onInitializeAccessibilityNodeInfo(AccessibilityNodeInfo info) {
        super.onInitializeAccessibilityNodeInfo(info);
        info.setClassName(Spinner.class.getName());
        if (this.mAdapter != null) {
            info.setCanOpenPopup(true);
        }
    }

    private final void $$robo$$android_widget_Spinner$setPrompt(CharSequence prompt) {
        this.mPopup.setPromptText(prompt);
    }

    private final void $$robo$$android_widget_Spinner$setPromptId(int promptId) {
        this.setPrompt(this.getContext().getText(promptId));
    }

    private final CharSequence $$robo$$android_widget_Spinner$getPrompt() {
        return this.mPopup.getHintText();
    }

    private final int $$robo$$android_widget_Spinner$measureContentWidth(SpinnerAdapter adapter, Drawable background) {
        if (adapter == null) {
            return 0;
        }
        int width = 0;
        View itemView = null;
        int itemType = 0;
        int widthMeasureSpec = View.MeasureSpec.makeMeasureSpec(0, 0);
        int heightMeasureSpec = View.MeasureSpec.makeMeasureSpec(0, 0);
        int start = Math.max(0, this.getSelectedItemPosition());
        int end = Math.min(adapter.getCount(), start + 15);
        int count = end - start;
        for (int i = start = Math.max(0, start - (15 - count)); i < end; ++i) {
            int positionType = adapter.getItemViewType(i);
            if (positionType != itemType) {
                itemType = positionType;
                itemView = null;
            }
            if ((itemView = adapter.getView(i, itemView, this)).getLayoutParams() == null) {
                itemView.setLayoutParams(new ViewGroup.LayoutParams(-2, -2));
            }
            itemView.measure(widthMeasureSpec, heightMeasureSpec);
            width = Math.max(width, itemView.getMeasuredWidth());
        }
        if (background != null) {
            background.getPadding(this.mTempRect);
            width += this.mTempRect.left + this.mTempRect.right;
        }
        return width;
    }

    private final Parcelable $$robo$$android_widget_Spinner$onSaveInstanceState() {
        SavedState ss = new SavedState(super.onSaveInstanceState());
        ss.showDropdown = this.mPopup != null && this.mPopup.isShowing();
        return ss;
    }

    private final void $$robo$$android_widget_Spinner$onRestoreInstanceState(Parcelable state) {
        ViewTreeObserver vto;
        SavedState ss = (SavedState)state;
        super.onRestoreInstanceState(ss.getSuperState());
        if (ss.showDropdown && (vto = this.getViewTreeObserver()) != null) {
            ViewTreeObserver.OnGlobalLayoutListener listener = new ViewTreeObserver.OnGlobalLayoutListener(this){
                public transient /* synthetic */ Object __robo_data__;
                /* synthetic */ Spinner this$0;

                private void $$robo$$android_widget_Spinner_2$__constructor__(Spinner spinner) {
                }

                private final void $$robo$$android_widget_Spinner_2$onGlobalLayout() {
                    ViewTreeObserver vto;
                    if (!this.this$0.mPopup.isShowing()) {
                        this.this$0.mPopup.show(this.this$0.getTextDirection(), this.this$0.getTextAlignment());
                    }
                    if ((vto = this.this$0.getViewTreeObserver()) != null) {
                        vto.removeOnGlobalLayoutListener(this);
                    }
                }

                private void __constructor__(Spinner spinner) {
                    this.$$robo$$android_widget_Spinner_2$__constructor__(spinner);
                }
                {
                    this.this$0 = spinner;
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_Spinner_2$__constructor__(android.widget.Spinner ), 0, this, spinner);
                }

                @Override
                public void onGlobalLayout() {
                    InvokeDynamicSupport.bootstrap("onGlobalLayout", $$robo$$android_widget_Spinner_2$onGlobalLayout(), 0, this);
                }
                {
                    this.$$robo$init();
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            };
            vto.addOnGlobalLayoutListener(listener);
        }
    }

    private void __constructor__(Context context) {
        this.$$robo$$android_widget_Spinner$__constructor__(context);
    }

    public Spinner(Context context) {
        this(context, null);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_Spinner$__constructor__(android.content.Context ), 0, this, context);
    }

    private void __constructor__(Context context, int n) {
        this.$$robo$$android_widget_Spinner$__constructor__(context, n);
    }

    public Spinner(Context context, int n) {
        this(context, null, 0x1010081, n);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_Spinner$__constructor__(android.content.Context int ), 0, this, context, n);
    }

    private void __constructor__(Context context, AttributeSet attributeSet) {
        this.$$robo$$android_widget_Spinner$__constructor__(context, attributeSet);
    }

    public Spinner(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 0x1010081);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_Spinner$__constructor__(android.content.Context android.util.AttributeSet ), 0, this, context, attributeSet);
    }

    private void __constructor__(Context context, AttributeSet attributeSet, int n) {
        this.$$robo$$android_widget_Spinner$__constructor__(context, attributeSet, n);
    }

    public Spinner(Context context, AttributeSet attributeSet, int n) {
        this(context, attributeSet, n, 0, -1);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_Spinner$__constructor__(android.content.Context android.util.AttributeSet int ), 0, this, context, attributeSet, n);
    }

    private void __constructor__(Context context, AttributeSet attributeSet, int n, int n2) {
        this.$$robo$$android_widget_Spinner$__constructor__(context, attributeSet, n, n2);
    }

    public Spinner(Context context, AttributeSet attributeSet, int n, int n2) {
        this(context, attributeSet, n, 0, n2);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_Spinner$__constructor__(android.content.Context android.util.AttributeSet int int ), 0, this, context, attributeSet, n, n2);
    }

    private void __constructor__(Context context, AttributeSet attributeSet, int n, int n2, int n3) {
        this.$$robo$$android_widget_Spinner$__constructor__(context, attributeSet, n, n2, n3);
    }

    public Spinner(Context context, AttributeSet attributeSet, int n, int n2, int n3) {
        super(context, attributeSet, n, n2);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_Spinner$__constructor__(android.content.Context android.util.AttributeSet int int int ), 0, this, context, attributeSet, n, n2, n3);
    }

    public void setPopupBackgroundDrawable(Drawable drawable2) {
        InvokeDynamicSupport.bootstrap("setPopupBackgroundDrawable", $$robo$$android_widget_Spinner$setPopupBackgroundDrawable(android.graphics.drawable.Drawable ), 0, this, drawable2);
    }

    public void setPopupBackgroundResource(int n) {
        InvokeDynamicSupport.bootstrap("setPopupBackgroundResource", $$robo$$android_widget_Spinner$setPopupBackgroundResource(int ), 0, this, n);
    }

    public Drawable getPopupBackground() {
        return InvokeDynamicSupport.bootstrap("getPopupBackground", $$robo$$android_widget_Spinner$getPopupBackground(), 0, this);
    }

    public void setDropDownVerticalOffset(int n) {
        InvokeDynamicSupport.bootstrap("setDropDownVerticalOffset", $$robo$$android_widget_Spinner$setDropDownVerticalOffset(int ), 0, this, n);
    }

    public int getDropDownVerticalOffset() {
        return (int)InvokeDynamicSupport.bootstrap("getDropDownVerticalOffset", $$robo$$android_widget_Spinner$getDropDownVerticalOffset(), 0, this);
    }

    public void setDropDownHorizontalOffset(int n) {
        InvokeDynamicSupport.bootstrap("setDropDownHorizontalOffset", $$robo$$android_widget_Spinner$setDropDownHorizontalOffset(int ), 0, this, n);
    }

    public int getDropDownHorizontalOffset() {
        return (int)InvokeDynamicSupport.bootstrap("getDropDownHorizontalOffset", $$robo$$android_widget_Spinner$getDropDownHorizontalOffset(), 0, this);
    }

    public void setDropDownWidth(int n) {
        InvokeDynamicSupport.bootstrap("setDropDownWidth", $$robo$$android_widget_Spinner$setDropDownWidth(int ), 0, this, n);
    }

    public int getDropDownWidth() {
        return (int)InvokeDynamicSupport.bootstrap("getDropDownWidth", $$robo$$android_widget_Spinner$getDropDownWidth(), 0, this);
    }

    @Override
    public void setEnabled(boolean bl) {
        InvokeDynamicSupport.bootstrap("setEnabled", $$robo$$android_widget_Spinner$setEnabled(boolean ), 0, this, bl);
    }

    public void setGravity(int n) {
        InvokeDynamicSupport.bootstrap("setGravity", $$robo$$android_widget_Spinner$setGravity(int ), 0, this, n);
    }

    public int getGravity() {
        return (int)InvokeDynamicSupport.bootstrap("getGravity", $$robo$$android_widget_Spinner$getGravity(), 0, this);
    }

    @Override
    public void setAdapter(SpinnerAdapter spinnerAdapter) {
        InvokeDynamicSupport.bootstrap("setAdapter", $$robo$$android_widget_Spinner$setAdapter(android.widget.SpinnerAdapter ), 0, this, spinnerAdapter);
    }

    @Override
    public int getBaseline() {
        return (int)InvokeDynamicSupport.bootstrap("getBaseline", $$robo$$android_widget_Spinner$getBaseline(), 0, this);
    }

    @Override
    protected void onDetachedFromWindow() {
        InvokeDynamicSupport.bootstrap("onDetachedFromWindow", $$robo$$android_widget_Spinner$onDetachedFromWindow(), 0, this);
    }

    @Override
    public void setOnItemClickListener(AdapterView.OnItemClickListener onItemClickListener) {
        InvokeDynamicSupport.bootstrap("setOnItemClickListener", $$robo$$android_widget_Spinner$setOnItemClickListener(android.widget.AdapterView$OnItemClickListener ), 0, this, onItemClickListener);
    }

    public void setOnItemClickListenerInt(AdapterView.OnItemClickListener onItemClickListener) {
        InvokeDynamicSupport.bootstrap("setOnItemClickListenerInt", $$robo$$android_widget_Spinner$setOnItemClickListenerInt(android.widget.AdapterView$OnItemClickListener ), 0, this, onItemClickListener);
    }

    @Override
    public boolean onTouchEvent(MotionEvent motionEvent) {
        return (boolean)InvokeDynamicSupport.bootstrap("onTouchEvent", $$robo$$android_widget_Spinner$onTouchEvent(android.view.MotionEvent ), 0, this, motionEvent);
    }

    @Override
    protected void onMeasure(int n, int n2) {
        InvokeDynamicSupport.bootstrap("onMeasure", $$robo$$android_widget_Spinner$onMeasure(int int ), 0, this, n, n2);
    }

    @Override
    protected void onLayout(boolean bl, int n, int n2, int n3, int n4) {
        InvokeDynamicSupport.bootstrap("onLayout", $$robo$$android_widget_Spinner$onLayout(boolean int int int int ), 0, this, bl, n, n2, n3, n4);
    }

    @Override
    void layout(int n, boolean bl) {
        InvokeDynamicSupport.bootstrap("layout", $$robo$$android_widget_Spinner$layout(int boolean ), 0, this, n, bl);
    }

    private View makeView(int n, boolean bl) {
        return InvokeDynamicSupport.bootstrap("makeView", $$robo$$android_widget_Spinner$makeView(int boolean ), 0, this, n, bl);
    }

    private void setUpChild(View view, boolean bl) {
        InvokeDynamicSupport.bootstrap("setUpChild", $$robo$$android_widget_Spinner$setUpChild(android.view.View boolean ), 0, this, view, bl);
    }

    @Override
    public boolean performClick() {
        return (boolean)InvokeDynamicSupport.bootstrap("performClick", $$robo$$android_widget_Spinner$performClick(), 0, this);
    }

    @Override
    public void onClick(DialogInterface dialogInterface, int n) {
        InvokeDynamicSupport.bootstrap("onClick", $$robo$$android_widget_Spinner$onClick(android.content.DialogInterface int ), 0, this, dialogInterface, n);
    }

    @Override
    public void onInitializeAccessibilityEvent(AccessibilityEvent accessibilityEvent) {
        InvokeDynamicSupport.bootstrap("onInitializeAccessibilityEvent", $$robo$$android_widget_Spinner$onInitializeAccessibilityEvent(android.view.accessibility.AccessibilityEvent ), 0, this, accessibilityEvent);
    }

    @Override
    public void onInitializeAccessibilityNodeInfo(AccessibilityNodeInfo accessibilityNodeInfo) {
        InvokeDynamicSupport.bootstrap("onInitializeAccessibilityNodeInfo", $$robo$$android_widget_Spinner$onInitializeAccessibilityNodeInfo(android.view.accessibility.AccessibilityNodeInfo ), 0, this, accessibilityNodeInfo);
    }

    public void setPrompt(CharSequence charSequence) {
        InvokeDynamicSupport.bootstrap("setPrompt", $$robo$$android_widget_Spinner$setPrompt(java.lang.CharSequence ), 0, this, charSequence);
    }

    public void setPromptId(int n) {
        InvokeDynamicSupport.bootstrap("setPromptId", $$robo$$android_widget_Spinner$setPromptId(int ), 0, this, n);
    }

    public CharSequence getPrompt() {
        return InvokeDynamicSupport.bootstrap("getPrompt", $$robo$$android_widget_Spinner$getPrompt(), 0, this);
    }

    int measureContentWidth(SpinnerAdapter spinnerAdapter, Drawable drawable2) {
        return (int)InvokeDynamicSupport.bootstrap("measureContentWidth", $$robo$$android_widget_Spinner$measureContentWidth(android.widget.SpinnerAdapter android.graphics.drawable.Drawable ), 0, this, spinnerAdapter, drawable2);
    }

    @Override
    public Parcelable onSaveInstanceState() {
        return InvokeDynamicSupport.bootstrap("onSaveInstanceState", $$robo$$android_widget_Spinner$onSaveInstanceState(), 0, this);
    }

    @Override
    public void onRestoreInstanceState(Parcelable parcelable) {
        InvokeDynamicSupport.bootstrap("onRestoreInstanceState", $$robo$$android_widget_Spinner$onRestoreInstanceState(android.os.Parcelable ), 0, this, parcelable);
    }

    public /* synthetic */ Spinner() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Spinner)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    private class DropdownPopup
    extends ListPopupWindow
    implements SpinnerPopup,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private CharSequence mHintText;
        private ListAdapter mAdapter;
        /* synthetic */ Spinner this$0;

        private void $$robo$$android_widget_Spinner_DropdownPopup$__constructor__(Spinner spinner, Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
            this.setAnchorView(spinner);
            this.setModal(true);
            this.setPromptPosition(0);
            this.setOnItemClickListener(new AdapterView.OnItemClickListener(this, spinner){
                public transient /* synthetic */ Object __robo_data__;
                /* synthetic */ Spinner val$this$0;
                /* synthetic */ DropdownPopup this$1;

                private void $$robo$$android_widget_Spinner_DropdownPopup_1$__constructor__(DropdownPopup dropdownPopup, Spinner spinner) {
                }

                private final void $$robo$$android_widget_Spinner_DropdownPopup_1$onItemClick(AdapterView parent, View v, int position, long id2) {
                    this.this$1.this$0.setSelection(position);
                    if (this.this$1.this$0.mOnItemClickListener != null) {
                        this.this$1.this$0.performItemClick(v, position, this.this$1.mAdapter.getItemId(position));
                    }
                    this.this$1.dismiss();
                }

                private void __constructor__(DropdownPopup dropdownPopup, Spinner spinner) {
                    this.$$robo$$android_widget_Spinner_DropdownPopup_1$__constructor__(dropdownPopup, spinner);
                }
                {
                    this.this$1 = dropdownPopup;
                    this.val$this$0 = spinner;
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_Spinner_DropdownPopup_1$__constructor__(android.widget.Spinner$DropdownPopup android.widget.Spinner ), 0, this, dropdownPopup, spinner);
                }

                public void onItemClick(AdapterView adapterView, View view, int n, long l) {
                    InvokeDynamicSupport.bootstrap("onItemClick", $$robo$$android_widget_Spinner_DropdownPopup_1$onItemClick(android.widget.AdapterView android.view.View int long ), 0, this, adapterView, view, n, l);
                }
                {
                    this.$$robo$init();
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            });
        }

        private final void $$robo$$android_widget_Spinner_DropdownPopup$setAdapter(ListAdapter adapter) {
            super.setAdapter(adapter);
            this.mAdapter = adapter;
        }

        private final CharSequence $$robo$$android_widget_Spinner_DropdownPopup$getHintText() {
            return this.mHintText;
        }

        private final void $$robo$$android_widget_Spinner_DropdownPopup$setPromptText(CharSequence hintText) {
            this.mHintText = hintText;
        }

        private final void $$robo$$android_widget_Spinner_DropdownPopup$computeContentWidth() {
            Drawable background = this.getBackground();
            int hOffset = 0;
            if (background != null) {
                background.getPadding(this.this$0.mTempRect);
                hOffset = this.this$0.isLayoutRtl() ? ((Spinner)this.this$0).mTempRect.right : -((Spinner)this.this$0).mTempRect.left;
            } else {
                ((Spinner)this.this$0).mTempRect.right = 0;
                ((Spinner)this.this$0).mTempRect.left = 0;
            }
            int spinnerPaddingLeft = this.this$0.getPaddingLeft();
            int spinnerPaddingRight = this.this$0.getPaddingRight();
            int spinnerWidth = this.this$0.getWidth();
            if (this.this$0.mDropDownWidth == -2) {
                int contentWidthLimit;
                int contentWidth = this.this$0.measureContentWidth((SpinnerAdapter)((Object)this.mAdapter), this.getBackground());
                if (contentWidth > (contentWidthLimit = ((Spinner)this.this$0).mContext.getResources().getDisplayMetrics().widthPixels - ((Spinner)this.this$0).mTempRect.left - ((Spinner)this.this$0).mTempRect.right)) {
                    contentWidth = contentWidthLimit;
                }
                this.setContentWidth(Math.max(contentWidth, spinnerWidth - spinnerPaddingLeft - spinnerPaddingRight));
            } else if (this.this$0.mDropDownWidth == -1) {
                this.setContentWidth(spinnerWidth - spinnerPaddingLeft - spinnerPaddingRight);
            } else {
                this.setContentWidth(this.this$0.mDropDownWidth);
            }
            hOffset = this.this$0.isLayoutRtl() ? (hOffset += spinnerWidth - spinnerPaddingRight - this.getWidth()) : (hOffset += spinnerPaddingLeft);
            this.setHorizontalOffset(hOffset);
        }

        private final void $$robo$$android_widget_Spinner_DropdownPopup$show(int textDirection, int textAlignment) {
            boolean wasShowing = this.isShowing();
            this.computeContentWidth();
            this.setInputMethodMode(2);
            super.show();
            ListView listView = this.getListView();
            listView.setChoiceMode(1);
            listView.setTextDirection(textDirection);
            listView.setTextAlignment(textAlignment);
            this.setSelection(this.this$0.getSelectedItemPosition());
            if (wasShowing) {
                return;
            }
            ViewTreeObserver vto = this.this$0.getViewTreeObserver();
            if (vto != null) {
                ViewTreeObserver.OnGlobalLayoutListener layoutListener = new ViewTreeObserver.OnGlobalLayoutListener(this){
                    public transient /* synthetic */ Object __robo_data__;
                    /* synthetic */ DropdownPopup this$1;

                    private void $$robo$$android_widget_Spinner_DropdownPopup_2$__constructor__(DropdownPopup dropdownPopup) {
                    }

                    private final void $$robo$$android_widget_Spinner_DropdownPopup_2$onGlobalLayout() {
                        if (!this.this$1.this$0.isVisibleToUser()) {
                            this.this$1.dismiss();
                        } else {
                            this.this$1.computeContentWidth();
                            DropdownPopup.super.show();
                        }
                    }

                    private void __constructor__(DropdownPopup dropdownPopup) {
                        this.$$robo$$android_widget_Spinner_DropdownPopup_2$__constructor__(dropdownPopup);
                    }
                    {
                        this.this$1 = dropdownPopup;
                        this.$$robo$init();
                        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_Spinner_DropdownPopup_2$__constructor__(android.widget.Spinner$DropdownPopup ), 0, this, dropdownPopup);
                    }

                    @Override
                    public void onGlobalLayout() {
                        InvokeDynamicSupport.bootstrap("onGlobalLayout", $$robo$$android_widget_Spinner_DropdownPopup_2$onGlobalLayout(), 0, this);
                    }
                    {
                        this.$$robo$init();
                    }

                    protected /* synthetic */ void $$robo$init() {
                        if (this.__robo_data__ == null) {
                            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                        }
                    }

                    public /* synthetic */ Object $$robo$getData() {
                        return this.__robo_data__;
                    }
                };
                vto.addOnGlobalLayoutListener(layoutListener);
                this.setOnDismissListener(new PopupWindow.OnDismissListener(this, layoutListener){
                    public transient /* synthetic */ Object __robo_data__;
                    /* synthetic */ ViewTreeObserver.OnGlobalLayoutListener val$layoutListener;
                    /* synthetic */ DropdownPopup this$1;

                    private void $$robo$$android_widget_Spinner_DropdownPopup_3$__constructor__(DropdownPopup dropdownPopup, ViewTreeObserver.OnGlobalLayoutListener onGlobalLayoutListener) {
                    }

                    private final void $$robo$$android_widget_Spinner_DropdownPopup_3$onDismiss() {
                        ViewTreeObserver vto = this.this$1.this$0.getViewTreeObserver();
                        if (vto != null) {
                            vto.removeOnGlobalLayoutListener(this.val$layoutListener);
                        }
                    }

                    private void __constructor__(DropdownPopup dropdownPopup, ViewTreeObserver.OnGlobalLayoutListener onGlobalLayoutListener) {
                        this.$$robo$$android_widget_Spinner_DropdownPopup_3$__constructor__(dropdownPopup, onGlobalLayoutListener);
                    }
                    {
                        this.this$1 = dropdownPopup;
                        this.val$layoutListener = onGlobalLayoutListener;
                        this.$$robo$init();
                        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_Spinner_DropdownPopup_3$__constructor__(android.widget.Spinner$DropdownPopup android.view.ViewTreeObserver$OnGlobalLayoutListener ), 0, this, dropdownPopup, onGlobalLayoutListener);
                    }

                    @Override
                    public void onDismiss() {
                        InvokeDynamicSupport.bootstrap("onDismiss", $$robo$$android_widget_Spinner_DropdownPopup_3$onDismiss(), 0, this);
                    }
                    {
                        this.$$robo$init();
                    }

                    protected /* synthetic */ void $$robo$init() {
                        if (this.__robo_data__ == null) {
                            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                        }
                    }

                    public /* synthetic */ Object $$robo$getData() {
                        return this.__robo_data__;
                    }
                });
            }
        }

        private void __constructor__(Spinner spinner, Context context, AttributeSet attributeSet, int n, int n2) {
            this.$$robo$$android_widget_Spinner_DropdownPopup$__constructor__(spinner, context, attributeSet, n, n2);
        }

        public DropdownPopup(Spinner spinner, Context context, AttributeSet attributeSet, int n, int n2) {
            this.this$0 = spinner;
            super(context, attributeSet, n, n2);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_Spinner_DropdownPopup$__constructor__(android.widget.Spinner android.content.Context android.util.AttributeSet int int ), 0, this, spinner, context, attributeSet, n, n2);
        }

        @Override
        public void setAdapter(ListAdapter listAdapter) {
            InvokeDynamicSupport.bootstrap("setAdapter", $$robo$$android_widget_Spinner_DropdownPopup$setAdapter(android.widget.ListAdapter ), 0, this, listAdapter);
        }

        @Override
        public CharSequence getHintText() {
            return InvokeDynamicSupport.bootstrap("getHintText", $$robo$$android_widget_Spinner_DropdownPopup$getHintText(), 0, this);
        }

        @Override
        public void setPromptText(CharSequence charSequence) {
            InvokeDynamicSupport.bootstrap("setPromptText", $$robo$$android_widget_Spinner_DropdownPopup$setPromptText(java.lang.CharSequence ), 0, this, charSequence);
        }

        void computeContentWidth() {
            InvokeDynamicSupport.bootstrap("computeContentWidth", $$robo$$android_widget_Spinner_DropdownPopup$computeContentWidth(), 0, this);
        }

        @Override
        public void show(int n, int n2) {
            InvokeDynamicSupport.bootstrap("show", $$robo$$android_widget_Spinner_DropdownPopup$show(int int ), 0, this, n, n2);
        }

        public /* synthetic */ DropdownPopup() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (DropdownPopup)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private class DialogPopup
    implements SpinnerPopup,
    DialogInterface.OnClickListener,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private AlertDialog mPopup;
        private ListAdapter mListAdapter;
        private CharSequence mPrompt;
        /* synthetic */ Spinner this$0;

        private void $$robo$$android_widget_Spinner_DialogPopup$__constructor__(Spinner spinner) {
        }

        private final void $$robo$$android_widget_Spinner_DialogPopup$dismiss() {
            if (this.mPopup != null) {
                this.mPopup.dismiss();
                this.mPopup = null;
            }
        }

        private final boolean $$robo$$android_widget_Spinner_DialogPopup$isShowing() {
            return this.mPopup != null ? this.mPopup.isShowing() : false;
        }

        private final void $$robo$$android_widget_Spinner_DialogPopup$setAdapter(ListAdapter adapter) {
            this.mListAdapter = adapter;
        }

        private final void $$robo$$android_widget_Spinner_DialogPopup$setPromptText(CharSequence hintText) {
            this.mPrompt = hintText;
        }

        private final CharSequence $$robo$$android_widget_Spinner_DialogPopup$getHintText() {
            return this.mPrompt;
        }

        private final void $$robo$$android_widget_Spinner_DialogPopup$show(int textDirection, int textAlignment) {
            if (this.mListAdapter == null) {
                return;
            }
            AlertDialog.Builder builder = new AlertDialog.Builder(this.this$0.getContext());
            if (this.mPrompt != null) {
                builder.setTitle(this.mPrompt);
            }
            this.mPopup = builder.setSingleChoiceItems(this.mListAdapter, this.this$0.getSelectedItemPosition(), (DialogInterface.OnClickListener)this).create();
            ListView listView = this.mPopup.getListView();
            listView.setTextDirection(textDirection);
            listView.setTextAlignment(textAlignment);
            this.mPopup.show();
        }

        private final void $$robo$$android_widget_Spinner_DialogPopup$onClick(DialogInterface dialog, int which) {
            this.this$0.setSelection(which);
            if (this.this$0.mOnItemClickListener != null) {
                this.this$0.performItemClick(null, which, this.mListAdapter.getItemId(which));
            }
            this.dismiss();
        }

        private final void $$robo$$android_widget_Spinner_DialogPopup$setBackgroundDrawable(Drawable bg) {
            Log.e("Spinner", "Cannot set popup background for MODE_DIALOG, ignoring");
        }

        private final void $$robo$$android_widget_Spinner_DialogPopup$setVerticalOffset(int px) {
            Log.e("Spinner", "Cannot set vertical offset for MODE_DIALOG, ignoring");
        }

        private final void $$robo$$android_widget_Spinner_DialogPopup$setHorizontalOffset(int px) {
            Log.e("Spinner", "Cannot set horizontal offset for MODE_DIALOG, ignoring");
        }

        private final Drawable $$robo$$android_widget_Spinner_DialogPopup$getBackground() {
            return null;
        }

        private final int $$robo$$android_widget_Spinner_DialogPopup$getVerticalOffset() {
            return 0;
        }

        private final int $$robo$$android_widget_Spinner_DialogPopup$getHorizontalOffset() {
            return 0;
        }

        private /* synthetic */ void $$robo$$android_widget_Spinner_DialogPopup$__constructor__(Spinner x0, 1 x1) {
        }

        private void __constructor__(Spinner spinner) {
            this.$$robo$$android_widget_Spinner_DialogPopup$__constructor__(spinner);
        }

        private DialogPopup(Spinner spinner) {
            this.this$0 = spinner;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_Spinner_DialogPopup$__constructor__(android.widget.Spinner ), 0, this, spinner);
        }

        @Override
        public void dismiss() {
            InvokeDynamicSupport.bootstrap("dismiss", $$robo$$android_widget_Spinner_DialogPopup$dismiss(), 0, this);
        }

        @Override
        public boolean isShowing() {
            return (boolean)InvokeDynamicSupport.bootstrap("isShowing", $$robo$$android_widget_Spinner_DialogPopup$isShowing(), 0, this);
        }

        @Override
        public void setAdapter(ListAdapter listAdapter) {
            InvokeDynamicSupport.bootstrap("setAdapter", $$robo$$android_widget_Spinner_DialogPopup$setAdapter(android.widget.ListAdapter ), 0, this, listAdapter);
        }

        @Override
        public void setPromptText(CharSequence charSequence) {
            InvokeDynamicSupport.bootstrap("setPromptText", $$robo$$android_widget_Spinner_DialogPopup$setPromptText(java.lang.CharSequence ), 0, this, charSequence);
        }

        @Override
        public CharSequence getHintText() {
            return InvokeDynamicSupport.bootstrap("getHintText", $$robo$$android_widget_Spinner_DialogPopup$getHintText(), 0, this);
        }

        @Override
        public void show(int n, int n2) {
            InvokeDynamicSupport.bootstrap("show", $$robo$$android_widget_Spinner_DialogPopup$show(int int ), 0, this, n, n2);
        }

        @Override
        public void onClick(DialogInterface dialogInterface, int n) {
            InvokeDynamicSupport.bootstrap("onClick", $$robo$$android_widget_Spinner_DialogPopup$onClick(android.content.DialogInterface int ), 0, this, dialogInterface, n);
        }

        @Override
        public void setBackgroundDrawable(Drawable drawable2) {
            InvokeDynamicSupport.bootstrap("setBackgroundDrawable", $$robo$$android_widget_Spinner_DialogPopup$setBackgroundDrawable(android.graphics.drawable.Drawable ), 0, this, drawable2);
        }

        @Override
        public void setVerticalOffset(int n) {
            InvokeDynamicSupport.bootstrap("setVerticalOffset", $$robo$$android_widget_Spinner_DialogPopup$setVerticalOffset(int ), 0, this, n);
        }

        @Override
        public void setHorizontalOffset(int n) {
            InvokeDynamicSupport.bootstrap("setHorizontalOffset", $$robo$$android_widget_Spinner_DialogPopup$setHorizontalOffset(int ), 0, this, n);
        }

        @Override
        public Drawable getBackground() {
            return InvokeDynamicSupport.bootstrap("getBackground", $$robo$$android_widget_Spinner_DialogPopup$getBackground(), 0, this);
        }

        @Override
        public int getVerticalOffset() {
            return (int)InvokeDynamicSupport.bootstrap("getVerticalOffset", $$robo$$android_widget_Spinner_DialogPopup$getVerticalOffset(), 0, this);
        }

        @Override
        public int getHorizontalOffset() {
            return (int)InvokeDynamicSupport.bootstrap("getHorizontalOffset", $$robo$$android_widget_Spinner_DialogPopup$getHorizontalOffset(), 0, this);
        }

        private /* synthetic */ void __constructor__(Spinner spinner, 1 var2_2) {
            this.$$robo$$android_widget_Spinner_DialogPopup$__constructor__(spinner, var2_2);
        }

        public /* synthetic */ DialogPopup() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (DialogPopup)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private static interface SpinnerPopup
    extends InstrumentedInterface {
        public void setAdapter(ListAdapter var1);

        public void show(int var1, int var2);

        public void dismiss();

        public boolean isShowing();

        public void setPromptText(CharSequence var1);

        public CharSequence getHintText();

        public void setBackgroundDrawable(Drawable var1);

        public void setVerticalOffset(int var1);

        public void setHorizontalOffset(int var1);

        public Drawable getBackground();

        public int getVerticalOffset();

        public int getHorizontalOffset();
    }

    private static class DropDownAdapter
    implements ListAdapter,
    SpinnerAdapter,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private SpinnerAdapter mAdapter;
        private ListAdapter mListAdapter;

        private void $$robo$$android_widget_Spinner_DropDownAdapter$__constructor__(SpinnerAdapter adapter) {
            this.mAdapter = adapter;
            if (adapter instanceof ListAdapter) {
                this.mListAdapter = (ListAdapter)((Object)adapter);
            }
        }

        private final int $$robo$$android_widget_Spinner_DropDownAdapter$getCount() {
            return this.mAdapter == null ? 0 : this.mAdapter.getCount();
        }

        private final Object $$robo$$android_widget_Spinner_DropDownAdapter$getItem(int position) {
            return this.mAdapter == null ? null : this.mAdapter.getItem(position);
        }

        private final long $$robo$$android_widget_Spinner_DropDownAdapter$getItemId(int position) {
            return this.mAdapter == null ? -1L : this.mAdapter.getItemId(position);
        }

        private final View $$robo$$android_widget_Spinner_DropDownAdapter$getView(int position, View convertView, ViewGroup parent) {
            return this.getDropDownView(position, convertView, parent);
        }

        private final View $$robo$$android_widget_Spinner_DropDownAdapter$getDropDownView(int position, View convertView, ViewGroup parent) {
            return this.mAdapter == null ? null : this.mAdapter.getDropDownView(position, convertView, parent);
        }

        private final boolean $$robo$$android_widget_Spinner_DropDownAdapter$hasStableIds() {
            return this.mAdapter != null && this.mAdapter.hasStableIds();
        }

        private final void $$robo$$android_widget_Spinner_DropDownAdapter$registerDataSetObserver(DataSetObserver observer) {
            if (this.mAdapter != null) {
                this.mAdapter.registerDataSetObserver(observer);
            }
        }

        private final void $$robo$$android_widget_Spinner_DropDownAdapter$unregisterDataSetObserver(DataSetObserver observer) {
            if (this.mAdapter != null) {
                this.mAdapter.unregisterDataSetObserver(observer);
            }
        }

        private final boolean $$robo$$android_widget_Spinner_DropDownAdapter$areAllItemsEnabled() {
            ListAdapter adapter = this.mListAdapter;
            if (adapter != null) {
                return adapter.areAllItemsEnabled();
            }
            return true;
        }

        private final boolean $$robo$$android_widget_Spinner_DropDownAdapter$isEnabled(int position) {
            ListAdapter adapter = this.mListAdapter;
            if (adapter != null) {
                return adapter.isEnabled(position);
            }
            return true;
        }

        private final int $$robo$$android_widget_Spinner_DropDownAdapter$getItemViewType(int position) {
            return 0;
        }

        private final int $$robo$$android_widget_Spinner_DropDownAdapter$getViewTypeCount() {
            return 1;
        }

        private final boolean $$robo$$android_widget_Spinner_DropDownAdapter$isEmpty() {
            return this.getCount() == 0;
        }

        private void __constructor__(SpinnerAdapter spinnerAdapter) {
            this.$$robo$$android_widget_Spinner_DropDownAdapter$__constructor__(spinnerAdapter);
        }

        public DropDownAdapter(SpinnerAdapter spinnerAdapter) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_Spinner_DropDownAdapter$__constructor__(android.widget.SpinnerAdapter ), 0, this, spinnerAdapter);
        }

        @Override
        public int getCount() {
            return (int)InvokeDynamicSupport.bootstrap("getCount", $$robo$$android_widget_Spinner_DropDownAdapter$getCount(), 0, this);
        }

        @Override
        public Object getItem(int n) {
            return InvokeDynamicSupport.bootstrap("getItem", $$robo$$android_widget_Spinner_DropDownAdapter$getItem(int ), 0, this, n);
        }

        @Override
        public long getItemId(int n) {
            return (long)InvokeDynamicSupport.bootstrap("getItemId", $$robo$$android_widget_Spinner_DropDownAdapter$getItemId(int ), 0, this, n);
        }

        @Override
        public View getView(int n, View view, ViewGroup viewGroup) {
            return InvokeDynamicSupport.bootstrap("getView", $$robo$$android_widget_Spinner_DropDownAdapter$getView(int android.view.View android.view.ViewGroup ), 0, this, n, view, viewGroup);
        }

        @Override
        public View getDropDownView(int n, View view, ViewGroup viewGroup) {
            return InvokeDynamicSupport.bootstrap("getDropDownView", $$robo$$android_widget_Spinner_DropDownAdapter$getDropDownView(int android.view.View android.view.ViewGroup ), 0, this, n, view, viewGroup);
        }

        @Override
        public boolean hasStableIds() {
            return (boolean)InvokeDynamicSupport.bootstrap("hasStableIds", $$robo$$android_widget_Spinner_DropDownAdapter$hasStableIds(), 0, this);
        }

        @Override
        public void registerDataSetObserver(DataSetObserver dataSetObserver) {
            InvokeDynamicSupport.bootstrap("registerDataSetObserver", $$robo$$android_widget_Spinner_DropDownAdapter$registerDataSetObserver(android.database.DataSetObserver ), 0, this, dataSetObserver);
        }

        @Override
        public void unregisterDataSetObserver(DataSetObserver dataSetObserver) {
            InvokeDynamicSupport.bootstrap("unregisterDataSetObserver", $$robo$$android_widget_Spinner_DropDownAdapter$unregisterDataSetObserver(android.database.DataSetObserver ), 0, this, dataSetObserver);
        }

        @Override
        public boolean areAllItemsEnabled() {
            return (boolean)InvokeDynamicSupport.bootstrap("areAllItemsEnabled", $$robo$$android_widget_Spinner_DropDownAdapter$areAllItemsEnabled(), 0, this);
        }

        @Override
        public boolean isEnabled(int n) {
            return (boolean)InvokeDynamicSupport.bootstrap("isEnabled", $$robo$$android_widget_Spinner_DropDownAdapter$isEnabled(int ), 0, this, n);
        }

        @Override
        public int getItemViewType(int n) {
            return (int)InvokeDynamicSupport.bootstrap("getItemViewType", $$robo$$android_widget_Spinner_DropDownAdapter$getItemViewType(int ), 0, this, n);
        }

        @Override
        public int getViewTypeCount() {
            return (int)InvokeDynamicSupport.bootstrap("getViewTypeCount", $$robo$$android_widget_Spinner_DropDownAdapter$getViewTypeCount(), 0, this);
        }

        @Override
        public boolean isEmpty() {
            return (boolean)InvokeDynamicSupport.bootstrap("isEmpty", $$robo$$android_widget_Spinner_DropDownAdapter$isEmpty(), 0, this);
        }

        public /* synthetic */ DropDownAdapter() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (DropDownAdapter)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class SavedState
    extends AbsSpinner.SavedState
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        boolean showDropdown;
        public static Parcelable.Creator<SavedState> CREATOR;

        private void $$robo$$android_widget_Spinner_SavedState$__constructor__(Parcelable superState) {
        }

        private void $$robo$$android_widget_Spinner_SavedState$__constructor__(Parcel in) {
            this.showDropdown = in.readByte() != 0;
        }

        private final void $$robo$$android_widget_Spinner_SavedState$writeToParcel(Parcel out, int flags) {
            super.writeToParcel(out, flags);
            out.writeByte((byte)(this.showDropdown ? 1 : 0));
        }

        private /* synthetic */ void $$robo$$android_widget_Spinner_SavedState$__constructor__(Parcel x0, 1 x1) {
        }

        static void __staticInitializer__() {
            CREATOR = new Parcelable.Creator<SavedState>(){
                public transient /* synthetic */ Object __robo_data__;

                private void $$robo$$android_widget_Spinner_SavedState_1$__constructor__() {
                }

                private final SavedState $$robo$$android_widget_Spinner_SavedState_1$createFromParcel(Parcel in) {
                    return new SavedState(in);
                }

                private final SavedState[] $$robo$$android_widget_Spinner_SavedState_1$newArray(int size) {
                    return new SavedState[size];
                }

                private void __constructor__() {
                    this.$$robo$$android_widget_Spinner_SavedState_1$__constructor__();
                }
                {
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_Spinner_SavedState_1$__constructor__(), 0, this);
                }

                @Override
                public SavedState createFromParcel(Parcel parcel) {
                    return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_widget_Spinner_SavedState_1$createFromParcel(android.os.Parcel ), 0, this, parcel);
                }

                public SavedState[] newArray(int n) {
                    return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_widget_Spinner_SavedState_1$newArray(int ), 0, this, n);
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            };
        }

        private void __constructor__(Parcelable parcelable) {
            this.$$robo$$android_widget_Spinner_SavedState$__constructor__(parcelable);
        }

        SavedState(Parcelable parcelable) {
            super(parcelable);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_Spinner_SavedState$__constructor__(android.os.Parcelable ), 0, this, parcelable);
        }

        private void __constructor__(Parcel parcel) {
            this.$$robo$$android_widget_Spinner_SavedState$__constructor__(parcel);
        }

        private SavedState(Parcel parcel) {
            super(parcel);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_Spinner_SavedState$__constructor__(android.os.Parcel ), 0, this, parcel);
        }

        @Override
        public void writeToParcel(Parcel parcel, int n) {
            InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_widget_Spinner_SavedState$writeToParcel(android.os.Parcel int ), 0, this, parcel, n);
        }

        private /* synthetic */ void __constructor__(Parcel parcel, 1 var2_2) {
            this.$$robo$$android_widget_Spinner_SavedState$__constructor__(parcel, var2_2);
        }

        static {
            RobolectricInternals.classInitializing(SavedState.class);
        }

        public /* synthetic */ SavedState() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SavedState)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

