/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.app.LocalActivityManager;
import android.content.Context;
import android.content.Intent;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.view.Window;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityNodeInfo;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.TabWidget;
import android.widget.TextView;
import com.android.internal.R;
import java.util.ArrayList;
import java.util.List;
import org.robolectric.internal.bytecode.InstrumentedInterface;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class TabHost
extends FrameLayout
implements ViewTreeObserver.OnTouchModeChangeListener,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static int TABWIDGET_LOCATION_LEFT = 0;
    private static int TABWIDGET_LOCATION_TOP = 1;
    private static int TABWIDGET_LOCATION_RIGHT = 2;
    private static int TABWIDGET_LOCATION_BOTTOM = 3;
    private TabWidget mTabWidget;
    private FrameLayout mTabContent;
    private List<TabSpec> mTabSpecs;
    protected int mCurrentTab;
    private View mCurrentView;
    protected LocalActivityManager mLocalActivityManager;
    private OnTabChangeListener mOnTabChangeListener;
    private View.OnKeyListener mTabKeyListener;
    private int mTabLayoutId;

    private void $$robo$$android_widget_TabHost$__constructor__(Context context) {
        this.mTabSpecs = new ArrayList<TabSpec>(2);
        this.mCurrentTab = -1;
        this.mCurrentView = null;
        this.mLocalActivityManager = null;
        this.initTabHost();
    }

    private void $$robo$$android_widget_TabHost$__constructor__(Context context, AttributeSet attrs) {
    }

    private void $$robo$$android_widget_TabHost$__constructor__(Context context, AttributeSet attrs, int defStyleAttr) {
    }

    private void $$robo$$android_widget_TabHost$__constructor__(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        this.mTabSpecs = new ArrayList<TabSpec>(2);
        this.mCurrentTab = -1;
        this.mCurrentView = null;
        this.mLocalActivityManager = null;
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.TabWidget, defStyleAttr, defStyleRes);
        this.mTabLayoutId = a.getResourceId(4, 0);
        a.recycle();
        if (this.mTabLayoutId == 0) {
            this.mTabLayoutId = 17367251;
        }
        this.initTabHost();
    }

    private final void $$robo$$android_widget_TabHost$initTabHost() {
        this.setFocusableInTouchMode(true);
        this.setDescendantFocusability(262144);
        this.mCurrentTab = -1;
        this.mCurrentView = null;
    }

    private final TabSpec $$robo$$android_widget_TabHost$newTabSpec(String tag) {
        return new TabSpec(this, tag);
    }

    private final void $$robo$$android_widget_TabHost$setup() {
        this.mTabWidget = (TabWidget)this.findViewById(16908307);
        if (this.mTabWidget == null) {
            throw new RuntimeException("Your TabHost must have a TabWidget whose id attribute is 'android.R.id.tabs'");
        }
        this.mTabKeyListener = new View.OnKeyListener(this){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ TabHost this$0;

            private void $$robo$$android_widget_TabHost_1$__constructor__(TabHost tabHost) {
            }

            private final boolean $$robo$$android_widget_TabHost_1$onKey(View v, int keyCode, KeyEvent event) {
                switch (keyCode) {
                    case 19: 
                    case 20: 
                    case 21: 
                    case 22: 
                    case 23: 
                    case 66: {
                        return false;
                    }
                }
                this.this$0.mTabContent.requestFocus(2);
                return this.this$0.mTabContent.dispatchKeyEvent(event);
            }

            private void __constructor__(TabHost tabHost) {
                this.$$robo$$android_widget_TabHost_1$__constructor__(tabHost);
            }
            {
                this.this$0 = tabHost;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_TabHost_1$__constructor__(android.widget.TabHost ), 0, this, tabHost);
            }

            @Override
            public boolean onKey(View view, int n, KeyEvent keyEvent) {
                return (boolean)InvokeDynamicSupport.bootstrap("onKey", $$robo$$android_widget_TabHost_1$onKey(android.view.View int android.view.KeyEvent ), 0, this, view, n, keyEvent);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.mTabWidget.setTabSelectionListener(new TabWidget.OnTabSelectionChanged(this){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ TabHost this$0;

            private void $$robo$$android_widget_TabHost_2$__constructor__(TabHost tabHost) {
            }

            private final void $$robo$$android_widget_TabHost_2$onTabSelectionChanged(int tabIndex, boolean clicked) {
                this.this$0.setCurrentTab(tabIndex);
                if (clicked) {
                    this.this$0.mTabContent.requestFocus(2);
                }
            }

            private void __constructor__(TabHost tabHost) {
                this.$$robo$$android_widget_TabHost_2$__constructor__(tabHost);
            }
            {
                this.this$0 = tabHost;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_TabHost_2$__constructor__(android.widget.TabHost ), 0, this, tabHost);
            }

            @Override
            public void onTabSelectionChanged(int n, boolean bl) {
                InvokeDynamicSupport.bootstrap("onTabSelectionChanged", $$robo$$android_widget_TabHost_2$onTabSelectionChanged(int boolean ), 0, this, n, bl);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        });
        this.mTabContent = (FrameLayout)this.findViewById(0x1020011);
        if (this.mTabContent == null) {
            throw new RuntimeException("Your TabHost must have a FrameLayout whose id attribute is 'android.R.id.tabcontent'");
        }
    }

    private final void $$robo$$android_widget_TabHost$sendAccessibilityEvent(int eventType) {
    }

    private final void $$robo$$android_widget_TabHost$setup(LocalActivityManager activityGroup) {
        this.setup();
        this.mLocalActivityManager = activityGroup;
    }

    private final void $$robo$$android_widget_TabHost$onAttachedToWindow() {
        super.onAttachedToWindow();
        ViewTreeObserver treeObserver = this.getViewTreeObserver();
        treeObserver.addOnTouchModeChangeListener(this);
    }

    private final void $$robo$$android_widget_TabHost$onDetachedFromWindow() {
        super.onDetachedFromWindow();
        ViewTreeObserver treeObserver = this.getViewTreeObserver();
        treeObserver.removeOnTouchModeChangeListener(this);
    }

    private final void $$robo$$android_widget_TabHost$onTouchModeChanged(boolean isInTouchMode) {
        if (!(isInTouchMode || this.mCurrentView == null || this.mCurrentView.hasFocus() && !this.mCurrentView.isFocused())) {
            this.mTabWidget.getChildTabViewAt(this.mCurrentTab).requestFocus();
        }
    }

    private final void $$robo$$android_widget_TabHost$addTab(TabSpec tabSpec) {
        if (tabSpec.mIndicatorStrategy == null) {
            throw new IllegalArgumentException("you must specify a way to create the tab indicator.");
        }
        if (tabSpec.mContentStrategy == null) {
            throw new IllegalArgumentException("you must specify a way to create the tab content");
        }
        View tabIndicator = tabSpec.mIndicatorStrategy.createIndicatorView();
        tabIndicator.setOnKeyListener(this.mTabKeyListener);
        if (tabSpec.mIndicatorStrategy instanceof ViewIndicatorStrategy) {
            this.mTabWidget.setStripEnabled(false);
        }
        this.mTabWidget.addView(tabIndicator);
        this.mTabSpecs.add(tabSpec);
        if (this.mCurrentTab == -1) {
            this.setCurrentTab(0);
        }
    }

    private final void $$robo$$android_widget_TabHost$clearAllTabs() {
        this.mTabWidget.removeAllViews();
        this.initTabHost();
        this.mTabContent.removeAllViews();
        this.mTabSpecs.clear();
        this.requestLayout();
        this.invalidate();
    }

    private final TabWidget $$robo$$android_widget_TabHost$getTabWidget() {
        return this.mTabWidget;
    }

    private final int $$robo$$android_widget_TabHost$getCurrentTab() {
        return this.mCurrentTab;
    }

    private final String $$robo$$android_widget_TabHost$getCurrentTabTag() {
        if (this.mCurrentTab >= 0 && this.mCurrentTab < this.mTabSpecs.size()) {
            return this.mTabSpecs.get(this.mCurrentTab).getTag();
        }
        return null;
    }

    private final View $$robo$$android_widget_TabHost$getCurrentTabView() {
        if (this.mCurrentTab >= 0 && this.mCurrentTab < this.mTabSpecs.size()) {
            return this.mTabWidget.getChildTabViewAt(this.mCurrentTab);
        }
        return null;
    }

    private final View $$robo$$android_widget_TabHost$getCurrentView() {
        return this.mCurrentView;
    }

    private final void $$robo$$android_widget_TabHost$setCurrentTabByTag(String tag) {
        for (int i = 0; i < this.mTabSpecs.size(); ++i) {
            if (!this.mTabSpecs.get(i).getTag().equals(tag)) continue;
            this.setCurrentTab(i);
            break;
        }
    }

    private final FrameLayout $$robo$$android_widget_TabHost$getTabContentView() {
        return this.mTabContent;
    }

    private final int $$robo$$android_widget_TabHost$getTabWidgetLocation() {
        int location = 1;
        switch (this.mTabWidget.getOrientation()) {
            case 1: {
                location = this.mTabContent.getLeft() < this.mTabWidget.getLeft() ? 2 : 0;
                break;
            }
            default: {
                location = this.mTabContent.getTop() < this.mTabWidget.getTop() ? 3 : 1;
            }
        }
        return location;
    }

    private final boolean $$robo$$android_widget_TabHost$dispatchKeyEvent(KeyEvent event) {
        boolean handled = super.dispatchKeyEvent(event);
        if (!handled && event.getAction() == 0 && this.mCurrentView != null && this.mCurrentView.isRootNamespace() && this.mCurrentView.hasFocus()) {
            int keyCodeShouldChangeFocus = 19;
            int directionShouldChangeFocus = 33;
            int soundEffect = 2;
            switch (this.getTabWidgetLocation()) {
                case 0: {
                    keyCodeShouldChangeFocus = 21;
                    directionShouldChangeFocus = 17;
                    soundEffect = 1;
                    break;
                }
                case 2: {
                    keyCodeShouldChangeFocus = 22;
                    directionShouldChangeFocus = 66;
                    soundEffect = 3;
                    break;
                }
                case 3: {
                    keyCodeShouldChangeFocus = 20;
                    directionShouldChangeFocus = 130;
                    soundEffect = 4;
                    break;
                }
                default: {
                    keyCodeShouldChangeFocus = 19;
                    directionShouldChangeFocus = 33;
                    soundEffect = 2;
                }
            }
            if (event.getKeyCode() == keyCodeShouldChangeFocus && this.mCurrentView.findFocus().focusSearch(directionShouldChangeFocus) == null) {
                this.mTabWidget.getChildTabViewAt(this.mCurrentTab).requestFocus();
                this.playSoundEffect(soundEffect);
                return true;
            }
        }
        return handled;
    }

    private final void $$robo$$android_widget_TabHost$dispatchWindowFocusChanged(boolean hasFocus) {
        if (this.mCurrentView != null) {
            this.mCurrentView.dispatchWindowFocusChanged(hasFocus);
        }
    }

    private final void $$robo$$android_widget_TabHost$onInitializeAccessibilityEvent(AccessibilityEvent event) {
        super.onInitializeAccessibilityEvent(event);
        event.setClassName(TabHost.class.getName());
    }

    private final void $$robo$$android_widget_TabHost$onInitializeAccessibilityNodeInfo(AccessibilityNodeInfo info) {
        super.onInitializeAccessibilityNodeInfo(info);
        info.setClassName(TabHost.class.getName());
    }

    private final void $$robo$$android_widget_TabHost$setCurrentTab(int index) {
        if (index < 0 || index >= this.mTabSpecs.size()) {
            return;
        }
        if (index == this.mCurrentTab) {
            return;
        }
        if (this.mCurrentTab != -1) {
            this.mTabSpecs.get(this.mCurrentTab).mContentStrategy.tabClosed();
        }
        this.mCurrentTab = index;
        TabSpec spec = this.mTabSpecs.get(index);
        this.mTabWidget.focusCurrentTab(this.mCurrentTab);
        this.mCurrentView = spec.mContentStrategy.getContentView();
        if (this.mCurrentView.getParent() == null) {
            this.mTabContent.addView(this.mCurrentView, new ViewGroup.LayoutParams(-1, -1));
        }
        if (!this.mTabWidget.hasFocus()) {
            this.mCurrentView.requestFocus();
        }
        this.invokeOnTabChangeListener();
    }

    private final void $$robo$$android_widget_TabHost$setOnTabChangedListener(OnTabChangeListener l) {
        this.mOnTabChangeListener = l;
    }

    private final void $$robo$$android_widget_TabHost$invokeOnTabChangeListener() {
        if (this.mOnTabChangeListener != null) {
            this.mOnTabChangeListener.onTabChanged(this.getCurrentTabTag());
        }
    }

    private void __constructor__(Context context) {
        this.$$robo$$android_widget_TabHost$__constructor__(context);
    }

    public TabHost(Context context) {
        super(context);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_TabHost$__constructor__(android.content.Context ), 0, this, context);
    }

    private void __constructor__(Context context, AttributeSet attributeSet) {
        this.$$robo$$android_widget_TabHost$__constructor__(context, attributeSet);
    }

    public TabHost(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 16842883);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_TabHost$__constructor__(android.content.Context android.util.AttributeSet ), 0, this, context, attributeSet);
    }

    private void __constructor__(Context context, AttributeSet attributeSet, int n) {
        this.$$robo$$android_widget_TabHost$__constructor__(context, attributeSet, n);
    }

    public TabHost(Context context, AttributeSet attributeSet, int n) {
        this(context, attributeSet, n, 0);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_TabHost$__constructor__(android.content.Context android.util.AttributeSet int ), 0, this, context, attributeSet, n);
    }

    private void __constructor__(Context context, AttributeSet attributeSet, int n, int n2) {
        this.$$robo$$android_widget_TabHost$__constructor__(context, attributeSet, n, n2);
    }

    public TabHost(Context context, AttributeSet attributeSet, int n, int n2) {
        super(context, attributeSet);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_TabHost$__constructor__(android.content.Context android.util.AttributeSet int int ), 0, this, context, attributeSet, n, n2);
    }

    private void initTabHost() {
        InvokeDynamicSupport.bootstrap("initTabHost", $$robo$$android_widget_TabHost$initTabHost(), 0, this);
    }

    public TabSpec newTabSpec(String string2) {
        return InvokeDynamicSupport.bootstrap("newTabSpec", $$robo$$android_widget_TabHost$newTabSpec(java.lang.String ), 0, this, string2);
    }

    public void setup() {
        InvokeDynamicSupport.bootstrap("setup", $$robo$$android_widget_TabHost$setup(), 0, this);
    }

    @Override
    public void sendAccessibilityEvent(int n) {
        InvokeDynamicSupport.bootstrap("sendAccessibilityEvent", $$robo$$android_widget_TabHost$sendAccessibilityEvent(int ), 0, this, n);
    }

    public void setup(LocalActivityManager localActivityManager) {
        InvokeDynamicSupport.bootstrap("setup", $$robo$$android_widget_TabHost$setup(android.app.LocalActivityManager ), 0, this, localActivityManager);
    }

    @Override
    protected void onAttachedToWindow() {
        InvokeDynamicSupport.bootstrap("onAttachedToWindow", $$robo$$android_widget_TabHost$onAttachedToWindow(), 0, this);
    }

    @Override
    protected void onDetachedFromWindow() {
        InvokeDynamicSupport.bootstrap("onDetachedFromWindow", $$robo$$android_widget_TabHost$onDetachedFromWindow(), 0, this);
    }

    @Override
    public void onTouchModeChanged(boolean bl) {
        InvokeDynamicSupport.bootstrap("onTouchModeChanged", $$robo$$android_widget_TabHost$onTouchModeChanged(boolean ), 0, this, bl);
    }

    public void addTab(TabSpec tabSpec) {
        InvokeDynamicSupport.bootstrap("addTab", $$robo$$android_widget_TabHost$addTab(android.widget.TabHost$TabSpec ), 0, this, tabSpec);
    }

    public void clearAllTabs() {
        InvokeDynamicSupport.bootstrap("clearAllTabs", $$robo$$android_widget_TabHost$clearAllTabs(), 0, this);
    }

    public TabWidget getTabWidget() {
        return InvokeDynamicSupport.bootstrap("getTabWidget", $$robo$$android_widget_TabHost$getTabWidget(), 0, this);
    }

    public int getCurrentTab() {
        return (int)InvokeDynamicSupport.bootstrap("getCurrentTab", $$robo$$android_widget_TabHost$getCurrentTab(), 0, this);
    }

    public String getCurrentTabTag() {
        return InvokeDynamicSupport.bootstrap("getCurrentTabTag", $$robo$$android_widget_TabHost$getCurrentTabTag(), 0, this);
    }

    public View getCurrentTabView() {
        return InvokeDynamicSupport.bootstrap("getCurrentTabView", $$robo$$android_widget_TabHost$getCurrentTabView(), 0, this);
    }

    public View getCurrentView() {
        return InvokeDynamicSupport.bootstrap("getCurrentView", $$robo$$android_widget_TabHost$getCurrentView(), 0, this);
    }

    public void setCurrentTabByTag(String string2) {
        InvokeDynamicSupport.bootstrap("setCurrentTabByTag", $$robo$$android_widget_TabHost$setCurrentTabByTag(java.lang.String ), 0, this, string2);
    }

    public FrameLayout getTabContentView() {
        return InvokeDynamicSupport.bootstrap("getTabContentView", $$robo$$android_widget_TabHost$getTabContentView(), 0, this);
    }

    private int getTabWidgetLocation() {
        return (int)InvokeDynamicSupport.bootstrap("getTabWidgetLocation", $$robo$$android_widget_TabHost$getTabWidgetLocation(), 0, this);
    }

    @Override
    public boolean dispatchKeyEvent(KeyEvent keyEvent) {
        return (boolean)InvokeDynamicSupport.bootstrap("dispatchKeyEvent", $$robo$$android_widget_TabHost$dispatchKeyEvent(android.view.KeyEvent ), 0, this, keyEvent);
    }

    @Override
    public void dispatchWindowFocusChanged(boolean bl) {
        InvokeDynamicSupport.bootstrap("dispatchWindowFocusChanged", $$robo$$android_widget_TabHost$dispatchWindowFocusChanged(boolean ), 0, this, bl);
    }

    @Override
    public void onInitializeAccessibilityEvent(AccessibilityEvent accessibilityEvent) {
        InvokeDynamicSupport.bootstrap("onInitializeAccessibilityEvent", $$robo$$android_widget_TabHost$onInitializeAccessibilityEvent(android.view.accessibility.AccessibilityEvent ), 0, this, accessibilityEvent);
    }

    @Override
    public void onInitializeAccessibilityNodeInfo(AccessibilityNodeInfo accessibilityNodeInfo) {
        InvokeDynamicSupport.bootstrap("onInitializeAccessibilityNodeInfo", $$robo$$android_widget_TabHost$onInitializeAccessibilityNodeInfo(android.view.accessibility.AccessibilityNodeInfo ), 0, this, accessibilityNodeInfo);
    }

    public void setCurrentTab(int n) {
        InvokeDynamicSupport.bootstrap("setCurrentTab", $$robo$$android_widget_TabHost$setCurrentTab(int ), 0, this, n);
    }

    public void setOnTabChangedListener(OnTabChangeListener onTabChangeListener) {
        InvokeDynamicSupport.bootstrap("setOnTabChangedListener", $$robo$$android_widget_TabHost$setOnTabChangedListener(android.widget.TabHost$OnTabChangeListener ), 0, this, onTabChangeListener);
    }

    private void invokeOnTabChangeListener() {
        InvokeDynamicSupport.bootstrap("invokeOnTabChangeListener", $$robo$$android_widget_TabHost$invokeOnTabChangeListener(), 0, this);
    }

    public /* synthetic */ TabHost() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (TabHost)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    private class IntentContentStrategy
    implements ContentStrategy,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private String mTag;
        private Intent mIntent;
        private View mLaunchedView;
        /* synthetic */ TabHost this$0;

        private void $$robo$$android_widget_TabHost_IntentContentStrategy$__constructor__(TabHost tabHost, String tag, Intent intent) {
            this.mTag = tag;
            this.mIntent = intent;
        }

        private final View $$robo$$android_widget_TabHost_IntentContentStrategy$getContentView() {
            View wd;
            if (this.this$0.mLocalActivityManager == null) {
                throw new IllegalStateException("Did you forget to call 'public void setup(LocalActivityManager activityGroup)'?");
            }
            Window w = this.this$0.mLocalActivityManager.startActivity(this.mTag, this.mIntent);
            View view = wd = w != null ? w.getDecorView() : null;
            if (this.mLaunchedView != wd && this.mLaunchedView != null && this.mLaunchedView.getParent() != null) {
                this.this$0.mTabContent.removeView(this.mLaunchedView);
            }
            this.mLaunchedView = wd;
            if (this.mLaunchedView != null) {
                this.mLaunchedView.setVisibility(0);
                this.mLaunchedView.setFocusableInTouchMode(true);
                ((ViewGroup)this.mLaunchedView).setDescendantFocusability(262144);
            }
            return this.mLaunchedView;
        }

        private final void $$robo$$android_widget_TabHost_IntentContentStrategy$tabClosed() {
            if (this.mLaunchedView != null) {
                this.mLaunchedView.setVisibility(8);
            }
        }

        private /* synthetic */ void $$robo$$android_widget_TabHost_IntentContentStrategy$__constructor__(TabHost x0, String x1, Intent x2, 1 x3) {
        }

        private void __constructor__(TabHost tabHost, String string2, Intent intent) {
            this.$$robo$$android_widget_TabHost_IntentContentStrategy$__constructor__(tabHost, string2, intent);
        }

        private IntentContentStrategy(TabHost tabHost, String string2, Intent intent) {
            this.this$0 = tabHost;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_TabHost_IntentContentStrategy$__constructor__(android.widget.TabHost java.lang.String android.content.Intent ), 0, this, tabHost, string2, intent);
        }

        @Override
        public View getContentView() {
            return InvokeDynamicSupport.bootstrap("getContentView", $$robo$$android_widget_TabHost_IntentContentStrategy$getContentView(), 0, this);
        }

        @Override
        public void tabClosed() {
            InvokeDynamicSupport.bootstrap("tabClosed", $$robo$$android_widget_TabHost_IntentContentStrategy$tabClosed(), 0, this);
        }

        private /* synthetic */ void __constructor__(TabHost tabHost, String string2, Intent intent, 1 var4_4) {
            this.$$robo$$android_widget_TabHost_IntentContentStrategy$__constructor__(tabHost, string2, intent, var4_4);
        }

        public /* synthetic */ IntentContentStrategy() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (IntentContentStrategy)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private class FactoryContentStrategy
    implements ContentStrategy,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private View mTabContent;
        private CharSequence mTag;
        private TabContentFactory mFactory;
        /* synthetic */ TabHost this$0;

        private void $$robo$$android_widget_TabHost_FactoryContentStrategy$__constructor__(TabHost tabHost, CharSequence tag, TabContentFactory factory) {
            this.mTag = tag;
            this.mFactory = factory;
        }

        private final View $$robo$$android_widget_TabHost_FactoryContentStrategy$getContentView() {
            if (this.mTabContent == null) {
                this.mTabContent = this.mFactory.createTabContent(this.mTag.toString());
            }
            this.mTabContent.setVisibility(0);
            return this.mTabContent;
        }

        private final void $$robo$$android_widget_TabHost_FactoryContentStrategy$tabClosed() {
            this.mTabContent.setVisibility(8);
        }

        private void __constructor__(TabHost tabHost, CharSequence charSequence, TabContentFactory tabContentFactory) {
            this.$$robo$$android_widget_TabHost_FactoryContentStrategy$__constructor__(tabHost, charSequence, tabContentFactory);
        }

        public FactoryContentStrategy(TabHost tabHost, CharSequence charSequence, TabContentFactory tabContentFactory) {
            this.this$0 = tabHost;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_TabHost_FactoryContentStrategy$__constructor__(android.widget.TabHost java.lang.CharSequence android.widget.TabHost$TabContentFactory ), 0, this, tabHost, charSequence, tabContentFactory);
        }

        @Override
        public View getContentView() {
            return InvokeDynamicSupport.bootstrap("getContentView", $$robo$$android_widget_TabHost_FactoryContentStrategy$getContentView(), 0, this);
        }

        @Override
        public void tabClosed() {
            InvokeDynamicSupport.bootstrap("tabClosed", $$robo$$android_widget_TabHost_FactoryContentStrategy$tabClosed(), 0, this);
        }

        public /* synthetic */ FactoryContentStrategy() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (FactoryContentStrategy)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private class ViewIdContentStrategy
    implements ContentStrategy,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private View mView;
        /* synthetic */ TabHost this$0;

        private void $$robo$$android_widget_TabHost_ViewIdContentStrategy$__constructor__(TabHost tabHost, int viewId) {
            this.mView = tabHost.mTabContent.findViewById(viewId);
            if (this.mView == null) {
                throw new RuntimeException("Could not create tab content because could not find view with id " + viewId);
            }
            this.mView.setVisibility(8);
        }

        private final View $$robo$$android_widget_TabHost_ViewIdContentStrategy$getContentView() {
            this.mView.setVisibility(0);
            return this.mView;
        }

        private final void $$robo$$android_widget_TabHost_ViewIdContentStrategy$tabClosed() {
            this.mView.setVisibility(8);
        }

        private /* synthetic */ void $$robo$$android_widget_TabHost_ViewIdContentStrategy$__constructor__(TabHost x0, int x1, 1 x2) {
        }

        private void __constructor__(TabHost tabHost, int n) {
            this.$$robo$$android_widget_TabHost_ViewIdContentStrategy$__constructor__(tabHost, n);
        }

        private ViewIdContentStrategy(TabHost tabHost, int n) {
            this.this$0 = tabHost;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_TabHost_ViewIdContentStrategy$__constructor__(android.widget.TabHost int ), 0, this, tabHost, n);
        }

        @Override
        public View getContentView() {
            return InvokeDynamicSupport.bootstrap("getContentView", $$robo$$android_widget_TabHost_ViewIdContentStrategy$getContentView(), 0, this);
        }

        @Override
        public void tabClosed() {
            InvokeDynamicSupport.bootstrap("tabClosed", $$robo$$android_widget_TabHost_ViewIdContentStrategy$tabClosed(), 0, this);
        }

        private /* synthetic */ void __constructor__(TabHost tabHost, int n, 1 var3_3) {
            this.$$robo$$android_widget_TabHost_ViewIdContentStrategy$__constructor__(tabHost, n, var3_3);
        }

        public /* synthetic */ ViewIdContentStrategy() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ViewIdContentStrategy)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private class ViewIndicatorStrategy
    implements IndicatorStrategy,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private View mView;
        /* synthetic */ TabHost this$0;

        private void $$robo$$android_widget_TabHost_ViewIndicatorStrategy$__constructor__(TabHost tabHost, View view) {
            this.mView = view;
        }

        private final View $$robo$$android_widget_TabHost_ViewIndicatorStrategy$createIndicatorView() {
            return this.mView;
        }

        private /* synthetic */ void $$robo$$android_widget_TabHost_ViewIndicatorStrategy$__constructor__(TabHost x0, View x1, 1 x2) {
        }

        private void __constructor__(TabHost tabHost, View view) {
            this.$$robo$$android_widget_TabHost_ViewIndicatorStrategy$__constructor__(tabHost, view);
        }

        private ViewIndicatorStrategy(TabHost tabHost, View view) {
            this.this$0 = tabHost;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_TabHost_ViewIndicatorStrategy$__constructor__(android.widget.TabHost android.view.View ), 0, this, tabHost, view);
        }

        @Override
        public View createIndicatorView() {
            return InvokeDynamicSupport.bootstrap("createIndicatorView", $$robo$$android_widget_TabHost_ViewIndicatorStrategy$createIndicatorView(), 0, this);
        }

        private /* synthetic */ void __constructor__(TabHost tabHost, View view, 1 var3_3) {
            this.$$robo$$android_widget_TabHost_ViewIndicatorStrategy$__constructor__(tabHost, view, var3_3);
        }

        public /* synthetic */ ViewIndicatorStrategy() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ViewIndicatorStrategy)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private class LabelAndIconIndicatorStrategy
    implements IndicatorStrategy,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private CharSequence mLabel;
        private Drawable mIcon;
        /* synthetic */ TabHost this$0;

        private void $$robo$$android_widget_TabHost_LabelAndIconIndicatorStrategy$__constructor__(TabHost tabHost, CharSequence label, Drawable icon) {
            this.mLabel = label;
            this.mIcon = icon;
        }

        private final View $$robo$$android_widget_TabHost_LabelAndIconIndicatorStrategy$createIndicatorView() {
            Context context = this.this$0.getContext();
            LayoutInflater inflater = (LayoutInflater)context.getSystemService("layout_inflater");
            View tabIndicator = inflater.inflate(this.this$0.mTabLayoutId, (ViewGroup)this.this$0.mTabWidget, false);
            TextView tv = (TextView)tabIndicator.findViewById(16908310);
            ImageView iconView = (ImageView)tabIndicator.findViewById(16908294);
            boolean exclusive = iconView.getVisibility() == 8;
            boolean bindIcon = !exclusive || TextUtils.isEmpty(this.mLabel);
            tv.setText(this.mLabel);
            if (bindIcon && this.mIcon != null) {
                iconView.setImageDrawable(this.mIcon);
                iconView.setVisibility(0);
            }
            if (context.getApplicationInfo().targetSdkVersion <= 4) {
                tabIndicator.setBackgroundResource(17303275);
                tv.setTextColor(context.getResources().getColorStateList(17170732));
            }
            return tabIndicator;
        }

        private /* synthetic */ void $$robo$$android_widget_TabHost_LabelAndIconIndicatorStrategy$__constructor__(TabHost x0, CharSequence x1, Drawable x2, 1 x3) {
        }

        private void __constructor__(TabHost tabHost, CharSequence charSequence, Drawable drawable2) {
            this.$$robo$$android_widget_TabHost_LabelAndIconIndicatorStrategy$__constructor__(tabHost, charSequence, drawable2);
        }

        private LabelAndIconIndicatorStrategy(TabHost tabHost, CharSequence charSequence, Drawable drawable2) {
            this.this$0 = tabHost;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_TabHost_LabelAndIconIndicatorStrategy$__constructor__(android.widget.TabHost java.lang.CharSequence android.graphics.drawable.Drawable ), 0, this, tabHost, charSequence, drawable2);
        }

        @Override
        public View createIndicatorView() {
            return InvokeDynamicSupport.bootstrap("createIndicatorView", $$robo$$android_widget_TabHost_LabelAndIconIndicatorStrategy$createIndicatorView(), 0, this);
        }

        private /* synthetic */ void __constructor__(TabHost tabHost, CharSequence charSequence, Drawable drawable2, 1 var4_4) {
            this.$$robo$$android_widget_TabHost_LabelAndIconIndicatorStrategy$__constructor__(tabHost, charSequence, drawable2, var4_4);
        }

        public /* synthetic */ LabelAndIconIndicatorStrategy() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (LabelAndIconIndicatorStrategy)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private class LabelIndicatorStrategy
    implements IndicatorStrategy,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private CharSequence mLabel;
        /* synthetic */ TabHost this$0;

        private void $$robo$$android_widget_TabHost_LabelIndicatorStrategy$__constructor__(TabHost tabHost, CharSequence label) {
            this.mLabel = label;
        }

        private final View $$robo$$android_widget_TabHost_LabelIndicatorStrategy$createIndicatorView() {
            Context context = this.this$0.getContext();
            LayoutInflater inflater = (LayoutInflater)context.getSystemService("layout_inflater");
            View tabIndicator = inflater.inflate(this.this$0.mTabLayoutId, (ViewGroup)this.this$0.mTabWidget, false);
            TextView tv = (TextView)tabIndicator.findViewById(16908310);
            tv.setText(this.mLabel);
            if (context.getApplicationInfo().targetSdkVersion <= 4) {
                tabIndicator.setBackgroundResource(17303275);
                tv.setTextColor(context.getResources().getColorStateList(17170732));
            }
            return tabIndicator;
        }

        private /* synthetic */ void $$robo$$android_widget_TabHost_LabelIndicatorStrategy$__constructor__(TabHost x0, CharSequence x1, 1 x2) {
        }

        private void __constructor__(TabHost tabHost, CharSequence charSequence) {
            this.$$robo$$android_widget_TabHost_LabelIndicatorStrategy$__constructor__(tabHost, charSequence);
        }

        private LabelIndicatorStrategy(TabHost tabHost, CharSequence charSequence) {
            this.this$0 = tabHost;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_TabHost_LabelIndicatorStrategy$__constructor__(android.widget.TabHost java.lang.CharSequence ), 0, this, tabHost, charSequence);
        }

        @Override
        public View createIndicatorView() {
            return InvokeDynamicSupport.bootstrap("createIndicatorView", $$robo$$android_widget_TabHost_LabelIndicatorStrategy$createIndicatorView(), 0, this);
        }

        private /* synthetic */ void __constructor__(TabHost tabHost, CharSequence charSequence, 1 var3_3) {
            this.$$robo$$android_widget_TabHost_LabelIndicatorStrategy$__constructor__(tabHost, charSequence, var3_3);
        }

        public /* synthetic */ LabelIndicatorStrategy() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (LabelIndicatorStrategy)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private static interface ContentStrategy
    extends InstrumentedInterface {
        public View getContentView();

        public void tabClosed();
    }

    private static interface IndicatorStrategy
    extends InstrumentedInterface {
        public View createIndicatorView();
    }

    public class TabSpec
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private String mTag;
        private IndicatorStrategy mIndicatorStrategy;
        private ContentStrategy mContentStrategy;
        /* synthetic */ TabHost this$0;

        private void $$robo$$android_widget_TabHost_TabSpec$__constructor__(TabHost tabHost, String tag) {
            this.mTag = tag;
        }

        private final TabSpec $$robo$$android_widget_TabHost_TabSpec$setIndicator(CharSequence label) {
            this.mIndicatorStrategy = new LabelIndicatorStrategy(this.this$0, label);
            return this;
        }

        private final TabSpec $$robo$$android_widget_TabHost_TabSpec$setIndicator(CharSequence label, Drawable icon) {
            this.mIndicatorStrategy = new LabelAndIconIndicatorStrategy(this.this$0, label, icon);
            return this;
        }

        private final TabSpec $$robo$$android_widget_TabHost_TabSpec$setIndicator(View view) {
            this.mIndicatorStrategy = new ViewIndicatorStrategy(this.this$0, view);
            return this;
        }

        private final TabSpec $$robo$$android_widget_TabHost_TabSpec$setContent(int viewId) {
            this.mContentStrategy = new ViewIdContentStrategy(this.this$0, viewId);
            return this;
        }

        private final TabSpec $$robo$$android_widget_TabHost_TabSpec$setContent(TabContentFactory contentFactory) {
            this.mContentStrategy = new FactoryContentStrategy(this.this$0, this.mTag, contentFactory);
            return this;
        }

        private final TabSpec $$robo$$android_widget_TabHost_TabSpec$setContent(Intent intent) {
            this.mContentStrategy = new IntentContentStrategy(this.this$0, this.mTag, intent);
            return this;
        }

        private final String $$robo$$android_widget_TabHost_TabSpec$getTag() {
            return this.mTag;
        }

        private /* synthetic */ void $$robo$$android_widget_TabHost_TabSpec$__constructor__(TabHost x0, String x1, 1 x2) {
        }

        private void __constructor__(TabHost tabHost, String string2) {
            this.$$robo$$android_widget_TabHost_TabSpec$__constructor__(tabHost, string2);
        }

        private TabSpec(TabHost tabHost, String string2) {
            this.this$0 = tabHost;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_TabHost_TabSpec$__constructor__(android.widget.TabHost java.lang.String ), 0, this, tabHost, string2);
        }

        public TabSpec setIndicator(CharSequence charSequence) {
            return InvokeDynamicSupport.bootstrap("setIndicator", $$robo$$android_widget_TabHost_TabSpec$setIndicator(java.lang.CharSequence ), 0, this, charSequence);
        }

        public TabSpec setIndicator(CharSequence charSequence, Drawable drawable2) {
            return InvokeDynamicSupport.bootstrap("setIndicator", $$robo$$android_widget_TabHost_TabSpec$setIndicator(java.lang.CharSequence android.graphics.drawable.Drawable ), 0, this, charSequence, drawable2);
        }

        public TabSpec setIndicator(View view) {
            return InvokeDynamicSupport.bootstrap("setIndicator", $$robo$$android_widget_TabHost_TabSpec$setIndicator(android.view.View ), 0, this, view);
        }

        public TabSpec setContent(int n) {
            return InvokeDynamicSupport.bootstrap("setContent", $$robo$$android_widget_TabHost_TabSpec$setContent(int ), 0, this, n);
        }

        public TabSpec setContent(TabContentFactory tabContentFactory) {
            return InvokeDynamicSupport.bootstrap("setContent", $$robo$$android_widget_TabHost_TabSpec$setContent(android.widget.TabHost$TabContentFactory ), 0, this, tabContentFactory);
        }

        public TabSpec setContent(Intent intent) {
            return InvokeDynamicSupport.bootstrap("setContent", $$robo$$android_widget_TabHost_TabSpec$setContent(android.content.Intent ), 0, this, intent);
        }

        public String getTag() {
            return InvokeDynamicSupport.bootstrap("getTag", $$robo$$android_widget_TabHost_TabSpec$getTag(), 0, this);
        }

        private /* synthetic */ void __constructor__(TabHost tabHost, String string2, 1 var3_3) {
            this.$$robo$$android_widget_TabHost_TabSpec$__constructor__(tabHost, string2, var3_3);
        }

        public /* synthetic */ TabSpec() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (TabSpec)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static interface TabContentFactory
    extends InstrumentedInterface {
        public View createTabContent(String var1);
    }

    public static interface OnTabChangeListener
    extends InstrumentedInterface {
        public void onTabChanged(String var1);
    }
}

