/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.View;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityNodeInfo;
import android.widget.LinearLayout;
import com.android.internal.R;
import org.robolectric.internal.bytecode.InstrumentedInterface;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class TabWidget
extends LinearLayout
implements View.OnFocusChangeListener,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private OnTabSelectionChanged mSelectionChangedListener;
    private int mSelectedTab;
    private Drawable mLeftStrip;
    private Drawable mRightStrip;
    private boolean mDrawBottomStrips;
    private boolean mStripMoved;
    private Rect mBounds;
    private int mImposedTabsHeight;
    private int[] mImposedTabWidths;

    private void $$robo$$android_widget_TabWidget$__constructor__(Context context) {
    }

    private void $$robo$$android_widget_TabWidget$__constructor__(Context context, AttributeSet attrs) {
    }

    private void $$robo$$android_widget_TabWidget$__constructor__(Context context, AttributeSet attrs, int defStyleAttr) {
    }

    private void $$robo$$android_widget_TabWidget$__constructor__(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        this.mSelectedTab = -1;
        this.mDrawBottomStrips = true;
        this.mBounds = new Rect();
        this.mImposedTabsHeight = -1;
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.TabWidget, defStyleAttr, defStyleRes);
        this.setStripEnabled(a.getBoolean(3, true));
        this.setLeftStripDrawable(a.getDrawable(1));
        this.setRightStripDrawable(a.getDrawable(2));
        a.recycle();
        this.initTabWidget();
    }

    private final void $$robo$$android_widget_TabWidget$onSizeChanged(int w, int h, int oldw, int oldh) {
        this.mStripMoved = true;
        super.onSizeChanged(w, h, oldw, oldh);
    }

    private final int $$robo$$android_widget_TabWidget$getChildDrawingOrder(int childCount, int i) {
        if (this.mSelectedTab == -1) {
            return i;
        }
        if (i == childCount - 1) {
            return this.mSelectedTab;
        }
        if (i >= this.mSelectedTab) {
            return i + 1;
        }
        return i;
    }

    private final void $$robo$$android_widget_TabWidget$initTabWidget() {
        this.setChildrenDrawingOrderEnabled(true);
        Context context = this.mContext;
        if (context.getApplicationInfo().targetSdkVersion <= 4) {
            if (this.mLeftStrip == null) {
                this.mLeftStrip = context.getDrawable(17303264);
            }
            if (this.mRightStrip == null) {
                this.mRightStrip = context.getDrawable(17303266);
            }
        } else {
            if (this.mLeftStrip == null) {
                this.mLeftStrip = context.getDrawable(17303263);
            }
            if (this.mRightStrip == null) {
                this.mRightStrip = context.getDrawable(17303265);
            }
        }
        this.setFocusable(true);
        this.setOnFocusChangeListener(this);
    }

    private final void $$robo$$android_widget_TabWidget$measureChildBeforeLayout(View child, int childIndex, int widthMeasureSpec, int totalWidth, int heightMeasureSpec, int totalHeight) {
        if (!this.isMeasureWithLargestChildEnabled() && this.mImposedTabsHeight >= 0) {
            widthMeasureSpec = View.MeasureSpec.makeMeasureSpec(totalWidth + this.mImposedTabWidths[childIndex], 0x40000000);
            heightMeasureSpec = View.MeasureSpec.makeMeasureSpec(this.mImposedTabsHeight, 0x40000000);
        }
        super.measureChildBeforeLayout(child, childIndex, widthMeasureSpec, totalWidth, heightMeasureSpec, totalHeight);
    }

    private final void $$robo$$android_widget_TabWidget$measureHorizontal(int widthMeasureSpec, int heightMeasureSpec) {
        if (View.MeasureSpec.getMode(widthMeasureSpec) == 0) {
            super.measureHorizontal(widthMeasureSpec, heightMeasureSpec);
            return;
        }
        int unspecifiedWidth = View.MeasureSpec.makeMeasureSpec(0, 0);
        this.mImposedTabsHeight = -1;
        super.measureHorizontal(unspecifiedWidth, heightMeasureSpec);
        int extraWidth = this.getMeasuredWidth() - View.MeasureSpec.getSize(widthMeasureSpec);
        if (extraWidth > 0) {
            View child;
            int i;
            int count = this.getChildCount();
            int childCount = 0;
            for (i = 0; i < count; ++i) {
                child = this.getChildAt(i);
                if (child.getVisibility() == 8) continue;
                ++childCount;
            }
            if (childCount > 0) {
                if (this.mImposedTabWidths == null || this.mImposedTabWidths.length != count) {
                    this.mImposedTabWidths = new int[count];
                }
                for (i = 0; i < count; ++i) {
                    int newWidth;
                    child = this.getChildAt(i);
                    if (child.getVisibility() == 8) continue;
                    int childWidth = child.getMeasuredWidth();
                    int delta = extraWidth / childCount;
                    this.mImposedTabWidths[i] = newWidth = Math.max(0, childWidth - delta);
                    extraWidth -= childWidth - newWidth;
                    --childCount;
                    this.mImposedTabsHeight = Math.max(this.mImposedTabsHeight, child.getMeasuredHeight());
                }
            }
        }
        super.measureHorizontal(widthMeasureSpec, heightMeasureSpec);
    }

    private final View $$robo$$android_widget_TabWidget$getChildTabViewAt(int index) {
        return this.getChildAt(index);
    }

    private final int $$robo$$android_widget_TabWidget$getTabCount() {
        return this.getChildCount();
    }

    private final void $$robo$$android_widget_TabWidget$setDividerDrawable(Drawable drawable2) {
        super.setDividerDrawable(drawable2);
    }

    private final void $$robo$$android_widget_TabWidget$setDividerDrawable(int resId) {
        this.setDividerDrawable(this.mContext.getDrawable(resId));
    }

    private final void $$robo$$android_widget_TabWidget$setLeftStripDrawable(Drawable drawable2) {
        this.mLeftStrip = drawable2;
        this.requestLayout();
        this.invalidate();
    }

    private final void $$robo$$android_widget_TabWidget$setLeftStripDrawable(int resId) {
        this.setLeftStripDrawable(this.mContext.getDrawable(resId));
    }

    private final void $$robo$$android_widget_TabWidget$setRightStripDrawable(Drawable drawable2) {
        this.mRightStrip = drawable2;
        this.requestLayout();
        this.invalidate();
    }

    private final void $$robo$$android_widget_TabWidget$setRightStripDrawable(int resId) {
        this.setRightStripDrawable(this.mContext.getDrawable(resId));
    }

    private final void $$robo$$android_widget_TabWidget$setStripEnabled(boolean stripEnabled) {
        this.mDrawBottomStrips = stripEnabled;
        this.invalidate();
    }

    private final boolean $$robo$$android_widget_TabWidget$isStripEnabled() {
        return this.mDrawBottomStrips;
    }

    private final void $$robo$$android_widget_TabWidget$childDrawableStateChanged(View child) {
        if (this.getTabCount() > 0 && child == this.getChildTabViewAt(this.mSelectedTab)) {
            this.invalidate();
        }
        super.childDrawableStateChanged(child);
    }

    private final void $$robo$$android_widget_TabWidget$dispatchDraw(Canvas canvas) {
        super.dispatchDraw(canvas);
        if (this.getTabCount() == 0) {
            return;
        }
        if (!this.mDrawBottomStrips) {
            return;
        }
        View selectedChild = this.getChildTabViewAt(this.mSelectedTab);
        Drawable leftStrip = this.mLeftStrip;
        Drawable rightStrip = this.mRightStrip;
        leftStrip.setState(selectedChild.getDrawableState());
        rightStrip.setState(selectedChild.getDrawableState());
        if (this.mStripMoved) {
            Rect bounds = this.mBounds;
            bounds.left = selectedChild.getLeft();
            bounds.right = selectedChild.getRight();
            int myHeight = this.getHeight();
            leftStrip.setBounds(Math.min(0, bounds.left - leftStrip.getIntrinsicWidth()), myHeight - leftStrip.getIntrinsicHeight(), bounds.left, myHeight);
            rightStrip.setBounds(bounds.right, myHeight - rightStrip.getIntrinsicHeight(), Math.max(this.getWidth(), bounds.right + rightStrip.getIntrinsicWidth()), myHeight);
            this.mStripMoved = false;
        }
        leftStrip.draw(canvas);
        rightStrip.draw(canvas);
    }

    private final void $$robo$$android_widget_TabWidget$setCurrentTab(int index) {
        if (index < 0 || index >= this.getTabCount() || index == this.mSelectedTab) {
            return;
        }
        if (this.mSelectedTab != -1) {
            this.getChildTabViewAt(this.mSelectedTab).setSelected(false);
        }
        this.mSelectedTab = index;
        this.getChildTabViewAt(this.mSelectedTab).setSelected(true);
        this.mStripMoved = true;
        if (this.isShown()) {
            this.sendAccessibilityEvent(4);
        }
    }

    private final boolean $$robo$$android_widget_TabWidget$dispatchPopulateAccessibilityEvent(AccessibilityEvent event) {
        View tabView;
        this.onPopulateAccessibilityEvent(event);
        if (this.mSelectedTab != -1 && (tabView = this.getChildTabViewAt(this.mSelectedTab)) != null && tabView.getVisibility() == 0) {
            return tabView.dispatchPopulateAccessibilityEvent(event);
        }
        return false;
    }

    private final void $$robo$$android_widget_TabWidget$onInitializeAccessibilityEvent(AccessibilityEvent event) {
        super.onInitializeAccessibilityEvent(event);
        event.setClassName(TabWidget.class.getName());
        event.setItemCount(this.getTabCount());
        event.setCurrentItemIndex(this.mSelectedTab);
    }

    private final void $$robo$$android_widget_TabWidget$sendAccessibilityEventUnchecked(AccessibilityEvent event) {
        if (event.getEventType() == 8 && this.isFocused()) {
            event.recycle();
            return;
        }
        super.sendAccessibilityEventUnchecked(event);
    }

    private final void $$robo$$android_widget_TabWidget$onInitializeAccessibilityNodeInfo(AccessibilityNodeInfo info) {
        super.onInitializeAccessibilityNodeInfo(info);
        info.setClassName(TabWidget.class.getName());
    }

    private final void $$robo$$android_widget_TabWidget$focusCurrentTab(int index) {
        int oldTab = this.mSelectedTab;
        this.setCurrentTab(index);
        if (oldTab != index) {
            this.getChildTabViewAt(index).requestFocus();
        }
    }

    private final void $$robo$$android_widget_TabWidget$setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        int count = this.getTabCount();
        for (int i = 0; i < count; ++i) {
            View child = this.getChildTabViewAt(i);
            child.setEnabled(enabled);
        }
    }

    private final void $$robo$$android_widget_TabWidget$addView(View child) {
        if (child.getLayoutParams() == null) {
            LinearLayout.LayoutParams lp = new LinearLayout.LayoutParams(0, -1, 1.0f);
            lp.setMargins(0, 0, 0, 0);
            child.setLayoutParams(lp);
        }
        child.setFocusable(true);
        child.setClickable(true);
        super.addView(child);
        child.setOnClickListener(new TabClickListener(this, this.getTabCount() - 1));
        child.setOnFocusChangeListener(this);
    }

    private final void $$robo$$android_widget_TabWidget$removeAllViews() {
        super.removeAllViews();
        this.mSelectedTab = -1;
    }

    private final void $$robo$$android_widget_TabWidget$setTabSelectionListener(OnTabSelectionChanged listener) {
        this.mSelectionChangedListener = listener;
    }

    private final void $$robo$$android_widget_TabWidget$onFocusChange(View v, boolean hasFocus) {
        if (v == this && hasFocus && this.getTabCount() > 0) {
            this.getChildTabViewAt(this.mSelectedTab).requestFocus();
            return;
        }
        if (hasFocus) {
            int numTabs = this.getTabCount();
            for (int i = 0; i < numTabs; ++i) {
                if (this.getChildTabViewAt(i) != v) continue;
                this.setCurrentTab(i);
                this.mSelectionChangedListener.onTabSelectionChanged(i, false);
                if (!this.isShown()) break;
                this.sendAccessibilityEvent(8);
                break;
            }
        }
    }

    private void __constructor__(Context context) {
        this.$$robo$$android_widget_TabWidget$__constructor__(context);
    }

    public TabWidget(Context context) {
        this(context, null);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_TabWidget$__constructor__(android.content.Context ), 0, this, context);
    }

    private void __constructor__(Context context, AttributeSet attributeSet) {
        this.$$robo$$android_widget_TabWidget$__constructor__(context, attributeSet);
    }

    public TabWidget(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 16842883);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_TabWidget$__constructor__(android.content.Context android.util.AttributeSet ), 0, this, context, attributeSet);
    }

    private void __constructor__(Context context, AttributeSet attributeSet, int n) {
        this.$$robo$$android_widget_TabWidget$__constructor__(context, attributeSet, n);
    }

    public TabWidget(Context context, AttributeSet attributeSet, int n) {
        this(context, attributeSet, n, 0);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_TabWidget$__constructor__(android.content.Context android.util.AttributeSet int ), 0, this, context, attributeSet, n);
    }

    private void __constructor__(Context context, AttributeSet attributeSet, int n, int n2) {
        this.$$robo$$android_widget_TabWidget$__constructor__(context, attributeSet, n, n2);
    }

    public TabWidget(Context context, AttributeSet attributeSet, int n, int n2) {
        super(context, attributeSet, n, n2);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_TabWidget$__constructor__(android.content.Context android.util.AttributeSet int int ), 0, this, context, attributeSet, n, n2);
    }

    @Override
    protected void onSizeChanged(int n, int n2, int n3, int n4) {
        InvokeDynamicSupport.bootstrap("onSizeChanged", $$robo$$android_widget_TabWidget$onSizeChanged(int int int int ), 0, this, n, n2, n3, n4);
    }

    @Override
    protected int getChildDrawingOrder(int n, int n2) {
        return (int)InvokeDynamicSupport.bootstrap("getChildDrawingOrder", $$robo$$android_widget_TabWidget$getChildDrawingOrder(int int ), 0, this, n, n2);
    }

    private void initTabWidget() {
        InvokeDynamicSupport.bootstrap("initTabWidget", $$robo$$android_widget_TabWidget$initTabWidget(), 0, this);
    }

    @Override
    void measureChildBeforeLayout(View view, int n, int n2, int n3, int n4, int n5) {
        InvokeDynamicSupport.bootstrap("measureChildBeforeLayout", $$robo$$android_widget_TabWidget$measureChildBeforeLayout(android.view.View int int int int int ), 0, this, view, n, n2, n3, n4, n5);
    }

    @Override
    void measureHorizontal(int n, int n2) {
        InvokeDynamicSupport.bootstrap("measureHorizontal", $$robo$$android_widget_TabWidget$measureHorizontal(int int ), 0, this, n, n2);
    }

    public View getChildTabViewAt(int n) {
        return InvokeDynamicSupport.bootstrap("getChildTabViewAt", $$robo$$android_widget_TabWidget$getChildTabViewAt(int ), 0, this, n);
    }

    public int getTabCount() {
        return (int)InvokeDynamicSupport.bootstrap("getTabCount", $$robo$$android_widget_TabWidget$getTabCount(), 0, this);
    }

    @Override
    public void setDividerDrawable(Drawable drawable2) {
        InvokeDynamicSupport.bootstrap("setDividerDrawable", $$robo$$android_widget_TabWidget$setDividerDrawable(android.graphics.drawable.Drawable ), 0, this, drawable2);
    }

    public void setDividerDrawable(int n) {
        InvokeDynamicSupport.bootstrap("setDividerDrawable", $$robo$$android_widget_TabWidget$setDividerDrawable(int ), 0, this, n);
    }

    public void setLeftStripDrawable(Drawable drawable2) {
        InvokeDynamicSupport.bootstrap("setLeftStripDrawable", $$robo$$android_widget_TabWidget$setLeftStripDrawable(android.graphics.drawable.Drawable ), 0, this, drawable2);
    }

    public void setLeftStripDrawable(int n) {
        InvokeDynamicSupport.bootstrap("setLeftStripDrawable", $$robo$$android_widget_TabWidget$setLeftStripDrawable(int ), 0, this, n);
    }

    public void setRightStripDrawable(Drawable drawable2) {
        InvokeDynamicSupport.bootstrap("setRightStripDrawable", $$robo$$android_widget_TabWidget$setRightStripDrawable(android.graphics.drawable.Drawable ), 0, this, drawable2);
    }

    public void setRightStripDrawable(int n) {
        InvokeDynamicSupport.bootstrap("setRightStripDrawable", $$robo$$android_widget_TabWidget$setRightStripDrawable(int ), 0, this, n);
    }

    public void setStripEnabled(boolean bl) {
        InvokeDynamicSupport.bootstrap("setStripEnabled", $$robo$$android_widget_TabWidget$setStripEnabled(boolean ), 0, this, bl);
    }

    public boolean isStripEnabled() {
        return (boolean)InvokeDynamicSupport.bootstrap("isStripEnabled", $$robo$$android_widget_TabWidget$isStripEnabled(), 0, this);
    }

    @Override
    public void childDrawableStateChanged(View view) {
        InvokeDynamicSupport.bootstrap("childDrawableStateChanged", $$robo$$android_widget_TabWidget$childDrawableStateChanged(android.view.View ), 0, this, view);
    }

    @Override
    public void dispatchDraw(Canvas canvas) {
        InvokeDynamicSupport.bootstrap("dispatchDraw", $$robo$$android_widget_TabWidget$dispatchDraw(android.graphics.Canvas ), 0, this, canvas);
    }

    public void setCurrentTab(int n) {
        InvokeDynamicSupport.bootstrap("setCurrentTab", $$robo$$android_widget_TabWidget$setCurrentTab(int ), 0, this, n);
    }

    @Override
    public boolean dispatchPopulateAccessibilityEvent(AccessibilityEvent accessibilityEvent) {
        return (boolean)InvokeDynamicSupport.bootstrap("dispatchPopulateAccessibilityEvent", $$robo$$android_widget_TabWidget$dispatchPopulateAccessibilityEvent(android.view.accessibility.AccessibilityEvent ), 0, this, accessibilityEvent);
    }

    @Override
    public void onInitializeAccessibilityEvent(AccessibilityEvent accessibilityEvent) {
        InvokeDynamicSupport.bootstrap("onInitializeAccessibilityEvent", $$robo$$android_widget_TabWidget$onInitializeAccessibilityEvent(android.view.accessibility.AccessibilityEvent ), 0, this, accessibilityEvent);
    }

    @Override
    public void sendAccessibilityEventUnchecked(AccessibilityEvent accessibilityEvent) {
        InvokeDynamicSupport.bootstrap("sendAccessibilityEventUnchecked", $$robo$$android_widget_TabWidget$sendAccessibilityEventUnchecked(android.view.accessibility.AccessibilityEvent ), 0, this, accessibilityEvent);
    }

    @Override
    public void onInitializeAccessibilityNodeInfo(AccessibilityNodeInfo accessibilityNodeInfo) {
        InvokeDynamicSupport.bootstrap("onInitializeAccessibilityNodeInfo", $$robo$$android_widget_TabWidget$onInitializeAccessibilityNodeInfo(android.view.accessibility.AccessibilityNodeInfo ), 0, this, accessibilityNodeInfo);
    }

    public void focusCurrentTab(int n) {
        InvokeDynamicSupport.bootstrap("focusCurrentTab", $$robo$$android_widget_TabWidget$focusCurrentTab(int ), 0, this, n);
    }

    @Override
    public void setEnabled(boolean bl) {
        InvokeDynamicSupport.bootstrap("setEnabled", $$robo$$android_widget_TabWidget$setEnabled(boolean ), 0, this, bl);
    }

    @Override
    public void addView(View view) {
        InvokeDynamicSupport.bootstrap("addView", $$robo$$android_widget_TabWidget$addView(android.view.View ), 0, this, view);
    }

    @Override
    public void removeAllViews() {
        InvokeDynamicSupport.bootstrap("removeAllViews", $$robo$$android_widget_TabWidget$removeAllViews(), 0, this);
    }

    void setTabSelectionListener(OnTabSelectionChanged onTabSelectionChanged) {
        InvokeDynamicSupport.bootstrap("setTabSelectionListener", $$robo$$android_widget_TabWidget$setTabSelectionListener(android.widget.TabWidget$OnTabSelectionChanged ), 0, this, onTabSelectionChanged);
    }

    @Override
    public void onFocusChange(View view, boolean bl) {
        InvokeDynamicSupport.bootstrap("onFocusChange", $$robo$$android_widget_TabWidget$onFocusChange(android.view.View boolean ), 0, this, view, bl);
    }

    public /* synthetic */ TabWidget() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (TabWidget)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    static interface OnTabSelectionChanged
    extends InstrumentedInterface {
        public void onTabSelectionChanged(int var1, boolean var2);
    }

    private class TabClickListener
    implements View.OnClickListener,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private int mTabIndex;
        /* synthetic */ TabWidget this$0;

        private void $$robo$$android_widget_TabWidget_TabClickListener$__constructor__(TabWidget tabWidget, int tabIndex) {
            this.mTabIndex = tabIndex;
        }

        private final void $$robo$$android_widget_TabWidget_TabClickListener$onClick(View v) {
            this.this$0.mSelectionChangedListener.onTabSelectionChanged(this.mTabIndex, true);
        }

        private /* synthetic */ void $$robo$$android_widget_TabWidget_TabClickListener$__constructor__(TabWidget x0, int x1, 1 x2) {
        }

        private void __constructor__(TabWidget tabWidget, int n) {
            this.$$robo$$android_widget_TabWidget_TabClickListener$__constructor__(tabWidget, n);
        }

        private TabClickListener(TabWidget tabWidget, int n) {
            this.this$0 = tabWidget;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_TabWidget_TabClickListener$__constructor__(android.widget.TabWidget int ), 0, this, tabWidget, n);
        }

        @Override
        public void onClick(View view) {
            InvokeDynamicSupport.bootstrap("onClick", $$robo$$android_widget_TabWidget_TabClickListener$onClick(android.view.View ), 0, this, view);
        }

        private /* synthetic */ void __constructor__(TabWidget tabWidget, int n, 1 var3_3) {
            this.$$robo$$android_widget_TabWidget_TabClickListener$__constructor__(tabWidget, n, var3_3);
        }

        public /* synthetic */ TabClickListener() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (TabClickListener)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

