/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.util.SparseIntArray;
import android.view.Gravity;
import android.view.View;
import android.view.ViewDebug;
import android.view.ViewGroup;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityNodeInfo;
import android.widget.LinearLayout;
import com.android.internal.R;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class TableRow
extends LinearLayout
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private int mNumColumns;
    private int[] mColumnWidths;
    private int[] mConstrainedColumnWidths;
    private SparseIntArray mColumnToChildIndex;
    private ChildrenTracker mChildrenTracker;

    private void $$robo$$android_widget_TableRow$__constructor__(Context context) {
        this.mNumColumns = 0;
        this.initTableRow();
    }

    private void $$robo$$android_widget_TableRow$__constructor__(Context context, AttributeSet attrs) {
        this.mNumColumns = 0;
        this.initTableRow();
    }

    private final void $$robo$$android_widget_TableRow$initTableRow() {
        ViewGroup.OnHierarchyChangeListener oldListener = this.mOnHierarchyChangeListener;
        this.mChildrenTracker = new ChildrenTracker(this);
        if (oldListener != null) {
            this.mChildrenTracker.setOnHierarchyChangeListener(oldListener);
        }
        super.setOnHierarchyChangeListener(this.mChildrenTracker);
    }

    private final void $$robo$$android_widget_TableRow$setOnHierarchyChangeListener(ViewGroup.OnHierarchyChangeListener listener) {
        this.mChildrenTracker.setOnHierarchyChangeListener(listener);
    }

    private final void $$robo$$android_widget_TableRow$setColumnCollapsed(int columnIndex, boolean collapsed) {
        View child = this.getVirtualChildAt(columnIndex);
        if (child != null) {
            child.setVisibility(collapsed ? 8 : 0);
        }
    }

    private final void $$robo$$android_widget_TableRow$onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        this.measureHorizontal(widthMeasureSpec, heightMeasureSpec);
    }

    private final void $$robo$$android_widget_TableRow$onLayout(boolean changed, int l, int t, int r, int b) {
        this.layoutHorizontal(l, t, r, b);
    }

    private final View $$robo$$android_widget_TableRow$getVirtualChildAt(int i) {
        int deflectedIndex;
        if (this.mColumnToChildIndex == null) {
            this.mapIndexAndColumns();
        }
        if ((deflectedIndex = this.mColumnToChildIndex.get(i, -1)) != -1) {
            return this.getChildAt(deflectedIndex);
        }
        return null;
    }

    private final int $$robo$$android_widget_TableRow$getVirtualChildCount() {
        if (this.mColumnToChildIndex == null) {
            this.mapIndexAndColumns();
        }
        return this.mNumColumns;
    }

    private final void $$robo$$android_widget_TableRow$mapIndexAndColumns() {
        if (this.mColumnToChildIndex == null) {
            int virtualCount = 0;
            int count = this.getChildCount();
            SparseIntArray columnToChild = this.mColumnToChildIndex = new SparseIntArray();
            for (int i = 0; i < count; ++i) {
                View child = this.getChildAt(i);
                LayoutParams layoutParams = (LayoutParams)child.getLayoutParams();
                if (layoutParams.column >= virtualCount) {
                    virtualCount = layoutParams.column;
                }
                for (int j = 0; j < layoutParams.span; ++j) {
                    columnToChild.put(virtualCount++, i);
                }
            }
            this.mNumColumns = virtualCount;
        }
    }

    private final int $$robo$$android_widget_TableRow$measureNullChild(int childIndex) {
        return this.mConstrainedColumnWidths[childIndex];
    }

    private final void $$robo$$android_widget_TableRow$measureChildBeforeLayout(View child, int childIndex, int widthMeasureSpec, int totalWidth, int heightMeasureSpec, int totalHeight) {
        if (this.mConstrainedColumnWidths != null) {
            LayoutParams lp = (LayoutParams)child.getLayoutParams();
            int measureMode = 0x40000000;
            int columnWidth = 0;
            int span = lp.span;
            int[] constrainedColumnWidths = this.mConstrainedColumnWidths;
            for (int i = 0; i < span; ++i) {
                columnWidth += constrainedColumnWidths[childIndex + i];
            }
            int gravity = lp.gravity;
            boolean isHorizontalGravity = Gravity.isHorizontal(gravity);
            if (isHorizontalGravity) {
                measureMode = Integer.MIN_VALUE;
            }
            int childWidthMeasureSpec = View.MeasureSpec.makeMeasureSpec(Math.max(0, columnWidth - lp.leftMargin - lp.rightMargin), measureMode);
            int childHeightMeasureSpec = TableRow.getChildMeasureSpec(heightMeasureSpec, this.mPaddingTop + this.mPaddingBottom + lp.topMargin + lp.bottomMargin + totalHeight, lp.height);
            child.measure(childWidthMeasureSpec, childHeightMeasureSpec);
            if (isHorizontalGravity) {
                int childWidth = child.getMeasuredWidth();
                ((LayoutParams)lp).mOffset[1] = columnWidth - childWidth;
                int layoutDirection = this.getLayoutDirection();
                int absoluteGravity = Gravity.getAbsoluteGravity(gravity, layoutDirection);
                switch (absoluteGravity & 7) {
                    case 3: {
                        break;
                    }
                    case 5: {
                        ((LayoutParams)lp).mOffset[0] = lp.mOffset[1];
                        break;
                    }
                    case 1: {
                        ((LayoutParams)lp).mOffset[0] = lp.mOffset[1] / 2;
                    }
                }
            } else {
                ((LayoutParams)lp).mOffset[1] = 0;
                ((LayoutParams)lp).mOffset[0] = 0;
            }
        } else {
            super.measureChildBeforeLayout(child, childIndex, widthMeasureSpec, totalWidth, heightMeasureSpec, totalHeight);
        }
    }

    private final int $$robo$$android_widget_TableRow$getChildrenSkipCount(View child, int index) {
        LayoutParams layoutParams = (LayoutParams)child.getLayoutParams();
        return layoutParams.span - 1;
    }

    private final int $$robo$$android_widget_TableRow$getLocationOffset(View child) {
        return ((LayoutParams)child.getLayoutParams()).mOffset[0];
    }

    private final int $$robo$$android_widget_TableRow$getNextLocationOffset(View child) {
        return ((LayoutParams)child.getLayoutParams()).mOffset[1];
    }

    private final int[] $$robo$$android_widget_TableRow$getColumnsWidths(int widthMeasureSpec) {
        int numColumns = this.getVirtualChildCount();
        if (this.mColumnWidths == null || numColumns != this.mColumnWidths.length) {
            this.mColumnWidths = new int[numColumns];
        }
        int[] columnWidths = this.mColumnWidths;
        for (int i = 0; i < numColumns; ++i) {
            View child = this.getVirtualChildAt(i);
            if (child != null && child.getVisibility() != 8) {
                LayoutParams layoutParams = (LayoutParams)child.getLayoutParams();
                if (layoutParams.span == 1) {
                    int width;
                    int spec;
                    switch (layoutParams.width) {
                        case -2: {
                            spec = TableRow.getChildMeasureSpec(widthMeasureSpec, 0, -2);
                            break;
                        }
                        case -1: {
                            spec = View.MeasureSpec.makeMeasureSpec(0, 0);
                            break;
                        }
                        default: {
                            spec = View.MeasureSpec.makeMeasureSpec(layoutParams.width, 0x40000000);
                        }
                    }
                    child.measure(spec, spec);
                    columnWidths[i] = width = child.getMeasuredWidth() + layoutParams.leftMargin + layoutParams.rightMargin;
                    continue;
                }
                columnWidths[i] = 0;
                continue;
            }
            columnWidths[i] = 0;
        }
        return columnWidths;
    }

    private final void $$robo$$android_widget_TableRow$setColumnsWidthConstraints(int[] columnWidths) {
        if (columnWidths == null || columnWidths.length < this.getVirtualChildCount()) {
            throw new IllegalArgumentException("columnWidths should be >= getVirtualChildCount()");
        }
        this.mConstrainedColumnWidths = columnWidths;
    }

    private final LayoutParams $$robo$$android_widget_TableRow$generateLayoutParams(AttributeSet attrs) {
        return new LayoutParams(this.getContext(), attrs);
    }

    private final LinearLayout.LayoutParams $$robo$$android_widget_TableRow$generateDefaultLayoutParams() {
        return new LayoutParams();
    }

    private final boolean $$robo$$android_widget_TableRow$checkLayoutParams(ViewGroup.LayoutParams p) {
        return p instanceof LayoutParams;
    }

    private final LinearLayout.LayoutParams $$robo$$android_widget_TableRow$generateLayoutParams(ViewGroup.LayoutParams p) {
        return new LayoutParams(p);
    }

    private final void $$robo$$android_widget_TableRow$onInitializeAccessibilityEvent(AccessibilityEvent event) {
        super.onInitializeAccessibilityEvent(event);
        event.setClassName(TableRow.class.getName());
    }

    private final void $$robo$$android_widget_TableRow$onInitializeAccessibilityNodeInfo(AccessibilityNodeInfo info) {
        super.onInitializeAccessibilityNodeInfo(info);
        info.setClassName(TableRow.class.getName());
    }

    private void __constructor__(Context context) {
        this.$$robo$$android_widget_TableRow$__constructor__(context);
    }

    public TableRow(Context context) {
        super(context);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_TableRow$__constructor__(android.content.Context ), 0, this, context);
    }

    private void __constructor__(Context context, AttributeSet attributeSet) {
        this.$$robo$$android_widget_TableRow$__constructor__(context, attributeSet);
    }

    public TableRow(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_TableRow$__constructor__(android.content.Context android.util.AttributeSet ), 0, this, context, attributeSet);
    }

    private void initTableRow() {
        InvokeDynamicSupport.bootstrap("initTableRow", $$robo$$android_widget_TableRow$initTableRow(), 0, this);
    }

    @Override
    public void setOnHierarchyChangeListener(ViewGroup.OnHierarchyChangeListener onHierarchyChangeListener) {
        InvokeDynamicSupport.bootstrap("setOnHierarchyChangeListener", $$robo$$android_widget_TableRow$setOnHierarchyChangeListener(android.view.ViewGroup$OnHierarchyChangeListener ), 0, this, onHierarchyChangeListener);
    }

    void setColumnCollapsed(int n, boolean bl) {
        InvokeDynamicSupport.bootstrap("setColumnCollapsed", $$robo$$android_widget_TableRow$setColumnCollapsed(int boolean ), 0, this, n, bl);
    }

    @Override
    protected void onMeasure(int n, int n2) {
        InvokeDynamicSupport.bootstrap("onMeasure", $$robo$$android_widget_TableRow$onMeasure(int int ), 0, this, n, n2);
    }

    @Override
    protected void onLayout(boolean bl, int n, int n2, int n3, int n4) {
        InvokeDynamicSupport.bootstrap("onLayout", $$robo$$android_widget_TableRow$onLayout(boolean int int int int ), 0, this, bl, n, n2, n3, n4);
    }

    @Override
    public View getVirtualChildAt(int n) {
        return InvokeDynamicSupport.bootstrap("getVirtualChildAt", $$robo$$android_widget_TableRow$getVirtualChildAt(int ), 0, this, n);
    }

    @Override
    public int getVirtualChildCount() {
        return (int)InvokeDynamicSupport.bootstrap("getVirtualChildCount", $$robo$$android_widget_TableRow$getVirtualChildCount(), 0, this);
    }

    private void mapIndexAndColumns() {
        InvokeDynamicSupport.bootstrap("mapIndexAndColumns", $$robo$$android_widget_TableRow$mapIndexAndColumns(), 0, this);
    }

    @Override
    int measureNullChild(int n) {
        return (int)InvokeDynamicSupport.bootstrap("measureNullChild", $$robo$$android_widget_TableRow$measureNullChild(int ), 0, this, n);
    }

    @Override
    void measureChildBeforeLayout(View view, int n, int n2, int n3, int n4, int n5) {
        InvokeDynamicSupport.bootstrap("measureChildBeforeLayout", $$robo$$android_widget_TableRow$measureChildBeforeLayout(android.view.View int int int int int ), 0, this, view, n, n2, n3, n4, n5);
    }

    @Override
    int getChildrenSkipCount(View view, int n) {
        return (int)InvokeDynamicSupport.bootstrap("getChildrenSkipCount", $$robo$$android_widget_TableRow$getChildrenSkipCount(android.view.View int ), 0, this, view, n);
    }

    @Override
    int getLocationOffset(View view) {
        return (int)InvokeDynamicSupport.bootstrap("getLocationOffset", $$robo$$android_widget_TableRow$getLocationOffset(android.view.View ), 0, this, view);
    }

    @Override
    int getNextLocationOffset(View view) {
        return (int)InvokeDynamicSupport.bootstrap("getNextLocationOffset", $$robo$$android_widget_TableRow$getNextLocationOffset(android.view.View ), 0, this, view);
    }

    int[] getColumnsWidths(int n) {
        return InvokeDynamicSupport.bootstrap("getColumnsWidths", $$robo$$android_widget_TableRow$getColumnsWidths(int ), 0, this, n);
    }

    void setColumnsWidthConstraints(int[] nArray) {
        InvokeDynamicSupport.bootstrap("setColumnsWidthConstraints", $$robo$$android_widget_TableRow$setColumnsWidthConstraints(int[] ), 0, this, nArray);
    }

    @Override
    public LayoutParams generateLayoutParams(AttributeSet attributeSet) {
        return InvokeDynamicSupport.bootstrap("generateLayoutParams", $$robo$$android_widget_TableRow$generateLayoutParams(android.util.AttributeSet ), 0, this, attributeSet);
    }

    @Override
    protected LinearLayout.LayoutParams generateDefaultLayoutParams() {
        return InvokeDynamicSupport.bootstrap("generateDefaultLayoutParams", $$robo$$android_widget_TableRow$generateDefaultLayoutParams(), 0, this);
    }

    @Override
    protected boolean checkLayoutParams(ViewGroup.LayoutParams layoutParams) {
        return (boolean)InvokeDynamicSupport.bootstrap("checkLayoutParams", $$robo$$android_widget_TableRow$checkLayoutParams(android.view.ViewGroup$LayoutParams ), 0, this, layoutParams);
    }

    @Override
    protected LinearLayout.LayoutParams generateLayoutParams(ViewGroup.LayoutParams layoutParams) {
        return InvokeDynamicSupport.bootstrap("generateLayoutParams", $$robo$$android_widget_TableRow$generateLayoutParams(android.view.ViewGroup$LayoutParams ), 0, this, layoutParams);
    }

    @Override
    public void onInitializeAccessibilityEvent(AccessibilityEvent accessibilityEvent) {
        InvokeDynamicSupport.bootstrap("onInitializeAccessibilityEvent", $$robo$$android_widget_TableRow$onInitializeAccessibilityEvent(android.view.accessibility.AccessibilityEvent ), 0, this, accessibilityEvent);
    }

    @Override
    public void onInitializeAccessibilityNodeInfo(AccessibilityNodeInfo accessibilityNodeInfo) {
        InvokeDynamicSupport.bootstrap("onInitializeAccessibilityNodeInfo", $$robo$$android_widget_TableRow$onInitializeAccessibilityNodeInfo(android.view.accessibility.AccessibilityNodeInfo ), 0, this, accessibilityNodeInfo);
    }

    public /* synthetic */ TableRow() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (TableRow)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    private class ChildrenTracker
    implements ViewGroup.OnHierarchyChangeListener,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private ViewGroup.OnHierarchyChangeListener listener;
        /* synthetic */ TableRow this$0;

        private void $$robo$$android_widget_TableRow_ChildrenTracker$__constructor__(TableRow tableRow) {
        }

        private final void $$robo$$android_widget_TableRow_ChildrenTracker$setOnHierarchyChangeListener(ViewGroup.OnHierarchyChangeListener listener) {
            this.listener = listener;
        }

        private final void $$robo$$android_widget_TableRow_ChildrenTracker$onChildViewAdded(View parent, View child) {
            this.this$0.mColumnToChildIndex = null;
            if (this.listener != null) {
                this.listener.onChildViewAdded(parent, child);
            }
        }

        private final void $$robo$$android_widget_TableRow_ChildrenTracker$onChildViewRemoved(View parent, View child) {
            this.this$0.mColumnToChildIndex = null;
            if (this.listener != null) {
                this.listener.onChildViewRemoved(parent, child);
            }
        }

        private /* synthetic */ void $$robo$$android_widget_TableRow_ChildrenTracker$__constructor__(TableRow x0, 1 x1) {
        }

        private void __constructor__(TableRow tableRow) {
            this.$$robo$$android_widget_TableRow_ChildrenTracker$__constructor__(tableRow);
        }

        private ChildrenTracker(TableRow tableRow) {
            this.this$0 = tableRow;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_TableRow_ChildrenTracker$__constructor__(android.widget.TableRow ), 0, this, tableRow);
        }

        private void setOnHierarchyChangeListener(ViewGroup.OnHierarchyChangeListener onHierarchyChangeListener) {
            InvokeDynamicSupport.bootstrap("setOnHierarchyChangeListener", $$robo$$android_widget_TableRow_ChildrenTracker$setOnHierarchyChangeListener(android.view.ViewGroup$OnHierarchyChangeListener ), 0, this, onHierarchyChangeListener);
        }

        @Override
        public void onChildViewAdded(View view, View view2) {
            InvokeDynamicSupport.bootstrap("onChildViewAdded", $$robo$$android_widget_TableRow_ChildrenTracker$onChildViewAdded(android.view.View android.view.View ), 0, this, view, view2);
        }

        @Override
        public void onChildViewRemoved(View view, View view2) {
            InvokeDynamicSupport.bootstrap("onChildViewRemoved", $$robo$$android_widget_TableRow_ChildrenTracker$onChildViewRemoved(android.view.View android.view.View ), 0, this, view, view2);
        }

        private /* synthetic */ void __constructor__(TableRow tableRow, 1 var2_2) {
            this.$$robo$$android_widget_TableRow_ChildrenTracker$__constructor__(tableRow, var2_2);
        }

        public /* synthetic */ ChildrenTracker() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ChildrenTracker)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class LayoutParams
    extends LinearLayout.LayoutParams
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        @ViewDebug.ExportedProperty(category="layout")
        public int column;
        @ViewDebug.ExportedProperty(category="layout")
        public int span;
        private static int LOCATION = 0;
        private static int LOCATION_NEXT = 1;
        private int[] mOffset;

        private void $$robo$$android_widget_TableRow_LayoutParams$__constructor__(Context c, AttributeSet attrs) {
            this.mOffset = new int[2];
            TypedArray a = c.obtainStyledAttributes(attrs, R.styleable.TableRow_Cell);
            this.column = a.getInt(0, -1);
            this.span = a.getInt(1, 1);
            if (this.span <= 1) {
                this.span = 1;
            }
            a.recycle();
        }

        private void $$robo$$android_widget_TableRow_LayoutParams$__constructor__(int w, int h) {
            this.mOffset = new int[2];
            this.column = -1;
            this.span = 1;
        }

        private void $$robo$$android_widget_TableRow_LayoutParams$__constructor__(int w, int h, float initWeight) {
            this.mOffset = new int[2];
            this.column = -1;
            this.span = 1;
        }

        private void $$robo$$android_widget_TableRow_LayoutParams$__constructor__() {
            this.mOffset = new int[2];
            this.column = -1;
            this.span = 1;
        }

        private void $$robo$$android_widget_TableRow_LayoutParams$__constructor__(int column) {
            this.column = column;
        }

        private void $$robo$$android_widget_TableRow_LayoutParams$__constructor__(ViewGroup.LayoutParams p) {
            this.mOffset = new int[2];
        }

        private void $$robo$$android_widget_TableRow_LayoutParams$__constructor__(ViewGroup.MarginLayoutParams source) {
            this.mOffset = new int[2];
        }

        private final void $$robo$$android_widget_TableRow_LayoutParams$setBaseAttributes(TypedArray a, int widthAttr, int heightAttr) {
            this.width = a.hasValue(widthAttr) ? a.getLayoutDimension(widthAttr, "layout_width") : -1;
            this.height = a.hasValue(heightAttr) ? a.getLayoutDimension(heightAttr, "layout_height") : -2;
        }

        private void __constructor__(Context context, AttributeSet attributeSet) {
            this.$$robo$$android_widget_TableRow_LayoutParams$__constructor__(context, attributeSet);
        }

        public LayoutParams(Context context, AttributeSet attributeSet) {
            super(context, attributeSet);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_TableRow_LayoutParams$__constructor__(android.content.Context android.util.AttributeSet ), 0, this, context, attributeSet);
        }

        private void __constructor__(int n, int n2) {
            this.$$robo$$android_widget_TableRow_LayoutParams$__constructor__(n, n2);
        }

        public LayoutParams(int n, int n2) {
            super(n, n2);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_TableRow_LayoutParams$__constructor__(int int ), 0, this, n, n2);
        }

        private void __constructor__(int n, int n2, float f) {
            this.$$robo$$android_widget_TableRow_LayoutParams$__constructor__(n, n2, f);
        }

        public LayoutParams(int n, int n2, float f) {
            super(n, n2, f);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_TableRow_LayoutParams$__constructor__(int int float ), 0, this, n, n2, f);
        }

        private void __constructor__() {
            this.$$robo$$android_widget_TableRow_LayoutParams$__constructor__();
        }

        public LayoutParams() {
            super(-1, -2);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_TableRow_LayoutParams$__constructor__(), 0, this);
        }

        private void __constructor__(int n) {
            this.$$robo$$android_widget_TableRow_LayoutParams$__constructor__(n);
        }

        public LayoutParams(int n) {
            this();
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_TableRow_LayoutParams$__constructor__(int ), 0, this, n);
        }

        private void __constructor__(ViewGroup.LayoutParams layoutParams) {
            this.$$robo$$android_widget_TableRow_LayoutParams$__constructor__(layoutParams);
        }

        public LayoutParams(ViewGroup.LayoutParams layoutParams) {
            super(layoutParams);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_TableRow_LayoutParams$__constructor__(android.view.ViewGroup$LayoutParams ), 0, this, layoutParams);
        }

        private void __constructor__(ViewGroup.MarginLayoutParams marginLayoutParams) {
            this.$$robo$$android_widget_TableRow_LayoutParams$__constructor__(marginLayoutParams);
        }

        public LayoutParams(ViewGroup.MarginLayoutParams marginLayoutParams) {
            super(marginLayoutParams);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_TableRow_LayoutParams$__constructor__(android.view.ViewGroup$MarginLayoutParams ), 0, this, marginLayoutParams);
        }

        @Override
        protected void setBaseAttributes(TypedArray typedArray, int n, int n2) {
            InvokeDynamicSupport.bootstrap("setBaseAttributes", $$robo$$android_widget_TableRow_LayoutParams$setBaseAttributes(android.content.res.TypedArray int int ), 0, this, typedArray, n, n2);
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (LayoutParams)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

