/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Typeface;
import android.util.AttributeSet;
import android.widget.TextView;
import com.android.internal.R;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class TextViewWithCircularIndicator
extends TextView
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static int SELECTED_CIRCLE_ALPHA = 60;
    private Paint mCirclePaint;
    private String mItemIsSelectedText;
    private int mCircleColor;
    private boolean mDrawIndicator;

    private void $$robo$$android_widget_TextViewWithCircularIndicator$__constructor__(Context context) {
    }

    private void $$robo$$android_widget_TextViewWithCircularIndicator$__constructor__(Context context, AttributeSet attrs) {
    }

    private void $$robo$$android_widget_TextViewWithCircularIndicator$__constructor__(Context context, AttributeSet attrs, int defStyleAttr) {
    }

    private void $$robo$$android_widget_TextViewWithCircularIndicator$__constructor__(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        this.mCirclePaint = new Paint();
        TypedArray a = this.mContext.obtainStyledAttributes(attrs, R.styleable.DatePicker, defStyleAttr, defStyleRes);
        int resId = a.getResourceId(13, -1);
        if (resId != -1) {
            this.setTextAppearance(context, resId);
        }
        Resources res = context.getResources();
        this.mItemIsSelectedText = res.getString(17041003);
        a.recycle();
        this.init();
    }

    private final void $$robo$$android_widget_TextViewWithCircularIndicator$init() {
        this.mCirclePaint.setTypeface(Typeface.create(this.mCirclePaint.getTypeface(), 1));
        this.mCirclePaint.setAntiAlias(true);
        this.mCirclePaint.setTextAlign(Paint.Align.CENTER);
        this.mCirclePaint.setStyle(Paint.Style.FILL);
    }

    private final void $$robo$$android_widget_TextViewWithCircularIndicator$setCircleColor(int color2) {
        if (color2 != this.mCircleColor) {
            this.mCircleColor = color2;
            this.mCirclePaint.setColor(this.mCircleColor);
            this.mCirclePaint.setAlpha(60);
            this.requestLayout();
        }
    }

    private final void $$robo$$android_widget_TextViewWithCircularIndicator$setDrawIndicator(boolean drawIndicator) {
        this.mDrawIndicator = drawIndicator;
    }

    private final void $$robo$$android_widget_TextViewWithCircularIndicator$onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (this.mDrawIndicator) {
            int width = this.getWidth();
            int height = this.getHeight();
            int radius = Math.min(width, height) / 2;
            canvas.drawCircle(width / 2, height / 2, radius, this.mCirclePaint);
        }
    }

    private final CharSequence $$robo$$android_widget_TextViewWithCircularIndicator$getContentDescription() {
        CharSequence itemText = this.getText();
        if (this.mDrawIndicator) {
            return String.format(this.mItemIsSelectedText, itemText);
        }
        return itemText;
    }

    private void __constructor__(Context context) {
        this.$$robo$$android_widget_TextViewWithCircularIndicator$__constructor__(context);
    }

    public TextViewWithCircularIndicator(Context context) {
        this(context, null);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_TextViewWithCircularIndicator$__constructor__(android.content.Context ), 0, this, context);
    }

    private void __constructor__(Context context, AttributeSet attributeSet) {
        this.$$robo$$android_widget_TextViewWithCircularIndicator$__constructor__(context, attributeSet);
    }

    public TextViewWithCircularIndicator(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 0);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_TextViewWithCircularIndicator$__constructor__(android.content.Context android.util.AttributeSet ), 0, this, context, attributeSet);
    }

    private void __constructor__(Context context, AttributeSet attributeSet, int n) {
        this.$$robo$$android_widget_TextViewWithCircularIndicator$__constructor__(context, attributeSet, n);
    }

    public TextViewWithCircularIndicator(Context context, AttributeSet attributeSet, int n) {
        this(context, attributeSet, n, 0);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_TextViewWithCircularIndicator$__constructor__(android.content.Context android.util.AttributeSet int ), 0, this, context, attributeSet, n);
    }

    private void __constructor__(Context context, AttributeSet attributeSet, int n, int n2) {
        this.$$robo$$android_widget_TextViewWithCircularIndicator$__constructor__(context, attributeSet, n, n2);
    }

    public TextViewWithCircularIndicator(Context context, AttributeSet attributeSet, int n, int n2) {
        super(context, attributeSet);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_TextViewWithCircularIndicator$__constructor__(android.content.Context android.util.AttributeSet int int ), 0, this, context, attributeSet, n, n2);
    }

    private void init() {
        InvokeDynamicSupport.bootstrap("init", $$robo$$android_widget_TextViewWithCircularIndicator$init(), 0, this);
    }

    public void setCircleColor(int n) {
        InvokeDynamicSupport.bootstrap("setCircleColor", $$robo$$android_widget_TextViewWithCircularIndicator$setCircleColor(int ), 0, this, n);
    }

    public void setDrawIndicator(boolean bl) {
        InvokeDynamicSupport.bootstrap("setDrawIndicator", $$robo$$android_widget_TextViewWithCircularIndicator$setDrawIndicator(boolean ), 0, this, bl);
    }

    @Override
    public void onDraw(Canvas canvas) {
        InvokeDynamicSupport.bootstrap("onDraw", $$robo$$android_widget_TextViewWithCircularIndicator$onDraw(android.graphics.Canvas ), 0, this, canvas);
    }

    @Override
    public CharSequence getContentDescription() {
        return InvokeDynamicSupport.bootstrap("getContentDescription", $$robo$$android_widget_TextViewWithCircularIndicator$getContentDescription(), 0, this);
    }

    public /* synthetic */ TextViewWithCircularIndicator() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (TextViewWithCircularIndicator)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

