/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.content.Context;
import android.content.res.Configuration;
import android.content.res.TypedArray;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.format.DateFormat;
import android.text.format.DateUtils;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityNodeInfo;
import android.view.inputmethod.InputMethodManager;
import android.widget.Button;
import android.widget.EditText;
import android.widget.NumberPicker;
import android.widget.TextView;
import android.widget.TimePicker;
import com.android.internal.R;
import java.util.Calendar;
import java.util.Locale;
import libcore.icu.LocaleData;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class TimePickerClockDelegate
extends TimePicker.AbstractTimePickerDelegate
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static boolean DEFAULT_ENABLED_STATE = true;
    private static int HOURS_IN_HALF_DAY = 12;
    private boolean mIs24HourView;
    private boolean mIsAm;
    private NumberPicker mHourSpinner;
    private NumberPicker mMinuteSpinner;
    private NumberPicker mAmPmSpinner;
    private EditText mHourSpinnerInput;
    private EditText mMinuteSpinnerInput;
    private EditText mAmPmSpinnerInput;
    private TextView mDivider;
    private Button mAmPmButton;
    private String[] mAmPmStrings;
    private boolean mIsEnabled;
    private Calendar mTempCalendar;
    private boolean mHourWithTwoDigit;
    private char mHourFormat;

    private void $$robo$$android_widget_TimePickerClockDelegate$__constructor__(TimePicker delegator, Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        this.mIsEnabled = true;
        TypedArray a = this.mContext.obtainStyledAttributes(attrs, R.styleable.TimePicker, defStyleAttr, defStyleRes);
        int layoutResourceId = a.getResourceId(10, 17367265);
        a.recycle();
        LayoutInflater inflater = LayoutInflater.from(this.mContext);
        inflater.inflate(layoutResourceId, (ViewGroup)this.mDelegator, true);
        this.mHourSpinner = (NumberPicker)delegator.findViewById(16909237);
        this.mHourSpinner.setOnValueChangedListener(new NumberPicker.OnValueChangeListener(this){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ TimePickerClockDelegate this$0;

            private void $$robo$$android_widget_TimePickerClockDelegate_1$__constructor__(TimePickerClockDelegate timePickerClockDelegate) {
            }

            private final void $$robo$$android_widget_TimePickerClockDelegate_1$onValueChange(NumberPicker spinner, int oldVal, int newVal) {
                this.this$0.updateInputState();
                if (!this.this$0.is24HourView() && (oldVal == 11 && newVal == 12 || oldVal == 12 && newVal == 11)) {
                    this.this$0.mIsAm = !this.this$0.mIsAm;
                    this.this$0.updateAmPmControl();
                }
                this.this$0.onTimeChanged();
            }

            private void __constructor__(TimePickerClockDelegate timePickerClockDelegate) {
                this.$$robo$$android_widget_TimePickerClockDelegate_1$__constructor__(timePickerClockDelegate);
            }
            {
                this.this$0 = timePickerClockDelegate;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_TimePickerClockDelegate_1$__constructor__(android.widget.TimePickerClockDelegate ), 0, this, timePickerClockDelegate);
            }

            @Override
            public void onValueChange(NumberPicker numberPicker, int n, int n2) {
                InvokeDynamicSupport.bootstrap("onValueChange", $$robo$$android_widget_TimePickerClockDelegate_1$onValueChange(android.widget.NumberPicker int int ), 0, this, numberPicker, n, n2);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        });
        this.mHourSpinnerInput = (EditText)this.mHourSpinner.findViewById(16909128);
        this.mHourSpinnerInput.setImeOptions(5);
        this.mDivider = (TextView)this.mDelegator.findViewById(16909240);
        if (this.mDivider != null) {
            this.setDividerText();
        }
        this.mMinuteSpinner = (NumberPicker)this.mDelegator.findViewById(16909238);
        this.mMinuteSpinner.setMinValue(0);
        this.mMinuteSpinner.setMaxValue(59);
        this.mMinuteSpinner.setOnLongPressUpdateInterval(100L);
        this.mMinuteSpinner.setFormatter(NumberPicker.getTwoDigitFormatter());
        this.mMinuteSpinner.setOnValueChangedListener(new NumberPicker.OnValueChangeListener(this){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ TimePickerClockDelegate this$0;

            private void $$robo$$android_widget_TimePickerClockDelegate_2$__constructor__(TimePickerClockDelegate timePickerClockDelegate) {
            }

            private final void $$robo$$android_widget_TimePickerClockDelegate_2$onValueChange(NumberPicker spinner, int oldVal, int newVal) {
                this.this$0.updateInputState();
                int minValue = this.this$0.mMinuteSpinner.getMinValue();
                int maxValue = this.this$0.mMinuteSpinner.getMaxValue();
                if (oldVal == maxValue && newVal == minValue) {
                    int newHour = this.this$0.mHourSpinner.getValue() + 1;
                    if (!this.this$0.is24HourView() && newHour == 12) {
                        this.this$0.mIsAm = !this.this$0.mIsAm;
                        this.this$0.updateAmPmControl();
                    }
                    this.this$0.mHourSpinner.setValue(newHour);
                } else if (oldVal == minValue && newVal == maxValue) {
                    int newHour = this.this$0.mHourSpinner.getValue() - 1;
                    if (!this.this$0.is24HourView() && newHour == 11) {
                        this.this$0.mIsAm = !this.this$0.mIsAm;
                        this.this$0.updateAmPmControl();
                    }
                    this.this$0.mHourSpinner.setValue(newHour);
                }
                this.this$0.onTimeChanged();
            }

            private void __constructor__(TimePickerClockDelegate timePickerClockDelegate) {
                this.$$robo$$android_widget_TimePickerClockDelegate_2$__constructor__(timePickerClockDelegate);
            }
            {
                this.this$0 = timePickerClockDelegate;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_TimePickerClockDelegate_2$__constructor__(android.widget.TimePickerClockDelegate ), 0, this, timePickerClockDelegate);
            }

            @Override
            public void onValueChange(NumberPicker numberPicker, int n, int n2) {
                InvokeDynamicSupport.bootstrap("onValueChange", $$robo$$android_widget_TimePickerClockDelegate_2$onValueChange(android.widget.NumberPicker int int ), 0, this, numberPicker, n, n2);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        });
        this.mMinuteSpinnerInput = (EditText)this.mMinuteSpinner.findViewById(16909128);
        this.mMinuteSpinnerInput.setImeOptions(5);
        this.mAmPmStrings = TimePickerClockDelegate.getAmPmStrings(context);
        View amPmView = this.mDelegator.findViewById(16909239);
        if (amPmView instanceof Button) {
            this.mAmPmSpinner = null;
            this.mAmPmSpinnerInput = null;
            this.mAmPmButton = (Button)amPmView;
            this.mAmPmButton.setOnClickListener(new View.OnClickListener(this){
                public transient /* synthetic */ Object __robo_data__;
                /* synthetic */ TimePickerClockDelegate this$0;

                private void $$robo$$android_widget_TimePickerClockDelegate_3$__constructor__(TimePickerClockDelegate timePickerClockDelegate) {
                }

                private final void $$robo$$android_widget_TimePickerClockDelegate_3$onClick(View button) {
                    button.requestFocus();
                    this.this$0.mIsAm = !this.this$0.mIsAm;
                    this.this$0.updateAmPmControl();
                    this.this$0.onTimeChanged();
                }

                private void __constructor__(TimePickerClockDelegate timePickerClockDelegate) {
                    this.$$robo$$android_widget_TimePickerClockDelegate_3$__constructor__(timePickerClockDelegate);
                }
                {
                    this.this$0 = timePickerClockDelegate;
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_TimePickerClockDelegate_3$__constructor__(android.widget.TimePickerClockDelegate ), 0, this, timePickerClockDelegate);
                }

                @Override
                public void onClick(View view) {
                    InvokeDynamicSupport.bootstrap("onClick", $$robo$$android_widget_TimePickerClockDelegate_3$onClick(android.view.View ), 0, this, view);
                }
                {
                    this.$$robo$init();
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            });
        } else {
            this.mAmPmButton = null;
            this.mAmPmSpinner = (NumberPicker)amPmView;
            this.mAmPmSpinner.setMinValue(0);
            this.mAmPmSpinner.setMaxValue(1);
            this.mAmPmSpinner.setDisplayedValues(this.mAmPmStrings);
            this.mAmPmSpinner.setOnValueChangedListener(new NumberPicker.OnValueChangeListener(this){
                public transient /* synthetic */ Object __robo_data__;
                /* synthetic */ TimePickerClockDelegate this$0;

                private void $$robo$$android_widget_TimePickerClockDelegate_4$__constructor__(TimePickerClockDelegate timePickerClockDelegate) {
                }

                private final void $$robo$$android_widget_TimePickerClockDelegate_4$onValueChange(NumberPicker picker, int oldVal, int newVal) {
                    this.this$0.updateInputState();
                    picker.requestFocus();
                    this.this$0.mIsAm = !this.this$0.mIsAm;
                    this.this$0.updateAmPmControl();
                    this.this$0.onTimeChanged();
                }

                private void __constructor__(TimePickerClockDelegate timePickerClockDelegate) {
                    this.$$robo$$android_widget_TimePickerClockDelegate_4$__constructor__(timePickerClockDelegate);
                }
                {
                    this.this$0 = timePickerClockDelegate;
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_TimePickerClockDelegate_4$__constructor__(android.widget.TimePickerClockDelegate ), 0, this, timePickerClockDelegate);
                }

                @Override
                public void onValueChange(NumberPicker numberPicker, int n, int n2) {
                    InvokeDynamicSupport.bootstrap("onValueChange", $$robo$$android_widget_TimePickerClockDelegate_4$onValueChange(android.widget.NumberPicker int int ), 0, this, numberPicker, n, n2);
                }
                {
                    this.$$robo$init();
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            });
            this.mAmPmSpinnerInput = (EditText)this.mAmPmSpinner.findViewById(16909128);
            this.mAmPmSpinnerInput.setImeOptions(6);
        }
        if (this.isAmPmAtStart()) {
            ViewGroup amPmParent = (ViewGroup)delegator.findViewById(16909236);
            amPmParent.removeView(amPmView);
            amPmParent.addView(amPmView, 0);
            ViewGroup.MarginLayoutParams lp = (ViewGroup.MarginLayoutParams)amPmView.getLayoutParams();
            int startMargin = lp.getMarginStart();
            int endMargin = lp.getMarginEnd();
            if (startMargin != endMargin) {
                lp.setMarginStart(endMargin);
                lp.setMarginEnd(startMargin);
            }
        }
        this.getHourFormatData();
        this.updateHourControl();
        this.updateMinuteControl();
        this.updateAmPmControl();
        this.setCurrentHour(this.mTempCalendar.get(11));
        this.setCurrentMinute(this.mTempCalendar.get(12));
        if (!this.isEnabled()) {
            this.setEnabled(false);
        }
        this.setContentDescriptions();
        if (this.mDelegator.getImportantForAccessibility() == 0) {
            this.mDelegator.setImportantForAccessibility(1);
        }
    }

    private final void $$robo$$android_widget_TimePickerClockDelegate$getHourFormatData() {
        String bestDateTimePattern = DateFormat.getBestDateTimePattern(this.mCurrentLocale, this.mIs24HourView ? "Hm" : "hm");
        int lengthPattern = bestDateTimePattern.length();
        this.mHourWithTwoDigit = false;
        boolean hourFormat = false;
        for (int i = 0; i < lengthPattern; ++i) {
            char c = bestDateTimePattern.charAt(i);
            if (c != 'H' && c != 'h' && c != 'K' && c != 'k') continue;
            this.mHourFormat = c;
            if (i + 1 >= lengthPattern || c != bestDateTimePattern.charAt(i + 1)) break;
            this.mHourWithTwoDigit = true;
            break;
        }
    }

    private final boolean $$robo$$android_widget_TimePickerClockDelegate$isAmPmAtStart() {
        String bestDateTimePattern = DateFormat.getBestDateTimePattern(this.mCurrentLocale, "hm");
        return bestDateTimePattern.startsWith("a");
    }

    private final void $$robo$$android_widget_TimePickerClockDelegate$setDividerText() {
        int minuteIndex;
        String skeleton = this.mIs24HourView ? "Hm" : "hm";
        String bestDateTimePattern = DateFormat.getBestDateTimePattern(this.mCurrentLocale, skeleton);
        int hourIndex = bestDateTimePattern.lastIndexOf(72);
        if (hourIndex == -1) {
            hourIndex = bestDateTimePattern.lastIndexOf(104);
        }
        String separatorText = hourIndex == -1 ? ":" : ((minuteIndex = bestDateTimePattern.indexOf(109, hourIndex + 1)) == -1 ? Character.toString(bestDateTimePattern.charAt(hourIndex + 1)) : bestDateTimePattern.substring(hourIndex + 1, minuteIndex));
        this.mDivider.setText(separatorText);
    }

    private final void $$robo$$android_widget_TimePickerClockDelegate$setCurrentHour(Integer currentHour) {
        this.setCurrentHour(currentHour, true);
    }

    private final void $$robo$$android_widget_TimePickerClockDelegate$setCurrentHour(Integer currentHour, boolean notifyTimeChanged) {
        if (currentHour == null || currentHour == this.getCurrentHour()) {
            return;
        }
        if (!this.is24HourView()) {
            if (currentHour >= 12) {
                this.mIsAm = false;
                if (currentHour > 12) {
                    currentHour = currentHour - 12;
                }
            } else {
                this.mIsAm = true;
                if (currentHour == 0) {
                    currentHour = 12;
                }
            }
            this.updateAmPmControl();
        }
        this.mHourSpinner.setValue(currentHour);
        if (notifyTimeChanged) {
            this.onTimeChanged();
        }
    }

    private final Integer $$robo$$android_widget_TimePickerClockDelegate$getCurrentHour() {
        int currentHour = this.mHourSpinner.getValue();
        if (this.is24HourView()) {
            return currentHour;
        }
        if (this.mIsAm) {
            return currentHour % 12;
        }
        return currentHour % 12 + 12;
    }

    private final void $$robo$$android_widget_TimePickerClockDelegate$setCurrentMinute(Integer currentMinute) {
        if (currentMinute == this.getCurrentMinute()) {
            return;
        }
        this.mMinuteSpinner.setValue(currentMinute);
        this.onTimeChanged();
    }

    private final Integer $$robo$$android_widget_TimePickerClockDelegate$getCurrentMinute() {
        return this.mMinuteSpinner.getValue();
    }

    private final void $$robo$$android_widget_TimePickerClockDelegate$setIs24HourView(Boolean is24HourView) {
        if (this.mIs24HourView == is24HourView) {
            return;
        }
        int currentHour = this.getCurrentHour();
        this.mIs24HourView = is24HourView;
        this.getHourFormatData();
        this.updateHourControl();
        this.setCurrentHour(currentHour, false);
        this.updateMinuteControl();
        this.updateAmPmControl();
    }

    private final boolean $$robo$$android_widget_TimePickerClockDelegate$is24HourView() {
        return this.mIs24HourView;
    }

    private final void $$robo$$android_widget_TimePickerClockDelegate$setOnTimeChangedListener(TimePicker.OnTimeChangedListener onTimeChangedListener) {
        this.mOnTimeChangedListener = onTimeChangedListener;
    }

    private final void $$robo$$android_widget_TimePickerClockDelegate$setEnabled(boolean enabled) {
        this.mMinuteSpinner.setEnabled(enabled);
        if (this.mDivider != null) {
            this.mDivider.setEnabled(enabled);
        }
        this.mHourSpinner.setEnabled(enabled);
        if (this.mAmPmSpinner != null) {
            this.mAmPmSpinner.setEnabled(enabled);
        } else {
            this.mAmPmButton.setEnabled(enabled);
        }
        this.mIsEnabled = enabled;
    }

    private final boolean $$robo$$android_widget_TimePickerClockDelegate$isEnabled() {
        return this.mIsEnabled;
    }

    private final int $$robo$$android_widget_TimePickerClockDelegate$getBaseline() {
        return this.mHourSpinner.getBaseline();
    }

    private final void $$robo$$android_widget_TimePickerClockDelegate$onConfigurationChanged(Configuration newConfig) {
        this.setCurrentLocale(newConfig.locale);
    }

    private final Parcelable $$robo$$android_widget_TimePickerClockDelegate$onSaveInstanceState(Parcelable superState) {
        return new SavedState(superState, this.getCurrentHour(), this.getCurrentMinute());
    }

    private final void $$robo$$android_widget_TimePickerClockDelegate$onRestoreInstanceState(Parcelable state) {
        SavedState ss = (SavedState)state;
        this.setCurrentHour(ss.getHour());
        this.setCurrentMinute(ss.getMinute());
    }

    private final boolean $$robo$$android_widget_TimePickerClockDelegate$dispatchPopulateAccessibilityEvent(AccessibilityEvent event) {
        this.onPopulateAccessibilityEvent(event);
        return true;
    }

    private final void $$robo$$android_widget_TimePickerClockDelegate$onPopulateAccessibilityEvent(AccessibilityEvent event) {
        int flags = 1;
        flags = this.mIs24HourView ? (flags |= 0x80) : (flags |= 0x40);
        this.mTempCalendar.set(11, this.getCurrentHour());
        this.mTempCalendar.set(12, this.getCurrentMinute());
        String selectedDateUtterance = DateUtils.formatDateTime(this.mContext, this.mTempCalendar.getTimeInMillis(), flags);
        event.getText().add(selectedDateUtterance);
    }

    private final void $$robo$$android_widget_TimePickerClockDelegate$onInitializeAccessibilityEvent(AccessibilityEvent event) {
        event.setClassName(TimePicker.class.getName());
    }

    private final void $$robo$$android_widget_TimePickerClockDelegate$onInitializeAccessibilityNodeInfo(AccessibilityNodeInfo info) {
        info.setClassName(TimePicker.class.getName());
    }

    private final void $$robo$$android_widget_TimePickerClockDelegate$updateInputState() {
        InputMethodManager inputMethodManager = InputMethodManager.peekInstance();
        if (inputMethodManager != null) {
            if (inputMethodManager.isActive(this.mHourSpinnerInput)) {
                this.mHourSpinnerInput.clearFocus();
                inputMethodManager.hideSoftInputFromWindow(this.mDelegator.getWindowToken(), 0);
            } else if (inputMethodManager.isActive(this.mMinuteSpinnerInput)) {
                this.mMinuteSpinnerInput.clearFocus();
                inputMethodManager.hideSoftInputFromWindow(this.mDelegator.getWindowToken(), 0);
            } else if (inputMethodManager.isActive(this.mAmPmSpinnerInput)) {
                this.mAmPmSpinnerInput.clearFocus();
                inputMethodManager.hideSoftInputFromWindow(this.mDelegator.getWindowToken(), 0);
            }
        }
    }

    private final void $$robo$$android_widget_TimePickerClockDelegate$updateAmPmControl() {
        if (this.is24HourView()) {
            if (this.mAmPmSpinner != null) {
                this.mAmPmSpinner.setVisibility(8);
            } else {
                this.mAmPmButton.setVisibility(8);
            }
        } else {
            int index;
            int n = index = this.mIsAm ? 0 : 1;
            if (this.mAmPmSpinner != null) {
                this.mAmPmSpinner.setValue(index);
                this.mAmPmSpinner.setVisibility(0);
            } else {
                this.mAmPmButton.setText(this.mAmPmStrings[index]);
                this.mAmPmButton.setVisibility(0);
            }
        }
        this.mDelegator.sendAccessibilityEvent(4);
    }

    private final void $$robo$$android_widget_TimePickerClockDelegate$setCurrentLocale(Locale locale) {
        super.setCurrentLocale(locale);
        this.mTempCalendar = Calendar.getInstance(locale);
    }

    private final void $$robo$$android_widget_TimePickerClockDelegate$onTimeChanged() {
        this.mDelegator.sendAccessibilityEvent(4);
        if (this.mOnTimeChangedListener != null) {
            this.mOnTimeChangedListener.onTimeChanged(this.mDelegator, this.getCurrentHour(), this.getCurrentMinute());
        }
    }

    private final void $$robo$$android_widget_TimePickerClockDelegate$updateHourControl() {
        if (this.is24HourView()) {
            if (this.mHourFormat == 'k') {
                this.mHourSpinner.setMinValue(1);
                this.mHourSpinner.setMaxValue(24);
            } else {
                this.mHourSpinner.setMinValue(0);
                this.mHourSpinner.setMaxValue(23);
            }
        } else if (this.mHourFormat == 'K') {
            this.mHourSpinner.setMinValue(0);
            this.mHourSpinner.setMaxValue(11);
        } else {
            this.mHourSpinner.setMinValue(1);
            this.mHourSpinner.setMaxValue(12);
        }
        this.mHourSpinner.setFormatter(this.mHourWithTwoDigit ? NumberPicker.getTwoDigitFormatter() : null);
    }

    private final void $$robo$$android_widget_TimePickerClockDelegate$updateMinuteControl() {
        if (this.is24HourView()) {
            this.mMinuteSpinnerInput.setImeOptions(6);
        } else {
            this.mMinuteSpinnerInput.setImeOptions(5);
        }
    }

    private final void $$robo$$android_widget_TimePickerClockDelegate$setContentDescriptions() {
        this.trySetContentDescription(this.mMinuteSpinner, 16909127, 17040751);
        this.trySetContentDescription(this.mMinuteSpinner, 16909129, 17040752);
        this.trySetContentDescription(this.mHourSpinner, 16909127, 17040753);
        this.trySetContentDescription(this.mHourSpinner, 16909129, 17040754);
        if (this.mAmPmSpinner != null) {
            this.trySetContentDescription(this.mAmPmSpinner, 16909127, 17040755);
            this.trySetContentDescription(this.mAmPmSpinner, 16909129, 17040756);
        }
    }

    private final void $$robo$$android_widget_TimePickerClockDelegate$trySetContentDescription(View root, int viewId, int contDescResId) {
        View target = root.findViewById(viewId);
        if (target != null) {
            target.setContentDescription(this.mContext.getString(contDescResId));
        }
    }

    private static final String[] $$robo$$android_widget_TimePickerClockDelegate$getAmPmStrings(Context context) {
        String[] result = new String[2];
        LocaleData d = LocaleData.get(context.getResources().getConfiguration().locale);
        result[0] = d.amPm[0].length() > 2 ? d.narrowAm : d.amPm[0];
        result[1] = d.amPm[1].length() > 2 ? d.narrowPm : d.amPm[1];
        return result;
    }

    private void __constructor__(TimePicker timePicker, Context context, AttributeSet attributeSet, int n, int n2) {
        this.$$robo$$android_widget_TimePickerClockDelegate$__constructor__(timePicker, context, attributeSet, n, n2);
    }

    public TimePickerClockDelegate(TimePicker timePicker, Context context, AttributeSet attributeSet, int n, int n2) {
        super(timePicker, context);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_TimePickerClockDelegate$__constructor__(android.widget.TimePicker android.content.Context android.util.AttributeSet int int ), 0, this, timePicker, context, attributeSet, n, n2);
    }

    private void getHourFormatData() {
        InvokeDynamicSupport.bootstrap("getHourFormatData", $$robo$$android_widget_TimePickerClockDelegate$getHourFormatData(), 0, this);
    }

    private boolean isAmPmAtStart() {
        return (boolean)InvokeDynamicSupport.bootstrap("isAmPmAtStart", $$robo$$android_widget_TimePickerClockDelegate$isAmPmAtStart(), 0, this);
    }

    private void setDividerText() {
        InvokeDynamicSupport.bootstrap("setDividerText", $$robo$$android_widget_TimePickerClockDelegate$setDividerText(), 0, this);
    }

    @Override
    public void setCurrentHour(Integer n) {
        InvokeDynamicSupport.bootstrap("setCurrentHour", $$robo$$android_widget_TimePickerClockDelegate$setCurrentHour(java.lang.Integer ), 0, this, n);
    }

    private void setCurrentHour(Integer n, boolean bl) {
        InvokeDynamicSupport.bootstrap("setCurrentHour", $$robo$$android_widget_TimePickerClockDelegate$setCurrentHour(java.lang.Integer boolean ), 0, this, n, bl);
    }

    @Override
    public Integer getCurrentHour() {
        return InvokeDynamicSupport.bootstrap("getCurrentHour", $$robo$$android_widget_TimePickerClockDelegate$getCurrentHour(), 0, this);
    }

    @Override
    public void setCurrentMinute(Integer n) {
        InvokeDynamicSupport.bootstrap("setCurrentMinute", $$robo$$android_widget_TimePickerClockDelegate$setCurrentMinute(java.lang.Integer ), 0, this, n);
    }

    @Override
    public Integer getCurrentMinute() {
        return InvokeDynamicSupport.bootstrap("getCurrentMinute", $$robo$$android_widget_TimePickerClockDelegate$getCurrentMinute(), 0, this);
    }

    @Override
    public void setIs24HourView(Boolean bl) {
        InvokeDynamicSupport.bootstrap("setIs24HourView", $$robo$$android_widget_TimePickerClockDelegate$setIs24HourView(java.lang.Boolean ), 0, this, bl);
    }

    @Override
    public boolean is24HourView() {
        return (boolean)InvokeDynamicSupport.bootstrap("is24HourView", $$robo$$android_widget_TimePickerClockDelegate$is24HourView(), 0, this);
    }

    @Override
    public void setOnTimeChangedListener(TimePicker.OnTimeChangedListener onTimeChangedListener) {
        InvokeDynamicSupport.bootstrap("setOnTimeChangedListener", $$robo$$android_widget_TimePickerClockDelegate$setOnTimeChangedListener(android.widget.TimePicker$OnTimeChangedListener ), 0, this, onTimeChangedListener);
    }

    @Override
    public void setEnabled(boolean bl) {
        InvokeDynamicSupport.bootstrap("setEnabled", $$robo$$android_widget_TimePickerClockDelegate$setEnabled(boolean ), 0, this, bl);
    }

    @Override
    public boolean isEnabled() {
        return (boolean)InvokeDynamicSupport.bootstrap("isEnabled", $$robo$$android_widget_TimePickerClockDelegate$isEnabled(), 0, this);
    }

    @Override
    public int getBaseline() {
        return (int)InvokeDynamicSupport.bootstrap("getBaseline", $$robo$$android_widget_TimePickerClockDelegate$getBaseline(), 0, this);
    }

    @Override
    public void onConfigurationChanged(Configuration configuration) {
        InvokeDynamicSupport.bootstrap("onConfigurationChanged", $$robo$$android_widget_TimePickerClockDelegate$onConfigurationChanged(android.content.res.Configuration ), 0, this, configuration);
    }

    @Override
    public Parcelable onSaveInstanceState(Parcelable parcelable) {
        return InvokeDynamicSupport.bootstrap("onSaveInstanceState", $$robo$$android_widget_TimePickerClockDelegate$onSaveInstanceState(android.os.Parcelable ), 0, this, parcelable);
    }

    @Override
    public void onRestoreInstanceState(Parcelable parcelable) {
        InvokeDynamicSupport.bootstrap("onRestoreInstanceState", $$robo$$android_widget_TimePickerClockDelegate$onRestoreInstanceState(android.os.Parcelable ), 0, this, parcelable);
    }

    @Override
    public boolean dispatchPopulateAccessibilityEvent(AccessibilityEvent accessibilityEvent) {
        return (boolean)InvokeDynamicSupport.bootstrap("dispatchPopulateAccessibilityEvent", $$robo$$android_widget_TimePickerClockDelegate$dispatchPopulateAccessibilityEvent(android.view.accessibility.AccessibilityEvent ), 0, this, accessibilityEvent);
    }

    @Override
    public void onPopulateAccessibilityEvent(AccessibilityEvent accessibilityEvent) {
        InvokeDynamicSupport.bootstrap("onPopulateAccessibilityEvent", $$robo$$android_widget_TimePickerClockDelegate$onPopulateAccessibilityEvent(android.view.accessibility.AccessibilityEvent ), 0, this, accessibilityEvent);
    }

    @Override
    public void onInitializeAccessibilityEvent(AccessibilityEvent accessibilityEvent) {
        InvokeDynamicSupport.bootstrap("onInitializeAccessibilityEvent", $$robo$$android_widget_TimePickerClockDelegate$onInitializeAccessibilityEvent(android.view.accessibility.AccessibilityEvent ), 0, this, accessibilityEvent);
    }

    @Override
    public void onInitializeAccessibilityNodeInfo(AccessibilityNodeInfo accessibilityNodeInfo) {
        InvokeDynamicSupport.bootstrap("onInitializeAccessibilityNodeInfo", $$robo$$android_widget_TimePickerClockDelegate$onInitializeAccessibilityNodeInfo(android.view.accessibility.AccessibilityNodeInfo ), 0, this, accessibilityNodeInfo);
    }

    private void updateInputState() {
        InvokeDynamicSupport.bootstrap("updateInputState", $$robo$$android_widget_TimePickerClockDelegate$updateInputState(), 0, this);
    }

    private void updateAmPmControl() {
        InvokeDynamicSupport.bootstrap("updateAmPmControl", $$robo$$android_widget_TimePickerClockDelegate$updateAmPmControl(), 0, this);
    }

    @Override
    public void setCurrentLocale(Locale locale) {
        InvokeDynamicSupport.bootstrap("setCurrentLocale", $$robo$$android_widget_TimePickerClockDelegate$setCurrentLocale(java.util.Locale ), 0, this, locale);
    }

    private void onTimeChanged() {
        InvokeDynamicSupport.bootstrap("onTimeChanged", $$robo$$android_widget_TimePickerClockDelegate$onTimeChanged(), 0, this);
    }

    private void updateHourControl() {
        InvokeDynamicSupport.bootstrap("updateHourControl", $$robo$$android_widget_TimePickerClockDelegate$updateHourControl(), 0, this);
    }

    private void updateMinuteControl() {
        InvokeDynamicSupport.bootstrap("updateMinuteControl", $$robo$$android_widget_TimePickerClockDelegate$updateMinuteControl(), 0, this);
    }

    private void setContentDescriptions() {
        InvokeDynamicSupport.bootstrap("setContentDescriptions", $$robo$$android_widget_TimePickerClockDelegate$setContentDescriptions(), 0, this);
    }

    private void trySetContentDescription(View view, int n, int n2) {
        InvokeDynamicSupport.bootstrap("trySetContentDescription", $$robo$$android_widget_TimePickerClockDelegate$trySetContentDescription(android.view.View int int ), 0, this, view, n, n2);
    }

    public static String[] getAmPmStrings(Context context) {
        return InvokeDynamicSupport.bootstrapStatic("getAmPmStrings", $$robo$$android_widget_TimePickerClockDelegate$getAmPmStrings(android.content.Context ), 0, (Context)context);
    }

    public /* synthetic */ TimePickerClockDelegate() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (TimePickerClockDelegate)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    private static class SavedState
    extends View.BaseSavedState
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private int mHour;
        private int mMinute;
        public static Parcelable.Creator<SavedState> CREATOR;

        private void $$robo$$android_widget_TimePickerClockDelegate_SavedState$__constructor__(Parcelable superState, int hour, int minute) {
            this.mHour = hour;
            this.mMinute = minute;
        }

        private void $$robo$$android_widget_TimePickerClockDelegate_SavedState$__constructor__(Parcel in) {
            this.mHour = in.readInt();
            this.mMinute = in.readInt();
        }

        private final int $$robo$$android_widget_TimePickerClockDelegate_SavedState$getHour() {
            return this.mHour;
        }

        private final int $$robo$$android_widget_TimePickerClockDelegate_SavedState$getMinute() {
            return this.mMinute;
        }

        private final void $$robo$$android_widget_TimePickerClockDelegate_SavedState$writeToParcel(Parcel dest, int flags) {
            super.writeToParcel(dest, flags);
            dest.writeInt(this.mHour);
            dest.writeInt(this.mMinute);
        }

        private /* synthetic */ void $$robo$$android_widget_TimePickerClockDelegate_SavedState$__constructor__(Parcelable x0, int x1, int x2, 1 x3) {
        }

        private /* synthetic */ void $$robo$$android_widget_TimePickerClockDelegate_SavedState$__constructor__(Parcel x0, 1 x1) {
        }

        static void __staticInitializer__() {
            CREATOR = new Parcelable.Creator<SavedState>(){
                public transient /* synthetic */ Object __robo_data__;

                private void $$robo$$android_widget_TimePickerClockDelegate_SavedState_1$__constructor__() {
                }

                private final SavedState $$robo$$android_widget_TimePickerClockDelegate_SavedState_1$createFromParcel(Parcel in) {
                    return new SavedState(in);
                }

                private final SavedState[] $$robo$$android_widget_TimePickerClockDelegate_SavedState_1$newArray(int size) {
                    return new SavedState[size];
                }

                private void __constructor__() {
                    this.$$robo$$android_widget_TimePickerClockDelegate_SavedState_1$__constructor__();
                }
                {
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_TimePickerClockDelegate_SavedState_1$__constructor__(), 0, this);
                }

                @Override
                public SavedState createFromParcel(Parcel parcel) {
                    return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_widget_TimePickerClockDelegate_SavedState_1$createFromParcel(android.os.Parcel ), 0, this, parcel);
                }

                public SavedState[] newArray(int n) {
                    return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_widget_TimePickerClockDelegate_SavedState_1$newArray(int ), 0, this, n);
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            };
        }

        private void __constructor__(Parcelable parcelable, int n, int n2) {
            this.$$robo$$android_widget_TimePickerClockDelegate_SavedState$__constructor__(parcelable, n, n2);
        }

        private SavedState(Parcelable parcelable, int n, int n2) {
            super(parcelable);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_TimePickerClockDelegate_SavedState$__constructor__(android.os.Parcelable int int ), 0, this, parcelable, n, n2);
        }

        private void __constructor__(Parcel parcel) {
            this.$$robo$$android_widget_TimePickerClockDelegate_SavedState$__constructor__(parcel);
        }

        private SavedState(Parcel parcel) {
            super(parcel);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_TimePickerClockDelegate_SavedState$__constructor__(android.os.Parcel ), 0, this, parcel);
        }

        public int getHour() {
            return (int)InvokeDynamicSupport.bootstrap("getHour", $$robo$$android_widget_TimePickerClockDelegate_SavedState$getHour(), 0, this);
        }

        public int getMinute() {
            return (int)InvokeDynamicSupport.bootstrap("getMinute", $$robo$$android_widget_TimePickerClockDelegate_SavedState$getMinute(), 0, this);
        }

        @Override
        public void writeToParcel(Parcel parcel, int n) {
            InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_widget_TimePickerClockDelegate_SavedState$writeToParcel(android.os.Parcel int ), 0, this, parcel, n);
        }

        private /* synthetic */ void __constructor__(Parcelable parcelable, int n, int n2, 1 var4_4) {
            this.$$robo$$android_widget_TimePickerClockDelegate_SavedState$__constructor__(parcelable, n, n2, var4_4);
        }

        private /* synthetic */ void __constructor__(Parcel parcel, 1 var2_2) {
            this.$$robo$$android_widget_TimePickerClockDelegate_SavedState$__constructor__(parcel, var2_2);
        }

        static {
            RobolectricInternals.classInitializing(SavedState.class);
        }

        public /* synthetic */ SavedState() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SavedState)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

