/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import android.text.format.DateFormat;
import android.text.format.DateUtils;
import android.util.AttributeSet;
import android.util.Log;
import android.view.KeyCharacterMap;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityNodeInfo;
import android.widget.RadialTimePickerView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import android.widget.TimePicker;
import android.widget.TimePickerClockDelegate;
import com.android.internal.R;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Locale;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class TimePickerSpinnerDelegate
extends TimePicker.AbstractTimePickerDelegate
implements RadialTimePickerView.OnValueSelectedListener,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "TimePickerDelegate";
    private static int HOUR_INDEX = 0;
    private static int MINUTE_INDEX = 1;
    private static int AMPM_INDEX = 2;
    private static int ENABLE_PICKER_INDEX = 3;
    private static int AM = 0;
    private static int PM = 1;
    private static boolean DEFAULT_ENABLED_STATE = true;
    private boolean mIsEnabled;
    private static int HOURS_IN_HALF_DAY = 12;
    private View mHeaderView;
    private TextView mHourView;
    private TextView mMinuteView;
    private TextView mAmPmTextView;
    private RadialTimePickerView mRadialTimePickerView;
    private TextView mSeparatorView;
    private String mAmText;
    private String mPmText;
    private boolean mAllowAutoAdvance;
    private int mInitialHourOfDay;
    private int mInitialMinute;
    private boolean mIs24HourView;
    private char mPlaceholderText;
    private String mDoublePlaceholderText;
    private String mDeletedKeyFormat;
    private boolean mInKbMode;
    private ArrayList<Integer> mTypedTimes;
    private Node mLegalTimesTree;
    private int mAmKeyCode;
    private int mPmKeyCode;
    private String mHourPickerDescription;
    private String mSelectHours;
    private String mMinutePickerDescription;
    private String mSelectMinutes;
    private Calendar mTempCalendar;
    private View.OnKeyListener mKeyListener;
    private View.OnFocusChangeListener mFocusListener;

    private void $$robo$$android_widget_TimePickerSpinnerDelegate$__constructor__(TimePicker delegator, Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        this.mIsEnabled = true;
        this.mTypedTimes = new ArrayList();
        this.mKeyListener = new View.OnKeyListener(this){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ TimePickerSpinnerDelegate this$0;

            private void $$robo$$android_widget_TimePickerSpinnerDelegate_4$__constructor__(TimePickerSpinnerDelegate timePickerSpinnerDelegate) {
            }

            private final boolean $$robo$$android_widget_TimePickerSpinnerDelegate_4$onKey(View v, int keyCode, KeyEvent event) {
                if (event.getAction() == 1) {
                    return this.this$0.processKeyUp(keyCode);
                }
                return false;
            }

            private void __constructor__(TimePickerSpinnerDelegate timePickerSpinnerDelegate) {
                this.$$robo$$android_widget_TimePickerSpinnerDelegate_4$__constructor__(timePickerSpinnerDelegate);
            }
            {
                this.this$0 = timePickerSpinnerDelegate;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_TimePickerSpinnerDelegate_4$__constructor__(android.widget.TimePickerSpinnerDelegate ), 0, this, timePickerSpinnerDelegate);
            }

            @Override
            public boolean onKey(View view, int n, KeyEvent keyEvent) {
                return (boolean)InvokeDynamicSupport.bootstrap("onKey", $$robo$$android_widget_TimePickerSpinnerDelegate_4$onKey(android.view.View int android.view.KeyEvent ), 0, this, view, n, keyEvent);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.mFocusListener = new View.OnFocusChangeListener(this){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ TimePickerSpinnerDelegate this$0;

            private void $$robo$$android_widget_TimePickerSpinnerDelegate_5$__constructor__(TimePickerSpinnerDelegate timePickerSpinnerDelegate) {
            }

            private final void $$robo$$android_widget_TimePickerSpinnerDelegate_5$onFocusChange(View v, boolean hasFocus) {
                if (!hasFocus && this.this$0.mInKbMode && this.this$0.isTypedTimeFullyLegal()) {
                    this.this$0.finishKbMode();
                    if (this.this$0.mOnTimeChangedListener != null) {
                        this.this$0.mOnTimeChangedListener.onTimeChanged(this.this$0.mDelegator, this.this$0.mRadialTimePickerView.getCurrentHour(), this.this$0.mRadialTimePickerView.getCurrentMinute());
                    }
                }
            }

            private void __constructor__(TimePickerSpinnerDelegate timePickerSpinnerDelegate) {
                this.$$robo$$android_widget_TimePickerSpinnerDelegate_5$__constructor__(timePickerSpinnerDelegate);
            }
            {
                this.this$0 = timePickerSpinnerDelegate;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_TimePickerSpinnerDelegate_5$__constructor__(android.widget.TimePickerSpinnerDelegate ), 0, this, timePickerSpinnerDelegate);
            }

            @Override
            public void onFocusChange(View view, boolean bl) {
                InvokeDynamicSupport.bootstrap("onFocusChange", $$robo$$android_widget_TimePickerSpinnerDelegate_5$onFocusChange(android.view.View boolean ), 0, this, view, bl);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        TypedArray a = this.mContext.obtainStyledAttributes(attrs, R.styleable.TimePicker, defStyleAttr, defStyleRes);
        LayoutInflater inflater = (LayoutInflater)this.mContext.getSystemService("layout_inflater");
        Resources res = this.mContext.getResources();
        this.mHourPickerDescription = res.getString(17040995);
        this.mSelectHours = res.getString(17040997);
        this.mMinutePickerDescription = res.getString(17040996);
        this.mSelectMinutes = res.getString(17040998);
        String[] amPmStrings = TimePickerClockDelegate.getAmPmStrings(context);
        this.mAmText = amPmStrings[0];
        this.mPmText = amPmStrings[1];
        int layoutResourceId = a.getResourceId(9, 17367264);
        View mainView = inflater.inflate(layoutResourceId, null);
        this.mDelegator.addView(mainView);
        this.mHourView = (TextView)mainView.findViewById(16909230);
        this.mSeparatorView = (TextView)mainView.findViewById(16909231);
        this.mMinuteView = (TextView)mainView.findViewById(16909232);
        this.mAmPmTextView = (TextView)mainView.findViewById(16909233);
        int headerTimeTextAppearance = a.getResourceId(1, 0);
        if (headerTimeTextAppearance != 0) {
            this.mHourView.setTextAppearance(context, headerTimeTextAppearance);
            this.mSeparatorView.setTextAppearance(context, headerTimeTextAppearance);
            this.mMinuteView.setTextAppearance(context, headerTimeTextAppearance);
        }
        int headerSelectedTextColor = a.getColor(11, res.getColor(17170669));
        this.mHourView.setTextColor(ColorStateList.addFirstIfMissing(this.mHourView.getTextColors(), 0x10100A1, headerSelectedTextColor));
        this.mMinuteView.setTextColor(ColorStateList.addFirstIfMissing(this.mMinuteView.getTextColors(), 0x10100A1, headerSelectedTextColor));
        int headerAmPmTextAppearance = a.getResourceId(2, 0);
        if (headerAmPmTextAppearance != 0) {
            this.mAmPmTextView.setTextAppearance(context, headerAmPmTextAppearance);
        }
        this.mHeaderView = mainView.findViewById(16909229);
        this.mHeaderView.setBackground(a.getDrawable(0));
        a.recycle();
        this.mRadialTimePickerView = (RadialTimePickerView)mainView.findViewById(16909235);
        this.setupListeners();
        this.mAllowAutoAdvance = true;
        this.mDoublePlaceholderText = res.getString(17041006);
        this.mDeletedKeyFormat = res.getString(17041004);
        this.mPlaceholderText = this.mDoublePlaceholderText.charAt(0);
        this.mPmKeyCode = -1;
        this.mAmKeyCode = -1;
        this.generateLegalTimesTree();
        Calendar calendar = Calendar.getInstance(this.mCurrentLocale);
        int currentHour = calendar.get(11);
        int currentMinute = calendar.get(12);
        this.initialize(currentHour, currentMinute, false, 0);
    }

    private final void $$robo$$android_widget_TimePickerSpinnerDelegate$initialize(int hourOfDay, int minute, boolean is24HourView, int index) {
        this.mInitialHourOfDay = hourOfDay;
        this.mInitialMinute = minute;
        this.mIs24HourView = is24HourView;
        this.mInKbMode = false;
        this.updateUI(index);
    }

    private final void $$robo$$android_widget_TimePickerSpinnerDelegate$setupListeners() {
        this.mHeaderView.setOnKeyListener(this.mKeyListener);
        this.mHeaderView.setOnFocusChangeListener(this.mFocusListener);
        this.mHeaderView.setFocusable(true);
        this.mRadialTimePickerView.setOnValueSelectedListener(this);
        this.mHourView.setOnClickListener(new View.OnClickListener(this){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ TimePickerSpinnerDelegate this$0;

            private void $$robo$$android_widget_TimePickerSpinnerDelegate_1$__constructor__(TimePickerSpinnerDelegate timePickerSpinnerDelegate) {
            }

            private final void $$robo$$android_widget_TimePickerSpinnerDelegate_1$onClick(View v) {
                this.this$0.setCurrentItemShowing(0, true, true);
                this.this$0.tryVibrate();
            }

            private void __constructor__(TimePickerSpinnerDelegate timePickerSpinnerDelegate) {
                this.$$robo$$android_widget_TimePickerSpinnerDelegate_1$__constructor__(timePickerSpinnerDelegate);
            }
            {
                this.this$0 = timePickerSpinnerDelegate;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_TimePickerSpinnerDelegate_1$__constructor__(android.widget.TimePickerSpinnerDelegate ), 0, this, timePickerSpinnerDelegate);
            }

            @Override
            public void onClick(View view) {
                InvokeDynamicSupport.bootstrap("onClick", $$robo$$android_widget_TimePickerSpinnerDelegate_1$onClick(android.view.View ), 0, this, view);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        });
        this.mMinuteView.setOnClickListener(new View.OnClickListener(this){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ TimePickerSpinnerDelegate this$0;

            private void $$robo$$android_widget_TimePickerSpinnerDelegate_2$__constructor__(TimePickerSpinnerDelegate timePickerSpinnerDelegate) {
            }

            private final void $$robo$$android_widget_TimePickerSpinnerDelegate_2$onClick(View v) {
                this.this$0.setCurrentItemShowing(1, true, true);
                this.this$0.tryVibrate();
            }

            private void __constructor__(TimePickerSpinnerDelegate timePickerSpinnerDelegate) {
                this.$$robo$$android_widget_TimePickerSpinnerDelegate_2$__constructor__(timePickerSpinnerDelegate);
            }
            {
                this.this$0 = timePickerSpinnerDelegate;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_TimePickerSpinnerDelegate_2$__constructor__(android.widget.TimePickerSpinnerDelegate ), 0, this, timePickerSpinnerDelegate);
            }

            @Override
            public void onClick(View view) {
                InvokeDynamicSupport.bootstrap("onClick", $$robo$$android_widget_TimePickerSpinnerDelegate_2$onClick(android.view.View ), 0, this, view);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        });
    }

    private final void $$robo$$android_widget_TimePickerSpinnerDelegate$updateUI(int index) {
        this.updateRadialPicker(index);
        this.updateHeaderAmPm();
        this.updateHeaderHour(this.mInitialHourOfDay, true);
        this.updateHeaderSeparator();
        this.updateHeaderMinute(this.mInitialMinute);
        this.mDelegator.invalidate();
    }

    private final void $$robo$$android_widget_TimePickerSpinnerDelegate$updateRadialPicker(int index) {
        this.mRadialTimePickerView.initialize(this.mInitialHourOfDay, this.mInitialMinute, this.mIs24HourView);
        this.setCurrentItemShowing(index, false, true);
    }

    private final int $$robo$$android_widget_TimePickerSpinnerDelegate$computeMaxWidthOfNumbers(int max) {
        TextView tempView = new TextView(this.mContext);
        tempView.setTextAppearance(this.mContext, 16974879);
        ViewGroup.LayoutParams lp = new ViewGroup.LayoutParams(-2, -2);
        tempView.setLayoutParams(lp);
        int maxWidth = 0;
        for (int minutes = 0; minutes < max; ++minutes) {
            String text = String.format("%02d", minutes);
            tempView.setText(text);
            tempView.measure(0, 0);
            maxWidth = Math.max(maxWidth, tempView.getMeasuredWidth());
        }
        return maxWidth;
    }

    private final void $$robo$$android_widget_TimePickerSpinnerDelegate$updateHeaderAmPm() {
        if (this.mIs24HourView) {
            this.mAmPmTextView.setVisibility(8);
        } else {
            this.mAmPmTextView.setVisibility(0);
            String bestDateTimePattern = DateFormat.getBestDateTimePattern(this.mCurrentLocale, "hm");
            boolean amPmOnLeft = bestDateTimePattern.startsWith("a");
            if (TextUtils.getLayoutDirectionFromLocale(this.mCurrentLocale) == 1) {
                amPmOnLeft = !amPmOnLeft;
            }
            RelativeLayout.LayoutParams layoutParams = (RelativeLayout.LayoutParams)this.mAmPmTextView.getLayoutParams();
            if (amPmOnLeft) {
                layoutParams.rightMargin = this.computeMaxWidthOfNumbers(12);
                layoutParams.removeRule(1);
                layoutParams.addRule(0, 16909231);
            } else {
                layoutParams.leftMargin = this.computeMaxWidthOfNumbers(60);
                layoutParams.removeRule(0);
                layoutParams.addRule(1, 16909231);
            }
            this.updateAmPmDisplay(this.mInitialHourOfDay < 12 ? 0 : 1);
            this.mAmPmTextView.setOnClickListener(new View.OnClickListener(this){
                public transient /* synthetic */ Object __robo_data__;
                /* synthetic */ TimePickerSpinnerDelegate this$0;

                private void $$robo$$android_widget_TimePickerSpinnerDelegate_3$__constructor__(TimePickerSpinnerDelegate timePickerSpinnerDelegate) {
                }

                private final void $$robo$$android_widget_TimePickerSpinnerDelegate_3$onClick(View v) {
                    this.this$0.tryVibrate();
                    int amOrPm = this.this$0.mRadialTimePickerView.getAmOrPm();
                    if (amOrPm == 0) {
                        amOrPm = 1;
                    } else if (amOrPm == 1) {
                        amOrPm = 0;
                    }
                    this.this$0.updateAmPmDisplay(amOrPm);
                    this.this$0.mRadialTimePickerView.setAmOrPm(amOrPm);
                }

                private void __constructor__(TimePickerSpinnerDelegate timePickerSpinnerDelegate) {
                    this.$$robo$$android_widget_TimePickerSpinnerDelegate_3$__constructor__(timePickerSpinnerDelegate);
                }
                {
                    this.this$0 = timePickerSpinnerDelegate;
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_TimePickerSpinnerDelegate_3$__constructor__(android.widget.TimePickerSpinnerDelegate ), 0, this, timePickerSpinnerDelegate);
                }

                @Override
                public void onClick(View view) {
                    InvokeDynamicSupport.bootstrap("onClick", $$robo$$android_widget_TimePickerSpinnerDelegate_3$onClick(android.view.View ), 0, this, view);
                }
                {
                    this.$$robo$init();
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            });
        }
    }

    private final void $$robo$$android_widget_TimePickerSpinnerDelegate$setCurrentHour(Integer currentHour) {
        if (this.mInitialHourOfDay == currentHour) {
            return;
        }
        this.mInitialHourOfDay = currentHour;
        this.updateHeaderHour(currentHour, true);
        this.updateHeaderAmPm();
        this.mRadialTimePickerView.setCurrentHour(currentHour);
        this.mRadialTimePickerView.setAmOrPm(this.mInitialHourOfDay < 12 ? 0 : 1);
        this.mDelegator.invalidate();
        this.onTimeChanged();
    }

    private final Integer $$robo$$android_widget_TimePickerSpinnerDelegate$getCurrentHour() {
        int currentHour = this.mRadialTimePickerView.getCurrentHour();
        if (this.mIs24HourView) {
            return currentHour;
        }
        switch (this.mRadialTimePickerView.getAmOrPm()) {
            case 1: {
                return currentHour % 12 + 12;
            }
        }
        return currentHour % 12;
    }

    private final void $$robo$$android_widget_TimePickerSpinnerDelegate$setCurrentMinute(Integer currentMinute) {
        if (this.mInitialMinute == currentMinute) {
            return;
        }
        this.mInitialMinute = currentMinute;
        this.updateHeaderMinute(currentMinute);
        this.mRadialTimePickerView.setCurrentMinute(currentMinute);
        this.mDelegator.invalidate();
        this.onTimeChanged();
    }

    private final Integer $$robo$$android_widget_TimePickerSpinnerDelegate$getCurrentMinute() {
        return this.mRadialTimePickerView.getCurrentMinute();
    }

    private final void $$robo$$android_widget_TimePickerSpinnerDelegate$setIs24HourView(Boolean is24HourView) {
        int hour;
        if (is24HourView == this.mIs24HourView) {
            return;
        }
        this.mIs24HourView = is24HourView;
        this.generateLegalTimesTree();
        this.mInitialHourOfDay = hour = this.mRadialTimePickerView.getCurrentHour();
        this.updateHeaderHour(hour, false);
        this.updateHeaderAmPm();
        this.updateRadialPicker(this.mRadialTimePickerView.getCurrentItemShowing());
        this.mDelegator.invalidate();
    }

    private final boolean $$robo$$android_widget_TimePickerSpinnerDelegate$is24HourView() {
        return this.mIs24HourView;
    }

    private final void $$robo$$android_widget_TimePickerSpinnerDelegate$setOnTimeChangedListener(TimePicker.OnTimeChangedListener callback) {
        this.mOnTimeChangedListener = callback;
    }

    private final void $$robo$$android_widget_TimePickerSpinnerDelegate$setEnabled(boolean enabled) {
        this.mHourView.setEnabled(enabled);
        this.mMinuteView.setEnabled(enabled);
        this.mAmPmTextView.setEnabled(enabled);
        this.mRadialTimePickerView.setEnabled(enabled);
        this.mIsEnabled = enabled;
    }

    private final boolean $$robo$$android_widget_TimePickerSpinnerDelegate$isEnabled() {
        return this.mIsEnabled;
    }

    private final int $$robo$$android_widget_TimePickerSpinnerDelegate$getBaseline() {
        return -1;
    }

    private final void $$robo$$android_widget_TimePickerSpinnerDelegate$onConfigurationChanged(Configuration newConfig) {
        this.updateUI(this.mRadialTimePickerView.getCurrentItemShowing());
    }

    private final Parcelable $$robo$$android_widget_TimePickerSpinnerDelegate$onSaveInstanceState(Parcelable superState) {
        return new SavedState(superState, this.getCurrentHour(), this.getCurrentMinute(), this.is24HourView(), this.inKbMode(), this.getTypedTimes(), this.getCurrentItemShowing());
    }

    private final void $$robo$$android_widget_TimePickerSpinnerDelegate$onRestoreInstanceState(Parcelable state) {
        SavedState ss = (SavedState)state;
        this.setInKbMode(ss.inKbMode());
        this.setTypedTimes(ss.getTypesTimes());
        this.initialize(ss.getHour(), ss.getMinute(), ss.is24HourMode(), ss.getCurrentItemShowing());
        this.mRadialTimePickerView.invalidate();
        if (this.mInKbMode) {
            this.tryStartingKbMode(-1);
            this.mHourView.invalidate();
        }
    }

    private final void $$robo$$android_widget_TimePickerSpinnerDelegate$setCurrentLocale(Locale locale) {
        super.setCurrentLocale(locale);
        this.mTempCalendar = Calendar.getInstance(locale);
    }

    private final boolean $$robo$$android_widget_TimePickerSpinnerDelegate$dispatchPopulateAccessibilityEvent(AccessibilityEvent event) {
        this.onPopulateAccessibilityEvent(event);
        return true;
    }

    private final void $$robo$$android_widget_TimePickerSpinnerDelegate$onPopulateAccessibilityEvent(AccessibilityEvent event) {
        int flags = 1;
        flags = this.mIs24HourView ? (flags |= 0x80) : (flags |= 0x40);
        this.mTempCalendar.set(11, this.getCurrentHour());
        this.mTempCalendar.set(12, this.getCurrentMinute());
        String selectedDate = DateUtils.formatDateTime(this.mContext, this.mTempCalendar.getTimeInMillis(), flags);
        event.getText().add(selectedDate);
    }

    private final void $$robo$$android_widget_TimePickerSpinnerDelegate$onInitializeAccessibilityEvent(AccessibilityEvent event) {
        event.setClassName(TimePicker.class.getName());
    }

    private final void $$robo$$android_widget_TimePickerSpinnerDelegate$onInitializeAccessibilityNodeInfo(AccessibilityNodeInfo info) {
        info.setClassName(TimePicker.class.getName());
    }

    private final void $$robo$$android_widget_TimePickerSpinnerDelegate$setInKbMode(boolean inKbMode) {
        this.mInKbMode = inKbMode;
    }

    private final boolean $$robo$$android_widget_TimePickerSpinnerDelegate$inKbMode() {
        return this.mInKbMode;
    }

    private final void $$robo$$android_widget_TimePickerSpinnerDelegate$setTypedTimes(ArrayList<Integer> typeTimes) {
        this.mTypedTimes = typeTimes;
    }

    private final ArrayList<Integer> $$robo$$android_widget_TimePickerSpinnerDelegate$getTypedTimes() {
        return this.mTypedTimes;
    }

    private final int $$robo$$android_widget_TimePickerSpinnerDelegate$getCurrentItemShowing() {
        return this.mRadialTimePickerView.getCurrentItemShowing();
    }

    private final void $$robo$$android_widget_TimePickerSpinnerDelegate$onTimeChanged() {
        this.mDelegator.sendAccessibilityEvent(4);
        if (this.mOnTimeChangedListener != null) {
            this.mOnTimeChangedListener.onTimeChanged(this.mDelegator, this.getCurrentHour(), this.getCurrentMinute());
        }
    }

    private final void $$robo$$android_widget_TimePickerSpinnerDelegate$tryVibrate() {
        this.mDelegator.performHapticFeedback(4);
    }

    private final void $$robo$$android_widget_TimePickerSpinnerDelegate$updateAmPmDisplay(int amOrPm) {
        if (amOrPm == 0) {
            this.mAmPmTextView.setText(this.mAmText);
            this.mRadialTimePickerView.announceForAccessibility(this.mAmText);
        } else if (amOrPm == 1) {
            this.mAmPmTextView.setText(this.mPmText);
            this.mRadialTimePickerView.announceForAccessibility(this.mPmText);
        } else {
            this.mAmPmTextView.setText(this.mDoublePlaceholderText);
        }
    }

    private final void $$robo$$android_widget_TimePickerSpinnerDelegate$onValueSelected(int pickerIndex, int newValue, boolean autoAdvance) {
        if (pickerIndex == 0) {
            this.updateHeaderHour(newValue, false);
            String announcement = String.format("%d", newValue);
            if (this.mAllowAutoAdvance && autoAdvance) {
                this.setCurrentItemShowing(1, true, false);
                announcement = announcement + ". " + this.mSelectMinutes;
            } else {
                this.mRadialTimePickerView.setContentDescription(this.mHourPickerDescription + ": " + newValue);
            }
            this.mRadialTimePickerView.announceForAccessibility(announcement);
        } else if (pickerIndex == 1) {
            this.updateHeaderMinute(newValue);
            this.mRadialTimePickerView.setContentDescription(this.mMinutePickerDescription + ": " + newValue);
        } else if (pickerIndex == 2) {
            this.updateAmPmDisplay(newValue);
        } else if (pickerIndex == 3) {
            if (!this.isTypedTimeFullyLegal()) {
                this.mTypedTimes.clear();
            }
            this.finishKbMode();
        }
    }

    private final void $$robo$$android_widget_TimePickerSpinnerDelegate$updateHeaderHour(int value, boolean announce) {
        String bestDateTimePattern = DateFormat.getBestDateTimePattern(this.mCurrentLocale, this.mIs24HourView ? "Hm" : "hm");
        int lengthPattern = bestDateTimePattern.length();
        boolean hourWithTwoDigit = false;
        char hourFormat = '\u0000';
        for (int i = 0; i < lengthPattern; ++i) {
            char c = bestDateTimePattern.charAt(i);
            if (c != 'H' && c != 'h' && c != 'K' && c != 'k') continue;
            hourFormat = c;
            if (i + 1 >= lengthPattern || c != bestDateTimePattern.charAt(i + 1)) break;
            hourWithTwoDigit = true;
            break;
        }
        String format = hourWithTwoDigit ? "%02d" : "%d";
        if (this.mIs24HourView) {
            if (hourFormat == 'k' && value == 0) {
                value = 24;
            }
        } else {
            value = TimePickerSpinnerDelegate.modulo12(value, hourFormat == 'K');
        }
        String text = String.format(format, value);
        this.mHourView.setText(text);
        if (announce) {
            this.mRadialTimePickerView.announceForAccessibility(text);
        }
    }

    private static final int $$robo$$android_widget_TimePickerSpinnerDelegate$modulo12(int n, boolean startWithZero) {
        int value = n % 12;
        if (value == 0 && !startWithZero) {
            value = 12;
        }
        return value;
    }

    private final void $$robo$$android_widget_TimePickerSpinnerDelegate$updateHeaderSeparator() {
        String bestDateTimePattern = DateFormat.getBestDateTimePattern(this.mCurrentLocale, this.mIs24HourView ? "Hm" : "hm");
        char[] hourFormats = new char[]{'H', 'h', 'K', 'k'};
        int hIndex = TimePickerSpinnerDelegate.lastIndexOfAny(bestDateTimePattern, hourFormats);
        String separatorText = hIndex == -1 ? ":" : Character.toString(bestDateTimePattern.charAt(hIndex + 1));
        this.mSeparatorView.setText(separatorText);
    }

    private static final int $$robo$$android_widget_TimePickerSpinnerDelegate$lastIndexOfAny(String str, char[] any) {
        int lengthAny = any.length;
        if (lengthAny > 0) {
            for (int i = str.length() - 1; i >= 0; --i) {
                char c = str.charAt(i);
                for (int j = 0; j < lengthAny; ++j) {
                    if (c != any[j]) continue;
                    return i;
                }
            }
        }
        return -1;
    }

    private final void $$robo$$android_widget_TimePickerSpinnerDelegate$updateHeaderMinute(int value) {
        if (value == 60) {
            value = 0;
        }
        String text = String.format(this.mCurrentLocale, "%02d", value);
        this.mRadialTimePickerView.announceForAccessibility(text);
        this.mMinuteView.setText(text);
    }

    private final void $$robo$$android_widget_TimePickerSpinnerDelegate$setCurrentItemShowing(int index, boolean animateCircle, boolean announce) {
        this.mRadialTimePickerView.setCurrentItemShowing(index, animateCircle);
        if (index == 0) {
            int hours = this.mRadialTimePickerView.getCurrentHour();
            if (!this.mIs24HourView) {
                hours %= 12;
            }
            this.mRadialTimePickerView.setContentDescription(this.mHourPickerDescription + ": " + hours);
            if (announce) {
                this.mRadialTimePickerView.announceForAccessibility(this.mSelectHours);
            }
        } else {
            int minutes = this.mRadialTimePickerView.getCurrentMinute();
            this.mRadialTimePickerView.setContentDescription(this.mMinutePickerDescription + ": " + minutes);
            if (announce) {
                this.mRadialTimePickerView.announceForAccessibility(this.mSelectMinutes);
            }
        }
        this.mHourView.setSelected(index == 0);
        this.mMinuteView.setSelected(index == 1);
    }

    private final boolean $$robo$$android_widget_TimePickerSpinnerDelegate$processKeyUp(int keyCode) {
        if (keyCode == 67) {
            if (this.mInKbMode && !this.mTypedTimes.isEmpty()) {
                int deleted = this.deleteLastTypedKey();
                String deletedKeyStr = deleted == this.getAmOrPmKeyCode(0) ? this.mAmText : (deleted == this.getAmOrPmKeyCode(1) ? this.mPmText : String.format("%d", this.getValFromKeyCode(deleted)));
                this.mRadialTimePickerView.announceForAccessibility(String.format(this.mDeletedKeyFormat, deletedKeyStr));
                this.updateDisplay(true);
            }
        } else if (keyCode == 7 || keyCode == 8 || keyCode == 9 || keyCode == 10 || keyCode == 11 || keyCode == 12 || keyCode == 13 || keyCode == 14 || keyCode == 15 || keyCode == 16 || !this.mIs24HourView && (keyCode == this.getAmOrPmKeyCode(0) || keyCode == this.getAmOrPmKeyCode(1))) {
            if (!this.mInKbMode) {
                if (this.mRadialTimePickerView == null) {
                    Log.e("TimePickerDelegate", "Unable to initiate keyboard mode, TimePicker was null.");
                    return true;
                }
                this.mTypedTimes.clear();
                this.tryStartingKbMode(keyCode);
                return true;
            }
            if (this.addKeyIfLegal(keyCode)) {
                this.updateDisplay(false);
            }
            return true;
        }
        return false;
    }

    private final void $$robo$$android_widget_TimePickerSpinnerDelegate$tryStartingKbMode(int keyCode) {
        if (keyCode == -1 || this.addKeyIfLegal(keyCode)) {
            this.mInKbMode = true;
            this.onValidationChanged(false);
            this.updateDisplay(false);
            this.mRadialTimePickerView.setInputEnabled(false);
        }
    }

    private final boolean $$robo$$android_widget_TimePickerSpinnerDelegate$addKeyIfLegal(int keyCode) {
        if (this.mIs24HourView && this.mTypedTimes.size() == 4 || !this.mIs24HourView && this.isTypedTimeFullyLegal()) {
            return false;
        }
        this.mTypedTimes.add(keyCode);
        if (!this.isTypedTimeLegalSoFar()) {
            this.deleteLastTypedKey();
            return false;
        }
        int val = this.getValFromKeyCode(keyCode);
        this.mRadialTimePickerView.announceForAccessibility(String.format("%d", val));
        if (this.isTypedTimeFullyLegal()) {
            if (!this.mIs24HourView && this.mTypedTimes.size() <= 3) {
                this.mTypedTimes.add(this.mTypedTimes.size() - 1, 7);
                this.mTypedTimes.add(this.mTypedTimes.size() - 1, 7);
            }
            this.onValidationChanged(true);
        }
        return true;
    }

    private final boolean $$robo$$android_widget_TimePickerSpinnerDelegate$isTypedTimeLegalSoFar() {
        Node node = this.mLegalTimesTree;
        for (int keyCode : this.mTypedTimes) {
            if ((node = node.canReach(keyCode)) != null) continue;
            return false;
        }
        return true;
    }

    private final boolean $$robo$$android_widget_TimePickerSpinnerDelegate$isTypedTimeFullyLegal() {
        if (this.mIs24HourView) {
            int[] values = this.getEnteredTime(null);
            return values[0] >= 0 && values[1] >= 0 && values[1] < 60;
        }
        return this.mTypedTimes.contains(this.getAmOrPmKeyCode(0)) || this.mTypedTimes.contains(this.getAmOrPmKeyCode(1));
    }

    private final int $$robo$$android_widget_TimePickerSpinnerDelegate$deleteLastTypedKey() {
        int deleted = this.mTypedTimes.remove(this.mTypedTimes.size() - 1);
        if (!this.isTypedTimeFullyLegal()) {
            this.onValidationChanged(false);
        }
        return deleted;
    }

    private final void $$robo$$android_widget_TimePickerSpinnerDelegate$finishKbMode() {
        this.mInKbMode = false;
        if (!this.mTypedTimes.isEmpty()) {
            int[] values = this.getEnteredTime(null);
            this.mRadialTimePickerView.setCurrentHour(values[0]);
            this.mRadialTimePickerView.setCurrentMinute(values[1]);
            if (!this.mIs24HourView) {
                this.mRadialTimePickerView.setAmOrPm(values[2]);
            }
            this.mTypedTimes.clear();
        }
        this.updateDisplay(false);
        this.mRadialTimePickerView.setInputEnabled(true);
    }

    private final void $$robo$$android_widget_TimePickerSpinnerDelegate$updateDisplay(boolean allowEmptyDisplay) {
        if (!allowEmptyDisplay && this.mTypedTimes.isEmpty()) {
            int hour = this.mRadialTimePickerView.getCurrentHour();
            int minute = this.mRadialTimePickerView.getCurrentMinute();
            this.updateHeaderHour(hour, true);
            this.updateHeaderMinute(minute);
            if (!this.mIs24HourView) {
                this.updateAmPmDisplay(hour < 12 ? 0 : 1);
            }
            this.setCurrentItemShowing(this.mRadialTimePickerView.getCurrentItemShowing(), true, true);
            this.onValidationChanged(true);
        } else {
            boolean[] enteredZeros = new boolean[]{false, false};
            int[] values = this.getEnteredTime(enteredZeros);
            String hourFormat = enteredZeros[0] ? "%02d" : "%2d";
            String minuteFormat = enteredZeros[1] ? "%02d" : "%2d";
            String hourStr = values[0] == -1 ? this.mDoublePlaceholderText : String.format(hourFormat, values[0]).replace(' ', this.mPlaceholderText);
            String minuteStr = values[1] == -1 ? this.mDoublePlaceholderText : String.format(minuteFormat, values[1]).replace(' ', this.mPlaceholderText);
            this.mHourView.setText(hourStr);
            this.mHourView.setSelected(false);
            this.mMinuteView.setText(minuteStr);
            this.mMinuteView.setSelected(false);
            if (!this.mIs24HourView) {
                this.updateAmPmDisplay(values[2]);
            }
        }
    }

    private final int $$robo$$android_widget_TimePickerSpinnerDelegate$getValFromKeyCode(int keyCode) {
        switch (keyCode) {
            case 7: {
                return 0;
            }
            case 8: {
                return 1;
            }
            case 9: {
                return 2;
            }
            case 10: {
                return 3;
            }
            case 11: {
                return 4;
            }
            case 12: {
                return 5;
            }
            case 13: {
                return 6;
            }
            case 14: {
                return 7;
            }
            case 15: {
                return 8;
            }
            case 16: {
                return 9;
            }
        }
        return -1;
    }

    private final int[] $$robo$$android_widget_TimePickerSpinnerDelegate$getEnteredTime(boolean[] enteredZeros) {
        int amOrPm = -1;
        int startIndex = 1;
        if (!this.mIs24HourView && this.isTypedTimeFullyLegal()) {
            int keyCode = this.mTypedTimes.get(this.mTypedTimes.size() - 1);
            if (keyCode == this.getAmOrPmKeyCode(0)) {
                amOrPm = 0;
            } else if (keyCode == this.getAmOrPmKeyCode(1)) {
                amOrPm = 1;
            }
            startIndex = 2;
        }
        int minute = -1;
        int hour = -1;
        for (int i = startIndex; i <= this.mTypedTimes.size(); ++i) {
            int val = this.getValFromKeyCode(this.mTypedTimes.get(this.mTypedTimes.size() - i));
            if (i == startIndex) {
                minute = val;
                continue;
            }
            if (i == startIndex + 1) {
                minute += 10 * val;
                if (enteredZeros == null || val != 0) continue;
                enteredZeros[1] = true;
                continue;
            }
            if (i == startIndex + 2) {
                hour = val;
                continue;
            }
            if (i != startIndex + 3) continue;
            hour += 10 * val;
            if (enteredZeros == null || val != 0) continue;
            enteredZeros[0] = true;
        }
        return new int[]{hour, minute, amOrPm};
    }

    private final int $$robo$$android_widget_TimePickerSpinnerDelegate$getAmOrPmKeyCode(int amOrPm) {
        if (this.mAmKeyCode == -1 || this.mPmKeyCode == -1) {
            KeyCharacterMap kcm = KeyCharacterMap.load(-1);
            for (int i = 0; i < Math.max(this.mAmText.length(), this.mPmText.length()); ++i) {
                char pmChar;
                char amChar = this.mAmText.toLowerCase(this.mCurrentLocale).charAt(i);
                if (amChar == (pmChar = this.mPmText.toLowerCase(this.mCurrentLocale).charAt(i))) continue;
                KeyEvent[] events = kcm.getEvents(new char[]{amChar, pmChar});
                if (events != null && events.length == 4) {
                    this.mAmKeyCode = events[0].getKeyCode();
                    this.mPmKeyCode = events[2].getKeyCode();
                    break;
                }
                Log.e("TimePickerDelegate", "Unable to find keycodes for AM and PM.");
                break;
            }
        }
        if (amOrPm == 0) {
            return this.mAmKeyCode;
        }
        if (amOrPm == 1) {
            return this.mPmKeyCode;
        }
        return -1;
    }

    private final void $$robo$$android_widget_TimePickerSpinnerDelegate$generateLegalTimesTree() {
        int k0 = 7;
        int k1 = 8;
        int k2 = 9;
        int k3 = 10;
        int k4 = 11;
        int k5 = 12;
        int k6 = 13;
        int k7 = 14;
        int k8 = 15;
        int k9 = 16;
        this.mLegalTimesTree = new Node(this, new int[0]);
        if (this.mIs24HourView) {
            Node minuteFirstDigit = new Node(this, 7, 8, 9, 10, 11, 12);
            Node minuteSecondDigit = new Node(this, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16);
            minuteFirstDigit.addChild(minuteSecondDigit);
            Node firstDigit = new Node(this, 7, 8);
            this.mLegalTimesTree.addChild(firstDigit);
            Node secondDigit = new Node(this, 7, 8, 9, 10, 11, 12);
            firstDigit.addChild(secondDigit);
            secondDigit.addChild(minuteFirstDigit);
            Node thirdDigit = new Node(this, 13, 14, 15, 16);
            secondDigit.addChild(thirdDigit);
            secondDigit = new Node(this, 13, 14, 15, 16);
            firstDigit.addChild(secondDigit);
            secondDigit.addChild(minuteFirstDigit);
            firstDigit = new Node(this, 9);
            this.mLegalTimesTree.addChild(firstDigit);
            secondDigit = new Node(this, 7, 8, 9, 10);
            firstDigit.addChild(secondDigit);
            secondDigit.addChild(minuteFirstDigit);
            secondDigit = new Node(this, 11, 12);
            firstDigit.addChild(secondDigit);
            secondDigit.addChild(minuteSecondDigit);
            firstDigit = new Node(this, 10, 11, 12, 13, 14, 15, 16);
            this.mLegalTimesTree.addChild(firstDigit);
            firstDigit.addChild(minuteFirstDigit);
        } else {
            Node ampm = new Node(this, this.getAmOrPmKeyCode(0), this.getAmOrPmKeyCode(1));
            Node firstDigit = new Node(this, 8);
            this.mLegalTimesTree.addChild(firstDigit);
            firstDigit.addChild(ampm);
            Node secondDigit = new Node(this, 7, 8, 9);
            firstDigit.addChild(secondDigit);
            secondDigit.addChild(ampm);
            Node thirdDigit = new Node(this, 7, 8, 9, 10, 11, 12);
            secondDigit.addChild(thirdDigit);
            thirdDigit.addChild(ampm);
            Node fourthDigit = new Node(this, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16);
            thirdDigit.addChild(fourthDigit);
            fourthDigit.addChild(ampm);
            thirdDigit = new Node(this, 13, 14, 15, 16);
            secondDigit.addChild(thirdDigit);
            thirdDigit.addChild(ampm);
            secondDigit = new Node(this, 10, 11, 12);
            firstDigit.addChild(secondDigit);
            thirdDigit = new Node(this, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16);
            secondDigit.addChild(thirdDigit);
            thirdDigit.addChild(ampm);
            firstDigit = new Node(this, 9, 10, 11, 12, 13, 14, 15, 16);
            this.mLegalTimesTree.addChild(firstDigit);
            firstDigit.addChild(ampm);
            secondDigit = new Node(this, 7, 8, 9, 10, 11, 12);
            firstDigit.addChild(secondDigit);
            thirdDigit = new Node(this, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16);
            secondDigit.addChild(thirdDigit);
            thirdDigit.addChild(ampm);
        }
    }

    private void __constructor__(TimePicker timePicker, Context context, AttributeSet attributeSet, int n, int n2) {
        this.$$robo$$android_widget_TimePickerSpinnerDelegate$__constructor__(timePicker, context, attributeSet, n, n2);
    }

    public TimePickerSpinnerDelegate(TimePicker timePicker, Context context, AttributeSet attributeSet, int n, int n2) {
        super(timePicker, context);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_TimePickerSpinnerDelegate$__constructor__(android.widget.TimePicker android.content.Context android.util.AttributeSet int int ), 0, this, timePicker, context, attributeSet, n, n2);
    }

    private void initialize(int n, int n2, boolean bl, int n3) {
        InvokeDynamicSupport.bootstrap("initialize", $$robo$$android_widget_TimePickerSpinnerDelegate$initialize(int int boolean int ), 0, this, n, n2, bl, n3);
    }

    private void setupListeners() {
        InvokeDynamicSupport.bootstrap("setupListeners", $$robo$$android_widget_TimePickerSpinnerDelegate$setupListeners(), 0, this);
    }

    private void updateUI(int n) {
        InvokeDynamicSupport.bootstrap("updateUI", $$robo$$android_widget_TimePickerSpinnerDelegate$updateUI(int ), 0, this, n);
    }

    private void updateRadialPicker(int n) {
        InvokeDynamicSupport.bootstrap("updateRadialPicker", $$robo$$android_widget_TimePickerSpinnerDelegate$updateRadialPicker(int ), 0, this, n);
    }

    private int computeMaxWidthOfNumbers(int n) {
        return (int)InvokeDynamicSupport.bootstrap("computeMaxWidthOfNumbers", $$robo$$android_widget_TimePickerSpinnerDelegate$computeMaxWidthOfNumbers(int ), 0, this, n);
    }

    private void updateHeaderAmPm() {
        InvokeDynamicSupport.bootstrap("updateHeaderAmPm", $$robo$$android_widget_TimePickerSpinnerDelegate$updateHeaderAmPm(), 0, this);
    }

    @Override
    public void setCurrentHour(Integer n) {
        InvokeDynamicSupport.bootstrap("setCurrentHour", $$robo$$android_widget_TimePickerSpinnerDelegate$setCurrentHour(java.lang.Integer ), 0, this, n);
    }

    @Override
    public Integer getCurrentHour() {
        return InvokeDynamicSupport.bootstrap("getCurrentHour", $$robo$$android_widget_TimePickerSpinnerDelegate$getCurrentHour(), 0, this);
    }

    @Override
    public void setCurrentMinute(Integer n) {
        InvokeDynamicSupport.bootstrap("setCurrentMinute", $$robo$$android_widget_TimePickerSpinnerDelegate$setCurrentMinute(java.lang.Integer ), 0, this, n);
    }

    @Override
    public Integer getCurrentMinute() {
        return InvokeDynamicSupport.bootstrap("getCurrentMinute", $$robo$$android_widget_TimePickerSpinnerDelegate$getCurrentMinute(), 0, this);
    }

    @Override
    public void setIs24HourView(Boolean bl) {
        InvokeDynamicSupport.bootstrap("setIs24HourView", $$robo$$android_widget_TimePickerSpinnerDelegate$setIs24HourView(java.lang.Boolean ), 0, this, bl);
    }

    @Override
    public boolean is24HourView() {
        return (boolean)InvokeDynamicSupport.bootstrap("is24HourView", $$robo$$android_widget_TimePickerSpinnerDelegate$is24HourView(), 0, this);
    }

    @Override
    public void setOnTimeChangedListener(TimePicker.OnTimeChangedListener onTimeChangedListener) {
        InvokeDynamicSupport.bootstrap("setOnTimeChangedListener", $$robo$$android_widget_TimePickerSpinnerDelegate$setOnTimeChangedListener(android.widget.TimePicker$OnTimeChangedListener ), 0, this, onTimeChangedListener);
    }

    @Override
    public void setEnabled(boolean bl) {
        InvokeDynamicSupport.bootstrap("setEnabled", $$robo$$android_widget_TimePickerSpinnerDelegate$setEnabled(boolean ), 0, this, bl);
    }

    @Override
    public boolean isEnabled() {
        return (boolean)InvokeDynamicSupport.bootstrap("isEnabled", $$robo$$android_widget_TimePickerSpinnerDelegate$isEnabled(), 0, this);
    }

    @Override
    public int getBaseline() {
        return (int)InvokeDynamicSupport.bootstrap("getBaseline", $$robo$$android_widget_TimePickerSpinnerDelegate$getBaseline(), 0, this);
    }

    @Override
    public void onConfigurationChanged(Configuration configuration) {
        InvokeDynamicSupport.bootstrap("onConfigurationChanged", $$robo$$android_widget_TimePickerSpinnerDelegate$onConfigurationChanged(android.content.res.Configuration ), 0, this, configuration);
    }

    @Override
    public Parcelable onSaveInstanceState(Parcelable parcelable) {
        return InvokeDynamicSupport.bootstrap("onSaveInstanceState", $$robo$$android_widget_TimePickerSpinnerDelegate$onSaveInstanceState(android.os.Parcelable ), 0, this, parcelable);
    }

    @Override
    public void onRestoreInstanceState(Parcelable parcelable) {
        InvokeDynamicSupport.bootstrap("onRestoreInstanceState", $$robo$$android_widget_TimePickerSpinnerDelegate$onRestoreInstanceState(android.os.Parcelable ), 0, this, parcelable);
    }

    @Override
    public void setCurrentLocale(Locale locale) {
        InvokeDynamicSupport.bootstrap("setCurrentLocale", $$robo$$android_widget_TimePickerSpinnerDelegate$setCurrentLocale(java.util.Locale ), 0, this, locale);
    }

    @Override
    public boolean dispatchPopulateAccessibilityEvent(AccessibilityEvent accessibilityEvent) {
        return (boolean)InvokeDynamicSupport.bootstrap("dispatchPopulateAccessibilityEvent", $$robo$$android_widget_TimePickerSpinnerDelegate$dispatchPopulateAccessibilityEvent(android.view.accessibility.AccessibilityEvent ), 0, this, accessibilityEvent);
    }

    @Override
    public void onPopulateAccessibilityEvent(AccessibilityEvent accessibilityEvent) {
        InvokeDynamicSupport.bootstrap("onPopulateAccessibilityEvent", $$robo$$android_widget_TimePickerSpinnerDelegate$onPopulateAccessibilityEvent(android.view.accessibility.AccessibilityEvent ), 0, this, accessibilityEvent);
    }

    @Override
    public void onInitializeAccessibilityEvent(AccessibilityEvent accessibilityEvent) {
        InvokeDynamicSupport.bootstrap("onInitializeAccessibilityEvent", $$robo$$android_widget_TimePickerSpinnerDelegate$onInitializeAccessibilityEvent(android.view.accessibility.AccessibilityEvent ), 0, this, accessibilityEvent);
    }

    @Override
    public void onInitializeAccessibilityNodeInfo(AccessibilityNodeInfo accessibilityNodeInfo) {
        InvokeDynamicSupport.bootstrap("onInitializeAccessibilityNodeInfo", $$robo$$android_widget_TimePickerSpinnerDelegate$onInitializeAccessibilityNodeInfo(android.view.accessibility.AccessibilityNodeInfo ), 0, this, accessibilityNodeInfo);
    }

    private void setInKbMode(boolean bl) {
        InvokeDynamicSupport.bootstrap("setInKbMode", $$robo$$android_widget_TimePickerSpinnerDelegate$setInKbMode(boolean ), 0, this, bl);
    }

    private boolean inKbMode() {
        return (boolean)InvokeDynamicSupport.bootstrap("inKbMode", $$robo$$android_widget_TimePickerSpinnerDelegate$inKbMode(), 0, this);
    }

    private void setTypedTimes(ArrayList<Integer> arrayList) {
        InvokeDynamicSupport.bootstrap("setTypedTimes", $$robo$$android_widget_TimePickerSpinnerDelegate$setTypedTimes(java.util.ArrayList<java.lang.Integer> ), 0, this, arrayList);
    }

    private ArrayList<Integer> getTypedTimes() {
        return InvokeDynamicSupport.bootstrap("getTypedTimes", $$robo$$android_widget_TimePickerSpinnerDelegate$getTypedTimes(), 0, this);
    }

    private int getCurrentItemShowing() {
        return (int)InvokeDynamicSupport.bootstrap("getCurrentItemShowing", $$robo$$android_widget_TimePickerSpinnerDelegate$getCurrentItemShowing(), 0, this);
    }

    private void onTimeChanged() {
        InvokeDynamicSupport.bootstrap("onTimeChanged", $$robo$$android_widget_TimePickerSpinnerDelegate$onTimeChanged(), 0, this);
    }

    private void tryVibrate() {
        InvokeDynamicSupport.bootstrap("tryVibrate", $$robo$$android_widget_TimePickerSpinnerDelegate$tryVibrate(), 0, this);
    }

    private void updateAmPmDisplay(int n) {
        InvokeDynamicSupport.bootstrap("updateAmPmDisplay", $$robo$$android_widget_TimePickerSpinnerDelegate$updateAmPmDisplay(int ), 0, this, n);
    }

    @Override
    public void onValueSelected(int n, int n2, boolean bl) {
        InvokeDynamicSupport.bootstrap("onValueSelected", $$robo$$android_widget_TimePickerSpinnerDelegate$onValueSelected(int int boolean ), 0, this, n, n2, bl);
    }

    private void updateHeaderHour(int n, boolean bl) {
        InvokeDynamicSupport.bootstrap("updateHeaderHour", $$robo$$android_widget_TimePickerSpinnerDelegate$updateHeaderHour(int boolean ), 0, this, n, bl);
    }

    private static int modulo12(int n, boolean bl) {
        return (int)InvokeDynamicSupport.bootstrapStatic("modulo12", $$robo$$android_widget_TimePickerSpinnerDelegate$modulo12(int boolean ), 0, (int)n, (boolean)bl);
    }

    private void updateHeaderSeparator() {
        InvokeDynamicSupport.bootstrap("updateHeaderSeparator", $$robo$$android_widget_TimePickerSpinnerDelegate$updateHeaderSeparator(), 0, this);
    }

    private static int lastIndexOfAny(String string2, char[] cArray) {
        return (int)InvokeDynamicSupport.bootstrapStatic("lastIndexOfAny", $$robo$$android_widget_TimePickerSpinnerDelegate$lastIndexOfAny(java.lang.String char[] ), 0, (String)string2, (char[])cArray);
    }

    private void updateHeaderMinute(int n) {
        InvokeDynamicSupport.bootstrap("updateHeaderMinute", $$robo$$android_widget_TimePickerSpinnerDelegate$updateHeaderMinute(int ), 0, this, n);
    }

    private void setCurrentItemShowing(int n, boolean bl, boolean bl2) {
        InvokeDynamicSupport.bootstrap("setCurrentItemShowing", $$robo$$android_widget_TimePickerSpinnerDelegate$setCurrentItemShowing(int boolean boolean ), 0, this, n, bl, bl2);
    }

    private boolean processKeyUp(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("processKeyUp", $$robo$$android_widget_TimePickerSpinnerDelegate$processKeyUp(int ), 0, this, n);
    }

    private void tryStartingKbMode(int n) {
        InvokeDynamicSupport.bootstrap("tryStartingKbMode", $$robo$$android_widget_TimePickerSpinnerDelegate$tryStartingKbMode(int ), 0, this, n);
    }

    private boolean addKeyIfLegal(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("addKeyIfLegal", $$robo$$android_widget_TimePickerSpinnerDelegate$addKeyIfLegal(int ), 0, this, n);
    }

    private boolean isTypedTimeLegalSoFar() {
        return (boolean)InvokeDynamicSupport.bootstrap("isTypedTimeLegalSoFar", $$robo$$android_widget_TimePickerSpinnerDelegate$isTypedTimeLegalSoFar(), 0, this);
    }

    private boolean isTypedTimeFullyLegal() {
        return (boolean)InvokeDynamicSupport.bootstrap("isTypedTimeFullyLegal", $$robo$$android_widget_TimePickerSpinnerDelegate$isTypedTimeFullyLegal(), 0, this);
    }

    private int deleteLastTypedKey() {
        return (int)InvokeDynamicSupport.bootstrap("deleteLastTypedKey", $$robo$$android_widget_TimePickerSpinnerDelegate$deleteLastTypedKey(), 0, this);
    }

    private void finishKbMode() {
        InvokeDynamicSupport.bootstrap("finishKbMode", $$robo$$android_widget_TimePickerSpinnerDelegate$finishKbMode(), 0, this);
    }

    private void updateDisplay(boolean bl) {
        InvokeDynamicSupport.bootstrap("updateDisplay", $$robo$$android_widget_TimePickerSpinnerDelegate$updateDisplay(boolean ), 0, this, bl);
    }

    private int getValFromKeyCode(int n) {
        return (int)InvokeDynamicSupport.bootstrap("getValFromKeyCode", $$robo$$android_widget_TimePickerSpinnerDelegate$getValFromKeyCode(int ), 0, this, n);
    }

    private int[] getEnteredTime(boolean[] blArray) {
        return InvokeDynamicSupport.bootstrap("getEnteredTime", $$robo$$android_widget_TimePickerSpinnerDelegate$getEnteredTime(boolean[] ), 0, this, blArray);
    }

    private int getAmOrPmKeyCode(int n) {
        return (int)InvokeDynamicSupport.bootstrap("getAmOrPmKeyCode", $$robo$$android_widget_TimePickerSpinnerDelegate$getAmOrPmKeyCode(int ), 0, this, n);
    }

    private void generateLegalTimesTree() {
        InvokeDynamicSupport.bootstrap("generateLegalTimesTree", $$robo$$android_widget_TimePickerSpinnerDelegate$generateLegalTimesTree(), 0, this);
    }

    public /* synthetic */ TimePickerSpinnerDelegate() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (TimePickerSpinnerDelegate)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    private class Node
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private int[] mLegalKeys;
        private ArrayList<Node> mChildren;
        /* synthetic */ TimePickerSpinnerDelegate this$0;

        private void $$robo$$android_widget_TimePickerSpinnerDelegate_Node$__constructor__(TimePickerSpinnerDelegate timePickerSpinnerDelegate, int ... legalKeys) {
            this.mLegalKeys = legalKeys;
            this.mChildren = new ArrayList();
        }

        private final void $$robo$$android_widget_TimePickerSpinnerDelegate_Node$addChild(Node child) {
            this.mChildren.add(child);
        }

        private final boolean $$robo$$android_widget_TimePickerSpinnerDelegate_Node$containsKey(int key) {
            for (int i = 0; i < this.mLegalKeys.length; ++i) {
                if (this.mLegalKeys[i] != key) continue;
                return true;
            }
            return false;
        }

        private final Node $$robo$$android_widget_TimePickerSpinnerDelegate_Node$canReach(int key) {
            if (this.mChildren == null) {
                return null;
            }
            for (Node child : this.mChildren) {
                if (!child.containsKey(key)) continue;
                return child;
            }
            return null;
        }

        private void __constructor__(TimePickerSpinnerDelegate timePickerSpinnerDelegate, int ... nArray) {
            this.$$robo$$android_widget_TimePickerSpinnerDelegate_Node$__constructor__(timePickerSpinnerDelegate, nArray);
        }

        public Node(TimePickerSpinnerDelegate timePickerSpinnerDelegate, int ... nArray) {
            this.this$0 = timePickerSpinnerDelegate;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_TimePickerSpinnerDelegate_Node$__constructor__(android.widget.TimePickerSpinnerDelegate int[] ), 0, this, timePickerSpinnerDelegate, nArray);
        }

        public void addChild(Node node) {
            InvokeDynamicSupport.bootstrap("addChild", $$robo$$android_widget_TimePickerSpinnerDelegate_Node$addChild(android.widget.TimePickerSpinnerDelegate$Node ), 0, this, node);
        }

        public boolean containsKey(int n) {
            return (boolean)InvokeDynamicSupport.bootstrap("containsKey", $$robo$$android_widget_TimePickerSpinnerDelegate_Node$containsKey(int ), 0, this, n);
        }

        public Node canReach(int n) {
            return InvokeDynamicSupport.bootstrap("canReach", $$robo$$android_widget_TimePickerSpinnerDelegate_Node$canReach(int ), 0, this, n);
        }

        public /* synthetic */ Node() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Node)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private static class SavedState
    extends View.BaseSavedState
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private int mHour;
        private int mMinute;
        private boolean mIs24HourMode;
        private boolean mInKbMode;
        private ArrayList<Integer> mTypedTimes;
        private int mCurrentItemShowing;
        public static Parcelable.Creator<SavedState> CREATOR;

        private void $$robo$$android_widget_TimePickerSpinnerDelegate_SavedState$__constructor__(Parcelable superState, int hour, int minute, boolean is24HourMode, boolean isKbMode, ArrayList<Integer> typedTimes, int currentItemShowing) {
            this.mHour = hour;
            this.mMinute = minute;
            this.mIs24HourMode = is24HourMode;
            this.mInKbMode = isKbMode;
            this.mTypedTimes = typedTimes;
            this.mCurrentItemShowing = currentItemShowing;
        }

        private void $$robo$$android_widget_TimePickerSpinnerDelegate_SavedState$__constructor__(Parcel in) {
            this.mHour = in.readInt();
            this.mMinute = in.readInt();
            this.mIs24HourMode = in.readInt() == 1;
            this.mInKbMode = in.readInt() == 1;
            this.mTypedTimes = in.readArrayList(this.getClass().getClassLoader());
            this.mCurrentItemShowing = in.readInt();
        }

        private final int $$robo$$android_widget_TimePickerSpinnerDelegate_SavedState$getHour() {
            return this.mHour;
        }

        private final int $$robo$$android_widget_TimePickerSpinnerDelegate_SavedState$getMinute() {
            return this.mMinute;
        }

        private final boolean $$robo$$android_widget_TimePickerSpinnerDelegate_SavedState$is24HourMode() {
            return this.mIs24HourMode;
        }

        private final boolean $$robo$$android_widget_TimePickerSpinnerDelegate_SavedState$inKbMode() {
            return this.mInKbMode;
        }

        private final ArrayList<Integer> $$robo$$android_widget_TimePickerSpinnerDelegate_SavedState$getTypesTimes() {
            return this.mTypedTimes;
        }

        private final int $$robo$$android_widget_TimePickerSpinnerDelegate_SavedState$getCurrentItemShowing() {
            return this.mCurrentItemShowing;
        }

        private final void $$robo$$android_widget_TimePickerSpinnerDelegate_SavedState$writeToParcel(Parcel dest, int flags) {
            super.writeToParcel(dest, flags);
            dest.writeInt(this.mHour);
            dest.writeInt(this.mMinute);
            dest.writeInt(this.mIs24HourMode ? 1 : 0);
            dest.writeInt(this.mInKbMode ? 1 : 0);
            dest.writeList(this.mTypedTimes);
            dest.writeInt(this.mCurrentItemShowing);
        }

        private /* synthetic */ void $$robo$$android_widget_TimePickerSpinnerDelegate_SavedState$__constructor__(Parcelable x0, int x1, int x2, boolean x3, boolean x4, ArrayList x5, int x6, 1 x7) {
        }

        private /* synthetic */ void $$robo$$android_widget_TimePickerSpinnerDelegate_SavedState$__constructor__(Parcel x0, 1 x1) {
        }

        static void __staticInitializer__() {
            CREATOR = new Parcelable.Creator<SavedState>(){
                public transient /* synthetic */ Object __robo_data__;

                private void $$robo$$android_widget_TimePickerSpinnerDelegate_SavedState_1$__constructor__() {
                }

                private final SavedState $$robo$$android_widget_TimePickerSpinnerDelegate_SavedState_1$createFromParcel(Parcel in) {
                    return new SavedState(in);
                }

                private final SavedState[] $$robo$$android_widget_TimePickerSpinnerDelegate_SavedState_1$newArray(int size) {
                    return new SavedState[size];
                }

                private void __constructor__() {
                    this.$$robo$$android_widget_TimePickerSpinnerDelegate_SavedState_1$__constructor__();
                }
                {
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_TimePickerSpinnerDelegate_SavedState_1$__constructor__(), 0, this);
                }

                @Override
                public SavedState createFromParcel(Parcel parcel) {
                    return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_widget_TimePickerSpinnerDelegate_SavedState_1$createFromParcel(android.os.Parcel ), 0, this, parcel);
                }

                public SavedState[] newArray(int n) {
                    return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_widget_TimePickerSpinnerDelegate_SavedState_1$newArray(int ), 0, this, n);
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            };
        }

        private void __constructor__(Parcelable parcelable, int n, int n2, boolean bl, boolean bl2, ArrayList<Integer> arrayList, int n3) {
            this.$$robo$$android_widget_TimePickerSpinnerDelegate_SavedState$__constructor__(parcelable, n, n2, bl, bl2, arrayList, n3);
        }

        private SavedState(Parcelable parcelable, int n, int n2, boolean bl, boolean bl2, ArrayList<Integer> arrayList, int n3) {
            super(parcelable);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_TimePickerSpinnerDelegate_SavedState$__constructor__(android.os.Parcelable int int boolean boolean java.util.ArrayList<java.lang.Integer> int ), 0, this, parcelable, n, n2, bl, bl2, arrayList, n3);
        }

        private void __constructor__(Parcel parcel) {
            this.$$robo$$android_widget_TimePickerSpinnerDelegate_SavedState$__constructor__(parcel);
        }

        private SavedState(Parcel parcel) {
            super(parcel);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_TimePickerSpinnerDelegate_SavedState$__constructor__(android.os.Parcel ), 0, this, parcel);
        }

        public int getHour() {
            return (int)InvokeDynamicSupport.bootstrap("getHour", $$robo$$android_widget_TimePickerSpinnerDelegate_SavedState$getHour(), 0, this);
        }

        public int getMinute() {
            return (int)InvokeDynamicSupport.bootstrap("getMinute", $$robo$$android_widget_TimePickerSpinnerDelegate_SavedState$getMinute(), 0, this);
        }

        public boolean is24HourMode() {
            return (boolean)InvokeDynamicSupport.bootstrap("is24HourMode", $$robo$$android_widget_TimePickerSpinnerDelegate_SavedState$is24HourMode(), 0, this);
        }

        public boolean inKbMode() {
            return (boolean)InvokeDynamicSupport.bootstrap("inKbMode", $$robo$$android_widget_TimePickerSpinnerDelegate_SavedState$inKbMode(), 0, this);
        }

        public ArrayList<Integer> getTypesTimes() {
            return InvokeDynamicSupport.bootstrap("getTypesTimes", $$robo$$android_widget_TimePickerSpinnerDelegate_SavedState$getTypesTimes(), 0, this);
        }

        public int getCurrentItemShowing() {
            return (int)InvokeDynamicSupport.bootstrap("getCurrentItemShowing", $$robo$$android_widget_TimePickerSpinnerDelegate_SavedState$getCurrentItemShowing(), 0, this);
        }

        @Override
        public void writeToParcel(Parcel parcel, int n) {
            InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_widget_TimePickerSpinnerDelegate_SavedState$writeToParcel(android.os.Parcel int ), 0, this, parcel, n);
        }

        private /* synthetic */ void __constructor__(Parcelable parcelable, int n, int n2, boolean bl, boolean bl2, ArrayList arrayList, int n3, 1 var8_8) {
            this.$$robo$$android_widget_TimePickerSpinnerDelegate_SavedState$__constructor__(parcelable, n, n2, bl, bl2, arrayList, n3, var8_8);
        }

        private /* synthetic */ void __constructor__(Parcel parcel, 1 var2_2) {
            this.$$robo$$android_widget_TimePickerSpinnerDelegate_SavedState$__constructor__(parcel, var2_2);
        }

        static {
            RobolectricInternals.classInitializing(SavedState.class);
        }

        public /* synthetic */ SavedState() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SavedState)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

