/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.LayerDrawable;
import android.util.AttributeSet;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityNodeInfo;
import android.widget.CompoundButton;
import com.android.internal.R;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class ToggleButton
extends CompoundButton
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private CharSequence mTextOn;
    private CharSequence mTextOff;
    private Drawable mIndicatorDrawable;
    private static int NO_ALPHA = 255;
    private float mDisabledAlpha;

    private void $$robo$$android_widget_ToggleButton$__constructor__(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.ToggleButton, defStyleAttr, defStyleRes);
        this.mTextOn = a.getText(1);
        this.mTextOff = a.getText(2);
        this.mDisabledAlpha = a.getFloat(0, 0.5f);
        this.syncTextState();
        a.recycle();
    }

    private void $$robo$$android_widget_ToggleButton$__constructor__(Context context, AttributeSet attrs, int defStyleAttr) {
    }

    private void $$robo$$android_widget_ToggleButton$__constructor__(Context context, AttributeSet attrs) {
    }

    private void $$robo$$android_widget_ToggleButton$__constructor__(Context context) {
    }

    private final void $$robo$$android_widget_ToggleButton$setChecked(boolean checked) {
        super.setChecked(checked);
        this.syncTextState();
    }

    private final void $$robo$$android_widget_ToggleButton$syncTextState() {
        boolean checked = this.isChecked();
        if (checked && this.mTextOn != null) {
            this.setText(this.mTextOn);
        } else if (!checked && this.mTextOff != null) {
            this.setText(this.mTextOff);
        }
    }

    private final CharSequence $$robo$$android_widget_ToggleButton$getTextOn() {
        return this.mTextOn;
    }

    private final void $$robo$$android_widget_ToggleButton$setTextOn(CharSequence textOn) {
        this.mTextOn = textOn;
    }

    private final CharSequence $$robo$$android_widget_ToggleButton$getTextOff() {
        return this.mTextOff;
    }

    private final void $$robo$$android_widget_ToggleButton$setTextOff(CharSequence textOff) {
        this.mTextOff = textOff;
    }

    private final void $$robo$$android_widget_ToggleButton$onFinishInflate() {
        super.onFinishInflate();
        this.updateReferenceToIndicatorDrawable(this.getBackground());
    }

    private final void $$robo$$android_widget_ToggleButton$setBackgroundDrawable(Drawable d) {
        super.setBackgroundDrawable(d);
        this.updateReferenceToIndicatorDrawable(d);
    }

    private final void $$robo$$android_widget_ToggleButton$updateReferenceToIndicatorDrawable(Drawable backgroundDrawable) {
        if (backgroundDrawable instanceof LayerDrawable) {
            LayerDrawable layerDrawable = (LayerDrawable)backgroundDrawable;
            this.mIndicatorDrawable = layerDrawable.findDrawableByLayerId(16908311);
        } else {
            this.mIndicatorDrawable = null;
        }
    }

    private final void $$robo$$android_widget_ToggleButton$drawableStateChanged() {
        super.drawableStateChanged();
        if (this.mIndicatorDrawable != null) {
            this.mIndicatorDrawable.setAlpha(this.isEnabled() ? 255 : (int)(255.0f * this.mDisabledAlpha));
        }
    }

    private final void $$robo$$android_widget_ToggleButton$onInitializeAccessibilityEvent(AccessibilityEvent event) {
        super.onInitializeAccessibilityEvent(event);
        event.setClassName(ToggleButton.class.getName());
    }

    private final void $$robo$$android_widget_ToggleButton$onInitializeAccessibilityNodeInfo(AccessibilityNodeInfo info) {
        super.onInitializeAccessibilityNodeInfo(info);
        info.setClassName(ToggleButton.class.getName());
    }

    private void __constructor__(Context context, AttributeSet attributeSet, int n, int n2) {
        this.$$robo$$android_widget_ToggleButton$__constructor__(context, attributeSet, n, n2);
    }

    public ToggleButton(Context context, AttributeSet attributeSet, int n, int n2) {
        super(context, attributeSet, n, n2);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_ToggleButton$__constructor__(android.content.Context android.util.AttributeSet int int ), 0, this, context, attributeSet, n, n2);
    }

    private void __constructor__(Context context, AttributeSet attributeSet, int n) {
        this.$$robo$$android_widget_ToggleButton$__constructor__(context, attributeSet, n);
    }

    public ToggleButton(Context context, AttributeSet attributeSet, int n) {
        this(context, attributeSet, n, 0);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_ToggleButton$__constructor__(android.content.Context android.util.AttributeSet int ), 0, this, context, attributeSet, n);
    }

    private void __constructor__(Context context, AttributeSet attributeSet) {
        this.$$robo$$android_widget_ToggleButton$__constructor__(context, attributeSet);
    }

    public ToggleButton(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 16842827);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_ToggleButton$__constructor__(android.content.Context android.util.AttributeSet ), 0, this, context, attributeSet);
    }

    private void __constructor__(Context context) {
        this.$$robo$$android_widget_ToggleButton$__constructor__(context);
    }

    public ToggleButton(Context context) {
        this(context, null);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_ToggleButton$__constructor__(android.content.Context ), 0, this, context);
    }

    @Override
    public void setChecked(boolean bl) {
        InvokeDynamicSupport.bootstrap("setChecked", $$robo$$android_widget_ToggleButton$setChecked(boolean ), 0, this, bl);
    }

    private void syncTextState() {
        InvokeDynamicSupport.bootstrap("syncTextState", $$robo$$android_widget_ToggleButton$syncTextState(), 0, this);
    }

    public CharSequence getTextOn() {
        return InvokeDynamicSupport.bootstrap("getTextOn", $$robo$$android_widget_ToggleButton$getTextOn(), 0, this);
    }

    public void setTextOn(CharSequence charSequence) {
        InvokeDynamicSupport.bootstrap("setTextOn", $$robo$$android_widget_ToggleButton$setTextOn(java.lang.CharSequence ), 0, this, charSequence);
    }

    public CharSequence getTextOff() {
        return InvokeDynamicSupport.bootstrap("getTextOff", $$robo$$android_widget_ToggleButton$getTextOff(), 0, this);
    }

    public void setTextOff(CharSequence charSequence) {
        InvokeDynamicSupport.bootstrap("setTextOff", $$robo$$android_widget_ToggleButton$setTextOff(java.lang.CharSequence ), 0, this, charSequence);
    }

    @Override
    protected void onFinishInflate() {
        InvokeDynamicSupport.bootstrap("onFinishInflate", $$robo$$android_widget_ToggleButton$onFinishInflate(), 0, this);
    }

    @Override
    public void setBackgroundDrawable(Drawable drawable2) {
        InvokeDynamicSupport.bootstrap("setBackgroundDrawable", $$robo$$android_widget_ToggleButton$setBackgroundDrawable(android.graphics.drawable.Drawable ), 0, this, drawable2);
    }

    private void updateReferenceToIndicatorDrawable(Drawable drawable2) {
        InvokeDynamicSupport.bootstrap("updateReferenceToIndicatorDrawable", $$robo$$android_widget_ToggleButton$updateReferenceToIndicatorDrawable(android.graphics.drawable.Drawable ), 0, this, drawable2);
    }

    @Override
    protected void drawableStateChanged() {
        InvokeDynamicSupport.bootstrap("drawableStateChanged", $$robo$$android_widget_ToggleButton$drawableStateChanged(), 0, this);
    }

    @Override
    public void onInitializeAccessibilityEvent(AccessibilityEvent accessibilityEvent) {
        InvokeDynamicSupport.bootstrap("onInitializeAccessibilityEvent", $$robo$$android_widget_ToggleButton$onInitializeAccessibilityEvent(android.view.accessibility.AccessibilityEvent ), 0, this, accessibilityEvent);
    }

    @Override
    public void onInitializeAccessibilityNodeInfo(AccessibilityNodeInfo accessibilityNodeInfo) {
        InvokeDynamicSupport.bootstrap("onInitializeAccessibilityNodeInfo", $$robo$$android_widget_ToggleButton$onInitializeAccessibilityNodeInfo(android.view.accessibility.AccessibilityNodeInfo ), 0, this, accessibilityNodeInfo);
    }

    public /* synthetic */ ToggleButton() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ToggleButton)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

