/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.content.Context;
import android.content.res.Resources;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.view.accessibility.AccessibilityEvent;
import android.widget.AbsListView;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.DatePickerController;
import android.widget.ListView;
import android.widget.OnDateChangedListener;
import android.widget.TextViewWithCircularIndicator;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class YearPickerView
extends ListView
implements AdapterView.OnItemClickListener,
OnDateChangedListener,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private DatePickerController mController;
    private YearAdapter mAdapter;
    private int mViewSize;
    private int mChildSize;
    private int mSelectedPosition;
    private int mYearSelectedCircleColor;

    private void $$robo$$android_widget_YearPickerView$__constructor__(Context context) {
    }

    private void $$robo$$android_widget_YearPickerView$__constructor__(Context context, AttributeSet attrs) {
    }

    private void $$robo$$android_widget_YearPickerView$__constructor__(Context context, AttributeSet attrs, int defStyleAttr) {
    }

    private void $$robo$$android_widget_YearPickerView$__constructor__(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        this.mSelectedPosition = -1;
        AbsListView.LayoutParams frame = new AbsListView.LayoutParams(-1, -2);
        this.setLayoutParams(frame);
        Resources res = context.getResources();
        this.mViewSize = res.getDimensionPixelOffset(17105036);
        this.mChildSize = res.getDimensionPixelOffset(17105038);
        this.setVerticalFadingEdgeEnabled(true);
        this.setFadingEdgeLength(this.mChildSize / 3);
        int paddingTop = res.getDimensionPixelSize(17105037);
        this.setPadding(0, paddingTop, 0, 0);
        this.setOnItemClickListener(this);
        this.setDividerHeight(0);
    }

    private final void $$robo$$android_widget_YearPickerView$init(DatePickerController controller) {
        this.mController = controller;
        this.mController.registerOnDateChangedListener(this);
        this.mAdapter = new YearAdapter(this, this.getContext(), 17367279);
        this.updateAdapterData();
        this.setAdapter(this.mAdapter);
        this.onDateChanged();
    }

    private final void $$robo$$android_widget_YearPickerView$setYearSelectedCircleColor(int color2) {
        if (color2 != this.mYearSelectedCircleColor) {
            this.mYearSelectedCircleColor = color2;
        }
        this.requestLayout();
    }

    private final int $$robo$$android_widget_YearPickerView$getYearSelectedCircleColor() {
        return this.mYearSelectedCircleColor;
    }

    private final void $$robo$$android_widget_YearPickerView$updateAdapterData() {
        this.mAdapter.clear();
        int maxYear = this.mController.getMaxYear();
        for (int year = this.mController.getMinYear(); year <= maxYear; ++year) {
            this.mAdapter.add(year);
        }
    }

    private final void $$robo$$android_widget_YearPickerView$onItemClick(AdapterView<?> parent, View view, int position, long id2) {
        this.mController.tryVibrate();
        if (position != this.mSelectedPosition) {
            this.mSelectedPosition = position;
            this.mAdapter.notifyDataSetChanged();
        }
        this.mController.onYearSelected((Integer)this.mAdapter.getItem(position));
    }

    private final void $$robo$$android_widget_YearPickerView$setItemTextAppearance(int resId) {
        this.mAdapter.setItemTextAppearance(resId);
    }

    private final void $$robo$$android_widget_YearPickerView$postSetSelectionCentered(int position) {
        this.postSetSelectionFromTop(position, this.mViewSize / 2 - this.mChildSize / 2);
    }

    private final void $$robo$$android_widget_YearPickerView$postSetSelectionFromTop(int position, int offset) {
        this.post(new Runnable(this, position, offset){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ int val$position;
            /* synthetic */ int val$offset;
            /* synthetic */ YearPickerView this$0;

            private void $$robo$$android_widget_YearPickerView_1$__constructor__(YearPickerView yearPickerView, int n, int n2) {
            }

            private final void $$robo$$android_widget_YearPickerView_1$run() {
                this.this$0.setSelectionFromTop(this.val$position, this.val$offset);
                this.this$0.requestLayout();
            }

            private void __constructor__(YearPickerView yearPickerView, int n, int n2) {
                this.$$robo$$android_widget_YearPickerView_1$__constructor__(yearPickerView, n, n2);
            }
            {
                this.this$0 = yearPickerView;
                this.val$position = n;
                this.val$offset = n2;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_YearPickerView_1$__constructor__(android.widget.YearPickerView int int ), 0, this, yearPickerView, n, n2);
            }

            @Override
            public void run() {
                InvokeDynamicSupport.bootstrap("run", $$robo$$android_widget_YearPickerView_1$run(), 0, this);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        });
    }

    private final int $$robo$$android_widget_YearPickerView$getFirstPositionOffset() {
        View firstChild = this.getChildAt(0);
        if (firstChild == null) {
            return 0;
        }
        return firstChild.getTop();
    }

    private final void $$robo$$android_widget_YearPickerView$onDateChanged() {
        this.updateAdapterData();
        this.mAdapter.notifyDataSetChanged();
        this.postSetSelectionCentered(this.mController.getSelectedDay().get(1) - this.mController.getMinYear());
    }

    private final void $$robo$$android_widget_YearPickerView$onInitializeAccessibilityEvent(AccessibilityEvent event) {
        super.onInitializeAccessibilityEvent(event);
        if (event.getEventType() == 4096) {
            event.setFromIndex(0);
            event.setToIndex(0);
        }
    }

    private void __constructor__(Context context) {
        this.$$robo$$android_widget_YearPickerView$__constructor__(context);
    }

    public YearPickerView(Context context) {
        this(context, null);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_YearPickerView$__constructor__(android.content.Context ), 0, this, context);
    }

    private void __constructor__(Context context, AttributeSet attributeSet) {
        this.$$robo$$android_widget_YearPickerView$__constructor__(context, attributeSet);
    }

    public YearPickerView(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 16842868);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_YearPickerView$__constructor__(android.content.Context android.util.AttributeSet ), 0, this, context, attributeSet);
    }

    private void __constructor__(Context context, AttributeSet attributeSet, int n) {
        this.$$robo$$android_widget_YearPickerView$__constructor__(context, attributeSet, n);
    }

    public YearPickerView(Context context, AttributeSet attributeSet, int n) {
        this(context, attributeSet, n, 0);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_YearPickerView$__constructor__(android.content.Context android.util.AttributeSet int ), 0, this, context, attributeSet, n);
    }

    private void __constructor__(Context context, AttributeSet attributeSet, int n, int n2) {
        this.$$robo$$android_widget_YearPickerView$__constructor__(context, attributeSet, n, n2);
    }

    public YearPickerView(Context context, AttributeSet attributeSet, int n, int n2) {
        super(context, attributeSet, n, n2);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_YearPickerView$__constructor__(android.content.Context android.util.AttributeSet int int ), 0, this, context, attributeSet, n, n2);
    }

    public void init(DatePickerController datePickerController) {
        InvokeDynamicSupport.bootstrap("init", $$robo$$android_widget_YearPickerView$init(android.widget.DatePickerController ), 0, this, datePickerController);
    }

    public void setYearSelectedCircleColor(int n) {
        InvokeDynamicSupport.bootstrap("setYearSelectedCircleColor", $$robo$$android_widget_YearPickerView$setYearSelectedCircleColor(int ), 0, this, n);
    }

    public int getYearSelectedCircleColor() {
        return (int)InvokeDynamicSupport.bootstrap("getYearSelectedCircleColor", $$robo$$android_widget_YearPickerView$getYearSelectedCircleColor(), 0, this);
    }

    private void updateAdapterData() {
        InvokeDynamicSupport.bootstrap("updateAdapterData", $$robo$$android_widget_YearPickerView$updateAdapterData(), 0, this);
    }

    @Override
    public void onItemClick(AdapterView<?> adapterView, View view, int n, long l) {
        InvokeDynamicSupport.bootstrap("onItemClick", $$robo$$android_widget_YearPickerView$onItemClick(android.widget.AdapterView<?> android.view.View int long ), 0, this, adapterView, view, n, l);
    }

    void setItemTextAppearance(int n) {
        InvokeDynamicSupport.bootstrap("setItemTextAppearance", $$robo$$android_widget_YearPickerView$setItemTextAppearance(int ), 0, this, n);
    }

    public void postSetSelectionCentered(int n) {
        InvokeDynamicSupport.bootstrap("postSetSelectionCentered", $$robo$$android_widget_YearPickerView$postSetSelectionCentered(int ), 0, this, n);
    }

    public void postSetSelectionFromTop(int n, int n2) {
        InvokeDynamicSupport.bootstrap("postSetSelectionFromTop", $$robo$$android_widget_YearPickerView$postSetSelectionFromTop(int int ), 0, this, n, n2);
    }

    public int getFirstPositionOffset() {
        return (int)InvokeDynamicSupport.bootstrap("getFirstPositionOffset", $$robo$$android_widget_YearPickerView$getFirstPositionOffset(), 0, this);
    }

    @Override
    public void onDateChanged() {
        InvokeDynamicSupport.bootstrap("onDateChanged", $$robo$$android_widget_YearPickerView$onDateChanged(), 0, this);
    }

    @Override
    public void onInitializeAccessibilityEvent(AccessibilityEvent accessibilityEvent) {
        InvokeDynamicSupport.bootstrap("onInitializeAccessibilityEvent", $$robo$$android_widget_YearPickerView$onInitializeAccessibilityEvent(android.view.accessibility.AccessibilityEvent ), 0, this, accessibilityEvent);
    }

    public /* synthetic */ YearPickerView() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (YearPickerView)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    private class YearAdapter
    extends ArrayAdapter<Integer> {
        public transient /* synthetic */ Object __robo_data__;
        int mItemTextAppearanceResId;
        /* synthetic */ YearPickerView this$0;

        private void $$robo$$android_widget_YearPickerView_YearAdapter$__constructor__(YearPickerView yearPickerView, Context context, int resource) {
        }

        private final View $$robo$$android_widget_YearPickerView_YearAdapter$getView(int position, View convertView, ViewGroup parent) {
            TextViewWithCircularIndicator v = (TextViewWithCircularIndicator)super.getView(position, convertView, parent);
            v.setTextAppearance(this.getContext(), this.mItemTextAppearanceResId);
            v.requestLayout();
            int year = (Integer)this.getItem(position);
            boolean selected = this.this$0.mController.getSelectedDay().get(1) == year;
            v.setDrawIndicator(selected);
            if (selected) {
                v.setCircleColor(this.this$0.mYearSelectedCircleColor);
            }
            return v;
        }

        private final void $$robo$$android_widget_YearPickerView_YearAdapter$setItemTextAppearance(int resId) {
            this.mItemTextAppearanceResId = resId;
        }

        private void __constructor__(YearPickerView yearPickerView, Context context, int n) {
            this.$$robo$$android_widget_YearPickerView_YearAdapter$__constructor__(yearPickerView, context, n);
        }

        public YearAdapter(YearPickerView yearPickerView, Context context, int n) {
            this.this$0 = yearPickerView;
            super(context, n);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_YearPickerView_YearAdapter$__constructor__(android.widget.YearPickerView android.content.Context int ), 0, this, yearPickerView, context, n);
        }

        @Override
        public View getView(int n, View view, ViewGroup viewGroup) {
            return InvokeDynamicSupport.bootstrap("getView", $$robo$$android_widget_YearPickerView_YearAdapter$getView(int android.view.View android.view.ViewGroup ), 0, this, n, view, viewGroup);
        }

        public void setItemTextAppearance(int n) {
            InvokeDynamicSupport.bootstrap("setItemTextAppearance", $$robo$$android_widget_YearPickerView_YearAdapter$setItemTextAppearance(int ), 0, this, n);
        }

        public /* synthetic */ YearAdapter() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (YearAdapter)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

