/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.app;

import android.content.Context;
import android.content.DialogInterface;
import android.content.res.TypedArray;
import android.database.Cursor;
import android.graphics.drawable.Drawable;
import android.os.Handler;
import android.os.Message;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.TypedValue;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.view.WindowInsets;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.Button;
import android.widget.CheckedTextView;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.ScrollView;
import android.widget.SimpleCursorAdapter;
import android.widget.TextView;
import com.android.internal.R;
import com.google.errorprone.annotations.DoNotMock;
import java.lang.ref.WeakReference;
import org.robolectric.internal.bytecode.InstrumentedInterface;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class AlertController
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private Context mContext;
    private DialogInterface mDialogInterface;
    private Window mWindow;
    private CharSequence mTitle;
    private CharSequence mMessage;
    private ListView mListView;
    private View mView;
    private int mViewLayoutResId;
    private int mViewSpacingLeft;
    private int mViewSpacingTop;
    private int mViewSpacingRight;
    private int mViewSpacingBottom;
    private boolean mViewSpacingSpecified;
    private Button mButtonPositive;
    private CharSequence mButtonPositiveText;
    private Message mButtonPositiveMessage;
    private Button mButtonNegative;
    private CharSequence mButtonNegativeText;
    private Message mButtonNegativeMessage;
    private Button mButtonNeutral;
    private CharSequence mButtonNeutralText;
    private Message mButtonNeutralMessage;
    private ScrollView mScrollView;
    private int mIconId;
    private Drawable mIcon;
    private ImageView mIconView;
    private TextView mTitleView;
    private TextView mMessageView;
    private View mCustomTitleView;
    private boolean mForceInverseBackground;
    private ListAdapter mAdapter;
    private int mCheckedItem;
    private int mAlertDialogLayout;
    private int mButtonPanelSideLayout;
    private int mListLayout;
    private int mMultiChoiceItemLayout;
    private int mSingleChoiceItemLayout;
    private int mListItemLayout;
    private int mButtonPanelLayoutHint;
    private Handler mHandler;
    private View.OnClickListener mButtonHandler;

    private static final boolean $$robo$$com_android_internal_app_AlertController$shouldCenterSingleButton(Context context) {
        TypedValue outValue = new TypedValue();
        context.getTheme().resolveAttribute(16843803, outValue, true);
        return outValue.data != 0;
    }

    private void $$robo$$com_android_internal_app_AlertController$__constructor__(Context context, DialogInterface di, Window window) {
        this.mViewSpacingSpecified = false;
        this.mIconId = 0;
        this.mCheckedItem = -1;
        this.mButtonPanelLayoutHint = 0;
        this.mButtonHandler = new View.OnClickListener(this){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ AlertController this$0;

            private void $$robo$$com_android_internal_app_AlertController_1$__constructor__(AlertController alertController) {
            }

            private final void $$robo$$com_android_internal_app_AlertController_1$onClick(View v) {
                Message m = v == this.this$0.mButtonPositive && this.this$0.mButtonPositiveMessage != null ? Message.obtain(this.this$0.mButtonPositiveMessage) : (v == this.this$0.mButtonNegative && this.this$0.mButtonNegativeMessage != null ? Message.obtain(this.this$0.mButtonNegativeMessage) : (v == this.this$0.mButtonNeutral && this.this$0.mButtonNeutralMessage != null ? Message.obtain(this.this$0.mButtonNeutralMessage) : null));
                if (m != null) {
                    m.sendToTarget();
                }
                this.this$0.mHandler.obtainMessage(1, this.this$0.mDialogInterface).sendToTarget();
            }

            private void __constructor__(AlertController alertController) {
                this.$$robo$$com_android_internal_app_AlertController_1$__constructor__(alertController);
            }
            {
                this.this$0 = alertController;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_app_AlertController_1$__constructor__(com.android.internal.app.AlertController ), 0, this, alertController);
            }

            @Override
            public void onClick(View view) {
                InvokeDynamicSupport.bootstrap("onClick", $$robo$$com_android_internal_app_AlertController_1$onClick(android.view.View ), 0, this, view);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.mContext = context;
        this.mDialogInterface = di;
        this.mWindow = window;
        this.mHandler = new ButtonHandler(di);
        TypedArray a = context.obtainStyledAttributes(null, R.styleable.AlertDialog, 16842845, 0);
        this.mAlertDialogLayout = a.getResourceId(10, 17367078);
        this.mButtonPanelSideLayout = a.getResourceId(11, 0);
        this.mListLayout = a.getResourceId(12, 17367233);
        this.mMultiChoiceItemLayout = a.getResourceId(13, 17367059);
        this.mSingleChoiceItemLayout = a.getResourceId(14, 17367058);
        this.mListItemLayout = a.getResourceId(15, 0x1090011);
        a.recycle();
    }

    private static final boolean $$robo$$com_android_internal_app_AlertController$canTextInput(View v) {
        if (v.onCheckIsTextEditor()) {
            return true;
        }
        if (!(v instanceof ViewGroup)) {
            return false;
        }
        ViewGroup vg = (ViewGroup)v;
        int i = vg.getChildCount();
        while (i > 0) {
            if (!AlertController.canTextInput(v = vg.getChildAt(--i))) continue;
            return true;
        }
        return false;
    }

    private final void $$robo$$com_android_internal_app_AlertController$installContent() {
        this.mWindow.requestFeature(1);
        int contentView = this.selectContentView();
        this.mWindow.setContentView(contentView);
        this.setupView();
        this.setupDecor();
    }

    private final int $$robo$$com_android_internal_app_AlertController$selectContentView() {
        if (this.mButtonPanelSideLayout == 0) {
            return this.mAlertDialogLayout;
        }
        if (this.mButtonPanelLayoutHint == 1) {
            return this.mButtonPanelSideLayout;
        }
        return this.mAlertDialogLayout;
    }

    private final void $$robo$$com_android_internal_app_AlertController$setTitle(CharSequence title) {
        this.mTitle = title;
        if (this.mTitleView != null) {
            this.mTitleView.setText(title);
        }
    }

    private final void $$robo$$com_android_internal_app_AlertController$setCustomTitle(View customTitleView) {
        this.mCustomTitleView = customTitleView;
    }

    private final void $$robo$$com_android_internal_app_AlertController$setMessage(CharSequence message) {
        this.mMessage = message;
        if (this.mMessageView != null) {
            this.mMessageView.setText(message);
        }
    }

    private final void $$robo$$com_android_internal_app_AlertController$setView(int layoutResId) {
        this.mView = null;
        this.mViewLayoutResId = layoutResId;
        this.mViewSpacingSpecified = false;
    }

    private final void $$robo$$com_android_internal_app_AlertController$setView(View view) {
        this.mView = view;
        this.mViewLayoutResId = 0;
        this.mViewSpacingSpecified = false;
    }

    private final void $$robo$$com_android_internal_app_AlertController$setView(View view, int viewSpacingLeft, int viewSpacingTop, int viewSpacingRight, int viewSpacingBottom) {
        this.mView = view;
        this.mViewLayoutResId = 0;
        this.mViewSpacingSpecified = true;
        this.mViewSpacingLeft = viewSpacingLeft;
        this.mViewSpacingTop = viewSpacingTop;
        this.mViewSpacingRight = viewSpacingRight;
        this.mViewSpacingBottom = viewSpacingBottom;
    }

    private final void $$robo$$com_android_internal_app_AlertController$setButtonPanelLayoutHint(int layoutHint) {
        this.mButtonPanelLayoutHint = layoutHint;
    }

    private final void $$robo$$com_android_internal_app_AlertController$setButton(int whichButton, CharSequence text, DialogInterface.OnClickListener listener, Message msg) {
        if (msg == null && listener != null) {
            msg = this.mHandler.obtainMessage(whichButton, listener);
        }
        switch (whichButton) {
            case -1: {
                this.mButtonPositiveText = text;
                this.mButtonPositiveMessage = msg;
                break;
            }
            case -2: {
                this.mButtonNegativeText = text;
                this.mButtonNegativeMessage = msg;
                break;
            }
            case -3: {
                this.mButtonNeutralText = text;
                this.mButtonNeutralMessage = msg;
                break;
            }
            default: {
                throw new IllegalArgumentException("Button does not exist");
            }
        }
    }

    private final void $$robo$$com_android_internal_app_AlertController$setIcon(int resId) {
        this.mIcon = null;
        this.mIconId = resId;
        if (this.mIconView != null) {
            if (resId != 0) {
                this.mIconView.setImageResource(this.mIconId);
            } else {
                this.mIconView.setVisibility(8);
            }
        }
    }

    private final void $$robo$$com_android_internal_app_AlertController$setIcon(Drawable icon) {
        this.mIcon = icon;
        this.mIconId = 0;
        if (this.mIconView != null) {
            if (icon != null) {
                this.mIconView.setImageDrawable(icon);
            } else {
                this.mIconView.setVisibility(8);
            }
        }
    }

    private final int $$robo$$com_android_internal_app_AlertController$getIconAttributeResId(int attrId) {
        TypedValue out = new TypedValue();
        this.mContext.getTheme().resolveAttribute(attrId, out, true);
        return out.resourceId;
    }

    private final void $$robo$$com_android_internal_app_AlertController$setInverseBackgroundForced(boolean forceInverseBackground) {
        this.mForceInverseBackground = forceInverseBackground;
    }

    private final ListView $$robo$$com_android_internal_app_AlertController$getListView() {
        return this.mListView;
    }

    private final Button $$robo$$com_android_internal_app_AlertController$getButton(int whichButton) {
        switch (whichButton) {
            case -1: {
                return this.mButtonPositive;
            }
            case -2: {
                return this.mButtonNegative;
            }
            case -3: {
                return this.mButtonNeutral;
            }
        }
        return null;
    }

    private final boolean $$robo$$com_android_internal_app_AlertController$onKeyDown(int keyCode, KeyEvent event) {
        return this.mScrollView != null && this.mScrollView.executeKeyEvent(event);
    }

    private final boolean $$robo$$com_android_internal_app_AlertController$onKeyUp(int keyCode, KeyEvent event) {
        return this.mScrollView != null && this.mScrollView.executeKeyEvent(event);
    }

    private final void $$robo$$com_android_internal_app_AlertController$setupDecor() {
        View decor = this.mWindow.getDecorView();
        View parent = this.mWindow.findViewById(16908988);
        if (parent != null && decor != null) {
            decor.setOnApplyWindowInsetsListener(new View.OnApplyWindowInsetsListener(this, parent){
                public transient /* synthetic */ Object __robo_data__;
                /* synthetic */ View val$parent;
                /* synthetic */ AlertController this$0;

                private void $$robo$$com_android_internal_app_AlertController_2$__constructor__(AlertController alertController, View view) {
                }

                private final WindowInsets $$robo$$com_android_internal_app_AlertController_2$onApplyWindowInsets(View view, WindowInsets insets) {
                    if (insets.isRound()) {
                        int roundOffset = this.this$0.mContext.getResources().getDimensionPixelOffset(17104947);
                        this.val$parent.setPadding(roundOffset, roundOffset, roundOffset, roundOffset);
                    }
                    return insets.consumeSystemWindowInsets();
                }

                private void __constructor__(AlertController alertController, View view) {
                    this.$$robo$$com_android_internal_app_AlertController_2$__constructor__(alertController, view);
                }
                {
                    this.this$0 = alertController;
                    this.val$parent = view;
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_app_AlertController_2$__constructor__(com.android.internal.app.AlertController android.view.View ), 0, this, alertController, view);
                }

                @Override
                public WindowInsets onApplyWindowInsets(View view, WindowInsets windowInsets) {
                    return InvokeDynamicSupport.bootstrap("onApplyWindowInsets", $$robo$$com_android_internal_app_AlertController_2$onApplyWindowInsets(android.view.View android.view.WindowInsets ), 0, this, view, windowInsets);
                }
                {
                    this.$$robo$init();
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            });
            decor.setFitsSystemWindows(true);
            decor.requestApplyInsets();
        }
    }

    private final void $$robo$$com_android_internal_app_AlertController$setupView() {
        View divider;
        boolean hasCustomView;
        View customView;
        LinearLayout contentPanel = (LinearLayout)this.mWindow.findViewById(16908996);
        this.setupContent(contentPanel);
        boolean hasButtons = this.setupButtons();
        LinearLayout topPanel = (LinearLayout)this.mWindow.findViewById(16908989);
        TypedArray a = this.mContext.obtainStyledAttributes(null, R.styleable.AlertDialog, 16842845, 0);
        boolean hasTitle = this.setupTitle(topPanel);
        View buttonPanel = this.mWindow.findViewById(16908993);
        if (!hasButtons) {
            buttonPanel.setVisibility(8);
            View spacer = this.mWindow.findViewById(16909001);
            if (spacer != null) {
                spacer.setVisibility(0);
            }
            this.mWindow.setCloseOnTouchOutsideIfNotSet(true);
        }
        FrameLayout customPanel = (FrameLayout)this.mWindow.findViewById(16908998);
        if (this.mView != null) {
            customView = this.mView;
        } else if (this.mViewLayoutResId != 0) {
            LayoutInflater inflater = LayoutInflater.from(this.mContext);
            customView = inflater.inflate(this.mViewLayoutResId, (ViewGroup)customPanel, false);
        } else {
            customView = null;
        }
        boolean bl = hasCustomView = customView != null;
        if (!hasCustomView || !AlertController.canTextInput(customView)) {
            this.mWindow.setFlags(131072, 131072);
        }
        if (hasCustomView) {
            FrameLayout custom = (FrameLayout)this.mWindow.findViewById(16908331);
            custom.addView(customView, new ViewGroup.LayoutParams(-1, -1));
            if (this.mViewSpacingSpecified) {
                custom.setPadding(this.mViewSpacingLeft, this.mViewSpacingTop, this.mViewSpacingRight, this.mViewSpacingBottom);
            }
            if (this.mListView != null) {
                ((LinearLayout.LayoutParams)customPanel.getLayoutParams()).weight = 0.0f;
            }
        } else {
            customPanel.setVisibility(8);
        }
        if (hasTitle && (divider = this.mMessage != null || customView != null || this.mListView != null ? this.mWindow.findViewById(16908992) : this.mWindow.findViewById(16908999)) != null) {
            divider.setVisibility(0);
        }
        this.setBackground(a, topPanel, contentPanel, customPanel, buttonPanel, hasTitle, hasCustomView, hasButtons);
        a.recycle();
    }

    private final boolean $$robo$$com_android_internal_app_AlertController$setupTitle(LinearLayout topPanel) {
        boolean hasTitle = true;
        if (this.mCustomTitleView != null) {
            LinearLayout.LayoutParams lp = new LinearLayout.LayoutParams(-1, -2);
            topPanel.addView(this.mCustomTitleView, 0, lp);
            View titleTemplate = this.mWindow.findViewById(16908990);
            titleTemplate.setVisibility(8);
        } else {
            boolean hasTextTitle;
            this.mIconView = (ImageView)this.mWindow.findViewById(16908294);
            boolean bl = hasTextTitle = !TextUtils.isEmpty(this.mTitle);
            if (hasTextTitle) {
                this.mTitleView = (TextView)this.mWindow.findViewById(16908991);
                this.mTitleView.setText(this.mTitle);
                if (this.mIconId != 0) {
                    this.mIconView.setImageResource(this.mIconId);
                } else if (this.mIcon != null) {
                    this.mIconView.setImageDrawable(this.mIcon);
                } else {
                    this.mTitleView.setPadding(this.mIconView.getPaddingLeft(), this.mIconView.getPaddingTop(), this.mIconView.getPaddingRight(), this.mIconView.getPaddingBottom());
                    this.mIconView.setVisibility(8);
                }
            } else {
                View titleTemplate = this.mWindow.findViewById(16908990);
                titleTemplate.setVisibility(8);
                this.mIconView.setVisibility(8);
                topPanel.setVisibility(8);
                hasTitle = false;
            }
        }
        return hasTitle;
    }

    private final void $$robo$$com_android_internal_app_AlertController$setupContent(LinearLayout contentPanel) {
        this.mScrollView = (ScrollView)this.mWindow.findViewById(16908997);
        this.mScrollView.setFocusable(false);
        this.mMessageView = (TextView)this.mWindow.findViewById(16908299);
        if (this.mMessageView == null) {
            return;
        }
        if (this.mMessage != null) {
            this.mMessageView.setText(this.mMessage);
        } else {
            this.mMessageView.setVisibility(8);
            this.mScrollView.removeView(this.mMessageView);
            if (this.mListView != null) {
                contentPanel.removeView(this.mWindow.findViewById(16908997));
                contentPanel.addView((View)this.mListView, new LinearLayout.LayoutParams(-1, -1));
                contentPanel.setLayoutParams(new LinearLayout.LayoutParams(-1, 0, 1.0f));
            } else {
                contentPanel.setVisibility(8);
            }
        }
    }

    private final boolean $$robo$$com_android_internal_app_AlertController$setupButtons() {
        int BIT_BUTTON_POSITIVE = 1;
        int BIT_BUTTON_NEGATIVE = 2;
        int BIT_BUTTON_NEUTRAL = 4;
        int whichButtons = 0;
        this.mButtonPositive = (Button)this.mWindow.findViewById(16908313);
        this.mButtonPositive.setOnClickListener(this.mButtonHandler);
        if (TextUtils.isEmpty(this.mButtonPositiveText)) {
            this.mButtonPositive.setVisibility(8);
        } else {
            this.mButtonPositive.setText(this.mButtonPositiveText);
            this.mButtonPositive.setVisibility(0);
            whichButtons |= BIT_BUTTON_POSITIVE;
        }
        this.mButtonNegative = (Button)this.mWindow.findViewById(16908314);
        this.mButtonNegative.setOnClickListener(this.mButtonHandler);
        if (TextUtils.isEmpty(this.mButtonNegativeText)) {
            this.mButtonNegative.setVisibility(8);
        } else {
            this.mButtonNegative.setText(this.mButtonNegativeText);
            this.mButtonNegative.setVisibility(0);
            whichButtons |= BIT_BUTTON_NEGATIVE;
        }
        this.mButtonNeutral = (Button)this.mWindow.findViewById(16908315);
        this.mButtonNeutral.setOnClickListener(this.mButtonHandler);
        if (TextUtils.isEmpty(this.mButtonNeutralText)) {
            this.mButtonNeutral.setVisibility(8);
        } else {
            this.mButtonNeutral.setText(this.mButtonNeutralText);
            this.mButtonNeutral.setVisibility(0);
            whichButtons |= BIT_BUTTON_NEUTRAL;
        }
        if (AlertController.shouldCenterSingleButton(this.mContext)) {
            if (whichButtons == BIT_BUTTON_POSITIVE) {
                this.centerButton(this.mButtonPositive);
            } else if (whichButtons == BIT_BUTTON_NEGATIVE) {
                this.centerButton(this.mButtonNegative);
            } else if (whichButtons == BIT_BUTTON_NEUTRAL) {
                this.centerButton(this.mButtonNeutral);
            }
        }
        return whichButtons != 0;
    }

    private final void $$robo$$com_android_internal_app_AlertController$centerButton(Button button) {
        View rightSpacer;
        LinearLayout.LayoutParams params = (LinearLayout.LayoutParams)button.getLayoutParams();
        params.gravity = 1;
        params.weight = 0.5f;
        button.setLayoutParams(params);
        View leftSpacer = this.mWindow.findViewById(16908994);
        if (leftSpacer != null) {
            leftSpacer.setVisibility(0);
        }
        if ((rightSpacer = this.mWindow.findViewById(16908995)) != null) {
            rightSpacer.setVisibility(0);
        }
    }

    private final void $$robo$$com_android_internal_app_AlertController$setBackground(TypedArray a, View topPanel, View contentPanel, View customPanel, View buttonPanel, boolean hasTitle, boolean hasCustomView, boolean hasButtons) {
        ListView listView;
        int fullDark = 0;
        int topDark = 0;
        int centerDark = 0;
        int bottomDark = 0;
        int fullBright = 0;
        int topBright = 0;
        int centerBright = 0;
        int bottomBright = 0;
        int bottomMedium = 0;
        boolean needsDefaultBackgrounds = a.getBoolean(18, true);
        if (needsDefaultBackgrounds) {
            fullDark = 17302870;
            topDark = 17302884;
            centerDark = 17302867;
            bottomDark = 17302864;
            fullBright = 17302869;
            topBright = 17302883;
            centerBright = 17302866;
            bottomBright = 17302863;
            bottomMedium = 17302865;
        }
        topBright = a.getResourceId(5, topBright);
        topDark = a.getResourceId(1, topDark);
        centerBright = a.getResourceId(6, centerBright);
        centerDark = a.getResourceId(2, centerDark);
        View[] views = new View[4];
        boolean[] light = new boolean[4];
        View lastView = null;
        boolean lastLight = false;
        int pos = 0;
        if (hasTitle) {
            views[pos] = topPanel;
            light[pos] = false;
            ++pos;
        }
        views[pos] = contentPanel.getVisibility() == 8 ? null : contentPanel;
        light[pos] = this.mListView != null;
        ++pos;
        if (hasCustomView) {
            views[pos] = customPanel;
            light[pos] = this.mForceInverseBackground;
            ++pos;
        }
        if (hasButtons) {
            views[pos] = buttonPanel;
            light[pos] = true;
        }
        boolean setView = false;
        for (pos = 0; pos < views.length; ++pos) {
            View v = views[pos];
            if (v == null) continue;
            if (lastView != null) {
                if (!setView) {
                    lastView.setBackgroundResource(lastLight ? topBright : topDark);
                } else {
                    lastView.setBackgroundResource(lastLight ? centerBright : centerDark);
                }
                setView = true;
            }
            lastView = v;
            lastLight = light[pos];
        }
        if (lastView != null) {
            if (setView) {
                bottomBright = a.getResourceId(7, bottomBright);
                bottomMedium = a.getResourceId(8, bottomMedium);
                bottomDark = a.getResourceId(3, bottomDark);
                lastView.setBackgroundResource(lastLight ? (hasButtons ? bottomMedium : bottomBright) : bottomDark);
            } else {
                fullBright = a.getResourceId(4, fullBright);
                fullDark = a.getResourceId(0, fullDark);
                lastView.setBackgroundResource(lastLight ? fullBright : fullDark);
            }
        }
        if ((listView = this.mListView) != null && this.mAdapter != null) {
            listView.setAdapter(this.mAdapter);
            int checkedItem = this.mCheckedItem;
            if (checkedItem > -1) {
                listView.setItemChecked(checkedItem, true);
                listView.setSelection(checkedItem);
            }
        }
    }

    private static boolean shouldCenterSingleButton(Context context) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("shouldCenterSingleButton", $$robo$$com_android_internal_app_AlertController$shouldCenterSingleButton(android.content.Context ), 0, (Context)context);
    }

    private void __constructor__(Context context, DialogInterface dialogInterface, Window window) {
        this.$$robo$$com_android_internal_app_AlertController$__constructor__(context, dialogInterface, window);
    }

    public AlertController(Context context, DialogInterface dialogInterface, Window window) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_app_AlertController$__constructor__(android.content.Context android.content.DialogInterface android.view.Window ), 0, this, context, dialogInterface, window);
    }

    static boolean canTextInput(View view) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("canTextInput", $$robo$$com_android_internal_app_AlertController$canTextInput(android.view.View ), 0, (View)view);
    }

    public void installContent() {
        InvokeDynamicSupport.bootstrap("installContent", $$robo$$com_android_internal_app_AlertController$installContent(), 0, this);
    }

    private int selectContentView() {
        return (int)InvokeDynamicSupport.bootstrap("selectContentView", $$robo$$com_android_internal_app_AlertController$selectContentView(), 0, this);
    }

    public void setTitle(CharSequence charSequence) {
        InvokeDynamicSupport.bootstrap("setTitle", $$robo$$com_android_internal_app_AlertController$setTitle(java.lang.CharSequence ), 0, this, charSequence);
    }

    public void setCustomTitle(View view) {
        InvokeDynamicSupport.bootstrap("setCustomTitle", $$robo$$com_android_internal_app_AlertController$setCustomTitle(android.view.View ), 0, this, view);
    }

    public void setMessage(CharSequence charSequence) {
        InvokeDynamicSupport.bootstrap("setMessage", $$robo$$com_android_internal_app_AlertController$setMessage(java.lang.CharSequence ), 0, this, charSequence);
    }

    public void setView(int n) {
        InvokeDynamicSupport.bootstrap("setView", $$robo$$com_android_internal_app_AlertController$setView(int ), 0, this, n);
    }

    public void setView(View view) {
        InvokeDynamicSupport.bootstrap("setView", $$robo$$com_android_internal_app_AlertController$setView(android.view.View ), 0, this, view);
    }

    public void setView(View view, int n, int n2, int n3, int n4) {
        InvokeDynamicSupport.bootstrap("setView", $$robo$$com_android_internal_app_AlertController$setView(android.view.View int int int int ), 0, this, view, n, n2, n3, n4);
    }

    public void setButtonPanelLayoutHint(int n) {
        InvokeDynamicSupport.bootstrap("setButtonPanelLayoutHint", $$robo$$com_android_internal_app_AlertController$setButtonPanelLayoutHint(int ), 0, this, n);
    }

    public void setButton(int n, CharSequence charSequence, DialogInterface.OnClickListener onClickListener, Message message) {
        InvokeDynamicSupport.bootstrap("setButton", $$robo$$com_android_internal_app_AlertController$setButton(int java.lang.CharSequence android.content.DialogInterface$OnClickListener android.os.Message ), 0, this, n, charSequence, onClickListener, message);
    }

    public void setIcon(int n) {
        InvokeDynamicSupport.bootstrap("setIcon", $$robo$$com_android_internal_app_AlertController$setIcon(int ), 0, this, n);
    }

    public void setIcon(Drawable drawable2) {
        InvokeDynamicSupport.bootstrap("setIcon", $$robo$$com_android_internal_app_AlertController$setIcon(android.graphics.drawable.Drawable ), 0, this, drawable2);
    }

    public int getIconAttributeResId(int n) {
        return (int)InvokeDynamicSupport.bootstrap("getIconAttributeResId", $$robo$$com_android_internal_app_AlertController$getIconAttributeResId(int ), 0, this, n);
    }

    public void setInverseBackgroundForced(boolean bl) {
        InvokeDynamicSupport.bootstrap("setInverseBackgroundForced", $$robo$$com_android_internal_app_AlertController$setInverseBackgroundForced(boolean ), 0, this, bl);
    }

    public ListView getListView() {
        return InvokeDynamicSupport.bootstrap("getListView", $$robo$$com_android_internal_app_AlertController$getListView(), 0, this);
    }

    public Button getButton(int n) {
        return InvokeDynamicSupport.bootstrap("getButton", $$robo$$com_android_internal_app_AlertController$getButton(int ), 0, this, n);
    }

    public boolean onKeyDown(int n, KeyEvent keyEvent) {
        return (boolean)InvokeDynamicSupport.bootstrap("onKeyDown", $$robo$$com_android_internal_app_AlertController$onKeyDown(int android.view.KeyEvent ), 0, this, n, keyEvent);
    }

    public boolean onKeyUp(int n, KeyEvent keyEvent) {
        return (boolean)InvokeDynamicSupport.bootstrap("onKeyUp", $$robo$$com_android_internal_app_AlertController$onKeyUp(int android.view.KeyEvent ), 0, this, n, keyEvent);
    }

    private void setupDecor() {
        InvokeDynamicSupport.bootstrap("setupDecor", $$robo$$com_android_internal_app_AlertController$setupDecor(), 0, this);
    }

    private void setupView() {
        InvokeDynamicSupport.bootstrap("setupView", $$robo$$com_android_internal_app_AlertController$setupView(), 0, this);
    }

    private boolean setupTitle(LinearLayout linearLayout) {
        return (boolean)InvokeDynamicSupport.bootstrap("setupTitle", $$robo$$com_android_internal_app_AlertController$setupTitle(android.widget.LinearLayout ), 0, this, linearLayout);
    }

    private void setupContent(LinearLayout linearLayout) {
        InvokeDynamicSupport.bootstrap("setupContent", $$robo$$com_android_internal_app_AlertController$setupContent(android.widget.LinearLayout ), 0, this, linearLayout);
    }

    private boolean setupButtons() {
        return (boolean)InvokeDynamicSupport.bootstrap("setupButtons", $$robo$$com_android_internal_app_AlertController$setupButtons(), 0, this);
    }

    private void centerButton(Button button) {
        InvokeDynamicSupport.bootstrap("centerButton", $$robo$$com_android_internal_app_AlertController$centerButton(android.widget.Button ), 0, this, button);
    }

    private void setBackground(TypedArray typedArray, View view, View view2, View view3, View view4, boolean bl, boolean bl2, boolean bl3) {
        InvokeDynamicSupport.bootstrap("setBackground", $$robo$$com_android_internal_app_AlertController$setBackground(android.content.res.TypedArray android.view.View android.view.View android.view.View android.view.View boolean boolean boolean ), 0, this, typedArray, view, view2, view3, view4, bl, bl2, bl3);
    }

    public /* synthetic */ AlertController() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (AlertController)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    private static class CheckedItemAdapter
    extends ArrayAdapter<CharSequence> {
        public transient /* synthetic */ Object __robo_data__;

        private void $$robo$$com_android_internal_app_AlertController_CheckedItemAdapter$__constructor__(Context context, int resource, int textViewResourceId, CharSequence[] objects) {
        }

        private final boolean $$robo$$com_android_internal_app_AlertController_CheckedItemAdapter$hasStableIds() {
            return true;
        }

        private final long $$robo$$com_android_internal_app_AlertController_CheckedItemAdapter$getItemId(int position) {
            return position;
        }

        private void __constructor__(Context context, int n, int n2, CharSequence[] charSequenceArray) {
            this.$$robo$$com_android_internal_app_AlertController_CheckedItemAdapter$__constructor__(context, n, n2, charSequenceArray);
        }

        public CheckedItemAdapter(Context context, int n, int n2, CharSequence[] charSequenceArray) {
            super(context, n, n2, charSequenceArray);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_app_AlertController_CheckedItemAdapter$__constructor__(android.content.Context int int java.lang.CharSequence[] ), 0, this, context, n, n2, charSequenceArray);
        }

        @Override
        public boolean hasStableIds() {
            return (boolean)InvokeDynamicSupport.bootstrap("hasStableIds", $$robo$$com_android_internal_app_AlertController_CheckedItemAdapter$hasStableIds(), 0, this);
        }

        @Override
        public long getItemId(int n) {
            return (long)InvokeDynamicSupport.bootstrap("getItemId", $$robo$$com_android_internal_app_AlertController_CheckedItemAdapter$getItemId(int ), 0, this, n);
        }

        public /* synthetic */ CheckedItemAdapter() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (CheckedItemAdapter)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class AlertParams
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public Context mContext;
        public LayoutInflater mInflater;
        public int mIconId;
        public Drawable mIcon;
        public int mIconAttrId;
        public CharSequence mTitle;
        public View mCustomTitleView;
        public CharSequence mMessage;
        public CharSequence mPositiveButtonText;
        public DialogInterface.OnClickListener mPositiveButtonListener;
        public CharSequence mNegativeButtonText;
        public DialogInterface.OnClickListener mNegativeButtonListener;
        public CharSequence mNeutralButtonText;
        public DialogInterface.OnClickListener mNeutralButtonListener;
        public boolean mCancelable;
        public DialogInterface.OnCancelListener mOnCancelListener;
        public DialogInterface.OnDismissListener mOnDismissListener;
        public DialogInterface.OnKeyListener mOnKeyListener;
        public CharSequence[] mItems;
        public ListAdapter mAdapter;
        public DialogInterface.OnClickListener mOnClickListener;
        public int mViewLayoutResId;
        public View mView;
        public int mViewSpacingLeft;
        public int mViewSpacingTop;
        public int mViewSpacingRight;
        public int mViewSpacingBottom;
        public boolean mViewSpacingSpecified;
        public boolean[] mCheckedItems;
        public boolean mIsMultiChoice;
        public boolean mIsSingleChoice;
        public int mCheckedItem;
        public DialogInterface.OnMultiChoiceClickListener mOnCheckboxClickListener;
        public Cursor mCursor;
        public String mLabelColumn;
        public String mIsCheckedColumn;
        public boolean mForceInverseBackground;
        public AdapterView.OnItemSelectedListener mOnItemSelectedListener;
        public OnPrepareListViewListener mOnPrepareListViewListener;
        public boolean mRecycleOnMeasure;

        private void $$robo$$com_android_internal_app_AlertController_AlertParams$__constructor__(Context context) {
            this.mIconId = 0;
            this.mIconAttrId = 0;
            this.mViewSpacingSpecified = false;
            this.mCheckedItem = -1;
            this.mRecycleOnMeasure = true;
            this.mContext = context;
            this.mCancelable = true;
            this.mInflater = (LayoutInflater)context.getSystemService("layout_inflater");
        }

        private final void $$robo$$com_android_internal_app_AlertController_AlertParams$apply(AlertController dialog) {
            if (this.mCustomTitleView != null) {
                dialog.setCustomTitle(this.mCustomTitleView);
            } else {
                if (this.mTitle != null) {
                    dialog.setTitle(this.mTitle);
                }
                if (this.mIcon != null) {
                    dialog.setIcon(this.mIcon);
                }
                if (this.mIconId >= 0) {
                    dialog.setIcon(this.mIconId);
                }
                if (this.mIconAttrId > 0) {
                    dialog.setIcon(dialog.getIconAttributeResId(this.mIconAttrId));
                }
            }
            if (this.mMessage != null) {
                dialog.setMessage(this.mMessage);
            }
            if (this.mPositiveButtonText != null) {
                dialog.setButton(-1, this.mPositiveButtonText, this.mPositiveButtonListener, null);
            }
            if (this.mNegativeButtonText != null) {
                dialog.setButton(-2, this.mNegativeButtonText, this.mNegativeButtonListener, null);
            }
            if (this.mNeutralButtonText != null) {
                dialog.setButton(-3, this.mNeutralButtonText, this.mNeutralButtonListener, null);
            }
            if (this.mForceInverseBackground) {
                dialog.setInverseBackgroundForced(true);
            }
            if (this.mItems != null || this.mCursor != null || this.mAdapter != null) {
                this.createListView(dialog);
            }
            if (this.mView != null) {
                if (this.mViewSpacingSpecified) {
                    dialog.setView(this.mView, this.mViewSpacingLeft, this.mViewSpacingTop, this.mViewSpacingRight, this.mViewSpacingBottom);
                } else {
                    dialog.setView(this.mView);
                }
            } else if (this.mViewLayoutResId != 0) {
                dialog.setView(this.mViewLayoutResId);
            }
        }

        private final void $$robo$$com_android_internal_app_AlertController_AlertParams$createListView(AlertController dialog) {
            Object adapter;
            RecycleListView listView = (RecycleListView)this.mInflater.inflate(dialog.mListLayout, null);
            if (this.mIsMultiChoice) {
                adapter = this.mCursor == null ? new ArrayAdapter<CharSequence>(this, this.mContext, dialog.mMultiChoiceItemLayout, 16908308, this.mItems, listView){
                    public transient /* synthetic */ Object __robo_data__;
                    /* synthetic */ RecycleListView val$listView;
                    /* synthetic */ AlertParams this$0;

                    private void $$robo$$com_android_internal_app_AlertController_AlertParams_1$__constructor__(AlertParams alertParams, Context x0, int x1, int x2, CharSequence[] x3, RecycleListView recycleListView) {
                    }

                    private final View $$robo$$com_android_internal_app_AlertController_AlertParams_1$getView(int position, View convertView, ViewGroup parent) {
                        boolean isItemChecked;
                        View view = super.getView(position, convertView, parent);
                        if (this.this$0.mCheckedItems != null && (isItemChecked = this.this$0.mCheckedItems[position])) {
                            this.val$listView.setItemChecked(position, true);
                        }
                        return view;
                    }

                    private void __constructor__(AlertParams alertParams, Context context, int n, int n2, CharSequence[] charSequenceArray, RecycleListView recycleListView) {
                        this.$$robo$$com_android_internal_app_AlertController_AlertParams_1$__constructor__(alertParams, context, n, n2, charSequenceArray, recycleListView);
                    }
                    {
                        this.this$0 = alertParams;
                        this.val$listView = recycleListView;
                        super(context, n, n2, charSequenceArray);
                        this.$$robo$init();
                        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_app_AlertController_AlertParams_1$__constructor__(com.android.internal.app.AlertController$AlertParams android.content.Context int int java.lang.CharSequence[] com.android.internal.app.AlertController$RecycleListView ), 0, this, alertParams, context, n, n2, charSequenceArray, recycleListView);
                    }

                    @Override
                    public View getView(int n, View view, ViewGroup viewGroup) {
                        return InvokeDynamicSupport.bootstrap("getView", $$robo$$com_android_internal_app_AlertController_AlertParams_1$getView(int android.view.View android.view.ViewGroup ), 0, this, n, view, viewGroup);
                    }
                    {
                        this.$$robo$init();
                    }

                    @Override
                    protected /* synthetic */ void $$robo$init() {
                        if (this.__robo_data__ == null) {
                            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                        }
                    }

                    @Override
                    public /* synthetic */ Object $$robo$getData() {
                        return this.__robo_data__;
                    }
                } : new ShadowedObject(this, this.mContext, this.mCursor, false, listView, dialog){
                    public transient /* synthetic */ Object __robo_data__;
                    private int mLabelIndex;
                    private int mIsCheckedIndex;
                    /* synthetic */ RecycleListView val$listView;
                    /* synthetic */ AlertController val$dialog;
                    /* synthetic */ AlertParams this$0;

                    private void $$robo$$com_android_internal_app_AlertController_AlertParams_2$__constructor__(AlertParams alertParams, Context x0, Cursor x1, boolean x2, RecycleListView recycleListView, AlertController alertController) {
                        Cursor cursor = this.getCursor();
                        this.mLabelIndex = cursor.getColumnIndexOrThrow(this.this$0.mLabelColumn);
                        this.mIsCheckedIndex = cursor.getColumnIndexOrThrow(this.this$0.mIsCheckedColumn);
                    }

                    private final void $$robo$$com_android_internal_app_AlertController_AlertParams_2$bindView(View view, Context context, Cursor cursor) {
                        CheckedTextView text = (CheckedTextView)view.findViewById(16908308);
                        text.setText(cursor.getString(this.mLabelIndex));
                        this.val$listView.setItemChecked(cursor.getPosition(), cursor.getInt(this.mIsCheckedIndex) == 1);
                    }

                    private final View $$robo$$com_android_internal_app_AlertController_AlertParams_2$newView(Context context, Cursor cursor, ViewGroup parent) {
                        return this.this$0.mInflater.inflate(this.val$dialog.mMultiChoiceItemLayout, parent, false);
                    }

                    private void __constructor__(AlertParams alertParams, Context context, Cursor cursor, boolean bl, RecycleListView recycleListView, AlertController alertController) {
                        this.$$robo$$com_android_internal_app_AlertController_AlertParams_2$__constructor__(alertParams, context, cursor, bl, recycleListView, alertController);
                    }
                    {
                        this.this$0 = alertParams;
                        this.val$listView = recycleListView;
                        this.val$dialog = alertController;
                        super(context, cursor, bl);
                        this.$$robo$init();
                        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_app_AlertController_AlertParams_2$__constructor__(com.android.internal.app.AlertController$AlertParams android.content.Context android.database.Cursor boolean com.android.internal.app.AlertController$RecycleListView com.android.internal.app.AlertController ), 0, this, alertParams, context, cursor, bl, recycleListView, alertController);
                    }

                    @Override
                    public void bindView(View view, Context context, Cursor cursor) {
                        InvokeDynamicSupport.bootstrap("bindView", $$robo$$com_android_internal_app_AlertController_AlertParams_2$bindView(android.view.View android.content.Context android.database.Cursor ), 0, this, view, context, cursor);
                    }

                    @Override
                    public View newView(Context context, Cursor cursor, ViewGroup viewGroup) {
                        return InvokeDynamicSupport.bootstrap("newView", $$robo$$com_android_internal_app_AlertController_AlertParams_2$newView(android.content.Context android.database.Cursor android.view.ViewGroup ), 0, this, context, cursor, viewGroup);
                    }
                    {
                        this.$$robo$init();
                    }

                    @Override
                    protected /* synthetic */ void $$robo$init() {
                        if (this.__robo_data__ == null) {
                            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                        }
                    }

                    @Override
                    public /* synthetic */ Object $$robo$getData() {
                        return this.__robo_data__;
                    }
                };
            } else {
                int layout2;
                int n = layout2 = this.mIsSingleChoice ? dialog.mSingleChoiceItemLayout : dialog.mListItemLayout;
                adapter = this.mCursor == null ? (this.mAdapter != null ? this.mAdapter : new CheckedItemAdapter(this.mContext, layout2, 16908308, this.mItems)) : new SimpleCursorAdapter(this.mContext, layout2, this.mCursor, new String[]{this.mLabelColumn}, new int[]{16908308});
            }
            if (this.mOnPrepareListViewListener != null) {
                this.mOnPrepareListViewListener.onPrepareListView(listView);
            }
            dialog.mAdapter = (ListAdapter)adapter;
            dialog.mCheckedItem = this.mCheckedItem;
            if (this.mOnClickListener != null) {
                listView.setOnItemClickListener(new AdapterView.OnItemClickListener(this, dialog){
                    public transient /* synthetic */ Object __robo_data__;
                    /* synthetic */ AlertController val$dialog;
                    /* synthetic */ AlertParams this$0;

                    private void $$robo$$com_android_internal_app_AlertController_AlertParams_3$__constructor__(AlertParams alertParams, AlertController alertController) {
                    }

                    private final void $$robo$$com_android_internal_app_AlertController_AlertParams_3$onItemClick(AdapterView<?> parent, View v, int position, long id2) {
                        this.this$0.mOnClickListener.onClick(this.val$dialog.mDialogInterface, position);
                        if (!this.this$0.mIsSingleChoice) {
                            this.val$dialog.mDialogInterface.dismiss();
                        }
                    }

                    private void __constructor__(AlertParams alertParams, AlertController alertController) {
                        this.$$robo$$com_android_internal_app_AlertController_AlertParams_3$__constructor__(alertParams, alertController);
                    }
                    {
                        this.this$0 = alertParams;
                        this.val$dialog = alertController;
                        this.$$robo$init();
                        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_app_AlertController_AlertParams_3$__constructor__(com.android.internal.app.AlertController$AlertParams com.android.internal.app.AlertController ), 0, this, alertParams, alertController);
                    }

                    @Override
                    public void onItemClick(AdapterView<?> adapterView, View view, int n, long l) {
                        InvokeDynamicSupport.bootstrap("onItemClick", $$robo$$com_android_internal_app_AlertController_AlertParams_3$onItemClick(android.widget.AdapterView<?> android.view.View int long ), 0, this, adapterView, view, n, l);
                    }
                    {
                        this.$$robo$init();
                    }

                    protected /* synthetic */ void $$robo$init() {
                        if (this.__robo_data__ == null) {
                            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                        }
                    }

                    public /* synthetic */ Object $$robo$getData() {
                        return this.__robo_data__;
                    }
                });
            } else if (this.mOnCheckboxClickListener != null) {
                listView.setOnItemClickListener(new AdapterView.OnItemClickListener(this, listView, dialog){
                    public transient /* synthetic */ Object __robo_data__;
                    /* synthetic */ RecycleListView val$listView;
                    /* synthetic */ AlertController val$dialog;
                    /* synthetic */ AlertParams this$0;

                    private void $$robo$$com_android_internal_app_AlertController_AlertParams_4$__constructor__(AlertParams alertParams, RecycleListView recycleListView, AlertController alertController) {
                    }

                    private final void $$robo$$com_android_internal_app_AlertController_AlertParams_4$onItemClick(AdapterView<?> parent, View v, int position, long id2) {
                        if (this.this$0.mCheckedItems != null) {
                            this.this$0.mCheckedItems[position] = this.val$listView.isItemChecked(position);
                        }
                        this.this$0.mOnCheckboxClickListener.onClick(this.val$dialog.mDialogInterface, position, this.val$listView.isItemChecked(position));
                    }

                    private void __constructor__(AlertParams alertParams, RecycleListView recycleListView, AlertController alertController) {
                        this.$$robo$$com_android_internal_app_AlertController_AlertParams_4$__constructor__(alertParams, recycleListView, alertController);
                    }
                    {
                        this.this$0 = alertParams;
                        this.val$listView = recycleListView;
                        this.val$dialog = alertController;
                        this.$$robo$init();
                        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_app_AlertController_AlertParams_4$__constructor__(com.android.internal.app.AlertController$AlertParams com.android.internal.app.AlertController$RecycleListView com.android.internal.app.AlertController ), 0, this, alertParams, recycleListView, alertController);
                    }

                    @Override
                    public void onItemClick(AdapterView<?> adapterView, View view, int n, long l) {
                        InvokeDynamicSupport.bootstrap("onItemClick", $$robo$$com_android_internal_app_AlertController_AlertParams_4$onItemClick(android.widget.AdapterView<?> android.view.View int long ), 0, this, adapterView, view, n, l);
                    }
                    {
                        this.$$robo$init();
                    }

                    protected /* synthetic */ void $$robo$init() {
                        if (this.__robo_data__ == null) {
                            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                        }
                    }

                    public /* synthetic */ Object $$robo$getData() {
                        return this.__robo_data__;
                    }
                });
            }
            if (this.mOnItemSelectedListener != null) {
                listView.setOnItemSelectedListener(this.mOnItemSelectedListener);
            }
            if (this.mIsSingleChoice) {
                listView.setChoiceMode(1);
            } else if (this.mIsMultiChoice) {
                listView.setChoiceMode(2);
            }
            listView.mRecycleOnMeasure = this.mRecycleOnMeasure;
            dialog.mListView = listView;
        }

        private void __constructor__(Context context) {
            this.$$robo$$com_android_internal_app_AlertController_AlertParams$__constructor__(context);
        }

        public AlertParams(Context context) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_app_AlertController_AlertParams$__constructor__(android.content.Context ), 0, this, context);
        }

        public void apply(AlertController alertController) {
            InvokeDynamicSupport.bootstrap("apply", $$robo$$com_android_internal_app_AlertController_AlertParams$apply(com.android.internal.app.AlertController ), 0, this, alertController);
        }

        private void createListView(AlertController alertController) {
            InvokeDynamicSupport.bootstrap("createListView", $$robo$$com_android_internal_app_AlertController_AlertParams$createListView(com.android.internal.app.AlertController ), 0, this, alertController);
        }

        public /* synthetic */ AlertParams() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (AlertParams)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }

        public static interface OnPrepareListViewListener
        extends InstrumentedInterface {
            public void onPrepareListView(ListView var1);
        }
    }

    public static class RecycleListView
    extends ListView
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        boolean mRecycleOnMeasure;

        private void $$robo$$com_android_internal_app_AlertController_RecycleListView$__constructor__(Context context) {
            this.mRecycleOnMeasure = true;
        }

        private void $$robo$$com_android_internal_app_AlertController_RecycleListView$__constructor__(Context context, AttributeSet attrs) {
            this.mRecycleOnMeasure = true;
        }

        private void $$robo$$com_android_internal_app_AlertController_RecycleListView$__constructor__(Context context, AttributeSet attrs, int defStyleAttr) {
            this.mRecycleOnMeasure = true;
        }

        private void $$robo$$com_android_internal_app_AlertController_RecycleListView$__constructor__(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
            this.mRecycleOnMeasure = true;
        }

        private final boolean $$robo$$com_android_internal_app_AlertController_RecycleListView$recycleOnMeasure() {
            return this.mRecycleOnMeasure;
        }

        private void __constructor__(Context context) {
            this.$$robo$$com_android_internal_app_AlertController_RecycleListView$__constructor__(context);
        }

        public RecycleListView(Context context) {
            super(context);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_app_AlertController_RecycleListView$__constructor__(android.content.Context ), 0, this, context);
        }

        private void __constructor__(Context context, AttributeSet attributeSet) {
            this.$$robo$$com_android_internal_app_AlertController_RecycleListView$__constructor__(context, attributeSet);
        }

        public RecycleListView(Context context, AttributeSet attributeSet) {
            super(context, attributeSet);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_app_AlertController_RecycleListView$__constructor__(android.content.Context android.util.AttributeSet ), 0, this, context, attributeSet);
        }

        private void __constructor__(Context context, AttributeSet attributeSet, int n) {
            this.$$robo$$com_android_internal_app_AlertController_RecycleListView$__constructor__(context, attributeSet, n);
        }

        public RecycleListView(Context context, AttributeSet attributeSet, int n) {
            super(context, attributeSet, n);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_app_AlertController_RecycleListView$__constructor__(android.content.Context android.util.AttributeSet int ), 0, this, context, attributeSet, n);
        }

        private void __constructor__(Context context, AttributeSet attributeSet, int n, int n2) {
            this.$$robo$$com_android_internal_app_AlertController_RecycleListView$__constructor__(context, attributeSet, n, n2);
        }

        public RecycleListView(Context context, AttributeSet attributeSet, int n, int n2) {
            super(context, attributeSet, n, n2);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_app_AlertController_RecycleListView$__constructor__(android.content.Context android.util.AttributeSet int int ), 0, this, context, attributeSet, n, n2);
        }

        @Override
        protected boolean recycleOnMeasure() {
            return (boolean)InvokeDynamicSupport.bootstrap("recycleOnMeasure", $$robo$$com_android_internal_app_AlertController_RecycleListView$recycleOnMeasure(), 0, this);
        }

        public /* synthetic */ RecycleListView() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (RecycleListView)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    private static final class ButtonHandler
    extends Handler
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private static int MSG_DISMISS_DIALOG = 1;
        private WeakReference<DialogInterface> mDialog;

        private void $$robo$$com_android_internal_app_AlertController_ButtonHandler$__constructor__(DialogInterface dialog) {
            this.mDialog = new WeakReference<DialogInterface>(dialog);
        }

        private final void $$robo$$com_android_internal_app_AlertController_ButtonHandler$handleMessage(Message msg) {
            switch (msg.what) {
                case -3: 
                case -2: 
                case -1: {
                    ((DialogInterface.OnClickListener)msg.obj).onClick((DialogInterface)this.mDialog.get(), msg.what);
                    break;
                }
                case 1: {
                    ((DialogInterface)msg.obj).dismiss();
                }
            }
        }

        private void __constructor__(DialogInterface dialogInterface) {
            this.$$robo$$com_android_internal_app_AlertController_ButtonHandler$__constructor__(dialogInterface);
        }

        public ButtonHandler(DialogInterface dialogInterface) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_app_AlertController_ButtonHandler$__constructor__(android.content.DialogInterface ), 0, this, dialogInterface);
        }

        @Override
        public void handleMessage(Message message) {
            InvokeDynamicSupport.bootstrap("handleMessage", $$robo$$com_android_internal_app_AlertController_ButtonHandler$handleMessage(android.os.Message ), 0, this, message);
        }

        public /* synthetic */ ButtonHandler() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ButtonHandler)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

