/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.app;

import android.app.Activity;
import android.app.ActivityManagerNative;
import android.app.ActivityThread;
import android.app.AppGlobals;
import android.content.Context;
import android.content.Intent;
import android.content.pm.IPackageManager;
import android.content.pm.ResolveInfo;
import android.content.pm.UserInfo;
import android.os.Bundle;
import android.os.RemoteException;
import android.os.UserHandle;
import android.os.UserManager;
import android.util.Slog;
import android.widget.Toast;
import java.util.List;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class IntentForwarderActivity
extends Activity
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    public static String TAG;
    public static String FORWARD_INTENT_TO_USER_OWNER;
    public static String FORWARD_INTENT_TO_MANAGED_PROFILE;

    private void $$robo$$com_android_internal_app_IntentForwarderActivity$__constructor__() {
    }

    private final void $$robo$$com_android_internal_app_IntentForwarderActivity$onCreate(Bundle savedInstanceState) {
        UserHandle userDest;
        int userMessageId;
        super.onCreate(savedInstanceState);
        Intent intentReceived = this.getIntent();
        String className = intentReceived.getComponent().getClassName();
        if (className.equals(FORWARD_INTENT_TO_USER_OWNER)) {
            userMessageId = 17040689;
            userDest = UserHandle.OWNER;
        } else if (className.equals(FORWARD_INTENT_TO_MANAGED_PROFILE)) {
            userMessageId = 17040690;
            userDest = this.getManagedProfile();
        } else {
            Slog.wtf(TAG, IntentForwarderActivity.class.getName() + " cannot be called directly");
            userMessageId = -1;
            userDest = null;
        }
        if (userDest == null) {
            this.finish();
            return;
        }
        Intent newIntent = new Intent(intentReceived);
        newIntent.setComponent(null);
        newIntent.setPackage(null);
        newIntent.addFlags(0x3000000);
        int callingUserId = this.getUserId();
        IPackageManager ipm = AppGlobals.getPackageManager();
        String resolvedType = newIntent.resolveTypeIfNeeded(this.getContentResolver());
        boolean canForward = false;
        Intent selector = newIntent.getSelector();
        if (selector == null) {
            selector = newIntent;
        }
        try {
            canForward = ipm.canForwardTo(selector, resolvedType, callingUserId, userDest.getIdentifier());
        }
        catch (RemoteException e) {
            Slog.e(TAG, "PackageManagerService is dead?");
        }
        if (canForward) {
            newIntent.setContentUserHint(callingUserId);
            ResolveInfo ri = this.getPackageManager().resolveActivityAsUser(newIntent, 65536, userDest.getIdentifier());
            boolean shouldShowDisclosure = !UserHandle.isSameApp(ri.activityInfo.applicationInfo.uid, 1000);
            try {
                this.startActivityAsCaller(newIntent, null, userDest.getIdentifier());
            }
            catch (RuntimeException e) {
                int launchedFromUid = -1;
                String launchedFromPackage = "?";
                try {
                    launchedFromUid = ActivityManagerNative.getDefault().getLaunchedFromUid(this.getActivityToken());
                    launchedFromPackage = ActivityManagerNative.getDefault().getLaunchedFromPackage(this.getActivityToken());
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
                Slog.wtf(TAG, "Unable to launch as UID " + launchedFromUid + " package " + launchedFromPackage + ", while running in " + ActivityThread.currentProcessName(), e);
            }
            if (shouldShowDisclosure) {
                Toast.makeText((Context)this, this.getString(userMessageId), 1).show();
            }
        } else {
            Slog.wtf(TAG, "the intent: " + newIntent + "cannot be forwarded from user " + callingUserId + " to user " + userDest.getIdentifier());
        }
        this.finish();
    }

    private final UserHandle $$robo$$com_android_internal_app_IntentForwarderActivity$getManagedProfile() {
        UserManager userManager = (UserManager)this.getSystemService("user");
        List<UserInfo> relatedUsers = userManager.getProfiles(0);
        for (UserInfo userInfo : relatedUsers) {
            if (!userInfo.isManagedProfile()) continue;
            return new UserHandle(userInfo.id);
        }
        Slog.wtf(TAG, FORWARD_INTENT_TO_MANAGED_PROFILE + " has been called, but there is no managed profile");
        return null;
    }

    static void __staticInitializer__() {
        TAG = "IntentForwarderActivity";
        FORWARD_INTENT_TO_USER_OWNER = "com.android.internal.app.ForwardIntentToUserOwner";
        FORWARD_INTENT_TO_MANAGED_PROFILE = "com.android.internal.app.ForwardIntentToManagedProfile";
    }

    private void __constructor__() {
        this.$$robo$$com_android_internal_app_IntentForwarderActivity$__constructor__();
    }

    public IntentForwarderActivity() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_app_IntentForwarderActivity$__constructor__(), 0, this);
    }

    @Override
    protected void onCreate(Bundle bundle) {
        InvokeDynamicSupport.bootstrap("onCreate", $$robo$$com_android_internal_app_IntentForwarderActivity$onCreate(android.os.Bundle ), 0, this, bundle);
    }

    private UserHandle getManagedProfile() {
        return InvokeDynamicSupport.bootstrap("getManagedProfile", $$robo$$com_android_internal_app_IntentForwarderActivity$getManagedProfile(), 0, this);
    }

    static {
        RobolectricInternals.classInitializing(IntentForwarderActivity.class);
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (IntentForwarderActivity)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

