/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.app;

import android.os.Parcel;
import android.os.Parcelable;
import android.os.SystemClock;
import android.os.SystemProperties;
import android.os.UserHandle;
import android.text.format.DateFormat;
import android.util.ArrayMap;
import android.util.ArraySet;
import android.util.Log;
import android.util.Slog;
import android.util.SparseArray;
import android.util.TimeUtils;
import com.android.internal.app.ProcessMap;
import com.android.internal.util.GrowingArrayUtils;
import com.google.errorprone.annotations.DoNotMock;
import dalvik.system.VMRuntime;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Objects;
import libcore.util.EmptyArray;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class ProcessStats
implements Parcelable,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    static String TAG = "ProcessStats";
    static boolean DEBUG = false;
    static boolean DEBUG_PARCEL = false;
    public static String SERVICE_NAME = "procstats";
    public static long COMMIT_PERIOD;
    public static long COMMIT_UPTIME_PERIOD;
    public static int STATE_NOTHING = -1;
    public static int STATE_PERSISTENT = 0;
    public static int STATE_TOP = 1;
    public static int STATE_IMPORTANT_FOREGROUND = 2;
    public static int STATE_IMPORTANT_BACKGROUND = 3;
    public static int STATE_BACKUP = 4;
    public static int STATE_HEAVY_WEIGHT = 5;
    public static int STATE_SERVICE = 6;
    public static int STATE_SERVICE_RESTARTING = 7;
    public static int STATE_RECEIVER = 8;
    public static int STATE_HOME = 9;
    public static int STATE_LAST_ACTIVITY = 10;
    public static int STATE_CACHED_ACTIVITY = 11;
    public static int STATE_CACHED_ACTIVITY_CLIENT = 12;
    public static int STATE_CACHED_EMPTY = 13;
    public static int STATE_COUNT = 14;
    public static int PSS_SAMPLE_COUNT = 0;
    public static int PSS_MINIMUM = 1;
    public static int PSS_AVERAGE = 2;
    public static int PSS_MAXIMUM = 3;
    public static int PSS_USS_MINIMUM = 4;
    public static int PSS_USS_AVERAGE = 5;
    public static int PSS_USS_MAXIMUM = 6;
    public static int PSS_COUNT = 7;
    public static int SYS_MEM_USAGE_SAMPLE_COUNT = 0;
    public static int SYS_MEM_USAGE_CACHED_MINIMUM = 1;
    public static int SYS_MEM_USAGE_CACHED_AVERAGE = 2;
    public static int SYS_MEM_USAGE_CACHED_MAXIMUM = 3;
    public static int SYS_MEM_USAGE_FREE_MINIMUM = 4;
    public static int SYS_MEM_USAGE_FREE_AVERAGE = 5;
    public static int SYS_MEM_USAGE_FREE_MAXIMUM = 6;
    public static int SYS_MEM_USAGE_ZRAM_MINIMUM = 7;
    public static int SYS_MEM_USAGE_ZRAM_AVERAGE = 8;
    public static int SYS_MEM_USAGE_ZRAM_MAXIMUM = 9;
    public static int SYS_MEM_USAGE_KERNEL_MINIMUM = 10;
    public static int SYS_MEM_USAGE_KERNEL_AVERAGE = 11;
    public static int SYS_MEM_USAGE_KERNEL_MAXIMUM = 12;
    public static int SYS_MEM_USAGE_NATIVE_MINIMUM = 13;
    public static int SYS_MEM_USAGE_NATIVE_AVERAGE = 14;
    public static int SYS_MEM_USAGE_NATIVE_MAXIMUM = 15;
    public static int SYS_MEM_USAGE_COUNT = 16;
    public static int ADJ_NOTHING = -1;
    public static int ADJ_MEM_FACTOR_NORMAL = 0;
    public static int ADJ_MEM_FACTOR_MODERATE = 1;
    public static int ADJ_MEM_FACTOR_LOW = 2;
    public static int ADJ_MEM_FACTOR_CRITICAL = 3;
    public static int ADJ_MEM_FACTOR_COUNT = 4;
    public static int ADJ_SCREEN_MOD = 4;
    public static int ADJ_SCREEN_OFF = 0;
    public static int ADJ_SCREEN_ON = 4;
    public static int ADJ_COUNT = 8;
    public static int FLAG_COMPLETE = 1;
    public static int FLAG_SHUTDOWN = 2;
    public static int FLAG_SYSPROPS = 4;
    public static int[] ALL_MEM_ADJ;
    public static int[] ALL_SCREEN_ADJ;
    public static int[] NON_CACHED_PROC_STATES;
    public static int[] BACKGROUND_PROC_STATES;
    static int[] PROCESS_STATE_TO_STATE;
    public static int[] ALL_PROC_STATES;
    static String[] STATE_NAMES;
    public static String[] ADJ_SCREEN_NAMES_CSV;
    public static String[] ADJ_MEM_NAMES_CSV;
    public static String[] STATE_NAMES_CSV;
    static String[] ADJ_SCREEN_TAGS;
    static String[] ADJ_MEM_TAGS;
    static String[] STATE_TAGS;
    static String CSV_SEP = "\t";
    private static int PARCEL_VERSION = 18;
    private static int MAGIC = 1347638355;
    static int OFFSET_TYPE_SHIFT;
    static int OFFSET_TYPE_MASK;
    static int OFFSET_ARRAY_SHIFT;
    static int OFFSET_ARRAY_MASK;
    static int OFFSET_INDEX_SHIFT;
    static int OFFSET_INDEX_MASK;
    public String mReadError;
    public String mTimePeriodStartClockStr;
    public int mFlags;
    public ProcessMap<SparseArray<PackageState>> mPackages;
    public ProcessMap<ProcessState> mProcesses;
    public long[] mMemFactorDurations;
    public int mMemFactor;
    public long mStartTime;
    public int[] mSysMemUsageTable;
    public int mSysMemUsageTableSize;
    public long[] mSysMemUsageArgs;
    public long mTimePeriodStartClock;
    public long mTimePeriodStartRealtime;
    public long mTimePeriodEndRealtime;
    public long mTimePeriodStartUptime;
    public long mTimePeriodEndUptime;
    String mRuntime;
    boolean mRunning;
    static int LONGS_SIZE = 4096;
    ArrayList<long[]> mLongs;
    int mNextLong;
    int[] mAddLongTable;
    int mAddLongTableSize;
    ArrayMap<String, Integer> mCommonStringToIndex;
    ArrayList<String> mIndexToCommonString;
    public static Parcelable.Creator<ProcessStats> CREATOR;
    static int[] BAD_TABLE;

    private void $$robo$$com_android_internal_app_ProcessStats$__constructor__(boolean running) {
        this.mPackages = new ProcessMap();
        this.mProcesses = new ProcessMap();
        this.mMemFactorDurations = new long[8];
        this.mMemFactor = -1;
        this.mSysMemUsageTable = null;
        this.mSysMemUsageTableSize = 0;
        this.mSysMemUsageArgs = new long[16];
        this.mLongs = new ArrayList();
        this.mRunning = running;
        this.reset();
    }

    private void $$robo$$com_android_internal_app_ProcessStats$__constructor__(Parcel in) {
        this.mPackages = new ProcessMap();
        this.mProcesses = new ProcessMap();
        this.mMemFactorDurations = new long[8];
        this.mMemFactor = -1;
        this.mSysMemUsageTable = null;
        this.mSysMemUsageTableSize = 0;
        this.mSysMemUsageArgs = new long[16];
        this.mLongs = new ArrayList();
        this.reset();
        this.readFromParcel(in);
    }

    private final void $$robo$$com_android_internal_app_ProcessStats$add(ProcessStats other) {
        int i;
        int uid;
        int iu;
        SparseArray<Object> uids;
        ArrayMap<String, SparseArray<SparseArray<PackageState>>> pkgMap = other.mPackages.getMap();
        for (int ip = 0; ip < pkgMap.size(); ++ip) {
            String pkgName = pkgMap.keyAt(ip);
            uids = pkgMap.valueAt(ip);
            for (iu = 0; iu < uids.size(); ++iu) {
                uid = uids.keyAt(iu);
                SparseArray versions = (SparseArray)uids.valueAt(iu);
                for (int iv = 0; iv < versions.size(); ++iv) {
                    int vers = versions.keyAt(iv);
                    PackageState otherState = (PackageState)versions.valueAt(iv);
                    int NPROCS = otherState.mProcesses.size();
                    int NSRVS = otherState.mServices.size();
                    for (int iproc = 0; iproc < NPROCS; ++iproc) {
                        ProcessState otherProc = otherState.mProcesses.valueAt(iproc);
                        if (otherProc.mCommonProcess == otherProc) continue;
                        ProcessState thisProc = this.getProcessStateLocked(pkgName, uid, vers, otherProc.mName);
                        if (thisProc.mCommonProcess == thisProc) {
                            thisProc.mMultiPackage = true;
                            long now = SystemClock.uptimeMillis();
                            PackageState pkgState = this.getPackageStateLocked(pkgName, uid, vers);
                            thisProc = thisProc.clone(thisProc.mPackage, now);
                            pkgState.mProcesses.put(thisProc.mName, thisProc);
                        }
                        thisProc.add(otherProc);
                    }
                    for (int isvc = 0; isvc < NSRVS; ++isvc) {
                        ServiceState otherSvc = otherState.mServices.valueAt(isvc);
                        ServiceState thisSvc = this.getServiceStateLocked(pkgName, uid, vers, otherSvc.mProcessName, otherSvc.mName);
                        thisSvc.add(otherSvc);
                    }
                }
            }
        }
        ArrayMap<String, SparseArray<ProcessState>> procMap = other.mProcesses.getMap();
        for (int ip = 0; ip < procMap.size(); ++ip) {
            uids = procMap.valueAt(ip);
            for (iu = 0; iu < uids.size(); ++iu) {
                uid = uids.keyAt(iu);
                ProcessState otherProc = (ProcessState)uids.valueAt(iu);
                ProcessState thisProc = this.mProcesses.get(otherProc.mName, uid);
                if (thisProc == null) {
                    thisProc = new ProcessState(this, otherProc.mPackage, uid, otherProc.mVersion, otherProc.mName);
                    this.mProcesses.put(otherProc.mName, uid, thisProc);
                    PackageState thisState = this.getPackageStateLocked(otherProc.mPackage, uid, otherProc.mVersion);
                    if (!thisState.mProcesses.containsKey(otherProc.mName)) {
                        thisState.mProcesses.put(otherProc.mName, thisProc);
                    }
                }
                thisProc.add(otherProc);
            }
        }
        for (i = 0; i < 8; ++i) {
            int n = i;
            this.mMemFactorDurations[n] = this.mMemFactorDurations[n] + other.mMemFactorDurations[i];
        }
        for (i = 0; i < other.mSysMemUsageTableSize; ++i) {
            int ent = other.mSysMemUsageTable[i];
            int state = ent >> OFFSET_TYPE_SHIFT & OFFSET_TYPE_MASK;
            long[] longs = other.mLongs.get(ent >> OFFSET_ARRAY_SHIFT & OFFSET_ARRAY_MASK);
            this.addSysMemUsage(state, longs, ent >> OFFSET_INDEX_SHIFT & OFFSET_INDEX_MASK);
        }
        if (other.mTimePeriodStartClock < this.mTimePeriodStartClock) {
            this.mTimePeriodStartClock = other.mTimePeriodStartClock;
            this.mTimePeriodStartClockStr = other.mTimePeriodStartClockStr;
        }
        this.mTimePeriodEndRealtime += other.mTimePeriodEndRealtime - other.mTimePeriodStartRealtime;
        this.mTimePeriodEndUptime += other.mTimePeriodEndUptime - other.mTimePeriodStartUptime;
    }

    private final void $$robo$$com_android_internal_app_ProcessStats$addSysMemUsage(long cachedMem, long freeMem, long zramMem, long kernelMem, long nativeMem) {
        if (this.mMemFactor != -1) {
            int state = this.mMemFactor * 14;
            this.mSysMemUsageArgs[0] = 1L;
            for (int i = 0; i < 3; ++i) {
                this.mSysMemUsageArgs[1 + i] = cachedMem;
                this.mSysMemUsageArgs[4 + i] = freeMem;
                this.mSysMemUsageArgs[7 + i] = zramMem;
                this.mSysMemUsageArgs[10 + i] = kernelMem;
                this.mSysMemUsageArgs[13 + i] = nativeMem;
            }
            this.addSysMemUsage(state, this.mSysMemUsageArgs, 0);
        }
    }

    private final void $$robo$$com_android_internal_app_ProcessStats$addSysMemUsage(int state, long[] data, int dataOff) {
        int off;
        int idx = ProcessStats.binarySearch(this.mSysMemUsageTable, this.mSysMemUsageTableSize, state);
        if (idx >= 0) {
            off = this.mSysMemUsageTable[idx];
        } else {
            this.mAddLongTable = this.mSysMemUsageTable;
            this.mAddLongTableSize = this.mSysMemUsageTableSize;
            off = this.addLongData(~idx, state, 16);
            this.mSysMemUsageTable = this.mAddLongTable;
            this.mSysMemUsageTableSize = this.mAddLongTableSize;
        }
        long[] longs = this.mLongs.get(off >> OFFSET_ARRAY_SHIFT & OFFSET_ARRAY_MASK);
        idx = off >> OFFSET_INDEX_SHIFT & OFFSET_INDEX_MASK;
        ProcessStats.addSysMemUsage(longs, idx, data, dataOff);
    }

    private static final void $$robo$$com_android_internal_app_ProcessStats$addSysMemUsage(long[] dstData, int dstOff, long[] addData, int addOff) {
        block4: {
            long addCount;
            long dstCount;
            block3: {
                dstCount = dstData[dstOff + 0];
                addCount = addData[addOff + 0];
                if (dstCount != 0L) break block3;
                dstData[dstOff + 0] = addCount;
                for (int i = 1; i < 16; ++i) {
                    dstData[dstOff + i] = addData[addOff + i];
                }
                break block4;
            }
            if (addCount <= 0L) break block4;
            dstData[dstOff + 0] = dstCount + addCount;
            for (int i = 1; i < 16; i += 3) {
                if (dstData[dstOff + i] > addData[addOff + i]) {
                    dstData[dstOff + i] = addData[addOff + i];
                }
                dstData[dstOff + i + 1] = (long)(((double)dstData[dstOff + i + 1] * (double)dstCount + (double)addData[addOff + i + 1] * (double)addCount) / (double)(dstCount + addCount));
                if (dstData[dstOff + i + 2] >= addData[addOff + i + 2]) continue;
                dstData[dstOff + i + 2] = addData[addOff + i + 2];
            }
        }
    }

    private static final void $$robo$$com_android_internal_app_ProcessStats$printScreenLabel(PrintWriter pw, int offset) {
        switch (offset) {
            case -1: {
                pw.print("     ");
                break;
            }
            case 0: {
                pw.print("SOff/");
                break;
            }
            case 4: {
                pw.print("SOn /");
                break;
            }
            default: {
                pw.print("????/");
            }
        }
    }

    private static final void $$robo$$com_android_internal_app_ProcessStats$printScreenLabelCsv(PrintWriter pw, int offset) {
        switch (offset) {
            case -1: {
                break;
            }
            case 0: {
                pw.print(ADJ_SCREEN_NAMES_CSV[0]);
                break;
            }
            case 4: {
                pw.print(ADJ_SCREEN_NAMES_CSV[1]);
                break;
            }
            default: {
                pw.print("???");
            }
        }
    }

    private static final void $$robo$$com_android_internal_app_ProcessStats$printMemLabel(PrintWriter pw, int offset, char sep) {
        switch (offset) {
            case -1: {
                pw.print("    ");
                if (sep == '\u0000') break;
                pw.print(' ');
                break;
            }
            case 0: {
                pw.print("Norm");
                if (sep == '\u0000') break;
                pw.print(sep);
                break;
            }
            case 1: {
                pw.print("Mod ");
                if (sep == '\u0000') break;
                pw.print(sep);
                break;
            }
            case 2: {
                pw.print("Low ");
                if (sep == '\u0000') break;
                pw.print(sep);
                break;
            }
            case 3: {
                pw.print("Crit");
                if (sep == '\u0000') break;
                pw.print(sep);
                break;
            }
            default: {
                pw.print("????");
                if (sep == '\u0000') break;
                pw.print(sep);
            }
        }
    }

    private static final void $$robo$$com_android_internal_app_ProcessStats$printMemLabelCsv(PrintWriter pw, int offset) {
        if (offset >= 0) {
            if (offset <= 3) {
                pw.print(ADJ_MEM_NAMES_CSV[offset]);
            } else {
                pw.print("???");
            }
        }
    }

    private static final long $$robo$$com_android_internal_app_ProcessStats$dumpSingleTime(PrintWriter pw, String prefix, long[] durations, int curState, long curStartTime, long now) {
        long totalTime = 0L;
        int printedScreen = -1;
        for (int iscreen = 0; iscreen < 8; iscreen += 4) {
            int printedMem = -1;
            for (int imem = 0; imem < 4; ++imem) {
                int state = imem + iscreen;
                long time = durations[state];
                String running = "";
                if (curState == state) {
                    time += now - curStartTime;
                    if (pw != null) {
                        running = " (running)";
                    }
                }
                if (time == 0L) continue;
                if (pw != null) {
                    pw.print(prefix);
                    ProcessStats.printScreenLabel(pw, printedScreen != iscreen ? iscreen : -1);
                    printedScreen = iscreen;
                    ProcessStats.printMemLabel(pw, printedMem != imem ? imem : -1, '\u0000');
                    printedMem = imem;
                    pw.print(": ");
                    TimeUtils.formatDuration(time, pw);
                    pw.println(running);
                }
                totalTime += time;
            }
        }
        if (totalTime != 0L && pw != null) {
            pw.print(prefix);
            pw.print("    TOTAL: ");
            TimeUtils.formatDuration(totalTime, pw);
            pw.println();
        }
        return totalTime;
    }

    private static final void $$robo$$com_android_internal_app_ProcessStats$dumpAdjTimesCheckin(PrintWriter pw, String sep, long[] durations, int curState, long curStartTime, long now) {
        for (int iscreen = 0; iscreen < 8; iscreen += 4) {
            for (int imem = 0; imem < 4; ++imem) {
                int state = imem + iscreen;
                long time = durations[state];
                if (curState == state) {
                    time += now - curStartTime;
                }
                if (time == 0L) continue;
                ProcessStats.printAdjTagAndValue(pw, state, time);
            }
        }
    }

    private static final void $$robo$$com_android_internal_app_ProcessStats$dumpServiceTimeCheckin(PrintWriter pw, String label, String packageName, int uid, int vers, String serviceName, ServiceState svc, int serviceType, int opCount, int curState, long curStartTime, long now) {
        if (opCount <= 0) {
            return;
        }
        pw.print(label);
        pw.print(",");
        pw.print(packageName);
        pw.print(",");
        pw.print(uid);
        pw.print(",");
        pw.print(vers);
        pw.print(",");
        pw.print(serviceName);
        pw.print(",");
        pw.print(opCount);
        boolean didCurState = false;
        for (int i = 0; i < svc.mDurationsTableSize; ++i) {
            int off = svc.mDurationsTable[i];
            int type = off >> OFFSET_TYPE_SHIFT & OFFSET_TYPE_MASK;
            int memFactor = type / 4;
            if ((type %= 4) != serviceType) continue;
            long time = svc.mStats.getLong(off, 0);
            if (curState == memFactor) {
                didCurState = true;
                time += now - curStartTime;
            }
            ProcessStats.printAdjTagAndValue(pw, memFactor, time);
        }
        if (!didCurState && curState != -1) {
            ProcessStats.printAdjTagAndValue(pw, curState, now - curStartTime);
        }
        pw.println();
    }

    private static final void $$robo$$com_android_internal_app_ProcessStats$computeProcessData(ProcessState proc, ProcessDataCollection data, long now) {
        data.totalTime = 0L;
        data.maxUss = 0L;
        data.avgUss = 0L;
        data.minUss = 0L;
        data.maxPss = 0L;
        data.avgPss = 0L;
        data.minPss = 0L;
        data.numPss = 0L;
        for (int is = 0; is < data.screenStates.length; ++is) {
            for (int im = 0; im < data.memStates.length; ++im) {
                for (int ip = 0; ip < data.procStates.length; ++ip) {
                    int bucket = (data.screenStates[is] + data.memStates[im]) * 14 + data.procStates[ip];
                    data.totalTime += proc.getDuration(bucket, now);
                    long samples = proc.getPssSampleCount(bucket);
                    if (samples <= 0L) continue;
                    long minPss = proc.getPssMinimum(bucket);
                    long avgPss = proc.getPssAverage(bucket);
                    long maxPss = proc.getPssMaximum(bucket);
                    long minUss = proc.getPssUssMinimum(bucket);
                    long avgUss = proc.getPssUssAverage(bucket);
                    long maxUss = proc.getPssUssMaximum(bucket);
                    if (data.numPss == 0L) {
                        data.minPss = minPss;
                        data.avgPss = avgPss;
                        data.maxPss = maxPss;
                        data.minUss = minUss;
                        data.avgUss = avgUss;
                        data.maxUss = maxUss;
                    } else {
                        if (minPss < data.minPss) {
                            data.minPss = minPss;
                        }
                        data.avgPss = (long)(((double)data.avgPss * (double)data.numPss + (double)avgPss * (double)samples) / (double)(data.numPss + samples));
                        if (maxPss > data.maxPss) {
                            data.maxPss = maxPss;
                        }
                        if (minUss < data.minUss) {
                            data.minUss = minUss;
                        }
                        data.avgUss = (long)(((double)data.avgUss * (double)data.numPss + (double)avgUss * (double)samples) / (double)(data.numPss + samples));
                        if (maxUss > data.maxUss) {
                            data.maxUss = maxUss;
                        }
                    }
                    data.numPss += samples;
                }
            }
        }
    }

    private static final long $$robo$$com_android_internal_app_ProcessStats$computeProcessTimeLocked(ProcessState proc, int[] screenStates, int[] memStates, int[] procStates, long now) {
        long totalTime = 0L;
        for (int is = 0; is < screenStates.length; ++is) {
            for (int im = 0; im < memStates.length; ++im) {
                for (int ip = 0; ip < procStates.length; ++ip) {
                    int bucket = (screenStates[is] + memStates[im]) * 14 + procStates[ip];
                    totalTime += proc.getDuration(bucket, now);
                }
            }
        }
        proc.mTmpTotalTime = totalTime;
        return totalTime;
    }

    private final void $$robo$$com_android_internal_app_ProcessStats$computeTotalMemoryUse(TotalMemoryUseCollection data, long now) {
        int i;
        data.totalTime = 0L;
        for (i = 0; i < 14; ++i) {
            data.processStateWeight[i] = 0.0;
            data.processStatePss[i] = 0L;
            data.processStateTime[i] = 0L;
            data.processStateSamples[i] = 0;
        }
        for (i = 0; i < 16; ++i) {
            data.sysMemUsage[i] = 0L;
        }
        data.sysMemCachedWeight = 0.0;
        data.sysMemFreeWeight = 0.0;
        data.sysMemZRamWeight = 0.0;
        data.sysMemKernelWeight = 0.0;
        data.sysMemNativeWeight = 0.0;
        data.sysMemSamples = 0;
        long[] totalMemUsage = new long[16];
        for (int i2 = 0; i2 < this.mSysMemUsageTableSize; ++i2) {
            int ent = this.mSysMemUsageTable[i2];
            long[] longs = this.mLongs.get(ent >> OFFSET_ARRAY_SHIFT & OFFSET_ARRAY_MASK);
            int idx = ent >> OFFSET_INDEX_SHIFT & OFFSET_INDEX_MASK;
            ProcessStats.addSysMemUsage(totalMemUsage, 0, longs, idx);
        }
        for (int is = 0; is < data.screenStates.length; ++is) {
            for (int im = 0; im < data.memStates.length; ++im) {
                int tmpIdx;
                int ent;
                long[] tmpLongs;
                int memBucket = data.screenStates[is] + data.memStates[im];
                int stateBucket = memBucket * 14;
                long memTime = this.mMemFactorDurations[memBucket];
                if (this.mMemFactor == memBucket) {
                    memTime += now - this.mStartTime;
                }
                data.totalTime += memTime;
                int sysIdx = ProcessStats.binarySearch(this.mSysMemUsageTable, this.mSysMemUsageTableSize, stateBucket);
                long[] longs = totalMemUsage;
                int idx = 0;
                if (sysIdx >= 0 && (tmpLongs = this.mLongs.get((ent = this.mSysMemUsageTable[sysIdx]) >> OFFSET_ARRAY_SHIFT & OFFSET_ARRAY_MASK))[(tmpIdx = ent >> OFFSET_INDEX_SHIFT & OFFSET_INDEX_MASK) + 0] >= 3L) {
                    ProcessStats.addSysMemUsage(data.sysMemUsage, 0, longs, idx);
                    longs = tmpLongs;
                    idx = tmpIdx;
                }
                data.sysMemCachedWeight += (double)longs[idx + 2] * (double)memTime;
                data.sysMemFreeWeight += (double)longs[idx + 5] * (double)memTime;
                data.sysMemZRamWeight += (double)longs[idx + 8] * (double)memTime;
                data.sysMemKernelWeight += (double)longs[idx + 11] * (double)memTime;
                data.sysMemNativeWeight += (double)longs[idx + 14] * (double)memTime;
                data.sysMemSamples = (int)((long)data.sysMemSamples + longs[idx + 0]);
            }
        }
        ArrayMap<String, SparseArray<ProcessState>> procMap = this.mProcesses.getMap();
        for (int iproc = 0; iproc < procMap.size(); ++iproc) {
            SparseArray<ProcessState> uids = procMap.valueAt(iproc);
            for (int iu = 0; iu < uids.size(); ++iu) {
                ProcessState proc = uids.valueAt(iu);
                PssAggr fgPss = new PssAggr();
                PssAggr bgPss = new PssAggr();
                PssAggr cachedPss = new PssAggr();
                boolean havePss = false;
                for (int i3 = 0; i3 < proc.mDurationsTableSize; ++i3) {
                    int off = proc.mDurationsTable[i3];
                    int type = off >> OFFSET_TYPE_SHIFT & OFFSET_TYPE_MASK;
                    int procState = type % 14;
                    long samples = proc.getPssSampleCount(type);
                    if (samples <= 0L) continue;
                    long avg = proc.getPssAverage(type);
                    havePss = true;
                    if (procState <= 2) {
                        fgPss.add(avg, samples);
                        continue;
                    }
                    if (procState <= 8) {
                        bgPss.add(avg, samples);
                        continue;
                    }
                    cachedPss.add(avg, samples);
                }
                if (!havePss) continue;
                boolean fgHasBg = false;
                boolean fgHasCached = false;
                boolean bgHasCached = false;
                if (fgPss.samples < 3L && bgPss.samples > 0L) {
                    fgHasBg = true;
                    fgPss.add(bgPss.pss, bgPss.samples);
                }
                if (fgPss.samples < 3L && cachedPss.samples > 0L) {
                    fgHasCached = true;
                    fgPss.add(cachedPss.pss, cachedPss.samples);
                }
                if (bgPss.samples < 3L && cachedPss.samples > 0L) {
                    bgHasCached = true;
                    bgPss.add(cachedPss.pss, cachedPss.samples);
                }
                if (bgPss.samples < 3L && !fgHasBg && fgPss.samples > 0L) {
                    bgPss.add(fgPss.pss, fgPss.samples);
                }
                if (cachedPss.samples < 3L && !bgHasCached && bgPss.samples > 0L) {
                    cachedPss.add(bgPss.pss, bgPss.samples);
                }
                if (cachedPss.samples < 3L && !fgHasCached && fgPss.samples > 0L) {
                    cachedPss.add(fgPss.pss, fgPss.samples);
                }
                for (int i4 = 0; i4 < proc.mDurationsTableSize; ++i4) {
                    long avg;
                    int procState;
                    int off = proc.mDurationsTable[i4];
                    int type = off >> OFFSET_TYPE_SHIFT & OFFSET_TYPE_MASK;
                    long time = this.getLong(off, 0);
                    if (proc.mCurState == type) {
                        time += now - proc.mStartTime;
                    }
                    int n = procState = type % 14;
                    data.processStateTime[n] = data.processStateTime[n] + time;
                    long samples = proc.getPssSampleCount(type);
                    if (samples > 0L) {
                        avg = proc.getPssAverage(type);
                    } else if (procState <= 2) {
                        samples = fgPss.samples;
                        avg = fgPss.pss;
                    } else if (procState <= 8) {
                        samples = bgPss.samples;
                        avg = bgPss.pss;
                    } else {
                        samples = cachedPss.samples;
                        avg = cachedPss.pss;
                    }
                    double newAvg = ((double)data.processStatePss[procState] * (double)data.processStateSamples[procState] + (double)avg * (double)samples) / (double)((long)data.processStateSamples[procState] + samples);
                    data.processStatePss[procState] = (long)newAvg;
                    int n2 = procState;
                    data.processStateSamples[n2] = (int)((long)data.processStateSamples[n2] + samples);
                    int n3 = procState;
                    data.processStateWeight[n3] = data.processStateWeight[n3] + (double)avg * (double)time;
                }
            }
        }
    }

    private static final void $$robo$$com_android_internal_app_ProcessStats$dumpProcessState(PrintWriter pw, String prefix, ProcessState proc, int[] screenStates, int[] memStates, int[] procStates, long now) {
        long totalTime = 0L;
        int printedScreen = -1;
        for (int is = 0; is < screenStates.length; ++is) {
            int printedMem = -1;
            for (int im = 0; im < memStates.length; ++im) {
                for (int ip = 0; ip < procStates.length; ++ip) {
                    int iscreen = screenStates[is];
                    int imem = memStates[im];
                    int bucket = (iscreen + imem) * 14 + procStates[ip];
                    long time = proc.getDuration(bucket, now);
                    String running = "";
                    if (proc.mCurState == bucket) {
                        running = " (running)";
                    }
                    if (time == 0L) continue;
                    pw.print(prefix);
                    if (screenStates.length > 1) {
                        ProcessStats.printScreenLabel(pw, printedScreen != iscreen ? iscreen : -1);
                        printedScreen = iscreen;
                    }
                    if (memStates.length > 1) {
                        ProcessStats.printMemLabel(pw, printedMem != imem ? imem : -1, '/');
                        printedMem = imem;
                    }
                    pw.print(STATE_NAMES[procStates[ip]]);
                    pw.print(": ");
                    TimeUtils.formatDuration(time, pw);
                    pw.println(running);
                    totalTime += time;
                }
            }
        }
        if (totalTime != 0L) {
            pw.print(prefix);
            if (screenStates.length > 1) {
                ProcessStats.printScreenLabel(pw, -1);
            }
            if (memStates.length > 1) {
                ProcessStats.printMemLabel(pw, -1, '/');
            }
            pw.print("TOTAL  : ");
            TimeUtils.formatDuration(totalTime, pw);
            pw.println();
        }
    }

    private static final void $$robo$$com_android_internal_app_ProcessStats$dumpProcessPss(PrintWriter pw, String prefix, ProcessState proc, int[] screenStates, int[] memStates, int[] procStates) {
        boolean printedHeader = false;
        int printedScreen = -1;
        for (int is = 0; is < screenStates.length; ++is) {
            int printedMem = -1;
            for (int im = 0; im < memStates.length; ++im) {
                for (int ip = 0; ip < procStates.length; ++ip) {
                    int iscreen = screenStates[is];
                    int imem = memStates[im];
                    int bucket = (iscreen + imem) * 14 + procStates[ip];
                    long count = proc.getPssSampleCount(bucket);
                    if (count <= 0L) continue;
                    if (!printedHeader) {
                        pw.print(prefix);
                        pw.print("PSS/USS (");
                        pw.print(proc.mPssTableSize);
                        pw.println(" entries):");
                        printedHeader = true;
                    }
                    pw.print(prefix);
                    pw.print("  ");
                    if (screenStates.length > 1) {
                        ProcessStats.printScreenLabel(pw, printedScreen != iscreen ? iscreen : -1);
                        printedScreen = iscreen;
                    }
                    if (memStates.length > 1) {
                        ProcessStats.printMemLabel(pw, printedMem != imem ? imem : -1, '/');
                        printedMem = imem;
                    }
                    pw.print(STATE_NAMES[procStates[ip]]);
                    pw.print(": ");
                    pw.print(count);
                    pw.print(" samples ");
                    ProcessStats.printSizeValue(pw, proc.getPssMinimum(bucket) * 1024L);
                    pw.print(" ");
                    ProcessStats.printSizeValue(pw, proc.getPssAverage(bucket) * 1024L);
                    pw.print(" ");
                    ProcessStats.printSizeValue(pw, proc.getPssMaximum(bucket) * 1024L);
                    pw.print(" / ");
                    ProcessStats.printSizeValue(pw, proc.getPssUssMinimum(bucket) * 1024L);
                    pw.print(" ");
                    ProcessStats.printSizeValue(pw, proc.getPssUssAverage(bucket) * 1024L);
                    pw.print(" ");
                    ProcessStats.printSizeValue(pw, proc.getPssUssMaximum(bucket) * 1024L);
                    pw.println();
                }
            }
        }
        if (proc.mNumExcessiveWake != 0) {
            pw.print(prefix);
            pw.print("Killed for excessive wake locks: ");
            pw.print(proc.mNumExcessiveWake);
            pw.println(" times");
        }
        if (proc.mNumExcessiveCpu != 0) {
            pw.print(prefix);
            pw.print("Killed for excessive CPU use: ");
            pw.print(proc.mNumExcessiveCpu);
            pw.println(" times");
        }
        if (proc.mNumCachedKill != 0) {
            pw.print(prefix);
            pw.print("Killed from cached state: ");
            pw.print(proc.mNumCachedKill);
            pw.print(" times from pss ");
            ProcessStats.printSizeValue(pw, proc.mMinCachedKillPss * 1024L);
            pw.print("-");
            ProcessStats.printSizeValue(pw, proc.mAvgCachedKillPss * 1024L);
            pw.print("-");
            ProcessStats.printSizeValue(pw, proc.mMaxCachedKillPss * 1024L);
            pw.println();
        }
    }

    private final long $$robo$$com_android_internal_app_ProcessStats$getSysMemUsageValue(int state, int index) {
        int idx = ProcessStats.binarySearch(this.mSysMemUsageTable, this.mSysMemUsageTableSize, state);
        return idx >= 0 ? this.getLong(this.mSysMemUsageTable[idx], index) : 0L;
    }

    private final void $$robo$$com_android_internal_app_ProcessStats$dumpSysMemUsageCategory(PrintWriter pw, String prefix, String label, int bucket, int index) {
        pw.print(prefix);
        pw.print(label);
        pw.print(": ");
        ProcessStats.printSizeValue(pw, this.getSysMemUsageValue(bucket, index) * 1024L);
        pw.print(" min, ");
        ProcessStats.printSizeValue(pw, this.getSysMemUsageValue(bucket, index + 1) * 1024L);
        pw.print(" avg, ");
        ProcessStats.printSizeValue(pw, this.getSysMemUsageValue(bucket, index + 2) * 1024L);
        pw.println(" max");
    }

    private final void $$robo$$com_android_internal_app_ProcessStats$dumpSysMemUsage(PrintWriter pw, String prefix, int[] screenStates, int[] memStates) {
        int printedScreen = -1;
        for (int is = 0; is < screenStates.length; ++is) {
            int printedMem = -1;
            for (int im = 0; im < memStates.length; ++im) {
                int iscreen = screenStates[is];
                int imem = memStates[im];
                int bucket = (iscreen + imem) * 14;
                long count = this.getSysMemUsageValue(bucket, 0);
                if (count <= 0L) continue;
                pw.print(prefix);
                if (screenStates.length > 1) {
                    ProcessStats.printScreenLabel(pw, printedScreen != iscreen ? iscreen : -1);
                    printedScreen = iscreen;
                }
                if (memStates.length > 1) {
                    ProcessStats.printMemLabel(pw, printedMem != imem ? imem : -1, '\u0000');
                    printedMem = imem;
                }
                pw.print(": ");
                pw.print(count);
                pw.println(" samples:");
                this.dumpSysMemUsageCategory(pw, prefix, "  Cached", bucket, 1);
                this.dumpSysMemUsageCategory(pw, prefix, "  Free", bucket, 4);
                this.dumpSysMemUsageCategory(pw, prefix, "  ZRam", bucket, 7);
                this.dumpSysMemUsageCategory(pw, prefix, "  Kernel", bucket, 10);
                this.dumpSysMemUsageCategory(pw, prefix, "  Native", bucket, 13);
            }
        }
    }

    private static final void $$robo$$com_android_internal_app_ProcessStats$dumpStateHeadersCsv(PrintWriter pw, String sep, int[] screenStates, int[] memStates, int[] procStates) {
        int NS = screenStates != null ? screenStates.length : 1;
        int NM = memStates != null ? memStates.length : 1;
        int NP = procStates != null ? procStates.length : 1;
        for (int is = 0; is < NS; ++is) {
            for (int im = 0; im < NM; ++im) {
                for (int ip = 0; ip < NP; ++ip) {
                    pw.print(sep);
                    boolean printed = false;
                    if (screenStates != null && screenStates.length > 1) {
                        ProcessStats.printScreenLabelCsv(pw, screenStates[is]);
                        printed = true;
                    }
                    if (memStates != null && memStates.length > 1) {
                        if (printed) {
                            pw.print("-");
                        }
                        ProcessStats.printMemLabelCsv(pw, memStates[im]);
                        printed = true;
                    }
                    if (procStates == null || procStates.length <= 1) continue;
                    if (printed) {
                        pw.print("-");
                    }
                    pw.print(STATE_NAMES_CSV[procStates[ip]]);
                }
            }
        }
    }

    private static final void $$robo$$com_android_internal_app_ProcessStats$dumpProcessStateCsv(PrintWriter pw, ProcessState proc, boolean sepScreenStates, int[] screenStates, boolean sepMemStates, int[] memStates, boolean sepProcStates, int[] procStates, long now) {
        int NSS = sepScreenStates ? screenStates.length : 1;
        int NMS = sepMemStates ? memStates.length : 1;
        int NPS = sepProcStates ? procStates.length : 1;
        for (int iss = 0; iss < NSS; ++iss) {
            for (int ims = 0; ims < NMS; ++ims) {
                for (int ips = 0; ips < NPS; ++ips) {
                    int vsscreen = sepScreenStates ? screenStates[iss] : 0;
                    int vsmem = sepMemStates ? memStates[ims] : 0;
                    int vsproc = sepProcStates ? procStates[ips] : 0;
                    int NSA = sepScreenStates ? 1 : screenStates.length;
                    int NMA = sepMemStates ? 1 : memStates.length;
                    int NPA = sepProcStates ? 1 : procStates.length;
                    long totalTime = 0L;
                    for (int isa = 0; isa < NSA; ++isa) {
                        for (int ima = 0; ima < NMA; ++ima) {
                            for (int ipa = 0; ipa < NPA; ++ipa) {
                                int vascreen = sepScreenStates ? 0 : screenStates[isa];
                                int vamem = sepMemStates ? 0 : memStates[ima];
                                int vaproc = sepProcStates ? 0 : procStates[ipa];
                                int bucket = (vsscreen + vascreen + vsmem + vamem) * 14 + vsproc + vaproc;
                                totalTime += proc.getDuration(bucket, now);
                            }
                        }
                    }
                    pw.print("\t");
                    pw.print(totalTime);
                }
            }
        }
    }

    private static final void $$robo$$com_android_internal_app_ProcessStats$dumpProcessList(PrintWriter pw, String prefix, ArrayList<ProcessState> procs, int[] screenStates, int[] memStates, int[] procStates, long now) {
        String innerPrefix = prefix + "  ";
        for (int i = procs.size() - 1; i >= 0; --i) {
            ProcessState proc = procs.get(i);
            pw.print(prefix);
            pw.print(proc.mName);
            pw.print(" / ");
            UserHandle.formatUid(pw, proc.mUid);
            pw.print(" (");
            pw.print(proc.mDurationsTableSize);
            pw.print(" entries)");
            pw.println(":");
            ProcessStats.dumpProcessState(pw, innerPrefix, proc, screenStates, memStates, procStates, now);
            if (proc.mPssTableSize <= 0) continue;
            ProcessStats.dumpProcessPss(pw, innerPrefix, proc, screenStates, memStates, procStates);
        }
    }

    private static final void $$robo$$com_android_internal_app_ProcessStats$dumpProcessSummaryDetails(PrintWriter pw, ProcessState proc, String prefix, String label, int[] screenStates, int[] memStates, int[] procStates, long now, long totalTime, boolean full) {
        ProcessDataCollection totals = new ProcessDataCollection(screenStates, memStates, procStates);
        ProcessStats.computeProcessData(proc, totals, now);
        if (totals.totalTime != 0L || totals.numPss != 0L) {
            if (prefix != null) {
                pw.print(prefix);
            }
            if (label != null) {
                pw.print(label);
            }
            totals.print(pw, totalTime, full);
            if (prefix != null) {
                pw.println();
            }
        }
    }

    private static final void $$robo$$com_android_internal_app_ProcessStats$dumpProcessSummaryLocked(PrintWriter pw, String prefix, ArrayList<ProcessState> procs, int[] screenStates, int[] memStates, int[] procStates, boolean inclUidVers, long now, long totalTime) {
        for (int i = procs.size() - 1; i >= 0; --i) {
            ProcessState proc = procs.get(i);
            pw.print(prefix);
            pw.print("* ");
            pw.print(proc.mName);
            pw.print(" / ");
            UserHandle.formatUid(pw, proc.mUid);
            pw.print(" / v");
            pw.print(proc.mVersion);
            pw.println(":");
            ProcessStats.dumpProcessSummaryDetails(pw, proc, prefix, "         TOTAL: ", screenStates, memStates, procStates, now, totalTime, true);
            ProcessStats.dumpProcessSummaryDetails(pw, proc, prefix, "    Persistent: ", screenStates, memStates, new int[]{0}, now, totalTime, true);
            ProcessStats.dumpProcessSummaryDetails(pw, proc, prefix, "           Top: ", screenStates, memStates, new int[]{1}, now, totalTime, true);
            ProcessStats.dumpProcessSummaryDetails(pw, proc, prefix, "        Imp Fg: ", screenStates, memStates, new int[]{2}, now, totalTime, true);
            ProcessStats.dumpProcessSummaryDetails(pw, proc, prefix, "        Imp Bg: ", screenStates, memStates, new int[]{3}, now, totalTime, true);
            ProcessStats.dumpProcessSummaryDetails(pw, proc, prefix, "        Backup: ", screenStates, memStates, new int[]{4}, now, totalTime, true);
            ProcessStats.dumpProcessSummaryDetails(pw, proc, prefix, "     Heavy Wgt: ", screenStates, memStates, new int[]{5}, now, totalTime, true);
            ProcessStats.dumpProcessSummaryDetails(pw, proc, prefix, "       Service: ", screenStates, memStates, new int[]{6}, now, totalTime, true);
            ProcessStats.dumpProcessSummaryDetails(pw, proc, prefix, "    Service Rs: ", screenStates, memStates, new int[]{7}, now, totalTime, true);
            ProcessStats.dumpProcessSummaryDetails(pw, proc, prefix, "      Receiver: ", screenStates, memStates, new int[]{8}, now, totalTime, true);
            ProcessStats.dumpProcessSummaryDetails(pw, proc, prefix, "        (Home): ", screenStates, memStates, new int[]{9}, now, totalTime, true);
            ProcessStats.dumpProcessSummaryDetails(pw, proc, prefix, "    (Last Act): ", screenStates, memStates, new int[]{10}, now, totalTime, true);
            ProcessStats.dumpProcessSummaryDetails(pw, proc, prefix, "      (Cached): ", screenStates, memStates, new int[]{11, 12, 13}, now, totalTime, true);
        }
    }

    private static final void $$robo$$com_android_internal_app_ProcessStats$printPercent(PrintWriter pw, double fraction2) {
        if ((fraction2 *= 100.0) < 1.0) {
            pw.print(String.format("%.2f", fraction2));
        } else if (fraction2 < 10.0) {
            pw.print(String.format("%.1f", fraction2));
        } else {
            pw.print(String.format("%.0f", fraction2));
        }
        pw.print("%");
    }

    private static final void $$robo$$com_android_internal_app_ProcessStats$printSizeValue(PrintWriter pw, long number) {
        float result = number;
        String suffix = "";
        if (result > 900.0f) {
            suffix = "KB";
            result /= 1024.0f;
        }
        if (result > 900.0f) {
            suffix = "MB";
            result /= 1024.0f;
        }
        if (result > 900.0f) {
            suffix = "GB";
            result /= 1024.0f;
        }
        if (result > 900.0f) {
            suffix = "TB";
            result /= 1024.0f;
        }
        if (result > 900.0f) {
            suffix = "PB";
            result /= 1024.0f;
        }
        String value = result < 1.0f ? String.format("%.2f", Float.valueOf(result)) : (result < 10.0f ? String.format("%.1f", Float.valueOf(result)) : (result < 100.0f ? String.format("%.0f", Float.valueOf(result)) : String.format("%.0f", Float.valueOf(result))));
        pw.print(value);
        pw.print(suffix);
    }

    private static final void $$robo$$com_android_internal_app_ProcessStats$dumpProcessListCsv(PrintWriter pw, ArrayList<ProcessState> procs, boolean sepScreenStates, int[] screenStates, boolean sepMemStates, int[] memStates, boolean sepProcStates, int[] procStates, long now) {
        pw.print("process");
        pw.print("\t");
        pw.print("uid");
        pw.print("\t");
        pw.print("vers");
        ProcessStats.dumpStateHeadersCsv(pw, "\t", (int[])(sepScreenStates ? screenStates : null), (int[])(sepMemStates ? memStates : null), (int[])(sepProcStates ? procStates : null));
        pw.println();
        for (int i = procs.size() - 1; i >= 0; --i) {
            ProcessState proc = procs.get(i);
            pw.print(proc.mName);
            pw.print("\t");
            UserHandle.formatUid(pw, proc.mUid);
            pw.print("\t");
            pw.print(proc.mVersion);
            ProcessStats.dumpProcessStateCsv(pw, proc, sepScreenStates, screenStates, sepMemStates, memStates, sepProcStates, procStates, now);
            pw.println();
        }
    }

    private static final int $$robo$$com_android_internal_app_ProcessStats$printArrayEntry(PrintWriter pw, String[] array2, int value, int mod) {
        int index = value / mod;
        if (index >= 0 && index < array2.length) {
            pw.print(array2[index]);
        } else {
            pw.print('?');
        }
        return value - index * mod;
    }

    private static final void $$robo$$com_android_internal_app_ProcessStats$printProcStateTag(PrintWriter pw, int state) {
        state = ProcessStats.printArrayEntry(pw, ADJ_SCREEN_TAGS, state, 56);
        state = ProcessStats.printArrayEntry(pw, ADJ_MEM_TAGS, state, 14);
        ProcessStats.printArrayEntry(pw, STATE_TAGS, state, 1);
    }

    private static final void $$robo$$com_android_internal_app_ProcessStats$printAdjTag(PrintWriter pw, int state) {
        state = ProcessStats.printArrayEntry(pw, ADJ_SCREEN_TAGS, state, 4);
        ProcessStats.printArrayEntry(pw, ADJ_MEM_TAGS, state, 1);
    }

    private static final void $$robo$$com_android_internal_app_ProcessStats$printProcStateTagAndValue(PrintWriter pw, int state, long value) {
        pw.print(',');
        ProcessStats.printProcStateTag(pw, state);
        pw.print(':');
        pw.print(value);
    }

    private static final void $$robo$$com_android_internal_app_ProcessStats$printAdjTagAndValue(PrintWriter pw, int state, long value) {
        pw.print(',');
        ProcessStats.printAdjTag(pw, state);
        pw.print(':');
        pw.print(value);
    }

    private static final void $$robo$$com_android_internal_app_ProcessStats$dumpAllProcessStateCheckin(PrintWriter pw, ProcessState proc, long now) {
        boolean didCurState = false;
        for (int i = 0; i < proc.mDurationsTableSize; ++i) {
            int off = proc.mDurationsTable[i];
            int type = off >> OFFSET_TYPE_SHIFT & OFFSET_TYPE_MASK;
            long time = proc.mStats.getLong(off, 0);
            if (proc.mCurState == type) {
                didCurState = true;
                time += now - proc.mStartTime;
            }
            ProcessStats.printProcStateTagAndValue(pw, type, time);
        }
        if (!didCurState && proc.mCurState != -1) {
            ProcessStats.printProcStateTagAndValue(pw, proc.mCurState, now - proc.mStartTime);
        }
    }

    private static final void $$robo$$com_android_internal_app_ProcessStats$dumpAllProcessPssCheckin(PrintWriter pw, ProcessState proc) {
        for (int i = 0; i < proc.mPssTableSize; ++i) {
            int off = proc.mPssTable[i];
            int type = off >> OFFSET_TYPE_SHIFT & OFFSET_TYPE_MASK;
            long count = proc.mStats.getLong(off, 0);
            long min = proc.mStats.getLong(off, 1);
            long avg = proc.mStats.getLong(off, 2);
            long max = proc.mStats.getLong(off, 3);
            long umin = proc.mStats.getLong(off, 4);
            long uavg = proc.mStats.getLong(off, 5);
            long umax = proc.mStats.getLong(off, 6);
            pw.print(',');
            ProcessStats.printProcStateTag(pw, type);
            pw.print(':');
            pw.print(count);
            pw.print(':');
            pw.print(min);
            pw.print(':');
            pw.print(avg);
            pw.print(':');
            pw.print(max);
            pw.print(':');
            pw.print(umin);
            pw.print(':');
            pw.print(uavg);
            pw.print(':');
            pw.print(umax);
        }
    }

    private final void $$robo$$com_android_internal_app_ProcessStats$reset() {
        this.resetCommon();
        this.mPackages.getMap().clear();
        this.mProcesses.getMap().clear();
        this.mMemFactor = -1;
        this.mStartTime = 0L;
    }

    private final void $$robo$$com_android_internal_app_ProcessStats$resetSafely() {
        int iu;
        int ip;
        this.resetCommon();
        long now = SystemClock.uptimeMillis();
        ArrayMap<String, SparseArray<ProcessState>> procMap = this.mProcesses.getMap();
        for (int ip2 = procMap.size() - 1; ip2 >= 0; --ip2) {
            SparseArray<ProcessState> uids = procMap.valueAt(ip2);
            for (int iu2 = uids.size() - 1; iu2 >= 0; --iu2) {
                uids.valueAt((int)iu2).mTmpNumInUse = 0;
            }
        }
        ArrayMap<String, SparseArray<SparseArray<PackageState>>> pkgMap = this.mPackages.getMap();
        for (ip = pkgMap.size() - 1; ip >= 0; --ip) {
            SparseArray<SparseArray<PackageState>> uids = pkgMap.valueAt(ip);
            for (iu = uids.size() - 1; iu >= 0; --iu) {
                SparseArray<PackageState> vpkgs = uids.valueAt(iu);
                for (int iv = vpkgs.size() - 1; iv >= 0; --iv) {
                    PackageState pkgState = vpkgs.valueAt(iv);
                    for (int iproc = pkgState.mProcesses.size() - 1; iproc >= 0; --iproc) {
                        ProcessState ps = pkgState.mProcesses.valueAt(iproc);
                        if (ps.isInUse()) {
                            ps.resetSafely(now);
                            ++ps.mCommonProcess.mTmpNumInUse;
                            ps.mCommonProcess.mTmpFoundSubProc = ps;
                            continue;
                        }
                        pkgState.mProcesses.valueAt(iproc).makeDead();
                        pkgState.mProcesses.removeAt(iproc);
                    }
                    for (int isvc = pkgState.mServices.size() - 1; isvc >= 0; --isvc) {
                        ServiceState ss = pkgState.mServices.valueAt(isvc);
                        if (ss.isInUse()) {
                            ss.resetSafely(now);
                            continue;
                        }
                        pkgState.mServices.removeAt(isvc);
                    }
                    if (pkgState.mProcesses.size() > 0 || pkgState.mServices.size() > 0) continue;
                    vpkgs.removeAt(iv);
                }
                if (vpkgs.size() > 0) continue;
                uids.removeAt(iu);
            }
            if (uids.size() > 0) continue;
            pkgMap.removeAt(ip);
        }
        for (ip = procMap.size() - 1; ip >= 0; --ip) {
            SparseArray<ProcessState> uids = procMap.valueAt(ip);
            for (iu = uids.size() - 1; iu >= 0; --iu) {
                ProcessState ps = uids.valueAt(iu);
                if (ps.isInUse() || ps.mTmpNumInUse > 0) {
                    if (!ps.mActive && ps.mMultiPackage && ps.mTmpNumInUse == 1) {
                        ps.mCommonProcess = ps = ps.mTmpFoundSubProc;
                        uids.setValueAt(iu, ps);
                        continue;
                    }
                    ps.resetSafely(now);
                    continue;
                }
                ps.makeDead();
                uids.removeAt(iu);
            }
            if (uids.size() > 0) continue;
            procMap.removeAt(ip);
        }
        this.mStartTime = now;
    }

    private final void $$robo$$com_android_internal_app_ProcessStats$resetCommon() {
        this.mTimePeriodStartClock = (long)InvokeDynamicSupport.bootstrapIntrinsic("currentTimeMillis", "java.lang.System");
        this.buildTimePeriodStartClockStr();
        this.mTimePeriodStartRealtime = this.mTimePeriodEndRealtime = SystemClock.elapsedRealtime();
        this.mTimePeriodStartUptime = this.mTimePeriodEndUptime = SystemClock.uptimeMillis();
        this.mLongs.clear();
        this.mLongs.add(new long[4096]);
        this.mNextLong = 0;
        Arrays.fill(this.mMemFactorDurations, 0L);
        this.mSysMemUsageTable = null;
        this.mSysMemUsageTableSize = 0;
        this.mStartTime = 0L;
        this.mReadError = null;
        this.mFlags = 0;
        this.evaluateSystemProperties(true);
    }

    private final boolean $$robo$$com_android_internal_app_ProcessStats$evaluateSystemProperties(boolean update) {
        boolean changed = false;
        String runtime = SystemProperties.get("persist.sys.dalvik.vm.lib.2", VMRuntime.getRuntime().vmLibrary());
        if (!Objects.equals(runtime, this.mRuntime)) {
            changed = true;
            if (update) {
                this.mRuntime = runtime;
            }
        }
        return changed;
    }

    private final void $$robo$$com_android_internal_app_ProcessStats$buildTimePeriodStartClockStr() {
        this.mTimePeriodStartClockStr = DateFormat.format((CharSequence)"yyyy-MM-dd-HH-mm-ss", this.mTimePeriodStartClock).toString();
    }

    private final int[] $$robo$$com_android_internal_app_ProcessStats$readTableFromParcel(Parcel in, String name, String what) {
        int size = in.readInt();
        if (size < 0) {
            Slog.w("ProcessStats", "Ignoring existing stats; bad " + what + " table size: " + size);
            return BAD_TABLE;
        }
        if (size == 0) {
            return null;
        }
        int[] table = new int[size];
        for (int i = 0; i < size; ++i) {
            table[i] = in.readInt();
            if (this.validateLongOffset(table[i])) continue;
            Slog.w("ProcessStats", "Ignoring existing stats; bad " + what + " table entry: " + ProcessStats.printLongOffset(table[i]));
            return null;
        }
        return table;
    }

    private final void $$robo$$com_android_internal_app_ProcessStats$writeCompactedLongArray(Parcel out, long[] array2, int num) {
        for (int i = 0; i < num; ++i) {
            long val = array2[i];
            if (val < 0L) {
                Slog.w("ProcessStats", "Time val negative: " + val);
                val = 0L;
            }
            if (val <= Integer.MAX_VALUE) {
                out.writeInt((int)val);
                continue;
            }
            int top = ~((int)(val >> 32 & Integer.MAX_VALUE));
            int bottom = (int)(val & 0xFFFFFFFL);
            out.writeInt(top);
            out.writeInt(bottom);
        }
    }

    private final void $$robo$$com_android_internal_app_ProcessStats$readCompactedLongArray(Parcel in, int version, long[] array2, int num) {
        int i;
        if (version <= 10) {
            in.readLongArray(array2);
            return;
        }
        int alen = array2.length;
        if (num > alen) {
            throw new RuntimeException("bad array lengths: got " + num + " array is " + alen);
        }
        for (i = 0; i < num; ++i) {
            int val = in.readInt();
            if (val >= 0) {
                array2[i] = val;
                continue;
            }
            int bottom = in.readInt();
            array2[i] = (long)(~val) << 32 | (long)bottom;
        }
        while (i < alen) {
            array2[i] = 0L;
            ++i;
        }
    }

    private final void $$robo$$com_android_internal_app_ProcessStats$writeCommonString(Parcel out, String name) {
        Integer index = this.mCommonStringToIndex.get(name);
        if (index != null) {
            out.writeInt(index);
            return;
        }
        index = this.mCommonStringToIndex.size();
        this.mCommonStringToIndex.put(name, index);
        out.writeInt(~index.intValue());
        out.writeString(name);
    }

    private final String $$robo$$com_android_internal_app_ProcessStats$readCommonString(Parcel in, int version) {
        if (version <= 9) {
            return in.readString();
        }
        int index = in.readInt();
        if (index >= 0) {
            return this.mIndexToCommonString.get(index);
        }
        index ^= 0xFFFFFFFF;
        String name = in.readString();
        while (this.mIndexToCommonString.size() <= index) {
            this.mIndexToCommonString.add(null);
        }
        this.mIndexToCommonString.set(index, name);
        return name;
    }

    private final int $$robo$$com_android_internal_app_ProcessStats$describeContents() {
        return 0;
    }

    private final void $$robo$$com_android_internal_app_ProcessStats$writeToParcel(Parcel out, int flags) {
        this.writeToParcel(out, SystemClock.uptimeMillis(), flags);
    }

    private final void $$robo$$com_android_internal_app_ProcessStats$writeToParcel(Parcel out, long now, int flags) {
        int NUID;
        int ip;
        out.writeInt(1347638355);
        out.writeInt(18);
        out.writeInt(14);
        out.writeInt(8);
        out.writeInt(7);
        out.writeInt(16);
        out.writeInt(4096);
        this.mCommonStringToIndex = new ArrayMap(this.mProcesses.mMap.size());
        ArrayMap<String, SparseArray<ProcessState>> procMap = this.mProcesses.getMap();
        int NPROC = procMap.size();
        for (int ip2 = 0; ip2 < NPROC; ++ip2) {
            SparseArray<ProcessState> uids = procMap.valueAt(ip2);
            int NUID2 = uids.size();
            for (int iu = 0; iu < NUID2; ++iu) {
                uids.valueAt(iu).commitStateTime(now);
            }
        }
        ArrayMap<String, SparseArray<SparseArray<PackageState>>> pkgMap = this.mPackages.getMap();
        int NPKG = pkgMap.size();
        for (int ip3 = 0; ip3 < NPKG; ++ip3) {
            SparseArray<SparseArray<PackageState>> uids = pkgMap.valueAt(ip3);
            int NUID3 = uids.size();
            for (int iu = 0; iu < NUID3; ++iu) {
                SparseArray<PackageState> vpkgs = uids.valueAt(iu);
                int NVERS = vpkgs.size();
                for (int iv = 0; iv < NVERS; ++iv) {
                    PackageState pkgState = vpkgs.valueAt(iv);
                    int NPROCS = pkgState.mProcesses.size();
                    for (int iproc = 0; iproc < NPROCS; ++iproc) {
                        ProcessState proc = pkgState.mProcesses.valueAt(iproc);
                        if (proc.mCommonProcess == proc) continue;
                        proc.commitStateTime(now);
                    }
                    int NSRVS = pkgState.mServices.size();
                    for (int isvc = 0; isvc < NSRVS; ++isvc) {
                        pkgState.mServices.valueAt(isvc).commitStateTime(now);
                    }
                }
            }
        }
        out.writeLong(this.mTimePeriodStartClock);
        out.writeLong(this.mTimePeriodStartRealtime);
        out.writeLong(this.mTimePeriodEndRealtime);
        out.writeLong(this.mTimePeriodStartUptime);
        out.writeLong(this.mTimePeriodEndUptime);
        out.writeString(this.mRuntime);
        out.writeInt(this.mFlags);
        out.writeInt(this.mLongs.size());
        out.writeInt(this.mNextLong);
        for (int i = 0; i < this.mLongs.size() - 1; ++i) {
            long[] array2 = this.mLongs.get(i);
            this.writeCompactedLongArray(out, array2, array2.length);
        }
        long[] lastLongs = this.mLongs.get(this.mLongs.size() - 1);
        this.writeCompactedLongArray(out, lastLongs, this.mNextLong);
        if (this.mMemFactor != -1) {
            int n = this.mMemFactor;
            this.mMemFactorDurations[n] = this.mMemFactorDurations[n] + (now - this.mStartTime);
            this.mStartTime = now;
        }
        this.writeCompactedLongArray(out, this.mMemFactorDurations, this.mMemFactorDurations.length);
        out.writeInt(this.mSysMemUsageTableSize);
        for (int i = 0; i < this.mSysMemUsageTableSize; ++i) {
            out.writeInt(this.mSysMemUsageTable[i]);
        }
        out.writeInt(NPROC);
        for (ip = 0; ip < NPROC; ++ip) {
            this.writeCommonString(out, procMap.keyAt(ip));
            SparseArray<ProcessState> uids = procMap.valueAt(ip);
            NUID = uids.size();
            out.writeInt(NUID);
            for (int iu = 0; iu < NUID; ++iu) {
                out.writeInt(uids.keyAt(iu));
                ProcessState proc = uids.valueAt(iu);
                this.writeCommonString(out, proc.mPackage);
                out.writeInt(proc.mVersion);
                proc.writeToParcel(out, now);
            }
        }
        out.writeInt(NPKG);
        for (ip = 0; ip < NPKG; ++ip) {
            this.writeCommonString(out, pkgMap.keyAt(ip));
            SparseArray<SparseArray<PackageState>> uids = pkgMap.valueAt(ip);
            NUID = uids.size();
            out.writeInt(NUID);
            for (int iu = 0; iu < NUID; ++iu) {
                out.writeInt(uids.keyAt(iu));
                SparseArray<PackageState> vpkgs = uids.valueAt(iu);
                int NVERS = vpkgs.size();
                out.writeInt(NVERS);
                for (int iv = 0; iv < NVERS; ++iv) {
                    out.writeInt(vpkgs.keyAt(iv));
                    PackageState pkgState = vpkgs.valueAt(iv);
                    int NPROCS = pkgState.mProcesses.size();
                    out.writeInt(NPROCS);
                    for (int iproc = 0; iproc < NPROCS; ++iproc) {
                        this.writeCommonString(out, pkgState.mProcesses.keyAt(iproc));
                        ProcessState proc = pkgState.mProcesses.valueAt(iproc);
                        if (proc.mCommonProcess == proc) {
                            out.writeInt(0);
                            continue;
                        }
                        out.writeInt(1);
                        proc.writeToParcel(out, now);
                    }
                    int NSRVS = pkgState.mServices.size();
                    out.writeInt(NSRVS);
                    for (int isvc = 0; isvc < NSRVS; ++isvc) {
                        out.writeString(pkgState.mServices.keyAt(isvc));
                        ServiceState svc = pkgState.mServices.valueAt(isvc);
                        this.writeCommonString(out, svc.mProcessName);
                        svc.writeToParcel(out, now);
                    }
                }
            }
        }
        this.mCommonStringToIndex = null;
    }

    private final boolean $$robo$$com_android_internal_app_ProcessStats$readCheckedInt(Parcel in, int val, String what) {
        int got = in.readInt();
        if (got != val) {
            this.mReadError = "bad " + what + ": " + got;
            return false;
        }
        return true;
    }

    private static final byte[] $$robo$$com_android_internal_app_ProcessStats$readFully(InputStream stream, int[] outLen) throws IOException {
        int pos = 0;
        int initialAvail = stream.available();
        byte[] data = new byte[initialAvail > 0 ? initialAvail + 1 : 16384];
        while (true) {
            int amt;
            if ((amt = stream.read(data, pos, data.length - pos)) < 0) {
                outLen[0] = pos;
                return data;
            }
            if ((pos += amt) < data.length) continue;
            byte[] newData = new byte[pos + 16384];
            InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (byte[])data, (int)0, (byte[])newData, (int)0, (int)pos);
            data = newData;
        }
    }

    private final void $$robo$$com_android_internal_app_ProcessStats$read(InputStream stream) {
        try {
            int[] len = new int[1];
            byte[] raw2 = ProcessStats.readFully(stream, len);
            Parcel in = Parcel.obtain();
            in.unmarshall(raw2, 0, len[0]);
            in.setDataPosition(0);
            stream.close();
            this.readFromParcel(in);
        }
        catch (IOException e) {
            this.mReadError = "caught exception: " + e;
        }
    }

    private final void $$robo$$com_android_internal_app_ProcessStats$readFromParcel(Parcel in) {
        boolean hadData;
        boolean bl = hadData = this.mPackages.getMap().size() > 0 || this.mProcesses.getMap().size() > 0;
        if (hadData) {
            this.resetSafely();
        }
        if (!this.readCheckedInt(in, 1347638355, "magic number")) {
            return;
        }
        int version = in.readInt();
        if (version != 18) {
            this.mReadError = "bad version: " + version;
            return;
        }
        if (!this.readCheckedInt(in, 14, "state count")) {
            return;
        }
        if (!this.readCheckedInt(in, 8, "adj count")) {
            return;
        }
        if (!this.readCheckedInt(in, 7, "pss count")) {
            return;
        }
        if (!this.readCheckedInt(in, 16, "sys mem usage count")) {
            return;
        }
        if (!this.readCheckedInt(in, 4096, "longs size")) {
            return;
        }
        this.mIndexToCommonString = new ArrayList();
        this.mTimePeriodStartClock = in.readLong();
        this.buildTimePeriodStartClockStr();
        this.mTimePeriodStartRealtime = in.readLong();
        this.mTimePeriodEndRealtime = in.readLong();
        this.mTimePeriodStartUptime = in.readLong();
        this.mTimePeriodEndUptime = in.readLong();
        this.mRuntime = in.readString();
        this.mFlags = in.readInt();
        int NLONGS = in.readInt();
        int NEXTLONG = in.readInt();
        this.mLongs.clear();
        for (int i = 0; i < NLONGS - 1; ++i) {
            while (i >= this.mLongs.size()) {
                this.mLongs.add(new long[4096]);
            }
            this.readCompactedLongArray(in, version, this.mLongs.get(i), 4096);
        }
        long[] longs = new long[4096];
        this.mNextLong = NEXTLONG;
        this.readCompactedLongArray(in, version, longs, NEXTLONG);
        this.mLongs.add(longs);
        this.readCompactedLongArray(in, version, this.mMemFactorDurations, this.mMemFactorDurations.length);
        this.mSysMemUsageTable = this.readTableFromParcel(in, "ProcessStats", "sys mem usage");
        if (this.mSysMemUsageTable == BAD_TABLE) {
            return;
        }
        this.mSysMemUsageTableSize = this.mSysMemUsageTable != null ? this.mSysMemUsageTable.length : 0;
        int NPROC = in.readInt();
        if (NPROC < 0) {
            this.mReadError = "bad process count: " + NPROC;
            return;
        }
        while (NPROC > 0) {
            --NPROC;
            String procName = this.readCommonString(in, version);
            if (procName == null) {
                this.mReadError = "bad process name";
                return;
            }
            int NUID = in.readInt();
            if (NUID < 0) {
                this.mReadError = "bad uid count: " + NUID;
                return;
            }
            while (NUID > 0) {
                ProcessState proc;
                --NUID;
                int uid = in.readInt();
                if (uid < 0) {
                    this.mReadError = "bad uid: " + uid;
                    return;
                }
                String pkgName = this.readCommonString(in, version);
                if (pkgName == null) {
                    this.mReadError = "bad process package name";
                    return;
                }
                int vers = in.readInt();
                ProcessState processState = proc = hadData ? this.mProcesses.get(procName, uid) : null;
                if (proc != null ? !proc.readFromParcel(in, false) : !(proc = new ProcessState(this, pkgName, uid, vers, procName)).readFromParcel(in, true)) {
                    return;
                }
                this.mProcesses.put(procName, uid, proc);
            }
        }
        int NPKG = in.readInt();
        if (NPKG < 0) {
            this.mReadError = "bad package count: " + NPKG;
            return;
        }
        while (NPKG > 0) {
            --NPKG;
            String pkgName = this.readCommonString(in, version);
            if (pkgName == null) {
                this.mReadError = "bad package name";
                return;
            }
            int NUID = in.readInt();
            if (NUID < 0) {
                this.mReadError = "bad uid count: " + NUID;
                return;
            }
            while (NUID > 0) {
                --NUID;
                int uid = in.readInt();
                if (uid < 0) {
                    this.mReadError = "bad uid: " + uid;
                    return;
                }
                int NVERS = in.readInt();
                if (NVERS < 0) {
                    this.mReadError = "bad versions count: " + NVERS;
                    return;
                }
                while (NVERS > 0) {
                    int NPROCS;
                    --NVERS;
                    int vers = in.readInt();
                    PackageState pkgState = new PackageState(pkgName, uid);
                    SparseArray<PackageState> vpkg = this.mPackages.get(pkgName, uid);
                    if (vpkg == null) {
                        vpkg = new SparseArray();
                        this.mPackages.put(pkgName, uid, vpkg);
                    }
                    vpkg.put(vers, pkgState);
                    if (NPROCS < 0) {
                        this.mReadError = "bad package process count: " + NPROCS;
                        return;
                    }
                    for (NPROCS = in.readInt(); NPROCS > 0; --NPROCS) {
                        String procName = this.readCommonString(in, version);
                        if (procName == null) {
                            this.mReadError = "bad package process name";
                            return;
                        }
                        int hasProc = in.readInt();
                        ProcessState commonProc = this.mProcesses.get(procName, uid);
                        if (commonProc == null) {
                            this.mReadError = "no common proc: " + procName;
                            return;
                        }
                        if (hasProc != 0) {
                            ProcessState proc;
                            ProcessState processState = proc = hadData ? pkgState.mProcesses.get(procName) : null;
                            if (proc != null ? !proc.readFromParcel(in, false) : !(proc = new ProcessState(commonProc, pkgName, uid, vers, procName, 0L)).readFromParcel(in, true)) {
                                return;
                            }
                            pkgState.mProcesses.put(procName, proc);
                            continue;
                        }
                        pkgState.mProcesses.put(procName, commonProc);
                    }
                    int NSRVS = in.readInt();
                    if (NSRVS < 0) {
                        this.mReadError = "bad package service count: " + NSRVS;
                        return;
                    }
                    while (NSRVS > 0) {
                        ServiceState serv;
                        --NSRVS;
                        String serviceName = in.readString();
                        if (serviceName == null) {
                            this.mReadError = "bad package service name";
                            return;
                        }
                        String processName = version > 9 ? this.readCommonString(in, version) : null;
                        ServiceState serviceState = serv = hadData ? pkgState.mServices.get(serviceName) : null;
                        if (serv == null) {
                            serv = new ServiceState(this, pkgName, serviceName, processName, null);
                        }
                        if (!serv.readFromParcel(in)) {
                            return;
                        }
                        pkgState.mServices.put(serviceName, serv);
                    }
                }
            }
        }
        this.mIndexToCommonString = null;
    }

    private final int $$robo$$com_android_internal_app_ProcessStats$addLongData(int index, int type, int num) {
        int off = this.allocLongData(num);
        this.mAddLongTable = GrowingArrayUtils.insert(this.mAddLongTable != null ? this.mAddLongTable : EmptyArray.INT, this.mAddLongTableSize, index, type | off);
        ++this.mAddLongTableSize;
        return off;
    }

    private final int $$robo$$com_android_internal_app_ProcessStats$allocLongData(int num) {
        int whichLongs = this.mLongs.size() - 1;
        long[] longs = this.mLongs.get(whichLongs);
        if (this.mNextLong + num > longs.length) {
            longs = new long[4096];
            this.mLongs.add(longs);
            ++whichLongs;
            this.mNextLong = 0;
        }
        int off = whichLongs << OFFSET_ARRAY_SHIFT | this.mNextLong << OFFSET_INDEX_SHIFT;
        this.mNextLong += num;
        return off;
    }

    private final boolean $$robo$$com_android_internal_app_ProcessStats$validateLongOffset(int off) {
        int arr = off >> OFFSET_ARRAY_SHIFT & OFFSET_ARRAY_MASK;
        if (arr >= this.mLongs.size()) {
            return false;
        }
        int idx = off >> OFFSET_INDEX_SHIFT & OFFSET_INDEX_MASK;
        return idx < 4096;
    }

    private static final String $$robo$$com_android_internal_app_ProcessStats$printLongOffset(int off) {
        StringBuilder sb = new StringBuilder(16);
        sb.append("a");
        sb.append(off >> OFFSET_ARRAY_SHIFT & OFFSET_ARRAY_MASK);
        sb.append("i");
        sb.append(off >> OFFSET_INDEX_SHIFT & OFFSET_INDEX_MASK);
        sb.append("t");
        sb.append(off >> OFFSET_TYPE_SHIFT & OFFSET_TYPE_MASK);
        return sb.toString();
    }

    private final void $$robo$$com_android_internal_app_ProcessStats$setLong(int off, int index, long value) {
        long[] longs = this.mLongs.get(off >> OFFSET_ARRAY_SHIFT & OFFSET_ARRAY_MASK);
        longs[index + (off >> ProcessStats.OFFSET_INDEX_SHIFT & ProcessStats.OFFSET_INDEX_MASK)] = value;
    }

    private final long $$robo$$com_android_internal_app_ProcessStats$getLong(int off, int index) {
        long[] longs = this.mLongs.get(off >> OFFSET_ARRAY_SHIFT & OFFSET_ARRAY_MASK);
        return longs[index + (off >> OFFSET_INDEX_SHIFT & OFFSET_INDEX_MASK)];
    }

    private static final int $$robo$$com_android_internal_app_ProcessStats$binarySearch(int[] array2, int size, int value) {
        int lo = 0;
        int hi = size - 1;
        while (lo <= hi) {
            int mid = lo + hi >>> 1;
            int midVal = array2[mid] >> OFFSET_TYPE_SHIFT & OFFSET_TYPE_MASK;
            if (midVal < value) {
                lo = mid + 1;
                continue;
            }
            if (midVal > value) {
                hi = mid - 1;
                continue;
            }
            return mid;
        }
        return ~lo;
    }

    private final PackageState $$robo$$com_android_internal_app_ProcessStats$getPackageStateLocked(String packageName, int uid, int vers) {
        PackageState as;
        SparseArray<PackageState> vpkg = this.mPackages.get(packageName, uid);
        if (vpkg == null) {
            vpkg = new SparseArray();
            this.mPackages.put(packageName, uid, vpkg);
        }
        if ((as = vpkg.get(vers)) != null) {
            return as;
        }
        as = new PackageState(packageName, uid);
        vpkg.put(vers, as);
        return as;
    }

    private final ProcessState $$robo$$com_android_internal_app_ProcessStats$getProcessStateLocked(String packageName, int uid, int vers, String processName) {
        PackageState pkgState = this.getPackageStateLocked(packageName, uid, vers);
        ProcessState ps = pkgState.mProcesses.get(processName);
        if (ps != null) {
            return ps;
        }
        ProcessState commonProc = this.mProcesses.get(processName, uid);
        if (commonProc == null) {
            commonProc = new ProcessState(this, packageName, uid, vers, processName);
            this.mProcesses.put(processName, uid, commonProc);
        }
        if (!commonProc.mMultiPackage) {
            if (packageName.equals(commonProc.mPackage) && vers == commonProc.mVersion) {
                ps = commonProc;
            } else {
                commonProc.mMultiPackage = true;
                long now = SystemClock.uptimeMillis();
                PackageState commonPkgState = this.getPackageStateLocked(commonProc.mPackage, uid, commonProc.mVersion);
                if (commonPkgState != null) {
                    ProcessState cloned = commonProc.clone(commonProc.mPackage, now);
                    commonPkgState.mProcesses.put(commonProc.mName, cloned);
                    for (int i = commonPkgState.mServices.size() - 1; i >= 0; --i) {
                        ServiceState ss = commonPkgState.mServices.valueAt(i);
                        if (ss.mProc != commonProc) continue;
                        ss.mProc = cloned;
                    }
                } else {
                    Slog.w("ProcessStats", "Cloning proc state: no package state " + commonProc.mPackage + "/" + uid + " for proc " + commonProc.mName);
                }
                ps = new ProcessState(commonProc, packageName, uid, vers, processName, now);
            }
        } else {
            ps = new ProcessState(commonProc, packageName, uid, vers, processName, SystemClock.uptimeMillis());
        }
        pkgState.mProcesses.put(processName, ps);
        return ps;
    }

    private final ServiceState $$robo$$com_android_internal_app_ProcessStats$getServiceStateLocked(String packageName, int uid, int vers, String processName, String className) {
        PackageState as = this.getPackageStateLocked(packageName, uid, vers);
        ServiceState ss = as.mServices.get(className);
        if (ss != null) {
            return ss;
        }
        ProcessState ps = processName != null ? this.getProcessStateLocked(packageName, uid, vers, processName) : null;
        ss = new ServiceState(this, packageName, className, processName, ps);
        as.mServices.put(className, ss);
        return ss;
    }

    private final void $$robo$$com_android_internal_app_ProcessStats$dumpProcessInternalLocked(PrintWriter pw, String prefix, ProcessState proc, boolean dumpAll) {
        if (dumpAll) {
            pw.print(prefix);
            pw.print("myID=");
            pw.print(Integer.toHexString(System.identityHashCode(proc)));
            pw.print(" mCommonProcess=");
            pw.print(Integer.toHexString(System.identityHashCode(proc.mCommonProcess)));
            pw.print(" mPackage=");
            pw.println(proc.mPackage);
            if (proc.mMultiPackage) {
                pw.print(prefix);
                pw.print("mMultiPackage=");
                pw.println(proc.mMultiPackage);
            }
            if (proc != proc.mCommonProcess) {
                pw.print(prefix);
                pw.print("Common Proc: ");
                pw.print(proc.mCommonProcess.mName);
                pw.print("/");
                pw.print(proc.mCommonProcess.mUid);
                pw.print(" pkg=");
                pw.println(proc.mCommonProcess.mPackage);
            }
        }
        if (proc.mActive) {
            pw.print(prefix);
            pw.print("mActive=");
            pw.println(proc.mActive);
        }
        if (proc.mDead) {
            pw.print(prefix);
            pw.print("mDead=");
            pw.println(proc.mDead);
        }
        if (proc.mNumActiveServices != 0 || proc.mNumStartedServices != 0) {
            pw.print(prefix);
            pw.print("mNumActiveServices=");
            pw.print(proc.mNumActiveServices);
            pw.print(" mNumStartedServices=");
            pw.println(proc.mNumStartedServices);
        }
    }

    private final void $$robo$$com_android_internal_app_ProcessStats$dumpLocked(PrintWriter pw, String reqPackage, long now, boolean dumpSummary, boolean dumpAll, boolean activeOnly) {
        long totalTime = ProcessStats.dumpSingleTime(null, null, this.mMemFactorDurations, this.mMemFactor, this.mStartTime, now);
        boolean sepNeeded = false;
        if (this.mSysMemUsageTable != null) {
            pw.println("System memory usage:");
            this.dumpSysMemUsage(pw, "  ", ALL_SCREEN_ADJ, ALL_MEM_ADJ);
            sepNeeded = true;
        }
        ArrayMap<String, SparseArray<SparseArray<PackageState>>> pkgMap = this.mPackages.getMap();
        boolean printedHeader = false;
        for (int ip = 0; ip < pkgMap.size(); ++ip) {
            String pkgName = pkgMap.keyAt(ip);
            SparseArray<SparseArray<PackageState>> uids = pkgMap.valueAt(ip);
            for (int iu = 0; iu < uids.size(); ++iu) {
                int uid = uids.keyAt(iu);
                SparseArray<PackageState> vpkgs = uids.valueAt(iu);
                for (int iv = 0; iv < vpkgs.size(); ++iv) {
                    ProcessState proc;
                    int iproc;
                    boolean pkgMatch;
                    int vers = vpkgs.keyAt(iv);
                    PackageState pkgState = vpkgs.valueAt(iv);
                    int NPROCS = pkgState.mProcesses.size();
                    int NSRVS = pkgState.mServices.size();
                    boolean bl = pkgMatch = reqPackage == null || reqPackage.equals(pkgName);
                    if (!pkgMatch) {
                        boolean procMatch = false;
                        for (iproc = 0; iproc < NPROCS; ++iproc) {
                            proc = pkgState.mProcesses.valueAt(iproc);
                            if (!reqPackage.equals(proc.mName)) continue;
                            procMatch = true;
                            break;
                        }
                        if (!procMatch) continue;
                    }
                    if (NPROCS > 0 || NSRVS > 0) {
                        if (!printedHeader) {
                            if (sepNeeded) {
                                pw.println();
                            }
                            pw.println("Per-Package Stats:");
                            printedHeader = true;
                            sepNeeded = true;
                        }
                        pw.print("  * ");
                        pw.print(pkgName);
                        pw.print(" / ");
                        UserHandle.formatUid(pw, uid);
                        pw.print(" / v");
                        pw.print(vers);
                        pw.println(":");
                    }
                    if (!dumpSummary || dumpAll) {
                        for (int iproc2 = 0; iproc2 < NPROCS; ++iproc2) {
                            ProcessState proc2 = pkgState.mProcesses.valueAt(iproc2);
                            if (!pkgMatch && !reqPackage.equals(proc2.mName)) continue;
                            if (activeOnly && !proc2.isInUse()) {
                                pw.print("      (Not active: ");
                                pw.print(pkgState.mProcesses.keyAt(iproc2));
                                pw.println(")");
                                continue;
                            }
                            pw.print("      Process ");
                            pw.print(pkgState.mProcesses.keyAt(iproc2));
                            if (proc2.mCommonProcess.mMultiPackage) {
                                pw.print(" (multi, ");
                            } else {
                                pw.print(" (unique, ");
                            }
                            pw.print(proc2.mDurationsTableSize);
                            pw.print(" entries)");
                            pw.println(":");
                            ProcessStats.dumpProcessState(pw, "        ", proc2, ALL_SCREEN_ADJ, ALL_MEM_ADJ, ALL_PROC_STATES, now);
                            ProcessStats.dumpProcessPss(pw, "        ", proc2, ALL_SCREEN_ADJ, ALL_MEM_ADJ, ALL_PROC_STATES);
                            this.dumpProcessInternalLocked(pw, "        ", proc2, dumpAll);
                        }
                    } else {
                        ArrayList<ProcessState> procs = new ArrayList<ProcessState>();
                        for (iproc = 0; iproc < NPROCS; ++iproc) {
                            proc = pkgState.mProcesses.valueAt(iproc);
                            if (!pkgMatch && !reqPackage.equals(proc.mName) || activeOnly && !proc.isInUse()) continue;
                            procs.add(proc);
                        }
                        ProcessStats.dumpProcessSummaryLocked(pw, "      ", procs, ALL_SCREEN_ADJ, ALL_MEM_ADJ, NON_CACHED_PROC_STATES, false, now, totalTime);
                    }
                    for (int isvc = 0; isvc < NSRVS; ++isvc) {
                        ServiceState svc = pkgState.mServices.valueAt(isvc);
                        if (!pkgMatch && !reqPackage.equals(svc.mProcessName)) continue;
                        if (activeOnly && !svc.isInUse()) {
                            pw.print("      (Not active: ");
                            pw.print(pkgState.mServices.keyAt(isvc));
                            pw.println(")");
                            continue;
                        }
                        if (dumpAll) {
                            pw.print("      Service ");
                        } else {
                            pw.print("      * ");
                        }
                        pw.print(pkgState.mServices.keyAt(isvc));
                        pw.println(":");
                        pw.print("        Process: ");
                        pw.println(svc.mProcessName);
                        this.dumpServiceStats(pw, "        ", "          ", "    ", "Running", svc, svc.mRunCount, 0, svc.mRunState, svc.mRunStartTime, now, totalTime, !dumpSummary || dumpAll);
                        this.dumpServiceStats(pw, "        ", "          ", "    ", "Started", svc, svc.mStartedCount, 1, svc.mStartedState, svc.mStartedStartTime, now, totalTime, !dumpSummary || dumpAll);
                        this.dumpServiceStats(pw, "        ", "          ", "      ", "Bound", svc, svc.mBoundCount, 2, svc.mBoundState, svc.mBoundStartTime, now, totalTime, !dumpSummary || dumpAll);
                        this.dumpServiceStats(pw, "        ", "          ", "  ", "Executing", svc, svc.mExecCount, 3, svc.mExecState, svc.mExecStartTime, now, totalTime, !dumpSummary || dumpAll);
                        if (!dumpAll) continue;
                        if (svc.mOwner != null) {
                            pw.print("        mOwner=");
                            pw.println(svc.mOwner);
                        }
                        if (!svc.mStarted && !svc.mRestarting) continue;
                        pw.print("        mStarted=");
                        pw.print(svc.mStarted);
                        pw.print(" mRestarting=");
                        pw.println(svc.mRestarting);
                    }
                }
            }
        }
        ArrayMap<String, SparseArray<ProcessState>> procMap = this.mProcesses.getMap();
        printedHeader = false;
        int numShownProcs = 0;
        int numTotalProcs = 0;
        for (int ip = 0; ip < procMap.size(); ++ip) {
            String procName = procMap.keyAt(ip);
            SparseArray<ProcessState> uids = procMap.valueAt(ip);
            for (int iu = 0; iu < uids.size(); ++iu) {
                int uid = uids.keyAt(iu);
                ++numTotalProcs;
                ProcessState proc = uids.valueAt(iu);
                if (proc.mDurationsTableSize == 0 && proc.mCurState == -1 && proc.mPssTableSize == 0 || !proc.mMultiPackage || reqPackage != null && !reqPackage.equals(procName) && !reqPackage.equals(proc.mPackage)) continue;
                ++numShownProcs;
                if (sepNeeded) {
                    pw.println();
                }
                sepNeeded = true;
                if (!printedHeader) {
                    pw.println("Multi-Package Common Processes:");
                    printedHeader = true;
                }
                if (activeOnly && !proc.isInUse()) {
                    pw.print("      (Not active: ");
                    pw.print(procName);
                    pw.println(")");
                    continue;
                }
                pw.print("  * ");
                pw.print(procName);
                pw.print(" / ");
                UserHandle.formatUid(pw, uid);
                pw.print(" (");
                pw.print(proc.mDurationsTableSize);
                pw.print(" entries)");
                pw.println(":");
                ProcessStats.dumpProcessState(pw, "        ", proc, ALL_SCREEN_ADJ, ALL_MEM_ADJ, ALL_PROC_STATES, now);
                ProcessStats.dumpProcessPss(pw, "        ", proc, ALL_SCREEN_ADJ, ALL_MEM_ADJ, ALL_PROC_STATES);
                this.dumpProcessInternalLocked(pw, "        ", proc, dumpAll);
            }
        }
        if (dumpAll) {
            pw.println();
            pw.print("  Total procs: ");
            pw.print(numShownProcs);
            pw.print(" shown of ");
            pw.print(numTotalProcs);
            pw.println(" total");
        }
        if (sepNeeded) {
            pw.println();
        }
        if (dumpSummary) {
            pw.println("Summary:");
            this.dumpSummaryLocked(pw, reqPackage, now, activeOnly);
        } else {
            this.dumpTotalsLocked(pw, now);
        }
        if (dumpAll) {
            pw.println();
            pw.println("Internal state:");
            pw.print("  Num long arrays: ");
            pw.println(this.mLongs.size());
            pw.print("  Next long entry: ");
            pw.println(this.mNextLong);
            pw.print("  mRunning=");
            pw.println(this.mRunning);
        }
    }

    private static final long $$robo$$com_android_internal_app_ProcessStats$dumpSingleServiceTime(PrintWriter pw, String prefix, ServiceState service, int serviceType, int curState, long curStartTime, long now) {
        long totalTime = 0L;
        int printedScreen = -1;
        for (int iscreen = 0; iscreen < 8; iscreen += 4) {
            int printedMem = -1;
            for (int imem = 0; imem < 4; ++imem) {
                int state = imem + iscreen;
                long time = service.getDuration(serviceType, curState, curStartTime, state, now);
                String running = "";
                if (curState == state && pw != null) {
                    running = " (running)";
                }
                if (time == 0L) continue;
                if (pw != null) {
                    pw.print(prefix);
                    ProcessStats.printScreenLabel(pw, printedScreen != iscreen ? iscreen : -1);
                    printedScreen = iscreen;
                    ProcessStats.printMemLabel(pw, printedMem != imem ? imem : -1, '\u0000');
                    printedMem = imem;
                    pw.print(": ");
                    TimeUtils.formatDuration(time, pw);
                    pw.println(running);
                }
                totalTime += time;
            }
        }
        if (totalTime != 0L && pw != null) {
            pw.print(prefix);
            pw.print("    TOTAL: ");
            TimeUtils.formatDuration(totalTime, pw);
            pw.println();
        }
        return totalTime;
    }

    private final void $$robo$$com_android_internal_app_ProcessStats$dumpServiceStats(PrintWriter pw, String prefix, String prefixInner, String headerPrefix, String header, ServiceState service, int count, int serviceType, int state, long startTime, long now, long totalTime, boolean dumpAll) {
        if (count != 0) {
            if (dumpAll) {
                pw.print(prefix);
                pw.print(header);
                pw.print(" op count ");
                pw.print(count);
                pw.println(":");
                ProcessStats.dumpSingleServiceTime(pw, prefixInner, service, serviceType, state, startTime, now);
            } else {
                long myTime = ProcessStats.dumpSingleServiceTime(null, null, service, serviceType, state, startTime, now);
                pw.print(prefix);
                pw.print(headerPrefix);
                pw.print(header);
                pw.print(" count ");
                pw.print(count);
                pw.print(" / time ");
                ProcessStats.printPercent(pw, (double)myTime / (double)totalTime);
                pw.println();
            }
        }
    }

    private final void $$robo$$com_android_internal_app_ProcessStats$dumpSummaryLocked(PrintWriter pw, String reqPackage, long now, boolean activeOnly) {
        long totalTime = ProcessStats.dumpSingleTime(null, null, this.mMemFactorDurations, this.mMemFactor, this.mStartTime, now);
        this.dumpFilteredSummaryLocked(pw, null, "  ", ALL_SCREEN_ADJ, ALL_MEM_ADJ, ALL_PROC_STATES, NON_CACHED_PROC_STATES, now, totalTime, reqPackage, activeOnly);
        pw.println();
        this.dumpTotalsLocked(pw, now);
    }

    private final long $$robo$$com_android_internal_app_ProcessStats$printMemoryCategory(PrintWriter pw, String prefix, String label, double memWeight, long totalTime, long curTotalMem, int samples) {
        if (memWeight != 0.0) {
            long mem = (long)(memWeight * 1024.0 / (double)totalTime);
            pw.print(prefix);
            pw.print(label);
            pw.print(": ");
            ProcessStats.printSizeValue(pw, mem);
            pw.print(" (");
            pw.print(samples);
            pw.print(" samples)");
            pw.println();
            return curTotalMem + mem;
        }
        return curTotalMem;
    }

    private final void $$robo$$com_android_internal_app_ProcessStats$dumpTotalsLocked(PrintWriter pw, long now) {
        pw.println("Run time Stats:");
        ProcessStats.dumpSingleTime(pw, "  ", this.mMemFactorDurations, this.mMemFactor, this.mStartTime, now);
        pw.println();
        pw.println("Memory usage:");
        TotalMemoryUseCollection totalMem = new TotalMemoryUseCollection(ALL_SCREEN_ADJ, ALL_MEM_ADJ);
        this.computeTotalMemoryUse(totalMem, now);
        long totalPss = 0L;
        totalPss = this.printMemoryCategory(pw, "  ", "Kernel ", totalMem.sysMemKernelWeight, totalMem.totalTime, totalPss, totalMem.sysMemSamples);
        totalPss = this.printMemoryCategory(pw, "  ", "Native ", totalMem.sysMemNativeWeight, totalMem.totalTime, totalPss, totalMem.sysMemSamples);
        for (int i = 0; i < 14; ++i) {
            if (i == 7) continue;
            totalPss = this.printMemoryCategory(pw, "  ", STATE_NAMES[i], totalMem.processStateWeight[i], totalMem.totalTime, totalPss, totalMem.processStateSamples[i]);
        }
        totalPss = this.printMemoryCategory(pw, "  ", "Cached ", totalMem.sysMemCachedWeight, totalMem.totalTime, totalPss, totalMem.sysMemSamples);
        totalPss = this.printMemoryCategory(pw, "  ", "Free   ", totalMem.sysMemFreeWeight, totalMem.totalTime, totalPss, totalMem.sysMemSamples);
        totalPss = this.printMemoryCategory(pw, "  ", "Z-Ram   ", totalMem.sysMemZRamWeight, totalMem.totalTime, totalPss, totalMem.sysMemSamples);
        pw.print("  TOTAL  : ");
        ProcessStats.printSizeValue(pw, totalPss);
        pw.println();
        this.printMemoryCategory(pw, "  ", STATE_NAMES[7], totalMem.processStateWeight[7], totalMem.totalTime, totalPss, totalMem.processStateSamples[7]);
        pw.println();
        pw.print("          Start time: ");
        pw.print(DateFormat.format((CharSequence)"yyyy-MM-dd HH:mm:ss", this.mTimePeriodStartClock));
        pw.println();
        pw.print("  Total elapsed time: ");
        TimeUtils.formatDuration((this.mRunning ? SystemClock.elapsedRealtime() : this.mTimePeriodEndRealtime) - this.mTimePeriodStartRealtime, pw);
        boolean partial = true;
        if ((this.mFlags & 2) != 0) {
            pw.print(" (shutdown)");
            partial = false;
        }
        if ((this.mFlags & 4) != 0) {
            pw.print(" (sysprops)");
            partial = false;
        }
        if ((this.mFlags & 1) != 0) {
            pw.print(" (complete)");
            partial = false;
        }
        if (partial) {
            pw.print(" (partial)");
        }
        pw.print(' ');
        pw.print(this.mRuntime);
        pw.println();
    }

    private final void $$robo$$com_android_internal_app_ProcessStats$dumpFilteredSummaryLocked(PrintWriter pw, String header, String prefix, int[] screenStates, int[] memStates, int[] procStates, int[] sortProcStates, long now, long totalTime, String reqPackage, boolean activeOnly) {
        ArrayList<ProcessState> procs = this.collectProcessesLocked(screenStates, memStates, procStates, sortProcStates, now, reqPackage, activeOnly);
        if (procs.size() > 0) {
            if (header != null) {
                pw.println();
                pw.println(header);
            }
            ProcessStats.dumpProcessSummaryLocked(pw, prefix, procs, screenStates, memStates, sortProcStates, true, now, totalTime);
        }
    }

    private final ArrayList<ProcessState> $$robo$$com_android_internal_app_ProcessStats$collectProcessesLocked(int[] screenStates, int[] memStates, int[] procStates, int[] sortProcStates, long now, String reqPackage, boolean activeOnly) {
        ArraySet<ProcessState> foundProcs = new ArraySet<ProcessState>();
        ArrayMap<String, SparseArray<SparseArray<PackageState>>> pkgMap = this.mPackages.getMap();
        for (int ip = 0; ip < pkgMap.size(); ++ip) {
            String pkgName = pkgMap.keyAt(ip);
            SparseArray<SparseArray<PackageState>> procs = pkgMap.valueAt(ip);
            for (int iu = 0; iu < procs.size(); ++iu) {
                SparseArray<PackageState> vpkgs = procs.valueAt(iu);
                int NVERS = vpkgs.size();
                for (int iv = 0; iv < NVERS; ++iv) {
                    PackageState state = vpkgs.valueAt(iv);
                    int NPROCS = state.mProcesses.size();
                    boolean pkgMatch = reqPackage == null || reqPackage.equals(pkgName);
                    for (int iproc = 0; iproc < NPROCS; ++iproc) {
                        ProcessState proc = state.mProcesses.valueAt(iproc);
                        if (!pkgMatch && !reqPackage.equals(proc.mName) || activeOnly && !proc.isInUse()) continue;
                        foundProcs.add(proc.mCommonProcess);
                    }
                }
            }
        }
        ArrayList<ProcessState> outProcs = new ArrayList<ProcessState>(foundProcs.size());
        for (int i = 0; i < foundProcs.size(); ++i) {
            ProcessState proc = (ProcessState)foundProcs.valueAt(i);
            if (ProcessStats.computeProcessTimeLocked(proc, screenStates, memStates, procStates, now) <= 0L) continue;
            outProcs.add(proc);
            if (procStates == sortProcStates) continue;
            ProcessStats.computeProcessTimeLocked(proc, screenStates, memStates, sortProcStates, now);
        }
        Collections.sort(outProcs, new Comparator<ProcessState>(this){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ ProcessStats this$0;

            private void $$robo$$com_android_internal_app_ProcessStats_2$__constructor__(ProcessStats processStats) {
            }

            private final int $$robo$$com_android_internal_app_ProcessStats_2$compare(ProcessState lhs, ProcessState rhs) {
                if (lhs.mTmpTotalTime < rhs.mTmpTotalTime) {
                    return -1;
                }
                if (lhs.mTmpTotalTime > rhs.mTmpTotalTime) {
                    return 1;
                }
                return 0;
            }

            private void __constructor__(ProcessStats processStats) {
                this.$$robo$$com_android_internal_app_ProcessStats_2$__constructor__(processStats);
            }
            {
                this.this$0 = processStats;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_app_ProcessStats_2$__constructor__(com.android.internal.app.ProcessStats ), 0, this, processStats);
            }

            @Override
            public int compare(ProcessState processState, ProcessState processState2) {
                return (int)InvokeDynamicSupport.bootstrap("compare", $$robo$$com_android_internal_app_ProcessStats_2$compare(com.android.internal.app.ProcessStats$ProcessState com.android.internal.app.ProcessStats$ProcessState ), 0, this, processState, processState2);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        });
        return outProcs;
    }

    private final String $$robo$$com_android_internal_app_ProcessStats$collapseString(String pkgName, String itemName) {
        if (itemName.startsWith(pkgName)) {
            int PKGLEN;
            int ITEMLEN = itemName.length();
            if (ITEMLEN == (PKGLEN = pkgName.length())) {
                return "";
            }
            if (ITEMLEN >= PKGLEN && itemName.charAt(PKGLEN) == '.') {
                return itemName.substring(PKGLEN);
            }
        }
        return itemName;
    }

    private final void $$robo$$com_android_internal_app_ProcessStats$dumpCheckinLocked(PrintWriter pw, String reqPackage) {
        long now = SystemClock.uptimeMillis();
        ArrayMap<String, SparseArray<SparseArray<PackageState>>> pkgMap = this.mPackages.getMap();
        pw.println("vers,5");
        pw.print("period,");
        pw.print(this.mTimePeriodStartClockStr);
        pw.print(",");
        pw.print(this.mTimePeriodStartRealtime);
        pw.print(",");
        pw.print(this.mRunning ? SystemClock.elapsedRealtime() : this.mTimePeriodEndRealtime);
        boolean partial = true;
        if ((this.mFlags & 2) != 0) {
            pw.print(",shutdown");
            partial = false;
        }
        if ((this.mFlags & 4) != 0) {
            pw.print(",sysprops");
            partial = false;
        }
        if ((this.mFlags & 1) != 0) {
            pw.print(",complete");
            partial = false;
        }
        if (partial) {
            pw.print(",partial");
        }
        pw.println();
        pw.print("config,");
        pw.println(this.mRuntime);
        for (int ip = 0; ip < pkgMap.size(); ++ip) {
            String pkgName = pkgMap.keyAt(ip);
            if (reqPackage != null && !reqPackage.equals(pkgName)) continue;
            SparseArray<SparseArray<PackageState>> uids = pkgMap.valueAt(ip);
            for (int iu = 0; iu < uids.size(); ++iu) {
                int uid = uids.keyAt(iu);
                SparseArray<PackageState> vpkgs = uids.valueAt(iu);
                for (int iv = 0; iv < vpkgs.size(); ++iv) {
                    int vers = vpkgs.keyAt(iv);
                    PackageState pkgState = vpkgs.valueAt(iv);
                    int NPROCS = pkgState.mProcesses.size();
                    int NSRVS = pkgState.mServices.size();
                    for (int iproc = 0; iproc < NPROCS; ++iproc) {
                        ProcessState proc = pkgState.mProcesses.valueAt(iproc);
                        pw.print("pkgproc,");
                        pw.print(pkgName);
                        pw.print(",");
                        pw.print(uid);
                        pw.print(",");
                        pw.print(vers);
                        pw.print(",");
                        pw.print(this.collapseString(pkgName, pkgState.mProcesses.keyAt(iproc)));
                        ProcessStats.dumpAllProcessStateCheckin(pw, proc, now);
                        pw.println();
                        if (proc.mPssTableSize > 0) {
                            pw.print("pkgpss,");
                            pw.print(pkgName);
                            pw.print(",");
                            pw.print(uid);
                            pw.print(",");
                            pw.print(vers);
                            pw.print(",");
                            pw.print(this.collapseString(pkgName, pkgState.mProcesses.keyAt(iproc)));
                            ProcessStats.dumpAllProcessPssCheckin(pw, proc);
                            pw.println();
                        }
                        if (proc.mNumExcessiveWake <= 0 && proc.mNumExcessiveCpu <= 0 && proc.mNumCachedKill <= 0) continue;
                        pw.print("pkgkills,");
                        pw.print(pkgName);
                        pw.print(",");
                        pw.print(uid);
                        pw.print(",");
                        pw.print(vers);
                        pw.print(",");
                        pw.print(this.collapseString(pkgName, pkgState.mProcesses.keyAt(iproc)));
                        pw.print(",");
                        pw.print(proc.mNumExcessiveWake);
                        pw.print(",");
                        pw.print(proc.mNumExcessiveCpu);
                        pw.print(",");
                        pw.print(proc.mNumCachedKill);
                        pw.print(",");
                        pw.print(proc.mMinCachedKillPss);
                        pw.print(":");
                        pw.print(proc.mAvgCachedKillPss);
                        pw.print(":");
                        pw.print(proc.mMaxCachedKillPss);
                        pw.println();
                    }
                    for (int isvc = 0; isvc < NSRVS; ++isvc) {
                        String serviceName = this.collapseString(pkgName, pkgState.mServices.keyAt(isvc));
                        ServiceState svc = pkgState.mServices.valueAt(isvc);
                        ProcessStats.dumpServiceTimeCheckin(pw, "pkgsvc-run", pkgName, uid, vers, serviceName, svc, 0, svc.mRunCount, svc.mRunState, svc.mRunStartTime, now);
                        ProcessStats.dumpServiceTimeCheckin(pw, "pkgsvc-start", pkgName, uid, vers, serviceName, svc, 1, svc.mStartedCount, svc.mStartedState, svc.mStartedStartTime, now);
                        ProcessStats.dumpServiceTimeCheckin(pw, "pkgsvc-bound", pkgName, uid, vers, serviceName, svc, 2, svc.mBoundCount, svc.mBoundState, svc.mBoundStartTime, now);
                        ProcessStats.dumpServiceTimeCheckin(pw, "pkgsvc-exec", pkgName, uid, vers, serviceName, svc, 3, svc.mExecCount, svc.mExecState, svc.mExecStartTime, now);
                    }
                }
            }
        }
        ArrayMap<String, SparseArray<ProcessState>> procMap = this.mProcesses.getMap();
        for (int ip = 0; ip < procMap.size(); ++ip) {
            String procName = procMap.keyAt(ip);
            SparseArray<ProcessState> uids = procMap.valueAt(ip);
            for (int iu = 0; iu < uids.size(); ++iu) {
                int uid = uids.keyAt(iu);
                ProcessState procState = uids.valueAt(iu);
                if (procState.mDurationsTableSize > 0) {
                    pw.print("proc,");
                    pw.print(procName);
                    pw.print(",");
                    pw.print(uid);
                    ProcessStats.dumpAllProcessStateCheckin(pw, procState, now);
                    pw.println();
                }
                if (procState.mPssTableSize > 0) {
                    pw.print("pss,");
                    pw.print(procName);
                    pw.print(",");
                    pw.print(uid);
                    ProcessStats.dumpAllProcessPssCheckin(pw, procState);
                    pw.println();
                }
                if (procState.mNumExcessiveWake <= 0 && procState.mNumExcessiveCpu <= 0 && procState.mNumCachedKill <= 0) continue;
                pw.print("kills,");
                pw.print(procName);
                pw.print(",");
                pw.print(uid);
                pw.print(",");
                pw.print(procState.mNumExcessiveWake);
                pw.print(",");
                pw.print(procState.mNumExcessiveCpu);
                pw.print(",");
                pw.print(procState.mNumCachedKill);
                pw.print(",");
                pw.print(procState.mMinCachedKillPss);
                pw.print(":");
                pw.print(procState.mAvgCachedKillPss);
                pw.print(":");
                pw.print(procState.mMaxCachedKillPss);
                pw.println();
            }
        }
        pw.print("total");
        ProcessStats.dumpAdjTimesCheckin(pw, ",", this.mMemFactorDurations, this.mMemFactor, this.mStartTime, now);
        if (this.mSysMemUsageTable != null) {
            pw.print("sysmemusage");
            for (int i = 0; i < this.mSysMemUsageTableSize; ++i) {
                int off = this.mSysMemUsageTable[i];
                int type = off >> OFFSET_TYPE_SHIFT & OFFSET_TYPE_MASK;
                pw.print(",");
                ProcessStats.printProcStateTag(pw, type);
                for (int j = 0; j < 16; ++j) {
                    if (j > 1) {
                        pw.print(":");
                    }
                    pw.print(this.getLong(off, j));
                }
            }
        }
        pw.println();
        TotalMemoryUseCollection totalMem = new TotalMemoryUseCollection(ALL_SCREEN_ADJ, ALL_MEM_ADJ);
        this.computeTotalMemoryUse(totalMem, now);
        pw.print("weights,");
        pw.print(totalMem.totalTime);
        pw.print(",");
        pw.print(totalMem.sysMemCachedWeight);
        pw.print(":");
        pw.print(totalMem.sysMemSamples);
        pw.print(",");
        pw.print(totalMem.sysMemFreeWeight);
        pw.print(":");
        pw.print(totalMem.sysMemSamples);
        pw.print(",");
        pw.print(totalMem.sysMemZRamWeight);
        pw.print(":");
        pw.print(totalMem.sysMemSamples);
        pw.print(",");
        pw.print(totalMem.sysMemKernelWeight);
        pw.print(":");
        pw.print(totalMem.sysMemSamples);
        pw.print(",");
        pw.print(totalMem.sysMemNativeWeight);
        pw.print(":");
        pw.print(totalMem.sysMemSamples);
        for (int i = 0; i < 14; ++i) {
            pw.print(",");
            pw.print(totalMem.processStateWeight[i]);
            pw.print(":");
            pw.print(totalMem.processStateSamples[i]);
        }
        pw.println();
    }

    static void __staticInitializer__() {
        COMMIT_PERIOD = 10800000L;
        COMMIT_UPTIME_PERIOD = 3600000L;
        ALL_MEM_ADJ = new int[]{0, 1, 2, 3};
        ALL_SCREEN_ADJ = new int[]{0, 4};
        NON_CACHED_PROC_STATES = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8};
        BACKGROUND_PROC_STATES = new int[]{2, 3, 4, 5, 6, 7, 8};
        PROCESS_STATE_TO_STATE = new int[]{0, 0, 1, 2, 3, 4, 5, 6, 8, 9, 10, 11, 12, 13};
        ALL_PROC_STATES = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13};
        STATE_NAMES = new String[]{"Persist", "Top    ", "ImpFg  ", "ImpBg  ", "Backup ", "HeavyWt", "Service", "ServRst", "Receivr", "Home   ", "LastAct", "CchAct ", "CchCAct", "CchEmty"};
        ADJ_SCREEN_NAMES_CSV = new String[]{"off", "on"};
        ADJ_MEM_NAMES_CSV = new String[]{"norm", "mod", "low", "crit"};
        STATE_NAMES_CSV = new String[]{"pers", "top", "impfg", "impbg", "backup", "heavy", "service", "service-rs", "receiver", "home", "lastact", "cch-activity", "cch-aclient", "cch-empty"};
        ADJ_SCREEN_TAGS = new String[]{"0", "1"};
        ADJ_MEM_TAGS = new String[]{"n", "m", "l", "c"};
        STATE_TAGS = new String[]{"p", "t", "f", "b", "u", "w", "s", "x", "r", "h", "l", "a", "c", "e"};
        OFFSET_TYPE_SHIFT = 0;
        OFFSET_TYPE_MASK = 255;
        OFFSET_ARRAY_SHIFT = 8;
        OFFSET_ARRAY_MASK = 255;
        OFFSET_INDEX_SHIFT = 16;
        OFFSET_INDEX_MASK = 65535;
        CREATOR = new Parcelable.Creator<ProcessStats>(){
            public transient /* synthetic */ Object __robo_data__;

            private void $$robo$$com_android_internal_app_ProcessStats_1$__constructor__() {
            }

            private final ProcessStats $$robo$$com_android_internal_app_ProcessStats_1$createFromParcel(Parcel in) {
                return new ProcessStats(in);
            }

            private final ProcessStats[] $$robo$$com_android_internal_app_ProcessStats_1$newArray(int size) {
                return new ProcessStats[size];
            }

            private void __constructor__() {
                this.$$robo$$com_android_internal_app_ProcessStats_1$__constructor__();
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_app_ProcessStats_1$__constructor__(), 0, this);
            }

            @Override
            public ProcessStats createFromParcel(Parcel parcel) {
                return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$com_android_internal_app_ProcessStats_1$createFromParcel(android.os.Parcel ), 0, this, parcel);
            }

            public ProcessStats[] newArray(int n) {
                return InvokeDynamicSupport.bootstrap("newArray", $$robo$$com_android_internal_app_ProcessStats_1$newArray(int ), 0, this, n);
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        BAD_TABLE = new int[0];
    }

    private void __constructor__(boolean bl) {
        this.$$robo$$com_android_internal_app_ProcessStats$__constructor__(bl);
    }

    public ProcessStats(boolean bl) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_app_ProcessStats$__constructor__(boolean ), 0, this, bl);
    }

    private void __constructor__(Parcel parcel) {
        this.$$robo$$com_android_internal_app_ProcessStats$__constructor__(parcel);
    }

    public ProcessStats(Parcel parcel) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_app_ProcessStats$__constructor__(android.os.Parcel ), 0, this, parcel);
    }

    public void add(ProcessStats processStats) {
        InvokeDynamicSupport.bootstrap("add", $$robo$$com_android_internal_app_ProcessStats$add(com.android.internal.app.ProcessStats ), 0, this, processStats);
    }

    public void addSysMemUsage(long l, long l2, long l3, long l4, long l5) {
        InvokeDynamicSupport.bootstrap("addSysMemUsage", $$robo$$com_android_internal_app_ProcessStats$addSysMemUsage(long long long long long ), 0, this, l, l2, l3, l4, l5);
    }

    void addSysMemUsage(int n, long[] lArray, int n2) {
        InvokeDynamicSupport.bootstrap("addSysMemUsage", $$robo$$com_android_internal_app_ProcessStats$addSysMemUsage(int long[] int ), 0, this, n, lArray, n2);
    }

    static void addSysMemUsage(long[] lArray, int n, long[] lArray2, int n2) {
        InvokeDynamicSupport.bootstrapStatic("addSysMemUsage", $$robo$$com_android_internal_app_ProcessStats$addSysMemUsage(long[] int long[] int ), 0, (long[])lArray, (int)n, (long[])lArray2, (int)n2);
    }

    private static void printScreenLabel(PrintWriter printWriter, int n) {
        InvokeDynamicSupport.bootstrapStatic("printScreenLabel", $$robo$$com_android_internal_app_ProcessStats$printScreenLabel(java.io.PrintWriter int ), 0, (PrintWriter)printWriter, (int)n);
    }

    public static void printScreenLabelCsv(PrintWriter printWriter, int n) {
        InvokeDynamicSupport.bootstrapStatic("printScreenLabelCsv", $$robo$$com_android_internal_app_ProcessStats$printScreenLabelCsv(java.io.PrintWriter int ), 0, (PrintWriter)printWriter, (int)n);
    }

    private static void printMemLabel(PrintWriter printWriter, int n, char c) {
        InvokeDynamicSupport.bootstrapStatic("printMemLabel", $$robo$$com_android_internal_app_ProcessStats$printMemLabel(java.io.PrintWriter int char ), 0, (PrintWriter)printWriter, (int)n, (char)c);
    }

    public static void printMemLabelCsv(PrintWriter printWriter, int n) {
        InvokeDynamicSupport.bootstrapStatic("printMemLabelCsv", $$robo$$com_android_internal_app_ProcessStats$printMemLabelCsv(java.io.PrintWriter int ), 0, (PrintWriter)printWriter, (int)n);
    }

    public static long dumpSingleTime(PrintWriter printWriter, String string2, long[] lArray, int n, long l, long l2) {
        return (long)InvokeDynamicSupport.bootstrapStatic("dumpSingleTime", $$robo$$com_android_internal_app_ProcessStats$dumpSingleTime(java.io.PrintWriter java.lang.String long[] int long long ), 0, (PrintWriter)printWriter, (String)string2, (long[])lArray, (int)n, (long)l, (long)l2);
    }

    static void dumpAdjTimesCheckin(PrintWriter printWriter, String string2, long[] lArray, int n, long l, long l2) {
        InvokeDynamicSupport.bootstrapStatic("dumpAdjTimesCheckin", $$robo$$com_android_internal_app_ProcessStats$dumpAdjTimesCheckin(java.io.PrintWriter java.lang.String long[] int long long ), 0, (PrintWriter)printWriter, (String)string2, (long[])lArray, (int)n, (long)l, (long)l2);
    }

    static void dumpServiceTimeCheckin(PrintWriter printWriter, String string2, String string3, int n, int n2, String string4, ServiceState serviceState, int n3, int n4, int n5, long l, long l2) {
        InvokeDynamicSupport.bootstrapStatic("dumpServiceTimeCheckin", $$robo$$com_android_internal_app_ProcessStats$dumpServiceTimeCheckin(java.io.PrintWriter java.lang.String java.lang.String int int java.lang.String com.android.internal.app.ProcessStats$ServiceState int int int long long ), 0, (PrintWriter)printWriter, (String)string2, (String)string3, (int)n, (int)n2, (String)string4, (ServiceState)serviceState, (int)n3, (int)n4, (int)n5, (long)l, (long)l2);
    }

    public static void computeProcessData(ProcessState processState, ProcessDataCollection processDataCollection, long l) {
        InvokeDynamicSupport.bootstrapStatic("computeProcessData", $$robo$$com_android_internal_app_ProcessStats$computeProcessData(com.android.internal.app.ProcessStats$ProcessState com.android.internal.app.ProcessStats$ProcessDataCollection long ), 0, (ProcessState)processState, (ProcessDataCollection)processDataCollection, (long)l);
    }

    static long computeProcessTimeLocked(ProcessState processState, int[] nArray, int[] nArray2, int[] nArray3, long l) {
        return (long)InvokeDynamicSupport.bootstrapStatic("computeProcessTimeLocked", $$robo$$com_android_internal_app_ProcessStats$computeProcessTimeLocked(com.android.internal.app.ProcessStats$ProcessState int[] int[] int[] long ), 0, (ProcessState)processState, (int[])nArray, (int[])nArray2, (int[])nArray3, (long)l);
    }

    public void computeTotalMemoryUse(TotalMemoryUseCollection totalMemoryUseCollection, long l) {
        InvokeDynamicSupport.bootstrap("computeTotalMemoryUse", $$robo$$com_android_internal_app_ProcessStats$computeTotalMemoryUse(com.android.internal.app.ProcessStats$TotalMemoryUseCollection long ), 0, this, totalMemoryUseCollection, l);
    }

    static void dumpProcessState(PrintWriter printWriter, String string2, ProcessState processState, int[] nArray, int[] nArray2, int[] nArray3, long l) {
        InvokeDynamicSupport.bootstrapStatic("dumpProcessState", $$robo$$com_android_internal_app_ProcessStats$dumpProcessState(java.io.PrintWriter java.lang.String com.android.internal.app.ProcessStats$ProcessState int[] int[] int[] long ), 0, (PrintWriter)printWriter, (String)string2, (ProcessState)processState, (int[])nArray, (int[])nArray2, (int[])nArray3, (long)l);
    }

    static void dumpProcessPss(PrintWriter printWriter, String string2, ProcessState processState, int[] nArray, int[] nArray2, int[] nArray3) {
        InvokeDynamicSupport.bootstrapStatic("dumpProcessPss", $$robo$$com_android_internal_app_ProcessStats$dumpProcessPss(java.io.PrintWriter java.lang.String com.android.internal.app.ProcessStats$ProcessState int[] int[] int[] ), 0, (PrintWriter)printWriter, (String)string2, (ProcessState)processState, (int[])nArray, (int[])nArray2, (int[])nArray3);
    }

    long getSysMemUsageValue(int n, int n2) {
        return (long)InvokeDynamicSupport.bootstrap("getSysMemUsageValue", $$robo$$com_android_internal_app_ProcessStats$getSysMemUsageValue(int int ), 0, this, n, n2);
    }

    void dumpSysMemUsageCategory(PrintWriter printWriter, String string2, String string3, int n, int n2) {
        InvokeDynamicSupport.bootstrap("dumpSysMemUsageCategory", $$robo$$com_android_internal_app_ProcessStats$dumpSysMemUsageCategory(java.io.PrintWriter java.lang.String java.lang.String int int ), 0, this, printWriter, string2, string3, n, n2);
    }

    void dumpSysMemUsage(PrintWriter printWriter, String string2, int[] nArray, int[] nArray2) {
        InvokeDynamicSupport.bootstrap("dumpSysMemUsage", $$robo$$com_android_internal_app_ProcessStats$dumpSysMemUsage(java.io.PrintWriter java.lang.String int[] int[] ), 0, this, printWriter, string2, nArray, nArray2);
    }

    static void dumpStateHeadersCsv(PrintWriter printWriter, String string2, int[] nArray, int[] nArray2, int[] nArray3) {
        InvokeDynamicSupport.bootstrapStatic("dumpStateHeadersCsv", $$robo$$com_android_internal_app_ProcessStats$dumpStateHeadersCsv(java.io.PrintWriter java.lang.String int[] int[] int[] ), 0, (PrintWriter)printWriter, (String)string2, (int[])nArray, (int[])nArray2, (int[])nArray3);
    }

    static void dumpProcessStateCsv(PrintWriter printWriter, ProcessState processState, boolean bl, int[] nArray, boolean bl2, int[] nArray2, boolean bl3, int[] nArray3, long l) {
        InvokeDynamicSupport.bootstrapStatic("dumpProcessStateCsv", $$robo$$com_android_internal_app_ProcessStats$dumpProcessStateCsv(java.io.PrintWriter com.android.internal.app.ProcessStats$ProcessState boolean int[] boolean int[] boolean int[] long ), 0, (PrintWriter)printWriter, (ProcessState)processState, (boolean)bl, (int[])nArray, (boolean)bl2, (int[])nArray2, (boolean)bl3, (int[])nArray3, (long)l);
    }

    static void dumpProcessList(PrintWriter printWriter, String string2, ArrayList<ProcessState> arrayList, int[] nArray, int[] nArray2, int[] nArray3, long l) {
        InvokeDynamicSupport.bootstrapStatic("dumpProcessList", $$robo$$com_android_internal_app_ProcessStats$dumpProcessList(java.io.PrintWriter java.lang.String java.util.ArrayList<com.android.internal.app.ProcessStats$ProcessState> int[] int[] int[] long ), 0, (PrintWriter)printWriter, (String)string2, arrayList, (int[])nArray, (int[])nArray2, (int[])nArray3, (long)l);
    }

    static void dumpProcessSummaryDetails(PrintWriter printWriter, ProcessState processState, String string2, String string3, int[] nArray, int[] nArray2, int[] nArray3, long l, long l2, boolean bl) {
        InvokeDynamicSupport.bootstrapStatic("dumpProcessSummaryDetails", $$robo$$com_android_internal_app_ProcessStats$dumpProcessSummaryDetails(java.io.PrintWriter com.android.internal.app.ProcessStats$ProcessState java.lang.String java.lang.String int[] int[] int[] long long boolean ), 0, (PrintWriter)printWriter, (ProcessState)processState, (String)string2, (String)string3, (int[])nArray, (int[])nArray2, (int[])nArray3, (long)l, (long)l2, (boolean)bl);
    }

    static void dumpProcessSummaryLocked(PrintWriter printWriter, String string2, ArrayList<ProcessState> arrayList, int[] nArray, int[] nArray2, int[] nArray3, boolean bl, long l, long l2) {
        InvokeDynamicSupport.bootstrapStatic("dumpProcessSummaryLocked", $$robo$$com_android_internal_app_ProcessStats$dumpProcessSummaryLocked(java.io.PrintWriter java.lang.String java.util.ArrayList<com.android.internal.app.ProcessStats$ProcessState> int[] int[] int[] boolean long long ), 0, (PrintWriter)printWriter, (String)string2, arrayList, (int[])nArray, (int[])nArray2, (int[])nArray3, (boolean)bl, (long)l, (long)l2);
    }

    static void printPercent(PrintWriter printWriter, double d) {
        InvokeDynamicSupport.bootstrapStatic("printPercent", $$robo$$com_android_internal_app_ProcessStats$printPercent(java.io.PrintWriter double ), 0, (PrintWriter)printWriter, (double)d);
    }

    static void printSizeValue(PrintWriter printWriter, long l) {
        InvokeDynamicSupport.bootstrapStatic("printSizeValue", $$robo$$com_android_internal_app_ProcessStats$printSizeValue(java.io.PrintWriter long ), 0, (PrintWriter)printWriter, (long)l);
    }

    public static void dumpProcessListCsv(PrintWriter printWriter, ArrayList<ProcessState> arrayList, boolean bl, int[] nArray, boolean bl2, int[] nArray2, boolean bl3, int[] nArray3, long l) {
        InvokeDynamicSupport.bootstrapStatic("dumpProcessListCsv", $$robo$$com_android_internal_app_ProcessStats$dumpProcessListCsv(java.io.PrintWriter java.util.ArrayList<com.android.internal.app.ProcessStats$ProcessState> boolean int[] boolean int[] boolean int[] long ), 0, (PrintWriter)printWriter, arrayList, (boolean)bl, (int[])nArray, (boolean)bl2, (int[])nArray2, (boolean)bl3, (int[])nArray3, (long)l);
    }

    static int printArrayEntry(PrintWriter printWriter, String[] stringArray, int n, int n2) {
        return (int)InvokeDynamicSupport.bootstrapStatic("printArrayEntry", $$robo$$com_android_internal_app_ProcessStats$printArrayEntry(java.io.PrintWriter java.lang.String[] int int ), 0, (PrintWriter)printWriter, (String[])stringArray, (int)n, (int)n2);
    }

    static void printProcStateTag(PrintWriter printWriter, int n) {
        InvokeDynamicSupport.bootstrapStatic("printProcStateTag", $$robo$$com_android_internal_app_ProcessStats$printProcStateTag(java.io.PrintWriter int ), 0, (PrintWriter)printWriter, (int)n);
    }

    static void printAdjTag(PrintWriter printWriter, int n) {
        InvokeDynamicSupport.bootstrapStatic("printAdjTag", $$robo$$com_android_internal_app_ProcessStats$printAdjTag(java.io.PrintWriter int ), 0, (PrintWriter)printWriter, (int)n);
    }

    static void printProcStateTagAndValue(PrintWriter printWriter, int n, long l) {
        InvokeDynamicSupport.bootstrapStatic("printProcStateTagAndValue", $$robo$$com_android_internal_app_ProcessStats$printProcStateTagAndValue(java.io.PrintWriter int long ), 0, (PrintWriter)printWriter, (int)n, (long)l);
    }

    static void printAdjTagAndValue(PrintWriter printWriter, int n, long l) {
        InvokeDynamicSupport.bootstrapStatic("printAdjTagAndValue", $$robo$$com_android_internal_app_ProcessStats$printAdjTagAndValue(java.io.PrintWriter int long ), 0, (PrintWriter)printWriter, (int)n, (long)l);
    }

    static void dumpAllProcessStateCheckin(PrintWriter printWriter, ProcessState processState, long l) {
        InvokeDynamicSupport.bootstrapStatic("dumpAllProcessStateCheckin", $$robo$$com_android_internal_app_ProcessStats$dumpAllProcessStateCheckin(java.io.PrintWriter com.android.internal.app.ProcessStats$ProcessState long ), 0, (PrintWriter)printWriter, (ProcessState)processState, (long)l);
    }

    static void dumpAllProcessPssCheckin(PrintWriter printWriter, ProcessState processState) {
        InvokeDynamicSupport.bootstrapStatic("dumpAllProcessPssCheckin", $$robo$$com_android_internal_app_ProcessStats$dumpAllProcessPssCheckin(java.io.PrintWriter com.android.internal.app.ProcessStats$ProcessState ), 0, (PrintWriter)printWriter, (ProcessState)processState);
    }

    public void reset() {
        InvokeDynamicSupport.bootstrap("reset", $$robo$$com_android_internal_app_ProcessStats$reset(), 0, this);
    }

    public void resetSafely() {
        InvokeDynamicSupport.bootstrap("resetSafely", $$robo$$com_android_internal_app_ProcessStats$resetSafely(), 0, this);
    }

    private void resetCommon() {
        InvokeDynamicSupport.bootstrap("resetCommon", $$robo$$com_android_internal_app_ProcessStats$resetCommon(), 0, this);
    }

    public boolean evaluateSystemProperties(boolean bl) {
        return (boolean)InvokeDynamicSupport.bootstrap("evaluateSystemProperties", $$robo$$com_android_internal_app_ProcessStats$evaluateSystemProperties(boolean ), 0, this, bl);
    }

    private void buildTimePeriodStartClockStr() {
        InvokeDynamicSupport.bootstrap("buildTimePeriodStartClockStr", $$robo$$com_android_internal_app_ProcessStats$buildTimePeriodStartClockStr(), 0, this);
    }

    private int[] readTableFromParcel(Parcel parcel, String string2, String string3) {
        return InvokeDynamicSupport.bootstrap("readTableFromParcel", $$robo$$com_android_internal_app_ProcessStats$readTableFromParcel(android.os.Parcel java.lang.String java.lang.String ), 0, this, parcel, string2, string3);
    }

    private void writeCompactedLongArray(Parcel parcel, long[] lArray, int n) {
        InvokeDynamicSupport.bootstrap("writeCompactedLongArray", $$robo$$com_android_internal_app_ProcessStats$writeCompactedLongArray(android.os.Parcel long[] int ), 0, this, parcel, lArray, n);
    }

    private void readCompactedLongArray(Parcel parcel, int n, long[] lArray, int n2) {
        InvokeDynamicSupport.bootstrap("readCompactedLongArray", $$robo$$com_android_internal_app_ProcessStats$readCompactedLongArray(android.os.Parcel int long[] int ), 0, this, parcel, n, lArray, n2);
    }

    private void writeCommonString(Parcel parcel, String string2) {
        InvokeDynamicSupport.bootstrap("writeCommonString", $$robo$$com_android_internal_app_ProcessStats$writeCommonString(android.os.Parcel java.lang.String ), 0, this, parcel, string2);
    }

    private String readCommonString(Parcel parcel, int n) {
        return InvokeDynamicSupport.bootstrap("readCommonString", $$robo$$com_android_internal_app_ProcessStats$readCommonString(android.os.Parcel int ), 0, this, parcel, n);
    }

    @Override
    public int describeContents() {
        return (int)InvokeDynamicSupport.bootstrap("describeContents", $$robo$$com_android_internal_app_ProcessStats$describeContents(), 0, this);
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$com_android_internal_app_ProcessStats$writeToParcel(android.os.Parcel int ), 0, this, parcel, n);
    }

    public void writeToParcel(Parcel parcel, long l, int n) {
        InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$com_android_internal_app_ProcessStats$writeToParcel(android.os.Parcel long int ), 0, this, parcel, l, n);
    }

    private boolean readCheckedInt(Parcel parcel, int n, String string2) {
        return (boolean)InvokeDynamicSupport.bootstrap("readCheckedInt", $$robo$$com_android_internal_app_ProcessStats$readCheckedInt(android.os.Parcel int java.lang.String ), 0, this, parcel, n, string2);
    }

    static byte[] readFully(InputStream inputStream, int[] nArray) throws IOException {
        return InvokeDynamicSupport.bootstrapStatic("readFully", $$robo$$com_android_internal_app_ProcessStats$readFully(java.io.InputStream int[] ), 0, (InputStream)inputStream, (int[])nArray);
    }

    public void read(InputStream inputStream) {
        InvokeDynamicSupport.bootstrap("read", $$robo$$com_android_internal_app_ProcessStats$read(java.io.InputStream ), 0, this, inputStream);
    }

    public void readFromParcel(Parcel parcel) {
        InvokeDynamicSupport.bootstrap("readFromParcel", $$robo$$com_android_internal_app_ProcessStats$readFromParcel(android.os.Parcel ), 0, this, parcel);
    }

    int addLongData(int n, int n2, int n3) {
        return (int)InvokeDynamicSupport.bootstrap("addLongData", $$robo$$com_android_internal_app_ProcessStats$addLongData(int int int ), 0, this, n, n2, n3);
    }

    int allocLongData(int n) {
        return (int)InvokeDynamicSupport.bootstrap("allocLongData", $$robo$$com_android_internal_app_ProcessStats$allocLongData(int ), 0, this, n);
    }

    boolean validateLongOffset(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("validateLongOffset", $$robo$$com_android_internal_app_ProcessStats$validateLongOffset(int ), 0, this, n);
    }

    static String printLongOffset(int n) {
        return InvokeDynamicSupport.bootstrapStatic("printLongOffset", $$robo$$com_android_internal_app_ProcessStats$printLongOffset(int ), 0, (int)n);
    }

    void setLong(int n, int n2, long l) {
        InvokeDynamicSupport.bootstrap("setLong", $$robo$$com_android_internal_app_ProcessStats$setLong(int int long ), 0, this, n, n2, l);
    }

    long getLong(int n, int n2) {
        return (long)InvokeDynamicSupport.bootstrap("getLong", $$robo$$com_android_internal_app_ProcessStats$getLong(int int ), 0, this, n, n2);
    }

    static int binarySearch(int[] nArray, int n, int n2) {
        return (int)InvokeDynamicSupport.bootstrapStatic("binarySearch", $$robo$$com_android_internal_app_ProcessStats$binarySearch(int[] int int ), 0, (int[])nArray, (int)n, (int)n2);
    }

    public PackageState getPackageStateLocked(String string2, int n, int n2) {
        return InvokeDynamicSupport.bootstrap("getPackageStateLocked", $$robo$$com_android_internal_app_ProcessStats$getPackageStateLocked(java.lang.String int int ), 0, this, string2, n, n2);
    }

    public ProcessState getProcessStateLocked(String string2, int n, int n2, String string3) {
        return InvokeDynamicSupport.bootstrap("getProcessStateLocked", $$robo$$com_android_internal_app_ProcessStats$getProcessStateLocked(java.lang.String int int java.lang.String ), 0, this, string2, n, n2, string3);
    }

    public ServiceState getServiceStateLocked(String string2, int n, int n2, String string3, String string4) {
        return InvokeDynamicSupport.bootstrap("getServiceStateLocked", $$robo$$com_android_internal_app_ProcessStats$getServiceStateLocked(java.lang.String int int java.lang.String java.lang.String ), 0, this, string2, n, n2, string3, string4);
    }

    private void dumpProcessInternalLocked(PrintWriter printWriter, String string2, ProcessState processState, boolean bl) {
        InvokeDynamicSupport.bootstrap("dumpProcessInternalLocked", $$robo$$com_android_internal_app_ProcessStats$dumpProcessInternalLocked(java.io.PrintWriter java.lang.String com.android.internal.app.ProcessStats$ProcessState boolean ), 0, this, printWriter, string2, processState, bl);
    }

    public void dumpLocked(PrintWriter printWriter, String string2, long l, boolean bl, boolean bl2, boolean bl3) {
        InvokeDynamicSupport.bootstrap("dumpLocked", $$robo$$com_android_internal_app_ProcessStats$dumpLocked(java.io.PrintWriter java.lang.String long boolean boolean boolean ), 0, this, printWriter, string2, l, bl, bl2, bl3);
    }

    public static long dumpSingleServiceTime(PrintWriter printWriter, String string2, ServiceState serviceState, int n, int n2, long l, long l2) {
        return (long)InvokeDynamicSupport.bootstrapStatic("dumpSingleServiceTime", $$robo$$com_android_internal_app_ProcessStats$dumpSingleServiceTime(java.io.PrintWriter java.lang.String com.android.internal.app.ProcessStats$ServiceState int int long long ), 0, (PrintWriter)printWriter, (String)string2, (ServiceState)serviceState, (int)n, (int)n2, (long)l, (long)l2);
    }

    void dumpServiceStats(PrintWriter printWriter, String string2, String string3, String string4, String string5, ServiceState serviceState, int n, int n2, int n3, long l, long l2, long l3, boolean bl) {
        InvokeDynamicSupport.bootstrap("dumpServiceStats", $$robo$$com_android_internal_app_ProcessStats$dumpServiceStats(java.io.PrintWriter java.lang.String java.lang.String java.lang.String java.lang.String com.android.internal.app.ProcessStats$ServiceState int int int long long long boolean ), 0, this, printWriter, string2, string3, string4, string5, serviceState, n, n2, n3, l, l2, l3, bl);
    }

    public void dumpSummaryLocked(PrintWriter printWriter, String string2, long l, boolean bl) {
        InvokeDynamicSupport.bootstrap("dumpSummaryLocked", $$robo$$com_android_internal_app_ProcessStats$dumpSummaryLocked(java.io.PrintWriter java.lang.String long boolean ), 0, this, printWriter, string2, l, bl);
    }

    long printMemoryCategory(PrintWriter printWriter, String string2, String string3, double d, long l, long l2, int n) {
        return (long)InvokeDynamicSupport.bootstrap("printMemoryCategory", $$robo$$com_android_internal_app_ProcessStats$printMemoryCategory(java.io.PrintWriter java.lang.String java.lang.String double long long int ), 0, this, printWriter, string2, string3, d, l, l2, n);
    }

    void dumpTotalsLocked(PrintWriter printWriter, long l) {
        InvokeDynamicSupport.bootstrap("dumpTotalsLocked", $$robo$$com_android_internal_app_ProcessStats$dumpTotalsLocked(java.io.PrintWriter long ), 0, this, printWriter, l);
    }

    void dumpFilteredSummaryLocked(PrintWriter printWriter, String string2, String string3, int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4, long l, long l2, String string4, boolean bl) {
        InvokeDynamicSupport.bootstrap("dumpFilteredSummaryLocked", $$robo$$com_android_internal_app_ProcessStats$dumpFilteredSummaryLocked(java.io.PrintWriter java.lang.String java.lang.String int[] int[] int[] int[] long long java.lang.String boolean ), 0, this, printWriter, string2, string3, nArray, nArray2, nArray3, nArray4, l, l2, string4, bl);
    }

    public ArrayList<ProcessState> collectProcessesLocked(int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4, long l, String string2, boolean bl) {
        return InvokeDynamicSupport.bootstrap("collectProcessesLocked", $$robo$$com_android_internal_app_ProcessStats$collectProcessesLocked(int[] int[] int[] int[] long java.lang.String boolean ), 0, this, nArray, nArray2, nArray3, nArray4, l, string2, bl);
    }

    String collapseString(String string2, String string3) {
        return InvokeDynamicSupport.bootstrap("collapseString", $$robo$$com_android_internal_app_ProcessStats$collapseString(java.lang.String java.lang.String ), 0, this, string2, string3);
    }

    public void dumpCheckinLocked(PrintWriter printWriter, String string2) {
        InvokeDynamicSupport.bootstrap("dumpCheckinLocked", $$robo$$com_android_internal_app_ProcessStats$dumpCheckinLocked(java.io.PrintWriter java.lang.String ), 0, this, printWriter, string2);
    }

    static {
        RobolectricInternals.classInitializing(ProcessStats.class);
    }

    public /* synthetic */ ProcessStats() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ProcessStats)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static class TotalMemoryUseCollection
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        int[] screenStates;
        int[] memStates;
        public long totalTime;
        public long[] processStatePss;
        public double[] processStateWeight;
        public long[] processStateTime;
        public int[] processStateSamples;
        public long[] sysMemUsage;
        public double sysMemCachedWeight;
        public double sysMemFreeWeight;
        public double sysMemZRamWeight;
        public double sysMemKernelWeight;
        public double sysMemNativeWeight;
        public int sysMemSamples;

        private void $$robo$$com_android_internal_app_ProcessStats_TotalMemoryUseCollection$__constructor__(int[] _screenStates, int[] _memStates) {
            this.processStatePss = new long[14];
            this.processStateWeight = new double[14];
            this.processStateTime = new long[14];
            this.processStateSamples = new int[14];
            this.sysMemUsage = new long[16];
            this.screenStates = _screenStates;
            this.memStates = _memStates;
        }

        private void __constructor__(int[] nArray, int[] nArray2) {
            this.$$robo$$com_android_internal_app_ProcessStats_TotalMemoryUseCollection$__constructor__(nArray, nArray2);
        }

        public TotalMemoryUseCollection(int[] nArray, int[] nArray2) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_app_ProcessStats_TotalMemoryUseCollection$__constructor__(int[] int[] ), 0, this, nArray, nArray2);
        }

        public /* synthetic */ TotalMemoryUseCollection() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (TotalMemoryUseCollection)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public static final class ProcessDataCollection
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        int[] screenStates;
        int[] memStates;
        int[] procStates;
        public long totalTime;
        public long numPss;
        public long minPss;
        public long avgPss;
        public long maxPss;
        public long minUss;
        public long avgUss;
        public long maxUss;

        private void $$robo$$com_android_internal_app_ProcessStats_ProcessDataCollection$__constructor__(int[] _screenStates, int[] _memStates, int[] _procStates) {
            this.screenStates = _screenStates;
            this.memStates = _memStates;
            this.procStates = _procStates;
        }

        private final void $$robo$$com_android_internal_app_ProcessStats_ProcessDataCollection$print(PrintWriter pw, long overallTime, boolean full) {
            if (this.totalTime > overallTime) {
                pw.print("*");
            }
            ProcessStats.printPercent(pw, (double)this.totalTime / (double)overallTime);
            if (this.numPss > 0L) {
                pw.print(" (");
                ProcessStats.printSizeValue(pw, this.minPss * 1024L);
                pw.print("-");
                ProcessStats.printSizeValue(pw, this.avgPss * 1024L);
                pw.print("-");
                ProcessStats.printSizeValue(pw, this.maxPss * 1024L);
                pw.print("/");
                ProcessStats.printSizeValue(pw, this.minUss * 1024L);
                pw.print("-");
                ProcessStats.printSizeValue(pw, this.avgUss * 1024L);
                pw.print("-");
                ProcessStats.printSizeValue(pw, this.maxUss * 1024L);
                if (full) {
                    pw.print(" over ");
                    pw.print(this.numPss);
                }
                pw.print(")");
            }
        }

        private void __constructor__(int[] nArray, int[] nArray2, int[] nArray3) {
            this.$$robo$$com_android_internal_app_ProcessStats_ProcessDataCollection$__constructor__(nArray, nArray2, nArray3);
        }

        public ProcessDataCollection(int[] nArray, int[] nArray2, int[] nArray3) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_app_ProcessStats_ProcessDataCollection$__constructor__(int[] int[] int[] ), 0, this, nArray, nArray2, nArray3);
        }

        void print(PrintWriter printWriter, long l, boolean bl) {
            InvokeDynamicSupport.bootstrap("print", $$robo$$com_android_internal_app_ProcessStats_ProcessDataCollection$print(java.io.PrintWriter long boolean ), 0, this, printWriter, l, bl);
        }

        public /* synthetic */ ProcessDataCollection() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ProcessDataCollection)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public static final class PackageState
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public ArrayMap<String, ProcessState> mProcesses;
        public ArrayMap<String, ServiceState> mServices;
        public String mPackageName;
        public int mUid;

        private void $$robo$$com_android_internal_app_ProcessStats_PackageState$__constructor__(String packageName, int uid) {
            this.mProcesses = new ArrayMap();
            this.mServices = new ArrayMap();
            this.mUid = uid;
            this.mPackageName = packageName;
        }

        private void __constructor__(String string2, int n) {
            this.$$robo$$com_android_internal_app_ProcessStats_PackageState$__constructor__(string2, n);
        }

        public PackageState(String string2, int n) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_app_ProcessStats_PackageState$__constructor__(java.lang.String int ), 0, this, string2, n);
        }

        public /* synthetic */ PackageState() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (PackageState)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public static final class ServiceState
    extends DurationsTable
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public String mPackage;
        public String mProcessName;
        ProcessState mProc;
        Object mOwner;
        public static int SERVICE_RUN = 0;
        public static int SERVICE_STARTED = 1;
        public static int SERVICE_BOUND = 2;
        public static int SERVICE_EXEC = 3;
        static int SERVICE_COUNT = 4;
        int mRunCount;
        public int mRunState;
        long mRunStartTime;
        boolean mStarted;
        boolean mRestarting;
        int mStartedCount;
        public int mStartedState;
        long mStartedStartTime;
        int mBoundCount;
        public int mBoundState;
        long mBoundStartTime;
        int mExecCount;
        public int mExecState;
        long mExecStartTime;

        private void $$robo$$com_android_internal_app_ProcessStats_ServiceState$__constructor__(ProcessStats processStats, String pkg, String name, String processName, ProcessState proc) {
            this.mRunState = -1;
            this.mStartedState = -1;
            this.mBoundState = -1;
            this.mExecState = -1;
            this.mPackage = pkg;
            this.mProcessName = processName;
            this.mProc = proc;
        }

        private final void $$robo$$com_android_internal_app_ProcessStats_ServiceState$applyNewOwner(Object newOwner) {
            if (this.mOwner != newOwner) {
                if (this.mOwner == null) {
                    this.mOwner = newOwner;
                    this.mProc.incActiveServices(this.mName);
                } else {
                    this.mOwner = newOwner;
                    if (this.mStarted || this.mBoundState != -1 || this.mExecState != -1) {
                        long now = SystemClock.uptimeMillis();
                        if (this.mStarted) {
                            this.setStarted(false, 0, now);
                        }
                        if (this.mBoundState != -1) {
                            this.setBound(false, 0, now);
                        }
                        if (this.mExecState != -1) {
                            this.setExecuting(false, 0, now);
                        }
                    }
                }
            }
        }

        private final void $$robo$$com_android_internal_app_ProcessStats_ServiceState$clearCurrentOwner(Object owner, boolean silently) {
            if (this.mOwner == owner) {
                this.mProc.decActiveServices(this.mName);
                if (this.mStarted || this.mBoundState != -1 || this.mExecState != -1) {
                    long now = SystemClock.uptimeMillis();
                    if (this.mStarted) {
                        if (!silently) {
                            Slog.wtfStack("ProcessStats", "Service owner " + owner + " cleared while started: pkg=" + this.mPackage + " service=" + this.mName + " proc=" + this.mProc);
                        }
                        this.setStarted(false, 0, now);
                    }
                    if (this.mBoundState != -1) {
                        if (!silently) {
                            Slog.wtfStack("ProcessStats", "Service owner " + owner + " cleared while bound: pkg=" + this.mPackage + " service=" + this.mName + " proc=" + this.mProc);
                        }
                        this.setBound(false, 0, now);
                    }
                    if (this.mExecState != -1) {
                        if (!silently) {
                            Slog.wtfStack("ProcessStats", "Service owner " + owner + " cleared while exec: pkg=" + this.mPackage + " service=" + this.mName + " proc=" + this.mProc);
                        }
                        this.setExecuting(false, 0, now);
                    }
                }
                this.mOwner = null;
            }
        }

        private final boolean $$robo$$com_android_internal_app_ProcessStats_ServiceState$isInUse() {
            return this.mOwner != null || this.mRestarting;
        }

        private final boolean $$robo$$com_android_internal_app_ProcessStats_ServiceState$isRestarting() {
            return this.mRestarting;
        }

        private final void $$robo$$com_android_internal_app_ProcessStats_ServiceState$add(ServiceState other) {
            this.addDurations(other);
            this.mRunCount += other.mRunCount;
            this.mStartedCount += other.mStartedCount;
            this.mBoundCount += other.mBoundCount;
            this.mExecCount += other.mExecCount;
        }

        private final void $$robo$$com_android_internal_app_ProcessStats_ServiceState$resetSafely(long now) {
            this.resetDurationsSafely();
            this.mRunCount = this.mRunState != -1 ? 1 : 0;
            this.mStartedCount = this.mStartedState != -1 ? 1 : 0;
            this.mBoundCount = this.mBoundState != -1 ? 1 : 0;
            this.mExecCount = this.mExecState != -1 ? 1 : 0;
            this.mBoundStartTime = this.mExecStartTime = now;
            this.mStartedStartTime = this.mExecStartTime;
            this.mRunStartTime = this.mExecStartTime;
        }

        private final void $$robo$$com_android_internal_app_ProcessStats_ServiceState$writeToParcel(Parcel out, long now) {
            this.writeDurationsToParcel(out);
            out.writeInt(this.mRunCount);
            out.writeInt(this.mStartedCount);
            out.writeInt(this.mBoundCount);
            out.writeInt(this.mExecCount);
        }

        private final boolean $$robo$$com_android_internal_app_ProcessStats_ServiceState$readFromParcel(Parcel in) {
            if (!this.readDurationsFromParcel(in)) {
                return false;
            }
            this.mRunCount = in.readInt();
            this.mStartedCount = in.readInt();
            this.mBoundCount = in.readInt();
            this.mExecCount = in.readInt();
            return true;
        }

        private final void $$robo$$com_android_internal_app_ProcessStats_ServiceState$commitStateTime(long now) {
            if (this.mRunState != -1) {
                this.addDuration(0 + this.mRunState * 4, now - this.mRunStartTime);
                this.mRunStartTime = now;
            }
            if (this.mStartedState != -1) {
                this.addDuration(1 + this.mStartedState * 4, now - this.mStartedStartTime);
                this.mStartedStartTime = now;
            }
            if (this.mBoundState != -1) {
                this.addDuration(2 + this.mBoundState * 4, now - this.mBoundStartTime);
                this.mBoundStartTime = now;
            }
            if (this.mExecState != -1) {
                this.addDuration(3 + this.mExecState * 4, now - this.mExecStartTime);
                this.mExecStartTime = now;
            }
        }

        private final void $$robo$$com_android_internal_app_ProcessStats_ServiceState$updateRunning(int memFactor, long now) {
            int state;
            int n = state = this.mStartedState != -1 || this.mBoundState != -1 || this.mExecState != -1 ? memFactor : -1;
            if (this.mRunState != state) {
                if (this.mRunState != -1) {
                    this.addDuration(0 + this.mRunState * 4, now - this.mRunStartTime);
                } else if (state != -1) {
                    ++this.mRunCount;
                }
                this.mRunState = state;
                this.mRunStartTime = now;
            }
        }

        private final void $$robo$$com_android_internal_app_ProcessStats_ServiceState$setStarted(boolean started, int memFactor, long now) {
            if (this.mOwner == null) {
                Slog.wtf("ProcessStats", "Starting service " + this + " without owner");
            }
            this.mStarted = started;
            this.updateStartedState(memFactor, now);
        }

        private final void $$robo$$com_android_internal_app_ProcessStats_ServiceState$setRestarting(boolean restarting, int memFactor, long now) {
            this.mRestarting = restarting;
            this.updateStartedState(memFactor, now);
        }

        private final void $$robo$$com_android_internal_app_ProcessStats_ServiceState$updateStartedState(int memFactor, long now) {
            int state;
            boolean wasStarted = this.mStartedState != -1;
            boolean started = this.mStarted || this.mRestarting;
            int n = state = started ? memFactor : -1;
            if (this.mStartedState != state) {
                if (this.mStartedState != -1) {
                    this.addDuration(1 + this.mStartedState * 4, now - this.mStartedStartTime);
                } else if (started) {
                    ++this.mStartedCount;
                }
                this.mStartedState = state;
                this.mStartedStartTime = now;
                this.mProc = this.mProc.pullFixedProc(this.mPackage);
                if (wasStarted != started) {
                    if (started) {
                        this.mProc.incStartedServices(memFactor, now, this.mName);
                    } else {
                        this.mProc.decStartedServices(memFactor, now, this.mName);
                    }
                }
                this.updateRunning(memFactor, now);
            }
        }

        private final void $$robo$$com_android_internal_app_ProcessStats_ServiceState$setBound(boolean bound, int memFactor, long now) {
            int state;
            if (this.mOwner == null) {
                Slog.wtf("ProcessStats", "Binding service " + this + " without owner");
            }
            int n = state = bound ? memFactor : -1;
            if (this.mBoundState != state) {
                if (this.mBoundState != -1) {
                    this.addDuration(2 + this.mBoundState * 4, now - this.mBoundStartTime);
                } else if (bound) {
                    ++this.mBoundCount;
                }
                this.mBoundState = state;
                this.mBoundStartTime = now;
                this.updateRunning(memFactor, now);
            }
        }

        private final void $$robo$$com_android_internal_app_ProcessStats_ServiceState$setExecuting(boolean executing, int memFactor, long now) {
            int state;
            if (this.mOwner == null) {
                Slog.wtf("ProcessStats", "Executing service " + this + " without owner");
            }
            int n = state = executing ? memFactor : -1;
            if (this.mExecState != state) {
                if (this.mExecState != -1) {
                    this.addDuration(3 + this.mExecState * 4, now - this.mExecStartTime);
                } else if (executing) {
                    ++this.mExecCount;
                }
                this.mExecState = state;
                this.mExecStartTime = now;
                this.updateRunning(memFactor, now);
            }
        }

        private final long $$robo$$com_android_internal_app_ProcessStats_ServiceState$getDuration(int opType, int curState, long startTime, int memFactor, long now) {
            int state = opType + memFactor * 4;
            long time = this.getDuration(state, now);
            if (curState == memFactor) {
                time += now - startTime;
            }
            return time;
        }

        private final String $$robo$$com_android_internal_app_ProcessStats_ServiceState$toString() {
            return "ServiceState{" + Integer.toHexString(System.identityHashCode(this)) + " " + this.mName + " pkg=" + this.mPackage + " proc=" + Integer.toHexString(System.identityHashCode(this)) + "}";
        }

        private void __constructor__(ProcessStats processStats, String string2, String string3, String string4, ProcessState processState) {
            this.$$robo$$com_android_internal_app_ProcessStats_ServiceState$__constructor__(processStats, string2, string3, string4, processState);
        }

        public ServiceState(ProcessStats processStats, String string2, String string3, String string4, ProcessState processState) {
            super(processStats, string3);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_app_ProcessStats_ServiceState$__constructor__(com.android.internal.app.ProcessStats java.lang.String java.lang.String java.lang.String com.android.internal.app.ProcessStats$ProcessState ), 0, this, processStats, string2, string3, string4, processState);
        }

        public void applyNewOwner(Object object) {
            InvokeDynamicSupport.bootstrap("applyNewOwner", $$robo$$com_android_internal_app_ProcessStats_ServiceState$applyNewOwner(java.lang.Object ), 0, this, object);
        }

        public void clearCurrentOwner(Object object, boolean bl) {
            InvokeDynamicSupport.bootstrap("clearCurrentOwner", $$robo$$com_android_internal_app_ProcessStats_ServiceState$clearCurrentOwner(java.lang.Object boolean ), 0, this, object, bl);
        }

        public boolean isInUse() {
            return (boolean)InvokeDynamicSupport.bootstrap("isInUse", $$robo$$com_android_internal_app_ProcessStats_ServiceState$isInUse(), 0, this);
        }

        public boolean isRestarting() {
            return (boolean)InvokeDynamicSupport.bootstrap("isRestarting", $$robo$$com_android_internal_app_ProcessStats_ServiceState$isRestarting(), 0, this);
        }

        void add(ServiceState serviceState) {
            InvokeDynamicSupport.bootstrap("add", $$robo$$com_android_internal_app_ProcessStats_ServiceState$add(com.android.internal.app.ProcessStats$ServiceState ), 0, this, serviceState);
        }

        void resetSafely(long l) {
            InvokeDynamicSupport.bootstrap("resetSafely", $$robo$$com_android_internal_app_ProcessStats_ServiceState$resetSafely(long ), 0, this, l);
        }

        void writeToParcel(Parcel parcel, long l) {
            InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$com_android_internal_app_ProcessStats_ServiceState$writeToParcel(android.os.Parcel long ), 0, this, parcel, l);
        }

        boolean readFromParcel(Parcel parcel) {
            return (boolean)InvokeDynamicSupport.bootstrap("readFromParcel", $$robo$$com_android_internal_app_ProcessStats_ServiceState$readFromParcel(android.os.Parcel ), 0, this, parcel);
        }

        void commitStateTime(long l) {
            InvokeDynamicSupport.bootstrap("commitStateTime", $$robo$$com_android_internal_app_ProcessStats_ServiceState$commitStateTime(long ), 0, this, l);
        }

        private void updateRunning(int n, long l) {
            InvokeDynamicSupport.bootstrap("updateRunning", $$robo$$com_android_internal_app_ProcessStats_ServiceState$updateRunning(int long ), 0, this, n, l);
        }

        public void setStarted(boolean bl, int n, long l) {
            InvokeDynamicSupport.bootstrap("setStarted", $$robo$$com_android_internal_app_ProcessStats_ServiceState$setStarted(boolean int long ), 0, this, bl, n, l);
        }

        public void setRestarting(boolean bl, int n, long l) {
            InvokeDynamicSupport.bootstrap("setRestarting", $$robo$$com_android_internal_app_ProcessStats_ServiceState$setRestarting(boolean int long ), 0, this, bl, n, l);
        }

        void updateStartedState(int n, long l) {
            InvokeDynamicSupport.bootstrap("updateStartedState", $$robo$$com_android_internal_app_ProcessStats_ServiceState$updateStartedState(int long ), 0, this, n, l);
        }

        public void setBound(boolean bl, int n, long l) {
            InvokeDynamicSupport.bootstrap("setBound", $$robo$$com_android_internal_app_ProcessStats_ServiceState$setBound(boolean int long ), 0, this, bl, n, l);
        }

        public void setExecuting(boolean bl, int n, long l) {
            InvokeDynamicSupport.bootstrap("setExecuting", $$robo$$com_android_internal_app_ProcessStats_ServiceState$setExecuting(boolean int long ), 0, this, bl, n, l);
        }

        private long getDuration(int n, int n2, long l, int n3, long l2) {
            return (long)InvokeDynamicSupport.bootstrap("getDuration", $$robo$$com_android_internal_app_ProcessStats_ServiceState$getDuration(int int long int long ), 0, this, n, n2, l, n3, l2);
        }

        public String toString() {
            return InvokeDynamicSupport.bootstrap("toString", $$robo$$com_android_internal_app_ProcessStats_ServiceState$toString(), 0, this);
        }

        public /* synthetic */ ServiceState() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ServiceState)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public static final class ProcessState
    extends DurationsTable
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public ProcessState mCommonProcess;
        public String mPackage;
        public int mUid;
        public int mVersion;
        int mCurState;
        long mStartTime;
        int mLastPssState;
        long mLastPssTime;
        int[] mPssTable;
        int mPssTableSize;
        boolean mActive;
        int mNumActiveServices;
        int mNumStartedServices;
        int mNumExcessiveWake;
        int mNumExcessiveCpu;
        int mNumCachedKill;
        long mMinCachedKillPss;
        long mAvgCachedKillPss;
        long mMaxCachedKillPss;
        boolean mMultiPackage;
        boolean mDead;
        public long mTmpTotalTime;
        int mTmpNumInUse;
        ProcessState mTmpFoundSubProc;

        private void $$robo$$com_android_internal_app_ProcessStats_ProcessState$__constructor__(ProcessStats processStats, String pkg, int uid, int vers, String name) {
            this.mCurState = -1;
            this.mLastPssState = -1;
            this.mCommonProcess = this;
            this.mPackage = pkg;
            this.mUid = uid;
            this.mVersion = vers;
        }

        private void $$robo$$com_android_internal_app_ProcessStats_ProcessState$__constructor__(ProcessState commonProcess, String pkg, int uid, int vers, String name, long now) {
            this.mCurState = -1;
            this.mLastPssState = -1;
            this.mCommonProcess = commonProcess;
            this.mPackage = pkg;
            this.mUid = uid;
            this.mVersion = vers;
            this.mCurState = commonProcess.mCurState;
            this.mStartTime = now;
        }

        private final ProcessState $$robo$$com_android_internal_app_ProcessStats_ProcessState$clone(String pkg, long now) {
            ProcessState pnew = new ProcessState(this, pkg, this.mUid, this.mVersion, this.mName, now);
            this.copyDurationsTo(pnew);
            if (this.mPssTable != null) {
                this.mStats.mAddLongTable = new int[this.mPssTable.length];
                this.mStats.mAddLongTableSize = 0;
                for (int i = 0; i < this.mPssTableSize; ++i) {
                    int origEnt = this.mPssTable[i];
                    int type = origEnt >> OFFSET_TYPE_SHIFT & OFFSET_TYPE_MASK;
                    int newOff = this.mStats.addLongData(i, type, 7);
                    this.mStats.mAddLongTable[i] = newOff | type;
                    for (int j = 0; j < 7; ++j) {
                        this.mStats.setLong(newOff, j, this.mStats.getLong(origEnt, j));
                    }
                }
                pnew.mPssTable = this.mStats.mAddLongTable;
                pnew.mPssTableSize = this.mStats.mAddLongTableSize;
            }
            pnew.mNumExcessiveWake = this.mNumExcessiveWake;
            pnew.mNumExcessiveCpu = this.mNumExcessiveCpu;
            pnew.mNumCachedKill = this.mNumCachedKill;
            pnew.mMinCachedKillPss = this.mMinCachedKillPss;
            pnew.mAvgCachedKillPss = this.mAvgCachedKillPss;
            pnew.mMaxCachedKillPss = this.mMaxCachedKillPss;
            pnew.mActive = this.mActive;
            pnew.mNumActiveServices = this.mNumActiveServices;
            pnew.mNumStartedServices = this.mNumStartedServices;
            return pnew;
        }

        private final void $$robo$$com_android_internal_app_ProcessStats_ProcessState$add(ProcessState other) {
            this.addDurations(other);
            for (int i = 0; i < other.mPssTableSize; ++i) {
                int ent = other.mPssTable[i];
                int state = ent >> OFFSET_TYPE_SHIFT & OFFSET_TYPE_MASK;
                this.addPss(state, (int)other.mStats.getLong(ent, 0), other.mStats.getLong(ent, 1), other.mStats.getLong(ent, 2), other.mStats.getLong(ent, 3), other.mStats.getLong(ent, 4), other.mStats.getLong(ent, 5), other.mStats.getLong(ent, 6));
            }
            this.mNumExcessiveWake += other.mNumExcessiveWake;
            this.mNumExcessiveCpu += other.mNumExcessiveCpu;
            if (other.mNumCachedKill > 0) {
                this.addCachedKill(other.mNumCachedKill, other.mMinCachedKillPss, other.mAvgCachedKillPss, other.mMaxCachedKillPss);
            }
        }

        private final void $$robo$$com_android_internal_app_ProcessStats_ProcessState$resetSafely(long now) {
            this.resetDurationsSafely();
            this.mStartTime = now;
            this.mLastPssState = -1;
            this.mLastPssTime = 0L;
            this.mPssTable = null;
            this.mPssTableSize = 0;
            this.mNumExcessiveWake = 0;
            this.mNumExcessiveCpu = 0;
            this.mNumCachedKill = 0;
            this.mMaxCachedKillPss = 0L;
            this.mAvgCachedKillPss = 0L;
            this.mMinCachedKillPss = 0L;
        }

        private final void $$robo$$com_android_internal_app_ProcessStats_ProcessState$makeDead() {
            this.mDead = true;
        }

        private final void $$robo$$com_android_internal_app_ProcessStats_ProcessState$ensureNotDead() {
            if (!this.mDead) {
                return;
            }
            Slog.wtfStack("ProcessStats", "ProcessState dead: name=" + this.mName + " pkg=" + this.mPackage + " uid=" + this.mUid + " common.name=" + this.mCommonProcess.mName);
        }

        private final void $$robo$$com_android_internal_app_ProcessStats_ProcessState$writeToParcel(Parcel out, long now) {
            out.writeInt(this.mMultiPackage ? 1 : 0);
            this.writeDurationsToParcel(out);
            out.writeInt(this.mPssTableSize);
            for (int i = 0; i < this.mPssTableSize; ++i) {
                out.writeInt(this.mPssTable[i]);
            }
            out.writeInt(this.mNumExcessiveWake);
            out.writeInt(this.mNumExcessiveCpu);
            out.writeInt(this.mNumCachedKill);
            if (this.mNumCachedKill > 0) {
                out.writeLong(this.mMinCachedKillPss);
                out.writeLong(this.mAvgCachedKillPss);
                out.writeLong(this.mMaxCachedKillPss);
            }
        }

        private final boolean $$robo$$com_android_internal_app_ProcessStats_ProcessState$readFromParcel(Parcel in, boolean fully) {
            boolean multiPackage;
            boolean bl = multiPackage = in.readInt() != 0;
            if (fully) {
                this.mMultiPackage = multiPackage;
            }
            if (!this.readDurationsFromParcel(in)) {
                return false;
            }
            this.mPssTable = this.mStats.readTableFromParcel(in, this.mName, "pss");
            if (this.mPssTable == BAD_TABLE) {
                return false;
            }
            this.mPssTableSize = this.mPssTable != null ? this.mPssTable.length : 0;
            this.mNumExcessiveWake = in.readInt();
            this.mNumExcessiveCpu = in.readInt();
            this.mNumCachedKill = in.readInt();
            if (this.mNumCachedKill > 0) {
                this.mMinCachedKillPss = in.readLong();
                this.mAvgCachedKillPss = in.readLong();
                this.mMaxCachedKillPss = in.readLong();
            } else {
                this.mMaxCachedKillPss = 0L;
                this.mAvgCachedKillPss = 0L;
                this.mMinCachedKillPss = 0L;
            }
            return true;
        }

        private final void $$robo$$com_android_internal_app_ProcessStats_ProcessState$makeActive() {
            this.ensureNotDead();
            this.mActive = true;
        }

        private final void $$robo$$com_android_internal_app_ProcessStats_ProcessState$makeInactive() {
            this.mActive = false;
        }

        private final boolean $$robo$$com_android_internal_app_ProcessStats_ProcessState$isInUse() {
            return this.mActive || this.mNumActiveServices > 0 || this.mNumStartedServices > 0 || this.mCurState != -1;
        }

        private final void $$robo$$com_android_internal_app_ProcessStats_ProcessState$setState(int state, int memFactor, long now, ArrayMap<String, ProcessStateHolder> pkgList) {
            state = state < 0 ? (this.mNumStartedServices > 0 ? 7 + memFactor * 14 : -1) : PROCESS_STATE_TO_STATE[state] + memFactor * 14;
            this.mCommonProcess.setState(state, now);
            if (!this.mCommonProcess.mMultiPackage) {
                return;
            }
            if (pkgList != null) {
                for (int ip = pkgList.size() - 1; ip >= 0; --ip) {
                    this.pullFixedProc(pkgList, ip).setState(state, now);
                }
            }
        }

        private final void $$robo$$com_android_internal_app_ProcessStats_ProcessState$setState(int state, long now) {
            this.ensureNotDead();
            if (this.mCurState != state) {
                this.commitStateTime(now);
                this.mCurState = state;
            }
        }

        private final void $$robo$$com_android_internal_app_ProcessStats_ProcessState$commitStateTime(long now) {
            long dur;
            if (this.mCurState != -1 && (dur = now - this.mStartTime) > 0L) {
                this.addDuration(this.mCurState, dur);
            }
            this.mStartTime = now;
        }

        private final void $$robo$$com_android_internal_app_ProcessStats_ProcessState$incActiveServices(String serviceName) {
            if (this.mCommonProcess != this) {
                this.mCommonProcess.incActiveServices(serviceName);
            }
            ++this.mNumActiveServices;
        }

        private final void $$robo$$com_android_internal_app_ProcessStats_ProcessState$decActiveServices(String serviceName) {
            if (this.mCommonProcess != this) {
                this.mCommonProcess.decActiveServices(serviceName);
            }
            --this.mNumActiveServices;
            if (this.mNumActiveServices < 0) {
                Slog.wtfStack("ProcessStats", "Proc active services underrun: pkg=" + this.mPackage + " uid=" + this.mUid + " proc=" + this.mName + " service=" + serviceName);
                this.mNumActiveServices = 0;
            }
        }

        private final void $$robo$$com_android_internal_app_ProcessStats_ProcessState$incStartedServices(int memFactor, long now, String serviceName) {
            if (this.mCommonProcess != this) {
                this.mCommonProcess.incStartedServices(memFactor, now, serviceName);
            }
            ++this.mNumStartedServices;
            if (this.mNumStartedServices == 1 && this.mCurState == -1) {
                this.setState(7 + memFactor * 14, now);
            }
        }

        private final void $$robo$$com_android_internal_app_ProcessStats_ProcessState$decStartedServices(int memFactor, long now, String serviceName) {
            if (this.mCommonProcess != this) {
                this.mCommonProcess.decStartedServices(memFactor, now, serviceName);
            }
            --this.mNumStartedServices;
            if (this.mNumStartedServices == 0 && this.mCurState % 14 == 7) {
                this.setState(-1, now);
            } else if (this.mNumStartedServices < 0) {
                Slog.wtfStack("ProcessStats", "Proc started services underrun: pkg=" + this.mPackage + " uid=" + this.mUid + " name=" + this.mName);
                this.mNumStartedServices = 0;
            }
        }

        private final void $$robo$$com_android_internal_app_ProcessStats_ProcessState$addPss(long pss, long uss, boolean always, ArrayMap<String, ProcessStateHolder> pkgList) {
            this.ensureNotDead();
            if (!always && this.mLastPssState == this.mCurState && SystemClock.uptimeMillis() < this.mLastPssTime + 30000L) {
                return;
            }
            this.mLastPssState = this.mCurState;
            this.mLastPssTime = SystemClock.uptimeMillis();
            if (this.mCurState != -1) {
                this.mCommonProcess.addPss(this.mCurState, 1, pss, pss, pss, uss, uss, uss);
                if (!this.mCommonProcess.mMultiPackage) {
                    return;
                }
                if (pkgList != null) {
                    for (int ip = pkgList.size() - 1; ip >= 0; --ip) {
                        this.pullFixedProc(pkgList, ip).addPss(this.mCurState, 1, pss, pss, pss, uss, uss, uss);
                    }
                }
            }
        }

        private final void $$robo$$com_android_internal_app_ProcessStats_ProcessState$addPss(int state, int inCount, long minPss, long avgPss, long maxPss, long minUss, long avgUss, long maxUss) {
            int off;
            int idx = ProcessStats.binarySearch(this.mPssTable, this.mPssTableSize, state);
            if (idx >= 0) {
                off = this.mPssTable[idx];
            } else {
                this.mStats.mAddLongTable = this.mPssTable;
                this.mStats.mAddLongTableSize = this.mPssTableSize;
                off = this.mStats.addLongData(~idx, state, 7);
                this.mPssTable = this.mStats.mAddLongTable;
                this.mPssTableSize = this.mStats.mAddLongTableSize;
            }
            long[] longs = this.mStats.mLongs.get(off >> OFFSET_ARRAY_SHIFT & OFFSET_ARRAY_MASK);
            idx = off >> OFFSET_INDEX_SHIFT & OFFSET_INDEX_MASK;
            long count = longs[idx + 0];
            if (count == 0L) {
                longs[idx + 0] = inCount;
                longs[idx + 1] = minPss;
                longs[idx + 2] = avgPss;
                longs[idx + 3] = maxPss;
                longs[idx + 4] = minUss;
                longs[idx + 5] = avgUss;
                longs[idx + 6] = maxUss;
            } else {
                longs[idx + 0] = count + (long)inCount;
                if (longs[idx + 1] > minPss) {
                    longs[idx + 1] = minPss;
                }
                longs[idx + 2] = (long)(((double)longs[idx + 2] * (double)count + (double)avgPss * (double)inCount) / (double)(count + (long)inCount));
                if (longs[idx + 3] < maxPss) {
                    longs[idx + 3] = maxPss;
                }
                if (longs[idx + 4] > minUss) {
                    longs[idx + 4] = minUss;
                }
                longs[idx + 5] = (long)(((double)longs[idx + 5] * (double)count + (double)avgUss * (double)inCount) / (double)(count + (long)inCount));
                if (longs[idx + 6] < maxUss) {
                    longs[idx + 6] = maxUss;
                }
            }
        }

        private final void $$robo$$com_android_internal_app_ProcessStats_ProcessState$reportExcessiveWake(ArrayMap<String, ProcessStateHolder> pkgList) {
            this.ensureNotDead();
            ++this.mCommonProcess.mNumExcessiveWake;
            if (!this.mCommonProcess.mMultiPackage) {
                return;
            }
            for (int ip = pkgList.size() - 1; ip >= 0; --ip) {
                ++this.pullFixedProc(pkgList, (int)ip).mNumExcessiveWake;
            }
        }

        private final void $$robo$$com_android_internal_app_ProcessStats_ProcessState$reportExcessiveCpu(ArrayMap<String, ProcessStateHolder> pkgList) {
            this.ensureNotDead();
            ++this.mCommonProcess.mNumExcessiveCpu;
            if (!this.mCommonProcess.mMultiPackage) {
                return;
            }
            for (int ip = pkgList.size() - 1; ip >= 0; --ip) {
                ++this.pullFixedProc(pkgList, (int)ip).mNumExcessiveCpu;
            }
        }

        private final void $$robo$$com_android_internal_app_ProcessStats_ProcessState$addCachedKill(int num, long minPss, long avgPss, long maxPss) {
            if (this.mNumCachedKill <= 0) {
                this.mNumCachedKill = num;
                this.mMinCachedKillPss = minPss;
                this.mAvgCachedKillPss = avgPss;
                this.mMaxCachedKillPss = maxPss;
            } else {
                if (minPss < this.mMinCachedKillPss) {
                    this.mMinCachedKillPss = minPss;
                }
                if (maxPss > this.mMaxCachedKillPss) {
                    this.mMaxCachedKillPss = maxPss;
                }
                this.mAvgCachedKillPss = (long)(((double)this.mAvgCachedKillPss * (double)this.mNumCachedKill + (double)avgPss) / (double)(this.mNumCachedKill + num));
                this.mNumCachedKill += num;
            }
        }

        private final void $$robo$$com_android_internal_app_ProcessStats_ProcessState$reportCachedKill(ArrayMap<String, ProcessStateHolder> pkgList, long pss) {
            this.ensureNotDead();
            this.mCommonProcess.addCachedKill(1, pss, pss, pss);
            if (!this.mCommonProcess.mMultiPackage) {
                return;
            }
            for (int ip = pkgList.size() - 1; ip >= 0; --ip) {
                this.pullFixedProc(pkgList, ip).addCachedKill(1, pss, pss, pss);
            }
        }

        private final ProcessState $$robo$$com_android_internal_app_ProcessStats_ProcessState$pullFixedProc(String pkgName) {
            if (this.mMultiPackage) {
                SparseArray<PackageState> vpkg = this.mStats.mPackages.get(pkgName, this.mUid);
                if (vpkg == null) {
                    throw new IllegalStateException("Didn't find package " + pkgName + " / " + this.mUid);
                }
                PackageState pkg = vpkg.get(this.mVersion);
                if (pkg == null) {
                    throw new IllegalStateException("Didn't find package " + pkgName + " / " + this.mUid + " vers " + this.mVersion);
                }
                ProcessState proc = pkg.mProcesses.get(this.mName);
                if (proc == null) {
                    throw new IllegalStateException("Didn't create per-package process " + this.mName + " in pkg " + pkgName + " / " + this.mUid + " vers " + this.mVersion);
                }
                return proc;
            }
            return this;
        }

        private final ProcessState $$robo$$com_android_internal_app_ProcessStats_ProcessState$pullFixedProc(ArrayMap<String, ProcessStateHolder> pkgList, int index) {
            ProcessStateHolder holder = pkgList.valueAt(index);
            ProcessState proc = holder.state;
            if (this.mDead && proc.mCommonProcess != proc) {
                Log.wtf("ProcessStats", "Pulling dead proc: name=" + this.mName + " pkg=" + this.mPackage + " uid=" + this.mUid + " common.name=" + this.mCommonProcess.mName);
                proc = this.mStats.getProcessStateLocked(proc.mPackage, proc.mUid, proc.mVersion, proc.mName);
            }
            if (proc.mMultiPackage) {
                SparseArray<PackageState> vpkg = this.mStats.mPackages.get(pkgList.keyAt(index), proc.mUid);
                if (vpkg == null) {
                    throw new IllegalStateException("No existing package " + pkgList.keyAt(index) + "/" + proc.mUid + " for multi-proc " + proc.mName);
                }
                PackageState pkg = vpkg.get(proc.mVersion);
                if (pkg == null) {
                    throw new IllegalStateException("No existing package " + pkgList.keyAt(index) + "/" + proc.mUid + " for multi-proc " + proc.mName + " version " + proc.mVersion);
                }
                proc = pkg.mProcesses.get(proc.mName);
                if (proc == null) {
                    throw new IllegalStateException("Didn't create per-package process " + proc.mName + " in pkg " + pkg.mPackageName + "/" + pkg.mUid);
                }
                holder.state = proc;
            }
            return proc;
        }

        private final long $$robo$$com_android_internal_app_ProcessStats_ProcessState$getDuration(int state, long now) {
            long time = super.getDuration(state, now);
            if (this.mCurState == state) {
                time += now - this.mStartTime;
            }
            return time;
        }

        private final long $$robo$$com_android_internal_app_ProcessStats_ProcessState$getPssSampleCount(int state) {
            int idx = ProcessStats.binarySearch(this.mPssTable, this.mPssTableSize, state);
            return idx >= 0 ? this.mStats.getLong(this.mPssTable[idx], 0) : 0L;
        }

        private final long $$robo$$com_android_internal_app_ProcessStats_ProcessState$getPssMinimum(int state) {
            int idx = ProcessStats.binarySearch(this.mPssTable, this.mPssTableSize, state);
            return idx >= 0 ? this.mStats.getLong(this.mPssTable[idx], 1) : 0L;
        }

        private final long $$robo$$com_android_internal_app_ProcessStats_ProcessState$getPssAverage(int state) {
            int idx = ProcessStats.binarySearch(this.mPssTable, this.mPssTableSize, state);
            return idx >= 0 ? this.mStats.getLong(this.mPssTable[idx], 2) : 0L;
        }

        private final long $$robo$$com_android_internal_app_ProcessStats_ProcessState$getPssMaximum(int state) {
            int idx = ProcessStats.binarySearch(this.mPssTable, this.mPssTableSize, state);
            return idx >= 0 ? this.mStats.getLong(this.mPssTable[idx], 3) : 0L;
        }

        private final long $$robo$$com_android_internal_app_ProcessStats_ProcessState$getPssUssMinimum(int state) {
            int idx = ProcessStats.binarySearch(this.mPssTable, this.mPssTableSize, state);
            return idx >= 0 ? this.mStats.getLong(this.mPssTable[idx], 4) : 0L;
        }

        private final long $$robo$$com_android_internal_app_ProcessStats_ProcessState$getPssUssAverage(int state) {
            int idx = ProcessStats.binarySearch(this.mPssTable, this.mPssTableSize, state);
            return idx >= 0 ? this.mStats.getLong(this.mPssTable[idx], 5) : 0L;
        }

        private final long $$robo$$com_android_internal_app_ProcessStats_ProcessState$getPssUssMaximum(int state) {
            int idx = ProcessStats.binarySearch(this.mPssTable, this.mPssTableSize, state);
            return idx >= 0 ? this.mStats.getLong(this.mPssTable[idx], 6) : 0L;
        }

        private final String $$robo$$com_android_internal_app_ProcessStats_ProcessState$toString() {
            StringBuilder sb = new StringBuilder(128);
            sb.append("ProcessState{").append(Integer.toHexString(System.identityHashCode(this))).append(" ").append(this.mName).append("/").append(this.mUid).append(" pkg=").append(this.mPackage);
            if (this.mMultiPackage) {
                sb.append(" (multi)");
            }
            if (this.mCommonProcess != this) {
                sb.append(" (sub)");
            }
            sb.append("}");
            return sb.toString();
        }

        private void __constructor__(ProcessStats processStats, String string2, int n, int n2, String string3) {
            this.$$robo$$com_android_internal_app_ProcessStats_ProcessState$__constructor__(processStats, string2, n, n2, string3);
        }

        public ProcessState(ProcessStats processStats, String string2, int n, int n2, String string3) {
            super(processStats, string3);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_app_ProcessStats_ProcessState$__constructor__(com.android.internal.app.ProcessStats java.lang.String int int java.lang.String ), 0, this, processStats, string2, n, n2, string3);
        }

        private void __constructor__(ProcessState processState, String string2, int n, int n2, String string3, long l) {
            this.$$robo$$com_android_internal_app_ProcessStats_ProcessState$__constructor__(processState, string2, n, n2, string3, l);
        }

        public ProcessState(ProcessState processState, String string2, int n, int n2, String string3, long l) {
            super(processState.mStats, string3);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_app_ProcessStats_ProcessState$__constructor__(com.android.internal.app.ProcessStats$ProcessState java.lang.String int int java.lang.String long ), 0, this, processState, string2, n, n2, string3, l);
        }

        ProcessState clone(String string2, long l) {
            return InvokeDynamicSupport.bootstrap("clone", $$robo$$com_android_internal_app_ProcessStats_ProcessState$clone(java.lang.String long ), 0, this, string2, l);
        }

        void add(ProcessState processState) {
            InvokeDynamicSupport.bootstrap("add", $$robo$$com_android_internal_app_ProcessStats_ProcessState$add(com.android.internal.app.ProcessStats$ProcessState ), 0, this, processState);
        }

        void resetSafely(long l) {
            InvokeDynamicSupport.bootstrap("resetSafely", $$robo$$com_android_internal_app_ProcessStats_ProcessState$resetSafely(long ), 0, this, l);
        }

        void makeDead() {
            InvokeDynamicSupport.bootstrap("makeDead", $$robo$$com_android_internal_app_ProcessStats_ProcessState$makeDead(), 0, this);
        }

        private void ensureNotDead() {
            InvokeDynamicSupport.bootstrap("ensureNotDead", $$robo$$com_android_internal_app_ProcessStats_ProcessState$ensureNotDead(), 0, this);
        }

        void writeToParcel(Parcel parcel, long l) {
            InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$com_android_internal_app_ProcessStats_ProcessState$writeToParcel(android.os.Parcel long ), 0, this, parcel, l);
        }

        boolean readFromParcel(Parcel parcel, boolean bl) {
            return (boolean)InvokeDynamicSupport.bootstrap("readFromParcel", $$robo$$com_android_internal_app_ProcessStats_ProcessState$readFromParcel(android.os.Parcel boolean ), 0, this, parcel, bl);
        }

        public void makeActive() {
            InvokeDynamicSupport.bootstrap("makeActive", $$robo$$com_android_internal_app_ProcessStats_ProcessState$makeActive(), 0, this);
        }

        public void makeInactive() {
            InvokeDynamicSupport.bootstrap("makeInactive", $$robo$$com_android_internal_app_ProcessStats_ProcessState$makeInactive(), 0, this);
        }

        public boolean isInUse() {
            return (boolean)InvokeDynamicSupport.bootstrap("isInUse", $$robo$$com_android_internal_app_ProcessStats_ProcessState$isInUse(), 0, this);
        }

        public void setState(int n, int n2, long l, ArrayMap<String, ProcessStateHolder> arrayMap) {
            InvokeDynamicSupport.bootstrap("setState", $$robo$$com_android_internal_app_ProcessStats_ProcessState$setState(int int long android.util.ArrayMap<java.lang.String, com.android.internal.app.ProcessStats$ProcessStateHolder> ), 0, this, n, n2, l, arrayMap);
        }

        void setState(int n, long l) {
            InvokeDynamicSupport.bootstrap("setState", $$robo$$com_android_internal_app_ProcessStats_ProcessState$setState(int long ), 0, this, n, l);
        }

        void commitStateTime(long l) {
            InvokeDynamicSupport.bootstrap("commitStateTime", $$robo$$com_android_internal_app_ProcessStats_ProcessState$commitStateTime(long ), 0, this, l);
        }

        void incActiveServices(String string2) {
            InvokeDynamicSupport.bootstrap("incActiveServices", $$robo$$com_android_internal_app_ProcessStats_ProcessState$incActiveServices(java.lang.String ), 0, this, string2);
        }

        void decActiveServices(String string2) {
            InvokeDynamicSupport.bootstrap("decActiveServices", $$robo$$com_android_internal_app_ProcessStats_ProcessState$decActiveServices(java.lang.String ), 0, this, string2);
        }

        void incStartedServices(int n, long l, String string2) {
            InvokeDynamicSupport.bootstrap("incStartedServices", $$robo$$com_android_internal_app_ProcessStats_ProcessState$incStartedServices(int long java.lang.String ), 0, this, n, l, string2);
        }

        void decStartedServices(int n, long l, String string2) {
            InvokeDynamicSupport.bootstrap("decStartedServices", $$robo$$com_android_internal_app_ProcessStats_ProcessState$decStartedServices(int long java.lang.String ), 0, this, n, l, string2);
        }

        public void addPss(long l, long l2, boolean bl, ArrayMap<String, ProcessStateHolder> arrayMap) {
            InvokeDynamicSupport.bootstrap("addPss", $$robo$$com_android_internal_app_ProcessStats_ProcessState$addPss(long long boolean android.util.ArrayMap<java.lang.String, com.android.internal.app.ProcessStats$ProcessStateHolder> ), 0, this, l, l2, bl, arrayMap);
        }

        void addPss(int n, int n2, long l, long l2, long l3, long l4, long l5, long l6) {
            InvokeDynamicSupport.bootstrap("addPss", $$robo$$com_android_internal_app_ProcessStats_ProcessState$addPss(int int long long long long long long ), 0, this, n, n2, l, l2, l3, l4, l5, l6);
        }

        public void reportExcessiveWake(ArrayMap<String, ProcessStateHolder> arrayMap) {
            InvokeDynamicSupport.bootstrap("reportExcessiveWake", $$robo$$com_android_internal_app_ProcessStats_ProcessState$reportExcessiveWake(android.util.ArrayMap<java.lang.String, com.android.internal.app.ProcessStats$ProcessStateHolder> ), 0, this, arrayMap);
        }

        public void reportExcessiveCpu(ArrayMap<String, ProcessStateHolder> arrayMap) {
            InvokeDynamicSupport.bootstrap("reportExcessiveCpu", $$robo$$com_android_internal_app_ProcessStats_ProcessState$reportExcessiveCpu(android.util.ArrayMap<java.lang.String, com.android.internal.app.ProcessStats$ProcessStateHolder> ), 0, this, arrayMap);
        }

        private void addCachedKill(int n, long l, long l2, long l3) {
            InvokeDynamicSupport.bootstrap("addCachedKill", $$robo$$com_android_internal_app_ProcessStats_ProcessState$addCachedKill(int long long long ), 0, this, n, l, l2, l3);
        }

        public void reportCachedKill(ArrayMap<String, ProcessStateHolder> arrayMap, long l) {
            InvokeDynamicSupport.bootstrap("reportCachedKill", $$robo$$com_android_internal_app_ProcessStats_ProcessState$reportCachedKill(android.util.ArrayMap<java.lang.String, com.android.internal.app.ProcessStats$ProcessStateHolder> long ), 0, this, arrayMap, l);
        }

        ProcessState pullFixedProc(String string2) {
            return InvokeDynamicSupport.bootstrap("pullFixedProc", $$robo$$com_android_internal_app_ProcessStats_ProcessState$pullFixedProc(java.lang.String ), 0, this, string2);
        }

        private ProcessState pullFixedProc(ArrayMap<String, ProcessStateHolder> arrayMap, int n) {
            return InvokeDynamicSupport.bootstrap("pullFixedProc", $$robo$$com_android_internal_app_ProcessStats_ProcessState$pullFixedProc(android.util.ArrayMap<java.lang.String, com.android.internal.app.ProcessStats$ProcessStateHolder> int ), 0, this, arrayMap, n);
        }

        @Override
        long getDuration(int n, long l) {
            return (long)InvokeDynamicSupport.bootstrap("getDuration", $$robo$$com_android_internal_app_ProcessStats_ProcessState$getDuration(int long ), 0, this, n, l);
        }

        long getPssSampleCount(int n) {
            return (long)InvokeDynamicSupport.bootstrap("getPssSampleCount", $$robo$$com_android_internal_app_ProcessStats_ProcessState$getPssSampleCount(int ), 0, this, n);
        }

        long getPssMinimum(int n) {
            return (long)InvokeDynamicSupport.bootstrap("getPssMinimum", $$robo$$com_android_internal_app_ProcessStats_ProcessState$getPssMinimum(int ), 0, this, n);
        }

        long getPssAverage(int n) {
            return (long)InvokeDynamicSupport.bootstrap("getPssAverage", $$robo$$com_android_internal_app_ProcessStats_ProcessState$getPssAverage(int ), 0, this, n);
        }

        long getPssMaximum(int n) {
            return (long)InvokeDynamicSupport.bootstrap("getPssMaximum", $$robo$$com_android_internal_app_ProcessStats_ProcessState$getPssMaximum(int ), 0, this, n);
        }

        long getPssUssMinimum(int n) {
            return (long)InvokeDynamicSupport.bootstrap("getPssUssMinimum", $$robo$$com_android_internal_app_ProcessStats_ProcessState$getPssUssMinimum(int ), 0, this, n);
        }

        long getPssUssAverage(int n) {
            return (long)InvokeDynamicSupport.bootstrap("getPssUssAverage", $$robo$$com_android_internal_app_ProcessStats_ProcessState$getPssUssAverage(int ), 0, this, n);
        }

        long getPssUssMaximum(int n) {
            return (long)InvokeDynamicSupport.bootstrap("getPssUssMaximum", $$robo$$com_android_internal_app_ProcessStats_ProcessState$getPssUssMaximum(int ), 0, this, n);
        }

        public String toString() {
            return InvokeDynamicSupport.bootstrap("toString", $$robo$$com_android_internal_app_ProcessStats_ProcessState$toString(), 0, this);
        }

        public /* synthetic */ ProcessState() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ProcessState)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public static final class ProcessStateHolder
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public int appVersion;
        public ProcessState state;

        private void $$robo$$com_android_internal_app_ProcessStats_ProcessStateHolder$__constructor__(int _appVersion) {
            this.appVersion = _appVersion;
        }

        private void __constructor__(int n) {
            this.$$robo$$com_android_internal_app_ProcessStats_ProcessStateHolder$__constructor__(n);
        }

        public ProcessStateHolder(int n) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_app_ProcessStats_ProcessStateHolder$__constructor__(int ), 0, this, n);
        }

        public /* synthetic */ ProcessStateHolder() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ProcessStateHolder)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class DurationsTable
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public ProcessStats mStats;
        public String mName;
        public int[] mDurationsTable;
        public int mDurationsTableSize;

        private void $$robo$$com_android_internal_app_ProcessStats_DurationsTable$__constructor__(ProcessStats stats, String name) {
            this.mStats = stats;
            this.mName = name;
        }

        private final void $$robo$$com_android_internal_app_ProcessStats_DurationsTable$copyDurationsTo(DurationsTable other) {
            if (this.mDurationsTable != null) {
                this.mStats.mAddLongTable = new int[this.mDurationsTable.length];
                this.mStats.mAddLongTableSize = 0;
                for (int i = 0; i < this.mDurationsTableSize; ++i) {
                    int origEnt = this.mDurationsTable[i];
                    int type = origEnt >> OFFSET_TYPE_SHIFT & OFFSET_TYPE_MASK;
                    int newOff = this.mStats.addLongData(i, type, 1);
                    this.mStats.mAddLongTable[i] = newOff | type;
                    this.mStats.setLong(newOff, 0, this.mStats.getLong(origEnt, 0));
                }
                other.mDurationsTable = this.mStats.mAddLongTable;
                other.mDurationsTableSize = this.mStats.mAddLongTableSize;
            } else {
                other.mDurationsTable = null;
                other.mDurationsTableSize = 0;
            }
        }

        private final void $$robo$$com_android_internal_app_ProcessStats_DurationsTable$addDurations(DurationsTable other) {
            for (int i = 0; i < other.mDurationsTableSize; ++i) {
                int ent = other.mDurationsTable[i];
                int state = ent >> OFFSET_TYPE_SHIFT & OFFSET_TYPE_MASK;
                this.addDuration(state, other.mStats.getLong(ent, 0));
            }
        }

        private final void $$robo$$com_android_internal_app_ProcessStats_DurationsTable$resetDurationsSafely() {
            this.mDurationsTable = null;
            this.mDurationsTableSize = 0;
        }

        private final void $$robo$$com_android_internal_app_ProcessStats_DurationsTable$writeDurationsToParcel(Parcel out) {
            out.writeInt(this.mDurationsTableSize);
            for (int i = 0; i < this.mDurationsTableSize; ++i) {
                out.writeInt(this.mDurationsTable[i]);
            }
        }

        private final boolean $$robo$$com_android_internal_app_ProcessStats_DurationsTable$readDurationsFromParcel(Parcel in) {
            this.mDurationsTable = this.mStats.readTableFromParcel(in, this.mName, "durations");
            if (this.mDurationsTable == BAD_TABLE) {
                return false;
            }
            this.mDurationsTableSize = this.mDurationsTable != null ? this.mDurationsTable.length : 0;
            return true;
        }

        private final void $$robo$$com_android_internal_app_ProcessStats_DurationsTable$addDuration(int state, long dur) {
            int off;
            int idx = ProcessStats.binarySearch(this.mDurationsTable, this.mDurationsTableSize, state);
            if (idx >= 0) {
                off = this.mDurationsTable[idx];
            } else {
                this.mStats.mAddLongTable = this.mDurationsTable;
                this.mStats.mAddLongTableSize = this.mDurationsTableSize;
                off = this.mStats.addLongData(~idx, state, 1);
                this.mDurationsTable = this.mStats.mAddLongTable;
                this.mDurationsTableSize = this.mStats.mAddLongTableSize;
            }
            long[] longs = this.mStats.mLongs.get(off >> OFFSET_ARRAY_SHIFT & OFFSET_ARRAY_MASK);
            int n = off >> OFFSET_INDEX_SHIFT & OFFSET_INDEX_MASK;
            longs[n] = longs[n] + dur;
        }

        private final long $$robo$$com_android_internal_app_ProcessStats_DurationsTable$getDuration(int state, long now) {
            int idx = ProcessStats.binarySearch(this.mDurationsTable, this.mDurationsTableSize, state);
            return idx >= 0 ? this.mStats.getLong(this.mDurationsTable[idx], 0) : 0L;
        }

        private void __constructor__(ProcessStats processStats, String string2) {
            this.$$robo$$com_android_internal_app_ProcessStats_DurationsTable$__constructor__(processStats, string2);
        }

        public DurationsTable(ProcessStats processStats, String string2) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_app_ProcessStats_DurationsTable$__constructor__(com.android.internal.app.ProcessStats java.lang.String ), 0, this, processStats, string2);
        }

        void copyDurationsTo(DurationsTable durationsTable) {
            InvokeDynamicSupport.bootstrap("copyDurationsTo", $$robo$$com_android_internal_app_ProcessStats_DurationsTable$copyDurationsTo(com.android.internal.app.ProcessStats$DurationsTable ), 0, this, durationsTable);
        }

        void addDurations(DurationsTable durationsTable) {
            InvokeDynamicSupport.bootstrap("addDurations", $$robo$$com_android_internal_app_ProcessStats_DurationsTable$addDurations(com.android.internal.app.ProcessStats$DurationsTable ), 0, this, durationsTable);
        }

        void resetDurationsSafely() {
            InvokeDynamicSupport.bootstrap("resetDurationsSafely", $$robo$$com_android_internal_app_ProcessStats_DurationsTable$resetDurationsSafely(), 0, this);
        }

        void writeDurationsToParcel(Parcel parcel) {
            InvokeDynamicSupport.bootstrap("writeDurationsToParcel", $$robo$$com_android_internal_app_ProcessStats_DurationsTable$writeDurationsToParcel(android.os.Parcel ), 0, this, parcel);
        }

        boolean readDurationsFromParcel(Parcel parcel) {
            return (boolean)InvokeDynamicSupport.bootstrap("readDurationsFromParcel", $$robo$$com_android_internal_app_ProcessStats_DurationsTable$readDurationsFromParcel(android.os.Parcel ), 0, this, parcel);
        }

        void addDuration(int n, long l) {
            InvokeDynamicSupport.bootstrap("addDuration", $$robo$$com_android_internal_app_ProcessStats_DurationsTable$addDuration(int long ), 0, this, n, l);
        }

        long getDuration(int n, long l) {
            return (long)InvokeDynamicSupport.bootstrap("getDuration", $$robo$$com_android_internal_app_ProcessStats_DurationsTable$getDuration(int long ), 0, this, n, l);
        }

        public /* synthetic */ DurationsTable() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (DurationsTable)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class PssAggr
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        long pss;
        long samples;

        private void $$robo$$com_android_internal_app_ProcessStats_PssAggr$__constructor__() {
            this.pss = 0L;
            this.samples = 0L;
        }

        private final void $$robo$$com_android_internal_app_ProcessStats_PssAggr$add(long newPss, long newSamples) {
            this.pss = (long)((double)this.pss * (double)this.samples + (double)newPss * (double)newSamples) / (this.samples + newSamples);
            this.samples += newSamples;
        }

        private void __constructor__() {
            this.$$robo$$com_android_internal_app_ProcessStats_PssAggr$__constructor__();
        }

        PssAggr() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_app_ProcessStats_PssAggr$__constructor__(), 0, this);
        }

        void add(long l, long l2) {
            InvokeDynamicSupport.bootstrap("add", $$robo$$com_android_internal_app_ProcessStats_PssAggr$add(long long ), 0, this, l, l2);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (PssAggr)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

