/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.app;

import android.app.Activity;
import android.app.ActivityManager;
import android.app.ActivityManagerNative;
import android.app.ActivityThread;
import android.app.AppGlobals;
import android.app.usage.UsageStats;
import android.app.usage.UsageStatsManager;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.ActivityInfo;
import android.content.pm.ApplicationInfo;
import android.content.pm.LabeledIntent;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.content.pm.UserInfo;
import android.content.res.Resources;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.AsyncTask;
import android.os.Bundle;
import android.os.PatternMatcher;
import android.os.RemoteException;
import android.os.UserHandle;
import android.os.UserManager;
import android.text.TextUtils;
import android.util.Log;
import android.util.Slog;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.BaseAdapter;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.ListView;
import android.widget.TextView;
import android.widget.Toast;
import com.android.internal.content.PackageMonitor;
import com.android.internal.widget.ResolverDrawerLayout;
import com.google.errorprone.annotations.DoNotMock;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class ResolverActivity
extends Activity
implements AdapterView.OnItemClickListener,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "ResolverActivity";
    private static boolean DEBUG = false;
    private int mLaunchedFromUid;
    private ResolveListAdapter mAdapter;
    private PackageManager mPm;
    private boolean mSafeForwardingMode;
    private boolean mAlwaysUseOption;
    private boolean mShowExtended;
    private ListView mListView;
    private Button mAlwaysButton;
    private Button mOnceButton;
    private int mIconDpi;
    private int mIconSize;
    private int mMaxColumns;
    private int mLastSelected;
    private boolean mResolvingHome;
    private UsageStatsManager mUsm;
    private Map<String, UsageStats> mStats;
    private static long USAGE_STATS_PERIOD = 1209600000L;
    private boolean mRegistered;
    private PackageMonitor mPackageMonitor;

    private void $$robo$$com_android_internal_app_ResolverActivity$__constructor__() {
        this.mLastSelected = -1;
        this.mResolvingHome = false;
        this.mPackageMonitor = new ShadowedObject(this){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ ResolverActivity this$0;

            private void $$robo$$com_android_internal_app_ResolverActivity_1$__constructor__(ResolverActivity resolverActivity) {
            }

            private final void $$robo$$com_android_internal_app_ResolverActivity_1$onSomePackagesChanged() {
                this.this$0.mAdapter.handlePackagesChanged();
            }

            private void __constructor__(ResolverActivity resolverActivity) {
                this.$$robo$$com_android_internal_app_ResolverActivity_1$__constructor__(resolverActivity);
            }
            {
                this.this$0 = resolverActivity;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_app_ResolverActivity_1$__constructor__(com.android.internal.app.ResolverActivity ), 0, this, resolverActivity);
            }

            @Override
            public void onSomePackagesChanged() {
                InvokeDynamicSupport.bootstrap("onSomePackagesChanged", $$robo$$com_android_internal_app_ResolverActivity_1$onSomePackagesChanged(), 0, this);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
    }

    private final Intent $$robo$$com_android_internal_app_ResolverActivity$makeMyIntent() {
        Intent intent = new Intent(this.getIntent());
        intent.setComponent(null);
        intent.setFlags(intent.getFlags() & 0xFF7FFFFF);
        return intent;
    }

    private final void $$robo$$com_android_internal_app_ResolverActivity$onCreate(Bundle savedInstanceState) {
        Intent intent = this.makeMyIntent();
        Set<String> categories = intent.getCategories();
        if ("android.intent.action.MAIN".equals(intent.getAction()) && categories != null && categories.size() == 1 && categories.contains("android.intent.category.HOME")) {
            this.mResolvingHome = true;
        }
        this.setSafeForwardingMode(true);
        this.onCreate(savedInstanceState, intent, null, 0, null, null, true);
    }

    private final void $$robo$$com_android_internal_app_ResolverActivity$onCreate(Bundle savedInstanceState, Intent intent, CharSequence title, Intent[] initialIntents, List<ResolveInfo> rList, boolean alwaysUseOption) {
        this.onCreate(savedInstanceState, intent, title, 0, initialIntents, rList, alwaysUseOption);
    }

    private final void $$robo$$com_android_internal_app_ResolverActivity$onCreate(Bundle savedInstanceState, Intent intent, CharSequence title, int defaultTitleRes, Intent[] initialIntents, List<ResolveInfo> rList, boolean alwaysUseOption) {
        ResolverDrawerLayout rdl;
        boolean useHeader;
        int layoutId;
        this.setTheme(16974991);
        super.onCreate(savedInstanceState);
        try {
            this.mLaunchedFromUid = ActivityManagerNative.getDefault().getLaunchedFromUid(this.getActivityToken());
        }
        catch (RemoteException remoteException) {
            this.mLaunchedFromUid = -1;
        }
        this.mPm = this.getPackageManager();
        this.mUsm = (UsageStatsManager)this.getSystemService("usagestats");
        reference var8_9 = InvokeDynamicSupport.bootstrapIntrinsic("currentTimeMillis", "java.lang.System") - 1209600000L;
        this.mStats = this.mUsm.queryAndAggregateUsageStats((long)var8_9, (long)InvokeDynamicSupport.bootstrapIntrinsic("currentTimeMillis", "java.lang.System"));
        Log.d("ResolverActivity", "sinceTime=" + (long)var8_9);
        this.mMaxColumns = this.getResources().getInteger(17694829);
        this.mPackageMonitor.register(this, this.getMainLooper(), false);
        this.mRegistered = true;
        ActivityManager am = (ActivityManager)this.getSystemService("activity");
        this.mIconDpi = am.getLauncherLargeIconDensity();
        this.mIconSize = am.getLauncherLargeIconSize();
        this.mAdapter = new ResolveListAdapter(this, this, intent, initialIntents, rList, this.mLaunchedFromUid, alwaysUseOption);
        if (this.mAdapter.hasFilteredItem()) {
            layoutId = 17367215;
            alwaysUseOption = false;
            useHeader = true;
        } else {
            useHeader = false;
            layoutId = 17367214;
        }
        this.mAlwaysUseOption = alwaysUseOption;
        int count = this.mAdapter.mList.size();
        if (this.mLaunchedFromUid < 0 || UserHandle.isIsolated(this.mLaunchedFromUid)) {
            this.finish();
            return;
        }
        if (count > 1) {
            this.setContentView(layoutId);
            this.mListView = (ListView)this.findViewById(16909156);
            this.mListView.setAdapter(this.mAdapter);
            this.mListView.setOnItemClickListener(this);
            this.mListView.setOnItemLongClickListener(new ItemLongClickListener(this));
            if (alwaysUseOption) {
                this.mListView.setChoiceMode(1);
            }
            if (useHeader) {
                this.mListView.addHeaderView(LayoutInflater.from(this).inflate(17367213, (ViewGroup)this.mListView, false));
            }
        } else {
            if (count == 1) {
                this.safelyStartActivity(this.mAdapter.intentForPosition(0, false));
                this.mPackageMonitor.unregister();
                this.mRegistered = false;
                this.finish();
                return;
            }
            this.setContentView(17367214);
            TextView empty = (TextView)this.findViewById(16908292);
            empty.setVisibility(0);
            this.mListView = (ListView)this.findViewById(16909156);
            this.mListView.setVisibility(8);
        }
        if ((rdl = (ResolverDrawerLayout)this.findViewById(16908996)) != null) {
            rdl.setOnClickOutsideListener(new View.OnClickListener(this){
                public transient /* synthetic */ Object __robo_data__;
                /* synthetic */ ResolverActivity this$0;

                private void $$robo$$com_android_internal_app_ResolverActivity_2$__constructor__(ResolverActivity resolverActivity) {
                }

                private final void $$robo$$com_android_internal_app_ResolverActivity_2$onClick(View v) {
                    this.this$0.finish();
                }

                private void __constructor__(ResolverActivity resolverActivity) {
                    this.$$robo$$com_android_internal_app_ResolverActivity_2$__constructor__(resolverActivity);
                }
                {
                    this.this$0 = resolverActivity;
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_app_ResolverActivity_2$__constructor__(com.android.internal.app.ResolverActivity ), 0, this, resolverActivity);
                }

                @Override
                public void onClick(View view) {
                    InvokeDynamicSupport.bootstrap("onClick", $$robo$$com_android_internal_app_ResolverActivity_2$onClick(android.view.View ), 0, this, view);
                }
                {
                    this.$$robo$init();
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            });
        }
        if (title == null) {
            title = this.getTitleForAction(intent.getAction(), defaultTitleRes);
        }
        if (!TextUtils.isEmpty(title)) {
            TextView titleView = (TextView)this.findViewById(16908310);
            if (titleView != null) {
                titleView.setText(title);
            }
            this.setTitle(title);
        }
        ImageView iconView = (ImageView)this.findViewById(16908294);
        DisplayResolveInfo iconInfo = this.mAdapter.getFilteredItem();
        if (iconView != null && iconInfo != null) {
            new LoadIconIntoViewTask(this, iconView).execute(iconInfo);
        }
        if (alwaysUseOption || this.mAdapter.hasFilteredItem()) {
            ViewGroup buttonLayout = (ViewGroup)this.findViewById(16909010);
            if (buttonLayout != null) {
                buttonLayout.setVisibility(0);
                this.mAlwaysButton = (Button)buttonLayout.findViewById(16909158);
                this.mOnceButton = (Button)buttonLayout.findViewById(16909157);
            } else {
                this.mAlwaysUseOption = false;
            }
        }
        if (this.mAdapter.hasFilteredItem()) {
            this.setAlwaysButtonEnabled(true, this.mAdapter.getFilteredPosition(), false);
            this.mOnceButton.setEnabled(true);
        }
    }

    private final void $$robo$$com_android_internal_app_ResolverActivity$setSafeForwardingMode(boolean safeForwarding) {
        this.mSafeForwardingMode = safeForwarding;
    }

    private final CharSequence $$robo$$com_android_internal_app_ResolverActivity$getTitleForAction(String action, int defaultTitleRes) {
        ActionTitle title = this.mResolvingHome ? ActionTitle.HOME : ActionTitle.forAction(action);
        boolean named = this.mAdapter.hasFilteredItem();
        if (title == ActionTitle.DEFAULT && defaultTitleRes != 0) {
            return this.getString(defaultTitleRes);
        }
        return named ? this.getString(title.namedTitleRes, this.mAdapter.getFilteredItem().displayLabel) : this.getString(title.titleRes);
    }

    private final void $$robo$$com_android_internal_app_ResolverActivity$dismiss() {
        if (!this.isFinishing()) {
            this.finish();
        }
    }

    private final Drawable $$robo$$com_android_internal_app_ResolverActivity$getIcon(Resources res, int resId) {
        Drawable result;
        try {
            result = res.getDrawableForDensity(resId, this.mIconDpi);
        }
        catch (Resources.NotFoundException e) {
            result = null;
        }
        return result;
    }

    private final Drawable $$robo$$com_android_internal_app_ResolverActivity$loadIconForResolveInfo(ResolveInfo ri) {
        try {
            Drawable dr;
            if (ri.resolvePackageName != null && ri.icon != 0 && (dr = this.getIcon(this.mPm.getResourcesForApplication(ri.resolvePackageName), ri.icon)) != null) {
                return dr;
            }
            int iconRes = ri.getIconResource();
            if (iconRes != 0 && (dr = this.getIcon(this.mPm.getResourcesForApplication(ri.activityInfo.packageName), iconRes)) != null) {
                return dr;
            }
        }
        catch (PackageManager.NameNotFoundException e) {
            Log.e("ResolverActivity", "Couldn't find resources for package", e);
        }
        return ri.loadIcon(this.mPm);
    }

    private final void $$robo$$com_android_internal_app_ResolverActivity$onRestart() {
        super.onRestart();
        if (!this.mRegistered) {
            this.mPackageMonitor.register(this, this.getMainLooper(), false);
            this.mRegistered = true;
        }
        this.mAdapter.handlePackagesChanged();
    }

    private final void $$robo$$com_android_internal_app_ResolverActivity$onStop() {
        super.onStop();
        if (this.mRegistered) {
            this.mPackageMonitor.unregister();
            this.mRegistered = false;
        }
        if ((this.getIntent().getFlags() & 0x10000000) != 0 && !this.isChangingConfigurations()) {
            this.finish();
        }
    }

    private final void $$robo$$com_android_internal_app_ResolverActivity$onRestoreInstanceState(Bundle savedInstanceState) {
        super.onRestoreInstanceState(savedInstanceState);
        if (this.mAlwaysUseOption) {
            int checkedPos = this.mListView.getCheckedItemPosition();
            boolean hasValidSelection = checkedPos != -1;
            this.mLastSelected = checkedPos;
            this.setAlwaysButtonEnabled(hasValidSelection, checkedPos, true);
            this.mOnceButton.setEnabled(hasValidSelection);
            if (hasValidSelection) {
                this.mListView.setSelection(checkedPos);
            }
        }
    }

    private final void $$robo$$com_android_internal_app_ResolverActivity$onItemClick(AdapterView<?> parent, View view, int position, long id2) {
        boolean hasValidSelection;
        if ((position -= this.mListView.getHeaderViewsCount()) < 0) {
            return;
        }
        ResolveInfo resolveInfo = this.mAdapter.resolveInfoForPosition(position, true);
        if (this.mResolvingHome && this.hasManagedProfile() && !this.supportsManagedProfiles(resolveInfo)) {
            Toast.makeText((Context)this, String.format(this.getResources().getString(17040824), resolveInfo.activityInfo.loadLabel(this.getPackageManager()).toString()), 1).show();
            return;
        }
        int checkedPos = this.mListView.getCheckedItemPosition();
        boolean bl = hasValidSelection = checkedPos != -1;
        if (this.mAlwaysUseOption && (!hasValidSelection || this.mLastSelected != checkedPos)) {
            this.setAlwaysButtonEnabled(hasValidSelection, checkedPos, true);
            this.mOnceButton.setEnabled(hasValidSelection);
            if (hasValidSelection) {
                this.mListView.smoothScrollToPosition(checkedPos);
            }
            this.mLastSelected = checkedPos;
        } else {
            this.startSelected(position, false, true);
        }
    }

    private final boolean $$robo$$com_android_internal_app_ResolverActivity$hasManagedProfile() {
        UserManager userManager = (UserManager)this.getSystemService("user");
        if (userManager == null) {
            return false;
        }
        try {
            List<UserInfo> profiles = userManager.getProfiles(this.getUserId());
            for (UserInfo userInfo : profiles) {
                if (userInfo == null || !userInfo.isManagedProfile()) continue;
                return true;
            }
        }
        catch (SecurityException e) {
            return false;
        }
        return false;
    }

    private final boolean $$robo$$com_android_internal_app_ResolverActivity$supportsManagedProfiles(ResolveInfo resolveInfo) {
        try {
            ApplicationInfo appInfo = this.getPackageManager().getApplicationInfo(resolveInfo.activityInfo.packageName, 0);
            return this.versionNumberAtLeastL(appInfo.targetSdkVersion);
        }
        catch (PackageManager.NameNotFoundException e) {
            return false;
        }
    }

    private final boolean $$robo$$com_android_internal_app_ResolverActivity$versionNumberAtLeastL(int versionNumber) {
        return versionNumber >= 21;
    }

    private final void $$robo$$com_android_internal_app_ResolverActivity$setAlwaysButtonEnabled(boolean hasValidSelection, int checkedPos, boolean filtered) {
        boolean enabled = false;
        if (hasValidSelection) {
            ResolveInfo ri = this.mAdapter.resolveInfoForPosition(checkedPos, filtered);
            if (ri.targetUserId == -2) {
                enabled = true;
            }
        }
        this.mAlwaysButton.setEnabled(enabled);
    }

    private final void $$robo$$com_android_internal_app_ResolverActivity$onButtonClick(View v) {
        int id2 = v.getId();
        this.startSelected(this.mAlwaysUseOption ? this.mListView.getCheckedItemPosition() : this.mAdapter.getFilteredPosition(), id2 == 16909158, this.mAlwaysUseOption);
        this.dismiss();
    }

    private final void $$robo$$com_android_internal_app_ResolverActivity$startSelected(int which, boolean always, boolean filtered) {
        if (this.isFinishing()) {
            return;
        }
        ResolveInfo ri = this.mAdapter.resolveInfoForPosition(which, filtered);
        Intent intent = this.mAdapter.intentForPosition(which, filtered);
        this.onIntentSelected(ri, intent, always);
        this.finish();
    }

    private final Intent $$robo$$com_android_internal_app_ResolverActivity$getReplacementIntent(String packageName, Intent defIntent) {
        return defIntent;
    }

    private final void $$robo$$com_android_internal_app_ResolverActivity$onIntentSelected(ResolveInfo ri, Intent intent, boolean alwaysCheck) {
        if ((this.mAlwaysUseOption || this.mAdapter.hasFilteredItem()) && this.mAdapter.mOrigResolveList != null) {
            String mimeType;
            Set<String> categories;
            IntentFilter filter = new IntentFilter();
            if (intent.getAction() != null) {
                filter.addAction(intent.getAction());
            }
            if ((categories = intent.getCategories()) != null) {
                for (String cat : categories) {
                    filter.addCategory(cat);
                }
            }
            filter.addCategory("android.intent.category.DEFAULT");
            int cat = ri.match & 0xFFF0000;
            Uri data = intent.getData();
            if (cat == 0x600000 && (mimeType = intent.resolveType(this)) != null) {
                try {
                    filter.addDataType(mimeType);
                }
                catch (IntentFilter.MalformedMimeTypeException e) {
                    Log.w("ResolverActivity", e);
                    filter = null;
                }
            }
            if (data != null && data.getScheme() != null && (cat != 0x600000 || !"file".equals(data.getScheme()) && !"content".equals(data.getScheme()))) {
                Iterator<IntentFilter.AuthorityEntry> aIt;
                filter.addDataScheme(data.getScheme());
                Iterator<PatternMatcher> pIt = ri.filter.schemeSpecificPartsIterator();
                if (pIt != null) {
                    String ssp = data.getSchemeSpecificPart();
                    while (ssp != null && pIt.hasNext()) {
                        PatternMatcher p = pIt.next();
                        if (!p.match(ssp)) continue;
                        filter.addDataSchemeSpecificPart(p.getPath(), p.getType());
                        break;
                    }
                }
                if ((aIt = ri.filter.authoritiesIterator()) != null) {
                    while (aIt.hasNext()) {
                        IntentFilter.AuthorityEntry a = aIt.next();
                        if (a.match(data) < 0) continue;
                        int port = a.getPort();
                        filter.addDataAuthority(a.getHost(), port >= 0 ? Integer.toString(port) : null);
                        break;
                    }
                }
                if ((pIt = ri.filter.pathsIterator()) != null) {
                    String path = data.getPath();
                    while (path != null && pIt.hasNext()) {
                        PatternMatcher p = pIt.next();
                        if (!p.match(path)) continue;
                        filter.addDataPath(p.getPath(), p.getType());
                        break;
                    }
                }
            }
            if (filter != null) {
                int N = this.mAdapter.mOrigResolveList.size();
                ComponentName[] set = new ComponentName[N];
                int bestMatch = 0;
                for (int i = 0; i < N; ++i) {
                    ResolveInfo r = this.mAdapter.mOrigResolveList.get(i);
                    set[i] = new ComponentName(r.activityInfo.packageName, r.activityInfo.name);
                    if (r.match <= bestMatch) continue;
                    bestMatch = r.match;
                }
                if (alwaysCheck) {
                    this.getPackageManager().addPreferredActivity(filter, bestMatch, set, intent.getComponent());
                } else {
                    try {
                        AppGlobals.getPackageManager().setLastChosenActivity(intent, intent.resolveTypeIfNeeded(this.getContentResolver()), 65536, filter, bestMatch, intent.getComponent());
                    }
                    catch (RemoteException re) {
                        Log.d("ResolverActivity", "Error calling setLastChosenActivity\n" + re);
                    }
                }
            }
        }
        if (intent != null) {
            this.safelyStartActivity(intent);
        }
    }

    private final void $$robo$$com_android_internal_app_ResolverActivity$safelyStartActivity(Intent intent) {
        if (!this.mSafeForwardingMode) {
            this.startActivity(intent);
            return;
        }
        try {
            this.startActivityAsCaller(intent, null, -10000);
        }
        catch (RuntimeException e) {
            String launchedFromPackage;
            try {
                launchedFromPackage = ActivityManagerNative.getDefault().getLaunchedFromPackage(this.getActivityToken());
            }
            catch (RemoteException e2) {
                launchedFromPackage = "??";
            }
            Slog.wtf("ResolverActivity", "Unable to launch as uid " + this.mLaunchedFromUid + " package " + launchedFromPackage + ", while running in " + ActivityThread.currentProcessName(), e);
        }
    }

    private final void $$robo$$com_android_internal_app_ResolverActivity$showAppDetails(ResolveInfo ri) {
        Intent in = new Intent().setAction("android.settings.APPLICATION_DETAILS_SETTINGS").setData(Uri.fromParts("package", ri.activityInfo.packageName, null)).addFlags(524288);
        this.startActivity(in);
    }

    private void __constructor__() {
        this.$$robo$$com_android_internal_app_ResolverActivity$__constructor__();
    }

    public ResolverActivity() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_app_ResolverActivity$__constructor__(), 0, this);
    }

    private Intent makeMyIntent() {
        return InvokeDynamicSupport.bootstrap("makeMyIntent", $$robo$$com_android_internal_app_ResolverActivity$makeMyIntent(), 0, this);
    }

    @Override
    protected void onCreate(Bundle bundle) {
        InvokeDynamicSupport.bootstrap("onCreate", $$robo$$com_android_internal_app_ResolverActivity$onCreate(android.os.Bundle ), 0, this, bundle);
    }

    protected void onCreate(Bundle bundle, Intent intent, CharSequence charSequence, Intent[] intentArray, List<ResolveInfo> list, boolean bl) {
        InvokeDynamicSupport.bootstrap("onCreate", $$robo$$com_android_internal_app_ResolverActivity$onCreate(android.os.Bundle android.content.Intent java.lang.CharSequence android.content.Intent[] java.util.List<android.content.pm.ResolveInfo> boolean ), 0, this, bundle, intent, charSequence, intentArray, list, bl);
    }

    protected void onCreate(Bundle bundle, Intent intent, CharSequence charSequence, int n, Intent[] intentArray, List<ResolveInfo> list, boolean bl) {
        InvokeDynamicSupport.bootstrap("onCreate", $$robo$$com_android_internal_app_ResolverActivity$onCreate(android.os.Bundle android.content.Intent java.lang.CharSequence int android.content.Intent[] java.util.List<android.content.pm.ResolveInfo> boolean ), 0, this, bundle, intent, charSequence, n, intentArray, list, bl);
    }

    public void setSafeForwardingMode(boolean bl) {
        InvokeDynamicSupport.bootstrap("setSafeForwardingMode", $$robo$$com_android_internal_app_ResolverActivity$setSafeForwardingMode(boolean ), 0, this, bl);
    }

    protected CharSequence getTitleForAction(String string2, int n) {
        return InvokeDynamicSupport.bootstrap("getTitleForAction", $$robo$$com_android_internal_app_ResolverActivity$getTitleForAction(java.lang.String int ), 0, this, string2, n);
    }

    void dismiss() {
        InvokeDynamicSupport.bootstrap("dismiss", $$robo$$com_android_internal_app_ResolverActivity$dismiss(), 0, this);
    }

    Drawable getIcon(Resources resources, int n) {
        return InvokeDynamicSupport.bootstrap("getIcon", $$robo$$com_android_internal_app_ResolverActivity$getIcon(android.content.res.Resources int ), 0, this, resources, n);
    }

    Drawable loadIconForResolveInfo(ResolveInfo resolveInfo) {
        return InvokeDynamicSupport.bootstrap("loadIconForResolveInfo", $$robo$$com_android_internal_app_ResolverActivity$loadIconForResolveInfo(android.content.pm.ResolveInfo ), 0, this, resolveInfo);
    }

    @Override
    protected void onRestart() {
        InvokeDynamicSupport.bootstrap("onRestart", $$robo$$com_android_internal_app_ResolverActivity$onRestart(), 0, this);
    }

    @Override
    protected void onStop() {
        InvokeDynamicSupport.bootstrap("onStop", $$robo$$com_android_internal_app_ResolverActivity$onStop(), 0, this);
    }

    @Override
    protected void onRestoreInstanceState(Bundle bundle) {
        InvokeDynamicSupport.bootstrap("onRestoreInstanceState", $$robo$$com_android_internal_app_ResolverActivity$onRestoreInstanceState(android.os.Bundle ), 0, this, bundle);
    }

    @Override
    public void onItemClick(AdapterView<?> adapterView, View view, int n, long l) {
        InvokeDynamicSupport.bootstrap("onItemClick", $$robo$$com_android_internal_app_ResolverActivity$onItemClick(android.widget.AdapterView<?> android.view.View int long ), 0, this, adapterView, view, n, l);
    }

    private boolean hasManagedProfile() {
        return (boolean)InvokeDynamicSupport.bootstrap("hasManagedProfile", $$robo$$com_android_internal_app_ResolverActivity$hasManagedProfile(), 0, this);
    }

    private boolean supportsManagedProfiles(ResolveInfo resolveInfo) {
        return (boolean)InvokeDynamicSupport.bootstrap("supportsManagedProfiles", $$robo$$com_android_internal_app_ResolverActivity$supportsManagedProfiles(android.content.pm.ResolveInfo ), 0, this, resolveInfo);
    }

    private boolean versionNumberAtLeastL(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("versionNumberAtLeastL", $$robo$$com_android_internal_app_ResolverActivity$versionNumberAtLeastL(int ), 0, this, n);
    }

    private void setAlwaysButtonEnabled(boolean bl, int n, boolean bl2) {
        InvokeDynamicSupport.bootstrap("setAlwaysButtonEnabled", $$robo$$com_android_internal_app_ResolverActivity$setAlwaysButtonEnabled(boolean int boolean ), 0, this, bl, n, bl2);
    }

    public void onButtonClick(View view) {
        InvokeDynamicSupport.bootstrap("onButtonClick", $$robo$$com_android_internal_app_ResolverActivity$onButtonClick(android.view.View ), 0, this, view);
    }

    void startSelected(int n, boolean bl, boolean bl2) {
        InvokeDynamicSupport.bootstrap("startSelected", $$robo$$com_android_internal_app_ResolverActivity$startSelected(int boolean boolean ), 0, this, n, bl, bl2);
    }

    public Intent getReplacementIntent(String string2, Intent intent) {
        return InvokeDynamicSupport.bootstrap("getReplacementIntent", $$robo$$com_android_internal_app_ResolverActivity$getReplacementIntent(java.lang.String android.content.Intent ), 0, this, string2, intent);
    }

    protected void onIntentSelected(ResolveInfo resolveInfo, Intent intent, boolean bl) {
        InvokeDynamicSupport.bootstrap("onIntentSelected", $$robo$$com_android_internal_app_ResolverActivity$onIntentSelected(android.content.pm.ResolveInfo android.content.Intent boolean ), 0, this, resolveInfo, intent, bl);
    }

    public void safelyStartActivity(Intent intent) {
        InvokeDynamicSupport.bootstrap("safelyStartActivity", $$robo$$com_android_internal_app_ResolverActivity$safelyStartActivity(android.content.Intent ), 0, this, intent);
    }

    void showAppDetails(ResolveInfo resolveInfo) {
        InvokeDynamicSupport.bootstrap("showAppDetails", $$robo$$com_android_internal_app_ResolverActivity$showAppDetails(android.content.pm.ResolveInfo ), 0, this, resolveInfo);
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ResolverActivity)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public class ResolverComparator
    implements Comparator<ResolveInfo> {
        public transient /* synthetic */ Object __robo_data__;
        private Collator mCollator;
        /* synthetic */ ResolverActivity this$0;

        private void $$robo$$com_android_internal_app_ResolverActivity_ResolverComparator$__constructor__(ResolverActivity resolverActivity, Context context) {
            this.mCollator = Collator.getInstance(context.getResources().getConfiguration().locale);
        }

        private final int $$robo$$com_android_internal_app_ResolverActivity_ResolverComparator$compare(ResolveInfo lhs, ResolveInfo rhs) {
            CharSequence sb;
            long timeDiff;
            if (lhs.targetUserId != -2) {
                return 1;
            }
            if (this.this$0.mStats != null && (timeDiff = this.getPackageTimeSpent(rhs.activityInfo.packageName) - this.getPackageTimeSpent(lhs.activityInfo.packageName)) != 0L) {
                return timeDiff > 0L ? 1 : -1;
            }
            CharSequence sa = lhs.loadLabel(this.this$0.mPm);
            if (sa == null) {
                sa = lhs.activityInfo.name;
            }
            if ((sb = rhs.loadLabel(this.this$0.mPm)) == null) {
                sb = rhs.activityInfo.name;
            }
            return this.mCollator.compare(sa.toString(), sb.toString());
        }

        private final long $$robo$$com_android_internal_app_ResolverActivity_ResolverComparator$getPackageTimeSpent(String packageName) {
            UsageStats stats;
            if (this.this$0.mStats != null && (stats = (UsageStats)this.this$0.mStats.get(packageName)) != null) {
                return stats.getTotalTimeInForeground();
            }
            return 0L;
        }

        private void __constructor__(ResolverActivity resolverActivity, Context context) {
            this.$$robo$$com_android_internal_app_ResolverActivity_ResolverComparator$__constructor__(resolverActivity, context);
        }

        public ResolverComparator(ResolverActivity resolverActivity, Context context) {
            this.this$0 = resolverActivity;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_app_ResolverActivity_ResolverComparator$__constructor__(com.android.internal.app.ResolverActivity android.content.Context ), 0, this, resolverActivity, context);
        }

        @Override
        public int compare(ResolveInfo resolveInfo, ResolveInfo resolveInfo2) {
            return (int)InvokeDynamicSupport.bootstrap("compare", $$robo$$com_android_internal_app_ResolverActivity_ResolverComparator$compare(android.content.pm.ResolveInfo android.content.pm.ResolveInfo ), 0, this, resolveInfo, resolveInfo2);
        }

        private long getPackageTimeSpent(String string2) {
            return (long)InvokeDynamicSupport.bootstrap("getPackageTimeSpent", $$robo$$com_android_internal_app_ResolverActivity_ResolverComparator$getPackageTimeSpent(java.lang.String ), 0, this, string2);
        }

        public /* synthetic */ ResolverComparator() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ResolverComparator)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public class LoadIconIntoViewTask
    extends AsyncTask<DisplayResolveInfo, Void, DisplayResolveInfo> {
        public transient /* synthetic */ Object __robo_data__;
        ImageView mTargetView;
        /* synthetic */ ResolverActivity this$0;

        private void $$robo$$com_android_internal_app_ResolverActivity_LoadIconIntoViewTask$__constructor__(ResolverActivity resolverActivity, ImageView target) {
            this.mTargetView = target;
        }

        private final DisplayResolveInfo $$robo$$com_android_internal_app_ResolverActivity_LoadIconIntoViewTask$doInBackground(DisplayResolveInfo ... params) {
            DisplayResolveInfo info = params[0];
            if (info.displayIcon == null) {
                info.displayIcon = this.this$0.loadIconForResolveInfo(info.ri);
            }
            return info;
        }

        private final void $$robo$$com_android_internal_app_ResolverActivity_LoadIconIntoViewTask$onPostExecute(DisplayResolveInfo info) {
            this.mTargetView.setImageDrawable(info.displayIcon);
        }

        private void __constructor__(ResolverActivity resolverActivity, ImageView imageView) {
            this.$$robo$$com_android_internal_app_ResolverActivity_LoadIconIntoViewTask$__constructor__(resolverActivity, imageView);
        }

        public LoadIconIntoViewTask(ResolverActivity resolverActivity, ImageView imageView) {
            this.this$0 = resolverActivity;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_app_ResolverActivity_LoadIconIntoViewTask$__constructor__(com.android.internal.app.ResolverActivity android.widget.ImageView ), 0, this, resolverActivity, imageView);
        }

        protected DisplayResolveInfo doInBackground(DisplayResolveInfo ... displayResolveInfoArray) {
            return InvokeDynamicSupport.bootstrap("doInBackground", $$robo$$com_android_internal_app_ResolverActivity_LoadIconIntoViewTask$doInBackground(com.android.internal.app.ResolverActivity$DisplayResolveInfo[] ), 0, this, displayResolveInfoArray);
        }

        @Override
        protected void onPostExecute(DisplayResolveInfo displayResolveInfo) {
            InvokeDynamicSupport.bootstrap("onPostExecute", $$robo$$com_android_internal_app_ResolverActivity_LoadIconIntoViewTask$onPostExecute(com.android.internal.app.ResolverActivity$DisplayResolveInfo ), 0, this, displayResolveInfo);
        }

        public /* synthetic */ LoadIconIntoViewTask() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (LoadIconIntoViewTask)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public class LoadIconTask
    extends AsyncTask<DisplayResolveInfo, Void, DisplayResolveInfo> {
        public transient /* synthetic */ Object __robo_data__;
        /* synthetic */ ResolverActivity this$0;

        private void $$robo$$com_android_internal_app_ResolverActivity_LoadIconTask$__constructor__(ResolverActivity resolverActivity) {
        }

        private final DisplayResolveInfo $$robo$$com_android_internal_app_ResolverActivity_LoadIconTask$doInBackground(DisplayResolveInfo ... params) {
            DisplayResolveInfo info = params[0];
            if (info.displayIcon == null) {
                info.displayIcon = this.this$0.loadIconForResolveInfo(info.ri);
            }
            return info;
        }

        private final void $$robo$$com_android_internal_app_ResolverActivity_LoadIconTask$onPostExecute(DisplayResolveInfo info) {
            this.this$0.mAdapter.notifyDataSetChanged();
        }

        private void __constructor__(ResolverActivity resolverActivity) {
            this.$$robo$$com_android_internal_app_ResolverActivity_LoadIconTask$__constructor__(resolverActivity);
        }

        LoadIconTask(ResolverActivity resolverActivity) {
            this.this$0 = resolverActivity;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_app_ResolverActivity_LoadIconTask$__constructor__(com.android.internal.app.ResolverActivity ), 0, this, resolverActivity);
        }

        protected DisplayResolveInfo doInBackground(DisplayResolveInfo ... displayResolveInfoArray) {
            return InvokeDynamicSupport.bootstrap("doInBackground", $$robo$$com_android_internal_app_ResolverActivity_LoadIconTask$doInBackground(com.android.internal.app.ResolverActivity$DisplayResolveInfo[] ), 0, this, displayResolveInfoArray);
        }

        @Override
        protected void onPostExecute(DisplayResolveInfo displayResolveInfo) {
            InvokeDynamicSupport.bootstrap("onPostExecute", $$robo$$com_android_internal_app_ResolverActivity_LoadIconTask$onPostExecute(com.android.internal.app.ResolverActivity$DisplayResolveInfo ), 0, this, displayResolveInfo);
        }

        public /* synthetic */ LoadIconTask() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (LoadIconTask)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public class ItemLongClickListener
    implements AdapterView.OnItemLongClickListener,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        /* synthetic */ ResolverActivity this$0;

        private void $$robo$$com_android_internal_app_ResolverActivity_ItemLongClickListener$__constructor__(ResolverActivity resolverActivity) {
        }

        private final boolean $$robo$$com_android_internal_app_ResolverActivity_ItemLongClickListener$onItemLongClick(AdapterView<?> parent, View view, int position, long id2) {
            if ((position -= this.this$0.mListView.getHeaderViewsCount()) < 0) {
                return false;
            }
            ResolveInfo ri = this.this$0.mAdapter.resolveInfoForPosition(position, true);
            this.this$0.showAppDetails(ri);
            return true;
        }

        private void __constructor__(ResolverActivity resolverActivity) {
            this.$$robo$$com_android_internal_app_ResolverActivity_ItemLongClickListener$__constructor__(resolverActivity);
        }

        ItemLongClickListener(ResolverActivity resolverActivity) {
            this.this$0 = resolverActivity;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_app_ResolverActivity_ItemLongClickListener$__constructor__(com.android.internal.app.ResolverActivity ), 0, this, resolverActivity);
        }

        @Override
        public boolean onItemLongClick(AdapterView<?> adapterView, View view, int n, long l) {
            return (boolean)InvokeDynamicSupport.bootstrap("onItemLongClick", $$robo$$com_android_internal_app_ResolverActivity_ItemLongClickListener$onItemLongClick(android.widget.AdapterView<?> android.view.View int long ), 0, this, adapterView, view, n, l);
        }

        public /* synthetic */ ItemLongClickListener() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ItemLongClickListener)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class ViewHolder
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public TextView text;
        public TextView text2;
        public ImageView icon;

        private void $$robo$$com_android_internal_app_ResolverActivity_ViewHolder$__constructor__(View view) {
            this.text = (TextView)view.findViewById(16908308);
            this.text2 = (TextView)view.findViewById(16908309);
            this.icon = (ImageView)view.findViewById(16908294);
        }

        private void __constructor__(View view) {
            this.$$robo$$com_android_internal_app_ResolverActivity_ViewHolder$__constructor__(view);
        }

        public ViewHolder(View view) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_app_ResolverActivity_ViewHolder$__constructor__(android.view.View ), 0, this, view);
        }

        public /* synthetic */ ViewHolder() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ViewHolder)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    private final class ResolveListAdapter
    extends BaseAdapter
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private Intent[] mInitialIntents;
        private List<ResolveInfo> mBaseResolveList;
        private ResolveInfo mLastChosen;
        private Intent mIntent;
        private int mLaunchedFromUid;
        private LayoutInflater mInflater;
        List<DisplayResolveInfo> mList;
        List<ResolveInfo> mOrigResolveList;
        private int mLastChosenPosition;
        private boolean mFilterLastUsed;
        /* synthetic */ ResolverActivity this$0;

        private void $$robo$$com_android_internal_app_ResolverActivity_ResolveListAdapter$__constructor__(ResolverActivity resolverActivity, Context context, Intent intent, Intent[] initialIntents, List<ResolveInfo> rList, int launchedFromUid, boolean filterLastUsed) {
            this.mLastChosenPosition = -1;
            this.mIntent = new Intent(intent);
            this.mInitialIntents = initialIntents;
            this.mBaseResolveList = rList;
            this.mLaunchedFromUid = launchedFromUid;
            this.mInflater = LayoutInflater.from(context);
            this.mList = new ArrayList<DisplayResolveInfo>();
            this.mFilterLastUsed = filterLastUsed;
            this.rebuildList();
        }

        private final void $$robo$$com_android_internal_app_ResolverActivity_ResolveListAdapter$handlePackagesChanged() {
            int oldItemCount = this.getCount();
            this.rebuildList();
            this.notifyDataSetChanged();
            int newItemCount = this.getCount();
            if (newItemCount == 0) {
                this.this$0.finish();
            }
        }

        private final DisplayResolveInfo $$robo$$com_android_internal_app_ResolverActivity_ResolveListAdapter$getFilteredItem() {
            if (this.mFilterLastUsed && this.mLastChosenPosition >= 0) {
                return this.mList.get(this.mLastChosenPosition);
            }
            return null;
        }

        private final int $$robo$$com_android_internal_app_ResolverActivity_ResolveListAdapter$getFilteredPosition() {
            if (this.mFilterLastUsed && this.mLastChosenPosition >= 0) {
                return this.mLastChosenPosition;
            }
            return -1;
        }

        private final boolean $$robo$$com_android_internal_app_ResolverActivity_ResolveListAdapter$hasFilteredItem() {
            return this.mFilterLastUsed && this.mLastChosenPosition >= 0;
        }

        private final void $$robo$$com_android_internal_app_ResolverActivity_ResolveListAdapter$rebuildList() {
            int N;
            List<ResolveInfo> currentResolveList;
            try {
                this.mLastChosen = AppGlobals.getPackageManager().getLastChosenActivity(this.mIntent, this.mIntent.resolveTypeIfNeeded(this.this$0.getContentResolver()), 65536);
            }
            catch (RemoteException re) {
                Log.d("ResolverActivity", "Error calling setLastChosenActivity\n" + re);
            }
            this.mList.clear();
            if (this.mBaseResolveList != null) {
                this.mOrigResolveList = this.mBaseResolveList;
                currentResolveList = this.mOrigResolveList;
            } else {
                this.mOrigResolveList = this.this$0.mPm.queryIntentActivities(this.mIntent, 0x10000 | (this.mFilterLastUsed ? 64 : 0));
                currentResolveList = this.mOrigResolveList;
                if (currentResolveList != null) {
                    for (int i = currentResolveList.size() - 1; i >= 0; --i) {
                        ActivityInfo ai = currentResolveList.get((int)i).activityInfo;
                        int granted = ActivityManager.checkComponentPermission(ai.permission, this.mLaunchedFromUid, ai.applicationInfo.uid, ai.exported);
                        if (granted == 0) continue;
                        if (this.mOrigResolveList == currentResolveList) {
                            this.mOrigResolveList = new ArrayList<ResolveInfo>(this.mOrigResolveList);
                        }
                        currentResolveList.remove(i);
                    }
                }
            }
            if (currentResolveList != null && (N = currentResolveList.size()) > 0) {
                ResolveInfo ri;
                ResolveInfo r0 = currentResolveList.get(0);
                for (int i = 1; i < N; ++i) {
                    ResolveInfo ri2 = currentResolveList.get(i);
                    if (r0.priority == ri2.priority && r0.isDefault == ri2.isDefault) continue;
                    while (i < N) {
                        if (this.mOrigResolveList == currentResolveList) {
                            this.mOrigResolveList = new ArrayList<ResolveInfo>(this.mOrigResolveList);
                        }
                        currentResolveList.remove(i);
                        --N;
                    }
                }
                if (N > 1) {
                    ResolverComparator rComparator = new ResolverComparator(this.this$0, this.this$0);
                    Collections.sort(currentResolveList, rComparator);
                }
                if (this.mInitialIntents != null) {
                    for (int i = 0; i < this.mInitialIntents.length; ++i) {
                        Intent ii = this.mInitialIntents[i];
                        if (ii == null) continue;
                        ActivityInfo ai = ii.resolveActivityInfo(this.this$0.getPackageManager(), 0);
                        if (ai == null) {
                            Log.w("ResolverActivity", "No activity found for " + ii);
                            continue;
                        }
                        ri = new ResolveInfo();
                        ri.activityInfo = ai;
                        if (ii instanceof LabeledIntent) {
                            LabeledIntent li = (LabeledIntent)ii;
                            ri.resolvePackageName = li.getSourcePackage();
                            ri.labelRes = li.getLabelResource();
                            ri.nonLocalizedLabel = li.getNonLocalizedLabel();
                            ri.icon = li.getIconResource();
                        }
                        this.mList.add(new DisplayResolveInfo(this.this$0, ri, ri.loadLabel(this.this$0.getPackageManager()), null, ii));
                    }
                }
                r0 = currentResolveList.get(0);
                int start = 0;
                CharSequence r0Label = r0.loadLabel(this.this$0.mPm);
                this.this$0.mShowExtended = false;
                for (int i = 1; i < N; ++i) {
                    CharSequence riLabel;
                    if (r0Label == null) {
                        r0Label = r0.activityInfo.packageName;
                    }
                    if ((riLabel = (ri = currentResolveList.get(i)).loadLabel(this.this$0.mPm)) == null) {
                        riLabel = ri.activityInfo.packageName;
                    }
                    if (riLabel.equals(r0Label)) continue;
                    this.processGroup(currentResolveList, start, i - 1, r0, r0Label);
                    r0 = ri;
                    r0Label = riLabel;
                    start = i;
                }
                this.processGroup(currentResolveList, start, N - 1, r0, r0Label);
            }
        }

        private final void $$robo$$com_android_internal_app_ResolverActivity_ResolveListAdapter$processGroup(List<ResolveInfo> rList, int start, int end, ResolveInfo ro, CharSequence roLabel) {
            int num = end - start + 1;
            if (num == 1) {
                if (this.mLastChosen != null && this.mLastChosen.activityInfo.packageName.equals(ro.activityInfo.packageName) && this.mLastChosen.activityInfo.name.equals(ro.activityInfo.name)) {
                    this.mLastChosenPosition = this.mList.size();
                }
                this.mList.add(new DisplayResolveInfo(this.this$0, ro, roLabel, null, null));
            } else {
                this.this$0.mShowExtended = true;
                boolean usePkg = false;
                CharSequence startApp = ro.activityInfo.applicationInfo.loadLabel(this.this$0.mPm);
                if (startApp == null) {
                    usePkg = true;
                }
                if (!usePkg) {
                    HashSet<CharSequence> duplicates = new HashSet<CharSequence>();
                    duplicates.add(startApp);
                    for (int j = start + 1; j <= end; ++j) {
                        ResolveInfo jRi = rList.get(j);
                        CharSequence jApp = jRi.activityInfo.applicationInfo.loadLabel(this.this$0.mPm);
                        if (jApp == null || duplicates.contains(jApp)) {
                            usePkg = true;
                            break;
                        }
                        duplicates.add(jApp);
                    }
                    duplicates.clear();
                }
                for (int k = start; k <= end; ++k) {
                    ResolveInfo add = rList.get(k);
                    if (this.mLastChosen != null && this.mLastChosen.activityInfo.packageName.equals(add.activityInfo.packageName) && this.mLastChosen.activityInfo.name.equals(add.activityInfo.name)) {
                        this.mLastChosenPosition = this.mList.size();
                    }
                    if (usePkg) {
                        this.mList.add(new DisplayResolveInfo(this.this$0, add, roLabel, add.activityInfo.packageName, null));
                        continue;
                    }
                    this.mList.add(new DisplayResolveInfo(this.this$0, add, roLabel, add.activityInfo.applicationInfo.loadLabel(this.this$0.mPm), null));
                }
            }
        }

        private final ResolveInfo $$robo$$com_android_internal_app_ResolverActivity_ResolveListAdapter$resolveInfoForPosition(int position, boolean filtered) {
            return ((DisplayResolveInfo)(filtered ? this.getItem((int)position) : this.mList.get((int)position))).ri;
        }

        private final Intent $$robo$$com_android_internal_app_ResolverActivity_ResolveListAdapter$intentForPosition(int position, boolean filtered) {
            Object dri = filtered ? this.getItem(position) : this.mList.get(position);
            Intent intent = new Intent(((DisplayResolveInfo)dri).origIntent != null ? ((DisplayResolveInfo)dri).origIntent : this.this$0.getReplacementIntent(((DisplayResolveInfo)dri).ri.activityInfo.packageName, this.mIntent));
            intent.addFlags(0x3000000);
            ActivityInfo ai = ((DisplayResolveInfo)dri).ri.activityInfo;
            intent.setComponent(new ComponentName(ai.applicationInfo.packageName, ai.name));
            return intent;
        }

        private final int $$robo$$com_android_internal_app_ResolverActivity_ResolveListAdapter$getCount() {
            int result = this.mList.size();
            if (this.mFilterLastUsed && this.mLastChosenPosition >= 0) {
                --result;
            }
            return result;
        }

        private final DisplayResolveInfo $$robo$$com_android_internal_app_ResolverActivity_ResolveListAdapter$getItem(int position) {
            if (this.mFilterLastUsed && this.mLastChosenPosition >= 0 && position >= this.mLastChosenPosition) {
                ++position;
            }
            return this.mList.get(position);
        }

        private final long $$robo$$com_android_internal_app_ResolverActivity_ResolveListAdapter$getItemId(int position) {
            return position;
        }

        private final View $$robo$$com_android_internal_app_ResolverActivity_ResolveListAdapter$getView(int position, View convertView, ViewGroup parent) {
            View view = convertView;
            if (view == null) {
                view = this.mInflater.inflate(17367212, parent, false);
                ViewHolder holder = new ViewHolder(view);
                view.setTag(holder);
            }
            this.bindView(view, (DisplayResolveInfo)this.getItem(position));
            return view;
        }

        private final void $$robo$$com_android_internal_app_ResolverActivity_ResolveListAdapter$bindView(View view, DisplayResolveInfo info) {
            ViewHolder holder = (ViewHolder)view.getTag();
            holder.text.setText(info.displayLabel);
            if (this.this$0.mShowExtended) {
                holder.text2.setVisibility(0);
                holder.text2.setText(info.extendedInfo);
            } else {
                holder.text2.setVisibility(8);
            }
            if (info.displayIcon == null) {
                new LoadIconTask(this.this$0).execute(info);
            }
            holder.icon.setImageDrawable(info.displayIcon);
        }

        private void __constructor__(ResolverActivity resolverActivity, Context context, Intent intent, Intent[] intentArray, List<ResolveInfo> list, int n, boolean bl) {
            this.$$robo$$com_android_internal_app_ResolverActivity_ResolveListAdapter$__constructor__(resolverActivity, context, intent, intentArray, list, n, bl);
        }

        public ResolveListAdapter(ResolverActivity resolverActivity, Context context, Intent intent, Intent[] intentArray, List<ResolveInfo> list, int n, boolean bl) {
            this.this$0 = resolverActivity;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_app_ResolverActivity_ResolveListAdapter$__constructor__(com.android.internal.app.ResolverActivity android.content.Context android.content.Intent android.content.Intent[] java.util.List<android.content.pm.ResolveInfo> int boolean ), 0, this, resolverActivity, context, intent, intentArray, list, n, bl);
        }

        public void handlePackagesChanged() {
            InvokeDynamicSupport.bootstrap("handlePackagesChanged", $$robo$$com_android_internal_app_ResolverActivity_ResolveListAdapter$handlePackagesChanged(), 0, this);
        }

        public DisplayResolveInfo getFilteredItem() {
            return InvokeDynamicSupport.bootstrap("getFilteredItem", $$robo$$com_android_internal_app_ResolverActivity_ResolveListAdapter$getFilteredItem(), 0, this);
        }

        public int getFilteredPosition() {
            return (int)InvokeDynamicSupport.bootstrap("getFilteredPosition", $$robo$$com_android_internal_app_ResolverActivity_ResolveListAdapter$getFilteredPosition(), 0, this);
        }

        public boolean hasFilteredItem() {
            return (boolean)InvokeDynamicSupport.bootstrap("hasFilteredItem", $$robo$$com_android_internal_app_ResolverActivity_ResolveListAdapter$hasFilteredItem(), 0, this);
        }

        private void rebuildList() {
            InvokeDynamicSupport.bootstrap("rebuildList", $$robo$$com_android_internal_app_ResolverActivity_ResolveListAdapter$rebuildList(), 0, this);
        }

        private void processGroup(List<ResolveInfo> list, int n, int n2, ResolveInfo resolveInfo, CharSequence charSequence) {
            InvokeDynamicSupport.bootstrap("processGroup", $$robo$$com_android_internal_app_ResolverActivity_ResolveListAdapter$processGroup(java.util.List<android.content.pm.ResolveInfo> int int android.content.pm.ResolveInfo java.lang.CharSequence ), 0, this, list, n, n2, resolveInfo, charSequence);
        }

        public ResolveInfo resolveInfoForPosition(int n, boolean bl) {
            return InvokeDynamicSupport.bootstrap("resolveInfoForPosition", $$robo$$com_android_internal_app_ResolverActivity_ResolveListAdapter$resolveInfoForPosition(int boolean ), 0, this, n, bl);
        }

        public Intent intentForPosition(int n, boolean bl) {
            return InvokeDynamicSupport.bootstrap("intentForPosition", $$robo$$com_android_internal_app_ResolverActivity_ResolveListAdapter$intentForPosition(int boolean ), 0, this, n, bl);
        }

        @Override
        public int getCount() {
            return (int)InvokeDynamicSupport.bootstrap("getCount", $$robo$$com_android_internal_app_ResolverActivity_ResolveListAdapter$getCount(), 0, this);
        }

        @Override
        public DisplayResolveInfo getItem(int n) {
            return InvokeDynamicSupport.bootstrap("getItem", $$robo$$com_android_internal_app_ResolverActivity_ResolveListAdapter$getItem(int ), 0, this, n);
        }

        @Override
        public long getItemId(int n) {
            return (long)InvokeDynamicSupport.bootstrap("getItemId", $$robo$$com_android_internal_app_ResolverActivity_ResolveListAdapter$getItemId(int ), 0, this, n);
        }

        @Override
        public View getView(int n, View view, ViewGroup viewGroup) {
            return InvokeDynamicSupport.bootstrap("getView", $$robo$$com_android_internal_app_ResolverActivity_ResolveListAdapter$getView(int android.view.View android.view.ViewGroup ), 0, this, n, view, viewGroup);
        }

        private void bindView(View view, DisplayResolveInfo displayResolveInfo) {
            InvokeDynamicSupport.bootstrap("bindView", $$robo$$com_android_internal_app_ResolverActivity_ResolveListAdapter$bindView(android.view.View com.android.internal.app.ResolverActivity$DisplayResolveInfo ), 0, this, view, displayResolveInfo);
        }

        public /* synthetic */ ResolveListAdapter() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ResolveListAdapter)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    private final class DisplayResolveInfo
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        ResolveInfo ri;
        CharSequence displayLabel;
        Drawable displayIcon;
        CharSequence extendedInfo;
        Intent origIntent;
        /* synthetic */ ResolverActivity this$0;

        private void $$robo$$com_android_internal_app_ResolverActivity_DisplayResolveInfo$__constructor__(ResolverActivity resolverActivity, ResolveInfo pri, CharSequence pLabel, CharSequence pInfo, Intent pOrigIntent) {
            this.ri = pri;
            this.displayLabel = pLabel;
            this.extendedInfo = pInfo;
            this.origIntent = pOrigIntent;
        }

        private void __constructor__(ResolverActivity resolverActivity, ResolveInfo resolveInfo, CharSequence charSequence, CharSequence charSequence2, Intent intent) {
            this.$$robo$$com_android_internal_app_ResolverActivity_DisplayResolveInfo$__constructor__(resolverActivity, resolveInfo, charSequence, charSequence2, intent);
        }

        DisplayResolveInfo(ResolverActivity resolverActivity, ResolveInfo resolveInfo, CharSequence charSequence, CharSequence charSequence2, Intent intent) {
            this.this$0 = resolverActivity;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_app_ResolverActivity_DisplayResolveInfo$__constructor__(com.android.internal.app.ResolverActivity android.content.pm.ResolveInfo java.lang.CharSequence java.lang.CharSequence android.content.Intent ), 0, this, resolverActivity, resolveInfo, charSequence, charSequence2, intent);
        }

        public /* synthetic */ DisplayResolveInfo() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (DisplayResolveInfo)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    private static final class ActionTitle
    extends Enum<ActionTitle> {
        public transient /* synthetic */ Object __robo_data__;
        public static /* enum */ ActionTitle VIEW;
        public static /* enum */ ActionTitle EDIT;
        public static /* enum */ ActionTitle SEND;
        public static /* enum */ ActionTitle SENDTO;
        public static /* enum */ ActionTitle SEND_MULTIPLE;
        public static /* enum */ ActionTitle DEFAULT;
        public static /* enum */ ActionTitle HOME;
        public String action;
        public int titleRes;
        public int namedTitleRes;
        private static /* synthetic */ ActionTitle[] $VALUES;

        private static final ActionTitle[] $$robo$$com_android_internal_app_ResolverActivity_ActionTitle$values() {
            return (ActionTitle[])$VALUES.clone();
        }

        private static final ActionTitle $$robo$$com_android_internal_app_ResolverActivity_ActionTitle$valueOf(String name) {
            return Enum.valueOf(ActionTitle.class, name);
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         */
        private void $$robo$$com_android_internal_app_ResolverActivity_ActionTitle$__constructor__(String string2, int n, String action, int titleRes, int namedTitleRes) {
            this.action = action;
            this.titleRes = titleRes;
            this.namedTitleRes = namedTitleRes;
        }

        private static final ActionTitle $$robo$$com_android_internal_app_ResolverActivity_ActionTitle$forAction(String action) {
            for (ActionTitle title : ActionTitle.values()) {
                if (title == HOME || action == null || !action.equals(title.action)) continue;
                return title;
            }
            return DEFAULT;
        }

        static void __staticInitializer__() {
            VIEW = new ActionTitle("android.intent.action.VIEW", 17040482, 17040483);
            EDIT = new ActionTitle("android.intent.action.EDIT", 17040484, 17040485);
            SEND = new ActionTitle("android.intent.action.SEND", 17040486, 17040487);
            SENDTO = new ActionTitle("android.intent.action.SENDTO", 17040486, 17040487);
            SEND_MULTIPLE = new ActionTitle("android.intent.action.SEND_MULTIPLE", 17040486, 17040487);
            DEFAULT = new ActionTitle(null, 17040480, 17040481);
            HOME = new ActionTitle("android.intent.action.MAIN", 17040488, 17040489);
            $VALUES = new ActionTitle[]{VIEW, EDIT, SEND, SENDTO, SEND_MULTIPLE, DEFAULT, HOME};
        }

        public static ActionTitle[] values() {
            return InvokeDynamicSupport.bootstrapStatic("values", $$robo$$com_android_internal_app_ResolverActivity_ActionTitle$values(), 0);
        }

        public static ActionTitle valueOf(String string2) {
            return InvokeDynamicSupport.bootstrapStatic("valueOf", $$robo$$com_android_internal_app_ResolverActivity_ActionTitle$valueOf(java.lang.String ), 0, (String)string2);
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         */
        private void __constructor__(String string2, int n, String string3, int n2, int n3) {
            this.$$robo$$com_android_internal_app_ResolverActivity_ActionTitle$__constructor__(string2, n, string3, n2, n3);
        }

        private ActionTitle(String string3, int n2, int n3) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_app_ResolverActivity_ActionTitle$__constructor__(java.lang.String int java.lang.String int int ), 0, this, string2, n, string3, n2, n3);
        }

        public static ActionTitle forAction(String string2) {
            return InvokeDynamicSupport.bootstrapStatic("forAction", $$robo$$com_android_internal_app_ResolverActivity_ActionTitle$forAction(java.lang.String ), 0, (String)string2);
        }

        static {
            RobolectricInternals.classInitializing(ActionTitle.class);
        }

        public /* synthetic */ ActionTitle() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ActionTitle)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

