/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.app;

import android.os.Bundle;
import android.os.UserManager;
import android.text.Editable;
import android.text.TextWatcher;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.Button;
import android.widget.EditText;
import android.widget.TextView;
import com.android.internal.app.AlertActivity;
import com.android.internal.app.AlertController;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class RestrictionsPinActivity
extends AlertActivity
implements View.OnClickListener,
TextWatcher,
TextView.OnEditorActionListener,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    protected UserManager mUserManager;
    protected boolean mHasRestrictionsPin;
    protected EditText mPinText;
    protected TextView mPinErrorMessage;
    private Button mOkButton;
    private Button mCancelButton;
    private Runnable mCountdownRunnable;

    private void $$robo$$com_android_internal_app_RestrictionsPinActivity$__constructor__() {
        this.mCountdownRunnable = new Runnable(this){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ RestrictionsPinActivity this$0;

            private void $$robo$$com_android_internal_app_RestrictionsPinActivity_1$__constructor__(RestrictionsPinActivity restrictionsPinActivity) {
            }

            private final void $$robo$$com_android_internal_app_RestrictionsPinActivity_1$run() {
                if (this.this$0.updatePinTimer(-1)) {
                    this.this$0.mPinErrorMessage.setVisibility(4);
                }
            }

            private void __constructor__(RestrictionsPinActivity restrictionsPinActivity) {
                this.$$robo$$com_android_internal_app_RestrictionsPinActivity_1$__constructor__(restrictionsPinActivity);
            }
            {
                this.this$0 = restrictionsPinActivity;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_app_RestrictionsPinActivity_1$__constructor__(com.android.internal.app.RestrictionsPinActivity ), 0, this, restrictionsPinActivity);
            }

            @Override
            public void run() {
                InvokeDynamicSupport.bootstrap("run", $$robo$$com_android_internal_app_RestrictionsPinActivity_1$run(), 0, this);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
    }

    private final void $$robo$$com_android_internal_app_RestrictionsPinActivity$onCreate(Bundle icicle) {
        super.onCreate(icicle);
        this.mUserManager = (UserManager)this.getSystemService("user");
        this.mHasRestrictionsPin = this.mUserManager.hasRestrictionsChallenge();
        this.initUi();
        this.setupAlert();
    }

    private final void $$robo$$com_android_internal_app_RestrictionsPinActivity$initUi() {
        AlertController.AlertParams ap = this.mAlertParams;
        ap.mTitle = this.getString(17040983);
        LayoutInflater inflater = (LayoutInflater)this.getSystemService("layout_inflater");
        ap.mView = inflater.inflate(17367216, null);
        this.mPinErrorMessage = (TextView)ap.mView.findViewById(16909160);
        this.mPinText = (EditText)ap.mView.findViewById(16909159);
        this.mOkButton = (Button)ap.mView.findViewById(16909162);
        this.mCancelButton = (Button)ap.mView.findViewById(16909161);
        this.mPinText.addTextChangedListener(this);
        this.mOkButton.setOnClickListener(this);
        this.mCancelButton.setOnClickListener(this);
    }

    private final boolean $$robo$$com_android_internal_app_RestrictionsPinActivity$verifyingPin() {
        return true;
    }

    private final void $$robo$$com_android_internal_app_RestrictionsPinActivity$onResume() {
        super.onResume();
        this.setPositiveButtonState(false);
        boolean hasPin = this.mUserManager.hasRestrictionsChallenge();
        if (hasPin) {
            this.mPinErrorMessage.setVisibility(4);
            this.mPinText.setOnEditorActionListener(this);
            this.updatePinTimer(-1);
        } else if (this.verifyingPin()) {
            this.setResult(-1);
            this.finish();
        }
    }

    private final void $$robo$$com_android_internal_app_RestrictionsPinActivity$setPositiveButtonState(boolean enabled) {
        this.mOkButton.setEnabled(enabled);
    }

    private final boolean $$robo$$com_android_internal_app_RestrictionsPinActivity$updatePinTimer(int pinTimerMs) {
        boolean enableInput;
        if (pinTimerMs < 0) {
            pinTimerMs = this.mUserManager.checkRestrictionsChallenge(null);
        }
        if (pinTimerMs >= 200) {
            if (pinTimerMs <= 60000) {
                int seconds = (pinTimerMs + 200) / 1000;
                String formatString = this.getResources().getQuantityString(18087960, seconds);
                this.mPinErrorMessage.setText(String.format(formatString, seconds));
            } else {
                this.mPinErrorMessage.setText(17040992);
            }
            enableInput = false;
            this.mPinErrorMessage.setVisibility(0);
            this.mPinText.setText("");
            this.mPinText.postDelayed(this.mCountdownRunnable, Math.min(1000, pinTimerMs));
        } else {
            enableInput = true;
            this.mPinErrorMessage.setText(17040985);
        }
        this.mPinText.setEnabled(enableInput);
        this.setPositiveButtonState(enableInput);
        return enableInput;
    }

    private final void $$robo$$com_android_internal_app_RestrictionsPinActivity$performPositiveButtonAction() {
        int result = this.mUserManager.checkRestrictionsChallenge(((Object)this.mPinText.getText()).toString());
        if (result == -1) {
            this.setResult(-1);
            this.finish();
        } else if (result >= 0) {
            this.mPinErrorMessage.setText(17040985);
            this.mPinErrorMessage.setVisibility(0);
            this.updatePinTimer(result);
            this.mPinText.setText("");
        }
    }

    private final void $$robo$$com_android_internal_app_RestrictionsPinActivity$beforeTextChanged(CharSequence s, int start, int count, int after) {
    }

    private final void $$robo$$com_android_internal_app_RestrictionsPinActivity$onTextChanged(CharSequence s, int start, int before, int count) {
        CharSequence pin = this.mPinText.getText();
        this.setPositiveButtonState(pin != null && pin.length() >= 4);
    }

    private final void $$robo$$com_android_internal_app_RestrictionsPinActivity$afterTextChanged(Editable s) {
    }

    private final boolean $$robo$$com_android_internal_app_RestrictionsPinActivity$onEditorAction(TextView v, int actionId, KeyEvent event) {
        this.performPositiveButtonAction();
        return true;
    }

    private final void $$robo$$com_android_internal_app_RestrictionsPinActivity$onClick(View v) {
        if (v == this.mOkButton) {
            this.performPositiveButtonAction();
        } else if (v == this.mCancelButton) {
            this.setResult(0);
            this.finish();
        }
    }

    private void __constructor__() {
        this.$$robo$$com_android_internal_app_RestrictionsPinActivity$__constructor__();
    }

    public RestrictionsPinActivity() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_app_RestrictionsPinActivity$__constructor__(), 0, this);
    }

    @Override
    public void onCreate(Bundle bundle) {
        InvokeDynamicSupport.bootstrap("onCreate", $$robo$$com_android_internal_app_RestrictionsPinActivity$onCreate(android.os.Bundle ), 0, this, bundle);
    }

    protected void initUi() {
        InvokeDynamicSupport.bootstrap("initUi", $$robo$$com_android_internal_app_RestrictionsPinActivity$initUi(), 0, this);
    }

    protected boolean verifyingPin() {
        return (boolean)InvokeDynamicSupport.bootstrap("verifyingPin", $$robo$$com_android_internal_app_RestrictionsPinActivity$verifyingPin(), 0, this);
    }

    @Override
    public void onResume() {
        InvokeDynamicSupport.bootstrap("onResume", $$robo$$com_android_internal_app_RestrictionsPinActivity$onResume(), 0, this);
    }

    protected void setPositiveButtonState(boolean bl) {
        InvokeDynamicSupport.bootstrap("setPositiveButtonState", $$robo$$com_android_internal_app_RestrictionsPinActivity$setPositiveButtonState(boolean ), 0, this, bl);
    }

    private boolean updatePinTimer(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("updatePinTimer", $$robo$$com_android_internal_app_RestrictionsPinActivity$updatePinTimer(int ), 0, this, n);
    }

    protected void performPositiveButtonAction() {
        InvokeDynamicSupport.bootstrap("performPositiveButtonAction", $$robo$$com_android_internal_app_RestrictionsPinActivity$performPositiveButtonAction(), 0, this);
    }

    @Override
    public void beforeTextChanged(CharSequence charSequence, int n, int n2, int n3) {
        InvokeDynamicSupport.bootstrap("beforeTextChanged", $$robo$$com_android_internal_app_RestrictionsPinActivity$beforeTextChanged(java.lang.CharSequence int int int ), 0, this, charSequence, n, n2, n3);
    }

    @Override
    public void onTextChanged(CharSequence charSequence, int n, int n2, int n3) {
        InvokeDynamicSupport.bootstrap("onTextChanged", $$robo$$com_android_internal_app_RestrictionsPinActivity$onTextChanged(java.lang.CharSequence int int int ), 0, this, charSequence, n, n2, n3);
    }

    @Override
    public void afterTextChanged(Editable editable) {
        InvokeDynamicSupport.bootstrap("afterTextChanged", $$robo$$com_android_internal_app_RestrictionsPinActivity$afterTextChanged(android.text.Editable ), 0, this, editable);
    }

    @Override
    public boolean onEditorAction(TextView textView, int n, KeyEvent keyEvent) {
        return (boolean)InvokeDynamicSupport.bootstrap("onEditorAction", $$robo$$com_android_internal_app_RestrictionsPinActivity$onEditorAction(android.widget.TextView int android.view.KeyEvent ), 0, this, textView, n, keyEvent);
    }

    @Override
    public void onClick(View view) {
        InvokeDynamicSupport.bootstrap("onClick", $$robo$$com_android_internal_app_RestrictionsPinActivity$onClick(android.view.View ), 0, this, view);
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (RestrictionsPinActivity)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

