/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.content;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.content.pm.PackageParser;
import android.os.Environment;
import android.os.FileUtils;
import android.os.IBinder;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.storage.IMountService;
import android.os.storage.StorageManager;
import android.util.Log;
import com.android.internal.content.NativeLibraryHelper;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import libcore.io.IoUtils;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class PackageHelper
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    public static int RECOMMEND_INSTALL_INTERNAL = 1;
    public static int RECOMMEND_INSTALL_EXTERNAL = 2;
    public static int RECOMMEND_FAILED_INSUFFICIENT_STORAGE = -1;
    public static int RECOMMEND_FAILED_INVALID_APK = -2;
    public static int RECOMMEND_FAILED_INVALID_LOCATION = -3;
    public static int RECOMMEND_FAILED_ALREADY_EXISTS = -4;
    public static int RECOMMEND_MEDIA_UNAVAILABLE = -5;
    public static int RECOMMEND_FAILED_INVALID_URI = -6;
    public static int RECOMMEND_FAILED_VERSION_DOWNGRADE = -7;
    private static boolean localLOGV = false;
    private static String TAG = "PackageHelper";
    public static int APP_INSTALL_AUTO = 0;
    public static int APP_INSTALL_INTERNAL = 1;
    public static int APP_INSTALL_EXTERNAL = 2;

    private void $$robo$$com_android_internal_content_PackageHelper$__constructor__() {
    }

    private static final IMountService $$robo$$com_android_internal_content_PackageHelper$getMountService() throws RemoteException {
        IBinder service = ServiceManager.getService("mount");
        if (service != null) {
            return IMountService.Stub.asInterface(service);
        }
        Log.e("PackageHelper", "Can't get mount service");
        throw new RemoteException("Could not contact mount service");
    }

    private static final String $$robo$$com_android_internal_content_PackageHelper$createSdDir(long sizeBytes, String cid, String sdEncKey, int uid, boolean isExternal) {
        int sizeMb = (int)((sizeBytes + 0x100000L) / 0x100000L) + 1;
        try {
            IMountService mountService = PackageHelper.getMountService();
            int rc = mountService.createSecureContainer(cid, sizeMb, "ext4", sdEncKey, uid, isExternal);
            if (rc != 0) {
                Log.e("PackageHelper", "Failed to create secure container " + cid);
                return null;
            }
            String cachePath = mountService.getSecureContainerPath(cid);
            return cachePath;
        }
        catch (RemoteException e) {
            Log.e("PackageHelper", "MountService running?");
            return null;
        }
    }

    private static final boolean $$robo$$com_android_internal_content_PackageHelper$resizeSdDir(long sizeBytes, String cid, String sdEncKey) {
        int sizeMb = (int)((sizeBytes + 0x100000L) / 0x100000L) + 1;
        try {
            IMountService mountService = PackageHelper.getMountService();
            int rc = mountService.resizeSecureContainer(cid, sizeMb, sdEncKey);
            if (rc == 0) {
                return true;
            }
        }
        catch (RemoteException e) {
            Log.e("PackageHelper", "MountService running?");
        }
        Log.e("PackageHelper", "Failed to create secure container " + cid);
        return false;
    }

    private static final String $$robo$$com_android_internal_content_PackageHelper$mountSdDir(String cid, String key, int ownerUid) {
        return PackageHelper.mountSdDir(cid, key, ownerUid, true);
    }

    private static final String $$robo$$com_android_internal_content_PackageHelper$mountSdDir(String cid, String key, int ownerUid, boolean readOnly) {
        try {
            int rc = PackageHelper.getMountService().mountSecureContainer(cid, key, ownerUid, readOnly);
            if (rc != 0) {
                Log.i("PackageHelper", "Failed to mount container " + cid + " rc : " + rc);
                return null;
            }
            return PackageHelper.getMountService().getSecureContainerPath(cid);
        }
        catch (RemoteException e) {
            Log.e("PackageHelper", "MountService running?");
            return null;
        }
    }

    private static final boolean $$robo$$com_android_internal_content_PackageHelper$unMountSdDir(String cid) {
        try {
            int rc = PackageHelper.getMountService().unmountSecureContainer(cid, true);
            if (rc != 0) {
                Log.e("PackageHelper", "Failed to unmount " + cid + " with rc " + rc);
                return false;
            }
            return true;
        }
        catch (RemoteException e) {
            Log.e("PackageHelper", "MountService running?");
            return false;
        }
    }

    private static final boolean $$robo$$com_android_internal_content_PackageHelper$renameSdDir(String oldId, String newId) {
        try {
            int rc = PackageHelper.getMountService().renameSecureContainer(oldId, newId);
            if (rc != 0) {
                Log.e("PackageHelper", "Failed to rename " + oldId + " to " + newId + "with rc " + rc);
                return false;
            }
            return true;
        }
        catch (RemoteException e) {
            Log.i("PackageHelper", "Failed ot rename  " + oldId + " to " + newId + " with exception : " + e);
            return false;
        }
    }

    private static final String $$robo$$com_android_internal_content_PackageHelper$getSdDir(String cid) {
        try {
            return PackageHelper.getMountService().getSecureContainerPath(cid);
        }
        catch (RemoteException e) {
            Log.e("PackageHelper", "Failed to get container path for " + cid + " with exception " + e);
            return null;
        }
    }

    private static final String $$robo$$com_android_internal_content_PackageHelper$getSdFilesystem(String cid) {
        try {
            return PackageHelper.getMountService().getSecureContainerFilesystemPath(cid);
        }
        catch (RemoteException e) {
            Log.e("PackageHelper", "Failed to get container path for " + cid + " with exception " + e);
            return null;
        }
    }

    private static final boolean $$robo$$com_android_internal_content_PackageHelper$finalizeSdDir(String cid) {
        try {
            int rc = PackageHelper.getMountService().finalizeSecureContainer(cid);
            if (rc != 0) {
                Log.i("PackageHelper", "Failed to finalize container " + cid);
                return false;
            }
            return true;
        }
        catch (RemoteException e) {
            Log.e("PackageHelper", "Failed to finalize container " + cid + " with exception " + e);
            return false;
        }
    }

    private static final boolean $$robo$$com_android_internal_content_PackageHelper$destroySdDir(String cid) {
        try {
            int rc = PackageHelper.getMountService().destroySecureContainer(cid, true);
            if (rc != 0) {
                Log.i("PackageHelper", "Failed to destroy container " + cid);
                return false;
            }
            return true;
        }
        catch (RemoteException e) {
            Log.e("PackageHelper", "Failed to destroy container " + cid + " with exception " + e);
            return false;
        }
    }

    private static final String[] $$robo$$com_android_internal_content_PackageHelper$getSecureContainerList() {
        try {
            return PackageHelper.getMountService().getSecureContainerList();
        }
        catch (RemoteException e) {
            Log.e("PackageHelper", "Failed to get secure container list with exception" + e);
            return null;
        }
    }

    private static final boolean $$robo$$com_android_internal_content_PackageHelper$isContainerMounted(String cid) {
        try {
            return PackageHelper.getMountService().isSecureContainerMounted(cid);
        }
        catch (RemoteException e) {
            Log.e("PackageHelper", "Failed to find out if container " + cid + " mounted");
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final long $$robo$$com_android_internal_content_PackageHelper$extractPublicFiles(File apkFile, File publicZipFile) throws IOException {
        ZipOutputStream publicZipOutStream;
        FileOutputStream fstr;
        if (publicZipFile == null) {
            fstr = null;
            publicZipOutStream = null;
        } else {
            fstr = new FileOutputStream(publicZipFile);
            publicZipOutStream = new ZipOutputStream(fstr);
            Log.d("PackageHelper", "Extracting " + apkFile + " to " + publicZipFile);
        }
        long size = 0L;
        try {
            ZipFile privateZip = new ZipFile(apkFile.getAbsolutePath());
            try {
                for (ZipEntry zipEntry : Collections.list(privateZip.entries())) {
                    String zipEntryName = zipEntry.getName();
                    if (!"AndroidManifest.xml".equals(zipEntryName) && !"resources.arsc".equals(zipEntryName) && !zipEntryName.startsWith("res/")) continue;
                    size += zipEntry.getSize();
                    if (publicZipFile == null) continue;
                    PackageHelper.copyZipEntry(zipEntry, privateZip, publicZipOutStream);
                }
            }
            finally {
                try {
                    privateZip.close();
                }
                catch (IOException iOException) {}
            }
            if (publicZipFile != null) {
                publicZipOutStream.finish();
                publicZipOutStream.flush();
                FileUtils.sync(fstr);
                publicZipOutStream.close();
                FileUtils.setPermissions(publicZipFile.getAbsolutePath(), 420, -1, -1);
            }
        }
        finally {
            IoUtils.closeQuietly(publicZipOutStream);
        }
        return size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void $$robo$$com_android_internal_content_PackageHelper$copyZipEntry(ZipEntry zipEntry, ZipFile inZipFile, ZipOutputStream outZipStream) throws IOException {
        byte[] buffer = new byte[4096];
        ZipEntry newEntry = zipEntry.getMethod() == 0 ? new ZipEntry(zipEntry) : new ZipEntry(zipEntry.getName());
        outZipStream.putNextEntry(newEntry);
        InputStream data = inZipFile.getInputStream(zipEntry);
        try {
            int num;
            while ((num = data.read(buffer)) > 0) {
                outZipStream.write(buffer, 0, num);
            }
            outZipStream.flush();
        }
        finally {
            IoUtils.closeQuietly(data);
        }
    }

    private static final boolean $$robo$$com_android_internal_content_PackageHelper$fixSdPermissions(String cid, int gid, String filename) {
        try {
            int rc = PackageHelper.getMountService().fixPermissionsSecureContainer(cid, gid, filename);
            if (rc != 0) {
                Log.i("PackageHelper", "Failed to fixperms container " + cid);
                return false;
            }
            return true;
        }
        catch (RemoteException e) {
            Log.e("PackageHelper", "Failed to fixperms container " + cid + " with exception " + e);
            return false;
        }
    }

    private static final int $$robo$$com_android_internal_content_PackageHelper$resolveInstallLocation(Context context, String packageName, int installLocation, long sizeBytes, int installFlags) {
        boolean checkBoth;
        int prefer;
        ApplicationInfo existingInfo = null;
        try {
            existingInfo = context.getPackageManager().getApplicationInfo(packageName, 8192);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            // empty catch block
        }
        if ((installFlags & 0x10) != 0) {
            prefer = 1;
            checkBoth = false;
        } else if ((installFlags & 8) != 0) {
            prefer = 2;
            checkBoth = false;
        } else if (installLocation == 1) {
            prefer = 1;
            checkBoth = false;
        } else if (installLocation == 2) {
            prefer = 2;
            checkBoth = true;
        } else if (installLocation == 0) {
            prefer = existingInfo != null ? ((existingInfo.flags & 0x40000) != 0 ? 2 : 1) : 1;
            checkBoth = true;
        } else {
            prefer = 1;
            checkBoth = false;
        }
        boolean emulated = Environment.isExternalStorageEmulated();
        StorageManager storage = StorageManager.from(context);
        boolean fitsOnInternal = false;
        if (checkBoth || prefer == 1) {
            File target = Environment.getDataDirectory();
            fitsOnInternal = sizeBytes <= storage.getStorageBytesUntilLow(target);
        }
        boolean fitsOnExternal = false;
        if (!emulated && (checkBoth || prefer == 2)) {
            File target = new Environment.UserEnvironment(0).getExternalStorageDirectory();
            if (sizeBytes > 0L) {
                boolean bl = fitsOnExternal = sizeBytes <= storage.getStorageBytesUntilLow(target);
            }
        }
        if (prefer == 1) {
            if (fitsOnInternal) {
                return 1;
            }
        } else if (!emulated && prefer == 2 && fitsOnExternal) {
            return 2;
        }
        if (checkBoth) {
            if (fitsOnInternal) {
                return 1;
            }
            if (!emulated && fitsOnExternal) {
                return 2;
            }
        }
        if (!(emulated || !checkBoth && prefer != 2 || "mounted".equals(Environment.getExternalStorageState()))) {
            return -5;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final long $$robo$$com_android_internal_content_PackageHelper$calculateInstalledSize(PackageParser.PackageLite pkg, boolean isForwardLocked, String abiOverride) throws IOException {
        NativeLibraryHelper.Handle handle = null;
        try {
            handle = NativeLibraryHelper.Handle.create(pkg);
            long l = PackageHelper.calculateInstalledSize(pkg, handle, isForwardLocked, abiOverride);
            return l;
        }
        finally {
            IoUtils.closeQuietly(handle);
        }
    }

    private static final long $$robo$$com_android_internal_content_PackageHelper$calculateInstalledSize(PackageParser.PackageLite pkg, NativeLibraryHelper.Handle handle, boolean isForwardLocked, String abiOverride) throws IOException {
        long sizeBytes = 0L;
        for (String codePath : pkg.getAllCodePaths()) {
            File codeFile = new File(codePath);
            sizeBytes += codeFile.length();
            if (!isForwardLocked) continue;
            sizeBytes += PackageHelper.extractPublicFiles(codeFile, null);
        }
        return sizeBytes += NativeLibraryHelper.sumNativeBinariesWithOverride(handle, abiOverride);
    }

    private static final String $$robo$$com_android_internal_content_PackageHelper$replaceEnd(String str, String before, String after) {
        if (!str.endsWith(before)) {
            throw new IllegalArgumentException("Expected " + str + " to end with " + before);
        }
        return str.substring(0, str.length() - before.length()) + after;
    }

    private void __constructor__() {
        this.$$robo$$com_android_internal_content_PackageHelper$__constructor__();
    }

    public PackageHelper() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_content_PackageHelper$__constructor__(), 0, this);
    }

    public static IMountService getMountService() throws RemoteException {
        return InvokeDynamicSupport.bootstrapStatic("getMountService", $$robo$$com_android_internal_content_PackageHelper$getMountService(), 0);
    }

    public static String createSdDir(long l, String string2, String string3, int n, boolean bl) {
        return InvokeDynamicSupport.bootstrapStatic("createSdDir", $$robo$$com_android_internal_content_PackageHelper$createSdDir(long java.lang.String java.lang.String int boolean ), 0, (long)l, (String)string2, (String)string3, (int)n, (boolean)bl);
    }

    public static boolean resizeSdDir(long l, String string2, String string3) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("resizeSdDir", $$robo$$com_android_internal_content_PackageHelper$resizeSdDir(long java.lang.String java.lang.String ), 0, (long)l, (String)string2, (String)string3);
    }

    public static String mountSdDir(String string2, String string3, int n) {
        return InvokeDynamicSupport.bootstrapStatic("mountSdDir", $$robo$$com_android_internal_content_PackageHelper$mountSdDir(java.lang.String java.lang.String int ), 0, (String)string2, (String)string3, (int)n);
    }

    public static String mountSdDir(String string2, String string3, int n, boolean bl) {
        return InvokeDynamicSupport.bootstrapStatic("mountSdDir", $$robo$$com_android_internal_content_PackageHelper$mountSdDir(java.lang.String java.lang.String int boolean ), 0, (String)string2, (String)string3, (int)n, (boolean)bl);
    }

    public static boolean unMountSdDir(String string2) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("unMountSdDir", $$robo$$com_android_internal_content_PackageHelper$unMountSdDir(java.lang.String ), 0, (String)string2);
    }

    public static boolean renameSdDir(String string2, String string3) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("renameSdDir", $$robo$$com_android_internal_content_PackageHelper$renameSdDir(java.lang.String java.lang.String ), 0, (String)string2, (String)string3);
    }

    public static String getSdDir(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("getSdDir", $$robo$$com_android_internal_content_PackageHelper$getSdDir(java.lang.String ), 0, (String)string2);
    }

    public static String getSdFilesystem(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("getSdFilesystem", $$robo$$com_android_internal_content_PackageHelper$getSdFilesystem(java.lang.String ), 0, (String)string2);
    }

    public static boolean finalizeSdDir(String string2) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("finalizeSdDir", $$robo$$com_android_internal_content_PackageHelper$finalizeSdDir(java.lang.String ), 0, (String)string2);
    }

    public static boolean destroySdDir(String string2) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("destroySdDir", $$robo$$com_android_internal_content_PackageHelper$destroySdDir(java.lang.String ), 0, (String)string2);
    }

    public static String[] getSecureContainerList() {
        return InvokeDynamicSupport.bootstrapStatic("getSecureContainerList", $$robo$$com_android_internal_content_PackageHelper$getSecureContainerList(), 0);
    }

    public static boolean isContainerMounted(String string2) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isContainerMounted", $$robo$$com_android_internal_content_PackageHelper$isContainerMounted(java.lang.String ), 0, (String)string2);
    }

    public static long extractPublicFiles(File file, File file2) throws IOException {
        return (long)InvokeDynamicSupport.bootstrapStatic("extractPublicFiles", $$robo$$com_android_internal_content_PackageHelper$extractPublicFiles(java.io.File java.io.File ), 0, (File)file, (File)file2);
    }

    private static void copyZipEntry(ZipEntry zipEntry, ZipFile zipFile, ZipOutputStream zipOutputStream) throws IOException {
        InvokeDynamicSupport.bootstrapStatic("copyZipEntry", $$robo$$com_android_internal_content_PackageHelper$copyZipEntry(java.util.zip.ZipEntry java.util.zip.ZipFile java.util.zip.ZipOutputStream ), 0, (ZipEntry)zipEntry, (ZipFile)zipFile, (ZipOutputStream)zipOutputStream);
    }

    public static boolean fixSdPermissions(String string2, int n, String string3) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("fixSdPermissions", $$robo$$com_android_internal_content_PackageHelper$fixSdPermissions(java.lang.String int java.lang.String ), 0, (String)string2, (int)n, (String)string3);
    }

    public static int resolveInstallLocation(Context context, String string2, int n, long l, int n2) {
        return (int)InvokeDynamicSupport.bootstrapStatic("resolveInstallLocation", $$robo$$com_android_internal_content_PackageHelper$resolveInstallLocation(android.content.Context java.lang.String int long int ), 0, (Context)context, (String)string2, (int)n, (long)l, (int)n2);
    }

    public static long calculateInstalledSize(PackageParser.PackageLite packageLite, boolean bl, String string2) throws IOException {
        return (long)InvokeDynamicSupport.bootstrapStatic("calculateInstalledSize", $$robo$$com_android_internal_content_PackageHelper$calculateInstalledSize(android.content.pm.PackageParser$PackageLite boolean java.lang.String ), 0, (PackageParser.PackageLite)packageLite, (boolean)bl, (String)string2);
    }

    public static long calculateInstalledSize(PackageParser.PackageLite packageLite, NativeLibraryHelper.Handle handle, boolean bl, String string2) throws IOException {
        return (long)InvokeDynamicSupport.bootstrapStatic("calculateInstalledSize", $$robo$$com_android_internal_content_PackageHelper$calculateInstalledSize(android.content.pm.PackageParser$PackageLite com.android.internal.content.NativeLibraryHelper$Handle boolean java.lang.String ), 0, (PackageParser.PackageLite)packageLite, (NativeLibraryHelper.Handle)handle, (boolean)bl, (String)string2);
    }

    public static String replaceEnd(String string2, String string3, String string4) {
        return InvokeDynamicSupport.bootstrapStatic("replaceEnd", $$robo$$com_android_internal_content_PackageHelper$replaceEnd(java.lang.String java.lang.String java.lang.String ), 0, (String)string2, (String)string3, (String)string4);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (PackageHelper)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

