/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.content;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.Uri;
import android.os.Handler;
import android.os.Looper;
import android.os.UserHandle;
import com.android.internal.os.BackgroundThread;
import java.util.HashSet;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public abstract class PackageMonitor
extends BroadcastReceiver
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    static IntentFilter sPackageFilt;
    static IntentFilter sNonDataFilt;
    static IntentFilter sExternalFilt;
    HashSet<String> mUpdatingPackages;
    Context mRegisteredContext;
    Handler mRegisteredHandler;
    String[] mDisappearingPackages;
    String[] mAppearingPackages;
    String[] mModifiedPackages;
    int mChangeType;
    int mChangeUserId;
    boolean mSomePackagesChanged;
    String[] mTempArray;
    public static int PACKAGE_UNCHANGED = 0;
    public static int PACKAGE_UPDATING = 1;
    public static int PACKAGE_TEMPORARY_CHANGE = 2;
    public static int PACKAGE_PERMANENT_CHANGE = 3;

    private void $$robo$$com_android_internal_content_PackageMonitor$__constructor__() {
        this.mUpdatingPackages = new HashSet();
        this.mChangeUserId = -10000;
        this.mTempArray = new String[1];
    }

    private final void $$robo$$com_android_internal_content_PackageMonitor$register(Context context, Looper thread, boolean externalStorage) {
        this.register(context, thread, null, externalStorage);
    }

    private final void $$robo$$com_android_internal_content_PackageMonitor$register(Context context, Looper thread, UserHandle user, boolean externalStorage) {
        if (this.mRegisteredContext != null) {
            throw new IllegalStateException("Already registered");
        }
        this.mRegisteredContext = context;
        this.mRegisteredHandler = thread == null ? BackgroundThread.getHandler() : new Handler(thread);
        if (user != null) {
            context.registerReceiverAsUser(this, user, sPackageFilt, null, this.mRegisteredHandler);
            context.registerReceiverAsUser(this, user, sNonDataFilt, null, this.mRegisteredHandler);
            if (externalStorage) {
                context.registerReceiverAsUser(this, user, sExternalFilt, null, this.mRegisteredHandler);
            }
        } else {
            context.registerReceiver(this, sPackageFilt, null, this.mRegisteredHandler);
            context.registerReceiver(this, sNonDataFilt, null, this.mRegisteredHandler);
            if (externalStorage) {
                context.registerReceiver(this, sExternalFilt, null, this.mRegisteredHandler);
            }
        }
    }

    private final Handler $$robo$$com_android_internal_content_PackageMonitor$getRegisteredHandler() {
        return this.mRegisteredHandler;
    }

    private final void $$robo$$com_android_internal_content_PackageMonitor$unregister() {
        if (this.mRegisteredContext == null) {
            throw new IllegalStateException("Not registered");
        }
        this.mRegisteredContext.unregisterReceiver(this);
        this.mRegisteredContext = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean $$robo$$com_android_internal_content_PackageMonitor$isPackageUpdating(String packageName) {
        HashSet<String> hashSet = this.mUpdatingPackages;
        synchronized (hashSet) {
            return this.mUpdatingPackages.contains(packageName);
        }
    }

    private final void $$robo$$com_android_internal_content_PackageMonitor$onBeginPackageChanges() {
    }

    private final void $$robo$$com_android_internal_content_PackageMonitor$onPackageAdded(String packageName, int uid) {
    }

    private final void $$robo$$com_android_internal_content_PackageMonitor$onPackageRemoved(String packageName, int uid) {
    }

    private final void $$robo$$com_android_internal_content_PackageMonitor$onPackageRemovedAllUsers(String packageName, int uid) {
    }

    private final void $$robo$$com_android_internal_content_PackageMonitor$onPackageUpdateStarted(String packageName, int uid) {
    }

    private final void $$robo$$com_android_internal_content_PackageMonitor$onPackageUpdateFinished(String packageName, int uid) {
    }

    private final boolean $$robo$$com_android_internal_content_PackageMonitor$onPackageChanged(String packageName, int uid, String[] components) {
        if (components != null) {
            for (String name : components) {
                if (!packageName.equals(name)) continue;
                return true;
            }
        }
        return false;
    }

    private final boolean $$robo$$com_android_internal_content_PackageMonitor$onHandleForceStop(Intent intent, String[] packages, int uid, boolean doit) {
        return false;
    }

    private final void $$robo$$com_android_internal_content_PackageMonitor$onHandleUserStop(Intent intent, int userHandle) {
    }

    private final void $$robo$$com_android_internal_content_PackageMonitor$onUidRemoved(int uid) {
    }

    private final void $$robo$$com_android_internal_content_PackageMonitor$onPackagesAvailable(String[] packages) {
    }

    private final void $$robo$$com_android_internal_content_PackageMonitor$onPackagesUnavailable(String[] packages) {
    }

    private final void $$robo$$com_android_internal_content_PackageMonitor$onPackageDisappeared(String packageName, int reason) {
    }

    private final void $$robo$$com_android_internal_content_PackageMonitor$onPackageAppeared(String packageName, int reason) {
    }

    private final void $$robo$$com_android_internal_content_PackageMonitor$onPackageModified(String packageName) {
    }

    private final boolean $$robo$$com_android_internal_content_PackageMonitor$didSomePackagesChange() {
        return this.mSomePackagesChanged;
    }

    private final int $$robo$$com_android_internal_content_PackageMonitor$isPackageAppearing(String packageName) {
        if (this.mAppearingPackages != null) {
            for (int i = this.mAppearingPackages.length - 1; i >= 0; --i) {
                if (!packageName.equals(this.mAppearingPackages[i])) continue;
                return this.mChangeType;
            }
        }
        return 0;
    }

    private final boolean $$robo$$com_android_internal_content_PackageMonitor$anyPackagesAppearing() {
        return this.mAppearingPackages != null;
    }

    private final int $$robo$$com_android_internal_content_PackageMonitor$isPackageDisappearing(String packageName) {
        if (this.mDisappearingPackages != null) {
            for (int i = this.mDisappearingPackages.length - 1; i >= 0; --i) {
                if (!packageName.equals(this.mDisappearingPackages[i])) continue;
                return this.mChangeType;
            }
        }
        return 0;
    }

    private final boolean $$robo$$com_android_internal_content_PackageMonitor$anyPackagesDisappearing() {
        return this.mDisappearingPackages != null;
    }

    private final boolean $$robo$$com_android_internal_content_PackageMonitor$isReplacing() {
        return this.mChangeType == 1;
    }

    private final boolean $$robo$$com_android_internal_content_PackageMonitor$isPackageModified(String packageName) {
        if (this.mModifiedPackages != null) {
            for (int i = this.mModifiedPackages.length - 1; i >= 0; --i) {
                if (!packageName.equals(this.mModifiedPackages[i])) continue;
                return true;
            }
        }
        return false;
    }

    private final void $$robo$$com_android_internal_content_PackageMonitor$onSomePackagesChanged() {
    }

    private final void $$robo$$com_android_internal_content_PackageMonitor$onFinishPackageChanges() {
    }

    private final int $$robo$$com_android_internal_content_PackageMonitor$getChangingUserId() {
        return this.mChangeUserId;
    }

    private final String $$robo$$com_android_internal_content_PackageMonitor$getPackageName(Intent intent) {
        Uri uri = intent.getData();
        String pkg = uri != null ? uri.getSchemeSpecificPart() : null;
        return pkg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$com_android_internal_content_PackageMonitor$onReceive(Context context, Intent intent) {
        this.mChangeUserId = intent.getIntExtra("android.intent.extra.user_handle", -10000);
        if (this.mChangeUserId == -10000) {
            throw new IllegalArgumentException("Intent broadcast does not contain user handle: " + intent);
        }
        this.onBeginPackageChanges();
        this.mAppearingPackages = null;
        this.mDisappearingPackages = null;
        this.mSomePackagesChanged = false;
        String action = intent.getAction();
        if ("android.intent.action.PACKAGE_ADDED".equals(action)) {
            String pkg = this.getPackageName(intent);
            int uid = intent.getIntExtra("android.intent.extra.UID", 0);
            this.mSomePackagesChanged = true;
            if (pkg != null) {
                this.mAppearingPackages = this.mTempArray;
                this.mTempArray[0] = pkg;
                if (intent.getBooleanExtra("android.intent.extra.REPLACING", false)) {
                    this.mModifiedPackages = this.mTempArray;
                    this.mChangeType = 1;
                    this.onPackageUpdateFinished(pkg, uid);
                    this.onPackageModified(pkg);
                } else {
                    this.mChangeType = 3;
                    this.onPackageAdded(pkg, uid);
                }
                this.onPackageAppeared(pkg, this.mChangeType);
                if (this.mChangeType == 1) {
                    HashSet<String> hashSet = this.mUpdatingPackages;
                    synchronized (hashSet) {
                        this.mUpdatingPackages.remove(pkg);
                    }
                }
            }
        } else if ("android.intent.action.PACKAGE_REMOVED".equals(action)) {
            String pkg = this.getPackageName(intent);
            int uid = intent.getIntExtra("android.intent.extra.UID", 0);
            if (pkg != null) {
                this.mDisappearingPackages = this.mTempArray;
                this.mTempArray[0] = pkg;
                if (intent.getBooleanExtra("android.intent.extra.REPLACING", false)) {
                    this.mChangeType = 1;
                    HashSet<String> hashSet = this.mUpdatingPackages;
                    synchronized (hashSet) {
                    }
                    this.onPackageUpdateStarted(pkg, uid);
                } else {
                    this.mChangeType = 3;
                    this.mSomePackagesChanged = true;
                    this.onPackageRemoved(pkg, uid);
                    if (intent.getBooleanExtra("android.intent.extra.REMOVED_FOR_ALL_USERS", false)) {
                        this.onPackageRemovedAllUsers(pkg, uid);
                    }
                }
                this.onPackageDisappeared(pkg, this.mChangeType);
            }
        } else if ("android.intent.action.PACKAGE_CHANGED".equals(action)) {
            String pkg = this.getPackageName(intent);
            int uid = intent.getIntExtra("android.intent.extra.UID", 0);
            String[] components = intent.getStringArrayExtra("android.intent.extra.changed_component_name_list");
            if (pkg != null) {
                this.mModifiedPackages = this.mTempArray;
                this.mTempArray[0] = pkg;
                this.mChangeType = 3;
                if (this.onPackageChanged(pkg, uid, components)) {
                    this.mSomePackagesChanged = true;
                }
                this.onPackageModified(pkg);
            }
        } else if ("android.intent.action.QUERY_PACKAGE_RESTART".equals(action)) {
            this.mDisappearingPackages = intent.getStringArrayExtra("android.intent.extra.PACKAGES");
            this.mChangeType = 2;
            boolean canRestart = this.onHandleForceStop(intent, this.mDisappearingPackages, intent.getIntExtra("android.intent.extra.UID", 0), false);
            if (canRestart) {
                this.setResultCode(-1);
            }
        } else if ("android.intent.action.PACKAGE_RESTARTED".equals(action)) {
            this.mDisappearingPackages = new String[]{this.getPackageName(intent)};
            this.mChangeType = 2;
            this.onHandleForceStop(intent, this.mDisappearingPackages, intent.getIntExtra("android.intent.extra.UID", 0), true);
        } else if ("android.intent.action.UID_REMOVED".equals(action)) {
            this.onUidRemoved(intent.getIntExtra("android.intent.extra.UID", 0));
        } else if ("android.intent.action.USER_STOPPED".equals(action)) {
            if (intent.hasExtra("android.intent.extra.user_handle")) {
                this.onHandleUserStop(intent, intent.getIntExtra("android.intent.extra.user_handle", 0));
            }
        } else if ("android.intent.action.EXTERNAL_APPLICATIONS_AVAILABLE".equals(action)) {
            String[] pkgList = intent.getStringArrayExtra("android.intent.extra.changed_package_list");
            this.mAppearingPackages = pkgList;
            this.mChangeType = intent.getBooleanExtra("android.intent.extra.REPLACING", false) ? 1 : 2;
            this.mSomePackagesChanged = true;
            if (pkgList != null) {
                this.onPackagesAvailable(pkgList);
                for (int i = 0; i < pkgList.length; ++i) {
                    this.onPackageAppeared(pkgList[i], this.mChangeType);
                }
            }
        } else if ("android.intent.action.EXTERNAL_APPLICATIONS_UNAVAILABLE".equals(action)) {
            String[] pkgList = intent.getStringArrayExtra("android.intent.extra.changed_package_list");
            this.mDisappearingPackages = pkgList;
            this.mChangeType = intent.getBooleanExtra("android.intent.extra.REPLACING", false) ? 1 : 2;
            this.mSomePackagesChanged = true;
            if (pkgList != null) {
                this.onPackagesUnavailable(pkgList);
                for (int i = 0; i < pkgList.length; ++i) {
                    this.onPackageDisappeared(pkgList[i], this.mChangeType);
                }
            }
        }
        if (this.mSomePackagesChanged) {
            this.onSomePackagesChanged();
        }
        this.onFinishPackageChanges();
        this.mChangeUserId = -10000;
    }

    static void __staticInitializer__() {
        sPackageFilt = new IntentFilter();
        sNonDataFilt = new IntentFilter();
        sExternalFilt = new IntentFilter();
        sPackageFilt.addAction("android.intent.action.PACKAGE_ADDED");
        sPackageFilt.addAction("android.intent.action.PACKAGE_REMOVED");
        sPackageFilt.addAction("android.intent.action.PACKAGE_CHANGED");
        sPackageFilt.addAction("android.intent.action.QUERY_PACKAGE_RESTART");
        sPackageFilt.addAction("android.intent.action.PACKAGE_RESTARTED");
        sPackageFilt.addAction("android.intent.action.UID_REMOVED");
        sPackageFilt.addDataScheme("package");
        sNonDataFilt.addAction("android.intent.action.UID_REMOVED");
        sNonDataFilt.addAction("android.intent.action.USER_STOPPED");
        sExternalFilt.addAction("android.intent.action.EXTERNAL_APPLICATIONS_AVAILABLE");
        sExternalFilt.addAction("android.intent.action.EXTERNAL_APPLICATIONS_UNAVAILABLE");
    }

    private void __constructor__() {
        this.$$robo$$com_android_internal_content_PackageMonitor$__constructor__();
    }

    public PackageMonitor() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_content_PackageMonitor$__constructor__(), 0, this);
    }

    public void register(Context context, Looper looper, boolean bl) {
        InvokeDynamicSupport.bootstrap("register", $$robo$$com_android_internal_content_PackageMonitor$register(android.content.Context android.os.Looper boolean ), 0, this, context, looper, bl);
    }

    public void register(Context context, Looper looper, UserHandle userHandle, boolean bl) {
        InvokeDynamicSupport.bootstrap("register", $$robo$$com_android_internal_content_PackageMonitor$register(android.content.Context android.os.Looper android.os.UserHandle boolean ), 0, this, context, looper, userHandle, bl);
    }

    public Handler getRegisteredHandler() {
        return InvokeDynamicSupport.bootstrap("getRegisteredHandler", $$robo$$com_android_internal_content_PackageMonitor$getRegisteredHandler(), 0, this);
    }

    public void unregister() {
        InvokeDynamicSupport.bootstrap("unregister", $$robo$$com_android_internal_content_PackageMonitor$unregister(), 0, this);
    }

    boolean isPackageUpdating(String string2) {
        return (boolean)InvokeDynamicSupport.bootstrap("isPackageUpdating", $$robo$$com_android_internal_content_PackageMonitor$isPackageUpdating(java.lang.String ), 0, this, string2);
    }

    public void onBeginPackageChanges() {
        InvokeDynamicSupport.bootstrap("onBeginPackageChanges", $$robo$$com_android_internal_content_PackageMonitor$onBeginPackageChanges(), 0, this);
    }

    public void onPackageAdded(String string2, int n) {
        InvokeDynamicSupport.bootstrap("onPackageAdded", $$robo$$com_android_internal_content_PackageMonitor$onPackageAdded(java.lang.String int ), 0, this, string2, n);
    }

    public void onPackageRemoved(String string2, int n) {
        InvokeDynamicSupport.bootstrap("onPackageRemoved", $$robo$$com_android_internal_content_PackageMonitor$onPackageRemoved(java.lang.String int ), 0, this, string2, n);
    }

    public void onPackageRemovedAllUsers(String string2, int n) {
        InvokeDynamicSupport.bootstrap("onPackageRemovedAllUsers", $$robo$$com_android_internal_content_PackageMonitor$onPackageRemovedAllUsers(java.lang.String int ), 0, this, string2, n);
    }

    public void onPackageUpdateStarted(String string2, int n) {
        InvokeDynamicSupport.bootstrap("onPackageUpdateStarted", $$robo$$com_android_internal_content_PackageMonitor$onPackageUpdateStarted(java.lang.String int ), 0, this, string2, n);
    }

    public void onPackageUpdateFinished(String string2, int n) {
        InvokeDynamicSupport.bootstrap("onPackageUpdateFinished", $$robo$$com_android_internal_content_PackageMonitor$onPackageUpdateFinished(java.lang.String int ), 0, this, string2, n);
    }

    public boolean onPackageChanged(String string2, int n, String[] stringArray) {
        return (boolean)InvokeDynamicSupport.bootstrap("onPackageChanged", $$robo$$com_android_internal_content_PackageMonitor$onPackageChanged(java.lang.String int java.lang.String[] ), 0, this, string2, n, stringArray);
    }

    public boolean onHandleForceStop(Intent intent, String[] stringArray, int n, boolean bl) {
        return (boolean)InvokeDynamicSupport.bootstrap("onHandleForceStop", $$robo$$com_android_internal_content_PackageMonitor$onHandleForceStop(android.content.Intent java.lang.String[] int boolean ), 0, this, intent, stringArray, n, bl);
    }

    public void onHandleUserStop(Intent intent, int n) {
        InvokeDynamicSupport.bootstrap("onHandleUserStop", $$robo$$com_android_internal_content_PackageMonitor$onHandleUserStop(android.content.Intent int ), 0, this, intent, n);
    }

    public void onUidRemoved(int n) {
        InvokeDynamicSupport.bootstrap("onUidRemoved", $$robo$$com_android_internal_content_PackageMonitor$onUidRemoved(int ), 0, this, n);
    }

    public void onPackagesAvailable(String[] stringArray) {
        InvokeDynamicSupport.bootstrap("onPackagesAvailable", $$robo$$com_android_internal_content_PackageMonitor$onPackagesAvailable(java.lang.String[] ), 0, this, stringArray);
    }

    public void onPackagesUnavailable(String[] stringArray) {
        InvokeDynamicSupport.bootstrap("onPackagesUnavailable", $$robo$$com_android_internal_content_PackageMonitor$onPackagesUnavailable(java.lang.String[] ), 0, this, stringArray);
    }

    public void onPackageDisappeared(String string2, int n) {
        InvokeDynamicSupport.bootstrap("onPackageDisappeared", $$robo$$com_android_internal_content_PackageMonitor$onPackageDisappeared(java.lang.String int ), 0, this, string2, n);
    }

    public void onPackageAppeared(String string2, int n) {
        InvokeDynamicSupport.bootstrap("onPackageAppeared", $$robo$$com_android_internal_content_PackageMonitor$onPackageAppeared(java.lang.String int ), 0, this, string2, n);
    }

    public void onPackageModified(String string2) {
        InvokeDynamicSupport.bootstrap("onPackageModified", $$robo$$com_android_internal_content_PackageMonitor$onPackageModified(java.lang.String ), 0, this, string2);
    }

    public boolean didSomePackagesChange() {
        return (boolean)InvokeDynamicSupport.bootstrap("didSomePackagesChange", $$robo$$com_android_internal_content_PackageMonitor$didSomePackagesChange(), 0, this);
    }

    public int isPackageAppearing(String string2) {
        return (int)InvokeDynamicSupport.bootstrap("isPackageAppearing", $$robo$$com_android_internal_content_PackageMonitor$isPackageAppearing(java.lang.String ), 0, this, string2);
    }

    public boolean anyPackagesAppearing() {
        return (boolean)InvokeDynamicSupport.bootstrap("anyPackagesAppearing", $$robo$$com_android_internal_content_PackageMonitor$anyPackagesAppearing(), 0, this);
    }

    public int isPackageDisappearing(String string2) {
        return (int)InvokeDynamicSupport.bootstrap("isPackageDisappearing", $$robo$$com_android_internal_content_PackageMonitor$isPackageDisappearing(java.lang.String ), 0, this, string2);
    }

    public boolean anyPackagesDisappearing() {
        return (boolean)InvokeDynamicSupport.bootstrap("anyPackagesDisappearing", $$robo$$com_android_internal_content_PackageMonitor$anyPackagesDisappearing(), 0, this);
    }

    public boolean isReplacing() {
        return (boolean)InvokeDynamicSupport.bootstrap("isReplacing", $$robo$$com_android_internal_content_PackageMonitor$isReplacing(), 0, this);
    }

    public boolean isPackageModified(String string2) {
        return (boolean)InvokeDynamicSupport.bootstrap("isPackageModified", $$robo$$com_android_internal_content_PackageMonitor$isPackageModified(java.lang.String ), 0, this, string2);
    }

    public void onSomePackagesChanged() {
        InvokeDynamicSupport.bootstrap("onSomePackagesChanged", $$robo$$com_android_internal_content_PackageMonitor$onSomePackagesChanged(), 0, this);
    }

    public void onFinishPackageChanges() {
        InvokeDynamicSupport.bootstrap("onFinishPackageChanges", $$robo$$com_android_internal_content_PackageMonitor$onFinishPackageChanges(), 0, this);
    }

    public int getChangingUserId() {
        return (int)InvokeDynamicSupport.bootstrap("getChangingUserId", $$robo$$com_android_internal_content_PackageMonitor$getChangingUserId(), 0, this);
    }

    String getPackageName(Intent intent) {
        return InvokeDynamicSupport.bootstrap("getPackageName", $$robo$$com_android_internal_content_PackageMonitor$getPackageName(android.content.Intent ), 0, this, intent);
    }

    @Override
    public void onReceive(Context context, Intent intent) {
        InvokeDynamicSupport.bootstrap("onReceive", $$robo$$com_android_internal_content_PackageMonitor$onReceive(android.content.Context android.content.Intent ), 0, this, context, intent);
    }

    static {
        RobolectricInternals.classInitializing(PackageMonitor.class);
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (PackageMonitor)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

