/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.http.multipart;

import com.android.internal.http.multipart.Part;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Random;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.Header;
import org.apache.http.entity.AbstractHttpEntity;
import org.apache.http.message.BasicHeader;
import org.apache.http.params.HttpParams;
import org.apache.http.util.EncodingUtils;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class MultipartEntity
extends AbstractHttpEntity
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static Log log;
    private static String MULTIPART_FORM_CONTENT_TYPE = "multipart/form-data";
    public static String MULTIPART_BOUNDARY = "http.method.multipart.boundary";
    private static byte[] MULTIPART_CHARS;
    protected Part[] parts;
    private byte[] multipartBoundary;
    private HttpParams params;
    private boolean contentConsumed;

    private static final byte[] $$robo$$com_android_internal_http_multipart_MultipartEntity$generateMultipartBoundary() {
        Random rand = new Random();
        byte[] bytes = new byte[rand.nextInt(11) + 30];
        for (int i = 0; i < bytes.length; ++i) {
            bytes[i] = MULTIPART_CHARS[rand.nextInt(MULTIPART_CHARS.length)];
        }
        return bytes;
    }

    private void $$robo$$com_android_internal_http_multipart_MultipartEntity$__constructor__(Part[] parts, HttpParams params) {
        this.contentConsumed = false;
        if (parts == null) {
            throw new IllegalArgumentException("parts cannot be null");
        }
        if (params == null) {
            throw new IllegalArgumentException("params cannot be null");
        }
        this.parts = parts;
        this.params = params;
    }

    private void $$robo$$com_android_internal_http_multipart_MultipartEntity$__constructor__(Part[] parts) {
        this.contentConsumed = false;
        this.setContentType("multipart/form-data");
        if (parts == null) {
            throw new IllegalArgumentException("parts cannot be null");
        }
        this.parts = parts;
        this.params = null;
    }

    private final byte[] $$robo$$com_android_internal_http_multipart_MultipartEntity$getMultipartBoundary() {
        if (this.multipartBoundary == null) {
            String temp = null;
            if (this.params != null) {
                temp = (String)this.params.getParameter("http.method.multipart.boundary");
            }
            this.multipartBoundary = temp != null ? EncodingUtils.getAsciiBytes(temp) : MultipartEntity.generateMultipartBoundary();
        }
        return this.multipartBoundary;
    }

    private final boolean $$robo$$com_android_internal_http_multipart_MultipartEntity$isRepeatable() {
        for (int i = 0; i < this.parts.length; ++i) {
            if (this.parts[i].isRepeatable()) continue;
            return false;
        }
        return true;
    }

    private final void $$robo$$com_android_internal_http_multipart_MultipartEntity$writeTo(OutputStream out) throws IOException {
        Part.sendParts(out, this.parts, this.getMultipartBoundary());
    }

    private final Header $$robo$$com_android_internal_http_multipart_MultipartEntity$getContentType() {
        StringBuffer buffer = new StringBuffer("multipart/form-data");
        buffer.append("; boundary=");
        buffer.append(EncodingUtils.getAsciiString(this.getMultipartBoundary()));
        return new BasicHeader("Content-Type", buffer.toString());
    }

    private final long $$robo$$com_android_internal_http_multipart_MultipartEntity$getContentLength() {
        try {
            return Part.getLengthOfParts(this.parts, this.getMultipartBoundary());
        }
        catch (Exception e) {
            log.error("An exception occurred while getting the length of the parts", e);
            return 0L;
        }
    }

    private final InputStream $$robo$$com_android_internal_http_multipart_MultipartEntity$getContent() throws IOException, IllegalStateException {
        if (!this.isRepeatable() && this.contentConsumed) {
            throw new IllegalStateException("Content has been consumed");
        }
        this.contentConsumed = true;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        Part.sendParts(baos, this.parts, this.multipartBoundary);
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        return bais;
    }

    private final boolean $$robo$$com_android_internal_http_multipart_MultipartEntity$isStreaming() {
        return false;
    }

    static void __staticInitializer__() {
        log = LogFactory.getLog(MultipartEntity.class);
        MULTIPART_CHARS = EncodingUtils.getAsciiBytes("-_1234567890abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ");
    }

    private static byte[] generateMultipartBoundary() {
        return InvokeDynamicSupport.bootstrapStatic("generateMultipartBoundary", $$robo$$com_android_internal_http_multipart_MultipartEntity$generateMultipartBoundary(), 0);
    }

    private void __constructor__(Part[] partArray, HttpParams httpParams) {
        this.$$robo$$com_android_internal_http_multipart_MultipartEntity$__constructor__(partArray, httpParams);
    }

    public MultipartEntity(Part[] partArray, HttpParams httpParams) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_http_multipart_MultipartEntity$__constructor__(com.android.internal.http.multipart.Part[] org.apache.http.params.HttpParams ), 0, this, partArray, httpParams);
    }

    private void __constructor__(Part[] partArray) {
        this.$$robo$$com_android_internal_http_multipart_MultipartEntity$__constructor__(partArray);
    }

    public MultipartEntity(Part[] partArray) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_http_multipart_MultipartEntity$__constructor__(com.android.internal.http.multipart.Part[] ), 0, this, partArray);
    }

    protected byte[] getMultipartBoundary() {
        return InvokeDynamicSupport.bootstrap("getMultipartBoundary", $$robo$$com_android_internal_http_multipart_MultipartEntity$getMultipartBoundary(), 0, this);
    }

    @Override
    public boolean isRepeatable() {
        return (boolean)InvokeDynamicSupport.bootstrap("isRepeatable", $$robo$$com_android_internal_http_multipart_MultipartEntity$isRepeatable(), 0, this);
    }

    @Override
    public void writeTo(OutputStream outputStream) throws IOException {
        InvokeDynamicSupport.bootstrap("writeTo", $$robo$$com_android_internal_http_multipart_MultipartEntity$writeTo(java.io.OutputStream ), 0, this, outputStream);
    }

    @Override
    public Header getContentType() {
        return InvokeDynamicSupport.bootstrap("getContentType", $$robo$$com_android_internal_http_multipart_MultipartEntity$getContentType(), 0, this);
    }

    @Override
    public long getContentLength() {
        return (long)InvokeDynamicSupport.bootstrap("getContentLength", $$robo$$com_android_internal_http_multipart_MultipartEntity$getContentLength(), 0, this);
    }

    @Override
    public InputStream getContent() throws IOException, IllegalStateException {
        return InvokeDynamicSupport.bootstrap("getContent", $$robo$$com_android_internal_http_multipart_MultipartEntity$getContent(), 0, this);
    }

    @Override
    public boolean isStreaming() {
        return (boolean)InvokeDynamicSupport.bootstrap("isStreaming", $$robo$$com_android_internal_http_multipart_MultipartEntity$isStreaming(), 0, this);
    }

    static {
        RobolectricInternals.classInitializing(MultipartEntity.class);
    }

    public /* synthetic */ MultipartEntity() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (MultipartEntity)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

