/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.http.multipart;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.util.EncodingUtils;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public abstract class Part
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static Log LOG;
    protected static String BOUNDARY = "----------------314159265358979323846";
    protected static byte[] BOUNDARY_BYTES;
    private static byte[] DEFAULT_BOUNDARY_BYTES;
    protected static String CRLF = "\r\n";
    protected static byte[] CRLF_BYTES;
    protected static String QUOTE = "\"";
    protected static byte[] QUOTE_BYTES;
    protected static String EXTRA = "--";
    protected static byte[] EXTRA_BYTES;
    protected static String CONTENT_DISPOSITION = "Content-Disposition: form-data; name=";
    protected static byte[] CONTENT_DISPOSITION_BYTES;
    protected static String CONTENT_TYPE = "Content-Type: ";
    protected static byte[] CONTENT_TYPE_BYTES;
    protected static String CHARSET = "; charset=";
    protected static byte[] CHARSET_BYTES;
    protected static String CONTENT_TRANSFER_ENCODING = "Content-Transfer-Encoding: ";
    protected static byte[] CONTENT_TRANSFER_ENCODING_BYTES;
    private byte[] boundaryBytes;

    private void $$robo$$com_android_internal_http_multipart_Part$__constructor__() {
    }

    private static final String $$robo$$com_android_internal_http_multipart_Part$getBoundary() {
        return "----------------314159265358979323846";
    }

    public abstract String getName();

    public abstract String getContentType();

    public abstract String getCharSet();

    public abstract String getTransferEncoding();

    private final byte[] $$robo$$com_android_internal_http_multipart_Part$getPartBoundary() {
        if (this.boundaryBytes == null) {
            return DEFAULT_BOUNDARY_BYTES;
        }
        return this.boundaryBytes;
    }

    private final void $$robo$$com_android_internal_http_multipart_Part$setPartBoundary(byte[] boundaryBytes) {
        this.boundaryBytes = boundaryBytes;
    }

    private final boolean $$robo$$com_android_internal_http_multipart_Part$isRepeatable() {
        return true;
    }

    private final void $$robo$$com_android_internal_http_multipart_Part$sendStart(OutputStream out) throws IOException {
        LOG.trace("enter sendStart(OutputStream out)");
        out.write(EXTRA_BYTES);
        out.write(this.getPartBoundary());
        out.write(CRLF_BYTES);
    }

    private final void $$robo$$com_android_internal_http_multipart_Part$sendDispositionHeader(OutputStream out) throws IOException {
        LOG.trace("enter sendDispositionHeader(OutputStream out)");
        out.write(CONTENT_DISPOSITION_BYTES);
        out.write(QUOTE_BYTES);
        out.write(EncodingUtils.getAsciiBytes(this.getName()));
        out.write(QUOTE_BYTES);
    }

    private final void $$robo$$com_android_internal_http_multipart_Part$sendContentTypeHeader(OutputStream out) throws IOException {
        LOG.trace("enter sendContentTypeHeader(OutputStream out)");
        String contentType = this.getContentType();
        if (contentType != null) {
            out.write(CRLF_BYTES);
            out.write(CONTENT_TYPE_BYTES);
            out.write(EncodingUtils.getAsciiBytes(contentType));
            String charSet = this.getCharSet();
            if (charSet != null) {
                out.write(CHARSET_BYTES);
                out.write(EncodingUtils.getAsciiBytes(charSet));
            }
        }
    }

    private final void $$robo$$com_android_internal_http_multipart_Part$sendTransferEncodingHeader(OutputStream out) throws IOException {
        LOG.trace("enter sendTransferEncodingHeader(OutputStream out)");
        String transferEncoding = this.getTransferEncoding();
        if (transferEncoding != null) {
            out.write(CRLF_BYTES);
            out.write(CONTENT_TRANSFER_ENCODING_BYTES);
            out.write(EncodingUtils.getAsciiBytes(transferEncoding));
        }
    }

    private final void $$robo$$com_android_internal_http_multipart_Part$sendEndOfHeader(OutputStream out) throws IOException {
        LOG.trace("enter sendEndOfHeader(OutputStream out)");
        out.write(CRLF_BYTES);
        out.write(CRLF_BYTES);
    }

    protected abstract void sendData(OutputStream var1) throws IOException;

    protected abstract long lengthOfData() throws IOException;

    private final void $$robo$$com_android_internal_http_multipart_Part$sendEnd(OutputStream out) throws IOException {
        LOG.trace("enter sendEnd(OutputStream out)");
        out.write(CRLF_BYTES);
    }

    private final void $$robo$$com_android_internal_http_multipart_Part$send(OutputStream out) throws IOException {
        LOG.trace("enter send(OutputStream out)");
        this.sendStart(out);
        this.sendDispositionHeader(out);
        this.sendContentTypeHeader(out);
        this.sendTransferEncodingHeader(out);
        this.sendEndOfHeader(out);
        this.sendData(out);
        this.sendEnd(out);
    }

    private final long $$robo$$com_android_internal_http_multipart_Part$length() throws IOException {
        LOG.trace("enter length()");
        if (this.lengthOfData() < 0L) {
            return -1L;
        }
        ByteArrayOutputStream overhead = new ByteArrayOutputStream();
        this.sendStart(overhead);
        this.sendDispositionHeader(overhead);
        this.sendContentTypeHeader(overhead);
        this.sendTransferEncodingHeader(overhead);
        this.sendEndOfHeader(overhead);
        this.sendEnd(overhead);
        return (long)overhead.size() + this.lengthOfData();
    }

    private final String $$robo$$com_android_internal_http_multipart_Part$toString() {
        return this.getName();
    }

    private static final void $$robo$$com_android_internal_http_multipart_Part$sendParts(OutputStream out, Part[] parts) throws IOException {
        Part.sendParts(out, parts, DEFAULT_BOUNDARY_BYTES);
    }

    private static final void $$robo$$com_android_internal_http_multipart_Part$sendParts(OutputStream out, Part[] parts, byte[] partBoundary) throws IOException {
        if (parts == null) {
            throw new IllegalArgumentException("Parts may not be null");
        }
        if (partBoundary == null || partBoundary.length == 0) {
            throw new IllegalArgumentException("partBoundary may not be empty");
        }
        for (int i = 0; i < parts.length; ++i) {
            parts[i].setPartBoundary(partBoundary);
            parts[i].send(out);
        }
        out.write(EXTRA_BYTES);
        out.write(partBoundary);
        out.write(EXTRA_BYTES);
        out.write(CRLF_BYTES);
    }

    private static final long $$robo$$com_android_internal_http_multipart_Part$getLengthOfParts(Part[] parts) throws IOException {
        return Part.getLengthOfParts(parts, DEFAULT_BOUNDARY_BYTES);
    }

    private static final long $$robo$$com_android_internal_http_multipart_Part$getLengthOfParts(Part[] parts, byte[] partBoundary) throws IOException {
        LOG.trace("getLengthOfParts(Parts[])");
        if (parts == null) {
            throw new IllegalArgumentException("Parts may not be null");
        }
        long total = 0L;
        for (int i = 0; i < parts.length; ++i) {
            parts[i].setPartBoundary(partBoundary);
            long l = parts[i].length();
            if (l < 0L) {
                return -1L;
            }
            total += l;
        }
        total += (long)EXTRA_BYTES.length;
        total += (long)partBoundary.length;
        total += (long)EXTRA_BYTES.length;
        return total += (long)CRLF_BYTES.length;
    }

    static void __staticInitializer__() {
        LOG = LogFactory.getLog(Part.class);
        BOUNDARY_BYTES = EncodingUtils.getAsciiBytes("----------------314159265358979323846");
        DEFAULT_BOUNDARY_BYTES = BOUNDARY_BYTES;
        CRLF_BYTES = EncodingUtils.getAsciiBytes("\r\n");
        QUOTE_BYTES = EncodingUtils.getAsciiBytes("\"");
        EXTRA_BYTES = EncodingUtils.getAsciiBytes("--");
        CONTENT_DISPOSITION_BYTES = EncodingUtils.getAsciiBytes("Content-Disposition: form-data; name=");
        CONTENT_TYPE_BYTES = EncodingUtils.getAsciiBytes("Content-Type: ");
        CHARSET_BYTES = EncodingUtils.getAsciiBytes("; charset=");
        CONTENT_TRANSFER_ENCODING_BYTES = EncodingUtils.getAsciiBytes("Content-Transfer-Encoding: ");
    }

    private void __constructor__() {
        this.$$robo$$com_android_internal_http_multipart_Part$__constructor__();
    }

    public Part() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_http_multipart_Part$__constructor__(), 0, this);
    }

    public static String getBoundary() {
        return InvokeDynamicSupport.bootstrapStatic("getBoundary", $$robo$$com_android_internal_http_multipart_Part$getBoundary(), 0);
    }

    protected byte[] getPartBoundary() {
        return InvokeDynamicSupport.bootstrap("getPartBoundary", $$robo$$com_android_internal_http_multipart_Part$getPartBoundary(), 0, this);
    }

    void setPartBoundary(byte[] byArray) {
        InvokeDynamicSupport.bootstrap("setPartBoundary", $$robo$$com_android_internal_http_multipart_Part$setPartBoundary(byte[] ), 0, this, byArray);
    }

    public boolean isRepeatable() {
        return (boolean)InvokeDynamicSupport.bootstrap("isRepeatable", $$robo$$com_android_internal_http_multipart_Part$isRepeatable(), 0, this);
    }

    protected void sendStart(OutputStream outputStream) throws IOException {
        InvokeDynamicSupport.bootstrap("sendStart", $$robo$$com_android_internal_http_multipart_Part$sendStart(java.io.OutputStream ), 0, this, outputStream);
    }

    protected void sendDispositionHeader(OutputStream outputStream) throws IOException {
        InvokeDynamicSupport.bootstrap("sendDispositionHeader", $$robo$$com_android_internal_http_multipart_Part$sendDispositionHeader(java.io.OutputStream ), 0, this, outputStream);
    }

    protected void sendContentTypeHeader(OutputStream outputStream) throws IOException {
        InvokeDynamicSupport.bootstrap("sendContentTypeHeader", $$robo$$com_android_internal_http_multipart_Part$sendContentTypeHeader(java.io.OutputStream ), 0, this, outputStream);
    }

    protected void sendTransferEncodingHeader(OutputStream outputStream) throws IOException {
        InvokeDynamicSupport.bootstrap("sendTransferEncodingHeader", $$robo$$com_android_internal_http_multipart_Part$sendTransferEncodingHeader(java.io.OutputStream ), 0, this, outputStream);
    }

    protected void sendEndOfHeader(OutputStream outputStream) throws IOException {
        InvokeDynamicSupport.bootstrap("sendEndOfHeader", $$robo$$com_android_internal_http_multipart_Part$sendEndOfHeader(java.io.OutputStream ), 0, this, outputStream);
    }

    protected void sendEnd(OutputStream outputStream) throws IOException {
        InvokeDynamicSupport.bootstrap("sendEnd", $$robo$$com_android_internal_http_multipart_Part$sendEnd(java.io.OutputStream ), 0, this, outputStream);
    }

    public void send(OutputStream outputStream) throws IOException {
        InvokeDynamicSupport.bootstrap("send", $$robo$$com_android_internal_http_multipart_Part$send(java.io.OutputStream ), 0, this, outputStream);
    }

    public long length() throws IOException {
        return (long)InvokeDynamicSupport.bootstrap("length", $$robo$$com_android_internal_http_multipart_Part$length(), 0, this);
    }

    public String toString() {
        return InvokeDynamicSupport.bootstrap("toString", $$robo$$com_android_internal_http_multipart_Part$toString(), 0, this);
    }

    public static void sendParts(OutputStream outputStream, Part[] partArray) throws IOException {
        InvokeDynamicSupport.bootstrapStatic("sendParts", $$robo$$com_android_internal_http_multipart_Part$sendParts(java.io.OutputStream com.android.internal.http.multipart.Part[] ), 0, (OutputStream)outputStream, (Part[])partArray);
    }

    public static void sendParts(OutputStream outputStream, Part[] partArray, byte[] byArray) throws IOException {
        InvokeDynamicSupport.bootstrapStatic("sendParts", $$robo$$com_android_internal_http_multipart_Part$sendParts(java.io.OutputStream com.android.internal.http.multipart.Part[] byte[] ), 0, (OutputStream)outputStream, (Part[])partArray, (byte[])byArray);
    }

    public static long getLengthOfParts(Part[] partArray) throws IOException {
        return (long)InvokeDynamicSupport.bootstrapStatic("getLengthOfParts", $$robo$$com_android_internal_http_multipart_Part$getLengthOfParts(com.android.internal.http.multipart.Part[] ), 0, (Part[])partArray);
    }

    public static long getLengthOfParts(Part[] partArray, byte[] byArray) throws IOException {
        return (long)InvokeDynamicSupport.bootstrapStatic("getLengthOfParts", $$robo$$com_android_internal_http_multipart_Part$getLengthOfParts(com.android.internal.http.multipart.Part[] byte[] ), 0, (Part[])partArray, (byte[])byArray);
    }

    static {
        RobolectricInternals.classInitializing(Part.class);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Part)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

