/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.inputmethod;

import android.app.AppOpsManager;
import android.content.ContentResolver;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.content.res.Resources;
import android.provider.Settings;
import android.text.TextUtils;
import android.util.Pair;
import android.util.Slog;
import android.view.inputmethod.InputMethodInfo;
import android.view.inputmethod.InputMethodSubtype;
import android.view.textservice.SpellCheckerInfo;
import android.view.textservice.TextServicesManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class InputMethodUtils
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    public static boolean DEBUG = false;
    public static int NOT_A_SUBTYPE_ID = -1;
    public static String SUBTYPE_MODE_ANY;
    public static String SUBTYPE_MODE_KEYBOARD = "keyboard";
    public static String SUBTYPE_MODE_VOICE = "voice";
    private static String TAG = "InputMethodUtils";
    private static Locale ENGLISH_LOCALE;
    private static String NOT_A_SUBTYPE_ID_STR;
    private static String TAG_ENABLED_WHEN_DEFAULT_IS_NOT_ASCII_CAPABLE = "EnabledWhenDefaultIsNotAsciiCapable";
    private static String TAG_ASCII_CAPABLE = "AsciiCapable";
    private static Locale[] SEARCH_ORDER_OF_FALLBACK_LOCALES;

    private void $$robo$$com_android_internal_inputmethod_InputMethodUtils$__constructor__() {
    }

    private static final String $$robo$$com_android_internal_inputmethod_InputMethodUtils$getStackTrace() {
        StringBuilder sb = new StringBuilder();
        try {
            throw new RuntimeException();
        }
        catch (RuntimeException e) {
            StackTraceElement[] frames = e.getStackTrace();
            for (int j = 1; j < frames.length; ++j) {
                sb.append(frames[j].toString() + "\n");
            }
            return sb.toString();
        }
    }

    private static final String $$robo$$com_android_internal_inputmethod_InputMethodUtils$getApiCallStack() {
        String apiCallStack = "";
        try {
            throw new RuntimeException();
        }
        catch (RuntimeException e) {
            StackTraceElement[] frames = e.getStackTrace();
            for (int j = 1; j < frames.length; ++j) {
                String tempCallStack = frames[j].toString();
                if (TextUtils.isEmpty(apiCallStack)) {
                    apiCallStack = tempCallStack;
                    continue;
                }
                if (tempCallStack.indexOf("Transact(") >= 0) break;
                apiCallStack = tempCallStack;
            }
            return apiCallStack;
        }
    }

    private static final boolean $$robo$$com_android_internal_inputmethod_InputMethodUtils$isSystemIme(InputMethodInfo inputMethod) {
        return (inputMethod.getServiceInfo().applicationInfo.flags & 1) != 0;
    }

    @Deprecated
    private static final boolean $$robo$$com_android_internal_inputmethod_InputMethodUtils$isSystemImeThatHasEnglishKeyboardSubtype(InputMethodInfo imi) {
        if (!InputMethodUtils.isSystemIme(imi)) {
            return false;
        }
        return InputMethodUtils.containsSubtypeOf(imi, ENGLISH_LOCALE.getLanguage(), "keyboard");
    }

    private static final Locale $$robo$$com_android_internal_inputmethod_InputMethodUtils$getFallbackLocaleForDefaultIme(ArrayList<InputMethodInfo> imis, Context context) {
        for (Locale fallbackLocale : SEARCH_ORDER_OF_FALLBACK_LOCALES) {
            for (int i = 0; i < imis.size(); ++i) {
                InputMethodInfo imi = imis.get(i);
                if (!InputMethodUtils.isSystemIme(imi) || !imi.isDefault(context) || !InputMethodUtils.containsSubtypeOf(imi, fallbackLocale, false, "keyboard")) continue;
                return fallbackLocale;
            }
        }
        return null;
    }

    private static final boolean $$robo$$com_android_internal_inputmethod_InputMethodUtils$isSystemAuxilialyImeThatHasAutomaticSubtype(InputMethodInfo imi) {
        if (!InputMethodUtils.isSystemIme(imi)) {
            return false;
        }
        if (!imi.isAuxiliaryIme()) {
            return false;
        }
        int subtypeCount = imi.getSubtypeCount();
        for (int i = 0; i < subtypeCount; ++i) {
            InputMethodSubtype s = imi.getSubtypeAt(i);
            if (!s.overridesImplicitlyEnabledSubtype()) continue;
            return true;
        }
        return false;
    }

    private static final Locale $$robo$$com_android_internal_inputmethod_InputMethodUtils$getSystemLocaleFromContext(Context context) {
        try {
            return context.getResources().getConfiguration().locale;
        }
        catch (Resources.NotFoundException ex) {
            return null;
        }
    }

    private static final ArrayList<InputMethodInfo> $$robo$$com_android_internal_inputmethod_InputMethodUtils$getDefaultEnabledImes(Context context, boolean isSystemReady, ArrayList<InputMethodInfo> imis) {
        InputMethodInfo imi;
        int i;
        Locale fallbackLocale = InputMethodUtils.getFallbackLocaleForDefaultIme(imis, context);
        if (!isSystemReady) {
            ArrayList<InputMethodInfo> retval = new ArrayList<InputMethodInfo>();
            for (int i2 = 0; i2 < imis.size(); ++i2) {
                InputMethodInfo imi2 = imis.get(i2);
                if (!InputMethodUtils.isSystemIme(imi2) || !imi2.isDefault(context) || !InputMethodUtils.isImeThatHasSubtypeOf(imi2, fallbackLocale, false, "keyboard")) continue;
                retval.add(imi2);
            }
            return retval;
        }
        Locale systemLocale = InputMethodUtils.getSystemLocaleFromContext(context);
        ArrayList<InputMethodInfo> retval = new ArrayList<InputMethodInfo>();
        boolean systemLocaleKeyboardImeFound = false;
        for (i = 0; i < imis.size(); ++i) {
            imi = imis.get(i);
            if (!InputMethodUtils.isSystemIme(imi) || !imi.isDefault(context)) continue;
            boolean isSystemLocaleKeyboardIme = InputMethodUtils.isImeThatHasSubtypeOf(imi, systemLocale, false, "keyboard");
            if (isSystemLocaleKeyboardIme || InputMethodUtils.isImeThatHasSubtypeOf(imi, fallbackLocale, false, SUBTYPE_MODE_ANY)) {
                retval.add(imi);
            }
            systemLocaleKeyboardImeFound |= isSystemLocaleKeyboardIme;
        }
        if (!systemLocaleKeyboardImeFound) {
            for (i = 0; i < imis.size(); ++i) {
                imi = imis.get(i);
                if (!InputMethodUtils.isSystemIme(imi) || !imi.isDefault(context) || InputMethodUtils.isImeThatHasSubtypeOf(imi, fallbackLocale, false, "keyboard") || !InputMethodUtils.isImeThatHasSubtypeOf(imi, systemLocale, true, SUBTYPE_MODE_ANY)) continue;
                retval.add(imi);
            }
        }
        for (i = 0; i < retval.size(); ++i) {
            if (!((InputMethodInfo)retval.get(i)).isAuxiliaryIme()) continue;
            return retval;
        }
        for (i = 0; i < imis.size(); ++i) {
            imi = imis.get(i);
            if (!InputMethodUtils.isSystemAuxilialyImeThatHasAutomaticSubtype(imi)) continue;
            retval.add(imi);
        }
        return retval;
    }

    private static final boolean $$robo$$com_android_internal_inputmethod_InputMethodUtils$isImeThatHasSubtypeOf(InputMethodInfo imi, Locale locale, boolean ignoreCountry, String mode) {
        if (locale == null) {
            return false;
        }
        return InputMethodUtils.containsSubtypeOf(imi, locale, ignoreCountry, mode);
    }

    @Deprecated
    private static final boolean $$robo$$com_android_internal_inputmethod_InputMethodUtils$isValidSystemDefaultIme(boolean isSystemReady, InputMethodInfo imi, Context context) {
        if (!isSystemReady) {
            return false;
        }
        if (!InputMethodUtils.isSystemIme(imi)) {
            return false;
        }
        if (imi.getIsDefaultResourceId() != 0) {
            try {
                if (imi.isDefault(context) && InputMethodUtils.containsSubtypeOf(imi, context.getResources().getConfiguration().locale.getLanguage(), SUBTYPE_MODE_ANY)) {
                    return true;
                }
            }
            catch (Resources.NotFoundException notFoundException) {
                // empty catch block
            }
        }
        if (imi.getSubtypeCount() == 0) {
            Slog.w("InputMethodUtils", "Found no subtypes in a system IME: " + imi.getPackageName());
        }
        return false;
    }

    private static final boolean $$robo$$com_android_internal_inputmethod_InputMethodUtils$containsSubtypeOf(InputMethodInfo imi, Locale locale, boolean ignoreCountry, String mode) {
        int N = imi.getSubtypeCount();
        for (int i = 0; i < N; ++i) {
            Locale subtypeLocale;
            InputMethodSubtype subtype = imi.getSubtypeAt(i);
            if (!ignoreCountry ? !TextUtils.equals(subtype.getLocale(), locale.toString()) : !(subtypeLocale = new Locale(InputMethodUtils.getLanguageFromLocaleString(subtype.getLocale()))).getLanguage().equals(locale.getLanguage())) continue;
            if (mode != SUBTYPE_MODE_ANY && !TextUtils.isEmpty(mode) && !mode.equalsIgnoreCase(subtype.getMode())) continue;
            return true;
        }
        return false;
    }

    @Deprecated
    private static final boolean $$robo$$com_android_internal_inputmethod_InputMethodUtils$containsSubtypeOf(InputMethodInfo imi, String language, String mode) {
        int N = imi.getSubtypeCount();
        for (int i = 0; i < N; ++i) {
            InputMethodSubtype subtype = imi.getSubtypeAt(i);
            if (!subtype.getLocale().startsWith(language) || mode != SUBTYPE_MODE_ANY && !TextUtils.isEmpty(mode) && !mode.equalsIgnoreCase(subtype.getMode())) continue;
            return true;
        }
        return false;
    }

    private static final ArrayList<InputMethodSubtype> $$robo$$com_android_internal_inputmethod_InputMethodUtils$getSubtypes(InputMethodInfo imi) {
        ArrayList<InputMethodSubtype> subtypes = new ArrayList<InputMethodSubtype>();
        int subtypeCount = imi.getSubtypeCount();
        for (int i = 0; i < subtypeCount; ++i) {
            subtypes.add(imi.getSubtypeAt(i));
        }
        return subtypes;
    }

    private static final ArrayList<InputMethodSubtype> $$robo$$com_android_internal_inputmethod_InputMethodUtils$getOverridingImplicitlyEnabledSubtypes(InputMethodInfo imi, String mode) {
        ArrayList<InputMethodSubtype> subtypes = new ArrayList<InputMethodSubtype>();
        int subtypeCount = imi.getSubtypeCount();
        for (int i = 0; i < subtypeCount; ++i) {
            InputMethodSubtype subtype = imi.getSubtypeAt(i);
            if (!subtype.overridesImplicitlyEnabledSubtype() || !subtype.getMode().equals(mode)) continue;
            subtypes.add(subtype);
        }
        return subtypes;
    }

    private static final InputMethodInfo $$robo$$com_android_internal_inputmethod_InputMethodUtils$getMostApplicableDefaultIME(List<InputMethodInfo> enabledImes) {
        if (enabledImes == null || enabledImes.isEmpty()) {
            return null;
        }
        int i = enabledImes.size();
        int firstFoundSystemIme = -1;
        while (i > 0) {
            InputMethodInfo imi;
            if (InputMethodUtils.isSystemImeThatHasEnglishKeyboardSubtype(imi = enabledImes.get(--i)) && !imi.isAuxiliaryIme()) {
                return imi;
            }
            if (firstFoundSystemIme >= 0 || !InputMethodUtils.isSystemIme(imi) || imi.isAuxiliaryIme()) continue;
            firstFoundSystemIme = i;
        }
        return enabledImes.get(Math.max(firstFoundSystemIme, 0));
    }

    private static final boolean $$robo$$com_android_internal_inputmethod_InputMethodUtils$isValidSubtypeId(InputMethodInfo imi, int subtypeHashCode) {
        return InputMethodUtils.getSubtypeIdFromHashCode(imi, subtypeHashCode) != -1;
    }

    private static final int $$robo$$com_android_internal_inputmethod_InputMethodUtils$getSubtypeIdFromHashCode(InputMethodInfo imi, int subtypeHashCode) {
        if (imi != null) {
            int subtypeCount = imi.getSubtypeCount();
            for (int i = 0; i < subtypeCount; ++i) {
                InputMethodSubtype ims = imi.getSubtypeAt(i);
                if (subtypeHashCode != ims.hashCode()) continue;
                return i;
            }
        }
        return -1;
    }

    private static final ArrayList<InputMethodSubtype> $$robo$$com_android_internal_inputmethod_InputMethodUtils$getImplicitlyApplicableSubtypesLocked(Resources res, InputMethodInfo imi) {
        InputMethodSubtype lastResortKeyboardSubtype;
        InputMethodSubtype subtype;
        int i;
        ArrayList<InputMethodSubtype> subtypes = InputMethodUtils.getSubtypes(imi);
        String systemLocale = res.getConfiguration().locale.toString();
        if (TextUtils.isEmpty(systemLocale)) {
            return new ArrayList<InputMethodSubtype>();
        }
        String systemLanguage = res.getConfiguration().locale.getLanguage();
        HashMap<String, InputMethodSubtype> applicableModeAndSubtypesMap = new HashMap<String, InputMethodSubtype>();
        int N = subtypes.size();
        for (i = 0; i < N; ++i) {
            String mode;
            subtype = (InputMethodSubtype)subtypes.get(i);
            if (!subtype.overridesImplicitlyEnabledSubtype() || applicableModeAndSubtypesMap.containsKey(mode = subtype.getMode())) continue;
            applicableModeAndSubtypesMap.put(mode, subtype);
        }
        if (applicableModeAndSubtypesMap.size() > 0) {
            return new ArrayList<InputMethodSubtype>(applicableModeAndSubtypesMap.values());
        }
        for (i = 0; i < N; ++i) {
            InputMethodSubtype applicableSubtype;
            subtype = (InputMethodSubtype)subtypes.get(i);
            String locale = subtype.getLocale();
            String mode = subtype.getMode();
            String language = InputMethodUtils.getLanguageFromLocaleString(locale);
            if (!language.equals(systemLanguage) || !systemLocale.startsWith(locale) || (applicableSubtype = (InputMethodSubtype)applicableModeAndSubtypesMap.get(mode)) != null && (systemLocale.equals(applicableSubtype.getLocale()) || !systemLocale.equals(locale))) continue;
            applicableModeAndSubtypesMap.put(mode, subtype);
        }
        InputMethodSubtype keyboardSubtype = (InputMethodSubtype)applicableModeAndSubtypesMap.get("keyboard");
        ArrayList<InputMethodSubtype> applicableSubtypes = new ArrayList<InputMethodSubtype>(applicableModeAndSubtypesMap.values());
        if (keyboardSubtype != null && !keyboardSubtype.containsExtraValueKey("AsciiCapable")) {
            for (int i2 = 0; i2 < N; ++i2) {
                InputMethodSubtype subtype2 = (InputMethodSubtype)subtypes.get(i2);
                String mode = subtype2.getMode();
                if (!"keyboard".equals(mode) || !subtype2.containsExtraValueKey("EnabledWhenDefaultIsNotAsciiCapable")) continue;
                applicableSubtypes.add(subtype2);
            }
        }
        if (keyboardSubtype == null && (lastResortKeyboardSubtype = InputMethodUtils.findLastResortApplicableSubtypeLocked(res, subtypes, "keyboard", systemLocale, true)) != null) {
            applicableSubtypes.add(lastResortKeyboardSubtype);
        }
        return applicableSubtypes;
    }

    private static final List<InputMethodSubtype> $$robo$$com_android_internal_inputmethod_InputMethodUtils$getEnabledInputMethodSubtypeList(Context context, InputMethodInfo imi, List<InputMethodSubtype> enabledSubtypes, boolean allowsImplicitlySelectedSubtypes) {
        if (allowsImplicitlySelectedSubtypes && enabledSubtypes.isEmpty()) {
            enabledSubtypes = InputMethodUtils.getImplicitlyApplicableSubtypesLocked(context.getResources(), imi);
        }
        return InputMethodSubtype.sort(context, 0, imi, enabledSubtypes);
    }

    private static final String $$robo$$com_android_internal_inputmethod_InputMethodUtils$getLanguageFromLocaleString(String locale) {
        int idx = locale.indexOf(95);
        if (idx < 0) {
            return locale;
        }
        return locale.substring(0, idx);
    }

    private static final InputMethodSubtype $$robo$$com_android_internal_inputmethod_InputMethodUtils$findLastResortApplicableSubtypeLocked(Resources res, List<InputMethodSubtype> subtypes, String mode, String locale, boolean canIgnoreLocaleAsLastResort) {
        if (subtypes == null || subtypes.size() == 0) {
            return null;
        }
        if (TextUtils.isEmpty(locale)) {
            locale = res.getConfiguration().locale.toString();
        }
        String language = InputMethodUtils.getLanguageFromLocaleString(locale);
        boolean partialMatchFound = false;
        InputMethodSubtype applicableSubtype = null;
        InputMethodSubtype firstMatchedModeSubtype = null;
        int N = subtypes.size();
        for (int i = 0; i < N; ++i) {
            InputMethodSubtype subtype = subtypes.get(i);
            String subtypeLocale = subtype.getLocale();
            String subtypeLanguage = InputMethodUtils.getLanguageFromLocaleString(subtypeLocale);
            if (mode != null && !subtypes.get(i).getMode().equalsIgnoreCase(mode)) continue;
            if (firstMatchedModeSubtype == null) {
                firstMatchedModeSubtype = subtype;
            }
            if (locale.equals(subtypeLocale)) {
                applicableSubtype = subtype;
                break;
            }
            if (partialMatchFound || !language.equals(subtypeLanguage)) continue;
            applicableSubtype = subtype;
            partialMatchFound = true;
        }
        if (applicableSubtype == null && canIgnoreLocaleAsLastResort) {
            return firstMatchedModeSubtype;
        }
        return applicableSubtype;
    }

    private static final boolean $$robo$$com_android_internal_inputmethod_InputMethodUtils$canAddToLastInputMethod(InputMethodSubtype subtype) {
        if (subtype == null) {
            return true;
        }
        return !subtype.isAuxiliary();
    }

    private static final void $$robo$$com_android_internal_inputmethod_InputMethodUtils$setNonSelectedSystemImesDisabledUntilUsed(PackageManager packageManager, List<InputMethodInfo> enabledImis) {
        String[] systemImesDisabledUntilUsed = Resources.getSystem().getStringArray(17236016);
        if (systemImesDisabledUntilUsed == null || systemImesDisabledUntilUsed.length == 0) {
            return;
        }
        SpellCheckerInfo currentSpellChecker = TextServicesManager.getInstance().getCurrentSpellChecker();
        for (String packageName : systemImesDisabledUntilUsed) {
            boolean isSystemPackage;
            boolean enabledIme = false;
            for (int j = 0; j < enabledImis.size(); ++j) {
                InputMethodInfo imi = enabledImis.get(j);
                if (!packageName.equals(imi.getPackageName())) continue;
                enabledIme = true;
                break;
            }
            if (enabledIme || currentSpellChecker != null && packageName.equals(currentSpellChecker.getPackageName())) continue;
            ApplicationInfo ai = null;
            try {
                ai = packageManager.getApplicationInfo(packageName, 32768);
            }
            catch (PackageManager.NameNotFoundException e) {
                Slog.w("InputMethodUtils", "NameNotFoundException: " + packageName, e);
            }
            if (ai == null) continue;
            boolean bl = isSystemPackage = (ai.flags & 1) != 0;
            if (!isSystemPackage) continue;
            InputMethodUtils.setDisabledUntilUsed(packageManager, packageName);
        }
    }

    private static final void $$robo$$com_android_internal_inputmethod_InputMethodUtils$setDisabledUntilUsed(PackageManager packageManager, String packageName) {
        int state = packageManager.getApplicationEnabledSetting(packageName);
        if (state == 0 || state == 1) {
            packageManager.setApplicationEnabledSetting(packageName, 4, 0);
        }
    }

    private static final CharSequence $$robo$$com_android_internal_inputmethod_InputMethodUtils$getImeAndSubtypeDisplayName(Context context, InputMethodInfo imi, InputMethodSubtype subtype) {
        CharSequence imiLabel = imi.loadLabel(context.getPackageManager());
        return subtype != null ? TextUtils.concat(subtype.getDisplayName(context, imi.getPackageName(), imi.getServiceInfo().applicationInfo), TextUtils.isEmpty(imiLabel) ? "" : " - " + imiLabel) : imiLabel;
    }

    private static final boolean $$robo$$com_android_internal_inputmethod_InputMethodUtils$checkIfPackageBelongsToUid(AppOpsManager appOpsManager, int uid, String packageName) {
        try {
            appOpsManager.checkPackage(uid, packageName);
            return true;
        }
        catch (SecurityException e) {
            return false;
        }
    }

    static void __staticInitializer__() {
        SUBTYPE_MODE_ANY = null;
        ENGLISH_LOCALE = new Locale("en");
        NOT_A_SUBTYPE_ID_STR = String.valueOf(-1);
        SEARCH_ORDER_OF_FALLBACK_LOCALES = new Locale[]{Locale.ENGLISH, Locale.US, Locale.UK};
    }

    private void __constructor__() {
        this.$$robo$$com_android_internal_inputmethod_InputMethodUtils$__constructor__();
    }

    private InputMethodUtils() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_inputmethod_InputMethodUtils$__constructor__(), 0, this);
    }

    public static String getStackTrace() {
        return InvokeDynamicSupport.bootstrapStatic("getStackTrace", $$robo$$com_android_internal_inputmethod_InputMethodUtils$getStackTrace(), 0);
    }

    public static String getApiCallStack() {
        return InvokeDynamicSupport.bootstrapStatic("getApiCallStack", $$robo$$com_android_internal_inputmethod_InputMethodUtils$getApiCallStack(), 0);
    }

    public static boolean isSystemIme(InputMethodInfo inputMethodInfo) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isSystemIme", $$robo$$com_android_internal_inputmethod_InputMethodUtils$isSystemIme(android.view.inputmethod.InputMethodInfo ), 0, (InputMethodInfo)inputMethodInfo);
    }

    @Deprecated
    public static boolean isSystemImeThatHasEnglishKeyboardSubtype(InputMethodInfo inputMethodInfo) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isSystemImeThatHasEnglishKeyboardSubtype", $$robo$$com_android_internal_inputmethod_InputMethodUtils$isSystemImeThatHasEnglishKeyboardSubtype(android.view.inputmethod.InputMethodInfo ), 0, (InputMethodInfo)inputMethodInfo);
    }

    public static Locale getFallbackLocaleForDefaultIme(ArrayList<InputMethodInfo> arrayList, Context context) {
        return InvokeDynamicSupport.bootstrapStatic("getFallbackLocaleForDefaultIme", $$robo$$com_android_internal_inputmethod_InputMethodUtils$getFallbackLocaleForDefaultIme(java.util.ArrayList<android.view.inputmethod.InputMethodInfo> android.content.Context ), 0, arrayList, (Context)context);
    }

    private static boolean isSystemAuxilialyImeThatHasAutomaticSubtype(InputMethodInfo inputMethodInfo) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isSystemAuxilialyImeThatHasAutomaticSubtype", $$robo$$com_android_internal_inputmethod_InputMethodUtils$isSystemAuxilialyImeThatHasAutomaticSubtype(android.view.inputmethod.InputMethodInfo ), 0, (InputMethodInfo)inputMethodInfo);
    }

    public static Locale getSystemLocaleFromContext(Context context) {
        return InvokeDynamicSupport.bootstrapStatic("getSystemLocaleFromContext", $$robo$$com_android_internal_inputmethod_InputMethodUtils$getSystemLocaleFromContext(android.content.Context ), 0, (Context)context);
    }

    public static ArrayList<InputMethodInfo> getDefaultEnabledImes(Context context, boolean bl, ArrayList<InputMethodInfo> arrayList) {
        return InvokeDynamicSupport.bootstrapStatic("getDefaultEnabledImes", $$robo$$com_android_internal_inputmethod_InputMethodUtils$getDefaultEnabledImes(android.content.Context boolean java.util.ArrayList<android.view.inputmethod.InputMethodInfo> ), 0, (Context)context, (boolean)bl, arrayList);
    }

    public static boolean isImeThatHasSubtypeOf(InputMethodInfo inputMethodInfo, Locale locale, boolean bl, String string2) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isImeThatHasSubtypeOf", $$robo$$com_android_internal_inputmethod_InputMethodUtils$isImeThatHasSubtypeOf(android.view.inputmethod.InputMethodInfo java.util.Locale boolean java.lang.String ), 0, (InputMethodInfo)inputMethodInfo, (Locale)locale, (boolean)bl, (String)string2);
    }

    @Deprecated
    public static boolean isValidSystemDefaultIme(boolean bl, InputMethodInfo inputMethodInfo, Context context) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isValidSystemDefaultIme", $$robo$$com_android_internal_inputmethod_InputMethodUtils$isValidSystemDefaultIme(boolean android.view.inputmethod.InputMethodInfo android.content.Context ), 0, (boolean)bl, (InputMethodInfo)inputMethodInfo, (Context)context);
    }

    public static boolean containsSubtypeOf(InputMethodInfo inputMethodInfo, Locale locale, boolean bl, String string2) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("containsSubtypeOf", $$robo$$com_android_internal_inputmethod_InputMethodUtils$containsSubtypeOf(android.view.inputmethod.InputMethodInfo java.util.Locale boolean java.lang.String ), 0, (InputMethodInfo)inputMethodInfo, (Locale)locale, (boolean)bl, (String)string2);
    }

    @Deprecated
    public static boolean containsSubtypeOf(InputMethodInfo inputMethodInfo, String string2, String string3) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("containsSubtypeOf", $$robo$$com_android_internal_inputmethod_InputMethodUtils$containsSubtypeOf(android.view.inputmethod.InputMethodInfo java.lang.String java.lang.String ), 0, (InputMethodInfo)inputMethodInfo, (String)string2, (String)string3);
    }

    public static ArrayList<InputMethodSubtype> getSubtypes(InputMethodInfo inputMethodInfo) {
        return InvokeDynamicSupport.bootstrapStatic("getSubtypes", $$robo$$com_android_internal_inputmethod_InputMethodUtils$getSubtypes(android.view.inputmethod.InputMethodInfo ), 0, (InputMethodInfo)inputMethodInfo);
    }

    public static ArrayList<InputMethodSubtype> getOverridingImplicitlyEnabledSubtypes(InputMethodInfo inputMethodInfo, String string2) {
        return InvokeDynamicSupport.bootstrapStatic("getOverridingImplicitlyEnabledSubtypes", $$robo$$com_android_internal_inputmethod_InputMethodUtils$getOverridingImplicitlyEnabledSubtypes(android.view.inputmethod.InputMethodInfo java.lang.String ), 0, (InputMethodInfo)inputMethodInfo, (String)string2);
    }

    public static InputMethodInfo getMostApplicableDefaultIME(List<InputMethodInfo> list) {
        return InvokeDynamicSupport.bootstrapStatic("getMostApplicableDefaultIME", $$robo$$com_android_internal_inputmethod_InputMethodUtils$getMostApplicableDefaultIME(java.util.List<android.view.inputmethod.InputMethodInfo> ), 0, list);
    }

    public static boolean isValidSubtypeId(InputMethodInfo inputMethodInfo, int n) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isValidSubtypeId", $$robo$$com_android_internal_inputmethod_InputMethodUtils$isValidSubtypeId(android.view.inputmethod.InputMethodInfo int ), 0, (InputMethodInfo)inputMethodInfo, (int)n);
    }

    public static int getSubtypeIdFromHashCode(InputMethodInfo inputMethodInfo, int n) {
        return (int)InvokeDynamicSupport.bootstrapStatic("getSubtypeIdFromHashCode", $$robo$$com_android_internal_inputmethod_InputMethodUtils$getSubtypeIdFromHashCode(android.view.inputmethod.InputMethodInfo int ), 0, (InputMethodInfo)inputMethodInfo, (int)n);
    }

    private static ArrayList<InputMethodSubtype> getImplicitlyApplicableSubtypesLocked(Resources resources, InputMethodInfo inputMethodInfo) {
        return InvokeDynamicSupport.bootstrapStatic("getImplicitlyApplicableSubtypesLocked", $$robo$$com_android_internal_inputmethod_InputMethodUtils$getImplicitlyApplicableSubtypesLocked(android.content.res.Resources android.view.inputmethod.InputMethodInfo ), 0, (Resources)resources, (InputMethodInfo)inputMethodInfo);
    }

    private static List<InputMethodSubtype> getEnabledInputMethodSubtypeList(Context context, InputMethodInfo inputMethodInfo, List<InputMethodSubtype> list, boolean bl) {
        return InvokeDynamicSupport.bootstrapStatic("getEnabledInputMethodSubtypeList", $$robo$$com_android_internal_inputmethod_InputMethodUtils$getEnabledInputMethodSubtypeList(android.content.Context android.view.inputmethod.InputMethodInfo java.util.List<android.view.inputmethod.InputMethodSubtype> boolean ), 0, (Context)context, (InputMethodInfo)inputMethodInfo, list, (boolean)bl);
    }

    public static String getLanguageFromLocaleString(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("getLanguageFromLocaleString", $$robo$$com_android_internal_inputmethod_InputMethodUtils$getLanguageFromLocaleString(java.lang.String ), 0, (String)string2);
    }

    public static InputMethodSubtype findLastResortApplicableSubtypeLocked(Resources resources, List<InputMethodSubtype> list, String string2, String string3, boolean bl) {
        return InvokeDynamicSupport.bootstrapStatic("findLastResortApplicableSubtypeLocked", $$robo$$com_android_internal_inputmethod_InputMethodUtils$findLastResortApplicableSubtypeLocked(android.content.res.Resources java.util.List<android.view.inputmethod.InputMethodSubtype> java.lang.String java.lang.String boolean ), 0, (Resources)resources, list, (String)string2, (String)string3, (boolean)bl);
    }

    public static boolean canAddToLastInputMethod(InputMethodSubtype inputMethodSubtype) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("canAddToLastInputMethod", $$robo$$com_android_internal_inputmethod_InputMethodUtils$canAddToLastInputMethod(android.view.inputmethod.InputMethodSubtype ), 0, (InputMethodSubtype)inputMethodSubtype);
    }

    public static void setNonSelectedSystemImesDisabledUntilUsed(PackageManager packageManager, List<InputMethodInfo> list) {
        InvokeDynamicSupport.bootstrapStatic("setNonSelectedSystemImesDisabledUntilUsed", $$robo$$com_android_internal_inputmethod_InputMethodUtils$setNonSelectedSystemImesDisabledUntilUsed(android.content.pm.PackageManager java.util.List<android.view.inputmethod.InputMethodInfo> ), 0, (PackageManager)packageManager, list);
    }

    private static void setDisabledUntilUsed(PackageManager packageManager, String string2) {
        InvokeDynamicSupport.bootstrapStatic("setDisabledUntilUsed", $$robo$$com_android_internal_inputmethod_InputMethodUtils$setDisabledUntilUsed(android.content.pm.PackageManager java.lang.String ), 0, (PackageManager)packageManager, (String)string2);
    }

    public static CharSequence getImeAndSubtypeDisplayName(Context context, InputMethodInfo inputMethodInfo, InputMethodSubtype inputMethodSubtype) {
        return InvokeDynamicSupport.bootstrapStatic("getImeAndSubtypeDisplayName", $$robo$$com_android_internal_inputmethod_InputMethodUtils$getImeAndSubtypeDisplayName(android.content.Context android.view.inputmethod.InputMethodInfo android.view.inputmethod.InputMethodSubtype ), 0, (Context)context, (InputMethodInfo)inputMethodInfo, (InputMethodSubtype)inputMethodSubtype);
    }

    public static boolean checkIfPackageBelongsToUid(AppOpsManager appOpsManager, int n, String string2) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("checkIfPackageBelongsToUid", $$robo$$com_android_internal_inputmethod_InputMethodUtils$checkIfPackageBelongsToUid(android.app.AppOpsManager int java.lang.String ), 0, (AppOpsManager)appOpsManager, (int)n, (String)string2);
    }

    static {
        RobolectricInternals.classInitializing(InputMethodUtils.class);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (InputMethodUtils)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static class InputMethodSettings
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private static char INPUT_METHOD_SEPARATER = ':';
        private static char INPUT_METHOD_SUBTYPE_SEPARATER = ';';
        private TextUtils.SimpleStringSplitter mInputMethodSplitter;
        private TextUtils.SimpleStringSplitter mSubtypeSplitter;
        private Resources mRes;
        private ContentResolver mResolver;
        private HashMap<String, InputMethodInfo> mMethodMap;
        private ArrayList<InputMethodInfo> mMethodList;
        private String mEnabledInputMethodsStrCache;
        private int mCurrentUserId;
        private int[] mCurrentProfileIds;

        private static final void $$robo$$com_android_internal_inputmethod_InputMethodUtils_InputMethodSettings$buildEnabledInputMethodsSettingString(StringBuilder builder, Pair<String, ArrayList<String>> pair) {
            String id2 = (String)pair.first;
            ArrayList subtypes = (ArrayList)pair.second;
            builder.append(id2);
            for (String subtypeId : subtypes) {
                builder.append(';').append(subtypeId);
            }
        }

        private void $$robo$$com_android_internal_inputmethod_InputMethodUtils_InputMethodSettings$__constructor__(Resources res, ContentResolver resolver, HashMap<String, InputMethodInfo> methodMap, ArrayList<InputMethodInfo> methodList, int userId) {
            this.mInputMethodSplitter = new TextUtils.SimpleStringSplitter(':');
            this.mSubtypeSplitter = new TextUtils.SimpleStringSplitter(';');
            this.mCurrentProfileIds = new int[0];
            this.setCurrentUserId(userId);
            this.mRes = res;
            this.mResolver = resolver;
            this.mMethodMap = methodMap;
            this.mMethodList = methodList;
        }

        private final void $$robo$$com_android_internal_inputmethod_InputMethodUtils_InputMethodSettings$setCurrentUserId(int userId) {
            this.mCurrentUserId = userId;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$com_android_internal_inputmethod_InputMethodUtils_InputMethodSettings$setCurrentProfileIds(int[] currentProfileIds) {
            InputMethodSettings inputMethodSettings = this;
            synchronized (inputMethodSettings) {
                this.mCurrentProfileIds = currentProfileIds;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final boolean $$robo$$com_android_internal_inputmethod_InputMethodUtils_InputMethodSettings$isCurrentProfile(int userId) {
            InputMethodSettings inputMethodSettings = this;
            synchronized (inputMethodSettings) {
                if (userId == this.mCurrentUserId) {
                    return true;
                }
                for (int i = 0; i < this.mCurrentProfileIds.length; ++i) {
                    if (userId != this.mCurrentProfileIds[i]) continue;
                    return true;
                }
                return false;
            }
        }

        private final List<InputMethodInfo> $$robo$$com_android_internal_inputmethod_InputMethodUtils_InputMethodSettings$getEnabledInputMethodListLocked() {
            return this.createEnabledInputMethodListLocked(this.getEnabledInputMethodsAndSubtypeListLocked());
        }

        private final List<Pair<InputMethodInfo, ArrayList<String>>> $$robo$$com_android_internal_inputmethod_InputMethodUtils_InputMethodSettings$getEnabledInputMethodAndSubtypeHashCodeListLocked() {
            return this.createEnabledInputMethodAndSubtypeHashCodeListLocked(this.getEnabledInputMethodsAndSubtypeListLocked());
        }

        private final List<InputMethodSubtype> $$robo$$com_android_internal_inputmethod_InputMethodUtils_InputMethodSettings$getEnabledInputMethodSubtypeListLocked(Context context, InputMethodInfo imi, boolean allowsImplicitlySelectedSubtypes) {
            ArrayList enabledSubtypes = this.getEnabledInputMethodSubtypeListLocked(imi);
            if (allowsImplicitlySelectedSubtypes && enabledSubtypes.isEmpty()) {
                enabledSubtypes = InputMethodUtils.getImplicitlyApplicableSubtypesLocked(context.getResources(), imi);
            }
            return InputMethodSubtype.sort(context, 0, imi, enabledSubtypes);
        }

        private final List<InputMethodSubtype> $$robo$$com_android_internal_inputmethod_InputMethodUtils_InputMethodSettings$getEnabledInputMethodSubtypeListLocked(InputMethodInfo imi) {
            List<Pair<String, ArrayList<String>>> imsList = this.getEnabledInputMethodsAndSubtypeListLocked();
            ArrayList<InputMethodSubtype> enabledSubtypes = new ArrayList<InputMethodSubtype>();
            if (imi != null) {
                for (Pair<String, ArrayList<String>> imsPair : imsList) {
                    InputMethodInfo info = this.mMethodMap.get(imsPair.first);
                    if (info == null || !info.getId().equals(imi.getId())) continue;
                    int subtypeCount = info.getSubtypeCount();
                    for (int i = 0; i < subtypeCount; ++i) {
                        InputMethodSubtype ims = info.getSubtypeAt(i);
                        for (String s : (ArrayList)imsPair.second) {
                            if (!String.valueOf(ims.hashCode()).equals(s)) continue;
                            enabledSubtypes.add(ims);
                        }
                    }
                }
            }
            return enabledSubtypes;
        }

        private final void $$robo$$com_android_internal_inputmethod_InputMethodUtils_InputMethodSettings$enableAllIMEsIfThereIsNoEnabledIME() {
            if (TextUtils.isEmpty(this.getEnabledInputMethodsStr())) {
                StringBuilder sb = new StringBuilder();
                int N = this.mMethodList.size();
                for (int i = 0; i < N; ++i) {
                    InputMethodInfo imi = this.mMethodList.get(i);
                    Slog.i("InputMethodUtils", "Adding: " + imi.getId());
                    if (i > 0) {
                        sb.append(':');
                    }
                    sb.append(imi.getId());
                }
                this.putEnabledInputMethodsStr(sb.toString());
            }
        }

        private final List<Pair<String, ArrayList<String>>> $$robo$$com_android_internal_inputmethod_InputMethodUtils_InputMethodSettings$getEnabledInputMethodsAndSubtypeListLocked() {
            ArrayList<Pair<String, ArrayList<String>>> imsList = new ArrayList<Pair<String, ArrayList<String>>>();
            String enabledInputMethodsStr = this.getEnabledInputMethodsStr();
            if (TextUtils.isEmpty(enabledInputMethodsStr)) {
                return imsList;
            }
            this.mInputMethodSplitter.setString(enabledInputMethodsStr);
            while (this.mInputMethodSplitter.hasNext()) {
                Object nextImsStr = this.mInputMethodSplitter.next();
                this.mSubtypeSplitter.setString((String)nextImsStr);
                if (!this.mSubtypeSplitter.hasNext()) continue;
                ArrayList<Object> subtypeHashes = new ArrayList<Object>();
                Object imeId = this.mSubtypeSplitter.next();
                while (this.mSubtypeSplitter.hasNext()) {
                    subtypeHashes.add(this.mSubtypeSplitter.next());
                }
                imsList.add(new Pair(imeId, subtypeHashes));
            }
            return imsList;
        }

        private final void $$robo$$com_android_internal_inputmethod_InputMethodUtils_InputMethodSettings$appendAndPutEnabledInputMethodLocked(String id2, boolean reloadInputMethodStr) {
            if (reloadInputMethodStr) {
                this.getEnabledInputMethodsStr();
            }
            if (TextUtils.isEmpty(this.mEnabledInputMethodsStrCache)) {
                this.putEnabledInputMethodsStr(id2);
            } else {
                this.putEnabledInputMethodsStr(this.mEnabledInputMethodsStrCache + ':' + id2);
            }
        }

        private final boolean $$robo$$com_android_internal_inputmethod_InputMethodUtils_InputMethodSettings$buildAndPutEnabledInputMethodsStrRemovingIdLocked(StringBuilder builder, List<Pair<String, ArrayList<String>>> imsList, String id2) {
            boolean isRemoved = false;
            boolean needsAppendSeparator = false;
            for (Pair<String, ArrayList<String>> ims : imsList) {
                String curId = (String)ims.first;
                if (curId.equals(id2)) {
                    isRemoved = true;
                    continue;
                }
                if (needsAppendSeparator) {
                    builder.append(':');
                } else {
                    needsAppendSeparator = true;
                }
                InputMethodSettings.buildEnabledInputMethodsSettingString(builder, ims);
            }
            if (isRemoved) {
                this.putEnabledInputMethodsStr(builder.toString());
            }
            return isRemoved;
        }

        private final List<InputMethodInfo> $$robo$$com_android_internal_inputmethod_InputMethodUtils_InputMethodSettings$createEnabledInputMethodListLocked(List<Pair<String, ArrayList<String>>> imsList) {
            ArrayList<InputMethodInfo> res = new ArrayList<InputMethodInfo>();
            for (Pair<String, ArrayList<String>> ims : imsList) {
                InputMethodInfo info = this.mMethodMap.get(ims.first);
                if (info == null) continue;
                res.add(info);
            }
            return res;
        }

        private final List<Pair<InputMethodInfo, ArrayList<String>>> $$robo$$com_android_internal_inputmethod_InputMethodUtils_InputMethodSettings$createEnabledInputMethodAndSubtypeHashCodeListLocked(List<Pair<String, ArrayList<String>>> imsList) {
            ArrayList<Pair<InputMethodInfo, ArrayList<String>>> res = new ArrayList<Pair<InputMethodInfo, ArrayList<String>>>();
            for (Pair<String, ArrayList<String>> ims : imsList) {
                InputMethodInfo info = this.mMethodMap.get(ims.first);
                if (info == null) continue;
                res.add(new Pair(info, ims.second));
            }
            return res;
        }

        private final void $$robo$$com_android_internal_inputmethod_InputMethodUtils_InputMethodSettings$putEnabledInputMethodsStr(String str) {
            Settings.Secure.putStringForUser(this.mResolver, "enabled_input_methods", str, this.mCurrentUserId);
            this.mEnabledInputMethodsStrCache = str;
        }

        private final String $$robo$$com_android_internal_inputmethod_InputMethodUtils_InputMethodSettings$getEnabledInputMethodsStr() {
            this.mEnabledInputMethodsStrCache = Settings.Secure.getStringForUser(this.mResolver, "enabled_input_methods", this.mCurrentUserId);
            return this.mEnabledInputMethodsStrCache;
        }

        private final void $$robo$$com_android_internal_inputmethod_InputMethodUtils_InputMethodSettings$saveSubtypeHistory(List<Pair<String, String>> savedImes, String newImeId, String newSubtypeId) {
            StringBuilder builder = new StringBuilder();
            boolean isImeAdded = false;
            if (!TextUtils.isEmpty(newImeId) && !TextUtils.isEmpty(newSubtypeId)) {
                builder.append(newImeId).append(';').append(newSubtypeId);
                isImeAdded = true;
            }
            for (Pair<String, String> ime : savedImes) {
                String imeId = (String)ime.first;
                String subtypeId = (String)ime.second;
                if (TextUtils.isEmpty(subtypeId)) {
                    subtypeId = NOT_A_SUBTYPE_ID_STR;
                }
                if (isImeAdded) {
                    builder.append(':');
                } else {
                    isImeAdded = true;
                }
                builder.append(imeId).append(';').append(subtypeId);
            }
            this.putSubtypeHistoryStr(builder.toString());
        }

        private final void $$robo$$com_android_internal_inputmethod_InputMethodUtils_InputMethodSettings$addSubtypeToHistory(String imeId, String subtypeId) {
            List<Pair<String, String>> subtypeHistory = this.loadInputMethodAndSubtypeHistoryLocked();
            for (Pair<String, String> ime : subtypeHistory) {
                if (!((String)ime.first).equals(imeId)) continue;
                subtypeHistory.remove(ime);
                break;
            }
            this.saveSubtypeHistory(subtypeHistory, imeId, subtypeId);
        }

        private final void $$robo$$com_android_internal_inputmethod_InputMethodUtils_InputMethodSettings$putSubtypeHistoryStr(String str) {
            Settings.Secure.putStringForUser(this.mResolver, "input_methods_subtype_history", str, this.mCurrentUserId);
        }

        private final Pair<String, String> $$robo$$com_android_internal_inputmethod_InputMethodUtils_InputMethodSettings$getLastInputMethodAndSubtypeLocked() {
            return this.getLastSubtypeForInputMethodLockedInternal(null);
        }

        private final String $$robo$$com_android_internal_inputmethod_InputMethodUtils_InputMethodSettings$getLastSubtypeForInputMethodLocked(String imeId) {
            Pair<String, String> ime = this.getLastSubtypeForInputMethodLockedInternal(imeId);
            if (ime != null) {
                return (String)ime.second;
            }
            return null;
        }

        private final Pair<String, String> $$robo$$com_android_internal_inputmethod_InputMethodUtils_InputMethodSettings$getLastSubtypeForInputMethodLockedInternal(String imeId) {
            List<Pair<String, ArrayList<String>>> enabledImes = this.getEnabledInputMethodsAndSubtypeListLocked();
            List<Pair<String, String>> subtypeHistory = this.loadInputMethodAndSubtypeHistoryLocked();
            for (Pair<String, String> imeAndSubtype : subtypeHistory) {
                String subtypeInTheHistory;
                String subtypeHashCode;
                String imeInTheHistory = (String)imeAndSubtype.first;
                if (!TextUtils.isEmpty(imeId) && !imeInTheHistory.equals(imeId) || TextUtils.isEmpty(subtypeHashCode = this.getEnabledSubtypeHashCodeForInputMethodAndSubtypeLocked(enabledImes, imeInTheHistory, subtypeInTheHistory = (String)imeAndSubtype.second))) continue;
                return new Pair<String, String>(imeInTheHistory, subtypeHashCode);
            }
            return null;
        }

        private final String $$robo$$com_android_internal_inputmethod_InputMethodUtils_InputMethodSettings$getEnabledSubtypeHashCodeForInputMethodAndSubtypeLocked(List<Pair<String, ArrayList<String>>> enabledImes, String imeId, String subtypeHashCode) {
            for (Pair<String, ArrayList<String>> enabledIme : enabledImes) {
                if (!((String)enabledIme.first).equals(imeId)) continue;
                ArrayList explicitlyEnabledSubtypes = (ArrayList)enabledIme.second;
                InputMethodInfo imi = this.mMethodMap.get(imeId);
                if (explicitlyEnabledSubtypes.size() == 0) {
                    ArrayList implicitlySelectedSubtypes;
                    if (imi != null && imi.getSubtypeCount() > 0 && (implicitlySelectedSubtypes = InputMethodUtils.getImplicitlyApplicableSubtypesLocked(this.mRes, imi)) != null) {
                        int N = implicitlySelectedSubtypes.size();
                        for (int i = 0; i < N; ++i) {
                            InputMethodSubtype st = (InputMethodSubtype)implicitlySelectedSubtypes.get(i);
                            if (!String.valueOf(st.hashCode()).equals(subtypeHashCode)) continue;
                            return subtypeHashCode;
                        }
                    }
                } else {
                    for (String s : explicitlyEnabledSubtypes) {
                        if (!s.equals(subtypeHashCode)) continue;
                        try {
                            int hashCode = Integer.valueOf(subtypeHashCode);
                            if (InputMethodUtils.isValidSubtypeId(imi, hashCode)) {
                                return s;
                            }
                            return NOT_A_SUBTYPE_ID_STR;
                        }
                        catch (NumberFormatException e) {
                            return NOT_A_SUBTYPE_ID_STR;
                        }
                    }
                }
                return NOT_A_SUBTYPE_ID_STR;
            }
            return null;
        }

        private final List<Pair<String, String>> $$robo$$com_android_internal_inputmethod_InputMethodUtils_InputMethodSettings$loadInputMethodAndSubtypeHistoryLocked() {
            ArrayList<Pair<String, String>> imsList = new ArrayList<Pair<String, String>>();
            String subtypeHistoryStr = this.getSubtypeHistoryStr();
            if (TextUtils.isEmpty(subtypeHistoryStr)) {
                return imsList;
            }
            this.mInputMethodSplitter.setString(subtypeHistoryStr);
            while (this.mInputMethodSplitter.hasNext()) {
                Object nextImsStr = this.mInputMethodSplitter.next();
                this.mSubtypeSplitter.setString((String)nextImsStr);
                if (!this.mSubtypeSplitter.hasNext()) continue;
                Object subtypeId = NOT_A_SUBTYPE_ID_STR;
                Object imeId = this.mSubtypeSplitter.next();
                if (this.mSubtypeSplitter.hasNext()) {
                    subtypeId = this.mSubtypeSplitter.next();
                }
                imsList.add(new Pair<Object, Object>(imeId, subtypeId));
            }
            return imsList;
        }

        private final String $$robo$$com_android_internal_inputmethod_InputMethodUtils_InputMethodSettings$getSubtypeHistoryStr() {
            return Settings.Secure.getStringForUser(this.mResolver, "input_methods_subtype_history", this.mCurrentUserId);
        }

        private final void $$robo$$com_android_internal_inputmethod_InputMethodUtils_InputMethodSettings$putSelectedInputMethod(String imeId) {
            Settings.Secure.putStringForUser(this.mResolver, "default_input_method", imeId, this.mCurrentUserId);
        }

        private final void $$robo$$com_android_internal_inputmethod_InputMethodUtils_InputMethodSettings$putSelectedSubtype(int subtypeId) {
            Settings.Secure.putIntForUser(this.mResolver, "selected_input_method_subtype", subtypeId, this.mCurrentUserId);
        }

        private final String $$robo$$com_android_internal_inputmethod_InputMethodUtils_InputMethodSettings$getDisabledSystemInputMethods() {
            return Settings.Secure.getStringForUser(this.mResolver, "disabled_system_input_methods", this.mCurrentUserId);
        }

        private final String $$robo$$com_android_internal_inputmethod_InputMethodUtils_InputMethodSettings$getSelectedInputMethod() {
            return Settings.Secure.getStringForUser(this.mResolver, "default_input_method", this.mCurrentUserId);
        }

        private final boolean $$robo$$com_android_internal_inputmethod_InputMethodUtils_InputMethodSettings$isSubtypeSelected() {
            return this.getSelectedInputMethodSubtypeHashCode() != -1;
        }

        private final int $$robo$$com_android_internal_inputmethod_InputMethodUtils_InputMethodSettings$getSelectedInputMethodSubtypeHashCode() {
            try {
                return Settings.Secure.getIntForUser(this.mResolver, "selected_input_method_subtype", this.mCurrentUserId);
            }
            catch (Settings.SettingNotFoundException e) {
                return -1;
            }
        }

        private final boolean $$robo$$com_android_internal_inputmethod_InputMethodUtils_InputMethodSettings$isShowImeWithHardKeyboardEnabled() {
            return Settings.Secure.getIntForUser(this.mResolver, "show_ime_with_hard_keyboard", 0, this.mCurrentUserId) == 1;
        }

        private final void $$robo$$com_android_internal_inputmethod_InputMethodUtils_InputMethodSettings$setShowImeWithHardKeyboard(boolean show) {
            Settings.Secure.putIntForUser(this.mResolver, "show_ime_with_hard_keyboard", show ? 1 : 0, this.mCurrentUserId);
        }

        private final int $$robo$$com_android_internal_inputmethod_InputMethodUtils_InputMethodSettings$getCurrentUserId() {
            return this.mCurrentUserId;
        }

        private final int $$robo$$com_android_internal_inputmethod_InputMethodUtils_InputMethodSettings$getSelectedInputMethodSubtypeId(String selectedImiId) {
            InputMethodInfo imi = this.mMethodMap.get(selectedImiId);
            if (imi == null) {
                return -1;
            }
            int subtypeHashCode = this.getSelectedInputMethodSubtypeHashCode();
            return InputMethodUtils.getSubtypeIdFromHashCode(imi, subtypeHashCode);
        }

        private final void $$robo$$com_android_internal_inputmethod_InputMethodUtils_InputMethodSettings$saveCurrentInputMethodAndSubtypeToHistory(String curMethodId, InputMethodSubtype currentSubtype) {
            String subtypeId = NOT_A_SUBTYPE_ID_STR;
            if (currentSubtype != null) {
                subtypeId = String.valueOf(currentSubtype.hashCode());
            }
            if (InputMethodUtils.canAddToLastInputMethod(currentSubtype)) {
                this.addSubtypeToHistory(curMethodId, subtypeId);
            }
        }

        private final HashMap<InputMethodInfo, List<InputMethodSubtype>> $$robo$$com_android_internal_inputmethod_InputMethodUtils_InputMethodSettings$getExplicitlyOrImplicitlyEnabledInputMethodsAndSubtypeListLocked(Context context) {
            HashMap<InputMethodInfo, List<InputMethodSubtype>> enabledInputMethodAndSubtypes = new HashMap<InputMethodInfo, List<InputMethodSubtype>>();
            for (InputMethodInfo imi : this.getEnabledInputMethodListLocked()) {
                enabledInputMethodAndSubtypes.put(imi, this.getEnabledInputMethodSubtypeListLocked(context, imi, true));
            }
            return enabledInputMethodAndSubtypes;
        }

        private static void buildEnabledInputMethodsSettingString(StringBuilder stringBuilder, Pair<String, ArrayList<String>> pair) {
            InvokeDynamicSupport.bootstrapStatic("buildEnabledInputMethodsSettingString", $$robo$$com_android_internal_inputmethod_InputMethodUtils_InputMethodSettings$buildEnabledInputMethodsSettingString(java.lang.StringBuilder android.util.Pair<java.lang.String, java.util.ArrayList<java.lang.String>> ), 0, (StringBuilder)stringBuilder, pair);
        }

        private void __constructor__(Resources resources, ContentResolver contentResolver, HashMap<String, InputMethodInfo> hashMap, ArrayList<InputMethodInfo> arrayList, int n) {
            this.$$robo$$com_android_internal_inputmethod_InputMethodUtils_InputMethodSettings$__constructor__(resources, contentResolver, hashMap, arrayList, n);
        }

        public InputMethodSettings(Resources resources, ContentResolver contentResolver, HashMap<String, InputMethodInfo> hashMap, ArrayList<InputMethodInfo> arrayList, int n) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_inputmethod_InputMethodUtils_InputMethodSettings$__constructor__(android.content.res.Resources android.content.ContentResolver java.util.HashMap<java.lang.String, android.view.inputmethod.InputMethodInfo> java.util.ArrayList<android.view.inputmethod.InputMethodInfo> int ), 0, this, resources, contentResolver, hashMap, arrayList, n);
        }

        public void setCurrentUserId(int n) {
            InvokeDynamicSupport.bootstrap("setCurrentUserId", $$robo$$com_android_internal_inputmethod_InputMethodUtils_InputMethodSettings$setCurrentUserId(int ), 0, this, n);
        }

        public void setCurrentProfileIds(int[] nArray) {
            InvokeDynamicSupport.bootstrap("setCurrentProfileIds", $$robo$$com_android_internal_inputmethod_InputMethodUtils_InputMethodSettings$setCurrentProfileIds(int[] ), 0, this, nArray);
        }

        public boolean isCurrentProfile(int n) {
            return (boolean)InvokeDynamicSupport.bootstrap("isCurrentProfile", $$robo$$com_android_internal_inputmethod_InputMethodUtils_InputMethodSettings$isCurrentProfile(int ), 0, this, n);
        }

        public List<InputMethodInfo> getEnabledInputMethodListLocked() {
            return InvokeDynamicSupport.bootstrap("getEnabledInputMethodListLocked", $$robo$$com_android_internal_inputmethod_InputMethodUtils_InputMethodSettings$getEnabledInputMethodListLocked(), 0, this);
        }

        public List<Pair<InputMethodInfo, ArrayList<String>>> getEnabledInputMethodAndSubtypeHashCodeListLocked() {
            return InvokeDynamicSupport.bootstrap("getEnabledInputMethodAndSubtypeHashCodeListLocked", $$robo$$com_android_internal_inputmethod_InputMethodUtils_InputMethodSettings$getEnabledInputMethodAndSubtypeHashCodeListLocked(), 0, this);
        }

        public List<InputMethodSubtype> getEnabledInputMethodSubtypeListLocked(Context context, InputMethodInfo inputMethodInfo, boolean bl) {
            return InvokeDynamicSupport.bootstrap("getEnabledInputMethodSubtypeListLocked", $$robo$$com_android_internal_inputmethod_InputMethodUtils_InputMethodSettings$getEnabledInputMethodSubtypeListLocked(android.content.Context android.view.inputmethod.InputMethodInfo boolean ), 0, this, context, inputMethodInfo, bl);
        }

        public List<InputMethodSubtype> getEnabledInputMethodSubtypeListLocked(InputMethodInfo inputMethodInfo) {
            return InvokeDynamicSupport.bootstrap("getEnabledInputMethodSubtypeListLocked", $$robo$$com_android_internal_inputmethod_InputMethodUtils_InputMethodSettings$getEnabledInputMethodSubtypeListLocked(android.view.inputmethod.InputMethodInfo ), 0, this, inputMethodInfo);
        }

        public void enableAllIMEsIfThereIsNoEnabledIME() {
            InvokeDynamicSupport.bootstrap("enableAllIMEsIfThereIsNoEnabledIME", $$robo$$com_android_internal_inputmethod_InputMethodUtils_InputMethodSettings$enableAllIMEsIfThereIsNoEnabledIME(), 0, this);
        }

        public List<Pair<String, ArrayList<String>>> getEnabledInputMethodsAndSubtypeListLocked() {
            return InvokeDynamicSupport.bootstrap("getEnabledInputMethodsAndSubtypeListLocked", $$robo$$com_android_internal_inputmethod_InputMethodUtils_InputMethodSettings$getEnabledInputMethodsAndSubtypeListLocked(), 0, this);
        }

        public void appendAndPutEnabledInputMethodLocked(String string2, boolean bl) {
            InvokeDynamicSupport.bootstrap("appendAndPutEnabledInputMethodLocked", $$robo$$com_android_internal_inputmethod_InputMethodUtils_InputMethodSettings$appendAndPutEnabledInputMethodLocked(java.lang.String boolean ), 0, this, string2, bl);
        }

        public boolean buildAndPutEnabledInputMethodsStrRemovingIdLocked(StringBuilder stringBuilder, List<Pair<String, ArrayList<String>>> list, String string2) {
            return (boolean)InvokeDynamicSupport.bootstrap("buildAndPutEnabledInputMethodsStrRemovingIdLocked", $$robo$$com_android_internal_inputmethod_InputMethodUtils_InputMethodSettings$buildAndPutEnabledInputMethodsStrRemovingIdLocked(java.lang.StringBuilder java.util.List<android.util.Pair<java.lang.String, java.util.ArrayList<java.lang.String>>> java.lang.String ), 0, this, stringBuilder, list, string2);
        }

        private List<InputMethodInfo> createEnabledInputMethodListLocked(List<Pair<String, ArrayList<String>>> list) {
            return InvokeDynamicSupport.bootstrap("createEnabledInputMethodListLocked", $$robo$$com_android_internal_inputmethod_InputMethodUtils_InputMethodSettings$createEnabledInputMethodListLocked(java.util.List<android.util.Pair<java.lang.String, java.util.ArrayList<java.lang.String>>> ), 0, this, list);
        }

        private List<Pair<InputMethodInfo, ArrayList<String>>> createEnabledInputMethodAndSubtypeHashCodeListLocked(List<Pair<String, ArrayList<String>>> list) {
            return InvokeDynamicSupport.bootstrap("createEnabledInputMethodAndSubtypeHashCodeListLocked", $$robo$$com_android_internal_inputmethod_InputMethodUtils_InputMethodSettings$createEnabledInputMethodAndSubtypeHashCodeListLocked(java.util.List<android.util.Pair<java.lang.String, java.util.ArrayList<java.lang.String>>> ), 0, this, list);
        }

        private void putEnabledInputMethodsStr(String string2) {
            InvokeDynamicSupport.bootstrap("putEnabledInputMethodsStr", $$robo$$com_android_internal_inputmethod_InputMethodUtils_InputMethodSettings$putEnabledInputMethodsStr(java.lang.String ), 0, this, string2);
        }

        public String getEnabledInputMethodsStr() {
            return InvokeDynamicSupport.bootstrap("getEnabledInputMethodsStr", $$robo$$com_android_internal_inputmethod_InputMethodUtils_InputMethodSettings$getEnabledInputMethodsStr(), 0, this);
        }

        private void saveSubtypeHistory(List<Pair<String, String>> list, String string2, String string3) {
            InvokeDynamicSupport.bootstrap("saveSubtypeHistory", $$robo$$com_android_internal_inputmethod_InputMethodUtils_InputMethodSettings$saveSubtypeHistory(java.util.List<android.util.Pair<java.lang.String, java.lang.String>> java.lang.String java.lang.String ), 0, this, list, string2, string3);
        }

        private void addSubtypeToHistory(String string2, String string3) {
            InvokeDynamicSupport.bootstrap("addSubtypeToHistory", $$robo$$com_android_internal_inputmethod_InputMethodUtils_InputMethodSettings$addSubtypeToHistory(java.lang.String java.lang.String ), 0, this, string2, string3);
        }

        private void putSubtypeHistoryStr(String string2) {
            InvokeDynamicSupport.bootstrap("putSubtypeHistoryStr", $$robo$$com_android_internal_inputmethod_InputMethodUtils_InputMethodSettings$putSubtypeHistoryStr(java.lang.String ), 0, this, string2);
        }

        public Pair<String, String> getLastInputMethodAndSubtypeLocked() {
            return InvokeDynamicSupport.bootstrap("getLastInputMethodAndSubtypeLocked", $$robo$$com_android_internal_inputmethod_InputMethodUtils_InputMethodSettings$getLastInputMethodAndSubtypeLocked(), 0, this);
        }

        public String getLastSubtypeForInputMethodLocked(String string2) {
            return InvokeDynamicSupport.bootstrap("getLastSubtypeForInputMethodLocked", $$robo$$com_android_internal_inputmethod_InputMethodUtils_InputMethodSettings$getLastSubtypeForInputMethodLocked(java.lang.String ), 0, this, string2);
        }

        private Pair<String, String> getLastSubtypeForInputMethodLockedInternal(String string2) {
            return InvokeDynamicSupport.bootstrap("getLastSubtypeForInputMethodLockedInternal", $$robo$$com_android_internal_inputmethod_InputMethodUtils_InputMethodSettings$getLastSubtypeForInputMethodLockedInternal(java.lang.String ), 0, this, string2);
        }

        private String getEnabledSubtypeHashCodeForInputMethodAndSubtypeLocked(List<Pair<String, ArrayList<String>>> list, String string2, String string3) {
            return InvokeDynamicSupport.bootstrap("getEnabledSubtypeHashCodeForInputMethodAndSubtypeLocked", $$robo$$com_android_internal_inputmethod_InputMethodUtils_InputMethodSettings$getEnabledSubtypeHashCodeForInputMethodAndSubtypeLocked(java.util.List<android.util.Pair<java.lang.String, java.util.ArrayList<java.lang.String>>> java.lang.String java.lang.String ), 0, this, list, string2, string3);
        }

        private List<Pair<String, String>> loadInputMethodAndSubtypeHistoryLocked() {
            return InvokeDynamicSupport.bootstrap("loadInputMethodAndSubtypeHistoryLocked", $$robo$$com_android_internal_inputmethod_InputMethodUtils_InputMethodSettings$loadInputMethodAndSubtypeHistoryLocked(), 0, this);
        }

        private String getSubtypeHistoryStr() {
            return InvokeDynamicSupport.bootstrap("getSubtypeHistoryStr", $$robo$$com_android_internal_inputmethod_InputMethodUtils_InputMethodSettings$getSubtypeHistoryStr(), 0, this);
        }

        public void putSelectedInputMethod(String string2) {
            InvokeDynamicSupport.bootstrap("putSelectedInputMethod", $$robo$$com_android_internal_inputmethod_InputMethodUtils_InputMethodSettings$putSelectedInputMethod(java.lang.String ), 0, this, string2);
        }

        public void putSelectedSubtype(int n) {
            InvokeDynamicSupport.bootstrap("putSelectedSubtype", $$robo$$com_android_internal_inputmethod_InputMethodUtils_InputMethodSettings$putSelectedSubtype(int ), 0, this, n);
        }

        public String getDisabledSystemInputMethods() {
            return InvokeDynamicSupport.bootstrap("getDisabledSystemInputMethods", $$robo$$com_android_internal_inputmethod_InputMethodUtils_InputMethodSettings$getDisabledSystemInputMethods(), 0, this);
        }

        public String getSelectedInputMethod() {
            return InvokeDynamicSupport.bootstrap("getSelectedInputMethod", $$robo$$com_android_internal_inputmethod_InputMethodUtils_InputMethodSettings$getSelectedInputMethod(), 0, this);
        }

        public boolean isSubtypeSelected() {
            return (boolean)InvokeDynamicSupport.bootstrap("isSubtypeSelected", $$robo$$com_android_internal_inputmethod_InputMethodUtils_InputMethodSettings$isSubtypeSelected(), 0, this);
        }

        private int getSelectedInputMethodSubtypeHashCode() {
            return (int)InvokeDynamicSupport.bootstrap("getSelectedInputMethodSubtypeHashCode", $$robo$$com_android_internal_inputmethod_InputMethodUtils_InputMethodSettings$getSelectedInputMethodSubtypeHashCode(), 0, this);
        }

        public boolean isShowImeWithHardKeyboardEnabled() {
            return (boolean)InvokeDynamicSupport.bootstrap("isShowImeWithHardKeyboardEnabled", $$robo$$com_android_internal_inputmethod_InputMethodUtils_InputMethodSettings$isShowImeWithHardKeyboardEnabled(), 0, this);
        }

        public void setShowImeWithHardKeyboard(boolean bl) {
            InvokeDynamicSupport.bootstrap("setShowImeWithHardKeyboard", $$robo$$com_android_internal_inputmethod_InputMethodUtils_InputMethodSettings$setShowImeWithHardKeyboard(boolean ), 0, this, bl);
        }

        public int getCurrentUserId() {
            return (int)InvokeDynamicSupport.bootstrap("getCurrentUserId", $$robo$$com_android_internal_inputmethod_InputMethodUtils_InputMethodSettings$getCurrentUserId(), 0, this);
        }

        public int getSelectedInputMethodSubtypeId(String string2) {
            return (int)InvokeDynamicSupport.bootstrap("getSelectedInputMethodSubtypeId", $$robo$$com_android_internal_inputmethod_InputMethodUtils_InputMethodSettings$getSelectedInputMethodSubtypeId(java.lang.String ), 0, this, string2);
        }

        public void saveCurrentInputMethodAndSubtypeToHistory(String string2, InputMethodSubtype inputMethodSubtype) {
            InvokeDynamicSupport.bootstrap("saveCurrentInputMethodAndSubtypeToHistory", $$robo$$com_android_internal_inputmethod_InputMethodUtils_InputMethodSettings$saveCurrentInputMethodAndSubtypeToHistory(java.lang.String android.view.inputmethod.InputMethodSubtype ), 0, this, string2, inputMethodSubtype);
        }

        public HashMap<InputMethodInfo, List<InputMethodSubtype>> getExplicitlyOrImplicitlyEnabledInputMethodsAndSubtypeListLocked(Context context) {
            return InvokeDynamicSupport.bootstrap("getExplicitlyOrImplicitlyEnabledInputMethodsAndSubtypeListLocked", $$robo$$com_android_internal_inputmethod_InputMethodUtils_InputMethodSettings$getExplicitlyOrImplicitlyEnabledInputMethodsAndSubtypeListLocked(android.content.Context ), 0, this, context);
        }

        public /* synthetic */ InputMethodSettings() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (InputMethodSettings)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

