/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.logging;

import android.util.Log;
import com.android.internal.util.FastPrintWriter;
import dalvik.system.DalvikLogHandler;
import dalvik.system.DalvikLogging;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class AndroidHandler
extends Handler
implements DalvikLogHandler,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static Formatter THE_FORMATTER;

    private void $$robo$$com_android_internal_logging_AndroidHandler$__constructor__() {
        this.setFormatter(THE_FORMATTER);
    }

    private final void $$robo$$com_android_internal_logging_AndroidHandler$close() {
    }

    private final void $$robo$$com_android_internal_logging_AndroidHandler$flush() {
    }

    private final void $$robo$$com_android_internal_logging_AndroidHandler$publish(LogRecord record) {
        int level = AndroidHandler.getAndroidLevel(record.getLevel());
        String tag = DalvikLogging.loggerNameToTag(record.getLoggerName());
        if (!Log.isLoggable(tag, level)) {
            return;
        }
        try {
            String message = this.getFormatter().format(record);
            Log.println(level, tag, message);
        }
        catch (RuntimeException e) {
            Log.e("AndroidHandler", "Error logging message.", e);
        }
    }

    private final void $$robo$$com_android_internal_logging_AndroidHandler$publish(Logger source, String tag, Level level, String message) {
        int priority = AndroidHandler.getAndroidLevel(level);
        if (!Log.isLoggable(tag, priority)) {
            return;
        }
        try {
            Log.println(priority, tag, message);
        }
        catch (RuntimeException e) {
            Log.e("AndroidHandler", "Error logging message.", e);
        }
    }

    private static final int $$robo$$com_android_internal_logging_AndroidHandler$getAndroidLevel(Level level) {
        int value = level.intValue();
        if (value >= 1000) {
            return 6;
        }
        if (value >= 900) {
            return 5;
        }
        if (value >= 800) {
            return 4;
        }
        return 3;
    }

    static void __staticInitializer__() {
        THE_FORMATTER = new ShadowedObject(){
            public transient /* synthetic */ Object __robo_data__;

            private void $$robo$$com_android_internal_logging_AndroidHandler_1$__constructor__() {
            }

            private final String $$robo$$com_android_internal_logging_AndroidHandler_1$format(LogRecord r) {
                Throwable thrown = r.getThrown();
                if (thrown != null) {
                    StringWriter sw = new StringWriter();
                    FastPrintWriter pw = new FastPrintWriter(sw, false, 256);
                    sw.write(r.getMessage());
                    sw.write("\n");
                    thrown.printStackTrace(pw);
                    ((PrintWriter)pw).flush();
                    return sw.toString();
                }
                return r.getMessage();
            }

            private void __constructor__() {
                this.$$robo$$com_android_internal_logging_AndroidHandler_1$__constructor__();
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_logging_AndroidHandler_1$__constructor__(), 0, this);
            }

            @Override
            public String format(LogRecord logRecord) {
                return InvokeDynamicSupport.bootstrap("format", $$robo$$com_android_internal_logging_AndroidHandler_1$format(java.util.logging.LogRecord ), 0, this, logRecord);
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
    }

    private void __constructor__() {
        this.$$robo$$com_android_internal_logging_AndroidHandler$__constructor__();
    }

    public AndroidHandler() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_logging_AndroidHandler$__constructor__(), 0, this);
    }

    @Override
    public void close() {
        InvokeDynamicSupport.bootstrap("close", $$robo$$com_android_internal_logging_AndroidHandler$close(), 0, this);
    }

    @Override
    public void flush() {
        InvokeDynamicSupport.bootstrap("flush", $$robo$$com_android_internal_logging_AndroidHandler$flush(), 0, this);
    }

    @Override
    public void publish(LogRecord logRecord) {
        InvokeDynamicSupport.bootstrap("publish", $$robo$$com_android_internal_logging_AndroidHandler$publish(java.util.logging.LogRecord ), 0, this, logRecord);
    }

    @Override
    public void publish(Logger logger, String string2, Level level, String string3) {
        InvokeDynamicSupport.bootstrap("publish", $$robo$$com_android_internal_logging_AndroidHandler$publish(java.util.logging.Logger java.lang.String java.util.logging.Level java.lang.String ), 0, this, logger, string2, level, string3);
    }

    static int getAndroidLevel(Level level) {
        return (int)InvokeDynamicSupport.bootstrapStatic("getAndroidLevel", $$robo$$com_android_internal_logging_AndroidHandler$getAndroidLevel(java.util.logging.Level ), 0, (Level)level);
    }

    static {
        RobolectricInternals.classInitializing(AndroidHandler.class);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (AndroidHandler)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

