/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.net;

import android.net.NetworkStats;
import android.os.StrictMode;
import android.os.SystemClock;
import android.util.ArrayMap;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.util.ArrayUtils;
import com.android.internal.util.ProcFileReader;
import com.android.server.NetworkManagementSocketTagger;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.ProtocolException;
import java.util.Objects;
import libcore.io.IoUtils;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class NetworkStatsFactory
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "NetworkStatsFactory";
    private static boolean USE_NATIVE_PARSING = true;
    private static boolean SANITY_CHECK_NATIVE = false;
    private File mStatsXtIfaceAll;
    private File mStatsXtIfaceFmt;
    private File mStatsXtUid;
    @GuardedBy(value="sStackedIfaces")
    private static ArrayMap<String, String> sStackedIfaces;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void $$robo$$com_android_internal_net_NetworkStatsFactory$noteStackedIface(String stackedIface, String baseIface) {
        ArrayMap<String, String> arrayMap = sStackedIfaces;
        synchronized (arrayMap) {
            if (baseIface != null) {
                sStackedIfaces.put(stackedIface, baseIface);
            } else {
                sStackedIfaces.remove(stackedIface);
            }
        }
    }

    private void $$robo$$com_android_internal_net_NetworkStatsFactory$__constructor__() {
    }

    private void $$robo$$com_android_internal_net_NetworkStatsFactory$__constructor__(File procRoot) {
        this.mStatsXtIfaceAll = new File(procRoot, "net/xt_qtaguid/iface_stat_all");
        this.mStatsXtIfaceFmt = new File(procRoot, "net/xt_qtaguid/iface_stat_fmt");
        this.mStatsXtUid = new File(procRoot, "net/xt_qtaguid/stats");
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final NetworkStats $$robo$$com_android_internal_net_NetworkStatsFactory$readNetworkStatsSummaryDev() throws IOException {
        StrictMode.ThreadPolicy savedPolicy = StrictMode.allowThreadDiskReads();
        NetworkStats stats = new NetworkStats(SystemClock.elapsedRealtime(), 6);
        NetworkStats.Entry entry = new NetworkStats.Entry();
        ProcFileReader reader = null;
        try {
            reader = new ProcFileReader(new FileInputStream(this.mStatsXtIfaceAll));
            while (reader.hasMoreData()) {
                entry.iface = reader.nextString();
                entry.uid = -1;
                entry.set = -1;
                entry.tag = 0;
                boolean active = reader.nextInt() != 0;
                entry.rxBytes = reader.nextLong();
                entry.rxPackets = reader.nextLong();
                entry.txBytes = reader.nextLong();
                entry.txPackets = reader.nextLong();
                if (active) {
                    entry.rxBytes += reader.nextLong();
                    entry.rxPackets += reader.nextLong();
                    entry.txBytes += reader.nextLong();
                    entry.txPackets += reader.nextLong();
                }
                stats.addValues(entry);
                reader.finishLine();
            }
        }
        catch (NullPointerException e) {
            try {
                throw new ProtocolException("problem parsing stats", e);
                catch (NumberFormatException e2) {
                    throw new ProtocolException("problem parsing stats", e2);
                }
            }
            catch (Throwable throwable) {
                IoUtils.closeQuietly(reader);
                StrictMode.setThreadPolicy(savedPolicy);
                throw throwable;
            }
        }
        IoUtils.closeQuietly(reader);
        StrictMode.setThreadPolicy(savedPolicy);
        return stats;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final NetworkStats $$robo$$com_android_internal_net_NetworkStatsFactory$readNetworkStatsSummaryXt() throws IOException {
        StrictMode.ThreadPolicy savedPolicy = StrictMode.allowThreadDiskReads();
        if (!this.mStatsXtIfaceFmt.exists()) {
            return null;
        }
        NetworkStats stats = new NetworkStats(SystemClock.elapsedRealtime(), 6);
        NetworkStats.Entry entry = new NetworkStats.Entry();
        ProcFileReader reader = null;
        try {
            reader = new ProcFileReader(new FileInputStream(this.mStatsXtIfaceFmt));
            reader.finishLine();
            while (reader.hasMoreData()) {
                entry.iface = reader.nextString();
                entry.uid = -1;
                entry.set = -1;
                entry.tag = 0;
                entry.rxBytes = reader.nextLong();
                entry.rxPackets = reader.nextLong();
                entry.txBytes = reader.nextLong();
                entry.txPackets = reader.nextLong();
                stats.addValues(entry);
                reader.finishLine();
            }
        }
        catch (NullPointerException e) {
            try {
                throw new ProtocolException("problem parsing stats", e);
                catch (NumberFormatException e2) {
                    throw new ProtocolException("problem parsing stats", e2);
                }
            }
            catch (Throwable throwable) {
                IoUtils.closeQuietly(reader);
                StrictMode.setThreadPolicy(savedPolicy);
                throw throwable;
            }
        }
        IoUtils.closeQuietly(reader);
        StrictMode.setThreadPolicy(savedPolicy);
        return stats;
    }

    private final NetworkStats $$robo$$com_android_internal_net_NetworkStatsFactory$readNetworkStatsDetail() throws IOException {
        return this.readNetworkStatsDetail(-1, null, -1, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final NetworkStats $$robo$$com_android_internal_net_NetworkStatsFactory$readNetworkStatsDetail(int limitUid, String[] limitIfaces, int limitTag, NetworkStats lastStats) throws IOException {
        NetworkStats stats = this.readNetworkStatsDetailInternal(limitUid, limitIfaces, limitTag, lastStats);
        ArrayMap<String, String> arrayMap = sStackedIfaces;
        synchronized (arrayMap) {
            int size = sStackedIfaces.size();
            for (int i = 0; i < size; ++i) {
                String stackedIface = sStackedIfaces.keyAt(i);
                String baseIface = sStackedIfaces.valueAt(i);
                NetworkStats.Entry adjust = new NetworkStats.Entry(baseIface, 0, 0, 0, 0L, 0L, 0L, 0L, 0L);
                NetworkStats.Entry entry = null;
                for (int j = 0; j < stats.size(); ++j) {
                    entry = stats.getValues(j, entry);
                    if (!Objects.equals(entry.iface, stackedIface)) continue;
                    adjust.txBytes -= entry.txBytes;
                    adjust.txPackets -= entry.txPackets;
                }
                stats.combineValues(adjust);
            }
        }
        NetworkStats.Entry entry = null;
        for (int i = 0; i < stats.size(); ++i) {
            entry = stats.getValues(i, entry);
            if (entry.iface == null || !entry.iface.startsWith("clat")) continue;
            entry.rxBytes = entry.rxPackets * 20L;
            entry.rxPackets = 0L;
            entry.txBytes = 0L;
            entry.txPackets = 0L;
            stats.combineValues(entry);
        }
        return stats;
    }

    private final NetworkStats $$robo$$com_android_internal_net_NetworkStatsFactory$readNetworkStatsDetailInternal(int limitUid, String[] limitIfaces, int limitTag, NetworkStats lastStats) throws IOException {
        NetworkStats stats;
        if (lastStats != null) {
            stats = lastStats;
            stats.setElapsedRealtime(SystemClock.elapsedRealtime());
        } else {
            stats = new NetworkStats(SystemClock.elapsedRealtime(), -1);
        }
        if (NetworkStatsFactory.nativeReadNetworkStatsDetail(stats, this.mStatsXtUid.getAbsolutePath(), limitUid, limitIfaces, limitTag) != 0) {
            throw new IOException("Failed to parse network stats");
        }
        return stats;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static final NetworkStats $$robo$$com_android_internal_net_NetworkStatsFactory$javaReadNetworkStatsDetail(File detailPath, int limitUid, String[] limitIfaces, int limitTag) throws IOException {
        StrictMode.ThreadPolicy savedPolicy = StrictMode.allowThreadDiskReads();
        NetworkStats stats = new NetworkStats(SystemClock.elapsedRealtime(), 24);
        NetworkStats.Entry entry = new NetworkStats.Entry();
        int idx = 1;
        int lastIdx = 1;
        ProcFileReader reader = null;
        try {
            reader = new ProcFileReader(new FileInputStream(detailPath));
            reader.finishLine();
            while (reader.hasMoreData()) {
                idx = reader.nextInt();
                if (idx != lastIdx + 1) {
                    throw new ProtocolException("inconsistent idx=" + idx + " after lastIdx=" + lastIdx);
                }
                lastIdx = idx;
                entry.iface = reader.nextString();
                entry.tag = NetworkManagementSocketTagger.kernelToTag(reader.nextString());
                entry.uid = reader.nextInt();
                entry.set = reader.nextInt();
                entry.rxBytes = reader.nextLong();
                entry.rxPackets = reader.nextLong();
                entry.txBytes = reader.nextLong();
                entry.txPackets = reader.nextLong();
                if (!(limitIfaces != null && !ArrayUtils.contains(limitIfaces, entry.iface) || limitUid != -1 && limitUid != entry.uid || limitTag != -1 && limitTag != entry.tag)) {
                    stats.addValues(entry);
                }
                reader.finishLine();
            }
        }
        catch (NullPointerException e) {
            try {
                throw new ProtocolException("problem parsing idx " + idx, e);
                catch (NumberFormatException e2) {
                    throw new ProtocolException("problem parsing idx " + idx, e2);
                }
            }
            catch (Throwable throwable) {
                IoUtils.closeQuietly(reader);
                StrictMode.setThreadPolicy(savedPolicy);
                throw throwable;
            }
        }
        IoUtils.closeQuietly(reader);
        StrictMode.setThreadPolicy(savedPolicy);
        return stats;
    }

    private final void $$robo$$com_android_internal_net_NetworkStatsFactory$assertEquals(NetworkStats expected, NetworkStats actual) {
        if (expected.size() != actual.size()) {
            throw new AssertionError((Object)("Expected size " + expected.size() + ", actual size " + actual.size()));
        }
        NetworkStats.Entry expectedRow = null;
        NetworkStats.Entry actualRow = null;
        for (int i = 0; i < expected.size(); ++i) {
            if (!(expectedRow = expected.getValues(i, expectedRow)).equals(actualRow = actual.getValues(i, actualRow))) {
                throw new AssertionError((Object)("Expected row " + i + ": " + expectedRow + ", actual row " + actualRow));
            }
        }
    }

    private static final int $$robo$$com_android_internal_net_NetworkStatsFactory$nativeReadNetworkStatsDetail(NetworkStats networkStats, String string2, int n, String[] stringArray, int n2) {
        return 0;
    }

    static void __staticInitializer__() {
        sStackedIfaces = new ArrayMap();
    }

    public static void noteStackedIface(String string2, String string3) {
        InvokeDynamicSupport.bootstrapStatic("noteStackedIface", $$robo$$com_android_internal_net_NetworkStatsFactory$noteStackedIface(java.lang.String java.lang.String ), 0, (String)string2, (String)string3);
    }

    private void __constructor__() {
        this.$$robo$$com_android_internal_net_NetworkStatsFactory$__constructor__();
    }

    public NetworkStatsFactory() {
        this(new File("/proc/"));
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_net_NetworkStatsFactory$__constructor__(), 0, this);
    }

    private void __constructor__(File file) {
        this.$$robo$$com_android_internal_net_NetworkStatsFactory$__constructor__(file);
    }

    public NetworkStatsFactory(File file) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_net_NetworkStatsFactory$__constructor__(java.io.File ), 0, this, file);
    }

    public NetworkStats readNetworkStatsSummaryDev() throws IOException {
        return InvokeDynamicSupport.bootstrap("readNetworkStatsSummaryDev", $$robo$$com_android_internal_net_NetworkStatsFactory$readNetworkStatsSummaryDev(), 0, this);
    }

    public NetworkStats readNetworkStatsSummaryXt() throws IOException {
        return InvokeDynamicSupport.bootstrap("readNetworkStatsSummaryXt", $$robo$$com_android_internal_net_NetworkStatsFactory$readNetworkStatsSummaryXt(), 0, this);
    }

    public NetworkStats readNetworkStatsDetail() throws IOException {
        return InvokeDynamicSupport.bootstrap("readNetworkStatsDetail", $$robo$$com_android_internal_net_NetworkStatsFactory$readNetworkStatsDetail(), 0, this);
    }

    public NetworkStats readNetworkStatsDetail(int n, String[] stringArray, int n2, NetworkStats networkStats) throws IOException {
        return InvokeDynamicSupport.bootstrap("readNetworkStatsDetail", $$robo$$com_android_internal_net_NetworkStatsFactory$readNetworkStatsDetail(int java.lang.String[] int android.net.NetworkStats ), 0, this, n, stringArray, n2, networkStats);
    }

    private NetworkStats readNetworkStatsDetailInternal(int n, String[] stringArray, int n2, NetworkStats networkStats) throws IOException {
        return InvokeDynamicSupport.bootstrap("readNetworkStatsDetailInternal", $$robo$$com_android_internal_net_NetworkStatsFactory$readNetworkStatsDetailInternal(int java.lang.String[] int android.net.NetworkStats ), 0, this, n, stringArray, n2, networkStats);
    }

    public static NetworkStats javaReadNetworkStatsDetail(File file, int n, String[] stringArray, int n2) throws IOException {
        return InvokeDynamicSupport.bootstrapStatic("javaReadNetworkStatsDetail", $$robo$$com_android_internal_net_NetworkStatsFactory$javaReadNetworkStatsDetail(java.io.File int java.lang.String[] int ), 0, (File)file, (int)n, (String[])stringArray, (int)n2);
    }

    public void assertEquals(NetworkStats networkStats, NetworkStats networkStats2) {
        InvokeDynamicSupport.bootstrap("assertEquals", $$robo$$com_android_internal_net_NetworkStatsFactory$assertEquals(android.net.NetworkStats android.net.NetworkStats ), 0, this, networkStats, networkStats2);
    }

    private static final native /* synthetic */ int $$robo$$nativeReadNetworkStatsDetail$nativeBinding(NetworkStats var0, String var1, int var2, String[] var3, int var4);

    public static int nativeReadNetworkStatsDetail(NetworkStats networkStats, String string2, int n, String[] stringArray, int n2) {
        return (int)InvokeDynamicSupport.bootstrapStatic("nativeReadNetworkStatsDetail", $$robo$$com_android_internal_net_NetworkStatsFactory$nativeReadNetworkStatsDetail(android.net.NetworkStats java.lang.String int java.lang.String[] int ), 1, (NetworkStats)networkStats, (String)string2, (int)n, (String[])stringArray, (int)n2);
    }

    static {
        RobolectricInternals.classInitializing(NetworkStatsFactory.class);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (NetworkStatsFactory)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

