/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.os;

import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.hardware.Sensor;
import android.hardware.SensorManager;
import android.net.ConnectivityManager;
import android.os.BatteryStats;
import android.os.Bundle;
import android.os.MemoryFile;
import android.os.Parcel;
import android.os.ParcelFileDescriptor;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.SystemClock;
import android.os.UserHandle;
import android.util.ArrayMap;
import android.util.Log;
import android.util.SparseArray;
import com.android.internal.app.IBatteryStats;
import com.android.internal.os.BatterySipper;
import com.android.internal.os.BatteryStatsImpl;
import com.android.internal.os.PowerProfile;
import com.google.errorprone.annotations.DoNotMock;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class BatteryStatsHelper
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static boolean DEBUG = false;
    private static String TAG;
    private static BatteryStats sStatsXfer;
    private static Intent sBatteryBroadcastXfer;
    private static ArrayMap<File, BatteryStats> sFileXfer;
    private Context mContext;
    private boolean mCollectBatteryBroadcast;
    private boolean mWifiOnly;
    private IBatteryStats mBatteryInfo;
    private BatteryStats mStats;
    private Intent mBatteryBroadcast;
    private PowerProfile mPowerProfile;
    private List<BatterySipper> mUsageList;
    private List<BatterySipper> mWifiSippers;
    private List<BatterySipper> mBluetoothSippers;
    private SparseArray<List<BatterySipper>> mUserSippers;
    private SparseArray<Double> mUserPower;
    private List<BatterySipper> mMobilemsppList;
    private int mStatsType;
    long mRawRealtime;
    long mRawUptime;
    long mBatteryRealtime;
    long mBatteryUptime;
    long mTypeBatteryRealtime;
    long mTypeBatteryUptime;
    long mBatteryTimeRemaining;
    long mChargeTimeRemaining;
    private long mStatsPeriod;
    private double mMaxPower;
    private double mMaxRealPower;
    private double mComputedPower;
    private double mTotalPower;
    private double mWifiPower;
    private double mBluetoothPower;
    private double mMinDrainedPower;
    private double mMaxDrainedPower;
    private long mAppMobileActive;
    private long mAppWifiRunning;

    private void $$robo$$com_android_internal_os_BatteryStatsHelper$__constructor__(Context context) {
    }

    private void $$robo$$com_android_internal_os_BatteryStatsHelper$__constructor__(Context context, boolean collectBatteryBroadcast) {
        this.mUsageList = new ArrayList<BatterySipper>();
        this.mWifiSippers = new ArrayList<BatterySipper>();
        this.mBluetoothSippers = new ArrayList<BatterySipper>();
        this.mUserSippers = new SparseArray();
        this.mUserPower = new SparseArray();
        this.mMobilemsppList = new ArrayList<BatterySipper>();
        this.mStatsType = 0;
        this.mStatsPeriod = 0L;
        this.mMaxPower = 1.0;
        this.mMaxRealPower = 1.0;
        this.mContext = context;
        this.mCollectBatteryBroadcast = collectBatteryBroadcast;
        this.mWifiOnly = BatteryStatsHelper.checkWifiOnly(context);
    }

    private void $$robo$$com_android_internal_os_BatteryStatsHelper$__constructor__(Context context, boolean collectBatteryBroadcast, boolean wifiOnly) {
        this.mUsageList = new ArrayList<BatterySipper>();
        this.mWifiSippers = new ArrayList<BatterySipper>();
        this.mBluetoothSippers = new ArrayList<BatterySipper>();
        this.mUserSippers = new SparseArray();
        this.mUserPower = new SparseArray();
        this.mMobilemsppList = new ArrayList<BatterySipper>();
        this.mStatsType = 0;
        this.mStatsPeriod = 0L;
        this.mMaxPower = 1.0;
        this.mMaxRealPower = 1.0;
        this.mContext = context;
        this.mCollectBatteryBroadcast = collectBatteryBroadcast;
        this.mWifiOnly = wifiOnly;
    }

    private static final boolean $$robo$$com_android_internal_os_BatteryStatsHelper$checkWifiOnly(Context context) {
        ConnectivityManager cm = (ConnectivityManager)context.getSystemService("connectivity");
        return !cm.isNetworkSupported(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$com_android_internal_os_BatteryStatsHelper$storeStatsHistoryInFile(String fname) {
        ArrayMap<File, BatteryStats> arrayMap = sFileXfer;
        synchronized (arrayMap) {
            File path = BatteryStatsHelper.makeFilePath(this.mContext, fname);
            sFileXfer.put(path, this.getStats());
            FileOutputStream fout = null;
            try {
                fout = new FileOutputStream(path);
                Parcel hist = Parcel.obtain();
                this.getStats().writeToParcelWithoutUids(hist, 0);
                byte[] histData = hist.marshall();
                fout.write(histData);
            }
            catch (IOException e) {
                Log.w(TAG, "Unable to write history to file", e);
            }
            finally {
                if (fout != null) {
                    try {
                        fout.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static final BatteryStats $$robo$$com_android_internal_os_BatteryStatsHelper$statsFromFile(Context context, String fname) {
        ArrayMap<File, BatteryStats> arrayMap = sFileXfer;
        synchronized (arrayMap) {
            block15: {
                BatteryStats batteryStats;
                File path = BatteryStatsHelper.makeFilePath(context, fname);
                BatteryStats stats = sFileXfer.get(path);
                if (stats != null) {
                    return stats;
                }
                FileInputStream fin = null;
                try {
                    fin = new FileInputStream(path);
                    byte[] data = BatteryStatsHelper.readFully(fin);
                    Parcel parcel = Parcel.obtain();
                    parcel.unmarshall(data, 0, data.length);
                    parcel.setDataPosition(0);
                    batteryStats = BatteryStatsImpl.CREATOR.createFromParcel(parcel);
                }
                catch (IOException e) {
                    Log.w(TAG, "Unable to read history to file", e);
                    break block15;
                }
                return batteryStats;
                finally {
                    if (fin != null) {
                        try {
                            fin.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
            return BatteryStatsHelper.getStats(IBatteryStats.Stub.asInterface(ServiceManager.getService("batterystats")));
        }
    }

    private static final void $$robo$$com_android_internal_os_BatteryStatsHelper$dropFile(Context context, String fname) {
        BatteryStatsHelper.makeFilePath(context, fname).delete();
    }

    private static final File $$robo$$com_android_internal_os_BatteryStatsHelper$makeFilePath(Context context, String fname) {
        return new File(context.getFilesDir(), fname);
    }

    private final void $$robo$$com_android_internal_os_BatteryStatsHelper$clearStats() {
        this.mStats = null;
    }

    private final BatteryStats $$robo$$com_android_internal_os_BatteryStatsHelper$getStats() {
        if (this.mStats == null) {
            this.load();
        }
        return this.mStats;
    }

    private final Intent $$robo$$com_android_internal_os_BatteryStatsHelper$getBatteryBroadcast() {
        if (this.mBatteryBroadcast == null && this.mCollectBatteryBroadcast) {
            this.load();
        }
        return this.mBatteryBroadcast;
    }

    private final PowerProfile $$robo$$com_android_internal_os_BatteryStatsHelper$getPowerProfile() {
        return this.mPowerProfile;
    }

    private final void $$robo$$com_android_internal_os_BatteryStatsHelper$create(BatteryStats stats) {
        this.mPowerProfile = new PowerProfile(this.mContext);
        this.mStats = stats;
    }

    private final void $$robo$$com_android_internal_os_BatteryStatsHelper$create(Bundle icicle) {
        if (icicle != null) {
            this.mStats = sStatsXfer;
            this.mBatteryBroadcast = sBatteryBroadcastXfer;
        }
        this.mBatteryInfo = IBatteryStats.Stub.asInterface(ServiceManager.getService("batterystats"));
        this.mPowerProfile = new PowerProfile(this.mContext);
    }

    private final void $$robo$$com_android_internal_os_BatteryStatsHelper$storeState() {
        sStatsXfer = this.mStats;
        sBatteryBroadcastXfer = this.mBatteryBroadcast;
    }

    private static final String $$robo$$com_android_internal_os_BatteryStatsHelper$makemAh(double power) {
        if (power < 1.0E-5) {
            return String.format("%.8f", power);
        }
        if (power < 1.0E-4) {
            return String.format("%.7f", power);
        }
        if (power < 0.001) {
            return String.format("%.6f", power);
        }
        if (power < 0.01) {
            return String.format("%.5f", power);
        }
        if (power < 0.1) {
            return String.format("%.4f", power);
        }
        if (power < 1.0) {
            return String.format("%.3f", power);
        }
        if (power < 10.0) {
            return String.format("%.2f", power);
        }
        if (power < 100.0) {
            return String.format("%.1f", power);
        }
        return String.format("%.0f", power);
    }

    private final void $$robo$$com_android_internal_os_BatteryStatsHelper$refreshStats(int statsType, int asUser) {
        SparseArray<UserHandle> users = new SparseArray<UserHandle>(1);
        users.put(asUser, new UserHandle(asUser));
        this.refreshStats(statsType, users);
    }

    private final void $$robo$$com_android_internal_os_BatteryStatsHelper$refreshStats(int statsType, List<UserHandle> asUsers) {
        int n = asUsers.size();
        SparseArray<UserHandle> users = new SparseArray<UserHandle>(n);
        for (int i = 0; i < n; ++i) {
            UserHandle userHandle = asUsers.get(i);
            users.put(userHandle.getIdentifier(), userHandle);
        }
        this.refreshStats(statsType, users);
    }

    private final void $$robo$$com_android_internal_os_BatteryStatsHelper$refreshStats(int statsType, SparseArray<UserHandle> asUsers) {
        this.refreshStats(statsType, asUsers, SystemClock.elapsedRealtime() * 1000L, SystemClock.uptimeMillis() * 1000L);
    }

    private final void $$robo$$com_android_internal_os_BatteryStatsHelper$refreshStats(int statsType, SparseArray<UserHandle> asUsers, long rawRealtimeUs, long rawUptimeUs) {
        int i;
        this.getStats();
        this.mMaxPower = 0.0;
        this.mMaxRealPower = 0.0;
        this.mComputedPower = 0.0;
        this.mTotalPower = 0.0;
        this.mWifiPower = 0.0;
        this.mBluetoothPower = 0.0;
        this.mAppMobileActive = 0L;
        this.mAppWifiRunning = 0L;
        this.mUsageList.clear();
        this.mWifiSippers.clear();
        this.mBluetoothSippers.clear();
        this.mUserSippers.clear();
        this.mUserPower.clear();
        this.mMobilemsppList.clear();
        if (this.mStats == null) {
            return;
        }
        this.mStatsType = statsType;
        this.mRawUptime = rawUptimeUs;
        this.mRawRealtime = rawRealtimeUs;
        this.mBatteryUptime = this.mStats.getBatteryUptime(rawUptimeUs);
        this.mBatteryRealtime = this.mStats.getBatteryRealtime(rawRealtimeUs);
        this.mTypeBatteryUptime = this.mStats.computeBatteryUptime(rawUptimeUs, this.mStatsType);
        this.mTypeBatteryRealtime = this.mStats.computeBatteryRealtime(rawRealtimeUs, this.mStatsType);
        this.mBatteryTimeRemaining = this.mStats.computeBatteryTimeRemaining(rawRealtimeUs);
        this.mChargeTimeRemaining = this.mStats.computeChargeTimeRemaining(rawRealtimeUs);
        this.mMinDrainedPower = (double)this.mStats.getLowDischargeAmountSinceCharge() * this.mPowerProfile.getBatteryCapacity() / 100.0;
        this.mMaxDrainedPower = (double)this.mStats.getHighDischargeAmountSinceCharge() * this.mPowerProfile.getBatteryCapacity() / 100.0;
        this.processAppUsage(asUsers);
        for (i = 0; i < this.mUsageList.size(); ++i) {
            BatterySipper bs = this.mUsageList.get(i);
            bs.computeMobilemspp();
            if (bs.mobilemspp == 0.0) continue;
            this.mMobilemsppList.add(bs);
        }
        for (i = 0; i < this.mUserSippers.size(); ++i) {
            List<BatterySipper> user = this.mUserSippers.valueAt(i);
            for (int j = 0; j < user.size(); ++j) {
                BatterySipper bs = user.get(j);
                bs.computeMobilemspp();
                if (bs.mobilemspp == 0.0) continue;
                this.mMobilemsppList.add(bs);
            }
        }
        Collections.sort(this.mMobilemsppList, new Comparator<BatterySipper>(this){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ BatteryStatsHelper this$0;

            private void $$robo$$com_android_internal_os_BatteryStatsHelper_1$__constructor__(BatteryStatsHelper batteryStatsHelper) {
            }

            private final int $$robo$$com_android_internal_os_BatteryStatsHelper_1$compare(BatterySipper lhs, BatterySipper rhs) {
                if (lhs.mobilemspp < rhs.mobilemspp) {
                    return 1;
                }
                if (lhs.mobilemspp > rhs.mobilemspp) {
                    return -1;
                }
                return 0;
            }

            private void __constructor__(BatteryStatsHelper batteryStatsHelper) {
                this.$$robo$$com_android_internal_os_BatteryStatsHelper_1$__constructor__(batteryStatsHelper);
            }
            {
                this.this$0 = batteryStatsHelper;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_os_BatteryStatsHelper_1$__constructor__(com.android.internal.os.BatteryStatsHelper ), 0, this, batteryStatsHelper);
            }

            @Override
            public int compare(BatterySipper batterySipper, BatterySipper batterySipper2) {
                return (int)InvokeDynamicSupport.bootstrap("compare", $$robo$$com_android_internal_os_BatteryStatsHelper_1$compare(com.android.internal.os.BatterySipper com.android.internal.os.BatterySipper ), 0, this, batterySipper, batterySipper2);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        });
        this.processMiscUsage();
        this.mTotalPower = this.mComputedPower;
        if (this.mStats.getLowDischargeAmountSinceCharge() > 1) {
            if (this.mMinDrainedPower > this.mComputedPower) {
                double amount = this.mMinDrainedPower - this.mComputedPower;
                this.mTotalPower = this.mMinDrainedPower;
                this.addEntryNoTotal(BatterySipper.DrainType.UNACCOUNTED, 0L, amount);
            } else if (this.mMaxDrainedPower < this.mComputedPower) {
                double amount = this.mComputedPower - this.mMaxDrainedPower;
                this.addEntryNoTotal(BatterySipper.DrainType.OVERCOUNTED, 0L, amount);
            }
        }
        Collections.sort(this.mUsageList);
    }

    private final void $$robo$$com_android_internal_os_BatteryStatsHelper$processAppUsage(SparseArray<UserHandle> asUsers) {
        boolean forAllUsers = asUsers.get(-1) != null;
        SensorManager sensorManager = (SensorManager)this.mContext.getSystemService("sensor");
        int which = this.mStatsType;
        int speedSteps = this.mPowerProfile.getNumSpeedSteps();
        double[] powerCpuNormal = new double[speedSteps];
        long[] cpuSpeedStepTimes = new long[speedSteps];
        for (int p = 0; p < speedSteps; ++p) {
            powerCpuNormal[p] = this.mPowerProfile.getAveragePower("cpu.active", p);
        }
        double mobilePowerPerPacket = this.getMobilePowerPerPacket();
        double mobilePowerPerMs = this.getMobilePowerPerMs();
        double wifiPowerPerPacket = this.getWifiPowerPerPacket();
        long appWakelockTimeUs = 0L;
        BatterySipper osApp = null;
        this.mStatsPeriod = this.mTypeBatteryRealtime;
        SparseArray<? extends BatteryStats.Uid> uidStats = this.mStats.getUidStats();
        int NU = uidStats.size();
        for (int iu = 0; iu < NU; ++iu) {
            BatteryStats.Uid u = uidStats.valueAt(iu);
            double power = 0.0;
            double highestDrain = 0.0;
            String packageWithHighestDrain = null;
            Map<String, ? extends BatteryStats.Uid.Proc> processStats = u.getProcessStats();
            long cpuTime = 0L;
            long cpuFgTime = 0L;
            long wakelockTime = 0L;
            long gpsTime = 0L;
            if (processStats.size() > 0) {
                for (Map.Entry<String, ? extends BatteryStats.Uid.Proc> ent : processStats.entrySet()) {
                    BatteryStats.Uid.Proc ps = ent.getValue();
                    long userTime = ps.getUserTime(which);
                    long systemTime = ps.getSystemTime(which);
                    long foregroundTime = ps.getForegroundTime(which);
                    cpuFgTime += foregroundTime * 10L;
                    long tmpCpuTime = (userTime + systemTime) * 10L;
                    int totalTimeAtSpeeds = 0;
                    for (int step = 0; step < speedSteps; ++step) {
                        cpuSpeedStepTimes[step] = ps.getTimeAtCpuSpeedStep(step, which);
                        totalTimeAtSpeeds = (int)((long)totalTimeAtSpeeds + cpuSpeedStepTimes[step]);
                    }
                    if (totalTimeAtSpeeds == 0) {
                        totalTimeAtSpeeds = 1;
                    }
                    double processPower = 0.0;
                    for (int step = 0; step < speedSteps; ++step) {
                        double ratio = (double)cpuSpeedStepTimes[step] / (double)totalTimeAtSpeeds;
                        processPower += ratio * (double)tmpCpuTime * powerCpuNormal[step];
                    }
                    cpuTime += tmpCpuTime;
                    power += processPower;
                    if (packageWithHighestDrain == null || packageWithHighestDrain.startsWith("*")) {
                        highestDrain = processPower;
                        packageWithHighestDrain = ent.getKey();
                        continue;
                    }
                    if (!(highestDrain < processPower) || ent.getKey().startsWith("*")) continue;
                    highestDrain = processPower;
                    packageWithHighestDrain = ent.getKey();
                }
            }
            if (cpuFgTime > cpuTime) {
                cpuTime = cpuFgTime;
            }
            power /= 3600000.0;
            Map<String, ? extends BatteryStats.Uid.Wakelock> wakelockStats = u.getWakelockStats();
            for (Map.Entry<String, ? extends BatteryStats.Uid.Wakelock> wakelockEntry : wakelockStats.entrySet()) {
                BatteryStats.Uid.Wakelock wakelock = wakelockEntry.getValue();
                BatteryStats.Timer timer = wakelock.getWakeTime(0);
                if (timer == null) continue;
                wakelockTime += timer.getTotalTimeLocked(this.mRawRealtime, which);
            }
            appWakelockTimeUs += wakelockTime;
            double p = (double)(wakelockTime /= 1000L) * this.mPowerProfile.getAveragePower("cpu.awake") / 3600000.0;
            power += p;
            long mobileRx = u.getNetworkActivityPackets(0, this.mStatsType);
            long mobileTx = u.getNetworkActivityPackets(1, this.mStatsType);
            long mobileRxB = u.getNetworkActivityBytes(0, this.mStatsType);
            long mobileTxB = u.getNetworkActivityBytes(1, this.mStatsType);
            long mobileActive = u.getMobileRadioActiveTime(this.mStatsType);
            if (mobileActive > 0L) {
                this.mAppMobileActive += mobileActive;
                p = mobilePowerPerMs * (double)mobileActive / 1000.0;
            } else {
                p = (double)(mobileRx + mobileTx) * mobilePowerPerPacket;
            }
            power += p;
            long wifiRx = u.getNetworkActivityPackets(2, this.mStatsType);
            long wifiTx = u.getNetworkActivityPackets(3, this.mStatsType);
            long wifiRxB = u.getNetworkActivityBytes(2, this.mStatsType);
            long wifiTxB = u.getNetworkActivityBytes(3, this.mStatsType);
            p = (double)(wifiRx + wifiTx) * wifiPowerPerPacket;
            power += p;
            long wifiRunningTimeMs = u.getWifiRunningTime(this.mRawRealtime, which) / 1000L;
            this.mAppWifiRunning += wifiRunningTimeMs;
            p = (double)wifiRunningTimeMs * this.mPowerProfile.getAveragePower("wifi.on") / 3600000.0;
            power += p;
            long wifiScanTimeMs = u.getWifiScanTime(this.mRawRealtime, which) / 1000L;
            p = (double)wifiScanTimeMs * this.mPowerProfile.getAveragePower("wifi.scan") / 3600000.0;
            power += p;
            for (int bin = 0; bin < 5; ++bin) {
                long batchScanTimeMs = u.getWifiBatchedScanTime(bin, this.mRawRealtime, which) / 1000L;
                p = (double)batchScanTimeMs * this.mPowerProfile.getAveragePower("wifi.batchedscan", bin) / 3600000.0;
                power += p;
            }
            SparseArray<? extends BatteryStats.Uid.Sensor> sensorStats = u.getSensorStats();
            int NSE = sensorStats.size();
            for (int ise = 0; ise < NSE; ++ise) {
                BatteryStats.Uid.Sensor sensor = sensorStats.valueAt(ise);
                int sensorHandle = sensorStats.keyAt(ise);
                BatteryStats.Timer timer = sensor.getSensorTime();
                long sensorTime = timer.getTotalTimeLocked(this.mRawRealtime, which) / 1000L;
                double multiplier = 0.0;
                block0 : switch (sensorHandle) {
                    case -10000: {
                        multiplier = this.mPowerProfile.getAveragePower("gps.on");
                        gpsTime = sensorTime;
                        break;
                    }
                    default: {
                        List<Sensor> sensorList = sensorManager.getSensorList(-1);
                        for (Sensor s : sensorList) {
                            if (s.getHandle() != sensorHandle) continue;
                            multiplier = s.getPower();
                            break block0;
                        }
                    }
                }
                p = multiplier * (double)sensorTime / 3600000.0;
                power += p;
            }
            int userId = UserHandle.getUserId(u.getUid());
            if (power == 0.0 && u.getUid() != 0) continue;
            BatterySipper app = new BatterySipper(BatterySipper.DrainType.APP, u, new double[]{power});
            app.cpuTime = cpuTime;
            app.gpsTime = gpsTime;
            app.wifiRunningTime = wifiRunningTimeMs;
            app.cpuFgTime = cpuFgTime;
            app.wakeLockTime = wakelockTime;
            app.mobileRxPackets = mobileRx;
            app.mobileTxPackets = mobileTx;
            app.mobileActive = mobileActive / 1000L;
            app.mobileActiveCount = u.getMobileRadioActiveCount(this.mStatsType);
            app.wifiRxPackets = wifiRx;
            app.wifiTxPackets = wifiTx;
            app.mobileRxBytes = mobileRxB;
            app.mobileTxBytes = mobileTxB;
            app.wifiRxBytes = wifiRxB;
            app.wifiTxBytes = wifiTxB;
            app.packageWithHighestDrain = packageWithHighestDrain;
            if (u.getUid() == 1010) {
                this.mWifiSippers.add(app);
                this.mWifiPower += power;
            } else if (u.getUid() == 1002) {
                this.mBluetoothSippers.add(app);
                this.mBluetoothPower += power;
            } else if (!forAllUsers && asUsers.get(userId) == null && UserHandle.getAppId(u.getUid()) >= 10000) {
                List<BatterySipper> list = this.mUserSippers.get(userId);
                if (list == null) {
                    list = new ArrayList<BatterySipper>();
                    this.mUserSippers.put(userId, list);
                }
                list.add(app);
                if (power != 0.0) {
                    Double userPower = this.mUserPower.get(userId);
                    userPower = userPower == null ? Double.valueOf(power) : Double.valueOf(userPower + power);
                    this.mUserPower.put(userId, userPower);
                }
            } else {
                this.mUsageList.add(app);
                if (power > this.mMaxPower) {
                    this.mMaxPower = power;
                }
                if (power > this.mMaxRealPower) {
                    this.mMaxRealPower = power;
                }
                this.mComputedPower += power;
            }
            if (u.getUid() != 0) continue;
            osApp = app;
        }
        if (osApp != null) {
            long wakeTimeMillis = this.mBatteryUptime / 1000L;
            if ((wakeTimeMillis -= appWakelockTimeUs / 1000L + this.mStats.getScreenOnTime(this.mRawRealtime, which) / 1000L) > 0L) {
                double power = (double)wakeTimeMillis * this.mPowerProfile.getAveragePower("cpu.awake") / 3600000.0;
                osApp.wakeLockTime += wakeTimeMillis;
                osApp.value += power;
                osApp.values[0] = osApp.values[0] + power;
                if (osApp.value > this.mMaxPower) {
                    this.mMaxPower = osApp.value;
                }
                if (osApp.value > this.mMaxRealPower) {
                    this.mMaxRealPower = osApp.value;
                }
                this.mComputedPower += power;
            }
        }
    }

    private final void $$robo$$com_android_internal_os_BatteryStatsHelper$addPhoneUsage() {
        long phoneOnTimeMs = this.mStats.getPhoneOnTime(this.mRawRealtime, this.mStatsType) / 1000L;
        double phoneOnPower = this.mPowerProfile.getAveragePower("radio.active") * (double)phoneOnTimeMs / 3600000.0;
        if (phoneOnPower != 0.0) {
            BatterySipper batterySipper = this.addEntry(BatterySipper.DrainType.PHONE, phoneOnTimeMs, phoneOnPower);
        }
    }

    private final void $$robo$$com_android_internal_os_BatteryStatsHelper$addScreenUsage() {
        double power = 0.0;
        long screenOnTimeMs = this.mStats.getScreenOnTime(this.mRawRealtime, this.mStatsType) / 1000L;
        power += (double)screenOnTimeMs * this.mPowerProfile.getAveragePower("screen.on");
        double screenFullPower = this.mPowerProfile.getAveragePower("screen.full");
        for (int i = 0; i < 5; ++i) {
            double screenBinPower = screenFullPower * (double)((float)i + 0.5f) / 5.0;
            long brightnessTime = this.mStats.getScreenBrightnessTime(i, this.mRawRealtime, this.mStatsType) / 1000L;
            double p = screenBinPower * (double)brightnessTime;
            power += p;
        }
        if ((power /= 3600000.0) != 0.0) {
            this.addEntry(BatterySipper.DrainType.SCREEN, screenOnTimeMs, power);
        }
    }

    private final void $$robo$$com_android_internal_os_BatteryStatsHelper$addRadioUsage() {
        double power = 0.0;
        int BINS = 5;
        long signalTimeMs = 0L;
        long noCoverageTimeMs = 0L;
        for (int i = 0; i < 5; ++i) {
            long strengthTimeMs = this.mStats.getPhoneSignalStrengthTime(i, this.mRawRealtime, this.mStatsType) / 1000L;
            double p = (double)strengthTimeMs * this.mPowerProfile.getAveragePower("radio.on", i) / 3600000.0;
            power += p;
            signalTimeMs += strengthTimeMs;
            if (i != 0) continue;
            noCoverageTimeMs = strengthTimeMs;
        }
        long scanningTimeMs = this.mStats.getPhoneSignalScanningTime(this.mRawRealtime, this.mStatsType) / 1000L;
        double p = (double)scanningTimeMs * this.mPowerProfile.getAveragePower("radio.scanning") / 3600000.0;
        power += p;
        long radioActiveTimeUs = this.mStats.getMobileRadioActiveTime(this.mRawRealtime, this.mStatsType);
        long remainingActiveTime = (radioActiveTimeUs - this.mAppMobileActive) / 1000L;
        if (remainingActiveTime > 0L) {
            power += this.getMobilePowerPerMs() * (double)remainingActiveTime;
        }
        if (power != 0.0) {
            BatterySipper bs = this.addEntry(BatterySipper.DrainType.CELL, signalTimeMs, power);
            if (signalTimeMs != 0L) {
                bs.noCoveragePercent = (double)noCoverageTimeMs * 100.0 / (double)signalTimeMs;
            }
            bs.mobileActive = remainingActiveTime;
            bs.mobileActiveCount = this.mStats.getMobileRadioActiveUnknownCount(this.mStatsType);
        }
    }

    private final void $$robo$$com_android_internal_os_BatteryStatsHelper$aggregateSippers(BatterySipper bs, List<BatterySipper> from, String tag) {
        for (int i = 0; i < from.size(); ++i) {
            BatterySipper wbs = from.get(i);
            bs.cpuTime += wbs.cpuTime;
            bs.gpsTime += wbs.gpsTime;
            bs.wifiRunningTime += wbs.wifiRunningTime;
            bs.cpuFgTime += wbs.cpuFgTime;
            bs.wakeLockTime += wbs.wakeLockTime;
            bs.mobileRxPackets += wbs.mobileRxPackets;
            bs.mobileTxPackets += wbs.mobileTxPackets;
            bs.mobileActive += wbs.mobileActive;
            bs.mobileActiveCount += wbs.mobileActiveCount;
            bs.wifiRxPackets += wbs.wifiRxPackets;
            bs.wifiTxPackets += wbs.wifiTxPackets;
            bs.mobileRxBytes += wbs.mobileRxBytes;
            bs.mobileTxBytes += wbs.mobileTxBytes;
            bs.wifiRxBytes += wbs.wifiRxBytes;
            bs.wifiTxBytes += wbs.wifiTxBytes;
        }
        bs.computeMobilemspp();
    }

    private final void $$robo$$com_android_internal_os_BatteryStatsHelper$addWiFiUsage() {
        double wifiPower;
        long onTimeMs = this.mStats.getWifiOnTime(this.mRawRealtime, this.mStatsType) / 1000L;
        long runningTimeMs = this.mStats.getGlobalWifiRunningTime(this.mRawRealtime, this.mStatsType) / 1000L;
        if ((runningTimeMs -= this.mAppWifiRunning) < 0L) {
            runningTimeMs = 0L;
        }
        if ((wifiPower = ((double)(onTimeMs * 0L) * this.mPowerProfile.getAveragePower("wifi.on") + (double)runningTimeMs * this.mPowerProfile.getAveragePower("wifi.on")) / 3600000.0) + this.mWifiPower != 0.0) {
            BatterySipper bs = this.addEntry(BatterySipper.DrainType.WIFI, runningTimeMs, wifiPower + this.mWifiPower);
            this.aggregateSippers(bs, this.mWifiSippers, "WIFI");
        }
    }

    private final void $$robo$$com_android_internal_os_BatteryStatsHelper$addIdleUsage() {
        long idleTimeMs = (this.mTypeBatteryRealtime - this.mStats.getScreenOnTime(this.mRawRealtime, this.mStatsType)) / 1000L;
        double idlePower = (double)idleTimeMs * this.mPowerProfile.getAveragePower("cpu.idle") / 3600000.0;
        if (idlePower != 0.0) {
            this.addEntry(BatterySipper.DrainType.IDLE, idleTimeMs, idlePower);
        }
    }

    private final void $$robo$$com_android_internal_os_BatteryStatsHelper$addBluetoothUsage() {
        long btOnTimeMs = this.mStats.getBluetoothOnTime(this.mRawRealtime, this.mStatsType) / 1000L;
        double btPower = (double)btOnTimeMs * this.mPowerProfile.getAveragePower("bluetooth.on") / 3600000.0;
        int btPingCount = this.mStats.getBluetoothPingCount();
        double pingPower = (double)btPingCount * this.mPowerProfile.getAveragePower("bluetooth.at") / 3600000.0;
        if ((btPower += pingPower) + this.mBluetoothPower != 0.0) {
            BatterySipper bs = this.addEntry(BatterySipper.DrainType.BLUETOOTH, btOnTimeMs, btPower + this.mBluetoothPower);
            this.aggregateSippers(bs, this.mBluetoothSippers, "Bluetooth");
        }
    }

    private final void $$robo$$com_android_internal_os_BatteryStatsHelper$addFlashlightUsage() {
        long flashlightOnTimeMs = this.mStats.getFlashlightOnTime(this.mRawRealtime, this.mStatsType) / 1000L;
        double flashlightPower = (double)flashlightOnTimeMs * this.mPowerProfile.getAveragePower("camera.flashlight") / 3600000.0;
        if (flashlightPower != 0.0) {
            this.addEntry(BatterySipper.DrainType.FLASHLIGHT, flashlightOnTimeMs, flashlightPower);
        }
    }

    private final void $$robo$$com_android_internal_os_BatteryStatsHelper$addUserUsage() {
        for (int i = 0; i < this.mUserSippers.size(); ++i) {
            int userId = this.mUserSippers.keyAt(i);
            List<BatterySipper> sippers = this.mUserSippers.valueAt(i);
            Double userPower = this.mUserPower.get(userId);
            double power = userPower != null ? userPower : 0.0;
            BatterySipper bs = this.addEntry(BatterySipper.DrainType.USER, 0L, power);
            bs.userId = userId;
            this.aggregateSippers(bs, sippers, "User");
        }
    }

    private final double $$robo$$com_android_internal_os_BatteryStatsHelper$getMobilePowerPerPacket() {
        long MOBILE_BPS = 200000L;
        double MOBILE_POWER = this.mPowerProfile.getAveragePower("radio.active") / 3600.0;
        long mobileRx = this.mStats.getNetworkActivityPackets(0, this.mStatsType);
        long mobileTx = this.mStats.getNetworkActivityPackets(1, this.mStatsType);
        long mobileData = mobileRx + mobileTx;
        long radioDataUptimeMs = this.mStats.getMobileRadioActiveTime(this.mRawRealtime, this.mStatsType) / 1000L;
        double mobilePps = mobileData != 0L && radioDataUptimeMs != 0L ? (double)mobileData / (double)radioDataUptimeMs : 12.20703125;
        return MOBILE_POWER / mobilePps / 3600.0;
    }

    private final double $$robo$$com_android_internal_os_BatteryStatsHelper$getMobilePowerPerMs() {
        return this.mPowerProfile.getAveragePower("radio.active") / 3600000.0;
    }

    private final double $$robo$$com_android_internal_os_BatteryStatsHelper$getWifiPowerPerPacket() {
        long WIFI_BPS = 1000000L;
        double WIFI_POWER = this.mPowerProfile.getAveragePower("wifi.active") / 3600.0;
        return WIFI_POWER / 61.03515625 / 3600.0;
    }

    private final void $$robo$$com_android_internal_os_BatteryStatsHelper$processMiscUsage() {
        this.addUserUsage();
        this.addPhoneUsage();
        this.addScreenUsage();
        this.addFlashlightUsage();
        this.addWiFiUsage();
        this.addBluetoothUsage();
        this.addIdleUsage();
        if (!this.mWifiOnly) {
            this.addRadioUsage();
        }
    }

    private final BatterySipper $$robo$$com_android_internal_os_BatteryStatsHelper$addEntry(BatterySipper.DrainType drainType, long time, double power) {
        this.mComputedPower += power;
        if (power > this.mMaxRealPower) {
            this.mMaxRealPower = power;
        }
        return this.addEntryNoTotal(drainType, time, power);
    }

    private final BatterySipper $$robo$$com_android_internal_os_BatteryStatsHelper$addEntryNoTotal(BatterySipper.DrainType drainType, long time, double power) {
        if (power > this.mMaxPower) {
            this.mMaxPower = power;
        }
        BatterySipper bs = new BatterySipper(drainType, null, new double[]{power});
        bs.usageTime = time;
        this.mUsageList.add(bs);
        return bs;
    }

    private final List<BatterySipper> $$robo$$com_android_internal_os_BatteryStatsHelper$getUsageList() {
        return this.mUsageList;
    }

    private final List<BatterySipper> $$robo$$com_android_internal_os_BatteryStatsHelper$getMobilemsppList() {
        return this.mMobilemsppList;
    }

    private final long $$robo$$com_android_internal_os_BatteryStatsHelper$getStatsPeriod() {
        return this.mStatsPeriod;
    }

    private final int $$robo$$com_android_internal_os_BatteryStatsHelper$getStatsType() {
        return this.mStatsType;
    }

    private final double $$robo$$com_android_internal_os_BatteryStatsHelper$getMaxPower() {
        return this.mMaxPower;
    }

    private final double $$robo$$com_android_internal_os_BatteryStatsHelper$getMaxRealPower() {
        return this.mMaxRealPower;
    }

    private final double $$robo$$com_android_internal_os_BatteryStatsHelper$getTotalPower() {
        return this.mTotalPower;
    }

    private final double $$robo$$com_android_internal_os_BatteryStatsHelper$getComputedPower() {
        return this.mComputedPower;
    }

    private final double $$robo$$com_android_internal_os_BatteryStatsHelper$getMinDrainedPower() {
        return this.mMinDrainedPower;
    }

    private final double $$robo$$com_android_internal_os_BatteryStatsHelper$getMaxDrainedPower() {
        return this.mMaxDrainedPower;
    }

    private final long $$robo$$com_android_internal_os_BatteryStatsHelper$getBatteryTimeRemaining() {
        return this.mBatteryTimeRemaining;
    }

    private final long $$robo$$com_android_internal_os_BatteryStatsHelper$getChargeTimeRemaining() {
        return this.mChargeTimeRemaining;
    }

    private static final byte[] $$robo$$com_android_internal_os_BatteryStatsHelper$readFully(FileInputStream stream) throws IOException {
        return BatteryStatsHelper.readFully(stream, stream.available());
    }

    private static final byte[] $$robo$$com_android_internal_os_BatteryStatsHelper$readFully(FileInputStream stream, int avail) throws IOException {
        int pos = 0;
        byte[] data = new byte[avail];
        int amt;
        while ((amt = stream.read(data, pos, data.length - pos)) > 0) {
            avail = stream.available();
            if (avail <= data.length - (pos += amt)) continue;
            byte[] newData = new byte[pos + avail];
            InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (byte[])data, (int)0, (byte[])newData, (int)0, (int)pos);
            data = newData;
        }
        return data;
    }

    private final void $$robo$$com_android_internal_os_BatteryStatsHelper$load() {
        if (this.mBatteryInfo == null) {
            return;
        }
        this.mStats = BatteryStatsHelper.getStats(this.mBatteryInfo);
        if (this.mCollectBatteryBroadcast) {
            this.mBatteryBroadcast = this.mContext.registerReceiver(null, new IntentFilter("android.intent.action.BATTERY_CHANGED"));
        }
    }

    private static final BatteryStatsImpl $$robo$$com_android_internal_os_BatteryStatsHelper$getStats(IBatteryStats service) {
        try {
            ParcelFileDescriptor pfd = service.getStatisticsStream();
            if (pfd != null) {
                ParcelFileDescriptor.AutoCloseInputStream fis = new ParcelFileDescriptor.AutoCloseInputStream(pfd);
                try {
                    byte[] data = BatteryStatsHelper.readFully(fis, MemoryFile.getSize(pfd.getFileDescriptor()));
                    Parcel parcel = Parcel.obtain();
                    parcel.unmarshall(data, 0, data.length);
                    parcel.setDataPosition(0);
                    BatteryStatsImpl stats = BatteryStatsImpl.CREATOR.createFromParcel(parcel);
                    stats.distributeWorkLocked(0);
                    return stats;
                }
                catch (IOException e) {
                    Log.w(TAG, "Unable to read statistics stream", e);
                }
            }
        }
        catch (RemoteException e) {
            Log.w(TAG, "RemoteException:", e);
        }
        return new BatteryStatsImpl();
    }

    static void __staticInitializer__() {
        TAG = BatteryStatsHelper.class.getSimpleName();
        sFileXfer = new ArrayMap();
    }

    private void __constructor__(Context context) {
        this.$$robo$$com_android_internal_os_BatteryStatsHelper$__constructor__(context);
    }

    public BatteryStatsHelper(Context context) {
        this(context, true);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_os_BatteryStatsHelper$__constructor__(android.content.Context ), 0, this, context);
    }

    private void __constructor__(Context context, boolean bl) {
        this.$$robo$$com_android_internal_os_BatteryStatsHelper$__constructor__(context, bl);
    }

    public BatteryStatsHelper(Context context, boolean bl) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_os_BatteryStatsHelper$__constructor__(android.content.Context boolean ), 0, this, context, bl);
    }

    private void __constructor__(Context context, boolean bl, boolean bl2) {
        this.$$robo$$com_android_internal_os_BatteryStatsHelper$__constructor__(context, bl, bl2);
    }

    public BatteryStatsHelper(Context context, boolean bl, boolean bl2) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_os_BatteryStatsHelper$__constructor__(android.content.Context boolean boolean ), 0, this, context, bl, bl2);
    }

    public static boolean checkWifiOnly(Context context) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("checkWifiOnly", $$robo$$com_android_internal_os_BatteryStatsHelper$checkWifiOnly(android.content.Context ), 0, (Context)context);
    }

    public void storeStatsHistoryInFile(String string2) {
        InvokeDynamicSupport.bootstrap("storeStatsHistoryInFile", $$robo$$com_android_internal_os_BatteryStatsHelper$storeStatsHistoryInFile(java.lang.String ), 0, this, string2);
    }

    public static BatteryStats statsFromFile(Context context, String string2) {
        return InvokeDynamicSupport.bootstrapStatic("statsFromFile", $$robo$$com_android_internal_os_BatteryStatsHelper$statsFromFile(android.content.Context java.lang.String ), 0, (Context)context, (String)string2);
    }

    public static void dropFile(Context context, String string2) {
        InvokeDynamicSupport.bootstrapStatic("dropFile", $$robo$$com_android_internal_os_BatteryStatsHelper$dropFile(android.content.Context java.lang.String ), 0, (Context)context, (String)string2);
    }

    private static File makeFilePath(Context context, String string2) {
        return InvokeDynamicSupport.bootstrapStatic("makeFilePath", $$robo$$com_android_internal_os_BatteryStatsHelper$makeFilePath(android.content.Context java.lang.String ), 0, (Context)context, (String)string2);
    }

    public void clearStats() {
        InvokeDynamicSupport.bootstrap("clearStats", $$robo$$com_android_internal_os_BatteryStatsHelper$clearStats(), 0, this);
    }

    public BatteryStats getStats() {
        return InvokeDynamicSupport.bootstrap("getStats", $$robo$$com_android_internal_os_BatteryStatsHelper$getStats(), 0, this);
    }

    public Intent getBatteryBroadcast() {
        return InvokeDynamicSupport.bootstrap("getBatteryBroadcast", $$robo$$com_android_internal_os_BatteryStatsHelper$getBatteryBroadcast(), 0, this);
    }

    public PowerProfile getPowerProfile() {
        return InvokeDynamicSupport.bootstrap("getPowerProfile", $$robo$$com_android_internal_os_BatteryStatsHelper$getPowerProfile(), 0, this);
    }

    public void create(BatteryStats batteryStats) {
        InvokeDynamicSupport.bootstrap("create", $$robo$$com_android_internal_os_BatteryStatsHelper$create(android.os.BatteryStats ), 0, this, batteryStats);
    }

    public void create(Bundle bundle) {
        InvokeDynamicSupport.bootstrap("create", $$robo$$com_android_internal_os_BatteryStatsHelper$create(android.os.Bundle ), 0, this, bundle);
    }

    public void storeState() {
        InvokeDynamicSupport.bootstrap("storeState", $$robo$$com_android_internal_os_BatteryStatsHelper$storeState(), 0, this);
    }

    public static String makemAh(double d) {
        return InvokeDynamicSupport.bootstrapStatic("makemAh", $$robo$$com_android_internal_os_BatteryStatsHelper$makemAh(double ), 0, (double)d);
    }

    public void refreshStats(int n, int n2) {
        InvokeDynamicSupport.bootstrap("refreshStats", $$robo$$com_android_internal_os_BatteryStatsHelper$refreshStats(int int ), 0, this, n, n2);
    }

    public void refreshStats(int n, List<UserHandle> list) {
        InvokeDynamicSupport.bootstrap("refreshStats", $$robo$$com_android_internal_os_BatteryStatsHelper$refreshStats(int java.util.List<android.os.UserHandle> ), 0, this, n, list);
    }

    public void refreshStats(int n, SparseArray<UserHandle> sparseArray) {
        InvokeDynamicSupport.bootstrap("refreshStats", $$robo$$com_android_internal_os_BatteryStatsHelper$refreshStats(int android.util.SparseArray<android.os.UserHandle> ), 0, this, n, sparseArray);
    }

    public void refreshStats(int n, SparseArray<UserHandle> sparseArray, long l, long l2) {
        InvokeDynamicSupport.bootstrap("refreshStats", $$robo$$com_android_internal_os_BatteryStatsHelper$refreshStats(int android.util.SparseArray<android.os.UserHandle> long long ), 0, this, n, sparseArray, l, l2);
    }

    private void processAppUsage(SparseArray<UserHandle> sparseArray) {
        InvokeDynamicSupport.bootstrap("processAppUsage", $$robo$$com_android_internal_os_BatteryStatsHelper$processAppUsage(android.util.SparseArray<android.os.UserHandle> ), 0, this, sparseArray);
    }

    private void addPhoneUsage() {
        InvokeDynamicSupport.bootstrap("addPhoneUsage", $$robo$$com_android_internal_os_BatteryStatsHelper$addPhoneUsage(), 0, this);
    }

    private void addScreenUsage() {
        InvokeDynamicSupport.bootstrap("addScreenUsage", $$robo$$com_android_internal_os_BatteryStatsHelper$addScreenUsage(), 0, this);
    }

    private void addRadioUsage() {
        InvokeDynamicSupport.bootstrap("addRadioUsage", $$robo$$com_android_internal_os_BatteryStatsHelper$addRadioUsage(), 0, this);
    }

    private void aggregateSippers(BatterySipper batterySipper, List<BatterySipper> list, String string2) {
        InvokeDynamicSupport.bootstrap("aggregateSippers", $$robo$$com_android_internal_os_BatteryStatsHelper$aggregateSippers(com.android.internal.os.BatterySipper java.util.List<com.android.internal.os.BatterySipper> java.lang.String ), 0, this, batterySipper, list, string2);
    }

    private void addWiFiUsage() {
        InvokeDynamicSupport.bootstrap("addWiFiUsage", $$robo$$com_android_internal_os_BatteryStatsHelper$addWiFiUsage(), 0, this);
    }

    private void addIdleUsage() {
        InvokeDynamicSupport.bootstrap("addIdleUsage", $$robo$$com_android_internal_os_BatteryStatsHelper$addIdleUsage(), 0, this);
    }

    private void addBluetoothUsage() {
        InvokeDynamicSupport.bootstrap("addBluetoothUsage", $$robo$$com_android_internal_os_BatteryStatsHelper$addBluetoothUsage(), 0, this);
    }

    private void addFlashlightUsage() {
        InvokeDynamicSupport.bootstrap("addFlashlightUsage", $$robo$$com_android_internal_os_BatteryStatsHelper$addFlashlightUsage(), 0, this);
    }

    private void addUserUsage() {
        InvokeDynamicSupport.bootstrap("addUserUsage", $$robo$$com_android_internal_os_BatteryStatsHelper$addUserUsage(), 0, this);
    }

    private double getMobilePowerPerPacket() {
        return (double)InvokeDynamicSupport.bootstrap("getMobilePowerPerPacket", $$robo$$com_android_internal_os_BatteryStatsHelper$getMobilePowerPerPacket(), 0, this);
    }

    private double getMobilePowerPerMs() {
        return (double)InvokeDynamicSupport.bootstrap("getMobilePowerPerMs", $$robo$$com_android_internal_os_BatteryStatsHelper$getMobilePowerPerMs(), 0, this);
    }

    private double getWifiPowerPerPacket() {
        return (double)InvokeDynamicSupport.bootstrap("getWifiPowerPerPacket", $$robo$$com_android_internal_os_BatteryStatsHelper$getWifiPowerPerPacket(), 0, this);
    }

    private void processMiscUsage() {
        InvokeDynamicSupport.bootstrap("processMiscUsage", $$robo$$com_android_internal_os_BatteryStatsHelper$processMiscUsage(), 0, this);
    }

    private BatterySipper addEntry(BatterySipper.DrainType drainType, long l, double d) {
        return InvokeDynamicSupport.bootstrap("addEntry", $$robo$$com_android_internal_os_BatteryStatsHelper$addEntry(com.android.internal.os.BatterySipper$DrainType long double ), 0, this, drainType, l, d);
    }

    private BatterySipper addEntryNoTotal(BatterySipper.DrainType drainType, long l, double d) {
        return InvokeDynamicSupport.bootstrap("addEntryNoTotal", $$robo$$com_android_internal_os_BatteryStatsHelper$addEntryNoTotal(com.android.internal.os.BatterySipper$DrainType long double ), 0, this, drainType, l, d);
    }

    public List<BatterySipper> getUsageList() {
        return InvokeDynamicSupport.bootstrap("getUsageList", $$robo$$com_android_internal_os_BatteryStatsHelper$getUsageList(), 0, this);
    }

    public List<BatterySipper> getMobilemsppList() {
        return InvokeDynamicSupport.bootstrap("getMobilemsppList", $$robo$$com_android_internal_os_BatteryStatsHelper$getMobilemsppList(), 0, this);
    }

    public long getStatsPeriod() {
        return (long)InvokeDynamicSupport.bootstrap("getStatsPeriod", $$robo$$com_android_internal_os_BatteryStatsHelper$getStatsPeriod(), 0, this);
    }

    public int getStatsType() {
        return (int)InvokeDynamicSupport.bootstrap("getStatsType", $$robo$$com_android_internal_os_BatteryStatsHelper$getStatsType(), 0, this);
    }

    public double getMaxPower() {
        return (double)InvokeDynamicSupport.bootstrap("getMaxPower", $$robo$$com_android_internal_os_BatteryStatsHelper$getMaxPower(), 0, this);
    }

    public double getMaxRealPower() {
        return (double)InvokeDynamicSupport.bootstrap("getMaxRealPower", $$robo$$com_android_internal_os_BatteryStatsHelper$getMaxRealPower(), 0, this);
    }

    public double getTotalPower() {
        return (double)InvokeDynamicSupport.bootstrap("getTotalPower", $$robo$$com_android_internal_os_BatteryStatsHelper$getTotalPower(), 0, this);
    }

    public double getComputedPower() {
        return (double)InvokeDynamicSupport.bootstrap("getComputedPower", $$robo$$com_android_internal_os_BatteryStatsHelper$getComputedPower(), 0, this);
    }

    public double getMinDrainedPower() {
        return (double)InvokeDynamicSupport.bootstrap("getMinDrainedPower", $$robo$$com_android_internal_os_BatteryStatsHelper$getMinDrainedPower(), 0, this);
    }

    public double getMaxDrainedPower() {
        return (double)InvokeDynamicSupport.bootstrap("getMaxDrainedPower", $$robo$$com_android_internal_os_BatteryStatsHelper$getMaxDrainedPower(), 0, this);
    }

    public long getBatteryTimeRemaining() {
        return (long)InvokeDynamicSupport.bootstrap("getBatteryTimeRemaining", $$robo$$com_android_internal_os_BatteryStatsHelper$getBatteryTimeRemaining(), 0, this);
    }

    public long getChargeTimeRemaining() {
        return (long)InvokeDynamicSupport.bootstrap("getChargeTimeRemaining", $$robo$$com_android_internal_os_BatteryStatsHelper$getChargeTimeRemaining(), 0, this);
    }

    public static byte[] readFully(FileInputStream fileInputStream) throws IOException {
        return InvokeDynamicSupport.bootstrapStatic("readFully", $$robo$$com_android_internal_os_BatteryStatsHelper$readFully(java.io.FileInputStream ), 0, (FileInputStream)fileInputStream);
    }

    public static byte[] readFully(FileInputStream fileInputStream, int n) throws IOException {
        return InvokeDynamicSupport.bootstrapStatic("readFully", $$robo$$com_android_internal_os_BatteryStatsHelper$readFully(java.io.FileInputStream int ), 0, (FileInputStream)fileInputStream, (int)n);
    }

    private void load() {
        InvokeDynamicSupport.bootstrap("load", $$robo$$com_android_internal_os_BatteryStatsHelper$load(), 0, this);
    }

    private static BatteryStatsImpl getStats(IBatteryStats iBatteryStats) {
        return InvokeDynamicSupport.bootstrapStatic("getStats", $$robo$$com_android_internal_os_BatteryStatsHelper$getStats(com.android.internal.app.IBatteryStats ), 0, (IBatteryStats)iBatteryStats);
    }

    static {
        RobolectricInternals.classInitializing(BatteryStatsHelper.class);
    }

    public /* synthetic */ BatteryStatsHelper() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (BatteryStatsHelper)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

