/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.os;

import android.net.LocalSocket;
import android.net.LocalSocketAddress;
import android.util.Slog;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import libcore.io.IoUtils;
import libcore.io.Streams;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class InstallerConnection
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "InstallerConnection";
    private static boolean LOCAL_DEBUG = false;
    private InputStream mIn;
    private OutputStream mOut;
    private LocalSocket mSocket;
    private byte[] buf;

    private void $$robo$$com_android_internal_os_InstallerConnection$__constructor__() {
        this.buf = new byte[1024];
    }

    private final synchronized String $$robo$$com_android_internal_os_InstallerConnection$transact(String cmd) {
        int replyLength;
        if (!this.connect()) {
            Slog.e("InstallerConnection", "connection failed");
            return "-1";
        }
        if (!this.writeCommand(cmd)) {
            Slog.e("InstallerConnection", "write command failed? reconnect!");
            if (!this.connect() || !this.writeCommand(cmd)) {
                return "-1";
            }
        }
        if ((replyLength = this.readReply()) > 0) {
            String s = new String(this.buf, 0, replyLength);
            return s;
        }
        return "-1";
    }

    private final int $$robo$$com_android_internal_os_InstallerConnection$execute(String cmd) {
        String res = this.transact(cmd);
        try {
            return Integer.parseInt(res);
        }
        catch (NumberFormatException ex) {
            return -1;
        }
    }

    private final int $$robo$$com_android_internal_os_InstallerConnection$dexopt(String apkPath, int uid, boolean isPublic, String instructionSet) {
        return this.dexopt(apkPath, uid, isPublic, "*", instructionSet, false);
    }

    private final int $$robo$$com_android_internal_os_InstallerConnection$dexopt(String apkPath, int uid, boolean isPublic, String pkgName, String instructionSet, boolean vmSafeMode) {
        StringBuilder builder = new StringBuilder("dexopt");
        builder.append(' ');
        builder.append(apkPath);
        builder.append(' ');
        builder.append(uid);
        builder.append(isPublic ? " 1" : " 0");
        builder.append(' ');
        builder.append(pkgName);
        builder.append(' ');
        builder.append(instructionSet);
        builder.append(' ');
        builder.append(vmSafeMode ? " 1" : " 0");
        return this.execute(builder.toString());
    }

    private final int $$robo$$com_android_internal_os_InstallerConnection$patchoat(String apkPath, int uid, boolean isPublic, String instructionSet) {
        return this.patchoat(apkPath, uid, isPublic, "*", instructionSet);
    }

    private final int $$robo$$com_android_internal_os_InstallerConnection$patchoat(String apkPath, int uid, boolean isPublic, String pkgName, String instructionSet) {
        StringBuilder builder = new StringBuilder("patchoat");
        builder.append(' ');
        builder.append(apkPath);
        builder.append(' ');
        builder.append(uid);
        builder.append(isPublic ? " 1" : " 0");
        builder.append(' ');
        builder.append(pkgName);
        builder.append(' ');
        builder.append(instructionSet);
        return this.execute(builder.toString());
    }

    private final boolean $$robo$$com_android_internal_os_InstallerConnection$connect() {
        if (this.mSocket != null) {
            return true;
        }
        Slog.i("InstallerConnection", "connecting...");
        try {
            this.mSocket = new LocalSocket();
            LocalSocketAddress address = new LocalSocketAddress("installd", LocalSocketAddress.Namespace.RESERVED);
            this.mSocket.connect(address);
            this.mIn = this.mSocket.getInputStream();
            this.mOut = this.mSocket.getOutputStream();
        }
        catch (IOException ex) {
            this.disconnect();
            return false;
        }
        return true;
    }

    private final void $$robo$$com_android_internal_os_InstallerConnection$disconnect() {
        Slog.i("InstallerConnection", "disconnecting...");
        IoUtils.closeQuietly(this.mSocket);
        IoUtils.closeQuietly(this.mIn);
        IoUtils.closeQuietly(this.mOut);
        this.mSocket = null;
        this.mIn = null;
        this.mOut = null;
    }

    private final boolean $$robo$$com_android_internal_os_InstallerConnection$readFully(byte[] buffer, int len) {
        try {
            Streams.readFully(this.mIn, buffer, 0, len);
        }
        catch (IOException ioe) {
            Slog.e("InstallerConnection", "read exception");
            this.disconnect();
            return false;
        }
        return true;
    }

    private final int $$robo$$com_android_internal_os_InstallerConnection$readReply() {
        if (!this.readFully(this.buf, 2)) {
            return -1;
        }
        int len = this.buf[0] & 0xFF | (this.buf[1] & 0xFF) << 8;
        if (len < 1 || len > this.buf.length) {
            Slog.e("InstallerConnection", "invalid reply length (" + len + ")");
            this.disconnect();
            return -1;
        }
        if (!this.readFully(this.buf, len)) {
            return -1;
        }
        return len;
    }

    private final boolean $$robo$$com_android_internal_os_InstallerConnection$writeCommand(String cmdString) {
        byte[] cmd = cmdString.getBytes();
        int len = cmd.length;
        if (len < 1 || len > this.buf.length) {
            return false;
        }
        this.buf[0] = (byte)(len & 0xFF);
        this.buf[1] = (byte)(len >> 8 & 0xFF);
        try {
            this.mOut.write(this.buf, 0, 2);
            this.mOut.write(cmd, 0, len);
        }
        catch (IOException ex) {
            Slog.e("InstallerConnection", "write error");
            this.disconnect();
            return false;
        }
        return true;
    }

    private void __constructor__() {
        this.$$robo$$com_android_internal_os_InstallerConnection$__constructor__();
    }

    public InstallerConnection() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_os_InstallerConnection$__constructor__(), 0, this);
    }

    public synchronized String transact(String string2) {
        return InvokeDynamicSupport.bootstrap("transact", $$robo$$com_android_internal_os_InstallerConnection$transact(java.lang.String ), 0, this, string2);
    }

    public int execute(String string2) {
        return (int)InvokeDynamicSupport.bootstrap("execute", $$robo$$com_android_internal_os_InstallerConnection$execute(java.lang.String ), 0, this, string2);
    }

    public int dexopt(String string2, int n, boolean bl, String string3) {
        return (int)InvokeDynamicSupport.bootstrap("dexopt", $$robo$$com_android_internal_os_InstallerConnection$dexopt(java.lang.String int boolean java.lang.String ), 0, this, string2, n, bl, string3);
    }

    public int dexopt(String string2, int n, boolean bl, String string3, String string4, boolean bl2) {
        return (int)InvokeDynamicSupport.bootstrap("dexopt", $$robo$$com_android_internal_os_InstallerConnection$dexopt(java.lang.String int boolean java.lang.String java.lang.String boolean ), 0, this, string2, n, bl, string3, string4, bl2);
    }

    public int patchoat(String string2, int n, boolean bl, String string3) {
        return (int)InvokeDynamicSupport.bootstrap("patchoat", $$robo$$com_android_internal_os_InstallerConnection$patchoat(java.lang.String int boolean java.lang.String ), 0, this, string2, n, bl, string3);
    }

    public int patchoat(String string2, int n, boolean bl, String string3, String string4) {
        return (int)InvokeDynamicSupport.bootstrap("patchoat", $$robo$$com_android_internal_os_InstallerConnection$patchoat(java.lang.String int boolean java.lang.String java.lang.String ), 0, this, string2, n, bl, string3, string4);
    }

    private boolean connect() {
        return (boolean)InvokeDynamicSupport.bootstrap("connect", $$robo$$com_android_internal_os_InstallerConnection$connect(), 0, this);
    }

    public void disconnect() {
        InvokeDynamicSupport.bootstrap("disconnect", $$robo$$com_android_internal_os_InstallerConnection$disconnect(), 0, this);
    }

    private boolean readFully(byte[] byArray, int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("readFully", $$robo$$com_android_internal_os_InstallerConnection$readFully(byte[] int ), 0, this, byArray, n);
    }

    private int readReply() {
        return (int)InvokeDynamicSupport.bootstrap("readReply", $$robo$$com_android_internal_os_InstallerConnection$readReply(), 0, this);
    }

    private boolean writeCommand(String string2) {
        return (boolean)InvokeDynamicSupport.bootstrap("writeCommand", $$robo$$com_android_internal_os_InstallerConnection$writeCommand(java.lang.String ), 0, this, string2);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (InstallerConnection)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

