/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.os;

import android.content.Context;
import android.content.res.XmlResourceParser;
import com.android.internal.util.XmlUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;
import org.xmlpull.v1.XmlPullParserException;

public class PowerProfile
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    public static String POWER_NONE = "none";
    public static String POWER_CPU_IDLE = "cpu.idle";
    public static String POWER_CPU_AWAKE = "cpu.awake";
    public static String POWER_CPU_ACTIVE = "cpu.active";
    public static String POWER_WIFI_SCAN = "wifi.scan";
    public static String POWER_WIFI_ON = "wifi.on";
    public static String POWER_WIFI_ACTIVE = "wifi.active";
    public static String POWER_GPS_ON = "gps.on";
    public static String POWER_BLUETOOTH_ON = "bluetooth.on";
    public static String POWER_BLUETOOTH_ACTIVE = "bluetooth.active";
    public static String POWER_BLUETOOTH_AT_CMD = "bluetooth.at";
    public static String POWER_SCREEN_ON = "screen.on";
    public static String POWER_RADIO_ON = "radio.on";
    public static String POWER_RADIO_SCANNING = "radio.scanning";
    public static String POWER_RADIO_ACTIVE = "radio.active";
    public static String POWER_SCREEN_FULL = "screen.full";
    public static String POWER_AUDIO = "dsp.audio";
    public static String POWER_VIDEO = "dsp.video";
    public static String POWER_FLASHLIGHT = "camera.flashlight";
    public static String POWER_CPU_SPEEDS = "cpu.speeds";
    public static String POWER_WIFI_BATCHED_SCAN = "wifi.batchedscan";
    public static String POWER_BATTERY_CAPACITY = "battery.capacity";
    static HashMap<String, Object> sPowerMap;
    private static String TAG_DEVICE = "device";
    private static String TAG_ITEM = "item";
    private static String TAG_ARRAY = "array";
    private static String TAG_ARRAYITEM = "value";
    private static String ATTR_NAME = "name";

    private void $$robo$$com_android_internal_os_PowerProfile$__constructor__(Context context) {
        if (sPowerMap.size() == 0) {
            this.readPowerValuesFromXml(context);
        }
    }

    private final void $$robo$$com_android_internal_os_PowerProfile$readPowerValuesFromXml(Context context) {
        int id2 = 0x111000E;
        XmlResourceParser parser = context.getResources().getXml(id2);
        boolean parsingArray = false;
        ArrayList<Double> array2 = new ArrayList<Double>();
        String arrayName = null;
        try {
            XmlUtils.beginDocument(parser, "device");
            while (true) {
                XmlUtils.nextElement(parser);
                String element = parser.getName();
                if (element == null) break;
                if (parsingArray && !element.equals("value")) {
                    sPowerMap.put(arrayName, array2.toArray(new Double[array2.size()]));
                    parsingArray = false;
                }
                if (element.equals("array")) {
                    parsingArray = true;
                    array2.clear();
                    arrayName = parser.getAttributeValue(null, "name");
                    continue;
                }
                if (!element.equals("item") && !element.equals("value")) continue;
                String name = null;
                if (!parsingArray) {
                    name = parser.getAttributeValue(null, "name");
                }
                if (parser.next() != 4) continue;
                String power = parser.getText();
                double value = 0.0;
                try {
                    value = Double.valueOf(power);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                if (element.equals("item")) {
                    sPowerMap.put(name, value);
                    continue;
                }
                if (!parsingArray) continue;
                array2.add(value);
            }
            if (parsingArray) {
                sPowerMap.put(arrayName, array2.toArray(new Double[array2.size()]));
            }
        }
        catch (XmlPullParserException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            parser.close();
        }
    }

    private final double $$robo$$com_android_internal_os_PowerProfile$getAveragePower(String type) {
        if (sPowerMap.containsKey(type)) {
            Object data = sPowerMap.get(type);
            if (data instanceof Double[]) {
                return ((Double[])data)[0];
            }
            return (Double)sPowerMap.get(type);
        }
        return 0.0;
    }

    private final double $$robo$$com_android_internal_os_PowerProfile$getAveragePower(String type, int level) {
        if (sPowerMap.containsKey(type)) {
            Object data = sPowerMap.get(type);
            if (data instanceof Double[]) {
                Double[] values = (Double[])data;
                if (values.length > level && level >= 0) {
                    return values[level];
                }
                if (level < 0) {
                    return 0.0;
                }
                return values[values.length - 1];
            }
            return (Double)data;
        }
        return 0.0;
    }

    private final double $$robo$$com_android_internal_os_PowerProfile$getBatteryCapacity() {
        return this.getAveragePower("battery.capacity");
    }

    private final int $$robo$$com_android_internal_os_PowerProfile$getNumSpeedSteps() {
        Object value = sPowerMap.get("cpu.speeds");
        if (value != null && value instanceof Double[]) {
            return ((Double[])value).length;
        }
        return 1;
    }

    static void __staticInitializer__() {
        sPowerMap = new HashMap();
    }

    private void __constructor__(Context context) {
        this.$$robo$$com_android_internal_os_PowerProfile$__constructor__(context);
    }

    public PowerProfile(Context context) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_os_PowerProfile$__constructor__(android.content.Context ), 0, this, context);
    }

    private void readPowerValuesFromXml(Context context) {
        InvokeDynamicSupport.bootstrap("readPowerValuesFromXml", $$robo$$com_android_internal_os_PowerProfile$readPowerValuesFromXml(android.content.Context ), 0, this, context);
    }

    public double getAveragePower(String string2) {
        return (double)InvokeDynamicSupport.bootstrap("getAveragePower", $$robo$$com_android_internal_os_PowerProfile$getAveragePower(java.lang.String ), 0, this, string2);
    }

    public double getAveragePower(String string2, int n) {
        return (double)InvokeDynamicSupport.bootstrap("getAveragePower", $$robo$$com_android_internal_os_PowerProfile$getAveragePower(java.lang.String int ), 0, this, string2, n);
    }

    public double getBatteryCapacity() {
        return (double)InvokeDynamicSupport.bootstrap("getBatteryCapacity", $$robo$$com_android_internal_os_PowerProfile$getBatteryCapacity(), 0, this);
    }

    public int getNumSpeedSteps() {
        return (int)InvokeDynamicSupport.bootstrap("getNumSpeedSteps", $$robo$$com_android_internal_os_PowerProfile$getNumSpeedSteps(), 0, this);
    }

    static {
        RobolectricInternals.classInitializing(PowerProfile.class);
    }

    public /* synthetic */ PowerProfile() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (PowerProfile)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

