/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.os;

import android.content.pm.PackageInfo;
import android.os.Build;
import android.os.SystemProperties;
import android.util.Log;
import dalvik.system.profiler.BinaryHprofWriter;
import dalvik.system.profiler.SamplingProfiler;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.invoke.CallSite;
import java.util.Date;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicBoolean;
import libcore.io.IoUtils;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class SamplingProfilerIntegration
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "SamplingProfilerIntegration";
    public static String SNAPSHOT_DIR = "/data/snapshots";
    private static boolean enabled;
    private static Executor snapshotWriter;
    private static int samplingProfilerMilliseconds;
    private static int samplingProfilerDepth;
    private static AtomicBoolean pending;
    private static SamplingProfiler samplingProfiler;
    private static long startMillis;

    private void $$robo$$com_android_internal_os_SamplingProfilerIntegration$__constructor__() {
    }

    private static final boolean $$robo$$com_android_internal_os_SamplingProfilerIntegration$isEnabled() {
        return enabled;
    }

    private static final void $$robo$$com_android_internal_os_SamplingProfilerIntegration$start() {
        if (!enabled) {
            return;
        }
        if (samplingProfiler != null) {
            Log.e("SamplingProfilerIntegration", "SamplingProfilerIntegration already started at " + new Date(startMillis));
            return;
        }
        ThreadGroup group = Thread.currentThread().getThreadGroup();
        SamplingProfiler.ThreadSet threadSet = SamplingProfiler.newThreadGroupThreadSet(group);
        samplingProfiler = new SamplingProfiler(samplingProfilerDepth, threadSet);
        samplingProfiler.start(samplingProfilerMilliseconds);
        startMillis = (long)InvokeDynamicSupport.bootstrapIntrinsic("currentTimeMillis", "java.lang.System");
    }

    private static final void $$robo$$com_android_internal_os_SamplingProfilerIntegration$writeSnapshot(String processName, PackageInfo packageInfo) {
        if (!enabled) {
            return;
        }
        if (samplingProfiler == null) {
            Log.e("SamplingProfilerIntegration", "SamplingProfilerIntegration is not started");
            return;
        }
        if (pending.compareAndSet(false, true)) {
            snapshotWriter.execute(new Runnable(processName, packageInfo){
                public transient /* synthetic */ Object __robo_data__;
                /* synthetic */ String val$processName;
                /* synthetic */ PackageInfo val$packageInfo;

                private void $$robo$$com_android_internal_os_SamplingProfilerIntegration_2$__constructor__(String string2, PackageInfo packageInfo) {
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                private final void $$robo$$com_android_internal_os_SamplingProfilerIntegration_2$run() {
                    try {
                        SamplingProfilerIntegration.writeSnapshotFile(this.val$processName, this.val$packageInfo);
                    }
                    finally {
                        pending.set(false);
                    }
                }

                private void __constructor__(String string2, PackageInfo packageInfo) {
                    this.$$robo$$com_android_internal_os_SamplingProfilerIntegration_2$__constructor__(string2, packageInfo);
                }
                {
                    this.val$processName = string2;
                    this.val$packageInfo = packageInfo;
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_os_SamplingProfilerIntegration_2$__constructor__(java.lang.String android.content.pm.PackageInfo ), 0, this, string2, packageInfo);
                }

                @Override
                public void run() {
                    InvokeDynamicSupport.bootstrap("run", $$robo$$com_android_internal_os_SamplingProfilerIntegration_2$run(), 0, this);
                }
                {
                    this.$$robo$init();
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            });
        }
    }

    private static final void $$robo$$com_android_internal_os_SamplingProfilerIntegration$writeZygoteSnapshot() {
        if (!enabled) {
            return;
        }
        SamplingProfilerIntegration.writeSnapshotFile("zygote", null);
        samplingProfiler.shutdown();
        samplingProfiler = null;
        startMillis = 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void $$robo$$com_android_internal_os_SamplingProfilerIntegration$writeSnapshotFile(String processName, PackageInfo packageInfo) {
        if (!enabled) {
            return;
        }
        samplingProfiler.stop();
        String name = processName.replaceAll(":", ".");
        String path = "/data/snapshots/" + name + "-" + startMillis + ".snapshot";
        CallSite start = InvokeDynamicSupport.bootstrapIntrinsic("currentTimeMillis", "java.lang.System");
        BufferedOutputStream outputStream = null;
        try {
            outputStream = new BufferedOutputStream(new FileOutputStream(path));
            PrintStream printStream = new PrintStream(outputStream);
            SamplingProfilerIntegration.generateSnapshotHeader(name, packageInfo, printStream);
            if (printStream.checkError()) {
                throw new IOException();
            }
            BinaryHprofWriter.write(samplingProfiler.getHprofData(), outputStream);
        }
        catch (IOException iOException) {
            try {
                Log.e("SamplingProfilerIntegration", "Error writing snapshot to " + path, iOException);
            }
            catch (Throwable throwable) {
                IoUtils.closeQuietly(outputStream);
                throw throwable;
            }
            IoUtils.closeQuietly(outputStream);
            return;
        }
        IoUtils.closeQuietly(outputStream);
        new File(path).setReadable(true, false);
        reference var7_8 = InvokeDynamicSupport.bootstrapIntrinsic("currentTimeMillis", "java.lang.System") - start;
        Log.i("SamplingProfilerIntegration", "Wrote snapshot " + path + " in " + (long)var7_8 + "ms.");
        samplingProfiler.start(samplingProfilerMilliseconds);
    }

    private static final void $$robo$$com_android_internal_os_SamplingProfilerIntegration$generateSnapshotHeader(String processName, PackageInfo packageInfo, PrintStream out) {
        out.println("Version: 3");
        out.println("Process: " + processName);
        if (packageInfo != null) {
            out.println("Package: " + packageInfo.packageName);
            out.println("Package-Version: " + packageInfo.versionCode);
        }
        out.println("Build: " + Build.FINGERPRINT);
        out.println();
    }

    static void __staticInitializer__() {
        pending = new AtomicBoolean(false);
        samplingProfilerMilliseconds = SystemProperties.getInt("persist.sys.profiler_ms", 0);
        samplingProfilerDepth = SystemProperties.getInt("persist.sys.profiler_depth", 4);
        if (samplingProfilerMilliseconds > 0) {
            File dir = new File("/data/snapshots");
            dir.mkdirs();
            dir.setWritable(true, false);
            dir.setExecutable(true, false);
            if (dir.isDirectory()) {
                snapshotWriter = Executors.newSingleThreadExecutor(new ThreadFactory(){
                    public transient /* synthetic */ Object __robo_data__;

                    private void $$robo$$com_android_internal_os_SamplingProfilerIntegration_1$__constructor__() {
                    }

                    private final Thread $$robo$$com_android_internal_os_SamplingProfilerIntegration_1$newThread(Runnable r) {
                        return new Thread(r, "SamplingProfilerIntegration");
                    }

                    private void __constructor__() {
                        this.$$robo$$com_android_internal_os_SamplingProfilerIntegration_1$__constructor__();
                    }
                    {
                        this.$$robo$init();
                        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_os_SamplingProfilerIntegration_1$__constructor__(), 0, this);
                    }

                    @Override
                    public Thread newThread(Runnable runnable) {
                        return InvokeDynamicSupport.bootstrap("newThread", $$robo$$com_android_internal_os_SamplingProfilerIntegration_1$newThread(java.lang.Runnable ), 0, this, runnable);
                    }

                    protected /* synthetic */ void $$robo$init() {
                        if (this.__robo_data__ == null) {
                            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                        }
                    }

                    public /* synthetic */ Object $$robo$getData() {
                        return this.__robo_data__;
                    }
                });
                enabled = true;
                Log.i("SamplingProfilerIntegration", "Profiling enabled. Sampling interval ms: " + samplingProfilerMilliseconds);
            } else {
                snapshotWriter = null;
                enabled = true;
                Log.w("SamplingProfilerIntegration", "Profiling setup failed. Could not create /data/snapshots");
            }
        } else {
            snapshotWriter = null;
            enabled = false;
            Log.i("SamplingProfilerIntegration", "Profiling disabled.");
        }
    }

    private void __constructor__() {
        this.$$robo$$com_android_internal_os_SamplingProfilerIntegration$__constructor__();
    }

    public SamplingProfilerIntegration() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_os_SamplingProfilerIntegration$__constructor__(), 0, this);
    }

    public static boolean isEnabled() {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isEnabled", $$robo$$com_android_internal_os_SamplingProfilerIntegration$isEnabled(), 0);
    }

    public static void start() {
        InvokeDynamicSupport.bootstrapStatic("start", $$robo$$com_android_internal_os_SamplingProfilerIntegration$start(), 0);
    }

    public static void writeSnapshot(String string2, PackageInfo packageInfo) {
        InvokeDynamicSupport.bootstrapStatic("writeSnapshot", $$robo$$com_android_internal_os_SamplingProfilerIntegration$writeSnapshot(java.lang.String android.content.pm.PackageInfo ), 0, (String)string2, (PackageInfo)packageInfo);
    }

    public static void writeZygoteSnapshot() {
        InvokeDynamicSupport.bootstrapStatic("writeZygoteSnapshot", $$robo$$com_android_internal_os_SamplingProfilerIntegration$writeZygoteSnapshot(), 0);
    }

    private static void writeSnapshotFile(String string2, PackageInfo packageInfo) {
        InvokeDynamicSupport.bootstrapStatic("writeSnapshotFile", $$robo$$com_android_internal_os_SamplingProfilerIntegration$writeSnapshotFile(java.lang.String android.content.pm.PackageInfo ), 0, (String)string2, (PackageInfo)packageInfo);
    }

    private static void generateSnapshotHeader(String string2, PackageInfo packageInfo, PrintStream printStream) {
        InvokeDynamicSupport.bootstrapStatic("generateSnapshotHeader", $$robo$$com_android_internal_os_SamplingProfilerIntegration$generateSnapshotHeader(java.lang.String android.content.pm.PackageInfo java.io.PrintStream ), 0, (String)string2, (PackageInfo)packageInfo, (PrintStream)printStream);
    }

    static {
        RobolectricInternals.classInitializing(SamplingProfilerIntegration.class);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SamplingProfilerIntegration)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

