/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.os;

import android.net.Credentials;
import android.net.LocalSocket;
import android.os.Process;
import android.os.SELinux;
import android.os.SystemClock;
import android.os.SystemProperties;
import android.system.ErrnoException;
import android.system.Os;
import android.util.Log;
import android.util.Slog;
import com.android.internal.os.RuntimeInit;
import com.android.internal.os.WrapperInit;
import com.android.internal.os.Zygote;
import com.android.internal.os.ZygoteInit;
import com.android.internal.os.ZygoteSecurityException;
import dalvik.system.PathClassLoader;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import libcore.io.IoUtils;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class ZygoteConnection
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "Zygote";
    private static int[][] intArray2d;
    private static int CONNECTION_TIMEOUT_MILLIS = 1000;
    private static int MAX_ZYGOTE_ARGC = 1024;
    private LocalSocket mSocket;
    private DataOutputStream mSocketOutStream;
    private BufferedReader mSocketReader;
    private Credentials peer;
    private String peerSecurityContext;
    private String abiList;

    private void $$robo$$com_android_internal_os_ZygoteConnection$__constructor__(LocalSocket socket, String abiList) throws IOException {
        this.mSocket = socket;
        this.abiList = abiList;
        this.mSocketOutStream = new DataOutputStream(socket.getOutputStream());
        this.mSocketReader = new BufferedReader(new InputStreamReader(socket.getInputStream()), 256);
        this.mSocket.setSoTimeout(1000);
        try {
            this.peer = this.mSocket.getPeerCredentials();
        }
        catch (IOException ex) {
            Log.e("Zygote", "Cannot read peer credentials", ex);
            throw ex;
        }
        this.peerSecurityContext = SELinux.getPeerContext(this.mSocket.getFileDescriptor());
    }

    private final void $$robo$$com_android_internal_os_ZygoteConnection$checkTime(long startTime, String where) {
        long now = SystemClock.elapsedRealtime();
        if (now - startTime > 1000L) {
            Slog.w("Zygote", "Slow operation: " + (now - startTime) + "ms so far, now at " + where);
        }
    }

    private final FileDescriptor $$robo$$com_android_internal_os_ZygoteConnection$getFileDescriptor() {
        return this.mSocket.getFileDescriptor();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean $$robo$$com_android_internal_os_ZygoteConnection$runOnce() throws ZygoteInit.MethodAndArgsCaller {
        FileDescriptor[] descriptors;
        String[] args;
        Arguments parsedArgs = null;
        long startTime = SystemClock.elapsedRealtime();
        try {
            args = this.readArgumentList();
            descriptors = this.mSocket.getAncillaryFileDescriptors();
        }
        catch (IOException ex) {
            Log.w("Zygote", "IOException on command socket " + ex.getMessage());
            this.closeSocket();
            return true;
        }
        this.checkTime(startTime, "zygoteConnection.runOnce: readArgumentList");
        if (args == null) {
            this.closeSocket();
            return true;
        }
        PrintStream newStderr = null;
        if (descriptors != null && descriptors.length >= 3) {
            newStderr = new PrintStream(new FileOutputStream(descriptors[2]));
        }
        int pid = -1;
        FileDescriptor childPipeFd = null;
        FileDescriptor serverPipeFd = null;
        try {
            parsedArgs = new Arguments(args);
            if (parsedArgs.abiListQuery) {
                return this.handleAbiListQuery();
            }
            if (parsedArgs.permittedCapabilities != 0L || parsedArgs.effectiveCapabilities != 0L) {
                throw new ZygoteSecurityException("Client may not specify capabilities: permitted=0x" + Long.toHexString(parsedArgs.permittedCapabilities) + ", effective=0x" + Long.toHexString(parsedArgs.effectiveCapabilities));
            }
            ZygoteConnection.applyUidSecurityPolicy(parsedArgs, this.peer, this.peerSecurityContext);
            ZygoteConnection.applyRlimitSecurityPolicy(parsedArgs, this.peer, this.peerSecurityContext);
            ZygoteConnection.applyInvokeWithSecurityPolicy(parsedArgs, this.peer, this.peerSecurityContext);
            ZygoteConnection.applyseInfoSecurityPolicy(parsedArgs, this.peer, this.peerSecurityContext);
            this.checkTime(startTime, "zygoteConnection.runOnce: apply security policies");
            ZygoteConnection.applyDebuggerSystemProperty(parsedArgs);
            ZygoteConnection.applyInvokeWithSystemProperty(parsedArgs);
            this.checkTime(startTime, "zygoteConnection.runOnce: apply security policies");
            int[][] rlimits = null;
            if (parsedArgs.rlimits != null) {
                rlimits = (int[][])parsedArgs.rlimits.toArray((T[])intArray2d);
            }
            if (parsedArgs.runtimeInit && parsedArgs.invokeWith != null) {
                FileDescriptor[] pipeFds = Os.pipe();
                childPipeFd = pipeFds[1];
                serverPipeFd = pipeFds[0];
                ZygoteInit.setCloseOnExec(serverPipeFd, true);
            }
            int[] fdsToClose = new int[]{-1, -1};
            FileDescriptor fd = this.mSocket.getFileDescriptor();
            if (fd != null) {
                fdsToClose[0] = (int)InvokeDynamicSupport.bootstrapIntrinsic("getInt$", "java.io.FileDescriptor", (FileDescriptor)fd);
            }
            if ((fd = ZygoteInit.getServerSocketFileDescriptor()) != null) {
                fdsToClose[1] = (int)InvokeDynamicSupport.bootstrapIntrinsic("getInt$", "java.io.FileDescriptor", (FileDescriptor)fd);
            }
            fd = null;
            this.checkTime(startTime, "zygoteConnection.runOnce: preForkAndSpecialize");
            pid = Zygote.forkAndSpecialize(parsedArgs.uid, parsedArgs.gid, parsedArgs.gids, parsedArgs.debugFlags, rlimits, parsedArgs.mountExternal, parsedArgs.seInfo, parsedArgs.niceName, fdsToClose, parsedArgs.instructionSet, parsedArgs.appDataDir);
            this.checkTime(startTime, "zygoteConnection.runOnce: postForkAndSpecialize");
        }
        catch (IOException ex) {
            ZygoteConnection.logAndPrintError(newStderr, "Exception creating pipe", ex);
        }
        catch (ErrnoException ex) {
            ZygoteConnection.logAndPrintError(newStderr, "Exception creating pipe", ex);
        }
        catch (IllegalArgumentException ex) {
            ZygoteConnection.logAndPrintError(newStderr, "Invalid zygote arguments", ex);
        }
        catch (ZygoteSecurityException ex) {
            ZygoteConnection.logAndPrintError(newStderr, "Zygote security policy prevents request: ", ex);
        }
        try {
            if (pid == 0) {
                IoUtils.closeQuietly(serverPipeFd);
                serverPipeFd = null;
                this.handleChildProc(parsedArgs, descriptors, childPipeFd, newStderr);
                boolean bl = true;
                return bl;
            }
            IoUtils.closeQuietly(childPipeFd);
            childPipeFd = null;
            boolean bl = this.handleParentProc(pid, descriptors, serverPipeFd, parsedArgs);
            return bl;
        }
        finally {
            IoUtils.closeQuietly(childPipeFd);
            IoUtils.closeQuietly(serverPipeFd);
        }
    }

    private final boolean $$robo$$com_android_internal_os_ZygoteConnection$handleAbiListQuery() {
        try {
            byte[] abiListBytes = this.abiList.getBytes(StandardCharsets.US_ASCII);
            this.mSocketOutStream.writeInt(abiListBytes.length);
            this.mSocketOutStream.write(abiListBytes);
            return false;
        }
        catch (IOException ioe) {
            Log.e("Zygote", "Error writing to command socket", ioe);
            return true;
        }
    }

    private final void $$robo$$com_android_internal_os_ZygoteConnection$closeSocket() {
        try {
            this.mSocket.close();
        }
        catch (IOException ex) {
            Log.e("Zygote", "Exception while closing command socket in parent", ex);
        }
    }

    private final String[] $$robo$$com_android_internal_os_ZygoteConnection$readArgumentList() throws IOException {
        int argc;
        try {
            String s = this.mSocketReader.readLine();
            if (s == null) {
                return null;
            }
            argc = Integer.parseInt(s);
        }
        catch (NumberFormatException ex) {
            Log.e("Zygote", "invalid Zygote wire format: non-int at argc");
            throw new IOException("invalid wire format");
        }
        if (argc > 1024) {
            throw new IOException("max arg count exceeded");
        }
        String[] result = new String[argc];
        for (int i = 0; i < argc; ++i) {
            result[i] = this.mSocketReader.readLine();
            if (result[i] != null) continue;
            throw new IOException("truncated request");
        }
        return result;
    }

    private static final void $$robo$$com_android_internal_os_ZygoteConnection$applyUidSecurityPolicy(Arguments args, Credentials peer, String peerSecurityContext) throws ZygoteSecurityException {
        boolean allowed;
        int peerUid = peer.getUid();
        if (peerUid != 0) {
            if (peerUid == 1000) {
                boolean uidRestricted;
                String factoryTest = SystemProperties.get("ro.factorytest");
                boolean bl = uidRestricted = !factoryTest.equals("1") && !factoryTest.equals("2");
                if (uidRestricted && args.uidSpecified && args.uid < 1000) {
                    throw new ZygoteSecurityException("System UID may not launch process with UID < 1000");
                }
            } else if (args.uidSpecified || args.gidSpecified || args.gids != null) {
                throw new ZygoteSecurityException("App UIDs may not specify uid's or gid's");
            }
        }
        if ((args.uidSpecified || args.gidSpecified || args.gids != null) && !(allowed = SELinux.checkSELinuxAccess(peerSecurityContext, peerSecurityContext, "zygote", "specifyids"))) {
            throw new ZygoteSecurityException("Peer may not specify uid's or gid's");
        }
        if (!args.uidSpecified) {
            args.uid = peer.getUid();
            args.uidSpecified = true;
        }
        if (!args.gidSpecified) {
            args.gid = peer.getGid();
            args.gidSpecified = true;
        }
    }

    private static final void $$robo$$com_android_internal_os_ZygoteConnection$applyDebuggerSystemProperty(Arguments args) {
        if ("1".equals(SystemProperties.get("ro.debuggable"))) {
            args.debugFlags |= 1;
        }
    }

    private static final void $$robo$$com_android_internal_os_ZygoteConnection$applyRlimitSecurityPolicy(Arguments args, Credentials peer, String peerSecurityContext) throws ZygoteSecurityException {
        boolean allowed;
        int peerUid = peer.getUid();
        if (peerUid != 0 && peerUid != 1000 && args.rlimits != null) {
            throw new ZygoteSecurityException("This UID may not specify rlimits.");
        }
        if (args.rlimits != null && !(allowed = SELinux.checkSELinuxAccess(peerSecurityContext, peerSecurityContext, "zygote", "specifyrlimits"))) {
            throw new ZygoteSecurityException("Peer may not specify rlimits");
        }
    }

    private static final void $$robo$$com_android_internal_os_ZygoteConnection$applyInvokeWithSecurityPolicy(Arguments args, Credentials peer, String peerSecurityContext) throws ZygoteSecurityException {
        boolean allowed;
        int peerUid = peer.getUid();
        if (args.invokeWith != null && peerUid != 0) {
            throw new ZygoteSecurityException("Peer is not permitted to specify an explicit invoke-with wrapper command");
        }
        if (args.invokeWith != null && !(allowed = SELinux.checkSELinuxAccess(peerSecurityContext, peerSecurityContext, "zygote", "specifyinvokewith"))) {
            throw new ZygoteSecurityException("Peer is not permitted to specify an explicit invoke-with wrapper command");
        }
    }

    private static final void $$robo$$com_android_internal_os_ZygoteConnection$applyseInfoSecurityPolicy(Arguments args, Credentials peer, String peerSecurityContext) throws ZygoteSecurityException {
        int peerUid = peer.getUid();
        if (args.seInfo == null) {
            return;
        }
        if (peerUid != 0 && peerUid != 1000) {
            throw new ZygoteSecurityException("This UID may not specify SELinux info.");
        }
        boolean allowed = SELinux.checkSELinuxAccess(peerSecurityContext, peerSecurityContext, "zygote", "specifyseinfo");
        if (!allowed) {
            throw new ZygoteSecurityException("Peer may not specify SELinux info");
        }
    }

    private static final void $$robo$$com_android_internal_os_ZygoteConnection$applyInvokeWithSystemProperty(Arguments args) {
        if (args.invokeWith == null && args.niceName != null && args.niceName != null) {
            String property = "wrap." + args.niceName;
            if (property.length() > 31) {
                property = property.substring(0, 31);
            }
            args.invokeWith = SystemProperties.get(property);
            if (args.invokeWith != null && args.invokeWith.length() == 0) {
                args.invokeWith = null;
            }
        }
    }

    private final void $$robo$$com_android_internal_os_ZygoteConnection$handleChildProc(Arguments parsedArgs, FileDescriptor[] descriptors, FileDescriptor pipeFd, PrintStream newStderr) throws ZygoteInit.MethodAndArgsCaller {
        this.closeSocket();
        ZygoteInit.closeServerSocket();
        if (descriptors != null) {
            try {
                ZygoteInit.reopenStdio(descriptors[0], descriptors[1], descriptors[2]);
                for (FileDescriptor fd : descriptors) {
                    IoUtils.closeQuietly(fd);
                }
                newStderr = System.err;
            }
            catch (IOException ex) {
                Log.e("Zygote", "Error reopening stdio", ex);
            }
        }
        if (parsedArgs.niceName != null) {
            Process.setArgV0(parsedArgs.niceName);
        }
        if (parsedArgs.runtimeInit) {
            if (parsedArgs.invokeWith != null) {
                WrapperInit.execApplication(parsedArgs.invokeWith, parsedArgs.niceName, parsedArgs.targetSdkVersion, pipeFd, parsedArgs.remainingArgs);
            } else {
                RuntimeInit.zygoteInit(parsedArgs.targetSdkVersion, parsedArgs.remainingArgs, null);
            }
        } else {
            String className;
            try {
                className = parsedArgs.remainingArgs[0];
            }
            catch (ArrayIndexOutOfBoundsException ex) {
                ZygoteConnection.logAndPrintError(newStderr, "Missing required class name argument", null);
                return;
            }
            String[] mainArgs = new String[parsedArgs.remainingArgs.length - 1];
            InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (Object)parsedArgs.remainingArgs, (int)1, (Object)mainArgs, (int)0, (int)mainArgs.length);
            if (parsedArgs.invokeWith != null) {
                WrapperInit.execStandalone(parsedArgs.invokeWith, parsedArgs.classpath, className, mainArgs);
            } else {
                ClassLoader cloader = parsedArgs.classpath != null ? new PathClassLoader(parsedArgs.classpath, ClassLoader.getSystemClassLoader()) : ClassLoader.getSystemClassLoader();
                try {
                    ZygoteInit.invokeStaticMain(cloader, className, mainArgs);
                }
                catch (RuntimeException ex) {
                    ZygoteConnection.logAndPrintError(newStderr, "Error starting.", ex);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean $$robo$$com_android_internal_os_ZygoteConnection$handleParentProc(int pid, FileDescriptor[] descriptors, FileDescriptor pipeFd, Arguments parsedArgs) {
        if (pid > 0) {
            this.setChildPgid(pid);
        }
        if (descriptors != null) {
            for (FileDescriptor fd : descriptors) {
                IoUtils.closeQuietly(fd);
            }
        }
        boolean usingWrapper = false;
        if (pipeFd != null && pid > 0) {
            DataInputStream is = new DataInputStream(new FileInputStream(pipeFd));
            int innerPid = -1;
            try {
                innerPid = is.readInt();
            }
            catch (IOException ex) {
                Log.w("Zygote", "Error reading pid from wrapped process, child may have died", ex);
            }
            finally {
                try {
                    is.close();
                }
                catch (IOException ex) {}
            }
            if (innerPid > 0) {
                int parentPid = innerPid;
                while (parentPid > 0 && parentPid != pid) {
                    parentPid = Process.getParentPid(parentPid);
                }
                if (parentPid > 0) {
                    Log.i("Zygote", "Wrapped process has pid " + innerPid);
                    pid = innerPid;
                    usingWrapper = true;
                } else {
                    Log.w("Zygote", "Wrapped process reported a pid that is not a child of the process that we forked: childPid=" + pid + " innerPid=" + innerPid);
                }
            }
        }
        try {
            this.mSocketOutStream.writeInt(pid);
            this.mSocketOutStream.writeBoolean(usingWrapper);
        }
        catch (IOException ex) {
            Log.e("Zygote", "Error writing to command socket", ex);
            return true;
        }
        return false;
    }

    private final void $$robo$$com_android_internal_os_ZygoteConnection$setChildPgid(int pid) {
        try {
            ZygoteInit.setpgid(pid, ZygoteInit.getpgid(this.peer.getPid()));
        }
        catch (IOException ex) {
            Log.i("Zygote", "Zygote: setpgid failed. This is normal if peer is not in our session");
        }
    }

    private static final void $$robo$$com_android_internal_os_ZygoteConnection$logAndPrintError(PrintStream newStderr, String message, Throwable ex) {
        Log.e("Zygote", message, ex);
        if (newStderr != null) {
            newStderr.println(message + (ex == null ? "" : ex));
        }
    }

    static void __staticInitializer__() {
        intArray2d = new int[0][0];
    }

    private void __constructor__(LocalSocket localSocket, String string2) throws IOException {
        this.$$robo$$com_android_internal_os_ZygoteConnection$__constructor__(localSocket, string2);
    }

    ZygoteConnection(LocalSocket localSocket, String string2) throws IOException {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_os_ZygoteConnection$__constructor__(android.net.LocalSocket java.lang.String ), 0, this, localSocket, string2);
    }

    private void checkTime(long l, String string2) {
        InvokeDynamicSupport.bootstrap("checkTime", $$robo$$com_android_internal_os_ZygoteConnection$checkTime(long java.lang.String ), 0, this, l, string2);
    }

    FileDescriptor getFileDescriptor() {
        return InvokeDynamicSupport.bootstrap("getFileDescriptor", $$robo$$com_android_internal_os_ZygoteConnection$getFileDescriptor(), 0, this);
    }

    boolean runOnce() throws ZygoteInit.MethodAndArgsCaller {
        return (boolean)InvokeDynamicSupport.bootstrap("runOnce", $$robo$$com_android_internal_os_ZygoteConnection$runOnce(), 0, this);
    }

    private boolean handleAbiListQuery() {
        return (boolean)InvokeDynamicSupport.bootstrap("handleAbiListQuery", $$robo$$com_android_internal_os_ZygoteConnection$handleAbiListQuery(), 0, this);
    }

    void closeSocket() {
        InvokeDynamicSupport.bootstrap("closeSocket", $$robo$$com_android_internal_os_ZygoteConnection$closeSocket(), 0, this);
    }

    private String[] readArgumentList() throws IOException {
        return InvokeDynamicSupport.bootstrap("readArgumentList", $$robo$$com_android_internal_os_ZygoteConnection$readArgumentList(), 0, this);
    }

    private static void applyUidSecurityPolicy(Arguments arguments, Credentials credentials, String string2) throws ZygoteSecurityException {
        InvokeDynamicSupport.bootstrapStatic("applyUidSecurityPolicy", $$robo$$com_android_internal_os_ZygoteConnection$applyUidSecurityPolicy(com.android.internal.os.ZygoteConnection$Arguments android.net.Credentials java.lang.String ), 0, (Arguments)arguments, (Credentials)credentials, (String)string2);
    }

    public static void applyDebuggerSystemProperty(Arguments arguments) {
        InvokeDynamicSupport.bootstrapStatic("applyDebuggerSystemProperty", $$robo$$com_android_internal_os_ZygoteConnection$applyDebuggerSystemProperty(com.android.internal.os.ZygoteConnection$Arguments ), 0, (Arguments)arguments);
    }

    private static void applyRlimitSecurityPolicy(Arguments arguments, Credentials credentials, String string2) throws ZygoteSecurityException {
        InvokeDynamicSupport.bootstrapStatic("applyRlimitSecurityPolicy", $$robo$$com_android_internal_os_ZygoteConnection$applyRlimitSecurityPolicy(com.android.internal.os.ZygoteConnection$Arguments android.net.Credentials java.lang.String ), 0, (Arguments)arguments, (Credentials)credentials, (String)string2);
    }

    private static void applyInvokeWithSecurityPolicy(Arguments arguments, Credentials credentials, String string2) throws ZygoteSecurityException {
        InvokeDynamicSupport.bootstrapStatic("applyInvokeWithSecurityPolicy", $$robo$$com_android_internal_os_ZygoteConnection$applyInvokeWithSecurityPolicy(com.android.internal.os.ZygoteConnection$Arguments android.net.Credentials java.lang.String ), 0, (Arguments)arguments, (Credentials)credentials, (String)string2);
    }

    private static void applyseInfoSecurityPolicy(Arguments arguments, Credentials credentials, String string2) throws ZygoteSecurityException {
        InvokeDynamicSupport.bootstrapStatic("applyseInfoSecurityPolicy", $$robo$$com_android_internal_os_ZygoteConnection$applyseInfoSecurityPolicy(com.android.internal.os.ZygoteConnection$Arguments android.net.Credentials java.lang.String ), 0, (Arguments)arguments, (Credentials)credentials, (String)string2);
    }

    public static void applyInvokeWithSystemProperty(Arguments arguments) {
        InvokeDynamicSupport.bootstrapStatic("applyInvokeWithSystemProperty", $$robo$$com_android_internal_os_ZygoteConnection$applyInvokeWithSystemProperty(com.android.internal.os.ZygoteConnection$Arguments ), 0, (Arguments)arguments);
    }

    private void handleChildProc(Arguments arguments, FileDescriptor[] fileDescriptorArray, FileDescriptor fileDescriptor, PrintStream printStream) throws ZygoteInit.MethodAndArgsCaller {
        InvokeDynamicSupport.bootstrap("handleChildProc", $$robo$$com_android_internal_os_ZygoteConnection$handleChildProc(com.android.internal.os.ZygoteConnection$Arguments java.io.FileDescriptor[] java.io.FileDescriptor java.io.PrintStream ), 0, this, arguments, fileDescriptorArray, fileDescriptor, printStream);
    }

    private boolean handleParentProc(int n, FileDescriptor[] fileDescriptorArray, FileDescriptor fileDescriptor, Arguments arguments) {
        return (boolean)InvokeDynamicSupport.bootstrap("handleParentProc", $$robo$$com_android_internal_os_ZygoteConnection$handleParentProc(int java.io.FileDescriptor[] java.io.FileDescriptor com.android.internal.os.ZygoteConnection$Arguments ), 0, this, n, fileDescriptorArray, fileDescriptor, arguments);
    }

    private void setChildPgid(int n) {
        InvokeDynamicSupport.bootstrap("setChildPgid", $$robo$$com_android_internal_os_ZygoteConnection$setChildPgid(int ), 0, this, n);
    }

    private static void logAndPrintError(PrintStream printStream, String string2, Throwable throwable) {
        InvokeDynamicSupport.bootstrapStatic("logAndPrintError", $$robo$$com_android_internal_os_ZygoteConnection$logAndPrintError(java.io.PrintStream java.lang.String java.lang.Throwable ), 0, (PrintStream)printStream, (String)string2, (Throwable)throwable);
    }

    static {
        RobolectricInternals.classInitializing(ZygoteConnection.class);
    }

    public /* synthetic */ ZygoteConnection() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ZygoteConnection)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static class Arguments
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        int uid;
        boolean uidSpecified;
        int gid;
        boolean gidSpecified;
        int[] gids;
        int debugFlags;
        int mountExternal;
        int targetSdkVersion;
        boolean targetSdkVersionSpecified;
        String classpath;
        boolean runtimeInit;
        String niceName;
        boolean capabilitiesSpecified;
        long permittedCapabilities;
        long effectiveCapabilities;
        boolean seInfoSpecified;
        String seInfo;
        ArrayList<int[]> rlimits;
        String invokeWith;
        String[] remainingArgs;
        boolean abiListQuery;
        String instructionSet;
        String appDataDir;

        private void $$robo$$com_android_internal_os_ZygoteConnection_Arguments$__constructor__(String[] args) throws IllegalArgumentException {
            this.uid = 0;
            this.gid = 0;
            this.mountExternal = 0;
            this.parseArgs(args);
        }

        private final void $$robo$$com_android_internal_os_ZygoteConnection_Arguments$parseArgs(String[] args) throws IllegalArgumentException {
            int curArg;
            for (curArg = 0; curArg < args.length; ++curArg) {
                String arg = args[curArg];
                if (arg.equals("--")) {
                    ++curArg;
                    break;
                }
                if (arg.startsWith("--setuid=")) {
                    if (this.uidSpecified) {
                        throw new IllegalArgumentException("Duplicate arg specified");
                    }
                    this.uidSpecified = true;
                    this.uid = Integer.parseInt(arg.substring(arg.indexOf(61) + 1));
                    continue;
                }
                if (arg.startsWith("--setgid=")) {
                    if (this.gidSpecified) {
                        throw new IllegalArgumentException("Duplicate arg specified");
                    }
                    this.gidSpecified = true;
                    this.gid = Integer.parseInt(arg.substring(arg.indexOf(61) + 1));
                    continue;
                }
                if (arg.startsWith("--target-sdk-version=")) {
                    if (this.targetSdkVersionSpecified) {
                        throw new IllegalArgumentException("Duplicate target-sdk-version specified");
                    }
                    this.targetSdkVersionSpecified = true;
                    this.targetSdkVersion = Integer.parseInt(arg.substring(arg.indexOf(61) + 1));
                    continue;
                }
                if (arg.equals("--enable-debugger")) {
                    this.debugFlags |= 1;
                    continue;
                }
                if (arg.equals("--enable-safemode")) {
                    this.debugFlags |= 8;
                    continue;
                }
                if (arg.equals("--enable-checkjni")) {
                    this.debugFlags |= 2;
                    continue;
                }
                if (arg.equals("--enable-jni-logging")) {
                    this.debugFlags |= 0x10;
                    continue;
                }
                if (arg.equals("--enable-assert")) {
                    this.debugFlags |= 4;
                    continue;
                }
                if (arg.equals("--runtime-init")) {
                    this.runtimeInit = true;
                    continue;
                }
                if (arg.startsWith("--seinfo=")) {
                    if (this.seInfoSpecified) {
                        throw new IllegalArgumentException("Duplicate arg specified");
                    }
                    this.seInfoSpecified = true;
                    this.seInfo = arg.substring(arg.indexOf(61) + 1);
                    continue;
                }
                if (arg.startsWith("--capabilities=")) {
                    if (this.capabilitiesSpecified) {
                        throw new IllegalArgumentException("Duplicate arg specified");
                    }
                    this.capabilitiesSpecified = true;
                    String capString = arg.substring(arg.indexOf(61) + 1);
                    String[] capStrings = capString.split(",", 2);
                    if (capStrings.length == 1) {
                        this.permittedCapabilities = this.effectiveCapabilities = Long.decode(capStrings[0]).longValue();
                        continue;
                    }
                    this.permittedCapabilities = Long.decode(capStrings[0]);
                    this.effectiveCapabilities = Long.decode(capStrings[1]);
                    continue;
                }
                if (arg.startsWith("--rlimit=")) {
                    String[] limitStrings = arg.substring(arg.indexOf(61) + 1).split(",");
                    if (limitStrings.length != 3) {
                        throw new IllegalArgumentException("--rlimit= should have 3 comma-delimited ints");
                    }
                    int[] rlimitTuple = new int[limitStrings.length];
                    for (int i = 0; i < limitStrings.length; ++i) {
                        rlimitTuple[i] = Integer.parseInt(limitStrings[i]);
                    }
                    if (this.rlimits == null) {
                        this.rlimits = new ArrayList();
                    }
                    this.rlimits.add(rlimitTuple);
                    continue;
                }
                if (arg.equals("-classpath")) {
                    if (this.classpath != null) {
                        throw new IllegalArgumentException("Duplicate arg specified");
                    }
                    try {
                        this.classpath = args[++curArg];
                        continue;
                    }
                    catch (IndexOutOfBoundsException ex) {
                        throw new IllegalArgumentException("-classpath requires argument");
                    }
                }
                if (arg.startsWith("--setgroups=")) {
                    if (this.gids != null) {
                        throw new IllegalArgumentException("Duplicate arg specified");
                    }
                    String[] params = arg.substring(arg.indexOf(61) + 1).split(",");
                    this.gids = new int[params.length];
                    for (int i = params.length - 1; i >= 0; --i) {
                        this.gids[i] = Integer.parseInt(params[i]);
                    }
                    continue;
                }
                if (arg.equals("--invoke-with")) {
                    if (this.invokeWith != null) {
                        throw new IllegalArgumentException("Duplicate arg specified");
                    }
                    try {
                        this.invokeWith = args[++curArg];
                        continue;
                    }
                    catch (IndexOutOfBoundsException ex) {
                        throw new IllegalArgumentException("--invoke-with requires argument");
                    }
                }
                if (arg.startsWith("--nice-name=")) {
                    if (this.niceName != null) {
                        throw new IllegalArgumentException("Duplicate arg specified");
                    }
                    this.niceName = arg.substring(arg.indexOf(61) + 1);
                    continue;
                }
                if (arg.equals("--mount-external-multiuser")) {
                    this.mountExternal = 2;
                    continue;
                }
                if (arg.equals("--mount-external-multiuser-all")) {
                    this.mountExternal = 3;
                    continue;
                }
                if (arg.equals("--query-abi-list")) {
                    this.abiListQuery = true;
                    continue;
                }
                if (arg.startsWith("--instruction-set=")) {
                    this.instructionSet = arg.substring(arg.indexOf(61) + 1);
                    continue;
                }
                if (!arg.startsWith("--app-data-dir=")) break;
                this.appDataDir = arg.substring(arg.indexOf(61) + 1);
            }
            if (this.runtimeInit && this.classpath != null) {
                throw new IllegalArgumentException("--runtime-init and -classpath are incompatible");
            }
            this.remainingArgs = new String[args.length - curArg];
            InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (Object)args, (int)curArg, (Object)this.remainingArgs, (int)0, (int)this.remainingArgs.length);
        }

        private void __constructor__(String[] stringArray) throws IllegalArgumentException {
            this.$$robo$$com_android_internal_os_ZygoteConnection_Arguments$__constructor__(stringArray);
        }

        Arguments(String[] stringArray) throws IllegalArgumentException {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_os_ZygoteConnection_Arguments$__constructor__(java.lang.String[] ), 0, this, stringArray);
        }

        private void parseArgs(String[] stringArray) throws IllegalArgumentException {
            InvokeDynamicSupport.bootstrap("parseArgs", $$robo$$com_android_internal_os_ZygoteConnection_Arguments$parseArgs(java.lang.String[] ), 0, this, stringArray);
        }

        public /* synthetic */ Arguments() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Arguments)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

