/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.os;

import android.content.res.Resources;
import android.content.res.TypedArray;
import android.net.LocalServerSocket;
import android.opengl.EGL14;
import android.os.Debug;
import android.os.Process;
import android.os.SystemClock;
import android.os.SystemProperties;
import android.os.Trace;
import android.system.ErrnoException;
import android.system.Os;
import android.system.OsConstants;
import android.util.EventLog;
import android.util.Log;
import android.webkit.WebViewFactory;
import com.android.internal.os.InstallerConnection;
import com.android.internal.os.RuntimeInit;
import com.android.internal.os.SamplingProfilerIntegration;
import com.android.internal.os.WrapperInit;
import com.android.internal.os.Zygote;
import com.android.internal.os.ZygoteConnection;
import dalvik.system.DexFile;
import dalvik.system.PathClassLoader;
import dalvik.system.VMRuntime;
import java.io.BufferedReader;
import java.io.FileDescriptor;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import libcore.io.IoUtils;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class ZygoteInit
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "Zygote";
    private static String PROPERTY_DISABLE_OPENGL_PRELOADING = "ro.zygote.disable_gl_preload";
    private static String ANDROID_SOCKET_PREFIX = "ANDROID_SOCKET_";
    private static int LOG_BOOT_PROGRESS_PRELOAD_START = 3020;
    private static int LOG_BOOT_PROGRESS_PRELOAD_END = 3030;
    private static int PRELOAD_GC_THRESHOLD = 50000;
    private static String ABI_LIST_ARG = "--abi-list=";
    private static String SOCKET_NAME_ARG = "--socket-name=";
    private static LocalServerSocket sServerSocket;
    private static Resources mResources;
    static int GC_LOOP_COUNT = 10;
    private static String PRELOADED_CLASSES = "preloaded-classes";
    private static boolean PRELOAD_RESOURCES = true;
    private static int UNPRIVILEGED_UID = 9999;
    private static int UNPRIVILEGED_GID = 9999;
    private static int ROOT_UID = 0;
    private static int ROOT_GID = 0;

    private static final void $$robo$$com_android_internal_os_ZygoteInit$invokeStaticMain(ClassLoader loader, String className, String[] argv) throws MethodAndArgsCaller {
        Method m;
        Class<?> cl;
        try {
            cl = loader.loadClass(className);
        }
        catch (ClassNotFoundException ex) {
            throw new RuntimeException("Missing class when invoking static main " + className, ex);
        }
        try {
            m = cl.getMethod("main", String[].class);
        }
        catch (NoSuchMethodException ex) {
            throw new RuntimeException("Missing static main on " + className, ex);
        }
        catch (SecurityException ex) {
            throw new RuntimeException("Problem getting static main on " + className, ex);
        }
        int modifiers = m.getModifiers();
        if (!Modifier.isStatic(modifiers) || !Modifier.isPublic(modifiers)) {
            throw new RuntimeException("Main method is not public and static on " + className);
        }
        throw new MethodAndArgsCaller(m, argv);
    }

    private static final void $$robo$$com_android_internal_os_ZygoteInit$registerZygoteSocket(String socketName) {
        if (sServerSocket == null) {
            int fileDesc;
            String fullSocketName = "ANDROID_SOCKET_" + socketName;
            try {
                String env = System.getenv(fullSocketName);
                fileDesc = Integer.parseInt(env);
            }
            catch (RuntimeException ex) {
                throw new RuntimeException(fullSocketName + " unset or invalid", ex);
            }
            try {
                sServerSocket = new LocalServerSocket(ZygoteInit.createFileDescriptor(fileDesc));
            }
            catch (IOException ex) {
                throw new RuntimeException("Error binding to local socket '" + fileDesc + "'", ex);
            }
        }
    }

    private static final ZygoteConnection $$robo$$com_android_internal_os_ZygoteInit$acceptCommandPeer(String abiList) {
        try {
            return new ZygoteConnection(sServerSocket.accept(), abiList);
        }
        catch (IOException ex) {
            throw new RuntimeException("IOException during accept()", ex);
        }
    }

    private static final void $$robo$$com_android_internal_os_ZygoteInit$closeServerSocket() {
        try {
            if (sServerSocket != null) {
                FileDescriptor fd = sServerSocket.getFileDescriptor();
                sServerSocket.close();
                if (fd != null) {
                    Os.close(fd);
                }
            }
        }
        catch (IOException ex) {
            Log.e("Zygote", "Zygote:  error closing sockets", ex);
        }
        catch (ErrnoException ex) {
            Log.e("Zygote", "Zygote:  error closing descriptor", ex);
        }
        sServerSocket = null;
    }

    private static final FileDescriptor $$robo$$com_android_internal_os_ZygoteInit$getServerSocketFileDescriptor() {
        return sServerSocket.getFileDescriptor();
    }

    private static final void $$robo$$com_android_internal_os_ZygoteInit$setEffectiveUser(int uid) {
        int errno = ZygoteInit.setreuid(0, uid);
        if (errno != 0) {
            Log.e("Zygote", "setreuid() failed. errno: " + errno);
        }
    }

    private static final void $$robo$$com_android_internal_os_ZygoteInit$setEffectiveGroup(int gid) {
        int errno = ZygoteInit.setregid(0, gid);
        if (errno != 0) {
            Log.e("Zygote", "setregid() failed. errno: " + errno);
        }
    }

    private static final void $$robo$$com_android_internal_os_ZygoteInit$preload() {
        Log.d("Zygote", "begin preload");
        ZygoteInit.preloadClasses();
        ZygoteInit.preloadResources();
        ZygoteInit.preloadOpenGL();
        ZygoteInit.preloadSharedLibraries();
        WebViewFactory.prepareWebViewInZygote();
        Log.d("Zygote", "end preload");
    }

    private static final void $$robo$$com_android_internal_os_ZygoteInit$preloadSharedLibraries() {
        Log.i("Zygote", "Preloading shared libraries...");
        InvokeDynamicSupport.bootstrapIntrinsic("loadLibrary", "java.lang.System", (String)"android");
        InvokeDynamicSupport.bootstrapIntrinsic("loadLibrary", "java.lang.System", (String)"compiler_rt");
        InvokeDynamicSupport.bootstrapIntrinsic("loadLibrary", "java.lang.System", (String)"jnigraphics");
    }

    private static final void $$robo$$com_android_internal_os_ZygoteInit$preloadOpenGL() {
        if (!SystemProperties.getBoolean("ro.zygote.disable_gl_preload", false)) {
            EGL14.eglGetDisplay(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void $$robo$$com_android_internal_os_ZygoteInit$preloadClasses() {
        VMRuntime runtime = VMRuntime.getRuntime();
        InputStream is = ClassLoader.getSystemClassLoader().getResourceAsStream("preloaded-classes");
        if (is == null) {
            Log.e("Zygote", "Couldn't find preloaded-classes.");
        } else {
            Log.i("Zygote", "Preloading classes...");
            long startTime = SystemClock.uptimeMillis();
            ZygoteInit.setEffectiveGroup(9999);
            ZygoteInit.setEffectiveUser(9999);
            float defaultUtilization = runtime.getTargetHeapUtilization();
            runtime.setTargetHeapUtilization(0.8f);
            System.gc();
            runtime.runFinalizationSync();
            Debug.startAllocCounting();
            try {
                String line;
                BufferedReader br = new BufferedReader(new InputStreamReader(is), 256);
                int count = 0;
                while ((line = br.readLine()) != null) {
                    if ((line = line.trim()).startsWith("#") || line.equals("")) continue;
                    try {
                        Class.forName(line);
                        if (Debug.getGlobalAllocSize() > 50000) {
                            System.gc();
                            runtime.runFinalizationSync();
                            Debug.resetGlobalAllocSize();
                        }
                        ++count;
                    }
                    catch (ClassNotFoundException e) {
                        Log.w("Zygote", "Class not found for preloading: " + line);
                    }
                    catch (UnsatisfiedLinkError e) {
                        Log.w("Zygote", "Problem preloading " + line + ": " + e);
                    }
                    catch (Throwable t) {
                        Log.e("Zygote", "Error preloading " + line + ".", t);
                        if (t instanceof Error) {
                            throw (Error)t;
                        }
                        if (t instanceof RuntimeException) {
                            throw (RuntimeException)t;
                        }
                        throw new RuntimeException(t);
                    }
                }
                Log.i("Zygote", "...preloaded " + count + " classes in " + (SystemClock.uptimeMillis() - startTime) + "ms.");
            }
            catch (IOException e) {
                Log.e("Zygote", "Error reading preloaded-classes.", e);
            }
            finally {
                IoUtils.closeQuietly(is);
                runtime.setTargetHeapUtilization(defaultUtilization);
                runtime.preloadDexCaches();
                Debug.stopAllocCounting();
                ZygoteInit.setEffectiveUser(0);
                ZygoteInit.setEffectiveGroup(0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void $$robo$$com_android_internal_os_ZygoteInit$preloadResources() {
        VMRuntime runtime = VMRuntime.getRuntime();
        Debug.startAllocCounting();
        try {
            System.gc();
            runtime.runFinalizationSync();
            mResources = Resources.getSystem();
            mResources.startPreloading();
            Log.i("Zygote", "Preloading resources...");
            long startTime = SystemClock.uptimeMillis();
            TypedArray ar = mResources.obtainTypedArray(17235974);
            int N = ZygoteInit.preloadDrawables(runtime, ar);
            ar.recycle();
            Log.i("Zygote", "...preloaded " + N + " resources in " + (SystemClock.uptimeMillis() - startTime) + "ms.");
            startTime = SystemClock.uptimeMillis();
            ar = mResources.obtainTypedArray(0x1070007);
            N = ZygoteInit.preloadColorStateLists(runtime, ar);
            ar.recycle();
            Log.i("Zygote", "...preloaded " + N + " resources in " + (SystemClock.uptimeMillis() - startTime) + "ms.");
            mResources.finishPreloading();
        }
        catch (RuntimeException e) {
            Log.w("Zygote", "Failure preloading resources", e);
        }
        finally {
            Debug.stopAllocCounting();
        }
    }

    private static final int $$robo$$com_android_internal_os_ZygoteInit$preloadColorStateLists(VMRuntime runtime, TypedArray ar) {
        int N = ar.length();
        for (int i = 0; i < N; ++i) {
            int id2;
            if (Debug.getGlobalAllocSize() > 50000) {
                System.gc();
                runtime.runFinalizationSync();
                Debug.resetGlobalAllocSize();
            }
            if ((id2 = ar.getResourceId(i, 0)) == 0 || mResources.getColorStateList(id2) != null) continue;
            throw new IllegalArgumentException("Unable to find preloaded color resource #0x" + Integer.toHexString(id2) + " (" + ar.getString(i) + ")");
        }
        return N;
    }

    private static final int $$robo$$com_android_internal_os_ZygoteInit$preloadDrawables(VMRuntime runtime, TypedArray ar) {
        int N = ar.length();
        for (int i = 0; i < N; ++i) {
            int id2;
            if (Debug.getGlobalAllocSize() > 50000) {
                System.gc();
                runtime.runFinalizationSync();
                Debug.resetGlobalAllocSize();
            }
            if ((id2 = ar.getResourceId(i, 0)) == 0 || mResources.getDrawable(id2, null) != null) continue;
            throw new IllegalArgumentException("Unable to find preloaded drawable resource #0x" + Integer.toHexString(id2) + " (" + ar.getString(i) + ")");
        }
        return N;
    }

    private static final void $$robo$$com_android_internal_os_ZygoteInit$gc() {
        VMRuntime runtime = VMRuntime.getRuntime();
        System.gc();
        runtime.runFinalizationSync();
        System.gc();
        runtime.runFinalizationSync();
        System.gc();
        runtime.runFinalizationSync();
    }

    private static final void $$robo$$com_android_internal_os_ZygoteInit$handleSystemServerProcess(ZygoteConnection.Arguments parsedArgs) throws MethodAndArgsCaller {
        String systemServerClasspath;
        ZygoteInit.closeServerSocket();
        Os.umask(OsConstants.S_IRWXG | OsConstants.S_IRWXO);
        if (parsedArgs.niceName != null) {
            Process.setArgV0(parsedArgs.niceName);
        }
        if ((systemServerClasspath = Os.getenv("SYSTEMSERVERCLASSPATH")) != null) {
            ZygoteInit.performSystemServerDexOpt(systemServerClasspath);
        }
        if (parsedArgs.invokeWith != null) {
            String[] args = parsedArgs.remainingArgs;
            if (systemServerClasspath != null) {
                String[] amendedArgs = new String[args.length + 2];
                amendedArgs[0] = "-cp";
                amendedArgs[1] = systemServerClasspath;
                InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (Object)parsedArgs.remainingArgs, (int)0, (Object)amendedArgs, (int)2, (int)parsedArgs.remainingArgs.length);
            }
            WrapperInit.execApplication(parsedArgs.invokeWith, parsedArgs.niceName, parsedArgs.targetSdkVersion, null, args);
        } else {
            PathClassLoader cl = null;
            if (systemServerClasspath != null) {
                cl = new PathClassLoader(systemServerClasspath, ClassLoader.getSystemClassLoader());
                Thread.currentThread().setContextClassLoader(cl);
            }
            RuntimeInit.zygoteInit(parsedArgs.targetSdkVersion, parsedArgs.remainingArgs, cl);
        }
    }

    private static final void $$robo$$com_android_internal_os_ZygoteInit$performSystemServerDexOpt(String classPath) {
        String[] classPathElements = classPath.split(":");
        InstallerConnection installer = new InstallerConnection();
        String instructionSet = VMRuntime.getRuntime().vmInstructionSet();
        try {
            for (String classPathElement : classPathElements) {
                byte dexopt = DexFile.isDexOptNeededInternal(classPathElement, "*", instructionSet, false);
                if (dexopt == 2) {
                    installer.dexopt(classPathElement, 1000, false, instructionSet);
                    continue;
                }
                if (dexopt != 1) continue;
                installer.patchoat(classPathElement, 1000, false, instructionSet);
            }
        }
        catch (IOException ioe) {
            throw new RuntimeException("Error starting system_server", ioe);
        }
        finally {
            installer.disconnect();
        }
    }

    private static final boolean $$robo$$com_android_internal_os_ZygoteInit$startSystemServer(String abiList, String socketName) throws MethodAndArgsCaller, RuntimeException {
        int pid;
        long capabilities = ZygoteInit.posixCapabilitiesAsBits(OsConstants.CAP_BLOCK_SUSPEND, OsConstants.CAP_KILL, OsConstants.CAP_NET_ADMIN, OsConstants.CAP_NET_BIND_SERVICE, OsConstants.CAP_NET_BROADCAST, OsConstants.CAP_NET_RAW, OsConstants.CAP_SYS_MODULE, OsConstants.CAP_SYS_NICE, OsConstants.CAP_SYS_RESOURCE, OsConstants.CAP_SYS_TIME, OsConstants.CAP_SYS_TTY_CONFIG);
        String[] args = new String[]{"--setuid=1000", "--setgid=1000", "--setgroups=1001,1002,1003,1004,1005,1006,1007,1008,1009,1010,1018,1032,3001,3002,3003,3006,3007", "--capabilities=" + capabilities + "," + capabilities, "--runtime-init", "--nice-name=system_server", "com.android.server.SystemServer"};
        ZygoteConnection.Arguments parsedArgs = null;
        try {
            parsedArgs = new ZygoteConnection.Arguments(args);
            ZygoteConnection.applyDebuggerSystemProperty(parsedArgs);
            ZygoteConnection.applyInvokeWithSystemProperty(parsedArgs);
            pid = Zygote.forkSystemServer(parsedArgs.uid, parsedArgs.gid, parsedArgs.gids, parsedArgs.debugFlags, null, parsedArgs.permittedCapabilities, parsedArgs.effectiveCapabilities);
        }
        catch (IllegalArgumentException ex) {
            throw new RuntimeException(ex);
        }
        if (pid == 0) {
            if (ZygoteInit.hasSecondZygote(abiList)) {
                ZygoteInit.waitForSecondaryZygote(socketName);
            }
            ZygoteInit.handleSystemServerProcess(parsedArgs);
        }
        return true;
    }

    private static final long $$robo$$com_android_internal_os_ZygoteInit$posixCapabilitiesAsBits(int ... capabilities) {
        long result = 0L;
        for (int capability : capabilities) {
            if (capability < 0 || capability > OsConstants.CAP_LAST_CAP) {
                throw new IllegalArgumentException(String.valueOf(capability));
            }
            result |= 1L << capability;
        }
        return result;
    }

    private static final void $$robo$$com_android_internal_os_ZygoteInit$main(String[] argv) {
        try {
            SamplingProfilerIntegration.start();
            boolean startSystemServer = false;
            String socketName = "zygote";
            String abiList = null;
            for (int i = 1; i < argv.length; ++i) {
                if ("start-system-server".equals(argv[i])) {
                    startSystemServer = true;
                    continue;
                }
                if (argv[i].startsWith("--abi-list=")) {
                    abiList = argv[i].substring("--abi-list=".length());
                    continue;
                }
                if (argv[i].startsWith("--socket-name=")) {
                    socketName = argv[i].substring("--socket-name=".length());
                    continue;
                }
                throw new RuntimeException("Unknown command line argument: " + argv[i]);
            }
            if (abiList == null) {
                throw new RuntimeException("No ABI list supplied.");
            }
            ZygoteInit.registerZygoteSocket(socketName);
            EventLog.writeEvent(3020, SystemClock.uptimeMillis());
            ZygoteInit.preload();
            EventLog.writeEvent(3030, SystemClock.uptimeMillis());
            SamplingProfilerIntegration.writeZygoteSnapshot();
            ZygoteInit.gc();
            Trace.setTracingEnabled(false);
            if (startSystemServer) {
                ZygoteInit.startSystemServer(abiList, socketName);
            }
            Log.i("Zygote", "Accepting command socket connections");
            ZygoteInit.runSelectLoop(abiList);
            ZygoteInit.closeServerSocket();
        }
        catch (MethodAndArgsCaller caller) {
            caller.run();
        }
        catch (RuntimeException ex) {
            Log.e("Zygote", "Zygote died with exception", ex);
            ZygoteInit.closeServerSocket();
            throw ex;
        }
    }

    private static final boolean $$robo$$com_android_internal_os_ZygoteInit$hasSecondZygote(String abiList) {
        return !SystemProperties.get("ro.product.cpu.abilist").equals(abiList);
    }

    private static final void $$robo$$com_android_internal_os_ZygoteInit$waitForSecondaryZygote(String socketName) {
        String otherZygoteName = "zygote".equals(socketName) ? "zygote_secondary" : "zygote";
        while (true) {
            try {
                Process.ZygoteState zs = Process.ZygoteState.connect(otherZygoteName);
                zs.close();
            }
            catch (IOException ioe) {
                Log.w("Zygote", "Got error connecting to zygote, retrying. msg= " + ioe.getMessage());
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {}
                continue;
            }
            break;
        }
    }

    private static final void $$robo$$com_android_internal_os_ZygoteInit$runSelectLoop(String abiList) throws MethodAndArgsCaller {
        ArrayList<FileDescriptor> fds = new ArrayList<FileDescriptor>();
        ArrayList<ZygoteConnection> peers = new ArrayList<ZygoteConnection>();
        FileDescriptor[] fdArray = new FileDescriptor[4];
        fds.add(sServerSocket.getFileDescriptor());
        peers.add(null);
        int loopCount = 10;
        while (true) {
            int index;
            if (loopCount <= 0) {
                ZygoteInit.gc();
                loopCount = 10;
            } else {
                --loopCount;
            }
            try {
                fdArray = fds.toArray(fdArray);
                index = ZygoteInit.selectReadable(fdArray);
            }
            catch (IOException ex) {
                throw new RuntimeException("Error in select()", ex);
            }
            if (index < 0) {
                throw new RuntimeException("Error in select()");
            }
            if (index == 0) {
                ZygoteConnection newPeer = ZygoteInit.acceptCommandPeer(abiList);
                peers.add(newPeer);
                fds.add(newPeer.getFileDescriptor());
                continue;
            }
            boolean done = ((ZygoteConnection)peers.get(index)).runOnce();
            if (!done) continue;
            peers.remove(index);
            fds.remove(index);
        }
    }

    private static final int $$robo$$com_android_internal_os_ZygoteInit$setreuid(int n, int n2) {
        return 0;
    }

    private static final int $$robo$$com_android_internal_os_ZygoteInit$setregid(int n, int n2) {
        return 0;
    }

    private static final int $$robo$$com_android_internal_os_ZygoteInit$setpgid(int n, int n2) {
        return 0;
    }

    private static final int $$robo$$com_android_internal_os_ZygoteInit$getpgid(int n) throws IOException {
        return 0;
    }

    private static final void $$robo$$com_android_internal_os_ZygoteInit$reopenStdio(FileDescriptor fileDescriptor, FileDescriptor fileDescriptor2, FileDescriptor fileDescriptor3) throws IOException {
    }

    private static final void $$robo$$com_android_internal_os_ZygoteInit$setCloseOnExec(FileDescriptor fileDescriptor, boolean bl) throws IOException {
    }

    private static final int $$robo$$com_android_internal_os_ZygoteInit$selectReadable(FileDescriptor[] fileDescriptorArray) throws IOException {
        return 0;
    }

    private static final FileDescriptor $$robo$$com_android_internal_os_ZygoteInit$createFileDescriptor(int n) throws IOException {
        return null;
    }

    private void $$robo$$com_android_internal_os_ZygoteInit$__constructor__() {
    }

    static void invokeStaticMain(ClassLoader classLoader, String string2, String[] stringArray) throws MethodAndArgsCaller {
        InvokeDynamicSupport.bootstrapStatic("invokeStaticMain", $$robo$$com_android_internal_os_ZygoteInit$invokeStaticMain(java.lang.ClassLoader java.lang.String java.lang.String[] ), 0, (ClassLoader)classLoader, (String)string2, (String[])stringArray);
    }

    private static void registerZygoteSocket(String string2) {
        InvokeDynamicSupport.bootstrapStatic("registerZygoteSocket", $$robo$$com_android_internal_os_ZygoteInit$registerZygoteSocket(java.lang.String ), 0, (String)string2);
    }

    private static ZygoteConnection acceptCommandPeer(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("acceptCommandPeer", $$robo$$com_android_internal_os_ZygoteInit$acceptCommandPeer(java.lang.String ), 0, (String)string2);
    }

    static void closeServerSocket() {
        InvokeDynamicSupport.bootstrapStatic("closeServerSocket", $$robo$$com_android_internal_os_ZygoteInit$closeServerSocket(), 0);
    }

    static FileDescriptor getServerSocketFileDescriptor() {
        return InvokeDynamicSupport.bootstrapStatic("getServerSocketFileDescriptor", $$robo$$com_android_internal_os_ZygoteInit$getServerSocketFileDescriptor(), 0);
    }

    private static void setEffectiveUser(int n) {
        InvokeDynamicSupport.bootstrapStatic("setEffectiveUser", $$robo$$com_android_internal_os_ZygoteInit$setEffectiveUser(int ), 0, (int)n);
    }

    private static void setEffectiveGroup(int n) {
        InvokeDynamicSupport.bootstrapStatic("setEffectiveGroup", $$robo$$com_android_internal_os_ZygoteInit$setEffectiveGroup(int ), 0, (int)n);
    }

    static void preload() {
        InvokeDynamicSupport.bootstrapStatic("preload", $$robo$$com_android_internal_os_ZygoteInit$preload(), 0);
    }

    private static void preloadSharedLibraries() {
        InvokeDynamicSupport.bootstrapStatic("preloadSharedLibraries", $$robo$$com_android_internal_os_ZygoteInit$preloadSharedLibraries(), 0);
    }

    private static void preloadOpenGL() {
        InvokeDynamicSupport.bootstrapStatic("preloadOpenGL", $$robo$$com_android_internal_os_ZygoteInit$preloadOpenGL(), 0);
    }

    private static void preloadClasses() {
        InvokeDynamicSupport.bootstrapStatic("preloadClasses", $$robo$$com_android_internal_os_ZygoteInit$preloadClasses(), 0);
    }

    private static void preloadResources() {
        InvokeDynamicSupport.bootstrapStatic("preloadResources", $$robo$$com_android_internal_os_ZygoteInit$preloadResources(), 0);
    }

    private static int preloadColorStateLists(VMRuntime vMRuntime, TypedArray typedArray) {
        return (int)InvokeDynamicSupport.bootstrapStatic("preloadColorStateLists", $$robo$$com_android_internal_os_ZygoteInit$preloadColorStateLists(dalvik.system.VMRuntime android.content.res.TypedArray ), 0, (VMRuntime)vMRuntime, (TypedArray)typedArray);
    }

    private static int preloadDrawables(VMRuntime vMRuntime, TypedArray typedArray) {
        return (int)InvokeDynamicSupport.bootstrapStatic("preloadDrawables", $$robo$$com_android_internal_os_ZygoteInit$preloadDrawables(dalvik.system.VMRuntime android.content.res.TypedArray ), 0, (VMRuntime)vMRuntime, (TypedArray)typedArray);
    }

    static void gc() {
        InvokeDynamicSupport.bootstrapStatic("gc", $$robo$$com_android_internal_os_ZygoteInit$gc(), 0);
    }

    private static void handleSystemServerProcess(ZygoteConnection.Arguments arguments) throws MethodAndArgsCaller {
        InvokeDynamicSupport.bootstrapStatic("handleSystemServerProcess", $$robo$$com_android_internal_os_ZygoteInit$handleSystemServerProcess(com.android.internal.os.ZygoteConnection$Arguments ), 0, (ZygoteConnection.Arguments)arguments);
    }

    private static void performSystemServerDexOpt(String string2) {
        InvokeDynamicSupport.bootstrapStatic("performSystemServerDexOpt", $$robo$$com_android_internal_os_ZygoteInit$performSystemServerDexOpt(java.lang.String ), 0, (String)string2);
    }

    private static boolean startSystemServer(String string2, String string3) throws MethodAndArgsCaller, RuntimeException {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("startSystemServer", $$robo$$com_android_internal_os_ZygoteInit$startSystemServer(java.lang.String java.lang.String ), 0, (String)string2, (String)string3);
    }

    private static long posixCapabilitiesAsBits(int ... nArray) {
        return (long)InvokeDynamicSupport.bootstrapStatic("posixCapabilitiesAsBits", $$robo$$com_android_internal_os_ZygoteInit$posixCapabilitiesAsBits(int[] ), 0, (int[])nArray);
    }

    public static void main(String[] stringArray) {
        InvokeDynamicSupport.bootstrapStatic("main", $$robo$$com_android_internal_os_ZygoteInit$main(java.lang.String[] ), 0, (String[])stringArray);
    }

    private static boolean hasSecondZygote(String string2) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("hasSecondZygote", $$robo$$com_android_internal_os_ZygoteInit$hasSecondZygote(java.lang.String ), 0, (String)string2);
    }

    private static void waitForSecondaryZygote(String string2) {
        InvokeDynamicSupport.bootstrapStatic("waitForSecondaryZygote", $$robo$$com_android_internal_os_ZygoteInit$waitForSecondaryZygote(java.lang.String ), 0, (String)string2);
    }

    private static void runSelectLoop(String string2) throws MethodAndArgsCaller {
        InvokeDynamicSupport.bootstrapStatic("runSelectLoop", $$robo$$com_android_internal_os_ZygoteInit$runSelectLoop(java.lang.String ), 0, (String)string2);
    }

    private static final native /* synthetic */ int $$robo$$setreuid$nativeBinding(int var0, int var1);

    static int setreuid(int n, int n2) {
        return (int)InvokeDynamicSupport.bootstrapStatic("setreuid", $$robo$$com_android_internal_os_ZygoteInit$setreuid(int int ), 1, (int)n, (int)n2);
    }

    private static final native /* synthetic */ int $$robo$$setregid$nativeBinding(int var0, int var1);

    static int setregid(int n, int n2) {
        return (int)InvokeDynamicSupport.bootstrapStatic("setregid", $$robo$$com_android_internal_os_ZygoteInit$setregid(int int ), 1, (int)n, (int)n2);
    }

    private static final native /* synthetic */ int $$robo$$setpgid$nativeBinding(int var0, int var1);

    static int setpgid(int n, int n2) {
        return (int)InvokeDynamicSupport.bootstrapStatic("setpgid", $$robo$$com_android_internal_os_ZygoteInit$setpgid(int int ), 1, (int)n, (int)n2);
    }

    private static final native /* synthetic */ int $$robo$$getpgid$nativeBinding(int var0) throws IOException;

    static int getpgid(int n) throws IOException {
        return (int)InvokeDynamicSupport.bootstrapStatic("getpgid", $$robo$$com_android_internal_os_ZygoteInit$getpgid(int ), 1, (int)n);
    }

    private static final native /* synthetic */ void $$robo$$reopenStdio$nativeBinding(FileDescriptor var0, FileDescriptor var1, FileDescriptor var2) throws IOException;

    static void reopenStdio(FileDescriptor fileDescriptor, FileDescriptor fileDescriptor2, FileDescriptor fileDescriptor3) throws IOException {
        InvokeDynamicSupport.bootstrapStatic("reopenStdio", $$robo$$com_android_internal_os_ZygoteInit$reopenStdio(java.io.FileDescriptor java.io.FileDescriptor java.io.FileDescriptor ), 1, (FileDescriptor)fileDescriptor, (FileDescriptor)fileDescriptor2, (FileDescriptor)fileDescriptor3);
    }

    private static final native /* synthetic */ void $$robo$$setCloseOnExec$nativeBinding(FileDescriptor var0, boolean var1) throws IOException;

    static void setCloseOnExec(FileDescriptor fileDescriptor, boolean bl) throws IOException {
        InvokeDynamicSupport.bootstrapStatic("setCloseOnExec", $$robo$$com_android_internal_os_ZygoteInit$setCloseOnExec(java.io.FileDescriptor boolean ), 1, (FileDescriptor)fileDescriptor, (boolean)bl);
    }

    private static final native /* synthetic */ int $$robo$$selectReadable$nativeBinding(FileDescriptor[] var0) throws IOException;

    static int selectReadable(FileDescriptor[] fileDescriptorArray) throws IOException {
        return (int)InvokeDynamicSupport.bootstrapStatic("selectReadable", $$robo$$com_android_internal_os_ZygoteInit$selectReadable(java.io.FileDescriptor[] ), 1, (FileDescriptor[])fileDescriptorArray);
    }

    private static final native /* synthetic */ FileDescriptor $$robo$$createFileDescriptor$nativeBinding(int var0) throws IOException;

    static FileDescriptor createFileDescriptor(int n) throws IOException {
        return InvokeDynamicSupport.bootstrapStatic("createFileDescriptor", $$robo$$com_android_internal_os_ZygoteInit$createFileDescriptor(int ), 1, (int)n);
    }

    private void __constructor__() {
        this.$$robo$$com_android_internal_os_ZygoteInit$__constructor__();
    }

    private ZygoteInit() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_os_ZygoteInit$__constructor__(), 0, this);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ZygoteInit)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static class MethodAndArgsCaller
    extends Exception
    implements Runnable,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private Method mMethod;
        private String[] mArgs;

        private void $$robo$$com_android_internal_os_ZygoteInit_MethodAndArgsCaller$__constructor__(Method method, String[] args) {
            this.mMethod = method;
            this.mArgs = args;
        }

        private final void $$robo$$com_android_internal_os_ZygoteInit_MethodAndArgsCaller$run() {
            try {
                this.mMethod.invoke(null, new Object[]{this.mArgs});
            }
            catch (IllegalAccessException ex) {
                throw new RuntimeException(ex);
            }
            catch (InvocationTargetException ex) {
                Throwable cause = ex.getCause();
                if (cause instanceof RuntimeException) {
                    throw (RuntimeException)cause;
                }
                if (cause instanceof Error) {
                    throw (Error)cause;
                }
                throw new RuntimeException(ex);
            }
        }

        private void __constructor__(Method method, String[] stringArray) {
            this.$$robo$$com_android_internal_os_ZygoteInit_MethodAndArgsCaller$__constructor__(method, stringArray);
        }

        public MethodAndArgsCaller(Method method, String[] stringArray) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_os_ZygoteInit_MethodAndArgsCaller$__constructor__(java.lang.reflect.Method java.lang.String[] ), 0, this, method, stringArray);
        }

        @Override
        public void run() {
            InvokeDynamicSupport.bootstrap("run", $$robo$$com_android_internal_os_ZygoteInit_MethodAndArgsCaller$run(), 0, this);
        }

        public /* synthetic */ MethodAndArgsCaller() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (MethodAndArgsCaller)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

