/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.os.storage;

import android.app.ProgressDialog;
import android.app.Service;
import android.content.ComponentName;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.os.Environment;
import android.os.IBinder;
import android.os.PowerManager;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.storage.IMountService;
import android.os.storage.StorageEventListener;
import android.os.storage.StorageManager;
import android.os.storage.StorageVolume;
import android.util.Log;
import android.widget.Toast;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class ExternalStorageFormatter
extends Service
implements DialogInterface.OnCancelListener,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    static String TAG = "ExternalStorageFormatter";
    public static String FORMAT_ONLY = "com.android.internal.os.storage.FORMAT_ONLY";
    public static String FORMAT_AND_FACTORY_RESET = "com.android.internal.os.storage.FORMAT_AND_FACTORY_RESET";
    public static String EXTRA_ALWAYS_RESET = "always_reset";
    private StorageVolume mStorageVolume;
    public static ComponentName COMPONENT_NAME;
    private IMountService mMountService;
    private StorageManager mStorageManager;
    private PowerManager.WakeLock mWakeLock;
    private ProgressDialog mProgressDialog;
    private boolean mFactoryReset;
    private boolean mAlwaysReset;
    private String mReason;
    StorageEventListener mStorageListener;

    private void $$robo$$com_android_internal_os_storage_ExternalStorageFormatter$__constructor__() {
        this.mMountService = null;
        this.mStorageManager = null;
        this.mProgressDialog = null;
        this.mFactoryReset = false;
        this.mAlwaysReset = false;
        this.mReason = null;
        this.mStorageListener = new ShadowedObject(this){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ ExternalStorageFormatter this$0;

            private void $$robo$$com_android_internal_os_storage_ExternalStorageFormatter_1$__constructor__(ExternalStorageFormatter externalStorageFormatter) {
            }

            private final void $$robo$$com_android_internal_os_storage_ExternalStorageFormatter_1$onStorageStateChanged(String path, String oldState, String newState) {
                Log.i("ExternalStorageFormatter", "Received storage state changed notification that " + path + " changed state from " + oldState + " to " + newState);
                this.this$0.updateProgressState();
            }

            private void __constructor__(ExternalStorageFormatter externalStorageFormatter) {
                this.$$robo$$com_android_internal_os_storage_ExternalStorageFormatter_1$__constructor__(externalStorageFormatter);
            }
            {
                this.this$0 = externalStorageFormatter;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_os_storage_ExternalStorageFormatter_1$__constructor__(com.android.internal.os.storage.ExternalStorageFormatter ), 0, this, externalStorageFormatter);
            }

            @Override
            public void onStorageStateChanged(String string2, String string3, String string4) {
                InvokeDynamicSupport.bootstrap("onStorageStateChanged", $$robo$$com_android_internal_os_storage_ExternalStorageFormatter_1$onStorageStateChanged(java.lang.String java.lang.String java.lang.String ), 0, this, string2, string3, string4);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
    }

    private final void $$robo$$com_android_internal_os_storage_ExternalStorageFormatter$onCreate() {
        super.onCreate();
        if (this.mStorageManager == null) {
            this.mStorageManager = (StorageManager)this.getSystemService("storage");
            this.mStorageManager.registerListener(this.mStorageListener);
        }
        this.mWakeLock = ((PowerManager)this.getSystemService("power")).newWakeLock(1, "ExternalStorageFormatter");
        this.mWakeLock.acquire();
    }

    private final int $$robo$$com_android_internal_os_storage_ExternalStorageFormatter$onStartCommand(Intent intent, int flags, int startId) {
        if ("com.android.internal.os.storage.FORMAT_AND_FACTORY_RESET".equals(intent.getAction())) {
            this.mFactoryReset = true;
        }
        if (intent.getBooleanExtra("always_reset", false)) {
            this.mAlwaysReset = true;
        }
        this.mReason = intent.getStringExtra("android.intent.extra.REASON");
        this.mStorageVolume = (StorageVolume)intent.getParcelableExtra("storage_volume");
        if (this.mProgressDialog == null) {
            this.mProgressDialog = new ProgressDialog(this);
            this.mProgressDialog.setIndeterminate(true);
            this.mProgressDialog.setCancelable(true);
            this.mProgressDialog.getWindow().setType(2003);
            if (!this.mAlwaysReset) {
                this.mProgressDialog.setOnCancelListener(this);
            }
            this.updateProgressState();
            this.mProgressDialog.show();
        }
        return 3;
    }

    private final void $$robo$$com_android_internal_os_storage_ExternalStorageFormatter$onDestroy() {
        if (this.mStorageManager != null) {
            this.mStorageManager.unregisterListener(this.mStorageListener);
        }
        if (this.mProgressDialog != null) {
            this.mProgressDialog.dismiss();
        }
        this.mWakeLock.release();
        super.onDestroy();
    }

    private final IBinder $$robo$$com_android_internal_os_storage_ExternalStorageFormatter$onBind(Intent intent) {
        return null;
    }

    private final void $$robo$$com_android_internal_os_storage_ExternalStorageFormatter$onCancel(DialogInterface dialog) {
        IMountService mountService = this.getMountService();
        String extStoragePath = this.mStorageVolume == null ? Environment.getLegacyExternalStorageDirectory().toString() : this.mStorageVolume.getPath();
        try {
            mountService.mountVolume(extStoragePath);
        }
        catch (RemoteException e) {
            Log.w("ExternalStorageFormatter", "Failed talking with mount service", e);
        }
        this.stopSelf();
    }

    private final void $$robo$$com_android_internal_os_storage_ExternalStorageFormatter$fail(int msg) {
        Toast.makeText((Context)this, msg, 1).show();
        if (this.mAlwaysReset) {
            Intent intent = new Intent("android.intent.action.MASTER_CLEAR");
            intent.addFlags(0x10000000);
            intent.putExtra("android.intent.extra.REASON", this.mReason);
            this.sendBroadcast(intent);
        }
        this.stopSelf();
    }

    private final void $$robo$$com_android_internal_os_storage_ExternalStorageFormatter$updateProgressState() {
        String status;
        String string2 = status = this.mStorageVolume == null ? Environment.getExternalStorageState() : this.mStorageManager.getVolumeState(this.mStorageVolume.getPath());
        if ("mounted".equals(status) || "mounted_ro".equals(status)) {
            this.updateProgressDialog(17040721);
            IMountService mountService = this.getMountService();
            String extStoragePath = this.mStorageVolume == null ? Environment.getLegacyExternalStorageDirectory().toString() : this.mStorageVolume.getPath();
            try {
                mountService.unmountVolume(extStoragePath, true, this.mFactoryReset);
            }
            catch (RemoteException e) {
                Log.w("ExternalStorageFormatter", "Failed talking with mount service", e);
            }
        } else if ("nofs".equals(status) || "unmounted".equals(status) || "unmountable".equals(status)) {
            String extStoragePath;
            this.updateProgressDialog(17040722);
            IMountService mountService = this.getMountService();
            String string3 = extStoragePath = this.mStorageVolume == null ? Environment.getLegacyExternalStorageDirectory().toString() : this.mStorageVolume.getPath();
            if (mountService != null) {
                new ShadowedObject(this, mountService, extStoragePath){
                    public transient /* synthetic */ Object __robo_data__;
                    /* synthetic */ IMountService val$mountService;
                    /* synthetic */ String val$extStoragePath;
                    /* synthetic */ ExternalStorageFormatter this$0;

                    private void $$robo$$com_android_internal_os_storage_ExternalStorageFormatter_2$__constructor__(ExternalStorageFormatter externalStorageFormatter, IMountService iMountService, String string2) {
                    }

                    private final void $$robo$$com_android_internal_os_storage_ExternalStorageFormatter_2$run() {
                        boolean success = false;
                        try {
                            this.val$mountService.formatVolume(this.val$extStoragePath);
                            success = true;
                        }
                        catch (Exception e) {
                            Toast.makeText((Context)this.this$0, 17040723, 1).show();
                        }
                        if (success && this.this$0.mFactoryReset) {
                            Intent intent = new Intent("android.intent.action.MASTER_CLEAR");
                            intent.addFlags(0x10000000);
                            intent.putExtra("android.intent.extra.REASON", this.this$0.mReason);
                            this.this$0.sendBroadcast(intent);
                            this.this$0.stopSelf();
                            return;
                        }
                        if (!success && this.this$0.mAlwaysReset) {
                            Intent intent = new Intent("android.intent.action.MASTER_CLEAR");
                            intent.addFlags(0x10000000);
                            intent.putExtra("android.intent.extra.REASON", this.this$0.mReason);
                            this.this$0.sendBroadcast(intent);
                        } else {
                            try {
                                this.val$mountService.mountVolume(this.val$extStoragePath);
                            }
                            catch (RemoteException e) {
                                Log.w("ExternalStorageFormatter", "Failed talking with mount service", e);
                            }
                        }
                        this.this$0.stopSelf();
                    }

                    private void __constructor__(ExternalStorageFormatter externalStorageFormatter, IMountService iMountService, String string2) {
                        this.$$robo$$com_android_internal_os_storage_ExternalStorageFormatter_2$__constructor__(externalStorageFormatter, iMountService, string2);
                    }
                    {
                        this.this$0 = externalStorageFormatter;
                        this.val$mountService = iMountService;
                        this.val$extStoragePath = string2;
                        this.$$robo$init();
                        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_os_storage_ExternalStorageFormatter_2$__constructor__(com.android.internal.os.storage.ExternalStorageFormatter android.os.storage.IMountService java.lang.String ), 0, this, externalStorageFormatter, iMountService, string2);
                    }

                    @Override
                    public void run() {
                        InvokeDynamicSupport.bootstrap("run", $$robo$$com_android_internal_os_storage_ExternalStorageFormatter_2$run(), 0, this);
                    }
                    {
                        this.$$robo$init();
                    }

                    protected /* synthetic */ void $$robo$init() {
                        if (this.__robo_data__ == null) {
                            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                        }
                    }

                    public /* synthetic */ Object $$robo$getData() {
                        return this.__robo_data__;
                    }
                }.start();
            } else {
                Log.w("ExternalStorageFormatter", "Unable to locate IMountService");
            }
        } else if ("bad_removal".equals(status)) {
            this.fail(17040724);
        } else if ("checking".equals(status)) {
            this.fail(17040725);
        } else if ("removed".equals(status)) {
            this.fail(17040726);
        } else if ("shared".equals(status)) {
            this.fail(17040727);
        } else {
            this.fail(17040728);
            Log.w("ExternalStorageFormatter", "Unknown storage state: " + status);
            this.stopSelf();
        }
    }

    private final void $$robo$$com_android_internal_os_storage_ExternalStorageFormatter$updateProgressDialog(int msg) {
        if (this.mProgressDialog == null) {
            this.mProgressDialog = new ProgressDialog(this);
            this.mProgressDialog.setIndeterminate(true);
            this.mProgressDialog.setCancelable(false);
            this.mProgressDialog.getWindow().setType(2003);
            this.mProgressDialog.show();
        }
        this.mProgressDialog.setMessage(this.getText(msg));
    }

    private final IMountService $$robo$$com_android_internal_os_storage_ExternalStorageFormatter$getMountService() {
        if (this.mMountService == null) {
            IBinder service = ServiceManager.getService("mount");
            if (service != null) {
                this.mMountService = IMountService.Stub.asInterface(service);
            } else {
                Log.e("ExternalStorageFormatter", "Can't get mount service");
            }
        }
        return this.mMountService;
    }

    static void __staticInitializer__() {
        COMPONENT_NAME = new ComponentName("android", ExternalStorageFormatter.class.getName());
    }

    private void __constructor__() {
        this.$$robo$$com_android_internal_os_storage_ExternalStorageFormatter$__constructor__();
    }

    public ExternalStorageFormatter() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_os_storage_ExternalStorageFormatter$__constructor__(), 0, this);
    }

    @Override
    public void onCreate() {
        InvokeDynamicSupport.bootstrap("onCreate", $$robo$$com_android_internal_os_storage_ExternalStorageFormatter$onCreate(), 0, this);
    }

    @Override
    public int onStartCommand(Intent intent, int n, int n2) {
        return (int)InvokeDynamicSupport.bootstrap("onStartCommand", $$robo$$com_android_internal_os_storage_ExternalStorageFormatter$onStartCommand(android.content.Intent int int ), 0, this, intent, n, n2);
    }

    @Override
    public void onDestroy() {
        InvokeDynamicSupport.bootstrap("onDestroy", $$robo$$com_android_internal_os_storage_ExternalStorageFormatter$onDestroy(), 0, this);
    }

    @Override
    public IBinder onBind(Intent intent) {
        return InvokeDynamicSupport.bootstrap("onBind", $$robo$$com_android_internal_os_storage_ExternalStorageFormatter$onBind(android.content.Intent ), 0, this, intent);
    }

    @Override
    public void onCancel(DialogInterface dialogInterface) {
        InvokeDynamicSupport.bootstrap("onCancel", $$robo$$com_android_internal_os_storage_ExternalStorageFormatter$onCancel(android.content.DialogInterface ), 0, this, dialogInterface);
    }

    void fail(int n) {
        InvokeDynamicSupport.bootstrap("fail", $$robo$$com_android_internal_os_storage_ExternalStorageFormatter$fail(int ), 0, this, n);
    }

    void updateProgressState() {
        InvokeDynamicSupport.bootstrap("updateProgressState", $$robo$$com_android_internal_os_storage_ExternalStorageFormatter$updateProgressState(), 0, this);
    }

    public void updateProgressDialog(int n) {
        InvokeDynamicSupport.bootstrap("updateProgressDialog", $$robo$$com_android_internal_os_storage_ExternalStorageFormatter$updateProgressDialog(int ), 0, this, n);
    }

    IMountService getMountService() {
        return InvokeDynamicSupport.bootstrap("getMountService", $$robo$$com_android_internal_os_storage_ExternalStorageFormatter$getMountService(), 0, this);
    }

    static {
        RobolectricInternals.classInitializing(ExternalStorageFormatter.class);
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ExternalStorageFormatter)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

