/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.policy.impl;

import android.app.StatusBarManager;
import android.os.Handler;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.SystemClock;
import android.view.WindowManagerPolicy;
import com.android.internal.policy.impl.PolicyControl;
import com.android.internal.statusbar.IStatusBarService;
import java.io.PrintWriter;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class BarController
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static boolean DEBUG = false;
    private static int TRANSIENT_BAR_NONE = 0;
    private static int TRANSIENT_BAR_SHOW_REQUESTED = 1;
    private static int TRANSIENT_BAR_SHOWING = 2;
    private static int TRANSIENT_BAR_HIDING = 3;
    private static int TRANSLUCENT_ANIMATION_DELAY_MS = 1000;
    private String mTag;
    private int mTransientFlag;
    private int mUnhideFlag;
    private int mTranslucentFlag;
    private int mStatusBarManagerId;
    private int mTranslucentWmFlag;
    private Handler mHandler;
    private Object mServiceAquireLock;
    private IStatusBarService mStatusBarService;
    private WindowManagerPolicy.WindowState mWin;
    private int mState;
    private int mTransientBarState;
    private boolean mPendingShow;
    private long mLastTranslucent;

    private void $$robo$$com_android_internal_policy_impl_BarController$__constructor__(String tag, int transientFlag, int unhideFlag, int translucentFlag, int statusBarManagerId, int translucentWmFlag) {
        this.mServiceAquireLock = new Object();
        this.mState = 0;
        this.mTag = "BarController." + tag;
        this.mTransientFlag = transientFlag;
        this.mUnhideFlag = unhideFlag;
        this.mTranslucentFlag = translucentFlag;
        this.mStatusBarManagerId = statusBarManagerId;
        this.mTranslucentWmFlag = translucentWmFlag;
        this.mHandler = new Handler();
    }

    private final void $$robo$$com_android_internal_policy_impl_BarController$setWindow(WindowManagerPolicy.WindowState win) {
        this.mWin = win;
    }

    private final void $$robo$$com_android_internal_policy_impl_BarController$showTransient() {
        if (this.mWin != null) {
            this.setTransientBarState(1);
        }
    }

    private final boolean $$robo$$com_android_internal_policy_impl_BarController$isTransientShowing() {
        return this.mTransientBarState == 2;
    }

    private final boolean $$robo$$com_android_internal_policy_impl_BarController$isTransientShowRequested() {
        return this.mTransientBarState == 1;
    }

    private final boolean $$robo$$com_android_internal_policy_impl_BarController$wasRecentlyTranslucent() {
        return SystemClock.uptimeMillis() - this.mLastTranslucent < 1000L;
    }

    private final void $$robo$$com_android_internal_policy_impl_BarController$adjustSystemUiVisibilityLw(int oldVis, int vis) {
        if (this.mWin != null && this.mTransientBarState == 2 && (vis & this.mTransientFlag) == 0) {
            this.setTransientBarState(3);
            this.setBarShowingLw(false);
        } else if (this.mWin != null && (oldVis & this.mUnhideFlag) != 0 && (vis & this.mUnhideFlag) == 0) {
            this.setBarShowingLw(true);
        }
    }

    private final int $$robo$$com_android_internal_policy_impl_BarController$applyTranslucentFlagLw(WindowManagerPolicy.WindowState win, int vis, int oldVis) {
        if (this.mWin != null) {
            if (win != null && (win.getAttrs().privateFlags & 0x200) == 0) {
                int fl = PolicyControl.getWindowFlags(win, null);
                vis = (fl & this.mTranslucentWmFlag) != 0 ? (vis |= this.mTranslucentFlag) : (vis &= ~this.mTranslucentFlag);
                vis = (fl & Integer.MIN_VALUE) != 0 ? (vis |= 0x8000) : (vis &= 0xFFFF7FFF);
            } else {
                vis = vis & ~this.mTranslucentFlag | oldVis & this.mTranslucentFlag;
                vis = vis & 0xFFFF7FFF | oldVis & 0x8000;
            }
        }
        return vis;
    }

    private final boolean $$robo$$com_android_internal_policy_impl_BarController$setBarShowingLw(boolean show) {
        if (this.mWin == null) {
            return false;
        }
        if (show && this.mTransientBarState == 3) {
            this.mPendingShow = true;
            return false;
        }
        boolean wasVis = this.mWin.isVisibleLw();
        boolean wasAnim = this.mWin.isAnimatingLw();
        boolean change = show ? this.mWin.showLw(true) : this.mWin.hideLw(true);
        int state = this.computeStateLw(wasVis, wasAnim, this.mWin, change);
        boolean stateChanged = this.updateStateLw(state);
        return change || stateChanged;
    }

    private final int $$robo$$com_android_internal_policy_impl_BarController$computeStateLw(boolean wasVis, boolean wasAnim, WindowManagerPolicy.WindowState win, boolean change) {
        if (win.hasDrawnLw()) {
            boolean vis = win.isVisibleLw();
            boolean anim2 = win.isAnimatingLw();
            if (this.mState == 1 && !change && !vis) {
                return 2;
            }
            if (this.mState == 2 && vis) {
                return 0;
            }
            if (change) {
                if (wasVis && vis && !wasAnim && anim2) {
                    return 1;
                }
                return 0;
            }
        }
        return this.mState;
    }

    private final boolean $$robo$$com_android_internal_policy_impl_BarController$updateStateLw(int state) {
        if (state != this.mState) {
            this.mState = state;
            this.mHandler.post(new Runnable(this, state){
                public transient /* synthetic */ Object __robo_data__;
                /* synthetic */ int val$state;
                /* synthetic */ BarController this$0;

                private void $$robo$$com_android_internal_policy_impl_BarController_1$__constructor__(BarController barController, int n) {
                }

                private final void $$robo$$com_android_internal_policy_impl_BarController_1$run() {
                    try {
                        IStatusBarService statusbar = this.this$0.getStatusBarService();
                        if (statusbar != null) {
                            statusbar.setWindowState(this.this$0.mStatusBarManagerId, this.val$state);
                        }
                    }
                    catch (RemoteException e) {
                        this.this$0.mStatusBarService = null;
                    }
                }

                private void __constructor__(BarController barController, int n) {
                    this.$$robo$$com_android_internal_policy_impl_BarController_1$__constructor__(barController, n);
                }
                {
                    this.this$0 = barController;
                    this.val$state = n;
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_policy_impl_BarController_1$__constructor__(com.android.internal.policy.impl.BarController int ), 0, this, barController, n);
                }

                @Override
                public void run() {
                    InvokeDynamicSupport.bootstrap("run", $$robo$$com_android_internal_policy_impl_BarController_1$run(), 0, this);
                }
                {
                    this.$$robo$init();
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            });
            return true;
        }
        return false;
    }

    private final boolean $$robo$$com_android_internal_policy_impl_BarController$checkHiddenLw() {
        if (this.mWin != null && this.mWin.hasDrawnLw()) {
            if (!this.mWin.isVisibleLw() && !this.mWin.isAnimatingLw()) {
                this.updateStateLw(2);
            }
            if (this.mTransientBarState == 3 && !this.mWin.isVisibleLw()) {
                this.setTransientBarState(0);
                if (this.mPendingShow) {
                    this.setBarShowingLw(true);
                    this.mPendingShow = false;
                }
                return true;
            }
        }
        return false;
    }

    private final boolean $$robo$$com_android_internal_policy_impl_BarController$checkShowTransientBarLw() {
        if (this.mTransientBarState == 2) {
            return false;
        }
        if (this.mTransientBarState == 1) {
            return false;
        }
        if (this.mWin == null) {
            return false;
        }
        return !this.mWin.isDisplayedLw();
    }

    private final int $$robo$$com_android_internal_policy_impl_BarController$updateVisibilityLw(boolean transientAllowed, int oldVis, int vis) {
        if (this.mWin == null) {
            return vis;
        }
        if (this.isTransientShowing() || this.isTransientShowRequested()) {
            if (transientAllowed) {
                vis |= this.mTransientFlag;
                if ((oldVis & this.mTransientFlag) == 0) {
                    vis |= this.mUnhideFlag;
                }
                this.setTransientBarState(2);
            } else {
                this.setTransientBarState(0);
            }
        }
        if (this.mTransientBarState != 0) {
            vis |= this.mTransientFlag;
            vis &= 0xFFFFFFFE;
        }
        if ((vis & this.mTranslucentFlag) != 0 || (oldVis & this.mTranslucentFlag) != 0 || ((vis | oldVis) & 4) != 0) {
            this.mLastTranslucent = SystemClock.uptimeMillis();
        }
        return vis;
    }

    private final void $$robo$$com_android_internal_policy_impl_BarController$setTransientBarState(int state) {
        if (this.mWin != null && state != this.mTransientBarState) {
            if (this.mTransientBarState == 2 || state == 2) {
                this.mLastTranslucent = SystemClock.uptimeMillis();
            }
            this.mTransientBarState = state;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final IStatusBarService $$robo$$com_android_internal_policy_impl_BarController$getStatusBarService() {
        Object object = this.mServiceAquireLock;
        synchronized (object) {
            if (this.mStatusBarService == null) {
                this.mStatusBarService = IStatusBarService.Stub.asInterface(ServiceManager.getService("statusbar"));
            }
            return this.mStatusBarService;
        }
    }

    private static final String $$robo$$com_android_internal_policy_impl_BarController$transientBarStateToString(int state) {
        if (state == 3) {
            return "TRANSIENT_BAR_HIDING";
        }
        if (state == 2) {
            return "TRANSIENT_BAR_SHOWING";
        }
        if (state == 1) {
            return "TRANSIENT_BAR_SHOW_REQUESTED";
        }
        if (state == 0) {
            return "TRANSIENT_BAR_NONE";
        }
        throw new IllegalArgumentException("Unknown state " + state);
    }

    private final void $$robo$$com_android_internal_policy_impl_BarController$dump(PrintWriter pw, String prefix) {
        if (this.mWin != null) {
            pw.print(prefix);
            pw.println(this.mTag);
            pw.print(prefix);
            pw.print("  ");
            pw.print("mState");
            pw.print('=');
            pw.println(StatusBarManager.windowStateToString(this.mState));
            pw.print(prefix);
            pw.print("  ");
            pw.print("mTransientBar");
            pw.print('=');
            pw.println(BarController.transientBarStateToString(this.mTransientBarState));
        }
    }

    private void __constructor__(String string2, int n, int n2, int n3, int n4, int n5) {
        this.$$robo$$com_android_internal_policy_impl_BarController$__constructor__(string2, n, n2, n3, n4, n5);
    }

    public BarController(String string2, int n, int n2, int n3, int n4, int n5) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_policy_impl_BarController$__constructor__(java.lang.String int int int int int ), 0, this, string2, n, n2, n3, n4, n5);
    }

    public void setWindow(WindowManagerPolicy.WindowState windowState) {
        InvokeDynamicSupport.bootstrap("setWindow", $$robo$$com_android_internal_policy_impl_BarController$setWindow(android.view.WindowManagerPolicy$WindowState ), 0, this, windowState);
    }

    public void showTransient() {
        InvokeDynamicSupport.bootstrap("showTransient", $$robo$$com_android_internal_policy_impl_BarController$showTransient(), 0, this);
    }

    public boolean isTransientShowing() {
        return (boolean)InvokeDynamicSupport.bootstrap("isTransientShowing", $$robo$$com_android_internal_policy_impl_BarController$isTransientShowing(), 0, this);
    }

    public boolean isTransientShowRequested() {
        return (boolean)InvokeDynamicSupport.bootstrap("isTransientShowRequested", $$robo$$com_android_internal_policy_impl_BarController$isTransientShowRequested(), 0, this);
    }

    public boolean wasRecentlyTranslucent() {
        return (boolean)InvokeDynamicSupport.bootstrap("wasRecentlyTranslucent", $$robo$$com_android_internal_policy_impl_BarController$wasRecentlyTranslucent(), 0, this);
    }

    public void adjustSystemUiVisibilityLw(int n, int n2) {
        InvokeDynamicSupport.bootstrap("adjustSystemUiVisibilityLw", $$robo$$com_android_internal_policy_impl_BarController$adjustSystemUiVisibilityLw(int int ), 0, this, n, n2);
    }

    public int applyTranslucentFlagLw(WindowManagerPolicy.WindowState windowState, int n, int n2) {
        return (int)InvokeDynamicSupport.bootstrap("applyTranslucentFlagLw", $$robo$$com_android_internal_policy_impl_BarController$applyTranslucentFlagLw(android.view.WindowManagerPolicy$WindowState int int ), 0, this, windowState, n, n2);
    }

    public boolean setBarShowingLw(boolean bl) {
        return (boolean)InvokeDynamicSupport.bootstrap("setBarShowingLw", $$robo$$com_android_internal_policy_impl_BarController$setBarShowingLw(boolean ), 0, this, bl);
    }

    private int computeStateLw(boolean bl, boolean bl2, WindowManagerPolicy.WindowState windowState, boolean bl3) {
        return (int)InvokeDynamicSupport.bootstrap("computeStateLw", $$robo$$com_android_internal_policy_impl_BarController$computeStateLw(boolean boolean android.view.WindowManagerPolicy$WindowState boolean ), 0, this, bl, bl2, windowState, bl3);
    }

    private boolean updateStateLw(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("updateStateLw", $$robo$$com_android_internal_policy_impl_BarController$updateStateLw(int ), 0, this, n);
    }

    public boolean checkHiddenLw() {
        return (boolean)InvokeDynamicSupport.bootstrap("checkHiddenLw", $$robo$$com_android_internal_policy_impl_BarController$checkHiddenLw(), 0, this);
    }

    public boolean checkShowTransientBarLw() {
        return (boolean)InvokeDynamicSupport.bootstrap("checkShowTransientBarLw", $$robo$$com_android_internal_policy_impl_BarController$checkShowTransientBarLw(), 0, this);
    }

    public int updateVisibilityLw(boolean bl, int n, int n2) {
        return (int)InvokeDynamicSupport.bootstrap("updateVisibilityLw", $$robo$$com_android_internal_policy_impl_BarController$updateVisibilityLw(boolean int int ), 0, this, bl, n, n2);
    }

    private void setTransientBarState(int n) {
        InvokeDynamicSupport.bootstrap("setTransientBarState", $$robo$$com_android_internal_policy_impl_BarController$setTransientBarState(int ), 0, this, n);
    }

    private IStatusBarService getStatusBarService() {
        return InvokeDynamicSupport.bootstrap("getStatusBarService", $$robo$$com_android_internal_policy_impl_BarController$getStatusBarService(), 0, this);
    }

    private static String transientBarStateToString(int n) {
        return InvokeDynamicSupport.bootstrapStatic("transientBarStateToString", $$robo$$com_android_internal_policy_impl_BarController$transientBarStateToString(int ), 0, (int)n);
    }

    public void dump(PrintWriter printWriter, String string2) {
        InvokeDynamicSupport.bootstrap("dump", $$robo$$com_android_internal_policy_impl_BarController$dump(java.io.PrintWriter java.lang.String ), 0, this, printWriter, string2);
    }

    public /* synthetic */ BarController() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (BarController)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

