/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.policy.impl;

import android.accessibilityservice.AccessibilityServiceInfo;
import android.app.ActivityManager;
import android.content.ComponentName;
import android.content.ContentResolver;
import android.content.Context;
import android.content.pm.ServiceInfo;
import android.media.Ringtone;
import android.media.RingtoneManager;
import android.os.Handler;
import android.os.Message;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.UserManager;
import android.provider.Settings;
import android.speech.tts.TextToSpeech;
import android.util.MathUtils;
import android.view.IWindowManager;
import android.view.MotionEvent;
import android.view.accessibility.AccessibilityManager;
import android.view.accessibility.IAccessibilityManager;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class EnableAccessibilityController
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static int SPEAK_WARNING_DELAY_MILLIS = 2000;
    private static int ENABLE_ACCESSIBILITY_DELAY_MILLIS = 6000;
    public static int MESSAGE_SPEAK_WARNING = 1;
    public static int MESSAGE_SPEAK_ENABLE_CANCELED = 2;
    public static int MESSAGE_ENABLE_ACCESSIBILITY = 3;
    private Handler mHandler;
    private IWindowManager mWindowManager;
    private IAccessibilityManager mAccessibilityManager;
    private Context mContext;
    private Runnable mOnAccessibilityEnabledCallback;
    private UserManager mUserManager;
    private TextToSpeech mTts;
    private Ringtone mTone;
    private float mTouchSlop;
    private boolean mDestroyed;
    private boolean mCanceled;
    private float mFirstPointerDownX;
    private float mFirstPointerDownY;
    private float mSecondPointerDownX;
    private float mSecondPointerDownY;

    private void $$robo$$com_android_internal_policy_impl_EnableAccessibilityController$__constructor__(Context context, Runnable onAccessibilityEnabledCallback) {
        this.mHandler = new ShadowedObject(this){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ EnableAccessibilityController this$0;

            private void $$robo$$com_android_internal_policy_impl_EnableAccessibilityController_1$__constructor__(EnableAccessibilityController enableAccessibilityController) {
            }

            private final void $$robo$$com_android_internal_policy_impl_EnableAccessibilityController_1$handleMessage(Message message) {
                switch (message.what) {
                    case 1: {
                        String text = this.this$0.mContext.getString(17040884);
                        this.this$0.mTts.speak(text, 0, null);
                        break;
                    }
                    case 2: {
                        String text = this.this$0.mContext.getString(17040886);
                        this.this$0.mTts.speak(text, 0, null);
                        break;
                    }
                    case 3: {
                        this.this$0.enableAccessibility();
                        this.this$0.mTone.play();
                        this.this$0.mTts.speak(this.this$0.mContext.getString(17040885), 0, null);
                    }
                }
            }

            private void __constructor__(EnableAccessibilityController enableAccessibilityController) {
                this.$$robo$$com_android_internal_policy_impl_EnableAccessibilityController_1$__constructor__(enableAccessibilityController);
            }
            {
                this.this$0 = enableAccessibilityController;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_policy_impl_EnableAccessibilityController_1$__constructor__(com.android.internal.policy.impl.EnableAccessibilityController ), 0, this, enableAccessibilityController);
            }

            @Override
            public void handleMessage(Message message) {
                InvokeDynamicSupport.bootstrap("handleMessage", $$robo$$com_android_internal_policy_impl_EnableAccessibilityController_1$handleMessage(android.os.Message ), 0, this, message);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.mWindowManager = IWindowManager.Stub.asInterface(ServiceManager.getService("window"));
        this.mAccessibilityManager = IAccessibilityManager.Stub.asInterface(ServiceManager.getService("accessibility"));
        this.mContext = context;
        this.mOnAccessibilityEnabledCallback = onAccessibilityEnabledCallback;
        this.mUserManager = (UserManager)this.mContext.getSystemService("user");
        this.mTts = new TextToSpeech(context, new TextToSpeech.OnInitListener(this){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ EnableAccessibilityController this$0;

            private void $$robo$$com_android_internal_policy_impl_EnableAccessibilityController_2$__constructor__(EnableAccessibilityController enableAccessibilityController) {
            }

            private final void $$robo$$com_android_internal_policy_impl_EnableAccessibilityController_2$onInit(int status) {
                if (this.this$0.mDestroyed) {
                    this.this$0.mTts.shutdown();
                }
            }

            private void __constructor__(EnableAccessibilityController enableAccessibilityController) {
                this.$$robo$$com_android_internal_policy_impl_EnableAccessibilityController_2$__constructor__(enableAccessibilityController);
            }
            {
                this.this$0 = enableAccessibilityController;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_policy_impl_EnableAccessibilityController_2$__constructor__(com.android.internal.policy.impl.EnableAccessibilityController ), 0, this, enableAccessibilityController);
            }

            @Override
            public void onInit(int n) {
                InvokeDynamicSupport.bootstrap("onInit", $$robo$$com_android_internal_policy_impl_EnableAccessibilityController_2$onInit(int ), 0, this, n);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        });
        this.mTone = RingtoneManager.getRingtone(context, Settings.System.DEFAULT_NOTIFICATION_URI);
        this.mTone.setStreamType(3);
        this.mTouchSlop = context.getResources().getDimensionPixelSize(17105006);
    }

    private static final boolean $$robo$$com_android_internal_policy_impl_EnableAccessibilityController$canEnableAccessibilityViaGesture(Context context) {
        AccessibilityManager accessibilityManager = AccessibilityManager.getInstance(context);
        if (accessibilityManager.isEnabled() && !accessibilityManager.getEnabledAccessibilityServiceList(1).isEmpty()) {
            return false;
        }
        return Settings.Global.getInt(context.getContentResolver(), "enable_accessibility_global_gesture_enabled", 0) == 1 && !EnableAccessibilityController.getInstalledSpeakingAccessibilityServices(context).isEmpty();
    }

    private static final List<AccessibilityServiceInfo> $$robo$$com_android_internal_policy_impl_EnableAccessibilityController$getInstalledSpeakingAccessibilityServices(Context context) {
        ArrayList<AccessibilityServiceInfo> services = new ArrayList<AccessibilityServiceInfo>();
        services.addAll(AccessibilityManager.getInstance(context).getInstalledAccessibilityServiceList());
        Iterator iterator = services.iterator();
        while (iterator.hasNext()) {
            AccessibilityServiceInfo service = (AccessibilityServiceInfo)iterator.next();
            if ((service.feedbackType & 1) != 0) continue;
            iterator.remove();
        }
        return services;
    }

    private final void $$robo$$com_android_internal_policy_impl_EnableAccessibilityController$onDestroy() {
        this.mDestroyed = true;
    }

    private final boolean $$robo$$com_android_internal_policy_impl_EnableAccessibilityController$onInterceptTouchEvent(MotionEvent event) {
        if (event.getActionMasked() == 5 && event.getPointerCount() == 2) {
            this.mFirstPointerDownX = event.getX(0);
            this.mFirstPointerDownY = event.getY(0);
            this.mSecondPointerDownX = event.getX(1);
            this.mSecondPointerDownY = event.getY(1);
            this.mHandler.sendEmptyMessageDelayed(1, 2000L);
            this.mHandler.sendEmptyMessageDelayed(3, 6000L);
            return true;
        }
        return false;
    }

    private final boolean $$robo$$com_android_internal_policy_impl_EnableAccessibilityController$onTouchEvent(MotionEvent event) {
        int pointerCount = event.getPointerCount();
        int action = event.getActionMasked();
        if (this.mCanceled) {
            if (action == 1) {
                this.mCanceled = false;
            }
            return true;
        }
        switch (action) {
            case 5: {
                if (pointerCount <= 2) break;
                this.cancel();
                break;
            }
            case 2: {
                float secondPointerMove;
                float firstPointerMove = MathUtils.dist(event.getX(0), event.getY(0), this.mFirstPointerDownX, this.mFirstPointerDownY);
                if (Math.abs(firstPointerMove) > this.mTouchSlop) {
                    this.cancel();
                }
                if (!(Math.abs(secondPointerMove = MathUtils.dist(event.getX(1), event.getY(1), this.mSecondPointerDownX, this.mSecondPointerDownY)) > this.mTouchSlop)) break;
                this.cancel();
                break;
            }
            case 3: 
            case 6: {
                this.cancel();
            }
        }
        return true;
    }

    private final void $$robo$$com_android_internal_policy_impl_EnableAccessibilityController$cancel() {
        this.mCanceled = true;
        if (this.mHandler.hasMessages(1)) {
            this.mHandler.removeMessages(1);
        } else if (this.mHandler.hasMessages(3)) {
            this.mHandler.sendEmptyMessage(2);
        }
        this.mHandler.removeMessages(3);
    }

    private final void $$robo$$com_android_internal_policy_impl_EnableAccessibilityController$enableAccessibility() {
        boolean enableTouchExploration;
        List<AccessibilityServiceInfo> services = EnableAccessibilityController.getInstalledSpeakingAccessibilityServices(this.mContext);
        if (services.isEmpty()) {
            return;
        }
        boolean keyguardLocked = false;
        try {
            keyguardLocked = this.mWindowManager.isKeyguardLocked();
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        boolean hasMoreThanOneUser = this.mUserManager.getUsers().size() > 1;
        AccessibilityServiceInfo service = services.get(0);
        boolean bl = enableTouchExploration = (service.flags & 4) != 0;
        if (!enableTouchExploration) {
            int serviceCount = services.size();
            for (int i = 1; i < serviceCount; ++i) {
                AccessibilityServiceInfo candidate = services.get(i);
                if ((candidate.flags & 4) == 0) continue;
                enableTouchExploration = true;
                service = candidate;
                break;
            }
        }
        ServiceInfo serviceInfo = service.getResolveInfo().serviceInfo;
        ComponentName componentName = new ComponentName(serviceInfo.packageName, serviceInfo.name);
        if (!keyguardLocked || !hasMoreThanOneUser) {
            int userId = ActivityManager.getCurrentUser();
            String enabledServiceString = componentName.flattenToString();
            ContentResolver resolver = this.mContext.getContentResolver();
            Settings.Secure.putStringForUser(resolver, "enabled_accessibility_services", enabledServiceString, userId);
            Settings.Secure.putStringForUser(resolver, "touch_exploration_granted_accessibility_services", enabledServiceString, userId);
            if (enableTouchExploration) {
                Settings.Secure.putIntForUser(resolver, "touch_exploration_enabled", 1, userId);
            }
            Settings.Secure.putIntForUser(resolver, "accessibility_script_injection", 1, userId);
            Settings.Secure.putIntForUser(resolver, "accessibility_enabled", 1, userId);
        } else if (keyguardLocked) {
            try {
                this.mAccessibilityManager.temporaryEnableAccessibilityStateUntilKeyguardRemoved(componentName, enableTouchExploration);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
        this.mOnAccessibilityEnabledCallback.run();
    }

    private void __constructor__(Context context, Runnable runnable) {
        this.$$robo$$com_android_internal_policy_impl_EnableAccessibilityController$__constructor__(context, runnable);
    }

    public EnableAccessibilityController(Context context, Runnable runnable) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_policy_impl_EnableAccessibilityController$__constructor__(android.content.Context java.lang.Runnable ), 0, this, context, runnable);
    }

    public static boolean canEnableAccessibilityViaGesture(Context context) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("canEnableAccessibilityViaGesture", $$robo$$com_android_internal_policy_impl_EnableAccessibilityController$canEnableAccessibilityViaGesture(android.content.Context ), 0, (Context)context);
    }

    private static List<AccessibilityServiceInfo> getInstalledSpeakingAccessibilityServices(Context context) {
        return InvokeDynamicSupport.bootstrapStatic("getInstalledSpeakingAccessibilityServices", $$robo$$com_android_internal_policy_impl_EnableAccessibilityController$getInstalledSpeakingAccessibilityServices(android.content.Context ), 0, (Context)context);
    }

    public void onDestroy() {
        InvokeDynamicSupport.bootstrap("onDestroy", $$robo$$com_android_internal_policy_impl_EnableAccessibilityController$onDestroy(), 0, this);
    }

    public boolean onInterceptTouchEvent(MotionEvent motionEvent) {
        return (boolean)InvokeDynamicSupport.bootstrap("onInterceptTouchEvent", $$robo$$com_android_internal_policy_impl_EnableAccessibilityController$onInterceptTouchEvent(android.view.MotionEvent ), 0, this, motionEvent);
    }

    public boolean onTouchEvent(MotionEvent motionEvent) {
        return (boolean)InvokeDynamicSupport.bootstrap("onTouchEvent", $$robo$$com_android_internal_policy_impl_EnableAccessibilityController$onTouchEvent(android.view.MotionEvent ), 0, this, motionEvent);
    }

    private void cancel() {
        InvokeDynamicSupport.bootstrap("cancel", $$robo$$com_android_internal_policy_impl_EnableAccessibilityController$cancel(), 0, this);
    }

    private void enableAccessibility() {
        InvokeDynamicSupport.bootstrap("enableAccessibility", $$robo$$com_android_internal_policy_impl_EnableAccessibilityController$enableAccessibility(), 0, this);
    }

    public /* synthetic */ EnableAccessibilityController() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (EnableAccessibilityController)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

