/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.policy.impl;

import android.app.ActivityManager;
import android.app.ActivityManagerNative;
import android.app.AlertDialog;
import android.app.Dialog;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.UserInfo;
import android.database.ContentObserver;
import android.graphics.drawable.Drawable;
import android.media.AudioManager;
import android.net.ConnectivityManager;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.SystemClock;
import android.os.SystemProperties;
import android.os.UserHandle;
import android.os.UserManager;
import android.os.Vibrator;
import android.provider.Settings;
import android.service.dreams.IDreamManager;
import android.telephony.PhoneStateListener;
import android.telephony.ServiceState;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import android.util.ArraySet;
import android.util.Log;
import android.util.TypedValue;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.view.WindowManagerGlobal;
import android.view.WindowManagerPolicy;
import android.view.accessibility.AccessibilityEvent;
import android.widget.AdapterView;
import android.widget.BaseAdapter;
import android.widget.ImageView;
import android.widget.ListView;
import android.widget.TextView;
import com.android.internal.app.AlertController;
import com.android.internal.policy.impl.EnableAccessibilityController;
import com.android.internal.widget.LockPatternUtils;
import com.google.errorprone.annotations.DoNotMock;
import java.util.ArrayList;
import java.util.List;
import org.robolectric.internal.bytecode.InstrumentedInterface;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class GlobalActions
implements DialogInterface.OnDismissListener,
DialogInterface.OnClickListener,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "GlobalActions";
    private static boolean SHOW_SILENT_TOGGLE = true;
    private static String GLOBAL_ACTION_KEY_POWER = "power";
    private static String GLOBAL_ACTION_KEY_AIRPLANE = "airplane";
    private static String GLOBAL_ACTION_KEY_BUGREPORT = "bugreport";
    private static String GLOBAL_ACTION_KEY_SILENT = "silent";
    private static String GLOBAL_ACTION_KEY_USERS = "users";
    private static String GLOBAL_ACTION_KEY_SETTINGS = "settings";
    private static String GLOBAL_ACTION_KEY_LOCKDOWN = "lockdown";
    private Context mContext;
    private WindowManagerPolicy.WindowManagerFuncs mWindowManagerFuncs;
    private AudioManager mAudioManager;
    private IDreamManager mDreamManager;
    private ArrayList<Action> mItems;
    private GlobalActionsDialog mDialog;
    private Action mSilentModeAction;
    private ToggleAction mAirplaneModeOn;
    private MyAdapter mAdapter;
    private boolean mKeyguardShowing;
    private boolean mDeviceProvisioned;
    private ToggleAction.State mAirplaneState;
    private boolean mIsWaitingForEcmExit;
    private boolean mHasTelephony;
    private boolean mHasVibrator;
    private boolean mShowSilentToggle;
    private BroadcastReceiver mBroadcastReceiver;
    PhoneStateListener mPhoneStateListener;
    private BroadcastReceiver mRingerModeReceiver;
    private ContentObserver mAirplaneModeObserver;
    private static int MESSAGE_DISMISS = 0;
    private static int MESSAGE_REFRESH = 1;
    private static int MESSAGE_SHOW = 2;
    private static int DIALOG_DISMISS_DELAY = 300;
    private Handler mHandler;

    private void $$robo$$com_android_internal_policy_impl_GlobalActions$__constructor__(Context context, WindowManagerPolicy.WindowManagerFuncs windowManagerFuncs) {
        this.mKeyguardShowing = false;
        this.mDeviceProvisioned = false;
        this.mAirplaneState = ToggleAction.State.Off;
        this.mIsWaitingForEcmExit = false;
        this.mBroadcastReceiver = new ShadowedObject(this){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ GlobalActions this$0;

            private void $$robo$$com_android_internal_policy_impl_GlobalActions_7$__constructor__(GlobalActions globalActions) {
            }

            private final void $$robo$$com_android_internal_policy_impl_GlobalActions_7$onReceive(Context context, Intent intent) {
                String action = intent.getAction();
                if ("android.intent.action.CLOSE_SYSTEM_DIALOGS".equals(action) || "android.intent.action.SCREEN_OFF".equals(action)) {
                    String reason = intent.getStringExtra("reason");
                    if (!"globalactions".equals(reason)) {
                        this.this$0.mHandler.sendEmptyMessage(0);
                    }
                } else if ("android.intent.action.EMERGENCY_CALLBACK_MODE_CHANGED".equals(action) && !intent.getBooleanExtra("PHONE_IN_ECM_STATE", false) && this.this$0.mIsWaitingForEcmExit) {
                    this.this$0.mIsWaitingForEcmExit = false;
                    this.this$0.changeAirplaneModeSystemSetting(true);
                }
            }

            private void __constructor__(GlobalActions globalActions) {
                this.$$robo$$com_android_internal_policy_impl_GlobalActions_7$__constructor__(globalActions);
            }
            {
                this.this$0 = globalActions;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_policy_impl_GlobalActions_7$__constructor__(com.android.internal.policy.impl.GlobalActions ), 0, this, globalActions);
            }

            @Override
            public void onReceive(Context context, Intent intent) {
                InvokeDynamicSupport.bootstrap("onReceive", $$robo$$com_android_internal_policy_impl_GlobalActions_7$onReceive(android.content.Context android.content.Intent ), 0, this, context, intent);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.mPhoneStateListener = new ShadowedObject(this){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ GlobalActions this$0;

            private void $$robo$$com_android_internal_policy_impl_GlobalActions_8$__constructor__(GlobalActions globalActions) {
            }

            private final void $$robo$$com_android_internal_policy_impl_GlobalActions_8$onServiceStateChanged(ServiceState serviceState) {
                if (!this.this$0.mHasTelephony) {
                    return;
                }
                boolean inAirplaneMode = serviceState.getState() == 3;
                this.this$0.mAirplaneState = inAirplaneMode ? ToggleAction.State.On : ToggleAction.State.Off;
                this.this$0.mAirplaneModeOn.updateState(this.this$0.mAirplaneState);
                this.this$0.mAdapter.notifyDataSetChanged();
            }

            private void __constructor__(GlobalActions globalActions) {
                this.$$robo$$com_android_internal_policy_impl_GlobalActions_8$__constructor__(globalActions);
            }
            {
                this.this$0 = globalActions;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_policy_impl_GlobalActions_8$__constructor__(com.android.internal.policy.impl.GlobalActions ), 0, this, globalActions);
            }

            @Override
            public void onServiceStateChanged(ServiceState serviceState) {
                InvokeDynamicSupport.bootstrap("onServiceStateChanged", $$robo$$com_android_internal_policy_impl_GlobalActions_8$onServiceStateChanged(android.telephony.ServiceState ), 0, this, serviceState);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.mRingerModeReceiver = new ShadowedObject(this){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ GlobalActions this$0;

            private void $$robo$$com_android_internal_policy_impl_GlobalActions_9$__constructor__(GlobalActions globalActions) {
            }

            private final void $$robo$$com_android_internal_policy_impl_GlobalActions_9$onReceive(Context context, Intent intent) {
                if (intent.getAction().equals("android.media.RINGER_MODE_CHANGED")) {
                    this.this$0.mHandler.sendEmptyMessage(1);
                }
            }

            private void __constructor__(GlobalActions globalActions) {
                this.$$robo$$com_android_internal_policy_impl_GlobalActions_9$__constructor__(globalActions);
            }
            {
                this.this$0 = globalActions;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_policy_impl_GlobalActions_9$__constructor__(com.android.internal.policy.impl.GlobalActions ), 0, this, globalActions);
            }

            @Override
            public void onReceive(Context context, Intent intent) {
                InvokeDynamicSupport.bootstrap("onReceive", $$robo$$com_android_internal_policy_impl_GlobalActions_9$onReceive(android.content.Context android.content.Intent ), 0, this, context, intent);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.mAirplaneModeObserver = new ShadowedObject(this, new Handler()){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ GlobalActions this$0;

            private void $$robo$$com_android_internal_policy_impl_GlobalActions_10$__constructor__(GlobalActions globalActions, Handler x0) {
            }

            private final void $$robo$$com_android_internal_policy_impl_GlobalActions_10$onChange(boolean selfChange) {
                this.this$0.onAirplaneModeChanged();
            }

            private void __constructor__(GlobalActions globalActions, Handler handler) {
                this.$$robo$$com_android_internal_policy_impl_GlobalActions_10$__constructor__(globalActions, handler);
            }
            {
                this.this$0 = globalActions;
                super(handler);
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_policy_impl_GlobalActions_10$__constructor__(com.android.internal.policy.impl.GlobalActions android.os.Handler ), 0, this, globalActions, handler);
            }

            @Override
            public void onChange(boolean bl) {
                InvokeDynamicSupport.bootstrap("onChange", $$robo$$com_android_internal_policy_impl_GlobalActions_10$onChange(boolean ), 0, this, bl);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.mHandler = new ShadowedObject(this){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ GlobalActions this$0;

            private void $$robo$$com_android_internal_policy_impl_GlobalActions_11$__constructor__(GlobalActions globalActions) {
            }

            private final void $$robo$$com_android_internal_policy_impl_GlobalActions_11$handleMessage(Message msg) {
                switch (msg.what) {
                    case 0: {
                        if (this.this$0.mDialog == null) break;
                        this.this$0.mDialog.dismiss();
                        this.this$0.mDialog = null;
                        break;
                    }
                    case 1: {
                        this.this$0.refreshSilentMode();
                        this.this$0.mAdapter.notifyDataSetChanged();
                        break;
                    }
                    case 2: {
                        this.this$0.handleShow();
                    }
                }
            }

            private void __constructor__(GlobalActions globalActions) {
                this.$$robo$$com_android_internal_policy_impl_GlobalActions_11$__constructor__(globalActions);
            }
            {
                this.this$0 = globalActions;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_policy_impl_GlobalActions_11$__constructor__(com.android.internal.policy.impl.GlobalActions ), 0, this, globalActions);
            }

            @Override
            public void handleMessage(Message message) {
                InvokeDynamicSupport.bootstrap("handleMessage", $$robo$$com_android_internal_policy_impl_GlobalActions_11$handleMessage(android.os.Message ), 0, this, message);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.mContext = context;
        this.mWindowManagerFuncs = windowManagerFuncs;
        this.mAudioManager = (AudioManager)this.mContext.getSystemService("audio");
        this.mDreamManager = IDreamManager.Stub.asInterface(ServiceManager.getService("dreams"));
        IntentFilter filter = new IntentFilter();
        filter.addAction("android.intent.action.CLOSE_SYSTEM_DIALOGS");
        filter.addAction("android.intent.action.SCREEN_OFF");
        filter.addAction("android.intent.action.EMERGENCY_CALLBACK_MODE_CHANGED");
        context.registerReceiver(this.mBroadcastReceiver, filter);
        ConnectivityManager cm = (ConnectivityManager)context.getSystemService("connectivity");
        this.mHasTelephony = cm.isNetworkSupported(0);
        TelephonyManager telephonyManager = (TelephonyManager)context.getSystemService("phone");
        telephonyManager.listen(this.mPhoneStateListener, 1);
        this.mContext.getContentResolver().registerContentObserver(Settings.Global.getUriFor("airplane_mode_on"), true, this.mAirplaneModeObserver);
        Vibrator vibrator = (Vibrator)this.mContext.getSystemService("vibrator");
        this.mHasVibrator = vibrator != null && vibrator.hasVibrator();
        this.mShowSilentToggle = !this.mContext.getResources().getBoolean(17956968);
    }

    private final void $$robo$$com_android_internal_policy_impl_GlobalActions$showDialog(boolean keyguardShowing, boolean isDeviceProvisioned) {
        this.mKeyguardShowing = keyguardShowing;
        this.mDeviceProvisioned = isDeviceProvisioned;
        if (this.mDialog != null) {
            this.mDialog.dismiss();
            this.mDialog = null;
            this.mHandler.sendEmptyMessage(2);
        } else {
            this.handleShow();
        }
    }

    private final void $$robo$$com_android_internal_policy_impl_GlobalActions$awakenIfNecessary() {
        if (this.mDreamManager != null) {
            try {
                if (this.mDreamManager.isDreaming()) {
                    this.mDreamManager.awaken();
                }
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
    }

    private final void $$robo$$com_android_internal_policy_impl_GlobalActions$handleShow() {
        this.awakenIfNecessary();
        this.mDialog = this.createDialog();
        this.prepareDialog();
        if (this.mAdapter.getCount() == 1 && this.mAdapter.getItem(0) instanceof SinglePressAction && !(this.mAdapter.getItem(0) instanceof LongPressAction)) {
            ((SinglePressAction)this.mAdapter.getItem(0)).onPress();
        } else {
            WindowManager.LayoutParams attrs = this.mDialog.getWindow().getAttributes();
            attrs.setTitle("GlobalActions");
            this.mDialog.getWindow().setAttributes(attrs);
            this.mDialog.show();
            this.mDialog.getWindow().getDecorView().setSystemUiVisibility(65536);
        }
    }

    private final GlobalActionsDialog $$robo$$com_android_internal_policy_impl_GlobalActions$createDialog() {
        this.mSilentModeAction = !this.mHasVibrator ? new SilentModeToggleAction(this) : new SilentModeTriStateAction(this.mContext, this.mAudioManager, this.mHandler);
        this.mAirplaneModeOn = new ShadowedObject(this, 17302391, 17302393, 17039614, 17039615, 0x1040100){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ GlobalActions this$0;

            private void $$robo$$com_android_internal_policy_impl_GlobalActions_1$__constructor__(GlobalActions globalActions, int x0, int x1, int x2, int x3, int x4) {
            }

            private final void $$robo$$com_android_internal_policy_impl_GlobalActions_1$onToggle(boolean on) {
                if (this.this$0.mHasTelephony && Boolean.parseBoolean(SystemProperties.get("ril.cdma.inecmmode"))) {
                    this.this$0.mIsWaitingForEcmExit = true;
                    Intent ecmDialogIntent = new Intent("android.intent.action.ACTION_SHOW_NOTICE_ECM_BLOCK_OTHERS", null);
                    ecmDialogIntent.addFlags(0x10000000);
                    this.this$0.mContext.startActivity(ecmDialogIntent);
                } else {
                    this.this$0.changeAirplaneModeSystemSetting(on);
                }
            }

            private final void $$robo$$com_android_internal_policy_impl_GlobalActions_1$changeStateFromPress(boolean buttonOn) {
                if (!this.this$0.mHasTelephony) {
                    return;
                }
                if (!Boolean.parseBoolean(SystemProperties.get("ril.cdma.inecmmode"))) {
                    this.mState = buttonOn ? ToggleAction.State.TurningOn : ToggleAction.State.TurningOff;
                    this.this$0.mAirplaneState = this.mState;
                }
            }

            private final boolean $$robo$$com_android_internal_policy_impl_GlobalActions_1$showDuringKeyguard() {
                return true;
            }

            private final boolean $$robo$$com_android_internal_policy_impl_GlobalActions_1$showBeforeProvisioning() {
                return false;
            }

            private void __constructor__(GlobalActions globalActions, int n, int n2, int n3, int n4, int n5) {
                this.$$robo$$com_android_internal_policy_impl_GlobalActions_1$__constructor__(globalActions, n, n2, n3, n4, n5);
            }
            {
                this.this$0 = globalActions;
                super(n, n2, n3, n4, n5);
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_policy_impl_GlobalActions_1$__constructor__(com.android.internal.policy.impl.GlobalActions int int int int int ), 0, this, globalActions, n, n2, n3, n4, n5);
            }

            @Override
            void onToggle(boolean bl) {
                InvokeDynamicSupport.bootstrap("onToggle", $$robo$$com_android_internal_policy_impl_GlobalActions_1$onToggle(boolean ), 0, this, bl);
            }

            @Override
            protected void changeStateFromPress(boolean bl) {
                InvokeDynamicSupport.bootstrap("changeStateFromPress", $$robo$$com_android_internal_policy_impl_GlobalActions_1$changeStateFromPress(boolean ), 0, this, bl);
            }

            @Override
            public boolean showDuringKeyguard() {
                return (boolean)InvokeDynamicSupport.bootstrap("showDuringKeyguard", $$robo$$com_android_internal_policy_impl_GlobalActions_1$showDuringKeyguard(), 0, this);
            }

            @Override
            public boolean showBeforeProvisioning() {
                return (boolean)InvokeDynamicSupport.bootstrap("showBeforeProvisioning", $$robo$$com_android_internal_policy_impl_GlobalActions_1$showBeforeProvisioning(), 0, this);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.onAirplaneModeChanged();
        this.mItems = new ArrayList();
        String[] defaultActions = this.mContext.getResources().getStringArray(17236021);
        ArraySet<String> addedKeys = new ArraySet<String>();
        for (int i = 0; i < defaultActions.length; ++i) {
            String actionKey = defaultActions[i];
            if (addedKeys.contains(actionKey)) continue;
            if ("power".equals(actionKey)) {
                this.mItems.add(new PowerAction(this));
            } else if ("airplane".equals(actionKey)) {
                this.mItems.add(this.mAirplaneModeOn);
            } else if ("bugreport".equals(actionKey)) {
                if (Settings.Global.getInt(this.mContext.getContentResolver(), "bugreport_in_power_menu", 0) != 0 && this.isCurrentUserOwner()) {
                    this.mItems.add(this.getBugReportAction());
                }
            } else if ("silent".equals(actionKey)) {
                if (this.mShowSilentToggle) {
                    this.mItems.add(this.mSilentModeAction);
                }
            } else if ("users".equals(actionKey)) {
                if (SystemProperties.getBoolean("fw.power_user_switcher", false)) {
                    this.addUsersToMenu(this.mItems);
                }
            } else if ("settings".equals(actionKey)) {
                this.mItems.add(this.getSettingsAction());
            } else if ("lockdown".equals(actionKey)) {
                this.mItems.add(this.getLockdownAction());
            } else {
                Log.e("GlobalActions", "Invalid global action key " + actionKey);
            }
            addedKeys.add(actionKey);
        }
        this.mAdapter = new MyAdapter(this);
        AlertController.AlertParams params = new AlertController.AlertParams(this.mContext);
        params.mAdapter = this.mAdapter;
        params.mOnClickListener = this;
        params.mForceInverseBackground = true;
        GlobalActionsDialog dialog = new GlobalActionsDialog(this.mContext, params);
        dialog.setCanceledOnTouchOutside(false);
        dialog.getListView().setItemsCanFocus(true);
        dialog.getListView().setLongClickable(true);
        dialog.getListView().setOnItemLongClickListener(new AdapterView.OnItemLongClickListener(this){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ GlobalActions this$0;

            private void $$robo$$com_android_internal_policy_impl_GlobalActions_2$__constructor__(GlobalActions globalActions) {
            }

            private final boolean $$robo$$com_android_internal_policy_impl_GlobalActions_2$onItemLongClick(AdapterView<?> parent, View view, int position, long id2) {
                Object action = this.this$0.mAdapter.getItem(position);
                if (action instanceof LongPressAction) {
                    return ((LongPressAction)action).onLongPress();
                }
                return false;
            }

            private void __constructor__(GlobalActions globalActions) {
                this.$$robo$$com_android_internal_policy_impl_GlobalActions_2$__constructor__(globalActions);
            }
            {
                this.this$0 = globalActions;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_policy_impl_GlobalActions_2$__constructor__(com.android.internal.policy.impl.GlobalActions ), 0, this, globalActions);
            }

            @Override
            public boolean onItemLongClick(AdapterView<?> adapterView, View view, int n, long l) {
                return (boolean)InvokeDynamicSupport.bootstrap("onItemLongClick", $$robo$$com_android_internal_policy_impl_GlobalActions_2$onItemLongClick(android.widget.AdapterView<?> android.view.View int long ), 0, this, adapterView, view, n, l);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        });
        dialog.getWindow().setType(2009);
        dialog.setOnDismissListener(this);
        return dialog;
    }

    private final Action $$robo$$com_android_internal_policy_impl_GlobalActions$getBugReportAction() {
        return new ShadowedObject(this, 17302395, 17039608){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ GlobalActions this$0;

            private void $$robo$$com_android_internal_policy_impl_GlobalActions_3$__constructor__(GlobalActions globalActions, int x0, int x1) {
            }

            private final void $$robo$$com_android_internal_policy_impl_GlobalActions_3$onPress() {
                AlertDialog.Builder builder = new AlertDialog.Builder(this.this$0.mContext);
                builder.setTitle(17039608);
                builder.setMessage(17039609);
                builder.setNegativeButton(0x1040000, null);
                builder.setPositiveButton(17040505, new DialogInterface.OnClickListener(this){
                    public transient /* synthetic */ Object __robo_data__;
                    /* synthetic */ 3 this$1;

                    private void $$robo$$com_android_internal_policy_impl_GlobalActions_3_1$__constructor__(3 var1_1) {
                    }

                    private final void $$robo$$com_android_internal_policy_impl_GlobalActions_3_1$onClick(DialogInterface dialog, int which) {
                        if (ActivityManager.isUserAMonkey()) {
                            return;
                        }
                        this.this$1.this$0.mHandler.postDelayed(new Runnable(this){
                            public transient /* synthetic */ Object __robo_data__;
                            /* synthetic */ 1 this$2;

                            private void $$robo$$com_android_internal_policy_impl_GlobalActions_3_1_1$__constructor__(1 var1_1) {
                            }

                            private final void $$robo$$com_android_internal_policy_impl_GlobalActions_3_1_1$run() {
                                try {
                                    ActivityManagerNative.getDefault().requestBugReport();
                                }
                                catch (RemoteException remoteException) {
                                    // empty catch block
                                }
                            }

                            private void __constructor__(1 var1_1) {
                                this.$$robo$$com_android_internal_policy_impl_GlobalActions_3_1_1$__constructor__(var1_1);
                            }
                            {
                                this.this$2 = var1_1;
                                this.$$robo$init();
                                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_policy_impl_GlobalActions_3_1_1$__constructor__(com.android.internal.policy.impl.GlobalActions$3$1 ), 0, this, var1_1);
                            }

                            @Override
                            public void run() {
                                InvokeDynamicSupport.bootstrap("run", $$robo$$com_android_internal_policy_impl_GlobalActions_3_1_1$run(), 0, this);
                            }
                            {
                                this.$$robo$init();
                            }

                            protected /* synthetic */ void $$robo$init() {
                                if (this.__robo_data__ == null) {
                                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                                }
                            }

                            public /* synthetic */ Object $$robo$getData() {
                                return this.__robo_data__;
                            }
                        }, 500L);
                    }

                    private void __constructor__(3 var1_1) {
                        this.$$robo$$com_android_internal_policy_impl_GlobalActions_3_1$__constructor__(var1_1);
                    }
                    {
                        this.this$1 = var1_1;
                        this.$$robo$init();
                        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_policy_impl_GlobalActions_3_1$__constructor__(com.android.internal.policy.impl.GlobalActions$3 ), 0, this, var1_1);
                    }

                    @Override
                    public void onClick(DialogInterface dialogInterface, int n) {
                        InvokeDynamicSupport.bootstrap("onClick", $$robo$$com_android_internal_policy_impl_GlobalActions_3_1$onClick(android.content.DialogInterface int ), 0, this, dialogInterface, n);
                    }
                    {
                        this.$$robo$init();
                    }

                    protected /* synthetic */ void $$robo$init() {
                        if (this.__robo_data__ == null) {
                            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                        }
                    }

                    public /* synthetic */ Object $$robo$getData() {
                        return this.__robo_data__;
                    }
                });
                AlertDialog dialog = builder.create();
                dialog.getWindow().setType(2009);
                dialog.show();
            }

            private final boolean $$robo$$com_android_internal_policy_impl_GlobalActions_3$showDuringKeyguard() {
                return true;
            }

            private final boolean $$robo$$com_android_internal_policy_impl_GlobalActions_3$showBeforeProvisioning() {
                return false;
            }

            private final String $$robo$$com_android_internal_policy_impl_GlobalActions_3$getStatus() {
                return this.this$0.mContext.getString(17039610, Build.VERSION.RELEASE, Build.ID);
            }

            private void __constructor__(GlobalActions globalActions, int n, int n2) {
                this.$$robo$$com_android_internal_policy_impl_GlobalActions_3$__constructor__(globalActions, n, n2);
            }
            {
                this.this$0 = globalActions;
                super(n, n2);
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_policy_impl_GlobalActions_3$__constructor__(com.android.internal.policy.impl.GlobalActions int int ), 0, this, globalActions, n, n2);
            }

            @Override
            public void onPress() {
                InvokeDynamicSupport.bootstrap("onPress", $$robo$$com_android_internal_policy_impl_GlobalActions_3$onPress(), 0, this);
            }

            @Override
            public boolean showDuringKeyguard() {
                return (boolean)InvokeDynamicSupport.bootstrap("showDuringKeyguard", $$robo$$com_android_internal_policy_impl_GlobalActions_3$showDuringKeyguard(), 0, this);
            }

            @Override
            public boolean showBeforeProvisioning() {
                return (boolean)InvokeDynamicSupport.bootstrap("showBeforeProvisioning", $$robo$$com_android_internal_policy_impl_GlobalActions_3$showBeforeProvisioning(), 0, this);
            }

            @Override
            public String getStatus() {
                return InvokeDynamicSupport.bootstrap("getStatus", $$robo$$com_android_internal_policy_impl_GlobalActions_3$getStatus(), 0, this);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
    }

    private final Action $$robo$$com_android_internal_policy_impl_GlobalActions$getSettingsAction() {
        return new ShadowedObject(this, 17302585, 0x1040101){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ GlobalActions this$0;

            private void $$robo$$com_android_internal_policy_impl_GlobalActions_4$__constructor__(GlobalActions globalActions, int x0, int x1) {
            }

            private final void $$robo$$com_android_internal_policy_impl_GlobalActions_4$onPress() {
                Intent intent = new Intent("android.settings.SETTINGS");
                intent.addFlags(0x14000000);
                this.this$0.mContext.startActivity(intent);
            }

            private final boolean $$robo$$com_android_internal_policy_impl_GlobalActions_4$showDuringKeyguard() {
                return true;
            }

            private final boolean $$robo$$com_android_internal_policy_impl_GlobalActions_4$showBeforeProvisioning() {
                return true;
            }

            private void __constructor__(GlobalActions globalActions, int n, int n2) {
                this.$$robo$$com_android_internal_policy_impl_GlobalActions_4$__constructor__(globalActions, n, n2);
            }
            {
                this.this$0 = globalActions;
                super(n, n2);
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_policy_impl_GlobalActions_4$__constructor__(com.android.internal.policy.impl.GlobalActions int int ), 0, this, globalActions, n, n2);
            }

            @Override
            public void onPress() {
                InvokeDynamicSupport.bootstrap("onPress", $$robo$$com_android_internal_policy_impl_GlobalActions_4$onPress(), 0, this);
            }

            @Override
            public boolean showDuringKeyguard() {
                return (boolean)InvokeDynamicSupport.bootstrap("showDuringKeyguard", $$robo$$com_android_internal_policy_impl_GlobalActions_4$showDuringKeyguard(), 0, this);
            }

            @Override
            public boolean showBeforeProvisioning() {
                return (boolean)InvokeDynamicSupport.bootstrap("showBeforeProvisioning", $$robo$$com_android_internal_policy_impl_GlobalActions_4$showBeforeProvisioning(), 0, this);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
    }

    private final Action $$robo$$com_android_internal_policy_impl_GlobalActions$getLockdownAction() {
        return new ShadowedObject(this, 17301551, 17039618){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ GlobalActions this$0;

            private void $$robo$$com_android_internal_policy_impl_GlobalActions_5$__constructor__(GlobalActions globalActions, int x0, int x1) {
            }

            private final void $$robo$$com_android_internal_policy_impl_GlobalActions_5$onPress() {
                new LockPatternUtils(this.this$0.mContext).requireCredentialEntry(-1);
                try {
                    WindowManagerGlobal.getWindowManagerService().lockNow(null);
                }
                catch (RemoteException e) {
                    Log.e("GlobalActions", "Error while trying to lock device.", e);
                }
            }

            private final boolean $$robo$$com_android_internal_policy_impl_GlobalActions_5$showDuringKeyguard() {
                return true;
            }

            private final boolean $$robo$$com_android_internal_policy_impl_GlobalActions_5$showBeforeProvisioning() {
                return false;
            }

            private void __constructor__(GlobalActions globalActions, int n, int n2) {
                this.$$robo$$com_android_internal_policy_impl_GlobalActions_5$__constructor__(globalActions, n, n2);
            }
            {
                this.this$0 = globalActions;
                super(n, n2);
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_policy_impl_GlobalActions_5$__constructor__(com.android.internal.policy.impl.GlobalActions int int ), 0, this, globalActions, n, n2);
            }

            @Override
            public void onPress() {
                InvokeDynamicSupport.bootstrap("onPress", $$robo$$com_android_internal_policy_impl_GlobalActions_5$onPress(), 0, this);
            }

            @Override
            public boolean showDuringKeyguard() {
                return (boolean)InvokeDynamicSupport.bootstrap("showDuringKeyguard", $$robo$$com_android_internal_policy_impl_GlobalActions_5$showDuringKeyguard(), 0, this);
            }

            @Override
            public boolean showBeforeProvisioning() {
                return (boolean)InvokeDynamicSupport.bootstrap("showBeforeProvisioning", $$robo$$com_android_internal_policy_impl_GlobalActions_5$showBeforeProvisioning(), 0, this);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
    }

    private final UserInfo $$robo$$com_android_internal_policy_impl_GlobalActions$getCurrentUser() {
        try {
            return ActivityManagerNative.getDefault().getCurrentUser();
        }
        catch (RemoteException re) {
            return null;
        }
    }

    private final boolean $$robo$$com_android_internal_policy_impl_GlobalActions$isCurrentUserOwner() {
        UserInfo currentUser = this.getCurrentUser();
        return currentUser == null || currentUser.isPrimary();
    }

    private final void $$robo$$com_android_internal_policy_impl_GlobalActions$addUsersToMenu(ArrayList<Action> items) {
        UserManager um = (UserManager)this.mContext.getSystemService("user");
        if (um.isUserSwitcherEnabled()) {
            List<UserInfo> users = um.getUsers();
            UserInfo currentUser = this.getCurrentUser();
            for (UserInfo user : users) {
                if (!user.supportsSwitchTo()) continue;
                boolean isCurrentUser = currentUser == null ? user.id == 0 : currentUser.id == user.id;
                Drawable icon = user.iconPath != null ? Drawable.createFromPath(user.iconPath) : null;
                ShadowedObject switchToUser = new ShadowedObject(this, 17302483, icon, (user.name != null ? user.name : "Primary") + (isCurrentUser ? " \u2714" : ""), user){
                    public transient /* synthetic */ Object __robo_data__;
                    /* synthetic */ UserInfo val$user;
                    /* synthetic */ GlobalActions this$0;

                    private void $$robo$$com_android_internal_policy_impl_GlobalActions_6$__constructor__(GlobalActions globalActions, int x0, Drawable x1, CharSequence x2, UserInfo userInfo) {
                    }

                    private final void $$robo$$com_android_internal_policy_impl_GlobalActions_6$onPress() {
                        try {
                            ActivityManagerNative.getDefault().switchUser(this.val$user.id);
                        }
                        catch (RemoteException re) {
                            Log.e("GlobalActions", "Couldn't switch user " + re);
                        }
                    }

                    private final boolean $$robo$$com_android_internal_policy_impl_GlobalActions_6$showDuringKeyguard() {
                        return true;
                    }

                    private final boolean $$robo$$com_android_internal_policy_impl_GlobalActions_6$showBeforeProvisioning() {
                        return false;
                    }

                    private void __constructor__(GlobalActions globalActions, int n, Drawable drawable2, CharSequence charSequence, UserInfo userInfo) {
                        this.$$robo$$com_android_internal_policy_impl_GlobalActions_6$__constructor__(globalActions, n, drawable2, charSequence, userInfo);
                    }
                    {
                        this.this$0 = globalActions;
                        this.val$user = userInfo;
                        super(n, drawable2, charSequence);
                        this.$$robo$init();
                        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_policy_impl_GlobalActions_6$__constructor__(com.android.internal.policy.impl.GlobalActions int android.graphics.drawable.Drawable java.lang.CharSequence android.content.pm.UserInfo ), 0, this, globalActions, n, drawable2, charSequence, userInfo);
                    }

                    @Override
                    public void onPress() {
                        InvokeDynamicSupport.bootstrap("onPress", $$robo$$com_android_internal_policy_impl_GlobalActions_6$onPress(), 0, this);
                    }

                    @Override
                    public boolean showDuringKeyguard() {
                        return (boolean)InvokeDynamicSupport.bootstrap("showDuringKeyguard", $$robo$$com_android_internal_policy_impl_GlobalActions_6$showDuringKeyguard(), 0, this);
                    }

                    @Override
                    public boolean showBeforeProvisioning() {
                        return (boolean)InvokeDynamicSupport.bootstrap("showBeforeProvisioning", $$robo$$com_android_internal_policy_impl_GlobalActions_6$showBeforeProvisioning(), 0, this);
                    }
                    {
                        this.$$robo$init();
                    }

                    @Override
                    protected /* synthetic */ void $$robo$init() {
                        if (this.__robo_data__ == null) {
                            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                        }
                    }

                    @Override
                    public /* synthetic */ Object $$robo$getData() {
                        return this.__robo_data__;
                    }
                };
                items.add((Action)switchToUser);
            }
        }
    }

    private final void $$robo$$com_android_internal_policy_impl_GlobalActions$prepareDialog() {
        this.refreshSilentMode();
        this.mAirplaneModeOn.updateState(this.mAirplaneState);
        this.mAdapter.notifyDataSetChanged();
        this.mDialog.getWindow().setType(2009);
        if (this.mShowSilentToggle) {
            IntentFilter filter = new IntentFilter("android.media.RINGER_MODE_CHANGED");
            this.mContext.registerReceiver(this.mRingerModeReceiver, filter);
        }
    }

    private final void $$robo$$com_android_internal_policy_impl_GlobalActions$refreshSilentMode() {
        if (!this.mHasVibrator) {
            boolean silentModeOn = this.mAudioManager.getRingerMode() != 2;
            ((ToggleAction)this.mSilentModeAction).updateState(silentModeOn ? ToggleAction.State.On : ToggleAction.State.Off);
        }
    }

    private final void $$robo$$com_android_internal_policy_impl_GlobalActions$onDismiss(DialogInterface dialog) {
        if (this.mShowSilentToggle) {
            try {
                this.mContext.unregisterReceiver(this.mRingerModeReceiver);
            }
            catch (IllegalArgumentException ie) {
                Log.w("GlobalActions", ie);
            }
        }
    }

    private final void $$robo$$com_android_internal_policy_impl_GlobalActions$onClick(DialogInterface dialog, int which) {
        if (!(this.mAdapter.getItem(which) instanceof SilentModeTriStateAction)) {
            dialog.dismiss();
        }
        this.mAdapter.getItem(which).onPress();
    }

    private final void $$robo$$com_android_internal_policy_impl_GlobalActions$onAirplaneModeChanged() {
        if (this.mHasTelephony) {
            return;
        }
        boolean airplaneModeOn = Settings.Global.getInt(this.mContext.getContentResolver(), "airplane_mode_on", 0) == 1;
        this.mAirplaneState = airplaneModeOn ? ToggleAction.State.On : ToggleAction.State.Off;
        this.mAirplaneModeOn.updateState(this.mAirplaneState);
    }

    private final void $$robo$$com_android_internal_policy_impl_GlobalActions$changeAirplaneModeSystemSetting(boolean on) {
        Settings.Global.putInt(this.mContext.getContentResolver(), "airplane_mode_on", on ? 1 : 0);
        Intent intent = new Intent("android.intent.action.AIRPLANE_MODE");
        intent.addFlags(0x20000000);
        intent.putExtra("state", on);
        this.mContext.sendBroadcastAsUser(intent, UserHandle.ALL);
        if (!this.mHasTelephony) {
            this.mAirplaneState = on ? ToggleAction.State.On : ToggleAction.State.Off;
        }
    }

    private void __constructor__(Context context, WindowManagerPolicy.WindowManagerFuncs windowManagerFuncs) {
        this.$$robo$$com_android_internal_policy_impl_GlobalActions$__constructor__(context, windowManagerFuncs);
    }

    public GlobalActions(Context context, WindowManagerPolicy.WindowManagerFuncs windowManagerFuncs) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_policy_impl_GlobalActions$__constructor__(android.content.Context android.view.WindowManagerPolicy$WindowManagerFuncs ), 0, this, context, windowManagerFuncs);
    }

    public void showDialog(boolean bl, boolean bl2) {
        InvokeDynamicSupport.bootstrap("showDialog", $$robo$$com_android_internal_policy_impl_GlobalActions$showDialog(boolean boolean ), 0, this, bl, bl2);
    }

    private void awakenIfNecessary() {
        InvokeDynamicSupport.bootstrap("awakenIfNecessary", $$robo$$com_android_internal_policy_impl_GlobalActions$awakenIfNecessary(), 0, this);
    }

    private void handleShow() {
        InvokeDynamicSupport.bootstrap("handleShow", $$robo$$com_android_internal_policy_impl_GlobalActions$handleShow(), 0, this);
    }

    private GlobalActionsDialog createDialog() {
        return InvokeDynamicSupport.bootstrap("createDialog", $$robo$$com_android_internal_policy_impl_GlobalActions$createDialog(), 0, this);
    }

    private Action getBugReportAction() {
        return InvokeDynamicSupport.bootstrap("getBugReportAction", $$robo$$com_android_internal_policy_impl_GlobalActions$getBugReportAction(), 0, this);
    }

    private Action getSettingsAction() {
        return InvokeDynamicSupport.bootstrap("getSettingsAction", $$robo$$com_android_internal_policy_impl_GlobalActions$getSettingsAction(), 0, this);
    }

    private Action getLockdownAction() {
        return InvokeDynamicSupport.bootstrap("getLockdownAction", $$robo$$com_android_internal_policy_impl_GlobalActions$getLockdownAction(), 0, this);
    }

    private UserInfo getCurrentUser() {
        return InvokeDynamicSupport.bootstrap("getCurrentUser", $$robo$$com_android_internal_policy_impl_GlobalActions$getCurrentUser(), 0, this);
    }

    private boolean isCurrentUserOwner() {
        return (boolean)InvokeDynamicSupport.bootstrap("isCurrentUserOwner", $$robo$$com_android_internal_policy_impl_GlobalActions$isCurrentUserOwner(), 0, this);
    }

    private void addUsersToMenu(ArrayList<Action> arrayList) {
        InvokeDynamicSupport.bootstrap("addUsersToMenu", $$robo$$com_android_internal_policy_impl_GlobalActions$addUsersToMenu(java.util.ArrayList<com.android.internal.policy.impl.GlobalActions$Action> ), 0, this, arrayList);
    }

    private void prepareDialog() {
        InvokeDynamicSupport.bootstrap("prepareDialog", $$robo$$com_android_internal_policy_impl_GlobalActions$prepareDialog(), 0, this);
    }

    private void refreshSilentMode() {
        InvokeDynamicSupport.bootstrap("refreshSilentMode", $$robo$$com_android_internal_policy_impl_GlobalActions$refreshSilentMode(), 0, this);
    }

    @Override
    public void onDismiss(DialogInterface dialogInterface) {
        InvokeDynamicSupport.bootstrap("onDismiss", $$robo$$com_android_internal_policy_impl_GlobalActions$onDismiss(android.content.DialogInterface ), 0, this, dialogInterface);
    }

    @Override
    public void onClick(DialogInterface dialogInterface, int n) {
        InvokeDynamicSupport.bootstrap("onClick", $$robo$$com_android_internal_policy_impl_GlobalActions$onClick(android.content.DialogInterface int ), 0, this, dialogInterface, n);
    }

    private void onAirplaneModeChanged() {
        InvokeDynamicSupport.bootstrap("onAirplaneModeChanged", $$robo$$com_android_internal_policy_impl_GlobalActions$onAirplaneModeChanged(), 0, this);
    }

    private void changeAirplaneModeSystemSetting(boolean bl) {
        InvokeDynamicSupport.bootstrap("changeAirplaneModeSystemSetting", $$robo$$com_android_internal_policy_impl_GlobalActions$changeAirplaneModeSystemSetting(boolean ), 0, this, bl);
    }

    public /* synthetic */ GlobalActions() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (GlobalActions)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    private static final class GlobalActionsDialog
    extends Dialog
    implements DialogInterface,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private Context mContext;
        private int mWindowTouchSlop;
        private AlertController mAlert;
        private MyAdapter mAdapter;
        private EnableAccessibilityController mEnableAccessibilityController;
        private boolean mIntercepted;
        private boolean mCancelOnUp;

        private void $$robo$$com_android_internal_policy_impl_GlobalActions_GlobalActionsDialog$__constructor__(Context context, AlertController.AlertParams params) {
            this.mContext = context;
            this.mAlert = new AlertController(this.mContext, this, this.getWindow());
            this.mAdapter = (MyAdapter)params.mAdapter;
            this.mWindowTouchSlop = ViewConfiguration.get(context).getScaledWindowTouchSlop();
            params.apply(this.mAlert);
        }

        private static final int $$robo$$com_android_internal_policy_impl_GlobalActions_GlobalActionsDialog$getDialogTheme(Context context) {
            TypedValue outValue = new TypedValue();
            context.getTheme().resolveAttribute(16843529, outValue, true);
            return outValue.resourceId;
        }

        private final void $$robo$$com_android_internal_policy_impl_GlobalActions_GlobalActionsDialog$onStart() {
            if (EnableAccessibilityController.canEnableAccessibilityViaGesture(this.mContext)) {
                this.mEnableAccessibilityController = new EnableAccessibilityController(this.mContext, new Runnable(this){
                    public transient /* synthetic */ Object __robo_data__;
                    /* synthetic */ GlobalActionsDialog this$0;

                    private void $$robo$$com_android_internal_policy_impl_GlobalActions_GlobalActionsDialog_1$__constructor__(GlobalActionsDialog globalActionsDialog) {
                    }

                    private final void $$robo$$com_android_internal_policy_impl_GlobalActions_GlobalActionsDialog_1$run() {
                        this.this$0.dismiss();
                    }

                    private void __constructor__(GlobalActionsDialog globalActionsDialog) {
                        this.$$robo$$com_android_internal_policy_impl_GlobalActions_GlobalActionsDialog_1$__constructor__(globalActionsDialog);
                    }
                    {
                        this.this$0 = globalActionsDialog;
                        this.$$robo$init();
                        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_policy_impl_GlobalActions_GlobalActionsDialog_1$__constructor__(com.android.internal.policy.impl.GlobalActions$GlobalActionsDialog ), 0, this, globalActionsDialog);
                    }

                    @Override
                    public void run() {
                        InvokeDynamicSupport.bootstrap("run", $$robo$$com_android_internal_policy_impl_GlobalActions_GlobalActionsDialog_1$run(), 0, this);
                    }
                    {
                        this.$$robo$init();
                    }

                    protected /* synthetic */ void $$robo$init() {
                        if (this.__robo_data__ == null) {
                            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                        }
                    }

                    public /* synthetic */ Object $$robo$getData() {
                        return this.__robo_data__;
                    }
                });
                super.setCanceledOnTouchOutside(false);
            } else {
                this.mEnableAccessibilityController = null;
                super.setCanceledOnTouchOutside(true);
            }
            super.onStart();
        }

        private final void $$robo$$com_android_internal_policy_impl_GlobalActions_GlobalActionsDialog$onStop() {
            if (this.mEnableAccessibilityController != null) {
                this.mEnableAccessibilityController.onDestroy();
            }
            super.onStop();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final boolean $$robo$$com_android_internal_policy_impl_GlobalActions_GlobalActionsDialog$dispatchTouchEvent(MotionEvent event) {
            block10: {
                if (this.mEnableAccessibilityController != null) {
                    int action = event.getActionMasked();
                    if (action == 0) {
                        View decor = this.getWindow().getDecorView();
                        int eventX = (int)event.getX();
                        int eventY = (int)event.getY();
                        if (eventX < -this.mWindowTouchSlop || eventY < -this.mWindowTouchSlop || eventX >= decor.getWidth() + this.mWindowTouchSlop || eventY >= decor.getHeight() + this.mWindowTouchSlop) {
                            this.mCancelOnUp = true;
                        }
                    }
                    try {
                        if (!this.mIntercepted) {
                            this.mIntercepted = this.mEnableAccessibilityController.onInterceptTouchEvent(event);
                            if (this.mIntercepted) {
                                long now = SystemClock.uptimeMillis();
                                event = MotionEvent.obtain(now, now, 3, 0.0f, 0.0f, 0);
                                event.setSource(4098);
                                this.mCancelOnUp = true;
                            }
                            break block10;
                        }
                        boolean bl = this.mEnableAccessibilityController.onTouchEvent(event);
                        return bl;
                    }
                    finally {
                        if (action == 1) {
                            if (this.mCancelOnUp) {
                                this.cancel();
                            }
                            this.mCancelOnUp = false;
                            this.mIntercepted = false;
                        }
                    }
                }
            }
            return super.dispatchTouchEvent(event);
        }

        private final ListView $$robo$$com_android_internal_policy_impl_GlobalActions_GlobalActionsDialog$getListView() {
            return this.mAlert.getListView();
        }

        private final void $$robo$$com_android_internal_policy_impl_GlobalActions_GlobalActionsDialog$onCreate(Bundle savedInstanceState) {
            super.onCreate(savedInstanceState);
            this.mAlert.installContent();
        }

        private final boolean $$robo$$com_android_internal_policy_impl_GlobalActions_GlobalActionsDialog$dispatchPopulateAccessibilityEvent(AccessibilityEvent event) {
            if (event.getEventType() == 32) {
                for (int i = 0; i < this.mAdapter.getCount(); ++i) {
                    CharSequence label = this.mAdapter.getItem(i).getLabelForAccessibility(this.getContext());
                    if (label == null) continue;
                    event.getText().add(label);
                }
            }
            return super.dispatchPopulateAccessibilityEvent(event);
        }

        private final boolean $$robo$$com_android_internal_policy_impl_GlobalActions_GlobalActionsDialog$onKeyDown(int keyCode, KeyEvent event) {
            if (this.mAlert.onKeyDown(keyCode, event)) {
                return true;
            }
            return super.onKeyDown(keyCode, event);
        }

        private final boolean $$robo$$com_android_internal_policy_impl_GlobalActions_GlobalActionsDialog$onKeyUp(int keyCode, KeyEvent event) {
            if (this.mAlert.onKeyUp(keyCode, event)) {
                return true;
            }
            return super.onKeyUp(keyCode, event);
        }

        private void __constructor__(Context context, AlertController.AlertParams alertParams) {
            this.$$robo$$com_android_internal_policy_impl_GlobalActions_GlobalActionsDialog$__constructor__(context, alertParams);
        }

        public GlobalActionsDialog(Context context, AlertController.AlertParams alertParams) {
            super(context, GlobalActionsDialog.getDialogTheme(context));
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_policy_impl_GlobalActions_GlobalActionsDialog$__constructor__(android.content.Context com.android.internal.app.AlertController$AlertParams ), 0, this, context, alertParams);
        }

        private static int getDialogTheme(Context context) {
            return (int)InvokeDynamicSupport.bootstrapStatic("getDialogTheme", $$robo$$com_android_internal_policy_impl_GlobalActions_GlobalActionsDialog$getDialogTheme(android.content.Context ), 0, (Context)context);
        }

        @Override
        protected void onStart() {
            InvokeDynamicSupport.bootstrap("onStart", $$robo$$com_android_internal_policy_impl_GlobalActions_GlobalActionsDialog$onStart(), 0, this);
        }

        @Override
        protected void onStop() {
            InvokeDynamicSupport.bootstrap("onStop", $$robo$$com_android_internal_policy_impl_GlobalActions_GlobalActionsDialog$onStop(), 0, this);
        }

        @Override
        public boolean dispatchTouchEvent(MotionEvent motionEvent) {
            return (boolean)InvokeDynamicSupport.bootstrap("dispatchTouchEvent", $$robo$$com_android_internal_policy_impl_GlobalActions_GlobalActionsDialog$dispatchTouchEvent(android.view.MotionEvent ), 0, this, motionEvent);
        }

        public ListView getListView() {
            return InvokeDynamicSupport.bootstrap("getListView", $$robo$$com_android_internal_policy_impl_GlobalActions_GlobalActionsDialog$getListView(), 0, this);
        }

        @Override
        protected void onCreate(Bundle bundle) {
            InvokeDynamicSupport.bootstrap("onCreate", $$robo$$com_android_internal_policy_impl_GlobalActions_GlobalActionsDialog$onCreate(android.os.Bundle ), 0, this, bundle);
        }

        @Override
        public boolean dispatchPopulateAccessibilityEvent(AccessibilityEvent accessibilityEvent) {
            return (boolean)InvokeDynamicSupport.bootstrap("dispatchPopulateAccessibilityEvent", $$robo$$com_android_internal_policy_impl_GlobalActions_GlobalActionsDialog$dispatchPopulateAccessibilityEvent(android.view.accessibility.AccessibilityEvent ), 0, this, accessibilityEvent);
        }

        @Override
        public boolean onKeyDown(int n, KeyEvent keyEvent) {
            return (boolean)InvokeDynamicSupport.bootstrap("onKeyDown", $$robo$$com_android_internal_policy_impl_GlobalActions_GlobalActionsDialog$onKeyDown(int android.view.KeyEvent ), 0, this, n, keyEvent);
        }

        @Override
        public boolean onKeyUp(int n, KeyEvent keyEvent) {
            return (boolean)InvokeDynamicSupport.bootstrap("onKeyUp", $$robo$$com_android_internal_policy_impl_GlobalActions_GlobalActionsDialog$onKeyUp(int android.view.KeyEvent ), 0, this, n, keyEvent);
        }

        public /* synthetic */ GlobalActionsDialog() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (GlobalActionsDialog)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private static class SilentModeTriStateAction
    implements Action,
    View.OnClickListener,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private int[] ITEM_IDS;
        private AudioManager mAudioManager;
        private Handler mHandler;
        private Context mContext;

        private void $$robo$$com_android_internal_policy_impl_GlobalActions_SilentModeTriStateAction$__constructor__(Context context, AudioManager audioManager, Handler handler) {
            this.ITEM_IDS = new int[]{16909044, 16909045, 16909046};
            this.mAudioManager = audioManager;
            this.mHandler = handler;
            this.mContext = context;
        }

        private final int $$robo$$com_android_internal_policy_impl_GlobalActions_SilentModeTriStateAction$ringerModeToIndex(int ringerMode) {
            return ringerMode;
        }

        private final int $$robo$$com_android_internal_policy_impl_GlobalActions_SilentModeTriStateAction$indexToRingerMode(int index) {
            return index;
        }

        private final CharSequence $$robo$$com_android_internal_policy_impl_GlobalActions_SilentModeTriStateAction$getLabelForAccessibility(Context context) {
            return null;
        }

        private final View $$robo$$com_android_internal_policy_impl_GlobalActions_SilentModeTriStateAction$create(Context context, View convertView, ViewGroup parent, LayoutInflater inflater) {
            View v = inflater.inflate(17367125, parent, false);
            int selectedIndex = this.ringerModeToIndex(this.mAudioManager.getRingerMode());
            for (int i = 0; i < 3; ++i) {
                View itemView = v.findViewById(this.ITEM_IDS[i]);
                itemView.setSelected(selectedIndex == i);
                itemView.setTag(i);
                itemView.setOnClickListener(this);
            }
            return v;
        }

        private final void $$robo$$com_android_internal_policy_impl_GlobalActions_SilentModeTriStateAction$onPress() {
        }

        private final boolean $$robo$$com_android_internal_policy_impl_GlobalActions_SilentModeTriStateAction$showDuringKeyguard() {
            return true;
        }

        private final boolean $$robo$$com_android_internal_policy_impl_GlobalActions_SilentModeTriStateAction$showBeforeProvisioning() {
            return false;
        }

        private final boolean $$robo$$com_android_internal_policy_impl_GlobalActions_SilentModeTriStateAction$isEnabled() {
            return true;
        }

        private final void $$robo$$com_android_internal_policy_impl_GlobalActions_SilentModeTriStateAction$willCreate() {
        }

        private final void $$robo$$com_android_internal_policy_impl_GlobalActions_SilentModeTriStateAction$onClick(View v) {
            if (!(v.getTag() instanceof Integer)) {
                return;
            }
            int index = (Integer)v.getTag();
            this.mAudioManager.setRingerMode(this.indexToRingerMode(index));
            this.mHandler.sendEmptyMessageDelayed(0, 300L);
        }

        private void __constructor__(Context context, AudioManager audioManager, Handler handler) {
            this.$$robo$$com_android_internal_policy_impl_GlobalActions_SilentModeTriStateAction$__constructor__(context, audioManager, handler);
        }

        SilentModeTriStateAction(Context context, AudioManager audioManager, Handler handler) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_policy_impl_GlobalActions_SilentModeTriStateAction$__constructor__(android.content.Context android.media.AudioManager android.os.Handler ), 0, this, context, audioManager, handler);
        }

        private int ringerModeToIndex(int n) {
            return (int)InvokeDynamicSupport.bootstrap("ringerModeToIndex", $$robo$$com_android_internal_policy_impl_GlobalActions_SilentModeTriStateAction$ringerModeToIndex(int ), 0, this, n);
        }

        private int indexToRingerMode(int n) {
            return (int)InvokeDynamicSupport.bootstrap("indexToRingerMode", $$robo$$com_android_internal_policy_impl_GlobalActions_SilentModeTriStateAction$indexToRingerMode(int ), 0, this, n);
        }

        @Override
        public CharSequence getLabelForAccessibility(Context context) {
            return InvokeDynamicSupport.bootstrap("getLabelForAccessibility", $$robo$$com_android_internal_policy_impl_GlobalActions_SilentModeTriStateAction$getLabelForAccessibility(android.content.Context ), 0, this, context);
        }

        @Override
        public View create(Context context, View view, ViewGroup viewGroup, LayoutInflater layoutInflater) {
            return InvokeDynamicSupport.bootstrap("create", $$robo$$com_android_internal_policy_impl_GlobalActions_SilentModeTriStateAction$create(android.content.Context android.view.View android.view.ViewGroup android.view.LayoutInflater ), 0, this, context, view, viewGroup, layoutInflater);
        }

        @Override
        public void onPress() {
            InvokeDynamicSupport.bootstrap("onPress", $$robo$$com_android_internal_policy_impl_GlobalActions_SilentModeTriStateAction$onPress(), 0, this);
        }

        @Override
        public boolean showDuringKeyguard() {
            return (boolean)InvokeDynamicSupport.bootstrap("showDuringKeyguard", $$robo$$com_android_internal_policy_impl_GlobalActions_SilentModeTriStateAction$showDuringKeyguard(), 0, this);
        }

        @Override
        public boolean showBeforeProvisioning() {
            return (boolean)InvokeDynamicSupport.bootstrap("showBeforeProvisioning", $$robo$$com_android_internal_policy_impl_GlobalActions_SilentModeTriStateAction$showBeforeProvisioning(), 0, this);
        }

        @Override
        public boolean isEnabled() {
            return (boolean)InvokeDynamicSupport.bootstrap("isEnabled", $$robo$$com_android_internal_policy_impl_GlobalActions_SilentModeTriStateAction$isEnabled(), 0, this);
        }

        void willCreate() {
            InvokeDynamicSupport.bootstrap("willCreate", $$robo$$com_android_internal_policy_impl_GlobalActions_SilentModeTriStateAction$willCreate(), 0, this);
        }

        @Override
        public void onClick(View view) {
            InvokeDynamicSupport.bootstrap("onClick", $$robo$$com_android_internal_policy_impl_GlobalActions_SilentModeTriStateAction$onClick(android.view.View ), 0, this, view);
        }

        public /* synthetic */ SilentModeTriStateAction() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SilentModeTriStateAction)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private class SilentModeToggleAction
    extends ToggleAction
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        /* synthetic */ GlobalActions this$0;

        private void $$robo$$com_android_internal_policy_impl_GlobalActions_SilentModeToggleAction$__constructor__(GlobalActions globalActions) {
        }

        private final void $$robo$$com_android_internal_policy_impl_GlobalActions_SilentModeToggleAction$onToggle(boolean on) {
            if (on) {
                this.this$0.mAudioManager.setRingerMode(0);
            } else {
                this.this$0.mAudioManager.setRingerMode(2);
            }
        }

        private final boolean $$robo$$com_android_internal_policy_impl_GlobalActions_SilentModeToggleAction$showDuringKeyguard() {
            return true;
        }

        private final boolean $$robo$$com_android_internal_policy_impl_GlobalActions_SilentModeToggleAction$showBeforeProvisioning() {
            return false;
        }

        private void __constructor__(GlobalActions globalActions) {
            this.$$robo$$com_android_internal_policy_impl_GlobalActions_SilentModeToggleAction$__constructor__(globalActions);
        }

        public SilentModeToggleAction(GlobalActions globalActions) {
            this.this$0 = globalActions;
            super(17302314, 17302313, 17039611, 17039612, 17039613);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_policy_impl_GlobalActions_SilentModeToggleAction$__constructor__(com.android.internal.policy.impl.GlobalActions ), 0, this, globalActions);
        }

        @Override
        void onToggle(boolean bl) {
            InvokeDynamicSupport.bootstrap("onToggle", $$robo$$com_android_internal_policy_impl_GlobalActions_SilentModeToggleAction$onToggle(boolean ), 0, this, bl);
        }

        @Override
        public boolean showDuringKeyguard() {
            return (boolean)InvokeDynamicSupport.bootstrap("showDuringKeyguard", $$robo$$com_android_internal_policy_impl_GlobalActions_SilentModeToggleAction$showDuringKeyguard(), 0, this);
        }

        @Override
        public boolean showBeforeProvisioning() {
            return (boolean)InvokeDynamicSupport.bootstrap("showBeforeProvisioning", $$robo$$com_android_internal_policy_impl_GlobalActions_SilentModeToggleAction$showBeforeProvisioning(), 0, this);
        }

        public /* synthetic */ SilentModeToggleAction() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SilentModeToggleAction)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private static abstract class ToggleAction
    implements Action,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        protected State mState;
        protected int mEnabledIconResId;
        protected int mDisabledIconResid;
        protected int mMessageResId;
        protected int mEnabledStatusMessageResId;
        protected int mDisabledStatusMessageResId;

        private void $$robo$$com_android_internal_policy_impl_GlobalActions_ToggleAction$__constructor__(int enabledIconResId, int disabledIconResid, int message, int enabledStatusMessageResId, int disabledStatusMessageResId) {
            this.mState = State.Off;
            this.mEnabledIconResId = enabledIconResId;
            this.mDisabledIconResid = disabledIconResid;
            this.mMessageResId = message;
            this.mEnabledStatusMessageResId = enabledStatusMessageResId;
            this.mDisabledStatusMessageResId = disabledStatusMessageResId;
        }

        private final void $$robo$$com_android_internal_policy_impl_GlobalActions_ToggleAction$willCreate() {
        }

        private final CharSequence $$robo$$com_android_internal_policy_impl_GlobalActions_ToggleAction$getLabelForAccessibility(Context context) {
            return context.getString(this.mMessageResId);
        }

        private final View $$robo$$com_android_internal_policy_impl_GlobalActions_ToggleAction$create(Context context, View convertView, ViewGroup parent, LayoutInflater inflater) {
            boolean on;
            this.willCreate();
            View v = inflater.inflate(17367124, parent, false);
            ImageView icon = (ImageView)v.findViewById(16908294);
            TextView messageView = (TextView)v.findViewById(16908299);
            TextView statusView = (TextView)v.findViewById(16909043);
            boolean enabled = this.isEnabled();
            if (messageView != null) {
                messageView.setText(this.mMessageResId);
                messageView.setEnabled(enabled);
            }
            boolean bl = on = this.mState == State.On || this.mState == State.TurningOn;
            if (icon != null) {
                icon.setImageDrawable(context.getDrawable(on ? this.mEnabledIconResId : this.mDisabledIconResid));
                icon.setEnabled(enabled);
            }
            if (statusView != null) {
                statusView.setText(on ? this.mEnabledStatusMessageResId : this.mDisabledStatusMessageResId);
                statusView.setVisibility(0);
                statusView.setEnabled(enabled);
            }
            v.setEnabled(enabled);
            return v;
        }

        private final void $$robo$$com_android_internal_policy_impl_GlobalActions_ToggleAction$onPress() {
            if (this.mState.inTransition()) {
                Log.w("GlobalActions", "shouldn't be able to toggle when in transition");
                return;
            }
            boolean nowOn = this.mState != State.On;
            this.onToggle(nowOn);
            this.changeStateFromPress(nowOn);
        }

        private final boolean $$robo$$com_android_internal_policy_impl_GlobalActions_ToggleAction$isEnabled() {
            return !this.mState.inTransition();
        }

        private final void $$robo$$com_android_internal_policy_impl_GlobalActions_ToggleAction$changeStateFromPress(boolean buttonOn) {
            this.mState = buttonOn ? State.On : State.Off;
        }

        abstract void onToggle(boolean var1);

        private final void $$robo$$com_android_internal_policy_impl_GlobalActions_ToggleAction$updateState(State state) {
            this.mState = state;
        }

        private void __constructor__(int n, int n2, int n3, int n4, int n5) {
            this.$$robo$$com_android_internal_policy_impl_GlobalActions_ToggleAction$__constructor__(n, n2, n3, n4, n5);
        }

        public ToggleAction(int n, int n2, int n3, int n4, int n5) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_policy_impl_GlobalActions_ToggleAction$__constructor__(int int int int int ), 0, this, n, n2, n3, n4, n5);
        }

        void willCreate() {
            InvokeDynamicSupport.bootstrap("willCreate", $$robo$$com_android_internal_policy_impl_GlobalActions_ToggleAction$willCreate(), 0, this);
        }

        @Override
        public CharSequence getLabelForAccessibility(Context context) {
            return InvokeDynamicSupport.bootstrap("getLabelForAccessibility", $$robo$$com_android_internal_policy_impl_GlobalActions_ToggleAction$getLabelForAccessibility(android.content.Context ), 0, this, context);
        }

        @Override
        public View create(Context context, View view, ViewGroup viewGroup, LayoutInflater layoutInflater) {
            return InvokeDynamicSupport.bootstrap("create", $$robo$$com_android_internal_policy_impl_GlobalActions_ToggleAction$create(android.content.Context android.view.View android.view.ViewGroup android.view.LayoutInflater ), 0, this, context, view, viewGroup, layoutInflater);
        }

        @Override
        public void onPress() {
            InvokeDynamicSupport.bootstrap("onPress", $$robo$$com_android_internal_policy_impl_GlobalActions_ToggleAction$onPress(), 0, this);
        }

        @Override
        public boolean isEnabled() {
            return (boolean)InvokeDynamicSupport.bootstrap("isEnabled", $$robo$$com_android_internal_policy_impl_GlobalActions_ToggleAction$isEnabled(), 0, this);
        }

        protected void changeStateFromPress(boolean bl) {
            InvokeDynamicSupport.bootstrap("changeStateFromPress", $$robo$$com_android_internal_policy_impl_GlobalActions_ToggleAction$changeStateFromPress(boolean ), 0, this, bl);
        }

        public void updateState(State state) {
            InvokeDynamicSupport.bootstrap("updateState", $$robo$$com_android_internal_policy_impl_GlobalActions_ToggleAction$updateState(com.android.internal.policy.impl.GlobalActions$ToggleAction$State ), 0, this, state);
        }

        public /* synthetic */ ToggleAction() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ToggleAction)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }

        @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
        public static final class State
        extends Enum<State> {
            public transient /* synthetic */ Object __robo_data__;
            public static /* enum */ State Off;
            public static /* enum */ State TurningOn;
            public static /* enum */ State TurningOff;
            public static /* enum */ State On;
            private boolean inTransition;
            private static /* synthetic */ State[] $VALUES;

            private static final State[] $$robo$$com_android_internal_policy_impl_GlobalActions_ToggleAction_State$values() {
                return (State[])$VALUES.clone();
            }

            private static final State $$robo$$com_android_internal_policy_impl_GlobalActions_ToggleAction_State$valueOf(String name) {
                return Enum.valueOf(State.class, name);
            }

            /*
             * Ignored method signature, as it can't be verified against descriptor
             */
            private void $$robo$$com_android_internal_policy_impl_GlobalActions_ToggleAction_State$__constructor__(String string2, int n, boolean intermediate) {
                this.inTransition = intermediate;
            }

            private final boolean $$robo$$com_android_internal_policy_impl_GlobalActions_ToggleAction_State$inTransition() {
                return this.inTransition;
            }

            static void __staticInitializer__() {
                Off = new State(false);
                TurningOn = new State(true);
                TurningOff = new State(true);
                On = new State(false);
                $VALUES = new State[]{Off, TurningOn, TurningOff, On};
            }

            public static State[] values() {
                return InvokeDynamicSupport.bootstrapStatic("values", $$robo$$com_android_internal_policy_impl_GlobalActions_ToggleAction_State$values(), 0);
            }

            public static State valueOf(String string2) {
                return InvokeDynamicSupport.bootstrapStatic("valueOf", $$robo$$com_android_internal_policy_impl_GlobalActions_ToggleAction_State$valueOf(java.lang.String ), 0, (String)string2);
            }

            /*
             * Ignored method signature, as it can't be verified against descriptor
             */
            private void __constructor__(String string2, int n, boolean bl) {
                this.$$robo$$com_android_internal_policy_impl_GlobalActions_ToggleAction_State$__constructor__(string2, n, bl);
            }

            private State(boolean bl) {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_policy_impl_GlobalActions_ToggleAction_State$__constructor__(java.lang.String int boolean ), 0, this, string2, n, bl);
            }

            public boolean inTransition() {
                return (boolean)InvokeDynamicSupport.bootstrap("inTransition", $$robo$$com_android_internal_policy_impl_GlobalActions_ToggleAction_State$inTransition(), 0, this);
            }

            static {
                RobolectricInternals.classInitializing(State.class);
            }

            public /* synthetic */ State() {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (State)this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        }
    }

    private static abstract class SinglePressAction
    implements Action,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private int mIconResId;
        private Drawable mIcon;
        private int mMessageResId;
        private CharSequence mMessage;

        private void $$robo$$com_android_internal_policy_impl_GlobalActions_SinglePressAction$__constructor__(int iconResId, int messageResId) {
            this.mIconResId = iconResId;
            this.mMessageResId = messageResId;
            this.mMessage = null;
            this.mIcon = null;
        }

        private void $$robo$$com_android_internal_policy_impl_GlobalActions_SinglePressAction$__constructor__(int iconResId, Drawable icon, CharSequence message) {
            this.mIconResId = iconResId;
            this.mMessageResId = 0;
            this.mMessage = message;
            this.mIcon = icon;
        }

        private void $$robo$$com_android_internal_policy_impl_GlobalActions_SinglePressAction$__constructor__(int iconResId, CharSequence message) {
            this.mIconResId = iconResId;
            this.mMessageResId = 0;
            this.mMessage = message;
            this.mIcon = null;
        }

        private final boolean $$robo$$com_android_internal_policy_impl_GlobalActions_SinglePressAction$isEnabled() {
            return true;
        }

        private final String $$robo$$com_android_internal_policy_impl_GlobalActions_SinglePressAction$getStatus() {
            return null;
        }

        @Override
        public abstract void onPress();

        private final CharSequence $$robo$$com_android_internal_policy_impl_GlobalActions_SinglePressAction$getLabelForAccessibility(Context context) {
            if (this.mMessage != null) {
                return this.mMessage;
            }
            return context.getString(this.mMessageResId);
        }

        private final View $$robo$$com_android_internal_policy_impl_GlobalActions_SinglePressAction$create(Context context, View convertView, ViewGroup parent, LayoutInflater inflater) {
            View v = inflater.inflate(17367124, parent, false);
            ImageView icon = (ImageView)v.findViewById(16908294);
            TextView messageView = (TextView)v.findViewById(16908299);
            TextView statusView = (TextView)v.findViewById(16909043);
            String status = this.getStatus();
            if (!TextUtils.isEmpty(status)) {
                statusView.setText(status);
            } else {
                statusView.setVisibility(8);
            }
            if (this.mIcon != null) {
                icon.setImageDrawable(this.mIcon);
                icon.setScaleType(ImageView.ScaleType.CENTER_CROP);
            } else if (this.mIconResId != 0) {
                icon.setImageDrawable(context.getDrawable(this.mIconResId));
            }
            if (this.mMessage != null) {
                messageView.setText(this.mMessage);
            } else {
                messageView.setText(this.mMessageResId);
            }
            return v;
        }

        private void __constructor__(int n, int n2) {
            this.$$robo$$com_android_internal_policy_impl_GlobalActions_SinglePressAction$__constructor__(n, n2);
        }

        protected SinglePressAction(int n, int n2) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_policy_impl_GlobalActions_SinglePressAction$__constructor__(int int ), 0, this, n, n2);
        }

        private void __constructor__(int n, Drawable drawable2, CharSequence charSequence) {
            this.$$robo$$com_android_internal_policy_impl_GlobalActions_SinglePressAction$__constructor__(n, drawable2, charSequence);
        }

        protected SinglePressAction(int n, Drawable drawable2, CharSequence charSequence) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_policy_impl_GlobalActions_SinglePressAction$__constructor__(int android.graphics.drawable.Drawable java.lang.CharSequence ), 0, this, n, drawable2, charSequence);
        }

        private void __constructor__(int n, CharSequence charSequence) {
            this.$$robo$$com_android_internal_policy_impl_GlobalActions_SinglePressAction$__constructor__(n, charSequence);
        }

        protected SinglePressAction(int n, CharSequence charSequence) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_policy_impl_GlobalActions_SinglePressAction$__constructor__(int java.lang.CharSequence ), 0, this, n, charSequence);
        }

        @Override
        public boolean isEnabled() {
            return (boolean)InvokeDynamicSupport.bootstrap("isEnabled", $$robo$$com_android_internal_policy_impl_GlobalActions_SinglePressAction$isEnabled(), 0, this);
        }

        public String getStatus() {
            return InvokeDynamicSupport.bootstrap("getStatus", $$robo$$com_android_internal_policy_impl_GlobalActions_SinglePressAction$getStatus(), 0, this);
        }

        @Override
        public CharSequence getLabelForAccessibility(Context context) {
            return InvokeDynamicSupport.bootstrap("getLabelForAccessibility", $$robo$$com_android_internal_policy_impl_GlobalActions_SinglePressAction$getLabelForAccessibility(android.content.Context ), 0, this, context);
        }

        @Override
        public View create(Context context, View view, ViewGroup viewGroup, LayoutInflater layoutInflater) {
            return InvokeDynamicSupport.bootstrap("create", $$robo$$com_android_internal_policy_impl_GlobalActions_SinglePressAction$create(android.content.Context android.view.View android.view.ViewGroup android.view.LayoutInflater ), 0, this, context, view, viewGroup, layoutInflater);
        }

        public /* synthetic */ SinglePressAction() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SinglePressAction)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private static interface LongPressAction
    extends Action,
    InstrumentedInterface {
        public boolean onLongPress();
    }

    private static interface Action
    extends InstrumentedInterface {
        public CharSequence getLabelForAccessibility(Context var1);

        public View create(Context var1, View var2, ViewGroup var3, LayoutInflater var4);

        public void onPress();

        public boolean showDuringKeyguard();

        public boolean showBeforeProvisioning();

        public boolean isEnabled();
    }

    private class MyAdapter
    extends BaseAdapter
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        /* synthetic */ GlobalActions this$0;

        private void $$robo$$com_android_internal_policy_impl_GlobalActions_MyAdapter$__constructor__(GlobalActions globalActions) {
        }

        private final int $$robo$$com_android_internal_policy_impl_GlobalActions_MyAdapter$getCount() {
            int count = 0;
            for (int i = 0; i < this.this$0.mItems.size(); ++i) {
                Action action = (Action)this.this$0.mItems.get(i);
                if (this.this$0.mKeyguardShowing && !action.showDuringKeyguard() || !this.this$0.mDeviceProvisioned && !action.showBeforeProvisioning()) continue;
                ++count;
            }
            return count;
        }

        private final boolean $$robo$$com_android_internal_policy_impl_GlobalActions_MyAdapter$isEnabled(int position) {
            return this.getItem(position).isEnabled();
        }

        private final boolean $$robo$$com_android_internal_policy_impl_GlobalActions_MyAdapter$areAllItemsEnabled() {
            return false;
        }

        private final Action $$robo$$com_android_internal_policy_impl_GlobalActions_MyAdapter$getItem(int position) {
            int filteredPos = 0;
            for (int i = 0; i < this.this$0.mItems.size(); ++i) {
                Action action = (Action)this.this$0.mItems.get(i);
                if (this.this$0.mKeyguardShowing && !action.showDuringKeyguard() || !this.this$0.mDeviceProvisioned && !action.showBeforeProvisioning()) continue;
                if (filteredPos == position) {
                    return action;
                }
                ++filteredPos;
            }
            throw new IllegalArgumentException("position " + position + " out of range of showable actions" + ", filtered count=" + this.getCount() + ", keyguardshowing=" + this.this$0.mKeyguardShowing + ", provisioned=" + this.this$0.mDeviceProvisioned);
        }

        private final long $$robo$$com_android_internal_policy_impl_GlobalActions_MyAdapter$getItemId(int position) {
            return position;
        }

        private final View $$robo$$com_android_internal_policy_impl_GlobalActions_MyAdapter$getView(int position, View convertView, ViewGroup parent) {
            Object action = this.getItem(position);
            return action.create(this.this$0.mContext, convertView, parent, LayoutInflater.from(this.this$0.mContext));
        }

        private /* synthetic */ void $$robo$$com_android_internal_policy_impl_GlobalActions_MyAdapter$__constructor__(GlobalActions x0, 1 x1) {
        }

        private void __constructor__(GlobalActions globalActions) {
            this.$$robo$$com_android_internal_policy_impl_GlobalActions_MyAdapter$__constructor__(globalActions);
        }

        private MyAdapter(GlobalActions globalActions) {
            this.this$0 = globalActions;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_policy_impl_GlobalActions_MyAdapter$__constructor__(com.android.internal.policy.impl.GlobalActions ), 0, this, globalActions);
        }

        @Override
        public int getCount() {
            return (int)InvokeDynamicSupport.bootstrap("getCount", $$robo$$com_android_internal_policy_impl_GlobalActions_MyAdapter$getCount(), 0, this);
        }

        @Override
        public boolean isEnabled(int n) {
            return (boolean)InvokeDynamicSupport.bootstrap("isEnabled", $$robo$$com_android_internal_policy_impl_GlobalActions_MyAdapter$isEnabled(int ), 0, this, n);
        }

        @Override
        public boolean areAllItemsEnabled() {
            return (boolean)InvokeDynamicSupport.bootstrap("areAllItemsEnabled", $$robo$$com_android_internal_policy_impl_GlobalActions_MyAdapter$areAllItemsEnabled(), 0, this);
        }

        @Override
        public Action getItem(int n) {
            return InvokeDynamicSupport.bootstrap("getItem", $$robo$$com_android_internal_policy_impl_GlobalActions_MyAdapter$getItem(int ), 0, this, n);
        }

        @Override
        public long getItemId(int n) {
            return (long)InvokeDynamicSupport.bootstrap("getItemId", $$robo$$com_android_internal_policy_impl_GlobalActions_MyAdapter$getItemId(int ), 0, this, n);
        }

        @Override
        public View getView(int n, View view, ViewGroup viewGroup) {
            return InvokeDynamicSupport.bootstrap("getView", $$robo$$com_android_internal_policy_impl_GlobalActions_MyAdapter$getView(int android.view.View android.view.ViewGroup ), 0, this, n, view, viewGroup);
        }

        private /* synthetic */ void __constructor__(GlobalActions globalActions, 1 var2_2) {
            this.$$robo$$com_android_internal_policy_impl_GlobalActions_MyAdapter$__constructor__(globalActions, var2_2);
        }

        public /* synthetic */ MyAdapter() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (MyAdapter)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    private final class PowerAction
    extends SinglePressAction
    implements LongPressAction,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        /* synthetic */ GlobalActions this$0;

        private void $$robo$$com_android_internal_policy_impl_GlobalActions_PowerAction$__constructor__(GlobalActions globalActions) {
        }

        private final boolean $$robo$$com_android_internal_policy_impl_GlobalActions_PowerAction$onLongPress() {
            this.this$0.mWindowManagerFuncs.rebootSafeMode(true);
            return true;
        }

        private final boolean $$robo$$com_android_internal_policy_impl_GlobalActions_PowerAction$showDuringKeyguard() {
            return true;
        }

        private final boolean $$robo$$com_android_internal_policy_impl_GlobalActions_PowerAction$showBeforeProvisioning() {
            return true;
        }

        private final void $$robo$$com_android_internal_policy_impl_GlobalActions_PowerAction$onPress() {
            this.this$0.mWindowManagerFuncs.shutdown(false);
        }

        private /* synthetic */ void $$robo$$com_android_internal_policy_impl_GlobalActions_PowerAction$__constructor__(GlobalActions x0, 1 x1) {
        }

        private void __constructor__(GlobalActions globalActions) {
            this.$$robo$$com_android_internal_policy_impl_GlobalActions_PowerAction$__constructor__(globalActions);
        }

        private PowerAction(GlobalActions globalActions) {
            this.this$0 = globalActions;
            super(17301552, 17039606);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_policy_impl_GlobalActions_PowerAction$__constructor__(com.android.internal.policy.impl.GlobalActions ), 0, this, globalActions);
        }

        @Override
        public boolean onLongPress() {
            return (boolean)InvokeDynamicSupport.bootstrap("onLongPress", $$robo$$com_android_internal_policy_impl_GlobalActions_PowerAction$onLongPress(), 0, this);
        }

        @Override
        public boolean showDuringKeyguard() {
            return (boolean)InvokeDynamicSupport.bootstrap("showDuringKeyguard", $$robo$$com_android_internal_policy_impl_GlobalActions_PowerAction$showDuringKeyguard(), 0, this);
        }

        @Override
        public boolean showBeforeProvisioning() {
            return (boolean)InvokeDynamicSupport.bootstrap("showBeforeProvisioning", $$robo$$com_android_internal_policy_impl_GlobalActions_PowerAction$showBeforeProvisioning(), 0, this);
        }

        @Override
        public void onPress() {
            InvokeDynamicSupport.bootstrap("onPress", $$robo$$com_android_internal_policy_impl_GlobalActions_PowerAction$onPress(), 0, this);
        }

        private /* synthetic */ void __constructor__(GlobalActions globalActions, 1 var2_2) {
            this.$$robo$$com_android_internal_policy_impl_GlobalActions_PowerAction$__constructor__(globalActions, var2_2);
        }

        public /* synthetic */ PowerAction() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (PowerAction)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

