/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.policy.impl;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.res.XmlResourceParser;
import android.os.UserHandle;
import android.util.SparseArray;
import android.view.KeyEvent;
import com.android.internal.util.XmlUtils;
import com.google.errorprone.annotations.DoNotMock;
import java.io.PrintWriter;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class GlobalKeyManager
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "GlobalKeyManager";
    private static String TAG_GLOBAL_KEYS = "global_keys";
    private static String ATTR_VERSION = "version";
    private static String TAG_KEY = "key";
    private static String ATTR_KEY_CODE = "keyCode";
    private static String ATTR_COMPONENT = "component";
    private static int GLOBAL_KEY_FILE_VERSION = 1;
    private SparseArray<ComponentName> mKeyMapping;

    private void $$robo$$com_android_internal_policy_impl_GlobalKeyManager$__constructor__(Context context) {
        this.mKeyMapping = new SparseArray();
        this.loadGlobalKeys(context);
    }

    private final boolean $$robo$$com_android_internal_policy_impl_GlobalKeyManager$handleGlobalKey(Context context, int keyCode, KeyEvent event) {
        ComponentName component;
        if (this.mKeyMapping.size() > 0 && (component = this.mKeyMapping.get(keyCode)) != null) {
            Intent intent = new Intent("android.intent.action.GLOBAL_BUTTON").setComponent(component).putExtra("android.intent.extra.KEY_EVENT", event);
            context.sendBroadcastAsUser(intent, UserHandle.CURRENT, null);
            return true;
        }
        return false;
    }

    private final boolean $$robo$$com_android_internal_policy_impl_GlobalKeyManager$shouldHandleGlobalKey(int keyCode, KeyEvent event) {
        return this.mKeyMapping.get(keyCode) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$com_android_internal_policy_impl_GlobalKeyManager$loadGlobalKeys(Context context) {
        block12: {
            try (XmlResourceParser parser = null;){
                parser = context.getResources().getXml(0x1110005);
                XmlUtils.beginDocument(parser, "global_keys");
                int version = parser.getAttributeIntValue(null, "version", 0);
                if (1 != version) break block12;
                while (true) {
                    XmlUtils.nextElement(parser);
                    String element = parser.getName();
                    if (element == null) {
                        break;
                    }
                    if (!"key".equals(element)) continue;
                    String keyCodeName = parser.getAttributeValue(null, "keyCode");
                    String componentName = parser.getAttributeValue(null, "component");
                    int keyCode = KeyEvent.keyCodeFromString(keyCodeName);
                    if (keyCode == 0) continue;
                    this.mKeyMapping.put(keyCode, ComponentName.unflattenFromString(componentName));
                }
            }
        }
    }

    private final void $$robo$$com_android_internal_policy_impl_GlobalKeyManager$dump(String prefix, PrintWriter pw) {
        int numKeys = this.mKeyMapping.size();
        if (numKeys == 0) {
            pw.print(prefix);
            pw.println("mKeyMapping.size=0");
            return;
        }
        pw.print(prefix);
        pw.println("mKeyMapping={");
        for (int i = 0; i < numKeys; ++i) {
            pw.print("  ");
            pw.print(prefix);
            pw.print(KeyEvent.keyCodeToString(this.mKeyMapping.keyAt(i)));
            pw.print("=");
            pw.println(this.mKeyMapping.valueAt(i).flattenToString());
        }
        pw.print(prefix);
        pw.println("}");
    }

    private void __constructor__(Context context) {
        this.$$robo$$com_android_internal_policy_impl_GlobalKeyManager$__constructor__(context);
    }

    public GlobalKeyManager(Context context) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_policy_impl_GlobalKeyManager$__constructor__(android.content.Context ), 0, this, context);
    }

    boolean handleGlobalKey(Context context, int n, KeyEvent keyEvent) {
        return (boolean)InvokeDynamicSupport.bootstrap("handleGlobalKey", $$robo$$com_android_internal_policy_impl_GlobalKeyManager$handleGlobalKey(android.content.Context int android.view.KeyEvent ), 0, this, context, n, keyEvent);
    }

    boolean shouldHandleGlobalKey(int n, KeyEvent keyEvent) {
        return (boolean)InvokeDynamicSupport.bootstrap("shouldHandleGlobalKey", $$robo$$com_android_internal_policy_impl_GlobalKeyManager$shouldHandleGlobalKey(int android.view.KeyEvent ), 0, this, n, keyEvent);
    }

    private void loadGlobalKeys(Context context) {
        InvokeDynamicSupport.bootstrap("loadGlobalKeys", $$robo$$com_android_internal_policy_impl_GlobalKeyManager$loadGlobalKeys(android.content.Context ), 0, this, context);
    }

    public void dump(String string2, PrintWriter printWriter) {
        InvokeDynamicSupport.bootstrap("dump", $$robo$$com_android_internal_policy_impl_GlobalKeyManager$dump(java.lang.String java.io.PrintWriter ), 0, this, string2, printWriter);
    }

    public /* synthetic */ GlobalKeyManager() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (GlobalKeyManager)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

