/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.policy.impl;

import android.animation.ArgbEvaluator;
import android.animation.ValueAnimator;
import android.app.ActivityManager;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.graphics.drawable.ColorDrawable;
import android.os.Handler;
import android.os.Message;
import android.provider.Settings;
import android.util.DisplayMetrics;
import android.util.Slog;
import android.util.SparseBooleanArray;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.view.animation.DecelerateInterpolator;
import android.widget.Button;
import android.widget.FrameLayout;
import com.android.internal.policy.impl.PolicyControl;
import com.google.errorprone.annotations.DoNotMock;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class ImmersiveModeConfirmation
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "ImmersiveModeConfirmation";
    private static boolean DEBUG = false;
    private static boolean DEBUG_SHOW_EVERY_TIME = false;
    private static String CONFIRMED = "confirmed";
    private Context mContext;
    private H mHandler;
    private long mShowDelayMs;
    private long mPanicThresholdMs;
    private SparseBooleanArray mUserPanicResets;
    private boolean mConfirmed;
    private ClingWindowView mClingWindow;
    private long mPanicTime;
    private WindowManager mWindowManager;
    private int mCurrentUserId;
    private Runnable mConfirm;

    private void $$robo$$com_android_internal_policy_impl_ImmersiveModeConfirmation$__constructor__(Context context) {
        this.mUserPanicResets = new SparseBooleanArray();
        this.mConfirm = new Runnable(this){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ ImmersiveModeConfirmation this$0;

            private void $$robo$$com_android_internal_policy_impl_ImmersiveModeConfirmation_1$__constructor__(ImmersiveModeConfirmation immersiveModeConfirmation) {
            }

            private final void $$robo$$com_android_internal_policy_impl_ImmersiveModeConfirmation_1$run() {
                if (!this.this$0.mConfirmed) {
                    this.this$0.mConfirmed = true;
                    this.this$0.saveSetting();
                }
                this.this$0.handleHide();
            }

            private void __constructor__(ImmersiveModeConfirmation immersiveModeConfirmation) {
                this.$$robo$$com_android_internal_policy_impl_ImmersiveModeConfirmation_1$__constructor__(immersiveModeConfirmation);
            }
            {
                this.this$0 = immersiveModeConfirmation;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_policy_impl_ImmersiveModeConfirmation_1$__constructor__(com.android.internal.policy.impl.ImmersiveModeConfirmation ), 0, this, immersiveModeConfirmation);
            }

            @Override
            public void run() {
                InvokeDynamicSupport.bootstrap("run", $$robo$$com_android_internal_policy_impl_ImmersiveModeConfirmation_1$run(), 0, this);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.mContext = context;
        this.mHandler = new H(this);
        this.mShowDelayMs = this.getNavBarExitDuration() * 3L;
        this.mPanicThresholdMs = context.getResources().getInteger(17694834);
        this.mWindowManager = (WindowManager)this.mContext.getSystemService("window");
    }

    private final long $$robo$$com_android_internal_policy_impl_ImmersiveModeConfirmation$getNavBarExitDuration() {
        Animation exit = AnimationUtils.loadAnimation(this.mContext, 17432599);
        return exit != null ? exit.getDuration() : 0L;
    }

    private final void $$robo$$com_android_internal_policy_impl_ImmersiveModeConfirmation$loadSetting(int currentUserId) {
        this.mConfirmed = false;
        this.mCurrentUserId = currentUserId;
        String value = null;
        try {
            value = Settings.Secure.getStringForUser(this.mContext.getContentResolver(), "immersive_mode_confirmations", -2);
            this.mConfirmed = "confirmed".equals(value);
        }
        catch (Throwable t) {
            Slog.w("ImmersiveModeConfirmation", "Error loading confirmations, value=" + value, t);
        }
    }

    private final void $$robo$$com_android_internal_policy_impl_ImmersiveModeConfirmation$saveSetting() {
        try {
            String value = this.mConfirmed ? "confirmed" : null;
            Settings.Secure.putStringForUser(this.mContext.getContentResolver(), "immersive_mode_confirmations", value, -2);
        }
        catch (Throwable t) {
            Slog.w("ImmersiveModeConfirmation", "Error saving confirmations, mConfirmed=" + this.mConfirmed, t);
        }
    }

    private final void $$robo$$com_android_internal_policy_impl_ImmersiveModeConfirmation$immersiveModeChanged(String pkg, boolean isImmersiveMode, boolean userSetupComplete) {
        this.mHandler.removeMessages(1);
        if (isImmersiveMode) {
            boolean disabled = PolicyControl.disableImmersiveConfirmation(pkg);
            if (!disabled && !this.mConfirmed && userSetupComplete) {
                this.mHandler.sendEmptyMessageDelayed(1, this.mShowDelayMs);
            }
        } else {
            this.mHandler.sendEmptyMessage(2);
        }
    }

    private final boolean $$robo$$com_android_internal_policy_impl_ImmersiveModeConfirmation$onPowerKeyDown(boolean isScreenOn, long time, boolean inImmersiveMode) {
        if (!isScreenOn && time - this.mPanicTime < this.mPanicThresholdMs) {
            this.mHandler.sendEmptyMessage(3);
            return this.mClingWindow == null;
        }
        this.mPanicTime = isScreenOn && inImmersiveMode ? time : 0L;
        return false;
    }

    private final void $$robo$$com_android_internal_policy_impl_ImmersiveModeConfirmation$confirmCurrentPrompt() {
        if (this.mClingWindow != null) {
            this.mHandler.post(this.mConfirm);
        }
    }

    private final void $$robo$$com_android_internal_policy_impl_ImmersiveModeConfirmation$handlePanic() {
        if (this.mUserPanicResets.get(this.mCurrentUserId, false)) {
            return;
        }
        this.mUserPanicResets.put(this.mCurrentUserId, true);
        this.mConfirmed = false;
        this.saveSetting();
    }

    private final void $$robo$$com_android_internal_policy_impl_ImmersiveModeConfirmation$handleHide() {
        if (this.mClingWindow != null) {
            this.mWindowManager.removeView(this.mClingWindow);
            this.mClingWindow = null;
        }
    }

    private final WindowManager.LayoutParams $$robo$$com_android_internal_policy_impl_ImmersiveModeConfirmation$getClingWindowLayoutParams() {
        WindowManager.LayoutParams lp = new WindowManager.LayoutParams(-1, -1, 2005, 0x1000108, -3);
        lp.privateFlags |= 0x10;
        lp.setTitle("ImmersiveModeConfirmation");
        lp.windowAnimations = 16974563;
        lp.gravity = 119;
        return lp;
    }

    private final FrameLayout.LayoutParams $$robo$$com_android_internal_policy_impl_ImmersiveModeConfirmation$getBubbleLayoutParams() {
        return new FrameLayout.LayoutParams(this.mContext.getResources().getDimensionPixelSize(17105046), -2, 49);
    }

    private final void $$robo$$com_android_internal_policy_impl_ImmersiveModeConfirmation$handleShow() {
        this.mClingWindow = new ClingWindowView(this, this.mContext, this.mConfirm);
        this.mClingWindow.setSystemUiVisibility(768);
        WindowManager.LayoutParams lp = this.getClingWindowLayoutParams();
        this.mWindowManager.addView(this.mClingWindow, lp);
    }

    private void __constructor__(Context context) {
        this.$$robo$$com_android_internal_policy_impl_ImmersiveModeConfirmation$__constructor__(context);
    }

    public ImmersiveModeConfirmation(Context context) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_policy_impl_ImmersiveModeConfirmation$__constructor__(android.content.Context ), 0, this, context);
    }

    private long getNavBarExitDuration() {
        return (long)InvokeDynamicSupport.bootstrap("getNavBarExitDuration", $$robo$$com_android_internal_policy_impl_ImmersiveModeConfirmation$getNavBarExitDuration(), 0, this);
    }

    public void loadSetting(int n) {
        InvokeDynamicSupport.bootstrap("loadSetting", $$robo$$com_android_internal_policy_impl_ImmersiveModeConfirmation$loadSetting(int ), 0, this, n);
    }

    private void saveSetting() {
        InvokeDynamicSupport.bootstrap("saveSetting", $$robo$$com_android_internal_policy_impl_ImmersiveModeConfirmation$saveSetting(), 0, this);
    }

    public void immersiveModeChanged(String string2, boolean bl, boolean bl2) {
        InvokeDynamicSupport.bootstrap("immersiveModeChanged", $$robo$$com_android_internal_policy_impl_ImmersiveModeConfirmation$immersiveModeChanged(java.lang.String boolean boolean ), 0, this, string2, bl, bl2);
    }

    public boolean onPowerKeyDown(boolean bl, long l, boolean bl2) {
        return (boolean)InvokeDynamicSupport.bootstrap("onPowerKeyDown", $$robo$$com_android_internal_policy_impl_ImmersiveModeConfirmation$onPowerKeyDown(boolean long boolean ), 0, this, bl, l, bl2);
    }

    public void confirmCurrentPrompt() {
        InvokeDynamicSupport.bootstrap("confirmCurrentPrompt", $$robo$$com_android_internal_policy_impl_ImmersiveModeConfirmation$confirmCurrentPrompt(), 0, this);
    }

    private void handlePanic() {
        InvokeDynamicSupport.bootstrap("handlePanic", $$robo$$com_android_internal_policy_impl_ImmersiveModeConfirmation$handlePanic(), 0, this);
    }

    private void handleHide() {
        InvokeDynamicSupport.bootstrap("handleHide", $$robo$$com_android_internal_policy_impl_ImmersiveModeConfirmation$handleHide(), 0, this);
    }

    public WindowManager.LayoutParams getClingWindowLayoutParams() {
        return InvokeDynamicSupport.bootstrap("getClingWindowLayoutParams", $$robo$$com_android_internal_policy_impl_ImmersiveModeConfirmation$getClingWindowLayoutParams(), 0, this);
    }

    public FrameLayout.LayoutParams getBubbleLayoutParams() {
        return InvokeDynamicSupport.bootstrap("getBubbleLayoutParams", $$robo$$com_android_internal_policy_impl_ImmersiveModeConfirmation$getBubbleLayoutParams(), 0, this);
    }

    private void handleShow() {
        InvokeDynamicSupport.bootstrap("handleShow", $$robo$$com_android_internal_policy_impl_ImmersiveModeConfirmation$handleShow(), 0, this);
    }

    public /* synthetic */ ImmersiveModeConfirmation() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ImmersiveModeConfirmation)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    private final class H
    extends Handler
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private static int SHOW = 1;
        private static int HIDE = 2;
        private static int PANIC = 3;
        /* synthetic */ ImmersiveModeConfirmation this$0;

        private void $$robo$$com_android_internal_policy_impl_ImmersiveModeConfirmation_H$__constructor__(ImmersiveModeConfirmation immersiveModeConfirmation) {
        }

        private final void $$robo$$com_android_internal_policy_impl_ImmersiveModeConfirmation_H$handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    this.this$0.handleShow();
                    break;
                }
                case 2: {
                    this.this$0.handleHide();
                    break;
                }
                case 3: {
                    this.this$0.handlePanic();
                }
            }
        }

        private /* synthetic */ void $$robo$$com_android_internal_policy_impl_ImmersiveModeConfirmation_H$__constructor__(ImmersiveModeConfirmation x0, 1 x1) {
        }

        private void __constructor__(ImmersiveModeConfirmation immersiveModeConfirmation) {
            this.$$robo$$com_android_internal_policy_impl_ImmersiveModeConfirmation_H$__constructor__(immersiveModeConfirmation);
        }

        private H(ImmersiveModeConfirmation immersiveModeConfirmation) {
            this.this$0 = immersiveModeConfirmation;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_policy_impl_ImmersiveModeConfirmation_H$__constructor__(com.android.internal.policy.impl.ImmersiveModeConfirmation ), 0, this, immersiveModeConfirmation);
        }

        @Override
        public void handleMessage(Message message) {
            InvokeDynamicSupport.bootstrap("handleMessage", $$robo$$com_android_internal_policy_impl_ImmersiveModeConfirmation_H$handleMessage(android.os.Message ), 0, this, message);
        }

        private /* synthetic */ void __constructor__(ImmersiveModeConfirmation immersiveModeConfirmation, 1 var2_2) {
            this.$$robo$$com_android_internal_policy_impl_ImmersiveModeConfirmation_H$__constructor__(immersiveModeConfirmation, var2_2);
        }

        public /* synthetic */ H() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (H)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private class ClingWindowView
    extends FrameLayout
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private static int BGCOLOR = Integer.MIN_VALUE;
        private static int OFFSET_DP = 48;
        private Runnable mConfirm;
        private ColorDrawable mColor;
        private ValueAnimator mColorAnim;
        private ViewGroup mClingLayout;
        private Runnable mUpdateLayoutRunnable;
        private BroadcastReceiver mReceiver;
        /* synthetic */ ImmersiveModeConfirmation this$0;

        private void $$robo$$com_android_internal_policy_impl_ImmersiveModeConfirmation_ClingWindowView$__constructor__(ImmersiveModeConfirmation immersiveModeConfirmation, Context context, Runnable confirm) {
            this.mColor = new ColorDrawable(0);
            this.mUpdateLayoutRunnable = new Runnable(this){
                public transient /* synthetic */ Object __robo_data__;
                /* synthetic */ ClingWindowView this$1;

                private void $$robo$$com_android_internal_policy_impl_ImmersiveModeConfirmation_ClingWindowView_1$__constructor__(ClingWindowView clingWindowView) {
                }

                private final void $$robo$$com_android_internal_policy_impl_ImmersiveModeConfirmation_ClingWindowView_1$run() {
                    if (this.this$1.mClingLayout != null && this.this$1.mClingLayout.getParent() != null) {
                        this.this$1.mClingLayout.setLayoutParams(this.this$1.this$0.getBubbleLayoutParams());
                    }
                }

                private void __constructor__(ClingWindowView clingWindowView) {
                    this.$$robo$$com_android_internal_policy_impl_ImmersiveModeConfirmation_ClingWindowView_1$__constructor__(clingWindowView);
                }
                {
                    this.this$1 = clingWindowView;
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_policy_impl_ImmersiveModeConfirmation_ClingWindowView_1$__constructor__(com.android.internal.policy.impl.ImmersiveModeConfirmation$ClingWindowView ), 0, this, clingWindowView);
                }

                @Override
                public void run() {
                    InvokeDynamicSupport.bootstrap("run", $$robo$$com_android_internal_policy_impl_ImmersiveModeConfirmation_ClingWindowView_1$run(), 0, this);
                }
                {
                    this.$$robo$init();
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            };
            this.mReceiver = new ShadowedObject(this){
                public transient /* synthetic */ Object __robo_data__;
                /* synthetic */ ClingWindowView this$1;

                private void $$robo$$com_android_internal_policy_impl_ImmersiveModeConfirmation_ClingWindowView_2$__constructor__(ClingWindowView clingWindowView) {
                }

                private final void $$robo$$com_android_internal_policy_impl_ImmersiveModeConfirmation_ClingWindowView_2$onReceive(Context context, Intent intent) {
                    if (intent.getAction().equals("android.intent.action.CONFIGURATION_CHANGED")) {
                        this.this$1.post(this.this$1.mUpdateLayoutRunnable);
                    }
                }

                private void __constructor__(ClingWindowView clingWindowView) {
                    this.$$robo$$com_android_internal_policy_impl_ImmersiveModeConfirmation_ClingWindowView_2$__constructor__(clingWindowView);
                }
                {
                    this.this$1 = clingWindowView;
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_policy_impl_ImmersiveModeConfirmation_ClingWindowView_2$__constructor__(com.android.internal.policy.impl.ImmersiveModeConfirmation$ClingWindowView ), 0, this, clingWindowView);
                }

                @Override
                public void onReceive(Context context, Intent intent) {
                    InvokeDynamicSupport.bootstrap("onReceive", $$robo$$com_android_internal_policy_impl_ImmersiveModeConfirmation_ClingWindowView_2$onReceive(android.content.Context android.content.Intent ), 0, this, context, intent);
                }
                {
                    this.$$robo$init();
                }

                @Override
                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                @Override
                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            };
            this.mConfirm = confirm;
            this.setClickable(true);
            this.setBackground(this.mColor);
        }

        private final void $$robo$$com_android_internal_policy_impl_ImmersiveModeConfirmation_ClingWindowView$onAttachedToWindow() {
            super.onAttachedToWindow();
            DisplayMetrics metrics = new DisplayMetrics();
            this.this$0.mWindowManager.getDefaultDisplay().getMetrics(metrics);
            float density = metrics.density;
            this.mClingLayout = (ViewGroup)View.inflate(this.getContext(), 17367130, null);
            Button ok = (Button)this.mClingLayout.findViewById(16909066);
            ok.setOnClickListener(new View.OnClickListener(this){
                public transient /* synthetic */ Object __robo_data__;
                /* synthetic */ ClingWindowView this$1;

                private void $$robo$$com_android_internal_policy_impl_ImmersiveModeConfirmation_ClingWindowView_3$__constructor__(ClingWindowView clingWindowView) {
                }

                private final void $$robo$$com_android_internal_policy_impl_ImmersiveModeConfirmation_ClingWindowView_3$onClick(View v) {
                    this.this$1.mConfirm.run();
                }

                private void __constructor__(ClingWindowView clingWindowView) {
                    this.$$robo$$com_android_internal_policy_impl_ImmersiveModeConfirmation_ClingWindowView_3$__constructor__(clingWindowView);
                }
                {
                    this.this$1 = clingWindowView;
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_policy_impl_ImmersiveModeConfirmation_ClingWindowView_3$__constructor__(com.android.internal.policy.impl.ImmersiveModeConfirmation$ClingWindowView ), 0, this, clingWindowView);
                }

                @Override
                public void onClick(View view) {
                    InvokeDynamicSupport.bootstrap("onClick", $$robo$$com_android_internal_policy_impl_ImmersiveModeConfirmation_ClingWindowView_3$onClick(android.view.View ), 0, this, view);
                }
                {
                    this.$$robo$init();
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            });
            this.addView((View)this.mClingLayout, this.this$0.getBubbleLayoutParams());
            if (ActivityManager.isHighEndGfx()) {
                View bubble = this.mClingLayout.findViewById(16908392);
                bubble.setAlpha(0.0f);
                bubble.setTranslationY(-48.0f * density);
                bubble.animate().alpha(1.0f).translationY(0.0f).setDuration(300L).setInterpolator(new DecelerateInterpolator()).start();
                ok.setAlpha(0.0f);
                ok.setTranslationY(-48.0f * density);
                ok.animate().alpha(1.0f).translationY(0.0f).setDuration(300L).setStartDelay(200L).setInterpolator(new DecelerateInterpolator()).start();
                this.mColorAnim = ValueAnimator.ofObject(new ArgbEvaluator(), 0, Integer.MIN_VALUE);
                this.mColorAnim.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(this){
                    public transient /* synthetic */ Object __robo_data__;
                    /* synthetic */ ClingWindowView this$1;

                    private void $$robo$$com_android_internal_policy_impl_ImmersiveModeConfirmation_ClingWindowView_4$__constructor__(ClingWindowView clingWindowView) {
                    }

                    private final void $$robo$$com_android_internal_policy_impl_ImmersiveModeConfirmation_ClingWindowView_4$onAnimationUpdate(ValueAnimator animation) {
                        int c = (Integer)animation.getAnimatedValue();
                        this.this$1.mColor.setColor(c);
                    }

                    private void __constructor__(ClingWindowView clingWindowView) {
                        this.$$robo$$com_android_internal_policy_impl_ImmersiveModeConfirmation_ClingWindowView_4$__constructor__(clingWindowView);
                    }
                    {
                        this.this$1 = clingWindowView;
                        this.$$robo$init();
                        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_policy_impl_ImmersiveModeConfirmation_ClingWindowView_4$__constructor__(com.android.internal.policy.impl.ImmersiveModeConfirmation$ClingWindowView ), 0, this, clingWindowView);
                    }

                    @Override
                    public void onAnimationUpdate(ValueAnimator valueAnimator) {
                        InvokeDynamicSupport.bootstrap("onAnimationUpdate", $$robo$$com_android_internal_policy_impl_ImmersiveModeConfirmation_ClingWindowView_4$onAnimationUpdate(android.animation.ValueAnimator ), 0, this, valueAnimator);
                    }
                    {
                        this.$$robo$init();
                    }

                    protected /* synthetic */ void $$robo$init() {
                        if (this.__robo_data__ == null) {
                            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                        }
                    }

                    public /* synthetic */ Object $$robo$getData() {
                        return this.__robo_data__;
                    }
                });
                this.mColorAnim.setDuration(1000L);
                this.mColorAnim.start();
            } else {
                this.mColor.setColor(Integer.MIN_VALUE);
            }
            this.mContext.registerReceiver(this.mReceiver, new IntentFilter("android.intent.action.CONFIGURATION_CHANGED"));
        }

        private final void $$robo$$com_android_internal_policy_impl_ImmersiveModeConfirmation_ClingWindowView$onDetachedFromWindow() {
            this.mContext.unregisterReceiver(this.mReceiver);
        }

        private final boolean $$robo$$com_android_internal_policy_impl_ImmersiveModeConfirmation_ClingWindowView$onTouchEvent(MotionEvent motion) {
            return true;
        }

        private void __constructor__(ImmersiveModeConfirmation immersiveModeConfirmation, Context context, Runnable runnable) {
            this.$$robo$$com_android_internal_policy_impl_ImmersiveModeConfirmation_ClingWindowView$__constructor__(immersiveModeConfirmation, context, runnable);
        }

        public ClingWindowView(ImmersiveModeConfirmation immersiveModeConfirmation, Context context, Runnable runnable) {
            this.this$0 = immersiveModeConfirmation;
            super(context);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_policy_impl_ImmersiveModeConfirmation_ClingWindowView$__constructor__(com.android.internal.policy.impl.ImmersiveModeConfirmation android.content.Context java.lang.Runnable ), 0, this, immersiveModeConfirmation, context, runnable);
        }

        @Override
        public void onAttachedToWindow() {
            InvokeDynamicSupport.bootstrap("onAttachedToWindow", $$robo$$com_android_internal_policy_impl_ImmersiveModeConfirmation_ClingWindowView$onAttachedToWindow(), 0, this);
        }

        @Override
        public void onDetachedFromWindow() {
            InvokeDynamicSupport.bootstrap("onDetachedFromWindow", $$robo$$com_android_internal_policy_impl_ImmersiveModeConfirmation_ClingWindowView$onDetachedFromWindow(), 0, this);
        }

        @Override
        public boolean onTouchEvent(MotionEvent motionEvent) {
            return (boolean)InvokeDynamicSupport.bootstrap("onTouchEvent", $$robo$$com_android_internal_policy_impl_ImmersiveModeConfirmation_ClingWindowView$onTouchEvent(android.view.MotionEvent ), 0, this, motionEvent);
        }

        public /* synthetic */ ClingWindowView() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ClingWindowView)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

