/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.policy.impl;

import android.app.KeyguardManager;
import android.app.SearchManager;
import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.content.res.Configuration;
import android.media.AudioManager;
import android.media.session.MediaSessionLegacyHelper;
import android.os.UserHandle;
import android.telephony.TelephonyManager;
import android.util.Slog;
import android.view.FallbackEventHandler;
import android.view.KeyEvent;
import android.view.View;
import com.android.internal.policy.impl.PhoneWindowManager;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class PhoneFallbackEventHandler
implements FallbackEventHandler,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG;
    private static boolean DEBUG = false;
    Context mContext;
    View mView;
    AudioManager mAudioManager;
    KeyguardManager mKeyguardManager;
    SearchManager mSearchManager;
    TelephonyManager mTelephonyManager;

    private void $$robo$$com_android_internal_policy_impl_PhoneFallbackEventHandler$__constructor__(Context context) {
        this.mContext = context;
    }

    private final void $$robo$$com_android_internal_policy_impl_PhoneFallbackEventHandler$setView(View v) {
        this.mView = v;
    }

    private final void $$robo$$com_android_internal_policy_impl_PhoneFallbackEventHandler$preDispatchKeyEvent(KeyEvent event) {
        this.getAudioManager().preDispatchKeyEvent(event, Integer.MIN_VALUE);
    }

    private final boolean $$robo$$com_android_internal_policy_impl_PhoneFallbackEventHandler$dispatchKeyEvent(KeyEvent event) {
        int action = event.getAction();
        int keyCode = event.getKeyCode();
        if (action == 0) {
            return this.onKeyDown(keyCode, event);
        }
        return this.onKeyUp(keyCode, event);
    }

    private final boolean $$robo$$com_android_internal_policy_impl_PhoneFallbackEventHandler$onKeyDown(int keyCode, KeyEvent event) {
        KeyEvent.DispatcherState dispatcher = this.mView.getKeyDispatcherState();
        switch (keyCode) {
            case 24: 
            case 25: 
            case 164: {
                MediaSessionLegacyHelper.getHelper(this.mContext).sendVolumeKeyEvent(event, false);
                return true;
            }
            case 85: 
            case 126: 
            case 127: {
                if (this.getTelephonyManager().getCallState() != 0) {
                    return true;
                }
            }
            case 79: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 130: 
            case 222: {
                this.handleMediaKeyEvent(event);
                return true;
            }
            case 5: {
                if (this.getKeyguardManager().inKeyguardRestrictedInputMode() || dispatcher == null) break;
                if (event.getRepeatCount() == 0) {
                    dispatcher.startTracking(event, this);
                } else if (event.isLongPress() && dispatcher.isTracking(event)) {
                    dispatcher.performedLongPress(event);
                    this.mView.performHapticFeedback(0);
                    Intent intent = new Intent("android.intent.action.VOICE_COMMAND");
                    intent.setFlags(0x10000000);
                    try {
                        this.sendCloseSystemWindows();
                        this.mContext.startActivity(intent);
                    }
                    catch (ActivityNotFoundException e) {
                        this.startCallActivity();
                    }
                }
                return true;
            }
            case 27: {
                if (this.getKeyguardManager().inKeyguardRestrictedInputMode() || dispatcher == null) break;
                if (event.getRepeatCount() == 0) {
                    dispatcher.startTracking(event, this);
                } else if (event.isLongPress() && dispatcher.isTracking(event)) {
                    dispatcher.performedLongPress(event);
                    this.mView.performHapticFeedback(0);
                    this.sendCloseSystemWindows();
                    Intent intent = new Intent("android.intent.action.CAMERA_BUTTON", null);
                    intent.putExtra("android.intent.extra.KEY_EVENT", event);
                    this.mContext.sendOrderedBroadcastAsUser(intent, UserHandle.CURRENT_OR_SELF, null, null, null, 0, null, null);
                }
                return true;
            }
            case 84: {
                if (this.getKeyguardManager().inKeyguardRestrictedInputMode() || dispatcher == null) break;
                if (event.getRepeatCount() == 0) {
                    dispatcher.startTracking(event, this);
                    break;
                }
                if (!event.isLongPress() || !dispatcher.isTracking(event)) break;
                Configuration config = this.mContext.getResources().getConfiguration();
                if (config.keyboard != 1 && config.hardKeyboardHidden != 2) break;
                Intent intent = new Intent("android.intent.action.SEARCH_LONG_PRESS");
                intent.setFlags(0x10000000);
                try {
                    this.mView.performHapticFeedback(0);
                    this.sendCloseSystemWindows();
                    this.getSearchManager().stopSearch();
                    this.mContext.startActivity(intent);
                    dispatcher.performedLongPress(event);
                    return true;
                }
                catch (ActivityNotFoundException activityNotFoundException) {
                    // empty catch block
                }
            }
        }
        return false;
    }

    private final boolean $$robo$$com_android_internal_policy_impl_PhoneFallbackEventHandler$onKeyUp(int keyCode, KeyEvent event) {
        KeyEvent.DispatcherState dispatcher = this.mView.getKeyDispatcherState();
        if (dispatcher != null) {
            dispatcher.handleUpEvent(event);
        }
        switch (keyCode) {
            case 24: 
            case 25: 
            case 164: {
                if (!event.isCanceled()) {
                    MediaSessionLegacyHelper.getHelper(this.mContext).sendVolumeKeyEvent(event, false);
                }
                return true;
            }
            case 79: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 126: 
            case 127: 
            case 130: 
            case 222: {
                this.handleMediaKeyEvent(event);
                return true;
            }
            case 27: {
                if (this.getKeyguardManager().inKeyguardRestrictedInputMode()) break;
                if (!event.isTracking() || !event.isCanceled()) {
                    // empty if block
                }
                return true;
            }
            case 5: {
                if (this.getKeyguardManager().inKeyguardRestrictedInputMode()) break;
                if (event.isTracking() && !event.isCanceled()) {
                    this.startCallActivity();
                }
                return true;
            }
        }
        return false;
    }

    private final void $$robo$$com_android_internal_policy_impl_PhoneFallbackEventHandler$startCallActivity() {
        this.sendCloseSystemWindows();
        Intent intent = new Intent("android.intent.action.CALL_BUTTON");
        intent.setFlags(0x10000000);
        try {
            this.mContext.startActivity(intent);
        }
        catch (ActivityNotFoundException e) {
            Slog.w(TAG, "No activity found for android.intent.action.CALL_BUTTON.");
        }
    }

    private final SearchManager $$robo$$com_android_internal_policy_impl_PhoneFallbackEventHandler$getSearchManager() {
        if (this.mSearchManager == null) {
            this.mSearchManager = (SearchManager)this.mContext.getSystemService("search");
        }
        return this.mSearchManager;
    }

    private final TelephonyManager $$robo$$com_android_internal_policy_impl_PhoneFallbackEventHandler$getTelephonyManager() {
        if (this.mTelephonyManager == null) {
            this.mTelephonyManager = (TelephonyManager)this.mContext.getSystemService("phone");
        }
        return this.mTelephonyManager;
    }

    private final KeyguardManager $$robo$$com_android_internal_policy_impl_PhoneFallbackEventHandler$getKeyguardManager() {
        if (this.mKeyguardManager == null) {
            this.mKeyguardManager = (KeyguardManager)this.mContext.getSystemService("keyguard");
        }
        return this.mKeyguardManager;
    }

    private final AudioManager $$robo$$com_android_internal_policy_impl_PhoneFallbackEventHandler$getAudioManager() {
        if (this.mAudioManager == null) {
            this.mAudioManager = (AudioManager)this.mContext.getSystemService("audio");
        }
        return this.mAudioManager;
    }

    private final void $$robo$$com_android_internal_policy_impl_PhoneFallbackEventHandler$sendCloseSystemWindows() {
        PhoneWindowManager.sendCloseSystemWindows(this.mContext, null);
    }

    private final void $$robo$$com_android_internal_policy_impl_PhoneFallbackEventHandler$handleMediaKeyEvent(KeyEvent keyEvent) {
        MediaSessionLegacyHelper.getHelper(this.mContext).sendMediaButtonEvent(keyEvent, false);
    }

    static void __staticInitializer__() {
        TAG = "PhoneFallbackEventHandler";
    }

    private void __constructor__(Context context) {
        this.$$robo$$com_android_internal_policy_impl_PhoneFallbackEventHandler$__constructor__(context);
    }

    public PhoneFallbackEventHandler(Context context) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_policy_impl_PhoneFallbackEventHandler$__constructor__(android.content.Context ), 0, this, context);
    }

    @Override
    public void setView(View view) {
        InvokeDynamicSupport.bootstrap("setView", $$robo$$com_android_internal_policy_impl_PhoneFallbackEventHandler$setView(android.view.View ), 0, this, view);
    }

    @Override
    public void preDispatchKeyEvent(KeyEvent keyEvent) {
        InvokeDynamicSupport.bootstrap("preDispatchKeyEvent", $$robo$$com_android_internal_policy_impl_PhoneFallbackEventHandler$preDispatchKeyEvent(android.view.KeyEvent ), 0, this, keyEvent);
    }

    @Override
    public boolean dispatchKeyEvent(KeyEvent keyEvent) {
        return (boolean)InvokeDynamicSupport.bootstrap("dispatchKeyEvent", $$robo$$com_android_internal_policy_impl_PhoneFallbackEventHandler$dispatchKeyEvent(android.view.KeyEvent ), 0, this, keyEvent);
    }

    boolean onKeyDown(int n, KeyEvent keyEvent) {
        return (boolean)InvokeDynamicSupport.bootstrap("onKeyDown", $$robo$$com_android_internal_policy_impl_PhoneFallbackEventHandler$onKeyDown(int android.view.KeyEvent ), 0, this, n, keyEvent);
    }

    boolean onKeyUp(int n, KeyEvent keyEvent) {
        return (boolean)InvokeDynamicSupport.bootstrap("onKeyUp", $$robo$$com_android_internal_policy_impl_PhoneFallbackEventHandler$onKeyUp(int android.view.KeyEvent ), 0, this, n, keyEvent);
    }

    void startCallActivity() {
        InvokeDynamicSupport.bootstrap("startCallActivity", $$robo$$com_android_internal_policy_impl_PhoneFallbackEventHandler$startCallActivity(), 0, this);
    }

    SearchManager getSearchManager() {
        return InvokeDynamicSupport.bootstrap("getSearchManager", $$robo$$com_android_internal_policy_impl_PhoneFallbackEventHandler$getSearchManager(), 0, this);
    }

    TelephonyManager getTelephonyManager() {
        return InvokeDynamicSupport.bootstrap("getTelephonyManager", $$robo$$com_android_internal_policy_impl_PhoneFallbackEventHandler$getTelephonyManager(), 0, this);
    }

    KeyguardManager getKeyguardManager() {
        return InvokeDynamicSupport.bootstrap("getKeyguardManager", $$robo$$com_android_internal_policy_impl_PhoneFallbackEventHandler$getKeyguardManager(), 0, this);
    }

    AudioManager getAudioManager() {
        return InvokeDynamicSupport.bootstrap("getAudioManager", $$robo$$com_android_internal_policy_impl_PhoneFallbackEventHandler$getAudioManager(), 0, this);
    }

    void sendCloseSystemWindows() {
        InvokeDynamicSupport.bootstrap("sendCloseSystemWindows", $$robo$$com_android_internal_policy_impl_PhoneFallbackEventHandler$sendCloseSystemWindows(), 0, this);
    }

    private void handleMediaKeyEvent(KeyEvent keyEvent) {
        InvokeDynamicSupport.bootstrap("handleMediaKeyEvent", $$robo$$com_android_internal_policy_impl_PhoneFallbackEventHandler$handleMediaKeyEvent(android.view.KeyEvent ), 0, this, keyEvent);
    }

    static {
        RobolectricInternals.classInitializing(PhoneFallbackEventHandler.class);
    }

    public /* synthetic */ PhoneFallbackEventHandler() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (PhoneFallbackEventHandler)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

