/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.policy.impl;

import android.app.ActivityManager;
import android.content.Context;
import android.provider.Settings;
import android.util.ArraySet;
import android.util.Slog;
import android.view.WindowManager;
import android.view.WindowManagerPolicy;
import java.io.PrintWriter;
import java.io.StringWriter;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class PolicyControl
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG;
    private static boolean DEBUG;
    private static String NAME_IMMERSIVE_FULL = "immersive.full";
    private static String NAME_IMMERSIVE_STATUS = "immersive.status";
    private static String NAME_IMMERSIVE_NAVIGATION = "immersive.navigation";
    private static String NAME_IMMERSIVE_PRECONFIRMATIONS = "immersive.preconfirms";
    private static String sSettingValue;
    private static Filter sImmersivePreconfirmationsFilter;
    private static Filter sImmersiveStatusFilter;
    private static Filter sImmersiveNavigationFilter;

    private void $$robo$$com_android_internal_policy_impl_PolicyControl$__constructor__() {
    }

    private static final int $$robo$$com_android_internal_policy_impl_PolicyControl$getSystemUiVisibility(WindowManagerPolicy.WindowState win, WindowManager.LayoutParams attrs) {
        int vis;
        attrs = attrs != null ? attrs : win.getAttrs();
        int n = vis = win != null ? win.getSystemUiVisibility() : attrs.systemUiVisibility;
        if (sImmersiveStatusFilter != null && sImmersiveStatusFilter.matches(attrs)) {
            vis |= 0x1404;
            vis &= 0xBFFFFEFF;
        }
        if (sImmersiveNavigationFilter != null && sImmersiveNavigationFilter.matches(attrs)) {
            vis |= 0x1202;
            vis &= 0x7FFFFEFF;
        }
        return vis;
    }

    private static final int $$robo$$com_android_internal_policy_impl_PolicyControl$getWindowFlags(WindowManagerPolicy.WindowState win, WindowManager.LayoutParams attrs) {
        attrs = attrs != null ? attrs : win.getAttrs();
        int flags = attrs.flags;
        if (sImmersiveStatusFilter != null && sImmersiveStatusFilter.matches(attrs)) {
            flags |= 0x400;
            flags &= 0xFBFFF7FF;
        }
        if (sImmersiveNavigationFilter != null && sImmersiveNavigationFilter.matches(attrs)) {
            flags &= 0xF7FFFFFF;
        }
        return flags;
    }

    private static final int $$robo$$com_android_internal_policy_impl_PolicyControl$adjustClearableFlags(WindowManagerPolicy.WindowState win, int clearableFlags) {
        WindowManager.LayoutParams attrs;
        WindowManager.LayoutParams layoutParams = attrs = win != null ? win.getAttrs() : null;
        if (sImmersiveStatusFilter != null && sImmersiveStatusFilter.matches(attrs)) {
            clearableFlags &= 0xFFFFFFFB;
        }
        return clearableFlags;
    }

    private static final boolean $$robo$$com_android_internal_policy_impl_PolicyControl$disableImmersiveConfirmation(String pkg) {
        return sImmersivePreconfirmationsFilter != null && sImmersivePreconfirmationsFilter.matches(pkg) || ActivityManager.isRunningInTestHarness();
    }

    private static final void $$robo$$com_android_internal_policy_impl_PolicyControl$reloadFromSetting(Context context) {
        if (DEBUG) {
            Slog.d(TAG, "reloadFromSetting()");
        }
        String value = null;
        try {
            value = Settings.Global.getStringForUser(context.getContentResolver(), "policy_control", -2);
            if (sSettingValue != null && sSettingValue.equals(value)) {
                return;
            }
            PolicyControl.setFilters(value);
            sSettingValue = value;
        }
        catch (Throwable t) {
            Slog.w(TAG, "Error loading policy control, value=" + value, t);
        }
    }

    private static final void $$robo$$com_android_internal_policy_impl_PolicyControl$dump(String prefix, PrintWriter pw) {
        PolicyControl.dump("sImmersiveStatusFilter", sImmersiveStatusFilter, prefix, pw);
        PolicyControl.dump("sImmersiveNavigationFilter", sImmersiveNavigationFilter, prefix, pw);
        PolicyControl.dump("sImmersivePreconfirmationsFilter", sImmersivePreconfirmationsFilter, prefix, pw);
    }

    private static final void $$robo$$com_android_internal_policy_impl_PolicyControl$dump(String name, Filter filter, String prefix, PrintWriter pw) {
        pw.print(prefix);
        pw.print("PolicyControl.");
        pw.print(name);
        pw.print('=');
        if (filter == null) {
            pw.println("null");
        } else {
            filter.dump(pw);
            pw.println();
        }
    }

    private static final void $$robo$$com_android_internal_policy_impl_PolicyControl$setFilters(String value) {
        if (DEBUG) {
            Slog.d(TAG, "setFilters: " + value);
        }
        sImmersiveStatusFilter = null;
        sImmersiveNavigationFilter = null;
        sImmersivePreconfirmationsFilter = null;
        if (value != null) {
            String[] nvps;
            for (String nvp : nvps = value.split(":")) {
                Filter f;
                int i = nvp.indexOf(61);
                if (i == -1) continue;
                String n = nvp.substring(0, i);
                String v = nvp.substring(i + 1);
                if (n.equals("immersive.full")) {
                    sImmersiveStatusFilter = sImmersiveNavigationFilter = (f = Filter.parse(v));
                    if (sImmersivePreconfirmationsFilter != null) continue;
                    sImmersivePreconfirmationsFilter = f;
                    continue;
                }
                if (n.equals("immersive.status")) {
                    sImmersiveStatusFilter = f = Filter.parse(v);
                    continue;
                }
                if (n.equals("immersive.navigation")) {
                    sImmersiveNavigationFilter = f = Filter.parse(v);
                    if (sImmersivePreconfirmationsFilter != null) continue;
                    sImmersivePreconfirmationsFilter = f;
                    continue;
                }
                if (!n.equals("immersive.preconfirms")) continue;
                sImmersivePreconfirmationsFilter = f = Filter.parse(v);
            }
        }
        if (DEBUG) {
            Slog.d(TAG, "immersiveStatusFilter: " + sImmersiveStatusFilter);
            Slog.d(TAG, "immersiveNavigationFilter: " + sImmersiveNavigationFilter);
            Slog.d(TAG, "immersivePreconfirmationsFilter: " + sImmersivePreconfirmationsFilter);
        }
    }

    static void __staticInitializer__() {
        TAG = "PolicyControl";
        DEBUG = false;
    }

    private void __constructor__() {
        this.$$robo$$com_android_internal_policy_impl_PolicyControl$__constructor__();
    }

    public PolicyControl() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_policy_impl_PolicyControl$__constructor__(), 0, this);
    }

    public static int getSystemUiVisibility(WindowManagerPolicy.WindowState windowState, WindowManager.LayoutParams layoutParams) {
        return (int)InvokeDynamicSupport.bootstrapStatic("getSystemUiVisibility", $$robo$$com_android_internal_policy_impl_PolicyControl$getSystemUiVisibility(android.view.WindowManagerPolicy$WindowState android.view.WindowManager$LayoutParams ), 0, (WindowManagerPolicy.WindowState)windowState, (WindowManager.LayoutParams)layoutParams);
    }

    public static int getWindowFlags(WindowManagerPolicy.WindowState windowState, WindowManager.LayoutParams layoutParams) {
        return (int)InvokeDynamicSupport.bootstrapStatic("getWindowFlags", $$robo$$com_android_internal_policy_impl_PolicyControl$getWindowFlags(android.view.WindowManagerPolicy$WindowState android.view.WindowManager$LayoutParams ), 0, (WindowManagerPolicy.WindowState)windowState, (WindowManager.LayoutParams)layoutParams);
    }

    public static int adjustClearableFlags(WindowManagerPolicy.WindowState windowState, int n) {
        return (int)InvokeDynamicSupport.bootstrapStatic("adjustClearableFlags", $$robo$$com_android_internal_policy_impl_PolicyControl$adjustClearableFlags(android.view.WindowManagerPolicy$WindowState int ), 0, (WindowManagerPolicy.WindowState)windowState, (int)n);
    }

    public static boolean disableImmersiveConfirmation(String string2) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("disableImmersiveConfirmation", $$robo$$com_android_internal_policy_impl_PolicyControl$disableImmersiveConfirmation(java.lang.String ), 0, (String)string2);
    }

    public static void reloadFromSetting(Context context) {
        InvokeDynamicSupport.bootstrapStatic("reloadFromSetting", $$robo$$com_android_internal_policy_impl_PolicyControl$reloadFromSetting(android.content.Context ), 0, (Context)context);
    }

    public static void dump(String string2, PrintWriter printWriter) {
        InvokeDynamicSupport.bootstrapStatic("dump", $$robo$$com_android_internal_policy_impl_PolicyControl$dump(java.lang.String java.io.PrintWriter ), 0, (String)string2, (PrintWriter)printWriter);
    }

    private static void dump(String string2, Filter filter, String string3, PrintWriter printWriter) {
        InvokeDynamicSupport.bootstrapStatic("dump", $$robo$$com_android_internal_policy_impl_PolicyControl$dump(java.lang.String com.android.internal.policy.impl.PolicyControl$Filter java.lang.String java.io.PrintWriter ), 0, (String)string2, (Filter)filter, (String)string3, (PrintWriter)printWriter);
    }

    private static void setFilters(String string2) {
        InvokeDynamicSupport.bootstrapStatic("setFilters", $$robo$$com_android_internal_policy_impl_PolicyControl$setFilters(java.lang.String ), 0, (String)string2);
    }

    static {
        RobolectricInternals.classInitializing(PolicyControl.class);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (PolicyControl)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    private static class Filter
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private static String ALL = "*";
        private static String APPS = "apps";
        private ArraySet<String> mWhitelist;
        private ArraySet<String> mBlacklist;

        private void $$robo$$com_android_internal_policy_impl_PolicyControl_Filter$__constructor__(ArraySet<String> whitelist, ArraySet<String> blacklist) {
            this.mWhitelist = whitelist;
            this.mBlacklist = blacklist;
        }

        private final boolean $$robo$$com_android_internal_policy_impl_PolicyControl_Filter$matches(WindowManager.LayoutParams attrs) {
            boolean isApp;
            if (attrs == null) {
                return false;
            }
            boolean bl = isApp = attrs.type >= 1 && attrs.type <= 99;
            if (isApp && this.mBlacklist.contains("apps")) {
                return false;
            }
            if (this.onBlacklist(attrs.packageName)) {
                return false;
            }
            if (isApp && this.mWhitelist.contains("apps")) {
                return true;
            }
            return this.onWhitelist(attrs.packageName);
        }

        private final boolean $$robo$$com_android_internal_policy_impl_PolicyControl_Filter$matches(String packageName) {
            return !this.onBlacklist(packageName) && this.onWhitelist(packageName);
        }

        private final boolean $$robo$$com_android_internal_policy_impl_PolicyControl_Filter$onBlacklist(String packageName) {
            return this.mBlacklist.contains(packageName) || this.mBlacklist.contains("*");
        }

        private final boolean $$robo$$com_android_internal_policy_impl_PolicyControl_Filter$onWhitelist(String packageName) {
            return this.mWhitelist.contains("*") || this.mWhitelist.contains(packageName);
        }

        private final void $$robo$$com_android_internal_policy_impl_PolicyControl_Filter$dump(PrintWriter pw) {
            pw.print("Filter[");
            this.dump("whitelist", this.mWhitelist, pw);
            pw.print(',');
            this.dump("blacklist", this.mBlacklist, pw);
            pw.print(']');
        }

        private final void $$robo$$com_android_internal_policy_impl_PolicyControl_Filter$dump(String name, ArraySet<String> set, PrintWriter pw) {
            pw.print(name);
            pw.print("=(");
            int n = set.size();
            for (int i = 0; i < n; ++i) {
                if (i > 0) {
                    pw.print(',');
                }
                pw.print(set.valueAt(i));
            }
            pw.print(')');
        }

        private final String $$robo$$com_android_internal_policy_impl_PolicyControl_Filter$toString() {
            StringWriter sw = new StringWriter();
            this.dump(new PrintWriter(sw, true));
            return sw.toString();
        }

        private static final Filter $$robo$$com_android_internal_policy_impl_PolicyControl_Filter$parse(String value) {
            if (value == null) {
                return null;
            }
            ArraySet<String> whitelist = new ArraySet<String>();
            ArraySet<String> blacklist = new ArraySet<String>();
            for (String token : value.split(",")) {
                if ((token = token.trim()).startsWith("-") && token.length() > 1) {
                    token = token.substring(1);
                    blacklist.add(token);
                    continue;
                }
                whitelist.add(token);
            }
            return new Filter(whitelist, blacklist);
        }

        private void __constructor__(ArraySet<String> arraySet, ArraySet<String> arraySet2) {
            this.$$robo$$com_android_internal_policy_impl_PolicyControl_Filter$__constructor__(arraySet, arraySet2);
        }

        private Filter(ArraySet<String> arraySet, ArraySet<String> arraySet2) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_policy_impl_PolicyControl_Filter$__constructor__(android.util.ArraySet<java.lang.String> android.util.ArraySet<java.lang.String> ), 0, this, arraySet, arraySet2);
        }

        boolean matches(WindowManager.LayoutParams layoutParams) {
            return (boolean)InvokeDynamicSupport.bootstrap("matches", $$robo$$com_android_internal_policy_impl_PolicyControl_Filter$matches(android.view.WindowManager$LayoutParams ), 0, this, layoutParams);
        }

        boolean matches(String string2) {
            return (boolean)InvokeDynamicSupport.bootstrap("matches", $$robo$$com_android_internal_policy_impl_PolicyControl_Filter$matches(java.lang.String ), 0, this, string2);
        }

        private boolean onBlacklist(String string2) {
            return (boolean)InvokeDynamicSupport.bootstrap("onBlacklist", $$robo$$com_android_internal_policy_impl_PolicyControl_Filter$onBlacklist(java.lang.String ), 0, this, string2);
        }

        private boolean onWhitelist(String string2) {
            return (boolean)InvokeDynamicSupport.bootstrap("onWhitelist", $$robo$$com_android_internal_policy_impl_PolicyControl_Filter$onWhitelist(java.lang.String ), 0, this, string2);
        }

        void dump(PrintWriter printWriter) {
            InvokeDynamicSupport.bootstrap("dump", $$robo$$com_android_internal_policy_impl_PolicyControl_Filter$dump(java.io.PrintWriter ), 0, this, printWriter);
        }

        private void dump(String string2, ArraySet<String> arraySet, PrintWriter printWriter) {
            InvokeDynamicSupport.bootstrap("dump", $$robo$$com_android_internal_policy_impl_PolicyControl_Filter$dump(java.lang.String android.util.ArraySet<java.lang.String> java.io.PrintWriter ), 0, this, string2, arraySet, printWriter);
        }

        public String toString() {
            return InvokeDynamicSupport.bootstrap("toString", $$robo$$com_android_internal_policy_impl_PolicyControl_Filter$toString(), 0, this);
        }

        static Filter parse(String string2) {
            return InvokeDynamicSupport.bootstrapStatic("parse", $$robo$$com_android_internal_policy_impl_PolicyControl_Filter$parse(java.lang.String ), 0, (String)string2);
        }

        public /* synthetic */ Filter() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Filter)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

