/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.policy.impl;

import android.content.Context;
import android.content.Intent;
import android.database.ContentObserver;
import android.database.Cursor;
import android.os.Handler;
import android.provider.Settings;
import android.util.Log;
import android.util.SparseArray;
import android.view.KeyCharacterMap;
import java.net.URISyntaxException;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class ShortcutManager
extends ContentObserver
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "ShortcutManager";
    private static int COLUMN_SHORTCUT = 0;
    private static int COLUMN_INTENT = 1;
    private static String[] sProjection;
    private Context mContext;
    private Cursor mCursor;
    private SparseArray<Intent> mShortcutIntents;

    private void $$robo$$com_android_internal_policy_impl_ShortcutManager$__constructor__(Context context, Handler handler) {
        this.mContext = context;
        this.mShortcutIntents = new SparseArray();
    }

    private final void $$robo$$com_android_internal_policy_impl_ShortcutManager$observe() {
        this.mCursor = this.mContext.getContentResolver().query(Settings.Bookmarks.CONTENT_URI, sProjection, null, null, null);
        this.mCursor.registerContentObserver(this);
        this.updateShortcuts();
    }

    private final void $$robo$$com_android_internal_policy_impl_ShortcutManager$onChange(boolean selfChange) {
        this.updateShortcuts();
    }

    private final void $$robo$$com_android_internal_policy_impl_ShortcutManager$updateShortcuts() {
        Cursor c = this.mCursor;
        if (!c.requery()) {
            Log.e("ShortcutManager", "ShortcutObserver could not re-query shortcuts.");
            return;
        }
        this.mShortcutIntents.clear();
        while (c.moveToNext()) {
            int shortcut = c.getInt(0);
            if (shortcut == 0) continue;
            String intentURI = c.getString(1);
            Intent intent = null;
            try {
                intent = Intent.getIntent(intentURI);
            }
            catch (URISyntaxException e) {
                Log.w("ShortcutManager", "Intent URI for shortcut invalid.", e);
            }
            if (intent == null) continue;
            this.mShortcutIntents.put(shortcut, intent);
        }
    }

    private final Intent $$robo$$com_android_internal_policy_impl_ShortcutManager$getIntent(KeyCharacterMap kcm, int keyCode, int metaState) {
        Intent intent = null;
        int shortcut = kcm.get(keyCode, metaState);
        if (shortcut != 0) {
            intent = this.mShortcutIntents.get(shortcut);
        }
        if (intent == null && (shortcut = (int)Character.toLowerCase(kcm.getDisplayLabel(keyCode))) != 0) {
            intent = this.mShortcutIntents.get(shortcut);
        }
        return intent;
    }

    static void __staticInitializer__() {
        sProjection = new String[]{"shortcut", "intent"};
    }

    private void __constructor__(Context context, Handler handler) {
        this.$$robo$$com_android_internal_policy_impl_ShortcutManager$__constructor__(context, handler);
    }

    public ShortcutManager(Context context, Handler handler) {
        super(handler);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_policy_impl_ShortcutManager$__constructor__(android.content.Context android.os.Handler ), 0, this, context, handler);
    }

    public void observe() {
        InvokeDynamicSupport.bootstrap("observe", $$robo$$com_android_internal_policy_impl_ShortcutManager$observe(), 0, this);
    }

    @Override
    public void onChange(boolean bl) {
        InvokeDynamicSupport.bootstrap("onChange", $$robo$$com_android_internal_policy_impl_ShortcutManager$onChange(boolean ), 0, this, bl);
    }

    private void updateShortcuts() {
        InvokeDynamicSupport.bootstrap("updateShortcuts", $$robo$$com_android_internal_policy_impl_ShortcutManager$updateShortcuts(), 0, this);
    }

    public Intent getIntent(KeyCharacterMap keyCharacterMap, int n, int n2) {
        return InvokeDynamicSupport.bootstrap("getIntent", $$robo$$com_android_internal_policy_impl_ShortcutManager$getIntent(android.view.KeyCharacterMap int int ), 0, this, keyCharacterMap, n, n2);
    }

    static {
        RobolectricInternals.classInitializing(ShortcutManager.class);
    }

    public /* synthetic */ ShortcutManager() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ShortcutManager)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

