/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.policy.impl;

import android.content.Context;
import android.view.MotionEvent;
import android.view.WindowManagerPolicy;
import org.robolectric.internal.bytecode.InstrumentedInterface;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class SystemGesturesPointerEventListener
implements WindowManagerPolicy.PointerEventListener,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "SystemGestures";
    private static boolean DEBUG = false;
    private static long SWIPE_TIMEOUT_MS = 500L;
    private static int MAX_TRACKED_POINTERS = 32;
    private static int UNTRACKED_POINTER = -1;
    private static int SWIPE_NONE = 0;
    private static int SWIPE_FROM_TOP = 1;
    private static int SWIPE_FROM_BOTTOM = 2;
    private static int SWIPE_FROM_RIGHT = 3;
    private int mSwipeStartThreshold;
    private int mSwipeDistanceThreshold;
    private Callbacks mCallbacks;
    private int[] mDownPointerId;
    private float[] mDownX;
    private float[] mDownY;
    private long[] mDownTime;
    int screenHeight;
    int screenWidth;
    private int mDownPointers;
    private boolean mSwipeFireable;
    private boolean mDebugFireable;

    private void $$robo$$com_android_internal_policy_impl_SystemGesturesPointerEventListener$__constructor__(Context context, Callbacks callbacks) {
        this.mDownPointerId = new int[32];
        this.mDownX = new float[32];
        this.mDownY = new float[32];
        this.mDownTime = new long[32];
        this.mCallbacks = SystemGesturesPointerEventListener.checkNull("callbacks", callbacks);
        this.mSwipeDistanceThreshold = this.mSwipeStartThreshold = SystemGesturesPointerEventListener.checkNull("context", context).getResources().getDimensionPixelSize(0x1050010);
    }

    private static final <T> T $$robo$$com_android_internal_policy_impl_SystemGesturesPointerEventListener$checkNull(String name, T arg) {
        if (arg == null) {
            throw new IllegalArgumentException(name + " must not be null");
        }
        return arg;
    }

    private final void $$robo$$com_android_internal_policy_impl_SystemGesturesPointerEventListener$onPointerEvent(MotionEvent event) {
        switch (event.getActionMasked()) {
            case 0: {
                this.mSwipeFireable = true;
                this.mDebugFireable = true;
                this.mDownPointers = 0;
                this.captureDown(event, 0);
                break;
            }
            case 5: {
                this.captureDown(event, event.getActionIndex());
                if (!this.mDebugFireable) break;
                boolean bl = this.mDebugFireable = event.getPointerCount() < 5;
                if (this.mDebugFireable) break;
                this.mCallbacks.onDebug();
                break;
            }
            case 2: {
                if (!this.mSwipeFireable) break;
                int swipe = this.detectSwipe(event);
                boolean bl = this.mSwipeFireable = swipe == 0;
                if (swipe == 1) {
                    this.mCallbacks.onSwipeFromTop();
                    break;
                }
                if (swipe == 2) {
                    this.mCallbacks.onSwipeFromBottom();
                    break;
                }
                if (swipe != 3) break;
                this.mCallbacks.onSwipeFromRight();
                break;
            }
            case 1: 
            case 3: {
                this.mSwipeFireable = false;
                this.mDebugFireable = false;
                break;
            }
        }
    }

    private final void $$robo$$com_android_internal_policy_impl_SystemGesturesPointerEventListener$captureDown(MotionEvent event, int pointerIndex) {
        int pointerId = event.getPointerId(pointerIndex);
        int i = this.findIndex(pointerId);
        if (i != -1) {
            this.mDownX[i] = event.getX(pointerIndex);
            this.mDownY[i] = event.getY(pointerIndex);
            this.mDownTime[i] = event.getEventTime();
        }
    }

    private final int $$robo$$com_android_internal_policy_impl_SystemGesturesPointerEventListener$findIndex(int pointerId) {
        for (int i = 0; i < this.mDownPointers; ++i) {
            if (this.mDownPointerId[i] != pointerId) continue;
            return i;
        }
        if (this.mDownPointers == 32 || pointerId == -1) {
            return -1;
        }
        this.mDownPointerId[this.mDownPointers++] = pointerId;
        return this.mDownPointers - 1;
    }

    private final int $$robo$$com_android_internal_policy_impl_SystemGesturesPointerEventListener$detectSwipe(MotionEvent move) {
        int historySize = move.getHistorySize();
        int pointerCount = move.getPointerCount();
        for (int p = 0; p < pointerCount; ++p) {
            int pointerId = move.getPointerId(p);
            int i = this.findIndex(pointerId);
            if (i == -1) continue;
            for (int h = 0; h < historySize; ++h) {
                float y;
                float x;
                long time = move.getHistoricalEventTime(h);
                int swipe = this.detectSwipe(i, time, x = move.getHistoricalX(p, h), y = move.getHistoricalY(p, h));
                if (swipe == 0) continue;
                return swipe;
            }
            int swipe = this.detectSwipe(i, move.getEventTime(), move.getX(p), move.getY(p));
            if (swipe == 0) continue;
            return swipe;
        }
        return 0;
    }

    private final int $$robo$$com_android_internal_policy_impl_SystemGesturesPointerEventListener$detectSwipe(int i, long time, float x, float y) {
        float fromX = this.mDownX[i];
        float fromY = this.mDownY[i];
        long elapsed = time - this.mDownTime[i];
        if (fromY <= (float)this.mSwipeStartThreshold && y > fromY + (float)this.mSwipeDistanceThreshold && elapsed < 500L) {
            return 1;
        }
        if (fromY >= (float)(this.screenHeight - this.mSwipeStartThreshold) && y < fromY - (float)this.mSwipeDistanceThreshold && elapsed < 500L) {
            return 2;
        }
        if (fromX >= (float)(this.screenWidth - this.mSwipeStartThreshold) && x < fromX - (float)this.mSwipeDistanceThreshold && elapsed < 500L) {
            return 3;
        }
        return 0;
    }

    private void __constructor__(Context context, Callbacks callbacks) {
        this.$$robo$$com_android_internal_policy_impl_SystemGesturesPointerEventListener$__constructor__(context, callbacks);
    }

    public SystemGesturesPointerEventListener(Context context, Callbacks callbacks) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_policy_impl_SystemGesturesPointerEventListener$__constructor__(android.content.Context com.android.internal.policy.impl.SystemGesturesPointerEventListener$Callbacks ), 0, this, context, callbacks);
    }

    private static <T> T checkNull(String string2, T t) {
        return (T)InvokeDynamicSupport.bootstrapStatic("checkNull", $$robo$$com_android_internal_policy_impl_SystemGesturesPointerEventListener$checkNull(java.lang.String T ), 0, (String)string2, t);
    }

    @Override
    public void onPointerEvent(MotionEvent motionEvent) {
        InvokeDynamicSupport.bootstrap("onPointerEvent", $$robo$$com_android_internal_policy_impl_SystemGesturesPointerEventListener$onPointerEvent(android.view.MotionEvent ), 0, this, motionEvent);
    }

    private void captureDown(MotionEvent motionEvent, int n) {
        InvokeDynamicSupport.bootstrap("captureDown", $$robo$$com_android_internal_policy_impl_SystemGesturesPointerEventListener$captureDown(android.view.MotionEvent int ), 0, this, motionEvent, n);
    }

    private int findIndex(int n) {
        return (int)InvokeDynamicSupport.bootstrap("findIndex", $$robo$$com_android_internal_policy_impl_SystemGesturesPointerEventListener$findIndex(int ), 0, this, n);
    }

    private int detectSwipe(MotionEvent motionEvent) {
        return (int)InvokeDynamicSupport.bootstrap("detectSwipe", $$robo$$com_android_internal_policy_impl_SystemGesturesPointerEventListener$detectSwipe(android.view.MotionEvent ), 0, this, motionEvent);
    }

    private int detectSwipe(int n, long l, float f, float f2) {
        return (int)InvokeDynamicSupport.bootstrap("detectSwipe", $$robo$$com_android_internal_policy_impl_SystemGesturesPointerEventListener$detectSwipe(int long float float ), 0, this, n, l, f, f2);
    }

    public /* synthetic */ SystemGesturesPointerEventListener() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SystemGesturesPointerEventListener)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    static interface Callbacks
    extends InstrumentedInterface {
        public void onSwipeFromTop();

        public void onSwipeFromBottom();

        public void onSwipeFromRight();

        public void onDebug();
    }
}

