/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.policy.impl;

import android.content.Context;
import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;
import android.os.Handler;
import android.os.SystemProperties;
import android.util.FloatMath;
import android.util.Log;
import android.util.Slog;
import com.google.errorprone.annotations.DoNotMock;
import java.io.PrintWriter;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public abstract class WindowOrientationListener
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "WindowOrientationListener";
    private static boolean LOG;
    private static boolean USE_GRAVITY_SENSOR = false;
    private Handler mHandler;
    private SensorManager mSensorManager;
    private boolean mEnabled;
    private int mRate;
    private Sensor mSensor;
    private SensorEventListenerImpl mSensorEventListener;
    private int mCurrentRotation;
    private Object mLock;

    private void $$robo$$com_android_internal_policy_impl_WindowOrientationListener$__constructor__(Context context, Handler handler) {
    }

    private void $$robo$$com_android_internal_policy_impl_WindowOrientationListener$__constructor__(Context context, Handler handler, int rate) {
        this.mCurrentRotation = -1;
        this.mLock = new Object();
        this.mHandler = handler;
        this.mSensorManager = (SensorManager)context.getSystemService("sensor");
        this.mRate = rate;
        this.mSensor = this.mSensorManager.getDefaultSensor(1);
        if (this.mSensor != null) {
            this.mSensorEventListener = new SensorEventListenerImpl(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$com_android_internal_policy_impl_WindowOrientationListener$enable() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mSensor == null) {
                Log.w("WindowOrientationListener", "Cannot detect sensors. Not enabled");
                return;
            }
            if (!this.mEnabled) {
                if (LOG) {
                    Log.d("WindowOrientationListener", "WindowOrientationListener enabled");
                }
                this.mSensorEventListener.resetLocked();
                this.mSensorManager.registerListener((SensorEventListener)this.mSensorEventListener, this.mSensor, this.mRate, this.mHandler);
                this.mEnabled = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$com_android_internal_policy_impl_WindowOrientationListener$disable() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mSensor == null) {
                Log.w("WindowOrientationListener", "Cannot detect sensors. Invalid disable");
                return;
            }
            if (this.mEnabled) {
                if (LOG) {
                    Log.d("WindowOrientationListener", "WindowOrientationListener disabled");
                }
                this.mSensorManager.unregisterListener(this.mSensorEventListener);
                this.mEnabled = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$com_android_internal_policy_impl_WindowOrientationListener$setCurrentRotation(int rotation) {
        Object object = this.mLock;
        synchronized (object) {
            this.mCurrentRotation = rotation;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int $$robo$$com_android_internal_policy_impl_WindowOrientationListener$getProposedRotation() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mEnabled) {
                return this.mSensorEventListener.getProposedRotationLocked();
            }
            return -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean $$robo$$com_android_internal_policy_impl_WindowOrientationListener$canDetectOrientation() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mSensor != null;
        }
    }

    public abstract void onProposedRotationChanged(int var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$com_android_internal_policy_impl_WindowOrientationListener$dump(PrintWriter pw, String prefix) {
        Object object = this.mLock;
        synchronized (object) {
            pw.println(prefix + "WindowOrientationListener");
            prefix = prefix + "  ";
            pw.println(prefix + "mEnabled=" + this.mEnabled);
            pw.println(prefix + "mCurrentRotation=" + this.mCurrentRotation);
            pw.println(prefix + "mSensor=" + this.mSensor);
            pw.println(prefix + "mRate=" + this.mRate);
            if (this.mSensorEventListener != null) {
                this.mSensorEventListener.dumpLocked(pw, prefix);
            }
        }
    }

    static void __staticInitializer__() {
        LOG = SystemProperties.getBoolean("debug.orientation.log", false);
    }

    private void __constructor__(Context context, Handler handler) {
        this.$$robo$$com_android_internal_policy_impl_WindowOrientationListener$__constructor__(context, handler);
    }

    public WindowOrientationListener(Context context, Handler handler) {
        this(context, handler, 2);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_policy_impl_WindowOrientationListener$__constructor__(android.content.Context android.os.Handler ), 0, this, context, handler);
    }

    private void __constructor__(Context context, Handler handler, int n) {
        this.$$robo$$com_android_internal_policy_impl_WindowOrientationListener$__constructor__(context, handler, n);
    }

    private WindowOrientationListener(Context context, Handler handler, int n) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_policy_impl_WindowOrientationListener$__constructor__(android.content.Context android.os.Handler int ), 0, this, context, handler, n);
    }

    public void enable() {
        InvokeDynamicSupport.bootstrap("enable", $$robo$$com_android_internal_policy_impl_WindowOrientationListener$enable(), 0, this);
    }

    public void disable() {
        InvokeDynamicSupport.bootstrap("disable", $$robo$$com_android_internal_policy_impl_WindowOrientationListener$disable(), 0, this);
    }

    public void setCurrentRotation(int n) {
        InvokeDynamicSupport.bootstrap("setCurrentRotation", $$robo$$com_android_internal_policy_impl_WindowOrientationListener$setCurrentRotation(int ), 0, this, n);
    }

    public int getProposedRotation() {
        return (int)InvokeDynamicSupport.bootstrap("getProposedRotation", $$robo$$com_android_internal_policy_impl_WindowOrientationListener$getProposedRotation(), 0, this);
    }

    public boolean canDetectOrientation() {
        return (boolean)InvokeDynamicSupport.bootstrap("canDetectOrientation", $$robo$$com_android_internal_policy_impl_WindowOrientationListener$canDetectOrientation(), 0, this);
    }

    public void dump(PrintWriter printWriter, String string2) {
        InvokeDynamicSupport.bootstrap("dump", $$robo$$com_android_internal_policy_impl_WindowOrientationListener$dump(java.io.PrintWriter java.lang.String ), 0, this, printWriter, string2);
    }

    static {
        RobolectricInternals.classInitializing(WindowOrientationListener.class);
    }

    public /* synthetic */ WindowOrientationListener() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (WindowOrientationListener)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public final class SensorEventListenerImpl
    implements SensorEventListener,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private static float RADIANS_TO_DEGREES = 57.29578f;
        private static long NANOS_PER_MS = 1000000L;
        private static int ACCELEROMETER_DATA_X = 0;
        private static int ACCELEROMETER_DATA_Y = 1;
        private static int ACCELEROMETER_DATA_Z = 2;
        private static long PROPOSAL_SETTLE_TIME_NANOS = 40000000L;
        private static long PROPOSAL_MIN_TIME_SINCE_FLAT_ENDED_NANOS = 500000000L;
        private static long PROPOSAL_MIN_TIME_SINCE_SWING_ENDED_NANOS = 300000000L;
        private static long PROPOSAL_MIN_TIME_SINCE_ACCELERATION_ENDED_NANOS = 500000000L;
        private static float FLAT_ANGLE = 75.0f;
        private static long FLAT_TIME_NANOS = 1000000000L;
        private static float SWING_AWAY_ANGLE_DELTA = 20.0f;
        private static long SWING_TIME_NANOS = 300000000L;
        private static long MAX_FILTER_DELTA_TIME_NANOS = 1000000000L;
        private static float FILTER_TIME_CONSTANT_MS = 200.0f;
        private static float NEAR_ZERO_MAGNITUDE = 1.0f;
        private static float ACCELERATION_TOLERANCE = 4.0f;
        private static float MIN_ACCELERATION_MAGNITUDE = 5.80665f;
        private static float MAX_ACCELERATION_MAGNITUDE = 13.80665f;
        private static int MAX_TILT = 75;
        private int[][] TILT_TOLERANCE;
        private int TILT_OVERHEAD_ENTER = -40;
        private int TILT_OVERHEAD_EXIT = -15;
        private static int ADJACENT_ORIENTATION_ANGLE_GAP = 45;
        private long mLastFilteredTimestampNanos;
        private float mLastFilteredX;
        private float mLastFilteredY;
        private float mLastFilteredZ;
        private int mProposedRotation;
        private int mPredictedRotation;
        private long mPredictedRotationTimestampNanos;
        private long mFlatTimestampNanos;
        private boolean mFlat;
        private long mSwingTimestampNanos;
        private boolean mSwinging;
        private long mAccelerationTimestampNanos;
        private boolean mAccelerating;
        private boolean mOverhead;
        private static int TILT_HISTORY_SIZE = 40;
        private float[] mTiltHistory;
        private long[] mTiltHistoryTimestampNanos;
        private int mTiltHistoryIndex;
        /* synthetic */ WindowOrientationListener this$0;

        private void $$robo$$com_android_internal_policy_impl_WindowOrientationListener_SensorEventListenerImpl$__constructor__(WindowOrientationListener windowOrientationListener) {
            this.TILT_TOLERANCE = new int[][]{{-25, 70}, {-25, 65}, {-25, 60}, {-25, 65}};
            this.TILT_OVERHEAD_ENTER = -40;
            this.TILT_OVERHEAD_EXIT = -15;
            this.mTiltHistory = new float[40];
            this.mTiltHistoryTimestampNanos = new long[40];
        }

        private final int $$robo$$com_android_internal_policy_impl_WindowOrientationListener_SensorEventListenerImpl$getProposedRotationLocked() {
            return this.mProposedRotation;
        }

        private final void $$robo$$com_android_internal_policy_impl_WindowOrientationListener_SensorEventListenerImpl$dumpLocked(PrintWriter pw, String prefix) {
            pw.println(prefix + "mProposedRotation=" + this.mProposedRotation);
            pw.println(prefix + "mPredictedRotation=" + this.mPredictedRotation);
            pw.println(prefix + "mLastFilteredX=" + this.mLastFilteredX);
            pw.println(prefix + "mLastFilteredY=" + this.mLastFilteredY);
            pw.println(prefix + "mLastFilteredZ=" + this.mLastFilteredZ);
            pw.println(prefix + "mTiltHistory={last: " + this.getLastTiltLocked() + "}");
            pw.println(prefix + "mFlat=" + this.mFlat);
            pw.println(prefix + "mSwinging=" + this.mSwinging);
            pw.println(prefix + "mAccelerating=" + this.mAccelerating);
            pw.println(prefix + "mOverhead=" + this.mOverhead);
        }

        private final void $$robo$$com_android_internal_policy_impl_WindowOrientationListener_SensorEventListenerImpl$onAccuracyChanged(Sensor sensor, int accuracy) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$com_android_internal_policy_impl_WindowOrientationListener_SensorEventListenerImpl$onSensorChanged(SensorEvent event) {
            int proposedRotation;
            int oldProposedRotation;
            Object object = this.this$0.mLock;
            synchronized (object) {
                boolean skipSample;
                float x = event.values[0];
                float y = event.values[1];
                float z = event.values[2];
                if (LOG) {
                    Slog.v("WindowOrientationListener", "Raw acceleration vector: x=" + x + ", y=" + y + ", z=" + z + ", magnitude=" + FloatMath.sqrt(x * x + y * y + z * z));
                }
                long now = event.timestamp;
                long then = this.mLastFilteredTimestampNanos;
                float timeDeltaMS = (float)(now - then) * 1.0E-6f;
                if (now < then || now > then + 1000000000L || x == 0.0f && y == 0.0f && z == 0.0f) {
                    if (LOG) {
                        Slog.v("WindowOrientationListener", "Resetting orientation listener.");
                    }
                    this.resetLocked();
                    skipSample = true;
                } else {
                    float alpha = timeDeltaMS / (200.0f + timeDeltaMS);
                    x = alpha * (x - this.mLastFilteredX) + this.mLastFilteredX;
                    y = alpha * (y - this.mLastFilteredY) + this.mLastFilteredY;
                    z = alpha * (z - this.mLastFilteredZ) + this.mLastFilteredZ;
                    if (LOG) {
                        Slog.v("WindowOrientationListener", "Filtered acceleration vector: x=" + x + ", y=" + y + ", z=" + z + ", magnitude=" + FloatMath.sqrt(x * x + y * y + z * z));
                    }
                    skipSample = false;
                }
                this.mLastFilteredTimestampNanos = now;
                this.mLastFilteredX = x;
                this.mLastFilteredY = y;
                this.mLastFilteredZ = z;
                boolean isAccelerating = false;
                boolean isFlat = false;
                boolean isSwinging = false;
                if (!skipSample) {
                    float magnitude = FloatMath.sqrt(x * x + y * y + z * z);
                    if (magnitude < 1.0f) {
                        if (LOG) {
                            Slog.v("WindowOrientationListener", "Ignoring sensor data, magnitude too close to zero.");
                        }
                        this.clearPredictedRotationLocked();
                    } else {
                        if (this.isAcceleratingLocked(magnitude)) {
                            isAccelerating = true;
                            this.mAccelerationTimestampNanos = now;
                        }
                        int tiltAngle = (int)Math.round(Math.asin(z / magnitude) * (double)57.29578f);
                        this.addTiltHistoryEntryLocked(now, tiltAngle);
                        if (this.isFlatLocked(now)) {
                            isFlat = true;
                            this.mFlatTimestampNanos = now;
                        }
                        if (this.isSwingingLocked(now, tiltAngle)) {
                            isSwinging = true;
                            this.mSwingTimestampNanos = now;
                        }
                        if (tiltAngle <= -40) {
                            this.mOverhead = true;
                        } else if (tiltAngle >= -15) {
                            this.mOverhead = false;
                        }
                        if (this.mOverhead) {
                            if (LOG) {
                                Slog.v("WindowOrientationListener", "Ignoring sensor data, device is overhead: tiltAngle=" + tiltAngle);
                            }
                            this.clearPredictedRotationLocked();
                        } else if (Math.abs(tiltAngle) > 75) {
                            if (LOG) {
                                Slog.v("WindowOrientationListener", "Ignoring sensor data, tilt angle too high: tiltAngle=" + tiltAngle);
                            }
                            this.clearPredictedRotationLocked();
                        } else {
                            int nearestRotation;
                            int orientationAngle = (int)Math.round(-Math.atan2(-x, y) * (double)57.29578f);
                            if (orientationAngle < 0) {
                                orientationAngle += 360;
                            }
                            if ((nearestRotation = (orientationAngle + 45) / 90) == 4) {
                                nearestRotation = 0;
                            }
                            if (this.isTiltAngleAcceptableLocked(nearestRotation, tiltAngle) && this.isOrientationAngleAcceptableLocked(nearestRotation, orientationAngle)) {
                                this.updatePredictedRotationLocked(now, nearestRotation);
                                if (LOG) {
                                    Slog.v("WindowOrientationListener", "Predicted: tiltAngle=" + tiltAngle + ", orientationAngle=" + orientationAngle + ", predictedRotation=" + this.mPredictedRotation + ", predictedRotationAgeMS=" + (float)(now - this.mPredictedRotationTimestampNanos) * 1.0E-6f);
                                }
                            } else {
                                if (LOG) {
                                    Slog.v("WindowOrientationListener", "Ignoring sensor data, no predicted rotation: tiltAngle=" + tiltAngle + ", orientationAngle=" + orientationAngle);
                                }
                                this.clearPredictedRotationLocked();
                            }
                        }
                    }
                }
                this.mFlat = isFlat;
                this.mSwinging = isSwinging;
                this.mAccelerating = isAccelerating;
                oldProposedRotation = this.mProposedRotation;
                if (this.mPredictedRotation < 0 || this.isPredictedRotationAcceptableLocked(now)) {
                    this.mProposedRotation = this.mPredictedRotation;
                }
                proposedRotation = this.mProposedRotation;
                if (LOG) {
                    Slog.v("WindowOrientationListener", "Result: currentRotation=" + this.this$0.mCurrentRotation + ", proposedRotation=" + proposedRotation + ", predictedRotation=" + this.mPredictedRotation + ", timeDeltaMS=" + timeDeltaMS + ", isAccelerating=" + isAccelerating + ", isFlat=" + isFlat + ", isSwinging=" + isSwinging + ", isOverhead=" + this.mOverhead + ", timeUntilSettledMS=" + this.remainingMS(now, this.mPredictedRotationTimestampNanos + 40000000L) + ", timeUntilAccelerationDelayExpiredMS=" + this.remainingMS(now, this.mAccelerationTimestampNanos + 500000000L) + ", timeUntilFlatDelayExpiredMS=" + this.remainingMS(now, this.mFlatTimestampNanos + 500000000L) + ", timeUntilSwingDelayExpiredMS=" + this.remainingMS(now, this.mSwingTimestampNanos + 300000000L));
                }
            }
            if (proposedRotation != oldProposedRotation && proposedRotation >= 0) {
                if (LOG) {
                    Slog.v("WindowOrientationListener", "Proposed rotation changed!  proposedRotation=" + proposedRotation + ", oldProposedRotation=" + oldProposedRotation);
                }
                this.this$0.onProposedRotationChanged(proposedRotation);
            }
        }

        private final boolean $$robo$$com_android_internal_policy_impl_WindowOrientationListener_SensorEventListenerImpl$isTiltAngleAcceptableLocked(int rotation, int tiltAngle) {
            return tiltAngle >= this.TILT_TOLERANCE[rotation][0] && tiltAngle <= this.TILT_TOLERANCE[rotation][1];
        }

        private final boolean $$robo$$com_android_internal_policy_impl_WindowOrientationListener_SensorEventListenerImpl$isOrientationAngleAcceptableLocked(int rotation, int orientationAngle) {
            int currentRotation = this.this$0.mCurrentRotation;
            if (currentRotation >= 0) {
                if (rotation == currentRotation || rotation == (currentRotation + 1) % 4) {
                    int lowerBound = rotation * 90 - 45 + 22;
                    if (rotation == 0 ? orientationAngle >= 315 && orientationAngle < lowerBound + 360 : orientationAngle < lowerBound) {
                        return false;
                    }
                }
                if (rotation == currentRotation || rotation == (currentRotation + 3) % 4) {
                    int upperBound = rotation * 90 + 45 - 22;
                    if (rotation == 0 ? orientationAngle <= 45 && orientationAngle > upperBound : orientationAngle > upperBound) {
                        return false;
                    }
                }
            }
            return true;
        }

        private final boolean $$robo$$com_android_internal_policy_impl_WindowOrientationListener_SensorEventListenerImpl$isPredictedRotationAcceptableLocked(long now) {
            if (now < this.mPredictedRotationTimestampNanos + 40000000L) {
                return false;
            }
            if (now < this.mFlatTimestampNanos + 500000000L) {
                return false;
            }
            if (now < this.mSwingTimestampNanos + 300000000L) {
                return false;
            }
            return now >= this.mAccelerationTimestampNanos + 500000000L;
        }

        private final void $$robo$$com_android_internal_policy_impl_WindowOrientationListener_SensorEventListenerImpl$resetLocked() {
            this.mLastFilteredTimestampNanos = Long.MIN_VALUE;
            this.mProposedRotation = -1;
            this.mFlatTimestampNanos = Long.MIN_VALUE;
            this.mFlat = false;
            this.mSwingTimestampNanos = Long.MIN_VALUE;
            this.mSwinging = false;
            this.mAccelerationTimestampNanos = Long.MIN_VALUE;
            this.mAccelerating = false;
            this.mOverhead = false;
            this.clearPredictedRotationLocked();
            this.clearTiltHistoryLocked();
        }

        private final void $$robo$$com_android_internal_policy_impl_WindowOrientationListener_SensorEventListenerImpl$clearPredictedRotationLocked() {
            this.mPredictedRotation = -1;
            this.mPredictedRotationTimestampNanos = Long.MIN_VALUE;
        }

        private final void $$robo$$com_android_internal_policy_impl_WindowOrientationListener_SensorEventListenerImpl$updatePredictedRotationLocked(long now, int rotation) {
            if (this.mPredictedRotation != rotation) {
                this.mPredictedRotation = rotation;
                this.mPredictedRotationTimestampNanos = now;
            }
        }

        private final boolean $$robo$$com_android_internal_policy_impl_WindowOrientationListener_SensorEventListenerImpl$isAcceleratingLocked(float magnitude) {
            return magnitude < 5.80665f || magnitude > 13.80665f;
        }

        private final void $$robo$$com_android_internal_policy_impl_WindowOrientationListener_SensorEventListenerImpl$clearTiltHistoryLocked() {
            this.mTiltHistoryTimestampNanos[0] = Long.MIN_VALUE;
            this.mTiltHistoryIndex = 1;
        }

        private final void $$robo$$com_android_internal_policy_impl_WindowOrientationListener_SensorEventListenerImpl$addTiltHistoryEntryLocked(long now, float tilt) {
            this.mTiltHistory[this.mTiltHistoryIndex] = tilt;
            this.mTiltHistoryTimestampNanos[this.mTiltHistoryIndex] = now;
            this.mTiltHistoryIndex = (this.mTiltHistoryIndex + 1) % 40;
            this.mTiltHistoryTimestampNanos[this.mTiltHistoryIndex] = Long.MIN_VALUE;
        }

        private final boolean $$robo$$com_android_internal_policy_impl_WindowOrientationListener_SensorEventListenerImpl$isFlatLocked(long now) {
            int i = this.mTiltHistoryIndex;
            while ((i = this.nextTiltHistoryIndexLocked(i)) >= 0 && !(this.mTiltHistory[i] < 75.0f)) {
                if (this.mTiltHistoryTimestampNanos[i] + 1000000000L > now) continue;
                return true;
            }
            return false;
        }

        private final boolean $$robo$$com_android_internal_policy_impl_WindowOrientationListener_SensorEventListenerImpl$isSwingingLocked(long now, float tilt) {
            int i = this.mTiltHistoryIndex;
            while ((i = this.nextTiltHistoryIndexLocked(i)) >= 0 && this.mTiltHistoryTimestampNanos[i] + 300000000L >= now) {
                if (!(this.mTiltHistory[i] + 20.0f <= tilt)) continue;
                return true;
            }
            return false;
        }

        private final int $$robo$$com_android_internal_policy_impl_WindowOrientationListener_SensorEventListenerImpl$nextTiltHistoryIndexLocked(int index) {
            index = (index == 0 ? 40 : index) - 1;
            return this.mTiltHistoryTimestampNanos[index] != Long.MIN_VALUE ? index : -1;
        }

        private final float $$robo$$com_android_internal_policy_impl_WindowOrientationListener_SensorEventListenerImpl$getLastTiltLocked() {
            int index = this.nextTiltHistoryIndexLocked(this.mTiltHistoryIndex);
            return index >= 0 ? this.mTiltHistory[index] : Float.NaN;
        }

        private final float $$robo$$com_android_internal_policy_impl_WindowOrientationListener_SensorEventListenerImpl$remainingMS(long now, long until) {
            return now >= until ? 0.0f : (float)(until - now) * 1.0E-6f;
        }

        private void __constructor__(WindowOrientationListener windowOrientationListener) {
            this.$$robo$$com_android_internal_policy_impl_WindowOrientationListener_SensorEventListenerImpl$__constructor__(windowOrientationListener);
        }

        SensorEventListenerImpl(WindowOrientationListener windowOrientationListener) {
            this.this$0 = windowOrientationListener;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_policy_impl_WindowOrientationListener_SensorEventListenerImpl$__constructor__(com.android.internal.policy.impl.WindowOrientationListener ), 0, this, windowOrientationListener);
        }

        public int getProposedRotationLocked() {
            return (int)InvokeDynamicSupport.bootstrap("getProposedRotationLocked", $$robo$$com_android_internal_policy_impl_WindowOrientationListener_SensorEventListenerImpl$getProposedRotationLocked(), 0, this);
        }

        public void dumpLocked(PrintWriter printWriter, String string2) {
            InvokeDynamicSupport.bootstrap("dumpLocked", $$robo$$com_android_internal_policy_impl_WindowOrientationListener_SensorEventListenerImpl$dumpLocked(java.io.PrintWriter java.lang.String ), 0, this, printWriter, string2);
        }

        @Override
        public void onAccuracyChanged(Sensor sensor, int n) {
            InvokeDynamicSupport.bootstrap("onAccuracyChanged", $$robo$$com_android_internal_policy_impl_WindowOrientationListener_SensorEventListenerImpl$onAccuracyChanged(android.hardware.Sensor int ), 0, this, sensor, n);
        }

        @Override
        public void onSensorChanged(SensorEvent sensorEvent) {
            InvokeDynamicSupport.bootstrap("onSensorChanged", $$robo$$com_android_internal_policy_impl_WindowOrientationListener_SensorEventListenerImpl$onSensorChanged(android.hardware.SensorEvent ), 0, this, sensorEvent);
        }

        private boolean isTiltAngleAcceptableLocked(int n, int n2) {
            return (boolean)InvokeDynamicSupport.bootstrap("isTiltAngleAcceptableLocked", $$robo$$com_android_internal_policy_impl_WindowOrientationListener_SensorEventListenerImpl$isTiltAngleAcceptableLocked(int int ), 0, this, n, n2);
        }

        private boolean isOrientationAngleAcceptableLocked(int n, int n2) {
            return (boolean)InvokeDynamicSupport.bootstrap("isOrientationAngleAcceptableLocked", $$robo$$com_android_internal_policy_impl_WindowOrientationListener_SensorEventListenerImpl$isOrientationAngleAcceptableLocked(int int ), 0, this, n, n2);
        }

        private boolean isPredictedRotationAcceptableLocked(long l) {
            return (boolean)InvokeDynamicSupport.bootstrap("isPredictedRotationAcceptableLocked", $$robo$$com_android_internal_policy_impl_WindowOrientationListener_SensorEventListenerImpl$isPredictedRotationAcceptableLocked(long ), 0, this, l);
        }

        private void resetLocked() {
            InvokeDynamicSupport.bootstrap("resetLocked", $$robo$$com_android_internal_policy_impl_WindowOrientationListener_SensorEventListenerImpl$resetLocked(), 0, this);
        }

        private void clearPredictedRotationLocked() {
            InvokeDynamicSupport.bootstrap("clearPredictedRotationLocked", $$robo$$com_android_internal_policy_impl_WindowOrientationListener_SensorEventListenerImpl$clearPredictedRotationLocked(), 0, this);
        }

        private void updatePredictedRotationLocked(long l, int n) {
            InvokeDynamicSupport.bootstrap("updatePredictedRotationLocked", $$robo$$com_android_internal_policy_impl_WindowOrientationListener_SensorEventListenerImpl$updatePredictedRotationLocked(long int ), 0, this, l, n);
        }

        private boolean isAcceleratingLocked(float f) {
            return (boolean)InvokeDynamicSupport.bootstrap("isAcceleratingLocked", $$robo$$com_android_internal_policy_impl_WindowOrientationListener_SensorEventListenerImpl$isAcceleratingLocked(float ), 0, this, f);
        }

        private void clearTiltHistoryLocked() {
            InvokeDynamicSupport.bootstrap("clearTiltHistoryLocked", $$robo$$com_android_internal_policy_impl_WindowOrientationListener_SensorEventListenerImpl$clearTiltHistoryLocked(), 0, this);
        }

        private void addTiltHistoryEntryLocked(long l, float f) {
            InvokeDynamicSupport.bootstrap("addTiltHistoryEntryLocked", $$robo$$com_android_internal_policy_impl_WindowOrientationListener_SensorEventListenerImpl$addTiltHistoryEntryLocked(long float ), 0, this, l, f);
        }

        private boolean isFlatLocked(long l) {
            return (boolean)InvokeDynamicSupport.bootstrap("isFlatLocked", $$robo$$com_android_internal_policy_impl_WindowOrientationListener_SensorEventListenerImpl$isFlatLocked(long ), 0, this, l);
        }

        private boolean isSwingingLocked(long l, float f) {
            return (boolean)InvokeDynamicSupport.bootstrap("isSwingingLocked", $$robo$$com_android_internal_policy_impl_WindowOrientationListener_SensorEventListenerImpl$isSwingingLocked(long float ), 0, this, l, f);
        }

        private int nextTiltHistoryIndexLocked(int n) {
            return (int)InvokeDynamicSupport.bootstrap("nextTiltHistoryIndexLocked", $$robo$$com_android_internal_policy_impl_WindowOrientationListener_SensorEventListenerImpl$nextTiltHistoryIndexLocked(int ), 0, this, n);
        }

        private float getLastTiltLocked() {
            return (float)InvokeDynamicSupport.bootstrap("getLastTiltLocked", $$robo$$com_android_internal_policy_impl_WindowOrientationListener_SensorEventListenerImpl$getLastTiltLocked(), 0, this);
        }

        private float remainingMS(long l, long l2) {
            return (float)InvokeDynamicSupport.bootstrap("remainingMS", $$robo$$com_android_internal_policy_impl_WindowOrientationListener_SensorEventListenerImpl$remainingMS(long long ), 0, this, l, l2);
        }

        public /* synthetic */ SensorEventListenerImpl() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SensorEventListenerImpl)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

