/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.policy.impl.keyguard;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Bundle;
import android.os.IBinder;
import android.os.RemoteException;
import android.os.UserHandle;
import android.util.Log;
import android.util.Slog;
import android.view.View;
import android.view.WindowManager;
import android.view.WindowManagerPolicy;
import com.android.internal.policy.IKeyguardExitCallback;
import com.android.internal.policy.IKeyguardService;
import com.android.internal.policy.IKeyguardShowCallback;
import com.android.internal.policy.impl.keyguard.KeyguardServiceWrapper;
import com.android.internal.widget.LockPatternUtils;
import com.google.errorprone.annotations.DoNotMock;
import org.robolectric.internal.bytecode.InstrumentedInterface;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class KeyguardServiceDelegate
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    public static String KEYGUARD_PACKAGE = "com.android.systemui";
    public static String KEYGUARD_CLASS = "com.android.systemui.keyguard.KeyguardService";
    private static String TAG = "KeyguardServiceDelegate";
    private static boolean DEBUG = true;
    protected KeyguardServiceWrapper mKeyguardService;
    private View mScrim;
    private KeyguardState mKeyguardState;
    private ServiceConnection mKeyguardConnection;

    private void $$robo$$com_android_internal_policy_impl_keyguard_KeyguardServiceDelegate$__constructor__(Context context, LockPatternUtils lockPatternUtils) {
        this.mKeyguardState = new KeyguardState();
        this.mKeyguardConnection = new ServiceConnection(this){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ KeyguardServiceDelegate this$0;

            private void $$robo$$com_android_internal_policy_impl_keyguard_KeyguardServiceDelegate_1$__constructor__(KeyguardServiceDelegate keyguardServiceDelegate) {
            }

            private final void $$robo$$com_android_internal_policy_impl_keyguard_KeyguardServiceDelegate_1$onServiceConnected(ComponentName name, IBinder service) {
                Log.v("KeyguardServiceDelegate", "*** Keyguard connected (yay!)");
                this.this$0.mKeyguardService = new KeyguardServiceWrapper(IKeyguardService.Stub.asInterface(service));
                if (((KeyguardServiceDelegate)this.this$0).mKeyguardState.systemIsReady) {
                    this.this$0.mKeyguardService.onSystemReady();
                    this.this$0.mKeyguardService.onScreenTurnedOn(new KeyguardShowDelegate(this.this$0, null));
                }
                if (((KeyguardServiceDelegate)this.this$0).mKeyguardState.bootCompleted) {
                    this.this$0.mKeyguardService.onBootCompleted();
                }
            }

            private final void $$robo$$com_android_internal_policy_impl_keyguard_KeyguardServiceDelegate_1$onServiceDisconnected(ComponentName name) {
                Log.v("KeyguardServiceDelegate", "*** Keyguard disconnected (boo!)");
                this.this$0.mKeyguardService = null;
            }

            private void __constructor__(KeyguardServiceDelegate keyguardServiceDelegate) {
                this.$$robo$$com_android_internal_policy_impl_keyguard_KeyguardServiceDelegate_1$__constructor__(keyguardServiceDelegate);
            }
            {
                this.this$0 = keyguardServiceDelegate;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_policy_impl_keyguard_KeyguardServiceDelegate_1$__constructor__(com.android.internal.policy.impl.keyguard.KeyguardServiceDelegate ), 0, this, keyguardServiceDelegate);
            }

            @Override
            public void onServiceConnected(ComponentName componentName, IBinder iBinder) {
                InvokeDynamicSupport.bootstrap("onServiceConnected", $$robo$$com_android_internal_policy_impl_keyguard_KeyguardServiceDelegate_1$onServiceConnected(android.content.ComponentName android.os.IBinder ), 0, this, componentName, iBinder);
            }

            @Override
            public void onServiceDisconnected(ComponentName componentName) {
                InvokeDynamicSupport.bootstrap("onServiceDisconnected", $$robo$$com_android_internal_policy_impl_keyguard_KeyguardServiceDelegate_1$onServiceDisconnected(android.content.ComponentName ), 0, this, componentName);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.mScrim = KeyguardServiceDelegate.createScrim(context);
    }

    private final void $$robo$$com_android_internal_policy_impl_keyguard_KeyguardServiceDelegate$bindService(Context context) {
        Intent intent = new Intent();
        intent.setClassName("com.android.systemui", "com.android.systemui.keyguard.KeyguardService");
        if (!context.bindServiceAsUser(intent, this.mKeyguardConnection, 1, UserHandle.OWNER)) {
            Log.v("KeyguardServiceDelegate", "*** Keyguard: can't bind to com.android.systemui.keyguard.KeyguardService");
            this.mKeyguardState.showing = false;
            this.mKeyguardState.showingAndNotOccluded = false;
            this.mKeyguardState.secure = false;
        } else {
            Log.v("KeyguardServiceDelegate", "*** Keyguard started");
        }
    }

    private final boolean $$robo$$com_android_internal_policy_impl_keyguard_KeyguardServiceDelegate$isShowing() {
        if (this.mKeyguardService != null) {
            this.mKeyguardState.showing = this.mKeyguardService.isShowing();
        }
        return this.mKeyguardState.showing;
    }

    private final boolean $$robo$$com_android_internal_policy_impl_keyguard_KeyguardServiceDelegate$isShowingAndNotOccluded() {
        if (this.mKeyguardService != null) {
            this.mKeyguardState.showingAndNotOccluded = this.mKeyguardService.isShowingAndNotOccluded();
        }
        return this.mKeyguardState.showingAndNotOccluded;
    }

    private final boolean $$robo$$com_android_internal_policy_impl_keyguard_KeyguardServiceDelegate$isInputRestricted() {
        if (this.mKeyguardService != null) {
            this.mKeyguardState.inputRestricted = this.mKeyguardService.isInputRestricted();
        }
        return this.mKeyguardState.inputRestricted;
    }

    private final void $$robo$$com_android_internal_policy_impl_keyguard_KeyguardServiceDelegate$verifyUnlock(WindowManagerPolicy.OnKeyguardExitResult onKeyguardExitResult) {
        if (this.mKeyguardService != null) {
            this.mKeyguardService.verifyUnlock(new KeyguardExitDelegate(this, onKeyguardExitResult));
        }
    }

    private final void $$robo$$com_android_internal_policy_impl_keyguard_KeyguardServiceDelegate$keyguardDone(boolean authenticated, boolean wakeup) {
        if (this.mKeyguardService != null) {
            this.mKeyguardService.keyguardDone(authenticated, wakeup);
        }
    }

    private final int $$robo$$com_android_internal_policy_impl_keyguard_KeyguardServiceDelegate$setOccluded(boolean isOccluded) {
        int result = 0;
        if (this.mKeyguardService != null) {
            result = this.mKeyguardService.setOccluded(isOccluded);
        }
        this.mKeyguardState.occluded = isOccluded;
        return result;
    }

    private final void $$robo$$com_android_internal_policy_impl_keyguard_KeyguardServiceDelegate$dismiss() {
        if (this.mKeyguardService != null) {
            this.mKeyguardService.dismiss();
        }
    }

    private final boolean $$robo$$com_android_internal_policy_impl_keyguard_KeyguardServiceDelegate$isSecure() {
        if (this.mKeyguardService != null) {
            this.mKeyguardState.secure = this.mKeyguardService.isSecure();
        }
        return this.mKeyguardState.secure;
    }

    private final void $$robo$$com_android_internal_policy_impl_keyguard_KeyguardServiceDelegate$onDreamingStarted() {
        if (this.mKeyguardService != null) {
            this.mKeyguardService.onDreamingStarted();
        }
        this.mKeyguardState.dreaming = true;
    }

    private final void $$robo$$com_android_internal_policy_impl_keyguard_KeyguardServiceDelegate$onDreamingStopped() {
        if (this.mKeyguardService != null) {
            this.mKeyguardService.onDreamingStopped();
        }
        this.mKeyguardState.dreaming = false;
    }

    private final void $$robo$$com_android_internal_policy_impl_keyguard_KeyguardServiceDelegate$onScreenTurnedOn(ShowListener showListener) {
        if (this.mKeyguardService != null) {
            Log.v("KeyguardServiceDelegate", "onScreenTurnedOn(showListener = " + showListener + ")");
            this.mKeyguardService.onScreenTurnedOn(new KeyguardShowDelegate(this, showListener));
        } else {
            Slog.w("KeyguardServiceDelegate", "onScreenTurnedOn(): no keyguard service!");
            showListener.onShown(null);
        }
        this.mKeyguardState.screenIsOn = true;
    }

    private final void $$robo$$com_android_internal_policy_impl_keyguard_KeyguardServiceDelegate$onScreenTurnedOff(int why) {
        if (this.mKeyguardService != null) {
            this.mKeyguardService.onScreenTurnedOff(why);
        }
        this.mKeyguardState.offReason = why;
        this.mKeyguardState.screenIsOn = false;
    }

    private final void $$robo$$com_android_internal_policy_impl_keyguard_KeyguardServiceDelegate$setKeyguardEnabled(boolean enabled) {
        if (this.mKeyguardService != null) {
            this.mKeyguardService.setKeyguardEnabled(enabled);
        }
        this.mKeyguardState.enabled = enabled;
    }

    private final boolean $$robo$$com_android_internal_policy_impl_keyguard_KeyguardServiceDelegate$isDismissable() {
        if (this.mKeyguardService != null) {
            this.mKeyguardState.dismissable = this.mKeyguardService.isDismissable();
        }
        return this.mKeyguardState.dismissable;
    }

    private final void $$robo$$com_android_internal_policy_impl_keyguard_KeyguardServiceDelegate$onSystemReady() {
        if (this.mKeyguardService != null) {
            this.mKeyguardService.onSystemReady();
        } else {
            this.mKeyguardState.systemIsReady = true;
        }
    }

    private final void $$robo$$com_android_internal_policy_impl_keyguard_KeyguardServiceDelegate$doKeyguardTimeout(Bundle options) {
        if (this.mKeyguardService != null) {
            this.mKeyguardService.doKeyguardTimeout(options);
        }
    }

    private final void $$robo$$com_android_internal_policy_impl_keyguard_KeyguardServiceDelegate$showAssistant() {
        if (this.mKeyguardService != null) {
            this.mKeyguardService.showAssistant();
        }
    }

    private final void $$robo$$com_android_internal_policy_impl_keyguard_KeyguardServiceDelegate$setCurrentUser(int newUserId) {
        if (this.mKeyguardService != null) {
            this.mKeyguardService.setCurrentUser(newUserId);
        }
        this.mKeyguardState.currentUser = newUserId;
    }

    private final void $$robo$$com_android_internal_policy_impl_keyguard_KeyguardServiceDelegate$startKeyguardExitAnimation(long startTime, long fadeoutDuration) {
        if (this.mKeyguardService != null) {
            this.mKeyguardService.startKeyguardExitAnimation(startTime, fadeoutDuration);
        }
    }

    private static final View $$robo$$com_android_internal_policy_impl_keyguard_KeyguardServiceDelegate$createScrim(Context context) {
        View view = new View(context);
        int flags = 0x110900;
        int stretch = -1;
        int type = 2029;
        WindowManager.LayoutParams lp = new WindowManager.LayoutParams(-1, -1, 2029, flags, -3);
        lp.softInputMode = 16;
        lp.screenOrientation = 5;
        lp.privateFlags |= 1;
        lp.setTitle("KeyguardScrim");
        WindowManager wm = (WindowManager)context.getSystemService("window");
        wm.addView(view, lp);
        view.setVisibility(8);
        view.setSystemUiVisibility(56688640);
        return view;
    }

    private final void $$robo$$com_android_internal_policy_impl_keyguard_KeyguardServiceDelegate$showScrim() {
        this.mScrim.post(new Runnable(this){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ KeyguardServiceDelegate this$0;

            private void $$robo$$com_android_internal_policy_impl_keyguard_KeyguardServiceDelegate_2$__constructor__(KeyguardServiceDelegate keyguardServiceDelegate) {
            }

            private final void $$robo$$com_android_internal_policy_impl_keyguard_KeyguardServiceDelegate_2$run() {
                this.this$0.mScrim.setVisibility(0);
            }

            private void __constructor__(KeyguardServiceDelegate keyguardServiceDelegate) {
                this.$$robo$$com_android_internal_policy_impl_keyguard_KeyguardServiceDelegate_2$__constructor__(keyguardServiceDelegate);
            }
            {
                this.this$0 = keyguardServiceDelegate;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_policy_impl_keyguard_KeyguardServiceDelegate_2$__constructor__(com.android.internal.policy.impl.keyguard.KeyguardServiceDelegate ), 0, this, keyguardServiceDelegate);
            }

            @Override
            public void run() {
                InvokeDynamicSupport.bootstrap("run", $$robo$$com_android_internal_policy_impl_keyguard_KeyguardServiceDelegate_2$run(), 0, this);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        });
    }

    private final void $$robo$$com_android_internal_policy_impl_keyguard_KeyguardServiceDelegate$hideScrim() {
        this.mScrim.post(new Runnable(this){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ KeyguardServiceDelegate this$0;

            private void $$robo$$com_android_internal_policy_impl_keyguard_KeyguardServiceDelegate_3$__constructor__(KeyguardServiceDelegate keyguardServiceDelegate) {
            }

            private final void $$robo$$com_android_internal_policy_impl_keyguard_KeyguardServiceDelegate_3$run() {
                this.this$0.mScrim.setVisibility(8);
            }

            private void __constructor__(KeyguardServiceDelegate keyguardServiceDelegate) {
                this.$$robo$$com_android_internal_policy_impl_keyguard_KeyguardServiceDelegate_3$__constructor__(keyguardServiceDelegate);
            }
            {
                this.this$0 = keyguardServiceDelegate;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_policy_impl_keyguard_KeyguardServiceDelegate_3$__constructor__(com.android.internal.policy.impl.keyguard.KeyguardServiceDelegate ), 0, this, keyguardServiceDelegate);
            }

            @Override
            public void run() {
                InvokeDynamicSupport.bootstrap("run", $$robo$$com_android_internal_policy_impl_keyguard_KeyguardServiceDelegate_3$run(), 0, this);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        });
    }

    private final void $$robo$$com_android_internal_policy_impl_keyguard_KeyguardServiceDelegate$onBootCompleted() {
        if (this.mKeyguardService != null) {
            this.mKeyguardService.onBootCompleted();
        }
        this.mKeyguardState.bootCompleted = true;
    }

    private final void $$robo$$com_android_internal_policy_impl_keyguard_KeyguardServiceDelegate$onActivityDrawn() {
        if (this.mKeyguardService != null) {
            this.mKeyguardService.onActivityDrawn();
        }
    }

    private void __constructor__(Context context, LockPatternUtils lockPatternUtils) {
        this.$$robo$$com_android_internal_policy_impl_keyguard_KeyguardServiceDelegate$__constructor__(context, lockPatternUtils);
    }

    public KeyguardServiceDelegate(Context context, LockPatternUtils lockPatternUtils) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_policy_impl_keyguard_KeyguardServiceDelegate$__constructor__(android.content.Context com.android.internal.widget.LockPatternUtils ), 0, this, context, lockPatternUtils);
    }

    public void bindService(Context context) {
        InvokeDynamicSupport.bootstrap("bindService", $$robo$$com_android_internal_policy_impl_keyguard_KeyguardServiceDelegate$bindService(android.content.Context ), 0, this, context);
    }

    public boolean isShowing() {
        return (boolean)InvokeDynamicSupport.bootstrap("isShowing", $$robo$$com_android_internal_policy_impl_keyguard_KeyguardServiceDelegate$isShowing(), 0, this);
    }

    public boolean isShowingAndNotOccluded() {
        return (boolean)InvokeDynamicSupport.bootstrap("isShowingAndNotOccluded", $$robo$$com_android_internal_policy_impl_keyguard_KeyguardServiceDelegate$isShowingAndNotOccluded(), 0, this);
    }

    public boolean isInputRestricted() {
        return (boolean)InvokeDynamicSupport.bootstrap("isInputRestricted", $$robo$$com_android_internal_policy_impl_keyguard_KeyguardServiceDelegate$isInputRestricted(), 0, this);
    }

    public void verifyUnlock(WindowManagerPolicy.OnKeyguardExitResult onKeyguardExitResult) {
        InvokeDynamicSupport.bootstrap("verifyUnlock", $$robo$$com_android_internal_policy_impl_keyguard_KeyguardServiceDelegate$verifyUnlock(android.view.WindowManagerPolicy$OnKeyguardExitResult ), 0, this, onKeyguardExitResult);
    }

    public void keyguardDone(boolean bl, boolean bl2) {
        InvokeDynamicSupport.bootstrap("keyguardDone", $$robo$$com_android_internal_policy_impl_keyguard_KeyguardServiceDelegate$keyguardDone(boolean boolean ), 0, this, bl, bl2);
    }

    public int setOccluded(boolean bl) {
        return (int)InvokeDynamicSupport.bootstrap("setOccluded", $$robo$$com_android_internal_policy_impl_keyguard_KeyguardServiceDelegate$setOccluded(boolean ), 0, this, bl);
    }

    public void dismiss() {
        InvokeDynamicSupport.bootstrap("dismiss", $$robo$$com_android_internal_policy_impl_keyguard_KeyguardServiceDelegate$dismiss(), 0, this);
    }

    public boolean isSecure() {
        return (boolean)InvokeDynamicSupport.bootstrap("isSecure", $$robo$$com_android_internal_policy_impl_keyguard_KeyguardServiceDelegate$isSecure(), 0, this);
    }

    public void onDreamingStarted() {
        InvokeDynamicSupport.bootstrap("onDreamingStarted", $$robo$$com_android_internal_policy_impl_keyguard_KeyguardServiceDelegate$onDreamingStarted(), 0, this);
    }

    public void onDreamingStopped() {
        InvokeDynamicSupport.bootstrap("onDreamingStopped", $$robo$$com_android_internal_policy_impl_keyguard_KeyguardServiceDelegate$onDreamingStopped(), 0, this);
    }

    public void onScreenTurnedOn(ShowListener showListener) {
        InvokeDynamicSupport.bootstrap("onScreenTurnedOn", $$robo$$com_android_internal_policy_impl_keyguard_KeyguardServiceDelegate$onScreenTurnedOn(com.android.internal.policy.impl.keyguard.KeyguardServiceDelegate$ShowListener ), 0, this, showListener);
    }

    public void onScreenTurnedOff(int n) {
        InvokeDynamicSupport.bootstrap("onScreenTurnedOff", $$robo$$com_android_internal_policy_impl_keyguard_KeyguardServiceDelegate$onScreenTurnedOff(int ), 0, this, n);
    }

    public void setKeyguardEnabled(boolean bl) {
        InvokeDynamicSupport.bootstrap("setKeyguardEnabled", $$robo$$com_android_internal_policy_impl_keyguard_KeyguardServiceDelegate$setKeyguardEnabled(boolean ), 0, this, bl);
    }

    public boolean isDismissable() {
        return (boolean)InvokeDynamicSupport.bootstrap("isDismissable", $$robo$$com_android_internal_policy_impl_keyguard_KeyguardServiceDelegate$isDismissable(), 0, this);
    }

    public void onSystemReady() {
        InvokeDynamicSupport.bootstrap("onSystemReady", $$robo$$com_android_internal_policy_impl_keyguard_KeyguardServiceDelegate$onSystemReady(), 0, this);
    }

    public void doKeyguardTimeout(Bundle bundle) {
        InvokeDynamicSupport.bootstrap("doKeyguardTimeout", $$robo$$com_android_internal_policy_impl_keyguard_KeyguardServiceDelegate$doKeyguardTimeout(android.os.Bundle ), 0, this, bundle);
    }

    public void showAssistant() {
        InvokeDynamicSupport.bootstrap("showAssistant", $$robo$$com_android_internal_policy_impl_keyguard_KeyguardServiceDelegate$showAssistant(), 0, this);
    }

    public void setCurrentUser(int n) {
        InvokeDynamicSupport.bootstrap("setCurrentUser", $$robo$$com_android_internal_policy_impl_keyguard_KeyguardServiceDelegate$setCurrentUser(int ), 0, this, n);
    }

    public void startKeyguardExitAnimation(long l, long l2) {
        InvokeDynamicSupport.bootstrap("startKeyguardExitAnimation", $$robo$$com_android_internal_policy_impl_keyguard_KeyguardServiceDelegate$startKeyguardExitAnimation(long long ), 0, this, l, l2);
    }

    private static View createScrim(Context context) {
        return InvokeDynamicSupport.bootstrapStatic("createScrim", $$robo$$com_android_internal_policy_impl_keyguard_KeyguardServiceDelegate$createScrim(android.content.Context ), 0, (Context)context);
    }

    public void showScrim() {
        InvokeDynamicSupport.bootstrap("showScrim", $$robo$$com_android_internal_policy_impl_keyguard_KeyguardServiceDelegate$showScrim(), 0, this);
    }

    public void hideScrim() {
        InvokeDynamicSupport.bootstrap("hideScrim", $$robo$$com_android_internal_policy_impl_keyguard_KeyguardServiceDelegate$hideScrim(), 0, this);
    }

    public void onBootCompleted() {
        InvokeDynamicSupport.bootstrap("onBootCompleted", $$robo$$com_android_internal_policy_impl_keyguard_KeyguardServiceDelegate$onBootCompleted(), 0, this);
    }

    public void onActivityDrawn() {
        InvokeDynamicSupport.bootstrap("onActivityDrawn", $$robo$$com_android_internal_policy_impl_keyguard_KeyguardServiceDelegate$onActivityDrawn(), 0, this);
    }

    public /* synthetic */ KeyguardServiceDelegate() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (KeyguardServiceDelegate)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    private final class KeyguardExitDelegate
    extends IKeyguardExitCallback.Stub
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private WindowManagerPolicy.OnKeyguardExitResult mOnKeyguardExitResult;
        /* synthetic */ KeyguardServiceDelegate this$0;

        private void $$robo$$com_android_internal_policy_impl_keyguard_KeyguardServiceDelegate_KeyguardExitDelegate$__constructor__(KeyguardServiceDelegate keyguardServiceDelegate, WindowManagerPolicy.OnKeyguardExitResult onKeyguardExitResult) {
            this.mOnKeyguardExitResult = onKeyguardExitResult;
        }

        private final void $$robo$$com_android_internal_policy_impl_keyguard_KeyguardServiceDelegate_KeyguardExitDelegate$onKeyguardExitResult(boolean success) throws RemoteException {
            Log.v("KeyguardServiceDelegate", "**** onKeyguardExitResult(" + success + ") CALLED ****");
            if (this.mOnKeyguardExitResult != null) {
                this.mOnKeyguardExitResult.onKeyguardExitResult(success);
            }
        }

        private void __constructor__(KeyguardServiceDelegate keyguardServiceDelegate, WindowManagerPolicy.OnKeyguardExitResult onKeyguardExitResult) {
            this.$$robo$$com_android_internal_policy_impl_keyguard_KeyguardServiceDelegate_KeyguardExitDelegate$__constructor__(keyguardServiceDelegate, onKeyguardExitResult);
        }

        KeyguardExitDelegate(KeyguardServiceDelegate keyguardServiceDelegate, WindowManagerPolicy.OnKeyguardExitResult onKeyguardExitResult) {
            this.this$0 = keyguardServiceDelegate;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_policy_impl_keyguard_KeyguardServiceDelegate_KeyguardExitDelegate$__constructor__(com.android.internal.policy.impl.keyguard.KeyguardServiceDelegate android.view.WindowManagerPolicy$OnKeyguardExitResult ), 0, this, keyguardServiceDelegate, onKeyguardExitResult);
        }

        @Override
        public void onKeyguardExitResult(boolean bl) throws RemoteException {
            InvokeDynamicSupport.bootstrap("onKeyguardExitResult", $$robo$$com_android_internal_policy_impl_keyguard_KeyguardServiceDelegate_KeyguardExitDelegate$onKeyguardExitResult(boolean ), 0, this, bl);
        }

        public /* synthetic */ KeyguardExitDelegate() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (KeyguardExitDelegate)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    private final class KeyguardShowDelegate
    extends IKeyguardShowCallback.Stub
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private ShowListener mShowListener;
        /* synthetic */ KeyguardServiceDelegate this$0;

        private void $$robo$$com_android_internal_policy_impl_keyguard_KeyguardServiceDelegate_KeyguardShowDelegate$__constructor__(KeyguardServiceDelegate keyguardServiceDelegate, ShowListener showListener) {
            this.mShowListener = showListener;
        }

        private final void $$robo$$com_android_internal_policy_impl_keyguard_KeyguardServiceDelegate_KeyguardShowDelegate$onShown(IBinder windowToken) throws RemoteException {
            Log.v("KeyguardServiceDelegate", "**** SHOWN CALLED ****");
            if (this.mShowListener != null) {
                this.mShowListener.onShown(windowToken);
            }
            this.this$0.hideScrim();
        }

        private void __constructor__(KeyguardServiceDelegate keyguardServiceDelegate, ShowListener showListener) {
            this.$$robo$$com_android_internal_policy_impl_keyguard_KeyguardServiceDelegate_KeyguardShowDelegate$__constructor__(keyguardServiceDelegate, showListener);
        }

        KeyguardShowDelegate(KeyguardServiceDelegate keyguardServiceDelegate, ShowListener showListener) {
            this.this$0 = keyguardServiceDelegate;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_policy_impl_keyguard_KeyguardServiceDelegate_KeyguardShowDelegate$__constructor__(com.android.internal.policy.impl.keyguard.KeyguardServiceDelegate com.android.internal.policy.impl.keyguard.KeyguardServiceDelegate$ShowListener ), 0, this, keyguardServiceDelegate, showListener);
        }

        @Override
        public void onShown(IBinder iBinder) throws RemoteException {
            InvokeDynamicSupport.bootstrap("onShown", $$robo$$com_android_internal_policy_impl_keyguard_KeyguardServiceDelegate_KeyguardShowDelegate$onShown(android.os.IBinder ), 0, this, iBinder);
        }

        public /* synthetic */ KeyguardShowDelegate() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (KeyguardShowDelegate)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static interface ShowListener
    extends InstrumentedInterface {
        public void onShown(IBinder var1);
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public static final class KeyguardState
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        boolean showing;
        boolean showingAndNotOccluded;
        boolean inputRestricted;
        boolean occluded;
        boolean secure;
        boolean dreaming;
        boolean systemIsReady;
        public boolean enabled;
        public boolean dismissable;
        public int offReason;
        public int currentUser;
        public boolean screenIsOn;
        public boolean bootCompleted;

        private void $$robo$$com_android_internal_policy_impl_keyguard_KeyguardServiceDelegate_KeyguardState$__constructor__() {
            this.showing = true;
            this.showingAndNotOccluded = true;
            this.secure = true;
        }

        private void __constructor__() {
            this.$$robo$$com_android_internal_policy_impl_keyguard_KeyguardServiceDelegate_KeyguardState$__constructor__();
        }

        KeyguardState() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_policy_impl_keyguard_KeyguardServiceDelegate_KeyguardState$__constructor__(), 0, this);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (KeyguardState)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

