/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.content.Context;
import android.os.AsyncResult;
import android.os.Handler;
import android.os.Message;
import android.os.Registrant;
import android.os.RegistrantList;
import android.telephony.PhoneNumberUtils;
import android.telephony.Rlog;
import android.telephony.TelephonyManager;
import com.android.internal.telephony.Call;
import com.android.internal.telephony.CallStateException;
import com.android.internal.telephony.Connection;
import com.android.internal.telephony.MmiCode;
import com.android.internal.telephony.Phone;
import com.android.internal.telephony.PhoneConstants;
import com.android.internal.telephony.PhoneProxy;
import com.android.internal.telephony.UUSInfo;
import com.android.internal.telephony.imsphone.ImsPhone;
import com.android.internal.telephony.sip.SipPhone;
import com.google.errorprone.annotations.DoNotMock;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class CallManager
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String LOG_TAG = "CallManager";
    private static boolean DBG = true;
    private static boolean VDBG = false;
    private static int EVENT_DISCONNECT = 100;
    private static int EVENT_PRECISE_CALL_STATE_CHANGED = 101;
    private static int EVENT_NEW_RINGING_CONNECTION = 102;
    private static int EVENT_UNKNOWN_CONNECTION = 103;
    private static int EVENT_INCOMING_RING = 104;
    private static int EVENT_RINGBACK_TONE = 105;
    private static int EVENT_IN_CALL_VOICE_PRIVACY_ON = 106;
    private static int EVENT_IN_CALL_VOICE_PRIVACY_OFF = 107;
    private static int EVENT_CALL_WAITING = 108;
    private static int EVENT_DISPLAY_INFO = 109;
    private static int EVENT_SIGNAL_INFO = 110;
    private static int EVENT_CDMA_OTA_STATUS_CHANGE = 111;
    private static int EVENT_RESEND_INCALL_MUTE = 112;
    private static int EVENT_MMI_INITIATE = 113;
    private static int EVENT_MMI_COMPLETE = 114;
    private static int EVENT_ECM_TIMER_RESET = 115;
    private static int EVENT_SUBSCRIPTION_INFO_READY = 116;
    private static int EVENT_SUPP_SERVICE_FAILED = 117;
    private static int EVENT_SERVICE_STATE_CHANGED = 118;
    private static int EVENT_POST_DIAL_CHARACTER = 119;
    private static int EVENT_ONHOLD_TONE = 120;
    private static CallManager INSTANCE;
    private ArrayList<Phone> mPhones;
    private ArrayList<Call> mRingingCalls;
    private ArrayList<Call> mBackgroundCalls;
    private ArrayList<Call> mForegroundCalls;
    private ArrayList<Connection> mEmptyConnections;
    private HashMap<Phone, CallManagerHandler> mHandlerMap;
    private Phone mDefaultPhone;
    private boolean mSpeedUpAudioForMtCall;
    protected RegistrantList mPreciseCallStateRegistrants;
    protected RegistrantList mNewRingingConnectionRegistrants;
    protected RegistrantList mIncomingRingRegistrants;
    protected RegistrantList mDisconnectRegistrants;
    protected RegistrantList mMmiRegistrants;
    protected RegistrantList mUnknownConnectionRegistrants;
    protected RegistrantList mRingbackToneRegistrants;
    protected RegistrantList mOnHoldToneRegistrants;
    protected RegistrantList mInCallVoicePrivacyOnRegistrants;
    protected RegistrantList mInCallVoicePrivacyOffRegistrants;
    protected RegistrantList mCallWaitingRegistrants;
    protected RegistrantList mDisplayInfoRegistrants;
    protected RegistrantList mSignalInfoRegistrants;
    protected RegistrantList mCdmaOtaStatusChangeRegistrants;
    protected RegistrantList mResendIncallMuteRegistrants;
    protected RegistrantList mMmiInitiateRegistrants;
    protected RegistrantList mMmiCompleteRegistrants;
    protected RegistrantList mEcmTimerResetRegistrants;
    protected RegistrantList mSubscriptionInfoReadyRegistrants;
    protected RegistrantList mSuppServiceFailedRegistrants;
    protected RegistrantList mServiceStateChangedRegistrants;
    protected RegistrantList mPostDialCharacterRegistrants;

    private void $$robo$$com_android_internal_telephony_CallManager$__constructor__() {
        this.mEmptyConnections = new ArrayList();
        this.mHandlerMap = new HashMap();
        this.mSpeedUpAudioForMtCall = false;
        this.mPreciseCallStateRegistrants = new RegistrantList();
        this.mNewRingingConnectionRegistrants = new RegistrantList();
        this.mIncomingRingRegistrants = new RegistrantList();
        this.mDisconnectRegistrants = new RegistrantList();
        this.mMmiRegistrants = new RegistrantList();
        this.mUnknownConnectionRegistrants = new RegistrantList();
        this.mRingbackToneRegistrants = new RegistrantList();
        this.mOnHoldToneRegistrants = new RegistrantList();
        this.mInCallVoicePrivacyOnRegistrants = new RegistrantList();
        this.mInCallVoicePrivacyOffRegistrants = new RegistrantList();
        this.mCallWaitingRegistrants = new RegistrantList();
        this.mDisplayInfoRegistrants = new RegistrantList();
        this.mSignalInfoRegistrants = new RegistrantList();
        this.mCdmaOtaStatusChangeRegistrants = new RegistrantList();
        this.mResendIncallMuteRegistrants = new RegistrantList();
        this.mMmiInitiateRegistrants = new RegistrantList();
        this.mMmiCompleteRegistrants = new RegistrantList();
        this.mEcmTimerResetRegistrants = new RegistrantList();
        this.mSubscriptionInfoReadyRegistrants = new RegistrantList();
        this.mSuppServiceFailedRegistrants = new RegistrantList();
        this.mServiceStateChangedRegistrants = new RegistrantList();
        this.mPostDialCharacterRegistrants = new RegistrantList();
        this.mPhones = new ArrayList();
        this.mRingingCalls = new ArrayList();
        this.mBackgroundCalls = new ArrayList();
        this.mForegroundCalls = new ArrayList();
        this.mDefaultPhone = null;
    }

    private static final CallManager $$robo$$com_android_internal_telephony_CallManager$getInstance() {
        return INSTANCE;
    }

    private static final Phone $$robo$$com_android_internal_telephony_CallManager$getPhoneBase(Phone phone) {
        if (phone instanceof PhoneProxy) {
            return phone.getForegroundCall().getPhone();
        }
        return phone;
    }

    private static final boolean $$robo$$com_android_internal_telephony_CallManager$isSamePhone(Phone p1, Phone p2) {
        return CallManager.getPhoneBase(p1) == CallManager.getPhoneBase(p2);
    }

    private final List<Phone> $$robo$$com_android_internal_telephony_CallManager$getAllPhones() {
        return Collections.unmodifiableList(this.mPhones);
    }

    private final Phone $$robo$$com_android_internal_telephony_CallManager$getPhone(long subId) {
        Phone p = null;
        for (Phone phone : this.mPhones) {
            if (phone.getSubId() != subId || phone instanceof ImsPhone) continue;
            p = phone;
            break;
        }
        return p;
    }

    private final PhoneConstants.State $$robo$$com_android_internal_telephony_CallManager$getState() {
        PhoneConstants.State s = PhoneConstants.State.IDLE;
        for (Phone phone : this.mPhones) {
            if (phone.getState() == PhoneConstants.State.RINGING) {
                s = PhoneConstants.State.RINGING;
                continue;
            }
            if (phone.getState() != PhoneConstants.State.OFFHOOK || s != PhoneConstants.State.IDLE) continue;
            s = PhoneConstants.State.OFFHOOK;
        }
        return s;
    }

    private final PhoneConstants.State $$robo$$com_android_internal_telephony_CallManager$getState(long subId) {
        PhoneConstants.State s = PhoneConstants.State.IDLE;
        for (Phone phone : this.mPhones) {
            if (phone.getSubId() != subId) continue;
            if (phone.getState() == PhoneConstants.State.RINGING) {
                s = PhoneConstants.State.RINGING;
                continue;
            }
            if (phone.getState() != PhoneConstants.State.OFFHOOK || s != PhoneConstants.State.IDLE) continue;
            s = PhoneConstants.State.OFFHOOK;
        }
        return s;
    }

    private final int $$robo$$com_android_internal_telephony_CallManager$getServiceState() {
        int resultState = 1;
        for (Phone phone : this.mPhones) {
            int serviceState = phone.getServiceState().getState();
            if (serviceState == 0) {
                resultState = serviceState;
                break;
            }
            if (serviceState == 1) {
                if (resultState != 2 && resultState != 3) continue;
                resultState = serviceState;
                continue;
            }
            if (serviceState != 2 || resultState != 3) continue;
            resultState = serviceState;
        }
        return resultState;
    }

    private final int $$robo$$com_android_internal_telephony_CallManager$getServiceState(long subId) {
        int resultState = 1;
        for (Phone phone : this.mPhones) {
            if (phone.getSubId() != subId) continue;
            int serviceState = phone.getServiceState().getState();
            if (serviceState == 0) {
                resultState = serviceState;
                break;
            }
            if (serviceState == 1) {
                if (resultState != 2 && resultState != 3) continue;
                resultState = serviceState;
                continue;
            }
            if (serviceState != 2 || resultState != 3) continue;
            resultState = serviceState;
        }
        return resultState;
    }

    private final Phone $$robo$$com_android_internal_telephony_CallManager$getPhoneInCall() {
        Phone phone = null;
        phone = !this.getFirstActiveRingingCall().isIdle() ? this.getFirstActiveRingingCall().getPhone() : (!this.getActiveFgCall().isIdle() ? this.getActiveFgCall().getPhone() : this.getFirstActiveBgCall().getPhone());
        return phone;
    }

    private final Phone $$robo$$com_android_internal_telephony_CallManager$getPhoneInCall(long subId) {
        Phone phone = null;
        phone = !this.getFirstActiveRingingCall(subId).isIdle() ? this.getFirstActiveRingingCall(subId).getPhone() : (!this.getActiveFgCall(subId).isIdle() ? this.getActiveFgCall(subId).getPhone() : this.getFirstActiveBgCall(subId).getPhone());
        return phone;
    }

    private final boolean $$robo$$com_android_internal_telephony_CallManager$registerPhone(Phone phone) {
        Phone basePhone = CallManager.getPhoneBase(phone);
        if (basePhone != null && !this.mPhones.contains(basePhone)) {
            Rlog.d("CallManager", "registerPhone(" + phone.getPhoneName() + " " + phone + ")");
            if (this.mPhones.isEmpty()) {
                this.mDefaultPhone = basePhone;
            }
            this.mPhones.add(basePhone);
            this.mRingingCalls.add(basePhone.getRingingCall());
            this.mBackgroundCalls.add(basePhone.getBackgroundCall());
            this.mForegroundCalls.add(basePhone.getForegroundCall());
            this.registerForPhoneStates(basePhone);
            return true;
        }
        return false;
    }

    private final void $$robo$$com_android_internal_telephony_CallManager$unregisterPhone(Phone phone) {
        Phone basePhone = CallManager.getPhoneBase(phone);
        if (basePhone != null && this.mPhones.contains(basePhone)) {
            Rlog.d("CallManager", "unregisterPhone(" + phone.getPhoneName() + " " + phone + ")");
            Phone vPhone = basePhone.getImsPhone();
            if (vPhone != null) {
                this.unregisterPhone(vPhone);
            }
            this.mPhones.remove(basePhone);
            this.mRingingCalls.remove(basePhone.getRingingCall());
            this.mBackgroundCalls.remove(basePhone.getBackgroundCall());
            this.mForegroundCalls.remove(basePhone.getForegroundCall());
            this.unregisterForPhoneStates(basePhone);
            if (basePhone == this.mDefaultPhone) {
                this.mDefaultPhone = this.mPhones.isEmpty() ? null : this.mPhones.get(0);
            }
        }
    }

    private final Phone $$robo$$com_android_internal_telephony_CallManager$getDefaultPhone() {
        return this.mDefaultPhone;
    }

    private final Phone $$robo$$com_android_internal_telephony_CallManager$getFgPhone() {
        return this.getActiveFgCall().getPhone();
    }

    private final Phone $$robo$$com_android_internal_telephony_CallManager$getFgPhone(long subId) {
        return this.getActiveFgCall(subId).getPhone();
    }

    private final Phone $$robo$$com_android_internal_telephony_CallManager$getBgPhone() {
        return this.getFirstActiveBgCall().getPhone();
    }

    private final Phone $$robo$$com_android_internal_telephony_CallManager$getBgPhone(long subId) {
        return this.getFirstActiveBgCall(subId).getPhone();
    }

    private final Phone $$robo$$com_android_internal_telephony_CallManager$getRingingPhone() {
        return this.getFirstActiveRingingCall().getPhone();
    }

    private final Phone $$robo$$com_android_internal_telephony_CallManager$getRingingPhone(long subId) {
        return this.getFirstActiveRingingCall(subId).getPhone();
    }

    private final Context $$robo$$com_android_internal_telephony_CallManager$getContext() {
        Phone defaultPhone = this.getDefaultPhone();
        return defaultPhone == null ? null : defaultPhone.getContext();
    }

    private final void $$robo$$com_android_internal_telephony_CallManager$registerForPhoneStates(Phone phone) {
        CallManagerHandler handler = this.mHandlerMap.get(phone);
        if (handler != null) {
            Rlog.d("CallManager", "This phone has already been registered.");
            return;
        }
        handler = new CallManagerHandler(this);
        this.mHandlerMap.put(phone, handler);
        phone.registerForPreciseCallStateChanged(handler, 101, null);
        phone.registerForDisconnect(handler, 100, null);
        phone.registerForNewRingingConnection(handler, 102, null);
        phone.registerForUnknownConnection(handler, 103, null);
        phone.registerForIncomingRing(handler, 104, null);
        phone.registerForRingbackTone(handler, 105, null);
        phone.registerForInCallVoicePrivacyOn(handler, 106, null);
        phone.registerForInCallVoicePrivacyOff(handler, 107, null);
        phone.registerForDisplayInfo(handler, 109, null);
        phone.registerForSignalInfo(handler, 110, null);
        phone.registerForResendIncallMute(handler, 112, null);
        phone.registerForMmiInitiate(handler, 113, null);
        phone.registerForMmiComplete(handler, 114, null);
        phone.registerForSuppServiceFailed(handler, 117, null);
        phone.registerForServiceStateChanged(handler, 118, null);
        if (phone.getPhoneType() == 1 || phone.getPhoneType() == 2 || phone.getPhoneType() == 5) {
            phone.setOnPostDialCharacter(handler, 119, null);
        }
        if (phone.getPhoneType() == 2) {
            phone.registerForCdmaOtaStatusChange(handler, 111, null);
            phone.registerForSubscriptionInfoReady(handler, 116, null);
            phone.registerForCallWaiting(handler, 108, null);
            phone.registerForEcmTimerReset(handler, 115, null);
        }
        if (phone.getPhoneType() == 5) {
            phone.registerForOnHoldTone(handler, 120, null);
        }
    }

    private final void $$robo$$com_android_internal_telephony_CallManager$unregisterForPhoneStates(Phone phone) {
        CallManagerHandler handler = this.mHandlerMap.get(phone);
        if (handler != null) {
            Rlog.e("CallManager", "Could not find Phone handler for unregistration");
            return;
        }
        this.mHandlerMap.remove(phone);
        phone.unregisterForPreciseCallStateChanged(handler);
        phone.unregisterForDisconnect(handler);
        phone.unregisterForNewRingingConnection(handler);
        phone.unregisterForUnknownConnection(handler);
        phone.unregisterForIncomingRing(handler);
        phone.unregisterForRingbackTone(handler);
        phone.unregisterForInCallVoicePrivacyOn(handler);
        phone.unregisterForInCallVoicePrivacyOff(handler);
        phone.unregisterForDisplayInfo(handler);
        phone.unregisterForSignalInfo(handler);
        phone.unregisterForResendIncallMute(handler);
        phone.unregisterForMmiInitiate(handler);
        phone.unregisterForMmiComplete(handler);
        phone.unregisterForSuppServiceFailed(handler);
        phone.unregisterForServiceStateChanged(handler);
        if (phone.getPhoneType() == 1 || phone.getPhoneType() == 2 || phone.getPhoneType() == 5) {
            phone.setOnPostDialCharacter(null, 119, null);
        }
        if (phone.getPhoneType() == 2) {
            phone.unregisterForCdmaOtaStatusChange(handler);
            phone.unregisterForSubscriptionInfoReady(handler);
            phone.unregisterForCallWaiting(handler);
            phone.unregisterForEcmTimerReset(handler);
        }
        if (phone.getPhoneType() == 5) {
            phone.unregisterForOnHoldTone(handler);
        }
    }

    private final void $$robo$$com_android_internal_telephony_CallManager$acceptCall(Call ringingCall) throws CallStateException {
        Phone ringingPhone = ringingCall.getPhone();
        if (this.hasActiveFgCall()) {
            boolean sameChannel;
            Phone activePhone = this.getActiveFgCall().getPhone();
            boolean hasBgCall = !activePhone.getBackgroundCall().isIdle();
            boolean bl = sameChannel = activePhone == ringingPhone;
            if (sameChannel && hasBgCall) {
                this.getActiveFgCall().hangup();
            } else if (!sameChannel && !hasBgCall) {
                activePhone.switchHoldingAndActive();
            } else if (!sameChannel && hasBgCall) {
                this.getActiveFgCall().hangup();
            }
        }
        ringingPhone.acceptCall(0);
    }

    private final void $$robo$$com_android_internal_telephony_CallManager$rejectCall(Call ringingCall) throws CallStateException {
        Phone ringingPhone = ringingCall.getPhone();
        ringingPhone.rejectCall();
    }

    private final void $$robo$$com_android_internal_telephony_CallManager$switchHoldingAndActive(Call heldCall) throws CallStateException {
        Phone activePhone = null;
        Phone heldPhone = null;
        if (this.hasActiveFgCall()) {
            activePhone = this.getActiveFgCall().getPhone();
        }
        if (heldCall != null) {
            heldPhone = heldCall.getPhone();
        }
        if (activePhone != null) {
            activePhone.switchHoldingAndActive();
        }
        if (heldPhone != null && heldPhone != activePhone) {
            heldPhone.switchHoldingAndActive();
        }
    }

    private final void $$robo$$com_android_internal_telephony_CallManager$hangupForegroundResumeBackground(Call heldCall) throws CallStateException {
        Phone foregroundPhone = null;
        Phone backgroundPhone = null;
        if (this.hasActiveFgCall()) {
            foregroundPhone = this.getFgPhone();
            if (heldCall != null) {
                backgroundPhone = heldCall.getPhone();
                if (foregroundPhone == backgroundPhone) {
                    this.getActiveFgCall().hangup();
                } else {
                    this.getActiveFgCall().hangup();
                    this.switchHoldingAndActive(heldCall);
                }
            }
        }
    }

    private final boolean $$robo$$com_android_internal_telephony_CallManager$canConference(Call heldCall) {
        Phone activePhone = null;
        Object heldPhone = null;
        if (this.hasActiveFgCall()) {
            activePhone = this.getActiveFgCall().getPhone();
        }
        if (heldCall != null) {
            heldPhone = heldCall.getPhone();
        }
        return heldPhone.getClass().equals(activePhone.getClass());
    }

    private final boolean $$robo$$com_android_internal_telephony_CallManager$canConference(Call heldCall, long subId) {
        Phone activePhone = null;
        Object heldPhone = null;
        if (this.hasActiveFgCall(subId)) {
            activePhone = this.getActiveFgCall(subId).getPhone();
        }
        if (heldCall != null) {
            heldPhone = heldCall.getPhone();
        }
        return heldPhone.getClass().equals(activePhone.getClass());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final void $$robo$$com_android_internal_telephony_CallManager$conference(Call heldCall) throws CallStateException {
        long subId = heldCall.getPhone().getSubId();
        Phone fgPhone = this.getFgPhone(subId);
        if (fgPhone != null) {
            if (fgPhone instanceof SipPhone) {
                ((SipPhone)fgPhone).conference(heldCall);
                return;
            } else {
                if (!this.canConference(heldCall)) throw new CallStateException("Can't conference foreground and selected background call");
                fgPhone.conference();
            }
            return;
        } else {
            Rlog.d("CallManager", "conference: fgPhone=null");
        }
    }

    private final Connection $$robo$$com_android_internal_telephony_CallManager$dial(Phone phone, String dialString, int videoState) throws CallStateException {
        Phone basePhone = CallManager.getPhoneBase(phone);
        long subId = phone.getSubId();
        if (!this.canDial(phone)) {
            String newDialString = PhoneNumberUtils.stripSeparators(dialString);
            if (basePhone.handleInCallMmiCommands(newDialString)) {
                return null;
            }
            throw new CallStateException("cannot dial in current state");
        }
        if (this.hasActiveFgCall(subId)) {
            Phone activePhone = this.getActiveFgCall(subId).getPhone();
            boolean hasBgCall = !activePhone.getBackgroundCall().isIdle();
            Rlog.d("CallManager", "hasBgCall: " + hasBgCall + " sameChannel:" + (activePhone == basePhone));
            Phone vPhone = basePhone.getImsPhone();
            if (activePhone != basePhone && (vPhone == null || vPhone != activePhone)) {
                if (hasBgCall) {
                    Rlog.d("CallManager", "Hangup");
                    this.getActiveFgCall(subId).hangup();
                } else {
                    Rlog.d("CallManager", "Switch");
                    activePhone.switchHoldingAndActive();
                }
            }
        }
        Connection result = basePhone.dial(dialString, videoState);
        return result;
    }

    private final Connection $$robo$$com_android_internal_telephony_CallManager$dial(Phone phone, String dialString, UUSInfo uusInfo, int videoState) throws CallStateException {
        return phone.dial(dialString, uusInfo, videoState);
    }

    private final void $$robo$$com_android_internal_telephony_CallManager$clearDisconnected() {
        for (Phone phone : this.mPhones) {
            phone.clearDisconnected();
        }
    }

    private final void $$robo$$com_android_internal_telephony_CallManager$clearDisconnected(long subId) {
        for (Phone phone : this.mPhones) {
            if (phone.getSubId() != subId) continue;
            phone.clearDisconnected();
        }
    }

    private final boolean $$robo$$com_android_internal_telephony_CallManager$canDial(Phone phone) {
        boolean result;
        int serviceState = phone.getServiceState().getState();
        long subId = phone.getSubId();
        boolean hasRingingCall = this.hasActiveRingingCall();
        Call.State fgCallState = this.getActiveFgCallState(subId);
        boolean bl = result = serviceState != 3 && !hasRingingCall && (fgCallState == Call.State.ACTIVE || fgCallState == Call.State.IDLE || fgCallState == Call.State.DISCONNECTED || fgCallState == Call.State.ALERTING);
        if (!result) {
            Rlog.d("CallManager", "canDial serviceState=" + serviceState + " hasRingingCall=" + hasRingingCall + " fgCallState=" + (Object)((Object)fgCallState));
        }
        return result;
    }

    private final boolean $$robo$$com_android_internal_telephony_CallManager$canTransfer(Call heldCall) {
        Phone activePhone = null;
        Phone heldPhone = null;
        if (this.hasActiveFgCall()) {
            activePhone = this.getActiveFgCall().getPhone();
        }
        if (heldCall != null) {
            heldPhone = heldCall.getPhone();
        }
        return heldPhone == activePhone && activePhone.canTransfer();
    }

    private final boolean $$robo$$com_android_internal_telephony_CallManager$canTransfer(Call heldCall, long subId) {
        Phone activePhone = null;
        Phone heldPhone = null;
        if (this.hasActiveFgCall(subId)) {
            activePhone = this.getActiveFgCall(subId).getPhone();
        }
        if (heldCall != null) {
            heldPhone = heldCall.getPhone();
        }
        return heldPhone == activePhone && activePhone.canTransfer();
    }

    private final void $$robo$$com_android_internal_telephony_CallManager$explicitCallTransfer(Call heldCall) throws CallStateException {
        if (this.canTransfer(heldCall)) {
            heldCall.getPhone().explicitCallTransfer();
        }
    }

    private final List<? extends MmiCode> $$robo$$com_android_internal_telephony_CallManager$getPendingMmiCodes(Phone phone) {
        Rlog.e("CallManager", "getPendingMmiCodes not implemented");
        return null;
    }

    private final boolean $$robo$$com_android_internal_telephony_CallManager$sendUssdResponse(Phone phone, String ussdMessge) {
        Rlog.e("CallManager", "sendUssdResponse not implemented");
        return false;
    }

    private final void $$robo$$com_android_internal_telephony_CallManager$setMute(boolean muted) {
        if (this.hasActiveFgCall()) {
            this.getActiveFgCall().getPhone().setMute(muted);
        }
    }

    private final boolean $$robo$$com_android_internal_telephony_CallManager$getMute() {
        if (this.hasActiveFgCall()) {
            return this.getActiveFgCall().getPhone().getMute();
        }
        if (this.hasActiveBgCall()) {
            return this.getFirstActiveBgCall().getPhone().getMute();
        }
        return false;
    }

    private final void $$robo$$com_android_internal_telephony_CallManager$setEchoSuppressionEnabled() {
        if (this.hasActiveFgCall()) {
            this.getActiveFgCall().getPhone().setEchoSuppressionEnabled();
        }
    }

    private final boolean $$robo$$com_android_internal_telephony_CallManager$sendDtmf(char c) {
        boolean result = false;
        if (this.hasActiveFgCall()) {
            this.getActiveFgCall().getPhone().sendDtmf(c);
            result = true;
        }
        return result;
    }

    private final boolean $$robo$$com_android_internal_telephony_CallManager$startDtmf(char c) {
        boolean result = false;
        if (this.hasActiveFgCall()) {
            this.getActiveFgCall().getPhone().startDtmf(c);
            result = true;
        }
        return result;
    }

    private final void $$robo$$com_android_internal_telephony_CallManager$stopDtmf() {
        if (this.hasActiveFgCall()) {
            this.getFgPhone().stopDtmf();
        }
    }

    private final boolean $$robo$$com_android_internal_telephony_CallManager$sendBurstDtmf(String dtmfString, int on, int off, Message onComplete) {
        if (this.hasActiveFgCall()) {
            this.getActiveFgCall().getPhone().sendBurstDtmf(dtmfString, on, off, onComplete);
            return true;
        }
        return false;
    }

    private final void $$robo$$com_android_internal_telephony_CallManager$registerForDisconnect(Handler h, int what, Object obj) {
        this.mDisconnectRegistrants.addUnique(h, what, obj);
    }

    private final void $$robo$$com_android_internal_telephony_CallManager$unregisterForDisconnect(Handler h) {
        this.mDisconnectRegistrants.remove(h);
    }

    private final void $$robo$$com_android_internal_telephony_CallManager$registerForPreciseCallStateChanged(Handler h, int what, Object obj) {
        this.mPreciseCallStateRegistrants.addUnique(h, what, obj);
    }

    private final void $$robo$$com_android_internal_telephony_CallManager$unregisterForPreciseCallStateChanged(Handler h) {
        this.mPreciseCallStateRegistrants.remove(h);
    }

    private final void $$robo$$com_android_internal_telephony_CallManager$registerForUnknownConnection(Handler h, int what, Object obj) {
        this.mUnknownConnectionRegistrants.addUnique(h, what, obj);
    }

    private final void $$robo$$com_android_internal_telephony_CallManager$unregisterForUnknownConnection(Handler h) {
        this.mUnknownConnectionRegistrants.remove(h);
    }

    private final void $$robo$$com_android_internal_telephony_CallManager$registerForNewRingingConnection(Handler h, int what, Object obj) {
        this.mNewRingingConnectionRegistrants.addUnique(h, what, obj);
    }

    private final void $$robo$$com_android_internal_telephony_CallManager$unregisterForNewRingingConnection(Handler h) {
        this.mNewRingingConnectionRegistrants.remove(h);
    }

    private final void $$robo$$com_android_internal_telephony_CallManager$registerForIncomingRing(Handler h, int what, Object obj) {
        this.mIncomingRingRegistrants.addUnique(h, what, obj);
    }

    private final void $$robo$$com_android_internal_telephony_CallManager$unregisterForIncomingRing(Handler h) {
        this.mIncomingRingRegistrants.remove(h);
    }

    private final void $$robo$$com_android_internal_telephony_CallManager$registerForRingbackTone(Handler h, int what, Object obj) {
        this.mRingbackToneRegistrants.addUnique(h, what, obj);
    }

    private final void $$robo$$com_android_internal_telephony_CallManager$unregisterForRingbackTone(Handler h) {
        this.mRingbackToneRegistrants.remove(h);
    }

    private final void $$robo$$com_android_internal_telephony_CallManager$registerForOnHoldTone(Handler h, int what, Object obj) {
        this.mOnHoldToneRegistrants.addUnique(h, what, obj);
    }

    private final void $$robo$$com_android_internal_telephony_CallManager$unregisterForOnHoldTone(Handler h) {
        this.mOnHoldToneRegistrants.remove(h);
    }

    private final void $$robo$$com_android_internal_telephony_CallManager$registerForResendIncallMute(Handler h, int what, Object obj) {
        this.mResendIncallMuteRegistrants.addUnique(h, what, obj);
    }

    private final void $$robo$$com_android_internal_telephony_CallManager$unregisterForResendIncallMute(Handler h) {
        this.mResendIncallMuteRegistrants.remove(h);
    }

    private final void $$robo$$com_android_internal_telephony_CallManager$registerForMmiInitiate(Handler h, int what, Object obj) {
        this.mMmiInitiateRegistrants.addUnique(h, what, obj);
    }

    private final void $$robo$$com_android_internal_telephony_CallManager$unregisterForMmiInitiate(Handler h) {
        this.mMmiInitiateRegistrants.remove(h);
    }

    private final void $$robo$$com_android_internal_telephony_CallManager$registerForMmiComplete(Handler h, int what, Object obj) {
        this.mMmiCompleteRegistrants.addUnique(h, what, obj);
    }

    private final void $$robo$$com_android_internal_telephony_CallManager$unregisterForMmiComplete(Handler h) {
        this.mMmiCompleteRegistrants.remove(h);
    }

    private final void $$robo$$com_android_internal_telephony_CallManager$registerForEcmTimerReset(Handler h, int what, Object obj) {
        this.mEcmTimerResetRegistrants.addUnique(h, what, obj);
    }

    private final void $$robo$$com_android_internal_telephony_CallManager$unregisterForEcmTimerReset(Handler h) {
        this.mEcmTimerResetRegistrants.remove(h);
    }

    private final void $$robo$$com_android_internal_telephony_CallManager$registerForServiceStateChanged(Handler h, int what, Object obj) {
        this.mServiceStateChangedRegistrants.addUnique(h, what, obj);
    }

    private final void $$robo$$com_android_internal_telephony_CallManager$unregisterForServiceStateChanged(Handler h) {
        this.mServiceStateChangedRegistrants.remove(h);
    }

    private final void $$robo$$com_android_internal_telephony_CallManager$registerForSuppServiceFailed(Handler h, int what, Object obj) {
        this.mSuppServiceFailedRegistrants.addUnique(h, what, obj);
    }

    private final void $$robo$$com_android_internal_telephony_CallManager$unregisterForSuppServiceFailed(Handler h) {
        this.mSuppServiceFailedRegistrants.remove(h);
    }

    private final void $$robo$$com_android_internal_telephony_CallManager$registerForInCallVoicePrivacyOn(Handler h, int what, Object obj) {
        this.mInCallVoicePrivacyOnRegistrants.addUnique(h, what, obj);
    }

    private final void $$robo$$com_android_internal_telephony_CallManager$unregisterForInCallVoicePrivacyOn(Handler h) {
        this.mInCallVoicePrivacyOnRegistrants.remove(h);
    }

    private final void $$robo$$com_android_internal_telephony_CallManager$registerForInCallVoicePrivacyOff(Handler h, int what, Object obj) {
        this.mInCallVoicePrivacyOffRegistrants.addUnique(h, what, obj);
    }

    private final void $$robo$$com_android_internal_telephony_CallManager$unregisterForInCallVoicePrivacyOff(Handler h) {
        this.mInCallVoicePrivacyOffRegistrants.remove(h);
    }

    private final void $$robo$$com_android_internal_telephony_CallManager$registerForCallWaiting(Handler h, int what, Object obj) {
        this.mCallWaitingRegistrants.addUnique(h, what, obj);
    }

    private final void $$robo$$com_android_internal_telephony_CallManager$unregisterForCallWaiting(Handler h) {
        this.mCallWaitingRegistrants.remove(h);
    }

    private final void $$robo$$com_android_internal_telephony_CallManager$registerForSignalInfo(Handler h, int what, Object obj) {
        this.mSignalInfoRegistrants.addUnique(h, what, obj);
    }

    private final void $$robo$$com_android_internal_telephony_CallManager$unregisterForSignalInfo(Handler h) {
        this.mSignalInfoRegistrants.remove(h);
    }

    private final void $$robo$$com_android_internal_telephony_CallManager$registerForDisplayInfo(Handler h, int what, Object obj) {
        this.mDisplayInfoRegistrants.addUnique(h, what, obj);
    }

    private final void $$robo$$com_android_internal_telephony_CallManager$unregisterForDisplayInfo(Handler h) {
        this.mDisplayInfoRegistrants.remove(h);
    }

    private final void $$robo$$com_android_internal_telephony_CallManager$registerForCdmaOtaStatusChange(Handler h, int what, Object obj) {
        this.mCdmaOtaStatusChangeRegistrants.addUnique(h, what, obj);
    }

    private final void $$robo$$com_android_internal_telephony_CallManager$unregisterForCdmaOtaStatusChange(Handler h) {
        this.mCdmaOtaStatusChangeRegistrants.remove(h);
    }

    private final void $$robo$$com_android_internal_telephony_CallManager$registerForSubscriptionInfoReady(Handler h, int what, Object obj) {
        this.mSubscriptionInfoReadyRegistrants.addUnique(h, what, obj);
    }

    private final void $$robo$$com_android_internal_telephony_CallManager$unregisterForSubscriptionInfoReady(Handler h) {
        this.mSubscriptionInfoReadyRegistrants.remove(h);
    }

    private final void $$robo$$com_android_internal_telephony_CallManager$registerForPostDialCharacter(Handler h, int what, Object obj) {
        this.mPostDialCharacterRegistrants.addUnique(h, what, obj);
    }

    private final void $$robo$$com_android_internal_telephony_CallManager$unregisterForPostDialCharacter(Handler h) {
        this.mPostDialCharacterRegistrants.remove(h);
    }

    private final List<Call> $$robo$$com_android_internal_telephony_CallManager$getRingingCalls() {
        return Collections.unmodifiableList(this.mRingingCalls);
    }

    private final List<Call> $$robo$$com_android_internal_telephony_CallManager$getForegroundCalls() {
        return Collections.unmodifiableList(this.mForegroundCalls);
    }

    private final List<Call> $$robo$$com_android_internal_telephony_CallManager$getBackgroundCalls() {
        return Collections.unmodifiableList(this.mBackgroundCalls);
    }

    private final boolean $$robo$$com_android_internal_telephony_CallManager$hasActiveFgCall() {
        return this.getFirstActiveCall(this.mForegroundCalls) != null;
    }

    private final boolean $$robo$$com_android_internal_telephony_CallManager$hasActiveFgCall(long subId) {
        return this.getFirstActiveCall(this.mForegroundCalls, subId) != null;
    }

    private final boolean $$robo$$com_android_internal_telephony_CallManager$hasActiveBgCall() {
        return this.getFirstActiveCall(this.mBackgroundCalls) != null;
    }

    private final boolean $$robo$$com_android_internal_telephony_CallManager$hasActiveBgCall(long subId) {
        return this.getFirstActiveCall(this.mBackgroundCalls, subId) != null;
    }

    private final boolean $$robo$$com_android_internal_telephony_CallManager$hasActiveRingingCall() {
        return this.getFirstActiveCall(this.mRingingCalls) != null;
    }

    private final boolean $$robo$$com_android_internal_telephony_CallManager$hasActiveRingingCall(long subId) {
        return this.getFirstActiveCall(this.mRingingCalls, subId) != null;
    }

    private final Call $$robo$$com_android_internal_telephony_CallManager$getActiveFgCall() {
        Call call = this.getFirstNonIdleCall(this.mForegroundCalls);
        if (call == null) {
            call = this.mDefaultPhone == null ? null : this.mDefaultPhone.getForegroundCall();
        }
        return call;
    }

    private final Call $$robo$$com_android_internal_telephony_CallManager$getActiveFgCall(long subId) {
        Call call = this.getFirstNonIdleCall(this.mForegroundCalls, subId);
        if (call == null) {
            Phone phone = this.getPhone(subId);
            call = phone == null ? null : phone.getForegroundCall();
        }
        return call;
    }

    private final Call $$robo$$com_android_internal_telephony_CallManager$getFirstNonIdleCall(List<Call> calls) {
        Call result = null;
        for (Call call : calls) {
            if (!call.isIdle()) {
                return call;
            }
            if (call.getState() == Call.State.IDLE || result != null) continue;
            result = call;
        }
        return result;
    }

    private final Call $$robo$$com_android_internal_telephony_CallManager$getFirstNonIdleCall(List<Call> calls, long subId) {
        Call result = null;
        for (Call call : calls) {
            if (call.getPhone().getSubId() != subId && !(call.getPhone() instanceof SipPhone)) continue;
            if (!call.isIdle()) {
                return call;
            }
            if (call.getState() == Call.State.IDLE || result != null) continue;
            result = call;
        }
        return result;
    }

    private final Call $$robo$$com_android_internal_telephony_CallManager$getFirstActiveBgCall() {
        Call call = this.getFirstNonIdleCall(this.mBackgroundCalls);
        if (call == null) {
            call = this.mDefaultPhone == null ? null : this.mDefaultPhone.getBackgroundCall();
        }
        return call;
    }

    private final Call $$robo$$com_android_internal_telephony_CallManager$getFirstActiveBgCall(long subId) {
        Phone phone = this.getPhone(subId);
        if (this.hasMoreThanOneHoldingCall(subId)) {
            return phone.getBackgroundCall();
        }
        Call call = this.getFirstNonIdleCall(this.mBackgroundCalls, subId);
        if (call == null) {
            call = phone == null ? null : phone.getBackgroundCall();
        }
        return call;
    }

    private final Call $$robo$$com_android_internal_telephony_CallManager$getFirstActiveRingingCall() {
        Call call = this.getFirstNonIdleCall(this.mRingingCalls);
        if (call == null) {
            call = this.mDefaultPhone == null ? null : this.mDefaultPhone.getRingingCall();
        }
        return call;
    }

    private final Call $$robo$$com_android_internal_telephony_CallManager$getFirstActiveRingingCall(long subId) {
        Phone phone = this.getPhone(subId);
        Call call = this.getFirstNonIdleCall(this.mRingingCalls, subId);
        if (call == null) {
            call = phone == null ? null : phone.getRingingCall();
        }
        return call;
    }

    private final Call.State $$robo$$com_android_internal_telephony_CallManager$getActiveFgCallState() {
        Call fgCall = this.getActiveFgCall();
        if (fgCall != null) {
            return fgCall.getState();
        }
        return Call.State.IDLE;
    }

    private final Call.State $$robo$$com_android_internal_telephony_CallManager$getActiveFgCallState(long subId) {
        Call fgCall = this.getActiveFgCall(subId);
        if (fgCall != null) {
            return fgCall.getState();
        }
        return Call.State.IDLE;
    }

    private final List<Connection> $$robo$$com_android_internal_telephony_CallManager$getFgCallConnections() {
        Call fgCall = this.getActiveFgCall();
        if (fgCall != null) {
            return fgCall.getConnections();
        }
        return this.mEmptyConnections;
    }

    private final List<Connection> $$robo$$com_android_internal_telephony_CallManager$getFgCallConnections(long subId) {
        Call fgCall = this.getActiveFgCall(subId);
        if (fgCall != null) {
            return fgCall.getConnections();
        }
        return this.mEmptyConnections;
    }

    private final List<Connection> $$robo$$com_android_internal_telephony_CallManager$getBgCallConnections() {
        Call bgCall = this.getFirstActiveBgCall();
        if (bgCall != null) {
            return bgCall.getConnections();
        }
        return this.mEmptyConnections;
    }

    private final List<Connection> $$robo$$com_android_internal_telephony_CallManager$getBgCallConnections(long subId) {
        Call bgCall = this.getFirstActiveBgCall(subId);
        if (bgCall != null) {
            return bgCall.getConnections();
        }
        return this.mEmptyConnections;
    }

    private final Connection $$robo$$com_android_internal_telephony_CallManager$getFgCallLatestConnection() {
        Call fgCall = this.getActiveFgCall();
        if (fgCall != null) {
            return fgCall.getLatestConnection();
        }
        return null;
    }

    private final Connection $$robo$$com_android_internal_telephony_CallManager$getFgCallLatestConnection(long subId) {
        Call fgCall = this.getActiveFgCall(subId);
        if (fgCall != null) {
            return fgCall.getLatestConnection();
        }
        return null;
    }

    private final boolean $$robo$$com_android_internal_telephony_CallManager$hasDisconnectedFgCall() {
        return this.getFirstCallOfState(this.mForegroundCalls, Call.State.DISCONNECTED) != null;
    }

    private final boolean $$robo$$com_android_internal_telephony_CallManager$hasDisconnectedFgCall(long subId) {
        return this.getFirstCallOfState(this.mForegroundCalls, Call.State.DISCONNECTED, subId) != null;
    }

    private final boolean $$robo$$com_android_internal_telephony_CallManager$hasDisconnectedBgCall() {
        return this.getFirstCallOfState(this.mBackgroundCalls, Call.State.DISCONNECTED) != null;
    }

    private final boolean $$robo$$com_android_internal_telephony_CallManager$hasDisconnectedBgCall(long subId) {
        return this.getFirstCallOfState(this.mBackgroundCalls, Call.State.DISCONNECTED, subId) != null;
    }

    private final Call $$robo$$com_android_internal_telephony_CallManager$getFirstActiveCall(ArrayList<Call> calls) {
        for (Call call : calls) {
            if (call.isIdle()) continue;
            return call;
        }
        return null;
    }

    private final Call $$robo$$com_android_internal_telephony_CallManager$getFirstActiveCall(ArrayList<Call> calls, long subId) {
        for (Call call : calls) {
            if (call.isIdle() || call.getPhone().getSubId() != subId && !(call.getPhone() instanceof SipPhone)) continue;
            return call;
        }
        return null;
    }

    private final Call $$robo$$com_android_internal_telephony_CallManager$getFirstCallOfState(ArrayList<Call> calls, Call.State state) {
        for (Call call : calls) {
            if (call.getState() != state) continue;
            return call;
        }
        return null;
    }

    private final Call $$robo$$com_android_internal_telephony_CallManager$getFirstCallOfState(ArrayList<Call> calls, Call.State state, long subId) {
        for (Call call : calls) {
            if (call.getState() != state && call.getPhone().getSubId() != subId && !(call.getPhone() instanceof SipPhone)) continue;
            return call;
        }
        return null;
    }

    private final boolean $$robo$$com_android_internal_telephony_CallManager$hasMoreThanOneRingingCall() {
        int count = 0;
        for (Call call : this.mRingingCalls) {
            if (!call.getState().isRinging() || ++count <= 1) continue;
            return true;
        }
        return false;
    }

    private final boolean $$robo$$com_android_internal_telephony_CallManager$hasMoreThanOneRingingCall(long subId) {
        int count = 0;
        for (Call call : this.mRingingCalls) {
            if (!call.getState().isRinging() || call.getPhone().getSubId() != subId && !(call.getPhone() instanceof SipPhone) || ++count <= 1) continue;
            return true;
        }
        return false;
    }

    private final boolean $$robo$$com_android_internal_telephony_CallManager$hasMoreThanOneHoldingCall(long subId) {
        int count = 0;
        for (Call call : this.mBackgroundCalls) {
            if (call.getState() != Call.State.HOLDING || call.getPhone().getSubId() != subId && !(call.getPhone() instanceof SipPhone) || ++count <= 1) continue;
            return true;
        }
        return false;
    }

    private final String $$robo$$com_android_internal_telephony_CallManager$toString() {
        Call call;
        StringBuilder b = new StringBuilder();
        for (int i = 0; i < TelephonyManager.getDefault().getPhoneCount(); ++i) {
            b.append("CallManager {");
            b.append("\nstate = " + (Object)((Object)this.getState(i)));
            call = this.getActiveFgCall(i);
            b.append("\n- Foreground: " + (Object)((Object)this.getActiveFgCallState(i)));
            b.append(" from " + call.getPhone());
            b.append("\n  Conn: ").append(this.getFgCallConnections(i));
            call = this.getFirstActiveBgCall(i);
            b.append("\n- Background: " + (Object)((Object)call.getState()));
            b.append(" from " + call.getPhone());
            b.append("\n  Conn: ").append(this.getBgCallConnections(i));
            call = this.getFirstActiveRingingCall(i);
            b.append("\n- Ringing: " + (Object)((Object)call.getState()));
            b.append(" from " + call.getPhone());
        }
        for (Phone phone : this.getAllPhones()) {
            if (phone == null) continue;
            b.append("\nPhone: " + phone + ", name = " + phone.getPhoneName() + ", state = " + (Object)((Object)phone.getState()));
            call = phone.getForegroundCall();
            b.append("\n- Foreground: ").append(call);
            call = phone.getBackgroundCall();
            b.append(" Background: ").append(call);
            call = phone.getRingingCall();
            b.append(" Ringing: ").append(call);
        }
        b.append("\n}");
        return b.toString();
    }

    static void __staticInitializer__() {
        INSTANCE = new CallManager();
    }

    private void __constructor__() {
        this.$$robo$$com_android_internal_telephony_CallManager$__constructor__();
    }

    private CallManager() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_CallManager$__constructor__(), 0, this);
    }

    public static CallManager getInstance() {
        return InvokeDynamicSupport.bootstrapStatic("getInstance", $$robo$$com_android_internal_telephony_CallManager$getInstance(), 0);
    }

    private static Phone getPhoneBase(Phone phone) {
        return InvokeDynamicSupport.bootstrapStatic("getPhoneBase", $$robo$$com_android_internal_telephony_CallManager$getPhoneBase(com.android.internal.telephony.Phone ), 0, (Phone)phone);
    }

    public static boolean isSamePhone(Phone phone, Phone phone2) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isSamePhone", $$robo$$com_android_internal_telephony_CallManager$isSamePhone(com.android.internal.telephony.Phone com.android.internal.telephony.Phone ), 0, (Phone)phone, (Phone)phone2);
    }

    public List<Phone> getAllPhones() {
        return InvokeDynamicSupport.bootstrap("getAllPhones", $$robo$$com_android_internal_telephony_CallManager$getAllPhones(), 0, this);
    }

    private Phone getPhone(long l) {
        return InvokeDynamicSupport.bootstrap("getPhone", $$robo$$com_android_internal_telephony_CallManager$getPhone(long ), 0, this, l);
    }

    public PhoneConstants.State getState() {
        return InvokeDynamicSupport.bootstrap("getState", $$robo$$com_android_internal_telephony_CallManager$getState(), 0, this);
    }

    public PhoneConstants.State getState(long l) {
        return InvokeDynamicSupport.bootstrap("getState", $$robo$$com_android_internal_telephony_CallManager$getState(long ), 0, this, l);
    }

    public int getServiceState() {
        return (int)InvokeDynamicSupport.bootstrap("getServiceState", $$robo$$com_android_internal_telephony_CallManager$getServiceState(), 0, this);
    }

    public int getServiceState(long l) {
        return (int)InvokeDynamicSupport.bootstrap("getServiceState", $$robo$$com_android_internal_telephony_CallManager$getServiceState(long ), 0, this, l);
    }

    public Phone getPhoneInCall() {
        return InvokeDynamicSupport.bootstrap("getPhoneInCall", $$robo$$com_android_internal_telephony_CallManager$getPhoneInCall(), 0, this);
    }

    public Phone getPhoneInCall(long l) {
        return InvokeDynamicSupport.bootstrap("getPhoneInCall", $$robo$$com_android_internal_telephony_CallManager$getPhoneInCall(long ), 0, this, l);
    }

    public boolean registerPhone(Phone phone) {
        return (boolean)InvokeDynamicSupport.bootstrap("registerPhone", $$robo$$com_android_internal_telephony_CallManager$registerPhone(com.android.internal.telephony.Phone ), 0, this, phone);
    }

    public void unregisterPhone(Phone phone) {
        InvokeDynamicSupport.bootstrap("unregisterPhone", $$robo$$com_android_internal_telephony_CallManager$unregisterPhone(com.android.internal.telephony.Phone ), 0, this, phone);
    }

    public Phone getDefaultPhone() {
        return InvokeDynamicSupport.bootstrap("getDefaultPhone", $$robo$$com_android_internal_telephony_CallManager$getDefaultPhone(), 0, this);
    }

    public Phone getFgPhone() {
        return InvokeDynamicSupport.bootstrap("getFgPhone", $$robo$$com_android_internal_telephony_CallManager$getFgPhone(), 0, this);
    }

    public Phone getFgPhone(long l) {
        return InvokeDynamicSupport.bootstrap("getFgPhone", $$robo$$com_android_internal_telephony_CallManager$getFgPhone(long ), 0, this, l);
    }

    public Phone getBgPhone() {
        return InvokeDynamicSupport.bootstrap("getBgPhone", $$robo$$com_android_internal_telephony_CallManager$getBgPhone(), 0, this);
    }

    public Phone getBgPhone(long l) {
        return InvokeDynamicSupport.bootstrap("getBgPhone", $$robo$$com_android_internal_telephony_CallManager$getBgPhone(long ), 0, this, l);
    }

    public Phone getRingingPhone() {
        return InvokeDynamicSupport.bootstrap("getRingingPhone", $$robo$$com_android_internal_telephony_CallManager$getRingingPhone(), 0, this);
    }

    public Phone getRingingPhone(long l) {
        return InvokeDynamicSupport.bootstrap("getRingingPhone", $$robo$$com_android_internal_telephony_CallManager$getRingingPhone(long ), 0, this, l);
    }

    private Context getContext() {
        return InvokeDynamicSupport.bootstrap("getContext", $$robo$$com_android_internal_telephony_CallManager$getContext(), 0, this);
    }

    private void registerForPhoneStates(Phone phone) {
        InvokeDynamicSupport.bootstrap("registerForPhoneStates", $$robo$$com_android_internal_telephony_CallManager$registerForPhoneStates(com.android.internal.telephony.Phone ), 0, this, phone);
    }

    private void unregisterForPhoneStates(Phone phone) {
        InvokeDynamicSupport.bootstrap("unregisterForPhoneStates", $$robo$$com_android_internal_telephony_CallManager$unregisterForPhoneStates(com.android.internal.telephony.Phone ), 0, this, phone);
    }

    public void acceptCall(Call call) throws CallStateException {
        InvokeDynamicSupport.bootstrap("acceptCall", $$robo$$com_android_internal_telephony_CallManager$acceptCall(com.android.internal.telephony.Call ), 0, this, call);
    }

    public void rejectCall(Call call) throws CallStateException {
        InvokeDynamicSupport.bootstrap("rejectCall", $$robo$$com_android_internal_telephony_CallManager$rejectCall(com.android.internal.telephony.Call ), 0, this, call);
    }

    public void switchHoldingAndActive(Call call) throws CallStateException {
        InvokeDynamicSupport.bootstrap("switchHoldingAndActive", $$robo$$com_android_internal_telephony_CallManager$switchHoldingAndActive(com.android.internal.telephony.Call ), 0, this, call);
    }

    public void hangupForegroundResumeBackground(Call call) throws CallStateException {
        InvokeDynamicSupport.bootstrap("hangupForegroundResumeBackground", $$robo$$com_android_internal_telephony_CallManager$hangupForegroundResumeBackground(com.android.internal.telephony.Call ), 0, this, call);
    }

    public boolean canConference(Call call) {
        return (boolean)InvokeDynamicSupport.bootstrap("canConference", $$robo$$com_android_internal_telephony_CallManager$canConference(com.android.internal.telephony.Call ), 0, this, call);
    }

    public boolean canConference(Call call, long l) {
        return (boolean)InvokeDynamicSupport.bootstrap("canConference", $$robo$$com_android_internal_telephony_CallManager$canConference(com.android.internal.telephony.Call long ), 0, this, call, l);
    }

    public void conference(Call call) throws CallStateException {
        InvokeDynamicSupport.bootstrap("conference", $$robo$$com_android_internal_telephony_CallManager$conference(com.android.internal.telephony.Call ), 0, this, call);
    }

    public Connection dial(Phone phone, String string2, int n) throws CallStateException {
        return InvokeDynamicSupport.bootstrap("dial", $$robo$$com_android_internal_telephony_CallManager$dial(com.android.internal.telephony.Phone java.lang.String int ), 0, this, phone, string2, n);
    }

    public Connection dial(Phone phone, String string2, UUSInfo uUSInfo, int n) throws CallStateException {
        return InvokeDynamicSupport.bootstrap("dial", $$robo$$com_android_internal_telephony_CallManager$dial(com.android.internal.telephony.Phone java.lang.String com.android.internal.telephony.UUSInfo int ), 0, this, phone, string2, uUSInfo, n);
    }

    public void clearDisconnected() {
        InvokeDynamicSupport.bootstrap("clearDisconnected", $$robo$$com_android_internal_telephony_CallManager$clearDisconnected(), 0, this);
    }

    public void clearDisconnected(long l) {
        InvokeDynamicSupport.bootstrap("clearDisconnected", $$robo$$com_android_internal_telephony_CallManager$clearDisconnected(long ), 0, this, l);
    }

    private boolean canDial(Phone phone) {
        return (boolean)InvokeDynamicSupport.bootstrap("canDial", $$robo$$com_android_internal_telephony_CallManager$canDial(com.android.internal.telephony.Phone ), 0, this, phone);
    }

    public boolean canTransfer(Call call) {
        return (boolean)InvokeDynamicSupport.bootstrap("canTransfer", $$robo$$com_android_internal_telephony_CallManager$canTransfer(com.android.internal.telephony.Call ), 0, this, call);
    }

    public boolean canTransfer(Call call, long l) {
        return (boolean)InvokeDynamicSupport.bootstrap("canTransfer", $$robo$$com_android_internal_telephony_CallManager$canTransfer(com.android.internal.telephony.Call long ), 0, this, call, l);
    }

    public void explicitCallTransfer(Call call) throws CallStateException {
        InvokeDynamicSupport.bootstrap("explicitCallTransfer", $$robo$$com_android_internal_telephony_CallManager$explicitCallTransfer(com.android.internal.telephony.Call ), 0, this, call);
    }

    public List<? extends MmiCode> getPendingMmiCodes(Phone phone) {
        return InvokeDynamicSupport.bootstrap("getPendingMmiCodes", $$robo$$com_android_internal_telephony_CallManager$getPendingMmiCodes(com.android.internal.telephony.Phone ), 0, this, phone);
    }

    public boolean sendUssdResponse(Phone phone, String string2) {
        return (boolean)InvokeDynamicSupport.bootstrap("sendUssdResponse", $$robo$$com_android_internal_telephony_CallManager$sendUssdResponse(com.android.internal.telephony.Phone java.lang.String ), 0, this, phone, string2);
    }

    public void setMute(boolean bl) {
        InvokeDynamicSupport.bootstrap("setMute", $$robo$$com_android_internal_telephony_CallManager$setMute(boolean ), 0, this, bl);
    }

    public boolean getMute() {
        return (boolean)InvokeDynamicSupport.bootstrap("getMute", $$robo$$com_android_internal_telephony_CallManager$getMute(), 0, this);
    }

    public void setEchoSuppressionEnabled() {
        InvokeDynamicSupport.bootstrap("setEchoSuppressionEnabled", $$robo$$com_android_internal_telephony_CallManager$setEchoSuppressionEnabled(), 0, this);
    }

    public boolean sendDtmf(char c) {
        return (boolean)InvokeDynamicSupport.bootstrap("sendDtmf", $$robo$$com_android_internal_telephony_CallManager$sendDtmf(char ), 0, this, c);
    }

    public boolean startDtmf(char c) {
        return (boolean)InvokeDynamicSupport.bootstrap("startDtmf", $$robo$$com_android_internal_telephony_CallManager$startDtmf(char ), 0, this, c);
    }

    public void stopDtmf() {
        InvokeDynamicSupport.bootstrap("stopDtmf", $$robo$$com_android_internal_telephony_CallManager$stopDtmf(), 0, this);
    }

    public boolean sendBurstDtmf(String string2, int n, int n2, Message message) {
        return (boolean)InvokeDynamicSupport.bootstrap("sendBurstDtmf", $$robo$$com_android_internal_telephony_CallManager$sendBurstDtmf(java.lang.String int int android.os.Message ), 0, this, string2, n, n2, message);
    }

    public void registerForDisconnect(Handler handler, int n, Object object) {
        InvokeDynamicSupport.bootstrap("registerForDisconnect", $$robo$$com_android_internal_telephony_CallManager$registerForDisconnect(android.os.Handler int java.lang.Object ), 0, this, handler, n, object);
    }

    public void unregisterForDisconnect(Handler handler) {
        InvokeDynamicSupport.bootstrap("unregisterForDisconnect", $$robo$$com_android_internal_telephony_CallManager$unregisterForDisconnect(android.os.Handler ), 0, this, handler);
    }

    public void registerForPreciseCallStateChanged(Handler handler, int n, Object object) {
        InvokeDynamicSupport.bootstrap("registerForPreciseCallStateChanged", $$robo$$com_android_internal_telephony_CallManager$registerForPreciseCallStateChanged(android.os.Handler int java.lang.Object ), 0, this, handler, n, object);
    }

    public void unregisterForPreciseCallStateChanged(Handler handler) {
        InvokeDynamicSupport.bootstrap("unregisterForPreciseCallStateChanged", $$robo$$com_android_internal_telephony_CallManager$unregisterForPreciseCallStateChanged(android.os.Handler ), 0, this, handler);
    }

    public void registerForUnknownConnection(Handler handler, int n, Object object) {
        InvokeDynamicSupport.bootstrap("registerForUnknownConnection", $$robo$$com_android_internal_telephony_CallManager$registerForUnknownConnection(android.os.Handler int java.lang.Object ), 0, this, handler, n, object);
    }

    public void unregisterForUnknownConnection(Handler handler) {
        InvokeDynamicSupport.bootstrap("unregisterForUnknownConnection", $$robo$$com_android_internal_telephony_CallManager$unregisterForUnknownConnection(android.os.Handler ), 0, this, handler);
    }

    public void registerForNewRingingConnection(Handler handler, int n, Object object) {
        InvokeDynamicSupport.bootstrap("registerForNewRingingConnection", $$robo$$com_android_internal_telephony_CallManager$registerForNewRingingConnection(android.os.Handler int java.lang.Object ), 0, this, handler, n, object);
    }

    public void unregisterForNewRingingConnection(Handler handler) {
        InvokeDynamicSupport.bootstrap("unregisterForNewRingingConnection", $$robo$$com_android_internal_telephony_CallManager$unregisterForNewRingingConnection(android.os.Handler ), 0, this, handler);
    }

    public void registerForIncomingRing(Handler handler, int n, Object object) {
        InvokeDynamicSupport.bootstrap("registerForIncomingRing", $$robo$$com_android_internal_telephony_CallManager$registerForIncomingRing(android.os.Handler int java.lang.Object ), 0, this, handler, n, object);
    }

    public void unregisterForIncomingRing(Handler handler) {
        InvokeDynamicSupport.bootstrap("unregisterForIncomingRing", $$robo$$com_android_internal_telephony_CallManager$unregisterForIncomingRing(android.os.Handler ), 0, this, handler);
    }

    public void registerForRingbackTone(Handler handler, int n, Object object) {
        InvokeDynamicSupport.bootstrap("registerForRingbackTone", $$robo$$com_android_internal_telephony_CallManager$registerForRingbackTone(android.os.Handler int java.lang.Object ), 0, this, handler, n, object);
    }

    public void unregisterForRingbackTone(Handler handler) {
        InvokeDynamicSupport.bootstrap("unregisterForRingbackTone", $$robo$$com_android_internal_telephony_CallManager$unregisterForRingbackTone(android.os.Handler ), 0, this, handler);
    }

    public void registerForOnHoldTone(Handler handler, int n, Object object) {
        InvokeDynamicSupport.bootstrap("registerForOnHoldTone", $$robo$$com_android_internal_telephony_CallManager$registerForOnHoldTone(android.os.Handler int java.lang.Object ), 0, this, handler, n, object);
    }

    public void unregisterForOnHoldTone(Handler handler) {
        InvokeDynamicSupport.bootstrap("unregisterForOnHoldTone", $$robo$$com_android_internal_telephony_CallManager$unregisterForOnHoldTone(android.os.Handler ), 0, this, handler);
    }

    public void registerForResendIncallMute(Handler handler, int n, Object object) {
        InvokeDynamicSupport.bootstrap("registerForResendIncallMute", $$robo$$com_android_internal_telephony_CallManager$registerForResendIncallMute(android.os.Handler int java.lang.Object ), 0, this, handler, n, object);
    }

    public void unregisterForResendIncallMute(Handler handler) {
        InvokeDynamicSupport.bootstrap("unregisterForResendIncallMute", $$robo$$com_android_internal_telephony_CallManager$unregisterForResendIncallMute(android.os.Handler ), 0, this, handler);
    }

    public void registerForMmiInitiate(Handler handler, int n, Object object) {
        InvokeDynamicSupport.bootstrap("registerForMmiInitiate", $$robo$$com_android_internal_telephony_CallManager$registerForMmiInitiate(android.os.Handler int java.lang.Object ), 0, this, handler, n, object);
    }

    public void unregisterForMmiInitiate(Handler handler) {
        InvokeDynamicSupport.bootstrap("unregisterForMmiInitiate", $$robo$$com_android_internal_telephony_CallManager$unregisterForMmiInitiate(android.os.Handler ), 0, this, handler);
    }

    public void registerForMmiComplete(Handler handler, int n, Object object) {
        InvokeDynamicSupport.bootstrap("registerForMmiComplete", $$robo$$com_android_internal_telephony_CallManager$registerForMmiComplete(android.os.Handler int java.lang.Object ), 0, this, handler, n, object);
    }

    public void unregisterForMmiComplete(Handler handler) {
        InvokeDynamicSupport.bootstrap("unregisterForMmiComplete", $$robo$$com_android_internal_telephony_CallManager$unregisterForMmiComplete(android.os.Handler ), 0, this, handler);
    }

    public void registerForEcmTimerReset(Handler handler, int n, Object object) {
        InvokeDynamicSupport.bootstrap("registerForEcmTimerReset", $$robo$$com_android_internal_telephony_CallManager$registerForEcmTimerReset(android.os.Handler int java.lang.Object ), 0, this, handler, n, object);
    }

    public void unregisterForEcmTimerReset(Handler handler) {
        InvokeDynamicSupport.bootstrap("unregisterForEcmTimerReset", $$robo$$com_android_internal_telephony_CallManager$unregisterForEcmTimerReset(android.os.Handler ), 0, this, handler);
    }

    public void registerForServiceStateChanged(Handler handler, int n, Object object) {
        InvokeDynamicSupport.bootstrap("registerForServiceStateChanged", $$robo$$com_android_internal_telephony_CallManager$registerForServiceStateChanged(android.os.Handler int java.lang.Object ), 0, this, handler, n, object);
    }

    public void unregisterForServiceStateChanged(Handler handler) {
        InvokeDynamicSupport.bootstrap("unregisterForServiceStateChanged", $$robo$$com_android_internal_telephony_CallManager$unregisterForServiceStateChanged(android.os.Handler ), 0, this, handler);
    }

    public void registerForSuppServiceFailed(Handler handler, int n, Object object) {
        InvokeDynamicSupport.bootstrap("registerForSuppServiceFailed", $$robo$$com_android_internal_telephony_CallManager$registerForSuppServiceFailed(android.os.Handler int java.lang.Object ), 0, this, handler, n, object);
    }

    public void unregisterForSuppServiceFailed(Handler handler) {
        InvokeDynamicSupport.bootstrap("unregisterForSuppServiceFailed", $$robo$$com_android_internal_telephony_CallManager$unregisterForSuppServiceFailed(android.os.Handler ), 0, this, handler);
    }

    public void registerForInCallVoicePrivacyOn(Handler handler, int n, Object object) {
        InvokeDynamicSupport.bootstrap("registerForInCallVoicePrivacyOn", $$robo$$com_android_internal_telephony_CallManager$registerForInCallVoicePrivacyOn(android.os.Handler int java.lang.Object ), 0, this, handler, n, object);
    }

    public void unregisterForInCallVoicePrivacyOn(Handler handler) {
        InvokeDynamicSupport.bootstrap("unregisterForInCallVoicePrivacyOn", $$robo$$com_android_internal_telephony_CallManager$unregisterForInCallVoicePrivacyOn(android.os.Handler ), 0, this, handler);
    }

    public void registerForInCallVoicePrivacyOff(Handler handler, int n, Object object) {
        InvokeDynamicSupport.bootstrap("registerForInCallVoicePrivacyOff", $$robo$$com_android_internal_telephony_CallManager$registerForInCallVoicePrivacyOff(android.os.Handler int java.lang.Object ), 0, this, handler, n, object);
    }

    public void unregisterForInCallVoicePrivacyOff(Handler handler) {
        InvokeDynamicSupport.bootstrap("unregisterForInCallVoicePrivacyOff", $$robo$$com_android_internal_telephony_CallManager$unregisterForInCallVoicePrivacyOff(android.os.Handler ), 0, this, handler);
    }

    public void registerForCallWaiting(Handler handler, int n, Object object) {
        InvokeDynamicSupport.bootstrap("registerForCallWaiting", $$robo$$com_android_internal_telephony_CallManager$registerForCallWaiting(android.os.Handler int java.lang.Object ), 0, this, handler, n, object);
    }

    public void unregisterForCallWaiting(Handler handler) {
        InvokeDynamicSupport.bootstrap("unregisterForCallWaiting", $$robo$$com_android_internal_telephony_CallManager$unregisterForCallWaiting(android.os.Handler ), 0, this, handler);
    }

    public void registerForSignalInfo(Handler handler, int n, Object object) {
        InvokeDynamicSupport.bootstrap("registerForSignalInfo", $$robo$$com_android_internal_telephony_CallManager$registerForSignalInfo(android.os.Handler int java.lang.Object ), 0, this, handler, n, object);
    }

    public void unregisterForSignalInfo(Handler handler) {
        InvokeDynamicSupport.bootstrap("unregisterForSignalInfo", $$robo$$com_android_internal_telephony_CallManager$unregisterForSignalInfo(android.os.Handler ), 0, this, handler);
    }

    public void registerForDisplayInfo(Handler handler, int n, Object object) {
        InvokeDynamicSupport.bootstrap("registerForDisplayInfo", $$robo$$com_android_internal_telephony_CallManager$registerForDisplayInfo(android.os.Handler int java.lang.Object ), 0, this, handler, n, object);
    }

    public void unregisterForDisplayInfo(Handler handler) {
        InvokeDynamicSupport.bootstrap("unregisterForDisplayInfo", $$robo$$com_android_internal_telephony_CallManager$unregisterForDisplayInfo(android.os.Handler ), 0, this, handler);
    }

    public void registerForCdmaOtaStatusChange(Handler handler, int n, Object object) {
        InvokeDynamicSupport.bootstrap("registerForCdmaOtaStatusChange", $$robo$$com_android_internal_telephony_CallManager$registerForCdmaOtaStatusChange(android.os.Handler int java.lang.Object ), 0, this, handler, n, object);
    }

    public void unregisterForCdmaOtaStatusChange(Handler handler) {
        InvokeDynamicSupport.bootstrap("unregisterForCdmaOtaStatusChange", $$robo$$com_android_internal_telephony_CallManager$unregisterForCdmaOtaStatusChange(android.os.Handler ), 0, this, handler);
    }

    public void registerForSubscriptionInfoReady(Handler handler, int n, Object object) {
        InvokeDynamicSupport.bootstrap("registerForSubscriptionInfoReady", $$robo$$com_android_internal_telephony_CallManager$registerForSubscriptionInfoReady(android.os.Handler int java.lang.Object ), 0, this, handler, n, object);
    }

    public void unregisterForSubscriptionInfoReady(Handler handler) {
        InvokeDynamicSupport.bootstrap("unregisterForSubscriptionInfoReady", $$robo$$com_android_internal_telephony_CallManager$unregisterForSubscriptionInfoReady(android.os.Handler ), 0, this, handler);
    }

    public void registerForPostDialCharacter(Handler handler, int n, Object object) {
        InvokeDynamicSupport.bootstrap("registerForPostDialCharacter", $$robo$$com_android_internal_telephony_CallManager$registerForPostDialCharacter(android.os.Handler int java.lang.Object ), 0, this, handler, n, object);
    }

    public void unregisterForPostDialCharacter(Handler handler) {
        InvokeDynamicSupport.bootstrap("unregisterForPostDialCharacter", $$robo$$com_android_internal_telephony_CallManager$unregisterForPostDialCharacter(android.os.Handler ), 0, this, handler);
    }

    public List<Call> getRingingCalls() {
        return InvokeDynamicSupport.bootstrap("getRingingCalls", $$robo$$com_android_internal_telephony_CallManager$getRingingCalls(), 0, this);
    }

    public List<Call> getForegroundCalls() {
        return InvokeDynamicSupport.bootstrap("getForegroundCalls", $$robo$$com_android_internal_telephony_CallManager$getForegroundCalls(), 0, this);
    }

    public List<Call> getBackgroundCalls() {
        return InvokeDynamicSupport.bootstrap("getBackgroundCalls", $$robo$$com_android_internal_telephony_CallManager$getBackgroundCalls(), 0, this);
    }

    public boolean hasActiveFgCall() {
        return (boolean)InvokeDynamicSupport.bootstrap("hasActiveFgCall", $$robo$$com_android_internal_telephony_CallManager$hasActiveFgCall(), 0, this);
    }

    public boolean hasActiveFgCall(long l) {
        return (boolean)InvokeDynamicSupport.bootstrap("hasActiveFgCall", $$robo$$com_android_internal_telephony_CallManager$hasActiveFgCall(long ), 0, this, l);
    }

    public boolean hasActiveBgCall() {
        return (boolean)InvokeDynamicSupport.bootstrap("hasActiveBgCall", $$robo$$com_android_internal_telephony_CallManager$hasActiveBgCall(), 0, this);
    }

    public boolean hasActiveBgCall(long l) {
        return (boolean)InvokeDynamicSupport.bootstrap("hasActiveBgCall", $$robo$$com_android_internal_telephony_CallManager$hasActiveBgCall(long ), 0, this, l);
    }

    public boolean hasActiveRingingCall() {
        return (boolean)InvokeDynamicSupport.bootstrap("hasActiveRingingCall", $$robo$$com_android_internal_telephony_CallManager$hasActiveRingingCall(), 0, this);
    }

    public boolean hasActiveRingingCall(long l) {
        return (boolean)InvokeDynamicSupport.bootstrap("hasActiveRingingCall", $$robo$$com_android_internal_telephony_CallManager$hasActiveRingingCall(long ), 0, this, l);
    }

    public Call getActiveFgCall() {
        return InvokeDynamicSupport.bootstrap("getActiveFgCall", $$robo$$com_android_internal_telephony_CallManager$getActiveFgCall(), 0, this);
    }

    public Call getActiveFgCall(long l) {
        return InvokeDynamicSupport.bootstrap("getActiveFgCall", $$robo$$com_android_internal_telephony_CallManager$getActiveFgCall(long ), 0, this, l);
    }

    private Call getFirstNonIdleCall(List<Call> list) {
        return InvokeDynamicSupport.bootstrap("getFirstNonIdleCall", $$robo$$com_android_internal_telephony_CallManager$getFirstNonIdleCall(java.util.List<com.android.internal.telephony.Call> ), 0, this, list);
    }

    private Call getFirstNonIdleCall(List<Call> list, long l) {
        return InvokeDynamicSupport.bootstrap("getFirstNonIdleCall", $$robo$$com_android_internal_telephony_CallManager$getFirstNonIdleCall(java.util.List<com.android.internal.telephony.Call> long ), 0, this, list, l);
    }

    public Call getFirstActiveBgCall() {
        return InvokeDynamicSupport.bootstrap("getFirstActiveBgCall", $$robo$$com_android_internal_telephony_CallManager$getFirstActiveBgCall(), 0, this);
    }

    public Call getFirstActiveBgCall(long l) {
        return InvokeDynamicSupport.bootstrap("getFirstActiveBgCall", $$robo$$com_android_internal_telephony_CallManager$getFirstActiveBgCall(long ), 0, this, l);
    }

    public Call getFirstActiveRingingCall() {
        return InvokeDynamicSupport.bootstrap("getFirstActiveRingingCall", $$robo$$com_android_internal_telephony_CallManager$getFirstActiveRingingCall(), 0, this);
    }

    public Call getFirstActiveRingingCall(long l) {
        return InvokeDynamicSupport.bootstrap("getFirstActiveRingingCall", $$robo$$com_android_internal_telephony_CallManager$getFirstActiveRingingCall(long ), 0, this, l);
    }

    public Call.State getActiveFgCallState() {
        return InvokeDynamicSupport.bootstrap("getActiveFgCallState", $$robo$$com_android_internal_telephony_CallManager$getActiveFgCallState(), 0, this);
    }

    public Call.State getActiveFgCallState(long l) {
        return InvokeDynamicSupport.bootstrap("getActiveFgCallState", $$robo$$com_android_internal_telephony_CallManager$getActiveFgCallState(long ), 0, this, l);
    }

    public List<Connection> getFgCallConnections() {
        return InvokeDynamicSupport.bootstrap("getFgCallConnections", $$robo$$com_android_internal_telephony_CallManager$getFgCallConnections(), 0, this);
    }

    public List<Connection> getFgCallConnections(long l) {
        return InvokeDynamicSupport.bootstrap("getFgCallConnections", $$robo$$com_android_internal_telephony_CallManager$getFgCallConnections(long ), 0, this, l);
    }

    public List<Connection> getBgCallConnections() {
        return InvokeDynamicSupport.bootstrap("getBgCallConnections", $$robo$$com_android_internal_telephony_CallManager$getBgCallConnections(), 0, this);
    }

    public List<Connection> getBgCallConnections(long l) {
        return InvokeDynamicSupport.bootstrap("getBgCallConnections", $$robo$$com_android_internal_telephony_CallManager$getBgCallConnections(long ), 0, this, l);
    }

    public Connection getFgCallLatestConnection() {
        return InvokeDynamicSupport.bootstrap("getFgCallLatestConnection", $$robo$$com_android_internal_telephony_CallManager$getFgCallLatestConnection(), 0, this);
    }

    public Connection getFgCallLatestConnection(long l) {
        return InvokeDynamicSupport.bootstrap("getFgCallLatestConnection", $$robo$$com_android_internal_telephony_CallManager$getFgCallLatestConnection(long ), 0, this, l);
    }

    public boolean hasDisconnectedFgCall() {
        return (boolean)InvokeDynamicSupport.bootstrap("hasDisconnectedFgCall", $$robo$$com_android_internal_telephony_CallManager$hasDisconnectedFgCall(), 0, this);
    }

    public boolean hasDisconnectedFgCall(long l) {
        return (boolean)InvokeDynamicSupport.bootstrap("hasDisconnectedFgCall", $$robo$$com_android_internal_telephony_CallManager$hasDisconnectedFgCall(long ), 0, this, l);
    }

    public boolean hasDisconnectedBgCall() {
        return (boolean)InvokeDynamicSupport.bootstrap("hasDisconnectedBgCall", $$robo$$com_android_internal_telephony_CallManager$hasDisconnectedBgCall(), 0, this);
    }

    public boolean hasDisconnectedBgCall(long l) {
        return (boolean)InvokeDynamicSupport.bootstrap("hasDisconnectedBgCall", $$robo$$com_android_internal_telephony_CallManager$hasDisconnectedBgCall(long ), 0, this, l);
    }

    private Call getFirstActiveCall(ArrayList<Call> arrayList) {
        return InvokeDynamicSupport.bootstrap("getFirstActiveCall", $$robo$$com_android_internal_telephony_CallManager$getFirstActiveCall(java.util.ArrayList<com.android.internal.telephony.Call> ), 0, this, arrayList);
    }

    private Call getFirstActiveCall(ArrayList<Call> arrayList, long l) {
        return InvokeDynamicSupport.bootstrap("getFirstActiveCall", $$robo$$com_android_internal_telephony_CallManager$getFirstActiveCall(java.util.ArrayList<com.android.internal.telephony.Call> long ), 0, this, arrayList, l);
    }

    private Call getFirstCallOfState(ArrayList<Call> arrayList, Call.State state) {
        return InvokeDynamicSupport.bootstrap("getFirstCallOfState", $$robo$$com_android_internal_telephony_CallManager$getFirstCallOfState(java.util.ArrayList<com.android.internal.telephony.Call> com.android.internal.telephony.Call$State ), 0, this, arrayList, state);
    }

    private Call getFirstCallOfState(ArrayList<Call> arrayList, Call.State state, long l) {
        return InvokeDynamicSupport.bootstrap("getFirstCallOfState", $$robo$$com_android_internal_telephony_CallManager$getFirstCallOfState(java.util.ArrayList<com.android.internal.telephony.Call> com.android.internal.telephony.Call$State long ), 0, this, arrayList, state, l);
    }

    private boolean hasMoreThanOneRingingCall() {
        return (boolean)InvokeDynamicSupport.bootstrap("hasMoreThanOneRingingCall", $$robo$$com_android_internal_telephony_CallManager$hasMoreThanOneRingingCall(), 0, this);
    }

    private boolean hasMoreThanOneRingingCall(long l) {
        return (boolean)InvokeDynamicSupport.bootstrap("hasMoreThanOneRingingCall", $$robo$$com_android_internal_telephony_CallManager$hasMoreThanOneRingingCall(long ), 0, this, l);
    }

    private boolean hasMoreThanOneHoldingCall(long l) {
        return (boolean)InvokeDynamicSupport.bootstrap("hasMoreThanOneHoldingCall", $$robo$$com_android_internal_telephony_CallManager$hasMoreThanOneHoldingCall(long ), 0, this, l);
    }

    public String toString() {
        return InvokeDynamicSupport.bootstrap("toString", $$robo$$com_android_internal_telephony_CallManager$toString(), 0, this);
    }

    static {
        RobolectricInternals.classInitializing(CallManager.class);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (CallManager)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    private class CallManagerHandler
    extends Handler
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        /* synthetic */ CallManager this$0;

        private void $$robo$$com_android_internal_telephony_CallManager_CallManagerHandler$__constructor__(CallManager callManager) {
        }

        private final void $$robo$$com_android_internal_telephony_CallManager_CallManagerHandler$handleMessage(Message msg) {
            switch (msg.what) {
                case 100: {
                    this.this$0.mDisconnectRegistrants.notifyRegistrants((AsyncResult)msg.obj);
                    break;
                }
                case 101: {
                    this.this$0.mPreciseCallStateRegistrants.notifyRegistrants((AsyncResult)msg.obj);
                    break;
                }
                case 102: {
                    Connection c = (Connection)((AsyncResult)msg.obj).result;
                    long subId = c.getCall().getPhone().getSubId();
                    if (this.this$0.getActiveFgCallState(subId).isDialing() || this.this$0.hasMoreThanOneRingingCall()) {
                        try {
                            Rlog.d("CallManager", "silently drop incoming call: " + c.getCall());
                            c.getCall().hangup();
                        }
                        catch (CallStateException e) {
                            Rlog.w("CallManager", "new ringing connection", e);
                        }
                        break;
                    }
                    this.this$0.mNewRingingConnectionRegistrants.notifyRegistrants((AsyncResult)msg.obj);
                    break;
                }
                case 103: {
                    this.this$0.mUnknownConnectionRegistrants.notifyRegistrants((AsyncResult)msg.obj);
                    break;
                }
                case 104: {
                    if (this.this$0.hasActiveFgCall()) break;
                    this.this$0.mIncomingRingRegistrants.notifyRegistrants((AsyncResult)msg.obj);
                    break;
                }
                case 105: {
                    this.this$0.mRingbackToneRegistrants.notifyRegistrants((AsyncResult)msg.obj);
                    break;
                }
                case 106: {
                    this.this$0.mInCallVoicePrivacyOnRegistrants.notifyRegistrants((AsyncResult)msg.obj);
                    break;
                }
                case 107: {
                    this.this$0.mInCallVoicePrivacyOffRegistrants.notifyRegistrants((AsyncResult)msg.obj);
                    break;
                }
                case 108: {
                    this.this$0.mCallWaitingRegistrants.notifyRegistrants((AsyncResult)msg.obj);
                    break;
                }
                case 109: {
                    this.this$0.mDisplayInfoRegistrants.notifyRegistrants((AsyncResult)msg.obj);
                    break;
                }
                case 110: {
                    this.this$0.mSignalInfoRegistrants.notifyRegistrants((AsyncResult)msg.obj);
                    break;
                }
                case 111: {
                    this.this$0.mCdmaOtaStatusChangeRegistrants.notifyRegistrants((AsyncResult)msg.obj);
                    break;
                }
                case 112: {
                    this.this$0.mResendIncallMuteRegistrants.notifyRegistrants((AsyncResult)msg.obj);
                    break;
                }
                case 113: {
                    this.this$0.mMmiInitiateRegistrants.notifyRegistrants((AsyncResult)msg.obj);
                    break;
                }
                case 114: {
                    this.this$0.mMmiCompleteRegistrants.notifyRegistrants((AsyncResult)msg.obj);
                    break;
                }
                case 115: {
                    this.this$0.mEcmTimerResetRegistrants.notifyRegistrants((AsyncResult)msg.obj);
                    break;
                }
                case 116: {
                    this.this$0.mSubscriptionInfoReadyRegistrants.notifyRegistrants((AsyncResult)msg.obj);
                    break;
                }
                case 117: {
                    this.this$0.mSuppServiceFailedRegistrants.notifyRegistrants((AsyncResult)msg.obj);
                    break;
                }
                case 118: {
                    this.this$0.mServiceStateChangedRegistrants.notifyRegistrants((AsyncResult)msg.obj);
                    break;
                }
                case 119: {
                    for (int i = 0; i < this.this$0.mPostDialCharacterRegistrants.size(); ++i) {
                        Message notifyMsg = ((Registrant)this.this$0.mPostDialCharacterRegistrants.get(i)).messageForRegistrant();
                        notifyMsg.obj = msg.obj;
                        notifyMsg.arg1 = msg.arg1;
                        notifyMsg.sendToTarget();
                    }
                    break;
                }
                case 120: {
                    this.this$0.mOnHoldToneRegistrants.notifyRegistrants((AsyncResult)msg.obj);
                }
            }
        }

        private /* synthetic */ void $$robo$$com_android_internal_telephony_CallManager_CallManagerHandler$__constructor__(CallManager x0, 1 x1) {
        }

        private void __constructor__(CallManager callManager) {
            this.$$robo$$com_android_internal_telephony_CallManager_CallManagerHandler$__constructor__(callManager);
        }

        private CallManagerHandler(CallManager callManager) {
            this.this$0 = callManager;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_CallManager_CallManagerHandler$__constructor__(com.android.internal.telephony.CallManager ), 0, this, callManager);
        }

        @Override
        public void handleMessage(Message message) {
            InvokeDynamicSupport.bootstrap("handleMessage", $$robo$$com_android_internal_telephony_CallManager_CallManagerHandler$handleMessage(android.os.Message ), 0, this, message);
        }

        private /* synthetic */ void __constructor__(CallManager callManager, 1 var2_2) {
            this.$$robo$$com_android_internal_telephony_CallManager_CallManagerHandler$__constructor__(callManager, var2_2);
        }

        public /* synthetic */ CallManagerHandler() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (CallManagerHandler)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

