/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.os.SystemClock;
import android.telecom.Connection;
import android.telephony.Rlog;
import com.android.internal.telephony.Call;
import com.android.internal.telephony.CallStateException;
import com.android.internal.telephony.UUSInfo;
import com.google.errorprone.annotations.DoNotMock;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.robolectric.internal.bytecode.InstrumentedInterface;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public abstract class Connection
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    public static int AUDIO_QUALITY_STANDARD = 1;
    public static int AUDIO_QUALITY_HIGH_DEFINITION = 2;
    protected String mCnapName;
    protected int mCnapNamePresentation;
    protected String mAddress;
    protected String mDialString;
    protected int mNumberPresentation;
    protected boolean mIsIncoming;
    protected long mCreateTime;
    protected long mConnectTime;
    protected long mConnectTimeReal;
    protected long mDuration;
    protected long mHoldingStartTime;
    protected Connection mOrigConnection;
    private List<PostDialListener> mPostDialListeners;
    public Set<Listener> mListeners;
    protected boolean mNumberConverted;
    protected String mConvertedNumber;
    private static String LOG_TAG;
    Object mUserData;
    private int mVideoState;
    private boolean mLocalVideoCapable;
    private boolean mRemoteVideoCapable;
    private int mAudioQuality;
    private Connection.VideoProvider mVideoProvider;

    private void $$robo$$com_android_internal_telephony_Connection$__constructor__() {
        this.mCnapNamePresentation = 1;
        this.mNumberPresentation = 1;
        this.mPostDialListeners = new ArrayList<PostDialListener>();
        this.mListeners = new CopyOnWriteArraySet<Listener>();
        this.mNumberConverted = false;
    }

    private final String $$robo$$com_android_internal_telephony_Connection$getAddress() {
        return this.mAddress;
    }

    private final String $$robo$$com_android_internal_telephony_Connection$getCnapName() {
        return this.mCnapName;
    }

    private final String $$robo$$com_android_internal_telephony_Connection$getOrigDialString() {
        return null;
    }

    private final int $$robo$$com_android_internal_telephony_Connection$getCnapNamePresentation() {
        return this.mCnapNamePresentation;
    }

    public abstract Call getCall();

    private final long $$robo$$com_android_internal_telephony_Connection$getCreateTime() {
        return this.mCreateTime;
    }

    private final long $$robo$$com_android_internal_telephony_Connection$getConnectTime() {
        return this.mConnectTime;
    }

    private final long $$robo$$com_android_internal_telephony_Connection$getConnectTimeReal() {
        return this.mConnectTimeReal;
    }

    public abstract long getDisconnectTime();

    private final long $$robo$$com_android_internal_telephony_Connection$getDurationMillis() {
        if (this.mConnectTimeReal == 0L) {
            return 0L;
        }
        if (this.mDuration == 0L) {
            return SystemClock.elapsedRealtime() - this.mConnectTimeReal;
        }
        return this.mDuration;
    }

    private final long $$robo$$com_android_internal_telephony_Connection$getHoldingStartTime() {
        return this.mHoldingStartTime;
    }

    public abstract long getHoldDurationMillis();

    public abstract int getDisconnectCause();

    private final boolean $$robo$$com_android_internal_telephony_Connection$isIncoming() {
        return this.mIsIncoming;
    }

    private final Call.State $$robo$$com_android_internal_telephony_Connection$getState() {
        Call c = this.getCall();
        if (c == null) {
            return Call.State.IDLE;
        }
        return c.getState();
    }

    private final boolean $$robo$$com_android_internal_telephony_Connection$isAlive() {
        return this.getState().isAlive();
    }

    private final boolean $$robo$$com_android_internal_telephony_Connection$isRinging() {
        return this.getState().isRinging();
    }

    private final Object $$robo$$com_android_internal_telephony_Connection$getUserData() {
        return this.mUserData;
    }

    private final void $$robo$$com_android_internal_telephony_Connection$setUserData(Object userdata) {
        this.mUserData = userdata;
    }

    public abstract void hangup() throws CallStateException;

    public abstract void separate() throws CallStateException;

    private final void $$robo$$com_android_internal_telephony_Connection$clearUserData() {
        this.mUserData = null;
    }

    private final void $$robo$$com_android_internal_telephony_Connection$addPostDialListener(PostDialListener listener) {
        if (!this.mPostDialListeners.contains(listener)) {
            this.mPostDialListeners.add(listener);
        }
    }

    private final void $$robo$$com_android_internal_telephony_Connection$clearPostDialListeners() {
        this.mPostDialListeners.clear();
    }

    private final void $$robo$$com_android_internal_telephony_Connection$notifyPostDialListeners() {
        if (this.getPostDialState() == PostDialState.WAIT) {
            for (PostDialListener listener : new ArrayList<PostDialListener>(this.mPostDialListeners)) {
                listener.onPostDialWait();
            }
        }
    }

    public abstract PostDialState getPostDialState();

    public abstract String getRemainingPostDialString();

    public abstract void proceedAfterWaitChar();

    public abstract void proceedAfterWildChar(String var1);

    public abstract void cancelPostDial();

    public abstract int getNumberPresentation();

    public abstract UUSInfo getUUSInfo();

    public abstract int getPreciseDisconnectCause();

    private final Connection $$robo$$com_android_internal_telephony_Connection$getOrigConnection() {
        return this.mOrigConnection;
    }

    public abstract boolean isMultiparty();

    private final void $$robo$$com_android_internal_telephony_Connection$migrateFrom(Connection c) {
        if (c == null) {
            return;
        }
        this.mListeners = c.mListeners;
        this.mAddress = c.getAddress();
        this.mNumberPresentation = c.getNumberPresentation();
        this.mDialString = c.getOrigDialString();
        this.mCnapName = c.getCnapName();
        this.mCnapNamePresentation = c.getCnapNamePresentation();
        this.mIsIncoming = c.isIncoming();
        this.mCreateTime = c.getCreateTime();
        this.mConnectTime = c.getConnectTime();
        this.mConnectTimeReal = c.getConnectTimeReal();
        this.mHoldingStartTime = c.getHoldingStartTime();
        this.mOrigConnection = c.getOrigConnection();
    }

    private final void $$robo$$com_android_internal_telephony_Connection$addListener(Listener listener) {
        this.mListeners.add(listener);
    }

    private final void $$robo$$com_android_internal_telephony_Connection$removeListener(Listener listener) {
        this.mListeners.remove(listener);
    }

    private final int $$robo$$com_android_internal_telephony_Connection$getVideoState() {
        return this.mVideoState;
    }

    private final boolean $$robo$$com_android_internal_telephony_Connection$isLocalVideoCapable() {
        return this.mLocalVideoCapable;
    }

    private final boolean $$robo$$com_android_internal_telephony_Connection$isRemoteVideoCapable() {
        return this.mRemoteVideoCapable;
    }

    private final Connection.VideoProvider $$robo$$com_android_internal_telephony_Connection$getVideoProvider() {
        return this.mVideoProvider;
    }

    private final int $$robo$$com_android_internal_telephony_Connection$getAudioQuality() {
        return this.mAudioQuality;
    }

    private final void $$robo$$com_android_internal_telephony_Connection$setVideoState(int videoState) {
        this.mVideoState = videoState;
        for (Listener l : this.mListeners) {
            l.onVideoStateChanged(this.mVideoState);
        }
    }

    private final void $$robo$$com_android_internal_telephony_Connection$setLocalVideoCapable(boolean capable) {
        this.mLocalVideoCapable = capable;
        for (Listener l : this.mListeners) {
            l.onLocalVideoCapabilityChanged(this.mLocalVideoCapable);
        }
    }

    private final void $$robo$$com_android_internal_telephony_Connection$setRemoteVideoCapable(boolean capable) {
        this.mRemoteVideoCapable = capable;
        for (Listener l : this.mListeners) {
            l.onRemoteVideoCapabilityChanged(this.mRemoteVideoCapable);
        }
    }

    private final void $$robo$$com_android_internal_telephony_Connection$setAudioQuality(int audioQuality) {
        this.mAudioQuality = audioQuality;
        for (Listener l : this.mListeners) {
            l.onAudioQualityChanged(this.mAudioQuality);
        }
    }

    private final void $$robo$$com_android_internal_telephony_Connection$setVideoProvider(Connection.VideoProvider videoProvider) {
        this.mVideoProvider = videoProvider;
        for (Listener l : this.mListeners) {
            l.onVideoProviderChanged(this.mVideoProvider);
        }
    }

    private final void $$robo$$com_android_internal_telephony_Connection$setConverted(String oriNumber) {
        this.mNumberConverted = true;
        this.mConvertedNumber = this.mAddress;
        this.mAddress = oriNumber;
        this.mDialString = oriNumber;
    }

    private final String $$robo$$com_android_internal_telephony_Connection$toString() {
        StringBuilder str = new StringBuilder(128);
        if (Rlog.isLoggable(LOG_TAG, 3)) {
            str.append("addr: " + this.getAddress()).append(" pres.: " + this.getNumberPresentation()).append(" dial: " + this.getOrigDialString()).append(" postdial: " + this.getRemainingPostDialString()).append(" cnap name: " + this.getCnapName()).append("(" + this.getCnapNamePresentation() + ")");
        }
        str.append(" incoming: " + this.isIncoming()).append(" state: " + (Object)((Object)this.getState())).append(" post dial state: " + (Object)((Object)this.getPostDialState()));
        return str.toString();
    }

    static void __staticInitializer__() {
        LOG_TAG = "Connection";
    }

    private void __constructor__() {
        this.$$robo$$com_android_internal_telephony_Connection$__constructor__();
    }

    public Connection() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_Connection$__constructor__(), 0, this);
    }

    public String getAddress() {
        return InvokeDynamicSupport.bootstrap("getAddress", $$robo$$com_android_internal_telephony_Connection$getAddress(), 0, this);
    }

    public String getCnapName() {
        return InvokeDynamicSupport.bootstrap("getCnapName", $$robo$$com_android_internal_telephony_Connection$getCnapName(), 0, this);
    }

    public String getOrigDialString() {
        return InvokeDynamicSupport.bootstrap("getOrigDialString", $$robo$$com_android_internal_telephony_Connection$getOrigDialString(), 0, this);
    }

    public int getCnapNamePresentation() {
        return (int)InvokeDynamicSupport.bootstrap("getCnapNamePresentation", $$robo$$com_android_internal_telephony_Connection$getCnapNamePresentation(), 0, this);
    }

    public long getCreateTime() {
        return (long)InvokeDynamicSupport.bootstrap("getCreateTime", $$robo$$com_android_internal_telephony_Connection$getCreateTime(), 0, this);
    }

    public long getConnectTime() {
        return (long)InvokeDynamicSupport.bootstrap("getConnectTime", $$robo$$com_android_internal_telephony_Connection$getConnectTime(), 0, this);
    }

    public long getConnectTimeReal() {
        return (long)InvokeDynamicSupport.bootstrap("getConnectTimeReal", $$robo$$com_android_internal_telephony_Connection$getConnectTimeReal(), 0, this);
    }

    public long getDurationMillis() {
        return (long)InvokeDynamicSupport.bootstrap("getDurationMillis", $$robo$$com_android_internal_telephony_Connection$getDurationMillis(), 0, this);
    }

    public long getHoldingStartTime() {
        return (long)InvokeDynamicSupport.bootstrap("getHoldingStartTime", $$robo$$com_android_internal_telephony_Connection$getHoldingStartTime(), 0, this);
    }

    public boolean isIncoming() {
        return (boolean)InvokeDynamicSupport.bootstrap("isIncoming", $$robo$$com_android_internal_telephony_Connection$isIncoming(), 0, this);
    }

    public Call.State getState() {
        return InvokeDynamicSupport.bootstrap("getState", $$robo$$com_android_internal_telephony_Connection$getState(), 0, this);
    }

    public boolean isAlive() {
        return (boolean)InvokeDynamicSupport.bootstrap("isAlive", $$robo$$com_android_internal_telephony_Connection$isAlive(), 0, this);
    }

    public boolean isRinging() {
        return (boolean)InvokeDynamicSupport.bootstrap("isRinging", $$robo$$com_android_internal_telephony_Connection$isRinging(), 0, this);
    }

    public Object getUserData() {
        return InvokeDynamicSupport.bootstrap("getUserData", $$robo$$com_android_internal_telephony_Connection$getUserData(), 0, this);
    }

    public void setUserData(Object object) {
        InvokeDynamicSupport.bootstrap("setUserData", $$robo$$com_android_internal_telephony_Connection$setUserData(java.lang.Object ), 0, this, object);
    }

    public void clearUserData() {
        InvokeDynamicSupport.bootstrap("clearUserData", $$robo$$com_android_internal_telephony_Connection$clearUserData(), 0, this);
    }

    public void addPostDialListener(PostDialListener postDialListener) {
        InvokeDynamicSupport.bootstrap("addPostDialListener", $$robo$$com_android_internal_telephony_Connection$addPostDialListener(com.android.internal.telephony.Connection$PostDialListener ), 0, this, postDialListener);
    }

    protected void clearPostDialListeners() {
        InvokeDynamicSupport.bootstrap("clearPostDialListeners", $$robo$$com_android_internal_telephony_Connection$clearPostDialListeners(), 0, this);
    }

    protected void notifyPostDialListeners() {
        InvokeDynamicSupport.bootstrap("notifyPostDialListeners", $$robo$$com_android_internal_telephony_Connection$notifyPostDialListeners(), 0, this);
    }

    public Connection getOrigConnection() {
        return InvokeDynamicSupport.bootstrap("getOrigConnection", $$robo$$com_android_internal_telephony_Connection$getOrigConnection(), 0, this);
    }

    public void migrateFrom(Connection connection) {
        InvokeDynamicSupport.bootstrap("migrateFrom", $$robo$$com_android_internal_telephony_Connection$migrateFrom(com.android.internal.telephony.Connection ), 0, this, connection);
    }

    public void addListener(Listener listener) {
        InvokeDynamicSupport.bootstrap("addListener", $$robo$$com_android_internal_telephony_Connection$addListener(com.android.internal.telephony.Connection$Listener ), 0, this, listener);
    }

    public void removeListener(Listener listener) {
        InvokeDynamicSupport.bootstrap("removeListener", $$robo$$com_android_internal_telephony_Connection$removeListener(com.android.internal.telephony.Connection$Listener ), 0, this, listener);
    }

    public int getVideoState() {
        return (int)InvokeDynamicSupport.bootstrap("getVideoState", $$robo$$com_android_internal_telephony_Connection$getVideoState(), 0, this);
    }

    public boolean isLocalVideoCapable() {
        return (boolean)InvokeDynamicSupport.bootstrap("isLocalVideoCapable", $$robo$$com_android_internal_telephony_Connection$isLocalVideoCapable(), 0, this);
    }

    public boolean isRemoteVideoCapable() {
        return (boolean)InvokeDynamicSupport.bootstrap("isRemoteVideoCapable", $$robo$$com_android_internal_telephony_Connection$isRemoteVideoCapable(), 0, this);
    }

    public Connection.VideoProvider getVideoProvider() {
        return InvokeDynamicSupport.bootstrap("getVideoProvider", $$robo$$com_android_internal_telephony_Connection$getVideoProvider(), 0, this);
    }

    public int getAudioQuality() {
        return (int)InvokeDynamicSupport.bootstrap("getAudioQuality", $$robo$$com_android_internal_telephony_Connection$getAudioQuality(), 0, this);
    }

    public void setVideoState(int n) {
        InvokeDynamicSupport.bootstrap("setVideoState", $$robo$$com_android_internal_telephony_Connection$setVideoState(int ), 0, this, n);
    }

    public void setLocalVideoCapable(boolean bl) {
        InvokeDynamicSupport.bootstrap("setLocalVideoCapable", $$robo$$com_android_internal_telephony_Connection$setLocalVideoCapable(boolean ), 0, this, bl);
    }

    public void setRemoteVideoCapable(boolean bl) {
        InvokeDynamicSupport.bootstrap("setRemoteVideoCapable", $$robo$$com_android_internal_telephony_Connection$setRemoteVideoCapable(boolean ), 0, this, bl);
    }

    public void setAudioQuality(int n) {
        InvokeDynamicSupport.bootstrap("setAudioQuality", $$robo$$com_android_internal_telephony_Connection$setAudioQuality(int ), 0, this, n);
    }

    public void setVideoProvider(Connection.VideoProvider videoProvider) {
        InvokeDynamicSupport.bootstrap("setVideoProvider", $$robo$$com_android_internal_telephony_Connection$setVideoProvider(android.telecom.Connection$VideoProvider ), 0, this, videoProvider);
    }

    public void setConverted(String string2) {
        InvokeDynamicSupport.bootstrap("setConverted", $$robo$$com_android_internal_telephony_Connection$setConverted(java.lang.String ), 0, this, string2);
    }

    public String toString() {
        return InvokeDynamicSupport.bootstrap("toString", $$robo$$com_android_internal_telephony_Connection$toString(), 0, this);
    }

    static {
        RobolectricInternals.classInitializing(Connection.class);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Connection)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public static final class PostDialState
    extends Enum<PostDialState> {
        public transient /* synthetic */ Object __robo_data__;
        public static /* enum */ PostDialState NOT_STARTED;
        public static /* enum */ PostDialState STARTED;
        public static /* enum */ PostDialState WAIT;
        public static /* enum */ PostDialState WILD;
        public static /* enum */ PostDialState COMPLETE;
        public static /* enum */ PostDialState CANCELLED;
        public static /* enum */ PostDialState PAUSE;
        private static /* synthetic */ PostDialState[] $VALUES;

        private static final PostDialState[] $$robo$$com_android_internal_telephony_Connection_PostDialState$values() {
            return (PostDialState[])$VALUES.clone();
        }

        private static final PostDialState $$robo$$com_android_internal_telephony_Connection_PostDialState$valueOf(String name) {
            return Enum.valueOf(PostDialState.class, name);
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         */
        private void $$robo$$com_android_internal_telephony_Connection_PostDialState$__constructor__(String string2, int n) {
        }

        static void __staticInitializer__() {
            NOT_STARTED = new PostDialState();
            STARTED = new PostDialState();
            WAIT = new PostDialState();
            WILD = new PostDialState();
            COMPLETE = new PostDialState();
            CANCELLED = new PostDialState();
            PAUSE = new PostDialState();
            $VALUES = new PostDialState[]{NOT_STARTED, STARTED, WAIT, WILD, COMPLETE, CANCELLED, PAUSE};
        }

        public static PostDialState[] values() {
            return InvokeDynamicSupport.bootstrapStatic("values", $$robo$$com_android_internal_telephony_Connection_PostDialState$values(), 0);
        }

        public static PostDialState valueOf(String string2) {
            return InvokeDynamicSupport.bootstrapStatic("valueOf", $$robo$$com_android_internal_telephony_Connection_PostDialState$valueOf(java.lang.String ), 0, (String)string2);
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         */
        private void __constructor__(String string2, int n) {
            this.$$robo$$com_android_internal_telephony_Connection_PostDialState$__constructor__(string2, n);
        }

        private PostDialState() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_Connection_PostDialState$__constructor__(java.lang.String int ), 0, this, string2, n);
        }

        static {
            RobolectricInternals.classInitializing(PostDialState.class);
        }

        public /* synthetic */ PostDialState() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (PostDialState)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static abstract class ListenerBase
    implements Listener,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;

        private void $$robo$$com_android_internal_telephony_Connection_ListenerBase$__constructor__() {
        }

        private final void $$robo$$com_android_internal_telephony_Connection_ListenerBase$onVideoStateChanged(int videoState) {
        }

        private final void $$robo$$com_android_internal_telephony_Connection_ListenerBase$onLocalVideoCapabilityChanged(boolean capable) {
        }

        private final void $$robo$$com_android_internal_telephony_Connection_ListenerBase$onRemoteVideoCapabilityChanged(boolean capable) {
        }

        private final void $$robo$$com_android_internal_telephony_Connection_ListenerBase$onVideoProviderChanged(Connection.VideoProvider videoProvider) {
        }

        private final void $$robo$$com_android_internal_telephony_Connection_ListenerBase$onAudioQualityChanged(int audioQuality) {
        }

        private void __constructor__() {
            this.$$robo$$com_android_internal_telephony_Connection_ListenerBase$__constructor__();
        }

        public ListenerBase() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_Connection_ListenerBase$__constructor__(), 0, this);
        }

        @Override
        public void onVideoStateChanged(int n) {
            InvokeDynamicSupport.bootstrap("onVideoStateChanged", $$robo$$com_android_internal_telephony_Connection_ListenerBase$onVideoStateChanged(int ), 0, this, n);
        }

        @Override
        public void onLocalVideoCapabilityChanged(boolean bl) {
            InvokeDynamicSupport.bootstrap("onLocalVideoCapabilityChanged", $$robo$$com_android_internal_telephony_Connection_ListenerBase$onLocalVideoCapabilityChanged(boolean ), 0, this, bl);
        }

        @Override
        public void onRemoteVideoCapabilityChanged(boolean bl) {
            InvokeDynamicSupport.bootstrap("onRemoteVideoCapabilityChanged", $$robo$$com_android_internal_telephony_Connection_ListenerBase$onRemoteVideoCapabilityChanged(boolean ), 0, this, bl);
        }

        @Override
        public void onVideoProviderChanged(Connection.VideoProvider videoProvider) {
            InvokeDynamicSupport.bootstrap("onVideoProviderChanged", $$robo$$com_android_internal_telephony_Connection_ListenerBase$onVideoProviderChanged(android.telecom.Connection$VideoProvider ), 0, this, videoProvider);
        }

        @Override
        public void onAudioQualityChanged(int n) {
            InvokeDynamicSupport.bootstrap("onAudioQualityChanged", $$robo$$com_android_internal_telephony_Connection_ListenerBase$onAudioQualityChanged(int ), 0, this, n);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ListenerBase)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static interface Listener
    extends InstrumentedInterface {
        public void onVideoStateChanged(int var1);

        public void onLocalVideoCapabilityChanged(boolean var1);

        public void onRemoteVideoCapabilityChanged(boolean var1);

        public void onVideoProviderChanged(Connection.VideoProvider var1);

        public void onAudioQualityChanged(int var1);
    }

    public static interface PostDialListener
    extends InstrumentedInterface {
        public void onPostDialWait();
    }
}

