/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.app.PendingIntent;
import android.net.Uri;
import android.os.AsyncResult;
import android.os.Message;
import android.telephony.Rlog;
import android.telephony.SmsMessage;
import com.android.internal.telephony.GsmAlphabet;
import com.android.internal.telephony.PhoneBase;
import com.android.internal.telephony.SMSDispatcher;
import com.android.internal.telephony.SmsBroadcastUndelivered;
import com.android.internal.telephony.SmsHeader;
import com.android.internal.telephony.SmsMessageBase;
import com.android.internal.telephony.SmsStorageMonitor;
import com.android.internal.telephony.SmsUsageMonitor;
import com.android.internal.telephony.cdma.CdmaInboundSmsHandler;
import com.android.internal.telephony.cdma.CdmaSMSDispatcher;
import com.android.internal.telephony.cdma.SmsMessage;
import com.android.internal.telephony.gsm.GsmInboundSmsHandler;
import com.android.internal.telephony.gsm.GsmSMSDispatcher;
import com.google.errorprone.annotations.DoNotMock;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class ImsSMSDispatcher
extends SMSDispatcher
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "RIL_ImsSms";
    private SMSDispatcher mCdmaDispatcher;
    private SMSDispatcher mGsmDispatcher;
    private GsmInboundSmsHandler mGsmInboundSmsHandler;
    private CdmaInboundSmsHandler mCdmaInboundSmsHandler;
    private boolean mIms;
    private String mImsSmsFormat;

    private void $$robo$$com_android_internal_telephony_ImsSMSDispatcher$__constructor__(PhoneBase phone, SmsStorageMonitor storageMonitor, SmsUsageMonitor usageMonitor) {
        this.mIms = false;
        this.mImsSmsFormat = "unknown";
        Rlog.d("RIL_ImsSms", "ImsSMSDispatcher created");
        this.mCdmaDispatcher = new CdmaSMSDispatcher(phone, usageMonitor, this);
        this.mGsmInboundSmsHandler = GsmInboundSmsHandler.makeInboundSmsHandler(phone.getContext(), storageMonitor, phone);
        this.mCdmaInboundSmsHandler = CdmaInboundSmsHandler.makeInboundSmsHandler(phone.getContext(), storageMonitor, phone, (CdmaSMSDispatcher)this.mCdmaDispatcher);
        this.mGsmDispatcher = new GsmSMSDispatcher(phone, usageMonitor, this, this.mGsmInboundSmsHandler);
        Thread broadcastThread = new Thread(new SmsBroadcastUndelivered(phone.getContext(), this.mGsmInboundSmsHandler, this.mCdmaInboundSmsHandler));
        broadcastThread.start();
        this.mCi.registerForOn(this, 11, null);
        this.mCi.registerForImsNetworkStateChanged(this, 12, null);
    }

    private final void $$robo$$com_android_internal_telephony_ImsSMSDispatcher$updatePhoneObject(PhoneBase phone) {
        Rlog.d("RIL_ImsSms", "In IMS updatePhoneObject ");
        super.updatePhoneObject(phone);
        this.mCdmaDispatcher.updatePhoneObject(phone);
        this.mGsmDispatcher.updatePhoneObject(phone);
        this.mGsmInboundSmsHandler.updatePhoneObject(phone);
        this.mCdmaInboundSmsHandler.updatePhoneObject(phone);
    }

    private final void $$robo$$com_android_internal_telephony_ImsSMSDispatcher$dispose() {
        this.mCi.unregisterForOn(this);
        this.mCi.unregisterForImsNetworkStateChanged(this);
        this.mGsmDispatcher.dispose();
        this.mCdmaDispatcher.dispose();
        this.mGsmInboundSmsHandler.dispose();
        this.mCdmaInboundSmsHandler.dispose();
    }

    private final void $$robo$$com_android_internal_telephony_ImsSMSDispatcher$handleMessage(Message msg) {
        switch (msg.what) {
            case 11: 
            case 12: {
                this.mCi.getImsRegistrationState(this.obtainMessage(13));
                break;
            }
            case 13: {
                AsyncResult ar = (AsyncResult)msg.obj;
                if (ar.exception == null) {
                    this.updateImsInfo(ar);
                    break;
                }
                Rlog.e("RIL_ImsSms", "IMS State query failed with exp " + ar.exception);
                break;
            }
            default: {
                super.handleMessage(msg);
            }
        }
    }

    private final void $$robo$$com_android_internal_telephony_ImsSMSDispatcher$setImsSmsFormat(int format) {
        switch (format) {
            case 1: {
                this.mImsSmsFormat = "3gpp";
                break;
            }
            case 2: {
                this.mImsSmsFormat = "3gpp2";
                break;
            }
            default: {
                this.mImsSmsFormat = "unknown";
            }
        }
    }

    private final void $$robo$$com_android_internal_telephony_ImsSMSDispatcher$updateImsInfo(AsyncResult ar) {
        int[] responseArray = (int[])ar.result;
        this.mIms = false;
        if (responseArray[0] == 1) {
            Rlog.d("RIL_ImsSms", "IMS is registered!");
            this.mIms = true;
        } else {
            Rlog.d("RIL_ImsSms", "IMS is NOT registered!");
        }
        this.setImsSmsFormat(responseArray[1]);
        if ("unknown".equals(this.mImsSmsFormat)) {
            Rlog.e("RIL_ImsSms", "IMS format was unknown!");
            this.mIms = false;
        }
    }

    private final void $$robo$$com_android_internal_telephony_ImsSMSDispatcher$sendData(String destAddr, String scAddr, int destPort, byte[] data, PendingIntent sentIntent, PendingIntent deliveryIntent) {
        if (this.isCdmaMo()) {
            this.mCdmaDispatcher.sendData(destAddr, scAddr, destPort, data, sentIntent, deliveryIntent);
        } else {
            this.mGsmDispatcher.sendData(destAddr, scAddr, destPort, data, sentIntent, deliveryIntent);
        }
    }

    private final void $$robo$$com_android_internal_telephony_ImsSMSDispatcher$sendMultipartText(String destAddr, String scAddr, ArrayList<String> parts, ArrayList<PendingIntent> sentIntents, ArrayList<PendingIntent> deliveryIntents, Uri messageUri, String callingPkg) {
        if (this.isCdmaMo()) {
            this.mCdmaDispatcher.sendMultipartText(destAddr, scAddr, parts, sentIntents, deliveryIntents, messageUri, callingPkg);
        } else {
            this.mGsmDispatcher.sendMultipartText(destAddr, scAddr, parts, sentIntents, deliveryIntents, messageUri, callingPkg);
        }
    }

    private final void $$robo$$com_android_internal_telephony_ImsSMSDispatcher$sendSms(SMSDispatcher.SmsTracker tracker) {
        Rlog.e("RIL_ImsSms", "sendSms should never be called from here!");
    }

    private final void $$robo$$com_android_internal_telephony_ImsSMSDispatcher$sendSmsByPstn(SMSDispatcher.SmsTracker tracker) {
        Rlog.e("RIL_ImsSms", "sendSmsByPstn should never be called from here!");
    }

    private final void $$robo$$com_android_internal_telephony_ImsSMSDispatcher$updateSmsSendStatus(int messageRef, boolean success) {
        if (this.isCdmaMo()) {
            this.updateSmsSendStatusHelper(messageRef, this.mCdmaDispatcher.sendPendingList, this.mCdmaDispatcher, success);
            this.updateSmsSendStatusHelper(messageRef, this.mGsmDispatcher.sendPendingList, null, success);
        } else {
            this.updateSmsSendStatusHelper(messageRef, this.mGsmDispatcher.sendPendingList, this.mGsmDispatcher, success);
            this.updateSmsSendStatusHelper(messageRef, this.mCdmaDispatcher.sendPendingList, null, success);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$com_android_internal_telephony_ImsSMSDispatcher$updateSmsSendStatusHelper(int messageRef, List<SMSDispatcher.SmsTracker> sendPendingList, SMSDispatcher smsDispatcher, boolean success) {
        List<SMSDispatcher.SmsTracker> list = sendPendingList;
        synchronized (list) {
            int count = sendPendingList.size();
            for (int i = 0; i < count; ++i) {
                SMSDispatcher.SmsTracker tracker = sendPendingList.get(i);
                if (tracker.mMessageRef != messageRef) continue;
                sendPendingList.remove(i);
                if (success) {
                    Rlog.d("RIL_ImsSms", "Sending SMS by IP succeeded.");
                    this.sendMessage(this.obtainMessage(2, new AsyncResult(tracker, null, null)));
                    break;
                }
                Rlog.d("RIL_ImsSms", "Sending SMS by IP failed.");
                if (smsDispatcher != null) {
                    smsDispatcher.sendSmsByPstn(tracker);
                    break;
                }
                Rlog.e("RIL_ImsSms", "No feasible way to send this SMS.");
                break;
            }
        }
    }

    private final void $$robo$$com_android_internal_telephony_ImsSMSDispatcher$sendText(String destAddr, String scAddr, String text, PendingIntent sentIntent, PendingIntent deliveryIntent, Uri messageUri, String callingPkg) {
        Rlog.d("RIL_ImsSms", "sendText");
        if (this.isCdmaMo()) {
            this.mCdmaDispatcher.sendText(destAddr, scAddr, text, sentIntent, deliveryIntent, messageUri, callingPkg);
        } else {
            this.mGsmDispatcher.sendText(destAddr, scAddr, text, sentIntent, deliveryIntent, messageUri, callingPkg);
        }
    }

    private final void $$robo$$com_android_internal_telephony_ImsSMSDispatcher$injectSmsPdu(byte[] pdu, String format, PendingIntent receivedIntent) {
        Rlog.d("RIL_ImsSms", "ImsSMSDispatcher:injectSmsPdu");
        try {
            android.telephony.SmsMessage msg = android.telephony.SmsMessage.createFromPdu(pdu, format);
            if (msg.getMessageClass() != SmsMessage.MessageClass.CLASS_1) {
                if (receivedIntent != null) {
                    receivedIntent.send(2);
                }
                return;
            }
            AsyncResult ar = new AsyncResult(receivedIntent, msg, null);
            if (format.equals("3gpp")) {
                Rlog.i("RIL_ImsSms", "ImsSMSDispatcher:injectSmsText Sending msg=" + msg + ", format=" + format + "to mGsmInboundSmsHandler");
                this.mGsmInboundSmsHandler.sendMessage(8, ar);
            } else if (format.equals("3gpp2")) {
                Rlog.i("RIL_ImsSms", "ImsSMSDispatcher:injectSmsText Sending msg=" + msg + ", format=" + format + "to mCdmaInboundSmsHandler");
                this.mCdmaInboundSmsHandler.sendMessage(8, ar);
            } else {
                Rlog.e("RIL_ImsSms", "Invalid pdu format: " + format);
                if (receivedIntent != null) {
                    receivedIntent.send(2);
                }
            }
        }
        catch (Exception e) {
            Rlog.e("RIL_ImsSms", "injectSmsPdu failed: ", e);
            try {
                if (receivedIntent != null) {
                    receivedIntent.send(2);
                }
            }
            catch (PendingIntent.CanceledException canceledException) {
                // empty catch block
            }
        }
    }

    private final void $$robo$$com_android_internal_telephony_ImsSMSDispatcher$sendRetrySms(SMSDispatcher.SmsTracker tracker) {
        String newFormat;
        String oldFormat = tracker.mFormat;
        String string2 = newFormat = 2 == this.mPhone.getPhoneType() ? this.mCdmaDispatcher.getFormat() : this.mGsmDispatcher.getFormat();
        if (oldFormat.equals(newFormat)) {
            if (this.isCdmaFormat(newFormat)) {
                Rlog.d("RIL_ImsSms", "old format matched new format (cdma)");
                this.mCdmaDispatcher.sendSms(tracker);
                return;
            }
            Rlog.d("RIL_ImsSms", "old format matched new format (gsm)");
            this.mGsmDispatcher.sendSms(tracker);
            return;
        }
        HashMap<String, Object> map = tracker.mData;
        if (!(map.containsKey("scAddr") && map.containsKey("destAddr") && (map.containsKey("text") || map.containsKey("data") && map.containsKey("destPort")))) {
            Rlog.e("RIL_ImsSms", "sendRetrySms failed to re-encode per missing fields!");
            tracker.onFailed(this.mContext, 1, 0);
            return;
        }
        String scAddr = (String)map.get("scAddr");
        String destAddr = (String)map.get("destAddr");
        SmsMessageBase.SubmitPduBase pdu = null;
        if (map.containsKey("text")) {
            Rlog.d("RIL_ImsSms", "sms failed was text");
            String text = (String)map.get("text");
            if (this.isCdmaFormat(newFormat)) {
                Rlog.d("RIL_ImsSms", "old format (gsm) ==> new format (cdma)");
                pdu = SmsMessage.getSubmitPdu(scAddr, destAddr, text, tracker.mDeliveryIntent != null, null);
            } else {
                Rlog.d("RIL_ImsSms", "old format (cdma) ==> new format (gsm)");
                pdu = com.android.internal.telephony.gsm.SmsMessage.getSubmitPdu(scAddr, destAddr, text, tracker.mDeliveryIntent != null, null);
            }
        } else if (map.containsKey("data")) {
            Rlog.d("RIL_ImsSms", "sms failed was data");
            byte[] data = (byte[])map.get("data");
            Integer destPort = (Integer)map.get("destPort");
            if (this.isCdmaFormat(newFormat)) {
                Rlog.d("RIL_ImsSms", "old format (gsm) ==> new format (cdma)");
                pdu = SmsMessage.getSubmitPdu(scAddr, destAddr, destPort, data, tracker.mDeliveryIntent != null);
            } else {
                Rlog.d("RIL_ImsSms", "old format (cdma) ==> new format (gsm)");
                pdu = com.android.internal.telephony.gsm.SmsMessage.getSubmitPdu(scAddr, destAddr, destPort, data, tracker.mDeliveryIntent != null);
            }
        }
        map.put("smsc", pdu.encodedScAddress);
        map.put("pdu", pdu.encodedMessage);
        SMSDispatcher dispatcher = this.isCdmaFormat(newFormat) ? this.mCdmaDispatcher : this.mGsmDispatcher;
        tracker.mFormat = dispatcher.getFormat();
        dispatcher.sendSms(tracker);
    }

    private final String $$robo$$com_android_internal_telephony_ImsSMSDispatcher$getFormat() {
        Rlog.e("RIL_ImsSms", "getFormat should never be called from here!");
        return "unknown";
    }

    private final GsmAlphabet.TextEncodingDetails $$robo$$com_android_internal_telephony_ImsSMSDispatcher$calculateLength(CharSequence messageBody, boolean use7bitOnly) {
        Rlog.e("RIL_ImsSms", "Error! Not implemented for IMS.");
        return null;
    }

    private final void $$robo$$com_android_internal_telephony_ImsSMSDispatcher$sendNewSubmitPdu(String destinationAddress, String scAddress, String message, SmsHeader smsHeader, int format, PendingIntent sentIntent, PendingIntent deliveryIntent, boolean lastPart, AtomicInteger unsentPartCount, AtomicBoolean anyPartFailed, Uri messageUri) {
        Rlog.e("RIL_ImsSms", "Error! Not implemented for IMS.");
    }

    private final boolean $$robo$$com_android_internal_telephony_ImsSMSDispatcher$isIms() {
        return this.mIms;
    }

    private final String $$robo$$com_android_internal_telephony_ImsSMSDispatcher$getImsSmsFormat() {
        return this.mImsSmsFormat;
    }

    private final boolean $$robo$$com_android_internal_telephony_ImsSMSDispatcher$isCdmaMo() {
        if (!this.isIms()) {
            return 2 == this.mPhone.getPhoneType();
        }
        return this.isCdmaFormat(this.mImsSmsFormat);
    }

    private final boolean $$robo$$com_android_internal_telephony_ImsSMSDispatcher$isCdmaFormat(String format) {
        return this.mCdmaDispatcher.getFormat().equals(format);
    }

    private void __constructor__(PhoneBase phoneBase, SmsStorageMonitor smsStorageMonitor, SmsUsageMonitor smsUsageMonitor) {
        this.$$robo$$com_android_internal_telephony_ImsSMSDispatcher$__constructor__(phoneBase, smsStorageMonitor, smsUsageMonitor);
    }

    public ImsSMSDispatcher(PhoneBase phoneBase, SmsStorageMonitor smsStorageMonitor, SmsUsageMonitor smsUsageMonitor) {
        super(phoneBase, smsUsageMonitor, null);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_ImsSMSDispatcher$__constructor__(com.android.internal.telephony.PhoneBase com.android.internal.telephony.SmsStorageMonitor com.android.internal.telephony.SmsUsageMonitor ), 0, this, phoneBase, smsStorageMonitor, smsUsageMonitor);
    }

    @Override
    protected void updatePhoneObject(PhoneBase phoneBase) {
        InvokeDynamicSupport.bootstrap("updatePhoneObject", $$robo$$com_android_internal_telephony_ImsSMSDispatcher$updatePhoneObject(com.android.internal.telephony.PhoneBase ), 0, this, phoneBase);
    }

    @Override
    public void dispose() {
        InvokeDynamicSupport.bootstrap("dispose", $$robo$$com_android_internal_telephony_ImsSMSDispatcher$dispose(), 0, this);
    }

    @Override
    public void handleMessage(Message message) {
        InvokeDynamicSupport.bootstrap("handleMessage", $$robo$$com_android_internal_telephony_ImsSMSDispatcher$handleMessage(android.os.Message ), 0, this, message);
    }

    private void setImsSmsFormat(int n) {
        InvokeDynamicSupport.bootstrap("setImsSmsFormat", $$robo$$com_android_internal_telephony_ImsSMSDispatcher$setImsSmsFormat(int ), 0, this, n);
    }

    private void updateImsInfo(AsyncResult asyncResult) {
        InvokeDynamicSupport.bootstrap("updateImsInfo", $$robo$$com_android_internal_telephony_ImsSMSDispatcher$updateImsInfo(android.os.AsyncResult ), 0, this, asyncResult);
    }

    @Override
    protected void sendData(String string2, String string3, int n, byte[] byArray, PendingIntent pendingIntent, PendingIntent pendingIntent2) {
        InvokeDynamicSupport.bootstrap("sendData", $$robo$$com_android_internal_telephony_ImsSMSDispatcher$sendData(java.lang.String java.lang.String int byte[] android.app.PendingIntent android.app.PendingIntent ), 0, this, string2, string3, n, byArray, pendingIntent, pendingIntent2);
    }

    @Override
    protected void sendMultipartText(String string2, String string3, ArrayList<String> arrayList, ArrayList<PendingIntent> arrayList2, ArrayList<PendingIntent> arrayList3, Uri uri, String string4) {
        InvokeDynamicSupport.bootstrap("sendMultipartText", $$robo$$com_android_internal_telephony_ImsSMSDispatcher$sendMultipartText(java.lang.String java.lang.String java.util.ArrayList<java.lang.String> java.util.ArrayList<android.app.PendingIntent> java.util.ArrayList<android.app.PendingIntent> android.net.Uri java.lang.String ), 0, this, string2, string3, arrayList, arrayList2, arrayList3, uri, string4);
    }

    @Override
    protected void sendSms(SMSDispatcher.SmsTracker smsTracker) {
        InvokeDynamicSupport.bootstrap("sendSms", $$robo$$com_android_internal_telephony_ImsSMSDispatcher$sendSms(com.android.internal.telephony.SMSDispatcher$SmsTracker ), 0, this, smsTracker);
    }

    @Override
    protected void sendSmsByPstn(SMSDispatcher.SmsTracker smsTracker) {
        InvokeDynamicSupport.bootstrap("sendSmsByPstn", $$robo$$com_android_internal_telephony_ImsSMSDispatcher$sendSmsByPstn(com.android.internal.telephony.SMSDispatcher$SmsTracker ), 0, this, smsTracker);
    }

    @Override
    protected void updateSmsSendStatus(int n, boolean bl) {
        InvokeDynamicSupport.bootstrap("updateSmsSendStatus", $$robo$$com_android_internal_telephony_ImsSMSDispatcher$updateSmsSendStatus(int boolean ), 0, this, n, bl);
    }

    private void updateSmsSendStatusHelper(int n, List<SMSDispatcher.SmsTracker> list, SMSDispatcher sMSDispatcher, boolean bl) {
        InvokeDynamicSupport.bootstrap("updateSmsSendStatusHelper", $$robo$$com_android_internal_telephony_ImsSMSDispatcher$updateSmsSendStatusHelper(int java.util.List<com.android.internal.telephony.SMSDispatcher$SmsTracker> com.android.internal.telephony.SMSDispatcher boolean ), 0, this, n, list, sMSDispatcher, bl);
    }

    @Override
    protected void sendText(String string2, String string3, String string4, PendingIntent pendingIntent, PendingIntent pendingIntent2, Uri uri, String string5) {
        InvokeDynamicSupport.bootstrap("sendText", $$robo$$com_android_internal_telephony_ImsSMSDispatcher$sendText(java.lang.String java.lang.String java.lang.String android.app.PendingIntent android.app.PendingIntent android.net.Uri java.lang.String ), 0, this, string2, string3, string4, pendingIntent, pendingIntent2, uri, string5);
    }

    @Override
    protected void injectSmsPdu(byte[] byArray, String string2, PendingIntent pendingIntent) {
        InvokeDynamicSupport.bootstrap("injectSmsPdu", $$robo$$com_android_internal_telephony_ImsSMSDispatcher$injectSmsPdu(byte[] java.lang.String android.app.PendingIntent ), 0, this, byArray, string2, pendingIntent);
    }

    @Override
    public void sendRetrySms(SMSDispatcher.SmsTracker smsTracker) {
        InvokeDynamicSupport.bootstrap("sendRetrySms", $$robo$$com_android_internal_telephony_ImsSMSDispatcher$sendRetrySms(com.android.internal.telephony.SMSDispatcher$SmsTracker ), 0, this, smsTracker);
    }

    @Override
    protected String getFormat() {
        return InvokeDynamicSupport.bootstrap("getFormat", $$robo$$com_android_internal_telephony_ImsSMSDispatcher$getFormat(), 0, this);
    }

    @Override
    protected GsmAlphabet.TextEncodingDetails calculateLength(CharSequence charSequence, boolean bl) {
        return InvokeDynamicSupport.bootstrap("calculateLength", $$robo$$com_android_internal_telephony_ImsSMSDispatcher$calculateLength(java.lang.CharSequence boolean ), 0, this, charSequence, bl);
    }

    @Override
    protected void sendNewSubmitPdu(String string2, String string3, String string4, SmsHeader smsHeader, int n, PendingIntent pendingIntent, PendingIntent pendingIntent2, boolean bl, AtomicInteger atomicInteger, AtomicBoolean atomicBoolean, Uri uri) {
        InvokeDynamicSupport.bootstrap("sendNewSubmitPdu", $$robo$$com_android_internal_telephony_ImsSMSDispatcher$sendNewSubmitPdu(java.lang.String java.lang.String java.lang.String com.android.internal.telephony.SmsHeader int android.app.PendingIntent android.app.PendingIntent boolean java.util.concurrent.atomic.AtomicInteger java.util.concurrent.atomic.AtomicBoolean android.net.Uri ), 0, this, string2, string3, string4, smsHeader, n, pendingIntent, pendingIntent2, bl, atomicInteger, atomicBoolean, uri);
    }

    @Override
    public boolean isIms() {
        return (boolean)InvokeDynamicSupport.bootstrap("isIms", $$robo$$com_android_internal_telephony_ImsSMSDispatcher$isIms(), 0, this);
    }

    @Override
    public String getImsSmsFormat() {
        return InvokeDynamicSupport.bootstrap("getImsSmsFormat", $$robo$$com_android_internal_telephony_ImsSMSDispatcher$getImsSmsFormat(), 0, this);
    }

    private boolean isCdmaMo() {
        return (boolean)InvokeDynamicSupport.bootstrap("isCdmaMo", $$robo$$com_android_internal_telephony_ImsSMSDispatcher$isCdmaMo(), 0, this);
    }

    private boolean isCdmaFormat(String string2) {
        return (boolean)InvokeDynamicSupport.bootstrap("isCdmaFormat", $$robo$$com_android_internal_telephony_ImsSMSDispatcher$isCdmaFormat(java.lang.String ), 0, this, string2);
    }

    public /* synthetic */ ImsSMSDispatcher() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ImsSMSDispatcher)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

