/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.app.ActivityManagerNative;
import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.ContentResolver;
import android.content.ContentUris;
import android.content.ContentValues;
import android.content.Context;
import android.content.Intent;
import android.content.pm.UserInfo;
import android.database.Cursor;
import android.net.Uri;
import android.os.AsyncResult;
import android.os.Binder;
import android.os.Build;
import android.os.Bundle;
import android.os.Message;
import android.os.PowerManager;
import android.os.RemoteException;
import android.os.SystemProperties;
import android.os.UserHandle;
import android.os.UserManager;
import android.provider.Telephony;
import android.telephony.Rlog;
import android.telephony.SmsManager;
import android.telephony.SmsMessage;
import android.telephony.SubscriptionManager;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import com.android.internal.telephony.CellBroadcastHandler;
import com.android.internal.telephony.InboundSmsTracker;
import com.android.internal.telephony.PhoneBase;
import com.android.internal.telephony.SmsApplication;
import com.android.internal.telephony.SmsHeader;
import com.android.internal.telephony.SmsMessageBase;
import com.android.internal.telephony.SmsStorageMonitor;
import com.android.internal.telephony.WapPushOverSms;
import com.android.internal.telephony.uicc.UiccCard;
import com.android.internal.telephony.uicc.UiccController;
import com.android.internal.util.HexDump;
import com.android.internal.util.State;
import com.android.internal.util.StateMachine;
import com.google.errorprone.annotations.DoNotMock;
import java.io.ByteArrayOutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public abstract class InboundSmsHandler
extends StateMachine
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    protected static boolean DBG = true;
    private static boolean VDBG = false;
    private static String[] PDU_PROJECTION;
    private static String[] PDU_SEQUENCE_PORT_PROJECTION;
    static int PDU_COLUMN = 0;
    static int SEQUENCE_COLUMN = 1;
    static int DESTINATION_PORT_COLUMN = 2;
    static int DATE_COLUMN = 3;
    static int REFERENCE_NUMBER_COLUMN = 4;
    static int COUNT_COLUMN = 5;
    static int ADDRESS_COLUMN = 6;
    static int ID_COLUMN = 7;
    static String SELECT_BY_ID = "_id=?";
    static String SELECT_BY_REFERENCE = "address=? AND reference_number=? AND count=?";
    public static int EVENT_NEW_SMS = 1;
    static int EVENT_BROADCAST_SMS = 2;
    static int EVENT_BROADCAST_COMPLETE = 3;
    static int EVENT_RETURN_TO_IDLE = 4;
    static int EVENT_RELEASE_WAKELOCK = 5;
    static int EVENT_START_ACCEPTING_SMS = 6;
    static int EVENT_UPDATE_PHONE_OBJECT = 7;
    public static int EVENT_INJECT_SMS = 8;
    private static int WAKELOCK_TIMEOUT = 3000;
    private static Uri sRawUri;
    protected Context mContext;
    private ContentResolver mResolver;
    private WapPushOverSms mWapPush;
    PowerManager.WakeLock mWakeLock;
    DefaultState mDefaultState;
    StartupState mStartupState;
    IdleState mIdleState;
    DeliveringState mDeliveringState;
    WaitingState mWaitingState;
    protected SmsStorageMonitor mStorageMonitor;
    private boolean mSmsReceiveDisabled;
    protected PhoneBase mPhone;
    protected CellBroadcastHandler mCellBroadcastHandler;
    private UserManager mUserManager;

    private void $$robo$$com_android_internal_telephony_InboundSmsHandler$__constructor__(String name, Context context, SmsStorageMonitor storageMonitor, PhoneBase phone, CellBroadcastHandler cellBroadcastHandler) {
        this.mDefaultState = new DefaultState(this);
        this.mStartupState = new StartupState(this);
        this.mIdleState = new IdleState(this);
        this.mDeliveringState = new DeliveringState(this);
        this.mWaitingState = new WaitingState(this);
        this.mContext = context;
        this.mStorageMonitor = storageMonitor;
        this.mPhone = phone;
        this.mCellBroadcastHandler = cellBroadcastHandler;
        this.mResolver = context.getContentResolver();
        this.mWapPush = new WapPushOverSms(context);
        boolean smsCapable = this.mContext.getResources().getBoolean(17956932);
        this.mSmsReceiveDisabled = !SystemProperties.getBoolean("telephony.sms.receive", smsCapable);
        PowerManager pm = (PowerManager)this.mContext.getSystemService("power");
        this.mWakeLock = pm.newWakeLock(1, name);
        this.mWakeLock.acquire();
        this.mUserManager = (UserManager)this.mContext.getSystemService("user");
        this.addState(this.mDefaultState);
        this.addState(this.mStartupState, this.mDefaultState);
        this.addState(this.mIdleState, this.mDefaultState);
        this.addState(this.mDeliveringState, this.mDefaultState);
        this.addState(this.mWaitingState, this.mDeliveringState);
        this.setInitialState(this.mStartupState);
        this.log("created InboundSmsHandler");
    }

    private final void $$robo$$com_android_internal_telephony_InboundSmsHandler$dispose() {
        this.quit();
    }

    private final void $$robo$$com_android_internal_telephony_InboundSmsHandler$updatePhoneObject(PhoneBase phone) {
        this.sendMessage(7, phone);
    }

    private final void $$robo$$com_android_internal_telephony_InboundSmsHandler$onQuitting() {
        this.mWapPush.dispose();
        while (this.mWakeLock.isHeld()) {
            this.mWakeLock.release();
        }
    }

    private final PhoneBase $$robo$$com_android_internal_telephony_InboundSmsHandler$getPhone() {
        return this.mPhone;
    }

    private final void $$robo$$com_android_internal_telephony_InboundSmsHandler$handleNewSms(AsyncResult ar) {
        int result;
        if (ar.exception != null) {
            this.loge("Exception processing incoming SMS: " + ar.exception);
            return;
        }
        try {
            SmsMessage sms = (SmsMessage)ar.result;
            result = this.dispatchMessage(sms.mWrappedSmsMessage);
        }
        catch (RuntimeException ex) {
            this.loge("Exception dispatching message", ex);
            result = 2;
        }
        if (result != -1) {
            boolean handled = result == 1;
            this.notifyAndAcknowledgeLastIncomingSms(handled, result, null);
        }
    }

    private final void $$robo$$com_android_internal_telephony_InboundSmsHandler$handleInjectSms(AsyncResult ar) {
        int result;
        PendingIntent receivedIntent = null;
        try {
            receivedIntent = (PendingIntent)ar.userObj;
            SmsMessage sms = (SmsMessage)ar.result;
            result = sms == null ? 2 : this.dispatchMessage(sms.mWrappedSmsMessage);
        }
        catch (RuntimeException ex) {
            this.loge("Exception dispatching message", ex);
            result = 2;
        }
        if (receivedIntent != null) {
            try {
                receivedIntent.send(result);
            }
            catch (PendingIntent.CanceledException canceledException) {
                // empty catch block
            }
        }
    }

    private final int $$robo$$com_android_internal_telephony_InboundSmsHandler$dispatchMessage(SmsMessageBase smsb) {
        if (smsb == null) {
            this.loge("dispatchSmsMessage: message is null");
            return 2;
        }
        if (this.mSmsReceiveDisabled) {
            this.log("Received short message on device which doesn't support receiving SMS. Ignored.");
            return 1;
        }
        return this.dispatchMessageRadioSpecific(smsb);
    }

    protected abstract int dispatchMessageRadioSpecific(SmsMessageBase var1);

    protected abstract void acknowledgeLastIncomingSms(boolean var1, int var2, Message var3);

    private final void $$robo$$com_android_internal_telephony_InboundSmsHandler$onUpdatePhoneObject(PhoneBase phone) {
        this.mPhone = phone;
        this.mStorageMonitor = this.mPhone.mSmsStorageMonitor;
        this.log("onUpdatePhoneObject: phone=" + this.mPhone.getClass().getSimpleName());
    }

    private final void $$robo$$com_android_internal_telephony_InboundSmsHandler$notifyAndAcknowledgeLastIncomingSms(boolean success, int result, Message response) {
        if (!success) {
            Intent intent = new Intent("android.provider.Telephony.SMS_REJECTED");
            intent.putExtra("result", result);
            this.mContext.sendBroadcast(intent, "android.permission.RECEIVE_SMS");
        }
        this.acknowledgeLastIncomingSms(success, result, response);
    }

    protected abstract boolean is3gpp2();

    private final int $$robo$$com_android_internal_telephony_InboundSmsHandler$dispatchNormalMessage(SmsMessageBase sms) {
        InboundSmsTracker tracker;
        SmsHeader smsHeader = sms.getUserDataHeader();
        if (smsHeader == null || smsHeader.concatRef == null) {
            int destPort = -1;
            if (smsHeader != null && smsHeader.portAddrs != null) {
                destPort = smsHeader.portAddrs.destPort;
                this.log("destination port: " + destPort);
            }
            tracker = new InboundSmsTracker(sms.getPdu(), sms.getTimestampMillis(), destPort, this.is3gpp2(), false);
        } else {
            SmsHeader.ConcatRef concatRef = smsHeader.concatRef;
            SmsHeader.PortAddrs portAddrs = smsHeader.portAddrs;
            int destPort = portAddrs != null ? portAddrs.destPort : -1;
            tracker = new InboundSmsTracker(sms.getPdu(), sms.getTimestampMillis(), destPort, this.is3gpp2(), sms.getOriginatingAddress(), concatRef.refNumber, concatRef.seqNumber, concatRef.msgCount, false);
        }
        return this.addTrackerToRawTableAndSendMessage(tracker);
    }

    private final int $$robo$$com_android_internal_telephony_InboundSmsHandler$addTrackerToRawTableAndSendMessage(InboundSmsTracker tracker) {
        switch (this.addTrackerToRawTable(tracker)) {
            case 1: {
                this.sendMessage(2, tracker);
                return 1;
            }
            case 5: {
                return 1;
            }
        }
        return 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean $$robo$$com_android_internal_telephony_InboundSmsHandler$processMessagePart(InboundSmsTracker tracker) {
        byte[][] pdus;
        int messageCount = tracker.getMessageCount();
        int destPort = tracker.getDestPort();
        if (messageCount == 1) {
            pdus = new byte[][]{tracker.getPdu()};
        } else {
            try (Cursor cursor = null;){
                String address = tracker.getAddress();
                String refNumber = Integer.toString(tracker.getReferenceNumber());
                String count = Integer.toString(tracker.getMessageCount());
                String[] whereArgs = new String[]{address, refNumber, count};
                cursor = this.mResolver.query(sRawUri, PDU_SEQUENCE_PORT_PROJECTION, "address=? AND reference_number=? AND count=?", whereArgs, null);
                int cursorCount = cursor.getCount();
                if (cursorCount < messageCount) {
                    boolean bl = false;
                    return bl;
                }
                pdus = new byte[messageCount][];
                while (cursor.moveToNext()) {
                    int index = cursor.getInt(1) - tracker.getIndexOffset();
                    pdus[index] = HexDump.hexStringToByteArray(cursor.getString(0));
                    if (index != 0 || cursor.isNull(2)) continue;
                    int port = cursor.getInt(2);
                    if ((port = InboundSmsTracker.getRealDestPort(port)) == -1) continue;
                    destPort = port;
                }
            }
        }
        SmsBroadcastReceiver resultReceiver = new SmsBroadcastReceiver(this, tracker);
        if (destPort == 2948) {
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            for (byte[] pdu : pdus) {
                if (!tracker.is3gpp2()) {
                    SmsMessage msg = SmsMessage.createFromPdu(pdu, "3gpp");
                    pdu = msg.getUserData();
                }
                output.write(pdu, 0, pdu.length);
            }
            int result = this.mWapPush.dispatchWapPdu(output.toByteArray(), resultReceiver, this);
            this.log("dispatchWapPdu() returned " + result);
            return result == -1;
        }
        Intent intent = new Intent("android.provider.Telephony.SMS_FILTER");
        List<String> carrierPackages = null;
        UiccCard card = UiccController.getInstance().getUiccCard();
        if (card != null) {
            carrierPackages = card.getCarrierPackageNamesForIntent(this.mContext.getPackageManager(), intent);
        }
        if (carrierPackages != null && carrierPackages.size() == 1) {
            intent.setPackage(carrierPackages.get(0));
            intent.putExtra("destport", destPort);
        } else {
            this.setAndDirectIntent(intent, destPort);
        }
        intent.putExtra("pdus", (Serializable)pdus);
        intent.putExtra("format", tracker.getFormat());
        this.dispatchIntent(intent, "android.permission.RECEIVE_SMS", 16, resultReceiver, UserHandle.OWNER);
        return true;
    }

    private final void $$robo$$com_android_internal_telephony_InboundSmsHandler$dispatchIntent(Intent intent, String permission2, int appOp, BroadcastReceiver resultReceiver, UserHandle user) {
        intent.addFlags(0x8000000);
        SubscriptionManager.putPhoneIdAndSubIdExtra(intent, this.mPhone.getPhoneId());
        if (user.equals(UserHandle.ALL)) {
            int[] users = null;
            try {
                users = ActivityManagerNative.getDefault().getRunningUserIds();
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
            if (users == null) {
                users = new int[]{user.getIdentifier()};
            }
            for (int i = users.length - 1; i >= 0; --i) {
                UserInfo info;
                UserHandle targetUser = new UserHandle(users[i]);
                if (users[i] != 0 && (this.mUserManager.hasUserRestriction("no_sms", targetUser) || (info = this.mUserManager.getUserInfo(users[i])) == null || info.isManagedProfile())) continue;
                this.mContext.sendOrderedBroadcastAsUser(intent, targetUser, permission2, appOp, users[i] == 0 ? resultReceiver : null, this.getHandler(), -1, null, null);
            }
        } else {
            this.mContext.sendOrderedBroadcastAsUser(intent, user, permission2, appOp, resultReceiver, this.getHandler(), -1, null, null);
        }
    }

    private final void $$robo$$com_android_internal_telephony_InboundSmsHandler$deleteFromRawTable(String deleteWhere, String[] deleteWhereArgs) {
        int rows = this.mResolver.delete(sRawUri, deleteWhere, deleteWhereArgs);
        if (rows == 0) {
            this.loge("No rows were deleted from raw table!");
        } else {
            this.log("Deleted " + rows + " rows from raw table.");
        }
    }

    private final void $$robo$$com_android_internal_telephony_InboundSmsHandler$setAndDirectIntent(Intent intent, int destPort) {
        if (destPort == -1) {
            intent.setAction("android.provider.Telephony.SMS_DELIVER");
            ComponentName componentName = SmsApplication.getDefaultSmsApplication(this.mContext, true);
            if (componentName != null) {
                intent.setComponent(componentName);
                this.log("Delivering SMS to: " + componentName.getPackageName() + " " + componentName.getClassName());
            } else {
                intent.setComponent(null);
            }
        } else {
            intent.setAction("android.intent.action.DATA_SMS_RECEIVED");
            Uri uri = Uri.parse("sms://localhost:" + destPort);
            intent.setData(uri);
            intent.setComponent(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int $$robo$$com_android_internal_telephony_InboundSmsHandler$addTrackerToRawTable(InboundSmsTracker tracker) {
        if (tracker.getMessageCount() != 1) {
            try (Cursor cursor = null;){
                int sequence = tracker.getSequenceNumber();
                String address = tracker.getAddress();
                String refNumber = Integer.toString(tracker.getReferenceNumber());
                String count = Integer.toString(tracker.getMessageCount());
                String seqNumber = Integer.toString(sequence);
                String[] deleteWhereArgs = new String[]{address, refNumber, count};
                tracker.setDeleteWhere("address=? AND reference_number=? AND count=?", deleteWhereArgs);
                cursor = this.mResolver.query(sRawUri, PDU_PROJECTION, "address=? AND reference_number=? AND count=? AND sequence=?", new String[]{address, refNumber, count, seqNumber}, null);
                if (cursor.moveToNext()) {
                    this.loge("Discarding duplicate message segment, refNumber=" + refNumber + " seqNumber=" + seqNumber);
                    String oldPduString = cursor.getString(0);
                    byte[] pdu = tracker.getPdu();
                    byte[] oldPdu = HexDump.hexStringToByteArray(oldPduString);
                    if (!Arrays.equals(oldPdu, tracker.getPdu())) {
                        this.loge("Warning: dup message segment PDU of length " + pdu.length + " is different from existing PDU of length " + oldPdu.length);
                    }
                    int n = 5;
                    return n;
                }
                cursor.close();
            }
        }
        ContentValues values = tracker.getContentValues();
        Uri newUri = this.mResolver.insert(sRawUri, values);
        this.log("URI of new row -> " + newUri);
        try {
            long rowId = ContentUris.parseId(newUri);
            if (tracker.getMessageCount() == 1) {
                tracker.setDeleteWhere("_id=?", new String[]{Long.toString(rowId)});
            }
            return 1;
        }
        catch (Exception e) {
            this.loge("error parsing URI for new row: " + newUri, e);
            return 2;
        }
    }

    private static final boolean $$robo$$com_android_internal_telephony_InboundSmsHandler$isCurrentFormat3gpp2() {
        int activePhone = TelephonyManager.getDefault().getCurrentPhoneType();
        return 2 == activePhone;
    }

    private final void $$robo$$com_android_internal_telephony_InboundSmsHandler$log(String s) {
        Rlog.d(this.getName(), s);
    }

    private final void $$robo$$com_android_internal_telephony_InboundSmsHandler$loge(String s) {
        Rlog.e(this.getName(), s);
    }

    private final void $$robo$$com_android_internal_telephony_InboundSmsHandler$loge(String s, Throwable e) {
        Rlog.e(this.getName(), s, e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Uri $$robo$$com_android_internal_telephony_InboundSmsHandler$writeInboxMessage(Intent intent) {
        SmsMessage[] messages = Telephony.Sms.Intents.getMessagesFromIntent(intent);
        if (messages == null || messages.length < 1) {
            this.loge("Failed to parse SMS pdu");
            return null;
        }
        for (SmsMessage smsMessage : messages) {
            try {
                smsMessage.getDisplayMessageBody();
            }
            catch (NullPointerException e) {
                this.loge("NPE inside SmsMessage");
                return null;
            }
        }
        ContentValues values = InboundSmsHandler.parseSmsMessage(messages);
        long identity = Binder.clearCallingIdentity();
        try {
            Uri uri = this.mContext.getContentResolver().insert(Telephony.Sms.Inbox.CONTENT_URI, values);
            return uri;
        }
        catch (Exception exception) {
            this.loge("Failed to persist inbox message", exception);
        }
        finally {
            Binder.restoreCallingIdentity(identity);
        }
        return null;
    }

    private static final ContentValues $$robo$$com_android_internal_telephony_InboundSmsHandler$parseSmsMessage(SmsMessage[] msgs) {
        SmsMessage sms = msgs[0];
        ContentValues values = new ContentValues();
        values.put("address", sms.getDisplayOriginatingAddress());
        values.put("body", InboundSmsHandler.buildMessageBodyFromPdus(msgs));
        values.put("date_sent", sms.getTimestampMillis());
        values.put("date", (long)InvokeDynamicSupport.bootstrapIntrinsic("currentTimeMillis", "java.lang.System"));
        values.put("protocol", sms.getProtocolIdentifier());
        values.put("seen", 0);
        values.put("read", 0);
        String subject = sms.getPseudoSubject();
        if (!TextUtils.isEmpty(subject)) {
            values.put("subject", subject);
        }
        values.put("reply_path_present", sms.isReplyPathPresent() ? 1 : 0);
        values.put("service_center", sms.getServiceCenterAddress());
        return values;
    }

    private static final String $$robo$$com_android_internal_telephony_InboundSmsHandler$buildMessageBodyFromPdus(SmsMessage[] msgs) {
        if (msgs.length == 1) {
            return InboundSmsHandler.replaceFormFeeds(msgs[0].getDisplayMessageBody());
        }
        StringBuilder body = new StringBuilder();
        for (SmsMessage msg : msgs) {
            body.append(msg.getDisplayMessageBody());
        }
        return InboundSmsHandler.replaceFormFeeds(body.toString());
    }

    private static final String $$robo$$com_android_internal_telephony_InboundSmsHandler$replaceFormFeeds(String s) {
        return s == null ? "" : s.replace('\f', '\n');
    }

    static void __staticInitializer__() {
        PDU_PROJECTION = new String[]{"pdu"};
        PDU_SEQUENCE_PORT_PROJECTION = new String[]{"pdu", "sequence", "destination_port"};
        sRawUri = Uri.withAppendedPath(Telephony.Sms.CONTENT_URI, "raw");
    }

    private void __constructor__(String string2, Context context, SmsStorageMonitor smsStorageMonitor, PhoneBase phoneBase, CellBroadcastHandler cellBroadcastHandler) {
        this.$$robo$$com_android_internal_telephony_InboundSmsHandler$__constructor__(string2, context, smsStorageMonitor, phoneBase, cellBroadcastHandler);
    }

    protected InboundSmsHandler(String string2, Context context, SmsStorageMonitor smsStorageMonitor, PhoneBase phoneBase, CellBroadcastHandler cellBroadcastHandler) {
        super(string2);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_InboundSmsHandler$__constructor__(java.lang.String android.content.Context com.android.internal.telephony.SmsStorageMonitor com.android.internal.telephony.PhoneBase com.android.internal.telephony.CellBroadcastHandler ), 0, this, string2, context, smsStorageMonitor, phoneBase, cellBroadcastHandler);
    }

    public void dispose() {
        InvokeDynamicSupport.bootstrap("dispose", $$robo$$com_android_internal_telephony_InboundSmsHandler$dispose(), 0, this);
    }

    public void updatePhoneObject(PhoneBase phoneBase) {
        InvokeDynamicSupport.bootstrap("updatePhoneObject", $$robo$$com_android_internal_telephony_InboundSmsHandler$updatePhoneObject(com.android.internal.telephony.PhoneBase ), 0, this, phoneBase);
    }

    @Override
    protected void onQuitting() {
        InvokeDynamicSupport.bootstrap("onQuitting", $$robo$$com_android_internal_telephony_InboundSmsHandler$onQuitting(), 0, this);
    }

    public PhoneBase getPhone() {
        return InvokeDynamicSupport.bootstrap("getPhone", $$robo$$com_android_internal_telephony_InboundSmsHandler$getPhone(), 0, this);
    }

    void handleNewSms(AsyncResult asyncResult) {
        InvokeDynamicSupport.bootstrap("handleNewSms", $$robo$$com_android_internal_telephony_InboundSmsHandler$handleNewSms(android.os.AsyncResult ), 0, this, asyncResult);
    }

    void handleInjectSms(AsyncResult asyncResult) {
        InvokeDynamicSupport.bootstrap("handleInjectSms", $$robo$$com_android_internal_telephony_InboundSmsHandler$handleInjectSms(android.os.AsyncResult ), 0, this, asyncResult);
    }

    public int dispatchMessage(SmsMessageBase smsMessageBase) {
        return (int)InvokeDynamicSupport.bootstrap("dispatchMessage", $$robo$$com_android_internal_telephony_InboundSmsHandler$dispatchMessage(com.android.internal.telephony.SmsMessageBase ), 0, this, smsMessageBase);
    }

    protected void onUpdatePhoneObject(PhoneBase phoneBase) {
        InvokeDynamicSupport.bootstrap("onUpdatePhoneObject", $$robo$$com_android_internal_telephony_InboundSmsHandler$onUpdatePhoneObject(com.android.internal.telephony.PhoneBase ), 0, this, phoneBase);
    }

    void notifyAndAcknowledgeLastIncomingSms(boolean bl, int n, Message message) {
        InvokeDynamicSupport.bootstrap("notifyAndAcknowledgeLastIncomingSms", $$robo$$com_android_internal_telephony_InboundSmsHandler$notifyAndAcknowledgeLastIncomingSms(boolean int android.os.Message ), 0, this, bl, n, message);
    }

    protected int dispatchNormalMessage(SmsMessageBase smsMessageBase) {
        return (int)InvokeDynamicSupport.bootstrap("dispatchNormalMessage", $$robo$$com_android_internal_telephony_InboundSmsHandler$dispatchNormalMessage(com.android.internal.telephony.SmsMessageBase ), 0, this, smsMessageBase);
    }

    protected int addTrackerToRawTableAndSendMessage(InboundSmsTracker inboundSmsTracker) {
        return (int)InvokeDynamicSupport.bootstrap("addTrackerToRawTableAndSendMessage", $$robo$$com_android_internal_telephony_InboundSmsHandler$addTrackerToRawTableAndSendMessage(com.android.internal.telephony.InboundSmsTracker ), 0, this, inboundSmsTracker);
    }

    boolean processMessagePart(InboundSmsTracker inboundSmsTracker) {
        return (boolean)InvokeDynamicSupport.bootstrap("processMessagePart", $$robo$$com_android_internal_telephony_InboundSmsHandler$processMessagePart(com.android.internal.telephony.InboundSmsTracker ), 0, this, inboundSmsTracker);
    }

    protected void dispatchIntent(Intent intent, String string2, int n, BroadcastReceiver broadcastReceiver, UserHandle userHandle) {
        InvokeDynamicSupport.bootstrap("dispatchIntent", $$robo$$com_android_internal_telephony_InboundSmsHandler$dispatchIntent(android.content.Intent java.lang.String int android.content.BroadcastReceiver android.os.UserHandle ), 0, this, intent, string2, n, broadcastReceiver, userHandle);
    }

    void deleteFromRawTable(String string2, String[] stringArray) {
        InvokeDynamicSupport.bootstrap("deleteFromRawTable", $$robo$$com_android_internal_telephony_InboundSmsHandler$deleteFromRawTable(java.lang.String java.lang.String[] ), 0, this, string2, stringArray);
    }

    void setAndDirectIntent(Intent intent, int n) {
        InvokeDynamicSupport.bootstrap("setAndDirectIntent", $$robo$$com_android_internal_telephony_InboundSmsHandler$setAndDirectIntent(android.content.Intent int ), 0, this, intent, n);
    }

    private int addTrackerToRawTable(InboundSmsTracker inboundSmsTracker) {
        return (int)InvokeDynamicSupport.bootstrap("addTrackerToRawTable", $$robo$$com_android_internal_telephony_InboundSmsHandler$addTrackerToRawTable(com.android.internal.telephony.InboundSmsTracker ), 0, this, inboundSmsTracker);
    }

    static boolean isCurrentFormat3gpp2() {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isCurrentFormat3gpp2", $$robo$$com_android_internal_telephony_InboundSmsHandler$isCurrentFormat3gpp2(), 0);
    }

    @Override
    protected void log(String string2) {
        InvokeDynamicSupport.bootstrap("log", $$robo$$com_android_internal_telephony_InboundSmsHandler$log(java.lang.String ), 0, this, string2);
    }

    @Override
    protected void loge(String string2) {
        InvokeDynamicSupport.bootstrap("loge", $$robo$$com_android_internal_telephony_InboundSmsHandler$loge(java.lang.String ), 0, this, string2);
    }

    @Override
    protected void loge(String string2, Throwable throwable) {
        InvokeDynamicSupport.bootstrap("loge", $$robo$$com_android_internal_telephony_InboundSmsHandler$loge(java.lang.String java.lang.Throwable ), 0, this, string2, throwable);
    }

    private Uri writeInboxMessage(Intent intent) {
        return InvokeDynamicSupport.bootstrap("writeInboxMessage", $$robo$$com_android_internal_telephony_InboundSmsHandler$writeInboxMessage(android.content.Intent ), 0, this, intent);
    }

    private static ContentValues parseSmsMessage(SmsMessage[] smsMessageArray) {
        return InvokeDynamicSupport.bootstrapStatic("parseSmsMessage", $$robo$$com_android_internal_telephony_InboundSmsHandler$parseSmsMessage(android.telephony.SmsMessage[] ), 0, (SmsMessage[])smsMessageArray);
    }

    private static String buildMessageBodyFromPdus(SmsMessage[] smsMessageArray) {
        return InvokeDynamicSupport.bootstrapStatic("buildMessageBodyFromPdus", $$robo$$com_android_internal_telephony_InboundSmsHandler$buildMessageBodyFromPdus(android.telephony.SmsMessage[] ), 0, (SmsMessage[])smsMessageArray);
    }

    private static String replaceFormFeeds(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("replaceFormFeeds", $$robo$$com_android_internal_telephony_InboundSmsHandler$replaceFormFeeds(java.lang.String ), 0, (String)string2);
    }

    static {
        RobolectricInternals.classInitializing(InboundSmsHandler.class);
    }

    public /* synthetic */ InboundSmsHandler() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (InboundSmsHandler)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    private final class SmsBroadcastReceiver
    extends BroadcastReceiver
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private String mDeleteWhere;
        private String[] mDeleteWhereArgs;
        private long mBroadcastTimeNano;
        /* synthetic */ InboundSmsHandler this$0;

        private void $$robo$$com_android_internal_telephony_InboundSmsHandler_SmsBroadcastReceiver$__constructor__(InboundSmsHandler inboundSmsHandler, InboundSmsTracker tracker) {
            this.mDeleteWhere = tracker.getDeleteWhere();
            this.mDeleteWhereArgs = tracker.getDeleteWhereArgs();
            this.mBroadcastTimeNano = (long)InvokeDynamicSupport.bootstrapIntrinsic("nanoTime", "java.lang.System");
        }

        private final void $$robo$$com_android_internal_telephony_InboundSmsHandler_SmsBroadcastReceiver$onReceive(Context context, Intent intent) {
            String action = intent.getAction();
            if (action.equals("android.provider.Telephony.SMS_FILTER")) {
                int rc = this.getResultCode();
                if (rc == -1) {
                    Bundle resultExtras = this.getResultExtras(false);
                    if (resultExtras != null && resultExtras.containsKey("pdus")) {
                        intent.putExtra("pdus", (Serializable)((byte[][])resultExtras.get("pdus")));
                    }
                    if (intent.hasExtra("destport")) {
                        Uri uri;
                        int destPort = intent.getIntExtra("destport", -1);
                        intent.removeExtra("destport");
                        this.this$0.setAndDirectIntent(intent, destPort);
                        if (SmsManager.getDefault().getAutoPersisting() && (uri = this.this$0.writeInboxMessage(intent)) != null) {
                            intent.putExtra("uri", uri.toString());
                        }
                        this.this$0.dispatchIntent(intent, "android.permission.RECEIVE_SMS", 16, this, UserHandle.OWNER);
                    } else {
                        this.this$0.loge("destport doesn't exist in the extras for SMS filter action.");
                    }
                } else {
                    this.this$0.log("SMS filtered by result code " + rc);
                    this.this$0.deleteFromRawTable(this.mDeleteWhere, this.mDeleteWhereArgs);
                    this.this$0.sendMessage(3);
                }
            } else if (action.equals("android.provider.Telephony.SMS_DELIVER")) {
                intent.setAction("android.provider.Telephony.SMS_RECEIVED");
                intent.setComponent(null);
                this.this$0.dispatchIntent(intent, "android.permission.RECEIVE_SMS", 16, this, UserHandle.ALL);
            } else if (action.equals("android.provider.Telephony.WAP_PUSH_DELIVER")) {
                intent.setAction("android.provider.Telephony.WAP_PUSH_RECEIVED");
                intent.setComponent(null);
                this.this$0.dispatchIntent(intent, "android.permission.RECEIVE_SMS", 16, this, UserHandle.OWNER);
            } else {
                int rc;
                if (!("android.intent.action.DATA_SMS_RECEIVED".equals(action) || "android.provider.Telephony.SMS_RECEIVED".equals(action) || "android.intent.action.DATA_SMS_RECEIVED".equals(action) || "android.provider.Telephony.WAP_PUSH_RECEIVED".equals(action))) {
                    this.this$0.loge("unexpected BroadcastReceiver action: " + action);
                }
                if ((rc = this.getResultCode()) != -1 && rc != 1) {
                    this.this$0.loge("a broadcast receiver set the result code to " + rc + ", deleting from raw table anyway!");
                } else {
                    this.this$0.log("successful broadcast, deleting from raw table.");
                }
                this.this$0.deleteFromRawTable(this.mDeleteWhere, this.mDeleteWhereArgs);
                this.this$0.sendMessage(3);
                int durationMillis = (int)((InvokeDynamicSupport.bootstrapIntrinsic("nanoTime", "java.lang.System") - this.mBroadcastTimeNano) / 1000000L);
                if (durationMillis >= 5000) {
                    this.this$0.loge("Slow ordered broadcast completion time: " + durationMillis + " ms");
                } else {
                    this.this$0.log("ordered broadcast completed in: " + durationMillis + " ms");
                }
            }
        }

        private void __constructor__(InboundSmsHandler inboundSmsHandler, InboundSmsTracker inboundSmsTracker) {
            this.$$robo$$com_android_internal_telephony_InboundSmsHandler_SmsBroadcastReceiver$__constructor__(inboundSmsHandler, inboundSmsTracker);
        }

        SmsBroadcastReceiver(InboundSmsHandler inboundSmsHandler, InboundSmsTracker inboundSmsTracker) {
            this.this$0 = inboundSmsHandler;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_InboundSmsHandler_SmsBroadcastReceiver$__constructor__(com.android.internal.telephony.InboundSmsHandler com.android.internal.telephony.InboundSmsTracker ), 0, this, inboundSmsHandler, inboundSmsTracker);
        }

        @Override
        public void onReceive(Context context, Intent intent) {
            InvokeDynamicSupport.bootstrap("onReceive", $$robo$$com_android_internal_telephony_InboundSmsHandler_SmsBroadcastReceiver$onReceive(android.content.Context android.content.Intent ), 0, this, context, intent);
        }

        public /* synthetic */ SmsBroadcastReceiver() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SmsBroadcastReceiver)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public class WaitingState
    extends State
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        /* synthetic */ InboundSmsHandler this$0;

        private void $$robo$$com_android_internal_telephony_InboundSmsHandler_WaitingState$__constructor__(InboundSmsHandler inboundSmsHandler) {
        }

        private final boolean $$robo$$com_android_internal_telephony_InboundSmsHandler_WaitingState$processMessage(Message msg) {
            this.this$0.log("WaitingState.processMessage:" + msg.what);
            switch (msg.what) {
                case 2: {
                    this.this$0.deferMessage(msg);
                    return true;
                }
                case 3: {
                    this.this$0.sendMessage(4);
                    this.this$0.transitionTo(this.this$0.mDeliveringState);
                    return true;
                }
                case 4: {
                    return true;
                }
            }
            return false;
        }

        private void __constructor__(InboundSmsHandler inboundSmsHandler) {
            this.$$robo$$com_android_internal_telephony_InboundSmsHandler_WaitingState$__constructor__(inboundSmsHandler);
        }

        WaitingState(InboundSmsHandler inboundSmsHandler) {
            this.this$0 = inboundSmsHandler;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_InboundSmsHandler_WaitingState$__constructor__(com.android.internal.telephony.InboundSmsHandler ), 0, this, inboundSmsHandler);
        }

        @Override
        public boolean processMessage(Message message) {
            return (boolean)InvokeDynamicSupport.bootstrap("processMessage", $$robo$$com_android_internal_telephony_InboundSmsHandler_WaitingState$processMessage(android.os.Message ), 0, this, message);
        }

        public /* synthetic */ WaitingState() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (WaitingState)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public class DeliveringState
    extends State
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        /* synthetic */ InboundSmsHandler this$0;

        private void $$robo$$com_android_internal_telephony_InboundSmsHandler_DeliveringState$__constructor__(InboundSmsHandler inboundSmsHandler) {
        }

        private final void $$robo$$com_android_internal_telephony_InboundSmsHandler_DeliveringState$enter() {
            this.this$0.log("entering Delivering state");
        }

        private final void $$robo$$com_android_internal_telephony_InboundSmsHandler_DeliveringState$exit() {
            this.this$0.log("leaving Delivering state");
        }

        private final boolean $$robo$$com_android_internal_telephony_InboundSmsHandler_DeliveringState$processMessage(Message msg) {
            this.this$0.log("DeliveringState.processMessage:" + msg.what);
            switch (msg.what) {
                case 1: {
                    this.this$0.handleNewSms((AsyncResult)msg.obj);
                    this.this$0.sendMessage(4);
                    return true;
                }
                case 8: {
                    this.this$0.handleInjectSms((AsyncResult)msg.obj);
                    this.this$0.sendMessage(4);
                    return true;
                }
                case 2: {
                    if (this.this$0.processMessagePart((InboundSmsTracker)msg.obj)) {
                        this.this$0.transitionTo(this.this$0.mWaitingState);
                    }
                    return true;
                }
                case 4: {
                    this.this$0.transitionTo(this.this$0.mIdleState);
                    return true;
                }
                case 5: {
                    this.this$0.mWakeLock.release();
                    if (!this.this$0.mWakeLock.isHeld()) {
                        this.this$0.loge("mWakeLock released while delivering/broadcasting!");
                    }
                    return true;
                }
            }
            return false;
        }

        private void __constructor__(InboundSmsHandler inboundSmsHandler) {
            this.$$robo$$com_android_internal_telephony_InboundSmsHandler_DeliveringState$__constructor__(inboundSmsHandler);
        }

        DeliveringState(InboundSmsHandler inboundSmsHandler) {
            this.this$0 = inboundSmsHandler;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_InboundSmsHandler_DeliveringState$__constructor__(com.android.internal.telephony.InboundSmsHandler ), 0, this, inboundSmsHandler);
        }

        @Override
        public void enter() {
            InvokeDynamicSupport.bootstrap("enter", $$robo$$com_android_internal_telephony_InboundSmsHandler_DeliveringState$enter(), 0, this);
        }

        @Override
        public void exit() {
            InvokeDynamicSupport.bootstrap("exit", $$robo$$com_android_internal_telephony_InboundSmsHandler_DeliveringState$exit(), 0, this);
        }

        @Override
        public boolean processMessage(Message message) {
            return (boolean)InvokeDynamicSupport.bootstrap("processMessage", $$robo$$com_android_internal_telephony_InboundSmsHandler_DeliveringState$processMessage(android.os.Message ), 0, this, message);
        }

        public /* synthetic */ DeliveringState() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (DeliveringState)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public class IdleState
    extends State
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        /* synthetic */ InboundSmsHandler this$0;

        private void $$robo$$com_android_internal_telephony_InboundSmsHandler_IdleState$__constructor__(InboundSmsHandler inboundSmsHandler) {
        }

        private final void $$robo$$com_android_internal_telephony_InboundSmsHandler_IdleState$enter() {
            this.this$0.log("entering Idle state");
            this.this$0.sendMessageDelayed(5, 3000L);
        }

        private final void $$robo$$com_android_internal_telephony_InboundSmsHandler_IdleState$exit() {
            this.this$0.mWakeLock.acquire();
            this.this$0.log("acquired wakelock, leaving Idle state");
        }

        private final boolean $$robo$$com_android_internal_telephony_InboundSmsHandler_IdleState$processMessage(Message msg) {
            this.this$0.log("IdleState.processMessage:" + msg.what);
            this.this$0.log("Idle state processing message type " + msg.what);
            switch (msg.what) {
                case 1: 
                case 2: 
                case 8: {
                    this.this$0.deferMessage(msg);
                    this.this$0.transitionTo(this.this$0.mDeliveringState);
                    return true;
                }
                case 5: {
                    this.this$0.mWakeLock.release();
                    if (this.this$0.mWakeLock.isHeld()) {
                        this.this$0.log("mWakeLock is still held after release");
                    } else {
                        this.this$0.log("mWakeLock released");
                    }
                    return true;
                }
                case 4: {
                    return true;
                }
            }
            return false;
        }

        private void __constructor__(InboundSmsHandler inboundSmsHandler) {
            this.$$robo$$com_android_internal_telephony_InboundSmsHandler_IdleState$__constructor__(inboundSmsHandler);
        }

        IdleState(InboundSmsHandler inboundSmsHandler) {
            this.this$0 = inboundSmsHandler;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_InboundSmsHandler_IdleState$__constructor__(com.android.internal.telephony.InboundSmsHandler ), 0, this, inboundSmsHandler);
        }

        @Override
        public void enter() {
            InvokeDynamicSupport.bootstrap("enter", $$robo$$com_android_internal_telephony_InboundSmsHandler_IdleState$enter(), 0, this);
        }

        @Override
        public void exit() {
            InvokeDynamicSupport.bootstrap("exit", $$robo$$com_android_internal_telephony_InboundSmsHandler_IdleState$exit(), 0, this);
        }

        @Override
        public boolean processMessage(Message message) {
            return (boolean)InvokeDynamicSupport.bootstrap("processMessage", $$robo$$com_android_internal_telephony_InboundSmsHandler_IdleState$processMessage(android.os.Message ), 0, this, message);
        }

        public /* synthetic */ IdleState() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (IdleState)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public class StartupState
    extends State
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        /* synthetic */ InboundSmsHandler this$0;

        private void $$robo$$com_android_internal_telephony_InboundSmsHandler_StartupState$__constructor__(InboundSmsHandler inboundSmsHandler) {
        }

        private final boolean $$robo$$com_android_internal_telephony_InboundSmsHandler_StartupState$processMessage(Message msg) {
            this.this$0.log("StartupState.processMessage:" + msg.what);
            switch (msg.what) {
                case 1: 
                case 2: 
                case 8: {
                    this.this$0.deferMessage(msg);
                    return true;
                }
                case 6: {
                    this.this$0.transitionTo(this.this$0.mIdleState);
                    return true;
                }
            }
            return false;
        }

        private void __constructor__(InboundSmsHandler inboundSmsHandler) {
            this.$$robo$$com_android_internal_telephony_InboundSmsHandler_StartupState$__constructor__(inboundSmsHandler);
        }

        StartupState(InboundSmsHandler inboundSmsHandler) {
            this.this$0 = inboundSmsHandler;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_InboundSmsHandler_StartupState$__constructor__(com.android.internal.telephony.InboundSmsHandler ), 0, this, inboundSmsHandler);
        }

        @Override
        public boolean processMessage(Message message) {
            return (boolean)InvokeDynamicSupport.bootstrap("processMessage", $$robo$$com_android_internal_telephony_InboundSmsHandler_StartupState$processMessage(android.os.Message ), 0, this, message);
        }

        public /* synthetic */ StartupState() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (StartupState)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public class DefaultState
    extends State
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        /* synthetic */ InboundSmsHandler this$0;

        private void $$robo$$com_android_internal_telephony_InboundSmsHandler_DefaultState$__constructor__(InboundSmsHandler inboundSmsHandler) {
        }

        private final boolean $$robo$$com_android_internal_telephony_InboundSmsHandler_DefaultState$processMessage(Message msg) {
            switch (msg.what) {
                case 7: {
                    this.this$0.onUpdatePhoneObject((PhoneBase)msg.obj);
                    break;
                }
                default: {
                    String errorText = "processMessage: unhandled message type " + msg.what + " currState=" + this.this$0.getCurrentState().getName();
                    if (Build.IS_DEBUGGABLE) {
                        this.this$0.loge("---- Dumping InboundSmsHandler ----");
                        this.this$0.loge("Total records=" + this.this$0.getLogRecCount());
                        for (int i = Math.max(this.this$0.getLogRecSize() - 20, 0); i < this.this$0.getLogRecSize(); ++i) {
                            this.this$0.loge("Rec[%d]: %s\n" + i + this.this$0.getLogRec(i).toString());
                        }
                        this.this$0.loge("---- Dumped InboundSmsHandler ----");
                        throw new RuntimeException(errorText);
                    }
                    this.this$0.loge(errorText);
                    break;
                }
            }
            return true;
        }

        private void __constructor__(InboundSmsHandler inboundSmsHandler) {
            this.$$robo$$com_android_internal_telephony_InboundSmsHandler_DefaultState$__constructor__(inboundSmsHandler);
        }

        DefaultState(InboundSmsHandler inboundSmsHandler) {
            this.this$0 = inboundSmsHandler;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_InboundSmsHandler_DefaultState$__constructor__(com.android.internal.telephony.InboundSmsHandler ), 0, this, inboundSmsHandler);
        }

        @Override
        public boolean processMessage(Message message) {
            return (boolean)InvokeDynamicSupport.bootstrap("processMessage", $$robo$$com_android_internal_telephony_InboundSmsHandler_DefaultState$processMessage(android.os.Message ), 0, this, message);
        }

        public /* synthetic */ DefaultState() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (DefaultState)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

